/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

#ifndef __GPA_OPTION_MENU__H__
#define __GPA_OPTION_MENU_H__

/*
 * gpa-option-menu.h:
 *
 * Libgnomeprint is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * Libgnomeprint is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the libgnomeprint; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors :
 *   Chema Celorio <chema@ximian.com>
 *
 * Copyright (C) 2002 Ximian, Inc. 
 *
 */

#include <glib.h>

G_BEGIN_DECLS

#define GPA_TYPE_OPTION_MENU         (gpa_option_menu_get_type ())
#define GPA_OPTION_MENU(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GPA_TYPE_OPTION_MENU, GPAOptionMenu))
#define GPA_OPTION_MENU_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST    ((k), GPA_TYPE_OPTION_MENU, GPAOptionMenuClass))
#define GPA_IS_OPTION_MENU(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GPA_TYPE_OPTION_MENU))
#define GPA_IS_OPTION_MENU_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE    ((k), GPA_TYPE_OPTION_MENU))
#define GPA_OPTION_MENU_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS  ((o), GPA_TYPE_OPTION_MENU, GPAOptionMenuClass))

#include "gpa-widget.h"
#include <libgnomeprint/private/gpa-node.h>

typedef struct _GPAOptionMenu      GPAOptionMenu;
typedef struct _GPAOptionMenuClass GPAOptionMenuClass;

struct _GPAOptionMenu {
	GPAWidget widget;

	guchar *key;      /* This is the key we are monitoring */
	GtkWidget *shell;
	GtkWidget *menu; /* GtkOptionMenu */

	gboolean updating;

	GPANode *node; /* The node we are listening to */
	guint handler; /* The signal handler */

	GPANode *parent; /* The node we are listening to */
	guint parent_handler; /* The signal handler */
};

struct _GPAOptionMenuClass {
	GPAWidgetClass widget_class;
};

GtkType     gpa_option_menu_get_type (void);

GtkWidget * gpa_option_menu_new       (GnomePrintConfig *config, const guchar *key, GPANode *parent);

G_END_DECLS

#endif /* __GPA_OPTION_MENU_H__ */
