/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libgnome/gnome-i18n.h>
#include "gul-gobject-misc.h"
#include "galeon-marshal.h"
#include "gul-bonobo-extensions.h"
#include <gtk/gtkspinbutton.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkstock.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkvbox.h>
#include "gul-tbi-zoom.h"
#include "prefs-strings.h"
#include "eel-gconf-extensions.h"
#include <string.h>

#define NOT_IMPLEMENTED g_warning ("not implemented: " G_STRLOC);
//#define DEBUG_MSG(x) g_print x
#define DEBUG_MSG(x)

/**
 * Private data
 */
struct _GulTbiZoomPrivate 
{
	GtkWidget *widget;
	GtkWidget *label;
	GtkWidget *hbox;
	GtkWidget *vbox;
	guint notification;
};

enum 
{
        TOOLBAR_ITEM_STYLE_PROP,
        TOOLBAR_ITEM_ORIENTATION_PROP,
	TOOLBAR_ITEM_WANT_LABEL_PROP
};

/**
 * Private functions, only availble from this file
 */
static void		gul_tbi_zoom_class_init			(GulTbiZoomClass *klass);
static void		gul_tbi_zoom_init			(GulTbiZoom *tb);
static void		gul_tbi_zoom_finalize_impl		(GObject *o);
static GtkWidget *	gul_tbi_zoom_get_widget_impl		(GulTbItem *i);
static GdkPixbuf *	gul_tbi_zoom_get_icon_impl		(GulTbItem *i);
static gchar *		gul_tbi_zoom_get_name_human_impl	(GulTbItem *i);
static gchar *		gul_tbi_zoom_to_string_impl		(GulTbItem *i);
static gboolean		gul_tbi_zoom_is_unique_impl		(GulTbItem *i);
static GulTbItem *	gul_tbi_zoom_clone_impl			(GulTbItem *i);
static void		gul_tbi_zoom_parse_properties_impl	(GulTbItem *i, const gchar *props);
static void		gul_tbi_zoom_add_to_bonobo_tb_impl	(GulTbItem *i, 
								 BonoboUIComponent *ui, 
								 const char *container_path,
								 guint index);
static void		gul_tbi_zoom_setup_label		(GulTbiZoom *it);
static void		gul_tbi_zoom_notification_cb		(GConfClient* client,
								 guint cnxn_id,
								 GConfEntry *entry,
								 gpointer user_data);


static gpointer gul_tb_item_class;

/**
 * TbiZoom object
 */

MAKE_GET_TYPE (gul_tbi_zoom, "GulTbiZoom", GulTbiZoom, gul_tbi_zoom_class_init, 
	       gul_tbi_zoom_init, GUL_TYPE_TB_ITEM);

static void
gul_tbi_zoom_class_init (GulTbiZoomClass *klass)
{
	G_OBJECT_CLASS (klass)->finalize = gul_tbi_zoom_finalize_impl;
	
	GUL_TB_ITEM_CLASS (klass)->get_widget = gul_tbi_zoom_get_widget_impl;
	GUL_TB_ITEM_CLASS (klass)->get_icon = gul_tbi_zoom_get_icon_impl;
	GUL_TB_ITEM_CLASS (klass)->get_name_human = gul_tbi_zoom_get_name_human_impl;
	GUL_TB_ITEM_CLASS (klass)->to_string = gul_tbi_zoom_to_string_impl;
	GUL_TB_ITEM_CLASS (klass)->is_unique = gul_tbi_zoom_is_unique_impl;
	GUL_TB_ITEM_CLASS (klass)->clone = gul_tbi_zoom_clone_impl;
	GUL_TB_ITEM_CLASS (klass)->parse_properties = gul_tbi_zoom_parse_properties_impl;
	GUL_TB_ITEM_CLASS (klass)->add_to_bonobo_tb = gul_tbi_zoom_add_to_bonobo_tb_impl;
	
	gul_tb_item_class = g_type_class_peek_parent (klass);
}

static void 
gul_tbi_zoom_init (GulTbiZoom *tbi)
{
	GulTbiZoomPrivate *p = g_new0 (GulTbiZoomPrivate, 1);
	tbi->priv = p;
	
	p->notification = eel_gconf_notification_add (CONF_DESKTOP_TOOLBAR_STYLE, 
						      gul_tbi_zoom_notification_cb,
						      tbi);
}

GulTbiZoom *
gul_tbi_zoom_new (void)
{
	GulTbiZoom *ret = g_object_new (GUL_TYPE_TBI_ZOOM, NULL);
	return ret;
}

static void
gul_tbi_zoom_finalize_impl (GObject *o)
{
	GulTbiZoom *it = GUL_TBI_ZOOM (o);
	GulTbiZoomPrivate *p = it->priv;

	if (p->widget)
	{
		g_object_unref (p->widget);
	}

	if (p->label)
	{
		g_object_unref (p->label);
	}

	if (p->vbox)
	{
		g_object_unref (p->vbox);
	}

	if (p->hbox)
	{
		g_object_unref (p->hbox);
	}

	if (p->notification)
	{
		eel_gconf_notification_remove (p->notification);
	}

	g_free (p);
	
	DEBUG_MSG (("GulTbiZoom finalized\n"));
	
	G_OBJECT_CLASS (gul_tb_item_class)->finalize (o);
}

static GtkWidget *
gul_tbi_zoom_get_widget_impl (GulTbItem *i)
{
	GulTbiZoom *iz = GUL_TBI_ZOOM (i);
	GulTbiZoomPrivate *p = iz->priv;

	if (!p->widget)
	{
		p->widget = gtk_spin_button_new_with_range (1, 999, 10);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (p->widget), 100);
		g_object_ref (p->widget);
		gtk_object_sink (GTK_OBJECT (p->widget));
		p->label = gtk_label_new (_("Zoom"));
		g_object_ref (p->label);
		gtk_object_sink (GTK_OBJECT (p->label));
		p->vbox = gtk_vbox_new (FALSE, 0);
		g_object_ref (p->vbox);
		gtk_object_sink (GTK_OBJECT (p->vbox));
		p->hbox = gtk_hbox_new (FALSE, 0);
		g_object_ref (p->hbox);
		gtk_object_sink (GTK_OBJECT (p->hbox));

		gtk_box_pack_start_defaults (GTK_BOX (p->hbox), p->vbox);
		gtk_box_pack_start_defaults (GTK_BOX (p->vbox), p->widget);
		gtk_widget_show (p->vbox);
		gtk_widget_show (p->hbox);
		
	}

	return p->widget;
}

static GdkPixbuf *
gul_tbi_zoom_get_icon_impl (GulTbItem *i)
{
	static GdkPixbuf *pb = NULL;
	if (!pb)
	{
		/* what's the easier way? */
		GtkWidget *b = gtk_spin_button_new_with_range (0, 1, 0.5);
		pb = gtk_widget_render_icon (b,
					     GTK_STOCK_ZOOM_IN,
					     GTK_ICON_SIZE_SMALL_TOOLBAR,
					     NULL);
		gtk_widget_destroy (b);
	}
	return g_object_ref (pb);
}

static gchar *
gul_tbi_zoom_get_name_human_impl (GulTbItem *i)
{
	return g_strdup (_("Zoom"));
}

static gchar *
gul_tbi_zoom_to_string_impl (GulTbItem *i)
{
	/* if it had any properties, the string should include them */
	return g_strdup_printf ("%s=zoom", i->id);
}

static gboolean
gul_tbi_zoom_is_unique_impl (GulTbItem *i)
{
	return TRUE;
}

static GulTbItem *
gul_tbi_zoom_clone_impl (GulTbItem *i)
{
	GulTbItem *ret = GUL_TB_ITEM (gul_tbi_zoom_new ());
	
	gul_tb_item_set_id (ret, i->id);

	/* should copy properties too, if any */
	/* the zoom value is not copied, not sure if it should... */

	return ret;
}

static void
gul_tbi_zoom_add_to_bonobo_tb_impl (GulTbItem *i, BonoboUIComponent *ui, 
				    const char *container_path, guint index)
{
	GtkWidget *w = gul_tb_item_get_widget (i);
	GulTbiZoomPrivate *p = GUL_TBI_ZOOM (i)->priv;
	gtk_widget_show (w);
	gul_bonobo_add_numbered_control (ui, p->hbox, index, container_path);
	gul_tbi_zoom_setup_label (GUL_TBI_ZOOM (i));
}

static void
gul_tbi_zoom_parse_properties_impl (GulTbItem *it, const gchar *props)
{
	/* we have no properties */
}

static void
gul_tbi_zoom_setup_label (GulTbiZoom *it)
{
	GulTbiZoomPrivate *p = it->priv;
	gchar *style = eel_gconf_get_string (CONF_DESKTOP_TOOLBAR_STYLE);
	gul_tb_item_get_widget (GUL_TB_ITEM (it));

	g_object_ref (p->label);
	if (p->label->parent)
	{
		gtk_container_remove (GTK_CONTAINER (p->label->parent), p->label);
	}

	if (!strcmp (style, "both_horiz") || !strcmp (style, "text"))
	{
		gtk_widget_show (p->label);
		gtk_box_pack_start_defaults (GTK_BOX (p->hbox), p->label);
	} 
	else if (!strcmp (style, "both"))
	{
		gtk_widget_show (p->label);
		gtk_box_pack_start_defaults (GTK_BOX (p->vbox), p->label);
	} 
	else
	{
		gtk_widget_hide (p->label);
	}

	g_free (style);
	g_object_unref (p->label);
}

static void
gul_tbi_zoom_notification_cb (GConfClient* client,
			      guint cnxn_id,
			      GConfEntry *entry,
			      gpointer user_data)
{
	gul_tbi_zoom_setup_label (user_data);
}

