/*
 *
 * mtm-stateful.c :
 *
 * Copyright (C) 2000-2001 Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Richard Hestilow <hestgray@ionet.net>
 *
 */

#include <mtm/mtm-stateful.h>

static GtkObjectClass *mtm_stateful_parent_class;

struct _MtmStatefulPrivate
{
};

enum
{
	ARG_0,
	ARG_ENV
};

static void mtm_stateful_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void mtm_stateful_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

static void
mtm_stateful_destroy (GtkObject *object)
{
	if (mtm_stateful_parent_class->destroy)
		(*mtm_stateful_parent_class->destroy)(object);
}

static void
mtm_stateful_class_init (GtkObjectClass *object_class)
{
	mtm_stateful_parent_class = gtk_type_class (gtk_object_get_type ());

	object_class->set_arg = mtm_stateful_set_arg;
	object_class->get_arg = mtm_stateful_get_arg;

	gtk_object_add_arg_type ("MtmStateful::env", MTM_ENV_TYPE,
		GTK_ARG_READWRITE, ARG_ENV);

	object_class->destroy = mtm_stateful_destroy;
}

static void
mtm_stateful_init (GtkObject *object)
{
};

/**
 * mtm_stateful_get_type:
 * @void:
 *
 * Registers the #MtmStateful class if necessary, and returns the type ID
 * associated to it.
 * 
 * Return value: The type ID of the #MtmStateful class.
 **/
GtkType
mtm_stateful_get_type (void)
{
	static GtkType type = 0;

	if (!type)
	{
		GtkTypeInfo info =
		{
			"MtmStateful",
			sizeof (MtmStateful),
			sizeof (MtmStatefulClass),
			(GtkClassInitFunc) mtm_stateful_class_init,
			(GtkObjectInitFunc) mtm_stateful_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (gtk_object_get_type (), &info);
	}

	return type;
}

static void
mtm_stateful_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
	MtmStateful *stateful = MTM_STATEFUL (object);

	switch (arg_id)
	{
		case ARG_ENV:
			mtm_stateful_set_env (stateful, MTM_ENV (GTK_VALUE_OBJECT (*arg)));
			break;
	}
}

static void
mtm_stateful_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
	MtmStateful *stateful = MTM_STATEFUL (object);

	switch (arg_id)
	{
		case ARG_ENV:
			GTK_VALUE_OBJECT (*arg) = GTK_OBJECT (mtm_stateful_get_env (stateful));
			break;
	}
}

/**
 * mtm_stateful_get_env:
 * @stateful: The stateful object.
 *
 * Queries the stateful object for the current environment object.
 *
 * Return value: The current environment object.
 */
MtmEnv *mtm_stateful_get_env (MtmStateful *stateful)
{
	g_return_val_if_fail (stateful != NULL, NULL);
	return stateful->env;
}

/**
 * mtm_stateful_set_env:
 * @stateful: The stateful object.
 * @env: An environment object.
 *
 * Sets the current environment object to the one provided.
 */
void mtm_stateful_set_env (MtmStateful *stateful, MtmEnv *env)
{
	g_return_if_fail (stateful != NULL);
	g_return_if_fail (env != NULL);
	
	stateful->env = env;
}

