/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* 
 * Copyright (C) 2000 Eazel, Inc
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Andy Hertzfeld
 */

/* main.c - main function and object activation function for the throbber component. */

#include <config.h>
#include <string.h>
#include "nautilus-throbber.h"

#include <eel/eel-debug.h>
#include <libgnomevfs/gnome-vfs-init.h>
#include <libnautilus-private/nautilus-global-preferences.h>

static int object_count = 0;

static void
throbber_object_destroyed (GtkObject *obj)
{
	object_count--;
	if (object_count <= 0) {
		gtk_main_quit ();
	}
}

static BonoboObject *
throbber_make_object (BonoboGenericFactory *factory, 
		      const char *iid, 
		      void *closure)
{
	NautilusThrobber *throbber;
	BonoboObject *bonobo_control;

	if (strcmp (iid, "OAFIID:nautilus_throbber")) {
		return NULL;
	}
	
	throbber = NAUTILUS_THROBBER (g_object_new (NAUTILUS_TYPE_THROBBER, NULL));
	
	object_count++;
	
	bonobo_control = nautilus_throbber_get_control (throbber);
	
	g_signal_connect (bonobo_control, "destroy", G_CALLBACK (throbber_object_destroyed), NULL);

	return bonobo_control;
}

int
main (int argc, char *argv[])
{
	BonoboGenericFactory *factory;
#ifdef GNOME2_CONVERSION_COMPLETE
	char *registration_id;
#endif

	if (g_getenv ("NAUTILUS_DEBUG") != NULL) {
		eel_make_warnings_and_criticals_stop_in_debugger ();
	}

	/* Disable session manager connection */
#ifdef GNOME2_CONVERSION_COMPLETE
	gnome_client_disable_master_connection ();

	gnomelib_register_popt_table (bonobo_activation_popt_options, bonobo_activation_get_popt_table_name ());
	orb = bonobo_activation_init (argc, argv);

	gnome_init ("nautilus-throbber", VERSION, argc, argv); 
	g_thread_init (NULL);
	gdk_rgb_init ();
	gnome_vfs_init ();
	bonobo_init (orb, CORBA_OBJECT_NIL, CORBA_OBJECT_NIL);
#endif
	bonobo_ui_init ("nautilus-throbber", VERSION, &argc, argv);

	nautilus_global_preferences_init ();   

#ifdef GNOME2_CONVERSION_COMPLETE
	registration_id = bonobo_activation_make_registration_id ("OAFIID:nautilus_throbber_factory", g_getenv ("DISPLAY"));
#endif
	factory = bonobo_generic_factory_new ("OAFIID:nautilus_throbber_factory", 
					      throbber_make_object,
					      NULL);

#ifdef GNOME2_CONVERSION_COMPLETE
	g_free (registration_id);
#endif

	if (factory != NULL) {
		bonobo_activate ();
		do {
			gtk_main ();
		} while (object_count > 0);
		
		bonobo_object_unref (BONOBO_OBJECT (factory));
	}

	gnome_vfs_shutdown ();

	return EXIT_SUCCESS;
}
