/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* test-monitor.c - Test program for file monitoringu in the GNOME Virtual
   File System.

   Copyright (C) 2001 Ian McKellar

   The Gnome Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Gnome Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Authors: 
	Ian McKellar <yakk@yakk.net>
 */

#include <libgnomevfs/gnome-vfs.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <glib.h>

static GMainLoop *main_loop;

static void
show_result (GnomeVFSResult result, const gchar *what, const gchar *text_uri)
{
	fprintf (stderr, "%s `%s': %s\n",
		 what, text_uri, gnome_vfs_result_to_string (result));
	if (result != GNOME_VFS_OK)
		exit (1);
}

static void
callback (GnomeVFSMonitorHandle *handle,
          const gchar *monitor_uri,
	  const gchar *info_uri,
	  GnomeVFSMonitorEventType event_type,
	  gpointer user_data) {
	g_print ("Got a callback: ");
	switch (event_type) {
		case GNOME_VFS_MONITOR_EVENT_CHANGED:
			g_print ("GNOME_VFS_MONITOR_EVENT_CHANGED");
			break;
		case GNOME_VFS_MONITOR_EVENT_DELETED:
			g_print ("GNOME_VFS_MONITOR_EVENT_DELETED");
			break;
		case GNOME_VFS_MONITOR_EVENT_STARTEXECUTING:
			g_print ("GNOME_VFS_MONITOR_EVENT_STARTEXECUTING");
			break;
		case GNOME_VFS_MONITOR_EVENT_STOPEXECUTING:
			g_print ("GNOME_VFS_MONITOR_EVENT_STOPEXECUTING");
			break;
		case GNOME_VFS_MONITOR_EVENT_CREATED:
			g_print ("GNOME_VFS_MONITOR_EVENT_CREATED");
			break;
		case GNOME_VFS_MONITOR_EVENT_METADATA_CHANGED:
			g_print ("GNOME_VFS_MONITOR_EVENT_METADATA_CHANGED");
			break;
	}

	g_print (" (%s)", info_uri);
	g_print ("\n");
}

int
main (int argc, char **argv)
{
	GnomeVFSResult    result;
	gchar            *text_uri = "/tmp/";
	GnomeVFSMonitorHandle *handle;

	if (! gnome_vfs_init ()) {
		fprintf (stderr, "Cannot initialize gnome-vfs.\n");
		return 1;
	}

	if (argc == 2) {
		text_uri = argv[1];
	}

	result = gnome_vfs_monitor_add (&handle, text_uri,
			GNOME_VFS_MONITOR_DIRECTORY, callback, "user data");
	show_result (result, "monitor_add", text_uri);

	if (result == GNOME_VFS_OK) {
		main_loop = g_main_loop_new (NULL, TRUE);
		g_main_loop_run (main_loop);
		g_main_loop_unref (main_loop);
	}

	g_free (text_uri);

	return 0;
}
