#include <stdio.h>
#include <stdarg.h>
#include <gtk/gtk.h>
#include <libintl.h>

#include "gnome.h"
#include "gnome-desktop.h"
#include "gdkx.h"

#define _(String) gettext(String)

static GtkWidget *screen;
static GtkWidget *preview;

static GtkWidget *frame;
static GtkWidget *monitor;
static GtkWidget *vbox;

/* If true, the display is a gradient from color1..color2 */
static gint grad;

/* Direction of the gradient */
static gint vertical;

static gint bgType;
static gint wpType;

static gchar *wpFileName;

enum {
	WALLPAPER_TILED,
	WALLPAPER_CENTERED,
};

enum {
	BACKGROUND_SIMPLE,
	BACKGROUND_WALLPAPER,
};


static GdkColor  bgColor1, bgColor2;

/* The pointers to the color selectors */
static GnomeColorSelector *cs1, *cs2;

void
gtk_widget_show_multi (GtkWidget *first,...)
{
	va_list ap;
	GtkWidget *next;
	
	if (!first)
		return;

	gtk_widget_show (first);
	va_start (ap, first);
	while ((next = va_arg (ap, GtkWidget *)) != 0)
		gtk_widget_show (next);
	va_end (ap);
}

static void
color_changed (gpointer data)
{
}

static void
radio_toggle_widget_active(GtkWidget *widget, gpointer data)
{
	GtkWidget *dest;

	dest = GTK_WIDGET(data);

	gtk_widget_set_sensitive(dest, GTK_TOGGLE_BUTTON(widget)->active);
} /* radio_toggle_widget_active */

static void
gnome_preview_fill_gradient (GtkPreview *pr,
		 GdkColor *c1, GdkColor *c2,
		 int vertical)
{
	guchar    *gbuf, *buf;
	guchar    *s, *p;
	int        i, j;
	int        gsize;
	gint width = GTK_WIDGET (pr)->requisition.width;
	gint height = GTK_WIDGET (pr)->requisition.height;

	
	if (vertical) {
		gbuf = g_malloc(height * 3 * sizeof(guchar));
		buf  = g_malloc(width * 3 * sizeof(guchar));

		gsize = height;
	} else {
		gbuf = g_malloc(width * 3 * sizeof(guchar));
		buf  = NULL;

		gsize = width;
	}

	/* Fill gradient stripe */

	p = gbuf;

	for (i = 0; i < gsize; i++) {
		*p++ = (c1->red + i * (c2->red - c1->red) / (gsize - 1)) >> 8;
		*p++ = (c1->green + i * (c2->green - c1->green) / (gsize - 1)) >> 8;
		*p++ = (c1->blue + i * (c2->blue - c1->blue) / (gsize - 1)) >> 8;
	}

	/* Fill preview */

	if (vertical) 
		for (i = 0; i < height; i++) {
			s = gbuf + 3 * i;
			p = buf;

			for (j = 0; j < width; j++) {
				*p++ = s[0];
				*p++ = s[1];
				*p++ = s[2];
			}

			gtk_preview_draw_row(GTK_PREVIEW(pr), buf, 0, i, width);
		}
	else
		for (i = 0; i < height; i++)
			gtk_preview_draw_row(GTK_PREVIEW(pr), gbuf, 0, i, width);

	g_free(gbuf);
	g_free(buf);
}

static void
set_gradient (void)
{
	gnome_preview_fill_gradient (GTK_PREVIEW (preview),
				     &bgColor1, &bgColor2, vertical);
}

static void
set_solid (void)
{
	gnome_preview_fill_gradient (GTK_PREVIEW (preview),
				     &bgColor1, &bgColor1, vertical);
}

static void
fill_monitor (void)
{
	gint r, g, b;

	gnome_color_selector_get_color_int(cs1, &r, &g, &b, 65535);
	bgColor1.red = r;
	bgColor1.green = g;
	bgColor1.blue = b;
	gnome_color_selector_get_color_int(cs2, &r, &g, &b, 65535);
	bgColor2.red = r;
	bgColor2.green = g;
	bgColor2.blue = b;
	
	if (grad)
		set_gradient();
	else
		set_solid ();

	if (GTK_WIDGET_DRAWABLE (preview))
		gtk_widget_draw (preview, NULL);
}

static void
set_background_mode (GtkWidget *widget, gpointer data)
{
	grad = (int) ((long) data);

	fill_monitor();
}

static void
set_orientation (GtkWidget *widget, gpointer data)
{
	vertical = (int) ((long) data);

	fill_monitor();
}

GtkWidget *
color_setup ()
{
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *button1;
	GtkWidget *button2;
	GtkWidget *radio1;
	GtkWidget *radio2;
	GtkWidget *vb1, *vb2;
	
	frame = gtk_frame_new (_("Color"));
	gtk_widget_show (frame);

	vb1= gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vb1);
	vb2= gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vb2);

	table = gtk_table_new (2, 2, FALSE);
	gtk_container_border_width (GTK_CONTAINER(table), GNOME_PAD);
	gtk_table_set_col_spacings (GTK_TABLE(table), GNOME_PAD);
	gtk_container_add (GTK_CONTAINER(frame), table);
	gtk_widget_show (table);

	cs1 = gnome_color_selector_new ((SetColorFunc) fill_monitor, NULL);
	gnome_color_selector_set_color_int (cs1,
					    bgColor1.red,
					    bgColor1.green,
					    bgColor1.blue, 65535);
	
	button1 = gnome_color_selector_get_button (cs1);
	gtk_table_attach (GTK_TABLE(table), button1, 0, 1, 0, 1, 0, 0, 0, 0);
	gtk_widget_show (button1);

	radio1 = gtk_radio_button_new_with_label (NULL, _("Flat"));
	gtk_signal_connect (GTK_OBJECT(radio1), "toggled",
			    (GtkSignalFunc) set_background_mode,
			    (gpointer) ((long) FALSE));
	gtk_box_pack_start (GTK_BOX (vb1), radio1, FALSE, FALSE, 0);
	gtk_table_attach_defaults (GTK_TABLE(table), vb1, 1, 2, 0, 1);
	gtk_widget_show (radio1);

	radio1 = gtk_radio_button_new_with_label (gtk_radio_button_group(GTK_RADIO_BUTTON(radio1)),
						 _("Gradient"));
	gtk_signal_connect (GTK_OBJECT(radio1), "toggled",
			    (GtkSignalFunc) set_background_mode,
			    (gpointer) ((long) TRUE));
	gtk_box_pack_start (GTK_BOX (vb1), radio1, FALSE, FALSE, 0);
	gtk_widget_show(radio1);

	cs2 = gnome_color_selector_new ((SetColorFunc) fill_monitor, NULL);
	gnome_color_selector_set_color_int (cs2,
					    bgColor2.red,
					    bgColor2.green,
					    bgColor2.blue, 65535);

	button2 = gnome_color_selector_get_button (cs2);
	gtk_table_attach (GTK_TABLE(table), button2, 0, 1, 1, 2, 0, 0, 0, 0);
	gtk_widget_set_sensitive (button2, FALSE);
	gtk_widget_show (button2);
	gtk_signal_connect (GTK_OBJECT(radio1), "toggled",
			    (GtkSignalFunc) radio_toggle_widget_active,
			    button2);

	radio2 = gtk_radio_button_new_with_label (NULL, _("Vertical"));
	gtk_signal_connect (GTK_OBJECT(radio2), "toggled",
			    (GtkSignalFunc) set_orientation,
			    (gpointer) ((long) TRUE));
	gtk_box_pack_start (GTK_BOX (vb2), radio2, FALSE, FALSE, 0);
	gtk_widget_set_sensitive (radio2, FALSE);
	gtk_widget_show (radio2);
	gtk_signal_connect (GTK_OBJECT(radio1), "toggled",
			    (GtkSignalFunc) radio_toggle_widget_active,
			    radio2);

	radio2 = gtk_radio_button_new_with_label (gtk_radio_button_group(GTK_RADIO_BUTTON(radio2)),
						 _("Horizontal"));
	gtk_signal_connect (GTK_OBJECT(radio2), "toggled",
			    (GtkSignalFunc) set_orientation,
			    (gpointer) ((long) FALSE));
	gtk_box_pack_start (GTK_BOX (vb2), radio2, FALSE, FALSE, 0);
	gtk_table_attach_defaults (GTK_TABLE(table), vb2, 1, 2, 1, 2);
	gtk_widget_set_sensitive (radio2, FALSE);
	gtk_widget_show(radio2);
	gtk_signal_connect (GTK_OBJECT(radio1), "toggled",
			    (GtkSignalFunc) radio_toggle_widget_active,
			    radio2);
	
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio1), grad);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio2), !vertical);
	fill_monitor();

	return frame;
}

GtkWidget *
wallpaper_setup ()
{
	GtkWidget *wallp;
	GtkWidget *vbox;
	GtkWidget *rbut;

	wallp = gtk_frame_new (_("Wallpaper"));
	vbox = gtk_vbox_new (FALSE, 0);
	rbut = gtk_radio_button_new_with_label (NULL, _("tiled"));
	gtk_box_pack_start (GTK_BOX (vbox), rbut, FALSE, FALSE, 0);
	gtk_widget_show (rbut);

	rbut = gtk_radio_button_new_with_label
		(gtk_radio_button_group (GTK_RADIO_BUTTON (rbut)),
		 _("centered"));
	gtk_box_pack_start (GTK_BOX (vbox), rbut, FALSE, FALSE, 0);

	gtk_container_border_width (GTK_CONTAINER (vbox), GNOME_PAD);
	gtk_container_add (GTK_CONTAINER (wallp), vbox);


	gtk_widget_show (rbut);
	gtk_widget_show (vbox);
	gtk_widget_show (wallp);

	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rbut),
				     wpType == WALLPAPER_CENTERED);

	return wallp;
}

static void
background_apply () {
	GdkWindow *rootWindow;
	GdkPixmap *rootBack = NULL;
	GtkWidget *rootPreview;
	gint rootWidth, rootHeight;

	GtkWidget *op = preview;

	/* gtk_widget_push_visual (gtk_preview_get_visual ());
	gtk_widget_push_colormap (gtk_preview_get_cmap ()); */

	rootWindow = gdk_window_foreign_new (GDK_ROOT_WINDOW());
	gdk_window_get_size (rootWindow, &rootWidth, &rootHeight);

	/* gnome_color_selector_get_color_int(cs1, &r0, &g0, &b0, 255);
	gnome_color_selector_get_color_int(cs2, &r1, &g1, &b1, 255); */

	if (bgType = BACKGROUND_WALLPAPER) {
		rootBack = gdk_pixmap_create_from_xpm (rootWindow, NULL,
						       &bgColor1, wpFileName);
		gdk_window_set_back_pixmap (rootWindow, rootBack, FALSE);
		gdk_pixmap_destroy (rootBack);
	} else if (grad) {
		rootPreview = gtk_preview_new (GTK_PREVIEW_COLOR);

		gtk_preview_size (GTK_PREVIEW (rootPreview), rootWidth, rootHeight);

		preview = rootPreview;
		gnome_preview_fill_gradient (GTK_PREVIEW (rootPreview),
					     &bgColor1, &bgColor2,
					     vertical);
		preview = op;

		rootBack = gdk_pixmap_new (rootWindow, rootWidth, rootHeight, -1);
		gtk_preview_put (GTK_PREVIEW (rootPreview),
				 rootBack,
				 monitor->style->black_gc,
				 0, 0,
				 0, 0,
				 rootWidth, rootHeight);

		gdk_window_set_back_pixmap (rootWindow, rootBack, FALSE);
	
		gdk_pixmap_destroy (rootBack);
		gtk_widget_destroy (rootPreview);
	} else {
		gdk_color_alloc (gdk_window_get_colormap (rootWindow),
				 &bgColor1);
			 
		gdk_window_set_background (rootWindow, &bgColor1);
	}
	gdk_window_clear (rootWindow);

	/* gtk_widget_pop_colormap ();
	gtk_widget_pop_visual (); */
}

static void
background_write () {
	char buffer [60];
	
	sprintf (buffer, "#%02x%02x%02x",
		 bgColor1.red,
		 bgColor1.green,
		 bgColor1.blue);
	gnome_config_set_string ("/Desktop/Background/color1", buffer);
	sprintf (buffer, "#%02x%02x%02x",
		 bgColor2.red,
		 bgColor2.green,
		 bgColor2.blue);
	gnome_config_set_string ("/Desktop/Background/color2", buffer);

	gnome_config_set_string ("/Desktop/Background/simple",
				 (grad) ? "gradient" : "solid");
	gnome_config_set_string ("/Desktop/Background/gradient",
				 (vertical) ? "vertical" : "horizontal");

	gnome_config_set_string ("/Desktop/Background/wallpaper",
				 (bgType == BACKGROUND_SIMPLE) ? "none" : wpFileName);
	gnome_config_set_string ("/Desktop/Background/wallpaperAlign",
				 (wpType == WALLPAPER_TILED) ? "tiled" : "centered");
}

static void
background_read () {
	gdk_color_parse
		(gnome_config_get_string ("/Desktop/Background/color1=#0000ff"),
		 &bgColor1);
	gdk_color_parse
		(gnome_config_get_string ("/Desktop/Background/color2=#808080"),
		 &bgColor2);

	bgType = (strcasecmp
		  (gnome_config_get_string
		   ("/Desktop/Background/type=simple"),
		   "simple"));
	grad = (strcasecmp
		(gnome_config_get_string
		 ("/Desktop/Background/simple=solid"),
		 "solid"));
	vertical = !(strcasecmp
		     (gnome_config_get_string
		      ("/Desktop/Background/gradient=vertical"),
		      "vertical"));
	if ((strcasecmp
	      (gnome_config_get_string
	       ("/Desktop/Background/wallpaperAlign=tiled"),
	       "tiled")))
		wpType = WALLPAPER_CENTERED;
	else
		wpType = WALLPAPER_TILED;

	wpFileName = gnome_config_get_string ("/Desktop/Background/wallpaper=none");

	if (!strcasecmp (wpFileName, "none")) {
		wpFileName = NULL;
		bgType = BACKGROUND_SIMPLE;
	} else
		bgType = BACKGROUND_WALLPAPER;
}

static gint
background_action (GnomePropertyRequest req)
{
	switch (req) {
	case GNOME_PROPERTY_READ:
		background_read ();
		break;
	case GNOME_PROPERTY_WRITE:
		background_write ();
		break;
	case GNOME_PROPERTY_APPLY:
		background_apply ();
		break;
	default:
		return 0;
	}

	return 1;
}

/*
 * background_setup: creates the dialog box for configuring the
 * display background and registers it with the display property
 * configurator
 */
void
background_setup (GtkWidget *window)
{
	GtkWidget *settings;
	GtkWidget *hbox;
	GtkWidget *fill, *wallp;
	
	background_action (GNOME_PROPERTY_READ);

	vbox = gtk_vbox_new (TRUE, 0);

	hbox = gtk_hbox_new (TRUE, 0);
	gtk_container_border_width (GTK_CONTAINER(hbox), GNOME_PAD);

	screen = gtk_fixed_new ();
	monitor = get_monitor_preview_widget (window);
	preview = gtk_preview_new(GTK_PREVIEW_COLOR);

	gtk_fixed_put (GTK_FIXED (screen), monitor, 0, 0);

	gtk_preview_size(GTK_PREVIEW(preview),
			 GNOME_MONITOR_WIDGET_WIDTH,
			 GNOME_MONITOR_WIDGET_HEIGHT);
	gtk_fixed_put (GTK_FIXED (screen), preview,
		       GNOME_MONITOR_WIDGET_X,
		       GNOME_MONITOR_WIDGET_Y);
	
	gtk_box_pack_start (GTK_BOX(hbox), screen, FALSE, FALSE, 0);

	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	
	settings = gtk_hbox_new (FALSE, GNOME_PAD);
	gtk_container_border_width (GTK_CONTAINER(settings), GNOME_PAD);
	gtk_box_pack_end (GTK_BOX (vbox), settings, TRUE, TRUE, 0);

	fill = color_setup ();
	gtk_box_pack_start (GTK_BOX (settings), fill, FALSE, FALSE, 0);
	
	wallp  = wallpaper_setup ();
	gtk_box_pack_end (GTK_BOX (settings), wallp, TRUE, TRUE, 0);
	
	gtk_widget_show (preview);
	gtk_widget_show (monitor);
	gtk_widget_show (screen);
	gtk_widget_show (settings);
	gtk_widget_show (hbox);

        register_extension (gtk_label_new (_(" Background ")), vbox, background_action);

	gtk_widget_show (vbox);
}
