/* main.c - Main program for desktop properties application.  */

#include <config.h>
#include <stdio.h>

#include <gnome.h>
#include "gnome-desktop.h"


GtkWidget *main_window;
GnomePropertyConfigurator *display_config;

/* This is true if we've ever changed the state with this program.  */
static int state_changed = 0;

/* True if we are running in initialize-then-exit mode.  */
int init = 0;


/* Enable the Apply button.  */
void
property_changed (void)
{
	gnome_property_box_changed (GNOME_PROPERTY_BOX (display_config->property_box));
}

void
property_applied (void)
{
	state_changed = 1;
}

static gint
deleteFn (GtkWidget *widget, gpointer *data)
{
	gtk_main_quit ();

	return TRUE;
}

/* This is called when the Help button is clicked.  */
static void
help (GtkWidget *w, gint page, gpointer *data)
{
  /* FIXME.  */
}

void
display_properties_setup (void)
{
	gnome_property_configurator_setup (display_config);
	main_window = display_config->property_box;
	gnome_property_configurator_request_foreach (display_config,
						     GNOME_PROPERTY_SETUP);

	gtk_signal_connect (GTK_OBJECT (display_config->property_box),
			    "help", (GtkSignalFunc) help, NULL);
	gtk_signal_connect (GTK_OBJECT (display_config->property_box),
			    "delete_event", (GtkSignalFunc) deleteFn, NULL);
	gtk_signal_connect (GTK_OBJECT (display_config->property_box),
			    "destroy", (GtkSignalFunc) deleteFn, NULL);

	gtk_window_set_title(GTK_WINDOW(display_config->property_box), 
			     application_title());
	gtk_widget_show (display_config->property_box);
}

int
property_main (char *app_id, int argc, char *argv [])
{
        GnomeClient *client = NULL;
	int token = 0;
	char *new_argv[4];
#if 0
	{
		volatile int i = 1;
		printf ("Esperando %d\n", getpid ());
		while (i);
	}
#endif
	argp_program_version = VERSION;
	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);

	gnome_init (app_id, &parser, argc, argv, 0, NULL);
	client = gnome_master_client ();

	/* Set this stuff for completeness' sake.  */
	gnome_client_set_restart_command (client, 1, argv);
	gnome_client_set_clone_command (client, 1, argv);

	display_config = gnome_property_configurator_new ();

	application_register (display_config);

	/* If this startup is the result of a previous session, we try
	   to acquire the token that would let us set the current
	   state.  */
	if (gnome_client_get_previous_id (client))
	        token = gnome_startup_acquire_token (application_property (),
						     gnome_client_get_id (client));
	else if (init) {
		/* User requested --init on command line, but no
		   session id was given.  We honor the user's
		   request.  */
		token = 1;
	}

	/* If our only purpose is to set the properties and then exit,
	   and we didn't acquire the lock, then we are done.  */
	if (init && ! token)
	        return 0;

	gnome_property_configurator_request_foreach (display_config,
						     GNOME_PROPERTY_READ);

	if (token) {
		/* We have the token, so we set up the state.  */
		gnome_property_configurator_request_foreach (display_config,
							     GNOME_PROPERTY_APPLY);
	}

	if (! init) {
		/* Show the user interface.  */
		display_properties_setup ();
		gtk_main ();
	}

	if (init || state_changed) {
		/* Arrange to be run again next time the session
		   starts.  */
		new_argv[0] = argv[0];
		new_argv[1] = "--init";
		gnome_client_set_restart_command (client, 2, new_argv);
		gnome_client_set_clone_command (client, 2, new_argv);
		gnome_client_set_restart_style (client, GNOME_RESTART_ANYWAY);
	}

	gnome_property_configurator_destroy (display_config);
	return 0;
}
