/*
 * $Id: snmp_lib.c,v 1.14 1998/08/06 19:14:52 jochen Exp $
 * GXSNMP -- An snmp management application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Snmp support
 */
#ifndef lint
static char const copyright[] =
"@(#) Copyright (c) 1998 Gregory McLean";
#endif
static char const rcsid[] =
"$Id: snmp_lib.c,v 1.14 1998/08/06 19:14:52 jochen Exp $";

#include <config.h>               /* pull in the autoconf genereated stuff */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#endif
#include <time.h>
#include <sys/errno.h>
#include <glib.h>
#include <gtk/gtk.h>
#include "main.h"
#include "snmp_lib.h"
#include "host.h"
#include "snmp_host.h"

extern int errno;
extern gint     snmpsocket;
static gint     snmp_tag    = 0;      /* SNMP input id */
static gint     snmp_time   = 0;      /* SNMP timeout callback */

void 
snmperror ()
{
  char buf[256];

  switch (errno)
    {
    case EPROTONOSUPPORT:
      snprintf (buf, sizeof (buf), "The protocol type or the specified "
		"protocol is not supported within this domain.");
      break;
    case EMFILE:
      snprintf (buf, sizeof (buf), 
		"The per-process descriptor table is full.");
      break;
    case ENFILE:
      snprintf (buf, sizeof (buf),
		"The system file table is full.");
      break;
    case EACCES:
      snprintf (buf, sizeof (buf), "Insuffcient permissions to open snmp"
		" socket or the protocol is denied.");
      break;
    case ENOBUFS:
      snprintf (buf, sizeof (buf), "Insuffcient buffer space is available. "
		"The socket cannot be created until sufficient resources are "
		"freed.");
      break;
    }
  notice_dlg (buf);
}

/*
 * The initialisation
 */

void
cb_register(guint socket, void (*receiveMessage)())
{
  gdk_input_add(socket, GDK_INPUT_READ, receiveMessage, NULL);
} 

void
snmpinit() 
{
  if (!g_snmp_init(FALSE, cb_register))
    g_error("Initialisation of SNMP library failed.");
  snmp_time = gtk_timeout_add (1000, g_snmp_timeout_cb, NULL);
} 
/* EOF */
