/*
 * $Id: gtkledbar.c,v 1.3 1998/05/31 15:31:56 gregm Exp $
 * GTKEXT - Extensions to The GIMP Toolkit
 * Copyright (C) 1998 Gregory McLean
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Cambridge, MA 
 * 02139, USA.
 *
 * Eye candy!
 */

#include "gtkledbar.h"
#include <gtk/gtktable.h>

static void     led_bar_class_init        (LedBarClass *klass);
static void     led_bar_init              (LedBar      *led_bar);

guint
led_bar_get_type ()
{
  static guint led_bar_type = 0;

  if (!led_bar_type)
    {
      GtkTypeInfo led_bar_info = {
	"LedBar",
	sizeof (LedBar),
	sizeof (LedBarClass),
	(GtkClassInitFunc) led_bar_class_init,
	(GtkObjectInitFunc) led_bar_init,
	(GtkArgSetFunc) NULL,
	(GtkArgGetFunc) NULL
      };

      led_bar_type = gtk_type_unique (gtk_vbox_get_type (), &led_bar_info);
    }
  return led_bar_type;
}

static void
led_bar_class_init (LedBarClass *class)
{
  GtkObjectClass   *object_class;

  object_class = (GtkObjectClass *) class;

}

static void
led_bar_init (LedBar *led_bar)
{
  led_bar->num_segments = 0;
  led_bar->lit_segments = 0;
  led_bar->seq_segment  = 0;
  led_bar->seq_dir      = 1;
}

GtkWidget *
led_bar_new (gint segments)
{
  LedBar    *led_bar;
  GtkWidget *table;
  gint      i;

  led_bar = gtk_type_new (led_bar_get_type ());
  if (segments > MAX_SEGMENTS)
    segments = MAX_SEGMENTS;
  led_bar->num_segments = segments;
  table = gtk_table_new (1, segments, FALSE);
  gtk_container_add (GTK_CONTAINER (led_bar), table);
  gtk_widget_show (table);

  for (i = 0; i < segments; i++) {
    led_bar->segments[i] = gtk_led_new ();
    gtk_table_attach_defaults (GTK_TABLE (table), led_bar->segments[i],
			       i, (i + 1), 0, 1);
    gtk_widget_show (led_bar->segments[i]);
  }

  return GTK_WIDGET (led_bar);
}

gint
led_bar_get_num_segments (GtkWidget *bar)
{
  g_return_if_fail (bar != NULL);
  g_return_if_fail (IS_LEDBAR (bar));

  return (LEDBAR (bar)->num_segments);
}

void
led_bar_light_segments (GtkWidget *bar, gint num)
{
  LedBar    *led_bar;
  int       i;

  g_return_if_fail (bar != NULL);
  g_return_if_fail (IS_LEDBAR (bar));

  led_bar = LEDBAR (bar);
  for (i = 0; i < num; i++) {
    gtk_led_set_state (GTK_LED (led_bar->segments[i]), 
		       GTK_STATE_SELECTED,
		       TRUE);
  }
  led_bar->lit_segments = i;
}

void 
led_bar_unlight_segments (GtkWidget *bar, gint num)
{
  LedBar    *led_bar;
  int       i;

  g_return_if_fail (bar != NULL);
  g_return_if_fail (IS_LEDBAR (bar));

  led_bar = LEDBAR (bar);
  for (i = 0; i < num; i++) {
    gtk_led_set_state (GTK_LED (led_bar->segments[i]),
		       GTK_STATE_SELECTED,
		       FALSE);
  }
  led_bar->lit_segments -= num;
  if (led_bar->lit_segments < 0)
    led_bar->lit_segments = 0;
}

void 
led_bar_light_segment (GtkWidget *bar, gint segment)
{
  LedBar     *led_bar;

  g_return_if_fail (bar != NULL);
  g_return_if_fail (IS_LEDBAR (bar));

  led_bar = LEDBAR (bar);
  gtk_led_set_state (GTK_LED (led_bar->segments[segment]),
		     GTK_STATE_SELECTED,
		     TRUE);
}

void
led_bar_unlight_segment (GtkWidget *bar, gint segment)
{
  LedBar     *led_bar;

  g_return_if_fail (bar != NULL);
  g_return_if_fail (IS_LEDBAR (bar));

  led_bar = LEDBAR (bar);
  gtk_led_set_state (GTK_LED (led_bar->segments[segment]),
		     GTK_STATE_SELECTED,
		     FALSE);
}

void
led_bar_light_percent (GtkWidget *bar, gfloat percent)
{
  LedBar     *led_bar;
  gint       num, i;

  g_return_if_fail (bar != NULL);
  g_return_if_fail (IS_LEDBAR (bar));

  led_bar = LEDBAR (bar);

  num = percent * led_bar->num_segments;
  for (i = 0; i < led_bar->num_segments; i++) {
    if (num > 0) {
      gtk_led_set_state (GTK_LED (led_bar->segments[i]),
			 GTK_STATE_SELECTED,
			 TRUE);
      num--;
    } else {
      gtk_led_set_state (GTK_LED (led_bar->segments[i]),
			 GTK_STATE_SELECTED,
			 FALSE);
    }
  }
}

void
led_bar_clear (GtkWidget *bar)
{
  LedBar     *led_bar;
  int        i;

  g_return_if_fail (bar != NULL);
  g_return_if_fail (IS_LEDBAR (bar));

  led_bar = LEDBAR (bar);
  for (i = 0; i < led_bar->num_segments; i++) {
    gtk_led_set_state (GTK_LED (led_bar->segments[i]),
		       GTK_STATE_SELECTED,
		       FALSE);
  }
}

void
led_bar_sequence_step (GtkWidget *bar)
{
  LedBar    *led_bar;

  g_return_if_fail (bar != NULL);
  g_return_if_fail (IS_LEDBAR (bar));

  led_bar = LEDBAR (bar);
  if (led_bar->seq_segment >= (led_bar->num_segments - 1))
    led_bar->seq_dir = -1;
  else if (led_bar->seq_segment <= 0)
    led_bar->seq_dir = 1;

  led_bar_unlight_segment (GTK_WIDGET(led_bar), led_bar->seq_segment);
  led_bar->seq_segment += led_bar->seq_dir;
  led_bar_light_segment (GTK_WIDGET(led_bar), led_bar->seq_segment);
}

/* EOF */
