/*
 * $Id: gui.h,v 1.9 1998/08/10 23:09:43 gregm Exp $
 * GXSNMP - An snmp managment application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Some 'lazy mans' functions.
 */
#ifndef __GUI_SUP_H__
#define __GUI_SUP_H__

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdarg.h>
#include "snmp_host.h"

#define RED_IDX     0
#define GRN_IDX     1
#define BLU_IDX     2

#define BLUE_COLOR    1
#define HOST_UP_COLOR 2
#define HOST_DN_COLOR 3

/* 
 * Handy element counting macro
 */
#define ELEMENTS(x) (sizeof (x) / sizeof (x[0]))

GtkWidget    *new_window            (char              *title,
				     GtkWindowType     type,
				     GtkWindowPosition pos,
				     int               border);
GtkWidget    *new_pixmap            (char            *filename,
				     GdkWindow       *window,
				     GdkColor        *background);
GtkWidget    *new_host_widget       (hosts           *hentry);
GdkColor     get_color              (int             which);
void         destroy_pixmap_cache   (void);
void         init_pixmap_d          (GtkWidget       *window);
void         page_switch_cb         (GtkWidget       *widget,
				     GtkNotebookPage *page,
   				     gint            page_num);
void         notice_dlg             (gchar *msg, ...)
                                    __attribute__ ((format (printf, 1, 2)));
GtkWidget    *notebook_tab          (const char      *label);
GtkWidget    *get_widget            (GtkWidget       *widget,
				     const gchar     *name);
#endif
/* EOF */







