/* GnomENIUS Calculator
 * Copyright (C) 1997, 1998 the Free Software Foundation.
 *
 * Author: George Lebl
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the  Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

/*
 * this is a command line testing program!
 */

#include <glib.h>

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "calc.h"
#include "util.h"

/*Globals:*/

/*calculator state*/
calcstate_t curstate={
	INFIX_NOTATION,
	256,
	INFIX_NOTATION,
	12,
	FALSE,
	FALSE,
	FALSE
	};

void
puterror(char *s)
{
	fprintf(stderr,"%s\n",s);
}

int
main(void)
{
	char *t=NULL;
	char tmp[256];
	char *o;

	while(fgets(tmp,255,stdin))
		t=appendstr(t,tmp);
	if(!t || t[0]=='\0') {
		puts("no input");
		return 1;
	}
	t=addparenth(t); /*add missing parenthesis*/
	o=evalexp(t,curstate,puterror);

	if(!o) {
		puts("errors");
		return 1;
	}
	puts(o);

	g_free(t);
	g_free(o);

	return 0;
}
