#include "obgnome.h"
#include <gnome.h>

GnomeUIInfo filemenu[] = {
  {GNOME_APP_UI_ITEM, N_("Properties"), N_("Prop Box test"), "propbox",
   NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Exit"), N_("Exit the program"), "quit",
   NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 0, 0, NULL},
  GNOMEUIINFO_END
};

GnomeUIInfo helpmenu[] = {
  GNOMEUIINFO_HELP("obHello"),
  {GNOME_APP_UI_ITEM, N_("About..."), N_("About this program"), "about",
   NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
  GNOMEUIINFO_END
};

GnomeUIInfo mainmenu[] = {
  GNOMEUIINFO_SUBTREE("File", &filemenu),
  GNOMEUIINFO_SUBTREE("Help", &helpmenu),
  GNOMEUIINFO_END
};

@interface PropertyDialogPopup : Gnome_PropertyBox
- init;
- buttonClicked1:(id) myObj;
@end

@implementation PropertyDialogPopup
- init
{
	Gtk_Button *button;

	self = [super init];

	[self connect:"apply"];

	button = [[Gtk_Button new] initWithLabel:"Click me!"];
	[button connectObj:"clicked" :self];

	[self append_page:[button show]
		:[[[Gtk_Label new] initWithLabel:"Page #1"] show]];

	button = [[Gtk_Button new] initWithLabel:"Button Fun"];
	[button connectObj:"clicked" :self];

	[self append_page:[button show]
		:[[[Gtk_Label new] initWithLabel:"Page #2"] show]];

	button = [[[Gtk_Button new] initWithLabel:"Button1"] show];
	[button connectObj:"clicked" :self];
	[button connectObjMethod:"clicked" :self
:@selector(buttonClicked1:)];

	/* This button is special, it connects to its own callback and also
the generic clicked so it also affects the "apply" signal in the property
box. cool. useful? no :P -Michael */

	[self append_page:[button show]
		:[[[Gtk_Label new] initWithLabel:"Page #3"] show]];

	[self show];

	return self;
}

- apply:(id) myObj :(gint) n
{
/* This is right out of stock_demo.c -Michael */
        char s[256];

        if (n != -1) {
                sprintf(s, "Applied changed on page #%d", n + 1);
                gtk_widget_show(gnome_message_box_new(s, "info",
                                GNOME_STOCK_BUTTON_OK, NULL));
        }
	return self;
}

- clicked:(id) myObj
{
        [self changed];
        return self;
}

- buttonClicked1:(id) myObj
{
	printf("Button1\n");
	return self;
}
@end

@interface HelloWindow : Gnome_AppWin
{
id myapp;
}
- initForApp: (id) myApp;
- clicked: (id) myObj;
- buttonClicked1:(id) myObj;
- buttonClicked2:(id) myObj;
- buttonClicked3:(id) myObj;
@end

@implementation HelloWindow
- initForApp: (id) myApp
{
	id vbox2, vbox, label, pix;
	Gtk_Button *button;
	Gtk_Frame *frame;

	myapp = myApp; /* FIXME: [need better explanation] pass 
				along main Object to new Object */

	self = [super initWithAppWinInfo:"obhello" :"GNOME Obj-C Hello"];

	vbox = [[Gtk_VBox new] show];

	label = [[[Gtk_Label new] initWithLabel:"GNOME is cool. yup."] show];
	button = [[[Gtk_Button new] initWithLabel:"Font Selection Test"] show];
	[button connectObj:"clicked" :self];

	[vbox pack_start:label doExpand:TRUE doFill:TRUE doPadding:5];
	[vbox pack_start:button doExpand:TRUE doFill:TRUE doPadding:5];

	button = [[[Gnome_StockButton alloc] initStock:GNOME_STOCK_PIXMAP_PREFERENCES] show];
	[vbox pack_start:button doExpand:TRUE doFill:TRUE doPadding:5];

	vbox2 = [[Gtk_HBox new] show];
	[vbox pack_start:vbox2 doExpand:TRUE doFill:TRUE doPadding:5];

	pix = [[Gnome_StockPixmapWidget alloc] initWithImage:myapp :GNOME_STOCK_PIXMAP_PREFERENCES];
	[vbox2 pack_start:[pix show] doExpand:TRUE doFill:TRUE doPadding:5];

	pix = [[Gnome_StockPixmapWidget alloc] initWithImage:myapp :GNOME_STOCK_PIXMAP_BOOK_GREEN];
	[vbox2 pack_start:[pix show] doExpand:TRUE doFill:TRUE doPadding:5];

	pix = [[Gnome_StockPixmapWidget alloc] initWithImage:myapp :GNOME_STOCK_PIXMAP_MAIL];
	[vbox2 pack_start:[pix show] doExpand:TRUE doFill:TRUE doPadding:5];

	frame = [[[Gtk_Frame new] initWithLabel:"connectObjMethod"] show];
	[vbox pack_start:frame doExpand:TRUE doFill:TRUE doPadding:5];

	vbox2 = [[Gtk_HBox new] show];
	[frame add:vbox2];

	button = [[[Gtk_Button new] initWithLabel:"Button1"] show];
	[button connectObjMethod:"clicked" :self :@selector(buttonClicked1:)];
	[vbox2 pack_start:button doExpand:TRUE doFill:TRUE doPadding:5];

	button = [[[Gtk_Button new] initWithLabel:"Button2"] show];
	[button connectObjMethod:"clicked" :self :@selector(buttonClicked2:)];
	[vbox2 pack_start:button doExpand:TRUE doFill:TRUE doPadding:5];

	button = [[[Gtk_Button new] initWithLabel:"Button3"] show];
	[button connectObjMethod:"clicked" :self :@selector(buttonClicked3:)];
	[vbox2 pack_start:button doExpand:TRUE doFill:TRUE doPadding:5];

	[self create_menus:mainmenu];
	[self set_contents:vbox];
	[self connect:"delete_event"];

	return self;
}

- buttonClicked1:(id) myObj
{
	printf("Button1\n");
	return self;
}

- buttonClicked2:(id) myObj
{
	printf("Button2\n");
	return self;
}

- buttonClicked3:(id) myObj
{
	printf("Button3\n");
	return self;
}

- clicked:(id) myObj
{
	id hi;
	char *woop;

	hi = [Gnome_Font_Selector alloc];

	woop = [hi initModalWithReturn];

	printf("font: %s\n", woop);

	free(woop);

	return self;
}

#define VERSION "0.0.1"

- about:(id) myObj
{
	char *author[] = {"Michael Hanni <mhanni@sprintmail.com>", NULL};

	[[[Gnome_About alloc] initWithAboutInfo:"obHello" 
		version:VERSION 
		copyright:"Copyright (C) 1998 the Free Software Foundation" 
		authors:author
		comments:"The Civilized GNOME Objective-C Hello..." 
		logo:NULL] show];

	return self;
}

- quit:(id) myObj
{
	[myapp quit];
	return self;
}

- propbox:(id) myObj
{
	[PropertyDialogPopup new];
	return self;
}

- delete_event:(id) myObj :(GdkEventAny *) event
{
	return [self quit:myObj];
}
@end

@interface HelloObject : Gnome_App
{
HelloObject *window;
}
-initHello:(char *)app_id :(int) argc :(char **) argv;
@end

@implementation HelloObject
-initHello:(char *)app_id
	:(int) argc
	:(char **) argv
{
	self = [super initApp:app_id :NULL :argc :argv :0 :NULL];

	window = [[[HelloWindow alloc] initForApp:self] show];

	return self;
}
@end

gint
main(int argc, char *argv[])
{

	id myapp;

	myapp = [HelloObject alloc];
	[myapp initHello:"obHello" :argc :argv];
	[myapp run];
	[myapp free];

	return 0;

}
