/*****************             Electirc Eyes           ***********************/
/* This software is Copyright (C) 1998 but The Rasterman (Carsten Haitzler). */
/* This software falls under the GNU Public License. Please read the COPYING */
/* file for more information                                                 */
/*****************************************************************************/
#include "ee.h"

int set_root_and_quit = 0;

static error_t parse (int key, char *arg, struct argp_state *state);

static struct argp_option options[] =
{
     { "root", 'r', NULL, 0, N_("Set root window image and leave"), 0 },
     { NULL, 0, NULL, 0, NULL, 0 }
};

static struct argp parser =
{
   options,
   parse,
   N_("[FILE ...]"),
   NULL,
   NULL,
   NULL,
   NULL
};

static error_t parse (int key, char *arg, struct argp_state *state)
{
   char *s;

   switch (key){
   case ARGP_KEY_ARG:
	   if (*arg!='/')
		   s=g_copy_strings(current_dir,"/",arg,NULL);
	   else
		   s=strdup(arg);
	   add_file_to_list(s);
	   free(s);
	   return 0;

   case 'r':
	   set_root_and_quit = 1;
	   return 0;
	   
   default:
	   return ARGP_ERR_UNKNOWN;
   }
}

int main(int argc, char **argv)
{
   bindtextdomain(PACKAGE,GNOMELOCALEDIR);
   textdomain(PACKAGE);

   current_dir=cwd();
   init_list();
   gnome_init("ElectricEyes", &parser, argc, argv, 0, NULL);
   gdk_imlib_init();
   gtk_widget_push_visual(gdk_imlib_get_visual());
   gtk_widget_push_colormap(gdk_imlib_get_colormap());

   edit_accel=gtk_accelerator_table_new();
   image_accel=gtk_accelerator_table_new();
   
   init_dirs();
   init_edit();
   init_image();
   init_dnd();
   
   gtk_window_add_accelerator_table(GTK_WINDOW(window_edit),edit_accel);
   gtk_window_add_accelerator_table(GTK_WINDOW(window_image),image_accel);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(window_image),"delete_event",
				 'q',0);
   gtk_accelerator_table_install(edit_accel,
				 GTK_OBJECT(window_image),"delete_event",
				 'q',0);
   sync_list_to_clist();

   if (set_root_and_quit){
        while (gtk_events_pending()) gtk_main_iteration();
      in_init=0;
      show_image_n(0);
      show_image();
      gdk_imlib_render(current.image,current.image->rgb_width,
		       current.image->rgb_height);
      current.pixmap=gdk_imlib_move_image(current.image);
      set_desktop_image ();
   } else
     {
        while (gtk_events_pending()) gtk_main_iteration();
	in_init=0;
	show_image_n(0);
	show_image();
	gtk_main();
     }
}
