/* GnomENIUS Calculator
 * Copyright (C) 1997 George Lebl.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _STRUCTS_H_
#define _STRUCTS_H_

#include "mpwrap.h"

struct _tree_t;
struct _dict_t;

/*dictionary function structure*/
typedef enum {BUILTIN_FUNC,USER_FUNC} func_type_t;
typedef struct _func_t {
	func_type_t type;
	char *id;
	int nargs; /*number of args*/
	int context;
	int dynamic;
	union {
		struct {
			struct _tree_t *value;
			struct _dict_t *dict;
		} user;
		struct _tree_t *(*func)(struct _tree_t * *);
	} data;
} func_t;

/*dictionary structure*/
typedef struct _dict_t {
	func_t * * dict;
	int top;
	int size;
} dict_t;

/*evaluation tree structure*/
typedef enum {NUMBER_NODE,ACTION_NODE} node_type_t;
typedef enum {PRIMITIVE_TYPE,FUNCTION_TYPE} op_type_t;
typedef struct _tree_t {
	node_type_t type;
	union {
		mpw_t val;
		struct {
			op_type_t type;
			union {
				int primitive;
				struct {
					func_t * func;
					struct _tree_t * * args;
				} function;
			} data;
		} action;
	} data;
	struct _tree_t *left;
	struct _tree_t *right;
	struct _tree_t *secondright; /*rarely used, for exampleIFELSE*/
} tree_t;

#endif
