#include "obgtk.h"

@implementation Gtk_Menu
- castGtkMenu:(GtkMenu *) castitem
{
  gtkmenu = castitem;
  return [super castGtkMenuShell:GTK_MENU_SHELL(gtkmenu)];
}

- init
{
  gtkmenu = GTK_MENU(gtk_menu_new());
  return [super castGtkMenuShell:GTK_MENU_SHELL(gtkmenu)];
}

- append:(Gtk_Widget *) child
{
  gtk_menu_append(gtkmenu, child->gtkwidget);
  return self;
}

- prepend:(Gtk_Widget *) child
{
  gtk_menu_prepend(gtkmenu, child->gtkwidget);
  return self;
}

- insert:(Gtk_Widget *) child
    aPos:(gint) position
{
  gtk_menu_insert(gtkmenu, child->gtkwidget, position);
  return self;
}

- popup     :(Gtk_MenuShell *) parent_menu_shell
    menuItem:(Gtk_MenuItem *) parent_menu_item
     posFunc:(GtkMenuPositionFunc) func
 posFuncData:(gpointer) data
  posFuncBtn:(gint) button
 posFuncTime:(guint32) activate_time
{
  gtk_menu_popup(gtkmenu, parent_menu_shell->gtkwidget,
		 parent_menu_item->gtkwidget, func, data,
		 button, activate_time);
  return self;
}

- popdown
{
  gtk_menu_popdown(gtkmenu);
  return self;
}

- (Gtk_Widget *) get_active
{
  return [[Gtk_Widget alloc] castGtkWidget:gtk_menu_get_active(gtkmenu)];
}

- set_active:(gint) index
{
  gtk_menu_set_active(gtkmenu, index);
  return self;
}

- set_accelerator_table:(Gtk_AcceleratorTable *) table
{
  gtk_menu_set_accelerator_table(gtkmenu, table->gtkacceleratortable);
  return self;
}
@end
