#include "obgtkEditable.h"

@implementation Gtk_Editable
- castGtkEditable:(GtkEditable *) castitem
{
  gtkeditable = castitem;
  return [super castGtkWidget:GTK_WIDGET(castitem)];
}

- select_region:(gint) start :(gint) end
{
  gtk_editable_select_region(gtkeditable, start, end);
  return self;
}

- insert_text:(const gchar *) new_text
	     :(gint) new_text_length
	     :(gint *) position
{
  gtk_editable_insert_text(gtkeditable, new_text, new_text_length, position);
  return self;
}

- delete_text:(gint) start_pos
	     :(gint) end_pos
{
  gtk_editable_delete_text(gtkeditable, start_pos, end_pos);
  return self;
}

- (gchar *) get_chars:(gint) start_pos
		     :(gint) end_pos
{
  return gtk_editable_get_chars(gtkeditable, start_pos, end_pos);
}

- cut_clipboard:(guint32) time
{
  gtk_editable_cut_clipboard(gtkeditable, time);
  return self;
}

- copy_clipboard:(guint32) time
{
  gtk_editable_copy_clipboard(gtkeditable, time);
  return self;
}

- paste_clipboard:(guint32) time
{
  gtk_editable_paste_clipboard(gtkeditable, time);
  return self;
}

- claim_selection:(gboolean) claim :(guint32) time
{
  gtk_editable_claim_selection(gtkeditable, claim, time);
  return self;
}

- delete_selection
{
  gtk_editable_delete_selection(gtkeditable);
  return self;
}

- changed
{
  gtk_editable_changed(gtkeditable);
  return self;
}
@end
