/* math-preferences.c generated by valac 0.20.1, the Vala compiler
 * generated from math-preferences.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>


#define TYPE_MATH_PREFERENCES_DIALOG (math_preferences_dialog_get_type ())
#define MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog))
#define MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))
#define IS_MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_PREFERENCES_DIALOG))
#define IS_MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_PREFERENCES_DIALOG))
#define MATH_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))

typedef struct _MathPreferencesDialog MathPreferencesDialog;
typedef struct _MathPreferencesDialogClass MathPreferencesDialogClass;
typedef struct _MathPreferencesDialogPrivate MathPreferencesDialogPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

struct _MathPreferencesDialog {
	GtkDialog parent_instance;
	MathPreferencesDialogPrivate * priv;
};

struct _MathPreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _MathPreferencesDialogPrivate {
	MathEquation* equation;
	GtkComboBox* angle_unit_combo;
	GtkComboBox* number_format_combo;
	GtkComboBox* word_size_combo;
	GtkSpinButton* decimal_places_spin;
	GtkCheckButton* thousands_separator_check;
	GtkCheckButton* trailing_zeroes_check;
};

struct _Block1Data {
	int _ref_count_;
	MathPreferencesDialog * self;
	MathEquation* equation;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;


static gpointer math_preferences_dialog_parent_class = NULL;

GType math_preferences_dialog_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
#define MATH_PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogPrivate))
enum  {
	MATH_PREFERENCES_DIALOG_DUMMY_PROPERTY
};
MathPreferencesDialog* math_preferences_dialog_new (MathEquation* equation);
MathPreferencesDialog* math_preferences_dialog_construct (GType object_type, MathEquation* equation);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void math_preferences_dialog_number_format_combo_changed_cb (MathPreferencesDialog* self, GtkComboBox* combo);
static void _math_preferences_dialog_number_format_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
GType display_format_get_type (void) G_GNUC_CONST;
static void __lambda31_ (Block1Data* _data1_);
void math_equation_set_accuracy (MathEquation* self, gint value);
static void ___lambda31__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void __lambda32_ (Block1Data* _data1_);
void math_equation_set_show_trailing_zeroes (MathEquation* self, gboolean value);
static void ___lambda32__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void __lambda33_ (Block1Data* _data1_);
void math_equation_set_show_thousands_separators (MathEquation* self, gboolean value);
static void ___lambda33__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void math_preferences_dialog_angle_unit_combo_changed_cb (MathPreferencesDialog* self, GtkComboBox* combo);
static void _math_preferences_dialog_angle_unit_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
GType angle_unit_get_type (void) G_GNUC_CONST;
static void math_preferences_dialog_word_size_combo_changed_cb (MathPreferencesDialog* self, GtkComboBox* combo);
static void _math_preferences_dialog_word_size_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
gint math_equation_get_accuracy (MathEquation* self);
static void __lambda34_ (Block1Data* _data1_, GParamSpec* pspec);
static void ___lambda34__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean math_equation_get_show_thousands_separators (MathEquation* self);
static void __lambda35_ (Block1Data* _data1_);
static void ___lambda35__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean math_equation_get_show_trailing_zeroes (MathEquation* self);
static void __lambda36_ (Block1Data* _data1_);
static void ___lambda36__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_preferences_dialog_set_combo_box_from_int (MathPreferencesDialog* self, GtkComboBox* combo, gint value);
DisplayFormat math_equation_get_number_format (MathEquation* self);
static void __lambda37_ (Block1Data* _data1_, GParamSpec* pspec);
static void ___lambda37__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gint math_equation_get_word_size (MathEquation* self);
static void __lambda38_ (Block1Data* _data1_, GParamSpec* pspec);
static void ___lambda38__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
AngleUnit math_equation_get_angle_units (MathEquation* self);
static void __lambda39_ (Block1Data* _data1_, GParamSpec* pspec);
static void ___lambda39__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_preferences_dialog_real_response (GtkDialog* base, gint id);
static gboolean math_preferences_dialog_real_delete_event (GtkWidget* base, GdkEventAny* event);
void math_equation_set_number_format (MathEquation* self, DisplayFormat value);
void math_equation_set_angle_units (MathEquation* self, AngleUnit value);
void math_equation_set_word_size (MathEquation* self, gint value);
static void math_preferences_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		MathPreferencesDialog * self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->equation);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _math_preferences_dialog_number_format_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_preferences_dialog_number_format_combo_changed_cb (self, _sender);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda31_ (Block1Data* _data1_) {
	MathPreferencesDialog * self;
	MathEquation* _tmp0_;
	GtkSpinButton* _tmp1_;
	gint _tmp2_ = 0;
	self = _data1_->self;
	_tmp0_ = _data1_->equation;
	_tmp1_ = self->priv->decimal_places_spin;
	_tmp2_ = gtk_spin_button_get_value_as_int (_tmp1_);
	math_equation_set_accuracy (_tmp0_, _tmp2_);
}


static void ___lambda31__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	__lambda31_ (self);
}


static void __lambda32_ (Block1Data* _data1_) {
	MathPreferencesDialog * self;
	MathEquation* _tmp0_;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = _data1_->self;
	_tmp0_ = _data1_->equation;
	_tmp1_ = self->priv->trailing_zeroes_check;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	math_equation_set_show_trailing_zeroes (_tmp0_, _tmp2_);
}


static void ___lambda32__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda32_ (self);
}


static void __lambda33_ (Block1Data* _data1_) {
	MathPreferencesDialog * self;
	MathEquation* _tmp0_;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = _data1_->self;
	_tmp0_ = _data1_->equation;
	_tmp1_ = self->priv->thousands_separator_check;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	math_equation_set_show_thousands_separators (_tmp0_, _tmp2_);
}


static void ___lambda33__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda33_ (self);
}


static void _math_preferences_dialog_angle_unit_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_preferences_dialog_angle_unit_combo_changed_cb (self, _sender);
}


static void _math_preferences_dialog_word_size_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_preferences_dialog_word_size_combo_changed_cb (self, _sender);
}


static void __lambda34_ (Block1Data* _data1_, GParamSpec* pspec) {
	MathPreferencesDialog * self;
	GtkSpinButton* _tmp0_;
	MathEquation* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = _data1_->self;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->decimal_places_spin;
	_tmp1_ = _data1_->equation;
	_tmp2_ = math_equation_get_accuracy (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_spin_button_set_value (_tmp0_, (gdouble) _tmp3_);
}


static void ___lambda34__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda34_ (self, pspec);
}


static void __lambda35_ (Block1Data* _data1_) {
	MathPreferencesDialog * self;
	GtkCheckButton* _tmp0_;
	MathEquation* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data1_->self;
	_tmp0_ = self->priv->thousands_separator_check;
	_tmp1_ = _data1_->equation;
	_tmp2_ = math_equation_get_show_thousands_separators (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, _tmp3_);
}


static void ___lambda35__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda35_ (self);
}


static void __lambda36_ (Block1Data* _data1_) {
	MathPreferencesDialog * self;
	GtkCheckButton* _tmp0_;
	MathEquation* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data1_->self;
	_tmp0_ = self->priv->trailing_zeroes_check;
	_tmp1_ = _data1_->equation;
	_tmp2_ = math_equation_get_show_trailing_zeroes (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, _tmp3_);
}


static void ___lambda36__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda36_ (self);
}


static void __lambda37_ (Block1Data* _data1_, GParamSpec* pspec) {
	MathPreferencesDialog * self;
	GtkComboBox* _tmp0_;
	MathEquation* _tmp1_;
	DisplayFormat _tmp2_;
	DisplayFormat _tmp3_;
	self = _data1_->self;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->number_format_combo;
	_tmp1_ = _data1_->equation;
	_tmp2_ = math_equation_get_number_format (_tmp1_);
	_tmp3_ = _tmp2_;
	math_preferences_dialog_set_combo_box_from_int (self, _tmp0_, (gint) _tmp3_);
}


static void ___lambda37__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda37_ (self, pspec);
}


static void __lambda38_ (Block1Data* _data1_, GParamSpec* pspec) {
	MathPreferencesDialog * self;
	GtkComboBox* _tmp0_;
	MathEquation* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = _data1_->self;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->word_size_combo;
	_tmp1_ = _data1_->equation;
	_tmp2_ = math_equation_get_word_size (_tmp1_);
	_tmp3_ = _tmp2_;
	math_preferences_dialog_set_combo_box_from_int (self, _tmp0_, _tmp3_);
}


static void ___lambda38__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda38_ (self, pspec);
}


static void __lambda39_ (Block1Data* _data1_, GParamSpec* pspec) {
	MathPreferencesDialog * self;
	GtkComboBox* _tmp0_;
	MathEquation* _tmp1_;
	AngleUnit _tmp2_;
	AngleUnit _tmp3_;
	self = _data1_->self;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->angle_unit_combo;
	_tmp1_ = _data1_->equation;
	_tmp2_ = math_equation_get_angle_units (_tmp1_);
	_tmp3_ = _tmp2_;
	math_preferences_dialog_set_combo_box_from_int (self, _tmp0_, (gint) _tmp3_);
}


static void ___lambda39__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda39_ (self, pspec);
}


MathPreferencesDialog* math_preferences_dialog_construct (GType object_type, MathEquation* equation) {
	MathPreferencesDialog * self = NULL;
	Block1Data* _data1_;
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	MathEquation* _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkGrid* _tmp6_;
	GtkGrid* grid;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkBox* _tmp11_ = NULL;
	GtkGrid* _tmp12_;
	const gchar* _tmp13_ = NULL;
	GtkLabel* _tmp14_;
	GtkLabel* label;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkGrid* _tmp17_;
	GtkLabel* _tmp18_;
	GtkComboBox* _tmp19_;
	GtkLabel* _tmp20_;
	GtkComboBox* _tmp21_;
	GtkComboBox* _tmp22_;
	GtkComboBox* _tmp23_;
	GtkGrid* _tmp24_;
	GtkComboBox* _tmp25_;
	GtkListStore* _tmp26_;
	GtkListStore* model;
	GtkComboBox* _tmp27_;
	GtkListStore* _tmp28_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp29_;
	GtkTreeIter _tmp30_ = {0};
	GtkListStore* _tmp31_;
	GtkTreeIter _tmp32_;
	const gchar* _tmp33_ = NULL;
	GtkListStore* _tmp34_;
	GtkTreeIter _tmp35_ = {0};
	GtkListStore* _tmp36_;
	GtkTreeIter _tmp37_;
	const gchar* _tmp38_ = NULL;
	GtkListStore* _tmp39_;
	GtkTreeIter _tmp40_ = {0};
	GtkListStore* _tmp41_;
	GtkTreeIter _tmp42_;
	const gchar* _tmp43_ = NULL;
	GtkListStore* _tmp44_;
	GtkTreeIter _tmp45_ = {0};
	GtkListStore* _tmp46_;
	GtkTreeIter _tmp47_;
	const gchar* _tmp48_ = NULL;
	GtkCellRendererText* _tmp49_;
	GtkCellRendererText* renderer;
	GtkComboBox* _tmp50_;
	GtkCellRendererText* _tmp51_;
	GtkComboBox* _tmp52_;
	GtkCellRendererText* _tmp53_;
	GtkAlignment* _tmp54_;
	GtkAlignment* alignment;
	GtkAlignment* _tmp55_;
	GtkAlignment* _tmp56_;
	GtkAlignment* _tmp57_;
	GtkGrid* _tmp58_;
	GtkAlignment* _tmp59_;
	GtkBox* _tmp60_;
	GtkBox* format_options_box;
	GtkBox* _tmp61_;
	GtkAlignment* _tmp62_;
	GtkBox* _tmp63_;
	GtkBox* _tmp64_;
	GtkBox* places_box;
	GtkBox* _tmp65_;
	GtkBox* _tmp66_;
	GtkBox* _tmp67_;
	const gchar* _tmp68_ = NULL;
	gchar* _tmp69_;
	gchar* string;
	const gchar* _tmp70_;
	gchar** _tmp71_;
	gchar** _tmp72_ = NULL;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	GtkAdjustment* _tmp73_;
	GtkAdjustment* decimal_places_adjustment;
	GtkAdjustment* _tmp74_;
	GtkSpinButton* _tmp75_;
	gchar** _tmp76_;
	gint _tmp76__length1;
	GtkSpinButton* _tmp87_;
	GtkSpinButton* _tmp88_;
	GtkBox* _tmp89_;
	GtkSpinButton* _tmp90_;
	gchar** _tmp91_;
	gint _tmp91__length1;
	const gchar* _tmp102_ = NULL;
	GtkCheckButton* _tmp103_;
	GtkCheckButton* _tmp104_;
	GtkCheckButton* _tmp105_;
	GtkBox* _tmp106_;
	GtkCheckButton* _tmp107_;
	const gchar* _tmp108_ = NULL;
	GtkCheckButton* _tmp109_;
	GtkCheckButton* _tmp110_;
	GtkCheckButton* _tmp111_;
	GtkBox* _tmp112_;
	GtkCheckButton* _tmp113_;
	const gchar* _tmp114_ = NULL;
	GtkLabel* _tmp115_;
	GtkLabel* _tmp116_;
	GtkLabel* _tmp117_;
	GtkGrid* _tmp118_;
	GtkLabel* _tmp119_;
	GtkComboBox* _tmp120_;
	GtkLabel* _tmp121_;
	GtkComboBox* _tmp122_;
	GtkComboBox* _tmp123_;
	GtkComboBox* _tmp124_;
	GtkGrid* _tmp125_;
	GtkComboBox* _tmp126_;
	GtkListStore* _tmp127_;
	GtkComboBox* _tmp128_;
	GtkListStore* _tmp129_;
	GtkListStore* _tmp130_;
	GtkTreeIter _tmp131_ = {0};
	GtkListStore* _tmp132_;
	GtkTreeIter _tmp133_;
	const gchar* _tmp134_ = NULL;
	GtkListStore* _tmp135_;
	GtkTreeIter _tmp136_ = {0};
	GtkListStore* _tmp137_;
	GtkTreeIter _tmp138_;
	const gchar* _tmp139_ = NULL;
	GtkListStore* _tmp140_;
	GtkTreeIter _tmp141_ = {0};
	GtkListStore* _tmp142_;
	GtkTreeIter _tmp143_;
	const gchar* _tmp144_ = NULL;
	GtkCellRendererText* _tmp145_;
	GtkComboBox* _tmp146_;
	GtkCellRendererText* _tmp147_;
	GtkComboBox* _tmp148_;
	GtkCellRendererText* _tmp149_;
	const gchar* _tmp150_ = NULL;
	GtkLabel* _tmp151_;
	GtkLabel* _tmp152_;
	GtkLabel* _tmp153_;
	GtkGrid* _tmp154_;
	GtkLabel* _tmp155_;
	GtkComboBox* _tmp156_;
	GtkLabel* _tmp157_;
	GtkComboBox* _tmp158_;
	GtkComboBox* _tmp159_;
	GtkComboBox* _tmp160_;
	GtkGrid* _tmp161_;
	GtkComboBox* _tmp162_;
	GtkListStore* _tmp163_;
	GtkComboBox* _tmp164_;
	GtkListStore* _tmp165_;
	GtkListStore* _tmp166_;
	GtkTreeIter _tmp167_ = {0};
	GtkListStore* _tmp168_;
	GtkTreeIter _tmp169_;
	const gchar* _tmp170_ = NULL;
	GtkListStore* _tmp171_;
	GtkTreeIter _tmp172_ = {0};
	GtkListStore* _tmp173_;
	GtkTreeIter _tmp174_;
	const gchar* _tmp175_ = NULL;
	GtkListStore* _tmp176_;
	GtkTreeIter _tmp177_ = {0};
	GtkListStore* _tmp178_;
	GtkTreeIter _tmp179_;
	const gchar* _tmp180_ = NULL;
	GtkListStore* _tmp181_;
	GtkTreeIter _tmp182_ = {0};
	GtkListStore* _tmp183_;
	GtkTreeIter _tmp184_;
	const gchar* _tmp185_ = NULL;
	GtkCellRendererText* _tmp186_;
	GtkComboBox* _tmp187_;
	GtkCellRendererText* _tmp188_;
	GtkComboBox* _tmp189_;
	GtkCellRendererText* _tmp190_;
	GtkSpinButton* _tmp191_;
	MathEquation* _tmp192_;
	gint _tmp193_;
	gint _tmp194_;
	MathEquation* _tmp195_;
	GtkCheckButton* _tmp196_;
	MathEquation* _tmp197_;
	gboolean _tmp198_;
	gboolean _tmp199_;
	MathEquation* _tmp200_;
	GtkCheckButton* _tmp201_;
	MathEquation* _tmp202_;
	gboolean _tmp203_;
	gboolean _tmp204_;
	MathEquation* _tmp205_;
	GtkComboBox* _tmp206_;
	MathEquation* _tmp207_;
	DisplayFormat _tmp208_;
	DisplayFormat _tmp209_;
	MathEquation* _tmp210_;
	GtkComboBox* _tmp211_;
	MathEquation* _tmp212_;
	gint _tmp213_;
	gint _tmp214_;
	MathEquation* _tmp215_;
	GtkComboBox* _tmp216_;
	MathEquation* _tmp217_;
	AngleUnit _tmp218_;
	AngleUnit _tmp219_;
	MathEquation* _tmp220_;
	g_return_val_if_fail (equation != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data1_->equation);
	_data1_->equation = _tmp1_;
	self = (MathPreferencesDialog*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	_tmp2_ = _data1_->equation;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->equation);
	self->priv->equation = _tmp3_;
	_tmp4_ = _ ("Preferences");
	gtk_window_set_title ((GtkWindow*) self, _tmp4_);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 8);
	_tmp5_ = _ ("_Close");
	gtk_dialog_add_button ((GtkDialog*) self, _tmp5_, 0);
	_tmp6_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp6_);
	grid = _tmp6_;
	_tmp7_ = grid;
	gtk_widget_show ((GtkWidget*) _tmp7_);
	_tmp8_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp8_, (guint) 5);
	_tmp9_ = grid;
	gtk_grid_set_column_spacing (_tmp9_, 6);
	_tmp10_ = grid;
	gtk_grid_set_row_spacing (_tmp10_, 12);
	_tmp11_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp12_ = grid;
	gtk_box_pack_start (_tmp11_, (GtkWidget*) _tmp12_, TRUE, TRUE, (guint) 0);
	_tmp13_ = _ ("Number _Format:");
	_tmp14_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp13_);
	g_object_ref_sink (_tmp14_);
	label = _tmp14_;
	_tmp15_ = label;
	gtk_widget_show ((GtkWidget*) _tmp15_);
	_tmp16_ = label;
	g_object_set ((GtkMisc*) _tmp16_, "xalign", (gfloat) 0, NULL);
	_tmp17_ = grid;
	_tmp18_ = label;
	gtk_grid_attach (_tmp17_, (GtkWidget*) _tmp18_, 0, 0, 1, 1);
	_tmp19_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->number_format_combo);
	self->priv->number_format_combo = _tmp19_;
	_tmp20_ = label;
	_tmp21_ = self->priv->number_format_combo;
	gtk_label_set_mnemonic_widget (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = self->priv->number_format_combo;
	gtk_widget_show ((GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->number_format_combo;
	g_signal_connect_object (_tmp23_, "changed", (GCallback) _math_preferences_dialog_number_format_combo_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp24_ = grid;
	_tmp25_ = self->priv->number_format_combo;
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 1, 0, 1, 1);
	_tmp26_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	model = _tmp26_;
	_tmp27_ = self->priv->number_format_combo;
	_tmp28_ = model;
	gtk_combo_box_set_model (_tmp27_, (GtkTreeModel*) _tmp28_);
	_tmp29_ = model;
	gtk_list_store_append (_tmp29_, &_tmp30_);
	iter = _tmp30_;
	_tmp31_ = model;
	_tmp32_ = iter;
	_tmp33_ = _ ("Automatic");
	gtk_list_store_set (_tmp31_, &_tmp32_, 0, _tmp33_, 1, DISPLAY_FORMAT_AUTOMATIC, -1, -1);
	_tmp34_ = model;
	gtk_list_store_append (_tmp34_, &_tmp35_);
	iter = _tmp35_;
	_tmp36_ = model;
	_tmp37_ = iter;
	_tmp38_ = _ ("Fixed");
	gtk_list_store_set (_tmp36_, &_tmp37_, 0, _tmp38_, 1, DISPLAY_FORMAT_FIXED, -1, -1);
	_tmp39_ = model;
	gtk_list_store_append (_tmp39_, &_tmp40_);
	iter = _tmp40_;
	_tmp41_ = model;
	_tmp42_ = iter;
	_tmp43_ = _ ("Scientific");
	gtk_list_store_set (_tmp41_, &_tmp42_, 0, _tmp43_, 1, DISPLAY_FORMAT_SCIENTIFIC, -1, -1);
	_tmp44_ = model;
	gtk_list_store_append (_tmp44_, &_tmp45_);
	iter = _tmp45_;
	_tmp46_ = model;
	_tmp47_ = iter;
	_tmp48_ = _ ("Engineering");
	gtk_list_store_set (_tmp46_, &_tmp47_, 0, _tmp48_, 1, DISPLAY_FORMAT_ENGINEERING, -1, -1);
	_tmp49_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp49_);
	renderer = _tmp49_;
	_tmp50_ = self->priv->number_format_combo;
	_tmp51_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp50_, (GtkCellRenderer*) _tmp51_, TRUE);
	_tmp52_ = self->priv->number_format_combo;
	_tmp53_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp52_, (GtkCellRenderer*) _tmp53_, "text", 0);
	_tmp54_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 1.0f, 1.0f);
	g_object_ref_sink (_tmp54_);
	alignment = _tmp54_;
	_tmp55_ = alignment;
	g_object_set (_tmp55_, "bottom-padding", (guint) 6, NULL);
	_tmp56_ = alignment;
	g_object_set (_tmp56_, "left-padding", (guint) 12, NULL);
	_tmp57_ = alignment;
	gtk_widget_show ((GtkWidget*) _tmp57_);
	_tmp58_ = grid;
	_tmp59_ = alignment;
	gtk_grid_attach (_tmp58_, (GtkWidget*) _tmp59_, 0, 1, 2, 1);
	_tmp60_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp60_);
	format_options_box = _tmp60_;
	_tmp61_ = format_options_box;
	gtk_widget_show ((GtkWidget*) _tmp61_);
	_tmp62_ = alignment;
	_tmp63_ = format_options_box;
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp64_);
	places_box = _tmp64_;
	_tmp65_ = places_box;
	gtk_widget_show ((GtkWidget*) _tmp65_);
	_tmp66_ = format_options_box;
	_tmp67_ = places_box;
	gtk_box_pack_start (_tmp66_, (GtkWidget*) _tmp67_, FALSE, FALSE, (guint) 0);
	_tmp68_ = _ ("Show %d decimal _places");
	_tmp69_ = g_strdup (_tmp68_);
	string = _tmp69_;
	_tmp70_ = string;
	_tmp72_ = _tmp71_ = g_strsplit (_tmp70_, "%d", 2);
	tokens = _tmp72_;
	tokens_length1 = _vala_array_length (_tmp71_);
	_tokens_size_ = tokens_length1;
	_tmp73_ = gtk_adjustment_new (0.0, 0.0, 9.0, 1.0, 1.0, 0.0);
	g_object_ref_sink (_tmp73_);
	decimal_places_adjustment = _tmp73_;
	_tmp74_ = decimal_places_adjustment;
	_tmp75_ = (GtkSpinButton*) gtk_spin_button_new (_tmp74_, 0.0, (guint) 0);
	g_object_ref_sink (_tmp75_);
	_g_object_unref0 (self->priv->decimal_places_spin);
	self->priv->decimal_places_spin = _tmp75_;
	_tmp76_ = tokens;
	_tmp76__length1 = tokens_length1;
	if (_tmp76__length1 > 0) {
		gchar** _tmp77_;
		gint _tmp77__length1;
		const gchar* _tmp78_;
		gchar* _tmp79_ = NULL;
		gchar* _tmp80_;
		GtkLabel* _tmp81_;
		GtkLabel* _tmp82_;
		GtkSpinButton* _tmp83_;
		GtkLabel* _tmp84_;
		GtkBox* _tmp85_;
		GtkLabel* _tmp86_;
		_tmp77_ = tokens;
		_tmp77__length1 = tokens_length1;
		_tmp78_ = _tmp77_[0];
		_tmp79_ = string_strip (_tmp78_);
		_tmp80_ = _tmp79_;
		_tmp81_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp80_);
		g_object_ref_sink (_tmp81_);
		_g_object_unref0 (label);
		label = _tmp81_;
		_g_free0 (_tmp80_);
		_tmp82_ = label;
		_tmp83_ = self->priv->decimal_places_spin;
		gtk_label_set_mnemonic_widget (_tmp82_, (GtkWidget*) _tmp83_);
		_tmp84_ = label;
		gtk_widget_show ((GtkWidget*) _tmp84_);
		_tmp85_ = places_box;
		_tmp86_ = label;
		gtk_box_pack_start (_tmp85_, (GtkWidget*) _tmp86_, FALSE, FALSE, (guint) 0);
	}
	_tmp87_ = self->priv->decimal_places_spin;
	gtk_widget_show ((GtkWidget*) _tmp87_);
	_tmp88_ = self->priv->decimal_places_spin;
	g_signal_connect_data (_tmp88_, "value-changed", (GCallback) ___lambda31__gtk_spin_button_value_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp89_ = places_box;
	_tmp90_ = self->priv->decimal_places_spin;
	gtk_box_pack_start (_tmp89_, (GtkWidget*) _tmp90_, FALSE, FALSE, (guint) 0);
	_tmp91_ = tokens;
	_tmp91__length1 = tokens_length1;
	if (_tmp91__length1 == 2) {
		gchar** _tmp92_;
		gint _tmp92__length1;
		const gchar* _tmp93_;
		gchar* _tmp94_ = NULL;
		gchar* _tmp95_;
		GtkLabel* _tmp96_;
		GtkLabel* _tmp97_;
		GtkSpinButton* _tmp98_;
		GtkLabel* _tmp99_;
		GtkBox* _tmp100_;
		GtkLabel* _tmp101_;
		_tmp92_ = tokens;
		_tmp92__length1 = tokens_length1;
		_tmp93_ = _tmp92_[1];
		_tmp94_ = string_strip (_tmp93_);
		_tmp95_ = _tmp94_;
		_tmp96_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp95_);
		g_object_ref_sink (_tmp96_);
		_g_object_unref0 (label);
		label = _tmp96_;
		_g_free0 (_tmp95_);
		_tmp97_ = label;
		_tmp98_ = self->priv->decimal_places_spin;
		gtk_label_set_mnemonic_widget (_tmp97_, (GtkWidget*) _tmp98_);
		_tmp99_ = label;
		gtk_widget_show ((GtkWidget*) _tmp99_);
		_tmp100_ = places_box;
		_tmp101_ = label;
		gtk_box_pack_start (_tmp100_, (GtkWidget*) _tmp101_, FALSE, FALSE, (guint) 0);
	}
	_tmp102_ = _ ("Show trailing _zeroes");
	_tmp103_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp102_);
	g_object_ref_sink (_tmp103_);
	_g_object_unref0 (self->priv->trailing_zeroes_check);
	self->priv->trailing_zeroes_check = _tmp103_;
	_tmp104_ = self->priv->trailing_zeroes_check;
	gtk_widget_show ((GtkWidget*) _tmp104_);
	_tmp105_ = self->priv->trailing_zeroes_check;
	g_signal_connect_data ((GtkToggleButton*) _tmp105_, "toggled", (GCallback) ___lambda32__gtk_toggle_button_toggled, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp106_ = format_options_box;
	_tmp107_ = self->priv->trailing_zeroes_check;
	gtk_box_pack_start (_tmp106_, (GtkWidget*) _tmp107_, FALSE, FALSE, (guint) 0);
	_tmp108_ = _ ("Show _thousands separators");
	_tmp109_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp108_);
	g_object_ref_sink (_tmp109_);
	_g_object_unref0 (self->priv->thousands_separator_check);
	self->priv->thousands_separator_check = _tmp109_;
	_tmp110_ = self->priv->thousands_separator_check;
	gtk_widget_show ((GtkWidget*) _tmp110_);
	_tmp111_ = self->priv->thousands_separator_check;
	g_signal_connect_data ((GtkToggleButton*) _tmp111_, "toggled", (GCallback) ___lambda33__gtk_toggle_button_toggled, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp112_ = format_options_box;
	_tmp113_ = self->priv->thousands_separator_check;
	gtk_box_pack_start (_tmp112_, (GtkWidget*) _tmp113_, FALSE, FALSE, (guint) 0);
	_tmp114_ = _ ("_Angle units:");
	_tmp115_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp114_);
	g_object_ref_sink (_tmp115_);
	_g_object_unref0 (label);
	label = _tmp115_;
	_tmp116_ = label;
	gtk_widget_show ((GtkWidget*) _tmp116_);
	_tmp117_ = label;
	g_object_set ((GtkMisc*) _tmp117_, "xalign", (gfloat) 0, NULL);
	_tmp118_ = grid;
	_tmp119_ = label;
	gtk_grid_attach (_tmp118_, (GtkWidget*) _tmp119_, 0, 2, 1, 1);
	_tmp120_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp120_);
	_g_object_unref0 (self->priv->angle_unit_combo);
	self->priv->angle_unit_combo = _tmp120_;
	_tmp121_ = label;
	_tmp122_ = self->priv->angle_unit_combo;
	gtk_label_set_mnemonic_widget (_tmp121_, (GtkWidget*) _tmp122_);
	_tmp123_ = self->priv->angle_unit_combo;
	gtk_widget_show ((GtkWidget*) _tmp123_);
	_tmp124_ = self->priv->angle_unit_combo;
	g_signal_connect_object (_tmp124_, "changed", (GCallback) _math_preferences_dialog_angle_unit_combo_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp125_ = grid;
	_tmp126_ = self->priv->angle_unit_combo;
	gtk_grid_attach (_tmp125_, (GtkWidget*) _tmp126_, 1, 2, 1, 1);
	_tmp127_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (model);
	model = _tmp127_;
	_tmp128_ = self->priv->angle_unit_combo;
	_tmp129_ = model;
	gtk_combo_box_set_model (_tmp128_, (GtkTreeModel*) _tmp129_);
	_tmp130_ = model;
	gtk_list_store_append (_tmp130_, &_tmp131_);
	iter = _tmp131_;
	_tmp132_ = model;
	_tmp133_ = iter;
	_tmp134_ = _ ("Degrees");
	gtk_list_store_set (_tmp132_, &_tmp133_, 0, _tmp134_, 1, ANGLE_UNIT_DEGREES, -1, -1);
	_tmp135_ = model;
	gtk_list_store_append (_tmp135_, &_tmp136_);
	iter = _tmp136_;
	_tmp137_ = model;
	_tmp138_ = iter;
	_tmp139_ = _ ("Radians");
	gtk_list_store_set (_tmp137_, &_tmp138_, 0, _tmp139_, 1, ANGLE_UNIT_RADIANS, -1, -1);
	_tmp140_ = model;
	gtk_list_store_append (_tmp140_, &_tmp141_);
	iter = _tmp141_;
	_tmp142_ = model;
	_tmp143_ = iter;
	_tmp144_ = _ ("Gradians");
	gtk_list_store_set (_tmp142_, &_tmp143_, 0, _tmp144_, 1, ANGLE_UNIT_GRADIANS, -1, -1);
	_tmp145_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp145_);
	_g_object_unref0 (renderer);
	renderer = _tmp145_;
	_tmp146_ = self->priv->angle_unit_combo;
	_tmp147_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp146_, (GtkCellRenderer*) _tmp147_, TRUE);
	_tmp148_ = self->priv->angle_unit_combo;
	_tmp149_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp148_, (GtkCellRenderer*) _tmp149_, "text", 0);
	_tmp150_ = _ ("Word _size:");
	_tmp151_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp150_);
	g_object_ref_sink (_tmp151_);
	_g_object_unref0 (label);
	label = _tmp151_;
	_tmp152_ = label;
	gtk_widget_show ((GtkWidget*) _tmp152_);
	_tmp153_ = label;
	g_object_set ((GtkMisc*) _tmp153_, "xalign", (gfloat) 0, NULL);
	_tmp154_ = grid;
	_tmp155_ = label;
	gtk_grid_attach (_tmp154_, (GtkWidget*) _tmp155_, 0, 3, 1, 1);
	_tmp156_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp156_);
	_g_object_unref0 (self->priv->word_size_combo);
	self->priv->word_size_combo = _tmp156_;
	_tmp157_ = label;
	_tmp158_ = self->priv->word_size_combo;
	gtk_label_set_mnemonic_widget (_tmp157_, (GtkWidget*) _tmp158_);
	_tmp159_ = self->priv->word_size_combo;
	gtk_widget_show ((GtkWidget*) _tmp159_);
	_tmp160_ = self->priv->word_size_combo;
	g_signal_connect_object (_tmp160_, "changed", (GCallback) _math_preferences_dialog_word_size_combo_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp161_ = grid;
	_tmp162_ = self->priv->word_size_combo;
	gtk_grid_attach (_tmp161_, (GtkWidget*) _tmp162_, 1, 3, 1, 1);
	_tmp163_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (model);
	model = _tmp163_;
	_tmp164_ = self->priv->word_size_combo;
	_tmp165_ = model;
	gtk_combo_box_set_model (_tmp164_, (GtkTreeModel*) _tmp165_);
	_tmp166_ = model;
	gtk_list_store_append (_tmp166_, &_tmp167_);
	iter = _tmp167_;
	_tmp168_ = model;
	_tmp169_ = iter;
	_tmp170_ = _ ("8 bits");
	gtk_list_store_set (_tmp168_, &_tmp169_, 0, _tmp170_, 1, 8, -1);
	_tmp171_ = model;
	gtk_list_store_append (_tmp171_, &_tmp172_);
	iter = _tmp172_;
	_tmp173_ = model;
	_tmp174_ = iter;
	_tmp175_ = _ ("16 bits");
	gtk_list_store_set (_tmp173_, &_tmp174_, 0, _tmp175_, 1, 16, -1);
	_tmp176_ = model;
	gtk_list_store_append (_tmp176_, &_tmp177_);
	iter = _tmp177_;
	_tmp178_ = model;
	_tmp179_ = iter;
	_tmp180_ = _ ("32 bits");
	gtk_list_store_set (_tmp178_, &_tmp179_, 0, _tmp180_, 1, 32, -1);
	_tmp181_ = model;
	gtk_list_store_append (_tmp181_, &_tmp182_);
	iter = _tmp182_;
	_tmp183_ = model;
	_tmp184_ = iter;
	_tmp185_ = _ ("64 bits");
	gtk_list_store_set (_tmp183_, &_tmp184_, 0, _tmp185_, 1, 64, -1);
	_tmp186_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp186_);
	_g_object_unref0 (renderer);
	renderer = _tmp186_;
	_tmp187_ = self->priv->word_size_combo;
	_tmp188_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp187_, (GtkCellRenderer*) _tmp188_, TRUE);
	_tmp189_ = self->priv->word_size_combo;
	_tmp190_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp189_, (GtkCellRenderer*) _tmp190_, "text", 0);
	_tmp191_ = self->priv->decimal_places_spin;
	_tmp192_ = _data1_->equation;
	_tmp193_ = math_equation_get_accuracy (_tmp192_);
	_tmp194_ = _tmp193_;
	gtk_spin_button_set_value (_tmp191_, (gdouble) _tmp194_);
	_tmp195_ = _data1_->equation;
	g_signal_connect_data ((GObject*) _tmp195_, "notify::accuracy", (GCallback) ___lambda34__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp196_ = self->priv->thousands_separator_check;
	_tmp197_ = _data1_->equation;
	_tmp198_ = math_equation_get_show_thousands_separators (_tmp197_);
	_tmp199_ = _tmp198_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp196_, _tmp199_);
	_tmp200_ = _data1_->equation;
	g_signal_connect_data ((GObject*) _tmp200_, "notify::show-thousands-separators", (GCallback) ___lambda35__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp201_ = self->priv->trailing_zeroes_check;
	_tmp202_ = _data1_->equation;
	_tmp203_ = math_equation_get_show_trailing_zeroes (_tmp202_);
	_tmp204_ = _tmp203_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp201_, _tmp204_);
	_tmp205_ = _data1_->equation;
	g_signal_connect_data ((GObject*) _tmp205_, "notify::show-trailing_zeroes", (GCallback) ___lambda36__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp206_ = self->priv->number_format_combo;
	_tmp207_ = _data1_->equation;
	_tmp208_ = math_equation_get_number_format (_tmp207_);
	_tmp209_ = _tmp208_;
	math_preferences_dialog_set_combo_box_from_int (self, _tmp206_, (gint) _tmp209_);
	_tmp210_ = _data1_->equation;
	g_signal_connect_data ((GObject*) _tmp210_, "notify::number-format", (GCallback) ___lambda37__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp211_ = self->priv->word_size_combo;
	_tmp212_ = _data1_->equation;
	_tmp213_ = math_equation_get_word_size (_tmp212_);
	_tmp214_ = _tmp213_;
	math_preferences_dialog_set_combo_box_from_int (self, _tmp211_, _tmp214_);
	_tmp215_ = _data1_->equation;
	g_signal_connect_data ((GObject*) _tmp215_, "notify::word-size", (GCallback) ___lambda38__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp216_ = self->priv->angle_unit_combo;
	_tmp217_ = _data1_->equation;
	_tmp218_ = math_equation_get_angle_units (_tmp217_);
	_tmp219_ = _tmp218_;
	math_preferences_dialog_set_combo_box_from_int (self, _tmp216_, (gint) _tmp219_);
	_tmp220_ = _data1_->equation;
	g_signal_connect_data ((GObject*) _tmp220_, "notify::angle-units", (GCallback) ___lambda39__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_g_object_unref0 (decimal_places_adjustment);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (string);
	_g_object_unref0 (places_box);
	_g_object_unref0 (format_options_box);
	_g_object_unref0 (alignment);
	_g_object_unref0 (renderer);
	_g_object_unref0 (model);
	_g_object_unref0 (label);
	_g_object_unref0 (grid);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}


MathPreferencesDialog* math_preferences_dialog_new (MathEquation* equation) {
	return math_preferences_dialog_construct (TYPE_MATH_PREFERENCES_DIALOG, equation);
}


static void math_preferences_dialog_real_response (GtkDialog* base, gint id) {
	MathPreferencesDialog * self;
	self = (MathPreferencesDialog*) base;
	gtk_widget_hide ((GtkWidget*) self);
}


static gboolean math_preferences_dialog_real_delete_event (GtkWidget* base, GdkEventAny* event) {
	MathPreferencesDialog * self;
	gboolean result = FALSE;
	self = (MathPreferencesDialog*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_hide ((GtkWidget*) self);
	result = TRUE;
	return result;
}


static void math_preferences_dialog_number_format_combo_changed_cb (MathPreferencesDialog* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	DisplayFormat value = 0;
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	MathEquation* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &value, -1, -1);
	_tmp6_ = self->priv->equation;
	math_equation_set_number_format (_tmp6_, value);
}


static void math_preferences_dialog_angle_unit_combo_changed_cb (MathPreferencesDialog* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	AngleUnit value = 0;
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	MathEquation* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &value, -1, -1);
	_tmp6_ = self->priv->equation;
	math_equation_set_angle_units (_tmp6_, value);
}


static void math_preferences_dialog_word_size_combo_changed_cb (MathPreferencesDialog* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint value = 0;
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	MathEquation* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &value, -1, -1);
	_tmp6_ = self->priv->equation;
	math_equation_set_word_size (_tmp6_, value);
}


static void math_preferences_dialog_set_combo_box_from_int (MathPreferencesDialog* self, GtkComboBox* combo, gint value) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	gboolean valid;
	gboolean _tmp16_;
	GtkComboBox* _tmp22_;
	GtkTreeIter _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = gtk_tree_model_get_iter_first (_tmp2_, &_tmp3_);
	iter = _tmp3_;
	valid = _tmp4_;
	while (TRUE) {
		gboolean _tmp5_;
		gint v = 0;
		GtkComboBox* _tmp6_;
		GtkTreeModel* _tmp7_;
		GtkTreeModel* _tmp8_;
		GtkTreeIter _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		GtkComboBox* _tmp12_;
		GtkTreeModel* _tmp13_;
		GtkTreeModel* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp5_ = valid;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = combo;
		_tmp7_ = gtk_combo_box_get_model (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = iter;
		gtk_tree_model_get (_tmp8_, &_tmp9_, 1, &v, -1, -1);
		_tmp10_ = v;
		_tmp11_ = value;
		if (_tmp10_ == _tmp11_) {
			break;
		}
		_tmp12_ = combo;
		_tmp13_ = gtk_combo_box_get_model (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = gtk_tree_model_iter_next (_tmp14_, &iter);
		valid = _tmp15_;
	}
	_tmp16_ = valid;
	if (!_tmp16_) {
		GtkComboBox* _tmp17_;
		GtkTreeModel* _tmp18_;
		GtkTreeModel* _tmp19_;
		GtkTreeIter _tmp20_ = {0};
		gboolean _tmp21_ = FALSE;
		_tmp17_ = combo;
		_tmp18_ = gtk_combo_box_get_model (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp21_ = gtk_tree_model_get_iter_first (_tmp19_, &_tmp20_);
		iter = _tmp20_;
		valid = _tmp21_;
	}
	_tmp22_ = combo;
	_tmp23_ = iter;
	gtk_combo_box_set_active_iter (_tmp22_, &_tmp23_);
}


static void math_preferences_dialog_class_init (MathPreferencesDialogClass * klass) {
	math_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathPreferencesDialogPrivate));
	GTK_DIALOG_CLASS (klass)->response = math_preferences_dialog_real_response;
	GTK_WIDGET_CLASS (klass)->delete_event = math_preferences_dialog_real_delete_event;
	G_OBJECT_CLASS (klass)->finalize = math_preferences_dialog_finalize;
}


static void math_preferences_dialog_instance_init (MathPreferencesDialog * self) {
	self->priv = MATH_PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void math_preferences_dialog_finalize (GObject* obj) {
	MathPreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	_g_object_unref0 (self->priv->equation);
	_g_object_unref0 (self->priv->angle_unit_combo);
	_g_object_unref0 (self->priv->number_format_combo);
	_g_object_unref0 (self->priv->word_size_combo);
	_g_object_unref0 (self->priv->decimal_places_spin);
	_g_object_unref0 (self->priv->thousands_separator_check);
	_g_object_unref0 (self->priv->trailing_zeroes_check);
	G_OBJECT_CLASS (math_preferences_dialog_parent_class)->finalize (obj);
}


GType math_preferences_dialog_get_type (void) {
	static volatile gsize math_preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&math_preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathPreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathPreferencesDialog), 0, (GInstanceInitFunc) math_preferences_dialog_instance_init, NULL };
		GType math_preferences_dialog_type_id;
		math_preferences_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "MathPreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&math_preferences_dialog_type_id__volatile, math_preferences_dialog_type_id);
	}
	return math_preferences_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



