/* contacts-revealer.c generated by valac 0.19.0.2-fa647, the Vala compiler
 * generated from contacts-revealer.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>


#define CONTACTS_TYPE_REVEALER (contacts_revealer_get_type ())
#define CONTACTS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_REVEALER, ContactsRevealer))
#define CONTACTS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_REVEALER, ContactsRevealerClass))
#define CONTACTS_IS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_REVEALER))
#define CONTACTS_IS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_REVEALER))
#define CONTACTS_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_REVEALER, ContactsRevealerClass))

typedef struct _ContactsRevealer ContactsRevealer;
typedef struct _ContactsRevealerClass ContactsRevealerClass;
typedef struct _ContactsRevealerPrivate ContactsRevealerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ContactsRevealer {
	GtkBin parent_instance;
	ContactsRevealerPrivate * priv;
};

struct _ContactsRevealerClass {
	GtkBinClass parent_class;
};

struct _ContactsRevealerPrivate {
	GtkOrientation _orientation;
	gint _duration;
	GdkWindow* bin_window;
	GdkWindow* view_window;
	gdouble current_pos;
	gdouble source_pos;
	gdouble target_pos;
	guint timeout;
	gint64 start_time;
	gint64 end_time;
};


static gpointer contacts_revealer_parent_class = NULL;

gdouble transition_ease_out_quad (gdouble t, gdouble d);
GType contacts_revealer_get_type (void) G_GNUC_CONST;
#define CONTACTS_REVEALER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_REVEALER, ContactsRevealerPrivate))
enum  {
	CONTACTS_REVEALER_DUMMY_PROPERTY,
	CONTACTS_REVEALER_ORIENTATION,
	CONTACTS_REVEALER_DURATION
};
#define CONTACTS_REVEALER_frame_time 17
ContactsRevealer* contacts_revealer_new (void);
ContactsRevealer* contacts_revealer_construct (GType object_type);
static void contacts_revealer_get_child_allocation (ContactsRevealer* self, GtkAllocation* allocation, GtkAllocation* child_allocation);
GtkOrientation contacts_revealer_get_orientation (ContactsRevealer* self);
static void contacts_revealer_real_realize (GtkWidget* base);
static void contacts_revealer_real_unrealize (GtkWidget* base);
static void contacts_revealer_real_add (GtkContainer* base, GtkWidget* child);
static void contacts_revealer_real_style_updated (GtkWidget* base);
static void contacts_revealer_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static void contacts_revealer_set_amount (ContactsRevealer* self, gdouble amount);
static void contacts_revealer_animate_step (ContactsRevealer* self, gint64 now);
static gboolean contacts_revealer_animate_cb (ContactsRevealer* self);
static void contacts_revealer_start_animation (ContactsRevealer* self, gdouble target);
gint contacts_revealer_get_duration (ContactsRevealer* self);
static gboolean _contacts_revealer_animate_cb_gsource_func (gpointer self);
static void contacts_revealer_stop_animation (ContactsRevealer* self);
static void contacts_revealer_real_map (GtkWidget* base);
static void contacts_revealer_real_unmap (GtkWidget* base);
static gboolean contacts_revealer_real_draw (GtkWidget* base, cairo_t* cr);
void contacts_revealer_reveal (ContactsRevealer* self);
void contacts_revealer_unreveal (ContactsRevealer* self);
static void contacts_revealer_real_get_preferred_height (GtkWidget* base, gint* minimum_height, gint* natural_height);
static void contacts_revealer_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum_height, gint* natural_height);
static void contacts_revealer_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width);
static void contacts_revealer_real_get_preferred_width_for_height (GtkWidget* base, gint height, gint* minimum_width, gint* natural_width);
void contacts_revealer_set_orientation (ContactsRevealer* self, GtkOrientation value);
void contacts_revealer_set_duration (ContactsRevealer* self, gint value);
static void contacts_revealer_finalize (GObject* obj);
static void _vala_contacts_revealer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_contacts_revealer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gdouble transition_ease_out_quad (gdouble t, gdouble d) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble p;
	_tmp0_ = t;
	_tmp1_ = d;
	p = _tmp0_ / _tmp1_;
	result = ((-1.0) * p) * (p - 2);
	return result;
}


ContactsRevealer* contacts_revealer_construct (GType object_type) {
	ContactsRevealer * self = NULL;
	gdouble _tmp0_;
	self = (ContactsRevealer*) g_object_new (object_type, NULL);
	self->priv->current_pos = 0.0;
	_tmp0_ = self->priv->current_pos;
	self->priv->target_pos = _tmp0_;
	gtk_widget_set_has_window ((GtkWidget*) self, TRUE);
	gtk_widget_set_redraw_on_allocate ((GtkWidget*) self, FALSE);
	return self;
}


ContactsRevealer* contacts_revealer_new (void) {
	return contacts_revealer_construct (CONTACTS_TYPE_REVEALER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void contacts_revealer_get_child_allocation (ContactsRevealer* self, GtkAllocation* allocation, GtkAllocation* child_allocation) {
	GtkAllocation _vala_child_allocation = {0};
	GtkAllocation _tmp0_;
	gint _tmp1_;
	GtkAllocation _tmp2_;
	gint _tmp3_;
	GtkAllocation _tmp4_ = {0};
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_;
	GtkWidget* child;
	gboolean _tmp7_ = FALSE;
	GtkWidget* _tmp8_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	_tmp1_ = _tmp0_.width;
	_tmp2_ = *allocation;
	_tmp3_ = _tmp2_.height;
	_tmp4_.x = 0;
	_tmp4_.y = 0;
	_tmp4_.width = _tmp1_;
	_tmp4_.height = _tmp3_;
	_vala_child_allocation = _tmp4_;
	_tmp5_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	child = _tmp6_;
	_tmp8_ = child;
	if (_tmp8_ != NULL) {
		GtkWidget* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = child;
		_tmp10_ = gtk_widget_get_visible (_tmp9_);
		_tmp7_ = _tmp10_;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp11_ = _tmp7_;
	if (_tmp11_) {
		GtkOrientation _tmp12_;
		_tmp12_ = self->priv->_orientation;
		if (_tmp12_ == GTK_ORIENTATION_HORIZONTAL) {
			GtkWidget* _tmp13_;
			GtkAllocation _tmp14_;
			gint _tmp15_;
			gint _tmp16_ = 0;
			_tmp13_ = child;
			_tmp14_ = _vala_child_allocation;
			_tmp15_ = _tmp14_.width;
			gtk_widget_get_preferred_height_for_width (_tmp13_, _tmp15_, NULL, &_tmp16_);
			_vala_child_allocation.height = _tmp16_;
		} else {
			GtkWidget* _tmp17_;
			GtkAllocation _tmp18_;
			gint _tmp19_;
			gint _tmp20_ = 0;
			_tmp17_ = child;
			_tmp18_ = _vala_child_allocation;
			_tmp19_ = _tmp18_.height;
			gtk_widget_get_preferred_width_for_height (_tmp17_, _tmp19_, NULL, &_tmp20_);
			_vala_child_allocation.width = _tmp20_;
		}
	}
	_g_object_unref0 (child);
	if (child_allocation) {
		*child_allocation = _vala_child_allocation;
	}
}


static void contacts_revealer_real_realize (GtkWidget* base) {
	ContactsRevealer * self;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GdkWindowAttr _tmp1_ = {0};
	GdkWindowAttr attributes;
	GtkAllocation _tmp2_;
	gint _tmp3_;
	GtkAllocation _tmp4_;
	gint _tmp5_;
	GtkAllocation _tmp6_;
	gint _tmp7_;
	GtkAllocation _tmp8_;
	gint _tmp9_;
	GdkVisual* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GdkWindowAttributesType attributes_mask;
	GdkWindow* _tmp12_ = NULL;
	GdkWindowAttr _tmp13_;
	GdkWindowAttributesType _tmp14_;
	GdkWindow* _tmp15_;
	GdkWindow* _tmp16_;
	GdkWindow* _tmp17_;
	GdkWindow* _tmp18_;
	GtkAllocation _tmp19_ = {0};
	GtkAllocation child_allocation;
	GtkAllocation _tmp20_;
	GtkAllocation _tmp21_ = {0};
	GtkAllocation _tmp22_;
	gint _tmp23_;
	GtkAllocation _tmp24_;
	gint _tmp25_;
	GtkOrientation _tmp26_;
	GdkWindow* _tmp35_;
	GdkWindowAttr _tmp36_;
	GdkWindowAttributesType _tmp37_;
	GdkWindow* _tmp38_;
	GdkWindow* _tmp39_;
	GtkWidget* _tmp40_ = NULL;
	GtkWidget* _tmp41_;
	GtkWidget* child;
	GtkWidget* _tmp42_;
	GtkStyleContext* _tmp45_ = NULL;
	GtkStyleContext* _tmp46_;
	GtkStyleContext* context;
	GdkWindow* _tmp47_;
	GdkWindow* _tmp48_;
	GdkWindow* _tmp49_;
	self = (ContactsRevealer*) base;
	gtk_widget_set_realized ((GtkWidget*) self, TRUE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	attributes = _tmp1_;
	_tmp2_ = allocation;
	_tmp3_ = _tmp2_.x;
	attributes.x = _tmp3_;
	_tmp4_ = allocation;
	_tmp5_ = _tmp4_.y;
	attributes.y = _tmp5_;
	_tmp6_ = allocation;
	_tmp7_ = _tmp6_.width;
	attributes.width = _tmp7_;
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.height;
	attributes.height = _tmp9_;
	attributes.window_type = GDK_WINDOW_CHILD;
	attributes.wclass = GDK_INPUT_OUTPUT;
	_tmp10_ = gtk_widget_get_visual ((GtkWidget*) self);
	attributes.visual = _tmp10_;
	_tmp11_ = gtk_widget_get_events ((GtkWidget*) self);
	attributes.event_mask = _tmp11_ | GDK_EXPOSURE_MASK;
	attributes_mask = (GDK_WA_X | GDK_WA_Y) | GDK_WA_VISUAL;
	_tmp12_ = gtk_widget_get_parent_window ((GtkWidget*) self);
	_tmp13_ = attributes;
	_tmp14_ = attributes_mask;
	_tmp15_ = gdk_window_new (_tmp12_, &_tmp13_, _tmp14_);
	_g_object_unref0 (self->priv->view_window);
	self->priv->view_window = _tmp15_;
	_tmp16_ = self->priv->view_window;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	gtk_widget_set_window ((GtkWidget*) self, _tmp17_);
	_tmp18_ = self->priv->view_window;
	gdk_window_set_user_data (_tmp18_, (GObject*) self);
	child_allocation = _tmp19_;
	_tmp20_ = allocation;
	contacts_revealer_get_child_allocation (self, &_tmp20_, &_tmp21_);
	child_allocation = _tmp21_;
	attributes.x = 0;
	attributes.y = 0;
	_tmp22_ = child_allocation;
	_tmp23_ = _tmp22_.width;
	attributes.width = _tmp23_;
	_tmp24_ = child_allocation;
	_tmp25_ = _tmp24_.height;
	attributes.height = _tmp25_;
	_tmp26_ = self->priv->_orientation;
	if (_tmp26_ == GTK_ORIENTATION_HORIZONTAL) {
		GtkAllocation _tmp27_;
		gint _tmp28_;
		GtkAllocation _tmp29_;
		gint _tmp30_;
		_tmp27_ = allocation;
		_tmp28_ = _tmp27_.height;
		_tmp29_ = child_allocation;
		_tmp30_ = _tmp29_.height;
		attributes.y = _tmp28_ - _tmp30_;
	} else {
		GtkAllocation _tmp31_;
		gint _tmp32_;
		GtkAllocation _tmp33_;
		gint _tmp34_;
		_tmp31_ = allocation;
		_tmp32_ = _tmp31_.width;
		_tmp33_ = child_allocation;
		_tmp34_ = _tmp33_.width;
		attributes.x = _tmp32_ - _tmp34_;
	}
	_tmp35_ = self->priv->view_window;
	_tmp36_ = attributes;
	_tmp37_ = attributes_mask;
	_tmp38_ = gdk_window_new (_tmp35_, &_tmp36_, _tmp37_);
	_g_object_unref0 (self->priv->bin_window);
	self->priv->bin_window = _tmp38_;
	_tmp39_ = self->priv->bin_window;
	gdk_window_set_user_data (_tmp39_, (GObject*) self);
	_tmp40_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp41_ = _g_object_ref0 (_tmp40_);
	child = _tmp41_;
	_tmp42_ = child;
	if (_tmp42_ != NULL) {
		GtkWidget* _tmp43_;
		GdkWindow* _tmp44_;
		_tmp43_ = child;
		_tmp44_ = self->priv->bin_window;
		gtk_widget_set_parent_window (_tmp43_, _tmp44_);
	}
	_tmp45_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp46_ = _g_object_ref0 (_tmp45_);
	context = _tmp46_;
	_tmp47_ = self->priv->view_window;
	gtk_style_context_set_background (context, _tmp47_);
	_tmp48_ = self->priv->bin_window;
	gtk_style_context_set_background (context, _tmp48_);
	_tmp49_ = self->priv->bin_window;
	gdk_window_show (_tmp49_);
	_g_object_unref0 (context);
	_g_object_unref0 (child);
}


static void contacts_revealer_real_unrealize (GtkWidget* base) {
	ContactsRevealer * self;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	self = (ContactsRevealer*) base;
	_tmp0_ = self->priv->view_window;
	gdk_window_set_user_data (_tmp0_, (GObject*) self);
	_tmp1_ = self->priv->view_window;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	gdk_window_destroy (_tmp2_);
	_g_object_unref0 (self->priv->view_window);
	self->priv->view_window = NULL;
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->unrealize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BIN, GtkBin));
}


static void contacts_revealer_real_add (GtkContainer* base, GtkWidget* child) {
	ContactsRevealer * self;
	GtkWidget* _tmp0_;
	GdkWindow* _tmp1_;
	GtkWidget* _tmp2_;
	gdouble _tmp3_;
	GtkWidget* _tmp4_;
	self = (ContactsRevealer*) base;
	g_return_if_fail (child != NULL);
	_tmp0_ = child;
	_tmp1_ = self->priv->bin_window;
	gtk_widget_set_parent_window (_tmp0_, _tmp1_);
	_tmp2_ = child;
	_tmp3_ = self->priv->current_pos;
	gtk_widget_set_child_visible (_tmp2_, _tmp3_ != 0.0);
	_tmp4_ = child;
	GTK_CONTAINER_CLASS (contacts_revealer_parent_class)->add ((GtkContainer*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BIN, GtkBin), _tmp4_);
}


static void contacts_revealer_real_style_updated (GtkWidget* base) {
	ContactsRevealer * self;
	gboolean _tmp0_ = FALSE;
	self = (ContactsRevealer*) base;
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->style_updated ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BIN, GtkBin));
	_tmp0_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (_tmp0_) {
		GtkStyleContext* _tmp1_ = NULL;
		GtkStyleContext* _tmp2_;
		GtkStyleContext* context;
		GtkStyleContext* _tmp3_;
		GdkWindow* _tmp4_;
		GtkStyleContext* _tmp5_;
		GdkWindow* _tmp6_;
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		context = _tmp2_;
		_tmp3_ = context;
		_tmp4_ = self->priv->bin_window;
		gtk_style_context_set_background (_tmp3_, _tmp4_);
		_tmp5_ = context;
		_tmp6_ = self->priv->view_window;
		gtk_style_context_set_background (_tmp5_, _tmp6_);
		_g_object_unref0 (context);
	}
}


static void contacts_revealer_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	ContactsRevealer * self;
	GtkAllocation _tmp0_;
	GtkAllocation _tmp1_ = {0};
	GtkAllocation child_allocation;
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_ = {0};
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_;
	GtkWidget* child;
	gboolean _tmp6_ = FALSE;
	GtkWidget* _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp13_ = FALSE;
	self = (ContactsRevealer*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	gtk_widget_set_allocation ((GtkWidget*) self, &_tmp0_);
	child_allocation = _tmp1_;
	_tmp2_ = *allocation;
	contacts_revealer_get_child_allocation (self, &_tmp2_, &_tmp3_);
	child_allocation = _tmp3_;
	_tmp4_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	child = _tmp5_;
	_tmp7_ = child;
	if (_tmp7_ != NULL) {
		GtkWidget* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = child;
		_tmp9_ = gtk_widget_get_visible (_tmp8_);
		_tmp6_ = _tmp9_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp10_ = _tmp6_;
	if (_tmp10_) {
		GtkWidget* _tmp11_;
		GtkAllocation _tmp12_;
		_tmp11_ = child;
		_tmp12_ = child_allocation;
		gtk_widget_size_allocate (_tmp11_, &_tmp12_);
	}
	_tmp13_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (_tmp13_) {
		gboolean _tmp14_ = FALSE;
		GdkWindow* _tmp33_;
		GtkAllocation _tmp34_;
		gint _tmp35_;
		GtkAllocation _tmp36_;
		gint _tmp37_;
		GtkAllocation _tmp38_;
		gint _tmp39_;
		GtkAllocation _tmp40_;
		gint _tmp41_;
		gint bin_x;
		gint bin_y;
		GtkOrientation _tmp42_;
		GdkWindow* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		GtkAllocation _tmp54_;
		gint _tmp55_;
		GtkAllocation _tmp56_;
		gint _tmp57_;
		_tmp14_ = gtk_widget_get_mapped ((GtkWidget*) self);
		if (_tmp14_) {
			gboolean _tmp15_ = FALSE;
			GtkAllocation _tmp16_;
			gint _tmp17_;
			gboolean _tmp20_;
			gboolean window_visible;
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_;
			gboolean _tmp25_;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_;
			gboolean _tmp31_;
			_tmp16_ = *allocation;
			_tmp17_ = _tmp16_.width;
			if (_tmp17_ > 0) {
				GtkAllocation _tmp18_;
				gint _tmp19_;
				_tmp18_ = *allocation;
				_tmp19_ = _tmp18_.height;
				_tmp15_ = _tmp19_ > 0;
			} else {
				_tmp15_ = FALSE;
			}
			_tmp20_ = _tmp15_;
			window_visible = _tmp20_;
			_tmp22_ = window_visible;
			if (!_tmp22_) {
				GdkWindow* _tmp23_;
				gboolean _tmp24_ = FALSE;
				_tmp23_ = self->priv->view_window;
				_tmp24_ = gdk_window_is_visible (_tmp23_);
				_tmp21_ = _tmp24_;
			} else {
				_tmp21_ = FALSE;
			}
			_tmp25_ = _tmp21_;
			if (_tmp25_) {
				GdkWindow* _tmp26_;
				_tmp26_ = self->priv->view_window;
				gdk_window_hide (_tmp26_);
			}
			_tmp28_ = window_visible;
			if (_tmp28_) {
				GdkWindow* _tmp29_;
				gboolean _tmp30_ = FALSE;
				_tmp29_ = self->priv->view_window;
				_tmp30_ = gdk_window_is_visible (_tmp29_);
				_tmp27_ = !_tmp30_;
			} else {
				_tmp27_ = FALSE;
			}
			_tmp31_ = _tmp27_;
			if (_tmp31_) {
				GdkWindow* _tmp32_;
				_tmp32_ = self->priv->view_window;
				gdk_window_show (_tmp32_);
			}
		}
		_tmp33_ = self->priv->view_window;
		_tmp34_ = *allocation;
		_tmp35_ = _tmp34_.x;
		_tmp36_ = *allocation;
		_tmp37_ = _tmp36_.y;
		_tmp38_ = *allocation;
		_tmp39_ = _tmp38_.width;
		_tmp40_ = *allocation;
		_tmp41_ = _tmp40_.height;
		gdk_window_move_resize (_tmp33_, _tmp35_, _tmp37_, _tmp39_, _tmp41_);
		bin_x = 0;
		bin_y = 0;
		_tmp42_ = self->priv->_orientation;
		if (_tmp42_ == GTK_ORIENTATION_HORIZONTAL) {
			GtkAllocation _tmp43_;
			gint _tmp44_;
			GtkAllocation _tmp45_;
			gint _tmp46_;
			_tmp43_ = *allocation;
			_tmp44_ = _tmp43_.height;
			_tmp45_ = child_allocation;
			_tmp46_ = _tmp45_.height;
			bin_y = _tmp44_ - _tmp46_;
		} else {
			GtkAllocation _tmp47_;
			gint _tmp48_;
			GtkAllocation _tmp49_;
			gint _tmp50_;
			_tmp47_ = *allocation;
			_tmp48_ = _tmp47_.width;
			_tmp49_ = child_allocation;
			_tmp50_ = _tmp49_.width;
			bin_x = _tmp48_ - _tmp50_;
		}
		_tmp51_ = self->priv->bin_window;
		_tmp52_ = bin_x;
		_tmp53_ = bin_y;
		_tmp54_ = child_allocation;
		_tmp55_ = _tmp54_.width;
		_tmp56_ = child_allocation;
		_tmp57_ = _tmp56_.height;
		gdk_window_move_resize (_tmp51_, _tmp52_, _tmp53_, _tmp55_, _tmp57_);
	}
	_g_object_unref0 (child);
}


static void contacts_revealer_set_amount (ContactsRevealer* self, gdouble amount) {
	gdouble _tmp0_;
	gboolean _tmp1_ = FALSE;
	gdouble _tmp2_;
	gboolean _tmp4_;
	gboolean new_visible;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_;
	GtkWidget* child;
	gboolean _tmp7_ = FALSE;
	GtkWidget* _tmp8_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = amount;
	self->priv->current_pos = _tmp0_;
	_tmp2_ = amount;
	if (_tmp2_ != 0.0) {
		_tmp1_ = TRUE;
	} else {
		gdouble _tmp3_;
		_tmp3_ = self->priv->target_pos;
		_tmp1_ = _tmp3_ != 0.0;
	}
	_tmp4_ = _tmp1_;
	new_visible = _tmp4_;
	_tmp5_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	child = _tmp6_;
	_tmp8_ = child;
	if (_tmp8_ != NULL) {
		gboolean _tmp9_;
		GtkWidget* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = new_visible;
		_tmp10_ = child;
		_tmp11_ = gtk_widget_get_child_visible (_tmp10_);
		_tmp7_ = _tmp9_ != _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp12_ = _tmp7_;
	if (_tmp12_) {
		GtkWidget* _tmp13_;
		gboolean _tmp14_;
		_tmp13_ = child;
		_tmp14_ = new_visible;
		gtk_widget_set_child_visible (_tmp13_, _tmp14_);
	}
	gtk_widget_queue_resize ((GtkWidget*) self);
	_g_object_unref0 (child);
}


static void contacts_revealer_animate_step (ContactsRevealer* self, gint64 now) {
	gdouble t;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gdouble _tmp6_;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	g_return_if_fail (self != NULL);
	t = 1.0;
	_tmp0_ = now;
	_tmp1_ = self->priv->end_time;
	if (_tmp0_ < _tmp1_) {
		gint64 _tmp2_;
		gint64 _tmp3_;
		gint64 _tmp4_;
		gint64 _tmp5_;
		_tmp2_ = now;
		_tmp3_ = self->priv->start_time;
		_tmp4_ = self->priv->end_time;
		_tmp5_ = self->priv->start_time;
		t = (_tmp2_ - _tmp3_) / ((gdouble) (_tmp4_ - _tmp5_));
	}
	_tmp6_ = t;
	_tmp7_ = transition_ease_out_quad (_tmp6_, 1.0);
	t = _tmp7_;
	_tmp8_ = self->priv->source_pos;
	_tmp9_ = t;
	_tmp10_ = self->priv->target_pos;
	_tmp11_ = self->priv->source_pos;
	contacts_revealer_set_amount (self, _tmp8_ + (_tmp9_ * (_tmp10_ - _tmp11_)));
}


static gboolean contacts_revealer_animate_cb (ContactsRevealer* self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
	gint64 now;
	gint64 _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_get_monotonic_time ();
	now = _tmp0_;
	_tmp1_ = now;
	contacts_revealer_animate_step (self, _tmp1_);
	_tmp2_ = self->priv->current_pos;
	_tmp3_ = self->priv->target_pos;
	if (_tmp2_ == _tmp3_) {
		self->priv->timeout = (guint) 0;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean _contacts_revealer_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = contacts_revealer_animate_cb (self);
	return result;
}


static void contacts_revealer_start_animation (ContactsRevealer* self, gdouble target) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->target_pos;
	_tmp1_ = target;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = target;
	self->priv->target_pos = _tmp2_;
	_tmp3_ = gtk_widget_get_mapped ((GtkWidget*) self);
	if (_tmp3_) {
		gdouble _tmp4_;
		gint64 _tmp5_ = 0LL;
		gint64 _tmp6_;
		gint _tmp7_;
		guint _tmp8_;
		gint64 _tmp10_;
		_tmp4_ = self->priv->current_pos;
		self->priv->source_pos = _tmp4_;
		_tmp5_ = g_get_monotonic_time ();
		self->priv->start_time = _tmp5_;
		_tmp6_ = self->priv->start_time;
		_tmp7_ = self->priv->_duration;
		self->priv->end_time = _tmp6_ + (_tmp7_ * 1000);
		_tmp8_ = self->priv->timeout;
		if (_tmp8_ == ((guint) 0)) {
			guint _tmp9_ = 0U;
			_tmp9_ = gdk_threads_add_timeout ((guint) CONTACTS_REVEALER_frame_time, _contacts_revealer_animate_cb_gsource_func, self);
			self->priv->timeout = _tmp9_;
		}
		_tmp10_ = self->priv->start_time;
		contacts_revealer_animate_step (self, _tmp10_);
	} else {
		gdouble _tmp11_;
		_tmp11_ = target;
		contacts_revealer_set_amount (self, _tmp11_);
	}
}


static void contacts_revealer_stop_animation (ContactsRevealer* self) {
	gdouble _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->target_pos;
	self->priv->current_pos = _tmp0_;
	_tmp1_ = self->priv->timeout;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_;
		_tmp2_ = self->priv->timeout;
		g_source_remove (_tmp2_);
		self->priv->timeout = (guint) 0;
	}
}


static void contacts_revealer_real_map (GtkWidget* base) {
	ContactsRevealer * self;
	gboolean _tmp0_ = FALSE;
	self = (ContactsRevealer*) base;
	_tmp0_ = gtk_widget_get_mapped ((GtkWidget*) self);
	if (!_tmp0_) {
		GtkAllocation allocation = {0};
		GtkAllocation _tmp1_ = {0};
		gboolean _tmp2_ = FALSE;
		GtkAllocation _tmp3_;
		gint _tmp4_;
		gboolean _tmp7_;
		gdouble _tmp9_;
		gtk_widget_get_allocation ((GtkWidget*) self, &_tmp1_);
		allocation = _tmp1_;
		_tmp3_ = allocation;
		_tmp4_ = _tmp3_.width;
		if (_tmp4_ > 0) {
			GtkAllocation _tmp5_;
			gint _tmp6_;
			_tmp5_ = allocation;
			_tmp6_ = _tmp5_.height;
			_tmp2_ = _tmp6_ > 0;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp7_ = _tmp2_;
		if (_tmp7_) {
			GdkWindow* _tmp8_;
			_tmp8_ = self->priv->view_window;
			gdk_window_show (_tmp8_);
		}
		_tmp9_ = self->priv->target_pos;
		contacts_revealer_start_animation (self, _tmp9_);
	}
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->map ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BIN, GtkBin));
}


static void contacts_revealer_real_unmap (GtkWidget* base) {
	ContactsRevealer * self;
	self = (ContactsRevealer*) base;
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->unmap ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BIN, GtkBin));
	contacts_revealer_stop_animation (self);
}


static gboolean contacts_revealer_real_draw (GtkWidget* base, cairo_t* cr) {
	ContactsRevealer * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_;
	GdkWindow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = (ContactsRevealer*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = cr;
	_tmp1_ = self->priv->bin_window;
	_tmp2_ = gtk_cairo_should_draw_window (_tmp0_, _tmp1_);
	if (_tmp2_) {
		cairo_t* _tmp3_;
		_tmp3_ = cr;
		GTK_WIDGET_CLASS (contacts_revealer_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BIN, GtkBin), _tmp3_);
	}
	result = TRUE;
	return result;
}


void contacts_revealer_reveal (ContactsRevealer* self) {
	g_return_if_fail (self != NULL);
	contacts_revealer_start_animation (self, 1.0);
}


void contacts_revealer_unreveal (ContactsRevealer* self) {
	g_return_if_fail (self != NULL);
	contacts_revealer_start_animation (self, 0.0);
}


static void contacts_revealer_real_get_preferred_height (GtkWidget* base, gint* minimum_height, gint* natural_height) {
	ContactsRevealer * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkOrientation _tmp2_;
	gint _tmp5_;
	self = (ContactsRevealer*) base;
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->get_preferred_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BIN, GtkBin), &_tmp0_, &_tmp1_);
	_vala_minimum_height = _tmp0_;
	_vala_natural_height = _tmp1_;
	_tmp2_ = self->priv->_orientation;
	if (_tmp2_ == GTK_ORIENTATION_HORIZONTAL) {
		gint _tmp3_;
		gdouble _tmp4_;
		_tmp3_ = _vala_natural_height;
		_tmp4_ = self->priv->current_pos;
		_vala_natural_height = (gint) (_tmp3_ * _tmp4_);
	}
	_tmp5_ = _vala_natural_height;
	_vala_minimum_height = _tmp5_;
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}


static void contacts_revealer_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum_height, gint* natural_height) {
	ContactsRevealer * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkOrientation _tmp3_;
	gint _tmp6_;
	self = (ContactsRevealer*) base;
	_tmp0_ = width;
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->get_preferred_height_for_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BIN, GtkBin), _tmp0_, &_tmp1_, &_tmp2_);
	_vala_minimum_height = _tmp1_;
	_vala_natural_height = _tmp2_;
	_tmp3_ = self->priv->_orientation;
	if (_tmp3_ == GTK_ORIENTATION_HORIZONTAL) {
		gint _tmp4_;
		gdouble _tmp5_;
		_tmp4_ = _vala_natural_height;
		_tmp5_ = self->priv->current_pos;
		_vala_natural_height = (gint) (_tmp4_ * _tmp5_);
	}
	_tmp6_ = _vala_natural_height;
	_vala_minimum_height = _tmp6_;
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}


static void contacts_revealer_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width) {
	ContactsRevealer * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkOrientation _tmp2_;
	gint _tmp5_;
	self = (ContactsRevealer*) base;
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->get_preferred_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BIN, GtkBin), &_tmp0_, &_tmp1_);
	_vala_minimum_width = _tmp0_;
	_vala_natural_width = _tmp1_;
	_tmp2_ = self->priv->_orientation;
	if (_tmp2_ == GTK_ORIENTATION_VERTICAL) {
		gint _tmp3_;
		gdouble _tmp4_;
		_tmp3_ = _vala_natural_width;
		_tmp4_ = self->priv->current_pos;
		_vala_natural_width = (gint) (_tmp3_ * _tmp4_);
	}
	_tmp5_ = _vala_natural_width;
	_vala_minimum_width = _tmp5_;
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}


static void contacts_revealer_real_get_preferred_width_for_height (GtkWidget* base, gint height, gint* minimum_width, gint* natural_width) {
	ContactsRevealer * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkOrientation _tmp3_;
	gint _tmp6_;
	self = (ContactsRevealer*) base;
	_tmp0_ = height;
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->get_preferred_width_for_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BIN, GtkBin), _tmp0_, &_tmp1_, &_tmp2_);
	_vala_minimum_width = _tmp1_;
	_vala_natural_width = _tmp2_;
	_tmp3_ = self->priv->_orientation;
	if (_tmp3_ == GTK_ORIENTATION_VERTICAL) {
		gint _tmp4_;
		gdouble _tmp5_;
		_tmp4_ = _vala_natural_width;
		_tmp5_ = self->priv->current_pos;
		_vala_natural_width = (gint) (_tmp4_ * _tmp5_);
	}
	_tmp6_ = _vala_natural_width;
	_vala_minimum_width = _tmp6_;
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}


GtkOrientation contacts_revealer_get_orientation (ContactsRevealer* self) {
	GtkOrientation result;
	GtkOrientation _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_orientation;
	result = _tmp0_;
	return result;
}


void contacts_revealer_set_orientation (ContactsRevealer* self, GtkOrientation value) {
	GtkOrientation _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_orientation = _tmp0_;
	g_object_notify ((GObject *) self, "orientation");
}


gint contacts_revealer_get_duration (ContactsRevealer* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_duration;
	result = _tmp0_;
	return result;
}


void contacts_revealer_set_duration (ContactsRevealer* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_duration = _tmp0_;
	g_object_notify ((GObject *) self, "duration");
}


static void contacts_revealer_class_init (ContactsRevealerClass * klass) {
	contacts_revealer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsRevealerPrivate));
	GTK_WIDGET_CLASS (klass)->realize = contacts_revealer_real_realize;
	GTK_WIDGET_CLASS (klass)->unrealize = contacts_revealer_real_unrealize;
	GTK_CONTAINER_CLASS (klass)->add = contacts_revealer_real_add;
	GTK_WIDGET_CLASS (klass)->style_updated = contacts_revealer_real_style_updated;
	GTK_WIDGET_CLASS (klass)->size_allocate = contacts_revealer_real_size_allocate;
	GTK_WIDGET_CLASS (klass)->map = contacts_revealer_real_map;
	GTK_WIDGET_CLASS (klass)->unmap = contacts_revealer_real_unmap;
	GTK_WIDGET_CLASS (klass)->draw = contacts_revealer_real_draw;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = contacts_revealer_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->get_preferred_height_for_width = contacts_revealer_real_get_preferred_height_for_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_width = contacts_revealer_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_width_for_height = contacts_revealer_real_get_preferred_width_for_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_revealer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_revealer_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_revealer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_REVEALER_ORIENTATION, g_param_spec_enum ("orientation", "orientation", "orientation", GTK_TYPE_ORIENTATION, GTK_ORIENTATION_HORIZONTAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_REVEALER_DURATION, g_param_spec_int ("duration", "duration", "duration", G_MININT, G_MAXINT, 250, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void contacts_revealer_instance_init (ContactsRevealer * self) {
	self->priv = CONTACTS_REVEALER_GET_PRIVATE (self);
	self->priv->_orientation = GTK_ORIENTATION_HORIZONTAL;
	self->priv->_duration = 250;
}


static void contacts_revealer_finalize (GObject* obj) {
	ContactsRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_REVEALER, ContactsRevealer);
	_g_object_unref0 (self->priv->bin_window);
	_g_object_unref0 (self->priv->view_window);
	G_OBJECT_CLASS (contacts_revealer_parent_class)->finalize (obj);
}


GType contacts_revealer_get_type (void) {
	static volatile gsize contacts_revealer_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_revealer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsRevealerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_revealer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsRevealer), 0, (GInstanceInitFunc) contacts_revealer_instance_init, NULL };
		GType contacts_revealer_type_id;
		contacts_revealer_type_id = g_type_register_static (GTK_TYPE_BIN, "ContactsRevealer", &g_define_type_info, 0);
		g_once_init_leave (&contacts_revealer_type_id__volatile, contacts_revealer_type_id);
	}
	return contacts_revealer_type_id__volatile;
}


static void _vala_contacts_revealer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_REVEALER, ContactsRevealer);
	switch (property_id) {
		case CONTACTS_REVEALER_ORIENTATION:
		g_value_set_enum (value, contacts_revealer_get_orientation (self));
		break;
		case CONTACTS_REVEALER_DURATION:
		g_value_set_int (value, contacts_revealer_get_duration (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_contacts_revealer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ContactsRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_REVEALER, ContactsRevealer);
	switch (property_id) {
		case CONTACTS_REVEALER_ORIENTATION:
		contacts_revealer_set_orientation (self, g_value_get_enum (value));
		break;
		case CONTACTS_REVEALER_DURATION:
		contacts_revealer_set_duration (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



