// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSERROR_H
#define _GIOMM_DBUSERROR_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/error.h>


namespace Gio
{

namespace DBus
{

//The GMMPROC_EXTRA_NAMESPACE() macro is a hint to generate_wrap_init.pl to put it in the DBus sub-namespace


class Error : public Glib::Error
{
public:
  enum Code
  {
    /** A generic error; "something went wrong" - see the error message for
     * more.
     */
    FAILED,
    /** There was not enough memory to complete an operation.
     */
    NO_MEMORY,
    /** The bus doesn't know how to launch a service to supply the bus name
     * you wanted.
     */
    SERVICE_UNKNOWN,
    /** The bus name you referenced doesn't exist (i.e.\ no application owns
     * it).
     */
    NAME_HAS_NO_OWNER,
    /** No reply to a message expecting one, usually means a timeout occurred.
     */
    NO_REPLY,
    /** Something went wrong reading or writing to a socket, for example.
     */
    IO_ERROR,
    /** A D-Bus bus address was malformed.
     */
    BAD_ADDRESS,
    /** Requested operation isn't supported (like ENOSYS on UNIX).
     */
    NOT_SUPPORTED,
    /** Some limited resource is exhausted.
     */
    LIMITS_EXCEEDED,
    /** Security restrictions don't allow doing what you're trying to do.
     */
    ACCESS_DENIED,
    /** Authentication didn't work.
     */
    AUTH_FAILED,
    /** Unable to connect to server (probably caused by ECONNREFUSED on a
     * socket).
     */
    NO_SERVER,
    /** Certain timeout errors, possibly ETIMEDOUT on a socket.  Note that
     * DBUS_ERROR_NO_REPLY is used for message reply timeouts. Warning:
     * this is confusingly-named given that DBUS_ERROR_TIMED_OUT also
     * exists. We can't fix it for compatibility reasons so just be
     * careful.
     */
    TIMEOUT,
    /** No network access (probably ENETUNREACH on a socket).
     */
    NO_NETWORK,
    /** Can't bind a socket since its address is in use (i.e.\ EADDRINUSE).
     */
    ADDRESS_IN_USE,
    /** The connection is disconnected and you're trying to use it.
     */
    DISCONNECTED,
    /** Invalid arguments passed to a method call.
     */
    INVALID_ARGS,
    /** Missing file.
     */
    FILE_NOT_FOUND,
    /** Existing file and the operation you're using does not silently overwrite.
     */
    FILE_EXISTS,
    /** Method name you invoked isn't known by the object you invoked it on.
     */
    UNKNOWN_METHOD,
    /** Certain timeout errors, e.g.\ while starting a service. Warning: this is
     * confusingly-named given that DBUS_ERROR_TIMEOUT also exists. We
     * can't fix it for compatibility reasons so just be careful.
     */
    TIMED_OUT,
    /** Tried to remove or modify a match rule that didn't exist.
     */
    MATCH_RULE_NOT_FOUND,
    /** The match rule isn't syntactically valid.
     */
    MATCH_RULE_INVALID,
    /** While starting a new process, the exec() call failed.
     */
    SPAWN_EXEC_FAILED,
    /** While starting a new process, the fork() call failed.
     */
    SPAWN_FORK_FAILED,
    /** While starting a new process, the child exited with a status code.
     */
    SPAWN_CHILD_EXITED,
    /** While starting a new process, the child exited on a signal.
     */
    SPAWN_CHILD_SIGNALED,
    /** While starting a new process, something went wrong.
     */
    SPAWN_FAILED,
    /** We failed to setup the environment correctly.
     */
    SPAWN_SETUP_FAILED,
    /** We failed to setup the config parser correctly.
     */
    SPAWN_CONFIG_INVALID,
    /** Bus name was not valid.
     */
    SPAWN_SERVICE_INVALID,
    /** Service file not found in system-services directory.
     */
    SPAWN_SERVICE_NOT_FOUND,
    /** Permissions are incorrect on the setuid helper.
     */
    SPAWN_PERMISSIONS_INVALID,
    /** Service file invalid (Name, User or Exec missing).
     */
    SPAWN_FILE_INVALID,
    /** Tried to get a UNIX process ID and it wasn't available.
     */
    SPAWN_NO_MEMORY,
    /** Tried to get a UNIX process ID and it wasn't available.
     */
    UNIX_PROCESS_ID_UNKNOWN,
    /** A type signature is not valid.
     */
    INVALID_SIGNATURE,
    /** A file contains invalid syntax or is otherwise broken.
     */
    INVALID_FILE_CONTENT,
    /** Asked for SELinux security context and it wasn't available.
     */
    SELINUX_SECURITY_CONTEXT_UNKNOWN,
    /** Asked for ADT audit data and it wasn't available.
     */
    ADT_AUDIT_DATA_UNKNOWN,
    /** There's already an object with the requested object path.
     */
    OBJECT_PATH_IN_USE
  };

  Error(Code error_code, const Glib::ustring& error_message);
  explicit Error(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};


} //namespace DBus

} // namespace Gio


#endif /* _GIOMM_DBUSERROR_H */

