/* sw-backend.c generated by valac 0.18.0.110-5650, the Vala compiler
 * generated from sw-backend.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <libsocialweb-client/libsocialweb-client-hack-for-vala.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks-libsocialweb.h>
#include <gio/gio.h>
#include <folks-internal.h>


#define FOLKS_BACKENDS_SW_TYPE_BACKEND (folks_backends_sw_backend_get_type ())
#define FOLKS_BACKENDS_SW_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackend))
#define FOLKS_BACKENDS_SW_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackendClass))
#define FOLKS_BACKENDS_SW_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_SW_TYPE_BACKEND))
#define FOLKS_BACKENDS_SW_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_SW_TYPE_BACKEND))
#define FOLKS_BACKENDS_SW_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackendClass))

typedef struct _FolksBackendsSwBackend FolksBackendsSwBackend;
typedef struct _FolksBackendsSwBackendClass FolksBackendsSwBackendClass;
typedef struct _FolksBackendsSwBackendPrivate FolksBackendsSwBackendPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FolksBackendsSwBackendPrepareData FolksBackendsSwBackendPrepareData;
typedef struct _FolksBackendsSwBackendUnprepareData FolksBackendsSwBackendUnprepareData;

struct _FolksBackendsSwBackend {
	FolksBackend parent_instance;
	FolksBackendsSwBackendPrivate * priv;
};

struct _FolksBackendsSwBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksBackendsSwBackendPrivate {
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	SwClient* _client;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
};

struct _FolksBackendsSwBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsSwBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	SwClient* _tmp4_;
	SwClient* _tmp5_;
};

struct _FolksBackendsSwBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsSwBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeHashMap* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	GeeIterator* _store_it;
	GeeIterator* _tmp10_;
	gboolean _tmp11_;
	GeeIterator* _tmp12_;
	gpointer _tmp13_;
	FolksPersonaStore* store;
	FolksPersonaStore* _tmp14_;
	guint _tmp15_;
	FolksPersonaStore* _tmp16_;
	GeeHashMap* _tmp17_;
	GError * _inner_error_;
};


static gpointer folks_backends_sw_backend_parent_class = NULL;

GType folks_backends_sw_backend_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_SW_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackendPrivate))
enum  {
	FOLKS_BACKENDS_SW_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_SW_BACKEND_NAME,
	FOLKS_BACKENDS_SW_BACKEND_PERSONA_STORES,
	FOLKS_BACKENDS_SW_BACKEND_IS_PREPARED,
	FOLKS_BACKENDS_SW_BACKEND_IS_QUIESCENT
};
static void folks_backends_sw_backend_real_enable_persona_store (FolksBackend* base, FolksPersonaStore* store);
static void _folks_backends_sw_backend_add_store (FolksBackendsSwBackend* self, FolksPersonaStore* store, gboolean notify);
static void folks_backends_sw_backend_real_disable_persona_store (FolksBackend* base, FolksPersonaStore* store);
static void _folks_backends_sw_backend_store_removed_cb (FolksBackendsSwBackend* self, FolksPersonaStore* store);
static void folks_backends_sw_backend_real_set_persona_stores (FolksBackend* base, GeeSet* storeids);
static void _vala_array_add1 (FolksPersonaStore*** array, int* length, int* size, FolksPersonaStore* value);
static void _folks_backends_sw_backend_remove_store (FolksBackendsSwBackend* self, FolksPersonaStore* store, gboolean notify);
FolksBackendsSwBackend* folks_backends_sw_backend_new (void);
FolksBackendsSwBackend* folks_backends_sw_backend_construct (GType object_type);
static void folks_backends_sw_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_sw_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_sw_backend_real_prepare_co (FolksBackendsSwBackendPrepareData* _data_);
static void __lambda2_ (FolksBackendsSwBackend* self, SwClient* client, GList* services);
static void folks_backends_sw_backend_add_service (FolksBackendsSwBackend* self, const gchar* service_name);
static void ___lambda2__sw_client_get_services_callback (SwClient* client, GList* services, gpointer self);
static void folks_backends_sw_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_sw_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_sw_backend_real_unprepare_co (FolksBackendsSwBackendUnprepareData* _data_);
static void __folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static GObject * folks_backends_sw_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_backends_sw_backend_finalize (GObject* obj);
static void _vala_folks_backends_sw_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
   * {@inheritDoc}
   *
   * @since 0.9.0
   */
static void folks_backends_sw_backend_real_enable_persona_store (FolksBackend* base, FolksPersonaStore* store) {
	FolksBackendsSwBackend * self;
	GeeHashMap* _tmp0_;
	FolksPersonaStore* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	self = (FolksBackendsSwBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp3_);
	if (_tmp4_ == FALSE) {
		FolksPersonaStore* _tmp5_;
		_tmp5_ = store;
		_folks_backends_sw_backend_add_store (self, (FolksPersonaStore*) G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SWF_TYPE_PERSONA_STORE, SwfPersonaStore), TRUE);
	}
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.0
   */
static void folks_backends_sw_backend_real_disable_persona_store (FolksBackend* base, FolksPersonaStore* store) {
	FolksBackendsSwBackend * self;
	GeeHashMap* _tmp0_;
	FolksPersonaStore* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	self = (FolksBackendsSwBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp3_);
	if (_tmp4_) {
		FolksPersonaStore* _tmp5_;
		_tmp5_ = store;
		_folks_backends_sw_backend_store_removed_cb (self, _tmp5_);
	}
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.0
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (FolksPersonaStore*** array, int* length, int* size, FolksPersonaStore* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void folks_backends_sw_backend_real_set_persona_stores (FolksBackend* base, GeeSet* storeids) {
	FolksBackendsSwBackend * self;
	gboolean added_stores;
	FolksPersonaStore** _tmp0_ = NULL;
	FolksPersonaStore** removed_stores;
	gint removed_stores_length1;
	gint _removed_stores_size_;
	FolksPersonaStore** _tmp34_;
	gint _tmp34__length1;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_;
	gboolean _tmp40_;
	self = (FolksBackendsSwBackend*) base;
	added_stores = FALSE;
	_tmp0_ = g_new0 (FolksPersonaStore*, 0 + 1);
	removed_stores = _tmp0_;
	removed_stores_length1 = 0;
	_removed_stores_size_ = removed_stores_length1;
	{
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _id_it;
		_tmp1_ = storeids;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_id_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			gboolean _tmp4_ = FALSE;
			GeeIterator* _tmp5_;
			gpointer _tmp6_ = NULL;
			gchar* id;
			GeeHashMap* _tmp7_;
			const gchar* _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp3_ = _id_it;
			_tmp4_ = gee_iterator_next (_tmp3_);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = _id_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			id = (gchar*) _tmp6_;
			_tmp7_ = self->priv->_persona_stores;
			_tmp8_ = id;
			_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, _tmp8_);
			if (_tmp9_ == FALSE) {
				SwClient* _tmp10_;
				const gchar* _tmp11_;
				SwClientService* _tmp12_ = NULL;
				SwClientService* service;
				SwClientService* _tmp13_;
				SwfPersonaStore* _tmp14_;
				SwfPersonaStore* store;
				SwfPersonaStore* _tmp15_;
				_tmp10_ = self->priv->_client;
				_tmp11_ = id;
				_tmp12_ = sw_client_get_service (_tmp10_, _tmp11_);
				service = _tmp12_;
				_tmp13_ = service;
				_tmp14_ = swf_persona_store_new (_tmp13_);
				store = _tmp14_;
				_tmp15_ = store;
				_folks_backends_sw_backend_add_store (self, (FolksPersonaStore*) _tmp15_, FALSE);
				added_stores = TRUE;
				_g_object_unref0 (store);
				_g_object_unref0 (service);
			}
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	{
		GeeHashMap* _tmp16_;
		GeeCollection* _tmp17_;
		GeeCollection* _tmp18_;
		GeeCollection* _tmp19_;
		GeeIterator* _tmp20_ = NULL;
		GeeIterator* _tmp21_;
		GeeIterator* _store_it;
		_tmp16_ = self->priv->_persona_stores;
		_tmp17_ = gee_abstract_map_get_values ((GeeMap*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp20_ = gee_iterable_iterator ((GeeIterable*) _tmp19_);
		_tmp21_ = _tmp20_;
		_g_object_unref0 (_tmp19_);
		_store_it = _tmp21_;
		while (TRUE) {
			GeeIterator* _tmp22_;
			gboolean _tmp23_ = FALSE;
			GeeIterator* _tmp24_;
			gpointer _tmp25_ = NULL;
			FolksPersonaStore* store;
			GeeSet* _tmp26_;
			FolksPersonaStore* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gboolean _tmp30_ = FALSE;
			_tmp22_ = _store_it;
			_tmp23_ = gee_iterator_next (_tmp22_);
			if (!_tmp23_) {
				break;
			}
			_tmp24_ = _store_it;
			_tmp25_ = gee_iterator_get (_tmp24_);
			store = (FolksPersonaStore*) _tmp25_;
			_tmp26_ = storeids;
			_tmp27_ = store;
			_tmp28_ = folks_persona_store_get_id (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = gee_collection_contains ((GeeCollection*) _tmp26_, _tmp29_);
			if (!_tmp30_) {
				FolksPersonaStore** _tmp31_;
				gint _tmp31__length1;
				FolksPersonaStore* _tmp32_;
				FolksPersonaStore* _tmp33_;
				_tmp31_ = removed_stores;
				_tmp31__length1 = removed_stores_length1;
				_tmp32_ = store;
				_tmp33_ = _g_object_ref0 (_tmp32_);
				_vala_array_add1 (&removed_stores, &removed_stores_length1, &_removed_stores_size_, _tmp33_);
			}
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	_tmp34_ = removed_stores;
	_tmp34__length1 = removed_stores_length1;
	{
		FolksPersonaStore** store_collection = NULL;
		gint store_collection_length1 = 0;
		gint _store_collection_size_ = 0;
		gint store_it = 0;
		store_collection = _tmp34_;
		store_collection_length1 = _tmp34__length1;
		for (store_it = 0; store_it < _tmp34__length1; store_it = store_it + 1) {
			FolksPersonaStore* _tmp35_;
			FolksPersonaStore* store = NULL;
			_tmp35_ = _g_object_ref0 (store_collection[store_it]);
			store = _tmp35_;
			{
				FolksPersonaStore* _tmp36_;
				_tmp36_ = store;
				_folks_backends_sw_backend_remove_store (self, (FolksPersonaStore*) G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, SWF_TYPE_PERSONA_STORE, SwfPersonaStore), FALSE);
				_g_object_unref0 (store);
			}
		}
	}
	_tmp38_ = added_stores;
	if (_tmp38_) {
		_tmp37_ = TRUE;
	} else {
		FolksPersonaStore** _tmp39_;
		gint _tmp39__length1;
		_tmp39_ = removed_stores;
		_tmp39__length1 = removed_stores_length1;
		_tmp37_ = _tmp39__length1 > 0;
	}
	_tmp40_ = _tmp37_;
	if (_tmp40_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
	removed_stores = (_vala_array_free (removed_stores, removed_stores_length1, (GDestroyNotify) g_object_unref), NULL);
}


/**
   * {@inheritDoc}
   */
FolksBackendsSwBackend* folks_backends_sw_backend_construct (GType object_type) {
	FolksBackendsSwBackend * self = NULL;
	self = (FolksBackendsSwBackend*) g_object_new (object_type, NULL);
	return self;
}


FolksBackendsSwBackend* folks_backends_sw_backend_new (void) {
	return folks_backends_sw_backend_construct (FOLKS_BACKENDS_SW_TYPE_BACKEND);
}


static void folks_backends_sw_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsSwBackendPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsSwBackendPrepareData, _data_);
}


static void folks_backends_sw_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsSwBackend * self;
	FolksBackendsSwBackendPrepareData* _data_;
	FolksBackendsSwBackend* _tmp0_;
	self = (FolksBackendsSwBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsSwBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_sw_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_sw_backend_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_sw_backend_real_prepare_co (_data_);
}


static void folks_backends_sw_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsSwBackendPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void __lambda2_ (FolksBackendsSwBackend* self, SwClient* client, GList* services) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (client != NULL);
	{
		GList* _tmp0_;
		_tmp0_ = services;
		{
			GList* service_name_collection = NULL;
			GList* service_name_it = NULL;
			service_name_collection = _tmp0_;
			for (service_name_it = service_name_collection; service_name_it != NULL; service_name_it = service_name_it->next) {
				gchar* _tmp1_;
				gchar* service_name = NULL;
				_tmp1_ = g_strdup ((const gchar*) service_name_it->data);
				service_name = _tmp1_;
				{
					const gchar* _tmp2_;
					_tmp2_ = service_name;
					folks_backends_sw_backend_add_service (self, _tmp2_);
					_g_free0 (service_name);
				}
			}
		}
		self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) self, "is-prepared");
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
		g_object_unref ((GObject*) self);
	}
	__finally0:
	{
		self->priv->_prepare_pending = FALSE;
	}
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda2__sw_client_get_services_callback (SwClient* client, GList* services, gpointer self) {
	__lambda2_ (self, client, services);
}


static gboolean folks_backends_sw_backend_real_prepare_co (FolksBackendsSwBackendPrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	folks_internal_profiling_start ("preparing Sw.Backend", NULL);
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	if (_data_->_tmp3_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_object_ref ((GObject*) _data_->self);
	_data_->self->priv->_prepare_pending = TRUE;
	_data_->_tmp4_ = sw_client_new ();
	_g_object_unref0 (_data_->self->priv->_client);
	_data_->self->priv->_client = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->_client;
	sw_client_get_services (_data_->_tmp5_, ___lambda2__sw_client_get_services_callback, _data_->self);
	folks_internal_profiling_end ("preparing Sw.Backend", NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_sw_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsSwBackendUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsSwBackendUnprepareData, _data_);
}


static void folks_backends_sw_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsSwBackend * self;
	FolksBackendsSwBackendUnprepareData* _data_;
	FolksBackendsSwBackend* _tmp0_;
	self = (FolksBackendsSwBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsSwBackendUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_sw_backend_real_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_sw_backend_real_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_sw_backend_real_unprepare_co (_data_);
}


static void folks_backends_sw_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsSwBackendUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void __folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_folks_backends_sw_backend_store_removed_cb (self, _sender);
}


static gboolean folks_backends_sw_backend_real_unprepare_co (FolksBackendsSwBackendUnprepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (!_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	if (_data_->_tmp3_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		{
			_data_->_tmp4_ = _data_->self->priv->_persona_stores;
			_data_->_tmp5_ = gee_abstract_map_get_values ((GeeMap*) _data_->_tmp4_);
			_data_->_tmp6_ = _data_->_tmp5_;
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_g_object_unref0 (_data_->_tmp7_);
			_data_->_store_it = _data_->_tmp9_;
			while (TRUE) {
				_data_->_tmp10_ = _data_->_store_it;
				_data_->_tmp11_ = FALSE;
				_data_->_tmp11_ = gee_iterator_next (_data_->_tmp10_);
				if (!_data_->_tmp11_) {
					break;
				}
				_data_->_tmp12_ = _data_->_store_it;
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = gee_iterator_get (_data_->_tmp12_);
				_data_->store = (FolksPersonaStore*) _data_->_tmp13_;
				_data_->_tmp14_ = _data_->store;
				_data_->_tmp15_ = 0U;
				g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_data_->_tmp15_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_data_->_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp15_, 0, NULL, (GCallback) __folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed, _data_->self);
				_data_->_tmp16_ = _data_->store;
				g_signal_emit_by_name ((FolksBackend*) _data_->self, "persona-store-removed", _data_->_tmp16_);
				_g_object_unref0 (_data_->store);
			}
			_g_object_unref0 (_data_->_store_it);
		}
		_g_object_unref0 (_data_->self->priv->_client);
		_data_->self->priv->_client = NULL;
		_data_->_tmp17_ = _data_->self->priv->_persona_stores;
		gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp17_);
		g_object_notify ((GObject*) _data_->self, "persona-stores");
		_data_->self->priv->_is_quiescent = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_data_->self->priv->_is_prepared = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
	}
	__finally1:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Utility function to add a persona store.
   *
   * @param store the store to add.
   * @param notify whether or not to emit notification signals.
   * @since 0.9.0
   */
static void _folks_backends_sw_backend_add_store (FolksBackendsSwBackend* self, FolksPersonaStore* store, gboolean notify) {
	GeeHashMap* _tmp0_;
	FolksPersonaStore* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FolksPersonaStore* _tmp4_;
	FolksPersonaStore* _tmp5_;
	FolksPersonaStore* _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = store;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp3_, _tmp4_);
	_tmp5_ = store;
	g_signal_connect_object (_tmp5_, "removed", (GCallback) __folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	_tmp6_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", _tmp6_);
	_tmp7_ = notify;
	if (_tmp7_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
}


/**
   * Utility function to remove a persona store.
   *
   * @param store the store to remove.
   * @param notify whether or not to emit notification signals.
   * @since 0.9.0
   */
static void _folks_backends_sw_backend_remove_store (FolksBackendsSwBackend* self, FolksPersonaStore* store, gboolean notify) {
	FolksPersonaStore* _tmp0_;
	guint _tmp1_ = 0U;
	GeeHashMap* _tmp2_;
	FolksPersonaStore* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	FolksPersonaStore* _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed, self);
	_tmp2_ = self->priv->_persona_stores;
	_tmp3_ = store;
	_tmp4_ = folks_persona_store_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp2_, _tmp5_, NULL);
	_tmp6_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", _tmp6_);
	_tmp7_ = notify;
	if (_tmp7_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
}


static void folks_backends_sw_backend_add_service (FolksBackendsSwBackend* self, const gchar* service_name) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	FolksPersonaStore* _tmp3_;
	gboolean _tmp4_;
	SwClient* _tmp5_;
	const gchar* _tmp6_;
	SwClientService* _tmp7_ = NULL;
	SwClientService* _tmp8_;
	SwfPersonaStore* _tmp9_;
	SwfPersonaStore* _tmp10_;
	SwfPersonaStore* store;
	SwfPersonaStore* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service_name != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = service_name;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	_tmp3_ = (FolksPersonaStore*) _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->_client;
	_tmp6_ = service_name;
	_tmp7_ = sw_client_get_service (_tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = swf_persona_store_new (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	store = _tmp10_;
	_tmp11_ = store;
	_folks_backends_sw_backend_add_store (self, (FolksPersonaStore*) _tmp11_, TRUE);
	_g_object_unref0 (store);
}


static void _folks_backends_sw_backend_store_removed_cb (FolksBackendsSwBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_folks_backends_sw_backend_remove_store (self, (FolksPersonaStore*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SWF_TYPE_PERSONA_STORE, SwfPersonaStore), TRUE);
}


static const gchar* folks_backends_sw_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsSwBackend* self;
	self = (FolksBackendsSwBackend*) base;
	result = BACKEND_NAME;
	return result;
}


static GeeMap* folks_backends_sw_backend_real_get_persona_stores (FolksBackend* base) {
	GeeMap* result;
	FolksBackendsSwBackend* self;
	GeeMap* _tmp0_;
	self = (FolksBackendsSwBackend*) base;
	_tmp0_ = self->priv->_persona_stores_ro;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_sw_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsSwBackend* self;
	gboolean _tmp0_;
	self = (FolksBackendsSwBackend*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_sw_backend_real_get_is_quiescent (FolksBackend* base) {
	gboolean result;
	FolksBackendsSwBackend* self;
	gboolean _tmp0_;
	self = (FolksBackendsSwBackend*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static GObject * folks_backends_sw_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsSwBackend * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	parent_class = G_OBJECT_CLASS (folks_backends_sw_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackend);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp0_;
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_persona_stores_ro = _tmp3_;
	return obj;
}


static void folks_backends_sw_backend_class_init (FolksBackendsSwBackendClass * klass) {
	folks_backends_sw_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsSwBackendPrivate));
	FOLKS_BACKEND_CLASS (klass)->enable_persona_store = folks_backends_sw_backend_real_enable_persona_store;
	FOLKS_BACKEND_CLASS (klass)->disable_persona_store = folks_backends_sw_backend_real_disable_persona_store;
	FOLKS_BACKEND_CLASS (klass)->set_persona_stores = folks_backends_sw_backend_real_set_persona_stores;
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_sw_backend_real_prepare;
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_sw_backend_real_prepare_finish;
	FOLKS_BACKEND_CLASS (klass)->unprepare = folks_backends_sw_backend_real_unprepare;
	FOLKS_BACKEND_CLASS (klass)->unprepare_finish = folks_backends_sw_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_sw_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_sw_backend_real_get_persona_stores;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_sw_backend_real_get_is_prepared;
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = folks_backends_sw_backend_real_get_is_quiescent;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_sw_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_sw_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_sw_backend_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_PERSONA_STORES, g_param_spec_object ("persona-stores", "persona-stores", "persona-stores", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this Backend has reached a quiescent state.
	   *
	   * See {@link Folks.Backend.is_quiescent}.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void folks_backends_sw_backend_instance_init (FolksBackendsSwBackend * self) {
	self->priv = FOLKS_BACKENDS_SW_BACKEND_GET_PRIVATE (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
}


static void folks_backends_sw_backend_finalize (GObject* obj) {
	FolksBackendsSwBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackend);
	_g_object_unref0 (self->priv->_client);
	_g_object_unref0 (self->priv->_persona_stores);
	_g_object_unref0 (self->priv->_persona_stores_ro);
	G_OBJECT_CLASS (folks_backends_sw_backend_parent_class)->finalize (obj);
}


/**
 * A backend which connects to libsocialweb and creates a {@link PersonaStore}
 * for each service.
 */
GType folks_backends_sw_backend_get_type (void) {
	static volatile gsize folks_backends_sw_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_sw_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsSwBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_sw_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsSwBackend), 0, (GInstanceInitFunc) folks_backends_sw_backend_instance_init, NULL };
		GType folks_backends_sw_backend_type_id;
		folks_backends_sw_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsSwBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_sw_backend_type_id__volatile, folks_backends_sw_backend_type_id);
	}
	return folks_backends_sw_backend_type_id__volatile;
}


static void _vala_folks_backends_sw_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsSwBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackend);
	switch (property_id) {
		case FOLKS_BACKENDS_SW_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_SW_BACKEND_PERSONA_STORES:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_SW_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_SW_BACKEND_IS_QUIESCENT:
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



