// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_ERROR_H
#define _GIOMM_ERROR_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/error.h>
#include <glibmm/interface.h>

// There have been issues with other libraries defining HOST_NOT_FOUND (e.g.
// netdb.h).  As a workaround, we added the alternate name HOST_WAS_NOT_FOUND.
// Portable code should not use HOST_NOT_FOUND.  Undefining it here (and
// restoring it below) will allow programs to compile even if they include
// netdb.h.  See Bug #529496
#ifdef HOST_NOT_FOUND
#define GIOMM_SAVED_HOST_NOT_FOUND HOST_NOT_FOUND
#undef HOST_NOT_FOUND
#endif // HOST_NOT_FOUND


namespace Gio
{

//Note that GIOErrorEnum is not named GIOError in gio because there is already a GIOError in glib,
//But we can have both Glib::Error and Gio::Error in C++.

/** Exception class for giomm errors.
 */
class Error : public Glib::Error
{
public:
  enum Code
  {
    /** Generic error condition for when any operation fails.
     */
    FAILED,
    /** File not found.
     */
    NOT_FOUND,
    /** File already exists.
     */
    EXISTS,
    /** File is a directory.
     */
    IS_DIRECTORY,
    /** File is not a directory.
     */
    NOT_DIRECTORY,
    /** File is a directory that isn't empty.
     */
    NOT_EMPTY,
    /** File is not a regular file.
     */
    NOT_REGULAR_FILE,
    /** File is not a symbolic link.
     */
    NOT_SYMBOLIC_LINK,
    /** File cannot be mounted.
     */
    NOT_MOUNTABLE_FILE,
    /** Filename is too many characters.
     */
    FILENAME_TOO_LONG,
    /** Filename is invalid or contains invalid characters.
     */
    INVALID_FILENAME,
    /** File contains too many symbolic links.
     */
    TOO_MANY_LINKS,
    /** No space left on drive.
     */
    NO_SPACE,
    /** Invalid argument.
     */
    INVALID_ARGUMENT,
    /** Permission denied.
     */
    PERMISSION_DENIED,
    /** Operation not supported for the current backend.
     */
    NOT_SUPPORTED,
    /** File isn't mounted.
     */
    NOT_MOUNTED,
    /** File is already mounted.
     */
    ALREADY_MOUNTED,
    /** File was closed.
     */
    CLOSED,
    /** Operation was cancelled. See Cancellable.
     */
    CANCELLED,
    /** Operations are still pending.
     */
    PENDING,
    /** File is read only.
     */
    READ_ONLY,
    /** Backup couldn't be created.
     */
    CANT_CREATE_BACKUP,
    /** File's Entity Tag was incorrect.
     */
    WRONG_ETAG,
    /** Operation timed out.
     */
    TIMED_OUT,
    /** Operation would be recursive.
     */
    WOULD_RECURSE,
    /** File is busy.
     */
    BUSY,
    /** Operation would block.
     */
    WOULD_BLOCK,
    /** Host couldn't be found (remote operations).
     */
    HOST_NOT_FOUND,
    HOST_WAS_NOT_FOUND = HOST_NOT_FOUND,
    /** Operation would merge files.
     */
    WOULD_MERGE,
    /** Operation failed and a helper program has
     * already interacted with the user. Do not display any error dialog.
     */
    FAILED_HANDLED,
    /** The current process has too many files
     * open and can't open any more. Duplicate descriptors do count toward
     * this limit. @newin{2,20}
     */
    TOO_MANY_OPEN_FILES,
    /** The object has not been initialized. @newin{2,22}
     */
    NOT_INITIALIZED,
    /** The requested address is already in use. @newin{2,22}
     */
    ADDRESS_IN_USE,
    /** Need more input to finish operation. @newin{2,24}
     */
    PARTIAL_INPUT,
    /** There input data was invalid. @newin{2,24}
     */
    INVALID_DATA,
    /** A remote object generated an error that
     * doesn't correspond to a locally registered Error error
     * domain. Use g_dbus_error_get_remote_error() to extract the D-Bus
     * error name and g_dbus_error_strip_remote_error() to fix up the
     * message so it matches what was received on the wire. @newin{2,26}
     */
    DBUS_ERROR,
    /** Host unreachable. @newin{2,26}
     */
    HOST_UNREACHABLE,
    /** Network unreachable. @newin{2,26}
     */
    NETWORK_UNREACHABLE,
    /** Connection refused. @newin{2,26}
     */
    CONNECTION_REFUSED,
    /** Connection to proxy server failed. @newin{2,26}
     */
    PROXY_FAILED,
    /** Proxy authentication failed. @newin{2,26}
     */
    PROXY_AUTH_FAILED,
    /** Proxy server needs authentication. @newin{2,26}
     */
    PROXY_NEED_AUTH,
    /** Proxy connection is not allowed by ruleset.
     * @newin{2,26}
     */
    PROXY_NOT_ALLOWED
  };

  Error(Code error_code, const Glib::ustring& error_message);
  explicit Error(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};


class ResolverError : public Glib::Error
{
public:
  enum Code
  {
    /** the requested name/address/service was not
     * found
     */
    NOT_FOUND,
    /** the requested information could not
     * be looked up due to a network error or similar problem
     */
    TEMPORARY_FAILURE,
    /** unknown error
     */
    INTERNAL
  };

  ResolverError(Code error_code, const Glib::ustring& error_message);
  explicit ResolverError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};


} // namespace Gio

#ifdef GIOMM_SAVED_HOST_NOT_FOUND
// restore the previously-defined HOST_NOT_FOUND macro
#define HOST_NOT_FOUND GIOMM_SAVED_HOST_NOT_FOUND
#undef GIOMM_SAVED_HOST_NOT_FOUND
#endif // GIOMM_SAVED_HOST_NOT_FOUND


#endif /* _GIOMM_ERROR_H */

