/* tpf-persona-store.c generated by valac 0.17.3, the Vala compiler
 * generated from tpf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 *       Xavier Claessens <xavier.claessens@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <telepathy-glib/telepathy-glib.h>
#include <gio/gio.h>
#include <zeitgeist.h>
#include <folks-internal.h>
#include <tp-lowlevel.h>
#include <glib/gi18n-lib.h>


#define TPF_TYPE_PERSONA_STORE (tpf_persona_store_get_type ())
#define TPF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStore))
#define TPF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))
#define TPF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE))
#define TPF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE))
#define TPF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))

typedef struct _TpfPersonaStore TpfPersonaStore;
typedef struct _TpfPersonaStoreClass TpfPersonaStoreClass;
typedef struct _TpfPersonaStorePrivate TpfPersonaStorePrivate;

#define TPF_TYPE_PERSONA (tpf_persona_get_type ())
#define TPF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA, TpfPersona))
#define TPF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA, TpfPersonaClass))
#define TPF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA))
#define TPF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA))
#define TPF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA, TpfPersonaClass))

typedef struct _TpfPersona TpfPersona;
typedef struct _TpfPersonaClass TpfPersonaClass;

#define TYPE_LOGGER (logger_get_type ())
#define LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER, Logger))
#define LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOGGER, LoggerClass))
#define IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER))
#define IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOGGER))
#define LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOGGER, LoggerClass))

typedef struct _Logger Logger;
typedef struct _LoggerClass LoggerClass;

#define TPF_TYPE_PERSONA_STORE_CACHE (tpf_persona_store_cache_get_type ())
#define TPF_PERSONA_STORE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE_CACHE, TpfPersonaStoreCache))
#define TPF_PERSONA_STORE_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE_CACHE, TpfPersonaStoreCacheClass))
#define TPF_IS_PERSONA_STORE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE_CACHE))
#define TPF_IS_PERSONA_STORE_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE_CACHE))
#define TPF_PERSONA_STORE_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE_CACHE, TpfPersonaStoreCacheClass))

typedef struct _TpfPersonaStoreCache TpfPersonaStoreCache;
typedef struct _TpfPersonaStoreCacheClass TpfPersonaStoreCacheClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TpfPersonaStorePrepareData TpfPersonaStorePrepareData;
typedef struct _TpfPersonaStoreInitialiseFavouriteContactsData TpfPersonaStoreInitialiseFavouriteContactsData;
typedef struct _Block1Data Block1Data;
typedef struct _TpfPersonaStoreNotifyConnectionCbAsyncData TpfPersonaStoreNotifyConnectionCbAsyncData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _TpfPersonaStoreLoadCacheData TpfPersonaStoreLoadCacheData;
typedef struct _TpfPersonaStoreFlushData TpfPersonaStoreFlushData;
typedef struct _TpfPersonaStoreStoreCacheData TpfPersonaStoreStoreCacheData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TpfPersonaStoreRemovePersonaData TpfPersonaStoreRemovePersonaData;
typedef struct _TpfPersonaStoreEnsurePersonaForIdData TpfPersonaStoreEnsurePersonaForIdData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _TpfPersonaStoreAddPersonaFromDetailsData TpfPersonaStoreAddPersonaFromDetailsData;
typedef struct _TpfPersonaStoreChangeIsFavouriteData TpfPersonaStoreChangeIsFavouriteData;
typedef struct _TpfPersonaStoreChangeAliasData TpfPersonaStoreChangeAliasData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define __vala_TpContactInfoField_free0(var) ((var == NULL) ? NULL : (var = (_vala_TpContactInfoField_free (var), NULL)))
typedef struct _TpfPersonaStoreChangeUserBirthdayData TpfPersonaStoreChangeUserBirthdayData;
typedef struct _TpfPersonaStoreChangeUserFullNameData TpfPersonaStoreChangeUserFullNameData;
typedef struct _TpfPersonaStoreChangeUserDetailsData TpfPersonaStoreChangeUserDetailsData;
#define __g_list_free___vala_TpContactInfoField_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free___vala_TpContactInfoField_free0_ (var), NULL)))
typedef struct _TpfPersonaStoreChangeUserContactInfoData TpfPersonaStoreChangeUserContactInfoData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _TpfPersonaStorePopulateCountersData TpfPersonaStorePopulateCountersData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TpfPersonaStore {
	FolksPersonaStore parent_instance;
	TpfPersonaStorePrivate * priv;
	GeeHashSet* _supported_fields;
	GeeSet* _supported_fields_ro;
};

struct _TpfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _TpfPersonaStorePrivate {
	gchar** _always_writeable_properties;
	gint _always_writeable_properties_length1;
	gint __always_writeable_properties_size_;
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	GeeHashSet* _persona_set;
	GeeHashMap* _contact_persona_map;
	GeeHashSet* _favourite_ids;
	GeeHashMap* _avatars;
	TpConnection* _conn;
	TpAccountManager* _account_manager;
	Logger* _logger;
	TpfPersona* _self_persona;
	FolksMaybeBool _can_add_personas;
	FolksMaybeBool _can_alias_personas;
	FolksMaybeBool _can_group_personas;
	FolksMaybeBool _can_remove_personas;
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	gboolean _got_initial_members;
	gboolean _got_initial_self_contact;
	FolksDebug* _debug;
	TpfPersonaStoreCache* _cache;
	GCancellable* _load_cache_cancellable;
	gboolean _cache_needs_update;
	TpAccount* _account;
	ZeitgeistLog* _log;
	ZeitgeistMonitor* _monitor;
};

struct _TpfPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	TpAccountManager* _tmp6_;
	TpAccountManager* _tmp7_;
	TpSimpleClientFactory* _tmp8_;
	TpSimpleClientFactory* _tmp9_;
	TpSimpleClientFactory* factory;
	TpSimpleClientFactory* _tmp10_;
	TpContactFeature* _tmp11_;
	TpContactFeature* _tmp12_;
	gint _tmp12__length1;
	TpAccountManager* _tmp13_;
	TpAccountManager* _tmp14_;
	TpAccountManager* _tmp15_;
	TpAccountManager* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GeeHashMap* _tmp19_;
	GeeHashSet* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	Logger* _tmp23_;
	Logger* _tmp24_;
	Logger* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	TpAccount* _tmp30_;
	TpAccount* _tmp31_;
	TpAccount* _tmp32_;
	TpAccount* _tmp33_;
	TpConnection* _tmp34_;
	TpConnection* _tmp35_;
	TpAccount* _tmp36_;
	TpAccount* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreInitialiseFavouriteContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	Logger* _tmp0_;
	Logger* _tmp1_;
	Logger* _tmp2_;
	gint _tmp3_;
	gchar** _tmp4_;
	gchar** contacts;
	gint contacts_length1;
	gint _contacts_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	TpfPersonaStore * self;
	GeeHashSet* old_personas;
};

struct _TpfPersonaStoreNotifyConnectionCbAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	TpAccount* _tmp4_;
	TpAccount* _tmp5_;
	TpConnection* _tmp6_;
	TpConnection* _tmp7_;
	GQuark _tmp8_;
	GQuark _tmp9_;
	GQuark _tmp10_;
	GQuark _tmp11_;
	GQuark* _tmp12_;
	GQuark* _tmp13_;
	gint _tmp13__length1;
	TpAccount* _tmp14_;
	TpAccount* _tmp15_;
	TpConnection* _tmp16_;
	TpConnection* _tmp17_;
	GQuark _tmp18_;
	gboolean _tmp19_;
	TpAccount* _tmp20_;
	TpAccount* _tmp21_;
	TpConnection* _tmp22_;
	TpConnection* _tmp23_;
	TpConnection* _tmp24_;
	TpConnection* _tmp25_;
	TpContactMetadataStorageType _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gchar* _tmp28_;
	TpConnection* _tmp29_;
	gboolean _tmp30_;
	FolksMaybeBool new_can_alias;
	TpConnection* _tmp31_;
	TpConnectionAliasFlags _tmp32_;
	TpConnectionAliasFlags flags;
	TpConnectionAliasFlags _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	GError* e;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	GError* _tmp39_;
	const gchar* _tmp40_;
	FolksMaybeBool _tmp41_;
	TpConnection* _tmp42_;
	TpConnection* _tmp43_;
	TpConnection* _tmp44_;
	TpConnection* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreLoadCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	GeeHashSet* old_personas;
	gboolean _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	TpAccount* _tmp5_;
	TpAccount* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	TpAccount* _tmp11_;
	TpAccount* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp15_;
	TpAccount* _tmp16_;
	TpAccount* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	GCancellable* _tmp26_;
	GCancellable* cancellable;
	GCancellable* _tmp27_;
	GCancellable* _tmp28_;
	GCancellable* _tmp29_;
	GCancellable* _tmp30_;
	GCancellable* _tmp31_;
	TpfPersonaStoreCache* _tmp32_;
	GCancellable* _tmp33_;
	GeeSet* _tmp34_;
	GeeSet* cached_personas;
	GCancellable* _tmp35_;
	gboolean _tmp36_;
	GCancellable* _tmp37_;
	GeeHashSet* _tmp38_;
	GeeSet* _tmp39_;
	GeeSet* _tmp40_;
	GeeIterator* _tmp41_;
	GeeIterator* _p_it;
	GeeIterator* _tmp42_;
	gboolean _tmp43_;
	GeeIterator* _tmp44_;
	gpointer _tmp45_;
	TpfPersona* p;
	TpfPersona* _tmp46_;
	GeeSet* _tmp47_;
	GeeHashSet* _tmp48_;
	Logger* _tmp49_;
	gchar* _tmp50_;
	gchar** _tmp51_;
	gchar** _tmp52_;
};

struct _TpfPersonaStoreFlushData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeHashSet* _tmp2_;
};

struct _TpfPersonaStoreStoreCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	GeeHashSet* old_personas;
	gboolean _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	TpAccount* _tmp5_;
	TpAccount* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	TpfPersonaStoreCache* _tmp17_;
	GeeHashSet* _tmp18_;
};

struct _TpfPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* tp_persona;
	TpfPersona* _tmp2_;
	TpContact* _tmp3_;
	TpContact* _tmp4_;
	TpfPersona* _tmp5_;
	gboolean _tmp6_;
	FolksPersona* _tmp7_;
	TpfPersona* _tmp8_;
	TpfPersona* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	TpfPersona* _tmp15_;
	TpContact* _tmp16_;
	TpContact* _tmp17_;
	GError* e;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreEnsurePersonaForIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	gchar* contact_id;
	TpfPersona* result;
	TpConnection* _tmp0_;
	const gchar* _tmp1_;
	TpContactFeature* _tmp2_;
	TpContactFeature* _tmp3_;
	gint _tmp3__length1;
	TpContact* _tmp4_;
	TpContact* _tmp5_;
	TpContact* contact;
	TpfPersona* _tmp6_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* contact_id;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* add_message;
	const gchar* _tmp14_;
	TpAccount* _tmp15_;
	TpAccount* _tmp16_;
	TpConnectionStatus _tmp17_;
	TpConnectionStatus status;
	gboolean _tmp18_;
	gboolean _tmp19_;
	TpConnectionStatus _tmp20_;
	TpConnectionStatus _tmp21_;
	gboolean _tmp22_;
	TpConnection* _tmp23_;
	gboolean _tmp24_;
	const gchar* _tmp25_;
	GError* _tmp26_;
	const gchar* _tmp27_;
	TpfPersona* _tmp28_;
	TpfPersona* persona;
	TpfPersona* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gboolean already_exists;
	TpfPersona* _tmp32_;
	TpfPersona* _tmp33_;
	TpfPersona* tp_persona;
	TpfPersona* _tmp34_;
	TpContact* _tmp35_;
	TpContact* _tmp36_;
	const gchar* _tmp37_;
	TpfPersona* _tmp38_;
	gboolean _tmp39_;
	TpfPersona* _tmp40_;
	TpfPersona* _tmp41_;
	FolksPersona* _tmp42_;
	GError* e;
	const gchar* _tmp43_;
	GError* _tmp44_;
	const gchar* _tmp45_;
	GError* _tmp46_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeIsFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	gboolean is_favourite;
	Logger* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	FolksPersona* _tmp3_;
	TpContact* _tmp4_;
	TpContact* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	FolksPersona* _tmp8_;
	TpContact* _tmp9_;
	TpContact* _tmp10_;
	const gchar* _tmp11_;
	const gchar* id;
	gboolean _tmp12_;
	Logger* _tmp13_;
	const gchar* _tmp14_;
	Logger* _tmp15_;
	const gchar* _tmp16_;
	GError* e;
	const gchar* _tmp17_;
	FolksPersona* _tmp18_;
	TpContact* _tmp19_;
	TpContact* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeAliasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	gchar* alias;
	const gchar* _tmp0_;
	TpfPersona* _tmp1_;
	TpContact* _tmp2_;
	TpContact* _tmp3_;
	TpfPersona* _tmp4_;
	const gchar* _tmp5_;
	TpfPersona* _tmp6_;
	TpContact* _tmp7_;
	TpContact* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	TpConnection* _tmp11_;
	TpfPersona* _tmp12_;
	TpContact* _tmp13_;
	TpContact* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	const gchar* _tmp17_;
	GError* e1;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeUserBirthdayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	GDateTime* birthday;
	gchar* birthday_str;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* info_set;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** values;
	gint values_length1;
	gint _values_size_;
	gchar** _tmp8_;
	gchar** parameters;
	gint parameters_length1;
	gint _parameters_size_;
	TpContactInfoField* _tmp9_;
	TpContactInfoField* field;
	TpfPersona* _tmp10_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeUserFullNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	gchar* full_name;
	const gchar* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* info_set;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** values;
	gint values_length1;
	gint _values_size_;
	gchar** _tmp5_;
	gchar** parameters;
	gint parameters_length1;
	gint _parameters_size_;
	TpContactInfoField* _tmp6_;
	TpContactInfoField* field;
	TpfPersona* _tmp7_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeUserDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	GeeSet* details;
	gchar* field_name;
	GeeHashSet* _tmp0_;
	GeeHashSet* info_set;
	GeeSet* _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _afd_it;
	GeeIterator* _tmp3_;
	gboolean _tmp4_;
	GeeIterator* _tmp5_;
	gpointer _tmp6_;
	FolksAbstractFieldDetails* afd;
	FolksAbstractFieldDetails* _tmp7_;
	gconstpointer _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** values;
	gint values_length1;
	gint _values_size_;
	gchar** _tmp12_;
	gchar** parameters;
	gint parameters_length1;
	gint _parameters_size_;
	FolksAbstractFieldDetails* _tmp13_;
	GeeMultiMap* _tmp14_;
	GeeMultiMap* _tmp15_;
	GeeSet* _tmp16_;
	GeeSet* _tmp17_;
	GeeIterator* _tmp18_;
	GeeIterator* _tmp19_;
	GeeIterator* _param_name_it;
	GeeIterator* _tmp20_;
	gboolean _tmp21_;
	GeeIterator* _tmp22_;
	gpointer _tmp23_;
	gchar* param_name;
	FolksAbstractFieldDetails* _tmp24_;
	GeeMultiMap* _tmp25_;
	GeeMultiMap* _tmp26_;
	const gchar* _tmp27_;
	GeeCollection* _tmp28_;
	GeeCollection* param_values;
	GeeCollection* _tmp29_;
	GeeIterator* _tmp30_;
	GeeIterator* _param_value_it;
	GeeIterator* _tmp31_;
	gboolean _tmp32_;
	GeeIterator* _tmp33_;
	gpointer _tmp34_;
	gchar* param_value;
	gchar** _tmp35_;
	gint _tmp35__length1;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar** _tmp42_;
	const gchar* _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	gchar** _tmp45_;
	gint _tmp45__length1;
	TpContactInfoField* _tmp46_;
	TpContactInfoField* field;
	GeeHashSet* _tmp47_;
	TpContactInfoField* _tmp48_;
	TpfPersona* _tmp49_;
	GeeHashSet* _tmp50_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeUserContactInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	GeeHashSet* info_set;
	TpfPersona* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	GeeHashSet* _tmp5_;
	GList* _tmp6_;
	GList* info_list;
	TpAccount* _tmp7_;
	TpAccount* _tmp8_;
	TpConnection* _tmp9_;
	TpConnection* _tmp10_;
	GError* _error_;
	gboolean success;
	TpConnection* _tmp11_;
	GList* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GError* e;
	GError* _tmp15_;
	GError* _tmp16_;
	gboolean _tmp17_;
	GError* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	GError* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GError* _tmp27_;
	GError * _inner_error_;
};

struct _TpfPersonaStorePopulateCountersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	ZeitgeistLog* _tmp0_;
	ZeitgeistLog* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* events;
	ZeitgeistLog* _tmp3_;
	ZeitgeistTimeRange* _tmp4_;
	ZeitgeistTimeRange* _tmp5_;
	GPtrArray* _tmp6_;
	ZeitgeistResultSet* _tmp7_;
	ZeitgeistResultSet* _tmp8_;
	ZeitgeistResultSet* results;
	GeeHashMap* _tmp9_;
	GeeCollection* _tmp10_;
	GeeCollection* _tmp11_;
	GeeCollection* _tmp12_;
	GeeIterator* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _persona_it;
	GeeIterator* _tmp15_;
	gboolean _tmp16_;
	GeeIterator* _tmp17_;
	gpointer _tmp18_;
	TpfPersona* persona;
	TpfPersona* _tmp19_;
	TpfPersona* _tmp20_;
	ZeitgeistResultSet* _tmp21_;
	ZeitgeistResultSet* _tmp22_;
	ZeitgeistResultSet* _e_it;
	ZeitgeistEvent* e;
	ZeitgeistResultSet* _tmp23_;
	ZeitgeistEvent* _tmp24_;
	ZeitgeistEvent* _tmp25_;
	ZeitgeistEvent* _tmp26_;
	ZeitgeistSubject* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* interaction_type;
	gint i;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	ZeitgeistEvent* _tmp34_;
	gint _tmp35_;
	ZeitgeistEvent* _tmp36_;
	gint _tmp37_;
	ZeitgeistSubject* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* id;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	ZeitgeistEvent* _tmp43_;
	GeeMap* _tmp44_;
	GeeMap* _tmp45_;
	GeeCollection* _tmp46_;
	GeeCollection* _tmp47_;
	GeeCollection* _tmp48_;
	GeeIterator* _tmp49_;
	GeeIterator* _tmp50_;
	GeeIterator* _vala1__persona_it;
	GeeIterator* _tmp51_;
	gboolean _tmp52_;
	GeeIterator* _tmp53_;
	gpointer _tmp54_;
	FolksPersona* _vala1_persona;
	FolksPersona* _tmp55_;
	ZeitgeistMonitor* _tmp56_;
	GPtrArray* _tmp57_;
	GPtrArray* monitor_events;
	ZeitgeistTimeRange* _tmp58_;
	ZeitgeistTimeRange* _tmp59_;
	GPtrArray* _tmp60_;
	ZeitgeistMonitor* _tmp61_;
	ZeitgeistMonitor* _tmp62_;
	ZeitgeistLog* _tmp63_;
	ZeitgeistMonitor* _tmp64_;
	GError * _inner_error_;
};


static gpointer tpf_persona_store_parent_class = NULL;
static GeeHashMap* tpf_persona_store__persona_stores_by_account;
static GStaticRecMutex __lock_tpf_persona_store__persona_stores_by_account = {0};
static GeeHashMap* tpf_persona_store__persona_stores_by_account = NULL;
static GeeMap* tpf_persona_store__persona_stores_by_account_ro;
static GeeMap* tpf_persona_store__persona_stores_by_account_ro = NULL;

GType tpf_persona_store_get_type (void) G_GNUC_CONST;
GType tpf_persona_get_type (void) G_GNUC_CONST;
GType logger_get_type (void) G_GNUC_CONST;
GType tpf_persona_store_cache_get_type (void) G_GNUC_CONST;
#define TPF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TPF_TYPE_PERSONA_STORE, TpfPersonaStorePrivate))
enum  {
	TPF_PERSONA_STORE_DUMMY_PROPERTY,
	TPF_PERSONA_STORE_ACCOUNT,
	TPF_PERSONA_STORE_TYPE_ID,
	TPF_PERSONA_STORE_CAN_ADD_PERSONAS,
	TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	TPF_PERSONA_STORE_CAN_GROUP_PERSONAS,
	TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	TPF_PERSONA_STORE_IS_PREPARED,
	TPF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES,
	TPF_PERSONA_STORE_IS_QUIESCENT,
	TPF_PERSONA_STORE_PERSONAS,
	TPF_PERSONA_STORE_SUPPORTED_FIELDS
};
static void _tpf_persona_store_reset (TpfPersonaStore* self);
static void _tpf_persona_store_remove_store_from_map (TpfPersonaStore* store);
static void _tpf_persona_store_debug_print_status (TpfPersonaStore* self, FolksDebug* debug);
static void __tpf_persona_store_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self);
static void _tpf_persona_store_logger_invalidated_cb (TpfPersonaStore* self);
static void __tpf_persona_store_logger_invalidated_cb_logger_invalidated (Logger* _sender, gpointer self);
static void _tpf_persona_store_account_invalidated_cb (TpfPersonaStore* self, guint domain, gint code, const gchar* message);
static void __tpf_persona_store_account_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self);
static void _tpf_persona_store_account_manager_invalidated_cb (TpfPersonaStore* self, guint domain, gint code, const gchar* message);
static void __tpf_persona_store_account_manager_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self);
static void _tpf_persona_store_notify_if_is_quiescent (TpfPersonaStore* self);
static void _tpf_persona_store_force_quiescent (TpfPersonaStore* self);
TpfPersonaStore* tpf_persona_store_new (TpAccount* account);
TpfPersonaStore* tpf_persona_store_construct (GType object_type, TpAccount* account);
static gchar* _tpf_persona_store_format_maybe_bool (TpfPersonaStore* self, FolksMaybeBool input);
gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self);
TpContact* tpf_persona_get_contact (TpfPersona* self);
TpAccount* tpf_persona_store_get_account (TpfPersonaStore* self);
static void _tpf_persona_store_self_contact_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_self_contact_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_contact_list_state_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_contact_list_state_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_contact_list_changed_cb (TpfPersonaStore* self, GPtrArray* added, GPtrArray* removed);
static void __tpf_persona_store_contact_list_changed_cb_tp_connection_contact_list_changed (TpConnection* _sender, GPtrArray* added, GPtrArray* removed, gpointer self);
static void _tpf_persona_store_contact_weak_notify_cb (TpfPersonaStore* self, GObject* obj);
static void __tpf_persona_store_contact_weak_notify_cb_gweak_notify (gpointer self, GObject* object);
static void _tpf_persona_store_remove_store (TpfPersonaStore* self);
static void tpf_persona_store_real_prepare_data_free (gpointer _data);
static void tpf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_prepare_co (TpfPersonaStorePrepareData* _data_);
static void ___lambda6_ (TpfPersonaStore* self, TpAccount* a);
static void ____lambda6__tp_account_manager_account_removed (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void ___lambda7_ (TpfPersonaStore* self, TpAccount* a, gboolean valid);
static void ____lambda7__tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* account, gboolean valid, gpointer self);
static void ___lambda8_ (TpfPersonaStore* self, TpAccount* a);
static void ____lambda8__tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self);
Logger* logger_new (const gchar* account_path);
Logger* logger_construct (GType object_type, const gchar* account_path);
static void _tpf_persona_store_favourite_contacts_changed_cb (TpfPersonaStore* self, gchar** added, int added_length1, gchar** removed, int removed_length1);
static void __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed (Logger* _sender, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self);
static void _tpf_persona_store_initialise_favourite_contacts (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_initialise_favourite_contacts_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void ___lambda9_ (TpfPersonaStore* self, GObject* o, GAsyncResult* r);
static void ____lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tpf_persona_store_notify_connection_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_notify_connection_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_load_cache (TpfPersonaStore* self, GeeHashSet* old_personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_load_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void tpf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_initialise_favourite_contacts_data_free (gpointer _data);
static gboolean _tpf_persona_store_initialise_favourite_contacts_co (TpfPersonaStoreInitialiseFavouriteContactsData* _data_);
void logger_prepare (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean logger_prepare_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void _tpf_persona_store_initialise_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void logger_get_favourite_contacts (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** logger_get_favourite_contacts_finish (Logger* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static TpfPersona* _tpf_persona_store_lookup_persona_by_id (TpfPersonaStore* self, const gchar* id);
void _tpf_persona_set_is_favourite (TpfPersona* self, gboolean is_favourite);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void _tpf_persona_store_set_cache_needs_update (TpfPersonaStore* self);
static void _tpf_persona_store_store_cache (TpfPersonaStore* self, GeeHashSet* old_personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_store_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void ____lambda10_ (Block1Data* _data1_, GObject* o, GAsyncResult* r);
static void ___lambda11_ (TpfPersonaStore* self, GObject* o2, GAsyncResult* r2);
static void ____lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _____lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tpf_persona_store_notify_connection_cb_async (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_notify_connection_cb_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void _tpf_persona_store_notify_connection_cb_async_data_free (gpointer _data);
static gboolean _tpf_persona_store_notify_connection_cb_async_co (TpfPersonaStoreNotifyConnectionCbAsyncData* _data_);
static void _tpf_persona_store_notify_connection_cb_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_unload_cache (TpfPersonaStore* self);
static void _tpf_persona_store_marshall_supported_fields (TpfPersonaStore* self);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
static void _tpf_persona_store_load_cache_data_free (gpointer _data);
static gboolean _tpf_persona_store_load_cache_co (TpfPersonaStoreLoadCacheData* _data_);
static void _tpf_persona_store_load_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _tpf_persona_store_add_persona (TpfPersonaStore* self, TpfPersona* p);
static void tpf_persona_store_real_flush_data_free (gpointer _data);
static void tpf_persona_store_real_flush (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_flush_co (TpfPersonaStoreFlushData* _data_);
static void tpf_persona_store_flush_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_store_cache_data_free (gpointer _data);
static gboolean _tpf_persona_store_store_cache_co (TpfPersonaStoreStoreCacheData* _data_);
static void _tpf_persona_store_store_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void _tpf_persona_store_update_avatar_cache (TpfPersonaStore* self, const gchar* persona_iid, GFile* avatar_file);
GFile* _tpf_persona_store_query_avatar_cache (TpfPersonaStore* self, const gchar* persona_iid);
static gboolean _tpf_persona_store_remove_persona (TpfPersonaStore* self, TpfPersona* p);
TpfPersona* _tpf_persona_store_ensure_persona_for_contact (TpfPersonaStore* self, TpContact* contact);
TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store);
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store);
static void _g_object_unref0_ (gpointer var);
static void _tpf_persona_store_populate_counters (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_populate_counters_finish (TpfPersonaStore* self, GAsyncResult* _res_);
void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value);
static void tpf_persona_store_real_remove_persona_data_free (gpointer _data);
static void tpf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_remove_persona_co (TpfPersonaStoreRemovePersonaData* _data_);
static void tpf_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_ensure_persona_for_id_data_free (gpointer _data);
static void _tpf_persona_store_ensure_persona_for_id (TpfPersonaStore* self, const gchar* contact_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static TpfPersona* _tpf_persona_store_ensure_persona_for_id_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean _tpf_persona_store_ensure_persona_for_id_co (TpfPersonaStoreEnsurePersonaForIdData* _data_);
static void _tpf_persona_store_ensure_persona_for_id_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void tpf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_add_persona_from_details_co (TpfPersonaStoreAddPersonaFromDetailsData* _data_);
static void tpf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_change_is_favourite_data_free (gpointer _data);
void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean tpf_persona_store_change_is_favourite_co (TpfPersonaStoreChangeIsFavouriteData* _data_);
void logger_add_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_add_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void logger_remove_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_remove_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_alias_data_free (gpointer _data);
void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean tpf_persona_store_change_alias_co (TpfPersonaStoreChangeAliasData* _data_);
static void tpf_persona_store_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_change_user_birthday_data_free (gpointer _data);
void tpf_persona_store_change_user_birthday (TpfPersonaStore* self, TpfPersona* persona, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_user_birthday_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean tpf_persona_store_change_user_birthday_co (TpfPersonaStoreChangeUserBirthdayData* _data_);
static TpContactInfoField* _vala_TpContactInfoField_copy (TpContactInfoField* self);
static void _vala_TpContactInfoField_free (TpContactInfoField* self);
static void _tpf_persona_store_change_user_contact_info (TpfPersonaStore* self, TpfPersona* persona, GeeHashSet* info_set, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_change_user_contact_info_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_user_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_change_user_full_name_data_free (gpointer _data);
void tpf_persona_store_change_user_full_name (TpfPersonaStore* self, TpfPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_user_full_name_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean tpf_persona_store_change_user_full_name_co (TpfPersonaStoreChangeUserFullNameData* _data_);
static void tpf_persona_store_change_user_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_change_user_details_data_free (gpointer _data);
void _tpf_persona_store_change_user_details (TpfPersonaStore* self, TpfPersona* persona, GeeSet* details, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _tpf_persona_store_change_user_details_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean _tpf_persona_store_change_user_details_co (TpfPersonaStoreChangeUserDetailsData* _data_);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void _tpf_persona_store_change_user_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_change_user_contact_info_data_free (gpointer _data);
static gboolean _tpf_persona_store_change_user_contact_info_co (TpfPersonaStoreChangeUserContactInfoData* _data_);
static GList* _tpf_persona_store_contact_info_set_to_list (GeeHashSet* info_set);
static void _tpf_persona_store_change_user_contact_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __vala_TpContactInfoField_free0_ (gpointer var);
static void _g_list_free___vala_TpContactInfoField_free0_ (GList* self);
GeeMap* tpf_persona_store_list_persona_stores (void);
static void _tpf_persona_store_store_removed_cb (FolksPersonaStore* store);
static void _tpf_persona_store_add_store_to_map (TpfPersonaStore* store);
static void __tpf_persona_store_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
TpfPersonaStore* tpf_persona_store_dup_for_account (TpAccount* account);
static gchar* _tpf_persona_store_get_iid_from_event_metadata (TpfPersonaStore* self, const gchar* uri);
static void _tpf_persona_store_increase_persona_counter (TpfPersonaStore* self, const gchar* id, const gchar* interaction_type, ZeitgeistEvent* event);
void _tpf_persona_increase_counter (TpfPersona* self, const gchar* id, const gchar* interaction_type, ZeitgeistEvent* event);
static void _tpf_persona_store_handle_new_interaction (TpfPersonaStore* self, ZeitgeistTimeRange* timerange, ZeitgeistResultSet* events);
static GPtrArray* _tpf_persona_store_get_zeitgeist_event_templates (TpfPersonaStore* self);
static void _tpf_persona_store_populate_counters_data_free (gpointer _data);
static gboolean _tpf_persona_store_populate_counters_co (TpfPersonaStorePopulateCountersData* _data_);
static void _tpf_persona_store_populate_counters_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void _tpf_persona_reset_interaction (TpfPersona* self);
static void __tpf_persona_store_handle_new_interaction_zeitgeist_monitor_events_inserted (ZeitgeistMonitor* _sender, ZeitgeistTimeRange* time_range, ZeitgeistResultSet* events, gpointer self);
static void tpf_persona_store_set_account (TpfPersonaStore* self, TpAccount* value);
GeeSet* tpf_persona_store_get_supported_fields (TpfPersonaStore* self);
static GObject * tpf_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
TpfPersonaStoreCache* tpf_persona_store_cache_new (TpfPersonaStore* store);
TpfPersonaStoreCache* tpf_persona_store_cache_construct (GType object_type, TpfPersonaStore* store);
static void tpf_persona_store_finalize (GObject* obj);
static void _vala_tpf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tpf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void __tpf_persona_store_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self) {
	_tpf_persona_store_debug_print_status (self, _sender);
}


static void __tpf_persona_store_logger_invalidated_cb_logger_invalidated (Logger* _sender, gpointer self) {
	_tpf_persona_store_logger_invalidated_cb (self);
}


static void __tpf_persona_store_account_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self) {
	_tpf_persona_store_account_invalidated_cb (self, domain, code, message);
}


static void __tpf_persona_store_account_manager_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self) {
	_tpf_persona_store_account_manager_invalidated_cb (self, domain, code, message);
}


static void _tpf_persona_store_notify_if_is_quiescent (TpfPersonaStore* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->_got_initial_members;
	if (_tmp2_ == TRUE) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->_got_initial_self_contact;
		_tmp1_ = _tmp3_ == TRUE;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_is_quiescent;
		_tmp0_ = _tmp5_ == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
	}
}


static void _tpf_persona_store_force_quiescent (TpfPersonaStore* self) {
	g_return_if_fail (self != NULL);
	self->priv->_got_initial_self_contact = TRUE;
	self->priv->_got_initial_members = TRUE;
	_tpf_persona_store_notify_if_is_quiescent (self);
}


/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to store the {@link Persona}s for the contacts
   * in the Telepathy account provided by `account`.
   *
   * @param account the Telepathy account being represented by the persona store
   */
TpfPersonaStore* tpf_persona_store_construct (GType object_type, TpAccount* account) {
	TpfPersonaStore * self = NULL;
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	TpAccount* _tmp4_;
	const gchar* _tmp5_ = NULL;
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = account;
	_tmp1_ = account;
	_tmp2_ = tp_account_get_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = account;
	_tmp5_ = tp_proxy_get_object_path ((TpProxy*) _tmp4_);
	self = (TpfPersonaStore*) g_object_new (object_type, "account", _tmp0_, "display-name", _tmp3_, "id", _tmp5_, NULL);
	return self;
}


TpfPersonaStore* tpf_persona_store_new (TpAccount* account) {
	return tpf_persona_store_construct (TPF_TYPE_PERSONA_STORE, account);
}


static gchar* _tpf_persona_store_format_maybe_bool (TpfPersonaStore* self, FolksMaybeBool input) {
	gchar* result = NULL;
	FolksMaybeBool _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = input;
	switch (_tmp0_) {
		case FOLKS_MAYBE_BOOL_UNSET:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("unset");
			result = _tmp1_;
			return result;
		}
		case FOLKS_MAYBE_BOOL_TRUE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("true");
			result = _tmp2_;
			return result;
		}
		case FOLKS_MAYBE_BOOL_FALSE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("false");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void _tpf_persona_store_debug_print_status (TpfPersonaStore* self, FolksDebug* debug) {
	static const char domain[] = FOLKS_DEBUG_STATUS_LOG_DOMAIN;
	static const GLogLevelFlags level = G_LOG_LEVEL_INFO;
	FolksDebug* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_;
	FolksDebug* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	TpConnection* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	TpAccountManager* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	TpfPersona* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	FolksMaybeBool _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	FolksMaybeBool _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	FolksMaybeBool _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	FolksMaybeBool _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	FolksDebug* _tmp34_;
	GeeHashSet* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	FolksDebug* _tmp38_;
	FolksDebug* _tmp72_;
	FolksDebug* _tmp73_;
	GeeHashMap* _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	FolksDebug* _tmp77_;
	GeeHashMap* _tmp78_;
	GeeMapIterator* _tmp79_ = NULL;
	GeeMapIterator* iter1;
	FolksDebug* _tmp88_;
	FolksDebug* _tmp89_;
	GeeHashSet* _tmp90_;
	gint _tmp91_;
	gint _tmp92_;
	FolksDebug* _tmp93_;
	FolksDebug* _tmp102_;
	FolksDebug* _tmp103_;
	GeeHashMap* _tmp104_;
	gint _tmp105_;
	gint _tmp106_;
	FolksDebug* _tmp107_;
	FolksDebug* _tmp120_;
	FolksDebug* _tmp121_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (debug != NULL);
	_tmp0_ = debug;
	folks_debug_print_heading (_tmp0_, domain, level, "Tpf.PersonaStore (%p)", self);
	_tmp2_ = self->priv->_is_prepared;
	if (_tmp2_) {
		_tmp1_ = "yes";
	} else {
		_tmp1_ = "no";
	}
	_tmp4_ = self->priv->_got_initial_members;
	if (_tmp4_) {
		_tmp3_ = "yes";
	} else {
		_tmp3_ = "no";
	}
	_tmp6_ = self->priv->_got_initial_self_contact;
	if (_tmp6_) {
		_tmp5_ = "yes";
	} else {
		_tmp5_ = "no";
	}
	_tmp7_ = debug;
	_tmp8_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp1_;
	_tmp11_ = _tmp3_;
	_tmp12_ = _tmp5_;
	_tmp13_ = self->priv->_conn;
	_tmp14_ = g_strdup_printf ("%p", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->_account_manager;
	_tmp17_ = g_strdup_printf ("%p", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->_self_persona;
	_tmp20_ = g_strdup_printf ("%p", _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->_can_add_personas;
	_tmp23_ = _tpf_persona_store_format_maybe_bool (self, _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = self->priv->_can_alias_personas;
	_tmp26_ = _tpf_persona_store_format_maybe_bool (self, _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = self->priv->_can_group_personas;
	_tmp29_ = _tpf_persona_store_format_maybe_bool (self, _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = self->priv->_can_remove_personas;
	_tmp32_ = _tpf_persona_store_format_maybe_bool (self, _tmp31_);
	_tmp33_ = _tmp32_;
	folks_debug_print_key_value_pairs (_tmp7_, domain, level, "ID", _tmp9_, "Prepared?", _tmp10_, "Has initial members?", _tmp11_, "Has self contact?", _tmp12_, "TpConnection", _tmp15_, "TpAccountManager", _tmp18_, "Self-Persona", _tmp21_, "Can add personas?", _tmp24_, "Can alias personas?", _tmp27_, "Can group personas?", _tmp30_, "Can remove personas?", _tmp33_, NULL);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_tmp34_ = debug;
	_tmp35_ = self->priv->_persona_set;
	_tmp36_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp35_);
	_tmp37_ = _tmp36_;
	folks_debug_print_line (_tmp34_, domain, level, "%u Personas:", (guint) _tmp37_);
	_tmp38_ = debug;
	folks_debug_indent (_tmp38_);
	{
		GeeHashSet* _tmp39_;
		GeeIterator* _tmp40_ = NULL;
		GeeIterator* _persona_it;
		_tmp39_ = self->priv->_persona_set;
		_tmp40_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp39_);
		_persona_it = _tmp40_;
		while (TRUE) {
			GeeIterator* _tmp41_;
			gboolean _tmp42_ = FALSE;
			GeeIterator* _tmp43_;
			gpointer _tmp44_ = NULL;
			TpfPersona* persona;
			FolksDebug* _tmp45_;
			TpfPersona* _tmp46_;
			const gchar* _tmp47_ = NULL;
			TpfPersona* _tmp48_;
			gboolean _tmp49_;
			gboolean _tmp50_;
			const gchar* _tmp51_ = NULL;
			TpfPersona* _tmp52_;
			gboolean _tmp53_;
			gboolean _tmp54_;
			FolksDebug* _tmp55_;
			TpfPersona* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			TpfPersona* _tmp59_;
			const gchar* _tmp60_;
			const gchar* _tmp61_;
			TpfPersona* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			TpfPersona* _tmp67_;
			TpContact* _tmp68_;
			TpContact* _tmp69_;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_;
			_tmp41_ = _persona_it;
			_tmp42_ = gee_iterator_next (_tmp41_);
			if (!_tmp42_) {
				break;
			}
			_tmp43_ = _persona_it;
			_tmp44_ = gee_iterator_get (_tmp43_);
			persona = (TpfPersona*) _tmp44_;
			_tmp45_ = debug;
			_tmp46_ = persona;
			folks_debug_print_heading (_tmp45_, domain, level, "Persona (%p)", _tmp46_);
			_tmp48_ = persona;
			_tmp49_ = folks_persona_get_is_user ((FolksPersona*) _tmp48_);
			_tmp50_ = _tmp49_;
			if (_tmp50_) {
				_tmp47_ = "yes";
			} else {
				_tmp47_ = "no";
			}
			_tmp52_ = persona;
			_tmp53_ = tpf_persona_get_is_in_contact_list (_tmp52_);
			_tmp54_ = _tmp53_;
			if (_tmp54_) {
				_tmp51_ = "yes";
			} else {
				_tmp51_ = "no";
			}
			_tmp55_ = debug;
			_tmp56_ = persona;
			_tmp57_ = folks_persona_get_uid ((FolksPersona*) _tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = persona;
			_tmp60_ = folks_persona_get_iid ((FolksPersona*) _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = persona;
			_tmp63_ = folks_persona_get_display_id ((FolksPersona*) _tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = _tmp47_;
			_tmp66_ = _tmp51_;
			_tmp67_ = persona;
			_tmp68_ = tpf_persona_get_contact (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strdup_printf ("%p", _tmp69_);
			_tmp71_ = _tmp70_;
			folks_debug_print_key_value_pairs (_tmp55_, domain, level, "UID", _tmp58_, "IID", _tmp61_, "Display ID", _tmp64_, "User?", _tmp65_, "In contact list?", _tmp66_, "TpContact", _tmp71_, NULL);
			_g_free0 (_tmp71_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp72_ = debug;
	folks_debug_unindent (_tmp72_);
	_tmp73_ = debug;
	_tmp74_ = self->priv->_contact_persona_map;
	_tmp75_ = gee_abstract_map_get_size ((GeeMap*) _tmp74_);
	_tmp76_ = _tmp75_;
	folks_debug_print_line (_tmp73_, domain, level, "%u TpContact–Persona mappings:", (guint) _tmp76_);
	_tmp77_ = debug;
	folks_debug_indent (_tmp77_);
	_tmp78_ = self->priv->_contact_persona_map;
	_tmp79_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp78_);
	iter1 = _tmp79_;
	while (TRUE) {
		GeeMapIterator* _tmp80_;
		gboolean _tmp81_ = FALSE;
		FolksDebug* _tmp82_;
		GeeMapIterator* _tmp83_;
		gpointer _tmp84_ = NULL;
		const gchar* _tmp85_ = NULL;
		GeeMapIterator* _tmp86_;
		gpointer _tmp87_ = NULL;
		_tmp80_ = iter1;
		_tmp81_ = gee_map_iterator_next (_tmp80_);
		if (!(_tmp81_ == TRUE)) {
			break;
		}
		_tmp82_ = debug;
		_tmp83_ = iter1;
		_tmp84_ = gee_map_iterator_get_key (_tmp83_);
		_tmp85_ = tp_contact_get_identifier ((TpContact*) _tmp84_);
		_tmp86_ = iter1;
		_tmp87_ = gee_map_iterator_get_value (_tmp86_);
		folks_debug_print_line (_tmp82_, domain, level, "%s → %p", _tmp85_, (TpfPersona*) _tmp87_);
	}
	_tmp88_ = debug;
	folks_debug_unindent (_tmp88_);
	_tmp89_ = debug;
	_tmp90_ = self->priv->_favourite_ids;
	_tmp91_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp90_);
	_tmp92_ = _tmp91_;
	folks_debug_print_line (_tmp89_, domain, level, "%u favourite TpContact IDs:", (guint) _tmp92_);
	_tmp93_ = debug;
	folks_debug_indent (_tmp93_);
	{
		GeeHashSet* _tmp94_;
		GeeIterator* _tmp95_ = NULL;
		GeeIterator* _id_it;
		_tmp94_ = self->priv->_favourite_ids;
		_tmp95_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp94_);
		_id_it = _tmp95_;
		while (TRUE) {
			GeeIterator* _tmp96_;
			gboolean _tmp97_ = FALSE;
			GeeIterator* _tmp98_;
			gpointer _tmp99_ = NULL;
			gchar* id;
			FolksDebug* _tmp100_;
			const gchar* _tmp101_;
			_tmp96_ = _id_it;
			_tmp97_ = gee_iterator_next (_tmp96_);
			if (!_tmp97_) {
				break;
			}
			_tmp98_ = _id_it;
			_tmp99_ = gee_iterator_get (_tmp98_);
			id = (gchar*) _tmp99_;
			_tmp100_ = debug;
			_tmp101_ = id;
			folks_debug_print_line (_tmp100_, domain, level, "%s", _tmp101_);
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	_tmp102_ = debug;
	folks_debug_unindent (_tmp102_);
	_tmp103_ = debug;
	_tmp104_ = self->priv->_avatars;
	_tmp105_ = gee_abstract_map_get_size ((GeeMap*) _tmp104_);
	_tmp106_ = _tmp105_;
	folks_debug_print_line (_tmp103_, domain, level, "Cached avatars for %u personas:", (guint) _tmp106_);
	_tmp107_ = debug;
	folks_debug_indent (_tmp107_);
	{
		GeeHashMap* _tmp108_;
		GeeSet* _tmp109_;
		GeeSet* _tmp110_;
		GeeSet* _tmp111_;
		GeeIterator* _tmp112_ = NULL;
		GeeIterator* _tmp113_;
		GeeIterator* _id_it;
		_tmp108_ = self->priv->_avatars;
		_tmp109_ = gee_abstract_map_get_keys ((GeeMap*) _tmp108_);
		_tmp110_ = _tmp109_;
		_tmp111_ = _tmp110_;
		_tmp112_ = gee_iterable_iterator ((GeeIterable*) _tmp111_);
		_tmp113_ = _tmp112_;
		_g_object_unref0 (_tmp111_);
		_id_it = _tmp113_;
		while (TRUE) {
			GeeIterator* _tmp114_;
			gboolean _tmp115_ = FALSE;
			GeeIterator* _tmp116_;
			gpointer _tmp117_ = NULL;
			gchar* id;
			FolksDebug* _tmp118_;
			const gchar* _tmp119_;
			_tmp114_ = _id_it;
			_tmp115_ = gee_iterator_next (_tmp114_);
			if (!_tmp115_) {
				break;
			}
			_tmp116_ = _id_it;
			_tmp117_ = gee_iterator_get (_tmp116_);
			id = (gchar*) _tmp117_;
			_tmp118_ = debug;
			_tmp119_ = id;
			folks_debug_print_line (_tmp118_, domain, level, "%s", _tmp119_);
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	_tmp120_ = debug;
	folks_debug_unindent (_tmp120_);
	_tmp121_ = debug;
	folks_debug_print_line (_tmp121_, domain, level, "");
	_g_object_unref0 (iter1);
}


static void __tpf_persona_store_self_contact_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_self_contact_changed_cb (self, _sender, pspec);
}


static void __tpf_persona_store_contact_list_state_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_contact_list_state_changed_cb (self, _sender, pspec);
}


static void __tpf_persona_store_contact_list_changed_cb_tp_connection_contact_list_changed (TpConnection* _sender, GPtrArray* added, GPtrArray* removed, gpointer self) {
	_tpf_persona_store_contact_list_changed_cb (self, added, removed);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __tpf_persona_store_contact_weak_notify_cb_gweak_notify (gpointer self, GObject* object) {
	_tpf_persona_store_contact_weak_notify_cb (self, object);
}


static void _tpf_persona_store_reset (TpfPersonaStore* self) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	TpAccount* _tmp3_;
	TpAccount* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp9_;
	GeeHashMap* _tmp10_;
	GeeHashMap* _tmp11_;
	GeeMap* _tmp12_;
	GeeMap* _tmp13_;
	GeeHashSet* _tmp14_;
	TpConnection* _tmp15_;
	GeeHashMap* _tmp24_;
	GeeHashMap* _tmp33_;
	GeeHashSet* _tmp34_;
	GeeHashSet* _tmp35_;
	GeeSet* _tmp36_;
	GeeSet* _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:388: Resetting Tpf.PersonaStore %p ('%s')", self, _tmp1_);
	_tmp3_ = tpf_persona_store_get_account (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = tp_account_get_protocol (_tmp4_);
	if (g_strcmp0 (_tmp5_, "local-xmpp") == 0) {
		_tmp2_ = TRUE;
	} else {
		TpAccount* _tmp6_;
		TpAccount* _tmp7_;
		const gchar* _tmp8_ = NULL;
		_tmp6_ = tpf_persona_store_get_account (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = tp_account_get_protocol (_tmp7_);
		_tmp2_ = g_strcmp0 (_tmp8_, "irc") == 0;
	}
	_tmp9_ = _tmp2_;
	if (_tmp9_) {
		folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_NONE);
	} else {
		folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_PARTIAL);
	}
	_tmp10_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp10_;
	_tmp11_ = self->priv->_personas;
	_tmp12_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp13_;
	_tmp14_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_set);
	self->priv->_persona_set = _tmp14_;
	self->priv->_cache_needs_update = FALSE;
	_tmp15_ = self->priv->_conn;
	if (_tmp15_ != NULL) {
		TpConnection* _tmp16_;
		guint _tmp17_ = 0U;
		GQuark _tmp18_ = 0U;
		TpConnection* _tmp19_;
		guint _tmp20_ = 0U;
		GQuark _tmp21_ = 0U;
		TpConnection* _tmp22_;
		guint _tmp23_ = 0U;
		_tmp16_ = self->priv->_conn;
		g_signal_parse_name ("notify::self-contact", G_TYPE_OBJECT, &_tmp17_, &_tmp18_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, _tmp18_, NULL, (GCallback) __tpf_persona_store_self_contact_changed_cb_g_object_notify, self);
		_tmp19_ = self->priv->_conn;
		g_signal_parse_name ("notify::contact-list-state", G_TYPE_OBJECT, &_tmp20_, &_tmp21_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp19_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp20_, _tmp21_, NULL, (GCallback) __tpf_persona_store_contact_list_state_changed_cb_g_object_notify, self);
		_tmp22_ = self->priv->_conn;
		g_signal_parse_name ("contact-list-changed", tp_connection_get_type (), &_tmp23_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) __tpf_persona_store_contact_list_changed_cb_tp_connection_contact_list_changed, self);
		_g_object_unref0 (self->priv->_conn);
		self->priv->_conn = NULL;
	}
	_tmp24_ = self->priv->_contact_persona_map;
	if (_tmp24_ != NULL) {
		GeeHashMap* _tmp25_;
		GeeMapIterator* _tmp26_ = NULL;
		GeeMapIterator* iter;
		_tmp25_ = self->priv->_contact_persona_map;
		_tmp26_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp25_);
		iter = _tmp26_;
		while (TRUE) {
			GeeMapIterator* _tmp27_;
			gboolean _tmp28_ = FALSE;
			GeeMapIterator* _tmp29_;
			gpointer _tmp30_ = NULL;
			TpContact* _tmp31_;
			TpContact* contact;
			TpContact* _tmp32_;
			_tmp27_ = iter;
			_tmp28_ = gee_map_iterator_next (_tmp27_);
			if (!(_tmp28_ == TRUE)) {
				break;
			}
			_tmp29_ = iter;
			_tmp30_ = gee_map_iterator_get_key (_tmp29_);
			_tmp31_ = _g_object_ref0 ((TpContact*) _tmp30_);
			contact = _tmp31_;
			_tmp32_ = contact;
			g_object_weak_unref ((GObject*) _tmp32_, __tpf_persona_store_contact_weak_notify_cb_gweak_notify, self);
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (iter);
	}
	_tmp33_ = gee_hash_map_new (tp_contact_get_type (), NULL, NULL, TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_contact_persona_map);
	self->priv->_contact_persona_map = _tmp33_;
	_tmp34_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_g_object_unref0 (self->_supported_fields);
	self->_supported_fields = _tmp34_;
	_tmp35_ = self->_supported_fields;
	_tmp36_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp35_);
	_tmp37_ = _tmp36_;
	_g_object_unref0 (self->_supported_fields_ro);
	self->_supported_fields_ro = _tmp37_;
	_g_object_unref0 (self->priv->_self_persona);
	self->priv->_self_persona = NULL;
}


static void _tpf_persona_store_remove_store (TpfPersonaStore* self) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeHashSet* _tmp2_;
	TpfPersonaStoreCache* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:434: Removing store %s (%p)", _tmp1_, self);
	_tmp2_ = self->priv->_persona_set;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp2_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_tmp3_ = self->priv->_cache;
	folks_object_cache_clear_cache ((FolksObjectCache*) _tmp3_, NULL, NULL);
	g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
}


static void tpf_persona_store_real_prepare_data_free (gpointer _data) {
	TpfPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStorePrepareData, _data_);
}


static void tpf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStorePrepareData* _data_;
	TpfPersonaStore* _tmp0_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tpf_persona_store_real_prepare_co (_data_);
}


static void tpf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaStorePrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the PersonaStore for use.
   *
   * See {@link Folks.PersonaStore.prepare}.
   *
   * @throws GLib.Error currently unused
   */
static void ___lambda6_ (TpfPersonaStore* self, TpAccount* a) {
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* _tmp2_;
	g_return_if_fail (a != NULL);
	_tmp0_ = tpf_persona_store_get_account (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = a;
	if (_tmp1_ == _tmp2_) {
		TpAccount* _tmp3_;
		TpAccount* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = a;
		_tmp4_ = a;
		_tmp5_ = tp_account_get_display_name (_tmp4_);
		_tmp6_ = _tmp5_;
		g_debug ("tpf-persona-store.vala:490: Account %p (‘%s’) removed.", _tmp3_, _tmp6_);
		_tpf_persona_store_remove_store (self);
	}
}


static void ____lambda6__tp_account_manager_account_removed (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	___lambda6_ (self, account);
}


static void ___lambda7_ (TpfPersonaStore* self, TpAccount* a, gboolean valid) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp5_;
	g_return_if_fail (a != NULL);
	_tmp1_ = valid;
	if (!_tmp1_) {
		TpAccount* _tmp2_;
		TpAccount* _tmp3_;
		TpAccount* _tmp4_;
		_tmp2_ = tpf_persona_store_get_account (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = a;
		_tmp0_ = _tmp3_ == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		TpAccount* _tmp6_;
		TpAccount* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = a;
		_tmp7_ = a;
		_tmp8_ = tp_account_get_display_name (_tmp7_);
		_tmp9_ = _tmp8_;
		g_debug ("tpf-persona-store.vala:499: Account %p (‘%s’) invalid.", _tmp6_, _tmp9_);
		_tpf_persona_store_remove_store (self);
	}
}


static void ____lambda7__tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* account, gboolean valid, gpointer self) {
	___lambda7_ (self, account, valid);
}


static void ___lambda8_ (TpfPersonaStore* self, TpAccount* a) {
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* _tmp2_;
	g_return_if_fail (a != NULL);
	_tmp0_ = tpf_persona_store_get_account (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = a;
	if (_tmp1_ == _tmp2_) {
		TpAccount* _tmp3_;
		TpAccount* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = a;
		_tmp4_ = a;
		_tmp5_ = tp_account_get_display_name (_tmp4_);
		_tmp6_ = _tmp5_;
		g_debug ("tpf-persona-store.vala:508: Account %p (‘%s’) disabled.", _tmp3_, _tmp6_);
		_tpf_persona_store_remove_store (self);
	}
}


static void ____lambda8__tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	___lambda8_ (self, account);
}


static void __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed (Logger* _sender, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self) {
	_tpf_persona_store_favourite_contacts_changed_cb (self, added, added_length1, removed, removed_length1);
}


static void ___lambda9_ (TpfPersonaStore* self, GObject* o, GAsyncResult* r) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (r != NULL);
	{
		GAsyncResult* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = r;
		_tpf_persona_store_initialise_favourite_contacts_finish (self, _tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp1_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
		_tmp2_ = _tmp1_;
		folks_internal_profiling_end ("initialising favourite " "contacts in Tpf.PersonaStore (ID: %s)", _tmp2_, NULL);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("tpf-persona-store.vala:536: Failed to initialise favourite contacts: %" \
"s", _tmp4_);
		_g_object_unref0 (self->priv->_logger);
		self->priv->_logger = NULL;
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda9_ (self, source_object, res);
	g_object_unref (self);
}


static void __tpf_persona_store_notify_connection_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_notify_connection_cb (self, _sender, pspec);
}


static void tpf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_real_prepare_co (_data_);
}


static gboolean tpf_persona_store_real_prepare_co (TpfPersonaStorePrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	folks_internal_profiling_start ("preparing Tpf.PersonaStore (ID: %s)", _data_->_tmp1_, NULL);
	_data_->_tmp3_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp3_) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp2_ = _data_->_tmp4_;
	}
	_data_->_tmp5_ = _data_->_tmp2_;
	if (_data_->_tmp5_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = tp_account_manager_dup ();
		_g_object_unref0 (_data_->self->priv->_account_manager);
		_data_->self->priv->_account_manager = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->self->priv->_account_manager;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = tp_proxy_get_factory ((TpProxy*) _data_->_tmp7_);
		_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
		_data_->factory = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->factory;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_new0 (TpContactFeature, 8);
		_data_->_tmp11_[0] = TP_CONTACT_FEATURE_ALIAS;
		_data_->_tmp11_[1] = TP_CONTACT_FEATURE_AVATAR_DATA;
		_data_->_tmp11_[2] = TP_CONTACT_FEATURE_AVATAR_TOKEN;
		_data_->_tmp11_[3] = TP_CONTACT_FEATURE_CAPABILITIES;
		_data_->_tmp11_[4] = TP_CONTACT_FEATURE_CLIENT_TYPES;
		_data_->_tmp11_[5] = TP_CONTACT_FEATURE_PRESENCE;
		_data_->_tmp11_[6] = TP_CONTACT_FEATURE_CONTACT_INFO;
		_data_->_tmp11_[7] = TP_CONTACT_FEATURE_CONTACT_GROUPS;
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp12__length1 = 8;
		tp_simple_client_factory_add_contact_features (_data_->_tmp10_, (guint) 8, _data_->_tmp12_);
		_data_->_tmp12_ = (g_free (_data_->_tmp12_), NULL);
		_data_->_tmp13_ = _data_->self->priv->_account_manager;
		g_signal_connect_object ((TpProxy*) _data_->_tmp13_, "invalidated", (GCallback) __tpf_persona_store_account_manager_invalidated_cb_tp_proxy_invalidated, _data_->self, 0);
		_data_->_tmp14_ = _data_->self->priv->_account_manager;
		g_signal_connect_object (_data_->_tmp14_, "account-removed", (GCallback) ____lambda6__tp_account_manager_account_removed, _data_->self, 0);
		_data_->_tmp15_ = _data_->self->priv->_account_manager;
		g_signal_connect_object (_data_->_tmp15_, "account-validity-changed", (GCallback) ____lambda7__tp_account_manager_account_validity_changed, _data_->self, 0);
		_data_->_tmp16_ = _data_->self->priv->_account_manager;
		g_signal_connect_object (_data_->_tmp16_, "account-disabled", (GCallback) ____lambda8__tp_account_manager_account_disabled, _data_->self, 0);
		_data_->_tmp17_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp18_ = _data_->_tmp17_;
		folks_internal_profiling_point ("created account manager in " "Tpf.PersonaStore (ID: %s)", _data_->_tmp18_, NULL);
		_data_->_tmp19_ = _data_->self->priv->_avatars;
		gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp19_);
		_data_->_tmp20_ = _data_->self->priv->_favourite_ids;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _data_->_tmp20_);
		_data_->_tmp21_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = logger_new (_data_->_tmp22_);
		_g_object_unref0 (_data_->self->priv->_logger);
		_data_->self->priv->_logger = _data_->_tmp23_;
		_data_->_tmp24_ = _data_->self->priv->_logger;
		g_signal_connect_object (_data_->_tmp24_, "invalidated", (GCallback) __tpf_persona_store_logger_invalidated_cb_logger_invalidated, _data_->self, 0);
		_data_->_tmp25_ = _data_->self->priv->_logger;
		g_signal_connect_object (_data_->_tmp25_, "favourite-contacts-changed", (GCallback) __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed, _data_->self, 0);
		_data_->_tmp26_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp27_ = _data_->_tmp26_;
		folks_internal_profiling_start ("initialising favourite contacts in " "Tpf.PersonaStore (ID: %s)", _data_->_tmp27_, NULL);
		_tpf_persona_store_initialise_favourite_contacts (_data_->self, ____lambda9__gasync_ready_callback, g_object_ref (_data_->self));
		_data_->_tmp28_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp29_ = _data_->_tmp28_;
		folks_internal_profiling_point ("created logger in Tpf.PersonaStore " "(ID: %s)", _data_->_tmp29_, NULL);
		_data_->_tmp30_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp31_ = _data_->_tmp30_;
		g_signal_connect_object ((GObject*) _data_->_tmp31_, "notify::connection", (GCallback) __tpf_persona_store_notify_connection_cb_g_object_notify, _data_->self, 0);
		_data_->_tmp32_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp33_ = _data_->_tmp32_;
		_data_->_tmp34_ = tp_account_get_connection (_data_->_tmp33_);
		_data_->_tmp35_ = _data_->_tmp34_;
		if (_data_->_tmp35_ != NULL) {
			_data_->_tmp36_ = tpf_persona_store_get_account (_data_->self);
			_data_->_tmp37_ = _data_->_tmp36_;
			_tpf_persona_store_notify_connection_cb (_data_->self, (GObject*) _data_->_tmp37_, NULL);
		} else {
			_data_->_state_ = 1;
			_tpf_persona_store_load_cache (_data_->self, NULL, tpf_persona_store_prepare_ready, _data_);
			return FALSE;
			_state_1:
			_tpf_persona_store_load_cache_finish (_data_->self, _data_->_res_);
			_tpf_persona_store_force_quiescent (_data_->self);
		}
		_data_->_tmp38_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp39_ = _data_->_tmp38_;
		folks_internal_profiling_point ("loaded cache in Tpf.PersonaStore " "(ID: %s)", _data_->_tmp39_, NULL);
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_g_object_unref0 (_data_->factory);
	}
	__finally6:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp40_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp41_ = _data_->_tmp40_;
	folks_internal_profiling_end ("preparing Tpf.PersonaStore (ID: %s)", _data_->_tmp41_, NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_account_manager_invalidated_cb (TpfPersonaStore* self, guint domain, gint code, const gchar* message) {
	guint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = domain;
	_tmp1_ = code;
	_tmp2_ = message;
	_tmp3_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp4_ = _tmp3_;
	g_debug ("TpAccountManager invalidated (%u, %i, “%s”) for " "Tpf.PersonaStore %p (‘%s’).", _tmp0_, _tmp1_, _tmp2_, self, _tmp4_);
	_tpf_persona_store_remove_store (self);
}


static void _tpf_persona_store_account_invalidated_cb (TpfPersonaStore* self, guint domain, gint code, const gchar* message) {
	guint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = domain;
	_tmp1_ = code;
	_tmp2_ = message;
	_tmp3_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp4_ = _tmp3_;
	g_debug ("TpAccount invalidated (%u, %i, “%s”) for " "Tpf.PersonaStore %p (‘%s’).", _tmp0_, _tmp1_, _tmp2_, self, _tmp4_);
	_tpf_persona_store_remove_store (self);
}


static void _tpf_persona_store_logger_invalidated_cb (TpfPersonaStore* self) {
	Logger* _tmp0_;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_logger;
	g_signal_parse_name ("invalidated", TYPE_LOGGER, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __tpf_persona_store_logger_invalidated_cb_logger_invalidated, self);
	g_debug ("tpf-persona-store.vala:595: Lost connection to the telepathy-logger se" \
"rvice.");
	_g_object_unref0 (self->priv->_logger);
	self->priv->_logger = NULL;
}


static void _tpf_persona_store_initialise_favourite_contacts_data_free (gpointer _data) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreInitialiseFavouriteContactsData, _data_);
}


static void _tpf_persona_store_initialise_favourite_contacts (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	TpfPersonaStore* _tmp0_;
	_data_ = g_slice_new0 (TpfPersonaStoreInitialiseFavouriteContactsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_initialise_favourite_contacts);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_initialise_favourite_contacts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_initialise_favourite_contacts_co (_data_);
}


static void _tpf_persona_store_initialise_favourite_contacts_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_initialise_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_initialise_favourite_contacts_co (_data_);
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean _tpf_persona_store_initialise_favourite_contacts_co (TpfPersonaStoreInitialiseFavouriteContactsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_logger;
	if (_data_->_tmp0_ == NULL) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->_logger;
	_data_->_state_ = 1;
	logger_prepare (_data_->_tmp1_, _tpf_persona_store_initialise_favourite_contacts_ready, _data_);
	return FALSE;
	_state_1:
	logger_prepare_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_logger;
	_data_->_tmp3_ = 0;
	_data_->_state_ = 2;
	logger_get_favourite_contacts (_data_->_tmp2_, _tpf_persona_store_initialise_favourite_contacts_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = logger_get_favourite_contacts_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error_);
	_data_->contacts = _data_->_tmp4_;
	_data_->contacts_length1 = _data_->_tmp3_;
	_data_->_contacts_size_ = _data_->contacts_length1;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->contacts;
	_data_->_tmp5__length1 = _data_->contacts_length1;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_new0 (gchar*, 0 + 1);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp7__length1 = 0;
	_tpf_persona_store_favourite_contacts_changed_cb (_data_->self, _data_->_tmp5_, _data_->_tmp5__length1, _data_->_tmp7_, 0);
	_data_->_tmp7_ = (_vala_array_free (_data_->_tmp7_, _data_->_tmp7__length1, (GDestroyNotify) g_free), NULL);
	_data_->_tmp8_ = _data_->self->priv->_always_writeable_properties;
	_data_->_tmp8__length1 = _data_->self->priv->_always_writeable_properties_length1;
	_data_->_tmp9_ = g_strdup ("is-favourite");
	_vala_array_add6 (&_data_->self->priv->_always_writeable_properties, &_data_->self->priv->_always_writeable_properties_length1, &_data_->self->priv->__always_writeable_properties_size_, _data_->_tmp9_);
	g_object_notify ((GObject*) _data_->self, "always-writeable-properties");
	_data_->contacts = (_vala_array_free (_data_->contacts, _data_->contacts_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static TpfPersona* _tpf_persona_store_lookup_persona_by_id (TpfPersonaStore* self, const gchar* id) {
	TpfPersona* result = NULL;
	GeeHashMap* _tmp0_;
	GeeMapIterator* _tmp1_ = NULL;
	GeeMapIterator* iter;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->_contact_persona_map;
	_tmp1_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GeeMapIterator* _tmp4_;
		gpointer _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_;
		_tmp2_ = iter;
		_tmp3_ = gee_map_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_map_iterator_get_key (_tmp4_);
		_tmp6_ = tp_contact_get_identifier ((TpContact*) _tmp5_);
		_tmp7_ = id;
		if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
			GeeMapIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			_tmp8_ = iter;
			_tmp9_ = gee_map_iterator_get_value (_tmp8_);
			result = (TpfPersona*) _tmp9_;
			_g_object_unref0 (iter);
			return result;
		}
	}
	result = NULL;
	_g_object_unref0 (iter);
	return result;
}


static void _tpf_persona_store_favourite_contacts_changed_cb (TpfPersonaStore* self, gchar** added, int added_length1, gchar** removed, int removed_length1) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = added;
	_tmp0__length1 = added_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp0_;
		id_collection_length1 = _tmp0__length1;
		for (id_it = 0; id_it < _tmp0__length1; id_it = id_it + 1) {
			gchar* _tmp1_;
			gchar* id = NULL;
			_tmp1_ = g_strdup (id_collection[id_it]);
			id = _tmp1_;
			{
				GeeHashSet* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				TpfPersona* _tmp5_ = NULL;
				TpfPersona* p;
				TpfPersona* _tmp6_;
				_tmp2_ = self->priv->_favourite_ids;
				_tmp3_ = id;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp3_);
				_tmp4_ = id;
				_tmp5_ = _tpf_persona_store_lookup_persona_by_id (self, _tmp4_);
				p = _tmp5_;
				_tmp6_ = p;
				if (_tmp6_ != NULL) {
					TpfPersona* _tmp7_;
					_tmp7_ = p;
					_tpf_persona_set_is_favourite (_tmp7_, TRUE);
				}
				_g_object_unref0 (p);
				_g_free0 (id);
			}
		}
	}
	_tmp8_ = removed;
	_tmp8__length1 = removed_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp8_;
		id_collection_length1 = _tmp8__length1;
		for (id_it = 0; id_it < _tmp8__length1; id_it = id_it + 1) {
			gchar* _tmp9_;
			gchar* id = NULL;
			_tmp9_ = g_strdup (id_collection[id_it]);
			id = _tmp9_;
			{
				GeeHashSet* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				TpfPersona* _tmp13_ = NULL;
				TpfPersona* p;
				TpfPersona* _tmp14_;
				_tmp10_ = self->priv->_favourite_ids;
				_tmp11_ = id;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp10_, _tmp11_);
				_tmp12_ = id;
				_tmp13_ = _tpf_persona_store_lookup_persona_by_id (self, _tmp12_);
				p = _tmp13_;
				_tmp14_ = p;
				if (_tmp14_ != NULL) {
					TpfPersona* _tmp15_;
					_tmp15_ = p;
					_tpf_persona_set_is_favourite (_tmp15_, FALSE);
				}
				_g_object_unref0 (p);
				_g_free0 (id);
			}
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		TpfPersonaStore * self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->old_personas);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda11_ (TpfPersonaStore* self, GObject* o2, GAsyncResult* r2) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r2 != NULL);
	_tmp0_ = r2;
	_tpf_persona_store_load_cache_finish (self, _tmp0_);
}


static void ____lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda11_ (self, source_object, res);
	g_object_unref (self);
}


static void ____lambda10_ (Block1Data* _data1_, GObject* o, GAsyncResult* r) {
	TpfPersonaStore * self;
	GAsyncResult* _tmp0_;
	gboolean _tmp1_ = FALSE;
	TpAccount* _tmp2_;
	TpAccount* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp10_;
	self = _data1_->self;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_tpf_persona_store_store_cache_finish (self, _tmp0_);
	_tmp2_ = tpf_persona_store_get_account (self);
	_tmp3_ = _tmp2_;
	g_object_get (_tmp3_, "enabled", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		TpAccount* _tmp6_;
		TpAccount* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
		_tmp6_ = tpf_persona_store_get_account (self);
		_tmp7_ = _tmp6_;
		g_object_get (_tmp7_, "valid", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		_tmp1_ = _tmp9_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		GeeHashSet* _tmp11_;
		_tmp11_ = _data1_->old_personas;
		_tpf_persona_store_load_cache (self, _tmp11_, ____lambda11__gasync_ready_callback, g_object_ref (self));
	}
}


static void _____lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda10_ (self, source_object, res);
	block1_data_unref (self);
}


static void _tpf_persona_store_notify_connection_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* account;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	TpAccount* _tmp4_;
	TpConnection* _tmp5_;
	TpConnection* _tmp6_;
	TpAccount* _tmp7_;
	TpConnection* _tmp8_;
	TpConnection* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, tp_account_get_type ()) ? ((TpAccount*) _tmp0_) : NULL);
	account = _tmp1_;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = account;
	_tmp5_ = tp_account_get_connection (_tmp4_);
	_tmp6_ = _tmp5_;
	g_debug ("tpf-persona-store.vala:656: Account '%s' connection changed to %p", _tmp3_, _tmp6_);
	_tmp7_ = account;
	_tmp8_ = tp_account_get_connection (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		GeeHashSet* _tmp10_;
		TpConnection* _tmp11_;
		_tmp10_ = self->_supported_fields;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
		g_object_notify ((GObject*) self, "supported-fields");
		_tmp11_ = self->priv->_conn;
		if (_tmp11_ != NULL) {
			Block1Data* _data1_;
			GeeHashSet* _tmp12_;
			GeeHashSet* _tmp13_;
			gboolean _tmp14_;
			gboolean old_cache_needs_update;
			gboolean _tmp15_;
			GeeHashSet* _tmp16_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_tmp12_ = self->priv->_persona_set;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_data1_->old_personas = _tmp13_;
			_tmp14_ = self->priv->_cache_needs_update;
			old_cache_needs_update = _tmp14_;
			_tpf_persona_store_reset (self);
			_tmp15_ = old_cache_needs_update;
			if (_tmp15_) {
				_tpf_persona_store_set_cache_needs_update (self);
			}
			_tmp16_ = _data1_->old_personas;
			_tpf_persona_store_store_cache (self, _tmp16_, _____lambda10__gasync_ready_callback, block1_data_ref (_data1_));
			block1_data_unref (_data1_);
			_data1_ = NULL;
		}
		_tpf_persona_store_force_quiescent (self);
		_g_object_unref0 (account);
		return;
	}
	_tpf_persona_store_notify_connection_cb_async (self, NULL, NULL);
	_g_object_unref0 (account);
}


static void _tpf_persona_store_notify_connection_cb_async_data_free (gpointer _data) {
	TpfPersonaStoreNotifyConnectionCbAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreNotifyConnectionCbAsyncData, _data_);
}


static void _tpf_persona_store_notify_connection_cb_async (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreNotifyConnectionCbAsyncData* _data_;
	TpfPersonaStore* _tmp0_;
	_data_ = g_slice_new0 (TpfPersonaStoreNotifyConnectionCbAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_notify_connection_cb_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_notify_connection_cb_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_notify_connection_cb_async_co (_data_);
}


static void _tpf_persona_store_notify_connection_cb_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreNotifyConnectionCbAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_notify_connection_cb_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreNotifyConnectionCbAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_notify_connection_cb_async_co (_data_);
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean _tpf_persona_store_notify_connection_cb_async_co (TpfPersonaStoreNotifyConnectionCbAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("tpf-persona-store.vala:714: _notify_connection_cb_async() for Tpf.Pers" \
"onaStore %p ('%s').", _data_->self, _data_->_tmp1_);
	_data_->_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	folks_internal_profiling_start ("notify connection for Tpf.PersonaStore " "(ID: %s)", _data_->_tmp3_, NULL);
	_data_->_tmp4_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = tp_account_get_connection (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = 0U;
	_data_->_tmp8_ = tp_connection_get_feature_quark_contact_list ();
	_data_->_tmp9_ = 0U;
	_data_->_tmp9_ = tp_connection_get_feature_quark_contact_groups ();
	_data_->_tmp10_ = 0U;
	_data_->_tmp10_ = tp_connection_get_feature_quark_contact_info ();
	_data_->_tmp11_ = 0U;
	_data_->_tmp11_ = tp_connection_get_feature_quark_connected ();
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = g_new0 (GQuark, 5);
	_data_->_tmp12_[0] = _data_->_tmp8_;
	_data_->_tmp12_[1] = _data_->_tmp9_;
	_data_->_tmp12_[2] = _data_->_tmp10_;
	_data_->_tmp12_[3] = _data_->_tmp11_;
	_data_->_tmp12_[4] = (GQuark) 0;
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->_tmp13__length1 = 5;
	_data_->_state_ = 1;
	tp_proxy_prepare_async ((TpProxy*) _data_->_tmp7_, _data_->_tmp13_, _tpf_persona_store_notify_connection_cb_async_ready, _data_);
	return FALSE;
	_state_1:
	tp_proxy_prepare_finish ((TpProxy*) _data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp13_ = (g_free (_data_->_tmp13_), NULL);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = tp_account_get_connection (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_tmp18_ = 0U;
	_data_->_tmp18_ = tp_iface_quark_connection_interface_contact_list ();
	_data_->_tmp19_ = FALSE;
	_data_->_tmp19_ = tp_proxy_has_interface_by_id ((TpProxy*) _data_->_tmp17_, _data_->_tmp18_);
	if (!_data_->_tmp19_) {
		g_debug ("tpf-persona-store.vala:732: %s", "Connection does not implement ContactList iface; " "legacy CMs are not supported any more.");
		_tpf_persona_store_remove_store (_data_->self);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_tpf_persona_store_unload_cache (_data_->self);
	_data_->_tmp20_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = tp_account_get_connection (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp24_ = _g_object_ref0 (_data_->_tmp23_);
	_g_object_unref0 (_data_->self->priv->_conn);
	_data_->self->priv->_conn = _data_->_tmp24_;
	g_object_freeze_notify ((GObject*) _data_->self);
	_tpf_persona_store_marshall_supported_fields (_data_->self);
	g_object_notify ((GObject*) _data_->self, "supported-fields");
	_data_->_tmp25_ = _data_->self->priv->_conn;
	_data_->_tmp26_ = 0;
	_data_->_tmp26_ = tp_connection_get_group_storage (_data_->_tmp25_);
	if (_data_->_tmp26_ != TP_CONTACT_METADATA_STORAGE_TYPE_NONE) {
		_data_->self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_TRUE;
		_data_->_tmp27_ = _data_->self->priv->_always_writeable_properties;
		_data_->_tmp27__length1 = _data_->self->priv->_always_writeable_properties_length1;
		_data_->_tmp28_ = g_strdup ("groups");
		_vala_array_add7 (&_data_->self->priv->_always_writeable_properties, &_data_->self->priv->_always_writeable_properties_length1, &_data_->self->priv->__always_writeable_properties_size_, _data_->_tmp28_);
		g_object_notify ((GObject*) _data_->self, "always-writeable-properties");
	} else {
		_data_->self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_FALSE;
	}
	g_object_notify ((GObject*) _data_->self, "can-group-personas");
	_data_->_tmp29_ = _data_->self->priv->_conn;
	_data_->_tmp30_ = FALSE;
	_data_->_tmp30_ = tp_connection_get_can_change_contact_list (_data_->_tmp29_);
	if (_data_->_tmp30_) {
		_data_->self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_TRUE;
		_data_->self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_TRUE;
	} else {
		_data_->self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_FALSE;
		_data_->self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_FALSE;
	}
	g_object_notify ((GObject*) _data_->self, "can-add-personas");
	g_object_notify ((GObject*) _data_->self, "can-remove-personas");
	_data_->new_can_alias = FOLKS_MAYBE_BOOL_FALSE;
	{
		_data_->_tmp31_ = _data_->self->priv->_conn;
		_data_->_state_ = 2;
		folks_tp_lowlevel_connection_get_alias_flags_async (_data_->_tmp31_, _tpf_persona_store_notify_connection_cb_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp32_ = 0;
		_data_->_tmp32_ = folks_tp_lowlevel_connection_get_alias_flags_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->flags = _data_->_tmp32_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_data_->_tmp33_ = _data_->flags;
		if ((_data_->_tmp33_ & TP_CONNECTION_ALIAS_FLAG_USER_SET) > 0) {
			_data_->new_can_alias = FOLKS_MAYBE_BOOL_TRUE;
			_data_->_tmp34_ = _data_->self->priv->_always_writeable_properties;
			_data_->_tmp34__length1 = _data_->self->priv->_always_writeable_properties_length1;
			_data_->_tmp35_ = g_strdup ("alias");
			_vala_array_add8 (&_data_->self->priv->_always_writeable_properties, &_data_->self->priv->_always_writeable_properties_length1, &_data_->self->priv->__always_writeable_properties_size_, _data_->_tmp35_);
			g_object_notify ((GObject*) _data_->self, "always-writeable-properties");
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _ ("Failed to determine whether we can set aliases on Telepathy account '%" \
"s': %s");
		_data_->_tmp37_ = folks_persona_store_get_display_name ((FolksPersonaStore*) _data_->self);
		_data_->_tmp38_ = _data_->_tmp37_;
		_data_->_tmp39_ = _data_->e;
		_data_->_tmp40_ = _data_->_tmp39_->message;
		g_warning (_data_->_tmp36_, _data_->_tmp38_, _data_->_tmp40_);
		_g_error_free0 (_data_->e);
	}
	__finally8:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp41_ = _data_->new_can_alias;
	_data_->self->priv->_can_alias_personas = _data_->_tmp41_;
	g_object_notify ((GObject*) _data_->self, "can-alias-personas");
	g_object_thaw_notify ((GObject*) _data_->self);
	_data_->_tmp42_ = _data_->self->priv->_conn;
	g_signal_connect_object ((GObject*) _data_->_tmp42_, "notify::self-contact", (GCallback) __tpf_persona_store_self_contact_changed_cb_g_object_notify, _data_->self, 0);
	_data_->_tmp43_ = _data_->self->priv->_conn;
	_tpf_persona_store_self_contact_changed_cb (_data_->self, (GObject*) _data_->_tmp43_, NULL);
	_data_->_tmp44_ = _data_->self->priv->_conn;
	g_signal_connect_object ((GObject*) _data_->_tmp44_, "notify::contact-list-state", (GCallback) __tpf_persona_store_contact_list_state_changed_cb_g_object_notify, _data_->self, 0);
	_data_->_tmp45_ = _data_->self->priv->_conn;
	_tpf_persona_store_contact_list_state_changed_cb (_data_->self, (GObject*) _data_->_tmp45_, NULL);
	_data_->_tmp46_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp47_ = _data_->_tmp46_;
	folks_internal_profiling_end ("notify connection for Tpf.PersonaStore " "(ID: %s)", _data_->_tmp47_, NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_marshall_supported_fields (TpfPersonaStore* self) {
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	TpConnection* _tmp2_;
	TpConnection* _tmp3_;
	TpConnection* _tmp4_;
	TpConnection* connection;
	TpConnection* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tpf_persona_store_get_account (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tp_account_get_connection (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	connection = _tmp4_;
	_tmp5_ = connection;
	if (_tmp5_ != NULL) {
		GeeHashSet* _tmp6_;
		TpConnection* _tmp7_;
		TpContactInfoFlags _tmp8_ = 0;
		TpContactInfoFlags ci_flags;
		TpContactInfoFlags _tmp9_;
		_tmp6_ = self->_supported_fields;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp6_);
		_tmp7_ = connection;
		_tmp8_ = tp_connection_get_contact_info_flags (_tmp7_);
		ci_flags = _tmp8_;
		_tmp9_ = ci_flags;
		if ((_tmp9_ & TP_CONTACT_INFO_FLAG_CAN_SET) != 0) {
			TpConnection* _tmp10_;
			GList* _tmp11_ = NULL;
			GList* field_specs;
			GList* _tmp12_;
			_tmp10_ = connection;
			_tmp11_ = tp_connection_get_contact_info_supported_fields (_tmp10_);
			field_specs = _tmp11_;
			_tmp12_ = field_specs;
			{
				GList* field_spec_collection = NULL;
				GList* field_spec_it = NULL;
				field_spec_collection = _tmp12_;
				for (field_spec_it = field_spec_collection; field_spec_it != NULL; field_spec_it = field_spec_it->next) {
					TpContactInfoFieldSpec* field_spec = NULL;
					field_spec = (TpContactInfoFieldSpec*) field_spec_it->data;
					{
						GeeHashSet* _tmp13_;
						TpContactInfoFieldSpec* _tmp14_;
						const gchar* _tmp15_;
						_tmp13_ = self->_supported_fields;
						_tmp14_ = field_spec;
						_tmp15_ = _tmp14_->name;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
					}
				}
			}
			_g_list_free0 (field_specs);
		}
	}
	_g_object_unref0 (connection);
}


static void _tpf_persona_store_load_cache_data_free (gpointer _data) {
	TpfPersonaStoreLoadCacheData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->old_personas);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreLoadCacheData, _data_);
}


static void _tpf_persona_store_load_cache (TpfPersonaStore* self, GeeHashSet* old_personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreLoadCacheData* _data_;
	TpfPersonaStore* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	_data_ = g_slice_new0 (TpfPersonaStoreLoadCacheData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_load_cache);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_load_cache_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = old_personas;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->old_personas = _tmp2_;
	_tpf_persona_store_load_cache_co (_data_);
}


static void _tpf_persona_store_load_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreLoadCacheData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * If our account is disconnected, we want to continue to export a static
   * view of personas from the cache. old_personas will be notified as removed.
   */
static void _tpf_persona_store_load_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreLoadCacheData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_load_cache_co (_data_);
}


static gboolean _tpf_persona_store_load_cache_co (TpfPersonaStoreLoadCacheData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = FALSE;
	g_object_get (_data_->_tmp2_, "enabled", &_data_->_tmp3_, NULL);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_ == FALSE) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp5_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = FALSE;
		g_object_get (_data_->_tmp6_, "valid", &_data_->_tmp7_, NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp0_ = _data_->_tmp8_ == FALSE;
	}
	_data_->_tmp9_ = _data_->_tmp0_;
	if (_data_->_tmp9_) {
		_data_->_tmp11_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = FALSE;
		g_object_get (_data_->_tmp12_, "enabled", &_data_->_tmp13_, NULL);
		_data_->_tmp14_ = _data_->_tmp13_;
		if (_data_->_tmp14_) {
			_data_->_tmp10_ = "yes";
		} else {
			_data_->_tmp10_ = "no";
		}
		_data_->_tmp16_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = FALSE;
		g_object_get (_data_->_tmp17_, "valid", &_data_->_tmp18_, NULL);
		_data_->_tmp19_ = _data_->_tmp18_;
		if (_data_->_tmp19_) {
			_data_->_tmp15_ = "yes";
		} else {
			_data_->_tmp15_ = "no";
		}
		_data_->_tmp20_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = _data_->_tmp10_;
		_data_->_tmp23_ = _data_->_tmp15_;
		g_debug ("Skipping loading cache for Tpf.PersonaStore %p ('%s'): " "enabled: %s, valid: %s.", _data_->self, _data_->_tmp21_, _data_->_tmp22_, _data_->_tmp23_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp24_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp25_ = _data_->_tmp24_;
	g_debug ("tpf-persona-store.vala:864: Loading cache for Tpf.PersonaStore %p ('%s" \
"').", _data_->self, _data_->_tmp25_);
	_data_->_tmp26_ = g_cancellable_new ();
	_data_->cancellable = _data_->_tmp26_;
	_data_->_tmp27_ = _data_->self->priv->_load_cache_cancellable;
	if (_data_->_tmp27_ != NULL) {
		_data_->_tmp28_ = _data_->self->priv->_load_cache_cancellable;
		g_debug ("tpf-persona-store.vala:870:     Cancelling ongoing loading operation (" \
"cancellable: %p).", _data_->_tmp28_);
		_data_->_tmp29_ = _data_->self->priv->_load_cache_cancellable;
		g_cancellable_cancel (_data_->_tmp29_);
	}
	_data_->_tmp30_ = _data_->cancellable;
	_data_->_tmp31_ = _g_object_ref0 (_data_->_tmp30_);
	_g_object_unref0 (_data_->self->priv->_load_cache_cancellable);
	_data_->self->priv->_load_cache_cancellable = _data_->_tmp31_;
	_data_->_tmp32_ = _data_->self->priv->_cache;
	_data_->_tmp33_ = _data_->cancellable;
	_data_->_state_ = 1;
	folks_object_cache_load_objects ((FolksObjectCache*) _data_->_tmp32_, _data_->_tmp33_, _tpf_persona_store_load_cache_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = folks_object_cache_load_objects_finish ((FolksObjectCache*) _data_->_tmp32_, _data_->_res_);
	_data_->cached_personas = _data_->_tmp34_;
	_data_->_tmp35_ = _data_->cancellable;
	_data_->_tmp36_ = FALSE;
	_data_->_tmp36_ = g_cancellable_is_cancelled (_data_->_tmp35_);
	if (_data_->_tmp36_ == TRUE) {
		_data_->_tmp37_ = _data_->cancellable;
		g_debug ("tpf-persona-store.vala:884:     Cancelled (cancellable: %p).", _data_->_tmp37_);
		_g_object_unref0 (_data_->cached_personas);
		_g_object_unref0 (_data_->cancellable);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_tpf_persona_store_reset (_data_->self);
	_data_->_tmp38_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (_data_->self->priv->_persona_set);
	_data_->self->priv->_persona_set = _data_->_tmp38_;
	_data_->_tmp39_ = _data_->cached_personas;
	if (_data_->_tmp39_ != NULL) {
		{
			_data_->_tmp40_ = _data_->cached_personas;
			_data_->_tmp41_ = NULL;
			_data_->_tmp41_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp40_);
			_data_->_p_it = _data_->_tmp41_;
			while (TRUE) {
				_data_->_tmp42_ = _data_->_p_it;
				_data_->_tmp43_ = FALSE;
				_data_->_tmp43_ = gee_iterator_next (_data_->_tmp42_);
				if (!_data_->_tmp43_) {
					break;
				}
				_data_->_tmp44_ = _data_->_p_it;
				_data_->_tmp45_ = NULL;
				_data_->_tmp45_ = gee_iterator_get (_data_->_tmp44_);
				_data_->p = (TpfPersona*) _data_->_tmp45_;
				_data_->_tmp46_ = _data_->p;
				_tpf_persona_store_add_persona (_data_->self, _data_->_tmp46_);
				_g_object_unref0 (_data_->p);
			}
			_g_object_unref0 (_data_->_p_it);
		}
	}
	_data_->_tmp47_ = _data_->cached_personas;
	_data_->_tmp48_ = _data_->old_personas;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, _data_->_tmp47_, (GeeSet*) _data_->_tmp48_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_data_->self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->self->priv->_can_alias_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->_tmp49_ = _data_->self->priv->_logger;
	if (_data_->_tmp49_ != NULL) {
		_data_->_tmp50_ = g_strdup ("is-favourite");
		_data_->_tmp51_ = NULL;
		_data_->_tmp51_ = g_new0 (gchar*, 1 + 1);
		_data_->_tmp51_[0] = _data_->_tmp50_;
		_data_->self->priv->_always_writeable_properties = (_vala_array_free (_data_->self->priv->_always_writeable_properties, _data_->self->priv->_always_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
		_data_->self->priv->_always_writeable_properties = _data_->_tmp51_;
		_data_->self->priv->_always_writeable_properties_length1 = 1;
		_data_->self->priv->__always_writeable_properties_size_ = _data_->self->priv->_always_writeable_properties_length1;
	} else {
		_data_->_tmp52_ = NULL;
		_data_->_tmp52_ = g_new0 (gchar*, 0 + 1);
		_data_->self->priv->_always_writeable_properties = (_vala_array_free (_data_->self->priv->_always_writeable_properties, _data_->self->priv->_always_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
		_data_->self->priv->_always_writeable_properties = _data_->_tmp52_;
		_data_->self->priv->_always_writeable_properties_length1 = 0;
		_data_->self->priv->__always_writeable_properties_size_ = _data_->self->priv->_always_writeable_properties_length1;
	}
	g_object_notify ((GObject*) _data_->self, "always-writeable-properties");
	_g_object_unref0 (_data_->cached_personas);
	_g_object_unref0 (_data_->cancellable);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_real_flush_data_free (gpointer _data) {
	TpfPersonaStoreFlushData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreFlushData, _data_);
}


static void tpf_persona_store_real_flush (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreFlushData* _data_;
	TpfPersonaStore* _tmp0_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreFlushData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_flush);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_flush_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tpf_persona_store_real_flush_co (_data_);
}


static void tpf_persona_store_real_flush_finish (FolksPersonaStore* base, GAsyncResult* _res_) {
	TpfPersonaStoreFlushData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_flush_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreFlushData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_real_flush_co (_data_);
}


static gboolean tpf_persona_store_real_flush_co (TpfPersonaStoreFlushData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("tpf-persona-store.vala:921: Flushing Tpf.PersonaStore %p (‘%s’).", _data_->self, _data_->_tmp1_);
	_data_->_tmp2_ = _data_->self->priv->_persona_set;
	_data_->_state_ = 1;
	_tpf_persona_store_store_cache (_data_->self, _data_->_tmp2_, tpf_persona_store_flush_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_store_store_cache_finish (_data_->self, _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Called when a contact property is set which is not accessible when either
   * the contact is offline or we're offline. For example, a contact's avatar.
   * This will cause the cache to be stored when the PersonaStore is destroyed.
   */
void _tpf_persona_store_set_cache_needs_update (TpfPersonaStore* self) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("Setting cache as needing an update for Tpf.PersonaStore " "%p (‘%s’).", self, _tmp1_);
	self->priv->_cache_needs_update = TRUE;
}


static void _tpf_persona_store_store_cache_data_free (gpointer _data) {
	TpfPersonaStoreStoreCacheData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->old_personas);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreStoreCacheData, _data_);
}


static void _tpf_persona_store_store_cache (TpfPersonaStore* self, GeeHashSet* old_personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreStoreCacheData* _data_;
	TpfPersonaStore* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	_data_ = g_slice_new0 (TpfPersonaStoreStoreCacheData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_store_cache);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_store_cache_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = old_personas;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->old_personas = _tmp2_;
	_tpf_persona_store_store_cache_co (_data_);
}


static void _tpf_persona_store_store_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreStoreCacheData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * When we're about to disconnect, store the current set of personas to the
   * cache file so that we can access them once offline.
   */
static void _tpf_persona_store_store_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreStoreCacheData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_store_cache_co (_data_);
}


static gboolean _tpf_persona_store_store_cache_co (TpfPersonaStoreStoreCacheData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = FALSE;
	g_object_get (_data_->_tmp2_, "enabled", &_data_->_tmp3_, NULL);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (!_data_->_tmp4_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp5_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = FALSE;
		g_object_get (_data_->_tmp6_, "valid", &_data_->_tmp7_, NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp0_ = !_data_->_tmp8_;
	}
	_data_->_tmp9_ = _data_->_tmp0_;
	if (_data_->_tmp9_) {
		_data_->_tmp10_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp11_ = _data_->_tmp10_;
		g_debug ("Skipping storing cache for Tpf.PersonaStore %p (‘%s’) as " "its TpAccount is disabled or invalid.", _data_->self, _data_->_tmp11_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp12_ = _data_->self->priv->_cache_needs_update;
		if (_data_->_tmp12_ == FALSE) {
			_data_->_tmp13_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
			_data_->_tmp14_ = _data_->_tmp13_;
			g_debug ("Skipping storing cache for Tpf.PersonaStore %p (‘%s’) as " "it doesn’t need an update.", _data_->self, _data_->_tmp14_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp15_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	g_debug ("tpf-persona-store.vala:961: Storing cache for Tpf.PersonaStore %p ('%s" \
"').", _data_->self, _data_->_tmp16_);
	_data_->_tmp17_ = _data_->self->priv->_cache;
	_data_->_tmp18_ = _data_->old_personas;
	_data_->_state_ = 1;
	folks_object_cache_store_objects ((FolksObjectCache*) _data_->_tmp17_, (GeeSet*) _data_->_tmp18_, NULL, _tpf_persona_store_store_cache_ready, _data_);
	return FALSE;
	_state_1:
	folks_object_cache_store_objects_finish ((FolksObjectCache*) _data_->_tmp17_, _data_->_res_);
	_data_->self->priv->_cache_needs_update = FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * When our account is connected again, we can unload the the personas which
   * we're advertising from the cache.
   */
static void _tpf_persona_store_unload_cache (TpfPersonaStore* self) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GCancellable* _tmp2_;
	GeeHashSet* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:973: Unloading cache for Tpf.PersonaStore %p ('" \
"%s').", self, _tmp1_);
	_tmp2_ = self->priv->_load_cache_cancellable;
	if (_tmp2_ != NULL) {
		GCancellable* _tmp3_;
		GCancellable* _tmp4_;
		_tmp3_ = self->priv->_load_cache_cancellable;
		g_debug ("tpf-persona-store.vala:978:     Cancelling ongoing loading operation (" \
"cancellable: %p).", _tmp3_);
		_tmp4_ = self->priv->_load_cache_cancellable;
		g_cancellable_cancel (_tmp4_);
	}
	_tmp5_ = self->priv->_persona_set;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp5_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_tpf_persona_store_reset (self);
}


void _tpf_persona_store_update_avatar_cache (TpfPersonaStore* self, const gchar* persona_iid, GFile* avatar_file) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona_iid != NULL);
	_tmp0_ = avatar_file;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->_avatars;
		_tmp2_ = persona_iid;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, _tmp2_, NULL);
	} else {
		GeeHashMap* _tmp3_;
		const gchar* _tmp4_;
		GFile* _tmp5_;
		_tmp3_ = self->priv->_avatars;
		_tmp4_ = persona_iid;
		_tmp5_ = avatar_file;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_FILE, GFile));
	}
}


GFile* _tpf_persona_store_query_avatar_cache (TpfPersonaStore* self, const gchar* persona_iid) {
	GFile* result = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona_iid != NULL, NULL);
	_tmp0_ = self->priv->_avatars;
	_tmp1_ = persona_iid;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	result = (GFile*) _tmp2_;
	return result;
}


static gboolean _tpf_persona_store_add_persona (TpfPersonaStore* self, TpfPersona* p) {
	gboolean result = FALSE;
	GeeHashSet* _tmp0_;
	TpfPersona* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = self->priv->_persona_set;
	_tmp1_ = p;
	_tmp2_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		TpfPersona* _tmp3_;
		TpfPersona* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GeeHashMap* _tmp7_;
		TpfPersona* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		TpfPersona* _tmp11_;
		_tmp3_ = p;
		_tmp4_ = p;
		_tmp5_ = folks_persona_get_uid ((FolksPersona*) _tmp4_);
		_tmp6_ = _tmp5_;
		g_debug ("tpf-persona-store.vala:1010: Add persona %p with uid %s", _tmp3_, _tmp6_);
		_tmp7_ = self->priv->_personas;
		_tmp8_ = p;
		_tmp9_ = folks_persona_get_iid ((FolksPersona*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = p;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, _tmp10_, _tmp11_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean _tpf_persona_store_remove_persona (TpfPersonaStore* self, TpfPersona* p) {
	gboolean result = FALSE;
	GeeHashSet* _tmp0_;
	TpfPersona* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = self->priv->_persona_set;
	_tmp1_ = p;
	_tmp2_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		TpfPersona* _tmp3_;
		TpfPersona* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GeeHashMap* _tmp7_;
		TpfPersona* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		TpfPersona* _tmp11_;
		TpfPersona* _tmp12_;
		_tmp3_ = p;
		_tmp4_ = p;
		_tmp5_ = folks_persona_get_uid ((FolksPersona*) _tmp4_);
		_tmp6_ = _tmp5_;
		g_debug ("tpf-persona-store.vala:1022: Remove persona %p with uid %s", _tmp3_, _tmp6_);
		_tmp7_ = self->priv->_personas;
		_tmp8_ = p;
		_tmp9_ = folks_persona_get_iid ((FolksPersona*) _tmp8_);
		_tmp10_ = _tmp9_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp10_, NULL);
		_tmp11_ = self->priv->_self_persona;
		_tmp12_ = p;
		if (_tmp11_ == _tmp12_) {
			_g_object_unref0 (self->priv->_self_persona);
			self->priv->_self_persona = NULL;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void _tpf_persona_store_contact_weak_notify_cb (TpfPersonaStore* self, GObject* obj) {
	GeeHashMap* _tmp0_;
	GObject* _tmp1_;
	TpContact* _tmp2_;
	TpContact* contact;
	TpContact* _tmp3_;
	const gchar* _tmp4_ = NULL;
	TpfPersona* persona;
	GeeHashMap* _tmp5_;
	TpContact* _tmp6_;
	gpointer _tmp7_ = NULL;
	TpfPersona* _tmp8_;
	TpfPersona* _tmp9_;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = self->priv->_contact_persona_map;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = obj;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, tp_contact_get_type ()) ? ((TpContact*) _tmp1_) : NULL);
	contact = _tmp2_;
	_tmp3_ = contact;
	_tmp4_ = tp_contact_get_identifier (_tmp3_);
	g_debug ("tpf-persona-store.vala:1043: Weak notify for TpContact %s", _tmp4_);
	persona = NULL;
	_tmp5_ = self->priv->_contact_persona_map;
	_tmp6_ = contact;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, _tmp6_, &_tmp7_);
	_g_object_unref0 (persona);
	persona = _tmp7_;
	_tmp8_ = persona;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (persona);
		_g_object_unref0 (contact);
		return;
	}
	_tmp9_ = persona;
	_tmp10_ = _tpf_persona_store_remove_persona (self, _tmp9_);
	if (_tmp10_) {
		GeeHashSet* _tmp11_;
		GeeHashSet* personas;
		GeeHashSet* _tmp12_;
		TpfPersona* _tmp13_;
		GeeHashSet* _tmp14_;
		g_warning ("tpf-persona-store.vala:1057: A TpContact part of the ContactList is di" \
"sposed");
		_tmp11_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
		personas = _tmp11_;
		_tmp12_ = personas;
		_tmp13_ = persona;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
		_tmp14_ = personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp14_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (personas);
	}
	_g_object_unref0 (persona);
	_g_object_unref0 (contact);
}


TpfPersona* _tpf_persona_store_ensure_persona_for_contact (TpfPersonaStore* self, TpContact* contact) {
	TpfPersona* result = NULL;
	GeeHashMap* _tmp0_;
	TpContact* _tmp1_;
	gpointer _tmp2_ = NULL;
	TpfPersona* persona;
	TpfPersona* _tmp3_;
	TpContact* _tmp6_;
	TpfPersona* _tmp7_;
	GeeHashMap* _tmp8_;
	TpContact* _tmp9_;
	TpfPersona* _tmp10_;
	TpContact* _tmp11_;
	GeeHashSet* _tmp12_;
	TpContact* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean is_favourite;
	TpfPersona* _tmp16_;
	gboolean _tmp17_;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_;
	TpfPersona* _tmp20_;
	TpfPersona* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	TpContact* _tmp24_;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = self->priv->_contact_persona_map;
	_tmp1_ = contact;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	persona = (TpfPersona*) _tmp2_;
	_tmp3_ = persona;
	if (_tmp3_ != NULL) {
		TpfPersona* _tmp4_;
		TpfPersona* _tmp5_;
		_tmp4_ = persona;
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TPF_TYPE_PERSONA, TpfPersona));
		result = _tmp5_;
		_g_object_unref0 (persona);
		return result;
	}
	_tmp6_ = contact;
	_tmp7_ = tpf_persona_new (_tmp6_, self);
	_g_object_unref0 (persona);
	persona = _tmp7_;
	_tmp8_ = self->priv->_contact_persona_map;
	_tmp9_ = contact;
	_tmp10_ = persona;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = contact;
	g_object_weak_ref ((GObject*) _tmp11_, __tpf_persona_store_contact_weak_notify_cb_gweak_notify, self);
	_tmp12_ = self->priv->_favourite_ids;
	_tmp13_ = contact;
	_tmp14_ = tp_contact_get_identifier (_tmp13_);
	_tmp15_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp12_, _tmp14_);
	is_favourite = _tmp15_;
	_tmp16_ = persona;
	_tmp17_ = is_favourite;
	_tpf_persona_set_is_favourite (_tmp16_, _tmp17_);
	_tmp19_ = is_favourite;
	if (_tmp19_) {
		_tmp18_ = "yes";
	} else {
		_tmp18_ = "no";
	}
	_tmp20_ = persona;
	_tmp21_ = persona;
	_tmp22_ = folks_persona_get_uid ((FolksPersona*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = contact;
	_tmp25_ = tp_contact_get_identifier (_tmp24_);
	_tmp26_ = _tmp18_;
	g_debug ("tpf-persona-store.vala:1080: Persona %p with uid %s created for TpCont" \
"act %s, favourite: %s", _tmp20_, _tmp23_, _tmp25_, _tmp26_);
	result = persona;
	return result;
}


static void _tpf_persona_store_self_contact_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	TpConnection* _tmp0_;
	TpContact* _tmp1_;
	TpContact* _tmp2_;
	TpContact* _tmp3_;
	TpContact* contact;
	GeeHashSet* _tmp4_;
	GeeHashSet* personas_added;
	GeeHashSet* _tmp5_;
	GeeHashSet* personas_removed;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	TpfPersona* _tmp8_;
	gboolean _tmp12_;
	gboolean _tmp15_;
	TpContact* _tmp18_;
	GeeHashSet* _tmp25_;
	GeeHashSet* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->_conn;
	_tmp1_ = tp_connection_get_self_contact (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	contact = _tmp3_;
	_tmp4_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	personas_added = _tmp4_;
	_tmp5_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	personas_removed = _tmp5_;
	_tmp8_ = self->priv->_self_persona;
	if (_tmp8_ != NULL) {
		TpfPersona* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->_self_persona;
		_tmp10_ = tpf_persona_get_is_in_contact_list (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp7_ = !_tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp12_ = _tmp7_;
	if (_tmp12_) {
		TpfPersona* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = self->priv->_self_persona;
		_tmp14_ = _tpf_persona_store_remove_persona (self, _tmp13_);
		_tmp6_ = _tmp14_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp15_ = _tmp6_;
	if (_tmp15_) {
		GeeHashSet* _tmp16_;
		TpfPersona* _tmp17_;
		_tmp16_ = personas_removed;
		_tmp17_ = self->priv->_self_persona;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
	}
	_g_object_unref0 (self->priv->_self_persona);
	self->priv->_self_persona = NULL;
	_tmp18_ = contact;
	if (_tmp18_ != NULL) {
		TpContact* _tmp19_;
		TpfPersona* _tmp20_ = NULL;
		TpfPersona* _tmp21_;
		gboolean _tmp22_ = FALSE;
		_tmp19_ = contact;
		_tmp20_ = _tpf_persona_store_ensure_persona_for_contact (self, _tmp19_);
		_g_object_unref0 (self->priv->_self_persona);
		self->priv->_self_persona = _tmp20_;
		_tmp21_ = self->priv->_self_persona;
		_tmp22_ = _tpf_persona_store_add_persona (self, _tmp21_);
		if (_tmp22_) {
			GeeHashSet* _tmp23_;
			TpfPersona* _tmp24_;
			_tmp23_ = personas_added;
			_tmp24_ = self->priv->_self_persona;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
		}
	}
	_tmp25_ = personas_added;
	_tmp26_ = personas_removed;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp25_, (GeeSet*) _tmp26_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	self->priv->_got_initial_self_contact = TRUE;
	_tpf_persona_store_notify_if_is_quiescent (self);
	_g_object_unref0 (personas_removed);
	_g_object_unref0 (personas_added);
	_g_object_unref0 (contact);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _tpf_persona_store_contact_list_state_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	TpConnection* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	TpConnection* _tmp3_;
	TpConnection* _tmp4_;
	GPtrArray* _tmp5_ = NULL;
	GPtrArray* _tmp6_;
	GPtrArray* _tmp7_;
	GPtrArray* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->_conn;
	_tmp1_ = tp_connection_get_contact_list_state (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint) TP_CONTACT_LIST_STATE_SUCCESS)) {
		return;
	}
	_tmp3_ = self->priv->_conn;
	g_signal_connect_object (_tmp3_, "contact-list-changed", (GCallback) __tpf_persona_store_contact_list_changed_cb_tp_connection_contact_list_changed, self, 0);
	_tmp4_ = self->priv->_conn;
	_tmp5_ = tp_connection_dup_contact_list (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_tmp8_ = _tmp7_;
	_tpf_persona_store_contact_list_changed_cb (self, _tmp6_, _tmp8_);
	_g_ptr_array_unref0 (_tmp8_);
	_g_ptr_array_unref0 (_tmp6_);
	self->priv->_got_initial_members = TRUE;
	_tpf_persona_store_populate_counters (self, NULL, NULL);
	_tpf_persona_store_notify_if_is_quiescent (self);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void _tpf_persona_store_contact_list_changed_cb (TpfPersonaStore* self, GPtrArray* added, GPtrArray* removed) {
	GeeHashSet* _tmp0_;
	GeeHashSet* personas_added;
	GeeHashSet* _tmp1_;
	GeeHashSet* personas_removed;
	GPtrArray* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GPtrArray* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GPtrArray* _tmp8_;
	gpointer* _tmp9_;
	gint _tmp9__length1;
	GPtrArray* _tmp21_;
	gpointer* _tmp22_;
	gint _tmp22__length1;
	GeeHashSet* _tmp37_;
	GeeHashSet* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	_tmp0_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	personas_added = _tmp0_;
	_tmp1_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	personas_removed = _tmp1_;
	_tmp2_ = added;
	_tmp3_ = g_ptr_array_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = removed;
	_tmp6_ = g_ptr_array_get_length (_tmp5_);
	_tmp7_ = _tmp6_;
	g_debug ("tpf-persona-store.vala:1139: contact list changed: %d added, %d remove" \
"d", _tmp4_, _tmp7_);
	_tmp8_ = added;
	_tmp9_ = _tmp8_->pdata;
	_tmp9__length1 = (gint) _tmp8_->len;
	{
		TpContact** contact_collection = NULL;
		gint contact_collection_length1 = 0;
		gint _contact_collection_size_ = 0;
		gint contact_it = 0;
		contact_collection = _tmp9_;
		contact_collection_length1 = _tmp9__length1;
		for (contact_it = 0; contact_it < _tmp9__length1; contact_it = contact_it + 1) {
			TpContact* _tmp10_;
			TpContact* contact = NULL;
			_tmp10_ = _g_object_ref0 (contact_collection[contact_it]);
			contact = _tmp10_;
			{
				TpContact* _tmp11_;
				TpfPersona* _tmp12_ = NULL;
				TpfPersona* persona;
				TpfPersona* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				TpfPersona* _tmp17_;
				gboolean _tmp18_ = FALSE;
				_tmp11_ = contact;
				_tmp12_ = _tpf_persona_store_ensure_persona_for_contact (self, _tmp11_);
				persona = _tmp12_;
				_tmp13_ = persona;
				_tmp14_ = tpf_persona_get_is_in_contact_list (_tmp13_);
				_tmp15_ = _tmp14_;
				if (!_tmp15_) {
					TpfPersona* _tmp16_;
					_tmp16_ = persona;
					tpf_persona_set_is_in_contact_list (_tmp16_, TRUE);
				}
				_tmp17_ = persona;
				_tmp18_ = _tpf_persona_store_add_persona (self, _tmp17_);
				if (_tmp18_) {
					GeeHashSet* _tmp19_;
					TpfPersona* _tmp20_;
					_tmp19_ = personas_added;
					_tmp20_ = persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
				}
				_g_object_unref0 (persona);
				_g_object_unref0 (contact);
			}
		}
	}
	_tmp21_ = removed;
	_tmp22_ = _tmp21_->pdata;
	_tmp22__length1 = (gint) _tmp21_->len;
	{
		TpContact** contact_collection = NULL;
		gint contact_collection_length1 = 0;
		gint _contact_collection_size_ = 0;
		gint contact_it = 0;
		contact_collection = _tmp22_;
		contact_collection_length1 = _tmp22__length1;
		for (contact_it = 0; contact_it < _tmp22__length1; contact_it = contact_it + 1) {
			TpContact* _tmp23_;
			TpContact* contact = NULL;
			_tmp23_ = _g_object_ref0 (contact_collection[contact_it]);
			contact = _tmp23_;
			{
				GeeHashMap* _tmp24_;
				TpContact* _tmp25_;
				gpointer _tmp26_ = NULL;
				TpfPersona* persona;
				TpfPersona* _tmp27_;
				TpfPersona* _tmp30_;
				TpfPersona* _tmp31_;
				TpfPersona* _tmp33_;
				gboolean _tmp34_ = FALSE;
				_tmp24_ = self->priv->_contact_persona_map;
				_tmp25_ = contact;
				_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, _tmp25_);
				persona = (TpfPersona*) _tmp26_;
				_tmp27_ = persona;
				if (_tmp27_ == NULL) {
					TpContact* _tmp28_;
					const gchar* _tmp29_ = NULL;
					_tmp28_ = contact;
					_tmp29_ = tp_contact_get_identifier (_tmp28_);
					g_warning ("tpf-persona-store.vala:1163: Unknown TpContact removed from ContactLis" \
"t: %s", _tmp29_);
					_g_object_unref0 (persona);
					_g_object_unref0 (contact);
					continue;
				}
				_tmp30_ = persona;
				_tmp31_ = self->priv->_self_persona;
				if (_tmp30_ == _tmp31_) {
					TpfPersona* _tmp32_;
					_tmp32_ = persona;
					tpf_persona_set_is_in_contact_list (_tmp32_, FALSE);
					_g_object_unref0 (persona);
					_g_object_unref0 (contact);
					continue;
				}
				_tmp33_ = persona;
				_tmp34_ = _tpf_persona_store_remove_persona (self, _tmp33_);
				if (_tmp34_) {
					GeeHashSet* _tmp35_;
					TpfPersona* _tmp36_;
					_tmp35_ = personas_removed;
					_tmp36_ = persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp36_);
				}
				_g_object_unref0 (persona);
				_g_object_unref0 (contact);
			}
		}
	}
	_tmp37_ = personas_added;
	_tmp38_ = personas_removed;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp37_, (GeeSet*) _tmp38_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_g_object_unref0 (personas_removed);
	_g_object_unref0 (personas_added);
}


static void tpf_persona_store_real_remove_persona_data_free (gpointer _data) {
	TpfPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreRemovePersonaData, _data_);
}


static void tpf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreRemovePersonaData* _data_;
	TpfPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	tpf_persona_store_real_remove_persona_co (_data_);
}


static void tpf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   *
   * @throws Folks.PersonaStoreError.UNSUPPORTED_ON_USER if `persona` is the
   * local user — removing the local user isn’t supported
   * @throws Folks.PersonaStoreError.REMOVE_FAILED if removing the contact
   * failed
   */
static void tpf_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreRemovePersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_real_remove_persona_co (_data_);
}


static gboolean tpf_persona_store_real_remove_persona_co (TpfPersonaStoreRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, TPF_TYPE_PERSONA, TpfPersona));
	_data_->tp_persona = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->tp_persona;
	_data_->_tmp3_ = tpf_persona_get_contact (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp5_ = _data_->tp_persona;
		g_warning ("Skipping server-side removal of Tpf.Persona %p because " "it has no attached TpContact", _data_->_tmp5_);
		_g_object_unref0 (_data_->tp_persona);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->persona;
	_data_->_tmp8_ = _data_->self->priv->_self_persona;
	if (_data_->_tmp7_ == G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, FOLKS_TYPE_PERSONA, FolksPersona)) {
		_data_->_tmp9_ = _data_->tp_persona;
		_data_->_tmp10_ = tpf_persona_get_is_in_contact_list (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp6_ = _data_->_tmp11_ == FALSE;
	} else {
		_data_->_tmp6_ = FALSE;
	}
	_data_->_tmp12_ = _data_->_tmp6_;
	if (_data_->_tmp12_) {
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _ ("Telepathy contacts representing the local user may not be removed.");
		_data_->_tmp14_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER, _data_->_tmp13_);
		_data_->_inner_error_ = _data_->_tmp14_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->tp_persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp15_ = _data_->tp_persona;
		_data_->_tmp16_ = tpf_persona_get_contact (_data_->_tmp15_);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_state_ = 1;
		tp_contact_remove_async (_data_->_tmp17_, tpf_persona_store_remove_persona_ready, _data_);
		return FALSE;
		_state_1:
		tp_contact_remove_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _ ("Failed to remove a persona from store: %s");
		_data_->_tmp19_ = _data_->e;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		_data_->_tmp21_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_REMOVE_FAILED, _data_->_tmp18_, _data_->_tmp20_);
		_data_->_inner_error_ = _data_->_tmp21_;
		_g_error_free0 (_data_->e);
		goto __finally9;
	}
	__finally9:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->tp_persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->tp_persona);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_ensure_persona_for_id_data_free (gpointer _data) {
	TpfPersonaStoreEnsurePersonaForIdData* _data_;
	_data_ = _data;
	_g_free0 (_data_->contact_id);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreEnsurePersonaForIdData, _data_);
}


static void _tpf_persona_store_ensure_persona_for_id (TpfPersonaStore* self, const gchar* contact_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreEnsurePersonaForIdData* _data_;
	TpfPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (TpfPersonaStoreEnsurePersonaForIdData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_ensure_persona_for_id);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_ensure_persona_for_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = contact_id;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->contact_id = _tmp2_;
	_tpf_persona_store_ensure_persona_for_id_co (_data_);
}


static TpfPersona* _tpf_persona_store_ensure_persona_for_id_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersona* result;
	TpfPersonaStoreEnsurePersonaForIdData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _tpf_persona_store_ensure_persona_for_id_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreEnsurePersonaForIdData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_ensure_persona_for_id_co (_data_);
}


static gboolean _tpf_persona_store_ensure_persona_for_id_co (TpfPersonaStoreEnsurePersonaForIdData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_conn;
	_data_->_tmp1_ = _data_->contact_id;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_new0 (TpContactFeature, 0);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = 0;
	_data_->_state_ = 1;
	tp_connection_dup_contact_by_id_async (_data_->_tmp0_, _data_->_tmp1_, (guint) 0, _data_->_tmp3_, _tpf_persona_store_ensure_persona_for_id_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = tp_connection_dup_contact_by_id_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp3_ = (g_free (_data_->_tmp3_), NULL);
	_data_->contact = _data_->_tmp5_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _tpf_persona_store_ensure_persona_for_contact (_data_->self, _data_->contact);
	_data_->result = _data_->_tmp6_;
	_g_object_unref0 (_data_->contact);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->contact);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreAddPersonaFromDetailsData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void tpf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	TpfPersonaStore* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
	_data_->details = _tmp2_;
	tpf_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* tpf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * @throws Folks.PersonaStoreError.INVALID_ARGUMENT if the `contact` key was
   * not provided in `details`
   * @throws Folks.PersonaStoreError.STORE_OFFLINE if the CM is offline
   * @throws Folks.PersonaStoreError.CREATE_FAILED if adding the contact failed
   */
static void tpf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_real_add_persona_from_details_co (_data_);
}


static gboolean tpf_persona_store_real_add_persona_from_details_co (TpfPersonaStoreAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->details;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = tp_asv_get_string (_data_->_tmp0_, "contact");
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
	_data_->contact_id = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->contact_id;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _ ("Persona store (%s, %s) requires the following details:\n" \
"    contact (provided: '%s')\n");
		_data_->_tmp5_ = folks_persona_store_get_type_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->contact_id;
		_data_->_tmp10_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT, _data_->_tmp4_, _data_->_tmp6_, _data_->_tmp8_, _data_->_tmp9_);
		_data_->_inner_error_ = _data_->_tmp10_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->contact_id);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->contact_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp11_ = _data_->details;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = tp_asv_get_string (_data_->_tmp11_, "message");
	_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
	_data_->add_message = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->add_message;
	if (g_strcmp0 (_data_->_tmp14_, "") == 0) {
		_g_free0 (_data_->add_message);
		_data_->add_message = NULL;
	}
	_data_->_tmp15_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = 0;
	_data_->_tmp17_ = tp_account_get_connection_status (_data_->_tmp16_, NULL);
	_data_->status = _data_->_tmp17_;
	_data_->_tmp20_ = _data_->status;
	if (_data_->_tmp20_ == TP_CONNECTION_STATUS_DISCONNECTED) {
		_data_->_tmp19_ = TRUE;
	} else {
		_data_->_tmp21_ = _data_->status;
		_data_->_tmp19_ = _data_->_tmp21_ == TP_CONNECTION_STATUS_CONNECTING;
	}
	_data_->_tmp22_ = _data_->_tmp19_;
	if (_data_->_tmp22_) {
		_data_->_tmp18_ = TRUE;
	} else {
		_data_->_tmp23_ = _data_->self->priv->_conn;
		_data_->_tmp18_ = _data_->_tmp23_ == NULL;
	}
	_data_->_tmp24_ = _data_->_tmp18_;
	if (_data_->_tmp24_) {
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _ ("Cannot create a new Telepathy contact while offline.");
		_data_->_tmp26_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp25_);
		_data_->_inner_error_ = _data_->_tmp26_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->add_message);
			_g_free0 (_data_->contact_id);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->add_message);
			_g_free0 (_data_->contact_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp27_ = _data_->contact_id;
		_data_->_state_ = 1;
		_tpf_persona_store_ensure_persona_for_id (_data_->self, _data_->_tmp27_, tpf_persona_store_add_persona_from_details_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _tpf_persona_store_ensure_persona_for_id_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->persona = _data_->_tmp28_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		_data_->_tmp29_ = _data_->persona;
		_data_->_tmp30_ = tpf_persona_get_is_in_contact_list (_data_->_tmp29_);
		_data_->_tmp31_ = _data_->_tmp30_;
		_data_->already_exists = _data_->_tmp31_;
		_data_->_tmp32_ = _data_->persona;
		_data_->_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp32_, TPF_TYPE_PERSONA, TpfPersona));
		_data_->tp_persona = _data_->_tmp33_;
		_data_->_tmp34_ = _data_->tp_persona;
		_data_->_tmp35_ = tpf_persona_get_contact (_data_->_tmp34_);
		_data_->_tmp36_ = _data_->_tmp35_;
		_data_->_tmp37_ = _data_->add_message;
		_data_->_state_ = 2;
		tp_contact_request_subscription_async (_data_->_tmp36_, _data_->_tmp37_, tpf_persona_store_add_persona_from_details_ready, _data_);
		return FALSE;
		_state_2:
		tp_contact_request_subscription_finish (_data_->_tmp36_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->tp_persona);
			_g_object_unref0 (_data_->persona);
			goto __catch10_g_error;
		}
		_data_->_tmp39_ = _data_->already_exists;
		if (_data_->_tmp39_) {
			_data_->_tmp38_ = NULL;
		} else {
			_data_->_tmp40_ = _data_->persona;
			_data_->_tmp38_ = _data_->_tmp40_;
		}
		_data_->_tmp41_ = _data_->_tmp38_;
		_data_->_tmp42_ = _g_object_ref0 ((FolksPersona*) _data_->_tmp41_);
		_data_->result = _data_->_tmp42_;
		_g_object_unref0 (_data_->tp_persona);
		_g_object_unref0 (_data_->persona);
		_g_free0 (_data_->add_message);
		_g_free0 (_data_->contact_id);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally10;
	__catch10_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp43_ = NULL;
		_data_->_tmp43_ = _ ("Failed to add a persona from details: %s");
		_data_->_tmp44_ = _data_->e;
		_data_->_tmp45_ = _data_->_tmp44_->message;
		_data_->_tmp46_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, _data_->_tmp43_, _data_->_tmp45_);
		_data_->_inner_error_ = _data_->_tmp46_;
		_g_error_free0 (_data_->e);
		goto __finally10;
	}
	__finally10:
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->add_message);
		_g_free0 (_data_->contact_id);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_g_free0 (_data_->add_message);
		_g_free0 (_data_->contact_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_free0 (_data_->add_message);
	_g_free0 (_data_->contact_id);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_is_favourite_data_free (gpointer _data) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeIsFavouriteData, _data_);
}


void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	TpfPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	gboolean _tmp3_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeIsFavouriteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_is_favourite);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_is_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = is_favourite;
	_data_->is_favourite = _tmp3_;
	tpf_persona_store_change_is_favourite_co (_data_);
}


void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the favourite status of a persona in this store.
   *
   * This function is idempotent, but relies upon having a connection to the
   * Telepathy logger service, so may fail if that connection is not present.
   */
static void tpf_persona_store_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_change_is_favourite_co (_data_);
}


static gboolean tpf_persona_store_change_is_favourite_co (TpfPersonaStoreChangeIsFavouriteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_logger;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _ ("Failed to change favorite without a connection to the telepathy-logger" \
" service.");
		_data_->_tmp2_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp1_);
		_data_->_inner_error_ = _data_->_tmp2_;
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp3_ = _data_->persona;
	_data_->_tmp4_ = tpf_persona_get_contact (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, TPF_TYPE_PERSONA, TpfPersona));
	_data_->_tmp5_ = _data_->_tmp4_;
	if (_data_->_tmp5_ == NULL) {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _ ("Failed to change favorite status of Telepathy Persona because it has n" \
"o attached TpContact.");
		_data_->_tmp7_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_INVALID_VALUE, _data_->_tmp6_);
		_data_->_inner_error_ = _data_->_tmp7_;
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp8_ = _data_->persona;
		_data_->_tmp9_ = tpf_persona_get_contact (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, TPF_TYPE_PERSONA, TpfPersona));
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = tp_contact_get_identifier (_data_->_tmp10_);
		_data_->id = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->is_favourite;
		if (_data_->_tmp12_) {
			_data_->_tmp13_ = _data_->self->priv->_logger;
			_data_->_tmp14_ = _data_->id;
			_data_->_state_ = 1;
			logger_add_favourite_contact (_data_->_tmp13_, _data_->_tmp14_, tpf_persona_store_change_is_favourite_ready, _data_);
			return FALSE;
			_state_1:
			logger_add_favourite_contact_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch11_g_error;
			}
		} else {
			_data_->_tmp15_ = _data_->self->priv->_logger;
			_data_->_tmp16_ = _data_->id;
			_data_->_state_ = 2;
			logger_remove_favourite_contact (_data_->_tmp15_, _data_->_tmp16_, tpf_persona_store_change_is_favourite_ready, _data_);
			return FALSE;
			_state_2:
			logger_remove_favourite_contact_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch11_g_error;
			}
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _ ("Failed to change favorite status for Telepathy contact ‘%s’.");
		_data_->_tmp18_ = _data_->persona;
		_data_->_tmp19_ = tpf_persona_get_contact (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, TPF_TYPE_PERSONA, TpfPersona));
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp21_ = tp_contact_get_identifier (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp17_, _data_->_tmp22_);
		_data_->_inner_error_ = _data_->_tmp23_;
		_g_error_free0 (_data_->e);
		goto __finally11;
	}
	__finally11:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_alias_data_free (gpointer _data) {
	TpfPersonaStoreChangeAliasData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->alias);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeAliasData, _data_);
}


void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeAliasData* _data_;
	TpfPersonaStore* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeAliasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_alias);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_alias_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = alias;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->alias = _tmp4_;
	tpf_persona_store_change_alias_co (_data_);
}


void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeAliasData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeAliasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_change_alias_co (_data_);
}


static gboolean tpf_persona_store_change_alias_co (TpfPersonaStoreChangeAliasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->alias;
	if (_data_->_tmp0_ == NULL) {
		_data_->alias = "";
	}
	_data_->_tmp1_ = _data_->persona;
	_data_->_tmp2_ = tpf_persona_get_contact (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = _data_->persona;
		_data_->_tmp5_ = _data_->alias;
		g_warning ("Skipping Tpf.Persona %p alias change to '%s' because it " "has no attached TpContact", _data_->_tmp4_, _data_->_tmp5_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp6_ = _data_->persona;
		_data_->_tmp7_ = tpf_persona_get_contact (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = tp_contact_get_identifier (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->alias;
		g_debug ("tpf-persona-store.vala:1355: Changing alias of persona %s to '%s'.", _data_->_tmp9_, _data_->_tmp10_);
		_data_->_tmp11_ = _data_->self->priv->_conn;
		_data_->_tmp12_ = _data_->persona;
		_data_->_tmp13_ = tpf_persona_get_contact (_data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = tp_contact_get_handle (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = _data_->alias;
		_data_->_state_ = 1;
		folks_tp_lowlevel_connection_set_contact_alias_async (_data_->_tmp11_, (guint) ((TpHandle) _data_->_tmp16_), _data_->_tmp17_, tpf_persona_store_change_alias_ready, _data_);
		return FALSE;
		_state_1:
		folks_tp_lowlevel_connection_set_contact_alias_finish (_data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		_data_->e1 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _ ("Failed to change contact's alias: %s");
		_data_->_tmp19_ = _data_->e1;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		_data_->_tmp21_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp18_, _data_->_tmp20_);
		_data_->_inner_error_ = _data_->_tmp21_;
		_g_error_free0 (_data_->e1);
		goto __finally12;
	}
	__finally12:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_user_birthday_data_free (gpointer _data) {
	TpfPersonaStoreChangeUserBirthdayData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_date_time_unref0 (_data_->birthday);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeUserBirthdayData, _data_);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


void tpf_persona_store_change_user_birthday (TpfPersonaStore* self, TpfPersona* persona, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserBirthdayData* _data_;
	TpfPersonaStore* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeUserBirthdayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_user_birthday);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_user_birthday_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = birthday;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	_data_->birthday = _tmp4_;
	tpf_persona_store_change_user_birthday_co (_data_);
}


void tpf_persona_store_change_user_birthday_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeUserBirthdayData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


static TpContactInfoField* _vala_TpContactInfoField_copy (TpContactInfoField* self) {
	return g_boxed_copy (tp_contact_info_field_get_type (), self);
}


static void _vala_TpContactInfoField_free (TpContactInfoField* self) {
	g_boxed_free (tp_contact_info_field_get_type (), self);
}


static void tpf_persona_store_change_user_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserBirthdayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_change_user_birthday_co (_data_);
}


static gboolean tpf_persona_store_change_user_birthday_co (TpfPersonaStoreChangeUserBirthdayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->birthday;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_strdup ("");
		_g_free0 (_data_->birthday_str);
		_data_->birthday_str = _data_->_tmp1_;
	} else {
		_data_->_tmp2_ = _data_->birthday;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_date_time_to_string (_data_->_tmp2_);
		_g_free0 (_data_->birthday_str);
		_data_->birthday_str = _data_->_tmp3_;
	}
	_data_->_tmp4_ = gee_hash_set_new (tp_contact_info_field_get_type (), (GBoxedCopyFunc) _vala_TpContactInfoField_copy, _vala_TpContactInfoField_free, NULL, NULL);
	_data_->info_set = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->birthday_str;
	_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp7_[0] = _data_->_tmp6_;
	_data_->values = _data_->_tmp7_;
	_data_->values_length1 = 1;
	_data_->_values_size_ = _data_->values_length1;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp8_[0] = NULL;
	_data_->parameters = _data_->_tmp8_;
	_data_->parameters_length1 = 1;
	_data_->_parameters_size_ = _data_->parameters_length1;
	_data_->_tmp9_ = tp_contact_info_field_new ("bday", _data_->parameters, _data_->values);
	_data_->field = _data_->_tmp9_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->info_set, _data_->field);
	_data_->_tmp10_ = _data_->persona;
	_data_->_state_ = 1;
	_tpf_persona_store_change_user_contact_info (_data_->self, _data_->_tmp10_, _data_->info_set, tpf_persona_store_change_user_birthday_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_store_change_user_contact_info_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->info_set);
			_g_free0 (_data_->birthday_str);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->info_set);
			_g_free0 (_data_->birthday_str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	__vala_TpContactInfoField_free0 (_data_->field);
	_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
	_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->info_set);
	_g_free0 (_data_->birthday_str);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_user_full_name_data_free (gpointer _data) {
	TpfPersonaStoreChangeUserFullNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeUserFullNameData, _data_);
}


void tpf_persona_store_change_user_full_name (TpfPersonaStore* self, TpfPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserFullNameData* _data_;
	TpfPersonaStore* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeUserFullNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_user_full_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_user_full_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = full_name;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->full_name = _tmp4_;
	tpf_persona_store_change_user_full_name_co (_data_);
}


void tpf_persona_store_change_user_full_name_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeUserFullNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_change_user_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserFullNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_change_user_full_name_co (_data_);
}


static gboolean tpf_persona_store_change_user_full_name_co (TpfPersonaStoreChangeUserFullNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->full_name;
	if (_data_->_tmp0_ == NULL) {
		_data_->full_name = "";
	}
	_data_->_tmp1_ = gee_hash_set_new (tp_contact_info_field_get_type (), (GBoxedCopyFunc) _vala_TpContactInfoField_copy, _vala_TpContactInfoField_free, NULL, NULL);
	_data_->info_set = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->full_name;
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp4_[0] = _data_->_tmp3_;
	_data_->values = _data_->_tmp4_;
	_data_->values_length1 = 1;
	_data_->_values_size_ = _data_->values_length1;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp5_[0] = NULL;
	_data_->parameters = _data_->_tmp5_;
	_data_->parameters_length1 = 1;
	_data_->_parameters_size_ = _data_->parameters_length1;
	_data_->_tmp6_ = tp_contact_info_field_new ("fn", _data_->parameters, _data_->values);
	_data_->field = _data_->_tmp6_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->info_set, _data_->field);
	_data_->_tmp7_ = _data_->persona;
	_data_->_state_ = 1;
	_tpf_persona_store_change_user_contact_info (_data_->self, _data_->_tmp7_, _data_->info_set, tpf_persona_store_change_user_full_name_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_store_change_user_contact_info_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->info_set);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->info_set);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	__vala_TpContactInfoField_free0 (_data_->field);
	_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
	_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->info_set);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_change_user_details_data_free (gpointer _data) {
	TpfPersonaStoreChangeUserDetailsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->details);
	_g_free0 (_data_->field_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeUserDetailsData, _data_);
}


void _tpf_persona_store_change_user_details (TpfPersonaStore* self, TpfPersona* persona, GeeSet* details, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserDetailsData* _data_;
	TpfPersonaStore* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeUserDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_change_user_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_change_user_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = details;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->details = _tmp4_;
	_tmp5_ = field_name;
	_tmp6_ = g_strdup (_tmp5_);
	_data_->field_name = _tmp6_;
	_tpf_persona_store_change_user_details_co (_data_);
}


void _tpf_persona_store_change_user_details_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeUserDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _tpf_persona_store_change_user_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_change_user_details_co (_data_);
}


static gboolean _tpf_persona_store_change_user_details_co (TpfPersonaStoreChangeUserDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_hash_set_new (tp_contact_info_field_get_type (), (GBoxedCopyFunc) _vala_TpContactInfoField_copy, _vala_TpContactInfoField_free, NULL, NULL);
	_data_->info_set = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->details;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp1_);
		_data_->_afd_it = _data_->_tmp2_;
		while (TRUE) {
			_data_->_tmp3_ = _data_->_afd_it;
			_data_->_tmp4_ = FALSE;
			_data_->_tmp4_ = gee_iterator_next (_data_->_tmp3_);
			if (!_data_->_tmp4_) {
				break;
			}
			_data_->_tmp5_ = _data_->_afd_it;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = gee_iterator_get (_data_->_tmp5_);
			_data_->afd = (FolksAbstractFieldDetails*) _data_->_tmp6_;
			_data_->_tmp7_ = _data_->afd;
			_data_->_tmp8_ = folks_abstract_field_details_get_value (_data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = g_strdup ((const gchar*) _data_->_tmp9_);
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = g_new0 (gchar*, 1 + 1);
			_data_->_tmp11_[0] = _data_->_tmp10_;
			_data_->values = _data_->_tmp11_;
			_data_->values_length1 = 1;
			_data_->_values_size_ = _data_->values_length1;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = g_new0 (gchar*, 0 + 1);
			_data_->parameters = _data_->_tmp12_;
			_data_->parameters_length1 = 0;
			_data_->_parameters_size_ = _data_->parameters_length1;
			{
				_data_->_tmp13_ = _data_->afd;
				_data_->_tmp14_ = folks_abstract_field_details_get_parameters (_data_->_tmp13_);
				_data_->_tmp15_ = _data_->_tmp14_;
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = gee_multi_map_get_keys (_data_->_tmp15_);
				_data_->_tmp17_ = _data_->_tmp16_;
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp17_);
				_data_->_tmp19_ = _data_->_tmp18_;
				_g_object_unref0 (_data_->_tmp17_);
				_data_->_param_name_it = _data_->_tmp19_;
				while (TRUE) {
					_data_->_tmp20_ = _data_->_param_name_it;
					_data_->_tmp21_ = FALSE;
					_data_->_tmp21_ = gee_iterator_next (_data_->_tmp20_);
					if (!_data_->_tmp21_) {
						break;
					}
					_data_->_tmp22_ = _data_->_param_name_it;
					_data_->_tmp23_ = NULL;
					_data_->_tmp23_ = gee_iterator_get (_data_->_tmp22_);
					_data_->param_name = (gchar*) _data_->_tmp23_;
					_data_->_tmp24_ = _data_->afd;
					_data_->_tmp25_ = folks_abstract_field_details_get_parameters (_data_->_tmp24_);
					_data_->_tmp26_ = _data_->_tmp25_;
					_data_->_tmp27_ = _data_->param_name;
					_data_->_tmp28_ = NULL;
					_data_->_tmp28_ = gee_multi_map_get (_data_->_tmp26_, _data_->_tmp27_);
					_data_->param_values = _data_->_tmp28_;
					{
						_data_->_tmp29_ = _data_->param_values;
						_data_->_tmp30_ = NULL;
						_data_->_tmp30_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp29_);
						_data_->_param_value_it = _data_->_tmp30_;
						while (TRUE) {
							_data_->_tmp31_ = _data_->_param_value_it;
							_data_->_tmp32_ = FALSE;
							_data_->_tmp32_ = gee_iterator_next (_data_->_tmp31_);
							if (!_data_->_tmp32_) {
								break;
							}
							_data_->_tmp33_ = _data_->_param_value_it;
							_data_->_tmp34_ = NULL;
							_data_->_tmp34_ = gee_iterator_get (_data_->_tmp33_);
							_data_->param_value = (gchar*) _data_->_tmp34_;
							_data_->_tmp35_ = _data_->parameters;
							_data_->_tmp35__length1 = _data_->parameters_length1;
							_data_->_tmp36_ = _data_->param_name;
							_data_->_tmp37_ = NULL;
							_data_->_tmp37_ = string_to_string (_data_->_tmp36_);
							_data_->_tmp38_ = _data_->param_value;
							_data_->_tmp39_ = NULL;
							_data_->_tmp39_ = string_to_string (_data_->_tmp38_);
							_data_->_tmp40_ = NULL;
							_data_->_tmp40_ = g_strconcat (_data_->_tmp37_, "=", _data_->_tmp39_, NULL);
							_vala_array_add9 (&_data_->parameters, &_data_->parameters_length1, &_data_->_parameters_size_, _data_->_tmp40_);
							_g_free0 (_data_->param_value);
						}
						_g_object_unref0 (_data_->_param_value_it);
					}
					_g_object_unref0 (_data_->param_values);
					_g_free0 (_data_->param_name);
				}
				_g_object_unref0 (_data_->_param_name_it);
			}
			_data_->_tmp41_ = _data_->parameters;
			_data_->_tmp41__length1 = _data_->parameters_length1;
			if (_data_->_tmp41__length1 == 0) {
				_data_->_tmp42_ = NULL;
				_data_->_tmp42_ = g_new0 (gchar*, 1 + 1);
				_data_->_tmp42_[0] = NULL;
				_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
				_data_->parameters = _data_->_tmp42_;
				_data_->parameters_length1 = 1;
				_data_->_parameters_size_ = _data_->parameters_length1;
			}
			_data_->_tmp43_ = _data_->field_name;
			_data_->_tmp44_ = _data_->parameters;
			_data_->_tmp44__length1 = _data_->parameters_length1;
			_data_->_tmp45_ = _data_->values;
			_data_->_tmp45__length1 = _data_->values_length1;
			_data_->_tmp46_ = tp_contact_info_field_new (_data_->_tmp43_, _data_->_tmp44_, _data_->_tmp45_);
			_data_->field = _data_->_tmp46_;
			_data_->_tmp47_ = _data_->info_set;
			_data_->_tmp48_ = _data_->field;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp47_, _data_->_tmp48_);
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->afd);
		}
		_g_object_unref0 (_data_->_afd_it);
	}
	_data_->_tmp49_ = _data_->persona;
	_data_->_tmp50_ = _data_->info_set;
	_data_->_state_ = 1;
	_tpf_persona_store_change_user_contact_info (_data_->self, _data_->_tmp49_, _data_->_tmp50_, _tpf_persona_store_change_user_details_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_store_change_user_contact_info_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->info_set);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->info_set);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->info_set);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_change_user_contact_info_data_free (gpointer _data) {
	TpfPersonaStoreChangeUserContactInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->info_set);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeUserContactInfoData, _data_);
}


static void _tpf_persona_store_change_user_contact_info (TpfPersonaStore* self, TpfPersona* persona, GeeHashSet* info_set, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserContactInfoData* _data_;
	TpfPersonaStore* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeHashSet* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeUserContactInfoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_change_user_contact_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_change_user_contact_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = info_set;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->info_set = _tmp4_;
	_tpf_persona_store_change_user_contact_info_co (_data_);
}


static void _tpf_persona_store_change_user_contact_info_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeUserContactInfoData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_change_user_contact_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserContactInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_change_user_contact_info_co (_data_);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void __vala_TpContactInfoField_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_TpContactInfoField_free (var), NULL));
}


static void _g_list_free___vala_TpContactInfoField_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) __vala_TpContactInfoField_free0_, NULL);
	g_list_free (self);
}


static gboolean _tpf_persona_store_change_user_contact_info_co (TpfPersonaStoreChangeUserContactInfoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = folks_persona_get_is_user ((FolksPersona*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _ ("Extended information may only be set on the user's Telepathy contact.");
		_data_->_tmp4_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_NON_USER, _data_->_tmp3_);
		_data_->_inner_error_ = _data_->_tmp4_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp5_ = _data_->info_set;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _tpf_persona_store_contact_info_set_to_list (_data_->_tmp5_);
	_data_->info_list = _data_->_tmp6_;
	_data_->_tmp7_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = tp_account_get_connection (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	if (_data_->_tmp10_ != NULL) {
		_data_->_error_ = NULL;
		_data_->success = FALSE;
		{
			_data_->_tmp11_ = _data_->self->priv->_conn;
			_data_->_tmp12_ = _data_->info_list;
			_data_->_state_ = 1;
			tp_connection_set_contact_info_async (_data_->_tmp11_, _data_->_tmp12_, _tpf_persona_store_change_user_contact_info_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp13_ = FALSE;
			_data_->_tmp13_ = tp_connection_set_contact_info_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp14_ = _data_->_tmp13_;
			if (_data_->_inner_error_ != NULL) {
				goto __catch13_g_error;
			}
			_data_->success = _data_->_tmp14_;
		}
		goto __finally13;
		__catch13_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp15_ = _data_->e;
			_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
			_g_error_free0 (_data_->_error_);
			_data_->_error_ = _data_->_tmp16_;
			_g_error_free0 (_data_->e);
		}
		__finally13:
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_error_free0 (_data_->_error_);
				__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_error_free0 (_data_->_error_);
				__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_tmp18_ = _data_->_error_;
		if (_data_->_tmp18_ != NULL) {
			_data_->_tmp17_ = TRUE;
		} else {
			_data_->_tmp19_ = _data_->success;
			_data_->_tmp17_ = !_data_->_tmp19_;
		}
		_data_->_tmp20_ = _data_->_tmp17_;
		if (_data_->_tmp20_) {
			_data_->_tmp22_ = _data_->_error_;
			if (_data_->_tmp22_ != NULL) {
				_data_->_tmp23_ = _data_->_error_;
				_data_->_tmp24_ = _data_->_tmp23_->message;
				_data_->_tmp21_ = _data_->_tmp24_;
			} else {
				_data_->_tmp21_ = "(reason unknown)";
			}
			_data_->_tmp25_ = _data_->_tmp21_;
			g_warning ("Failed to set extended information on user's " "Telepathy contact: %s", _data_->_tmp25_);
		}
		_g_error_free0 (_data_->_error_);
	} else {
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _ ("Extended information cannot be written because the store is disconnect" \
"ed.");
		_data_->_tmp27_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp26_);
		_data_->_inner_error_ = _data_->_tmp27_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GList* _tpf_persona_store_contact_info_set_to_list (GeeHashSet* info_set) {
	GList* result = NULL;
	GList* info_list;
	g_return_val_if_fail (info_set != NULL, NULL);
	info_list = NULL;
	{
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _info_field_it;
		_tmp0_ = info_set;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_info_field_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			TpContactInfoField* info_field;
			TpContactInfoField* _tmp6_;
			const gchar* _tmp7_;
			TpContactInfoField* _tmp8_;
			gchar** _tmp9_;
			gint _tmp9__length1;
			TpContactInfoField* _tmp10_;
			gchar** _tmp11_;
			gint _tmp11__length1;
			TpContactInfoField* _tmp12_;
			_tmp2_ = _info_field_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _info_field_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			info_field = (TpContactInfoField*) _tmp5_;
			_tmp6_ = info_field;
			_tmp7_ = _tmp6_->field_name;
			_tmp8_ = info_field;
			_tmp9_ = _tmp8_->parameters;
			_tmp9__length1 = _vala_array_length (_tmp8_->parameters);
			_tmp10_ = info_field;
			_tmp11_ = _tmp10_->field_value;
			_tmp11__length1 = _vala_array_length (_tmp10_->field_value);
			_tmp12_ = tp_contact_info_field_new (_tmp7_, _tmp9_, _tmp11_);
			info_list = g_list_prepend (info_list, _tmp12_);
			__vala_TpContactInfoField_free0 (info_field);
		}
		_g_object_unref0 (_info_field_it);
	}
	info_list = g_list_reverse (info_list);
	result = info_list;
	return result;
}


/**
   * Get a map of all the currently constructed {@link Tpf.PersonaStore}s.
   *
   * If a {@link Folks.BackendStore} has been prepared, this map will be
   * complete, containing every store known to the Telepathy account manager. If
   * no {@link Folks.BackendStore} has been prepared, this map will only contain
   * the stores which have been created by calling
   * {@link Tpf.PersonaStore.dup_for_account}.
   *
   * This map is read-only. Use {@link Folks.BackendStore} or
   * {@link Tpf.PersonaStore.dup_for_account} to add stores.
   *
   * @return map from {@link Folks.PersonaStore.id} to {@link Tpf.PersonaStore}
   * @since 0.6.6
   */
GeeMap* tpf_persona_store_list_persona_stores (void) {
	GeeMap* result = NULL;
	GeeMap* store = NULL;
	GError * _inner_error_ = NULL;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = tpf_persona_store__persona_stores_by_account;
		g_static_rec_mutex_lock (&__lock_tpf_persona_store__persona_stores_by_account);
		{
			GeeHashMap* _tmp1_;
			GeeMap* _tmp6_;
			_tmp1_ = tpf_persona_store__persona_stores_by_account;
			if (_tmp1_ == NULL) {
				GeeHashMap* _tmp2_;
				GeeHashMap* _tmp3_;
				GeeMap* _tmp4_;
				GeeMap* _tmp5_;
				_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TPF_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account);
				tpf_persona_store__persona_stores_by_account = _tmp2_;
				_tmp3_ = tpf_persona_store__persona_stores_by_account;
				_tmp4_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp3_);
				_tmp5_ = _tmp4_;
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account_ro);
				tpf_persona_store__persona_stores_by_account_ro = _tmp5_;
			}
			_tmp6_ = tpf_persona_store__persona_stores_by_account_ro;
			store = _tmp6_;
		}
		__finally14:
		{
			GeeHashMap* _tmp7_;
			_tmp7_ = tpf_persona_store__persona_stores_by_account;
			g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = store;
	return result;
}


static void _tpf_persona_store_store_removed_cb (FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tpf_persona_store_remove_store_from_map (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore));
}


static void __tpf_persona_store_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_tpf_persona_store_store_removed_cb (_sender);
}


static void _tpf_persona_store_add_store_to_map (TpfPersonaStore* store) {
	TpfPersonaStore* _tmp0_;
	TpfPersonaStore* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("tpf-persona-store.vala:1543: Adding PersonaStore %p ('%s') to map.", _tmp0_, _tmp3_);
	{
		GeeHashMap* _tmp4_;
		_tmp4_ = tpf_persona_store__persona_stores_by_account;
		g_static_rec_mutex_lock (&__lock_tpf_persona_store__persona_stores_by_account);
		{
			GeeHashMap* _tmp5_;
			GeeHashMap* _tmp10_;
			TpfPersonaStore* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			GeeHashMap* _tmp15_;
			TpfPersonaStore* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			TpfPersonaStore* _tmp19_;
			TpfPersonaStore* _tmp20_;
			_tmp5_ = tpf_persona_store__persona_stores_by_account;
			if (_tmp5_ == NULL) {
				GeeHashMap* _tmp6_;
				GeeHashMap* _tmp7_;
				GeeMap* _tmp8_;
				GeeMap* _tmp9_;
				_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TPF_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account);
				tpf_persona_store__persona_stores_by_account = _tmp6_;
				_tmp7_ = tpf_persona_store__persona_stores_by_account;
				_tmp8_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp7_);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account_ro);
				tpf_persona_store__persona_stores_by_account_ro = _tmp9_;
			}
			_tmp10_ = tpf_persona_store__persona_stores_by_account;
			_tmp11_ = store;
			_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp10_, _tmp13_);
			_vala_assert (!_tmp14_, "!PersonaStore._persona_stores_by_account.has_key (store.id)");
			_tmp15_ = tpf_persona_store__persona_stores_by_account;
			_tmp16_ = store;
			_tmp17_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = store;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp18_, _tmp19_);
			_tmp20_ = store;
			g_signal_connect ((FolksPersonaStore*) _tmp20_, "removed", (GCallback) __tpf_persona_store_store_removed_cb_folks_persona_store_removed, NULL);
		}
		__finally15:
		{
			GeeHashMap* _tmp21_;
			_tmp21_ = tpf_persona_store__persona_stores_by_account;
			g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void _tpf_persona_store_remove_store_from_map (TpfPersonaStore* store) {
	TpfPersonaStore* _tmp0_;
	TpfPersonaStore* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("tpf-persona-store.vala:1567: Removing PersonaStore %p ('%s') from map.", _tmp0_, _tmp3_);
	{
		GeeHashMap* _tmp4_;
		_tmp4_ = tpf_persona_store__persona_stores_by_account;
		g_static_rec_mutex_lock (&__lock_tpf_persona_store__persona_stores_by_account);
		{
			gboolean _tmp5_ = FALSE;
			GeeHashMap* _tmp6_;
			gboolean _tmp12_;
			TpfPersonaStore* _tmp14_;
			guint _tmp15_ = 0U;
			GeeHashMap* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp6_ = tpf_persona_store__persona_stores_by_account;
			if (_tmp6_ == NULL) {
				_tmp5_ = TRUE;
			} else {
				GeeHashMap* _tmp7_;
				TpfPersonaStore* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gboolean _tmp11_ = FALSE;
				_tmp7_ = tpf_persona_store__persona_stores_by_account;
				_tmp8_ = store;
				_tmp9_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp10_, NULL);
				_tmp5_ = !_tmp11_;
			}
			_tmp12_ = _tmp5_;
			if (_tmp12_) {
				{
					GeeHashMap* _tmp13_;
					_tmp13_ = tpf_persona_store__persona_stores_by_account;
					g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
				}
				return;
			}
			_tmp14_ = store;
			g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp15_, NULL, FALSE);
			g_signal_handlers_disconnect_matched ((FolksPersonaStore*) _tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) __tpf_persona_store_store_removed_cb_folks_persona_store_removed, NULL);
			_tmp16_ = tpf_persona_store__persona_stores_by_account;
			_tmp17_ = gee_abstract_map_get_size ((GeeMap*) _tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ == 0) {
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account_ro);
				tpf_persona_store__persona_stores_by_account_ro = NULL;
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account);
				tpf_persona_store__persona_stores_by_account = NULL;
			}
		}
		__finally16:
		{
			GeeHashMap* _tmp19_;
			_tmp19_ = tpf_persona_store__persona_stores_by_account;
			g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
   * Look up a {@link Tpf.PersonaStore} by its {@link TelepathyGLib.Account}.
   *
   * If found, a new reference to the persona store will be returned. If not
   * found, a new {@link Tpf.PersonaStore} will be created for the account.
   *
   * See the documentation for {@link Tpf.PersonaStore.list_persona_stores} for
   * information on the lifecycle of these stores when a
   * {@link Folks.BackendStore} is and is not present.
   *
   * @param account the Telepathy account of the persona store
   * @return the persona store associated with the account
   * @since 0.6.6
   */
TpfPersonaStore* tpf_persona_store_dup_for_account (TpAccount* account) {
	TpfPersonaStore* result = NULL;
	TpfPersonaStore* store;
	TpAccount* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (account != NULL, NULL);
	store = NULL;
	_tmp0_ = account;
	g_debug ("tpf-persona-store.vala:1609: Tpf.PersonaStore.dup_for_account (%p):", _tmp0_);
	{
		GeeHashMap* _tmp1_;
		_tmp1_ = tpf_persona_store__persona_stores_by_account;
		g_static_rec_mutex_lock (&__lock_tpf_persona_store__persona_stores_by_account);
		{
			GeeHashMap* _tmp2_;
			TpfPersonaStore* _tmp7_;
			_tmp2_ = tpf_persona_store__persona_stores_by_account;
			if (_tmp2_ != NULL) {
				GeeHashMap* _tmp3_;
				TpAccount* _tmp4_;
				const gchar* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				_tmp3_ = tpf_persona_store__persona_stores_by_account;
				_tmp4_ = account;
				_tmp5_ = tp_proxy_get_object_path ((TpProxy*) _tmp4_);
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp5_);
				_g_object_unref0 (store);
				store = (TpfPersonaStore*) _tmp6_;
			}
			_tmp7_ = store;
			if (_tmp7_ == NULL) {
				TpAccount* _tmp8_;
				TpfPersonaStore* _tmp9_;
				g_debug ("tpf-persona-store.vala:1625:     Creating new PersonaStore.");
				_tmp8_ = account;
				_tmp9_ = tpf_persona_store_new (_tmp8_);
				_g_object_unref0 (store);
				store = _tmp9_;
			} else {
				TpfPersonaStore* _tmp10_;
				TpfPersonaStore* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp10_ = store;
				_tmp11_ = store;
				_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp11_);
				_tmp13_ = _tmp12_;
				g_debug ("tpf-persona-store.vala:1630:     Found existing PersonaStore %p ('%s')" \
".", _tmp10_, _tmp13_);
			}
		}
		__finally17:
		{
			GeeHashMap* _tmp14_;
			_tmp14_ = tpf_persona_store__persona_stores_by_account;
			g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (store);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = store;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally18;
	__catch18_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* _tpf_persona_store_get_iid_from_event_metadata (TpfPersonaStore* self, const gchar* uri) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* new_uri;
	TpAccount* _tmp3_;
	TpAccount* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = uri;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = uri;
	_tmp2_ = string_replace (_tmp1_, "x-telepathy-identifier:", "");
	new_uri = _tmp2_;
	_tmp3_ = tpf_persona_store_get_account (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = tp_account_get_protocol (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, ":", NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = new_uri;
	_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp8_);
	result = _tmp11_;
	_g_free0 (new_uri);
	return result;
}


static void _tpf_persona_store_increase_persona_counter (TpfPersonaStore* self, const gchar* id, const gchar* interaction_type, ZeitgeistEvent* event) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp6_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp2_ = id;
	if (_tmp2_ != NULL) {
		GeeHashMap* _tmp3_;
		const gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = self->priv->_personas;
		_tmp4_ = id;
		_tmp5_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, _tmp4_);
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		_tmp7_ = interaction_type;
		_tmp0_ = _tmp7_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		GeeHashMap* _tmp9_;
		const gchar* _tmp10_;
		gpointer _tmp11_ = NULL;
		TpfPersona* persona;
		TpfPersona* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		ZeitgeistEvent* _tmp15_;
		_tmp9_ = self->priv->_personas;
		_tmp10_ = id;
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
		persona = (TpfPersona*) _tmp11_;
		_tmp12_ = persona;
		_tmp13_ = id;
		_tmp14_ = interaction_type;
		_tmp15_ = event;
		_tpf_persona_increase_counter (_tmp12_, _tmp13_, _tmp14_, _tmp15_);
		_g_object_unref0 (persona);
	}
}


static void _tpf_persona_store_handle_new_interaction (TpfPersonaStore* self, ZeitgeistTimeRange* timerange, ZeitgeistResultSet* events) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (timerange != NULL);
	g_return_if_fail (events != NULL);
	{
		ZeitgeistResultSet* _tmp0_;
		ZeitgeistResultSet* _tmp1_ = NULL;
		ZeitgeistResultSet* _e_it;
		ZeitgeistEvent* e = NULL;
		_tmp0_ = events;
		_tmp1_ = _vala_zeitgeist_result_set_iterator (_tmp0_);
		_e_it = _tmp1_;
		while (TRUE) {
			ZeitgeistResultSet* _tmp2_;
			ZeitgeistEvent* _tmp3_ = NULL;
			ZeitgeistEvent* _tmp4_;
			_tmp2_ = _e_it;
			_tmp3_ = _vala_zeitgeist_result_set_next_value (_tmp2_);
			e = _tmp3_;
			_tmp4_ = e;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			{
				gint i;
				i = 1;
				{
					gboolean _tmp5_;
					_tmp5_ = TRUE;
					while (TRUE) {
						gboolean _tmp6_;
						gint _tmp8_;
						ZeitgeistEvent* _tmp9_;
						gint _tmp10_ = 0;
						ZeitgeistEvent* _tmp11_;
						gint _tmp12_;
						ZeitgeistSubject* _tmp13_ = NULL;
						const gchar* _tmp14_ = NULL;
						gchar* _tmp15_ = NULL;
						gchar* id;
						ZeitgeistEvent* _tmp16_;
						ZeitgeistSubject* _tmp17_ = NULL;
						const gchar* _tmp18_ = NULL;
						gchar* _tmp19_;
						gchar* interaction_type;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						ZeitgeistEvent* _tmp22_;
						_tmp6_ = _tmp5_;
						if (!_tmp6_) {
							gint _tmp7_;
							_tmp7_ = i;
							i = _tmp7_ + 1;
						}
						_tmp5_ = FALSE;
						_tmp8_ = i;
						_tmp9_ = e;
						_tmp10_ = zeitgeist_event_num_subjects (_tmp9_);
						if (!(_tmp8_ < _tmp10_)) {
							break;
						}
						_tmp11_ = e;
						_tmp12_ = i;
						_tmp13_ = zeitgeist_event_get_subject (_tmp11_, _tmp12_);
						_tmp14_ = zeitgeist_subject_get_uri (_tmp13_);
						_tmp15_ = _tpf_persona_store_get_iid_from_event_metadata (self, _tmp14_);
						id = _tmp15_;
						_tmp16_ = e;
						_tmp17_ = zeitgeist_event_get_subject (_tmp16_, 0);
						_tmp18_ = zeitgeist_subject_get_interpretation (_tmp17_);
						_tmp19_ = g_strdup (_tmp18_);
						interaction_type = _tmp19_;
						_tmp20_ = id;
						_tmp21_ = interaction_type;
						_tmp22_ = e;
						_tpf_persona_store_increase_persona_counter (self, _tmp20_, _tmp21_, _tmp22_);
						_g_free0 (interaction_type);
						_g_free0 (id);
					}
				}
			}
		}
		_g_object_unref0 (_e_it);
	}
}


static GPtrArray* _tpf_persona_store_get_zeitgeist_event_templates (TpfPersonaStore* self) {
	GPtrArray* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* origin;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* ev1;
	ZeitgeistSubject* _tmp4_;
	ZeitgeistSubject* _tmp5_;
	ZeitgeistEvent* _tmp6_;
	ZeitgeistEvent* ev2;
	ZeitgeistSubject* _tmp7_;
	ZeitgeistSubject* _tmp8_;
	GPtrArray* _tmp9_;
	GPtrArray* templates;
	GObject* _tmp10_ = NULL;
	GObject* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, TP_ACCOUNT_OBJECT_PATH_BASE, "x-telepathy-account-path:");
	origin = _tmp2_;
	_tmp3_ = zeitgeist_event_new_full ("", "", "dbus://org.freedesktop.Telepathy.Logger.service", NULL);
	g_object_ref_sink (_tmp3_);
	ev1 = _tmp3_;
	_tmp4_ = zeitgeist_subject_new_full ("", ZEITGEIST_NMO_IMMESSAGE, "", "", "", "", "");
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	zeitgeist_event_add_subject (ev1, _tmp5_);
	_g_object_unref0 (_tmp5_);
	zeitgeist_event_set_origin (ev1, origin);
	_tmp6_ = zeitgeist_event_new_full ("", "", "dbus://org.freedesktop.Telepathy.Logger.service", NULL);
	g_object_ref_sink (_tmp6_);
	ev2 = _tmp6_;
	_tmp7_ = zeitgeist_subject_new_full ("", "", ZEITGEIST_NFO_MEDIA_STREAM, "", "", "", "");
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	zeitgeist_event_add_subject (ev2, _tmp8_);
	_g_object_unref0 (_tmp8_);
	zeitgeist_event_set_origin (ev2, origin);
	_tmp9_ = g_ptr_array_new ();
	templates = _tmp9_;
	_tmp10_ = g_object_ref ((GObject*) ev1);
	g_ptr_array_add (templates, _tmp10_);
	_tmp11_ = g_object_ref ((GObject*) ev2);
	g_ptr_array_add (templates, _tmp11_);
	result = templates;
	_g_object_unref0 (ev2);
	_g_object_unref0 (ev1);
	_g_free0 (origin);
	return result;
}


static void _tpf_persona_store_populate_counters_data_free (gpointer _data) {
	TpfPersonaStorePopulateCountersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStorePopulateCountersData, _data_);
}


static void _tpf_persona_store_populate_counters (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStorePopulateCountersData* _data_;
	TpfPersonaStore* _tmp0_;
	_data_ = g_slice_new0 (TpfPersonaStorePopulateCountersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_populate_counters);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_populate_counters_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_populate_counters_co (_data_);
}


static void _tpf_persona_store_populate_counters_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStorePopulateCountersData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_populate_counters_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStorePopulateCountersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_populate_counters_co (_data_);
}


static void __tpf_persona_store_handle_new_interaction_zeitgeist_monitor_events_inserted (ZeitgeistMonitor* _sender, ZeitgeistTimeRange* time_range, ZeitgeistResultSet* events, gpointer self) {
	_tpf_persona_store_handle_new_interaction (self, time_range, events);
}


static gboolean _tpf_persona_store_populate_counters_co (TpfPersonaStorePopulateCountersData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_log;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = zeitgeist_log_new ();
		_g_object_unref0 (_data_->self->priv->_log);
		_data_->self->priv->_log = _data_->_tmp1_;
	}
	{
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _tpf_persona_store_get_zeitgeist_event_templates (_data_->self);
		_data_->events = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->self->priv->_log;
		_data_->_tmp4_ = zeitgeist_time_range_new_anytime ();
		g_object_ref_sink (_data_->_tmp4_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = _data_->events;
		_data_->events = NULL;
		_data_->_state_ = 1;
		zeitgeist_log_find_events (_data_->_tmp3_, _data_->_tmp5_, _data_->_tmp6_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 0, ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS, NULL, _tpf_persona_store_populate_counters_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = zeitgeist_log_find_events_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp5_);
		_data_->results = _data_->_tmp8_;
		if (_data_->_inner_error_ != NULL) {
			_g_ptr_array_unref0 (_data_->events);
			goto __catch19_g_error;
		}
		{
			_data_->_tmp9_ = _data_->self->priv->_personas;
			_data_->_tmp10_ = gee_abstract_map_get_values ((GeeMap*) _data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			_g_object_unref0 (_data_->_tmp12_);
			_data_->_persona_it = _data_->_tmp14_;
			while (TRUE) {
				_data_->_tmp15_ = _data_->_persona_it;
				_data_->_tmp16_ = FALSE;
				_data_->_tmp16_ = gee_iterator_next (_data_->_tmp15_);
				if (!_data_->_tmp16_) {
					break;
				}
				_data_->_tmp17_ = _data_->_persona_it;
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = gee_iterator_get (_data_->_tmp17_);
				_data_->persona = (TpfPersona*) _data_->_tmp18_;
				_data_->_tmp19_ = _data_->persona;
				g_object_freeze_notify ((GObject*) _data_->_tmp19_);
				_data_->_tmp20_ = _data_->persona;
				_tpf_persona_reset_interaction (_data_->_tmp20_);
				_g_object_unref0 (_data_->persona);
			}
			_g_object_unref0 (_data_->_persona_it);
		}
		{
			_data_->_tmp21_ = _data_->results;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _vala_zeitgeist_result_set_iterator (_data_->_tmp21_);
			_data_->_e_it = _data_->_tmp22_;
			while (TRUE) {
				_data_->_tmp23_ = _data_->_e_it;
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = _vala_zeitgeist_result_set_next_value (_data_->_tmp23_);
				_data_->e = _data_->_tmp24_;
				_data_->_tmp25_ = _data_->e;
				if (!(_data_->_tmp25_ != NULL)) {
					break;
				}
				_data_->_tmp26_ = _data_->e;
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = zeitgeist_event_get_subject (_data_->_tmp26_, 0);
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = zeitgeist_subject_get_interpretation (_data_->_tmp27_);
				_data_->_tmp29_ = g_strdup (_data_->_tmp28_);
				_data_->interaction_type = _data_->_tmp29_;
				{
					_data_->i = 1;
					{
						_data_->_tmp30_ = TRUE;
						while (TRUE) {
							_data_->_tmp31_ = _data_->_tmp30_;
							if (!_data_->_tmp31_) {
								_data_->_tmp32_ = _data_->i;
								_data_->i = _data_->_tmp32_ + 1;
							}
							_data_->_tmp30_ = FALSE;
							_data_->_tmp33_ = _data_->i;
							_data_->_tmp34_ = _data_->e;
							_data_->_tmp35_ = 0;
							_data_->_tmp35_ = zeitgeist_event_num_subjects (_data_->_tmp34_);
							if (!(_data_->_tmp33_ < _data_->_tmp35_)) {
								break;
							}
							_data_->_tmp36_ = _data_->e;
							_data_->_tmp37_ = _data_->i;
							_data_->_tmp38_ = NULL;
							_data_->_tmp38_ = zeitgeist_event_get_subject (_data_->_tmp36_, _data_->_tmp37_);
							_data_->_tmp39_ = NULL;
							_data_->_tmp39_ = zeitgeist_subject_get_uri (_data_->_tmp38_);
							_data_->_tmp40_ = NULL;
							_data_->_tmp40_ = _tpf_persona_store_get_iid_from_event_metadata (_data_->self, _data_->_tmp39_);
							_data_->id = _data_->_tmp40_;
							_data_->_tmp41_ = _data_->id;
							_data_->_tmp42_ = _data_->interaction_type;
							_data_->_tmp43_ = _data_->e;
							_tpf_persona_store_increase_persona_counter (_data_->self, _data_->_tmp41_, _data_->_tmp42_, _data_->_tmp43_);
							_g_free0 (_data_->id);
						}
					}
				}
				_g_free0 (_data_->interaction_type);
			}
			_g_object_unref0 (_data_->_e_it);
		}
		{
			_data_->_tmp44_ = folks_persona_store_get_personas ((FolksPersonaStore*) _data_->self);
			_data_->_tmp45_ = _data_->_tmp44_;
			_data_->_tmp46_ = gee_map_get_values (_data_->_tmp45_);
			_data_->_tmp47_ = _data_->_tmp46_;
			_data_->_tmp48_ = _data_->_tmp47_;
			_data_->_tmp49_ = NULL;
			_data_->_tmp49_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp48_);
			_data_->_tmp50_ = _data_->_tmp49_;
			_g_object_unref0 (_data_->_tmp48_);
			_data_->_vala1__persona_it = _data_->_tmp50_;
			while (TRUE) {
				_data_->_tmp51_ = _data_->_vala1__persona_it;
				_data_->_tmp52_ = FALSE;
				_data_->_tmp52_ = gee_iterator_next (_data_->_tmp51_);
				if (!_data_->_tmp52_) {
					break;
				}
				_data_->_tmp53_ = _data_->_vala1__persona_it;
				_data_->_tmp54_ = NULL;
				_data_->_tmp54_ = gee_iterator_get (_data_->_tmp53_);
				_data_->_vala1_persona = (FolksPersona*) _data_->_tmp54_;
				_data_->_tmp55_ = _data_->_vala1_persona;
				g_object_thaw_notify ((GObject*) _data_->_tmp55_);
				_g_object_unref0 (_data_->_vala1_persona);
			}
			_g_object_unref0 (_data_->_vala1__persona_it);
		}
		_g_object_unref0 (_data_->results);
		_g_ptr_array_unref0 (_data_->events);
	}
	goto __finally19;
	__catch19_g_error:
	{
		g_clear_error (&_data_->_inner_error_);
		_data_->_inner_error_ = NULL;
		g_debug ("tpf-persona-store.vala:1735: Failed to fetch events from Zeitgeist");
	}
	__finally19:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp56_ = _data_->self->priv->_monitor;
	if (_data_->_tmp56_ == NULL) {
		_data_->_tmp57_ = NULL;
		_data_->_tmp57_ = _tpf_persona_store_get_zeitgeist_event_templates (_data_->self);
		_data_->monitor_events = _data_->_tmp57_;
		_data_->_tmp58_ = zeitgeist_time_range_new_from_now ();
		g_object_ref_sink (_data_->_tmp58_);
		_data_->_tmp59_ = _data_->_tmp58_;
		_data_->_tmp60_ = _data_->monitor_events;
		_data_->monitor_events = NULL;
		_data_->_tmp61_ = zeitgeist_monitor_new (_data_->_tmp59_, _data_->_tmp60_);
		_g_object_unref0 (_data_->self->priv->_monitor);
		_data_->self->priv->_monitor = _data_->_tmp61_;
		_g_object_unref0 (_data_->_tmp59_);
		_data_->_tmp62_ = _data_->self->priv->_monitor;
		g_signal_connect_object (_data_->_tmp62_, "events-inserted", (GCallback) __tpf_persona_store_handle_new_interaction_zeitgeist_monitor_events_inserted, _data_->self, 0);
		_data_->_tmp63_ = _data_->self->priv->_log;
		_data_->_tmp64_ = _data_->self->priv->_monitor;
		zeitgeist_log_install_monitor (_data_->_tmp63_, _data_->_tmp64_);
		_g_ptr_array_unref0 (_data_->monitor_events);
	}
	_tpf_persona_store_notify_if_is_quiescent (_data_->self);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


TpAccount* tpf_persona_store_get_account (TpfPersonaStore* self) {
	TpAccount* result;
	TpAccount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void tpf_persona_store_set_account (TpfPersonaStore* self, TpAccount* value) {
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_account);
	self->priv->_account = _tmp1_;
	_tmp2_ = self->priv->_account;
	g_signal_connect_object ((TpProxy*) _tmp2_, "invalidated", (GCallback) __tpf_persona_store_account_invalidated_cb_tp_proxy_invalidated, self, 0);
	g_object_notify ((GObject *) self, "account");
}


static const gchar* tpf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_add_personas;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_alias_personas;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_group_personas;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_remove_personas;
	result = _tmp0_;
	return result;
}


static gboolean tpf_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	TpfPersonaStore* self;
	gboolean _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gchar** tpf_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base, int* result_length1) {
	gchar** result;
	TpfPersonaStore* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_always_writeable_properties;
	_tmp0__length1 = self->priv->_always_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gboolean tpf_persona_store_real_get_is_quiescent (FolksPersonaStore* base) {
	gboolean result;
	TpfPersonaStore* self;
	gboolean _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static GeeMap* tpf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	TpfPersonaStore* self;
	GeeMap* _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}


GeeSet* tpf_persona_store_get_supported_fields (TpfPersonaStore* self) {
	GeeSet* result;
	GeeSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_supported_fields_ro;
	result = _tmp0_;
	return result;
}


static GObject * tpf_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TpfPersonaStore * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TpAccount* _tmp2_;
	TpAccount* _tmp3_;
	FolksDebug* _tmp4_ = NULL;
	FolksDebug* _tmp5_;
	TpfPersonaStoreCache* _tmp6_;
	parent_class = G_OBJECT_CLASS (tpf_persona_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TPF_TYPE_PERSONA_STORE, TpfPersonaStore);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tpf_persona_store_get_account (self);
	_tmp3_ = _tmp2_;
	g_debug ("tpf-persona-store.vala:253: Creating new Tpf.PersonaStore %p ('%s') fo" \
"r TpAccount %p.", self, _tmp1_, _tmp3_);
	_tmp4_ = folks_debug_dup ();
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = _tmp4_;
	_tmp5_ = self->priv->_debug;
	g_signal_connect_object (_tmp5_, "print-status", (GCallback) __tpf_persona_store_debug_print_status_folks_debug_print_status, self, 0);
	_tpf_persona_store_add_store_to_map (self);
	_tmp6_ = tpf_persona_store_cache_new (self);
	_g_object_unref0 (self->priv->_cache);
	self->priv->_cache = _tmp6_;
	_tpf_persona_store_reset (self);
	return obj;
}


static void tpf_persona_store_class_init (TpfPersonaStoreClass * klass) {
	tpf_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TpfPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = tpf_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = tpf_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->flush = tpf_persona_store_real_flush;
	FOLKS_PERSONA_STORE_CLASS (klass)->flush_finish = tpf_persona_store_real_flush_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = tpf_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = tpf_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = tpf_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = tpf_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = tpf_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = tpf_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = tpf_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = tpf_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = tpf_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = tpf_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = tpf_persona_store_real_get_always_writeable_properties;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = tpf_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = tpf_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_tpf_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tpf_persona_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = tpf_persona_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = tpf_persona_store_finalize;
	/**
	   * The Telepathy account this store is based upon.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_ACCOUNT, g_param_spec_object ("account", "account", "account", tp_account_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The type of persona store this is.
	   *
	   * See {@link Folks.PersonaStore.type_id}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_TYPE_ID, g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_ADD_PERSONAS, g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS, g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_GROUP_PERSONAS, g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS, g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES, g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * See {@link Folks.PersonaStore.personas}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_PERSONAS, g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_SUPPORTED_FIELDS, g_param_spec_object ("supported-fields", "supported-fields", "supported-fields", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_static_rec_mutex_init (&__lock_tpf_persona_store__persona_stores_by_account);
}


static void tpf_persona_store_instance_init (TpfPersonaStore * self) {
	gchar** _tmp0_ = NULL;
	GeeHashSet* _tmp1_;
	GeeHashMap* _tmp2_;
	self->priv = TPF_PERSONA_STORE_GET_PRIVATE (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->_always_writeable_properties = _tmp0_;
	self->priv->_always_writeable_properties_length1 = 0;
	self->priv->__always_writeable_properties_size_ = self->priv->_always_writeable_properties_length1;
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	self->priv->_favourite_ids = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->_avatars = _tmp2_;
	self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_alias_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
	self->priv->_got_initial_members = FALSE;
	self->priv->_got_initial_self_contact = FALSE;
	self->priv->_load_cache_cancellable = NULL;
	self->priv->_cache_needs_update = FALSE;
	self->priv->_log = NULL;
	self->priv->_monitor = NULL;
}


static void tpf_persona_store_finalize (GObject* obj) {
	TpfPersonaStore * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	FolksDebug* _tmp2_;
	guint _tmp3_ = 0U;
	Logger* _tmp4_;
	TpAccount* _tmp7_;
	guint _tmp8_ = 0U;
	TpAccountManager* _tmp9_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TPF_TYPE_PERSONA_STORE, TpfPersonaStore);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:270: Destroying Tpf.PersonaStore %p ('%s').", self, _tmp1_);
	_tpf_persona_store_reset (self);
	_tpf_persona_store_remove_store_from_map (self);
	_tmp2_ = self->priv->_debug;
	g_signal_parse_name ("print-status", FOLKS_TYPE_DEBUG, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) __tpf_persona_store_debug_print_status_folks_debug_print_status, self);
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = NULL;
	_tmp4_ = self->priv->_logger;
	if (_tmp4_ != NULL) {
		Logger* _tmp5_;
		guint _tmp6_ = 0U;
		_tmp5_ = self->priv->_logger;
		g_signal_parse_name ("invalidated", TYPE_LOGGER, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) __tpf_persona_store_logger_invalidated_cb_logger_invalidated, self);
	}
	_tmp7_ = self->priv->_account;
	g_signal_parse_name ("invalidated", tp_proxy_get_type (), &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((TpProxy*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) __tpf_persona_store_account_invalidated_cb_tp_proxy_invalidated, self);
	_tmp9_ = self->priv->_account_manager;
	if (_tmp9_ != NULL) {
		TpAccountManager* _tmp10_;
		guint _tmp11_ = 0U;
		_tmp10_ = self->priv->_account_manager;
		g_signal_parse_name ("invalidated", tp_proxy_get_type (), &_tmp11_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((TpProxy*) _tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) __tpf_persona_store_account_manager_invalidated_cb_tp_proxy_invalidated, self);
		_g_object_unref0 (self->priv->_account_manager);
		self->priv->_account_manager = NULL;
	}
	self->priv->_always_writeable_properties = (_vala_array_free (self->priv->_always_writeable_properties, self->priv->_always_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_object_unref0 (self->priv->_persona_set);
	_g_object_unref0 (self->priv->_contact_persona_map);
	_g_object_unref0 (self->priv->_favourite_ids);
	_g_object_unref0 (self->priv->_avatars);
	_g_object_unref0 (self->priv->_conn);
	_g_object_unref0 (self->priv->_account_manager);
	_g_object_unref0 (self->priv->_logger);
	_g_object_unref0 (self->priv->_self_persona);
	_g_object_unref0 (self->priv->_debug);
	_g_object_unref0 (self->priv->_cache);
	_g_object_unref0 (self->priv->_load_cache_cancellable);
	_g_object_unref0 (self->_supported_fields);
	_g_object_unref0 (self->_supported_fields_ro);
	_g_object_unref0 (self->priv->_account);
	_g_object_unref0 (self->priv->_log);
	_g_object_unref0 (self->priv->_monitor);
	G_OBJECT_CLASS (tpf_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single Telepathy account. It will
 * create {@link Persona}s for each of the contacts in the account's
 * contact list.
 *
 * User must define contact features it wants on the #TpSimpleClientFactory of
 * the default #TpAccountManager returned by tp_account_manager_dup() *before*
 * preparing telepathy stores. Note that this is a behaviour change since
 * 0.7.0, folks won't force preparing any feature anymore.
 */
GType tpf_persona_store_get_type (void) {
	static volatile gsize tpf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&tpf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TpfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tpf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TpfPersonaStore), 0, (GInstanceInitFunc) tpf_persona_store_instance_init, NULL };
		GType tpf_persona_store_type_id;
		tpf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "TpfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&tpf_persona_store_type_id__volatile, tpf_persona_store_type_id);
	}
	return tpf_persona_store_type_id__volatile;
}


static void _vala_tpf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TpfPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TPF_TYPE_PERSONA_STORE, TpfPersonaStore);
	switch (property_id) {
		case TPF_PERSONA_STORE_ACCOUNT:
		g_value_set_object (value, tpf_persona_store_get_account (self));
		break;
		case TPF_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		case TPF_PERSONA_STORE_IS_QUIESCENT:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_PERSONAS:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_SUPPORTED_FIELDS:
		g_value_set_object (value, tpf_persona_store_get_supported_fields (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tpf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TpfPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TPF_TYPE_PERSONA_STORE, TpfPersonaStore);
	switch (property_id) {
		case TPF_PERSONA_STORE_ACCOUNT:
		tpf_persona_store_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



