/* backend.c generated by valac 0.17.2.19-5f50d, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libebook/libebook.h>
#include <gee.h>
#include <libedataserver/libedataserver.h>
#include <gio/gio.h>
#include <folks/folks-eds.h>
#include <folks/folks.h>
#include <gobject/gvaluecollector.h>


#define EDS_TEST_TYPE_BACKEND (eds_test_backend_get_type ())
#define EDS_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackend))
#define EDS_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))
#define EDS_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))

typedef struct _EdsTestBackend EdsTestBackend;
typedef struct _EdsTestBackendClass EdsTestBackendClass;
typedef struct _EdsTestBackendPrivate EdsTestBackendPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _eds_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (eds_test_backend_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _EdsTestBackendUpdateContactData EdsTestBackendUpdateContactData;
typedef struct _EdsTestBackendRemoveContactData EdsTestBackendRemoveContactData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _EdsTestBackendCommitContactsToAddressbookData EdsTestBackendCommitContactsToAddressbookData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define __vala_EContactPhoto_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactPhoto_free (var), NULL)))
#define __vala_EContactName_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactName_free (var), NULL)))
#define __vala_EContactAddress_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactAddress_free (var), NULL)))
typedef struct _EdsTestParamSpecBackend EdsTestParamSpecBackend;

typedef enum  {
	EDS_TEST_BACKEND_SETUP_ERROR_FETCH_SOURCE_GROUP_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_OPENING_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_TO_SOURCE_GROUP_FAILED
} EdsTestBackendSetupError;
#define EDS_TEST_BACKEND_SETUP_ERROR eds_test_backend_setup_error_quark ()
struct _EdsTestBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EdsTestBackendPrivate * priv;
};

struct _EdsTestBackendClass {
	GTypeClass parent_class;
	void (*finalize) (EdsTestBackend *self);
};

struct _EdsTestBackendPrivate {
	gchar* _addressbook_name;
	EBookClient* _addressbook;
	GList* _e_contacts;
	GList* _contacts;
	ESourceRegistry* _source_registry;
	ESource* _source;
};

struct _EdsTestBackendUpdateContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	GeeHashMap* updated_data;
	GList* _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* uid;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EContact* _tmp7_;
	GeeHashMap* _tmp8_;
	EBookClient* _tmp9_;
	EContact* _tmp10_;
	GError* e;
	GError * _inner_error_;
};

struct _EdsTestBackendRemoveContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	GList* _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* uid;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EBookClient* _tmp7_;
	EContact* _tmp8_;
	GError* e;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	EdsTestBackend * self;
	GMainLoop* mainloop;
};

struct _EdsTestBackendCommitContactsToAddressbookData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	GList* _tmp0_;
	GList* c_collection;
	GList* c_it;
	GeeHashMap* _tmp1_;
	GeeHashMap* c;
	EContact* _tmp2_;
	EContact* contact;
	EContact* _tmp3_;
	GeeHashMap* _tmp4_;
	gchar* added_uid;
	EBookClient* _tmp5_;
	EContact* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError * _inner_error_;
};

struct _EdsTestParamSpecBackend {
	GParamSpec parent_instance;
};


static gpointer eds_test_backend_parent_class = NULL;

GQuark eds_test_backend_setup_error_quark (void);
gpointer eds_test_backend_ref (gpointer instance);
void eds_test_backend_unref (gpointer instance);
GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void eds_test_value_set_backend (GValue* value, gpointer v_object);
void eds_test_value_take_backend (GValue* value, gpointer v_object);
gpointer eds_test_value_get_backend (const GValue* value);
GType eds_test_backend_get_type (void) G_GNUC_CONST;
#define EDS_TEST_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDS_TEST_TYPE_BACKEND, EdsTestBackendPrivate))
enum  {
	EDS_TEST_BACKEND_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
EdsTestBackend* eds_test_backend_new (void);
EdsTestBackend* eds_test_backend_construct (GType object_type);
void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c);
static void eds_test_backend_update_contact_data_free (gpointer _data);
void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_);
static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c);
static void eds_test_backend_remove_contact_data_free (gpointer _data);
void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_);
static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void eds_test_backend_reset (EdsTestBackend* self);
void eds_test_backend_set_up (EdsTestBackend* self, gboolean source_is_default, const gchar* name);
static void _eds_test_backend_prepare_source (EdsTestBackend* self, gboolean is_default);
void eds_test_backend_set_as_default (EdsTestBackend* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda2_ (Block1Data* _data1_, GObject* obj, GAsyncResult* async_res);
static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data);
void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_);
static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_GValue_free (GValue* self);
static void _vala_EContactPhoto_free (EContactPhoto* self);
static void _vala_EContactName_free (EContactName* self);
static GeeHashMap* _eds_test_backend_parse_addrs (EdsTestBackend* self, const gchar* addr_s);
static void _vala_EContactAddress_free (EContactAddress* self);
void eds_test_backend_tear_down (EdsTestBackend* self);
static void __lambda3_ (EdsTestBackend* self, GObject* o, GAsyncResult* r);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
const gchar* eds_test_backend_get_address_book_uid (EdsTestBackend* self);
static void eds_test_backend_finalize (EdsTestBackend* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark eds_test_backend_setup_error_quark (void) {
	return g_quark_from_static_string ("eds_test_backend_setup_error-quark");
}


static void _g_free0_ (gpointer var) {
#line 37 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	var = (g_free (var), NULL);
#line 244 "backend.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 37 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 37 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_list_free (self);
#line 253 "backend.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 38 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 260 "backend.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 38 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 38 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_list_free (self);
#line 269 "backend.c"
}


EdsTestBackend* eds_test_backend_construct (GType object_type) {
	EdsTestBackend* self = NULL;
#line 47 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	self = (EdsTestBackend*) g_type_create_instance (object_type);
#line 49 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 49 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = NULL;
#line 50 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_free0_0 (self->priv->_e_contacts);
#line 50 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = NULL;
#line 47 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return self;
#line 287 "backend.c"
}


EdsTestBackend* eds_test_backend_new (void) {
#line 47 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return eds_test_backend_construct (EDS_TEST_TYPE_BACKEND);
#line 294 "backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 55 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 301 "backend.c"
}


void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
#line 53 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (c != NULL);
#line 55 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp0_ = c;
#line 55 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 55 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = g_list_prepend (self->priv->_contacts, _tmp1_);
#line 53 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (c);
#line 320 "backend.c"
}


static void eds_test_backend_update_contact_data_free (gpointer _data) {
	EdsTestBackendUpdateContactData* _data_;
	_data_ = _data;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendUpdateContactData, _data_);
#line 333 "backend.c"
}


static gpointer _eds_test_backend_ref0 (gpointer self) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return self ? eds_test_backend_ref (self) : NULL;
#line 340 "backend.c"
}


void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
	EdsTestBackend* _tmp0_;
	gint _tmp1_;
	GeeHashMap* _tmp2_;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendUpdateContactData);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_update_contact);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_update_contact_data_free);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp1_ = contact_pos;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->contact_pos = _tmp1_;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp2_ = updated_data;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->updated_data = _tmp2_;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	eds_test_backend_update_contact_co (_data_);
#line 371 "backend.c"
}


void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendUpdateContactData* _data_;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 379 "backend.c"
}


static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	eds_test_backend_update_contact_co (_data_);
#line 393 "backend.c"
}


static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_) {
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		case 0:
#line 402 "backend.c"
		goto _state_0;
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		case 1:
#line 406 "backend.c"
		goto _state_1;
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		case 2:
#line 410 "backend.c"
		goto _state_2;
		default:
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 415 "backend.c"
	}
	_state_0:
#line 61 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
#line 61 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = _data_->contact_pos;
#line 61 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = NULL;
#line 61 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = g_list_nth_data (_data_->_tmp0_, (guint) _data_->_tmp1_);
#line 61 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_strdup ((const gchar*) _data_->_tmp2_);
#line 61 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->uid = _data_->_tmp3_;
#line 430 "backend.c"
	{
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = _data_->uid;
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_tmp6_ = NULL;
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_update_contact_ready, _data_);
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 444 "backend.c"
		_state_1:
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->contact = _data_->_tmp6_;
#line 65 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 454 "backend.c"
			goto __catch0_g_error;
		}
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->contact;
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->updated_data;
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp7_, _data_->_tmp8_);
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_tmp9_ = _data_->self->priv->_addressbook;
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_tmp10_ = _data_->contact;
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 2;
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e_book_client_modify_contact (_data_->_tmp9_, _data_->_tmp10_, NULL, eds_test_backend_update_contact_ready, _data_);
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 473 "backend.c"
		_state_2:
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e_book_client_modify_contact_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 479 "backend.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 63 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 63 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 71 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:71: Couldn't update contact\n");
#line 63 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 494 "backend.c"
	}
	__finally0:
#line 63 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 63 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 63 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->uid);
#line 63 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->updated_data);
#line 63 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 63 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 63 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 511 "backend.c"
	}
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->contact);
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->uid);
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 523 "backend.c"
	} else {
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 527 "backend.c"
	}
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 58 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 533 "backend.c"
}


static void eds_test_backend_remove_contact_data_free (gpointer _data) {
	EdsTestBackendRemoveContactData* _data_;
	_data_ = _data;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendRemoveContactData, _data_);
#line 544 "backend.c"
}


void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
	EdsTestBackend* _tmp0_;
	gint _tmp1_;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendRemoveContactData);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_remove_contact);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_remove_contact_data_free);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp1_ = contact_pos;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->contact_pos = _tmp1_;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	eds_test_backend_remove_contact_co (_data_);
#line 568 "backend.c"
}


void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendRemoveContactData* _data_;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 576 "backend.c"
}


static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	eds_test_backend_remove_contact_co (_data_);
#line 590 "backend.c"
}


static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_) {
#line 75 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 75 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		case 0:
#line 599 "backend.c"
		goto _state_0;
#line 75 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		case 1:
#line 603 "backend.c"
		goto _state_1;
#line 75 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		case 2:
#line 607 "backend.c"
		goto _state_2;
		default:
#line 75 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 612 "backend.c"
	}
	_state_0:
#line 77 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
#line 77 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = _data_->contact_pos;
#line 77 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = NULL;
#line 77 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = g_list_nth_data (_data_->_tmp0_, (guint) _data_->_tmp1_);
#line 77 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_strdup ((const gchar*) _data_->_tmp2_);
#line 77 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->uid = _data_->_tmp3_;
#line 627 "backend.c"
	{
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = _data_->uid;
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_tmp6_ = NULL;
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_remove_contact_ready, _data_);
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 641 "backend.c"
		_state_1:
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->contact = _data_->_tmp6_;
#line 81 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 651 "backend.c"
			goto __catch1_g_error;
		}
#line 82 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->self->priv->_addressbook;
#line 82 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->contact;
#line 82 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 2;
#line 82 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e_book_client_remove_contact (_data_->_tmp7_, _data_->_tmp8_, NULL, eds_test_backend_remove_contact_ready, _data_);
#line 82 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 664 "backend.c"
		_state_2:
#line 82 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e_book_client_remove_contact_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 82 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 670 "backend.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 79 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 79 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 86 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:86: Couldn't remove contact\n");
#line 79 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 685 "backend.c"
	}
	__finally1:
#line 79 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 79 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 79 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->uid);
#line 79 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 79 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 79 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 700 "backend.c"
	}
#line 75 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->contact);
#line 75 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->uid);
#line 75 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 75 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 710 "backend.c"
	} else {
#line 75 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 714 "backend.c"
	}
#line 75 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 75 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 720 "backend.c"
}


void eds_test_backend_reset (EdsTestBackend* self) {
#line 90 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = NULL;
#line 93 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_free0_0 (self->priv->_e_contacts);
#line 93 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = NULL;
#line 735 "backend.c"
}


void eds_test_backend_set_up (EdsTestBackend* self, gboolean source_is_default, const gchar* name) {
	GError * _inner_error_ = NULL;
#line 97 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 97 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (name != NULL);
#line 745 "backend.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gboolean _tmp2_;
		ESource* _tmp3_;
		EBookClient* _tmp4_;
		EBookClient* _tmp5_;
		EBookClient* _tmp6_;
		const gchar* _tmp7_;
#line 102 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp0_ = name;
#line 102 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 102 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_free0 (self->priv->_addressbook_name);
#line 102 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook_name = _tmp1_;
#line 104 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp2_ = source_is_default;
#line 104 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_prepare_source (self, _tmp2_);
#line 105 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp3_ = self->priv->_source;
#line 105 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp4_ = e_book_client_new (_tmp3_, &_inner_error_);
#line 105 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp5_ = _tmp4_;
#line 105 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 775 "backend.c"
			goto __catch2_g_error;
		}
#line 105 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_addressbook);
#line 105 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook = _tmp5_;
#line 106 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp6_ = self->priv->_addressbook;
#line 106 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e_client_open_sync ((EClient*) _tmp6_, FALSE, NULL, &_inner_error_);
#line 106 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 788 "backend.c"
			goto __catch2_g_error;
		}
#line 107 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp7_ = self->priv->_addressbook_name;
#line 107 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", _tmp7_, TRUE);
#line 795 "backend.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 99 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 99 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 112 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp8_ = e;
#line 112 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp9_ = _tmp8_->message;
#line 112 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:112: Unable to create test data: %s\n", _tmp9_);
#line 99 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 815 "backend.c"
	}
	__finally2:
#line 99 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (_inner_error_ != NULL) {
#line 99 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 99 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 99 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		return;
#line 826 "backend.c"
	}
}


void eds_test_backend_set_as_default (EdsTestBackend* self) {
	ESourceRegistry* _tmp0_;
	ESource* _tmp1_;
#line 116 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp0_ = self->priv->_source_registry;
#line 118 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp1_ = self->priv->_source;
#line 118 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	e_source_registry_set_default_address_book (_tmp0_, _tmp1_);
#line 842 "backend.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return _data1_;
#line 851 "backend.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 860 "backend.c"
		EdsTestBackend * self;
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		self = _data1_->self;
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_main_loop_unref0 (_data1_->mainloop);
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_unref0 (self);
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_slice_free (Block1Data, _data1_);
#line 870 "backend.c"
	}
}


static void __lambda2_ (Block1Data* _data1_, GObject* obj, GAsyncResult* async_res) {
	EdsTestBackend * self;
	GMainLoop* _tmp5_;
	GError * _inner_error_ = NULL;
#line 125 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	self = _data1_->self;
#line 125 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (async_res != NULL);
#line 883 "backend.c"
	{
		GAsyncResult* _tmp0_;
		ESourceRegistry* _tmp1_ = NULL;
		ESourceRegistry* _tmp2_;
#line 129 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp0_ = async_res;
#line 129 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp1_ = e_source_registry_new_finish (_tmp0_, &_inner_error_);
#line 129 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp2_ = _tmp1_;
#line 129 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 896 "backend.c"
			goto __catch3_g_error;
		}
#line 129 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_source_registry);
#line 129 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		self->priv->_source_registry = _tmp2_;
#line 903 "backend.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 133 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp3_ = e;
#line 133 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp4_ = _tmp3_->message;
#line 133 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_critical ("backend.vala:133: %s", _tmp4_);
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 923 "backend.c"
	}
	__finally3:
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (_inner_error_ != NULL) {
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		return;
#line 934 "backend.c"
	}
#line 135 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp5_ = _data1_->mainloop;
#line 135 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_main_loop_quit (_tmp5_);
#line 940 "backend.c"
}


static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 125 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	__lambda2_ (self, source_object, res);
#line 125 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	block1_data_unref (self);
#line 949 "backend.c"
}


static void _eds_test_backend_prepare_source (EdsTestBackend* self, gboolean is_default) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	GMainLoop* _tmp1_;
	ESourceRegistry* _tmp2_;
	const gchar* _tmp3_;
	ESource* _tmp4_ = NULL;
	gboolean _tmp5_;
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data1_->_ref_count_ = 1;
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data1_->self = eds_test_backend_ref (self);
#line 123 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 123 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data1_->mainloop = _tmp0_;
#line 125 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	e_source_registry_new (NULL, ___lambda2__gasync_ready_callback, block1_data_ref (_data1_));
#line 138 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp1_ = _data1_->mainloop;
#line 138 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_main_loop_run (_tmp1_);
#line 140 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp2_ = self->priv->_source_registry;
#line 140 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp3_ = self->priv->_addressbook_name;
#line 140 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp4_ = e_source_registry_ref_source (_tmp2_, _tmp3_);
#line 140 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source);
#line 140 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	self->priv->_source = _tmp4_;
#line 142 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp5_ = is_default;
#line 142 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (_tmp5_) {
#line 143 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		eds_test_backend_set_as_default (self);
#line 995 "backend.c"
	}
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	block1_data_unref (_data1_);
#line 121 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data1_ = NULL;
#line 1001 "backend.c"
}


static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	_data_ = _data;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendCommitContactsToAddressbookData, _data_);
#line 1012 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	EdsTestBackend* _tmp0_;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendCommitContactsToAddressbookData);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_commit_contacts_to_addressbook);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_commit_contacts_to_addressbook_data_free);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
#line 1031 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1039 "backend.c"
}


static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
#line 1053 "backend.c"
}


static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_) {
#line 146 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 146 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		case 0:
#line 1062 "backend.c"
		goto _state_0;
#line 146 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		case 1:
#line 1066 "backend.c"
		goto _state_1;
		default:
#line 146 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 1071 "backend.c"
	}
	_state_0:
#line 148 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_contacts = g_list_reverse (_data_->self->priv->_contacts);
#line 149 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_contacts;
#line 1078 "backend.c"
	{
#line 149 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_data_->c_collection = _data_->_tmp0_;
#line 149 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		for (_data_->c_it = _data_->c_collection; _data_->c_it != NULL; _data_->c_it = _data_->c_it->next) {
#line 149 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_data_->_tmp1_ = _g_object_ref0 ((GeeHashMap*) _data_->c_it->data);
#line 149 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_data_->c = _data_->_tmp1_;
#line 1088 "backend.c"
			{
#line 151 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_data_->_tmp2_ = e_contact_new ();
#line 151 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_data_->contact = _data_->_tmp2_;
#line 153 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_data_->_tmp3_ = _data_->contact;
#line 153 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_data_->_tmp4_ = _data_->c;
#line 153 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp3_, _data_->_tmp4_);
#line 1100 "backend.c"
				{
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_data_->_tmp5_ = _data_->self->priv->_addressbook;
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_data_->_tmp6_ = _data_->contact;
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_data_->_tmp7_ = NULL;
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_data_->_state_ = 1;
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					e_book_client_add_contact (_data_->_tmp5_, _data_->_tmp6_, NULL, eds_test_backend_commit_contacts_to_addressbook_ready, _data_);
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					return FALSE;
#line 1114 "backend.c"
					_state_1:
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					e_book_client_add_contact_finish (_data_->_tmp5_, _data_->_res_, &_data_->_tmp7_, &_data_->_inner_error_);
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_g_free0 (_data_->added_uid);
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_data_->added_uid = _data_->_tmp7_;
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					if (_data_->_inner_error_ != NULL) {
#line 158 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_g_free0 (_data_->added_uid);
#line 1126 "backend.c"
						goto __catch4_g_error;
					}
#line 160 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_data_->_tmp8_ = _data_->added_uid;
#line 160 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_data_->added_uid = NULL;
#line 160 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_data_->self->priv->_e_contacts = g_list_prepend (_data_->self->priv->_e_contacts, _data_->_tmp8_);
#line 155 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_g_free0 (_data_->added_uid);
#line 1137 "backend.c"
				}
				goto __finally4;
				__catch4_g_error:
				{
#line 155 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_data_->e = _data_->_inner_error_;
#line 155 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_data_->_inner_error_ = NULL;
#line 164 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_data_->_tmp9_ = _data_->e;
#line 164 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_data_->_tmp10_ = _data_->_tmp9_->message;
#line 164 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					g_warning ("backend.vala:164: Couldn't add contact: %s\n", _data_->_tmp10_);
#line 155 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_g_error_free0 (_data_->e);
#line 1154 "backend.c"
				}
				__finally4:
#line 155 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				if (_data_->_inner_error_ != NULL) {
#line 155 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_g_object_unref0 (_data_->contact);
#line 155 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_g_object_unref0 (_data_->c);
#line 155 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 155 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					g_clear_error (&_data_->_inner_error_);
#line 155 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					return FALSE;
#line 1169 "backend.c"
				}
#line 149 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (_data_->contact);
#line 149 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (_data_->c);
#line 1175 "backend.c"
			}
		}
	}
#line 168 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_e_contacts = g_list_reverse (_data_->self->priv->_e_contacts);
#line 146 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 146 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1185 "backend.c"
	} else {
#line 146 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1189 "backend.c"
	}
#line 146 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 146 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1195 "backend.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1163 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1164 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1164 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1164 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1165 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1165 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1230 "backend.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1166 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1166 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1166 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1239 "backend.c"
	}
#line 1168 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1168 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1245 "backend.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1169 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1169 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1169 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1254 "backend.c"
	}
#line 1171 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1171 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1260 "backend.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1171 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1171 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1171 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1269 "backend.c"
	} else {
#line 1171 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1273 "backend.c"
	}
#line 1171 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1171 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1172 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1172 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 1283 "backend.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1172 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1172 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1172 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 1292 "backend.c"
	} else {
#line 1172 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 1296 "backend.c"
	}
#line 1172 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1172 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1173 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1173 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1173 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1174 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1174 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1174 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1174 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1174 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1174 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 1320 "backend.c"
}


static void _vala_GValue_free (GValue* self) {
#line 183 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_value_unset (self);
#line 183 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_free (self);
#line 1329 "backend.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 884 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 884 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 885 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 885 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 885 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 885 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 887 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 887 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1356 "backend.c"
		gchar* _tmp4_;
#line 888 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 888 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 888 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 1364 "backend.c"
	} else {
#line 890 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		result = -1;
#line 890 "/opt/gnome/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 1370 "backend.c"
	}
}


static void _vala_EContactPhoto_free (EContactPhoto* self) {
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_photo_get_type (), self);
#line 1378 "backend.c"
}


static void _vala_EContactName_free (EContactName* self) {
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_name_get_type (), self);
#line 1385 "backend.c"
}


static void _vala_EContactAddress_free (EContactAddress* self) {
#line 239 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_address_get_type (), self);
#line 1392 "backend.c"
}


static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c) {
	gboolean added_contact_name;
	EContactName* _tmp0_;
	EContactName* contact_name;
	gchar* _tmp1_;
	gchar* contact_field_name;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint min_len;
	gboolean _tmp177_;
	GError * _inner_error_ = NULL;
#line 171 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 171 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (contact != NULL);
#line 171 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (c != NULL);
#line 174 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	added_contact_name = FALSE;
#line 175 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp0_ = e_contact_name_new ();
#line 175 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	contact_name = _tmp0_;
#line 176 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp1_ = g_strdup ("contact_name");
#line 176 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	contact_field_name = _tmp1_;
#line 177 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp2_ = contact_field_name;
#line 177 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp3_ = strlen (_tmp2_);
#line 177 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp4_ = _tmp3_;
#line 177 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	min_len = _tmp4_;
#line 1432 "backend.c"
	{
		GeeHashMap* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _tmp10_;
		GeeIterator* _k_it;
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp5_ = c;
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp7_ = _tmp6_;
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp8_ = _tmp7_;
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp10_ = _tmp9_;
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_tmp8_);
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_k_it = _tmp10_;
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		while (TRUE) {
#line 1459 "backend.c"
			GeeIterator* _tmp11_;
			gboolean _tmp12_ = FALSE;
			GeeIterator* _tmp13_;
			gpointer _tmp14_ = NULL;
			gchar* k;
			gboolean _tmp15_ = FALSE;
			const gchar* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gboolean _tmp25_;
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_tmp11_ = _k_it;
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_tmp12_ = gee_iterator_next (_tmp11_);
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			if (!_tmp12_) {
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				break;
#line 1479 "backend.c"
			}
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_tmp13_ = _k_it;
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			k = (gchar*) _tmp14_;
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_tmp16_ = k;
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_tmp17_ = strlen (_tmp16_);
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_tmp18_ = _tmp17_;
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_tmp19_ = min_len;
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			if (_tmp18_ > _tmp19_) {
#line 1497 "backend.c"
				const gchar* _tmp20_;
				gint _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				const gchar* _tmp24_;
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp20_ = k;
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp21_ = min_len;
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp22_ = string_slice (_tmp20_, (glong) 0, (glong) _tmp21_);
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp23_ = _tmp22_;
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp24_ = contact_field_name;
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp15_ = g_strcmp0 (_tmp23_, _tmp24_) == 0;
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp23_);
#line 1517 "backend.c"
			} else {
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp15_ = FALSE;
#line 1521 "backend.c"
			}
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_tmp25_ = _tmp15_;
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			if (_tmp25_) {
#line 1527 "backend.c"
				GeeHashMap* _tmp26_;
				const gchar* _tmp27_;
				gpointer _tmp28_ = NULL;
				GValue* _tmp29_;
				const gchar* _tmp30_ = NULL;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* v;
				const gchar* _tmp33_;
				gint _tmp34_ = 0;
#line 183 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp26_ = c;
#line 183 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp27_ = k;
#line 183 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, _tmp27_);
#line 183 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp29_ = (GValue*) _tmp28_;
#line 183 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp30_ = g_value_get_string (_tmp29_);
#line 183 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp31_ = g_strdup (_tmp30_);
#line 183 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp32_ = _tmp31_;
#line 183 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				__vala_GValue_free0 (_tmp29_);
#line 183 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				v = _tmp32_;
#line 184 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp33_ = k;
#line 184 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp34_ = string_index_of (_tmp33_, "family", 0);
#line 184 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				if (_tmp34_ >= 0) {
#line 1562 "backend.c"
					EContactName* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
#line 186 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp35_ = contact_name;
#line 186 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp36_ = v;
#line 186 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp37_ = g_strdup (_tmp36_);
#line 186 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_g_free0 (_tmp35_->family);
#line 186 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp35_->family = _tmp37_;
#line 1576 "backend.c"
				} else {
					const gchar* _tmp38_;
					gint _tmp39_ = 0;
#line 188 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp38_ = k;
#line 188 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp39_ = string_index_of (_tmp38_, "given", 0);
#line 188 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					if (_tmp39_ >= 0) {
#line 1586 "backend.c"
						EContactName* _tmp40_;
						const gchar* _tmp41_;
						gchar* _tmp42_;
#line 190 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp40_ = contact_name;
#line 190 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp41_ = v;
#line 190 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp42_ = g_strdup (_tmp41_);
#line 190 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_g_free0 (_tmp40_->given);
#line 190 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp40_->given = _tmp42_;
#line 1600 "backend.c"
					} else {
						const gchar* _tmp43_;
						gint _tmp44_ = 0;
#line 192 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp43_ = k;
#line 192 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp44_ = string_index_of (_tmp43_, "additional", 0);
#line 192 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						if (_tmp44_ >= 0) {
#line 1610 "backend.c"
							EContactName* _tmp45_;
							const gchar* _tmp46_;
							gchar* _tmp47_;
#line 194 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp45_ = contact_name;
#line 194 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp46_ = v;
#line 194 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp47_ = g_strdup (_tmp46_);
#line 194 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp45_->additional);
#line 194 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp45_->additional = _tmp47_;
#line 1624 "backend.c"
						} else {
							const gchar* _tmp48_;
							gint _tmp49_ = 0;
#line 196 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp48_ = k;
#line 196 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp49_ = string_index_of (_tmp48_, "prefixes", 0);
#line 196 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							if (_tmp49_ >= 0) {
#line 1634 "backend.c"
								EContactName* _tmp50_;
								const gchar* _tmp51_;
								gchar* _tmp52_;
#line 198 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp50_ = contact_name;
#line 198 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp51_ = v;
#line 198 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp52_ = g_strdup (_tmp51_);
#line 198 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp50_->prefixes);
#line 198 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp50_->prefixes = _tmp52_;
#line 1648 "backend.c"
							} else {
								const gchar* _tmp53_;
								gint _tmp54_ = 0;
#line 200 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp53_ = k;
#line 200 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp54_ = string_index_of (_tmp53_, "suffixes", 0);
#line 200 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								if (_tmp54_ >= 0) {
#line 1658 "backend.c"
									EContactName* _tmp55_;
									const gchar* _tmp56_;
									gchar* _tmp57_;
#line 202 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
									_tmp55_ = contact_name;
#line 202 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
									_tmp56_ = v;
#line 202 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
									_tmp57_ = g_strdup (_tmp56_);
#line 202 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
									_g_free0 (_tmp55_->suffixes);
#line 202 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
									_tmp55_->suffixes = _tmp57_;
#line 1672 "backend.c"
								}
							}
						}
					}
				}
#line 205 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				added_contact_name = TRUE;
#line 181 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_g_free0 (v);
#line 1682 "backend.c"
			} else {
				const gchar* _tmp58_;
#line 207 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp58_ = k;
#line 207 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				if (g_strcmp0 (_tmp58_, "avatar") == 0) {
#line 1689 "backend.c"
					GeeHashMap* _tmp59_;
					const gchar* _tmp60_;
					gpointer _tmp61_ = NULL;
					GValue* _tmp62_;
					const gchar* _tmp63_ = NULL;
					gchar* _tmp64_;
					gchar* _tmp65_;
					gchar* v;
					guint8* photo_content = NULL;
					gint photo_content_length1 = 0;
					gint _photo_content_size_ = 0;
					const gchar* _tmp66_;
					GFile* _tmp67_ = NULL;
					GFile* file;
#line 209 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp59_ = c;
#line 209 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp60_ = k;
#line 209 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp61_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp59_, _tmp60_);
#line 209 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp62_ = (GValue*) _tmp61_;
#line 209 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp63_ = g_value_get_string (_tmp62_);
#line 209 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp64_ = g_strdup (_tmp63_);
#line 209 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp65_ = _tmp64_;
#line 209 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					__vala_GValue_free0 (_tmp62_);
#line 209 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					v = _tmp65_;
#line 211 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp66_ = v;
#line 211 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp67_ = g_file_new_for_path (_tmp66_);
#line 211 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					file = _tmp67_;
#line 1728 "backend.c"
					{
						GFile* _tmp68_;
						guint8* _tmp69_ = NULL;
						gsize _tmp70_;
						EContactPhoto* _tmp71_;
						EContactPhoto* cp;
						EContactPhoto* _tmp72_;
						EContactPhoto* _tmp73_;
						guint8* _tmp74_;
						gint _tmp74__length1;
						EContact* _tmp75_;
						EContactField _tmp76_ = 0;
						EContactPhoto* _tmp77_;
#line 215 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp68_ = file;
#line 215 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						g_file_load_contents (_tmp68_, NULL, &_tmp69_, &_tmp70_, NULL, &_inner_error_);
#line 215 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						photo_content = (g_free (photo_content), NULL);
#line 215 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						photo_content = _tmp69_;
#line 215 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						photo_content_length1 = _tmp70_;
#line 215 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_photo_content_size_ = photo_content_length1;
#line 215 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						if (_inner_error_ != NULL) {
#line 1756 "backend.c"
							goto __catch5_g_error;
						}
#line 217 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp71_ = e_contact_photo_new ();
#line 217 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						cp = _tmp71_;
#line 218 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp72_ = cp;
#line 218 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp72_->type = E_CONTACT_PHOTO_TYPE_INLINED;
#line 219 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp73_ = cp;
#line 219 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp74_ = photo_content;
#line 219 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp74__length1 = photo_content_length1;
#line 219 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						e_contact_photo_set_inlined (_tmp73_, _tmp74_, (gsize) _tmp74__length1);
#line 221 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp75_ = contact;
#line 221 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp76_ = e_contact_field_id ("photo");
#line 221 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp77_ = cp;
#line 221 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						e_contact_set (_tmp75_, _tmp76_, _tmp77_);
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						__vala_EContactPhoto_free0 (cp);
#line 1785 "backend.c"
					}
					goto __finally5;
					__catch5_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp78_;
						GError* _tmp79_;
						const gchar* _tmp80_;
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						e = _inner_error_;
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_inner_error_ = NULL;
#line 225 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp78_ = v;
#line 225 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp79_ = e;
#line 225 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp80_ = _tmp79_->message;
#line 225 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						g_warning ("backend.vala:225: \n\nCan't load avatar %s: %s\n\n", _tmp78_, _tmp80_);
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_g_error_free0 (e);
#line 1808 "backend.c"
					}
					__finally5:
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					if (_inner_error_ != NULL) {
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (file);
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						photo_content = (g_free (photo_content), NULL);
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_g_free0 (v);
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_g_free0 (k);
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (_k_it);
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_g_free0 (contact_field_name);
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						__vala_EContactName_free0 (contact_name);
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						g_clear_error (&_inner_error_);
#line 213 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						return;
#line 1833 "backend.c"
					}
#line 207 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_g_object_unref0 (file);
#line 207 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					photo_content = (g_free (photo_content), NULL);
#line 207 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_g_free0 (v);
#line 1841 "backend.c"
				} else {
					const gchar* _tmp81_;
#line 229 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					_tmp81_ = k;
#line 229 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
					if (g_strcmp0 (_tmp81_, "im_addresses") == 0) {
#line 1848 "backend.c"
						GeeHashMap* _tmp82_;
						const gchar* _tmp83_;
						gpointer _tmp84_ = NULL;
						GValue* _tmp85_;
						const gchar* _tmp86_ = NULL;
						gchar* _tmp87_;
						gchar* _tmp88_;
						gchar* v;
						const gchar* _tmp89_;
						GeeHashMap* _tmp90_ = NULL;
						GeeHashMap* addresses;
#line 231 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp82_ = c;
#line 231 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp83_ = k;
#line 231 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp84_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp82_, _tmp83_);
#line 231 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp85_ = (GValue*) _tmp84_;
#line 231 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp86_ = g_value_get_string (_tmp85_);
#line 231 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp87_ = g_strdup (_tmp86_);
#line 231 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp88_ = _tmp87_;
#line 231 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						__vala_GValue_free0 (_tmp85_);
#line 231 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						v = _tmp88_;
#line 232 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp89_ = v;
#line 232 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp90_ = _eds_test_backend_parse_addrs (self, _tmp89_);
#line 232 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						addresses = _tmp90_;
#line 1884 "backend.c"
						{
							GeeHashMap* _tmp91_;
							GeeSet* _tmp92_;
							GeeSet* _tmp93_;
							GeeSet* _tmp94_;
							GeeIterator* _tmp95_ = NULL;
							GeeIterator* _tmp96_;
							GeeIterator* _addr_it;
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp91_ = addresses;
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp92_ = gee_abstract_map_get_keys ((GeeMap*) _tmp91_);
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp93_ = _tmp92_;
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp94_ = _tmp93_;
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp95_ = gee_iterable_iterator ((GeeIterable*) _tmp94_);
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp96_ = _tmp95_;
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_object_unref0 (_tmp94_);
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_addr_it = _tmp96_;
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							while (TRUE) {
#line 1911 "backend.c"
								GeeIterator* _tmp97_;
								gboolean _tmp98_ = FALSE;
								GeeIterator* _tmp99_;
								gpointer _tmp100_ = NULL;
								gchar* addr;
								GeeHashMap* _tmp101_;
								const gchar* _tmp102_;
								gpointer _tmp103_ = NULL;
								gchar* proto;
								EContact* _tmp104_;
								const gchar* _tmp105_;
								EContactField _tmp106_ = 0;
								const gchar* _tmp107_;
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp97_ = _addr_it;
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp98_ = gee_iterator_next (_tmp97_);
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								if (!_tmp98_) {
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
									break;
#line 1933 "backend.c"
								}
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp99_ = _addr_it;
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp100_ = gee_iterator_get (_tmp99_);
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								addr = (gchar*) _tmp100_;
#line 235 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp101_ = addresses;
#line 235 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp102_ = addr;
#line 235 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp103_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp101_, _tmp102_);
#line 235 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								proto = (gchar*) _tmp103_;
#line 236 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp104_ = contact;
#line 236 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp105_ = proto;
#line 236 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp106_ = e_contact_field_id (_tmp105_);
#line 236 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_tmp107_ = addr;
#line 236 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								e_contact_set (_tmp104_, _tmp106_, _tmp107_);
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_g_free0 (proto);
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
								_g_free0 (addr);
#line 1963 "backend.c"
							}
#line 233 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_object_unref0 (_addr_it);
#line 1967 "backend.c"
						}
#line 229 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (addresses);
#line 229 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_g_free0 (v);
#line 1973 "backend.c"
					} else {
						const gchar* _tmp108_;
						const gchar* _tmp109_;
#line 239 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp108_ = k;
#line 239 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						_tmp109_ = EDSF_PERSONA_address_fields[0];
#line 239 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
						if (g_strcmp0 (_tmp108_, _tmp109_) == 0) {
#line 1983 "backend.c"
							GeeHashMap* _tmp110_;
							const gchar* _tmp111_;
							gpointer _tmp112_ = NULL;
							GValue* _tmp113_;
							GObject* _tmp114_ = NULL;
							FolksPostalAddressFieldDetails* _tmp115_;
							FolksPostalAddressFieldDetails* _tmp116_;
							FolksPostalAddressFieldDetails* pa_fd;
							FolksPostalAddressFieldDetails* _tmp117_;
							gconstpointer _tmp118_;
							FolksPostalAddress* _tmp119_;
							FolksPostalAddress* _tmp120_;
							FolksPostalAddress* pa;
							EContactAddress* _tmp121_;
							EContactAddress* address;
							EContactAddress* _tmp122_;
							FolksPostalAddress* _tmp123_;
							const gchar* _tmp124_;
							const gchar* _tmp125_;
							gchar* _tmp126_;
							EContactAddress* _tmp127_;
							FolksPostalAddress* _tmp128_;
							const gchar* _tmp129_;
							const gchar* _tmp130_;
							gchar* _tmp131_;
							EContactAddress* _tmp132_;
							FolksPostalAddress* _tmp133_;
							const gchar* _tmp134_;
							const gchar* _tmp135_;
							gchar* _tmp136_;
							EContactAddress* _tmp137_;
							FolksPostalAddress* _tmp138_;
							const gchar* _tmp139_;
							const gchar* _tmp140_;
							gchar* _tmp141_;
							EContactAddress* _tmp142_;
							FolksPostalAddress* _tmp143_;
							const gchar* _tmp144_;
							const gchar* _tmp145_;
							gchar* _tmp146_;
							EContactAddress* _tmp147_;
							FolksPostalAddress* _tmp148_;
							const gchar* _tmp149_;
							const gchar* _tmp150_;
							gchar* _tmp151_;
							EContactAddress* _tmp152_;
							FolksPostalAddress* _tmp153_;
							const gchar* _tmp154_;
							const gchar* _tmp155_;
							gchar* _tmp156_;
							EContactAddress* _tmp157_;
							FolksPostalAddress* _tmp158_;
							const gchar* _tmp159_;
							const gchar* _tmp160_;
							gchar* _tmp161_;
							EContact* _tmp162_;
							const gchar* _tmp163_;
							EContactField _tmp164_ = 0;
							EContactAddress* _tmp165_;
#line 241 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp110_ = c;
#line 241 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp111_ = k;
#line 241 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp112_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp110_, _tmp111_);
#line 241 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp113_ = (GValue*) _tmp112_;
#line 241 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp114_ = g_value_get_object (_tmp113_);
#line 241 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp115_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails));
#line 241 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp116_ = _tmp115_;
#line 241 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							__vala_GValue_free0 (_tmp113_);
#line 241 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							pa_fd = _tmp116_;
#line 242 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp117_ = pa_fd;
#line 242 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp118_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp117_);
#line 242 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp119_ = _tmp118_;
#line 242 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp120_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((FolksPostalAddress*) _tmp119_, FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress));
#line 242 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							pa = _tmp120_;
#line 243 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp121_ = e_contact_address_new ();
#line 243 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							address = _tmp121_;
#line 244 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp122_ = address;
#line 244 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp123_ = pa;
#line 244 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp124_ = folks_postal_address_get_po_box (_tmp123_);
#line 244 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp125_ = _tmp124_;
#line 244 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp126_ = g_strdup (_tmp125_);
#line 244 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp122_->po);
#line 244 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp122_->po = _tmp126_;
#line 245 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp127_ = address;
#line 245 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp128_ = pa;
#line 245 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp129_ = folks_postal_address_get_extension (_tmp128_);
#line 245 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp130_ = _tmp129_;
#line 245 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp131_ = g_strdup (_tmp130_);
#line 245 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp127_->ext);
#line 245 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp127_->ext = _tmp131_;
#line 246 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp132_ = address;
#line 246 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp133_ = pa;
#line 246 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp134_ = folks_postal_address_get_street (_tmp133_);
#line 246 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp135_ = _tmp134_;
#line 246 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp136_ = g_strdup (_tmp135_);
#line 246 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp132_->street);
#line 246 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp132_->street = _tmp136_;
#line 247 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp137_ = address;
#line 247 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp138_ = pa;
#line 247 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp139_ = folks_postal_address_get_locality (_tmp138_);
#line 247 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp140_ = _tmp139_;
#line 247 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp141_ = g_strdup (_tmp140_);
#line 247 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp137_->locality);
#line 247 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp137_->locality = _tmp141_;
#line 248 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp142_ = address;
#line 248 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp143_ = pa;
#line 248 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp144_ = folks_postal_address_get_region (_tmp143_);
#line 248 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp145_ = _tmp144_;
#line 248 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp146_ = g_strdup (_tmp145_);
#line 248 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp142_->region);
#line 248 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp142_->region = _tmp146_;
#line 249 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp147_ = address;
#line 249 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp148_ = pa;
#line 249 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp149_ = folks_postal_address_get_postal_code (_tmp148_);
#line 249 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp150_ = _tmp149_;
#line 249 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp151_ = g_strdup (_tmp150_);
#line 249 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp147_->code);
#line 249 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp147_->code = _tmp151_;
#line 250 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp152_ = address;
#line 250 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp153_ = pa;
#line 250 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp154_ = folks_postal_address_get_country (_tmp153_);
#line 250 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp155_ = _tmp154_;
#line 250 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp156_ = g_strdup (_tmp155_);
#line 250 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp152_->country);
#line 250 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp152_->country = _tmp156_;
#line 251 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp157_ = address;
#line 251 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp158_ = pa;
#line 251 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp159_ = folks_postal_address_get_address_format (_tmp158_);
#line 251 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp160_ = _tmp159_;
#line 251 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp161_ = g_strdup (_tmp160_);
#line 251 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp157_->address_format);
#line 251 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp157_->address_format = _tmp161_;
#line 253 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp162_ = contact;
#line 253 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp163_ = k;
#line 253 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp164_ = e_contact_field_id (_tmp163_);
#line 253 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp165_ = address;
#line 253 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							e_contact_set (_tmp162_, _tmp164_, _tmp165_);
#line 239 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							__vala_EContactAddress_free0 (address);
#line 239 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_object_unref0 (pa);
#line 239 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_object_unref0 (pa_fd);
#line 2203 "backend.c"
						} else {
							GeeHashMap* _tmp166_;
							const gchar* _tmp167_;
							gpointer _tmp168_ = NULL;
							GValue* _tmp169_;
							const gchar* _tmp170_ = NULL;
							gchar* _tmp171_;
							gchar* _tmp172_;
							gchar* v;
							EContact* _tmp173_;
							const gchar* _tmp174_;
							EContactField _tmp175_ = 0;
							const gchar* _tmp176_;
#line 257 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp166_ = c;
#line 257 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp167_ = k;
#line 257 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp168_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp166_, _tmp167_);
#line 257 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp169_ = (GValue*) _tmp168_;
#line 257 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp170_ = g_value_get_string (_tmp169_);
#line 257 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp171_ = g_strdup (_tmp170_);
#line 257 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp172_ = _tmp171_;
#line 257 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							__vala_GValue_free0 (_tmp169_);
#line 257 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							v = _tmp172_;
#line 258 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp173_ = contact;
#line 258 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp174_ = k;
#line 258 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp175_ = e_contact_field_id (_tmp174_);
#line 258 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_tmp176_ = v;
#line 258 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							e_contact_set (_tmp173_, _tmp175_, _tmp176_);
#line 239 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
							_g_free0 (v);
#line 2247 "backend.c"
						}
					}
				}
			}
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_g_free0 (k);
#line 2254 "backend.c"
		}
#line 179 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_k_it);
#line 2258 "backend.c"
	}
#line 261 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp177_ = added_contact_name;
#line 261 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (_tmp177_) {
#line 2264 "backend.c"
		EContact* _tmp178_;
		EContactField _tmp179_ = 0;
		EContactName* _tmp180_;
#line 263 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp178_ = contact;
#line 263 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp179_ = e_contact_field_id ("name");
#line 263 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp180_ = contact_name;
#line 263 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e_contact_set (_tmp178_, _tmp179_, _tmp180_);
#line 2276 "backend.c"
	}
#line 171 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_free0 (contact_field_name);
#line 171 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	__vala_EContactName_free0 (contact_name);
#line 2282 "backend.c"
}


static void __lambda3_ (EdsTestBackend* self, GObject* o, GAsyncResult* r) {
	GError * _inner_error_ = NULL;
#line 273 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (r != NULL);
#line 2290 "backend.c"
	{
		EBookClient* _tmp0_;
		GAsyncResult* _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean ret;
#line 277 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp0_ = self->priv->_addressbook;
#line 277 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp1_ = r;
#line 277 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp2_ = e_client_remove_finish ((EClient*) _tmp0_, _tmp1_, &_inner_error_);
#line 277 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		ret = _tmp2_;
#line 277 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 2306 "backend.c"
			goto __catch6_g_error;
		}
#line 278 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		if (ret == FALSE) {
#line 2311 "backend.c"
			const gchar* _tmp3_;
#line 280 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_tmp3_ = self->priv->_addressbook_name;
#line 280 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			g_warning ("backend.vala:280: remove() addressbook returned false on %s\n", _tmp3_);
#line 2317 "backend.c"
		}
#line 283 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_addressbook);
#line 283 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook = NULL;
#line 2323 "backend.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 275 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 275 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 287 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp4_ = self->priv->_addressbook_name;
#line 287 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp5_ = e;
#line 287 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_tmp6_ = _tmp5_->message;
#line 287 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:287: Unable to remove addressbook %s because: %s\n", _tmp4_, _tmp6_);
#line 275 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 2346 "backend.c"
	}
	__finally6:
#line 275 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (_inner_error_ != NULL) {
#line 275 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 275 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 275 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		return;
#line 2357 "backend.c"
	}
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 273 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	__lambda3_ (self, source_object, res);
#line 273 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	eds_test_backend_unref (self);
#line 2367 "backend.c"
}


void eds_test_backend_tear_down (EdsTestBackend* self) {
	EBookClient* _tmp0_;
#line 267 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 269 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", "", TRUE);
#line 273 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp0_ = self->priv->_addressbook;
#line 273 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	e_client_remove ((EClient*) _tmp0_, NULL, ___lambda3__gasync_ready_callback, eds_test_backend_ref (self));
#line 2381 "backend.c"
}


static GeeHashMap* _eds_test_backend_parse_addrs (EdsTestBackend* self, const gchar* addr_s) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* ret;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** im_addrs;
	gint im_addrs_length1;
	gint _im_addrs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
#line 293 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 293 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (addr_s != NULL, NULL);
#line 295 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 295 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	ret = _tmp0_;
#line 296 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp1_ = addr_s;
#line 296 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
#line 296 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	im_addrs = _tmp3_;
#line 296 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	im_addrs_length1 = _vala_array_length (_tmp2_);
#line 296 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_im_addrs_size_ = im_addrs_length1;
#line 298 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp4_ = im_addrs;
#line 298 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp4__length1 = im_addrs_length1;
#line 2419 "backend.c"
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
#line 298 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		a_collection = _tmp4_;
#line 298 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		a_collection_length1 = _tmp4__length1;
#line 298 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		for (a_it = 0; a_it < _tmp4__length1; a_it = a_it + 1) {
#line 2431 "backend.c"
			gchar* _tmp5_;
			gchar* a = NULL;
#line 298 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			_tmp5_ = g_strdup (a_collection[a_it]);
#line 298 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			a = _tmp5_;
#line 2438 "backend.c"
			{
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_ = NULL;
				gchar** info;
				gint info_length1;
				gint _info_size_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* proto;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* addr;
				GeeHashMap* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
#line 300 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp6_ = a;
#line 300 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "#", 0);
#line 300 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				info = _tmp8_;
#line 300 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				info_length1 = _vala_array_length (_tmp7_);
#line 300 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_info_size_ = info_length1;
#line 301 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp9_ = info;
#line 301 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp9__length1 = info_length1;
#line 301 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp10_ = _tmp9_[0];
#line 301 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp11_ = g_strdup (_tmp10_);
#line 301 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				proto = _tmp11_;
#line 302 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp12_ = info;
#line 302 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp12__length1 = info_length1;
#line 302 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp13_ = _tmp12_[1];
#line 302 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 302 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				addr = _tmp14_;
#line 304 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp15_ = ret;
#line 304 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp16_ = addr;
#line 304 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				addr = NULL;
#line 304 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp17_ = _tmp16_;
#line 304 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp18_ = proto;
#line 304 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				proto = NULL;
#line 304 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_tmp19_ = _tmp18_;
#line 304 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp17_, _tmp19_);
#line 304 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp19_);
#line 304 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp17_);
#line 298 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_g_free0 (addr);
#line 298 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_g_free0 (proto);
#line 298 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 298 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
				_g_free0 (a);
#line 2519 "backend.c"
			}
		}
	}
#line 307 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	result = ret;
#line 307 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	im_addrs = (_vala_array_free (im_addrs, im_addrs_length1, (GDestroyNotify) g_free), NULL);
#line 307 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return result;
#line 2529 "backend.c"
}


const gchar* eds_test_backend_get_address_book_uid (EdsTestBackend* self) {
	const gchar* result;
	EBookClient* _tmp0_;
	ESource* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 44 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp0_ = self->priv->_addressbook;
#line 44 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp1_ = e_client_get_source ((EClient*) _tmp0_);
#line 44 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_tmp2_ = e_source_get_uid (_tmp1_);
#line 44 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	result = _tmp2_;
#line 44 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return result;
#line 2550 "backend.c"
}


static void eds_test_value_backend_init (GValue* value) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	value->data[0].v_pointer = NULL;
#line 2557 "backend.c"
}


static void eds_test_value_backend_free_value (GValue* value) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (value->data[0].v_pointer) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (value->data[0].v_pointer);
#line 2566 "backend.c"
	}
}


static void eds_test_value_backend_copy_value (const GValue* src_value, GValue* dest_value) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (src_value->data[0].v_pointer) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		dest_value->data[0].v_pointer = eds_test_backend_ref (src_value->data[0].v_pointer);
#line 2576 "backend.c"
	} else {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2580 "backend.c"
	}
}


static gpointer eds_test_value_backend_peek_pointer (const GValue* value) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return value->data[0].v_pointer;
#line 2588 "backend.c"
}


static gchar* eds_test_value_backend_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (collect_values[0].v_pointer) {
#line 2595 "backend.c"
		EdsTestBackend* object;
		object = collect_values[0].v_pointer;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		if (object->parent_instance.g_class == NULL) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2602 "backend.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2606 "backend.c"
		}
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = eds_test_backend_ref (object);
#line 2610 "backend.c"
	} else {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 2614 "backend.c"
	}
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return NULL;
#line 2618 "backend.c"
}


static gchar* eds_test_value_backend_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EdsTestBackend** object_p;
	object_p = collect_values[0].v_pointer;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (!object_p) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2629 "backend.c"
	}
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (!value->data[0].v_pointer) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		*object_p = NULL;
#line 2635 "backend.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		*object_p = value->data[0].v_pointer;
#line 2639 "backend.c"
	} else {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		*object_p = eds_test_backend_ref (value->data[0].v_pointer);
#line 2643 "backend.c"
	}
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return NULL;
#line 2647 "backend.c"
}


GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	EdsTestParamSpecBackend* spec;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (g_type_is_a (object_type, EDS_TEST_TYPE_BACKEND), NULL);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return G_PARAM_SPEC (spec);
#line 2661 "backend.c"
}


gpointer eds_test_value_get_backend (const GValue* value) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND), NULL);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return value->data[0].v_pointer;
#line 2670 "backend.c"
}


void eds_test_value_set_backend (GValue* value, gpointer v_object) {
	EdsTestBackend* old;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	old = value->data[0].v_pointer;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (v_object) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = v_object;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		eds_test_backend_ref (value->data[0].v_pointer);
#line 2690 "backend.c"
	} else {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 2694 "backend.c"
	}
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (old) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (old);
#line 2700 "backend.c"
	}
}


void eds_test_value_take_backend (GValue* value, gpointer v_object) {
	EdsTestBackend* old;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	old = value->data[0].v_pointer;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (v_object) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = v_object;
#line 2719 "backend.c"
	} else {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 2723 "backend.c"
	}
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (old) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (old);
#line 2729 "backend.c"
	}
}


static void eds_test_backend_class_init (EdsTestBackendClass * klass) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	eds_test_backend_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	EDS_TEST_BACKEND_CLASS (klass)->finalize = eds_test_backend_finalize;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_type_class_add_private (klass, sizeof (EdsTestBackendPrivate));
#line 2741 "backend.c"
}


static void eds_test_backend_instance_init (EdsTestBackend * self) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	self->priv = EDS_TEST_BACKEND_GET_PRIVATE (self);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	self->ref_count = 1;
#line 2750 "backend.c"
}


static void eds_test_backend_finalize (EdsTestBackend* obj) {
	EdsTestBackend * self;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDS_TEST_TYPE_BACKEND, EdsTestBackend);
#line 35 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_free0 (self->priv->_addressbook_name);
#line 36 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_addressbook);
#line 37 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_free0_0 (self->priv->_e_contacts);
#line 38 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 39 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source_registry);
#line 40 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source);
#line 2770 "backend.c"
}


GType eds_test_backend_get_type (void) {
	static volatile gsize eds_test_backend_type_id__volatile = 0;
	if (g_once_init_enter (&eds_test_backend_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { eds_test_value_backend_init, eds_test_value_backend_free_value, eds_test_value_backend_copy_value, eds_test_value_backend_peek_pointer, "p", eds_test_value_backend_collect_value, "p", eds_test_value_backend_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EdsTestBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) eds_test_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EdsTestBackend), 0, (GInstanceInitFunc) eds_test_backend_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType eds_test_backend_type_id;
		eds_test_backend_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EdsTestBackend", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&eds_test_backend_type_id__volatile, eds_test_backend_type_id);
	}
	return eds_test_backend_type_id__volatile;
}


gpointer eds_test_backend_ref (gpointer instance) {
	EdsTestBackend* self;
	self = instance;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&self->ref_count);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	return instance;
#line 2795 "backend.c"
}


void eds_test_backend_unref (gpointer instance) {
	EdsTestBackend* self;
	self = instance;
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		EDS_TEST_BACKEND_GET_CLASS (self)->finalize (self);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/tests/lib/eds/backend.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2808 "backend.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



