/* valagobjectmodule.c generated by valac, the Vala compiler
 * generated from valagobjectmodule.vala, do not modify */

/* valagobjectmodule.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <glib.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))

struct _ValaGObjectModulePrivate {
	gint dynamic_property_id;
	gint signal_wrapper_id;
};

static gint ValaGObjectModule_private_offset;
static gpointer vala_gobject_module_parent_class = NULL;

static void vala_gobject_module_real_visit_class (ValaCodeVisitor* base,
                                           ValaClass* cl);
static gboolean vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self,
                                                            ValaClass* cl);
static void vala_gobject_module_add_get_property_function (ValaGObjectModule* self,
                                                    ValaClass* cl);
static gboolean vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self,
                                                            ValaClass* cl);
static void vala_gobject_module_add_set_property_function (ValaGObjectModule* self,
                                                    ValaClass* cl);
static void vala_gobject_module_real_generate_class_init (ValaGTypeModule* base,
                                                   ValaClass* cl);
static void vala_gobject_module_add_guarded_expression (ValaGObjectModule* self,
                                                 ValaSymbol* sym,
                                                 ValaCCodeExpression* expression);
static void vala_gobject_module_emit_invalid_property_id_warn (ValaGObjectModule* self);
static void vala_gobject_module_real_visit_constructor (ValaCodeVisitor* base,
                                                 ValaConstructor* c);
static gchar* vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeBaseModule* base,
                                                                   ValaDynamicProperty* prop);
static gchar* vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeBaseModule* base,
                                                                   ValaDynamicProperty* prop);
static gchar* vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeBaseModule* base,
                                                          ValaDynamicSignal* node);
static gchar* vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeBaseModule* base,
                                                                         ValaDynamicSignal* sig);
static void vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self,
                                                           ValaDynamicSignal* sig,
                                                           gboolean after);
static gchar* vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name (ValaCCodeBaseModule* base,
                                                                               ValaDynamicSignal* sig);
static void vala_gobject_module_real_visit_property (ValaCodeVisitor* base,
                                              ValaProperty* prop);
static void vala_gobject_module_real_visit_method_call (ValaCodeVisitor* base,
                                                 ValaMethodCall* expr);
static void vala_gobject_module_finalize (ValaCodeVisitor * obj);
static GType vala_gobject_module_get_type_once (void);

static inline gpointer
vala_gobject_module_get_instance_private (ValaGObjectModule* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGObjectModule_private_offset);
}

static void
vala_gobject_module_real_visit_class (ValaCodeVisitor* base,
                                      ValaClass* cl)
{
	ValaGObjectModule * self;
	ValaTypeSymbol* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_class ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), cl);
	_tmp0_ = ((ValaCCodeBaseModule*) self)->gobject_type;
	if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, _tmp0_)) {
		return;
	}
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
	_tmp2_ = _tmp1_;
	vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp2_);
	if (vala_gobject_module_class_has_readable_properties (self, cl)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp3_) {
		vala_gobject_module_add_get_property_function (self, cl);
	}
	if (vala_gobject_module_class_has_writable_properties (self, cl)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp4_) {
		vala_gobject_module_add_set_property_function (self, cl);
	}
	vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_gobject_module_real_generate_class_init (ValaGTypeModule* base,
                                              ValaClass* cl)
{
	ValaGObjectModule * self;
	ValaTypeSymbol* _tmp0_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp20_ = FALSE;
	ValaConstructor* _tmp32_;
	ValaConstructor* _tmp33_;
	gboolean _tmp52_ = FALSE;
	ValaList* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	ValaList* props = NULL;
	ValaList* _tmp226_;
	ValaList* _tmp227_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = ((ValaCCodeBaseModule*) self)->gobject_type;
	if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, _tmp0_)) {
		return;
	}
	_tmp1_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2_);
	_tmp4_ = _tmp3_;
	_vala_ccode_node_unref0 (_tmp2_);
	ccall = _tmp4_;
	_tmp5_ = ccall;
	_tmp6_ = vala_ccode_identifier_new ("klass");
	_tmp7_ = _tmp6_;
	vala_ccode_function_call_add_argument (_tmp5_, (ValaCCodeExpression*) _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	if (vala_gobject_module_class_has_readable_properties (self, cl)) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp8_) {
		ValaCCodeFunction* _tmp9_;
		ValaCCodeFunction* _tmp10_;
		ValaCCodeFunctionCall* _tmp11_;
		ValaCCodeMemberAccess* _tmp12_;
		ValaCCodeMemberAccess* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeIdentifier* _tmp19_;
		_tmp9_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = ccall;
		_tmp12_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp11_, "get_property");
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("_vala_%s_get_property", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_ccode_identifier_new (_tmp17_);
		_tmp19_ = _tmp18_;
		vala_ccode_function_add_assignment (_tmp10_, (ValaCCodeExpression*) _tmp13_, (ValaCCodeExpression*) _tmp19_);
		_vala_ccode_node_unref0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_vala_ccode_node_unref0 (_tmp13_);
	}
	if (vala_gobject_module_class_has_writable_properties (self, cl)) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp20_) {
		ValaCCodeFunction* _tmp21_;
		ValaCCodeFunction* _tmp22_;
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeMemberAccess* _tmp24_;
		ValaCCodeMemberAccess* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		_tmp21_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = ccall;
		_tmp24_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp23_, "set_property");
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("_vala_%s_set_property", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_ccode_identifier_new (_tmp29_);
		_tmp31_ = _tmp30_;
		vala_ccode_function_add_assignment (_tmp22_, (ValaCCodeExpression*) _tmp25_, (ValaCCodeExpression*) _tmp31_);
		_vala_ccode_node_unref0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_vala_ccode_node_unref0 (_tmp25_);
	}
	_tmp32_ = vala_class_get_constructor (cl);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp34_;
		ValaCCodeIdentifier* _tmp35_;
		ValaCCodeFunctionCall* _tmp36_;
		ValaCCodeFunctionCall* _tmp37_;
		ValaCCodeFunctionCall* _tmp38_;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeIdentifier* _tmp40_;
		ValaCCodeFunction* _tmp41_;
		ValaCCodeFunction* _tmp42_;
		ValaCCodeFunctionCall* _tmp43_;
		ValaCCodeMemberAccess* _tmp44_;
		ValaCCodeMemberAccess* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		ValaCCodeIdentifier* _tmp50_;
		ValaCCodeIdentifier* _tmp51_;
		_tmp34_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp35_);
		_tmp37_ = _tmp36_;
		_vala_ccode_node_unref0 (_tmp35_);
		ccast = _tmp37_;
		_tmp38_ = ccast;
		_tmp39_ = vala_ccode_identifier_new ("klass");
		_tmp40_ = _tmp39_;
		vala_ccode_function_call_add_argument (_tmp38_, (ValaCCodeExpression*) _tmp40_);
		_vala_ccode_node_unref0 (_tmp40_);
		_tmp41_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = ccast;
		_tmp44_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp43_, "constructor");
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) cl);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_strdup_printf ("%sconstructor", _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_ccode_identifier_new (_tmp49_);
		_tmp51_ = _tmp50_;
		vala_ccode_function_add_assignment (_tmp42_, (ValaCCodeExpression*) _tmp45_, (ValaCCodeExpression*) _tmp51_);
		_vala_ccode_node_unref0 (_tmp51_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp47_);
		_vala_ccode_node_unref0 (_tmp45_);
		_vala_ccode_node_unref0 (ccast);
	}
	_tmp53_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) cl);
	_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
	_tmp55_ = _tmp54_;
	if (_tmp55_ > 0) {
		_tmp52_ = TRUE;
	} else {
		ValaDestructor* _tmp56_;
		ValaDestructor* _tmp57_;
		_tmp56_ = vala_class_get_destructor (cl);
		_tmp57_ = _tmp56_;
		_tmp52_ = _tmp57_ != NULL;
	}
	if (_tmp52_) {
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp58_;
		ValaCCodeIdentifier* _tmp59_;
		ValaCCodeFunctionCall* _tmp60_;
		ValaCCodeFunctionCall* _tmp61_;
		ValaCCodeFunctionCall* _tmp62_;
		ValaCCodeIdentifier* _tmp63_;
		ValaCCodeIdentifier* _tmp64_;
		ValaCCodeFunction* _tmp65_;
		ValaCCodeFunction* _tmp66_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaCCodeMemberAccess* _tmp68_;
		ValaCCodeMemberAccess* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		ValaCCodeIdentifier* _tmp74_;
		ValaCCodeIdentifier* _tmp75_;
		_tmp58_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp59_ = _tmp58_;
		_tmp60_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp59_);
		_tmp61_ = _tmp60_;
		_vala_ccode_node_unref0 (_tmp59_);
		ccast = _tmp61_;
		_tmp62_ = ccast;
		_tmp63_ = vala_ccode_identifier_new ("klass");
		_tmp64_ = _tmp63_;
		vala_ccode_function_call_add_argument (_tmp62_, (ValaCCodeExpression*) _tmp64_);
		_vala_ccode_node_unref0 (_tmp64_);
		_tmp65_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp66_ = _tmp65_;
		_tmp67_ = ccast;
		_tmp68_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp67_, "finalize");
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) cl);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_strdup_printf ("%sfinalize", _tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_ccode_identifier_new (_tmp73_);
		_tmp75_ = _tmp74_;
		vala_ccode_function_add_assignment (_tmp66_, (ValaCCodeExpression*) _tmp69_, (ValaCCodeExpression*) _tmp75_);
		_vala_ccode_node_unref0 (_tmp75_);
		_g_free0 (_tmp73_);
		_g_free0 (_tmp71_);
		_vala_ccode_node_unref0 (_tmp69_);
		_vala_ccode_node_unref0 (ccast);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp76_;
		ValaList* _tmp77_;
		gint _type_param_size = 0;
		ValaList* _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		gint _type_param_index = 0;
		_tmp76_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_tmp77_ = _vala_iterable_ref0 (_tmp76_);
		_type_param_list = _tmp77_;
		_tmp78_ = _type_param_list;
		_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
		_tmp80_ = _tmp79_;
		_type_param_size = _tmp80_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp81_;
			gint _tmp82_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp83_;
			gpointer _tmp84_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeConstant* func_name_constant = NULL;
			ValaCCodeFunctionCall* cinst = NULL;
			ValaCCodeFunctionCall* cspec = NULL;
			gchar* name_prefix = NULL;
			ValaTypeParameter* _tmp85_;
			const gchar* _tmp86_;
			const gchar* _tmp87_;
			gchar* _tmp88_;
			gchar* canonical_prefix = NULL;
			const gchar* _tmp89_;
			gchar* _tmp90_;
			const gchar* _tmp91_;
			gchar* _tmp92_;
			const gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			ValaCCodeConstant* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			const gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			ValaCCodeIdentifier* _tmp103_;
			ValaCCodeIdentifier* _tmp104_;
			ValaCCodeFunctionCall* _tmp105_;
			ValaCCodeFunctionCall* _tmp106_;
			ValaCCodeFunctionCall* _tmp107_;
			ValaCCodeFunctionCall* _tmp108_;
			const gchar* _tmp109_;
			ValaCCodeConstant* _tmp110_;
			ValaCCodeConstant* _tmp111_;
			ValaCCodeIdentifier* _tmp112_;
			ValaCCodeIdentifier* _tmp113_;
			ValaCCodeFunctionCall* _tmp114_;
			ValaCCodeFunctionCall* _tmp115_;
			ValaCCodeConstant* _tmp116_;
			ValaCCodeFunctionCall* _tmp117_;
			ValaCCodeConstant* _tmp118_;
			ValaCCodeConstant* _tmp119_;
			ValaCCodeFunctionCall* _tmp120_;
			ValaCCodeConstant* _tmp121_;
			ValaCCodeConstant* _tmp122_;
			ValaCCodeFunctionCall* _tmp123_;
			ValaCCodeIdentifier* _tmp124_;
			ValaCCodeIdentifier* _tmp125_;
			ValaCCodeFunctionCall* _tmp126_;
			ValaCCodeConstant* _tmp127_;
			ValaCCodeConstant* _tmp128_;
			ValaCCodeFunctionCall* _tmp129_;
			ValaCCodeFunctionCall* _tmp130_;
			ValaCCodeFunction* _tmp131_;
			ValaCCodeFunction* _tmp132_;
			ValaCCodeFunctionCall* _tmp133_;
			ValaCCodeEnum* _tmp134_;
			const gchar* _tmp135_;
			ValaCCodeEnumValue* _tmp136_;
			ValaCCodeEnumValue* _tmp137_;
			const gchar* _tmp138_;
			gchar* _tmp139_;
			const gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			ValaCCodeConstant* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			const gchar* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			gchar* _tmp149_;
			ValaCCodeIdentifier* _tmp150_;
			ValaCCodeIdentifier* _tmp151_;
			ValaCCodeFunctionCall* _tmp152_;
			ValaCCodeFunctionCall* _tmp153_;
			ValaCCodeFunctionCall* _tmp154_;
			ValaCCodeFunctionCall* _tmp155_;
			const gchar* _tmp156_;
			ValaCCodeConstant* _tmp157_;
			ValaCCodeConstant* _tmp158_;
			ValaCCodeIdentifier* _tmp159_;
			ValaCCodeIdentifier* _tmp160_;
			ValaCCodeFunctionCall* _tmp161_;
			ValaCCodeFunctionCall* _tmp162_;
			ValaCCodeConstant* _tmp163_;
			ValaCCodeFunctionCall* _tmp164_;
			ValaCCodeConstant* _tmp165_;
			ValaCCodeConstant* _tmp166_;
			ValaCCodeFunctionCall* _tmp167_;
			ValaCCodeConstant* _tmp168_;
			ValaCCodeConstant* _tmp169_;
			ValaCCodeFunctionCall* _tmp170_;
			ValaCCodeConstant* _tmp171_;
			ValaCCodeConstant* _tmp172_;
			ValaCCodeFunctionCall* _tmp173_;
			ValaCCodeFunctionCall* _tmp174_;
			ValaCCodeFunction* _tmp175_;
			ValaCCodeFunction* _tmp176_;
			ValaCCodeFunctionCall* _tmp177_;
			ValaCCodeEnum* _tmp178_;
			const gchar* _tmp179_;
			ValaCCodeEnumValue* _tmp180_;
			ValaCCodeEnumValue* _tmp181_;
			const gchar* _tmp182_;
			gchar* _tmp183_;
			const gchar* _tmp184_;
			gchar* _tmp185_;
			gchar* _tmp186_;
			ValaCCodeConstant* _tmp187_;
			gchar* _tmp188_;
			gchar* _tmp189_;
			const gchar* _tmp190_;
			gchar* _tmp191_;
			gchar* _tmp192_;
			gchar* _tmp193_;
			ValaCCodeIdentifier* _tmp194_;
			ValaCCodeIdentifier* _tmp195_;
			ValaCCodeFunctionCall* _tmp196_;
			ValaCCodeFunctionCall* _tmp197_;
			ValaCCodeFunctionCall* _tmp198_;
			ValaCCodeFunctionCall* _tmp199_;
			const gchar* _tmp200_;
			ValaCCodeConstant* _tmp201_;
			ValaCCodeConstant* _tmp202_;
			ValaCCodeIdentifier* _tmp203_;
			ValaCCodeIdentifier* _tmp204_;
			ValaCCodeFunctionCall* _tmp205_;
			ValaCCodeFunctionCall* _tmp206_;
			ValaCCodeConstant* _tmp207_;
			ValaCCodeFunctionCall* _tmp208_;
			ValaCCodeConstant* _tmp209_;
			ValaCCodeConstant* _tmp210_;
			ValaCCodeFunctionCall* _tmp211_;
			ValaCCodeConstant* _tmp212_;
			ValaCCodeConstant* _tmp213_;
			ValaCCodeFunctionCall* _tmp214_;
			ValaCCodeConstant* _tmp215_;
			ValaCCodeConstant* _tmp216_;
			ValaCCodeFunctionCall* _tmp217_;
			ValaCCodeFunctionCall* _tmp218_;
			ValaCCodeFunction* _tmp219_;
			ValaCCodeFunction* _tmp220_;
			ValaCCodeFunctionCall* _tmp221_;
			ValaCCodeEnum* _tmp222_;
			const gchar* _tmp223_;
			ValaCCodeEnumValue* _tmp224_;
			ValaCCodeEnumValue* _tmp225_;
			_type_param_index = _type_param_index + 1;
			_tmp81_ = _type_param_index;
			_tmp82_ = _type_param_size;
			if (!(_tmp81_ < _tmp82_)) {
				break;
			}
			_tmp83_ = _type_param_list;
			_tmp84_ = vala_list_get (_tmp83_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp84_;
			_tmp85_ = type_param;
			_tmp86_ = vala_symbol_get_name ((ValaSymbol*) _tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = g_utf8_strdown (_tmp87_, (gssize) -1);
			name_prefix = _tmp88_;
			_tmp89_ = name_prefix;
			_tmp90_ = string_replace (_tmp89_, "_", "-");
			canonical_prefix = _tmp90_;
			_tmp91_ = name_prefix;
			_tmp92_ = g_strdup_printf ("%s_type", _tmp91_);
			_g_free0 (func_name);
			func_name = _tmp92_;
			_tmp93_ = canonical_prefix;
			_tmp94_ = g_strdup_printf ("\"%s-type\"", _tmp93_);
			_tmp95_ = _tmp94_;
			_tmp96_ = vala_ccode_constant_new (_tmp95_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp96_;
			_g_free0 (_tmp95_);
			_tmp97_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp98_ = _tmp97_;
			_tmp99_ = func_name;
			_tmp100_ = g_strdup_printf ("%s_%s", _tmp98_, _tmp99_);
			_tmp101_ = _tmp100_;
			_tmp102_ = g_ascii_strup (_tmp101_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp102_;
			_g_free0 (_tmp101_);
			_g_free0 (_tmp98_);
			_tmp103_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp104_ = _tmp103_;
			_tmp105_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp104_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp105_;
			_vala_ccode_node_unref0 (_tmp104_);
			_tmp106_ = cinst;
			_tmp107_ = ccall;
			vala_ccode_function_call_add_argument (_tmp106_, (ValaCCodeExpression*) _tmp107_);
			_tmp108_ = cinst;
			_tmp109_ = enum_value;
			_tmp110_ = vala_ccode_constant_new (_tmp109_);
			_tmp111_ = _tmp110_;
			vala_ccode_function_call_add_argument (_tmp108_, (ValaCCodeExpression*) _tmp111_);
			_vala_ccode_node_unref0 (_tmp111_);
			_tmp112_ = vala_ccode_identifier_new ("g_param_spec_gtype");
			_tmp113_ = _tmp112_;
			_tmp114_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp113_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp114_;
			_vala_ccode_node_unref0 (_tmp113_);
			_tmp115_ = cspec;
			_tmp116_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp115_, (ValaCCodeExpression*) _tmp116_);
			_tmp117_ = cspec;
			_tmp118_ = vala_ccode_constant_new ("\"type\"");
			_tmp119_ = _tmp118_;
			vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
			_vala_ccode_node_unref0 (_tmp119_);
			_tmp120_ = cspec;
			_tmp121_ = vala_ccode_constant_new ("\"type\"");
			_tmp122_ = _tmp121_;
			vala_ccode_function_call_add_argument (_tmp120_, (ValaCCodeExpression*) _tmp122_);
			_vala_ccode_node_unref0 (_tmp122_);
			_tmp123_ = cspec;
			_tmp124_ = vala_ccode_identifier_new ("G_TYPE_NONE");
			_tmp125_ = _tmp124_;
			vala_ccode_function_call_add_argument (_tmp123_, (ValaCCodeExpression*) _tmp125_);
			_vala_ccode_node_unref0 (_tmp125_);
			_tmp126_ = cspec;
			_tmp127_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY");
			_tmp128_ = _tmp127_;
			vala_ccode_function_call_add_argument (_tmp126_, (ValaCCodeExpression*) _tmp128_);
			_vala_ccode_node_unref0 (_tmp128_);
			_tmp129_ = cinst;
			_tmp130_ = cspec;
			vala_ccode_function_call_add_argument (_tmp129_, (ValaCCodeExpression*) _tmp130_);
			_tmp131_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp132_ = _tmp131_;
			_tmp133_ = cinst;
			vala_ccode_function_add_expression (_tmp132_, (ValaCCodeExpression*) _tmp133_);
			_tmp134_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp135_ = enum_value;
			_tmp136_ = vala_ccode_enum_value_new (_tmp135_, NULL);
			_tmp137_ = _tmp136_;
			vala_ccode_enum_add_value (_tmp134_, _tmp137_);
			_vala_ccode_node_unref0 (_tmp137_);
			_tmp138_ = name_prefix;
			_tmp139_ = g_strdup_printf ("%s_dup_func", _tmp138_);
			_g_free0 (func_name);
			func_name = _tmp139_;
			_tmp140_ = canonical_prefix;
			_tmp141_ = g_strdup_printf ("\"%s-dup-func\"", _tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_ccode_constant_new (_tmp142_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp143_;
			_g_free0 (_tmp142_);
			_tmp144_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp145_ = _tmp144_;
			_tmp146_ = func_name;
			_tmp147_ = g_strdup_printf ("%s_%s", _tmp145_, _tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = g_ascii_strup (_tmp148_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp149_;
			_g_free0 (_tmp148_);
			_g_free0 (_tmp145_);
			_tmp150_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp151_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp152_;
			_vala_ccode_node_unref0 (_tmp151_);
			_tmp153_ = cinst;
			_tmp154_ = ccall;
			vala_ccode_function_call_add_argument (_tmp153_, (ValaCCodeExpression*) _tmp154_);
			_tmp155_ = cinst;
			_tmp156_ = enum_value;
			_tmp157_ = vala_ccode_constant_new (_tmp156_);
			_tmp158_ = _tmp157_;
			vala_ccode_function_call_add_argument (_tmp155_, (ValaCCodeExpression*) _tmp158_);
			_vala_ccode_node_unref0 (_tmp158_);
			_tmp159_ = vala_ccode_identifier_new ("g_param_spec_pointer");
			_tmp160_ = _tmp159_;
			_tmp161_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp160_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp161_;
			_vala_ccode_node_unref0 (_tmp160_);
			_tmp162_ = cspec;
			_tmp163_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp162_, (ValaCCodeExpression*) _tmp163_);
			_tmp164_ = cspec;
			_tmp165_ = vala_ccode_constant_new ("\"dup func\"");
			_tmp166_ = _tmp165_;
			vala_ccode_function_call_add_argument (_tmp164_, (ValaCCodeExpression*) _tmp166_);
			_vala_ccode_node_unref0 (_tmp166_);
			_tmp167_ = cspec;
			_tmp168_ = vala_ccode_constant_new ("\"dup func\"");
			_tmp169_ = _tmp168_;
			vala_ccode_function_call_add_argument (_tmp167_, (ValaCCodeExpression*) _tmp169_);
			_vala_ccode_node_unref0 (_tmp169_);
			_tmp170_ = cspec;
			_tmp171_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY");
			_tmp172_ = _tmp171_;
			vala_ccode_function_call_add_argument (_tmp170_, (ValaCCodeExpression*) _tmp172_);
			_vala_ccode_node_unref0 (_tmp172_);
			_tmp173_ = cinst;
			_tmp174_ = cspec;
			vala_ccode_function_call_add_argument (_tmp173_, (ValaCCodeExpression*) _tmp174_);
			_tmp175_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp176_ = _tmp175_;
			_tmp177_ = cinst;
			vala_ccode_function_add_expression (_tmp176_, (ValaCCodeExpression*) _tmp177_);
			_tmp178_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp179_ = enum_value;
			_tmp180_ = vala_ccode_enum_value_new (_tmp179_, NULL);
			_tmp181_ = _tmp180_;
			vala_ccode_enum_add_value (_tmp178_, _tmp181_);
			_vala_ccode_node_unref0 (_tmp181_);
			_tmp182_ = name_prefix;
			_tmp183_ = g_strdup_printf ("%s_destroy_func", _tmp182_);
			_g_free0 (func_name);
			func_name = _tmp183_;
			_tmp184_ = canonical_prefix;
			_tmp185_ = g_strdup_printf ("\"%s-destroy-func\"", _tmp184_);
			_tmp186_ = _tmp185_;
			_tmp187_ = vala_ccode_constant_new (_tmp186_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp187_;
			_g_free0 (_tmp186_);
			_tmp188_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp189_ = _tmp188_;
			_tmp190_ = func_name;
			_tmp191_ = g_strdup_printf ("%s_%s", _tmp189_, _tmp190_);
			_tmp192_ = _tmp191_;
			_tmp193_ = g_ascii_strup (_tmp192_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp193_;
			_g_free0 (_tmp192_);
			_g_free0 (_tmp189_);
			_tmp194_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp195_ = _tmp194_;
			_tmp196_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp195_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp196_;
			_vala_ccode_node_unref0 (_tmp195_);
			_tmp197_ = cinst;
			_tmp198_ = ccall;
			vala_ccode_function_call_add_argument (_tmp197_, (ValaCCodeExpression*) _tmp198_);
			_tmp199_ = cinst;
			_tmp200_ = enum_value;
			_tmp201_ = vala_ccode_constant_new (_tmp200_);
			_tmp202_ = _tmp201_;
			vala_ccode_function_call_add_argument (_tmp199_, (ValaCCodeExpression*) _tmp202_);
			_vala_ccode_node_unref0 (_tmp202_);
			_tmp203_ = vala_ccode_identifier_new ("g_param_spec_pointer");
			_tmp204_ = _tmp203_;
			_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp205_;
			_vala_ccode_node_unref0 (_tmp204_);
			_tmp206_ = cspec;
			_tmp207_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp206_, (ValaCCodeExpression*) _tmp207_);
			_tmp208_ = cspec;
			_tmp209_ = vala_ccode_constant_new ("\"destroy func\"");
			_tmp210_ = _tmp209_;
			vala_ccode_function_call_add_argument (_tmp208_, (ValaCCodeExpression*) _tmp210_);
			_vala_ccode_node_unref0 (_tmp210_);
			_tmp211_ = cspec;
			_tmp212_ = vala_ccode_constant_new ("\"destroy func\"");
			_tmp213_ = _tmp212_;
			vala_ccode_function_call_add_argument (_tmp211_, (ValaCCodeExpression*) _tmp213_);
			_vala_ccode_node_unref0 (_tmp213_);
			_tmp214_ = cspec;
			_tmp215_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY");
			_tmp216_ = _tmp215_;
			vala_ccode_function_call_add_argument (_tmp214_, (ValaCCodeExpression*) _tmp216_);
			_vala_ccode_node_unref0 (_tmp216_);
			_tmp217_ = cinst;
			_tmp218_ = cspec;
			vala_ccode_function_call_add_argument (_tmp217_, (ValaCCodeExpression*) _tmp218_);
			_tmp219_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp220_ = _tmp219_;
			_tmp221_ = cinst;
			vala_ccode_function_add_expression (_tmp220_, (ValaCCodeExpression*) _tmp221_);
			_tmp222_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp223_ = enum_value;
			_tmp224_ = vala_ccode_enum_value_new (_tmp223_, NULL);
			_tmp225_ = _tmp224_;
			vala_ccode_enum_add_value (_tmp222_, _tmp225_);
			_vala_ccode_node_unref0 (_tmp225_);
			_g_free0 (canonical_prefix);
			_g_free0 (name_prefix);
			_vala_ccode_node_unref0 (cspec);
			_vala_ccode_node_unref0 (cinst);
			_vala_ccode_node_unref0 (func_name_constant);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp226_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	_tmp227_ = _vala_iterable_ref0 (_tmp226_);
	props = _tmp227_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp228_;
		ValaList* _tmp229_;
		gint _prop_size = 0;
		ValaList* _tmp230_;
		gint _tmp231_;
		gint _tmp232_;
		gint _prop_index = 0;
		_tmp228_ = props;
		_tmp229_ = _vala_iterable_ref0 (_tmp228_);
		_prop_list = _tmp229_;
		_tmp230_ = _prop_list;
		_tmp231_ = vala_collection_get_size ((ValaCollection*) _tmp230_);
		_tmp232_ = _tmp231_;
		_prop_size = _tmp232_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp233_;
			gint _tmp234_;
			ValaProperty* prop = NULL;
			ValaList* _tmp235_;
			gpointer _tmp236_;
			ValaCodeContext* _tmp237_;
			ValaCodeContext* _tmp238_;
			ValaSemanticAnalyzer* _tmp239_;
			ValaSemanticAnalyzer* _tmp240_;
			ValaProperty* _tmp241_;
			ValaProperty* _tmp259_;
			ValaComment* _tmp260_;
			ValaComment* _tmp261_;
			ValaCCodeFunctionCall* cinst = NULL;
			ValaCCodeIdentifier* _tmp271_;
			ValaCCodeIdentifier* _tmp272_;
			ValaCCodeFunctionCall* _tmp273_;
			ValaCCodeFunctionCall* _tmp274_;
			ValaCCodeFunctionCall* _tmp275_;
			ValaCCodeFunctionCall* _tmp276_;
			ValaCCodeFunctionCall* _tmp277_;
			ValaProperty* _tmp278_;
			gchar* _tmp279_;
			gchar* _tmp280_;
			gchar* _tmp281_;
			gchar* _tmp282_;
			ValaCCodeConstant* _tmp283_;
			ValaCCodeConstant* _tmp284_;
			ValaCCodeFunctionCall* _tmp285_;
			ValaProperty* _tmp286_;
			ValaCCodeExpression* _tmp287_;
			ValaCCodeExpression* _tmp288_;
			ValaCCodeFunction* _tmp289_;
			ValaCCodeFunction* _tmp290_;
			ValaCCodeFunctionCall* _tmp291_;
			_prop_index = _prop_index + 1;
			_tmp233_ = _prop_index;
			_tmp234_ = _prop_size;
			if (!(_tmp233_ < _tmp234_)) {
				break;
			}
			_tmp235_ = _prop_list;
			_tmp236_ = vala_list_get (_tmp235_, _prop_index);
			prop = (ValaProperty*) _tmp236_;
			_tmp237_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp238_ = _tmp237_;
			_tmp239_ = vala_code_context_get_analyzer (_tmp238_);
			_tmp240_ = _tmp239_;
			_tmp241_ = prop;
			if (!vala_semantic_analyzer_is_gobject_property (_tmp240_, _tmp241_)) {
				ValaCodeContext* _tmp242_;
				ValaCodeContext* _tmp243_;
				ValaSemanticAnalyzer* _tmp244_;
				ValaSemanticAnalyzer* _tmp245_;
				ValaProperty* _tmp246_;
				ValaDataType* _tmp247_;
				ValaDataType* _tmp248_;
				_tmp242_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp243_ = _tmp242_;
				_tmp244_ = vala_code_context_get_analyzer (_tmp243_);
				_tmp245_ = _tmp244_;
				_tmp246_ = prop;
				_tmp247_ = vala_property_get_property_type (_tmp246_);
				_tmp248_ = _tmp247_;
				if (!vala_semantic_analyzer_is_gobject_property_type (_tmp245_, _tmp248_)) {
					ValaProperty* _tmp249_;
					ValaSourceReference* _tmp250_;
					ValaSourceReference* _tmp251_;
					ValaProperty* _tmp252_;
					ValaDataType* _tmp253_;
					ValaDataType* _tmp254_;
					gchar* _tmp255_;
					gchar* _tmp256_;
					gchar* _tmp257_;
					gchar* _tmp258_;
					_tmp249_ = prop;
					_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp249_);
					_tmp251_ = _tmp250_;
					_tmp252_ = prop;
					_tmp253_ = vala_property_get_property_type (_tmp252_);
					_tmp254_ = _tmp253_;
					_tmp255_ = vala_data_type_to_qualified_string (_tmp254_, NULL);
					_tmp256_ = _tmp255_;
					_tmp257_ = g_strdup_printf ("Type `%s' can not be used for a GLib.Object property", _tmp256_);
					_tmp258_ = _tmp257_;
					vala_report_warning (_tmp251_, _tmp258_);
					_g_free0 (_tmp258_);
					_g_free0 (_tmp256_);
				}
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp259_ = prop;
			_tmp260_ = vala_symbol_get_comment ((ValaSymbol*) _tmp259_);
			_tmp261_ = _tmp260_;
			if (_tmp261_ != NULL) {
				ValaCCodeFunction* _tmp262_;
				ValaCCodeFunction* _tmp263_;
				ValaProperty* _tmp264_;
				ValaComment* _tmp265_;
				ValaComment* _tmp266_;
				const gchar* _tmp267_;
				const gchar* _tmp268_;
				ValaCCodeComment* _tmp269_;
				ValaCCodeComment* _tmp270_;
				_tmp262_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp263_ = _tmp262_;
				_tmp264_ = prop;
				_tmp265_ = vala_symbol_get_comment ((ValaSymbol*) _tmp264_);
				_tmp266_ = _tmp265_;
				_tmp267_ = vala_comment_get_content (_tmp266_);
				_tmp268_ = _tmp267_;
				_tmp269_ = vala_ccode_comment_new (_tmp268_);
				_tmp270_ = _tmp269_;
				vala_ccode_function_add_statement (_tmp263_, (ValaCCodeNode*) _tmp270_);
				_vala_ccode_node_unref0 (_tmp270_);
			}
			_tmp271_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp272_ = _tmp271_;
			_tmp273_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp272_);
			_tmp274_ = _tmp273_;
			_vala_ccode_node_unref0 (_tmp272_);
			cinst = _tmp274_;
			_tmp275_ = cinst;
			_tmp276_ = ccall;
			vala_ccode_function_call_add_argument (_tmp275_, (ValaCCodeExpression*) _tmp276_);
			_tmp277_ = cinst;
			_tmp278_ = prop;
			_tmp279_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp278_, NULL);
			_tmp280_ = _tmp279_;
			_tmp281_ = g_strdup_printf ("%s_PROPERTY", _tmp280_);
			_tmp282_ = _tmp281_;
			_tmp283_ = vala_ccode_constant_new (_tmp282_);
			_tmp284_ = _tmp283_;
			vala_ccode_function_call_add_argument (_tmp277_, (ValaCCodeExpression*) _tmp284_);
			_vala_ccode_node_unref0 (_tmp284_);
			_g_free0 (_tmp282_);
			_g_free0 (_tmp280_);
			_tmp285_ = cinst;
			_tmp286_ = prop;
			_tmp287_ = vala_ccode_base_module_get_param_spec ((ValaCCodeBaseModule*) self, _tmp286_);
			_tmp288_ = _tmp287_;
			vala_ccode_function_call_add_argument (_tmp285_, _tmp288_);
			_vala_ccode_node_unref0 (_tmp288_);
			_tmp289_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp290_ = _tmp289_;
			_tmp291_ = cinst;
			vala_ccode_function_add_expression (_tmp290_, (ValaCCodeExpression*) _tmp291_);
			_vala_ccode_node_unref0 (cinst);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
}

static gboolean
vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self,
                                                   ValaClass* cl)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prop_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prop_index = 0;
		_tmp0_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prop_list = _tmp1_;
		_tmp2_ = _prop_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prop_size = _tmp4_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaProperty* prop = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaProperty* _tmp9_;
			ValaPropertyAccessor* _tmp10_;
			ValaPropertyAccessor* _tmp11_;
			_prop_index = _prop_index + 1;
			_tmp5_ = _prop_index;
			_tmp6_ = _prop_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prop_list;
			_tmp8_ = vala_list_get (_tmp7_, _prop_index);
			prop = (ValaProperty*) _tmp8_;
			_tmp9_ = prop;
			_tmp10_ = vala_property_get_get_accessor (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				result = TRUE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				return result;
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	result = FALSE;
	return result;
}

static gboolean
vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self,
                                                   ValaClass* cl)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prop_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prop_index = 0;
		_tmp0_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prop_list = _tmp1_;
		_tmp2_ = _prop_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prop_size = _tmp4_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaProperty* prop = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaProperty* _tmp9_;
			ValaPropertyAccessor* _tmp10_;
			ValaPropertyAccessor* _tmp11_;
			_prop_index = _prop_index + 1;
			_tmp5_ = _prop_index;
			_tmp6_ = _prop_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prop_list;
			_tmp8_ = vala_list_get (_tmp7_, _prop_index);
			prop = (ValaProperty*) _tmp8_;
			_tmp9_ = prop;
			_tmp10_ = vala_property_get_set_accessor (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				result = TRUE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				return result;
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	result = FALSE;
	return result;
}

static void
vala_gobject_module_add_guarded_expression (ValaGObjectModule* self,
                                            ValaSymbol* sym,
                                            ValaCCodeExpression* expression)
{
	ValaVersionAttribute* _tmp0_;
	ValaVersionAttribute* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (expression != NULL);
	_tmp0_ = vala_symbol_get_version (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_version_attribute_get_deprecated (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		ValaCCodeGGnucSection* guard = NULL;
		ValaCCodeGGnucSection* _tmp4_;
		ValaCCodeFunction* _tmp5_;
		ValaCCodeFunction* _tmp6_;
		ValaCCodeGGnucSection* _tmp7_;
		ValaCCodeGGnucSection* _tmp8_;
		ValaCCodeExpressionStatement* _tmp9_;
		ValaCCodeExpressionStatement* _tmp10_;
		_tmp4_ = vala_ccode_ggnuc_section_new (VALA_GGNUC_SECTION_TYPE_IGNORE_DEPRECATIONS);
		guard = _tmp4_;
		_tmp5_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = guard;
		vala_ccode_function_add_statement (_tmp6_, (ValaCCodeNode*) _tmp7_);
		_tmp8_ = guard;
		_tmp9_ = vala_ccode_expression_statement_new (expression);
		_tmp10_ = _tmp9_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp8_, (ValaCCodeNode*) _tmp10_);
		_vala_ccode_node_unref0 (_tmp10_);
		_vala_ccode_node_unref0 (guard);
	} else {
		ValaCCodeFunction* _tmp11_;
		ValaCCodeFunction* _tmp12_;
		_tmp11_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp12_ = _tmp11_;
		vala_ccode_function_add_expression (_tmp12_, expression);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static void
vala_gobject_module_add_get_property_function (ValaGObjectModule* self,
                                               ValaClass* cl)
{
	ValaCCodeFunction* get_prop = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp36_;
	ValaList* props = NULL;
	ValaList* _tmp37_;
	ValaList* _tmp38_;
	ValaCCodeFunction* _tmp423_;
	ValaCCodeFunction* _tmp424_;
	ValaCCodeFunction* _tmp425_;
	ValaCCodeFunction* _tmp426_;
	ValaCCodeFunction* _tmp427_;
	ValaCCodeFunction* _tmp428_;
	ValaCCodeFile* _tmp429_;
	ValaCCodeFunction* _tmp430_;
	ValaCCodeFile* _tmp431_;
	ValaCCodeFunction* _tmp432_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_vala_%s_get_property", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_new (_tmp3_, "void");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	get_prop = _tmp5_;
	_tmp6_ = get_prop;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp6_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp7_ = get_prop;
	_tmp8_ = vala_ccode_parameter_new ("object", "GObject *");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (_tmp7_, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = get_prop;
	_tmp11_ = vala_ccode_parameter_new ("property_id", "guint");
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp10_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = get_prop;
	_tmp14_ = vala_ccode_parameter_new ("value", "GValue *");
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp13_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = get_prop;
	_tmp17_ = vala_ccode_parameter_new ("pspec", "GParamSpec *");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = get_prop;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("object");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp21_, (ValaTypeSymbol*) cl);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	ccall = _tmp23_;
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_get_ccode_name ((ValaCodeNode*) cl);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("%s *", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	_tmp31_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_declaration (_tmp25_, _tmp29_, (ValaCCodeDeclarator*) _tmp32_, 0);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_ccode_identifier_new ("property_id");
	_tmp36_ = _tmp35_;
	vala_ccode_function_open_switch (_tmp34_, (ValaCCodeExpression*) _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	_tmp37_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	_tmp38_ = _vala_iterable_ref0 (_tmp37_);
	props = _tmp38_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp39_;
		ValaList* _tmp40_;
		gint _prop_size = 0;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _prop_index = 0;
		_tmp39_ = props;
		_tmp40_ = _vala_iterable_ref0 (_tmp39_);
		_prop_list = _tmp40_;
		_tmp41_ = _prop_list;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_prop_size = _tmp43_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			ValaProperty* prop = NULL;
			ValaList* _tmp46_;
			gpointer _tmp47_;
			gboolean _tmp48_ = FALSE;
			ValaProperty* _tmp49_;
			ValaPropertyAccessor* _tmp50_;
			ValaPropertyAccessor* _tmp51_;
			ValaCodeContext* _tmp55_;
			ValaCodeContext* _tmp56_;
			ValaSemanticAnalyzer* _tmp57_;
			ValaSemanticAnalyzer* _tmp58_;
			ValaProperty* _tmp59_;
			ValaProperty* base_prop = NULL;
			ValaProperty* _tmp60_;
			ValaProperty* _tmp61_;
			ValaCCodeExpression* cself = NULL;
			ValaCCodeIdentifier* _tmp62_;
			ValaProperty* _tmp63_;
			ValaProperty* _tmp64_;
			ValaProperty* _tmp65_;
			ValaCCodeExpression* cfunc = NULL;
			gboolean _tmp127_ = FALSE;
			ValaProperty* _tmp128_;
			ValaCCodeFunction* _tmp142_;
			ValaCCodeFunction* _tmp143_;
			ValaProperty* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			ValaCCodeIdentifier* _tmp149_;
			ValaCCodeIdentifier* _tmp150_;
			ValaProperty* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			ValaCCodeFunction* _tmp304_;
			ValaCCodeFunction* _tmp305_;
			_prop_index = _prop_index + 1;
			_tmp44_ = _prop_index;
			_tmp45_ = _prop_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _prop_list;
			_tmp47_ = vala_list_get (_tmp46_, _prop_index);
			prop = (ValaProperty*) _tmp47_;
			_tmp49_ = prop;
			_tmp50_ = vala_property_get_get_accessor (_tmp49_);
			_tmp51_ = _tmp50_;
			if (_tmp51_ == NULL) {
				_tmp48_ = TRUE;
			} else {
				ValaProperty* _tmp52_;
				gboolean _tmp53_;
				gboolean _tmp54_;
				_tmp52_ = prop;
				_tmp53_ = vala_property_get_is_abstract (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp48_ = _tmp54_;
			}
			if (_tmp48_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp55_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_code_context_get_analyzer (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = prop;
			if (!vala_semantic_analyzer_is_gobject_property (_tmp58_, _tmp59_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp60_ = prop;
			_tmp61_ = _vala_code_node_ref0 (_tmp60_);
			base_prop = _tmp61_;
			_tmp62_ = vala_ccode_identifier_new ("self");
			cself = (ValaCCodeExpression*) _tmp62_;
			_tmp63_ = prop;
			_tmp64_ = vala_property_get_base_property (_tmp63_);
			_tmp65_ = _tmp64_;
			if (_tmp65_ != NULL) {
				ValaClass* base_type = NULL;
				ValaProperty* _tmp66_;
				ValaProperty* _tmp67_;
				ValaProperty* _tmp68_;
				ValaSymbol* _tmp69_;
				ValaSymbol* _tmp70_;
				ValaClass* _tmp71_;
				ValaProperty* _tmp72_;
				ValaProperty* _tmp73_;
				ValaProperty* _tmp74_;
				ValaProperty* _tmp75_;
				ValaObjectType* _tmp76_;
				ValaObjectType* _tmp77_;
				ValaCCodeExpression* _tmp78_;
				ValaGLibValue* _tmp79_;
				ValaGLibValue* _tmp80_;
				ValaClass* _tmp81_;
				ValaObjectType* _tmp82_;
				ValaObjectType* _tmp83_;
				ValaProperty* _tmp84_;
				ValaTargetValue* _tmp85_;
				ValaTargetValue* _tmp86_;
				ValaCCodeExpression* _tmp87_;
				ValaCCodeExpression* _tmp88_;
				ValaProperty* _tmp89_;
				ValaProperty* _tmp90_;
				ValaProperty* _tmp91_;
				ValaPropertyAccessor* _tmp92_;
				ValaPropertyAccessor* _tmp93_;
				ValaCCodeFile* _tmp94_;
				_tmp66_ = prop;
				_tmp67_ = vala_property_get_base_property (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_CLASS, ValaClass));
				base_type = _tmp71_;
				_tmp72_ = prop;
				_tmp73_ = vala_property_get_base_property (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = _vala_code_node_ref0 (_tmp74_);
				_vala_code_node_unref0 (base_prop);
				base_prop = _tmp75_;
				_tmp76_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
				_tmp77_ = _tmp76_;
				_tmp78_ = cself;
				_tmp79_ = vala_glib_value_new ((ValaDataType*) _tmp77_, _tmp78_, TRUE);
				_tmp80_ = _tmp79_;
				_tmp81_ = base_type;
				_tmp82_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp81_);
				_tmp83_ = _tmp82_;
				_tmp84_ = prop;
				_tmp85_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp80_, (ValaDataType*) _tmp83_, (ValaCodeNode*) _tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = vala_get_cvalue_ (_tmp86_);
				_tmp88_ = _vala_ccode_node_ref0 (_tmp87_);
				_vala_ccode_node_unref0 (cself);
				cself = _tmp88_;
				_vala_target_value_unref0 (_tmp86_);
				_vala_code_node_unref0 (_tmp83_);
				_vala_target_value_unref0 (_tmp80_);
				_vala_code_node_unref0 (_tmp77_);
				_tmp89_ = prop;
				_tmp90_ = vala_property_get_base_property (_tmp89_);
				_tmp91_ = _tmp90_;
				_tmp92_ = vala_property_get_get_accessor (_tmp91_);
				_tmp93_ = _tmp92_;
				_tmp94_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp93_, _tmp94_);
				_vala_code_node_unref0 (base_type);
			} else {
				ValaProperty* _tmp95_;
				ValaProperty* _tmp96_;
				ValaProperty* _tmp97_;
				_tmp95_ = prop;
				_tmp96_ = vala_property_get_base_interface_property (_tmp95_);
				_tmp97_ = _tmp96_;
				if (_tmp97_ != NULL) {
					ValaInterface* base_type = NULL;
					ValaProperty* _tmp98_;
					ValaProperty* _tmp99_;
					ValaProperty* _tmp100_;
					ValaSymbol* _tmp101_;
					ValaSymbol* _tmp102_;
					ValaInterface* _tmp103_;
					ValaProperty* _tmp104_;
					ValaProperty* _tmp105_;
					ValaProperty* _tmp106_;
					ValaProperty* _tmp107_;
					ValaObjectType* _tmp108_;
					ValaObjectType* _tmp109_;
					ValaCCodeExpression* _tmp110_;
					ValaGLibValue* _tmp111_;
					ValaGLibValue* _tmp112_;
					ValaInterface* _tmp113_;
					ValaObjectType* _tmp114_;
					ValaObjectType* _tmp115_;
					ValaProperty* _tmp116_;
					ValaTargetValue* _tmp117_;
					ValaTargetValue* _tmp118_;
					ValaCCodeExpression* _tmp119_;
					ValaCCodeExpression* _tmp120_;
					ValaProperty* _tmp121_;
					ValaProperty* _tmp122_;
					ValaProperty* _tmp123_;
					ValaPropertyAccessor* _tmp124_;
					ValaPropertyAccessor* _tmp125_;
					ValaCCodeFile* _tmp126_;
					_tmp98_ = prop;
					_tmp99_ = vala_property_get_base_interface_property (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_INTERFACE, ValaInterface));
					base_type = _tmp103_;
					_tmp104_ = prop;
					_tmp105_ = vala_property_get_base_interface_property (_tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = _vala_code_node_ref0 (_tmp106_);
					_vala_code_node_unref0 (base_prop);
					base_prop = _tmp107_;
					_tmp108_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp109_ = _tmp108_;
					_tmp110_ = cself;
					_tmp111_ = vala_glib_value_new ((ValaDataType*) _tmp109_, _tmp110_, TRUE);
					_tmp112_ = _tmp111_;
					_tmp113_ = base_type;
					_tmp114_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = prop;
					_tmp117_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp112_, (ValaDataType*) _tmp115_, (ValaCodeNode*) _tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = vala_get_cvalue_ (_tmp118_);
					_tmp120_ = _vala_ccode_node_ref0 (_tmp119_);
					_vala_ccode_node_unref0 (cself);
					cself = _tmp120_;
					_vala_target_value_unref0 (_tmp118_);
					_vala_code_node_unref0 (_tmp115_);
					_vala_target_value_unref0 (_tmp112_);
					_vala_code_node_unref0 (_tmp109_);
					_tmp121_ = prop;
					_tmp122_ = vala_property_get_base_interface_property (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_property_get_get_accessor (_tmp123_);
					_tmp125_ = _tmp124_;
					_tmp126_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp125_, _tmp126_);
					_vala_code_node_unref0 (base_type);
				}
			}
			_tmp128_ = base_prop;
			if (!vala_get_ccode_no_accessor_method (_tmp128_)) {
				ValaProperty* _tmp129_;
				_tmp129_ = base_prop;
				_tmp127_ = !vala_get_ccode_concrete_accessor (_tmp129_);
			} else {
				_tmp127_ = FALSE;
			}
			if (_tmp127_) {
				ValaProperty* _tmp130_;
				ValaPropertyAccessor* _tmp131_;
				ValaPropertyAccessor* _tmp132_;
				gchar* _tmp133_;
				gchar* _tmp134_;
				ValaCCodeIdentifier* _tmp135_;
				_tmp130_ = base_prop;
				_tmp131_ = vala_property_get_get_accessor (_tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = vala_get_ccode_name ((ValaCodeNode*) _tmp132_);
				_tmp134_ = _tmp133_;
				_tmp135_ = vala_ccode_identifier_new (_tmp134_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp135_;
				_g_free0 (_tmp134_);
			} else {
				ValaProperty* _tmp136_;
				ValaPropertyAccessor* _tmp137_;
				ValaPropertyAccessor* _tmp138_;
				gchar* _tmp139_;
				gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				_tmp136_ = prop;
				_tmp137_ = vala_property_get_get_accessor (_tmp136_);
				_tmp138_ = _tmp137_;
				_tmp139_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp141_;
				_g_free0 (_tmp140_);
			}
			_tmp142_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp143_ = _tmp142_;
			_tmp144_ = prop;
			_tmp145_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp144_, NULL);
			_tmp146_ = _tmp145_;
			_tmp147_ = g_strdup_printf ("%s_PROPERTY", _tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_ccode_identifier_new (_tmp148_);
			_tmp150_ = _tmp149_;
			vala_ccode_function_add_case (_tmp143_, (ValaCCodeExpression*) _tmp150_);
			_vala_ccode_node_unref0 (_tmp150_);
			_g_free0 (_tmp148_);
			_g_free0 (_tmp146_);
			_tmp151_ = prop;
			_tmp152_ = vala_property_get_property_type (_tmp151_);
			_tmp153_ = _tmp152_;
			if (vala_data_type_is_real_struct_type (_tmp153_)) {
				ValaCCodeFunction* _tmp154_;
				ValaCCodeFunction* _tmp155_;
				ValaCCodeFunction* _tmp156_;
				ValaCCodeFunction* _tmp157_;
				ValaProperty* _tmp158_;
				ValaDataType* _tmp159_;
				ValaDataType* _tmp160_;
				gchar* _tmp161_;
				gchar* _tmp162_;
				ValaCCodeVariableDeclarator* _tmp163_;
				ValaCCodeVariableDeclarator* _tmp164_;
				ValaCCodeExpression* _tmp165_;
				ValaCCodeFunctionCall* _tmp166_;
				ValaCCodeFunctionCall* _tmp167_;
				ValaCCodeExpression* _tmp168_;
				ValaProperty* _tmp169_;
				ValaDataType* _tmp170_;
				ValaDataType* _tmp171_;
				gboolean _tmp172_;
				gboolean _tmp173_;
				ValaCCodeFunctionCall* csetcall = NULL;
				ValaCCodeFunctionCall* _tmp187_;
				ValaCCodeFunctionCall* _tmp188_;
				ValaProperty* _tmp189_;
				ValaDataType* _tmp190_;
				ValaDataType* _tmp191_;
				ValaCCodeExpression* _tmp192_;
				ValaCCodeExpression* _tmp193_;
				ValaCCodeFunctionCall* _tmp194_;
				ValaCCodeIdentifier* _tmp195_;
				ValaCCodeIdentifier* _tmp196_;
				ValaProperty* _tmp197_;
				ValaDataType* _tmp198_;
				ValaDataType* _tmp199_;
				gboolean _tmp200_;
				gboolean _tmp201_;
				ValaProperty* _tmp210_;
				ValaCCodeFunctionCall* _tmp211_;
				ValaProperty* _tmp212_;
				ValaPropertyAccessor* _tmp213_;
				ValaPropertyAccessor* _tmp214_;
				ValaDataType* _tmp215_;
				ValaDataType* _tmp216_;
				ValaCCodeFunction* _tmp230_;
				ValaCCodeFunction* _tmp231_;
				_tmp154_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp155_ = _tmp154_;
				vala_ccode_function_open_block (_tmp155_);
				_tmp156_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp157_ = _tmp156_;
				_tmp158_ = prop;
				_tmp159_ = vala_property_get_property_type (_tmp158_);
				_tmp160_ = _tmp159_;
				_tmp161_ = vala_get_ccode_name ((ValaCodeNode*) _tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = vala_ccode_variable_declarator_new ("boxed", NULL, NULL);
				_tmp164_ = _tmp163_;
				vala_ccode_function_add_declaration (_tmp157_, _tmp162_, (ValaCCodeDeclarator*) _tmp164_, 0);
				_vala_ccode_node_unref0 (_tmp164_);
				_g_free0 (_tmp162_);
				_tmp165_ = cfunc;
				_tmp166_ = vala_ccode_function_call_new (_tmp165_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp166_;
				_tmp167_ = ccall;
				_tmp168_ = cself;
				vala_ccode_function_call_add_argument (_tmp167_, _tmp168_);
				_tmp169_ = prop;
				_tmp170_ = vala_property_get_property_type (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_data_type_get_nullable (_tmp171_);
				_tmp173_ = _tmp172_;
				if (_tmp173_) {
					ValaCCodeFunction* _tmp174_;
					ValaCCodeFunction* _tmp175_;
					ValaCCodeIdentifier* _tmp176_;
					ValaCCodeIdentifier* _tmp177_;
					ValaCCodeFunctionCall* _tmp178_;
					_tmp174_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp175_ = _tmp174_;
					_tmp176_ = vala_ccode_identifier_new ("boxed");
					_tmp177_ = _tmp176_;
					_tmp178_ = ccall;
					vala_ccode_function_add_assignment (_tmp175_, (ValaCCodeExpression*) _tmp177_, (ValaCCodeExpression*) _tmp178_);
					_vala_ccode_node_unref0 (_tmp177_);
				} else {
					ValaCCodeFunctionCall* _tmp179_;
					ValaCCodeIdentifier* _tmp180_;
					ValaCCodeIdentifier* _tmp181_;
					ValaCCodeUnaryExpression* _tmp182_;
					ValaCCodeUnaryExpression* _tmp183_;
					ValaCCodeFunction* _tmp184_;
					ValaCCodeFunction* _tmp185_;
					ValaCCodeFunctionCall* _tmp186_;
					_tmp179_ = ccall;
					_tmp180_ = vala_ccode_identifier_new ("boxed");
					_tmp181_ = _tmp180_;
					_tmp182_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp181_);
					_tmp183_ = _tmp182_;
					vala_ccode_function_call_add_argument (_tmp179_, (ValaCCodeExpression*) _tmp183_);
					_vala_ccode_node_unref0 (_tmp183_);
					_vala_ccode_node_unref0 (_tmp181_);
					_tmp184_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp185_ = _tmp184_;
					_tmp186_ = ccall;
					vala_ccode_function_add_expression (_tmp185_, (ValaCCodeExpression*) _tmp186_);
				}
				_tmp187_ = vala_ccode_function_call_new (NULL);
				csetcall = _tmp187_;
				_tmp188_ = csetcall;
				_tmp189_ = prop;
				_tmp190_ = vala_property_get_property_type (_tmp189_);
				_tmp191_ = _tmp190_;
				_tmp192_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, _tmp191_);
				_tmp193_ = _tmp192_;
				vala_ccode_function_call_set_call (_tmp188_, _tmp193_);
				_vala_ccode_node_unref0 (_tmp193_);
				_tmp194_ = csetcall;
				_tmp195_ = vala_ccode_identifier_new ("value");
				_tmp196_ = _tmp195_;
				vala_ccode_function_call_add_argument (_tmp194_, (ValaCCodeExpression*) _tmp196_);
				_vala_ccode_node_unref0 (_tmp196_);
				_tmp197_ = prop;
				_tmp198_ = vala_property_get_property_type (_tmp197_);
				_tmp199_ = _tmp198_;
				_tmp200_ = vala_data_type_get_nullable (_tmp199_);
				_tmp201_ = _tmp200_;
				if (_tmp201_) {
					ValaCCodeFunctionCall* _tmp202_;
					ValaCCodeIdentifier* _tmp203_;
					ValaCCodeIdentifier* _tmp204_;
					_tmp202_ = csetcall;
					_tmp203_ = vala_ccode_identifier_new ("boxed");
					_tmp204_ = _tmp203_;
					vala_ccode_function_call_add_argument (_tmp202_, (ValaCCodeExpression*) _tmp204_);
					_vala_ccode_node_unref0 (_tmp204_);
				} else {
					ValaCCodeFunctionCall* _tmp205_;
					ValaCCodeIdentifier* _tmp206_;
					ValaCCodeIdentifier* _tmp207_;
					ValaCCodeUnaryExpression* _tmp208_;
					ValaCCodeUnaryExpression* _tmp209_;
					_tmp205_ = csetcall;
					_tmp206_ = vala_ccode_identifier_new ("boxed");
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp207_);
					_tmp209_ = _tmp208_;
					vala_ccode_function_call_add_argument (_tmp205_, (ValaCCodeExpression*) _tmp209_);
					_vala_ccode_node_unref0 (_tmp209_);
					_vala_ccode_node_unref0 (_tmp207_);
				}
				_tmp210_ = prop;
				_tmp211_ = csetcall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp210_, (ValaCCodeExpression*) _tmp211_);
				_tmp212_ = prop;
				_tmp213_ = vala_property_get_get_accessor (_tmp212_);
				_tmp214_ = _tmp213_;
				_tmp215_ = vala_property_accessor_get_value_type (_tmp214_);
				_tmp216_ = _tmp215_;
				if (vala_ccode_base_module_requires_destroy (_tmp216_)) {
					ValaCCodeFunction* _tmp217_;
					ValaCCodeFunction* _tmp218_;
					ValaProperty* _tmp219_;
					ValaPropertyAccessor* _tmp220_;
					ValaPropertyAccessor* _tmp221_;
					ValaDataType* _tmp222_;
					ValaDataType* _tmp223_;
					ValaCCodeIdentifier* _tmp224_;
					ValaCCodeIdentifier* _tmp225_;
					ValaGLibValue* _tmp226_;
					ValaGLibValue* _tmp227_;
					ValaCCodeExpression* _tmp228_;
					ValaCCodeExpression* _tmp229_;
					_tmp217_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp218_ = _tmp217_;
					_tmp219_ = prop;
					_tmp220_ = vala_property_get_get_accessor (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_property_accessor_get_value_type (_tmp221_);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_ccode_identifier_new ("boxed");
					_tmp225_ = _tmp224_;
					_tmp226_ = vala_glib_value_new (_tmp223_, (ValaCCodeExpression*) _tmp225_, TRUE);
					_tmp227_ = _tmp226_;
					_tmp228_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp227_, FALSE);
					_tmp229_ = _tmp228_;
					vala_ccode_function_add_expression (_tmp218_, _tmp229_);
					_vala_ccode_node_unref0 (_tmp229_);
					_vala_target_value_unref0 (_tmp227_);
					_vala_ccode_node_unref0 (_tmp225_);
				}
				_tmp230_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp231_ = _tmp230_;
				vala_ccode_function_close (_tmp231_);
				_vala_ccode_node_unref0 (csetcall);
			} else {
				ValaCCodeExpression* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeFunctionCall* _tmp234_;
				ValaCCodeExpression* _tmp235_;
				ValaArrayType* array_type = NULL;
				ValaProperty* _tmp236_;
				ValaDataType* _tmp237_;
				ValaDataType* _tmp238_;
				ValaArrayType* _tmp239_;
				gboolean _tmp240_ = FALSE;
				gboolean _tmp241_ = FALSE;
				ValaArrayType* _tmp242_;
				ValaCCodeFunctionCall* csetcall = NULL;
				ValaCCodeFunctionCall* _tmp263_;
				ValaProperty* _tmp264_;
				ValaPropertyAccessor* _tmp265_;
				ValaPropertyAccessor* _tmp266_;
				ValaDataType* _tmp267_;
				ValaDataType* _tmp268_;
				gboolean _tmp269_;
				gboolean _tmp270_;
				ValaCCodeFunctionCall* _tmp283_;
				ValaCCodeIdentifier* _tmp284_;
				ValaCCodeIdentifier* _tmp285_;
				ValaCCodeFunctionCall* _tmp286_;
				ValaCCodeFunctionCall* _tmp287_;
				ValaProperty* _tmp288_;
				ValaCCodeFunctionCall* _tmp289_;
				gboolean _tmp290_ = FALSE;
				gboolean _tmp291_ = FALSE;
				ValaArrayType* _tmp292_;
				_tmp232_ = cfunc;
				_tmp233_ = vala_ccode_function_call_new (_tmp232_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp233_;
				_tmp234_ = ccall;
				_tmp235_ = cself;
				vala_ccode_function_call_add_argument (_tmp234_, _tmp235_);
				_tmp236_ = prop;
				_tmp237_ = vala_property_get_property_type (_tmp236_);
				_tmp238_ = _tmp237_;
				_tmp239_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp238_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp238_) : NULL);
				array_type = _tmp239_;
				_tmp242_ = array_type;
				if (_tmp242_ != NULL) {
					ValaProperty* _tmp243_;
					_tmp243_ = prop;
					_tmp241_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp243_);
				} else {
					_tmp241_ = FALSE;
				}
				if (_tmp241_) {
					ValaArrayType* _tmp244_;
					ValaDataType* _tmp245_;
					ValaDataType* _tmp246_;
					ValaTypeSymbol* _tmp247_;
					ValaTypeSymbol* _tmp248_;
					ValaDataType* _tmp249_;
					ValaTypeSymbol* _tmp250_;
					ValaTypeSymbol* _tmp251_;
					_tmp244_ = array_type;
					_tmp245_ = vala_array_type_get_element_type (_tmp244_);
					_tmp246_ = _tmp245_;
					_tmp247_ = vala_data_type_get_type_symbol (_tmp246_);
					_tmp248_ = _tmp247_;
					_tmp249_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp250_ = vala_data_type_get_type_symbol (_tmp249_);
					_tmp251_ = _tmp250_;
					_tmp240_ = _tmp248_ == _tmp251_;
				} else {
					_tmp240_ = FALSE;
				}
				if (_tmp240_) {
					ValaCCodeFunction* _tmp252_;
					ValaCCodeFunction* _tmp253_;
					ValaCCodeFunction* _tmp254_;
					ValaCCodeFunction* _tmp255_;
					ValaCCodeVariableDeclarator* _tmp256_;
					ValaCCodeVariableDeclarator* _tmp257_;
					ValaCCodeFunctionCall* _tmp258_;
					ValaCCodeIdentifier* _tmp259_;
					ValaCCodeIdentifier* _tmp260_;
					ValaCCodeUnaryExpression* _tmp261_;
					ValaCCodeUnaryExpression* _tmp262_;
					_tmp252_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp253_ = _tmp252_;
					vala_ccode_function_open_block (_tmp253_);
					_tmp254_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp255_ = _tmp254_;
					_tmp256_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
					_tmp257_ = _tmp256_;
					vala_ccode_function_add_declaration (_tmp255_, "int", (ValaCCodeDeclarator*) _tmp257_, 0);
					_vala_ccode_node_unref0 (_tmp257_);
					_tmp258_ = ccall;
					_tmp259_ = vala_ccode_identifier_new ("length");
					_tmp260_ = _tmp259_;
					_tmp261_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp260_);
					_tmp262_ = _tmp261_;
					vala_ccode_function_call_add_argument (_tmp258_, (ValaCCodeExpression*) _tmp262_);
					_vala_ccode_node_unref0 (_tmp262_);
					_vala_ccode_node_unref0 (_tmp260_);
				}
				_tmp263_ = vala_ccode_function_call_new (NULL);
				csetcall = _tmp263_;
				_tmp264_ = prop;
				_tmp265_ = vala_property_get_get_accessor (_tmp264_);
				_tmp266_ = _tmp265_;
				_tmp267_ = vala_property_accessor_get_value_type (_tmp266_);
				_tmp268_ = _tmp267_;
				_tmp269_ = vala_data_type_get_value_owned (_tmp268_);
				_tmp270_ = _tmp269_;
				if (_tmp270_) {
					ValaCCodeFunctionCall* _tmp271_;
					ValaProperty* _tmp272_;
					ValaDataType* _tmp273_;
					ValaDataType* _tmp274_;
					ValaCCodeExpression* _tmp275_;
					ValaCCodeExpression* _tmp276_;
					_tmp271_ = csetcall;
					_tmp272_ = prop;
					_tmp273_ = vala_property_get_property_type (_tmp272_);
					_tmp274_ = _tmp273_;
					_tmp275_ = vala_ccode_base_module_get_value_taker_function ((ValaCCodeBaseModule*) self, _tmp274_);
					_tmp276_ = _tmp275_;
					vala_ccode_function_call_set_call (_tmp271_, _tmp276_);
					_vala_ccode_node_unref0 (_tmp276_);
				} else {
					ValaCCodeFunctionCall* _tmp277_;
					ValaProperty* _tmp278_;
					ValaDataType* _tmp279_;
					ValaDataType* _tmp280_;
					ValaCCodeExpression* _tmp281_;
					ValaCCodeExpression* _tmp282_;
					_tmp277_ = csetcall;
					_tmp278_ = prop;
					_tmp279_ = vala_property_get_property_type (_tmp278_);
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, _tmp280_);
					_tmp282_ = _tmp281_;
					vala_ccode_function_call_set_call (_tmp277_, _tmp282_);
					_vala_ccode_node_unref0 (_tmp282_);
				}
				_tmp283_ = csetcall;
				_tmp284_ = vala_ccode_identifier_new ("value");
				_tmp285_ = _tmp284_;
				vala_ccode_function_call_add_argument (_tmp283_, (ValaCCodeExpression*) _tmp285_);
				_vala_ccode_node_unref0 (_tmp285_);
				_tmp286_ = csetcall;
				_tmp287_ = ccall;
				vala_ccode_function_call_add_argument (_tmp286_, (ValaCCodeExpression*) _tmp287_);
				_tmp288_ = prop;
				_tmp289_ = csetcall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp288_, (ValaCCodeExpression*) _tmp289_);
				_tmp292_ = array_type;
				if (_tmp292_ != NULL) {
					ValaProperty* _tmp293_;
					_tmp293_ = prop;
					_tmp291_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp293_);
				} else {
					_tmp291_ = FALSE;
				}
				if (_tmp291_) {
					ValaArrayType* _tmp294_;
					ValaDataType* _tmp295_;
					ValaDataType* _tmp296_;
					ValaTypeSymbol* _tmp297_;
					ValaTypeSymbol* _tmp298_;
					ValaDataType* _tmp299_;
					ValaTypeSymbol* _tmp300_;
					ValaTypeSymbol* _tmp301_;
					_tmp294_ = array_type;
					_tmp295_ = vala_array_type_get_element_type (_tmp294_);
					_tmp296_ = _tmp295_;
					_tmp297_ = vala_data_type_get_type_symbol (_tmp296_);
					_tmp298_ = _tmp297_;
					_tmp299_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp300_ = vala_data_type_get_type_symbol (_tmp299_);
					_tmp301_ = _tmp300_;
					_tmp290_ = _tmp298_ == _tmp301_;
				} else {
					_tmp290_ = FALSE;
				}
				if (_tmp290_) {
					ValaCCodeFunction* _tmp302_;
					ValaCCodeFunction* _tmp303_;
					_tmp302_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp303_ = _tmp302_;
					vala_ccode_function_close (_tmp303_);
				}
				_vala_ccode_node_unref0 (csetcall);
				_vala_code_node_unref0 (array_type);
			}
			_tmp304_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp305_ = _tmp304_;
			vala_ccode_function_add_break (_tmp305_);
			_vala_ccode_node_unref0 (cfunc);
			_vala_ccode_node_unref0 (cself);
			_vala_code_node_unref0 (base_prop);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp306_;
		ValaList* _tmp307_;
		gint _type_param_size = 0;
		ValaList* _tmp308_;
		gint _tmp309_;
		gint _tmp310_;
		gint _type_param_index = 0;
		_tmp306_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_tmp307_ = _vala_iterable_ref0 (_tmp306_);
		_type_param_list = _tmp307_;
		_tmp308_ = _type_param_list;
		_tmp309_ = vala_collection_get_size ((ValaCollection*) _tmp308_);
		_tmp310_ = _tmp309_;
		_type_param_size = _tmp310_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp311_;
			gint _tmp312_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp313_;
			gpointer _tmp314_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeMemberAccess* cfield = NULL;
			ValaCCodeFunctionCall* csetcall = NULL;
			ValaTypeParameter* _tmp315_;
			const gchar* _tmp316_;
			const gchar* _tmp317_;
			gchar* _tmp318_;
			gchar* _tmp319_;
			gchar* _tmp320_;
			gchar* _tmp321_;
			gchar* _tmp322_;
			const gchar* _tmp323_;
			gchar* _tmp324_;
			gchar* _tmp325_;
			gchar* _tmp326_;
			ValaCCodeFunction* _tmp327_;
			ValaCCodeFunction* _tmp328_;
			const gchar* _tmp329_;
			ValaCCodeIdentifier* _tmp330_;
			ValaCCodeIdentifier* _tmp331_;
			ValaCCodeIdentifier* _tmp332_;
			ValaCCodeIdentifier* _tmp333_;
			ValaCCodeMemberAccess* _tmp334_;
			ValaCCodeMemberAccess* _tmp335_;
			const gchar* _tmp336_;
			ValaCCodeMemberAccess* _tmp337_;
			ValaCCodeIdentifier* _tmp338_;
			ValaCCodeIdentifier* _tmp339_;
			ValaCCodeFunctionCall* _tmp340_;
			ValaCCodeFunctionCall* _tmp341_;
			ValaCCodeIdentifier* _tmp342_;
			ValaCCodeIdentifier* _tmp343_;
			ValaCCodeFunctionCall* _tmp344_;
			ValaCCodeMemberAccess* _tmp345_;
			ValaCCodeFunction* _tmp346_;
			ValaCCodeFunction* _tmp347_;
			ValaCCodeFunctionCall* _tmp348_;
			ValaCCodeFunction* _tmp349_;
			ValaCCodeFunction* _tmp350_;
			ValaTypeParameter* _tmp351_;
			const gchar* _tmp352_;
			const gchar* _tmp353_;
			gchar* _tmp354_;
			gchar* _tmp355_;
			gchar* _tmp356_;
			gchar* _tmp357_;
			gchar* _tmp358_;
			const gchar* _tmp359_;
			gchar* _tmp360_;
			gchar* _tmp361_;
			gchar* _tmp362_;
			ValaCCodeFunction* _tmp363_;
			ValaCCodeFunction* _tmp364_;
			const gchar* _tmp365_;
			ValaCCodeIdentifier* _tmp366_;
			ValaCCodeIdentifier* _tmp367_;
			ValaCCodeIdentifier* _tmp368_;
			ValaCCodeIdentifier* _tmp369_;
			ValaCCodeMemberAccess* _tmp370_;
			ValaCCodeMemberAccess* _tmp371_;
			const gchar* _tmp372_;
			ValaCCodeMemberAccess* _tmp373_;
			ValaCCodeIdentifier* _tmp374_;
			ValaCCodeIdentifier* _tmp375_;
			ValaCCodeFunctionCall* _tmp376_;
			ValaCCodeFunctionCall* _tmp377_;
			ValaCCodeIdentifier* _tmp378_;
			ValaCCodeIdentifier* _tmp379_;
			ValaCCodeFunctionCall* _tmp380_;
			ValaCCodeMemberAccess* _tmp381_;
			ValaCCodeFunction* _tmp382_;
			ValaCCodeFunction* _tmp383_;
			ValaCCodeFunctionCall* _tmp384_;
			ValaCCodeFunction* _tmp385_;
			ValaCCodeFunction* _tmp386_;
			ValaTypeParameter* _tmp387_;
			const gchar* _tmp388_;
			const gchar* _tmp389_;
			gchar* _tmp390_;
			gchar* _tmp391_;
			gchar* _tmp392_;
			gchar* _tmp393_;
			gchar* _tmp394_;
			const gchar* _tmp395_;
			gchar* _tmp396_;
			gchar* _tmp397_;
			gchar* _tmp398_;
			ValaCCodeFunction* _tmp399_;
			ValaCCodeFunction* _tmp400_;
			const gchar* _tmp401_;
			ValaCCodeIdentifier* _tmp402_;
			ValaCCodeIdentifier* _tmp403_;
			ValaCCodeIdentifier* _tmp404_;
			ValaCCodeIdentifier* _tmp405_;
			ValaCCodeMemberAccess* _tmp406_;
			ValaCCodeMemberAccess* _tmp407_;
			const gchar* _tmp408_;
			ValaCCodeMemberAccess* _tmp409_;
			ValaCCodeIdentifier* _tmp410_;
			ValaCCodeIdentifier* _tmp411_;
			ValaCCodeFunctionCall* _tmp412_;
			ValaCCodeFunctionCall* _tmp413_;
			ValaCCodeIdentifier* _tmp414_;
			ValaCCodeIdentifier* _tmp415_;
			ValaCCodeFunctionCall* _tmp416_;
			ValaCCodeMemberAccess* _tmp417_;
			ValaCCodeFunction* _tmp418_;
			ValaCCodeFunction* _tmp419_;
			ValaCCodeFunctionCall* _tmp420_;
			ValaCCodeFunction* _tmp421_;
			ValaCCodeFunction* _tmp422_;
			_type_param_index = _type_param_index + 1;
			_tmp311_ = _type_param_index;
			_tmp312_ = _type_param_size;
			if (!(_tmp311_ < _tmp312_)) {
				break;
			}
			_tmp313_ = _type_param_list;
			_tmp314_ = vala_list_get (_tmp313_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp314_;
			_tmp315_ = type_param;
			_tmp316_ = vala_symbol_get_name ((ValaSymbol*) _tmp315_);
			_tmp317_ = _tmp316_;
			_tmp318_ = g_ascii_strdown (_tmp317_, (gssize) -1);
			_tmp319_ = _tmp318_;
			_tmp320_ = g_strdup_printf ("%s_type", _tmp319_);
			_g_free0 (func_name);
			func_name = _tmp320_;
			_g_free0 (_tmp319_);
			_tmp321_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp322_ = _tmp321_;
			_tmp323_ = func_name;
			_tmp324_ = g_strdup_printf ("%s_%s", _tmp322_, _tmp323_);
			_tmp325_ = _tmp324_;
			_tmp326_ = g_ascii_strup (_tmp325_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp326_;
			_g_free0 (_tmp325_);
			_g_free0 (_tmp322_);
			_tmp327_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp328_ = _tmp327_;
			_tmp329_ = enum_value;
			_tmp330_ = vala_ccode_identifier_new (_tmp329_);
			_tmp331_ = _tmp330_;
			vala_ccode_function_add_case (_tmp328_, (ValaCCodeExpression*) _tmp331_);
			_vala_ccode_node_unref0 (_tmp331_);
			_tmp332_ = vala_ccode_identifier_new ("self");
			_tmp333_ = _tmp332_;
			_tmp334_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp333_, "priv");
			_tmp335_ = _tmp334_;
			_tmp336_ = func_name;
			_tmp337_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp335_, _tmp336_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp337_;
			_vala_ccode_node_unref0 (_tmp335_);
			_vala_ccode_node_unref0 (_tmp333_);
			_tmp338_ = vala_ccode_identifier_new ("g_value_set_gtype");
			_tmp339_ = _tmp338_;
			_tmp340_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp339_);
			_vala_ccode_node_unref0 (csetcall);
			csetcall = _tmp340_;
			_vala_ccode_node_unref0 (_tmp339_);
			_tmp341_ = csetcall;
			_tmp342_ = vala_ccode_identifier_new ("value");
			_tmp343_ = _tmp342_;
			vala_ccode_function_call_add_argument (_tmp341_, (ValaCCodeExpression*) _tmp343_);
			_vala_ccode_node_unref0 (_tmp343_);
			_tmp344_ = csetcall;
			_tmp345_ = cfield;
			vala_ccode_function_call_add_argument (_tmp344_, (ValaCCodeExpression*) _tmp345_);
			_tmp346_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp347_ = _tmp346_;
			_tmp348_ = csetcall;
			vala_ccode_function_add_expression (_tmp347_, (ValaCCodeExpression*) _tmp348_);
			_tmp349_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp350_ = _tmp349_;
			vala_ccode_function_add_break (_tmp350_);
			_tmp351_ = type_param;
			_tmp352_ = vala_symbol_get_name ((ValaSymbol*) _tmp351_);
			_tmp353_ = _tmp352_;
			_tmp354_ = g_ascii_strdown (_tmp353_, (gssize) -1);
			_tmp355_ = _tmp354_;
			_tmp356_ = g_strdup_printf ("%s_dup_func", _tmp355_);
			_g_free0 (func_name);
			func_name = _tmp356_;
			_g_free0 (_tmp355_);
			_tmp357_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp358_ = _tmp357_;
			_tmp359_ = func_name;
			_tmp360_ = g_strdup_printf ("%s_%s", _tmp358_, _tmp359_);
			_tmp361_ = _tmp360_;
			_tmp362_ = g_ascii_strup (_tmp361_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp362_;
			_g_free0 (_tmp361_);
			_g_free0 (_tmp358_);
			_tmp363_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp364_ = _tmp363_;
			_tmp365_ = enum_value;
			_tmp366_ = vala_ccode_identifier_new (_tmp365_);
			_tmp367_ = _tmp366_;
			vala_ccode_function_add_case (_tmp364_, (ValaCCodeExpression*) _tmp367_);
			_vala_ccode_node_unref0 (_tmp367_);
			_tmp368_ = vala_ccode_identifier_new ("self");
			_tmp369_ = _tmp368_;
			_tmp370_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp369_, "priv");
			_tmp371_ = _tmp370_;
			_tmp372_ = func_name;
			_tmp373_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp371_, _tmp372_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp373_;
			_vala_ccode_node_unref0 (_tmp371_);
			_vala_ccode_node_unref0 (_tmp369_);
			_tmp374_ = vala_ccode_identifier_new ("g_value_set_pointer");
			_tmp375_ = _tmp374_;
			_tmp376_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp375_);
			_vala_ccode_node_unref0 (csetcall);
			csetcall = _tmp376_;
			_vala_ccode_node_unref0 (_tmp375_);
			_tmp377_ = csetcall;
			_tmp378_ = vala_ccode_identifier_new ("value");
			_tmp379_ = _tmp378_;
			vala_ccode_function_call_add_argument (_tmp377_, (ValaCCodeExpression*) _tmp379_);
			_vala_ccode_node_unref0 (_tmp379_);
			_tmp380_ = csetcall;
			_tmp381_ = cfield;
			vala_ccode_function_call_add_argument (_tmp380_, (ValaCCodeExpression*) _tmp381_);
			_tmp382_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp383_ = _tmp382_;
			_tmp384_ = csetcall;
			vala_ccode_function_add_expression (_tmp383_, (ValaCCodeExpression*) _tmp384_);
			_tmp385_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp386_ = _tmp385_;
			vala_ccode_function_add_break (_tmp386_);
			_tmp387_ = type_param;
			_tmp388_ = vala_symbol_get_name ((ValaSymbol*) _tmp387_);
			_tmp389_ = _tmp388_;
			_tmp390_ = g_ascii_strdown (_tmp389_, (gssize) -1);
			_tmp391_ = _tmp390_;
			_tmp392_ = g_strdup_printf ("%s_destroy_func", _tmp391_);
			_g_free0 (func_name);
			func_name = _tmp392_;
			_g_free0 (_tmp391_);
			_tmp393_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp394_ = _tmp393_;
			_tmp395_ = func_name;
			_tmp396_ = g_strdup_printf ("%s_%s", _tmp394_, _tmp395_);
			_tmp397_ = _tmp396_;
			_tmp398_ = g_ascii_strup (_tmp397_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp398_;
			_g_free0 (_tmp397_);
			_g_free0 (_tmp394_);
			_tmp399_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp400_ = _tmp399_;
			_tmp401_ = enum_value;
			_tmp402_ = vala_ccode_identifier_new (_tmp401_);
			_tmp403_ = _tmp402_;
			vala_ccode_function_add_case (_tmp400_, (ValaCCodeExpression*) _tmp403_);
			_vala_ccode_node_unref0 (_tmp403_);
			_tmp404_ = vala_ccode_identifier_new ("self");
			_tmp405_ = _tmp404_;
			_tmp406_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp405_, "priv");
			_tmp407_ = _tmp406_;
			_tmp408_ = func_name;
			_tmp409_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp407_, _tmp408_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp409_;
			_vala_ccode_node_unref0 (_tmp407_);
			_vala_ccode_node_unref0 (_tmp405_);
			_tmp410_ = vala_ccode_identifier_new ("g_value_set_pointer");
			_tmp411_ = _tmp410_;
			_tmp412_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp411_);
			_vala_ccode_node_unref0 (csetcall);
			csetcall = _tmp412_;
			_vala_ccode_node_unref0 (_tmp411_);
			_tmp413_ = csetcall;
			_tmp414_ = vala_ccode_identifier_new ("value");
			_tmp415_ = _tmp414_;
			vala_ccode_function_call_add_argument (_tmp413_, (ValaCCodeExpression*) _tmp415_);
			_vala_ccode_node_unref0 (_tmp415_);
			_tmp416_ = csetcall;
			_tmp417_ = cfield;
			vala_ccode_function_call_add_argument (_tmp416_, (ValaCCodeExpression*) _tmp417_);
			_tmp418_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp419_ = _tmp418_;
			_tmp420_ = csetcall;
			vala_ccode_function_add_expression (_tmp419_, (ValaCCodeExpression*) _tmp420_);
			_tmp421_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp422_ = _tmp421_;
			vala_ccode_function_add_break (_tmp422_);
			_vala_ccode_node_unref0 (csetcall);
			_vala_ccode_node_unref0 (cfield);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp423_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp424_ = _tmp423_;
	vala_ccode_function_add_default (_tmp424_);
	vala_gobject_module_emit_invalid_property_id_warn (self);
	_tmp425_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp426_ = _tmp425_;
	vala_ccode_function_add_break (_tmp426_);
	_tmp427_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp428_ = _tmp427_;
	vala_ccode_function_close (_tmp428_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp429_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp430_ = get_prop;
	vala_ccode_file_add_function_declaration (_tmp429_, _tmp430_);
	_tmp431_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp432_ = get_prop;
	vala_ccode_file_add_function (_tmp431_, _tmp432_);
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (get_prop);
}

static void
vala_gobject_module_add_set_property_function (ValaGObjectModule* self,
                                               ValaClass* cl)
{
	ValaCCodeFunction* set_prop = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp36_;
	ValaList* props = NULL;
	ValaList* _tmp37_;
	ValaList* _tmp38_;
	ValaCCodeFunction* _tmp358_;
	ValaCCodeFunction* _tmp359_;
	ValaCCodeFunction* _tmp360_;
	ValaCCodeFunction* _tmp361_;
	ValaCCodeFunction* _tmp362_;
	ValaCCodeFunction* _tmp363_;
	ValaCCodeFile* _tmp364_;
	ValaCCodeFunction* _tmp365_;
	ValaCCodeFile* _tmp366_;
	ValaCCodeFunction* _tmp367_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_vala_%s_set_property", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_new (_tmp3_, "void");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	set_prop = _tmp5_;
	_tmp6_ = set_prop;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp6_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp7_ = set_prop;
	_tmp8_ = vala_ccode_parameter_new ("object", "GObject *");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (_tmp7_, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = set_prop;
	_tmp11_ = vala_ccode_parameter_new ("property_id", "guint");
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp10_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = set_prop;
	_tmp14_ = vala_ccode_parameter_new ("value", "const GValue *");
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp13_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = set_prop;
	_tmp17_ = vala_ccode_parameter_new ("pspec", "GParamSpec *");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = set_prop;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("object");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp21_, (ValaTypeSymbol*) cl);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	ccall = _tmp23_;
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_get_ccode_name ((ValaCodeNode*) cl);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("%s *", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	_tmp31_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_declaration (_tmp25_, _tmp29_, (ValaCCodeDeclarator*) _tmp32_, 0);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_ccode_identifier_new ("property_id");
	_tmp36_ = _tmp35_;
	vala_ccode_function_open_switch (_tmp34_, (ValaCCodeExpression*) _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	_tmp37_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	_tmp38_ = _vala_iterable_ref0 (_tmp37_);
	props = _tmp38_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp39_;
		ValaList* _tmp40_;
		gint _prop_size = 0;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _prop_index = 0;
		_tmp39_ = props;
		_tmp40_ = _vala_iterable_ref0 (_tmp39_);
		_prop_list = _tmp40_;
		_tmp41_ = _prop_list;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_prop_size = _tmp43_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			ValaProperty* prop = NULL;
			ValaList* _tmp46_;
			gpointer _tmp47_;
			gboolean _tmp48_ = FALSE;
			ValaProperty* _tmp49_;
			ValaPropertyAccessor* _tmp50_;
			ValaPropertyAccessor* _tmp51_;
			ValaCodeContext* _tmp55_;
			ValaCodeContext* _tmp56_;
			ValaSemanticAnalyzer* _tmp57_;
			ValaSemanticAnalyzer* _tmp58_;
			ValaProperty* _tmp59_;
			ValaProperty* base_prop = NULL;
			ValaProperty* _tmp60_;
			ValaProperty* _tmp61_;
			ValaCCodeExpression* cself = NULL;
			ValaCCodeIdentifier* _tmp62_;
			ValaProperty* _tmp63_;
			ValaProperty* _tmp64_;
			ValaProperty* _tmp65_;
			ValaCCodeExpression* cfunc = NULL;
			gboolean _tmp127_ = FALSE;
			ValaProperty* _tmp128_;
			ValaCCodeFunction* _tmp142_;
			ValaCCodeFunction* _tmp143_;
			ValaProperty* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			ValaCCodeIdentifier* _tmp149_;
			ValaCCodeIdentifier* _tmp150_;
			ValaCCodeExpression* _tmp151_;
			ValaCCodeFunctionCall* _tmp152_;
			ValaCCodeFunctionCall* _tmp153_;
			ValaCCodeExpression* _tmp154_;
			gboolean _tmp155_ = FALSE;
			ValaProperty* _tmp156_;
			ValaDataType* _tmp157_;
			ValaDataType* _tmp158_;
			ValaCCodeFunction* _tmp242_;
			ValaCCodeFunction* _tmp243_;
			_prop_index = _prop_index + 1;
			_tmp44_ = _prop_index;
			_tmp45_ = _prop_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _prop_list;
			_tmp47_ = vala_list_get (_tmp46_, _prop_index);
			prop = (ValaProperty*) _tmp47_;
			_tmp49_ = prop;
			_tmp50_ = vala_property_get_set_accessor (_tmp49_);
			_tmp51_ = _tmp50_;
			if (_tmp51_ == NULL) {
				_tmp48_ = TRUE;
			} else {
				ValaProperty* _tmp52_;
				gboolean _tmp53_;
				gboolean _tmp54_;
				_tmp52_ = prop;
				_tmp53_ = vala_property_get_is_abstract (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp48_ = _tmp54_;
			}
			if (_tmp48_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp55_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_code_context_get_analyzer (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = prop;
			if (!vala_semantic_analyzer_is_gobject_property (_tmp58_, _tmp59_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp60_ = prop;
			_tmp61_ = _vala_code_node_ref0 (_tmp60_);
			base_prop = _tmp61_;
			_tmp62_ = vala_ccode_identifier_new ("self");
			cself = (ValaCCodeExpression*) _tmp62_;
			_tmp63_ = prop;
			_tmp64_ = vala_property_get_base_property (_tmp63_);
			_tmp65_ = _tmp64_;
			if (_tmp65_ != NULL) {
				ValaClass* base_type = NULL;
				ValaProperty* _tmp66_;
				ValaProperty* _tmp67_;
				ValaProperty* _tmp68_;
				ValaSymbol* _tmp69_;
				ValaSymbol* _tmp70_;
				ValaClass* _tmp71_;
				ValaProperty* _tmp72_;
				ValaProperty* _tmp73_;
				ValaProperty* _tmp74_;
				ValaProperty* _tmp75_;
				ValaObjectType* _tmp76_;
				ValaObjectType* _tmp77_;
				ValaCCodeExpression* _tmp78_;
				ValaGLibValue* _tmp79_;
				ValaGLibValue* _tmp80_;
				ValaClass* _tmp81_;
				ValaObjectType* _tmp82_;
				ValaObjectType* _tmp83_;
				ValaProperty* _tmp84_;
				ValaTargetValue* _tmp85_;
				ValaTargetValue* _tmp86_;
				ValaCCodeExpression* _tmp87_;
				ValaCCodeExpression* _tmp88_;
				ValaProperty* _tmp89_;
				ValaProperty* _tmp90_;
				ValaProperty* _tmp91_;
				ValaPropertyAccessor* _tmp92_;
				ValaPropertyAccessor* _tmp93_;
				ValaCCodeFile* _tmp94_;
				_tmp66_ = prop;
				_tmp67_ = vala_property_get_base_property (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_CLASS, ValaClass));
				base_type = _tmp71_;
				_tmp72_ = prop;
				_tmp73_ = vala_property_get_base_property (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = _vala_code_node_ref0 (_tmp74_);
				_vala_code_node_unref0 (base_prop);
				base_prop = _tmp75_;
				_tmp76_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
				_tmp77_ = _tmp76_;
				_tmp78_ = cself;
				_tmp79_ = vala_glib_value_new ((ValaDataType*) _tmp77_, _tmp78_, TRUE);
				_tmp80_ = _tmp79_;
				_tmp81_ = base_type;
				_tmp82_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp81_);
				_tmp83_ = _tmp82_;
				_tmp84_ = prop;
				_tmp85_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp80_, (ValaDataType*) _tmp83_, (ValaCodeNode*) _tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = vala_get_cvalue_ (_tmp86_);
				_tmp88_ = _vala_ccode_node_ref0 (_tmp87_);
				_vala_ccode_node_unref0 (cself);
				cself = _tmp88_;
				_vala_target_value_unref0 (_tmp86_);
				_vala_code_node_unref0 (_tmp83_);
				_vala_target_value_unref0 (_tmp80_);
				_vala_code_node_unref0 (_tmp77_);
				_tmp89_ = prop;
				_tmp90_ = vala_property_get_base_property (_tmp89_);
				_tmp91_ = _tmp90_;
				_tmp92_ = vala_property_get_set_accessor (_tmp91_);
				_tmp93_ = _tmp92_;
				_tmp94_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp93_, _tmp94_);
				_vala_code_node_unref0 (base_type);
			} else {
				ValaProperty* _tmp95_;
				ValaProperty* _tmp96_;
				ValaProperty* _tmp97_;
				_tmp95_ = prop;
				_tmp96_ = vala_property_get_base_interface_property (_tmp95_);
				_tmp97_ = _tmp96_;
				if (_tmp97_ != NULL) {
					ValaInterface* base_type = NULL;
					ValaProperty* _tmp98_;
					ValaProperty* _tmp99_;
					ValaProperty* _tmp100_;
					ValaSymbol* _tmp101_;
					ValaSymbol* _tmp102_;
					ValaInterface* _tmp103_;
					ValaProperty* _tmp104_;
					ValaProperty* _tmp105_;
					ValaProperty* _tmp106_;
					ValaProperty* _tmp107_;
					ValaObjectType* _tmp108_;
					ValaObjectType* _tmp109_;
					ValaCCodeExpression* _tmp110_;
					ValaGLibValue* _tmp111_;
					ValaGLibValue* _tmp112_;
					ValaInterface* _tmp113_;
					ValaObjectType* _tmp114_;
					ValaObjectType* _tmp115_;
					ValaProperty* _tmp116_;
					ValaTargetValue* _tmp117_;
					ValaTargetValue* _tmp118_;
					ValaCCodeExpression* _tmp119_;
					ValaCCodeExpression* _tmp120_;
					ValaProperty* _tmp121_;
					ValaProperty* _tmp122_;
					ValaProperty* _tmp123_;
					ValaPropertyAccessor* _tmp124_;
					ValaPropertyAccessor* _tmp125_;
					ValaCCodeFile* _tmp126_;
					_tmp98_ = prop;
					_tmp99_ = vala_property_get_base_interface_property (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_INTERFACE, ValaInterface));
					base_type = _tmp103_;
					_tmp104_ = prop;
					_tmp105_ = vala_property_get_base_interface_property (_tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = _vala_code_node_ref0 (_tmp106_);
					_vala_code_node_unref0 (base_prop);
					base_prop = _tmp107_;
					_tmp108_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp109_ = _tmp108_;
					_tmp110_ = cself;
					_tmp111_ = vala_glib_value_new ((ValaDataType*) _tmp109_, _tmp110_, TRUE);
					_tmp112_ = _tmp111_;
					_tmp113_ = base_type;
					_tmp114_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = prop;
					_tmp117_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp112_, (ValaDataType*) _tmp115_, (ValaCodeNode*) _tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = vala_get_cvalue_ (_tmp118_);
					_tmp120_ = _vala_ccode_node_ref0 (_tmp119_);
					_vala_ccode_node_unref0 (cself);
					cself = _tmp120_;
					_vala_target_value_unref0 (_tmp118_);
					_vala_code_node_unref0 (_tmp115_);
					_vala_target_value_unref0 (_tmp112_);
					_vala_code_node_unref0 (_tmp109_);
					_tmp121_ = prop;
					_tmp122_ = vala_property_get_base_interface_property (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_property_get_set_accessor (_tmp123_);
					_tmp125_ = _tmp124_;
					_tmp126_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp125_, _tmp126_);
					_vala_code_node_unref0 (base_type);
				}
			}
			_tmp128_ = base_prop;
			if (!vala_get_ccode_no_accessor_method (_tmp128_)) {
				ValaProperty* _tmp129_;
				_tmp129_ = base_prop;
				_tmp127_ = !vala_get_ccode_concrete_accessor (_tmp129_);
			} else {
				_tmp127_ = FALSE;
			}
			if (_tmp127_) {
				ValaProperty* _tmp130_;
				ValaPropertyAccessor* _tmp131_;
				ValaPropertyAccessor* _tmp132_;
				gchar* _tmp133_;
				gchar* _tmp134_;
				ValaCCodeIdentifier* _tmp135_;
				_tmp130_ = base_prop;
				_tmp131_ = vala_property_get_set_accessor (_tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = vala_get_ccode_name ((ValaCodeNode*) _tmp132_);
				_tmp134_ = _tmp133_;
				_tmp135_ = vala_ccode_identifier_new (_tmp134_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp135_;
				_g_free0 (_tmp134_);
			} else {
				ValaProperty* _tmp136_;
				ValaPropertyAccessor* _tmp137_;
				ValaPropertyAccessor* _tmp138_;
				gchar* _tmp139_;
				gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				_tmp136_ = prop;
				_tmp137_ = vala_property_get_set_accessor (_tmp136_);
				_tmp138_ = _tmp137_;
				_tmp139_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp141_;
				_g_free0 (_tmp140_);
			}
			_tmp142_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp143_ = _tmp142_;
			_tmp144_ = prop;
			_tmp145_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp144_, NULL);
			_tmp146_ = _tmp145_;
			_tmp147_ = g_strdup_printf ("%s_PROPERTY", _tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_ccode_identifier_new (_tmp148_);
			_tmp150_ = _tmp149_;
			vala_ccode_function_add_case (_tmp143_, (ValaCCodeExpression*) _tmp150_);
			_vala_ccode_node_unref0 (_tmp150_);
			_g_free0 (_tmp148_);
			_g_free0 (_tmp146_);
			_tmp151_ = cfunc;
			_tmp152_ = vala_ccode_function_call_new (_tmp151_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp152_;
			_tmp153_ = ccall;
			_tmp154_ = cself;
			vala_ccode_function_call_add_argument (_tmp153_, _tmp154_);
			_tmp156_ = prop;
			_tmp157_ = vala_property_get_property_type (_tmp156_);
			_tmp158_ = _tmp157_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp158_, VALA_TYPE_ARRAY_TYPE)) {
				ValaProperty* _tmp159_;
				ValaDataType* _tmp160_;
				ValaDataType* _tmp161_;
				ValaDataType* _tmp162_;
				ValaDataType* _tmp163_;
				ValaTypeSymbol* _tmp164_;
				ValaTypeSymbol* _tmp165_;
				ValaDataType* _tmp166_;
				ValaTypeSymbol* _tmp167_;
				ValaTypeSymbol* _tmp168_;
				_tmp159_ = prop;
				_tmp160_ = vala_property_get_property_type (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_data_type_get_type_symbol (_tmp163_);
				_tmp165_ = _tmp164_;
				_tmp166_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp167_ = vala_data_type_get_type_symbol (_tmp166_);
				_tmp168_ = _tmp167_;
				_tmp155_ = _tmp165_ == _tmp168_;
			} else {
				_tmp155_ = FALSE;
			}
			if (_tmp155_) {
				ValaCCodeFunction* _tmp169_;
				ValaCCodeFunction* _tmp170_;
				ValaCCodeFunction* _tmp171_;
				ValaCCodeFunction* _tmp172_;
				ValaCCodeVariableDeclarator* _tmp173_;
				ValaCCodeVariableDeclarator* _tmp174_;
				ValaCCodeFunctionCall* cgetcall = NULL;
				ValaCCodeIdentifier* _tmp175_;
				ValaCCodeIdentifier* _tmp176_;
				ValaCCodeFunctionCall* _tmp177_;
				ValaCCodeFunctionCall* _tmp178_;
				ValaCCodeFunctionCall* _tmp179_;
				ValaCCodeIdentifier* _tmp180_;
				ValaCCodeIdentifier* _tmp181_;
				ValaCCodeFunction* _tmp182_;
				ValaCCodeFunction* _tmp183_;
				ValaCCodeIdentifier* _tmp184_;
				ValaCCodeIdentifier* _tmp185_;
				ValaCCodeFunctionCall* _tmp186_;
				ValaCCodeFunctionCall* _tmp187_;
				ValaCCodeIdentifier* _tmp188_;
				ValaCCodeIdentifier* _tmp189_;
				ValaProperty* _tmp190_;
				ValaProperty* _tmp212_;
				ValaCCodeFunctionCall* _tmp213_;
				ValaCCodeFunction* _tmp214_;
				ValaCCodeFunction* _tmp215_;
				_tmp169_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp170_ = _tmp169_;
				vala_ccode_function_open_block (_tmp170_);
				_tmp171_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp172_ = _tmp171_;
				_tmp173_ = vala_ccode_variable_declarator_new ("boxed", NULL, NULL);
				_tmp174_ = _tmp173_;
				vala_ccode_function_add_declaration (_tmp172_, "gpointer", (ValaCCodeDeclarator*) _tmp174_, 0);
				_vala_ccode_node_unref0 (_tmp174_);
				_tmp175_ = vala_ccode_identifier_new ("g_value_get_boxed");
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp176_);
				_tmp178_ = _tmp177_;
				_vala_ccode_node_unref0 (_tmp176_);
				cgetcall = _tmp178_;
				_tmp179_ = cgetcall;
				_tmp180_ = vala_ccode_identifier_new ("value");
				_tmp181_ = _tmp180_;
				vala_ccode_function_call_add_argument (_tmp179_, (ValaCCodeExpression*) _tmp181_);
				_vala_ccode_node_unref0 (_tmp181_);
				_tmp182_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_ccode_identifier_new ("boxed");
				_tmp185_ = _tmp184_;
				_tmp186_ = cgetcall;
				vala_ccode_function_add_assignment (_tmp183_, (ValaCCodeExpression*) _tmp185_, (ValaCCodeExpression*) _tmp186_);
				_vala_ccode_node_unref0 (_tmp185_);
				_tmp187_ = ccall;
				_tmp188_ = vala_ccode_identifier_new ("boxed");
				_tmp189_ = _tmp188_;
				vala_ccode_function_call_add_argument (_tmp187_, (ValaCCodeExpression*) _tmp189_);
				_vala_ccode_node_unref0 (_tmp189_);
				_tmp190_ = prop;
				if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp190_)) {
					ValaCCodeBinaryExpression* cisnull = NULL;
					ValaCCodeIdentifier* _tmp191_;
					ValaCCodeIdentifier* _tmp192_;
					ValaCCodeConstant* _tmp193_;
					ValaCCodeConstant* _tmp194_;
					ValaCCodeBinaryExpression* _tmp195_;
					ValaCCodeBinaryExpression* _tmp196_;
					ValaCCodeFunctionCall* cstrvlen = NULL;
					ValaCCodeIdentifier* _tmp197_;
					ValaCCodeIdentifier* _tmp198_;
					ValaCCodeFunctionCall* _tmp199_;
					ValaCCodeFunctionCall* _tmp200_;
					ValaCCodeFunctionCall* _tmp201_;
					ValaCCodeIdentifier* _tmp202_;
					ValaCCodeIdentifier* _tmp203_;
					ValaCCodeConditionalExpression* ccond = NULL;
					ValaCCodeBinaryExpression* _tmp204_;
					ValaCCodeConstant* _tmp205_;
					ValaCCodeConstant* _tmp206_;
					ValaCCodeFunctionCall* _tmp207_;
					ValaCCodeConditionalExpression* _tmp208_;
					ValaCCodeConditionalExpression* _tmp209_;
					ValaCCodeFunctionCall* _tmp210_;
					ValaCCodeConditionalExpression* _tmp211_;
					_tmp191_ = vala_ccode_identifier_new ("boxed");
					_tmp192_ = _tmp191_;
					_tmp193_ = vala_ccode_constant_new ("NULL");
					_tmp194_ = _tmp193_;
					_tmp195_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp192_, (ValaCCodeExpression*) _tmp194_);
					_tmp196_ = _tmp195_;
					_vala_ccode_node_unref0 (_tmp194_);
					_vala_ccode_node_unref0 (_tmp192_);
					cisnull = _tmp196_;
					_tmp197_ = vala_ccode_identifier_new ("g_strv_length");
					_tmp198_ = _tmp197_;
					_tmp199_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp198_);
					_tmp200_ = _tmp199_;
					_vala_ccode_node_unref0 (_tmp198_);
					cstrvlen = _tmp200_;
					_tmp201_ = cstrvlen;
					_tmp202_ = vala_ccode_identifier_new ("boxed");
					_tmp203_ = _tmp202_;
					vala_ccode_function_call_add_argument (_tmp201_, (ValaCCodeExpression*) _tmp203_);
					_vala_ccode_node_unref0 (_tmp203_);
					_tmp204_ = cisnull;
					_tmp205_ = vala_ccode_constant_new ("0");
					_tmp206_ = _tmp205_;
					_tmp207_ = cstrvlen;
					_tmp208_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp204_, (ValaCCodeExpression*) _tmp206_, (ValaCCodeExpression*) _tmp207_);
					_tmp209_ = _tmp208_;
					_vala_ccode_node_unref0 (_tmp206_);
					ccond = _tmp209_;
					_tmp210_ = ccall;
					_tmp211_ = ccond;
					vala_ccode_function_call_add_argument (_tmp210_, (ValaCCodeExpression*) _tmp211_);
					_vala_ccode_node_unref0 (ccond);
					_vala_ccode_node_unref0 (cstrvlen);
					_vala_ccode_node_unref0 (cisnull);
				}
				_tmp212_ = prop;
				_tmp213_ = ccall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp212_, (ValaCCodeExpression*) _tmp213_);
				_tmp214_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp215_ = _tmp214_;
				vala_ccode_function_close (_tmp215_);
				_vala_ccode_node_unref0 (cgetcall);
			} else {
				ValaCCodeFunctionCall* cgetcall = NULL;
				ValaCCodeFunctionCall* _tmp216_;
				ValaProperty* _tmp217_;
				ValaDataType* _tmp218_;
				ValaDataType* _tmp219_;
				ValaTypeSymbol* _tmp220_;
				ValaTypeSymbol* _tmp221_;
				ValaCCodeFunctionCall* _tmp235_;
				ValaCCodeIdentifier* _tmp236_;
				ValaCCodeIdentifier* _tmp237_;
				ValaCCodeFunctionCall* _tmp238_;
				ValaCCodeFunctionCall* _tmp239_;
				ValaProperty* _tmp240_;
				ValaCCodeFunctionCall* _tmp241_;
				_tmp216_ = vala_ccode_function_call_new (NULL);
				cgetcall = _tmp216_;
				_tmp217_ = prop;
				_tmp218_ = vala_property_get_property_type (_tmp217_);
				_tmp219_ = _tmp218_;
				_tmp220_ = vala_data_type_get_type_symbol (_tmp219_);
				_tmp221_ = _tmp220_;
				if (_tmp221_ != NULL) {
					ValaCCodeFunctionCall* _tmp222_;
					ValaProperty* _tmp223_;
					ValaDataType* _tmp224_;
					ValaDataType* _tmp225_;
					ValaTypeSymbol* _tmp226_;
					ValaTypeSymbol* _tmp227_;
					gchar* _tmp228_;
					gchar* _tmp229_;
					ValaCCodeIdentifier* _tmp230_;
					ValaCCodeIdentifier* _tmp231_;
					_tmp222_ = cgetcall;
					_tmp223_ = prop;
					_tmp224_ = vala_property_get_property_type (_tmp223_);
					_tmp225_ = _tmp224_;
					_tmp226_ = vala_data_type_get_type_symbol (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp228_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp227_);
					_tmp229_ = _tmp228_;
					_tmp230_ = vala_ccode_identifier_new (_tmp229_);
					_tmp231_ = _tmp230_;
					vala_ccode_function_call_set_call (_tmp222_, (ValaCCodeExpression*) _tmp231_);
					_vala_ccode_node_unref0 (_tmp231_);
					_g_free0 (_tmp229_);
				} else {
					ValaCCodeFunctionCall* _tmp232_;
					ValaCCodeIdentifier* _tmp233_;
					ValaCCodeIdentifier* _tmp234_;
					_tmp232_ = cgetcall;
					_tmp233_ = vala_ccode_identifier_new ("g_value_get_pointer");
					_tmp234_ = _tmp233_;
					vala_ccode_function_call_set_call (_tmp232_, (ValaCCodeExpression*) _tmp234_);
					_vala_ccode_node_unref0 (_tmp234_);
				}
				_tmp235_ = cgetcall;
				_tmp236_ = vala_ccode_identifier_new ("value");
				_tmp237_ = _tmp236_;
				vala_ccode_function_call_add_argument (_tmp235_, (ValaCCodeExpression*) _tmp237_);
				_vala_ccode_node_unref0 (_tmp237_);
				_tmp238_ = ccall;
				_tmp239_ = cgetcall;
				vala_ccode_function_call_add_argument (_tmp238_, (ValaCCodeExpression*) _tmp239_);
				_tmp240_ = prop;
				_tmp241_ = ccall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp240_, (ValaCCodeExpression*) _tmp241_);
				_vala_ccode_node_unref0 (cgetcall);
			}
			_tmp242_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp243_ = _tmp242_;
			vala_ccode_function_add_break (_tmp243_);
			_vala_ccode_node_unref0 (cfunc);
			_vala_ccode_node_unref0 (cself);
			_vala_code_node_unref0 (base_prop);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp244_;
		ValaList* _tmp245_;
		gint _type_param_size = 0;
		ValaList* _tmp246_;
		gint _tmp247_;
		gint _tmp248_;
		gint _type_param_index = 0;
		_tmp244_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_tmp245_ = _vala_iterable_ref0 (_tmp244_);
		_type_param_list = _tmp245_;
		_tmp246_ = _type_param_list;
		_tmp247_ = vala_collection_get_size ((ValaCollection*) _tmp246_);
		_tmp248_ = _tmp247_;
		_type_param_size = _tmp248_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp249_;
			gint _tmp250_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp251_;
			gpointer _tmp252_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeMemberAccess* cfield = NULL;
			ValaCCodeFunctionCall* cgetcall = NULL;
			ValaTypeParameter* _tmp253_;
			const gchar* _tmp254_;
			const gchar* _tmp255_;
			gchar* _tmp256_;
			gchar* _tmp257_;
			gchar* _tmp258_;
			gchar* _tmp259_;
			gchar* _tmp260_;
			const gchar* _tmp261_;
			gchar* _tmp262_;
			gchar* _tmp263_;
			gchar* _tmp264_;
			ValaCCodeFunction* _tmp265_;
			ValaCCodeFunction* _tmp266_;
			const gchar* _tmp267_;
			ValaCCodeIdentifier* _tmp268_;
			ValaCCodeIdentifier* _tmp269_;
			ValaCCodeIdentifier* _tmp270_;
			ValaCCodeIdentifier* _tmp271_;
			ValaCCodeMemberAccess* _tmp272_;
			ValaCCodeMemberAccess* _tmp273_;
			const gchar* _tmp274_;
			ValaCCodeMemberAccess* _tmp275_;
			ValaCCodeIdentifier* _tmp276_;
			ValaCCodeIdentifier* _tmp277_;
			ValaCCodeFunctionCall* _tmp278_;
			ValaCCodeFunctionCall* _tmp279_;
			ValaCCodeIdentifier* _tmp280_;
			ValaCCodeIdentifier* _tmp281_;
			ValaCCodeFunction* _tmp282_;
			ValaCCodeFunction* _tmp283_;
			ValaCCodeMemberAccess* _tmp284_;
			ValaCCodeFunctionCall* _tmp285_;
			ValaCCodeFunction* _tmp286_;
			ValaCCodeFunction* _tmp287_;
			ValaTypeParameter* _tmp288_;
			const gchar* _tmp289_;
			const gchar* _tmp290_;
			gchar* _tmp291_;
			gchar* _tmp292_;
			gchar* _tmp293_;
			gchar* _tmp294_;
			gchar* _tmp295_;
			const gchar* _tmp296_;
			gchar* _tmp297_;
			gchar* _tmp298_;
			gchar* _tmp299_;
			ValaCCodeFunction* _tmp300_;
			ValaCCodeFunction* _tmp301_;
			const gchar* _tmp302_;
			ValaCCodeIdentifier* _tmp303_;
			ValaCCodeIdentifier* _tmp304_;
			ValaCCodeIdentifier* _tmp305_;
			ValaCCodeIdentifier* _tmp306_;
			ValaCCodeMemberAccess* _tmp307_;
			ValaCCodeMemberAccess* _tmp308_;
			const gchar* _tmp309_;
			ValaCCodeMemberAccess* _tmp310_;
			ValaCCodeIdentifier* _tmp311_;
			ValaCCodeIdentifier* _tmp312_;
			ValaCCodeFunctionCall* _tmp313_;
			ValaCCodeFunctionCall* _tmp314_;
			ValaCCodeIdentifier* _tmp315_;
			ValaCCodeIdentifier* _tmp316_;
			ValaCCodeFunction* _tmp317_;
			ValaCCodeFunction* _tmp318_;
			ValaCCodeMemberAccess* _tmp319_;
			ValaCCodeFunctionCall* _tmp320_;
			ValaCCodeFunction* _tmp321_;
			ValaCCodeFunction* _tmp322_;
			ValaTypeParameter* _tmp323_;
			const gchar* _tmp324_;
			const gchar* _tmp325_;
			gchar* _tmp326_;
			gchar* _tmp327_;
			gchar* _tmp328_;
			gchar* _tmp329_;
			gchar* _tmp330_;
			const gchar* _tmp331_;
			gchar* _tmp332_;
			gchar* _tmp333_;
			gchar* _tmp334_;
			ValaCCodeFunction* _tmp335_;
			ValaCCodeFunction* _tmp336_;
			const gchar* _tmp337_;
			ValaCCodeIdentifier* _tmp338_;
			ValaCCodeIdentifier* _tmp339_;
			ValaCCodeIdentifier* _tmp340_;
			ValaCCodeIdentifier* _tmp341_;
			ValaCCodeMemberAccess* _tmp342_;
			ValaCCodeMemberAccess* _tmp343_;
			const gchar* _tmp344_;
			ValaCCodeMemberAccess* _tmp345_;
			ValaCCodeIdentifier* _tmp346_;
			ValaCCodeIdentifier* _tmp347_;
			ValaCCodeFunctionCall* _tmp348_;
			ValaCCodeFunctionCall* _tmp349_;
			ValaCCodeIdentifier* _tmp350_;
			ValaCCodeIdentifier* _tmp351_;
			ValaCCodeFunction* _tmp352_;
			ValaCCodeFunction* _tmp353_;
			ValaCCodeMemberAccess* _tmp354_;
			ValaCCodeFunctionCall* _tmp355_;
			ValaCCodeFunction* _tmp356_;
			ValaCCodeFunction* _tmp357_;
			_type_param_index = _type_param_index + 1;
			_tmp249_ = _type_param_index;
			_tmp250_ = _type_param_size;
			if (!(_tmp249_ < _tmp250_)) {
				break;
			}
			_tmp251_ = _type_param_list;
			_tmp252_ = vala_list_get (_tmp251_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp252_;
			_tmp253_ = type_param;
			_tmp254_ = vala_symbol_get_name ((ValaSymbol*) _tmp253_);
			_tmp255_ = _tmp254_;
			_tmp256_ = g_ascii_strdown (_tmp255_, (gssize) -1);
			_tmp257_ = _tmp256_;
			_tmp258_ = g_strdup_printf ("%s_type", _tmp257_);
			_g_free0 (func_name);
			func_name = _tmp258_;
			_g_free0 (_tmp257_);
			_tmp259_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp260_ = _tmp259_;
			_tmp261_ = func_name;
			_tmp262_ = g_strdup_printf ("%s_%s", _tmp260_, _tmp261_);
			_tmp263_ = _tmp262_;
			_tmp264_ = g_ascii_strup (_tmp263_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp264_;
			_g_free0 (_tmp263_);
			_g_free0 (_tmp260_);
			_tmp265_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp266_ = _tmp265_;
			_tmp267_ = enum_value;
			_tmp268_ = vala_ccode_identifier_new (_tmp267_);
			_tmp269_ = _tmp268_;
			vala_ccode_function_add_case (_tmp266_, (ValaCCodeExpression*) _tmp269_);
			_vala_ccode_node_unref0 (_tmp269_);
			_tmp270_ = vala_ccode_identifier_new ("self");
			_tmp271_ = _tmp270_;
			_tmp272_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp271_, "priv");
			_tmp273_ = _tmp272_;
			_tmp274_ = func_name;
			_tmp275_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp273_, _tmp274_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp275_;
			_vala_ccode_node_unref0 (_tmp273_);
			_vala_ccode_node_unref0 (_tmp271_);
			_tmp276_ = vala_ccode_identifier_new ("g_value_get_gtype");
			_tmp277_ = _tmp276_;
			_tmp278_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp277_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp278_;
			_vala_ccode_node_unref0 (_tmp277_);
			_tmp279_ = cgetcall;
			_tmp280_ = vala_ccode_identifier_new ("value");
			_tmp281_ = _tmp280_;
			vala_ccode_function_call_add_argument (_tmp279_, (ValaCCodeExpression*) _tmp281_);
			_vala_ccode_node_unref0 (_tmp281_);
			_tmp282_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp283_ = _tmp282_;
			_tmp284_ = cfield;
			_tmp285_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp283_, (ValaCCodeExpression*) _tmp284_, (ValaCCodeExpression*) _tmp285_);
			_tmp286_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp287_ = _tmp286_;
			vala_ccode_function_add_break (_tmp287_);
			_tmp288_ = type_param;
			_tmp289_ = vala_symbol_get_name ((ValaSymbol*) _tmp288_);
			_tmp290_ = _tmp289_;
			_tmp291_ = g_ascii_strdown (_tmp290_, (gssize) -1);
			_tmp292_ = _tmp291_;
			_tmp293_ = g_strdup_printf ("%s_dup_func", _tmp292_);
			_g_free0 (func_name);
			func_name = _tmp293_;
			_g_free0 (_tmp292_);
			_tmp294_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp295_ = _tmp294_;
			_tmp296_ = func_name;
			_tmp297_ = g_strdup_printf ("%s_%s", _tmp295_, _tmp296_);
			_tmp298_ = _tmp297_;
			_tmp299_ = g_ascii_strup (_tmp298_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp299_;
			_g_free0 (_tmp298_);
			_g_free0 (_tmp295_);
			_tmp300_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp301_ = _tmp300_;
			_tmp302_ = enum_value;
			_tmp303_ = vala_ccode_identifier_new (_tmp302_);
			_tmp304_ = _tmp303_;
			vala_ccode_function_add_case (_tmp301_, (ValaCCodeExpression*) _tmp304_);
			_vala_ccode_node_unref0 (_tmp304_);
			_tmp305_ = vala_ccode_identifier_new ("self");
			_tmp306_ = _tmp305_;
			_tmp307_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp306_, "priv");
			_tmp308_ = _tmp307_;
			_tmp309_ = func_name;
			_tmp310_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp308_, _tmp309_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp310_;
			_vala_ccode_node_unref0 (_tmp308_);
			_vala_ccode_node_unref0 (_tmp306_);
			_tmp311_ = vala_ccode_identifier_new ("g_value_get_pointer");
			_tmp312_ = _tmp311_;
			_tmp313_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp312_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp313_;
			_vala_ccode_node_unref0 (_tmp312_);
			_tmp314_ = cgetcall;
			_tmp315_ = vala_ccode_identifier_new ("value");
			_tmp316_ = _tmp315_;
			vala_ccode_function_call_add_argument (_tmp314_, (ValaCCodeExpression*) _tmp316_);
			_vala_ccode_node_unref0 (_tmp316_);
			_tmp317_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp318_ = _tmp317_;
			_tmp319_ = cfield;
			_tmp320_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp318_, (ValaCCodeExpression*) _tmp319_, (ValaCCodeExpression*) _tmp320_);
			_tmp321_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp322_ = _tmp321_;
			vala_ccode_function_add_break (_tmp322_);
			_tmp323_ = type_param;
			_tmp324_ = vala_symbol_get_name ((ValaSymbol*) _tmp323_);
			_tmp325_ = _tmp324_;
			_tmp326_ = g_ascii_strdown (_tmp325_, (gssize) -1);
			_tmp327_ = _tmp326_;
			_tmp328_ = g_strdup_printf ("%s_destroy_func", _tmp327_);
			_g_free0 (func_name);
			func_name = _tmp328_;
			_g_free0 (_tmp327_);
			_tmp329_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp330_ = _tmp329_;
			_tmp331_ = func_name;
			_tmp332_ = g_strdup_printf ("%s_%s", _tmp330_, _tmp331_);
			_tmp333_ = _tmp332_;
			_tmp334_ = g_ascii_strup (_tmp333_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp334_;
			_g_free0 (_tmp333_);
			_g_free0 (_tmp330_);
			_tmp335_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp336_ = _tmp335_;
			_tmp337_ = enum_value;
			_tmp338_ = vala_ccode_identifier_new (_tmp337_);
			_tmp339_ = _tmp338_;
			vala_ccode_function_add_case (_tmp336_, (ValaCCodeExpression*) _tmp339_);
			_vala_ccode_node_unref0 (_tmp339_);
			_tmp340_ = vala_ccode_identifier_new ("self");
			_tmp341_ = _tmp340_;
			_tmp342_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp341_, "priv");
			_tmp343_ = _tmp342_;
			_tmp344_ = func_name;
			_tmp345_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp343_, _tmp344_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp345_;
			_vala_ccode_node_unref0 (_tmp343_);
			_vala_ccode_node_unref0 (_tmp341_);
			_tmp346_ = vala_ccode_identifier_new ("g_value_get_pointer");
			_tmp347_ = _tmp346_;
			_tmp348_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp347_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp348_;
			_vala_ccode_node_unref0 (_tmp347_);
			_tmp349_ = cgetcall;
			_tmp350_ = vala_ccode_identifier_new ("value");
			_tmp351_ = _tmp350_;
			vala_ccode_function_call_add_argument (_tmp349_, (ValaCCodeExpression*) _tmp351_);
			_vala_ccode_node_unref0 (_tmp351_);
			_tmp352_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp353_ = _tmp352_;
			_tmp354_ = cfield;
			_tmp355_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp353_, (ValaCCodeExpression*) _tmp354_, (ValaCCodeExpression*) _tmp355_);
			_tmp356_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp357_ = _tmp356_;
			vala_ccode_function_add_break (_tmp357_);
			_vala_ccode_node_unref0 (cgetcall);
			_vala_ccode_node_unref0 (cfield);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp358_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp359_ = _tmp358_;
	vala_ccode_function_add_default (_tmp359_);
	vala_gobject_module_emit_invalid_property_id_warn (self);
	_tmp360_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp361_ = _tmp360_;
	vala_ccode_function_add_break (_tmp361_);
	_tmp362_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp363_ = _tmp362_;
	vala_ccode_function_close (_tmp363_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp364_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp365_ = set_prop;
	vala_ccode_file_add_function_declaration (_tmp364_, _tmp365_);
	_tmp366_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp367_ = set_prop;
	vala_ccode_file_add_function (_tmp366_, _tmp367_);
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (set_prop);
}

static void
vala_gobject_module_emit_invalid_property_id_warn (ValaGObjectModule* self)
{
	ValaCCodeFunctionCall* cwarn = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_ccode_identifier_new ("G_OBJECT_WARN_INVALID_PROPERTY_ID");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	cwarn = _tmp3_;
	_tmp4_ = vala_ccode_identifier_new ("object");
	_tmp5_ = _tmp4_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp5_);
	_vala_ccode_node_unref0 (_tmp5_);
	_tmp6_ = vala_ccode_identifier_new ("property_id");
	_tmp7_ = _tmp6_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = vala_ccode_identifier_new ("pspec");
	_tmp9_ = _tmp8_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp11_ = _tmp10_;
	vala_ccode_function_add_expression (_tmp11_, (ValaCCodeExpression*) cwarn);
	_vala_ccode_node_unref0 (cwarn);
}

static void
vala_gobject_module_real_visit_constructor (ValaCodeVisitor* base,
                                            ValaConstructor* c)
{
	ValaGObjectModule * self;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaClass* cl = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaClass* _tmp4_;
	ValaMemberBinding _tmp5_;
	ValaMemberBinding _tmp6_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) c);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
	cl = _tmp4_;
	_tmp5_ = vala_constructor_get_binding (c);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaClass* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaCCodeBaseModuleEmitContext* _tmp11_;
		ValaCCodeBaseModuleEmitContext* _tmp12_;
		ValaCCodeFunction* function = NULL;
		ValaClass* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ValaCCodeFunction* _tmp18_;
		ValaCCodeFunction* _tmp19_;
		ValaCCodeFunction* _tmp20_;
		ValaCCodeFunction* _tmp21_;
		ValaCCodeParameter* _tmp22_;
		ValaCCodeParameter* _tmp23_;
		ValaCCodeFunction* _tmp24_;
		ValaCCodeParameter* _tmp25_;
		ValaCCodeParameter* _tmp26_;
		ValaCCodeFunction* _tmp27_;
		ValaCCodeParameter* _tmp28_;
		ValaCCodeParameter* _tmp29_;
		ValaCCodeFile* _tmp30_;
		ValaCCodeFunction* _tmp31_;
		ValaCCodeFunction* _tmp32_;
		ValaCCodeFunction* _tmp33_;
		ValaCCodeFunction* _tmp34_;
		ValaCCodeVariableDeclarator* _tmp35_;
		ValaCCodeVariableDeclarator* _tmp36_;
		ValaCCodeFunction* _tmp37_;
		ValaCCodeFunction* _tmp38_;
		ValaCCodeVariableDeclarator* _tmp39_;
		ValaCCodeVariableDeclarator* _tmp40_;
		ValaClass* _tmp41_;
		gboolean _tmp42_;
		gboolean _tmp43_;
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp199_;
		ValaCCodeIdentifier* _tmp200_;
		ValaCCodeFunctionCall* _tmp201_;
		ValaCCodeFunctionCall* _tmp202_;
		ValaCCodeFunctionCall* _tmp203_;
		ValaClass* _tmp204_;
		gchar* _tmp205_;
		gchar* _tmp206_;
		gchar* _tmp207_;
		gchar* _tmp208_;
		ValaCCodeIdentifier* _tmp209_;
		ValaCCodeIdentifier* _tmp210_;
		ValaCCodeFunction* _tmp211_;
		ValaCCodeFunction* _tmp212_;
		ValaCCodeIdentifier* _tmp213_;
		ValaCCodeIdentifier* _tmp214_;
		ValaCCodeFunctionCall* _tmp215_;
		ValaCCodeFunctionCall* ccall = NULL;
		ValaCCodeIdentifier* _tmp216_;
		ValaCCodeIdentifier* _tmp217_;
		ValaCCodeMemberAccess* _tmp218_;
		ValaCCodeMemberAccess* _tmp219_;
		ValaCCodeFunctionCall* _tmp220_;
		ValaCCodeFunctionCall* _tmp221_;
		ValaCCodeFunctionCall* _tmp222_;
		ValaCCodeIdentifier* _tmp223_;
		ValaCCodeIdentifier* _tmp224_;
		ValaCCodeFunctionCall* _tmp225_;
		ValaCCodeIdentifier* _tmp226_;
		ValaCCodeIdentifier* _tmp227_;
		ValaCCodeFunctionCall* _tmp228_;
		ValaCCodeIdentifier* _tmp229_;
		ValaCCodeIdentifier* _tmp230_;
		ValaCCodeFunction* _tmp231_;
		ValaCCodeFunction* _tmp232_;
		ValaCCodeIdentifier* _tmp233_;
		ValaCCodeIdentifier* _tmp234_;
		ValaCCodeFunctionCall* _tmp235_;
		ValaCCodeIdentifier* _tmp236_;
		ValaCCodeIdentifier* _tmp237_;
		ValaClass* _tmp238_;
		ValaCCodeFunctionCall* _tmp239_;
		ValaCCodeFunction* _tmp240_;
		ValaCCodeFunction* _tmp241_;
		ValaClass* _tmp242_;
		gchar* _tmp243_;
		gchar* _tmp244_;
		gchar* _tmp245_;
		gchar* _tmp246_;
		ValaCCodeVariableDeclarator* _tmp247_;
		ValaCCodeVariableDeclarator* _tmp248_;
		ValaCCodeFunction* _tmp249_;
		ValaCCodeFunction* _tmp250_;
		ValaCCodeIdentifier* _tmp251_;
		ValaCCodeIdentifier* _tmp252_;
		ValaCCodeFunctionCall* _tmp253_;
		ValaBlock* _tmp254_;
		ValaBlock* _tmp255_;
		gboolean _tmp256_;
		gboolean _tmp257_;
		ValaClass* _tmp268_;
		gboolean _tmp269_;
		gboolean _tmp270_;
		ValaCCodeFunction* _tmp324_;
		ValaCCodeFunction* _tmp325_;
		ValaCCodeIdentifier* _tmp326_;
		ValaCCodeIdentifier* _tmp327_;
		ValaCCodeFile* _tmp328_;
		ValaCCodeFunction* _tmp329_;
		_tmp7_ = cl;
		_tmp8_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp7_, _tmp8_)) {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
			_tmp10_ = _tmp9_;
			vala_report_error (_tmp10_, "construct blocks require GLib.Object");
			vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
			_vala_code_node_unref0 (cl);
			return;
		}
		_tmp11_ = vala_ccode_base_module_emit_context_new ((ValaSymbol*) c);
		_tmp12_ = _tmp11_;
		vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp12_);
		_vala_ccode_base_module_emit_context_unref0 (_tmp12_);
		_tmp13_ = cl;
		_tmp14_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%sconstructor", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_ccode_function_new (_tmp17_, "GObject *");
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		function = _tmp19_;
		_tmp20_ = function;
		vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp20_, VALA_CCODE_MODIFIERS_STATIC);
		_tmp21_ = function;
		_tmp22_ = vala_ccode_parameter_new ("type", "GType");
		_tmp23_ = _tmp22_;
		vala_ccode_function_add_parameter (_tmp21_, _tmp23_);
		_vala_ccode_node_unref0 (_tmp23_);
		_tmp24_ = function;
		_tmp25_ = vala_ccode_parameter_new ("n_construct_properties", "guint");
		_tmp26_ = _tmp25_;
		vala_ccode_function_add_parameter (_tmp24_, _tmp26_);
		_vala_ccode_node_unref0 (_tmp26_);
		_tmp27_ = function;
		_tmp28_ = vala_ccode_parameter_new ("construct_properties", "GObjectConstructParam *");
		_tmp29_ = _tmp28_;
		vala_ccode_function_add_parameter (_tmp27_, _tmp29_);
		_vala_ccode_node_unref0 (_tmp29_);
		_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp31_ = function;
		vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
		_tmp32_ = function;
		vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp32_);
		_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_ccode_variable_declarator_new ("obj", NULL, NULL);
		_tmp36_ = _tmp35_;
		vala_ccode_function_add_declaration (_tmp34_, "GObject *", (ValaCCodeDeclarator*) _tmp36_, 0);
		_vala_ccode_node_unref0 (_tmp36_);
		_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_ccode_variable_declarator_new ("parent_class", NULL, NULL);
		_tmp40_ = _tmp39_;
		vala_ccode_function_add_declaration (_tmp38_, "GObjectClass *", (ValaCCodeDeclarator*) _tmp40_, 0);
		_vala_ccode_node_unref0 (_tmp40_);
		_tmp41_ = cl;
		_tmp42_ = vala_class_get_is_singleton (_tmp41_);
		_tmp43_ = _tmp42_;
		if (_tmp43_) {
			gchar* singleton_ref_name = NULL;
			ValaClass* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* singleton_lock_name = NULL;
			ValaClass* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* singleton_once_name = NULL;
			ValaClass* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			ValaCCodeDeclaration* singleton_ref = NULL;
			ValaCCodeDeclaration* _tmp59_;
			ValaCCodeDeclaration* _tmp60_;
			const gchar* _tmp61_;
			ValaCCodeConstant* _tmp62_;
			ValaCCodeConstant* _tmp63_;
			ValaCCodeVariableDeclarator* _tmp64_;
			ValaCCodeVariableDeclarator* _tmp65_;
			ValaCCodeDeclaration* _tmp66_;
			ValaCCodeFunction* _tmp67_;
			ValaCCodeFunction* _tmp68_;
			ValaCCodeDeclaration* _tmp69_;
			ValaCCodeDeclaration* mutex_lock = NULL;
			ValaCCodeDeclaration* _tmp70_;
			ValaCCodeDeclaration* _tmp71_;
			const gchar* _tmp72_;
			ValaCCodeVariableDeclarator* _tmp73_;
			ValaCCodeVariableDeclarator* _tmp74_;
			ValaCCodeDeclaration* _tmp75_;
			ValaCCodeFunction* _tmp76_;
			ValaCCodeFunction* _tmp77_;
			ValaCCodeDeclaration* _tmp78_;
			ValaCCodeDeclaration* once_lock = NULL;
			ValaCCodeDeclaration* _tmp79_;
			ValaCCodeDeclaration* _tmp80_;
			const gchar* _tmp81_;
			ValaCCodeConstant* _tmp82_;
			ValaCCodeConstant* _tmp83_;
			ValaCCodeVariableDeclarator* _tmp84_;
			ValaCCodeVariableDeclarator* _tmp85_;
			ValaCCodeDeclaration* _tmp86_;
			ValaCCodeFunction* _tmp87_;
			ValaCCodeFunction* _tmp88_;
			ValaCCodeDeclaration* _tmp89_;
			ValaCCodeFunctionCall* once_init = NULL;
			ValaCCodeIdentifier* _tmp90_;
			ValaCCodeIdentifier* _tmp91_;
			ValaCCodeFunctionCall* _tmp92_;
			ValaCCodeFunctionCall* _tmp93_;
			ValaCCodeFunctionCall* _tmp94_;
			const gchar* _tmp95_;
			ValaCCodeIdentifier* _tmp96_;
			ValaCCodeIdentifier* _tmp97_;
			ValaCCodeUnaryExpression* _tmp98_;
			ValaCCodeUnaryExpression* _tmp99_;
			ValaCCodeBlock* once_block = NULL;
			ValaCCodeBlock* _tmp100_;
			ValaCCodeFunctionCall* singleton_mutex_init = NULL;
			ValaCCodeIdentifier* _tmp101_;
			ValaCCodeIdentifier* _tmp102_;
			ValaCCodeFunctionCall* _tmp103_;
			ValaCCodeFunctionCall* _tmp104_;
			ValaCCodeFunctionCall* _tmp105_;
			const gchar* _tmp106_;
			ValaCCodeIdentifier* _tmp107_;
			ValaCCodeIdentifier* _tmp108_;
			ValaCCodeUnaryExpression* _tmp109_;
			ValaCCodeUnaryExpression* _tmp110_;
			ValaCCodeBlock* _tmp111_;
			ValaCCodeFunctionCall* _tmp112_;
			ValaCCodeExpressionStatement* _tmp113_;
			ValaCCodeExpressionStatement* _tmp114_;
			ValaCCodeFunctionCall* once_leave = NULL;
			ValaCCodeIdentifier* _tmp115_;
			ValaCCodeIdentifier* _tmp116_;
			ValaCCodeFunctionCall* _tmp117_;
			ValaCCodeFunctionCall* _tmp118_;
			ValaCCodeFunctionCall* _tmp119_;
			const gchar* _tmp120_;
			ValaCCodeIdentifier* _tmp121_;
			ValaCCodeIdentifier* _tmp122_;
			ValaCCodeUnaryExpression* _tmp123_;
			ValaCCodeUnaryExpression* _tmp124_;
			ValaCCodeFunctionCall* _tmp125_;
			ValaCCodeConstant* _tmp126_;
			ValaCCodeConstant* _tmp127_;
			ValaCCodeBlock* _tmp128_;
			ValaCCodeFunctionCall* _tmp129_;
			ValaCCodeExpressionStatement* _tmp130_;
			ValaCCodeExpressionStatement* _tmp131_;
			ValaCCodeIfStatement* if_once = NULL;
			ValaCCodeFunctionCall* _tmp132_;
			ValaCCodeBlock* _tmp133_;
			ValaCCodeIfStatement* _tmp134_;
			ValaCCodeFunction* _tmp135_;
			ValaCCodeFunction* _tmp136_;
			ValaCCodeIfStatement* _tmp137_;
			ValaCCodeFunctionCall* singleton_mutex_lock = NULL;
			ValaCCodeIdentifier* _tmp138_;
			ValaCCodeIdentifier* _tmp139_;
			ValaCCodeFunctionCall* _tmp140_;
			ValaCCodeFunctionCall* _tmp141_;
			ValaCCodeFunctionCall* _tmp142_;
			const gchar* _tmp143_;
			ValaCCodeIdentifier* _tmp144_;
			ValaCCodeIdentifier* _tmp145_;
			ValaCCodeUnaryExpression* _tmp146_;
			ValaCCodeUnaryExpression* _tmp147_;
			ValaCCodeFunction* _tmp148_;
			ValaCCodeFunction* _tmp149_;
			ValaCCodeFunctionCall* _tmp150_;
			ValaCCodeExpressionStatement* _tmp151_;
			ValaCCodeExpressionStatement* _tmp152_;
			ValaCCodeBinaryExpression* check_existance = NULL;
			const gchar* _tmp153_;
			ValaCCodeIdentifier* _tmp154_;
			ValaCCodeIdentifier* _tmp155_;
			ValaCCodeConstant* _tmp156_;
			ValaCCodeConstant* _tmp157_;
			ValaCCodeBinaryExpression* _tmp158_;
			ValaCCodeBinaryExpression* _tmp159_;
			ValaCCodeBlock* return_singleton = NULL;
			ValaCCodeBlock* _tmp160_;
			ValaCCodeFunctionCall* ref_object = NULL;
			ValaCCodeIdentifier* _tmp161_;
			ValaCCodeIdentifier* _tmp162_;
			ValaCCodeFunctionCall* _tmp163_;
			ValaCCodeFunctionCall* _tmp164_;
			ValaCCodeFunctionCall* _tmp165_;
			const gchar* _tmp166_;
			ValaCCodeIdentifier* _tmp167_;
			ValaCCodeIdentifier* _tmp168_;
			ValaCCodeBlock* _tmp169_;
			ValaCCodeFunctionCall* _tmp170_;
			ValaCCodeExpressionStatement* _tmp171_;
			ValaCCodeExpressionStatement* _tmp172_;
			ValaCCodeFunctionCall* singleton_mutex_unlock = NULL;
			ValaCCodeIdentifier* _tmp173_;
			ValaCCodeIdentifier* _tmp174_;
			ValaCCodeFunctionCall* _tmp175_;
			ValaCCodeFunctionCall* _tmp176_;
			ValaCCodeFunctionCall* _tmp177_;
			const gchar* _tmp178_;
			ValaCCodeIdentifier* _tmp179_;
			ValaCCodeIdentifier* _tmp180_;
			ValaCCodeUnaryExpression* _tmp181_;
			ValaCCodeUnaryExpression* _tmp182_;
			ValaCCodeBlock* _tmp183_;
			ValaCCodeFunctionCall* _tmp184_;
			ValaCCodeExpressionStatement* _tmp185_;
			ValaCCodeExpressionStatement* _tmp186_;
			ValaCCodeBlock* _tmp187_;
			const gchar* _tmp188_;
			ValaCCodeIdentifier* _tmp189_;
			ValaCCodeIdentifier* _tmp190_;
			ValaCCodeReturnStatement* _tmp191_;
			ValaCCodeReturnStatement* _tmp192_;
			ValaCCodeIfStatement* if_singleton_alive = NULL;
			ValaCCodeBinaryExpression* _tmp193_;
			ValaCCodeBlock* _tmp194_;
			ValaCCodeIfStatement* _tmp195_;
			ValaCCodeFunction* _tmp196_;
			ValaCCodeFunction* _tmp197_;
			ValaCCodeIfStatement* _tmp198_;
			_tmp44_ = cl;
			_tmp45_ = vala_get_ccode_name ((ValaCodeNode*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strdup_printf ("%s_singleton__ref", _tmp46_);
			_tmp48_ = _tmp47_;
			_g_free0 (_tmp46_);
			singleton_ref_name = _tmp48_;
			_tmp49_ = cl;
			_tmp50_ = vala_get_ccode_name ((ValaCodeNode*) _tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = g_strdup_printf ("%s_singleton__lock", _tmp51_);
			_tmp53_ = _tmp52_;
			_g_free0 (_tmp51_);
			singleton_lock_name = _tmp53_;
			_tmp54_ = cl;
			_tmp55_ = vala_get_ccode_name ((ValaCodeNode*) _tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strdup_printf ("%s_singleton__volatile", _tmp56_);
			_tmp58_ = _tmp57_;
			_g_free0 (_tmp56_);
			singleton_once_name = _tmp58_;
			_tmp59_ = vala_ccode_declaration_new ("GObject *");
			singleton_ref = _tmp59_;
			_tmp60_ = singleton_ref;
			_tmp61_ = singleton_ref_name;
			_tmp62_ = vala_ccode_constant_new ("NULL");
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_ccode_variable_declarator_new (_tmp61_, (ValaCCodeExpression*) _tmp63_, NULL);
			_tmp65_ = _tmp64_;
			vala_ccode_declaration_add_declarator (_tmp60_, (ValaCCodeDeclarator*) _tmp65_);
			_vala_ccode_node_unref0 (_tmp65_);
			_vala_ccode_node_unref0 (_tmp63_);
			_tmp66_ = singleton_ref;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp66_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp67_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp68_ = _tmp67_;
			_tmp69_ = singleton_ref;
			vala_ccode_function_add_statement (_tmp68_, (ValaCCodeNode*) _tmp69_);
			_tmp70_ = vala_ccode_declaration_new ("GMutex");
			mutex_lock = _tmp70_;
			_tmp71_ = mutex_lock;
			_tmp72_ = singleton_lock_name;
			_tmp73_ = vala_ccode_variable_declarator_new (_tmp72_, NULL, NULL);
			_tmp74_ = _tmp73_;
			vala_ccode_declaration_add_declarator (_tmp71_, (ValaCCodeDeclarator*) _tmp74_);
			_vala_ccode_node_unref0 (_tmp74_);
			_tmp75_ = mutex_lock;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp75_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp76_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp77_ = _tmp76_;
			_tmp78_ = mutex_lock;
			vala_ccode_function_add_statement (_tmp77_, (ValaCCodeNode*) _tmp78_);
			_tmp79_ = vala_ccode_declaration_new ("gsize");
			once_lock = _tmp79_;
			_tmp80_ = once_lock;
			_tmp81_ = singleton_once_name;
			_tmp82_ = vala_ccode_constant_new ("0");
			_tmp83_ = _tmp82_;
			_tmp84_ = vala_ccode_variable_declarator_new (_tmp81_, (ValaCCodeExpression*) _tmp83_, NULL);
			_tmp85_ = _tmp84_;
			vala_ccode_declaration_add_declarator (_tmp80_, (ValaCCodeDeclarator*) _tmp85_);
			_vala_ccode_node_unref0 (_tmp85_);
			_vala_ccode_node_unref0 (_tmp83_);
			_tmp86_ = once_lock;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp86_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_VOLATILE);
			_tmp87_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp88_ = _tmp87_;
			_tmp89_ = once_lock;
			vala_ccode_function_add_statement (_tmp88_, (ValaCCodeNode*) _tmp89_);
			_tmp90_ = vala_ccode_identifier_new ("g_once_init_enter");
			_tmp91_ = _tmp90_;
			_tmp92_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp91_);
			_tmp93_ = _tmp92_;
			_vala_ccode_node_unref0 (_tmp91_);
			once_init = _tmp93_;
			_tmp94_ = once_init;
			_tmp95_ = singleton_once_name;
			_tmp96_ = vala_ccode_identifier_new (_tmp95_);
			_tmp97_ = _tmp96_;
			_tmp98_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp97_);
			_tmp99_ = _tmp98_;
			vala_ccode_function_call_add_argument (_tmp94_, (ValaCCodeExpression*) _tmp99_);
			_vala_ccode_node_unref0 (_tmp99_);
			_vala_ccode_node_unref0 (_tmp97_);
			_tmp100_ = vala_ccode_block_new ();
			once_block = _tmp100_;
			_tmp101_ = vala_ccode_identifier_new ("g_mutex_init");
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
			_tmp104_ = _tmp103_;
			_vala_ccode_node_unref0 (_tmp102_);
			singleton_mutex_init = _tmp104_;
			_tmp105_ = singleton_mutex_init;
			_tmp106_ = singleton_lock_name;
			_tmp107_ = vala_ccode_identifier_new (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp109_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp108_);
			_tmp110_ = _tmp109_;
			vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp110_);
			_vala_ccode_node_unref0 (_tmp110_);
			_vala_ccode_node_unref0 (_tmp108_);
			_tmp111_ = once_block;
			_tmp112_ = singleton_mutex_init;
			_tmp113_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp112_);
			_tmp114_ = _tmp113_;
			vala_ccode_block_add_statement (_tmp111_, (ValaCCodeNode*) _tmp114_);
			_vala_ccode_node_unref0 (_tmp114_);
			_tmp115_ = vala_ccode_identifier_new ("g_once_init_leave");
			_tmp116_ = _tmp115_;
			_tmp117_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp116_);
			_tmp118_ = _tmp117_;
			_vala_ccode_node_unref0 (_tmp116_);
			once_leave = _tmp118_;
			_tmp119_ = once_leave;
			_tmp120_ = singleton_once_name;
			_tmp121_ = vala_ccode_identifier_new (_tmp120_);
			_tmp122_ = _tmp121_;
			_tmp123_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp122_);
			_tmp124_ = _tmp123_;
			vala_ccode_function_call_add_argument (_tmp119_, (ValaCCodeExpression*) _tmp124_);
			_vala_ccode_node_unref0 (_tmp124_);
			_vala_ccode_node_unref0 (_tmp122_);
			_tmp125_ = once_leave;
			_tmp126_ = vala_ccode_constant_new ("42");
			_tmp127_ = _tmp126_;
			vala_ccode_function_call_add_argument (_tmp125_, (ValaCCodeExpression*) _tmp127_);
			_vala_ccode_node_unref0 (_tmp127_);
			_tmp128_ = once_block;
			_tmp129_ = once_leave;
			_tmp130_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp129_);
			_tmp131_ = _tmp130_;
			vala_ccode_block_add_statement (_tmp128_, (ValaCCodeNode*) _tmp131_);
			_vala_ccode_node_unref0 (_tmp131_);
			_tmp132_ = once_init;
			_tmp133_ = once_block;
			_tmp134_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) _tmp132_, (ValaCCodeStatement*) _tmp133_, NULL);
			if_once = _tmp134_;
			_tmp135_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp136_ = _tmp135_;
			_tmp137_ = if_once;
			vala_ccode_function_add_statement (_tmp136_, (ValaCCodeNode*) _tmp137_);
			_tmp138_ = vala_ccode_identifier_new ("g_mutex_lock");
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp139_);
			_tmp141_ = _tmp140_;
			_vala_ccode_node_unref0 (_tmp139_);
			singleton_mutex_lock = _tmp141_;
			_tmp142_ = singleton_mutex_lock;
			_tmp143_ = singleton_lock_name;
			_tmp144_ = vala_ccode_identifier_new (_tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp145_);
			_tmp147_ = _tmp146_;
			vala_ccode_function_call_add_argument (_tmp142_, (ValaCCodeExpression*) _tmp147_);
			_vala_ccode_node_unref0 (_tmp147_);
			_vala_ccode_node_unref0 (_tmp145_);
			_tmp148_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp149_ = _tmp148_;
			_tmp150_ = singleton_mutex_lock;
			_tmp151_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp150_);
			_tmp152_ = _tmp151_;
			vala_ccode_function_add_statement (_tmp149_, (ValaCCodeNode*) _tmp152_);
			_vala_ccode_node_unref0 (_tmp152_);
			_tmp153_ = singleton_ref_name;
			_tmp154_ = vala_ccode_identifier_new (_tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_ccode_constant_new ("NULL");
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp155_, (ValaCCodeExpression*) _tmp157_);
			_tmp159_ = _tmp158_;
			_vala_ccode_node_unref0 (_tmp157_);
			_vala_ccode_node_unref0 (_tmp155_);
			check_existance = _tmp159_;
			_tmp160_ = vala_ccode_block_new ();
			return_singleton = _tmp160_;
			_tmp161_ = vala_ccode_identifier_new ("g_object_ref");
			_tmp162_ = _tmp161_;
			_tmp163_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp162_);
			_tmp164_ = _tmp163_;
			_vala_ccode_node_unref0 (_tmp162_);
			ref_object = _tmp164_;
			_tmp165_ = ref_object;
			_tmp166_ = singleton_ref_name;
			_tmp167_ = vala_ccode_identifier_new (_tmp166_);
			_tmp168_ = _tmp167_;
			vala_ccode_function_call_add_argument (_tmp165_, (ValaCCodeExpression*) _tmp168_);
			_vala_ccode_node_unref0 (_tmp168_);
			_tmp169_ = return_singleton;
			_tmp170_ = ref_object;
			_tmp171_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp170_);
			_tmp172_ = _tmp171_;
			vala_ccode_block_add_statement (_tmp169_, (ValaCCodeNode*) _tmp172_);
			_vala_ccode_node_unref0 (_tmp172_);
			_tmp173_ = vala_ccode_identifier_new ("g_mutex_unlock");
			_tmp174_ = _tmp173_;
			_tmp175_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp174_);
			_tmp176_ = _tmp175_;
			_vala_ccode_node_unref0 (_tmp174_);
			singleton_mutex_unlock = _tmp176_;
			_tmp177_ = singleton_mutex_unlock;
			_tmp178_ = singleton_lock_name;
			_tmp179_ = vala_ccode_identifier_new (_tmp178_);
			_tmp180_ = _tmp179_;
			_tmp181_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp180_);
			_tmp182_ = _tmp181_;
			vala_ccode_function_call_add_argument (_tmp177_, (ValaCCodeExpression*) _tmp182_);
			_vala_ccode_node_unref0 (_tmp182_);
			_vala_ccode_node_unref0 (_tmp180_);
			_tmp183_ = return_singleton;
			_tmp184_ = singleton_mutex_unlock;
			_tmp185_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp184_);
			_tmp186_ = _tmp185_;
			vala_ccode_block_add_statement (_tmp183_, (ValaCCodeNode*) _tmp186_);
			_vala_ccode_node_unref0 (_tmp186_);
			_tmp187_ = return_singleton;
			_tmp188_ = singleton_ref_name;
			_tmp189_ = vala_ccode_identifier_new (_tmp188_);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) _tmp190_);
			_tmp192_ = _tmp191_;
			vala_ccode_block_add_statement (_tmp187_, (ValaCCodeNode*) _tmp192_);
			_vala_ccode_node_unref0 (_tmp192_);
			_vala_ccode_node_unref0 (_tmp190_);
			_tmp193_ = check_existance;
			_tmp194_ = return_singleton;
			_tmp195_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) _tmp193_, (ValaCCodeStatement*) _tmp194_, NULL);
			if_singleton_alive = _tmp195_;
			_tmp196_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp197_ = _tmp196_;
			_tmp198_ = if_singleton_alive;
			vala_ccode_function_add_statement (_tmp197_, (ValaCCodeNode*) _tmp198_);
			_vala_ccode_node_unref0 (if_singleton_alive);
			_vala_ccode_node_unref0 (singleton_mutex_unlock);
			_vala_ccode_node_unref0 (ref_object);
			_vala_ccode_node_unref0 (return_singleton);
			_vala_ccode_node_unref0 (check_existance);
			_vala_ccode_node_unref0 (singleton_mutex_lock);
			_vala_ccode_node_unref0 (if_once);
			_vala_ccode_node_unref0 (once_leave);
			_vala_ccode_node_unref0 (singleton_mutex_init);
			_vala_ccode_node_unref0 (once_block);
			_vala_ccode_node_unref0 (once_init);
			_vala_ccode_node_unref0 (once_lock);
			_vala_ccode_node_unref0 (mutex_lock);
			_vala_ccode_node_unref0 (singleton_ref);
			_g_free0 (singleton_once_name);
			_g_free0 (singleton_lock_name);
			_g_free0 (singleton_ref_name);
		}
		_tmp199_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp200_ = _tmp199_;
		_tmp201_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp200_);
		_tmp202_ = _tmp201_;
		_vala_ccode_node_unref0 (_tmp200_);
		ccast = _tmp202_;
		_tmp203_ = ccast;
		_tmp204_ = cl;
		_tmp205_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp204_, NULL);
		_tmp206_ = _tmp205_;
		_tmp207_ = g_strdup_printf ("%s_parent_class", _tmp206_);
		_tmp208_ = _tmp207_;
		_tmp209_ = vala_ccode_identifier_new (_tmp208_);
		_tmp210_ = _tmp209_;
		vala_ccode_function_call_add_argument (_tmp203_, (ValaCCodeExpression*) _tmp210_);
		_vala_ccode_node_unref0 (_tmp210_);
		_g_free0 (_tmp208_);
		_g_free0 (_tmp206_);
		_tmp211_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp212_ = _tmp211_;
		_tmp213_ = vala_ccode_identifier_new ("parent_class");
		_tmp214_ = _tmp213_;
		_tmp215_ = ccast;
		vala_ccode_function_add_assignment (_tmp212_, (ValaCCodeExpression*) _tmp214_, (ValaCCodeExpression*) _tmp215_);
		_vala_ccode_node_unref0 (_tmp214_);
		_tmp216_ = vala_ccode_identifier_new ("parent_class");
		_tmp217_ = _tmp216_;
		_tmp218_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp217_, "constructor");
		_tmp219_ = _tmp218_;
		_tmp220_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp219_);
		_tmp221_ = _tmp220_;
		_vala_ccode_node_unref0 (_tmp219_);
		_vala_ccode_node_unref0 (_tmp217_);
		ccall = _tmp221_;
		_tmp222_ = ccall;
		_tmp223_ = vala_ccode_identifier_new ("type");
		_tmp224_ = _tmp223_;
		vala_ccode_function_call_add_argument (_tmp222_, (ValaCCodeExpression*) _tmp224_);
		_vala_ccode_node_unref0 (_tmp224_);
		_tmp225_ = ccall;
		_tmp226_ = vala_ccode_identifier_new ("n_construct_properties");
		_tmp227_ = _tmp226_;
		vala_ccode_function_call_add_argument (_tmp225_, (ValaCCodeExpression*) _tmp227_);
		_vala_ccode_node_unref0 (_tmp227_);
		_tmp228_ = ccall;
		_tmp229_ = vala_ccode_identifier_new ("construct_properties");
		_tmp230_ = _tmp229_;
		vala_ccode_function_call_add_argument (_tmp228_, (ValaCCodeExpression*) _tmp230_);
		_vala_ccode_node_unref0 (_tmp230_);
		_tmp231_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp232_ = _tmp231_;
		_tmp233_ = vala_ccode_identifier_new ("obj");
		_tmp234_ = _tmp233_;
		_tmp235_ = ccall;
		vala_ccode_function_add_assignment (_tmp232_, (ValaCCodeExpression*) _tmp234_, (ValaCCodeExpression*) _tmp235_);
		_vala_ccode_node_unref0 (_tmp234_);
		_tmp236_ = vala_ccode_identifier_new ("obj");
		_tmp237_ = _tmp236_;
		_tmp238_ = cl;
		_tmp239_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp237_, (ValaTypeSymbol*) _tmp238_);
		_vala_ccode_node_unref0 (ccall);
		ccall = _tmp239_;
		_vala_ccode_node_unref0 (_tmp237_);
		_tmp240_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp241_ = _tmp240_;
		_tmp242_ = cl;
		_tmp243_ = vala_get_ccode_name ((ValaCodeNode*) _tmp242_);
		_tmp244_ = _tmp243_;
		_tmp245_ = g_strdup_printf ("%s *", _tmp244_);
		_tmp246_ = _tmp245_;
		_tmp247_ = vala_ccode_variable_declarator_new ("self", NULL, NULL);
		_tmp248_ = _tmp247_;
		vala_ccode_function_add_declaration (_tmp241_, _tmp246_, (ValaCCodeDeclarator*) _tmp248_, 0);
		_vala_ccode_node_unref0 (_tmp248_);
		_g_free0 (_tmp246_);
		_g_free0 (_tmp244_);
		_tmp249_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp250_ = _tmp249_;
		_tmp251_ = vala_ccode_identifier_new ("self");
		_tmp252_ = _tmp251_;
		_tmp253_ = ccall;
		vala_ccode_function_add_assignment (_tmp250_, (ValaCCodeExpression*) _tmp252_, (ValaCCodeExpression*) _tmp253_);
		_vala_ccode_node_unref0 (_tmp252_);
		_tmp254_ = vala_subroutine_get_body ((ValaSubroutine*) c);
		_tmp255_ = _tmp254_;
		vala_code_node_emit ((ValaCodeNode*) _tmp255_, (ValaCodeGenerator*) self);
		_tmp256_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
		_tmp257_ = _tmp256_;
		if (_tmp257_) {
			ValaCCodeFunction* _tmp258_;
			ValaCCodeFunction* _tmp259_;
			gint _tmp260_;
			gint _tmp261_;
			gchar* _tmp262_;
			gchar* _tmp263_;
			ValaCCodeConstant* _tmp264_;
			ValaCCodeConstant* _tmp265_;
			ValaCCodeVariableDeclarator* _tmp266_;
			ValaCCodeVariableDeclarator* _tmp267_;
			_tmp258_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp259_ = _tmp258_;
			_tmp260_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
			_tmp261_ = _tmp260_;
			_tmp262_ = g_strdup_printf ("_inner_error%d_", _tmp261_);
			_tmp263_ = _tmp262_;
			_tmp264_ = vala_ccode_constant_new ("NULL");
			_tmp265_ = _tmp264_;
			_tmp266_ = vala_ccode_variable_declarator_new_zero (_tmp263_, (ValaCCodeExpression*) _tmp265_, NULL);
			_tmp267_ = _tmp266_;
			vala_ccode_function_add_declaration (_tmp259_, "GError*", (ValaCCodeDeclarator*) _tmp267_, 0);
			_vala_ccode_node_unref0 (_tmp267_);
			_vala_ccode_node_unref0 (_tmp265_);
			_g_free0 (_tmp263_);
		}
		_tmp268_ = cl;
		_tmp269_ = vala_class_get_is_singleton (_tmp268_);
		_tmp270_ = _tmp269_;
		if (_tmp270_) {
			gchar* singleton_ref_name = NULL;
			ValaClass* _tmp271_;
			gchar* _tmp272_;
			gchar* _tmp273_;
			gchar* _tmp274_;
			gchar* _tmp275_;
			gchar* singleton_lock_name = NULL;
			ValaClass* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			gchar* _tmp279_;
			gchar* _tmp280_;
			ValaCCodeFunction* _tmp281_;
			ValaCCodeFunction* _tmp282_;
			const gchar* _tmp283_;
			ValaCCodeIdentifier* _tmp284_;
			ValaCCodeIdentifier* _tmp285_;
			ValaCCodeIdentifier* _tmp286_;
			ValaCCodeIdentifier* _tmp287_;
			ValaCCodeFunctionCall* set_weak_ref_to_volatile = NULL;
			ValaCCodeIdentifier* _tmp288_;
			ValaCCodeIdentifier* _tmp289_;
			ValaCCodeFunctionCall* _tmp290_;
			ValaCCodeFunctionCall* _tmp291_;
			ValaCCodeFunctionCall* _tmp292_;
			const gchar* _tmp293_;
			ValaCCodeIdentifier* _tmp294_;
			ValaCCodeIdentifier* _tmp295_;
			ValaCCodeFunctionCall* _tmp296_;
			const gchar* _tmp297_;
			ValaCCodeIdentifier* _tmp298_;
			ValaCCodeIdentifier* _tmp299_;
			ValaCCodeUnaryExpression* _tmp300_;
			ValaCCodeUnaryExpression* _tmp301_;
			ValaCCodeCastExpression* _tmp302_;
			ValaCCodeCastExpression* _tmp303_;
			ValaCCodeFunction* _tmp304_;
			ValaCCodeFunction* _tmp305_;
			ValaCCodeFunctionCall* _tmp306_;
			ValaCCodeExpressionStatement* _tmp307_;
			ValaCCodeExpressionStatement* _tmp308_;
			ValaCCodeFunctionCall* final_singleton_mutex_unlock = NULL;
			ValaCCodeIdentifier* _tmp309_;
			ValaCCodeIdentifier* _tmp310_;
			ValaCCodeFunctionCall* _tmp311_;
			ValaCCodeFunctionCall* _tmp312_;
			ValaCCodeFunctionCall* _tmp313_;
			const gchar* _tmp314_;
			ValaCCodeIdentifier* _tmp315_;
			ValaCCodeIdentifier* _tmp316_;
			ValaCCodeUnaryExpression* _tmp317_;
			ValaCCodeUnaryExpression* _tmp318_;
			ValaCCodeFunction* _tmp319_;
			ValaCCodeFunction* _tmp320_;
			ValaCCodeFunctionCall* _tmp321_;
			ValaCCodeExpressionStatement* _tmp322_;
			ValaCCodeExpressionStatement* _tmp323_;
			_tmp271_ = cl;
			_tmp272_ = vala_get_ccode_name ((ValaCodeNode*) _tmp271_);
			_tmp273_ = _tmp272_;
			_tmp274_ = g_strdup_printf ("%s_singleton__ref", _tmp273_);
			_tmp275_ = _tmp274_;
			_g_free0 (_tmp273_);
			singleton_ref_name = _tmp275_;
			_tmp276_ = cl;
			_tmp277_ = vala_get_ccode_name ((ValaCodeNode*) _tmp276_);
			_tmp278_ = _tmp277_;
			_tmp279_ = g_strdup_printf ("%s_singleton__lock", _tmp278_);
			_tmp280_ = _tmp279_;
			_g_free0 (_tmp278_);
			singleton_lock_name = _tmp280_;
			_tmp281_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp282_ = _tmp281_;
			_tmp283_ = singleton_ref_name;
			_tmp284_ = vala_ccode_identifier_new (_tmp283_);
			_tmp285_ = _tmp284_;
			_tmp286_ = vala_ccode_identifier_new ("obj");
			_tmp287_ = _tmp286_;
			vala_ccode_function_add_assignment (_tmp282_, (ValaCCodeExpression*) _tmp285_, (ValaCCodeExpression*) _tmp287_);
			_vala_ccode_node_unref0 (_tmp287_);
			_vala_ccode_node_unref0 (_tmp285_);
			_tmp288_ = vala_ccode_identifier_new ("g_object_add_weak_pointer");
			_tmp289_ = _tmp288_;
			_tmp290_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp289_);
			_tmp291_ = _tmp290_;
			_vala_ccode_node_unref0 (_tmp289_);
			set_weak_ref_to_volatile = _tmp291_;
			_tmp292_ = set_weak_ref_to_volatile;
			_tmp293_ = singleton_ref_name;
			_tmp294_ = vala_ccode_identifier_new (_tmp293_);
			_tmp295_ = _tmp294_;
			vala_ccode_function_call_add_argument (_tmp292_, (ValaCCodeExpression*) _tmp295_);
			_vala_ccode_node_unref0 (_tmp295_);
			_tmp296_ = set_weak_ref_to_volatile;
			_tmp297_ = singleton_ref_name;
			_tmp298_ = vala_ccode_identifier_new (_tmp297_);
			_tmp299_ = _tmp298_;
			_tmp300_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp299_);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp301_, "gpointer");
			_tmp303_ = _tmp302_;
			vala_ccode_function_call_add_argument (_tmp296_, (ValaCCodeExpression*) _tmp303_);
			_vala_ccode_node_unref0 (_tmp303_);
			_vala_ccode_node_unref0 (_tmp301_);
			_vala_ccode_node_unref0 (_tmp299_);
			_tmp304_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp305_ = _tmp304_;
			_tmp306_ = set_weak_ref_to_volatile;
			_tmp307_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp306_);
			_tmp308_ = _tmp307_;
			vala_ccode_function_add_statement (_tmp305_, (ValaCCodeNode*) _tmp308_);
			_vala_ccode_node_unref0 (_tmp308_);
			_tmp309_ = vala_ccode_identifier_new ("g_mutex_unlock");
			_tmp310_ = _tmp309_;
			_tmp311_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp310_);
			_tmp312_ = _tmp311_;
			_vala_ccode_node_unref0 (_tmp310_);
			final_singleton_mutex_unlock = _tmp312_;
			_tmp313_ = final_singleton_mutex_unlock;
			_tmp314_ = singleton_lock_name;
			_tmp315_ = vala_ccode_identifier_new (_tmp314_);
			_tmp316_ = _tmp315_;
			_tmp317_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp316_);
			_tmp318_ = _tmp317_;
			vala_ccode_function_call_add_argument (_tmp313_, (ValaCCodeExpression*) _tmp318_);
			_vala_ccode_node_unref0 (_tmp318_);
			_vala_ccode_node_unref0 (_tmp316_);
			_tmp319_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp320_ = _tmp319_;
			_tmp321_ = final_singleton_mutex_unlock;
			_tmp322_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp321_);
			_tmp323_ = _tmp322_;
			vala_ccode_function_add_statement (_tmp320_, (ValaCCodeNode*) _tmp323_);
			_vala_ccode_node_unref0 (_tmp323_);
			_vala_ccode_node_unref0 (final_singleton_mutex_unlock);
			_vala_ccode_node_unref0 (set_weak_ref_to_volatile);
			_g_free0 (singleton_lock_name);
			_g_free0 (singleton_ref_name);
		}
		_tmp324_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp325_ = _tmp324_;
		_tmp326_ = vala_ccode_identifier_new ("obj");
		_tmp327_ = _tmp326_;
		vala_ccode_function_add_return (_tmp325_, (ValaCCodeExpression*) _tmp327_);
		_vala_ccode_node_unref0 (_tmp327_);
		vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
		_tmp328_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp329_ = function;
		vala_ccode_file_add_function (_tmp328_, _tmp329_);
		vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
		_vala_ccode_node_unref0 (ccall);
		_vala_ccode_node_unref0 (ccast);
		_vala_ccode_node_unref0 (function);
	} else {
		ValaMemberBinding _tmp330_;
		ValaMemberBinding _tmp331_;
		_tmp330_ = vala_constructor_get_binding (c);
		_tmp331_ = _tmp330_;
		if (_tmp331_ == VALA_MEMBER_BINDING_CLASS) {
			ValaClass* _tmp332_;
			gboolean _tmp333_;
			gboolean _tmp334_;
			ValaCCodeBaseModuleEmitContext* _tmp337_;
			ValaBlock* _tmp338_;
			ValaBlock* _tmp339_;
			gboolean _tmp340_;
			gboolean _tmp341_;
			_tmp332_ = cl;
			_tmp333_ = vala_class_get_is_compact (_tmp332_);
			_tmp334_ = _tmp333_;
			if (_tmp334_) {
				ValaSourceReference* _tmp335_;
				ValaSourceReference* _tmp336_;
				_tmp335_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp336_ = _tmp335_;
				vala_report_error (_tmp336_, "class constructors are not supported in compact classes");
				vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
				_vala_code_node_unref0 (cl);
				return;
			}
			_tmp337_ = ((ValaCCodeBaseModule*) self)->base_init_context;
			vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp337_);
			_tmp338_ = vala_subroutine_get_body ((ValaSubroutine*) c);
			_tmp339_ = _tmp338_;
			vala_code_node_emit ((ValaCodeNode*) _tmp339_, (ValaCodeGenerator*) self);
			_tmp340_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
			_tmp341_ = _tmp340_;
			if (_tmp341_) {
				ValaCCodeFunction* _tmp342_;
				ValaCCodeFunction* _tmp343_;
				gint _tmp344_;
				gint _tmp345_;
				gchar* _tmp346_;
				gchar* _tmp347_;
				ValaCCodeConstant* _tmp348_;
				ValaCCodeConstant* _tmp349_;
				ValaCCodeVariableDeclarator* _tmp350_;
				ValaCCodeVariableDeclarator* _tmp351_;
				_tmp342_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp343_ = _tmp342_;
				_tmp344_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
				_tmp345_ = _tmp344_;
				_tmp346_ = g_strdup_printf ("_inner_error%d_", _tmp345_);
				_tmp347_ = _tmp346_;
				_tmp348_ = vala_ccode_constant_new ("NULL");
				_tmp349_ = _tmp348_;
				_tmp350_ = vala_ccode_variable_declarator_new_zero (_tmp347_, (ValaCCodeExpression*) _tmp349_, NULL);
				_tmp351_ = _tmp350_;
				vala_ccode_function_add_declaration (_tmp343_, "GError*", (ValaCCodeDeclarator*) _tmp351_, 0);
				_vala_ccode_node_unref0 (_tmp351_);
				_vala_ccode_node_unref0 (_tmp349_);
				_g_free0 (_tmp347_);
			}
			vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
		} else {
			ValaMemberBinding _tmp352_;
			ValaMemberBinding _tmp353_;
			_tmp352_ = vala_constructor_get_binding (c);
			_tmp353_ = _tmp352_;
			if (_tmp353_ == VALA_MEMBER_BINDING_STATIC) {
				ValaClass* _tmp354_;
				gboolean _tmp355_;
				gboolean _tmp356_;
				ValaCCodeBaseModuleEmitContext* _tmp359_;
				ValaBlock* _tmp360_;
				ValaBlock* _tmp361_;
				gboolean _tmp362_;
				gboolean _tmp363_;
				_tmp354_ = cl;
				_tmp355_ = vala_class_get_is_compact (_tmp354_);
				_tmp356_ = _tmp355_;
				if (_tmp356_) {
					ValaSourceReference* _tmp357_;
					ValaSourceReference* _tmp358_;
					_tmp357_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
					_tmp358_ = _tmp357_;
					vala_report_error (_tmp358_, "static constructors are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
					_vala_code_node_unref0 (cl);
					return;
				}
				_tmp359_ = ((ValaCCodeBaseModule*) self)->class_init_context;
				vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp359_);
				_tmp360_ = vala_subroutine_get_body ((ValaSubroutine*) c);
				_tmp361_ = _tmp360_;
				vala_code_node_emit ((ValaCodeNode*) _tmp361_, (ValaCodeGenerator*) self);
				_tmp362_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
				_tmp363_ = _tmp362_;
				if (_tmp363_) {
					ValaCCodeFunction* _tmp364_;
					ValaCCodeFunction* _tmp365_;
					gint _tmp366_;
					gint _tmp367_;
					gchar* _tmp368_;
					gchar* _tmp369_;
					ValaCCodeConstant* _tmp370_;
					ValaCCodeConstant* _tmp371_;
					ValaCCodeVariableDeclarator* _tmp372_;
					ValaCCodeVariableDeclarator* _tmp373_;
					_tmp364_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp365_ = _tmp364_;
					_tmp366_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
					_tmp367_ = _tmp366_;
					_tmp368_ = g_strdup_printf ("_inner_error%d_", _tmp367_);
					_tmp369_ = _tmp368_;
					_tmp370_ = vala_ccode_constant_new ("NULL");
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_ccode_variable_declarator_new_zero (_tmp369_, (ValaCCodeExpression*) _tmp371_, NULL);
					_tmp373_ = _tmp372_;
					vala_ccode_function_add_declaration (_tmp365_, "GError*", (ValaCCodeDeclarator*) _tmp373_, 0);
					_vala_ccode_node_unref0 (_tmp373_);
					_vala_ccode_node_unref0 (_tmp371_);
					_g_free0 (_tmp369_);
				}
				vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
			} else {
				ValaSourceReference* _tmp374_;
				ValaSourceReference* _tmp375_;
				_tmp374_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp375_ = _tmp374_;
				vala_report_error (_tmp375_, "internal error: constructors must have instance, class, or static bind" \
"ing");
			}
		}
	}
	vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
	_vala_code_node_unref0 (cl);
}

static gchar*
vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeBaseModule* base,
                                                            ValaDynamicProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* getter_cname = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeModifiers _tmp24_;
	ValaCCodeModifiers _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	ValaCCodeParameter* _tmp31_;
	ValaCCodeParameter* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaDataType* _tmp36_;
	ValaDataType* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	ValaCCodeVariableDeclarator* _tmp40_;
	ValaCCodeVariableDeclarator* _tmp41_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeUnaryExpression* _tmp55_;
	ValaCCodeUnaryExpression* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	ValaCCodeFunction* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeFunction* _tmp63_;
	ValaCCodeFunction* _tmp64_;
	ValaCCodeIdentifier* _tmp65_;
	ValaCCodeIdentifier* _tmp66_;
	ValaCCodeFile* _tmp67_;
	ValaCCodeFunction* _tmp68_;
	ValaCCodeFile* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_type_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_property_get_dynamic_type (prop);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_getter_cname ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->dynamic_property_id;
	self->priv->dynamic_property_id = _tmp13_ + 1;
	_tmp14_ = g_strdup_printf ("_dynamic_get_%s%d", _tmp12_, _tmp13_);
	getter_cname = _tmp14_;
	_tmp15_ = getter_cname;
	_tmp16_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_get_ccode_name ((ValaCodeNode*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_ccode_function_new (_tmp15_, _tmp19_);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	func = _tmp21_;
	_tmp22_ = func;
	_tmp23_ = func;
	_tmp24_ = vala_ccode_node_get_modifiers ((ValaCCodeNode*) _tmp23_);
	_tmp25_ = _tmp24_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp23_, _tmp25_ | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp26_ = func;
	_tmp27_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_ccode_parameter_new ("obj", _tmp30_);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp32_);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp30_);
	_tmp33_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_get_ccode_name ((ValaCodeNode*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp41_ = _tmp40_;
	vala_ccode_function_add_declaration (_tmp35_, _tmp39_, (ValaCCodeDeclarator*) _tmp41_, 0);
	_vala_ccode_node_unref0 (_tmp41_);
	_g_free0 (_tmp39_);
	_tmp42_ = vala_ccode_identifier_new ("g_object_get");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	call = _tmp45_;
	_tmp46_ = call;
	_tmp47_ = vala_ccode_identifier_new ("obj");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = call;
	_tmp50_ = vala_ccode_base_module_get_property_canonical_cconstant ((ValaCCodeBaseModule*) self, (ValaProperty*) prop);
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = call;
	_tmp53_ = vala_ccode_identifier_new ("result");
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp54_);
	_tmp56_ = _tmp55_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp56_);
	_vala_ccode_node_unref0 (_tmp56_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp57_ = call;
	_tmp58_ = vala_ccode_constant_new ("NULL");
	_tmp59_ = _tmp58_;
	vala_ccode_function_call_add_argument (_tmp57_, (ValaCCodeExpression*) _tmp59_);
	_vala_ccode_node_unref0 (_tmp59_);
	_tmp60_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp61_ = _tmp60_;
	_tmp62_ = call;
	vala_ccode_function_add_expression (_tmp61_, (ValaCCodeExpression*) _tmp62_);
	_tmp63_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_identifier_new ("result");
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_return (_tmp64_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp67_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp68_ = func;
	vala_ccode_file_add_function_declaration (_tmp67_, _tmp68_);
	_tmp69_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp70_ = func;
	vala_ccode_file_add_function (_tmp69_, _tmp70_);
	result = getter_cname;
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (func);
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeBaseModule* base,
                                                            ValaDynamicProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* setter_cname = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeFunction* _tmp18_;
	ValaCCodeModifiers _tmp19_;
	ValaCCodeModifiers _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	ValaCCodeParameter* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeFunction* _tmp28_;
	ValaDataType* _tmp29_;
	ValaDataType* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	ValaCCodeParameter* _tmp33_;
	ValaCCodeParameter* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp36_;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeIdentifier* _tmp41_;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeFunctionCall* _tmp43_;
	ValaCCodeConstant* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunction* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunctionCall* _tmp54_;
	ValaCCodeFile* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	ValaCCodeFile* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_type_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_property_get_dynamic_type (prop);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_setter_cname ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->dynamic_property_id;
	self->priv->dynamic_property_id = _tmp13_ + 1;
	_tmp14_ = g_strdup_printf ("_dynamic_set_%s%d", _tmp12_, _tmp13_);
	setter_cname = _tmp14_;
	_tmp15_ = setter_cname;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "void");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = func;
	_tmp19_ = vala_ccode_node_get_modifiers ((ValaCCodeNode*) _tmp18_);
	_tmp20_ = _tmp19_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp18_, _tmp20_ | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp21_ = func;
	_tmp22_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_get_ccode_name ((ValaCodeNode*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_parameter_new ("obj", _tmp25_);
	_tmp27_ = _tmp26_;
	vala_ccode_function_add_parameter (_tmp21_, _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_g_free0 (_tmp25_);
	_tmp28_ = func;
	_tmp29_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_get_ccode_name ((ValaCodeNode*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_ccode_parameter_new ("value", _tmp32_);
	_tmp34_ = _tmp33_;
	vala_ccode_function_add_parameter (_tmp28_, _tmp34_);
	_vala_ccode_node_unref0 (_tmp34_);
	_g_free0 (_tmp32_);
	_tmp35_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp35_);
	_tmp36_ = vala_ccode_identifier_new ("g_object_set");
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp37_);
	_tmp39_ = _tmp38_;
	_vala_ccode_node_unref0 (_tmp37_);
	call = _tmp39_;
	_tmp40_ = call;
	_tmp41_ = vala_ccode_identifier_new ("obj");
	_tmp42_ = _tmp41_;
	vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp42_);
	_vala_ccode_node_unref0 (_tmp42_);
	_tmp43_ = call;
	_tmp44_ = vala_ccode_base_module_get_property_canonical_cconstant ((ValaCCodeBaseModule*) self, (ValaProperty*) prop);
	_tmp45_ = _tmp44_;
	vala_ccode_function_call_add_argument (_tmp43_, (ValaCCodeExpression*) _tmp45_);
	_vala_ccode_node_unref0 (_tmp45_);
	_tmp46_ = call;
	_tmp47_ = vala_ccode_identifier_new ("value");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = call;
	_tmp50_ = vala_ccode_constant_new ("NULL");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp53_ = _tmp52_;
	_tmp54_ = call;
	vala_ccode_function_add_expression (_tmp53_, (ValaCCodeExpression*) _tmp54_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp55_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp56_ = func;
	vala_ccode_file_add_function_declaration (_tmp55_, _tmp56_);
	_tmp57_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp58_ = func;
	vala_ccode_file_add_function (_tmp57_, _tmp58_);
	result = setter_cname;
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (func);
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeBaseModule* base,
                                                   ValaDynamicSignal* node)
{
	ValaGObjectModule * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) node);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->signal_wrapper_id;
	self->priv->signal_wrapper_id = _tmp2_ + 1;
	_tmp3_ = g_strdup_printf ("dynamic_%s%d_", _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeBaseModule* base,
                                                                  ValaDynamicSignal* sig)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* connect_wrapper_name = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFile* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFile* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp1_ = vala_dynamic_signal_get_dynamic_type (sig);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_type_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_signal_get_dynamic_type (sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), sig);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_ccode_base_module_get_dynamic_signal_cname ((ValaCCodeBaseModule*) self, sig);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("_%sconnect", _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	connect_wrapper_name = _tmp14_;
	_tmp15_ = connect_wrapper_name;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "gulong");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = vala_ccode_parameter_new ("obj", "gpointer");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = func;
	_tmp21_ = vala_ccode_parameter_new ("signal_name", "const char *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = func;
	_tmp24_ = vala_ccode_parameter_new ("handler", "GCallback");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = func;
	_tmp27_ = vala_ccode_parameter_new ("data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	vala_gobject_module_generate_gobject_connect_wrapper (self, sig, FALSE);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp31_ = func;
	vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
	_tmp32_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp33_ = func;
	vala_ccode_file_add_function (_tmp32_, _tmp33_);
	result = connect_wrapper_name;
	_vala_ccode_node_unref0 (func);
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name (ValaCCodeBaseModule* base,
                                                                        ValaDynamicSignal* sig)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* connect_wrapper_name = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFile* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFile* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp1_ = vala_dynamic_signal_get_dynamic_type (sig);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_type_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_signal_get_dynamic_type (sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), sig);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_ccode_base_module_get_dynamic_signal_cname ((ValaCCodeBaseModule*) self, sig);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("_%sconnect_after", _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	connect_wrapper_name = _tmp14_;
	_tmp15_ = connect_wrapper_name;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "gulong");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = vala_ccode_parameter_new ("obj", "gpointer");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = func;
	_tmp21_ = vala_ccode_parameter_new ("signal_name", "const char *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = func;
	_tmp24_ = vala_ccode_parameter_new ("handler", "GCallback");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = func;
	_tmp27_ = vala_ccode_parameter_new ("data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	vala_gobject_module_generate_gobject_connect_wrapper (self, sig, TRUE);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp31_ = func;
	vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
	_tmp32_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp33_ = func;
	vala_ccode_file_add_function (_tmp32_, _tmp33_);
	result = connect_wrapper_name;
	_vala_ccode_node_unref0 (func);
	return result;
}

static void
vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self,
                                                      ValaDynamicSignal* sig,
                                                      gboolean after)
{
	ValaMethod* m = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaMethod* _tmp4_;
	gchar* connect_func = NULL;
	gchar* _tmp5_;
	ValaMethod* _tmp6_;
	ValaMemberBinding _tmp7_;
	ValaMemberBinding _tmp8_;
	ValaCCodeFunctionCall* call = NULL;
	const gchar* _tmp11_;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeIdentifier* _tmp27_;
	ValaMethod* _tmp28_;
	ValaMemberBinding _tmp29_;
	ValaMemberBinding _tmp30_;
	ValaCCodeFunction* _tmp37_;
	ValaCCodeFunction* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_dynamic_signal_get_handler (sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_symbol_reference (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp4_;
	vala_code_node_accept ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	_tmp5_ = g_strdup ("g_signal_connect_object");
	connect_func = _tmp5_;
	_tmp6_ = m;
	_tmp7_ = vala_method_get_binding (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != VALA_MEMBER_BINDING_INSTANCE) {
		if (!after) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("g_signal_connect");
			_g_free0 (connect_func);
			connect_func = _tmp9_;
		} else {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("g_signal_connect_after");
			_g_free0 (connect_func);
			connect_func = _tmp10_;
		}
	}
	_tmp11_ = connect_func;
	_tmp12_ = vala_ccode_identifier_new (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_ccode_node_unref0 (_tmp13_);
	call = _tmp15_;
	_tmp16_ = call;
	_tmp17_ = vala_ccode_identifier_new ("obj");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = call;
	_tmp20_ = vala_ccode_identifier_new ("signal_name");
	_tmp21_ = _tmp20_;
	vala_ccode_function_call_add_argument (_tmp19_, (ValaCCodeExpression*) _tmp21_);
	_vala_ccode_node_unref0 (_tmp21_);
	_tmp22_ = call;
	_tmp23_ = vala_ccode_identifier_new ("handler");
	_tmp24_ = _tmp23_;
	vala_ccode_function_call_add_argument (_tmp22_, (ValaCCodeExpression*) _tmp24_);
	_vala_ccode_node_unref0 (_tmp24_);
	_tmp25_ = call;
	_tmp26_ = vala_ccode_identifier_new ("data");
	_tmp27_ = _tmp26_;
	vala_ccode_function_call_add_argument (_tmp25_, (ValaCCodeExpression*) _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_tmp28_ = m;
	_tmp29_ = vala_method_get_binding (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == VALA_MEMBER_BINDING_INSTANCE) {
		if (!after) {
			ValaCCodeFunctionCall* _tmp31_;
			ValaCCodeConstant* _tmp32_;
			ValaCCodeConstant* _tmp33_;
			_tmp31_ = call;
			_tmp32_ = vala_ccode_constant_new ("0");
			_tmp33_ = _tmp32_;
			vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
			_vala_ccode_node_unref0 (_tmp33_);
		} else {
			ValaCCodeFunctionCall* _tmp34_;
			ValaCCodeConstant* _tmp35_;
			ValaCCodeConstant* _tmp36_;
			_tmp34_ = call;
			_tmp35_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp36_ = _tmp35_;
			vala_ccode_function_call_add_argument (_tmp34_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
		}
	}
	_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = call;
	vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp39_);
	_vala_ccode_node_unref0 (call);
	_g_free0 (connect_func);
	_vala_code_node_unref0 (m);
}

static void
vala_gobject_module_real_visit_property (ValaCodeVisitor* base,
                                         ValaProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaSemanticAnalyzer* _tmp3_;
	ValaSemanticAnalyzer* _tmp4_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (prop != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_property ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
	_tmp1_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_analyzer (_tmp2_);
	_tmp4_ = _tmp3_;
	if (vala_semantic_analyzer_is_gobject_property (_tmp4_, prop)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
		_tmp6_ = _tmp5_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_CLASS);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeEnum* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		ValaCCodeEnumValue* _tmp12_;
		ValaCCodeEnumValue* _tmp13_;
		_tmp7_ = ((ValaCCodeBaseModule*) self)->prop_enum;
		_tmp8_ = vala_get_ccode_upper_case_name ((ValaSymbol*) prop, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("%s_PROPERTY", _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_ccode_enum_value_new (_tmp11_, NULL);
		_tmp13_ = _tmp12_;
		vala_ccode_enum_add_value (_tmp7_, _tmp13_);
		_vala_ccode_node_unref0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
}

static void
vala_gobject_module_real_visit_method_call (ValaCodeVisitor* base,
                                            ValaMethodCall* expr)
{
	ValaGObjectModule * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaMemberAccess* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		ValaMemberAccess* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp3_ = _tmp2_;
		vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp3_);
		_tmp4_ = vala_method_call_get_call (expr);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
		ma = _tmp6_;
		_tmp9_ = ma;
		_tmp10_ = vala_member_access_get_inner (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ != NULL) {
			ValaMemberAccess* _tmp12_;
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaTypeSymbol* _tmp17_;
			_tmp12_ = ma;
			_tmp13_ = vala_member_access_get_inner (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = ((ValaCCodeBaseModule*) self)->gobject_type;
			_tmp8_ = _tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_SYMBOL, ValaSymbol);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			ValaMemberAccess* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp21_ = ma;
			_tmp22_ = vala_member_access_get_member_name (_tmp21_);
			_tmp23_ = _tmp22_;
			if (g_strcmp0 (_tmp23_, "new") == 0) {
				_tmp20_ = TRUE;
			} else {
				ValaMemberAccess* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				_tmp24_ = ma;
				_tmp25_ = vala_member_access_get_member_name (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp20_ = g_strcmp0 (_tmp26_, "newv") == 0;
			}
			if (_tmp20_) {
				_tmp19_ = TRUE;
			} else {
				ValaMemberAccess* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				_tmp27_ = ma;
				_tmp28_ = vala_member_access_get_member_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp19_ = g_strcmp0 (_tmp29_, "new_valist") == 0;
			}
			if (_tmp19_) {
				_tmp18_ = TRUE;
			} else {
				ValaMemberAccess* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp30_ = ma;
				_tmp31_ = vala_member_access_get_member_name (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp18_ = g_strcmp0 (_tmp32_, "new_with_properties") == 0;
			}
			_tmp7_ = _tmp18_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValaCCodeFunctionCall* initiallyunowned_ccall = NULL;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeFunctionCall* _tmp35_;
			ValaCCodeFunctionCall* _tmp36_;
			ValaCCodeFunctionCall* _tmp37_;
			ValaCCodeExpression* _tmp38_;
			ValaCCodeFunctionCall* sink_ref_ccall = NULL;
			ValaCCodeIdentifier* _tmp39_;
			ValaCCodeIdentifier* _tmp40_;
			ValaCCodeFunctionCall* _tmp41_;
			ValaCCodeFunctionCall* _tmp42_;
			ValaCCodeFunctionCall* _tmp43_;
			ValaCCodeExpression* _tmp44_;
			ValaCCodeConditionalExpression* cexpr = NULL;
			ValaCCodeFunctionCall* _tmp45_;
			ValaCCodeFunctionCall* _tmp46_;
			ValaCCodeExpression* _tmp47_;
			ValaCCodeConditionalExpression* _tmp48_;
			ValaDataType* _tmp49_;
			ValaDataType* _tmp50_;
			ValaCCodeConditionalExpression* _tmp51_;
			ValaGLibValue* _tmp52_;
			ValaGLibValue* _tmp53_;
			ValaTargetValue* _tmp54_;
			ValaTargetValue* _tmp55_;
			VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), expr);
			_tmp33_ = vala_ccode_identifier_new ("G_IS_INITIALLY_UNOWNED");
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp34_);
			_tmp36_ = _tmp35_;
			_vala_ccode_node_unref0 (_tmp34_);
			initiallyunowned_ccall = _tmp36_;
			_tmp37_ = initiallyunowned_ccall;
			_tmp38_ = vala_get_cvalue ((ValaExpression*) expr);
			vala_ccode_function_call_add_argument (_tmp37_, _tmp38_);
			_tmp39_ = vala_ccode_identifier_new ("g_object_ref_sink");
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp40_);
			_tmp42_ = _tmp41_;
			_vala_ccode_node_unref0 (_tmp40_);
			sink_ref_ccall = _tmp42_;
			_tmp43_ = sink_ref_ccall;
			_tmp44_ = vala_get_cvalue ((ValaExpression*) expr);
			vala_ccode_function_call_add_argument (_tmp43_, _tmp44_);
			_tmp45_ = initiallyunowned_ccall;
			_tmp46_ = sink_ref_ccall;
			_tmp47_ = vala_get_cvalue ((ValaExpression*) expr);
			_tmp48_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp45_, (ValaCCodeExpression*) _tmp46_, _tmp47_);
			cexpr = _tmp48_;
			_tmp49_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp50_ = _tmp49_;
			_tmp51_ = cexpr;
			_tmp52_ = vala_glib_value_new (_tmp50_, (ValaCCodeExpression*) _tmp51_, FALSE);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp53_, (ValaCodeNode*) expr, NULL);
			_tmp55_ = _tmp54_;
			vala_expression_set_target_value ((ValaExpression*) expr, _tmp55_);
			_vala_target_value_unref0 (_tmp55_);
			_vala_target_value_unref0 (_tmp53_);
			_vala_ccode_node_unref0 (cexpr);
			_vala_ccode_node_unref0 (sink_ref_ccall);
			_vala_ccode_node_unref0 (initiallyunowned_ccall);
			_vala_code_node_unref0 (ma);
			return;
		} else {
			ValaMemberAccess* _tmp56_;
			ValaSymbol* _tmp57_;
			ValaSymbol* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			_tmp56_ = ma;
			_tmp57_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = ((ValaCCodeBaseModule*) self)->gobject_type;
			if (_tmp58_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				{
					ValaList* _arg_list = NULL;
					ValaList* _tmp60_;
					ValaList* _tmp61_;
					gint _arg_size = 0;
					ValaList* _tmp62_;
					gint _tmp63_;
					gint _tmp64_;
					gint _arg_index = 0;
					_tmp60_ = vala_method_call_get_argument_list (expr);
					_tmp61_ = _vala_iterable_ref0 (_tmp60_);
					_arg_list = _tmp61_;
					_tmp62_ = _arg_list;
					_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
					_tmp64_ = _tmp63_;
					_arg_size = _tmp64_;
					_arg_index = -1;
					while (TRUE) {
						gint _tmp65_;
						gint _tmp66_;
						ValaExpression* arg = NULL;
						ValaList* _tmp67_;
						gpointer _tmp68_;
						ValaNamedArgument* named_argument = NULL;
						ValaExpression* _tmp69_;
						ValaNamedArgument* _tmp70_;
						ValaNamedArgument* _tmp71_;
						ValaProperty* prop = NULL;
						ValaClass* _tmp75_;
						ValaClass* _tmp76_;
						ValaNamedArgument* _tmp77_;
						const gchar* _tmp78_;
						const gchar* _tmp79_;
						ValaSymbol* _tmp80_;
						ValaProperty* _tmp81_;
						ValaProperty* _tmp82_;
						ValaCodeContext* _tmp95_;
						ValaCodeContext* _tmp96_;
						ValaSemanticAnalyzer* _tmp97_;
						ValaSemanticAnalyzer* _tmp98_;
						ValaProperty* _tmp99_;
						ValaExpression* _tmp108_;
						ValaDataType* _tmp109_;
						ValaDataType* _tmp110_;
						ValaProperty* _tmp111_;
						ValaDataType* _tmp112_;
						ValaDataType* _tmp113_;
						_arg_index = _arg_index + 1;
						_tmp65_ = _arg_index;
						_tmp66_ = _arg_size;
						if (!(_tmp65_ < _tmp66_)) {
							break;
						}
						_tmp67_ = _arg_list;
						_tmp68_ = vala_list_get (_tmp67_, _arg_index);
						arg = (ValaExpression*) _tmp68_;
						_tmp69_ = arg;
						_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, VALA_TYPE_NAMED_ARGUMENT) ? ((ValaNamedArgument*) _tmp69_) : NULL);
						named_argument = _tmp70_;
						_tmp71_ = named_argument;
						if (_tmp71_ == NULL) {
							ValaExpression* _tmp72_;
							ValaSourceReference* _tmp73_;
							ValaSourceReference* _tmp74_;
							_tmp72_ = arg;
							_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp72_);
							_tmp74_ = _tmp73_;
							vala_report_error (_tmp74_, "Named argument expected");
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp75_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp76_ = _tmp75_;
						_tmp77_ = named_argument;
						_tmp78_ = vala_named_argument_get_name (_tmp77_);
						_tmp79_ = _tmp78_;
						_tmp80_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp76_, _tmp79_);
						_tmp81_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp80_) : NULL;
						if (_tmp81_ == NULL) {
							_vala_code_node_unref0 (_tmp80_);
						}
						prop = _tmp81_;
						_tmp82_ = prop;
						if (_tmp82_ == NULL) {
							ValaExpression* _tmp83_;
							ValaSourceReference* _tmp84_;
							ValaSourceReference* _tmp85_;
							ValaNamedArgument* _tmp86_;
							const gchar* _tmp87_;
							const gchar* _tmp88_;
							ValaClass* _tmp89_;
							ValaClass* _tmp90_;
							gchar* _tmp91_;
							gchar* _tmp92_;
							gchar* _tmp93_;
							gchar* _tmp94_;
							_tmp83_ = arg;
							_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp83_);
							_tmp85_ = _tmp84_;
							_tmp86_ = named_argument;
							_tmp87_ = vala_named_argument_get_name (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp89_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
							_tmp90_ = _tmp89_;
							_tmp91_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp90_);
							_tmp92_ = _tmp91_;
							_tmp93_ = g_strdup_printf ("Property `%s' not found in `%s'", _tmp88_, _tmp92_);
							_tmp94_ = _tmp93_;
							vala_report_error (_tmp85_, _tmp94_);
							_g_free0 (_tmp94_);
							_g_free0 (_tmp92_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp95_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
						_tmp96_ = _tmp95_;
						_tmp97_ = vala_code_context_get_analyzer (_tmp96_);
						_tmp98_ = _tmp97_;
						_tmp99_ = prop;
						if (!vala_semantic_analyzer_is_gobject_property (_tmp98_, _tmp99_)) {
							ValaExpression* _tmp100_;
							ValaSourceReference* _tmp101_;
							ValaSourceReference* _tmp102_;
							ValaNamedArgument* _tmp103_;
							const gchar* _tmp104_;
							const gchar* _tmp105_;
							gchar* _tmp106_;
							gchar* _tmp107_;
							_tmp100_ = arg;
							_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp100_);
							_tmp102_ = _tmp101_;
							_tmp103_ = named_argument;
							_tmp104_ = vala_named_argument_get_name (_tmp103_);
							_tmp105_ = _tmp104_;
							_tmp106_ = g_strdup_printf ("Property `%s' not supported in Object (property: value) constructor ch" \
"ain up", _tmp105_);
							_tmp107_ = _tmp106_;
							vala_report_error (_tmp102_, _tmp107_);
							_g_free0 (_tmp107_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp108_ = arg;
						_tmp109_ = vala_expression_get_value_type (_tmp108_);
						_tmp110_ = _tmp109_;
						_tmp111_ = prop;
						_tmp112_ = vala_property_get_property_type (_tmp111_);
						_tmp113_ = _tmp112_;
						if (!vala_data_type_compatible (_tmp110_, _tmp113_)) {
							ValaExpression* _tmp114_;
							ValaSourceReference* _tmp115_;
							ValaSourceReference* _tmp116_;
							ValaExpression* _tmp117_;
							ValaDataType* _tmp118_;
							ValaDataType* _tmp119_;
							gchar* _tmp120_;
							gchar* _tmp121_;
							ValaProperty* _tmp122_;
							ValaDataType* _tmp123_;
							ValaDataType* _tmp124_;
							gchar* _tmp125_;
							gchar* _tmp126_;
							gchar* _tmp127_;
							gchar* _tmp128_;
							_tmp114_ = arg;
							_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp114_);
							_tmp116_ = _tmp115_;
							_tmp117_ = arg;
							_tmp118_ = vala_expression_get_value_type (_tmp117_);
							_tmp119_ = _tmp118_;
							_tmp120_ = vala_code_node_to_string ((ValaCodeNode*) _tmp119_);
							_tmp121_ = _tmp120_;
							_tmp122_ = prop;
							_tmp123_ = vala_property_get_property_type (_tmp122_);
							_tmp124_ = _tmp123_;
							_tmp125_ = vala_code_node_to_string ((ValaCodeNode*) _tmp124_);
							_tmp126_ = _tmp125_;
							_tmp127_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp121_, _tmp126_);
							_tmp128_ = _tmp127_;
							vala_report_error (_tmp116_, _tmp128_);
							_g_free0 (_tmp128_);
							_g_free0 (_tmp126_);
							_g_free0 (_tmp121_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_vala_code_node_unref0 (prop);
						_vala_code_node_unref0 (named_argument);
						_vala_code_node_unref0 (arg);
					}
					_vala_iterable_unref0 (_arg_list);
				}
			}
		}
		vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
		_vala_code_node_unref0 (ma);
	}
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), expr);
}

ValaGObjectModule*
vala_gobject_module_construct (GType object_type)
{
	ValaGObjectModule* self = NULL;
	self = (ValaGObjectModule*) vala_gtype_module_construct (object_type);
	return self;
}

ValaGObjectModule*
vala_gobject_module_new (void)
{
	return vala_gobject_module_construct (VALA_TYPE_GOBJECT_MODULE);
}

static void
vala_gobject_module_class_init (ValaGObjectModuleClass * klass,
                                gpointer klass_data)
{
	vala_gobject_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gobject_module_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGObjectModule_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_gobject_module_real_visit_class;
	((ValaGTypeModuleClass *) klass)->generate_class_init = (void (*) (ValaGTypeModule*, ValaClass*)) vala_gobject_module_real_generate_class_init;
	((ValaCodeVisitorClass *) klass)->visit_constructor = (void (*) (ValaCodeVisitor*, ValaConstructor*)) vala_gobject_module_real_visit_constructor;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_property_getter_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicProperty*)) vala_gobject_module_real_get_dynamic_property_getter_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_property_setter_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicProperty*)) vala_gobject_module_real_get_dynamic_property_setter_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_connect_wrapper_name = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_connect_after_wrapper_name = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_gobject_module_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_gobject_module_real_visit_method_call;
}

static void
vala_gobject_module_instance_init (ValaGObjectModule * self,
                                   gpointer klass)
{
	self->priv = vala_gobject_module_get_instance_private (self);
}

static void
vala_gobject_module_finalize (ValaCodeVisitor * obj)
{
	ValaGObjectModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->finalize (obj);
}

static GType
vala_gobject_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGObjectModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gobject_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGObjectModule), 0, (GInstanceInitFunc) vala_gobject_module_instance_init, NULL };
	GType vala_gobject_module_type_id;
	vala_gobject_module_type_id = g_type_register_static (VALA_TYPE_GTYPE_MODULE, "ValaGObjectModule", &g_define_type_info, 0);
	ValaGObjectModule_private_offset = g_type_add_instance_private (vala_gobject_module_type_id, sizeof (ValaGObjectModulePrivate));
	return vala_gobject_module_type_id;
}

GType
vala_gobject_module_get_type (void)
{
	static volatile gsize vala_gobject_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gobject_module_type_id__volatile)) {
		GType vala_gobject_module_type_id;
		vala_gobject_module_type_id = vala_gobject_module_get_type_once ();
		g_once_init_leave (&vala_gobject_module_type_id__volatile, vala_gobject_module_type_id);
	}
	return vala_gobject_module_type_id__volatile;
}

