/* rygel-player-controller.c generated by valac 0.48.5, the Vala compiler
 * generated from rygel-player-controller.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2014 Atlantic PuffinPack AB.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerIface))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerIface RygelPlayerControllerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelPlayerControllerIface {
	GTypeInterface parent_iface;
	gboolean (*next) (RygelPlayerController* self);
	gboolean (*previous) (RygelPlayerController* self);
	void (*set_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	void (*set_next_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_next_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	gboolean (*is_play_mode_valid) (RygelPlayerController* self, const gchar* play_mode);
	const gchar* (*get_playback_state) (RygelPlayerController* self);
	void (*set_playback_state) (RygelPlayerController* self, const gchar* value);
	guint (*get_n_tracks) (RygelPlayerController* self);
	void (*set_n_tracks) (RygelPlayerController* self, guint value);
	guint (*get_track) (RygelPlayerController* self);
	void (*set_track) (RygelPlayerController* self, guint value);
	gchar* (*get_uri) (RygelPlayerController* self);
	void (*set_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_metadata) (RygelPlayerController* self);
	void (*set_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_uri) (RygelPlayerController* self);
	void (*set_track_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_metadata) (RygelPlayerController* self);
	void (*set_track_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_uri) (RygelPlayerController* self);
	void (*set_next_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_metadata) (RygelPlayerController* self);
	void (*set_next_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_current_transport_actions) (RygelPlayerController* self);
	const gchar* (*get_play_mode) (RygelPlayerController* self);
	void (*set_play_mode) (RygelPlayerController* self, const gchar* value);
	gboolean (*get_can_pause) (RygelPlayerController* self);
};

GType rygel_player_controller_get_type (void) G_GNUC_CONST;
gboolean rygel_player_controller_next (RygelPlayerController* self);
gboolean rygel_player_controller_previous (RygelPlayerController* self);
void rygel_player_controller_set_single_play_uri (RygelPlayerController* self,
                                                  const gchar* uri,
                                                  const gchar* metadata,
                                                  const gchar* mime,
                                                  const gchar* features);
void rygel_player_controller_set_playlist_uri (RygelPlayerController* self,
                                               const gchar* uri,
                                               const gchar* metadata,
                                               GUPnPMediaCollection* collection);
void rygel_player_controller_set_next_single_play_uri (RygelPlayerController* self,
                                                       const gchar* uri,
                                                       const gchar* metadata,
                                                       const gchar* mime,
                                                       const gchar* features);
void rygel_player_controller_set_next_playlist_uri (RygelPlayerController* self,
                                                    const gchar* uri,
                                                    const gchar* metadata,
                                                    GUPnPMediaCollection* collection);
gboolean rygel_player_controller_is_play_mode_valid (RygelPlayerController* self,
                                                     const gchar* play_mode);
gchar* rygel_player_controller_unescape (RygelPlayerController* self,
                                         const gchar* input);
const gchar* rygel_player_controller_get_playback_state (RygelPlayerController* self);
void rygel_player_controller_set_playback_state (RygelPlayerController* self,
                                                 const gchar* value);
guint rygel_player_controller_get_n_tracks (RygelPlayerController* self);
void rygel_player_controller_set_n_tracks (RygelPlayerController* self,
                                           guint value);
guint rygel_player_controller_get_track (RygelPlayerController* self);
void rygel_player_controller_set_track (RygelPlayerController* self,
                                        guint value);
gchar* rygel_player_controller_get_uri (RygelPlayerController* self);
void rygel_player_controller_set_uri (RygelPlayerController* self,
                                      const gchar* value);
gchar* rygel_player_controller_get_metadata (RygelPlayerController* self);
void rygel_player_controller_set_metadata (RygelPlayerController* self,
                                           const gchar* value);
gchar* rygel_player_controller_get_track_uri (RygelPlayerController* self);
void rygel_player_controller_set_track_uri (RygelPlayerController* self,
                                            const gchar* value);
gchar* rygel_player_controller_get_track_metadata (RygelPlayerController* self);
void rygel_player_controller_set_track_metadata (RygelPlayerController* self,
                                                 const gchar* value);
gchar* rygel_player_controller_get_next_uri (RygelPlayerController* self);
void rygel_player_controller_set_next_uri (RygelPlayerController* self,
                                           const gchar* value);
gchar* rygel_player_controller_get_next_metadata (RygelPlayerController* self);
void rygel_player_controller_set_next_metadata (RygelPlayerController* self,
                                                const gchar* value);
gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self);
const gchar* rygel_player_controller_get_play_mode (RygelPlayerController* self);
void rygel_player_controller_set_play_mode (RygelPlayerController* self,
                                            const gchar* value);
gboolean rygel_player_controller_get_can_pause (RygelPlayerController* self);
static GType rygel_player_controller_get_type_once (void);

gboolean
rygel_player_controller_next (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->next (self);
}

gboolean
rygel_player_controller_previous (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->previous (self);
}

void
rygel_player_controller_set_single_play_uri (RygelPlayerController* self,
                                             const gchar* uri,
                                             const gchar* metadata,
                                             const gchar* mime,
                                             const gchar* features)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_single_play_uri (self, uri, metadata, mime, features);
}

void
rygel_player_controller_set_playlist_uri (RygelPlayerController* self,
                                          const gchar* uri,
                                          const gchar* metadata,
                                          GUPnPMediaCollection* collection)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_playlist_uri (self, uri, metadata, collection);
}

void
rygel_player_controller_set_next_single_play_uri (RygelPlayerController* self,
                                                  const gchar* uri,
                                                  const gchar* metadata,
                                                  const gchar* mime,
                                                  const gchar* features)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_next_single_play_uri (self, uri, metadata, mime, features);
}

void
rygel_player_controller_set_next_playlist_uri (RygelPlayerController* self,
                                               const gchar* uri,
                                               const gchar* metadata,
                                               GUPnPMediaCollection* collection)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_next_playlist_uri (self, uri, metadata, collection);
}

gboolean
rygel_player_controller_is_play_mode_valid (RygelPlayerController* self,
                                            const gchar* play_mode)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->is_play_mode_valid (self, play_mode);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
rygel_player_controller_unescape (RygelPlayerController* self,
                                  const gchar* input)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = string_replace (input, "&quot;", "\"");
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	_tmp2_ = string_replace (_tmp1_, "&lt;", "<");
	_g_free0 (_result_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	_tmp4_ = string_replace (_tmp3_, "&gt;", ">");
	_g_free0 (_result_);
	_result_ = _tmp4_;
	_tmp5_ = _result_;
	_tmp6_ = string_replace (_tmp5_, "&apos;", "'");
	_g_free0 (_result_);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	_tmp8_ = string_replace (_tmp7_, "&amp;", "&");
	_g_free0 (_result_);
	_result_ = _tmp8_;
	result = _result_;
	return result;
}

const gchar*
rygel_player_controller_get_playback_state (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_playback_state (self);
}

void
rygel_player_controller_set_playback_state (RygelPlayerController* self,
                                            const gchar* value)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_playback_state (self, value);
}

guint
rygel_player_controller_get_n_tracks (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, 0U);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_n_tracks (self);
}

void
rygel_player_controller_set_n_tracks (RygelPlayerController* self,
                                      guint value)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_n_tracks (self, value);
}

guint
rygel_player_controller_get_track (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, 0U);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_track (self);
}

void
rygel_player_controller_set_track (RygelPlayerController* self,
                                   guint value)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_track (self, value);
}

gchar*
rygel_player_controller_get_uri (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_uri (self);
}

void
rygel_player_controller_set_uri (RygelPlayerController* self,
                                 const gchar* value)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_uri (self, value);
}

gchar*
rygel_player_controller_get_metadata (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_metadata (self);
}

void
rygel_player_controller_set_metadata (RygelPlayerController* self,
                                      const gchar* value)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_metadata (self, value);
}

gchar*
rygel_player_controller_get_track_uri (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_track_uri (self);
}

void
rygel_player_controller_set_track_uri (RygelPlayerController* self,
                                       const gchar* value)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_track_uri (self, value);
}

gchar*
rygel_player_controller_get_track_metadata (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_track_metadata (self);
}

void
rygel_player_controller_set_track_metadata (RygelPlayerController* self,
                                            const gchar* value)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_track_metadata (self, value);
}

gchar*
rygel_player_controller_get_next_uri (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_next_uri (self);
}

void
rygel_player_controller_set_next_uri (RygelPlayerController* self,
                                      const gchar* value)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_next_uri (self, value);
}

gchar*
rygel_player_controller_get_next_metadata (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_next_metadata (self);
}

void
rygel_player_controller_set_next_metadata (RygelPlayerController* self,
                                           const gchar* value)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_next_metadata (self, value);
}

gchar*
rygel_player_controller_get_current_transport_actions (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_current_transport_actions (self);
}

const gchar*
rygel_player_controller_get_play_mode (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_play_mode (self);
}

void
rygel_player_controller_set_play_mode (RygelPlayerController* self,
                                       const gchar* value)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_play_mode (self, value);
}

gboolean
rygel_player_controller_get_can_pause (RygelPlayerController* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_can_pause (self);
}

static void
rygel_player_controller_default_init (RygelPlayerControllerIface * iface,
                                      gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("track-uri", "track-uri", "track-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("track-metadata", "track-metadata", "track-metadata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("next-uri", "next-uri", "next-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("next-metadata", "next-metadata", "next-metadata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("current-transport-actions", "current-transport-actions", "current-transport-actions", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("play-mode", "play-mode", "play-mode", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_boolean ("can-pause", "can-pause", "can-pause", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

/**
 * This class keeps track of global states that are not dependant on the
 * RygelMediaPlayer.
 *
 * These states are:
 * # URI
 * # MetaData
 * # Number of tracks
 * # Current track
 * # Playback state
 *
 * In case of playlists this class will also control the player. It needs to
 * proxy the playback state to react on end of item to be able to switch to
 * the next item.
 */
static GType
rygel_player_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelPlayerControllerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_player_controller_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType rygel_player_controller_type_id;
	rygel_player_controller_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelPlayerController", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (rygel_player_controller_type_id, G_TYPE_OBJECT);
	return rygel_player_controller_type_id;
}

GType
rygel_player_controller_get_type (void)
{
	static volatile gsize rygel_player_controller_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_player_controller_type_id__volatile)) {
		GType rygel_player_controller_type_id;
		rygel_player_controller_type_id = rygel_player_controller_get_type_once ();
		g_once_init_leave (&rygel_player_controller_type_id__volatile, rygel_player_controller_type_id);
	}
	return rygel_player_controller_type_id__volatile;
}

