// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!
#ifndef _GTKMM_WIDGET_H
#define _GTKMM_WIDGET_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2002, 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <vector>

#include <pangomm/context.h>
#include <pangomm/layout.h>

#ifdef GTKMM_ATKMM_ENABLED
#include <atkmm/object.h>
#include <atkmm/implementor.h>
#endif //GTKMM_ATKMM_ENABLED

#include <gtkmm/object.h>
#include <gtkmm/buildable.h>
#include <gtkmm/constrainttarget.h>
#include <gdkmm/events.h>
#include <gdkmm/types.h>
#include <gtkmm/enums.h>
#include <gdkmm/display.h>
#include <gdkmm/clipboard.h>
#include <gtkmm/requisition.h>
#include <gtkmm/stylecontext.h>
#include <giomm/actiongroup.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkWidget = struct _GtkWidget;
using GtkWidgetClass = struct _GtkWidgetClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class Widget_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gio
{
class ListModel;
}

namespace Gdk
{
class FrameClock;
class Paintable;
}

namespace Gtk
{


class AccelGroup;
class Adjustment;
class Window;
class Root;
class Native;
class Container;
class EventController;
class LayoutManager;
class Settings;
class Snapshot;
class Tooltip;

// Gtk::Allocation is a typedef of Gdk::Rectangle because GtkAllocation is
// a typedef of GdkRectangle.
typedef Gdk::Rectangle Allocation;

/** @defgroup Widgets Widgets
 */

//TODO: Deal with the GtkObject->GObject change:
/** Abstract Widget (Base class for all widgets)
 *
 * As the base class of all widgets this contains all of the properties
 * and methods common to all widgets.  It is an abstract class that
 * can not be instantiated.
 *
 * Important part of widgets are the *_event signals and virtual methods
 * that every widget have. Those are events coming directly from gdk and
 * thus also from XLib. By overriding those virtual methods you can
 * trap everything a widget can ever do.
 * In order to capture events from a widget, the event mask must
 * first be set with ().
 *
 * Only widgets with a Gdk::Surface on the server side are allowed to
 * capture events.
 */

class Widget
: public Object,
  public Buildable,
  public ConstraintTarget
#ifdef GTKMM_ATKMM_ENABLED
  ,public Atk::Implementor
#endif //GTKMM_ATKMM_ENABLED
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Widget CppObjectType;
  typedef Widget_Class CppClassType;
  typedef GtkWidget BaseObjectType;
  typedef GtkWidgetClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Widget(Widget&& src) noexcept;
  Widget& operator=(Widget&& src) noexcept;

  // noncopyable
  Widget(const Widget&) = delete;
  Widget& operator=(const Widget&) = delete;

  /** Destroys the widget. The widget will be automatically removed from the parent container.
   */
  ~Widget() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Widget_Class;
  static CppClassType widget_class_;

protected:
  explicit Widget(const Glib::ConstructParams& construct_params);
  explicit Widget(GtkWidget* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkWidget*       gobj()       { return reinterpret_cast<GtkWidget*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkWidget* gobj() const { return reinterpret_cast<GtkWidget*>(gobject_); }

private:

  
public:
  friend class Main;
  
  
  /** Converts this widget to a reference counted Gtk::ConstraintTarget.
   * Useful in calls to Gtk::Constraint::create().
   */
  Glib::RefPtr<ConstraintTarget> make_refptr_constrainttarget();

  /** Converts this widget to a reference counted Gtk::ConstraintTarget.
   */
  Glib::RefPtr<const ConstraintTarget> make_refptr_constrainttarget() const;

  
  /** Flags a widget to be displayed. Any widget that isn’t shown will
   * not appear on the screen.
   * 
   * Remember that you have to show the containers containing a widget,
   * in addition to the widget itself, before it will appear onscreen.
   * 
   * When a toplevel container is shown, it is immediately realized and
   * mapped; other shown widgets are realized and mapped when their
   * toplevel container is realized and mapped.
   */
  void show();
  
  /** Reverses the effects of show(), causing the widget to be
   * hidden (invisible to the user).
   */
  void hide();

/* QUEUE DRAWS */

  
  /** Schedules this widget to be redrawn in paint phase of the
   * current or the next frame. This means @a widget's GtkWidgetClass.snapshot()
   * implementation will be called.
   */
  void queue_draw();
  
  /** This function is only for use in widget implementations.
   * Flags a widget to have its size renegotiated; should
   * be called when a widget for some reason has a new size request.
   * For example, when you change the text in a Gtk::Label, Gtk::Label
   * queues a resize to ensure there’s enough space for the new text.
   * 
   * Note that you cannot call queue_resize() on a widget
   * from inside its implementation of the GtkWidgetClass::size_allocate 
   * virtual method. Calls to queue_resize() from inside
   * GtkWidgetClass::size_allocate will be silently ignored.
   */
  void queue_resize();
  
  /** This function is only for use in widget implementations.
   * 
   * Flags the widget for a rerun of the GtkWidgetClass::size_allocate
   * function. Use this function instead of queue_resize()
   * when the @a widget's size request didn't change but it wants to
   * reposition its contents.
   * 
   * An example user of this function is set_halign().
   */
  void queue_allocate();

  
  /** This is a simple form of allocate() that takes the new position
   * of @a widget as part of @a allocation.
   * 
   * @param allocation Position and size to be allocated to @a widget.
   * @param baseline The baseline of the child, or -1.
   */
  void size_allocate(const Allocation& allocation, int baseline);

  
  /** Gets whether the widget prefers a height-for-width layout
   * or a width-for-height layout.
   * 
   * Gtk::Bin widgets generally propagate the preference of
   * their child, container widgets need to request something either in
   * context of their children or in context of their allocation
   * capabilities.
   * 
   * @return The Gtk::SizeRequestMode preferred by @a widget.
   */
  SizeRequestMode get_request_mode() const;
  
  /** Measures @a widget in the orientation @a orientation and for the given @a for_size.
   * As an example, if @a orientation is Gtk::Orientation::HORIZONTAL and @a for_size is 300,
   * this functions will compute the minimum and natural width of @a widget if
   * it is allocated at a height of 300 pixels.
   * 
   * See [GtkWidget’s geometry management section][geometry-management] for
   * a more details on implementing Gtk::WidgetClass.measure().
   * 
   * @param orientation The orientation to measure.
   * @param for_size Size for the opposite of @a orientation, i.e.
   * if @a orientation is Gtk::Orientation::HORIZONTAL, this is
   * the height the widget should be measured with. The Gtk::Orientation::VERTICAL
   * case is analogous. This way, both height-for-width and width-for-height
   * requests can be implemented. If no size is known, -1 can be passed.
   * @param minimum Location to store the minimum size, or <tt>nullptr</tt>.
   * @param natural Location to store the natural size, or <tt>nullptr</tt>.
   * @param minimum_baseline Location to store the baseline
   * position for the minimum size, or <tt>nullptr</tt>.
   * @param natural_baseline Location to store the baseline
   * position for the natural size, or <tt>nullptr</tt>.
   */
  void measure(Orientation orientation, int for_size, int& minimum, int& natural, int& minimum_baseline, int& natural_baseline) const;
  
  /** Retrieves the minimum and natural size of a widget, taking
   * into account the widget’s preference for height-for-width management.
   * 
   * This is used to retrieve a suitable size by container widgets which do
   * not impose any restrictions on the child placement. It can be used
   * to deduce toplevel window and menu sizes as well as child widgets in
   * free-form containers such as GtkLayout.
   * 
   * Handle with care. Note that the natural height of a height-for-width
   * widget will generally be a smaller size than the minimum height, since the required
   * height for the natural width is generally smaller than the required height for
   * the minimum width.
   * 
   * Use measure() if you want to support
   * baseline alignment.
   * 
   * @param minimum_size Location for storing the minimum size, or <tt>nullptr</tt>.
   * @param natural_size Location for storing the natural size, or <tt>nullptr</tt>.
   */
  void get_preferred_size(Requisition& minimum_size, Requisition& natural_size) const;

  
  /** Sets the layout manager delegate instance that provides an implementation
   * for measuring and allocating the children of @a widget.
   * 
   * @param layout_manager A Gtk::LayoutManager.
   */

  void set_layout_manager(const Glib::RefPtr<LayoutManager>& layout_manager);
  /** Undoes the effect of a previous call to set_layout_manager().
   */
  void unset_layout_manager();
  
  /** Retrieves the layout manager set using set_layout_manager().
   * 
   * @return A Gtk::LayoutManager.
   */
  Glib::RefPtr<LayoutManager> get_layout_manager();
  
  /** Retrieves the layout manager set using set_layout_manager().
   * 
   * @return A Gtk::LayoutManager.
   */
  Glib::RefPtr<const LayoutManager> get_layout_manager() const;

  
  /** Installs an accelerator for this @a widget in @a accel_group that causes
   *  @a accel_signal to be emitted if the accelerator is activated.
   * The @a accel_group needs to be added to the widget’s toplevel via
   * Gtk::Window::add_accel_group(), and the signal must be of type G_SIGNAL_ACTION.
   * Accelerators added through this function are not user changeable during
   * runtime. If you want to support accelerators that can be changed by the
   * user, use Gtk::AccelMap::add_entry() and set_accel_path() or
   * gtk_menu_item_set_accel_path() instead.
   * 
   * @param accel_signal Widget signal to emit on accelerator activation.
   * @param accel_group Accel group for this widget, added to its toplevel.
   * @param accel_key GDK keyval of the accelerator.
   * @param accel_mods Modifier key combination of the accelerator.
   * @param accel_flags Flag accelerators, e.g. Gtk::AccelFlags::VISIBLE.
   */
  void add_accelerator(const Glib::ustring& accel_signal, const Glib::RefPtr<AccelGroup>& accel_group, guint accel_key, Gdk::ModifierType accel_mods, AccelFlags accel_flags);

  
  /** Removes an accelerator from @a widget, previously installed with
   * add_accelerator().
   * 
   * @param accel_group Accel group for this widget.
   * @param accel_key GDK keyval of the accelerator.
   * @param accel_mods Modifier key combination of the accelerator.
   * @return Whether an accelerator was installed and could be removed.
   */
  bool remove_accelerator(const Glib::RefPtr<AccelGroup>& accel_group, guint accel_key, Gdk::ModifierType accel_mods);
  
  /** Given an accelerator group, @a accel_group, and an accelerator path,
   *  @a accel_path, sets up an accelerator in @a accel_group so whenever the
   * key binding that is defined for @a accel_path is pressed, @a widget
   * will be activated.  This removes any accelerators (for any
   * accelerator group) installed by previous calls to
   * set_accel_path(). Associating accelerators with
   * paths allows them to be modified by the user and the modifications
   * to be saved for future use. (See Gtk::AccelMap::save().)
   * 
   * This function is a low level function that would most likely
   * be used by a menu creation system.
   * 
   * If you only want to
   * set up accelerators on menu items gtk_menu_item_set_accel_path()
   * provides a somewhat more convenient interface.
   * 
   * Note that @a accel_path string will be stored in a Quark. Therefore, if you
   * pass a static string, you can save some memory by interning it first with
   * Glib::intern_static_string().
   * 
   * @param accel_path Path used to look up the accelerator.
   * @param accel_group A Gtk::AccelGroup.
   */
  void set_accel_path(const Glib::ustring& accel_path, const Glib::RefPtr<AccelGroup>& accel_group);

  //GList* gtk_widget_list_accel_closures();

  
  /** Emits the Gtk::Widget::signal_mnemonic_activate() signal.
   * 
   * @param group_cycling <tt>true</tt> if there are other widgets with the same mnemonic.
   * @return <tt>true</tt> if the signal has been handled.
   */
  bool mnemonic_activate(bool group_cycling);

  
  //Probably not useful. Too C-specific: _WRAP_METHOD(bool can_activate_accel(guint signal_id) const, gtk_widget_can_activate_accel)

  
  /** Rarely-used function. This function is used to emit
   * the event signals on a widget (those signals should never
   * be emitted without using this function to do so).
   * If you want to synthesize an event though, don’t use this function;
   * instead, use gtk_main_do_event() so the event will behave as if
   * it were in the event queue.
   * 
   * @param gdk_event A Gdk::Event.
   * @return Return from the event signal emission (<tt>true</tt> if
   * the event was handled).
   */
  bool event(const Glib::RefPtr<Gdk::Event>& gdk_event);
  
  /** For widgets that can be “activated” (buttons, menu items, etc.)
   * this function activates them. Activation is what happens when you
   * press Enter on a widget during key navigation. If @a widget isn't
   * activatable, the function returns <tt>false</tt>.
   * 
   * @return <tt>true</tt> if the widget was activatable.
   */
  bool activate();

  // gtk_widget_reparent() has been removed, but we want to keep Gtk::Widget::reparent().
  /** Moves a widget from one Gtk::Container to another, handling reference
   * count issues to avoid destroying the widget.
   *
   * @param new_parent A Gtk::Container to move the widget into.
   */
  void reparent(Container& new_parent);

  
  /** Specifies whether @a widget can own the input focus.
   * 
   * Note that having @a can_focus be <tt>true</tt> is only one of the
   * necessary conditions for being focusable. A widget must
   * also be sensitive and not have an ancestor that is marked
   * as not child-focusable in order to receive input focus.
   * 
   * See grab_focus() for actually setting the input
   * focus on a widget.
   * 
   * @param can_focus Whether or not @a widget can own the input focus.
   */
  void set_can_focus(bool can_focus =  true);
  
  /** Determines whether @a widget can own the input focus. See
   * set_can_focus().
   * 
   * @return <tt>true</tt> if @a widget can own the input focus, <tt>false</tt> otherwise.
   */
  bool get_can_focus() const;
  
  /** Determines if the widget has the global input focus. See
   * is_focus() for the difference between having the global
   * input focus, and only having the focus within a toplevel.
   * 
   * @return <tt>true</tt> if the widget has the global input focus.
   */
  bool has_focus() const;

  
  /** Determines if the widget is the focus widget within its
   * toplevel. (This does not mean that the Gtk::Widget::property_has_focus() property is
   * necessarily set; Gtk::Widget::property_has_focus() will only be set if the
   * toplevel widget additionally has the global input focus.)
   * 
   * @return <tt>true</tt> if the widget is the focus widget.
   */
  bool is_focus() const;
  
  /** Determines if the widget should show a visible indication that
   * it has the global input focus. This is a convenience function for
   * use in signal_draw() handlers that takes into account whether focus
   * indication should currently be shown in the toplevel window of
   *  @a widget. See Gtk::Window::get_focus_visible() for more information
   * about focus indication.
   * 
   * To find out if the widget has the global input focus, use
   * has_focus().
   * 
   * @return <tt>true</tt> if the widget should display a “focus rectangle”.
   */
  bool has_visible_focus() const;
  
  /** Causes @a widget (or one of its descendents) to have the keyboard focus
   * for the Gtk::Window it's inside.
   * 
   * If @a widget is not focusable, or its ::grab_focus implementation cannot
   * transfer the focus to a descendant of @a widget that is focusable, it will
   * not take focus and <tt>false</tt> will be returned.
   * 
   * Calling grab_focus() on an already focused widget is allowed,
   * should not have an effect, and return <tt>true</tt>.
   * 
   * @return <tt>true</tt> if focus is now inside @a widget.
   */
  bool grab_focus();
  
  /** Sets whether the widget should grab focus when it is clicked with the mouse.
   * Making mouse clicks not grab focus is useful in places like toolbars where
   * you don’t want the keyboard focus removed from the main area of the
   * application.
   * 
   * @param focus_on_click Whether the widget should grab focus when clicked with the mouse.
   */
  void set_focus_on_click(bool focus_on_click =  true);
  
  /** Returns whether the widget should grab focus when it is clicked with the mouse.
   * See set_focus_on_click().
   * 
   * @return <tt>true</tt> if the widget should grab focus when it is clicked with
   * the mouse.
   */
  bool get_focus_on_click() const;
  
  /** Sets whether @a widget can be the target of pointer events.
   * 
   * @param can_target Whether this widget should be able to receive pointer events.
   */
  void set_can_target(bool can_target =  true);
  
  /** Queries whether @a widget can be the target of pointer events.
   * 
   * @return <tt>true</tt> if @a widget can receive pointer events.
   */
  bool get_can_target() const;
  
  /** Determines whether @a widget is the current default widget within its
   * toplevel.
   * 
   * @return <tt>true</tt> if @a widget is the current default widget within
   * its toplevel, <tt>false</tt> otherwise.
   */
  bool has_default() const;
  
  /** Specifies whether @a widget will be treated as the default
   * widget within its toplevel when it has the focus, even if
   * another widget is the default.
   * 
   * @param receives_default Whether or not @a widget can be a default widget.
   */
  void set_receives_default(bool receives_default =  true);
  
  /** Determines whether @a widget is always treated as the default widget
   * within its toplevel when it has the focus, even if another widget
   * is the default.
   * 
   * See set_receives_default().
   * 
   * @return <tt>true</tt> if @a widget acts as the default widget when focused,
   * <tt>false</tt> otherwise.
   */
  bool get_receives_default() const;
  
  /** Determines whether the widget is currently grabbing events, so it
   * is the only widget receiving input events (keyboard and mouse).
   * 
   * See also gtk_grab_add().
   * 
   * @return <tt>true</tt> if the widget is in the grab_widgets stack.
   */
  bool has_grab() const;
  
  /** Returns <tt>true</tt> if @a device has been shadowed by a GTK+
   * device grab on another widget, so it would stop sending
   * events to @a widget. This may be used in the
   * Gtk::Widget::signal_grab_notify() signal to check for specific
   * devices. See gtk_device_grab_add().
   * 
   * @param device A Gdk::Device.
   * @return <tt>true</tt> if there is an ongoing grab on @a device
   * by another Gtk::Widget than @a widget.
   */
  bool device_is_shadowed(const Glib::RefPtr<const Gdk::Device>& device);


  /** Block events to everything else than this widget and its children. This
   * way you can get modal behaviour (usually not recommended). One practical
   * example could be when implementing a key-binding widget that needs
   * exclusive access to the key combination that the user presses next.
   *
   * Calls to add_modal_grab should be paired with calls to remove_modal_grab.
   */
  void add_modal_grab();

  /** Remove the modal grab of the widget in case it was previously grabbed.
   */
  void remove_modal_grab();

  /** Retrieve the widget which is currently grabbing all events.
   */
  static Widget* get_current_modal_grab();

  
  /** Widgets can be named, which allows you to refer to them from a
   * CSS file. You can apply a style to widgets with a particular name
   * in the CSS file. See the documentation for the CSS syntax (on the
   * same page as the docs for Gtk::StyleContext).
   * 
   * Note that the CSS syntax has certain special characters to delimit
   * and represent elements in a selector (period, #, >, *...), so using
   * these will make your widget impossible to match by name. Any combination
   * of alphanumeric symbols, dashes and underscores will suffice.
   * 
   * @param name Name for the widget.
   */
  void set_name(const Glib::ustring& name);
  void unset_name();
  
  /** Retrieves the name of a widget. See set_name() for the
   * significance of widget names.
   * 
   * @return Name of the widget. This string is owned by GTK+ and
   * should not be modified or freed.
   */
  Glib::ustring get_name() const;

  
  /** This function is for use in widget implementations. Turns on flag
   * values in the current widget state (insensitive, prelighted, etc.).
   * 
   * This function accepts the values Gtk::StateFlags::DIR_LTR and
   * Gtk::StateFlags::DIR_RTL but ignores them. If you want to set the widget's
   * direction, use set_direction().
   * 
   * It is worth mentioning that any other state than Gtk::StateFlags::INSENSITIVE,
   * will be propagated down to all non-internal children if @a widget is a
   * Gtk::Container, while Gtk::StateFlags::INSENSITIVE itself will be propagated
   * down to all Gtk::Container children by different means than turning on the
   * state flag down the hierarchy, both get_state_flags() and
   * is_sensitive() will make use of these.
   * 
   * @param flags State flags to turn on.
   * @param clear Whether to clear state before turning on @a flags.
   */
  void set_state_flags(StateFlags flags, bool clear =  true);
  
  /** This function is for use in widget implementations. Turns off flag
   * values for the current widget state (insensitive, prelighted, etc.).
   * See set_state_flags().
   * 
   * @param flags State flags to turn off.
   */
  void unset_state_flags(StateFlags flags);
  
  /** Returns the widget state as a flag set. It is worth mentioning
   * that the effective Gtk::StateFlags::INSENSITIVE state will be
   * returned, that is, also based on parent insensitivity, even if
   *  @a widget itself is sensitive.
   * 
   * Also note that if you are looking for a way to obtain the
   * Gtk::StateFlags to pass to a Gtk::StyleContext method, you
   * should look at Gtk::StyleContext::get_state().
   * 
   * @return The state flags for widget.
   */
  StateFlags get_state_flags() const;

  
  /** Sets the sensitivity of a widget. A widget is sensitive if the user
   * can interact with it. Insensitive widgets are “grayed out” and the
   * user can’t interact with them. Insensitive widgets are known as
   * “inactive”, “disabled”, or “ghosted” in some other toolkits.
   * 
   * @param sensitive <tt>true</tt> to make the widget sensitive.
   */
  void set_sensitive(bool sensitive =  true);
  
  /** Returns the widget’s sensitivity (in the sense of returning
   * the value that has been set using set_sensitive()).
   * 
   * The effective sensitivity of a widget is however determined by both its
   * own and its parent widget’s sensitivity. See is_sensitive().
   * 
   * @return <tt>true</tt> if the widget is sensitive.
   */
  bool get_sensitive() const;
  
  /** Returns the widget’s effective sensitivity, which means
   * it is sensitive itself and also its parent widget is sensitive
   * 
   * @return <tt>true</tt> if the widget is effectively sensitive.
   */
  bool is_sensitive() const;
  
  /** Sets the visibility state of @a widget. Note that setting this to
   * <tt>true</tt> doesn’t mean the widget is actually viewable, see
   * get_visible().
   * 
   * This function simply calls show() or hide()
   * but is nicer to use when the visibility of the widget depends on
   * some condition.
   * 
   * @param visible Whether the widget should be shown or not.
   */
  void set_visible(bool visible =  true);
  
  /** Determines whether the widget is visible. If you want to
   * take into account whether the widget’s parent is also marked as
   * visible, use is_visible() instead.
   * 
   * This function does not check if the widget is obscured in any way.
   * 
   * See set_visible().
   * 
   * @return <tt>true</tt> if the widget is visible.
   */
  bool get_visible() const;
  
  /** Determines whether the widget and all its parents are marked as
   * visible.
   * 
   * This function does not check if the widget is obscured in any way.
   * 
   * See also get_visible() and set_visible()
   * 
   * @return <tt>true</tt> if the widget and all its parents are visible.
   */
  bool is_visible() const;
  
  /** Determines whether @a widget can be drawn to. A widget can be drawn
   * if it is mapped and visible.
   * 
   * @return <tt>true</tt> if @a widget is drawable, <tt>false</tt> otherwise.
   */
  bool get_is_drawable() const;
  
  /** Determines whether @a widget is realized.
   * 
   * @return <tt>true</tt> if @a widget is realized, <tt>false</tt> otherwise.
   */
  bool get_realized() const;
  
  /** Whether the widget is mapped.
   * 
   * @return <tt>true</tt> if the widget is mapped, <tt>false</tt> otherwise.
   */
  bool get_mapped() const;

  
  /** Sets whether @a widget should be mapped along with its when its parent
   * is mapped and @a widget has been shown with show().
   * 
   * The child visibility can be set for widget before it is added to
   * a container with set_parent(), to avoid mapping
   * children unnecessary before immediately unmapping them. However
   * it will be reset to its default state of <tt>true</tt> when the widget
   * is removed from a container.
   * 
   * Note that changing the child visibility of a widget does not
   * queue a resize on the widget. Most of the time, the size of
   * a widget is computed from all visible children, whether or
   * not they are mapped. If this is not the case, the container
   * can queue a resize itself.
   * 
   * This function is only useful for container implementations and
   * never should be called by an application.
   * 
   * @param visible If <tt>true</tt>, @a widget should be mapped along with its parent.
   */
  void set_child_visible(bool visible =  true);
  
  /** Gets the value set with set_child_visible().
   * If you feel a need to use this function, your code probably
   * needs reorganization.
   * 
   * This function is only useful for container implementations and
   * never should be called by an application.
   * 
   * @return <tt>true</tt> if the widget is mapped with the parent.
   */
  bool get_child_visible() const;

  
  /** Returns the width that has currently been allocated to @a widget.
   * 
   * @return The width of the @a widget.
   */
  int get_allocated_width() const;
  
  /** Returns the height that has currently been allocated to @a widget.
   * 
   * @return The height of the @a widget.
   */
  int get_allocated_height() const;
  
  /** Returns the baseline that has currently been allocated to @a widget.
   * This function is intended to be used when implementing handlers
   * for the Gtk::Widget::signal_snapshot() function, and when allocating child
   * widgets in Gtk::Widget::size_allocate.
   * 
   * @return The baseline of the @a widget, or -1 if none.
   */
  int get_allocated_baseline() const;

  /** Retrieves the widget's location.
   * Note, when implementing a Container: a widget's allocation will be its "adjusted" allocation,
   * that is, the widget's parent container typically calls size_allocate() with an allocation,
   * and that allocation is then adjusted (to handle margin and alignment for example) before
   * assignment to the widget. get_allocation() returns the adjusted allocation that was actually
   * assigned to the widget. The adjusted allocation is guaranteed to be completely contained
   * within the size_allocate() allocation, however. So a Container is guaranteed that its
   * children stay inside the assigned bounds, but not that they have exactly the bounds the
   * container assigned. There is no way to get the original allocation assigned by
   * size_allocate(), since it isn't stored. If a container implementation needs that information
   * it will have to track it itself.
   *
   * @return The widget's allocated area.
   */
  Allocation get_allocation() const;
  

  /** Returns the content width of the widget, as passed to its size-allocate implementation.
   * This is the size you should be using in GtkWidgetClass.snapshot(). For pointer
   * events, see contains().
   * 
   * @return The width of @a widget.
   */
  int get_width() const;
  
  /** Returns the content height of the widget, as passed to its size-allocate implementation.
   * This is the size you should be using in GtkWidgetClass.snapshot(). For pointer
   * events, see contains().
   * 
   * @return The height of @a widget.
   */
  int get_height() const;

  
  /** Returns the parent widget of @a widget.
   * 
   * @return The parent widget of @a widget, or <tt>nullptr</tt>.
   */
  Container* get_parent();
  
  /** Returns the parent widget of @a widget.
   * 
   * @return The parent widget of @a widget, or <tt>nullptr</tt>.
   */
  const Container* get_parent() const;

  
  /** Returns the Gtk::Root widget of @a widget or <tt>nullptr</tt> if the widget is not contained
   * inside a widget tree with a root widget.
   * 
   * Gtk::Root widgets will return themselves here.
   * 
   * @return The root widget of @a widget, or <tt>nullptr</tt>.
   */
  Root* get_root();
  
  /** Returns the Gtk::Root widget of @a widget or <tt>nullptr</tt> if the widget is not contained
   * inside a widget tree with a root widget.
   * 
   * Gtk::Root widgets will return themselves here.
   * 
   * @return The root widget of @a widget, or <tt>nullptr</tt>.
   */
  const Root* get_root() const;

  
  /** Returns the GtkNative widget that contains @a widget,
   * or <tt>nullptr</tt> if the widget is not contained inside a
   * widget tree with a native ancestor.
   * 
   * Gtk::Native widgets will return themselves here.
   * 
   * @return The Gtk::Native
   * widget of @a widget, or <tt>nullptr</tt>.
   */
  Native* get_native();
  
  /** Returns the GtkNative widget that contains @a widget,
   * or <tt>nullptr</tt> if the widget is not contained inside a
   * widget tree with a native ancestor.
   * 
   * Gtk::Native widgets will return themselves here.
   * 
   * @return The Gtk::Native
   * widget of @a widget, or <tt>nullptr</tt>.
   */
  const Native* get_native() const;

  
  /** This function is used by custom widget implementations; if you're
   * writing an app, you’d use grab_focus() to move the focus
   * to a particular widget.
   * 
   * child_focus() is called by containers as the user moves
   * around the window using keyboard shortcuts. @a direction indicates
   * what kind of motion is taking place (up, down, left, right, tab
   * forward, tab backward). child_focus() emits the
   * Gtk::Widget::signal_focus() signal; widgets override the default handler
   * for this signal in order to implement appropriate focus behavior.
   * 
   * The default signal_focus() handler for a widget should return <tt>true</tt> if
   * moving in @a direction left the focus on a focusable location inside
   * that widget, and <tt>false</tt> if moving in @a direction moved the focus
   * outside the widget. If returning <tt>true</tt>, widgets normally
   * call grab_focus() to place the focus accordingly;
   * if returning <tt>false</tt>, they don’t modify the current focus location.
   * 
   * @param direction Direction of focus movement.
   * @return <tt>true</tt> if focus ended up inside @a widget.
   */
  bool child_focus(DirectionType direction);

  
  /** This function should be called whenever keyboard navigation within
   * a single widget hits a boundary. The function emits the
   * Gtk::Widget::signal_keynav_failed() signal on the widget and its return
   * value should be interpreted in a way similar to the return value of
   * child_focus():
   * 
   * When <tt>true</tt> is returned, stay in the widget, the failed keyboard
   * navigation is OK and/or there is nowhere we can/should move the
   * focus to.
   * 
   * When <tt>false</tt> is returned, the caller should continue with keyboard
   * navigation outside the widget, e.g. by calling
   * child_focus() on the widget’s toplevel.
   * 
   * The default signal_keynav_failed() handler returns <tt>false</tt> for
   * Gtk::DirectionType::TAB_FORWARD and Gtk::DirectionType::TAB_BACKWARD. For the other
   * values of Gtk::DirectionType it returns <tt>true</tt>.
   * 
   * Whenever the default handler returns <tt>true</tt>, it also calls
   * error_bell() to notify the user of the failed keyboard
   * navigation.
   * 
   * A use case for providing an own implementation of signal_keynav_failed()
   * (either by connecting to it or by overriding it) would be a row of
   * Gtk::Entry widgets where the user should be able to navigate the
   * entire row with the cursor keys, as e.g. known from user interfaces
   * that require entering license keys.
   * 
   * @param direction Direction of focus movement.
   * @return <tt>true</tt> if stopping keyboard navigation is fine, <tt>false</tt>
   * if the emitting widget should try to handle the keyboard
   * navigation attempt in its parent container(s).
   */
  bool keynav_failed(DirectionType direction);
  
  /** Notifies the user about an input-related error on this widget. 
   * If the Gtk::Settings gtk-error-bell property is true, it calls
   * Gdk::Surface::beep(), otherwise it does nothing.
   * 
   * Note that the effect of Gdk::Surface::beep() can be configured in many
   * ways, depending on the windowing backend and the desktop environment
   * or window manager that is used.
   * 
   * @newin{2,12}
   */
  void error_bell();

  
  /** Sets the minimum size of a widget; that is, the widget’s size
   * request will be at least @a width by @a height. You can use this 
   * function to force a widget to be larger than it normally would be.
   * 
   * In most cases, Gtk::Window::set_default_size() is a better choice for
   * toplevel windows than this function; setting the default size will
   * still allow users to shrink the window. Setting the size request
   * will force them to leave the window at least as large as the size
   * request. When dealing with window sizes,
   * gtk_window_set_geometry_hints() can be a useful function as well.
   * 
   * Note the inherent danger of setting any fixed size - themes,
   * translations into other languages, different fonts, and user action
   * can all change the appropriate size for a given widget. So, it's
   * basically impossible to hardcode a size that will always be
   * correct.
   * 
   * The size request of a widget is the smallest size a widget can
   * accept while still functioning well and drawing itself correctly.
   * However in some strange cases a widget may be allocated less than
   * its requested size, and in many cases a widget may be allocated more
   * space than it requested.
   * 
   * If the size request in a given direction is -1 (unset), then
   * the “natural” size request of the widget will be used instead.
   * 
   * The size request set here does not include any margin from the
   * Gtk::Widget properties margin-left, margin-right, margin-top, and
   * margin-bottom, but it does include pretty much all other padding
   * or border properties set by any subclass of Gtk::Widget.
   * 
   * @param width Width @a widget should request, or -1 to unset.
   * @param height Height @a widget should request, or -1 to unset.
   */
  void set_size_request(int width =  -1, int height =  -1);
  
  /** Gets the size request that was explicitly set for the widget using
   * set_size_request(). A value of -1 stored in @a width or
   *  @a height indicates that that dimension has not been set explicitly
   * and the natural requisition of the widget will be used instead. See
   * set_size_request(). To get the size a widget will
   * actually request, call measure() instead of
   * this function.
   * 
   * @param width Return location for width, or <tt>nullptr</tt>.
   * @param height Return location for height, or <tt>nullptr</tt>.
   */
  void get_size_request(int& width, int& height) const;

  
  /** Request the @a widget to be rendered partially transparent,
   * with opacity 0 being fully transparent and 1 fully opaque. (Opacity values
   * are clamped to the [0,1] range.).
   * This works on both toplevel widget, and child widgets, although there
   * are some limitations:
   * 
   * For toplevel widgets this depends on the capabilities of the windowing
   * system. On X11 this has any effect only on X displays with a compositing manager
   * running. See gdk_display_is_composited(). On Windows it should work
   * always, although setting a window’s opacity after the window has been
   * shown causes it to flicker once on Windows.
   * 
   * For child widgets it doesn’t work if any affected widget has a native window.
   * 
   * @param opacity Desired opacity, between 0 and 1.
   */
  void set_opacity(double opacity);
  
  /** Fetches the requested opacity for this widget.
   * See set_opacity().
   * 
   * @return The requested opacity for this widget.
   */
  double get_opacity() const;

  
  /** Sets how @a widget treats content that is drawn outside the widget's content area.
   * See the definition of Gtk::Overflow for details.
   * 
   * This setting is provided for widget implementations and should not be used by
   * application code.
   * 
   * The default value is Gtk::Overflow::VISIBLE.
   * 
   * @newin{3,96}
   * 
   * @param overflow Desired overflow.
   */
  void set_overflow(Overflow overflow);
  
  /** Returns the value set via set_overflow().
   * 
   * @newin{3,96}
   * 
   * @return The widget's overflow.
   */
  Overflow get_overflow() const;

  
  /** Gets the first ancestor of @a widget with type @a widget_type. For example,
   * `gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)` gets
   * the first Gtk::Box that’s an ancestor of @a widget. No reference will be
   * added to the returned widget; it should not be unreferenced.
   * 
   * Note that unlike is_ancestor(), get_ancestor()
   * considers @a widget to be an ancestor of itself.
   * 
   * @param widget_type Ancestor type.
   * @return The ancestor widget, or <tt>nullptr</tt> if not found.
   */
  Widget* get_ancestor(GType widget_type);
  
  /** Gets the first ancestor of @a widget with type @a widget_type. For example,
   * `gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)` gets
   * the first Gtk::Box that’s an ancestor of @a widget. No reference will be
   * added to the returned widget; it should not be unreferenced.
   * 
   * Note that unlike is_ancestor(), get_ancestor()
   * considers @a widget to be an ancestor of itself.
   * 
   * @param widget_type Ancestor type.
   * @return The ancestor widget, or <tt>nullptr</tt> if not found.
   */
  const Widget* get_ancestor(GType widget_type) const;

  
  /** Retrieves the internal scale factor that maps from window coordinates
   * to the actual device pixels. On traditional systems this is 1, on
   * high density outputs, it can be a higher value (typically 2).
   * 
   * See gdk_surface_get_scale_factor().
   * 
   * @return The scale factor for @a widget.
   */
  int get_scale_factor() const;

  
  /** Get the Gdk::Display for the toplevel window associated with
   * this widget. This function can only be called after the widget
   * has been added to a widget hierarchy with a Gtk::Window at the top.
   * 
   * In general, you should only create display specific
   * resources when a widget has been realized, and you should
   * free those resources when the widget is unrealized.
   * 
   * @return The Gdk::Display for the toplevel for this widget.
   */
  Glib::RefPtr<Gdk::Display> get_display();
  
  /** Get the Gdk::Display for the toplevel window associated with
   * this widget. This function can only be called after the widget
   * has been added to a widget hierarchy with a Gtk::Window at the top.
   * 
   * In general, you should only create display specific
   * resources when a widget has been realized, and you should
   * free those resources when the widget is unrealized.
   * 
   * @return The Gdk::Display for the toplevel for this widget.
   */
  Glib::RefPtr<const Gdk::Display> get_display() const;

  
  /** Gets the settings object holding the settings used for this widget.
   * 
   * Note that this function can only be called when the Gtk::Widget
   * is attached to a toplevel, since the settings object is specific
   * to a particular Gdk::Display. If you want to monitor the widget for
   * changes in its settings, connect to notify::display.
   * 
   * @return The relevant Gtk::Settings object.
   */
  Glib::RefPtr<Settings> get_settings();

  
  /** This is a utility function to get the clipboard object for the
   * Gdk::Display that @a widget is using.
   * 
   * Note that this function always works, even when @a widget is not
   * realized yet.
   * 
   * @return The appropriate clipboard object.
   */
  Glib::RefPtr<Gdk::Clipboard> get_clipboard();
  
  /** This is a utility function to get the clipboard object for the
   * Gdk::Display that @a widget is using.
   * 
   * Note that this function always works, even when @a widget is not
   * realized yet.
   * 
   * @return The appropriate clipboard object.
   */
  Glib::RefPtr<const Gdk::Clipboard> get_clipboard() const;
  
  /** This is a utility function to get the primary clipboard object 
   * for the Gdk::Display that @a widget is using.
   * 
   * Note that this function always works, even when @a widget is not
   * realized yet.
   * 
   * @return The appropriate clipboard object.
   */
  Glib::RefPtr<Gdk::Clipboard> get_primary_clipboard();
  
  /** This is a utility function to get the primary clipboard object 
   * for the Gdk::Display that @a widget is using.
   * 
   * Note that this function always works, even when @a widget is not
   * realized yet.
   * 
   * @return The appropriate clipboard object.
   */
  Glib::RefPtr<const Gdk::Clipboard> get_primary_clipboard() const;

  
  /** Gets whether the widget would like any available extra horizontal
   * space. When a user resizes a Gtk::Window, widgets with expand=<tt>true</tt>
   * generally receive the extra space. For example, a list or
   * scrollable area or document in your window would often be set to
   * expand.
   * 
   * Containers should use compute_expand() rather than
   * this function, to see whether a widget, or any of its children,
   * has the expand flag set. If any child of a widget wants to
   * expand, the parent may ask to expand also.
   * 
   * This function only looks at the widget’s own hexpand flag, rather
   * than computing whether the entire widget tree rooted at this widget
   * wants to expand.
   * 
   * @return Whether hexpand flag is set.
   */
  bool get_hexpand() const;
  
  /** Sets whether the widget would like any available extra horizontal
   * space. When a user resizes a Gtk::Window, widgets with expand=<tt>true</tt>
   * generally receive the extra space. For example, a list or
   * scrollable area or document in your window would often be set to
   * expand.
   * 
   * Call this function to set the expand flag if you would like your
   * widget to become larger horizontally when the window has extra
   * room.
   * 
   * By default, widgets automatically expand if any of their children
   * want to expand. (To see if a widget will automatically expand given
   * its current children and state, call compute_expand(). A
   * container can decide how the expandability of children affects the
   * expansion of the container by overriding the compute_expand virtual
   * method on Gtk::Widget.).
   * 
   * Setting hexpand explicitly with this function will override the
   * automatic expand behavior.
   * 
   * This function forces the widget to expand or not to expand,
   * regardless of children.  The override occurs because
   * set_hexpand() sets the hexpand-set property (see
   * set_hexpand_set()) which causes the widget’s hexpand
   * value to be used, rather than looking at children and widget state.
   * 
   * @param expand Whether to expand.
   */
  void set_hexpand(bool expand =  true);
  
  /** Gets whether set_hexpand() has been used to
   * explicitly set the expand flag on this widget.
   * 
   * If hexpand is set, then it overrides any computed
   * expand value based on child widgets. If hexpand is not
   * set, then the expand value depends on whether any
   * children of the widget would like to expand.
   * 
   * There are few reasons to use this function, but it’s here
   * for completeness and consistency.
   * 
   * @return Whether hexpand has been explicitly set.
   */
  bool get_hexpand_set() const;
  
  /** Sets whether the hexpand flag (see get_hexpand()) will
   * be used.
   * 
   * The hexpand-set property will be set automatically when you call
   * set_hexpand() to set hexpand, so the most likely
   * reason to use this function would be to unset an explicit expand
   * flag.
   * 
   * If hexpand is set, then it overrides any computed
   * expand value based on child widgets. If hexpand is not
   * set, then the expand value depends on whether any
   * children of the widget would like to expand.
   * 
   * There are few reasons to use this function, but it’s here
   * for completeness and consistency.
   * 
   * @param set Value for hexpand-set property.
   */
  void set_hexpand_set(bool set =  true);
  
  /** Gets whether the widget would like any available extra vertical
   * space.
   * 
   * See get_hexpand() for more detail.
   * 
   * @return Whether vexpand flag is set.
   */
  bool get_vexpand() const;
  
  /** Sets whether the widget would like any available extra vertical
   * space.
   * 
   * See set_hexpand() for more detail.
   * 
   * @param expand Whether to expand.
   */
  void set_vexpand(bool expand =  true);
  
  /** Gets whether set_vexpand() has been used to
   * explicitly set the expand flag on this widget.
   * 
   * See get_hexpand_set() for more detail.
   * 
   * @return Whether vexpand has been explicitly set.
   */
  bool get_vexpand_set() const;
  
  /** Sets whether the vexpand flag (see get_vexpand()) will
   * be used.
   * 
   * See set_hexpand_set() for more detail.
   * 
   * @param set Value for vexpand-set property.
   */
  void set_vexpand_set(bool set =  true);
  
  /** Computes whether a container should give this widget extra space
   * when possible. Containers should check this, rather than
   * looking at get_hexpand() or get_vexpand().
   * 
   * This function already checks whether the widget is visible, so
   * visibility does not need to be checked separately. Non-visible
   * widgets are not expanded.
   * 
   * The computed expand value uses either the expand setting explicitly
   * set on the widget itself, or, if none has been explicitly set,
   * the widget may expand if some of its children do.
   * 
   * @param orientation Expand direction.
   * @return Whether widget tree rooted here should be expanded.
   */
  bool compute_expand(Orientation orientation);

  /** Sets whether the widget would like any available extra space in both directions.
   *
   * @see set_hexpand() for more detail.
   * @param expand Whether to expand in horizontal and vertical direction.
   */
  void set_expand(bool expand = true);

  
  /** Returns <tt>true</tt> if @a widget is multiple pointer aware. See
   * set_support_multidevice() for more information.
   * 
   * @return <tt>true</tt> if @a widget is multidevice aware.
   */
  bool get_support_multidevice() const;
  
  /** Enables or disables multiple pointer awareness. If this setting is <tt>true</tt>,
   *  @a widget will start receiving multiple, per device enter/leave events. Note
   * that if custom Gdk::Surfaces are created in Gtk::Widget::signal_realize(),
   * gdk_surface_set_support_multidevice() will have to be called manually on them.
   * 
   * @param support_multidevice <tt>true</tt> to support input from multiple devices.
   */
  void set_support_multidevice(bool support_multidevice =  true);

  
#ifdef  GTKMM_ATKMM_ENABLED

  /** Returns the accessible object that describes the widget to an
   * assistive technology.
   * 
   * If accessibility support is not available, this Atk::Object
   * instance may be a no-op. Likewise, if no class-specific Atk::Object
   * implementation is available for the widget instance in question,
   * it will inherit an Atk::Object implementation from the first ancestor
   * class for which such an implementation is defined.
   * 
   * The documentation of the
   * [ATK](http://developer.gnome.org/atk/stable/)
   * library contains more information about accessible objects and their uses.
   * 
   * @return The Atk::Object associated with @a widget.
   */
  Glib::RefPtr<Atk::Object> get_accessible();
#endif //  GTKMM_ATKMM_ENABLED

  
#ifdef  GTKMM_ATKMM_ENABLED

  /** Returns the accessible object that describes the widget to an
   * assistive technology.
   * 
   * If accessibility support is not available, this Atk::Object
   * instance may be a no-op. Likewise, if no class-specific Atk::Object
   * implementation is available for the widget instance in question,
   * it will inherit an Atk::Object implementation from the first ancestor
   * class for which such an implementation is defined.
   * 
   * The documentation of the
   * [ATK](http://developer.gnome.org/atk/stable/)
   * library contains more information about accessible objects and their uses.
   * 
   * @return The Atk::Object associated with @a widget.
   */
  Glib::RefPtr<const Atk::Object> get_accessible() const;
#endif //  GTKMM_ATKMM_ENABLED


  /** Gets the value of the Gtk::Widget::property_halign() property.
   * 
   * For backwards compatibility reasons this method will never return
   * Gtk::Align::BASELINE, but instead it will convert it to
   * Gtk::Align::FILL. Baselines are not supported for horizontal
   * alignment.
   * 
   * @return The horizontal alignment of @a widget.
   */
  Align get_halign() const;
  
  /** Sets the horizontal alignment of @a widget.
   * See the Gtk::Widget::property_halign() property.
   * 
   * @param align The horizontal alignment.
   */
  void set_halign(Align align);
  
  /** Gets the value of the Gtk::Widget::property_valign() property.
   * 
   * @return The vertical alignment of @a widget.
   */
  Align get_valign() const;
  
  /** Sets the vertical alignment of @a widget.
   * See the Gtk::Widget::property_valign() property.
   * 
   * @param align The vertical alignment.
   */
  void set_valign(Align align);
  
  /** Gets the value of the Gtk::Widget::property_margin_start() property.
   * 
   * @return The start margin of @a widget.
   */
  int get_margin_start() const;
  
  /** Sets the start margin of @a widget.
   * See the Gtk::Widget::property_margin_start() property.
   * 
   * @param margin The start margin.
   */
  void set_margin_start(int margin);
  
  /** Gets the value of the Gtk::Widget::property_margin_end() property.
   * 
   * @return The end margin of @a widget.
   */
  int get_margin_end() const;
  
  /** Sets the end margin of @a widget.
   * See the Gtk::Widget::property_margin_end() property.
   * 
   * @param margin The end margin.
   */
  void set_margin_end(int margin);
  
  /** Gets the value of the Gtk::Widget::property_margin_top() property.
   * 
   * @return The top margin of @a widget.
   */
  int get_margin_top() const;
  
  /** Sets the top margin of @a widget.
   * See the Gtk::Widget::property_margin_top() property.
   * 
   * @param margin The top margin.
   */
  void set_margin_top(int margin);
  
  /** Gets the value of the Gtk::Widget::property_margin_bottom() property.
   * 
   * @return The bottom margin of @a widget.
   */
  int get_margin_bottom() const;
  
  /** Sets the bottom margin of @a widget.
   * See the Gtk::Widget::property_margin_bottom() property.
   * 
   * @param margin The bottom margin.
   */
  void set_margin_bottom(int margin);

  /** Set all 4 margins to the same value.
   * @param margin The start, end, top, and bottom margin.
   */
  void set_margin(int margin);

  
  /** Determines whether @a widget is somewhere inside @a ancestor, possibly with
   * intermediate containers.
   * 
   * @param ancestor Another Gtk::Widget.
   * @return <tt>true</tt> if @a ancestor contains @a widget as a child,
   * grandchild, great grandchild, etc.
   */
  bool is_ancestor(Widget & ancestor) const;

  
  /** Translate coordinates relative to @a src_widget’s allocation to coordinates
   * relative to @a dest_widget’s allocations. In order to perform this
   * operation, both widget must share a common toplevel.
   * 
   * @param dest_widget A Gtk::Widget.
   * @param src_x X position relative to @a src_widget.
   * @param src_y Y position relative to @a src_widget.
   * @param dest_x Location to store X position relative to @a dest_widget.
   * @param dest_y Location to store Y position relative to @a dest_widget.
   * @return <tt>false</tt> if @a src_widget and @a dest_widget have no common
   * ancestor. In this case, 0 is stored in
   * * @a dest_x and * @a dest_y. Otherwise <tt>true</tt>.
   */
  bool translate_coordinates(Widget& dest_widget, int src_x, int src_y, int& dest_x, int& dest_y);

  
  /** Tests if the point at ( @a x, @a y) is contained in @a widget.
   * 
   * The coordinates for ( @a x, @a y) must be in widget coordinates, so
   * (0, 0) is assumed to be the top left of @a widget's content area.
   * 
   * @param x X coordinate to test, relative to @a widget's origin.
   * @param y Y coordinate to test, relative to @a widget's origin.
   * @return <tt>true</tt> if @a widget contains ( @a x, @a y).
   */
  bool contains(double x, double y) const;
  
  /** Finds the descendant of @a widget (including @a widget itself) closest
   * to the screen at the point ( @a x, @a y). The point must be given in
   * widget coordinates, so (0, 0) is assumed to be the top left of
   *  @a widget's content area.
   * 
   * Usually widgets will return <tt>nullptr</tt> if the given coordinate is not
   * contained in @a widget checked via contains(). Otherwise
   * they will recursively try to find a child that does not return <tt>nullptr</tt>.
   * Widgets are however free to customize their picking algorithm.
   * 
   * This function is used on the toplevel to determine the widget below
   * the mouse cursor for purposes of hover hilighting and delivering events.
   * 
   * @param x X coordinate to test, relative to @a widget's origin.
   * @param y Y coordinate to test, relative to @a widget's origin.
   * @param flags Flags to influence what is picked.
   * @return The widget descendant at the given
   * coordinate or <tt>nullptr</tt> if none.
   */
  Widget* pick(double x, double y, PickFlags flags =  PickFlags::DEFAULT);
  
  /** Finds the descendant of @a widget (including @a widget itself) closest
   * to the screen at the point ( @a x, @a y). The point must be given in
   * widget coordinates, so (0, 0) is assumed to be the top left of
   *  @a widget's content area.
   * 
   * Usually widgets will return <tt>nullptr</tt> if the given coordinate is not
   * contained in @a widget checked via contains(). Otherwise
   * they will recursively try to find a child that does not return <tt>nullptr</tt>.
   * Widgets are however free to customize their picking algorithm.
   * 
   * This function is used on the toplevel to determine the widget below
   * the mouse cursor for purposes of hover hilighting and delivering events.
   * 
   * @param x X coordinate to test, relative to @a widget's origin.
   * @param y Y coordinate to test, relative to @a widget's origin.
   * @param flags Flags to influence what is picked.
   * @return The widget descendant at the given
   * coordinate or <tt>nullptr</tt> if none.
   */
  const Widget* pick(double x, double y, PickFlags flags =  PickFlags::DEFAULT) const;

  
  /** Adds @a controller to @a widget so that it will receive events. You will
   * usually want to call this function right after creating any kind of
   * Gtk::EventController.
   * 
   * @param controller A Gtk::EventController that hasn't been
   * added to a widget yet.
   */

  void add_controller(const Glib::RefPtr<EventController>& controller);
  
  /** Removes @a controller from @a widget, so that it doesn't process
   * events anymore. It should not be used again.
   * 
   * Widgets will remove all event controllers automatically when they
   * are destroyed, there is normally no need to call this function.
   * 
   * @param controller A Gtk::EventController.
   */
  void remove_controller(const Glib::RefPtr<EventController>& controller);

  
  /** Updates the style context of @a widget and all descendants
   * by updating its widget path. Gtk::Containers may want
   * to use this on a child when reordering it in a way that a different
   * style might apply to it.
   */
  void reset_style();

  
  /** Creates a new Pango::Context with the appropriate font map,
   * font options, font description, and base direction for drawing
   * text for this widget. See also get_pango_context().
   * 
   * @return The new Pango::Context.
   */
  Glib::RefPtr<Pango::Context> create_pango_context();
  
  /** Gets a Pango::Context with the appropriate font map, font description,
   * and base direction for this widget. Unlike the context returned
   * by create_pango_context(), this context is owned by
   * the widget (it can be used until the screen for the widget changes
   * or the widget is removed from its toplevel), and will be updated to
   * match any changes to the widget’s attributes. This can be tracked
   * by using the Gtk::Widget::signal_display_changed() signal on the widget.
   * 
   * @return The Pango::Context for the widget.
   */
  Glib::RefPtr<Pango::Context> get_pango_context();

  
  /** Sets the #cairo_font_options_t used for Pango rendering in this widget.
   * When not set, the default font options for the Gdk::Display will be used.
   * 
   * @param options A #cairo_font_options_t, or <tt>nullptr</tt> to unset any
   * previously set default font options.
   */
  void set_font_options(const Cairo::FontOptions& options);
  /** Undoes the effect of previous calls to set_font_options().
   *
   * @newin{3,20}
   */
  void unset_font_options();
  // This returns a const, so we assume that we must copy it:
 

  /** Returns the #cairo_font_options_t used for Pango rendering. When not set,
   * the defaults font options for the Gdk::Display will be used.
   * 
   * @return The #cairo_font_options_t or <tt>nullptr</tt> if not set.
   */
  Cairo::FontOptions get_font_options() const;

  
  /** Creates a new Pango::Layout with the appropriate font map,
   * font description, and base direction for drawing text for
   * this widget.
   * 
   * If you keep a Pango::Layout created in this way around, you need
   * to re-create it when the widget Pango::Context is replaced.
   * This can be tracked by using the Gtk::Widget::signal_display_changed() signal
   * on the widget.
   * 
   * @param text Text to set on the layout (can be <tt>nullptr</tt>).
   * @return The new Pango::Layout.
   */
  Glib::RefPtr<Pango::Layout> create_pango_layout(const Glib::ustring& text);

/* Directionality of Text */

  
  /** Sets the reading direction on a particular widget. This direction
   * controls the primary direction for widgets containing text,
   * and also the direction in which the children of a container are
   * packed. The ability to set the direction is present in order
   * so that correct localization into languages with right-to-left
   * reading directions can be done. Generally, applications will
   * let the default reading direction present, except for containers
   * where the containers are arranged in an order that is explicitly
   * visual rather than logical (such as buttons for text justification).
   * 
   * If the direction is set to Gtk::TextDirection::NONE, then the value
   * set by set_default_direction() will be used.
   * 
   * @param dir The new direction.
   */
  void set_direction(TextDirection dir);
  
  /** Gets the reading direction for a particular widget. See
   * set_direction().
   * 
   * @return The reading direction for the widget.
   */
  TextDirection get_direction() const;

  
  /** Sets the default reading direction for widgets where the
   * direction has not been explicitly set by set_direction().
   * 
   * @param dir The new default direction. This cannot be
   * Gtk::TextDirection::NONE.
   */
  static void set_default_direction(TextDirection dir);
  
  /** Obtains the current default reading direction. See
   * set_default_direction().
   * 
   * @return The current default direction.
   */
  static TextDirection get_default_direction();

  
  /** Sets an input shape for this widget’s GDK surface. This allows for
   * windows which react to mouse click in a nonrectangular region, see
   * gdk_surface_input_shape_combine_region() for more information.
   * 
   * @param region Shape to be added, or <tt>nullptr</tt> to remove an existing shape.
   */
  void input_shape_combine_region(const Cairo::RefPtr<const Cairo::Region>& region);

  
  /** Sets the cursor to be shown when pointer devices point towards @a widget.
   * 
   * If the @a cursor is <tt>nullptr</tt>, @a widget will use the cursor inherited from the
   * parent widget.
   * 
   * @param cursor The new cursor or <tt>nullptr</tt> to use the default
   * cursor.
   */
  void set_cursor(const Glib::RefPtr<Gdk::Cursor>& cursor);

  
  /** Sets a named cursor to be shown when pointer devices point towards the widget.
   *
   * This is a utility function that creates a cursor and then sets it on the widget.
   *
   * If the @a name is an empty string, the widget will use the cursor specified via CSS
   * or the parent widget. If neither specifies a cursor, the default cursor
   * will be shown. This is the default behavior.
   *
   * @newin{3,94}
   *
   * @param name The name of the cursor, or an empty string to use the default cursor.
   */
  void set_cursor(const Glib::ustring& name =  {});
  
  /** Queries the cursor set via set_cursor(). See that function for
   * details.
   * 
   * @return The cursor currently in use or <tt>nullptr</tt>
   * to use the default.
   */
  Glib::RefPtr<Gdk::Cursor> get_cursor();
  
  /** Queries the cursor set via set_cursor(). See that function for
   * details.
   * 
   * @return The cursor currently in use or <tt>nullptr</tt>
   * to use the default.
   */
  Glib::RefPtr<const Gdk::Cursor> get_cursor() const;

 
  /** Returns a newly allocated list of the widgets, normally labels, for
   * which this widget is the target of a mnemonic (see for example,
   * Gtk::Label::set_mnemonic_widget()).
   * 
   * The widgets in the list are not individually referenced. If you
   * want to iterate through the list and perform actions involving
   * callbacks that might destroy the widgets, you
   * must call `g_list_foreach (result,
   * (GFunc)g_object_ref, <tt>nullptr</tt>)` first, and then unref all the
   * widgets afterwards.
   * 
   * @return The list of
   * mnemonic labels; free this list
   * with Glib::list_free() when you are done with it.
   */
  std::vector<Widget*> list_mnemonic_labels();
 

  /** Returns a newly allocated list of the widgets, normally labels, for
   * which this widget is the target of a mnemonic (see for example,
   * Gtk::Label::set_mnemonic_widget()).
   * 
   * The widgets in the list are not individually referenced. If you
   * want to iterate through the list and perform actions involving
   * callbacks that might destroy the widgets, you
   * must call `g_list_foreach (result,
   * (GFunc)g_object_ref, <tt>nullptr</tt>)` first, and then unref all the
   * widgets afterwards.
   * 
   * @return The list of
   * mnemonic labels; free this list
   * with Glib::list_free() when you are done with it.
   */
  std::vector<const Widget*> list_mnemonic_labels() const;
 
  /** Adds a widget to the list of mnemonic labels for
   * this widget. (See list_mnemonic_labels()). Note the
   * list of mnemonic labels for the widget is cleared when the
   * widget is destroyed, so the caller must make sure to update
   * its internal state at this point as well.
   * 
   * @newin{2,4}
   * 
   * @param label A Gtk::Widget that acts as a mnemonic label for @a widget.
   */
  void add_mnemonic_label(Widget& label);
 
  /** Removes a widget from the list of mnemonic labels for
   * this widget. (See list_mnemonic_labels()). The widget
   * must have previously been added to the list with
   * add_mnemonic_label().
   * 
   * @param label A Gtk::Widget that was previously set as a mnemonic label for
   *  @a widget with add_mnemonic_label().
   */
  void remove_mnemonic_label(Widget& label);

  
  /** Checks to see if a mouse drag starting at ( @a start_x, @a start_y) and ending
   * at ( @a current_x, @a current_y) has passed the GTK drag threshold, and thus
   * should trigger the beginning of a drag-and-drop operation.
   * 
   * @param start_x X coordinate of start of drag.
   * @param start_y Y coordinate of start of drag.
   * @param current_x Current X coordinate.
   * @param current_y Current Y coordinate.
   * @return <tt>true</tt> if the drag threshold has been passed.
   */
  bool drag_check_threshold(int start_x, int start_y, int current_x, int current_y);

  
  /** Obtains the frame clock for a widget. The frame clock is a global
   * “ticker” that can be used to drive animations and repaints.  The
   * most common reason to get the frame clock is to call
   * gdk_frame_clock_get_frame_time(), in order to get a time to use for
   * animating. For example you might record the start of the animation
   * with an initial value from gdk_frame_clock_get_frame_time(), and
   * then update the animation by calling
   * gdk_frame_clock_get_frame_time() again during each repaint.
   * 
   * gdk_frame_clock_request_phase() will result in a new frame on the
   * clock, but won’t necessarily repaint any widgets. To repaint a
   * widget, you have to use queue_draw() which invalidates
   * the widget (thus scheduling it to receive a draw on the next
   * frame). queue_draw() will also end up requesting a frame
   * on the appropriate frame clock.
   * 
   * A widget’s frame clock will not change while the widget is
   * mapped. Reparenting a widget (which implies a temporary unmap) can
   * change the widget’s frame clock.
   * 
   * Unrealized widgets do not have a frame clock.
   * 
   * @newin{3,24}
   * 
   * @return A Gdk::FrameClock,
   * or <tt>nullptr</tt> if widget is unrealized.
   */
  Glib::RefPtr<Gdk::FrameClock> get_frame_clock();
  
  /** Obtains the frame clock for a widget. The frame clock is a global
   * “ticker” that can be used to drive animations and repaints.  The
   * most common reason to get the frame clock is to call
   * gdk_frame_clock_get_frame_time(), in order to get a time to use for
   * animating. For example you might record the start of the animation
   * with an initial value from gdk_frame_clock_get_frame_time(), and
   * then update the animation by calling
   * gdk_frame_clock_get_frame_time() again during each repaint.
   * 
   * gdk_frame_clock_request_phase() will result in a new frame on the
   * clock, but won’t necessarily repaint any widgets. To repaint a
   * widget, you have to use queue_draw() which invalidates
   * the widget (thus scheduling it to receive a draw on the next
   * frame). queue_draw() will also end up requesting a frame
   * on the appropriate frame clock.
   * 
   * A widget’s frame clock will not change while the widget is
   * mapped. Reparenting a widget (which implies a temporary unmap) can
   * change the widget’s frame clock.
   * 
   * Unrealized widgets do not have a frame clock.
   * 
   * @newin{3,24}
   * 
   * @return A Gdk::FrameClock,
   * or <tt>nullptr</tt> if widget is unrealized.
   */
  Glib::RefPtr<const Gdk::FrameClock> get_frame_clock() const;

  //Used when implementing containers:
  
  /** This function is useful only when implementing subclasses of
   * Gtk::Widget.
   * Sets @a parent as the parent widget of @a widget, and takes care of
   * some details such as updating the state and style of the child
   * to reflect its new location and resizing the parent. The opposite
   * function is unparent().
   * 
   * @param parent Parent widget.
   */
  void set_parent(Widget& parent);
  
  /** This function is only for use in widget implementations.
   * Should be called by parent widgets to dissociate @a widget
   * from the parent.
   */
  void unparent();

  //TODO: When exactly do we need to custom containers need to call map() on the child widgets?
  //Most containers that derive from GtkContainer do not need to, but GtkNotebook does.
  
  /** This function is only for use in widget implementations. Causes
   * a widget to be mapped if it isn’t already.
   */
  void map();
  
  /** This function is only for use in widget implementations. Causes
   * a widget to be unmapped if it’s currently mapped.
   */
  void unmap();

  // Gtk+ 2.12 tooltip API
  
  /** Triggers a tooltip query on the display where the toplevel of @a widget
   * is located. See gtk_tooltip_trigger_tooltip_query() for more
   * information.
   */
  void trigger_tooltip_query();
  
  /** Sets @a text as the contents of the tooltip. This function will take
   * care of setting Gtk::Widget::property_has_tooltip() to <tt>true</tt> and of the default
   * handler for the Gtk::Widget::signal_query_tooltip() signal.
   * 
   * See also the Gtk::Widget::property_tooltip_text() property and Gtk::Tooltip::set_text().
   * 
   * @param text The contents of the tooltip for @a widget.
   */
  void set_tooltip_text(const Glib::ustring& text);
  
  /** Gets the contents of the tooltip for @a widget.
   * 
   * @return The tooltip text.
   */
  Glib::ustring get_tooltip_text() const;
  
  /** Sets @a markup as the contents of the tooltip, which is marked up with
   * the Pango text markup language.
   * 
   * This function will take care of setting GtkWidget:has-tooltip to <tt>true</tt>
   * and of the default handler for the GtkWidget::query-tooltip signal.
   * 
   * See also the GtkWidget:tooltip-markup property and
   * Gtk::Tooltip::set_markup().
   * 
   * @newin{2,12}
   * 
   * @param markup The contents of the tooltip for @a widget.
   */
  void set_tooltip_markup(const Glib::ustring& markup);
  
  /** Gets the contents of the tooltip for @a widget.
   * 
   * @return The tooltip text.
   */
  Glib::ustring get_tooltip_markup() const;
  
  /** Sets the has-tooltip property on @a widget to @a has_tooltip.  See
   * Gtk::Widget::property_has_tooltip() for more information.
   * 
   * @param has_tooltip Whether or not @a widget has a tooltip.
   */
  void set_has_tooltip(bool has_tooltip =  TRUE);
  
  /** Returns the current value of the has-tooltip property.  See
   * Gtk::Widget::property_has_tooltip() for more information.
   * 
   * @return Current value of has-tooltip on @a widget.
   */
  bool get_has_tooltip() const;

  
  /** Returns whether the widget is currently being destroyed.
   * This information can sometimes be used to avoid doing
   * unnecessary work.
   * 
   * @return <tt>true</tt> if @a widget is being destroyed.
   */
  bool in_destruction() const;

  
  /** Returns the style context associated to @a widget. The returned object is
   * guaranteed to be the same for the lifetime of @a widget.
   * 
   * @return A Gtk::StyleContext. This memory is owned by @a widget and
   * must not be freed.
   */
  Glib::RefPtr<StyleContext> get_style_context();
  
  /** Returns the style context associated to @a widget. The returned object is
   * guaranteed to be the same for the lifetime of @a widget.
   * 
   * @return A Gtk::StyleContext. This memory is owned by @a widget and
   * must not be freed.
   */
  Glib::RefPtr<const StyleContext> get_style_context() const;

  
  /** Returns the modifier mask the @a widget’s windowing system backend
   * uses for a particular purpose.
   * 
   * See gdk_keymap_get_modifier_mask().
   * 
   * @param intent The use case for the modifier mask.
   * @return The modifier mask used for @a intent.
   */
  Gdk::ModifierType get_modifier_mask(Gdk::ModifierIntent intent);

  /** Callback type for adding a function to update animations. See add_tick_callback().
   *
   * For instance:
   * @code
   * bool on_tick(const Glib::RefPtr<Gdk::FrameClock>& frame_clock);
   * @endcode
   *
   * @param frame_clock The frame clock for the widget (same as calling get_frame_clock()).
   * @return <tt>true</tt> if the tick callback should continue to be called,
   *         <tt>false</tt> if the tick callback should be removed.
   *
   * @newin{3,24}
   */
  using SlotTick = sigc::slot<bool(const Glib::RefPtr<Gdk::FrameClock>&)>;

  /** Queues an animation frame update and adds a callback to be called
   * before each frame.
   *
   * Until the tick callback is removed, it will be
   * called frequently (usually at the frame rate of the output device
   * or as quickly as the application can be repainted, whichever is
   * slower). For this reason, is most suitable for handling graphics
   * that change every frame or every few frames. The tick callback does
   * not automatically imply a relayout or repaint. If you want a
   * repaint or relayout, and aren’t changing widget properties that
   * would trigger that (for example, changing the text of a Gtk::Label),
   * then you will have to call queue_resize() or queue_draw_area() yourself.
   *
   * Gdk::FrameClock::get_frame_time() should generally be used for timing
   * continuous animations and
   * Gdk::FrameTimings::get_predicted_presentation_time() if you are
   * trying to display isolated frames at particular times.
   *
   * This is a more convenient alternative to connecting directly to the
   * Gdk::FrameClock::signal_update() signal of Gdk::FrameClock, since you don't
   * have to worry about when a Gdk::FrameClock is assigned to a widget.
   *
   * @newin{3,24}
   *
   * @param slot Slot to call for updating animations.
   * @return An id for the connection of this callback. Remove the callback
   *         by passing it to remove_tick_callback().
   */
  guint add_tick_callback(const SlotTick& slot);
  

  /** Removes a tick callback previously registered with
   * add_tick_callback().
   * 
   * @newin{3,24}
   * 
   * @param id An id returned by add_tick_callback().
   */
  void remove_tick_callback(guint id);

  //This is mostly only needed by the class itself, so it could be protected,
  //but it is sometimes helpful to call it from outside:
  
  /** Inserts @a group into @a widget. Children of @a widget that implement
   * Gtk::Actionable can then be associated with actions in @a group by
   * setting their “action-name” to @a prefix.`action-name`.
   * 
   * Note that inheritance is defined for individual actions. I.e.
   * even if you insert a group with prefix @a prefix, actions with
   * the same prefix will still be inherited from the parent, unless
   * the group contains an action with the same name.
   * 
   * If @a group is <tt>nullptr</tt>, a previously inserted group for @a name is
   * removed from @a widget.
   * 
   * @param name The prefix for actions in @a group.
   * @param group A Gio::ActionGroup, or <tt>nullptr</tt>.
   */
  void insert_action_group(const Glib::ustring& name, const Glib::RefPtr<Gio::ActionGroup>& group);

  /** Removes a group from the widget.
   * See insert_action_group().
   *
   * @param name The prefix for actions.
   *
   * @newin{3,10}
   */
  void remove_action_group(const Glib::ustring& name);

  
  /** Looks up the action in the action groups associated
   * with the widget and its ancestors, and activates it.
   *
   * If the action is in an action group added with
   * insert_action_group(), the @a name is
   * expected to be prefixed with the prefix that was
   * used when the group was inserted.
   *
   * The arguments must match the action's expected parameter
   * type, as returned by Gio::Action::get_parameter_type().
   *
   * @param name The name of the action to activate.
   * @param args Parameters to use. If the action does not expect parameters,
   *             use the activate_action() overload without the @a args argument.
   * @return <tt>true</tt> if the action was activated, <tt>false</tt> if the
   *         action does not exist.
   */
  bool activate_action(const Glib::ustring& name, const Glib::VariantBase& args);

  /// A activate_action() convenience overload.
  bool activate_action(const Glib::ustring& name);
  
  
  /** Activate the default.activate action from @a widget.
   */
  void activate_default();

  
  /** Sets the font map to use for Pango rendering. When not set, the widget
   * will inherit the font map from its parent.
   * 
   * @param font_map A Pango::FontMap, or <tt>nullptr</tt> to unset any previously
   * set font map.
   */
  void set_font_map(const Glib::RefPtr<Pango::FontMap>& font_map);
  
  /** Gets the font map that has been set with set_font_map().
   * 
   * @return A Pango::FontMap, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<Pango::FontMap> get_font_map();
  
  /** Gets the font map that has been set with set_font_map().
   * 
   * @return A Pango::FontMap, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Pango::FontMap> get_font_map() const;

  
  /** @return The widget's first child.
   */
  Widget* get_first_child();
  
  /** @return The widget's first child.
   */
  const Widget* get_first_child() const;
  
  /** @return The widget's last child.
   */
  Widget* get_last_child();
  
  /** @return The widget's last child.
   */
  const Widget* get_last_child() const;
  
  /** @return The widget's next sibling.
   */
  Widget* get_next_sibling();
  
  /** @return The widget's next sibling.
   */
  const Widget* get_next_sibling() const;
  
  /** @return The widget's previous sibling.
   */
  Widget* get_prev_sibling();
  
  /** @return The widget's previous sibling.
   */
  const Widget* get_prev_sibling() const;

  
  /** Returns a ListModel to track the children of @a widget. 
   * 
   * Calling this function will enable extra internal bookkeeping to track
   * children and emit signals on the returned listmodel. It may slow down
   * operations a lot.
   * 
   * Applications should try hard to avoid calling this function because of
   * the slowdowns.
   * 
   * @return A ListModel tracking @a widget's children.
   */
  Glib::RefPtr<Gio::ListModel> observe_children();
  
  /** Returns a ListModel to track the children of @a widget. 
   * 
   * Calling this function will enable extra internal bookkeeping to track
   * children and emit signals on the returned listmodel. It may slow down
   * operations a lot.
   * 
   * Applications should try hard to avoid calling this function because of
   * the slowdowns.
   * 
   * @return A ListModel tracking @a widget's children.
   */
  Glib::RefPtr<const Gio::ListModel> observe_children() const;
  
  /** Returns a ListModel to track the Gtk::EventControllers of @a widget. 
   * 
   * Calling this function will enable extra internal bookkeeping to track
   * controllers and emit signals on the returned listmodel. It may slow down
   * operations a lot.
   * 
   * Applications should try hard to avoid calling this function because of
   * the slowdowns.
   * 
   * @return A ListModel tracking @a widget's controllers.
   */
  Glib::RefPtr<Gio::ListModel> observe_controllers();
  
  /** Returns a ListModel to track the Gtk::EventControllers of @a widget. 
   * 
   * Calling this function will enable extra internal bookkeeping to track
   * controllers and emit signals on the returned listmodel. It may slow down
   * operations a lot.
   * 
   * Applications should try hard to avoid calling this function because of
   * the slowdowns.
   * 
   * @return A ListModel tracking @a widget's controllers.
   */
  Glib::RefPtr<const Gio::ListModel> observe_controllers() const;

  
  /** Inserts the %Widget into the child widget list of @a parent after @a previous_sibling.
   *
   * After calling this function, get_prev_sibling() will return @a previous_sibling.
   *
   * If @a parent is already set as the parent widget of the %Widget, this function can also be used
   * to reorder the %Widget in the child widget list of @a parent.
   *
   * @param parent The parent Gtk::Widget to insert the %Widget into.
   * @param previous_sibling The new previous sibling of the %Widget.
   */
  void insert_after(Widget& parent, const Widget& previous_sibling);

  
  /** Inserts the %Widget into the child widget list of @a parent before @a next_sibling.
   *
   * After calling this function, get_next_sibling() will return @a next_sibling.
   *
   * If @a parent is already set as the parent widget of the %Widget, this function can also be used
   * to reorder the %Widget in the child widget list of @a parent.
   *
   * @param parent The parent Gtk::Widget to insert the %Widget into.
   * @param next_sibling The new next sibling of the %Widget.
   */
  void insert_before(Widget& parent, const Widget& next_sibling);

  /** Inserts the %Widget at the beginning of the child widget list of @a parent.
   *
   * After calling this function, get_prev_sibling() will return <tt>nullptr</tt>.
   *
   * If @a parent is already set as the parent of the %Widget, this function can also be used
   * to reorder the %Widget in the child widget list of @a parent.
   *
   * @param parent The parent Gtk::Widget to insert the %Widget into.
   */
  void insert_at_start(Widget& parent);

  /** Inserts the %Widget at the end of the child widget list of @a parent.
   *
   * After calling this function, get_next_sibling() will return <tt>nullptr</tt>.
   *
   * If @a parent is already set as the parent of the %Widget, this function can also be used
   * to reorder the %Widget in the child widget list of @a parent.
   *
   * @param parent The parent Gtk::Widget to insert the %Widget into.
   */
  void insert_at_end(Widget& parent);

  
  /** When a widget receives a call to the snapshot function, it must send
   * synthetic Gtk::Widget::signal_snapshot() calls to all children. This function
   * provides a convenient way of doing this. A widget, when it receives
   * a call to its Gtk::Widget::signal_snapshot() function, calls
   * snapshot_child() once for each child, passing in
   * the @a snapshot the widget received.
   * 
   * snapshot_child() takes care of translating the origin of
   *  @a snapshot, and deciding whether the child needs to be snapshot.
   * 
   * This function does nothing for children that implement Gtk::Native.
   * 
   * @param child A child of @a widget.
   * @param snapshot Gtk::Snapshot as passed to the widget. In particular, no
   * calls to Gtk::Snapshot::translate() or other transform calls should
   * have been made.
   */
  void snapshot_child(Widget& child, const Glib::RefPtr<Gtk::Snapshot>& snapshot);

  
  /** Returns whether @a widget should contribute to
   * the measuring and allocation of its parent.
   * This is <tt>false</tt> for invisible children, but also
   * for children that have their own surface.
   * 
   * @return <tt>true</tt> if child should be included in
   * measuring and allocating.
   */
  bool should_layout() const;

  
  /** Adds @a css_class to @a widget. After calling this function, @a widget's
   * style will match for @a css_class, after the CSS matching rules.
   * 
   * @param css_class The style class to add to @a widget, without
   * the leading '.' used for notation of style classes.
   */
  void add_css_class(const Glib::ustring& css_class);
  
  /** Removes @a css_class from @a widget. After this, the style of @a widget
   * will stop matching for @a css_class.
   * 
   * @param css_class The style class to remove from @a widget, without
   * the leading '.' used for notation of style classes.
   */
  void remove_css_class(const Glib::ustring& css_class);
  
  /** Returns whether @a css_class is currently applied to @a widget.
   * 
   * @param css_class A CSS style class, without the leading '.'
   * used for notation of style classes.
   * @return <tt>true</tt> if @a css_class is currently applied to @a widget,
   * <tt>false</tt> otherwise.
   */
  bool has_css_class(const Glib::ustring& css_class) const;

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%show()</tt>
   *
   * Flags: Run First
   *
   * The signal_show() signal is emitted when @a widget is shown, for example with
   * Gtk::Widget::show().
   */

  Glib::SignalProxy<void()> signal_show();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%hide()</tt>
   *
   * Flags: Run First
   *
   * The signal_hide() signal is emitted when @a widget is hidden, for example with
   * Gtk::Widget::hide().
   */

  Glib::SignalProxy<void()> signal_hide();


  /// Emitted on mapping of a widget to the screen.
  //- See {flags.mapped}.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%map()</tt>
   *
   * Flags: Run First
   *
   * The signal_map() signal is emitted when @a widget is going to be mapped, that is
   * when the widget is visible (which is controlled with
   * Gtk::Widget::set_visible()) and all its parents up to the toplevel widget
   * are also visible.
   * 
   * The signal_map() signal can be used to determine whether a widget will be drawn,
   * for instance it can resume an animation that was stopped during the
   * emission of Gtk::Widget::signal_unmap().
   */

  Glib::SignalProxy<void()> signal_map();


  //- See {flags.mapped}.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%unmap()</tt>
   *
   * Flags: Run First
   *
   * The signal_unmap() signal is emitted when @a widget is going to be unmapped, which
   * means that either it or any of its parents up to the toplevel widget have
   * been set as hidden.
   * 
   * As signal_unmap() indicates that a widget will not be shown any longer, it can be
   * used to, for example, stop an animation on the widget.
   */

  Glib::SignalProxy<void()> signal_unmap();


  /// Emitted on realization of a widget.
  //- See {flags.realized}.  This is also responsible for
  //- setting {flags.realized} when it is done.  Therefore,
  //- when overriding the impl method, you should call the
  //- default realize method.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%realize()</tt>
   *
   * Flags: Run First
   *
   * The signal_realize() signal is emitted when @a widget is associated with a
   * Gdk::Surface, which means that Gtk::Widget::realize() has been called or the
   * widget has been mapped (that is, it is going to be drawn).
   */

  Glib::SignalProxy<void()> signal_realize();


  //- See {flags.realized}.  This should not be called by the user.
  //__WRAP(meth|sig|impl,void unrealize_(),gtk_widget_unrealize,"unrealize")
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%unrealize()</tt>
   *
   * Flags: Run Last
   *
   * The signal_unrealize() signal is emitted when the Gdk::Surface associated with
   *  @a widget is destroyed, which means that Gtk::Widget::unrealize() has been
   * called or the widget has been unmapped (that is, it is going to be
   * hidden).
   */

  Glib::SignalProxy<void()> signal_unrealize();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%size_allocate(int width, int height, int baseline)</tt>
   *
   * Flags: Run First
   *
   * @param width The content width of the widget.
   * @param height The content height of the widget.
   * @param baseline The baseline.
   */

  Glib::SignalProxy<void(int, int, int)> signal_size_allocate();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%state_flags_changed(Gtk::StateFlags previous_state_flags)</tt>
   *
   * Flags: Run First
   *
   * The signal_state_flags_changed() signal is emitted when the widget state
   * changes, see Gtk::Widget::get_state_flags().
   * 
   * @param previous_state_flags The previous state flags.
   */

  Glib::SignalProxy<void(Gtk::StateFlags)> signal_state_flags_changed();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%direction_changed(TextDirection direction)</tt>
   *
   * Flags: Run First
   *
   * The signal_direction_changed() signal is emitted when the text direction
   * of a widget changes.
   * 
   * @param direction The previous text direction of @a widget.
   */

  Glib::SignalProxy<void(TextDirection)> signal_direction_changed();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%grab_notify(bool was_grabbed)</tt>
   *
   * Flags: Run First
   *
   * The signal_grab_notify() signal is emitted when a widget becomes
   * shadowed by a GTK+ grab (not a pointer or keyboard grab) on
   * another widget, or when it becomes unshadowed due to a grab
   * being removed.
   * 
   * A widget is shadowed by a gtk_grab_add() when the topmost
   * grab widget in the grab stack of its window group is not
   * its ancestor.
   * 
   * @param was_grabbed <tt>false</tt> if the widget becomes shadowed, <tt>true</tt>
   * if it becomes unshadowed.
   */

  Glib::SignalProxy<void(bool)> signal_grab_notify();


  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%mnemonic_activate(bool group_cycling)</tt>
   *
   * Flags: Run Last
   *
   * The default handler for this signal activates @a widget if @a group_cycling
   * is <tt>false</tt>, or just makes @a widget grab focus if @a group_cycling is <tt>true</tt>.
   * 
   * @param group_cycling <tt>true</tt> if there are other widgets with the same mnemonic.
   * @return <tt>true</tt> to stop other handlers from being invoked for the event.
   * <tt>false</tt> to propagate the event further.
   */

  Glib::SignalProxy<bool(bool)> signal_mnemonic_activate();


  // The accel_closures_changed signal can't have a default handler because the wrapped C signal has no default handler.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%accel_closures_changed()</tt>
   *
   * The signal_accel_closures_changed() signal gets emitted when accelerators for this
   * widget get added, removed or changed.
   */

  Glib::SignalProxy<void()> signal_accel_closures_changed();


//TODO: The signal_id is very C-like here:
  //_WRAP_SIGNAL(bool can_activate_accel(guint signal_id), "can_activate_accel")

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%popup_menu()</tt>
   *
   * Flags: Run Last, Action
   *
   * This signal gets emitted whenever a widget should pop up a context
   * menu. This usually happens through the standard key binding mechanism;
   * by pressing a certain key while a widget is focused, the user can cause
   * the widget to pop up a menu.  For example, the Gtk::Entry widget creates
   * a menu with clipboard commands. See the
   * [Popup Menu Migration Checklist][checklist-popup-menu]
   * for an example of how to use this signal.
   * 
   * @return <tt>true</tt> if a menu was activated.
   */

  Glib::SignalProxy<bool()> signal_popup_menu();
 //Note that popup-menu is a keybinding signal, but is really meant to be wrapped.

  
  //Keybinding signals:
  

  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%query_tooltip(int x, int y, bool keyboard_tooltip, const Glib::RefPtr<Tooltip>& tooltip)</tt>
   *
   * Flags: Run Last
   *
   * Emitted when Gtk::Widget::property_has_tooltip() is <tt>true</tt> and the hover timeout
   * has expired with the cursor hovering "above" @a widget; or emitted when @a widget got
   * focus in keyboard mode.
   * 
   * Using the given coordinates, the signal handler should determine
   * whether a tooltip should be shown for @a widget. If this is the case
   * <tt>true</tt> should be returned, <tt>false</tt> otherwise.  Note that if
   *  @a keyboard_tooltip is <tt>true</tt>, the values of @a x and @a y are undefined and
   * should not be used.
   * 
   * The signal handler is free to manipulate @a tooltip with the therefore
   * destined function calls.
   * 
   * @param x The x coordinate of the cursor position where the request has
   * been emitted, relative to @a widget's left side.
   * @param y The y coordinate of the cursor position where the request has
   * been emitted, relative to @a widget's top.
   * @param keyboard_tooltip <tt>true</tt> if the tooltip was triggered using the keyboard.
   * @param tooltip A Gtk::Tooltip.
   * @return <tt>true</tt> if @a tooltip should be shown right now, <tt>false</tt> otherwise.
   */

  Glib::SignalProxy<bool(int, int, bool, const Glib::RefPtr<Tooltip>&)> signal_query_tooltip();


  /** The name of the widget.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_name() ;

/** The name of the widget.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_name() const;

  /** The parent widget of this widget.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Container* > property_parent() const;


  /** The Gtk::Root widget of the widget tree containing this widget or <tt>nullptr</tt> if
   * the widget is not contained in a root widget.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Root* > property_root() const;


  /** Override for width request of the widget, or -1 if natural request should be used.
   *
   * Default value: -1
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_width_request() ;

/** Override for width request of the widget, or -1 if natural request should be used.
   *
   * Default value: -1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_width_request() const;

  /** Override for height request of the widget, or -1 if natural request should be used.
   *
   * Default value: -1
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_height_request() ;

/** Override for height request of the widget, or -1 if natural request should be used.
   *
   * Default value: -1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_height_request() const;

  /** Whether the widget is visible.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_visible() ;

/** Whether the widget is visible.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_visible() const;

  /** Whether the widget responds to input.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_sensitive() ;

/** Whether the widget responds to input.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_sensitive() const;

  /** Whether the widget can accept the input focus.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_can_focus() ;

/** Whether the widget can accept the input focus.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_can_focus() const;

  /** Whether the widget has the input focus.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_has_focus() ;

/** Whether the widget has the input focus.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_focus() const;

  /** Whether the widget is the focus widget within the toplevel.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_is_focus() ;

/** Whether the widget is the focus widget within the toplevel.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_is_focus() const;

  /** Whether the widget can receive pointer events.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_can_target() ;

/** Whether the widget can receive pointer events.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_can_target() const;

  /** Whether the widget should grab focus when it is clicked with the mouse.
   * 
   * This property is only relevant for widgets that can take focus.
   * 
   * Before 3.20, several widgets (GtkButton, GtkFileChooserButton,
   * GtkComboBox) implemented this property individually.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_focus_on_click() ;

/** Whether the widget should grab focus when it is clicked with the mouse.
   * 
   * This property is only relevant for widgets that can take focus.
   * 
   * Before 3.20, several widgets (GtkButton, GtkFileChooserButton,
   * GtkComboBox) implemented this property individually.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_focus_on_click() const;

  /** Whether the widget is the default widget.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_default() const;


  /** If <tt>true</tt>, the widget will receive the default action when it is focused.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_receives_default() ;

/** If <tt>true</tt>, the widget will receive the default action when it is focused.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_receives_default() const;

  /** The cursor used by @a widget. See Gtk::Widget::set_cursor() for details.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Cursor> > property_cursor() ;

/** The cursor used by @a widget. See Gtk::Widget::set_cursor() for details.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Cursor> > property_cursor() const;

  /** Enables or disables the emission of Gtk::Widget::signal_query_tooltip() on @a widget.
   * A value of <tt>true</tt> indicates that @a widget can have a tooltip, in this case
   * the widget will be queried using Gtk::Widget::signal_query_tooltip() to determine
   * whether it will provide a tooltip or not.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_has_tooltip() ;

/** Enables or disables the emission of Gtk::Widget::signal_query_tooltip() on @a widget.
   * A value of <tt>true</tt> indicates that @a widget can have a tooltip, in this case
   * the widget will be queried using Gtk::Widget::signal_query_tooltip() to determine
   * whether it will provide a tooltip or not.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_tooltip() const;

  /** Sets the text of tooltip to be the given string, which is marked up
   * with the [Pango text markup language][PangoMarkupFormat].
   * Also see Gtk::Tooltip::set_markup().
   * 
   * This is a convenience property which will take care of getting the
   * tooltip shown if the given string is not <tt>nullptr</tt>: Gtk::Widget::property_has_tooltip()
   * will automatically be set to <tt>true</tt> and there will be taken care of
   * Gtk::Widget::signal_query_tooltip() in the default signal handler.
   * 
   * Note that if both Gtk::Widget::property_tooltip_text() and Gtk::Widget::property_tooltip_markup()
   * are set, the last one wins.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_tooltip_markup() ;

/** Sets the text of tooltip to be the given string, which is marked up
   * with the [Pango text markup language][PangoMarkupFormat].
   * Also see Gtk::Tooltip::set_markup().
   * 
   * This is a convenience property which will take care of getting the
   * tooltip shown if the given string is not <tt>nullptr</tt>: Gtk::Widget::property_has_tooltip()
   * will automatically be set to <tt>true</tt> and there will be taken care of
   * Gtk::Widget::signal_query_tooltip() in the default signal handler.
   * 
   * Note that if both Gtk::Widget::property_tooltip_text() and Gtk::Widget::property_tooltip_markup()
   * are set, the last one wins.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_tooltip_markup() const;

  /** Sets the text of tooltip to be the given string.
   * 
   * Also see Gtk::Tooltip::set_text().
   * 
   * This is a convenience property which will take care of getting the
   * tooltip shown if the given string is not <tt>nullptr</tt>: Gtk::Widget::property_has_tooltip()
   * will automatically be set to <tt>true</tt> and there will be taken care of
   * Gtk::Widget::signal_query_tooltip() in the default signal handler.
   * 
   * Note that if both Gtk::Widget::property_tooltip_text() and Gtk::Widget::property_tooltip_markup()
   * are set, the last one wins.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_tooltip_text() ;

/** Sets the text of tooltip to be the given string.
   * 
   * Also see Gtk::Tooltip::set_text().
   * 
   * This is a convenience property which will take care of getting the
   * tooltip shown if the given string is not <tt>nullptr</tt>: Gtk::Widget::property_has_tooltip()
   * will automatically be set to <tt>true</tt> and there will be taken care of
   * Gtk::Widget::signal_query_tooltip() in the default signal handler.
   * 
   * Note that if both Gtk::Widget::property_tooltip_text() and Gtk::Widget::property_tooltip_markup()
   * are set, the last one wins.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_tooltip_text() const;


  /** How to distribute horizontal space if widget gets extra space, see Gtk::Align
   *
   * Default value: Gtk::Align::FILL
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Align > property_halign() ;

/** How to distribute horizontal space if widget gets extra space, see Gtk::Align
   *
   * Default value: Gtk::Align::FILL
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Align > property_halign() const;

  /** How to distribute vertical space if widget gets extra space, see Gtk::Align
   *
   * Default value: Gtk::Align::FILL
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Align > property_valign() ;

/** How to distribute vertical space if widget gets extra space, see Gtk::Align
   *
   * Default value: Gtk::Align::FILL
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Align > property_valign() const;

  /** Margin on start of widget, horizontally. This property supports
   * left-to-right and right-to-left text directions.
   * 
   * This property adds margin outside of the widget's normal size
   * request, the margin will be added in addition to the size from
   * Gtk::Widget::set_size_request() for example.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_margin_start() ;

/** Margin on start of widget, horizontally. This property supports
   * left-to-right and right-to-left text directions.
   * 
   * This property adds margin outside of the widget's normal size
   * request, the margin will be added in addition to the size from
   * Gtk::Widget::set_size_request() for example.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_margin_start() const;

  /** Margin on end of widget, horizontally. This property supports
   * left-to-right and right-to-left text directions.
   * 
   * This property adds margin outside of the widget's normal size
   * request, the margin will be added in addition to the size from
   * Gtk::Widget::set_size_request() for example.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_margin_end() ;

/** Margin on end of widget, horizontally. This property supports
   * left-to-right and right-to-left text directions.
   * 
   * This property adds margin outside of the widget's normal size
   * request, the margin will be added in addition to the size from
   * Gtk::Widget::set_size_request() for example.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_margin_end() const;

  /** Margin on top side of widget.
   * 
   * This property adds margin outside of the widget's normal size
   * request, the margin will be added in addition to the size from
   * Gtk::Widget::set_size_request() for example.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_margin_top() ;

/** Margin on top side of widget.
   * 
   * This property adds margin outside of the widget's normal size
   * request, the margin will be added in addition to the size from
   * Gtk::Widget::set_size_request() for example.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_margin_top() const;

  /** Margin on bottom side of widget.
   * 
   * This property adds margin outside of the widget's normal size
   * request, the margin will be added in addition to the size from
   * Gtk::Widget::set_size_request() for example.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_margin_bottom() ;

/** Margin on bottom side of widget.
   * 
   * This property adds margin outside of the widget's normal size
   * request, the margin will be added in addition to the size from
   * Gtk::Widget::set_size_request() for example.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_margin_bottom() const;

  /** Sets all four sides' margin at once. If read, returns max
   * margin on any side.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_margin() ;

/** Sets all four sides' margin at once. If read, returns max
   * margin on any side.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_margin() const;

  /** Whether to expand horizontally. See Gtk::Widget::set_hexpand().
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_hexpand() ;

/** Whether to expand horizontally. See Gtk::Widget::set_hexpand().
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_hexpand() const;

  /** Whether to use the Gtk::Widget::property_hexpand() property. See Gtk::Widget::get_hexpand_set().
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_hexpand_set() ;

/** Whether to use the Gtk::Widget::property_hexpand() property. See Gtk::Widget::get_hexpand_set().
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_hexpand_set() const;

  /** Whether to expand vertically. See Gtk::Widget::set_vexpand().
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_vexpand() ;

/** Whether to expand vertically. See Gtk::Widget::set_vexpand().
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_vexpand() const;

  /** Whether to use the Gtk::Widget::property_vexpand() property. See Gtk::Widget::get_vexpand_set().
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_vexpand_set() ;

/** Whether to use the Gtk::Widget::property_vexpand() property. See Gtk::Widget::get_vexpand_set().
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_vexpand_set() const;

  /** Whether to expand in both directions. Setting this sets both Gtk::Widget::property_hexpand() and Gtk::Widget::property_vexpand()
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_expand() ;

/** Whether to expand in both directions. Setting this sets both Gtk::Widget::property_hexpand() and Gtk::Widget::property_vexpand()
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_expand() const;

  /** The requested opacity of the widget. See Gtk::Widget::set_opacity() for
   * more details about window opacity.
   * 
   * Before 3.8 this was only available in GtkWindow
   *
   * Default value: 1
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_opacity() ;

/** The requested opacity of the widget. See Gtk::Widget::set_opacity() for
   * more details about window opacity.
   * 
   * Before 3.8 this was only available in GtkWindow
   *
   * Default value: 1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_opacity() const;

  /** How content outside the widget's content area is treated.
   * 
   * @newin{3,96}
   *
   * Default value: Gtk::Overflow::VISIBLE
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Overflow > property_overflow() ;

/** How content outside the widget's content area is treated.
   * 
   * @newin{3,96}
   *
   * Default value: Gtk::Overflow::VISIBLE
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Overflow > property_overflow() const;

  /** The scale factor of the widget. See Gtk::Widget::get_scale_factor() for
   * more details about widget scaling.
   *
   * Default value: 1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_scale_factor() const;


  /** The name of this widget in the CSS tree.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_css_name() const;


  /** The Gtk::LayoutManager instance to use to compute the preferred size
   * of the widget, and allocate its children.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<LayoutManager> > property_layout_manager() ;

/** The Gtk::LayoutManager instance to use to compute the preferred size
   * of the widget, and allocate its children.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<LayoutManager> > property_layout_manager() const;


protected:

    virtual void root_vfunc();

    virtual void unroot_vfunc();

    virtual SizeRequestMode get_request_mode_vfunc() const;

    virtual void measure_vfunc(Orientation orientation, int for_size, int& minimum, int& natural, int& minimum_baseline, int& natural_baseline) const;

    virtual bool grab_focus_vfunc();

  
#ifdef  GTKMM_ATKMM_ENABLED
  virtual Glib::RefPtr<Atk::Object> get_accessible_vfunc();

#endif //  GTKMM_ATKMM_ENABLED


    virtual void compute_expand_vfunc(bool& hexpand_p, bool& vexpand_p);

    virtual bool contains_vfunc(double x, double y) const;


    virtual void snapshot_vfunc(const Glib::RefPtr<Gtk::Snapshot>& snapshot);


protected:
  Widget();

  
  /** Creates the GDK (windowing system) resources associated with a
   * widget.  For example, @a widget->surface will be created when a widget
   * is realized.  Normally realization happens implicitly; if you show
   * a widget and all its parent containers, then the widget will be
   * realized and mapped automatically.
   * 
   * Realizing a widget requires all
   * the widget’s parent widgets to be realized; calling
   * realize() realizes the widget’s parents in addition to
   *  @a widget itself. If a widget is not yet inside a toplevel window
   * when you realize it, bad things will happen.
   * 
   * This function is primarily used in widget implementations, and
   * isn’t very useful otherwise. Many times when you think you might
   * need it, a better approach is to connect to a signal that will be
   * called after the widget is realized automatically, such as
   * Gtk::Widget::signal_realize().
   */
  void realize();
  
  /** This function is only useful in widget implementations.
   * Causes a widget to be unrealized (frees all GDK resources
   * associated with the widget, such as @a widget->surface).
   */
  void unrealize();

  void realize_if_needed();

  
  /** Set @a child as the current focus child of @a widget. The previous
   * focus child will be unset.
   * 
   * This function is only suitable for widget implementations.
   * If you want a certain widget to get the input focus, call
   * grab_focus() on it.
   * 
   * @param child A direct child widget of @a widget or <tt>nullptr</tt>
   * to unset the focus child of @a widget.
   */
  void set_focus_child(Widget& child);
  /** Unsets the focus child of the widget.
   *
   * The previous focus child will be unset.
   *
   * This function is only suitable for widget implementations.
   */
  void unset_focus_child();

  
  /** Returns the current focus child of @a widget.
   * 
   * @return The current focus child of @a widget,
   * or <tt>nullptr</tt> in case the focus child is unset.
   */
  Widget* get_focus_child();
  
  /** Returns the current focus child of @a widget.
   * 
   * @return The current focus child of @a widget,
   * or <tt>nullptr</tt> in case the focus child is unset.
   */
  const Widget* get_focus_child() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_show().
  virtual void on_show();
  /// This is a default handler for the signal signal_hide().
  virtual void on_hide();
  /// This is a default handler for the signal signal_map().
  virtual void on_map();
  /// This is a default handler for the signal signal_unmap().
  virtual void on_unmap();
  /// This is a default handler for the signal signal_realize().
  virtual void on_realize();
  /// This is a default handler for the signal signal_unrealize().
  virtual void on_unrealize();
  /// This is a default handler for the signal signal_size_allocate().
  virtual void on_size_allocate(int width, int height, int baseline);
  /// This is a default handler for the signal signal_state_flags_changed().
  virtual void on_state_flags_changed(Gtk::StateFlags previous_state_flags);
  /// This is a default handler for the signal signal_direction_changed().
  virtual void on_direction_changed(TextDirection direction);
  /// This is a default handler for the signal signal_grab_notify().
  virtual void on_grab_notify(bool was_grabbed);
  /// This is a default handler for the signal signal_mnemonic_activate().
  virtual bool on_mnemonic_activate(bool group_cycling);
  /// This is a default handler for the signal signal_popup_menu().
  virtual bool on_popup_menu();
  /// This is a default handler for the signal signal_query_tooltip().
  virtual bool on_query_tooltip(int x, int y, bool keyboard_tooltip, const Glib::RefPtr<Tooltip>& tooltip);


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Widget
   */
  Gtk::Widget* wrap(GtkWidget* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_WIDGET_H */

