// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!
#ifndef _GTKMM_ICONTHEME_H
#define _GTKMM_ICONTHEME_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <vector>

#include <gdkmm/paintable.h>
#include <gdkmm/display.h>
#include <gtkmm/enums.h>
#include <gtkmm/iconpaintable.h>
#include <giomm/icon.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkIconTheme = struct _GtkIconTheme;
using GtkIconThemeClass = struct _GtkIconThemeClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class IconTheme_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/** 
 *  @var IconLookupFlags FORCE_REGULAR
 * Try to always load regular icons, even
 * when symbolic icon names are given.
 * 
 *  @var IconLookupFlags FORCE_SYMBOLIC
 * Try to always load symbolic icons, even
 * when regular icon names are given.
 * 
 *  @var IconLookupFlags PRELOAD
 * Starts loading the texture in the background
 * so it is ready when later needed.
 * 
 *  @enum IconLookupFlags
 * 
 * Used to specify options for Gtk::IconTheme::lookup_icon()
 *
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>IconLookupFlags operator|(IconLookupFlags, IconLookupFlags)</tt><br>
 * <tt>IconLookupFlags operator&(IconLookupFlags, IconLookupFlags)</tt><br>
 * <tt>IconLookupFlags operator^(IconLookupFlags, IconLookupFlags)</tt><br>
 * <tt>IconLookupFlags operator~(IconLookupFlags)</tt><br>
 * <tt>IconLookupFlags& operator|=(IconLookupFlags&, IconLookupFlags)</tt><br>
 * <tt>IconLookupFlags& operator&=(IconLookupFlags&, IconLookupFlags)</tt><br>
 * <tt>IconLookupFlags& operator^=(IconLookupFlags&, IconLookupFlags)</tt><br>
 */
enum class IconLookupFlags
{
  FORCE_REGULAR = 1 << 0,
  FORCE_SYMBOLIC = 1 << 1,
  PRELOAD = 1 << 2
};

/** @ingroup gtkmmEnums */
inline IconLookupFlags operator|(IconLookupFlags lhs, IconLookupFlags rhs)
  { return static_cast<IconLookupFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline IconLookupFlags operator&(IconLookupFlags lhs, IconLookupFlags rhs)
  { return static_cast<IconLookupFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline IconLookupFlags operator^(IconLookupFlags lhs, IconLookupFlags rhs)
  { return static_cast<IconLookupFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline IconLookupFlags operator~(IconLookupFlags flags)
  { return static_cast<IconLookupFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline IconLookupFlags& operator|=(IconLookupFlags& lhs, IconLookupFlags rhs)
  { return (lhs = static_cast<IconLookupFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline IconLookupFlags& operator&=(IconLookupFlags& lhs, IconLookupFlags rhs)
  { return (lhs = static_cast<IconLookupFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline IconLookupFlags& operator^=(IconLookupFlags& lhs, IconLookupFlags rhs)
  { return (lhs = static_cast<IconLookupFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**  %Exception class for Gtk::IconTheme errors.
 */
class IconThemeError : public Glib::Error
{
public:
  /**  @var Code ICON_THEME_NOT_FOUND
   * The icon specified does not exist in the theme.
   * 
   *  @var Code ICON_THEME_FAILED
   * An unspecified error occurred.
   * 
   *  @enum Code
   * 
   * %Error codes for GtkIconTheme operations.
   */
  enum Code
  {
    ICON_THEME_NOT_FOUND,
    ICON_THEME_FAILED
  };

  IconThemeError(Code error_code, const Glib::ustring& error_message);
  explicit IconThemeError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::IconThemeError::Code> : public Glib::Value_Enum<Gtk::IconThemeError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{


/** Looking up icons by name.
 *
 * %Gtk::IconTheme provides a facility for looking up icons by name
 * and size. The main reason for using a name rather than simply
 * providing a filename is to allow different icons to be used
 * depending on what “icon theme” is selected by the user.
 * The operation of icon themes on Linux and Unix follows the
 * [IconPaintable Theme Specification](http://www.freedesktop.org/Standards/icon-theme-spec).
 * There is a fallback icon theme, named `hicolor`, where applications
 * should install their icons, but additional icon themes can be installed
 * as operating system vendors and users choose.
 *
 * In many cases, named themes are used indirectly, via Gtk::Image
 * rather than directly, but looking up icons
 * directly is also simple. The %Gtk::IconTheme object acts
 * as a database of all the icons in the current theme. You
 * can create new %Gtk::IconTheme objects, but it’s much more
 * efficient to use the standard icon theme for the Gdk::Display
 * so that the icon information is shared with other people
 * looking up icons. Use get_for_display().
 */

class IconTheme : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = IconTheme;
  using CppClassType = IconTheme_Class;
  using BaseObjectType = GtkIconTheme;
  using BaseClassType = GtkIconThemeClass;

  // noncopyable
  IconTheme(const IconTheme&) = delete;
  IconTheme& operator=(const IconTheme&) = delete;

private:  friend class IconTheme_Class;
  static CppClassType icontheme_class_;

protected:
  explicit IconTheme(const Glib::ConstructParams& construct_params);
  explicit IconTheme(GtkIconTheme* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  IconTheme(IconTheme&& src) noexcept;
  IconTheme& operator=(IconTheme&& src) noexcept;

  ~IconTheme() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkIconTheme*       gobj()       { return reinterpret_cast<GtkIconTheme*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkIconTheme* gobj() const { return reinterpret_cast<GtkIconTheme*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkIconTheme* gobj_copy();

private:

  
protected:
  IconTheme();
public:
  
  static Glib::RefPtr<IconTheme> create();


  /** Gets the icon theme object associated with @a display; if this
   * function has not previously been called for the given
   * display, a new icon theme object will be created and
   * associated with the display. Icon theme objects are
   * fairly expensive to create, so using this function
   * is usually a better choice than calling than new()
   * and setting the display yourself; by using this function
   * a single icon theme object will be shared between users.
   * 
   * @param display A Gdk::Display.
   * @return A unique Gtk::IconTheme associated with
   * the given display. This icon theme is associated with
   * the display and can be used as long as the display
   * is open. Do not ref or unref it.
   */
  static Glib::RefPtr<IconTheme> get_for_display(const Glib::RefPtr<Gdk::Display>& display);
  
  /** Sets the display for an icon theme; the display is used
   * to track the user’s currently configured icon theme,
   * which might be different for different displays.
   * 
   * @param display A Gdk::Display.
   */
  void set_display(const Glib::RefPtr<Gdk::Display>& display);
  void set_search_path(const std::vector<Glib::ustring>& path);
  std::vector<Glib::ustring> get_search_path() const;
  
  /** Appends a directory to the search path.
   * See set_search_path().
   * 
   * @param path Directory name to append to the icon path.
   */
  void append_search_path(const Glib::ustring& path);
  
  /** Prepends a directory to the search path.
   * See set_search_path().
   * 
   * @param path Directory name to prepend to the icon path.
   */
  void prepend_search_path(const Glib::ustring& path);

  
  /** Adds a resource path that will be looked at when looking
   * for icons, similar to search paths.
   * 
   * This function should be used to make application-specific icons
   * available as part of the icon theme.
   * 
   * The resources are considered as part of the hicolor icon theme
   * and must be located in subdirectories that are defined in the
   * hicolor icon theme, such as ` @a path/16x16/actions/run.png`.
   * Icons that are directly placed in the resource path instead
   * of a subdirectory are also considered as ultimate fallback.
   * 
   * @param path A resource path.
   */
  void add_resource_path(const std::string& path);

  
  /** Sets the name of the icon theme that the Gtk::IconTheme object uses
   * overriding system configuration. This function cannot be called
   * on the icon theme objects returned from get_for_display().
   * 
   * @param theme_name Name of icon theme to use instead of
   * configured theme, or <tt>nullptr</tt> to unset a previously set custom theme.
   */
  void set_custom_theme(const Glib::ustring& theme_name);
  
  /** Checks whether an icon theme includes an icon
   * for a particular name.
   * 
   * @param icon_name The name of an icon.
   * @return <tt>true</tt> if @a self includes an
   * icon for @a icon_name.
   */
  bool has_icon(const Glib::ustring& icon_name) const;

  
  /** Returns an array of integers describing the sizes at which
   * the icon is available without scaling. A size of -1 means
   * that the icon is available in a scalable format. The array
   * is zero-terminated.
   * 
   * @param icon_name The name of an icon.
   * @return A newly
   * allocated array describing the sizes at which the icon is
   * available.
   */

  std::vector<int> get_icon_sizes(const Glib::ustring& icon_name) const;

 
  /** Looks up a named icon for a desired size and window scale, returning a
   * Gtk::Icon. The icon can then be rendered by using it as a Gdk::Paintable,
   * or you can get information such as the filename and size.
   * 
   * If the available @a icon_name is not available and @a fallbacks are provided,
   * they will be tried in order.
   * 
   * If no matching icon is found, then a paintable that renders the
   * "missing icon" icon is returned. If you need to do something else
   * for missing icons you need to use has_icon().
   * 
   * Note that you probably want to listen for icon theme changes and
   * update the icon. This is usually done by overriding the
   * Gtk::Widget::property_css_changed() function.
   * 
   * @param icon_name The name of the icon to lookup.
   * @param size Desired icon size.
   * @param scale The window scale this will be displayed on.
   * @param direction Text direction the icon will be displayed in.
   * @param flags Flags modifying the behavior of the icon lookup.
   * @return A Gtk::IconPaintable object
   * containing the icon.
   */
  Glib::RefPtr<IconPaintable> lookup_icon(const Glib::ustring& icon_name, const std::vector<Glib::ustring>& fallbacks, int size, int scale =  1, TextDirection direction =  TextDirection::NONE, IconLookupFlags flags =  (IconLookupFlags)0);

  /// A lookup_icon() convenience overload.
  Glib::RefPtr<IconPaintable> lookup_icon(const Glib::ustring& icon_name, int size, int scale =  1, TextDirection direction =  TextDirection::NONE, IconLookupFlags flags =  (IconLookupFlags)0);
  
  /** Looks up a named icon for a desired size and window scale, returning a
   * Gtk::Icon. The icon can then be rendered by using it as a Gdk::Paintable,
   * or you can get information such as the filename and size.
   * 
   * If the available @a icon_name is not available and @a fallbacks are provided,
   * they will be tried in order.
   * 
   * If no matching icon is found, then a paintable that renders the
   * "missing icon" icon is returned. If you need to do something else
   * for missing icons you need to use has_icon().
   * 
   * Note that you probably want to listen for icon theme changes and
   * update the icon. This is usually done by overriding the
   * Gtk::Widget::property_css_changed() function.
   * 
   * @param icon_name The name of the icon to lookup.
   * @param size Desired icon size.
   * @param scale The window scale this will be displayed on.
   * @param direction Text direction the icon will be displayed in.
   * @param flags Flags modifying the behavior of the icon lookup.
   * @return A Gtk::IconPaintable object
   * containing the icon.
   */
  Glib::RefPtr<const IconPaintable> lookup_icon(const Glib::ustring& icon_name, const std::vector<Glib::ustring>& fallbacks, int size, int scale =  1, TextDirection direction =  TextDirection::NONE, IconLookupFlags flags =  (IconLookupFlags)0) const;

  /// A lookup_icon() convenience overload.
  Glib::RefPtr<const IconPaintable> lookup_icon(const Glib::ustring& icon_name, int size, int scale =  1, TextDirection direction =  TextDirection::NONE, IconLookupFlags flags =  (IconLookupFlags)0) const;

  
  /** Looks up a icon for a desired size and window scale, returning a
   * Gtk::Icon. The icon can then be rendered by using it as a Gdk::Paintable,
   * or you can get information such as the filename and size.
   * 
   * @param icon The Gio::Icon to look up.
   * @param size Desired icon size.
   * @param scale The desired scale.
   * @param direction Text direction the icon will be displayed in.
   * @param flags Flags modifying the behavior of the icon lookup.
   * @return A Gtk::IconPaintable containing
   * information about the icon. Unref with Glib::object_unref().
   */
  Glib::RefPtr<IconPaintable> lookup_icon(const Glib::RefPtr<const Gio::Icon>& icon, int size, int scale =  1, TextDirection direction =  TextDirection::NONE, IconLookupFlags flags =  (IconLookupFlags)0);
  
  /** Looks up a icon for a desired size and window scale, returning a
   * Gtk::Icon. The icon can then be rendered by using it as a Gdk::Paintable,
   * or you can get information such as the filename and size.
   * 
   * @param icon The Gio::Icon to look up.
   * @param size Desired icon size.
   * @param scale The desired scale.
   * @param direction Text direction the icon will be displayed in.
   * @param flags Flags modifying the behavior of the icon lookup.
   * @return A Gtk::IconPaintable containing
   * information about the icon. Unref with Glib::object_unref().
   */
  Glib::RefPtr<const IconPaintable> lookup_icon(const Glib::RefPtr<const Gio::Icon>& icon, int size, int scale =  1, TextDirection direction =  TextDirection::NONE, IconLookupFlags flags =  (IconLookupFlags)0) const;

 
  /** Lists the icons in the current icon theme.
   *
   * @return A vector holding the names of all the icons in the theme.
   */
  std::vector<Glib::ustring> list_icons() const;

  // no_default_handler because GtkIconThemeClass is private.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%changed()</tt>
   *
   * Flags: Run Last
   *
   * Emitted when the current icon theme is switched or GTK+ detects
   * that a change has occurred in the contents of the current
   * icon theme.
   */

  Glib::SignalProxy<void()> signal_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::IconTheme
   */
  Glib::RefPtr<Gtk::IconTheme> wrap(GtkIconTheme* object, bool take_copy = false);
}


#endif /* _GTKMM_ICONTHEME_H */

