// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!
#ifndef _GTKMM_FILECHOOSER_H
#define _GTKMM_FILECHOOSER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <vector>

#include <gtkmm/widget.h>
#include <gtkmm/filefilter.h>
#include <giomm/file.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkFileChooser = struct _GtkFileChooser;
using GtkFileChooserClass = struct _GtkFileChooserClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class FileChooser_Class; } // namespace Gtk
#endif // DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

//Note that GTK_FILE_SYSTEM_ERROR is not currently public GTK+ API and should
//never be instantiated by the GTK+ C API.

/**  %Exception class for Gdk::FileChooser errors.
 */
class FileChooserError : public Glib::Error
{
public:
  /**  @var Code NONEXISTENT
   * Indicates that a file does not exist.
   * 
   *  @var Code BAD_FILENAME
   * Indicates a malformed filename.
   * 
   *  @var Code ALREADY_EXISTS
   * Indicates a duplicate path (e.g. when
   * adding a bookmark).
   * 
   *  @var Code INCOMPLETE_HOSTNAME
   * Indicates an incomplete hostname (e.g. "http://foo" without a slash after that).
   * 
   *  @enum Code
   * 
   * These identify the various errors that can occur while calling
   * Gtk::FileChooser functions.
   */
  enum Code
  {
    NONEXISTENT,
    BAD_FILENAME,
    ALREADY_EXISTS,
    INCOMPLETE_HOSTNAME
  };

  FileChooserError(Code error_code, const Glib::ustring& error_message);
  explicit FileChooserError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::FileChooserError::Code> : public Glib::Value_Enum<Gtk::FileChooserError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{


/**
 * Gtk::FileChooser is an interface that can be implemented by file selection
 * widgets. In gtkmm, the main objects that implement this interface are
 * FileChooserWidget and FileChooserDialog. You do not need to write an
 * object that implements the FileChooser interface unless you are trying to
 * adapt an existing file selector to expose a standard programming interface.
 *
 * @par File Names and Encodings
 * When the user is finished selecting files in a FileChooser, your program
 * can get the selected names either as filenames or as URIs. For URIs, the
 * normal escaping rules are applied if the URI contains non-ASCII characters.
 * However, filenames are always returned in the character set specified by the
 * G_FILENAME_ENCODING environment variable. Please see the Glib documentation
 * for more details about this variable.
 *
 * @par Important
 * This means that while you can pass the result of FileChooser::get_filename()
 * to <tt>open(2)</tt> or <tt>fopen(3)</tt>, you may not be able to directly
 * set it as the text of a Gtk::Label widget unless you convert it first to
 * UTF-8, which all gtkmm widgets expect. You should use
 * Glib::filename_to_utf8() to convert filenames into strings that can be
 * passed to gtkmm widgets.
 */

class FileChooser : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = FileChooser;
  using CppClassType = FileChooser_Class;
  using BaseObjectType = GtkFileChooser;
  using BaseClassType = GtkFileChooserClass;

  // noncopyable
  FileChooser(const FileChooser&) = delete;
  FileChooser& operator=(const FileChooser&) = delete;

private:
  friend class FileChooser_Class;
  static CppClassType filechooser_class_;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  FileChooser();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of
   * the Class init() function to ensure that it is properly
   * initialized.
   *
   * @param interface_class The Class object for the derived type.
   */
  explicit FileChooser(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface.
  explicit FileChooser(GtkFileChooser* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  FileChooser(FileChooser&& src) noexcept;
  FileChooser& operator=(FileChooser&& src) noexcept;

  ~FileChooser() noexcept override;

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkFileChooser*       gobj()       { return reinterpret_cast<GtkFileChooser*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkFileChooser* gobj() const { return reinterpret_cast<GtkFileChooser*>(gobject_); }

private:

public:
  /** @addtogroup gtkmmEnums gtkmm Enums and Flags */

  /** 
   *  @var Action OPEN
   * Indicates open mode.  The file chooser
   * will only let the user pick an existing file.
   * 
   *  @var Action SAVE
   * Indicates save mode.  The file chooser
   * will let the user pick an existing file, or type in a new
   * filename.
   * 
   *  @var Action SELECT_FOLDER
   * Indicates an Open mode for
   * selecting folders.  The file chooser will let the user pick an
   * existing folder.
   * 
   *  @var Action CREATE_FOLDER
   * Indicates a mode for creating a
   * new folder.  The file chooser will let the user name an existing or
   * new folder.
   * 
   *  @enum Action
   * 
   * Describes whether a Gtk::FileChooser is being used to open existing files
   * or to save to a possibly new file.
   *
   * @ingroup gtkmmEnums
   */
  enum class Action
  {
    OPEN,
    SAVE,
    SELECT_FOLDER,
    CREATE_FOLDER
  };


  /** 
   *  @var Confirmation CONFIRM
   * The file chooser will present
   * its stock dialog to confirm about overwriting an existing file.
   * 
   *  @var Confirmation ACCEPT_FILENAME
   * The file chooser will
   * terminate and accept the user’s choice of a file name.
   * 
   *  @var Confirmation SELECT_AGAIN
   * The file chooser will
   * continue running, so as to let the user select another file name.
   * 
   *  @enum Confirmation
   * 
   * Used as a return value of handlers for the
   * Gtk::FileChooser::signal_confirm_overwrite() signal of a Gtk::FileChooser. This
   * value determines whether the file chooser will present the stock
   * confirmation dialog, accept the user’s choice of a filename, or
   * let the user choose another filename.
   *
   * @ingroup gtkmmEnums
   */
  enum class Confirmation
  {
    CONFIRM,
    ACCEPT_FILENAME,
    SELECT_AGAIN
  };


  /** Sets the type of operation that the chooser is performing; the
   * user interface is adapted to suit the selected action. For example,
   * an option to create a new folder might be shown if the action is
   * Gtk::FileChooser::Action::SAVE but not if the action is
   * Gtk::FileChooser::Action::OPEN.
   * 
   * @param action The action that the file selector is performing.
   */
  void set_action(Action action);
  
  /** Gets the type of operation that the file chooser is performing; see
   * set_action().
   * 
   * @return The action that the file selector is performing.
   */
  Action get_action() const;
  
  /** Sets whether only local files can be selected in the
   * file selector. If @a local_only is <tt>true</tt> (the default is <tt>false</tt>),
   * then the selected file or files are guaranteed to be
   * accessible through the operating system’s native file
   * system and therefore the application only
   * needs to worry about the filename functions in
   * Gtk::FileChooser, like get_filename(),
   * rather than the URI functions like
   * get_uri(),
   * 
   * On some systems non-native files may still be
   * available using the native filesystem via a userspace
   * filesystem (FUSE).
   * 
   * @param local_only <tt>true</tt> if only local files can be selected.
   */
  void set_local_only(bool local_only =  true);
  
  /** Gets whether only local files can be selected in the
   * file selector. See set_local_only()
   * 
   * @return <tt>true</tt> if only local files can be selected.
   */
  bool get_local_only() const;
  
  /** Sets whether multiple files can be selected in the file selector.  This is
   * only relevant if the action is set to be Gtk::FileChooser::Action::OPEN or
   * Gtk::FileChooser::Action::SELECT_FOLDER.
   * 
   * @param select_multiple <tt>true</tt> if multiple files can be selected.
   */
  void set_select_multiple(bool select_multiple =  true);
  
  /** Gets whether multiple files can be selected in the file
   * selector. See set_select_multiple().
   * 
   * @return <tt>true</tt> if multiple files can be selected.
   */
  bool get_select_multiple() const;

  
  /** Sets whether hidden files and folders are displayed in the file selector.
   * 
   * @param show_hidden <tt>true</tt> if hidden files and folders should be displayed.
   */
  void set_show_hidden(bool show_hidden =  true);
  
  /** Gets whether hidden files and folders are displayed in the file selector.   
   * See set_show_hidden().
   * 
   * @return <tt>true</tt> if hidden files and folders are displayed.
   */
  bool get_show_hidden() const;

  
  /** Sets whether a file chooser in Gtk::FileChooser::Action::SAVE mode will present
   * a confirmation dialog if the user types a file name that already exists.  This
   * is <tt>false</tt> by default.
   * 
   * If set to <tt>true</tt>, the @a chooser will emit the
   * Gtk::FileChooser::signal_confirm_overwrite() signal when appropriate.
   * 
   * If all you need is the standard confirmation dialog, set this property to <tt>true</tt>.
   * You can override the way confirmation is done by actually handling the
   * Gtk::FileChooser::signal_confirm_overwrite() signal; please refer to its documentation
   * for the details.
   * 
   * @param do_overwrite_confirmation Whether to confirm overwriting in save mode.
   */
  void set_do_overwrite_confirmation(bool do_overwrite_confirmation =  true);
  
  /** Queries whether a file chooser is set to confirm for overwriting when the user
   * types a file name that already exists.
   * 
   * @return <tt>true</tt> if the file chooser will present a confirmation dialog;
   * <tt>false</tt> otherwise.
   */
  bool get_do_overwrite_confirmation() const;

  
  /** Sets whether file choser will offer to create new folders.
   * This is only relevant if the action is not set to be 
   * Gtk::FileChooser::Action::OPEN.
   * 
   * @param create_folders <tt>true</tt> if the Create Folder button should be displayed.
   */
  void set_create_folders(bool create_folders =  true);
  
  /** Gets whether file choser will offer to create new folders.
   * See set_create_folders().
   * 
   * @return <tt>true</tt> if the Create Folder button should be displayed.
   */
  bool get_create_folders() const;

  
  /** Sets the current name in the file selector, as if entered
   * by the user. Note that the name passed in here is a UTF-8
   * string rather than a filename. This function is meant for
   * such uses as a suggested name in a “Save As...” dialog.  You can
   * pass “Untitled.doc” or a similarly suitable suggestion for the @a name.
   * 
   * If you want to preselect a particular existing file, you should use
   * set_filename() or set_uri() instead.
   * Please see the documentation for those functions for an example of using
   * set_current_name() as well.
   * 
   * @param name The filename to use, as a UTF-8 string.
   */
  void set_current_name(const Glib::ustring& name);
  
  /** Gets the current name in the file selector, as entered by the user in the
   * text entry for “Name”.
   * 
   * This is meant to be used in save dialogs, to get the currently typed filename
   * when the file itself does not exist yet.  For example, an application that
   * adds a custom extra widget to the file chooser for “file format” may want to
   * change the extension of the typed filename based on the chosen format, say,
   * from “.jpg” to “.png”.
   * 
   * @return The raw text from the file chooser’s “Name” entry.  Note that this string is not a full pathname or URI; it is
   * whatever the contents of the entry are.  Note also that this string is in
   * UTF-8 encoding, which is not necessarily the system’s encoding for filenames.
   */
  Glib::ustring get_current_name() const;

  
  /** Gets the filename for the currently selected file in
   * the file selector. The filename is returned as an absolute path. If
   * multiple files are selected, one of the filenames will be returned at
   * random.
   * 
   * If the file chooser is in folder mode, this function returns the selected
   * folder.
   * 
   * @return The currently selected filename, or an empty string
   * if no file is selected, or the selected file can't
   * be represented with a local filename.
   */
  std::string get_filename() const;
  
  /** Sets @a filename as the current filename for the file chooser, by changing to
   * the file’s parent folder and actually selecting the file in list; all other
   * files will be unselected.  If the @a chooser is in
   * Gtk::FileChooser::Action::SAVE mode, the file’s base name will also appear in
   * the dialog’s file name entry.
   * 
   * Note that the file must exist, or nothing will be done except
   * for the directory change.
   * 
   * You should use this function only when implementing a save
   * dialog for which you already have a file name to which
   * the user may save.  For example, when the user opens an existing file and
   * then does Save As... to save a copy or
   * a modified version.  If you don’t have a file name already — for
   * example, if the user just created a new file and is saving it for the first
   * time, do not call this function.  Instead, use something similar to this:
   * 
   * [C example ellipted]
   * 
   * In the first case, the file chooser will present the user with useful suggestions
   * as to where to save his new file.  In the second case, the file’s existing location
   * is already known, so the file chooser will use it.
   * 
   * @param filename The filename to set as current.
   * @return Not useful.
   */
  bool set_filename(const std::string& filename);
  
  /** Selects a filename. If the file name isn’t in the current
   * folder of @a chooser, then the current folder of @a chooser will
   * be changed to the folder containing @a filename.
   * 
   * @param filename The filename to select.
   * @return Not useful.
   * 
   * See also: set_filename().
   */
  bool select_filename(const std::string& filename);
  
  /** Unselects a currently selected filename. If the filename
   * is not in the current directory, does not exist, or
   * is otherwise not currently selected, does nothing.
   * 
   * @param filename The filename to unselect.
   */
  void unselect_filename(const std::string& filename);
  
  /** Selects all the files in the current folder of a file chooser.
   */
  void select_all();
  
  /** Unselects all the files in the current folder of a file chooser.
   */
  void unselect_all();

 
  /** Lists all the selected files and subfolders in the current folder of
   *  @a chooser. The returned names are full absolute paths. If files in the current
   * folder cannot be represented as local filenames they will be ignored. (See
   * get_uris())
   * 
   * @return A list containing the filenames of all selected
   * files and subfolders in the current folder.
   */
  std::vector<std::string> get_filenames() const;

  
  /** Sets the current folder for @a chooser from a local filename.
   * The user will be shown the full contents of the current folder,
   * plus user interface elements for navigating to other folders.
   * 
   * In general, you should not use this function.  See the
   * [section on setting up a file chooser dialog][gtkfilechooserdialog-setting-up]
   * for the rationale behind this.
   * 
   * @param filename The full path of the new current folder.
   * @return Not useful.
   */
  bool set_current_folder(const std::string& filename);
  
  /** Gets the current folder of @a chooser as a local filename.
   * See set_current_folder().
   * 
   * Note that this is the folder that the file chooser is currently displaying
   * (e.g. "/home/username/Documents"), which is not the same
   * as the currently-selected folder if the chooser is in
   * Gtk::FileChooser::Action::SELECT_FOLDER mode
   * (e.g. "/home/username/Documents/selected-folder/".  To get the
   * currently-selected folder in that mode, use get_uri() as the
   * usual way to get the selection.
   * 
   * @return The full path of the current folder, possibly empty if the current
   * path cannot be represented as a local filename.  This function may also return
   * an empty string if the file chooser was unable to load the last folder that was
   * requested from it; for example, as would be for calling
   * set_current_folder() on a nonexistent folder.
   */
  std::string get_current_folder() const;


/* URI manipulation
 */
  
  /** Gets the URI for the currently selected file in
   * the file selector. If multiple files are selected,
   * one of the filenames will be returned at random.
   * 
   * If the file chooser is in folder mode, this function returns the selected
   * folder.
   * 
   * @return The currently selected URI, or an empty string
   * if no file is selected.
   */
  Glib::ustring get_uri() const;
  
  /** Sets the file referred to by @a uri as the current file for the file chooser,
   * by changing to the URI’s parent folder and actually selecting the URI in the
   * list.  If the @a chooser is Gtk::FileChooser::Action::SAVE mode, the URI’s base
   * name will also appear in the dialog’s file name entry.
   * 
   * Note that the URI must exist, or nothing will be done except for the 
   * directory change.
   * 
   * You should use this function only when implementing a save
   * dialog for which you already have a file name to which
   * the user may save.  For example, when the user opens an existing file and then
   * does Save As... to save a copy or a
   * modified version.  If you don’t have a file name already — for example,
   * if the user just created a new file and is saving it for the first time, do
   * not call this function.  Instead, use something similar to this:
   * 
   * [C example ellipted]
   * 
   * 
   * In the first case, the file chooser will present the user with useful suggestions
   * as to where to save his new file.  In the second case, the file’s existing location
   * is already known, so the file chooser will use it.
   * 
   * @param uri The URI to set as current.
   * @return Not useful.
   */
  bool set_uri(const Glib::ustring& uri);
  
  /** Selects the file to by @a uri. If the URI doesn’t refer to a
   * file in the current folder of @a chooser, then the current folder of
   *  @a chooser will be changed to the folder containing @a filename.
   * 
   * @param uri The URI to select.
   * @return Not useful.
   */
  bool select_uri(const Glib::ustring& uri);
  
  /** Unselects the file referred to by @a uri. If the file
   * is not in the current directory, does not exist, or
   * is otherwise not currently selected, does nothing.
   * 
   * @param uri The URI to unselect.
   */
  void unselect_uri(const Glib::ustring& uri);
 

  /** Lists all the selected files and subfolders in the current folder of
   *  @a chooser. The returned names are full absolute URIs.
   * 
   * @return A list containing the URIs of all selected
   * files and subfolders in the current folder.
   */
  std::vector<Glib::ustring> get_uris() const;

  
  /** Sets the current folder for @a chooser from an URI.
   * The user will be shown the full contents of the current folder,
   * plus user interface elements for navigating to other folders.
   * 
   * In general, you should not use this function.  See the
   * [section on setting up a file chooser dialog][gtkfilechooserdialog-setting-up]
   * for the rationale behind this.
   * 
   * @param uri The URI for the new current folder.
   * @return <tt>true</tt> if the folder could be changed successfully, <tt>false</tt>
   * otherwise.
   */
  bool set_current_folder_uri(const Glib::ustring& uri);
  
  /** Gets the current folder of @a chooser as an URI.
   * See set_current_folder_uri().
   * 
   * Note that this is the folder that the file chooser is currently displaying
   * (e.g. "file:///home/username/Documents"), which is not the same
   * as the currently-selected folder if the chooser is in
   * Gtk::FileChooser::Action::SELECT_FOLDER mode
   * (e.g. "file:///home/username/Documents/selected-folder/".  To get the
   * currently-selected folder in that mode, use get_uri() as the
   * usual way to get the selection.
   * 
   * @return The URI for the current folder.
   */
  Glib::ustring get_current_folder_uri() const;

  
  /** Sets @a file as the current filename for the file chooser, by changing
   * to the file’s parent folder and actually selecting the file in list.  If
   * the @a chooser is in Gtk::FileChooser::Action::SAVE mode, the file’s base name
   * will also appear in the dialog’s file name entry.
   * 
   * If the file name isn’t in the current folder of @a chooser, then the current
   * folder of @a chooser will be changed to the folder containing @a filename. This
   * is equivalent to a sequence of unselect_all() followed by
   * select_filename().
   * 
   * Note that the file must exist, or nothing will be done except
   * for the directory change.
   * 
   * If you are implementing a save dialog,
   * you should use this function if you already have a file name to which the
   * user may save; for example, when the user opens an existing file and then
   * does Save As...  If you don’t have
   * a file name already — for example, if the user just created a new
   * file and is saving it for the first time, do not call this function.
   * Instead, use something similar to this:
   * 
   * [C example ellipted]
   * 
   * @param file The Gio::File to set as current.
   * @return Not useful.
   * 
   * @throws Glib::Error
   */
  bool set_file(const Glib::RefPtr<const Gio::File>& file);

  
  /** Selects the file referred to by @a file. An internal function. See
   * _gtk_file_chooser_select_uri().
   * 
   * @param file The file to select.
   * @return Not useful.
   * 
   * @throws Glib::Error
   */
  bool select_file(const Glib::RefPtr<const Gio::File>& file);
  
  /** Unselects the file referred to by @a file. If the file is not in the current
   * directory, does not exist, or is otherwise not currently selected, does nothing.
   * 
   * @param file A Gio::File.
   */
  void unselect_file(const Glib::RefPtr<const Gio::File>& file);

 
  /** Lists all the selected files and subfolders in the current folder of @a chooser
   * as Gio::File. An internal function, see get_uris().
   * 
   * @return A SList
   * containing a Gio::File for each selected file and subfolder in the
   * current folder.
   */
  std::vector< Glib::RefPtr<Gio::File> > get_files();

  
  /** Sets the current folder for @a chooser from a Gio::File.
   * Internal function, see set_current_folder_uri().
   * 
   * @param file The Gio::File for the new folder.
   * @return <tt>true</tt> if the folder could be changed successfully, <tt>false</tt>
   * otherwise.
   * 
   * @throws Glib::Error
   */
  bool set_current_folder_file(const Glib::RefPtr<const Gio::File>& file);

  //No refreturn is needed here, because the C function provides a reference:
  
  /** Gets the current folder of @a chooser as Gio::File.
   * See get_current_folder_uri().
   * 
   * @return The Gio::File for the current folder.
   */
  Glib::RefPtr<Gio::File> get_current_folder_file();

  //No refreturn is needed here, because the C function provides a reference:
  
  /** Gets the Gio::File for the currently selected file in
   * the file selector. If multiple files are selected,
   * one of the files will be returned at random.
   * 
   * If the file chooser is in folder mode, this function returns the selected
   * folder.
   * 
   * @return A selected Gio::File. You own the returned file;
   * use Glib::object_unref() to release it.
   */
  Glib::RefPtr<Gio::File> get_file();
  
  /** Gets the Gio::File for the currently selected file in
   * the file selector. If multiple files are selected,
   * one of the files will be returned at random.
   * 
   * If the file chooser is in folder mode, this function returns the selected
   * folder.
   * 
   * @return A selected Gio::File. You own the returned file;
   * use Glib::object_unref() to release it.
   */
  Glib::RefPtr<const Gio::File> get_file() const;

/* Preview widget
 */
  
  /** Sets an application-supplied widget to use to display a custom preview
   * of the currently selected file. To implement a preview, after setting the
   * preview widget, you connect to the Gtk::FileChooser::signal_update_preview()
   * signal, and call get_preview_filename() or
   * get_preview_uri() on each change. If you can
   * display a preview of the new file, update your widget and
   * set the preview active using set_preview_widget_active().
   * Otherwise, set the preview inactive.
   * 
   * When there is no application-supplied preview widget, or the
   * application-supplied preview widget is not active, the file chooser
   * will display no preview at all.
   * 
   * @param preview_widget Widget for displaying preview.
   */
  void set_preview_widget(Gtk::Widget& preview_widget);

  
  /** Gets the current preview widget; see
   * set_preview_widget().
   * 
   * @return The current preview widget, or <tt>nullptr</tt>.
   */
  Gtk::Widget* get_preview_widget();
  
  /** Gets the current preview widget; see
   * set_preview_widget().
   * 
   * @return The current preview widget, or <tt>nullptr</tt>.
   */
  const Gtk::Widget* get_preview_widget() const;

  
  /** Sets whether the preview widget set by
   * set_preview_widget() should be shown for the
   * current filename. When @a active is set to false, the file chooser
   * may display an internally generated preview of the current file
   * or it may display no preview at all. See
   * set_preview_widget() for more details.
   * 
   * @param active Whether to display the user-specified preview widget.
   */
  void set_preview_widget_active(bool active =  true);
  
  /** Gets whether the preview widget set by set_preview_widget()
   * should be shown for the current filename. See
   * set_preview_widget_active().
   * 
   * @return <tt>true</tt> if the preview widget is active for the current filename.
   */
  bool get_preview_widget_active() const;

  
  /** Sets whether the file chooser should display a label with the name of
   * the file that is being previewed; the default is <tt>true</tt>.  Applications that
   * want to draw the whole preview area themselves should set this to <tt>false</tt> and
   * display the name themselves in their preview widget.
   * 
   * See also: set_preview_widget()
   * 
   * @param use_label Whether to display a label with the name of the previewed file.
   */
  void set_use_preview_label(bool use_label =  true);
  
  /** Gets whether a label should be drawn with the name of the previewed
   * file.  See set_use_preview_label().
   * 
   * @return <tt>true</tt> if the file chooser is set to display a label with the
   * name of the previewed file, <tt>false</tt> otherwise.
   */
  bool get_use_preview_label() const;

 
  /** Gets the filename that should be previewed in a custom preview
   * widget. See set_preview_widget().
   * 
   * @return The filename to preview, or an empty string if no file
   * is selected, or if the selected file cannot be represented
   * as a local filename.
   */
  std::string get_preview_filename() const;
  
  /** Gets the URI that should be previewed in a custom preview
   * widget. See set_preview_widget().
   * 
   * @return The URI for the file to preview, or an empty string if no file is
   * selected.
   */
  Glib::ustring get_preview_uri() const;

  //No refreturn is needed here, because the C function provides a reference:
  
  /** Gets the Gio::File that should be previewed in a custom preview
   * Internal function, see get_preview_uri().
   * 
   * @return The Gio::File for the file to preview,
   * or <tt>nullptr</tt> if no file is selected. Free with Glib::object_unref().
   */
  Glib::RefPtr<Gio::File> get_preview_file();
  
  /** Gets the Gio::File that should be previewed in a custom preview
   * Internal function, see get_preview_uri().
   * 
   * @return The Gio::File for the file to preview,
   * or <tt>nullptr</tt> if no file is selected. Free with Glib::object_unref().
   */
  Glib::RefPtr<const Gio::File> get_preview_file() const;

/* Extra widget
 */
  
  /** Sets an application-supplied widget to provide extra options to the user.
   * 
   * @param extra_widget Widget for extra options.
   */
  void set_extra_widget(Gtk::Widget& extra_widget);
  
  /** Gets the current extra widget; see
   * set_extra_widget().
   * 
   * @return The current extra widget, or <tt>nullptr</tt>.
   */
  Gtk::Widget* get_extra_widget();
  
  /** Gets the current extra widget; see
   * set_extra_widget().
   * 
   * @return The current extra widget, or <tt>nullptr</tt>.
   */
  const Gtk::Widget* get_extra_widget() const;

/* List of user selectable filters
 */
  
  /** Adds @a filter to the list of filters that the user can select between.
   * When a filter is selected, only files that are passed by that
   * filter are displayed. 
   * 
   * Note that the @a chooser takes ownership of the filter, so you have to 
   * ref and sink it if you want to keep a reference.
   * 
   * @param filter A Gtk::FileFilter.
   */
  void add_filter(const Glib::RefPtr<FileFilter>& filter);
  
  /** Removes @a filter from the list of filters that the user can select between.
   * 
   * @param filter A Gtk::FileFilter.
   */
  void remove_filter(const Glib::RefPtr<FileFilter>& filter);

 
  /** Lists the current set of user-selectable filters; see
   * add_filter(), remove_filter().
   * 
   * @return A list containing the current set of
   * user selectable filters.
   */
  std::vector< Glib::RefPtr<FileFilter> > list_filters();
  
  /** Lists the current set of user-selectable filters; see
   * add_filter(), remove_filter().
   * 
   * @return A list containing the current set of
   * user selectable filters.
   */
  std::vector< Glib::RefPtr<const FileFilter> > list_filters() const;

/* Current filter
 */
  
  /** Sets the current filter; only the files that pass the
   * filter will be displayed. If the user-selectable list of filters
   * is non-empty, then the filter should be one of the filters
   * in that list. Setting the current filter when the list of
   * filters is empty is useful if you want to restrict the displayed
   * set of files without letting the user change it.
   * 
   * @param filter A Gtk::FileFilter.
   */
  void set_filter(const Glib::RefPtr<FileFilter>& filter);
  
  /** Gets the current filter; see set_filter().
   * 
   * @return The current filter, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<FileFilter> get_filter();
  
  /** Gets the current filter; see set_filter().
   * 
   * @return The current filter, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const FileFilter> get_filter() const;

/* Per-application shortcut folders */

  
  /** Adds a folder to be displayed with the shortcut folders in a file chooser.
   * Note that shortcut folders do not get saved, as they are provided by the
   * application.  For example, you can use this to add a
   * “/usr/share/mydrawprogram/Clipart” folder to the volume list.
   * 
   * @param folder Filename of the folder to add.
   * @return <tt>true</tt> if the folder could be added successfully, <tt>false</tt>
   * otherwise.  In the latter case, the @a error will be set as appropriate.
   * 
   * @throws Glib::Error
   */
  bool add_shortcut_folder(const std::string& folder);
  
  /** Removes a folder from a file chooser’s list of shortcut folders.
   * 
   * @param folder Filename of the folder to remove.
   * @return <tt>true</tt> if the operation succeeds, <tt>false</tt> otherwise.  
   * In the latter case, the @a error will be set as appropriate.
   * 
   * See also: add_shortcut_folder().
   * 
   * @throws Glib::Error
   */
  bool remove_shortcut_folder(const std::string& folder);

  
  /** Queries the list of shortcut folders in the file chooser, as set by
   * add_shortcut_folder().
   * 
   * @return A list of folder filenames, if there are any shortcut
   * folders.
   */
  std::vector<std::string> list_shortcut_folders() const;

  
  /** Adds a folder URI to be displayed with the shortcut folders in a file
   * chooser.  Note that shortcut folders do not get saved, as they are provided
   * by the application.  For example, you can use this to add a
   * “file:///usr/share/mydrawprogram/Clipart” folder to the volume list.
   * 
   * @param uri URI of the folder to add.
   * @return <tt>true</tt> if the folder could be added successfully, <tt>false</tt>
   * otherwise.  In the latter case, the @a error will be set as appropriate.
   * 
   * @throws Glib::Error
   */
  bool add_shortcut_folder_uri(const Glib::ustring& uri);
  
  /** Removes a folder URI from a file chooser’s list of shortcut folders.
   * 
   * @param uri URI of the folder to remove.
   * @return <tt>true</tt> if the operation succeeds, <tt>false</tt> otherwise.  
   * In the latter case, the @a error will be set as appropriate.
   * 
   * See also: add_shortcut_folder_uri().
   * 
   * @throws Glib::Error
   */
  bool remove_shortcut_folder_uri(const Glib::ustring& uri);
  
  /** Queries the list of shortcut folders in the file chooser, as set by
   * add_shortcut_folder_uri().
   * 
   * @return A list of folder URIs.
   */
  std::vector<Glib::ustring> list_shortcut_folder_uris() const;

 
  /** Adds a 'choice' to the file chooser. This is typically implemented
   * as a combobox or, for boolean choices, as a checkbutton. You can select
   * a value using set_choice() before the dialog is shown,
   * and you can obtain the user-selected value in the signal_response() signal handler
   * using get_choice().
   * 
   * Compare set_extra_widget().
   * 
   * @param id Id for the added choice.
   * @param label User-visible label for the added choice.
   * @param options Ids for the options of the choice, or <tt>nullptr</tt> for a boolean choice.
   * @param option_labels User-visible labels for the options, must be the same length as @a options.
   */
  void add_choice(const Glib::ustring& id, const Glib::ustring& label, const std::vector<Glib::ustring>& options, const std::vector<Glib::ustring>& option_labels);

  /** Adds a boolean 'choice' to the file chooser.
   * This is typically implemented as a checkbutton. You can select
   * a value using set_boolean_choice() before the dialog is shown,
   * and you can obtain the user-selected value in the signal_response() signal handler
   * using get_choice().
   *
   * Compare set_extra_widget().
   *
   * @newin{3,22}
   *
   * @param id Id for the added choice.
   * @param label User-visible label for the added choice.
   */
  void add_choice(const Glib::ustring& id, const Glib::ustring& label);

  
  /** Removes a 'choice' that has been added with add_choice().
   * 
   * @param id The ID of the choice to remove.
   */
  void remove_choice(const Glib::ustring& id);
  
  /** Selects an option in a 'choice' that has been added with
   * add_choice(). For a boolean choice, the
   * possible options are "true" and "false".
   * 
   * @param id The ID of the choice to set.
   * @param option The ID of the option to select.
   */
  void set_choice(const Glib::ustring& id, const Glib::ustring& option);
  
  /** Gets the currently selected option in the 'choice' with the given ID.
   * 
   * @param id The ID of the choice to get.
   * @return The ID of the currenly selected option.
   */
  Glib::ustring get_choice(const Glib::ustring& id) const;

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%current_folder_changed()</tt>
   *
   * Flags: Run Last
   *
   * This signal is emitted when the current folder in a Gtk::FileChooser
   * changes.  This can happen due to the user performing some action that
   * changes folders, such as selecting a bookmark or visiting a folder on the
   * file list.  It can also happen as a result of calling a function to
   * explicitly change the current folder in a file chooser.
   * 
   * Normally you do not need to connect to this signal, unless you need to keep
   * track of which folder a file chooser is showing.
   * 
   * See also:  Gtk::FileChooser::set_current_folder(),
   * Gtk::FileChooser::get_current_folder(),
   * Gtk::FileChooser::set_current_folder_uri(),
   * Gtk::FileChooser::get_current_folder_uri().
   */

  Glib::SignalProxy<void()> signal_current_folder_changed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%selection_changed()</tt>
   *
   * Flags: Run Last
   *
   * This signal is emitted when there is a change in the set of selected files
   * in a Gtk::FileChooser.  This can happen when the user modifies the selection
   * with the mouse or the keyboard, or when explicitly calling functions to
   * change the selection.
   * 
   * Normally you do not need to connect to this signal, as it is easier to wait
   * for the file chooser to finish running, and then to get the list of
   * selected files using the functions mentioned below.
   * 
   * See also: Gtk::FileChooser::select_filename(),
   * Gtk::FileChooser::unselect_filename(), Gtk::FileChooser::get_filename(),
   * Gtk::FileChooser::get_filenames(), Gtk::FileChooser::select_uri(),
   * Gtk::FileChooser::unselect_uri(), Gtk::FileChooser::get_uri(),
   * Gtk::FileChooser::get_uris().
   */

  Glib::SignalProxy<void()> signal_selection_changed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%update_preview()</tt>
   *
   * Flags: Run Last
   *
   * This signal is emitted when the preview in a file chooser should be
   * regenerated.  For example, this can happen when the currently selected file
   * changes.  You should use this signal if you want your file chooser to have
   * a preview widget.
   * 
   * Once you have installed a preview widget with
   * Gtk::FileChooser::set_preview_widget(), you should update it when this
   * signal is emitted.  You can use the functions
   * Gtk::FileChooser::get_preview_filename() or
   * Gtk::FileChooser::get_preview_uri() to get the name of the file to preview.
   * Your widget may not be able to preview all kinds of files; your callback
   * must call Gtk::FileChooser::set_preview_widget_active() to inform the file
   * chooser about whether the preview was generated successfully or not.
   * 
   * Please see the example code in
   * [Using a Preview Widget][gtkfilechooser-preview].
   * 
   * See also: Gtk::FileChooser::set_preview_widget(),
   * Gtk::FileChooser::set_preview_widget_active(),
   * Gtk::FileChooser::set_use_preview_label(),
   * Gtk::FileChooser::get_preview_filename(),
   * Gtk::FileChooser::get_preview_uri().
   */

  Glib::SignalProxy<void()> signal_update_preview();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%file_activated()</tt>
   *
   * Flags: Run Last
   *
   * This signal is emitted when the user "activates" a file in the file
   * chooser.  This can happen by double-clicking on a file in the file list, or
   * by pressing `Enter`.
   * 
   * Normally you do not need to connect to this signal.  It is used internally
   * by Gtk::FileChooserDialog to know when to activate the default button in the
   * dialog.
   * 
   * See also: Gtk::FileChooser::get_filename(),
   * Gtk::FileChooser::get_filenames(), Gtk::FileChooser::get_uri(),
   * Gtk::FileChooser::get_uris().
   */

  Glib::SignalProxy<void()> signal_file_activated();

  
  /**
   * @par Slot Prototype:
   * <tt>Confirmation on_my_%confirm_overwrite()</tt>
   *
   * Flags: Run Last
   *
   * This signal gets emitted whenever it is appropriate to present a
   * confirmation dialog when the user has selected a file name that
   * already exists.  The signal only gets emitted when the file
   * chooser is in Gtk::FileChooser::Action::SAVE mode.
   * 
   * Most applications just need to turn on the
   * Gtk::FileChooser::property_do_overwrite_confirmation() property (or call the
   * Gtk::FileChooser::set_do_overwrite_confirmation() function), and
   * they will automatically get a standard confirmation dialog.
   * Applications which need to customize this behavior should do
   * that, and also connect to the Gtk::FileChooser::signal_confirm_overwrite()
   * signal.
   * 
   * A signal handler for this signal must return a
   * Gtk::FileChooser::Confirmation value, which indicates the action to
   * take.  If the handler determines that the user wants to select a
   * different filename, it should return
   * Gtk::FileChooser::Confirmation::SELECT_AGAIN.  If it determines
   * that the user is satisfied with his choice of file name, it
   * should return Gtk::FileChooser::Confirmation::ACCEPT_FILENAME.
   * On the other hand, if it determines that the standard confirmation
   * dialog should be used, it should return
   * Gtk::FileChooser::Confirmation::CONFIRM. The following example
   * illustrates this.
   * 
   * ## Custom confirmation ## {#gtkfilechooser-confirmation}
   * 
   * 
   * [C example ellipted]
   * 
   * @return A Gtk::FileChooser::Confirmation value that indicates which
   * action to take after emitting the signal.
   */

  Glib::SignalProxy<Confirmation()> signal_confirm_overwrite();


  /** The type of operation that the file selector is performing.
   *
   * Default value: Gtk::FileChooser::Action::OPEN
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Action > property_action() ;

/** The type of operation that the file selector is performing.
   *
   * Default value: Gtk::FileChooser::Action::OPEN
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Action > property_action() const;

  /** The current filter for selecting which files are displayed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<FileFilter> > property_filter() ;

/** The current filter for selecting which files are displayed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<FileFilter> > property_filter() const;

  /** Whether the selected file(s) should be limited to local file: URLs.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_local_only() ;

/** Whether the selected file(s) should be limited to local file: URLs.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_local_only() const;

  /** Application supplied widget for custom previews.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_preview_widget() ;

/** Application supplied widget for custom previews.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_preview_widget() const;

  /** Whether the application supplied widget for custom previews should be shown.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_preview_widget_active() ;

/** Whether the application supplied widget for custom previews should be shown.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_preview_widget_active() const;

  /** Whether to display a label with the name of the previewed file.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_use_preview_label() ;

/** Whether to display a label with the name of the previewed file.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_use_preview_label() const;

  /** Application supplied widget for extra options.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_extra_widget() ;

/** Application supplied widget for extra options.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_extra_widget() const;

  /** Whether to allow multiple files to be selected.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_select_multiple() ;

/** Whether to allow multiple files to be selected.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_select_multiple() const;

  /** Whether the hidden files and folders should be displayed.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_hidden() ;

/** Whether the hidden files and folders should be displayed.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_hidden() const;

  /** Whether a file chooser in Gtk::FileChooser::Action::SAVE mode
   * will present an overwrite confirmation dialog if the user
   * selects a file name that already exists.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_do_overwrite_confirmation() ;

/** Whether a file chooser in Gtk::FileChooser::Action::SAVE mode
   * will present an overwrite confirmation dialog if the user
   * selects a file name that already exists.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_do_overwrite_confirmation() const;

  /** Whether a file chooser not in Gtk::FileChooser::Action::OPEN mode
   * will offer the user to create new folders.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_create_folders() ;

/** Whether a file chooser not in Gtk::FileChooser::Action::OPEN mode
   * will offer the user to create new folders.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_create_folders() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::FileChooser::Action> : public Glib::Value_Enum<Gtk::FileChooser::Action>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::FileChooser::Confirmation> : public Glib::Value_Enum<Gtk::FileChooser::Confirmation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::FileChooser
   */
  Glib::RefPtr<Gtk::FileChooser> wrap(GtkFileChooser* object, bool take_copy = false);

} // namespace Glib


#endif /* _GTKMM_FILECHOOSER_H */

