/* valaconstant.c generated by valac, the Vala compiler
 * generated from valaconstant.vala, do not modify */

/* valaconstant.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaConstantPrivate {
	ValaDataType* _data_type;
	ValaExpression* _value;
};

static gint ValaConstant_private_offset;
static gpointer vala_constant_parent_class = NULL;

static void vala_constant_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor);
static void vala_constant_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_constant_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node);
static void vala_constant_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type);
static gboolean vala_constant_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context);
static gboolean vala_constant_check_const_type (ValaConstant* self,
                                         ValaDataType* type,
                                         ValaCodeContext* context);
static void vala_constant_finalize (ValaCodeNode * obj);

static inline gpointer
vala_constant_get_instance_private (ValaConstant* self)
{
	return G_STRUCT_MEMBER_P (self, ValaConstant_private_offset);
}

/**
 * Creates a new constant.
 *
 * @param name             constant name
 * @param type_reference   constant type
 * @param value            constant value
 * @param source_reference reference to source code
 * @return                 newly created constant
 */
ValaConstant*
vala_constant_construct (GType object_type,
                         const gchar* name,
                         ValaDataType* type_reference,
                         ValaExpression* value,
                         ValaSourceReference* source_reference,
                         ValaComment* comment)
{
	ValaConstant* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaConstant*) vala_symbol_construct (object_type, name, source_reference, comment);
	if (type_reference != NULL) {
		vala_constant_set_type_reference (self, type_reference);
	}
	vala_constant_set_value (self, value);
	return self;
}

ValaConstant*
vala_constant_new (const gchar* name,
                   ValaDataType* type_reference,
                   ValaExpression* value,
                   ValaSourceReference* source_reference,
                   ValaComment* comment)
{
	return vala_constant_construct (VALA_TYPE_CONSTANT, name, type_reference, value, source_reference, comment);
}

static void
vala_constant_real_accept (ValaCodeNode* base,
                           ValaCodeVisitor* visitor)
{
	ValaConstant * self;
	self = (ValaConstant*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_constant (visitor, self);
}

static void
vala_constant_real_accept_children (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaConstant * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaConstant*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_constant_get_type_reference (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_constant_get_value (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_constant_get_value (self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_constant_real_replace_expression (ValaCodeNode* base,
                                       ValaExpression* old_node,
                                       ValaExpression* new_node)
{
	ValaConstant * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaConstant*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_constant_get_value (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_constant_set_value (self, new_node);
	}
}

static void
vala_constant_real_replace_type (ValaCodeNode* base,
                                 ValaDataType* old_type,
                                 ValaDataType* new_type)
{
	ValaConstant * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaConstant*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_constant_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_constant_set_type_reference (self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_constant_real_check (ValaCodeNode* base,
                          ValaCodeContext* context)
{
	ValaConstant * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSymbol* _tmp22_;
	ValaSymbol* _tmp23_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp114_ = FALSE;
	gboolean _tmp115_ = FALSE;
	gboolean _tmp116_;
	gboolean _tmp117_;
	ValaSemanticAnalyzer* _tmp132_;
	ValaSemanticAnalyzer* _tmp133_;
	ValaSourceFile* _tmp134_;
	ValaSemanticAnalyzer* _tmp135_;
	ValaSemanticAnalyzer* _tmp136_;
	ValaSymbol* _tmp137_;
	gboolean _tmp138_;
	gboolean _tmp139_;
	gboolean result = FALSE;
	self = (ValaConstant*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp23_ = _tmp22_;
	if (!VALA_IS_BLOCK (_tmp23_)) {
		ValaSemanticAnalyzer* _tmp24_;
		ValaSemanticAnalyzer* _tmp25_;
		_tmp24_ = vala_code_context_get_analyzer (context);
		_tmp25_ = _tmp24_;
		vala_semantic_analyzer_set_current_symbol (_tmp25_, (ValaSymbol*) self);
	}
	_tmp26_ = vala_constant_get_type_reference (self);
	_tmp27_ = _tmp26_;
	vala_code_node_check ((ValaCodeNode*) _tmp27_, context);
	_tmp28_ = vala_constant_get_type_reference (self);
	_tmp29_ = _tmp28_;
	if (!vala_constant_check_const_type (self, _tmp29_, context)) {
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_constant_get_type_reference (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_code_node_to_string ((ValaCodeNode*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf ("`%s' not supported as type for constants", _tmp35_);
		_tmp37_ = _tmp36_;
		vala_report_error (_tmp31_, _tmp37_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp38_ = vala_symbol_get_external ((ValaSymbol*) self);
	_tmp39_ = _tmp38_;
	if (!_tmp39_) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		_tmp40_ = vala_constant_get_value (self);
		_tmp41_ = _tmp40_;
		if (_tmp41_ == NULL) {
			ValaSourceFileType _tmp42_;
			ValaSourceFileType _tmp43_;
			_tmp42_ = vala_symbol_get_source_type ((ValaSymbol*) self);
			_tmp43_ = _tmp42_;
			if (_tmp43_ != VALA_SOURCE_FILE_TYPE_FAST) {
				ValaSourceReference* _tmp44_;
				ValaSourceReference* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp45_, "A const field requires a value to be provided");
			}
		} else {
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			gboolean _tmp50_ = FALSE;
			ValaExpression* _tmp51_;
			ValaExpression* _tmp52_;
			ValaExpression* _tmp57_;
			ValaExpression* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaDataType* _tmp61_;
			ValaDataType* _tmp62_;
			ValaMethodCall* call = NULL;
			ValaExpression* _tmp77_;
			ValaExpression* _tmp78_;
			ValaMethodCall* _tmp79_;
			ValaMethodCall* _tmp80_;
			ValaExpression* _tmp104_;
			ValaExpression* _tmp105_;
			_tmp46_ = vala_constant_get_value (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_constant_get_type_reference (self);
			_tmp49_ = _tmp48_;
			vala_expression_set_target_type (_tmp47_, _tmp49_);
			_tmp51_ = vala_constant_get_value (self);
			_tmp52_ = _tmp51_;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp52_, context)) {
				_tmp50_ = TRUE;
			} else {
				ValaDataType* _tmp53_;
				ValaDataType* _tmp54_;
				gboolean _tmp55_;
				gboolean _tmp56_;
				_tmp53_ = vala_constant_get_type_reference (self);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_code_node_get_error ((ValaCodeNode*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp50_ = _tmp56_;
			}
			if (_tmp50_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp57_ = vala_constant_get_value (self);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_expression_get_value_type (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_constant_get_type_reference (self);
			_tmp62_ = _tmp61_;
			if (!vala_data_type_compatible (_tmp60_, _tmp62_)) {
				ValaSourceReference* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaExpression* _tmp65_;
				ValaExpression* _tmp66_;
				ValaDataType* _tmp67_;
				ValaDataType* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_constant_get_value (self);
				_tmp66_ = _tmp65_;
				_tmp67_ = vala_expression_get_value_type (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = vala_code_node_to_string ((ValaCodeNode*) _tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_constant_get_type_reference (self);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_code_node_to_string ((ValaCodeNode*) _tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp70_, _tmp74_);
				_tmp76_ = _tmp75_;
				vala_report_error (_tmp64_, _tmp76_);
				_g_free0 (_tmp76_);
				_g_free0 (_tmp74_);
				_g_free0 (_tmp70_);
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp77_ = vala_constant_get_value (self);
			_tmp78_ = _tmp77_;
			_tmp79_ = _vala_code_node_ref0 (VALA_IS_METHOD_CALL (_tmp78_) ? ((ValaMethodCall*) _tmp78_) : NULL);
			call = _tmp79_;
			_tmp80_ = call;
			if (_tmp80_ != NULL) {
				ValaMethodType* method_type = NULL;
				ValaMethodCall* _tmp81_;
				ValaExpression* _tmp82_;
				ValaExpression* _tmp83_;
				ValaDataType* _tmp84_;
				ValaDataType* _tmp85_;
				ValaMethodType* _tmp86_;
				gboolean _tmp87_ = FALSE;
				ValaMethodType* _tmp88_;
				_tmp81_ = call;
				_tmp82_ = vala_method_call_get_call (_tmp81_);
				_tmp83_ = _tmp82_;
				_tmp84_ = vala_expression_get_value_type (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = _vala_code_node_ref0 (VALA_IS_METHOD_TYPE (_tmp85_) ? ((ValaMethodType*) _tmp85_) : NULL);
				method_type = _tmp86_;
				_tmp88_ = method_type;
				if (_tmp88_ != NULL) {
					ValaMethodType* _tmp89_;
					ValaMethod* _tmp90_;
					ValaMethod* _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					_tmp89_ = method_type;
					_tmp90_ = vala_method_type_get_method_symbol (_tmp89_);
					_tmp91_ = _tmp90_;
					_tmp92_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp91_);
					_tmp93_ = _tmp92_;
					_tmp87_ = g_strcmp0 (_tmp93_, "GLib._") == 0;
					_g_free0 (_tmp93_);
				} else {
					_tmp87_ = FALSE;
				}
				if (_tmp87_) {
					ValaStringLiteral* literal = NULL;
					ValaMethodCall* _tmp94_;
					ValaList* _tmp95_;
					ValaList* _tmp96_;
					gpointer _tmp97_;
					ValaExpression* _tmp98_;
					ValaStringLiteral* _tmp99_;
					ValaStringLiteral* _tmp100_;
					ValaStringLiteral* _tmp101_;
					_tmp94_ = call;
					_tmp95_ = vala_method_call_get_argument_list (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_list_get (_tmp96_, 0);
					_tmp98_ = (ValaExpression*) _tmp97_;
					_tmp99_ = VALA_IS_STRING_LITERAL (_tmp98_) ? ((ValaStringLiteral*) _tmp98_) : NULL;
					if (_tmp99_ == NULL) {
						_vala_code_node_unref0 (_tmp98_);
					}
					_tmp100_ = _tmp99_;
					_vala_iterable_unref0 (_tmp96_);
					literal = _tmp100_;
					_tmp101_ = literal;
					if (_tmp101_ != NULL) {
						ValaStringLiteral* _tmp102_;
						ValaStringLiteral* _tmp103_;
						_tmp102_ = literal;
						vala_constant_set_value (self, (ValaExpression*) _tmp102_);
						_tmp103_ = literal;
						vala_string_literal_set_translate (_tmp103_, TRUE);
					}
					_vala_code_node_unref0 (literal);
				}
				_vala_code_node_unref0 (method_type);
			}
			_tmp104_ = vala_constant_get_value (self);
			_tmp105_ = _tmp104_;
			if (!vala_expression_is_constant (_tmp105_)) {
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				ValaSourceReference* _tmp108_;
				ValaSourceReference* _tmp109_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp106_ = vala_constant_get_value (self);
				_tmp107_ = _tmp106_;
				_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp107_);
				_tmp109_ = _tmp108_;
				vala_report_error (_tmp109_, "Value must be constant");
				result = FALSE;
				_vala_code_node_unref0 (call);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (call);
		}
	} else {
		ValaExpression* _tmp110_;
		ValaExpression* _tmp111_;
		_tmp110_ = vala_constant_get_value (self);
		_tmp111_ = _tmp110_;
		if (_tmp111_ != NULL) {
			ValaSourceReference* _tmp112_;
			ValaSourceReference* _tmp113_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp113_ = _tmp112_;
			vala_report_error (_tmp113_, "External constants cannot use values");
		}
	}
	_tmp116_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp117_ = _tmp116_;
	if (!_tmp117_) {
		gboolean _tmp118_;
		gboolean _tmp119_;
		_tmp118_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp119_ = _tmp118_;
		_tmp115_ = !_tmp119_;
	} else {
		_tmp115_ = FALSE;
	}
	if (_tmp115_) {
		ValaSymbol* _tmp120_;
		ValaSymbol* _tmp121_;
		_tmp120_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp121_ = _tmp120_;
		_tmp114_ = _tmp121_ != NULL;
		_vala_code_node_unref0 (_tmp121_);
	} else {
		_tmp114_ = FALSE;
	}
	if (_tmp114_) {
		ValaSourceReference* _tmp122_;
		ValaSourceReference* _tmp123_;
		gchar* _tmp124_;
		gchar* _tmp125_;
		ValaSymbol* _tmp126_;
		ValaSymbol* _tmp127_;
		gchar* _tmp128_;
		gchar* _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp127_ = _tmp126_;
		_tmp128_ = vala_symbol_get_full_name (_tmp127_);
		_tmp129_ = _tmp128_;
		_tmp130_ = g_strdup_printf ("%s hides inherited constant `%s'. Use the `new' keyword if hiding was " \
"intentional", _tmp125_, _tmp129_);
		_tmp131_ = _tmp130_;
		vala_report_warning (_tmp123_, _tmp131_);
		_g_free0 (_tmp131_);
		_g_free0 (_tmp129_);
		_vala_code_node_unref0 (_tmp127_);
		_g_free0 (_tmp125_);
	}
	_tmp132_ = vala_code_context_get_analyzer (context);
	_tmp133_ = _tmp132_;
	_tmp134_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp133_, _tmp134_);
	_tmp135_ = vala_code_context_get_analyzer (context);
	_tmp136_ = _tmp135_;
	_tmp137_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp136_, _tmp137_);
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp138_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp139_ = _tmp138_;
	result = !_tmp139_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static gboolean
vala_constant_check_const_type (ValaConstant* self,
                                ValaDataType* type,
                                ValaCodeContext* context)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	if (VALA_IS_VALUE_TYPE (type)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		if (VALA_IS_VOID_TYPE (type)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = VALA_IS_POINTER_TYPE (type);
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		} else {
			if (VALA_IS_ARRAY_TYPE (type)) {
				ValaArrayType* array_type = NULL;
				ValaArrayType* _tmp1_;
				ValaArrayType* _tmp2_;
				ValaDataType* _tmp3_;
				ValaDataType* _tmp4_;
				_tmp1_ = _vala_code_node_ref0 (VALA_IS_ARRAY_TYPE (type) ? ((ValaArrayType*) type) : NULL);
				array_type = _tmp1_;
				_tmp2_ = array_type;
				_tmp3_ = vala_array_type_get_element_type (_tmp2_);
				_tmp4_ = _tmp3_;
				result = vala_constant_check_const_type (self, _tmp4_, context);
				_vala_code_node_unref0 (array_type);
				return result;
			} else {
				ValaTypeSymbol* _tmp5_;
				ValaTypeSymbol* _tmp6_;
				_tmp5_ = vala_data_type_get_data_type (type);
				_tmp6_ = _tmp5_;
				if (_tmp6_ != NULL) {
					ValaTypeSymbol* _tmp7_;
					ValaTypeSymbol* _tmp8_;
					ValaSemanticAnalyzer* _tmp9_;
					ValaSemanticAnalyzer* _tmp10_;
					ValaDataType* _tmp11_;
					ValaTypeSymbol* _tmp12_;
					ValaTypeSymbol* _tmp13_;
					_tmp7_ = vala_data_type_get_data_type (type);
					_tmp8_ = _tmp7_;
					_tmp9_ = vala_code_context_get_analyzer (context);
					_tmp10_ = _tmp9_;
					_tmp11_ = _tmp10_->string_type;
					_tmp12_ = vala_data_type_get_data_type (_tmp11_);
					_tmp13_ = _tmp12_;
					result = vala_typesymbol_is_subtype_of (_tmp8_, _tmp13_);
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

ValaDataType*
vala_constant_get_type_reference (ValaConstant* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

void
vala_constant_set_type_reference (ValaConstant* self,
                                  ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaExpression*
vala_constant_get_value (ValaConstant* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

void
vala_constant_set_value (ValaConstant* self,
                         ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value);
	self->priv->_value = _tmp0_;
	_tmp1_ = self->priv->_value;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_value;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

static void
vala_constant_class_init (ValaConstantClass * klass,
                          gpointer klass_data)
{
	vala_constant_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_constant_finalize;
	g_type_class_adjust_private_offset (klass, &ValaConstant_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_constant_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_constant_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_constant_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_constant_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_constant_real_check;
}

static void
vala_constant_instance_init (ValaConstant * self,
                             gpointer klass)
{
	self->priv = vala_constant_get_instance_private (self);
}

static void
vala_constant_finalize (ValaCodeNode * obj)
{
	ValaConstant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CONSTANT, ValaConstant);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_value);
	VALA_CODE_NODE_CLASS (vala_constant_parent_class)->finalize (obj);
}

/**
 * Represents a type member with a constant value.
 */
GType
vala_constant_get_type (void)
{
	static volatile gsize vala_constant_type_id__volatile = 0;
	if (g_once_init_enter (&vala_constant_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaConstantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_constant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaConstant), 0, (GInstanceInitFunc) vala_constant_instance_init, NULL };
		GType vala_constant_type_id;
		vala_constant_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaConstant", &g_define_type_info, 0);
		ValaConstant_private_offset = g_type_add_instance_private (vala_constant_type_id, sizeof (ValaConstantPrivate));
		g_once_init_leave (&vala_constant_type_id__volatile, vala_constant_type_id);
	}
	return vala_constant_type_id__volatile;
}

