/* valaarraycreationexpression.c generated by valac, the Vala compiler
 * generated from valaarraycreationexpression.vala, do not modify */

/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaArrayCreationExpressionPrivate {
	gint _rank;
	ValaList* sizes;
	ValaDataType* _element_type;
	ValaDataType* _length_type;
	ValaInitializerList* _initializer_list;
};

static gint ValaArrayCreationExpression_private_offset;
static gpointer vala_array_creation_expression_parent_class = NULL;

static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base,
                                                          ValaCodeVisitor* visitor);
static void vala_array_creation_expression_real_accept (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_array_creation_expression_real_is_accessible (ValaExpression* base,
                                                            ValaSymbol* sym);
static gchar* vala_array_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_array_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                             ValaExpression* old_node,
                                                             ValaExpression* new_node);
static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base,
                                                       ValaDataType* old_type,
                                                       ValaDataType* new_type);
static gint vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self,
                                                                        ValaCodeContext* context,
                                                                        ValaInitializerList* il,
                                                                        gint rank,
                                                                        ValaList* sl);
static gboolean vala_array_creation_expression_real_check (ValaCodeNode* base,
                                                    ValaCodeContext* context);
static void vala_array_creation_expression_real_emit (ValaCodeNode* base,
                                               ValaCodeGenerator* codegen);
static void vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                             ValaCollection* collection);
static void vala_array_creation_expression_finalize (ValaCodeNode * obj);

static inline gpointer
vala_array_creation_expression_get_instance_private (ValaArrayCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaArrayCreationExpression_private_offset);
}

/**
 * Add a size expression.
 */
void
vala_array_creation_expression_append_size (ValaArrayCreationExpression* self,
                                            ValaExpression* size)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (size != NULL);
	_tmp0_ = self->priv->sizes;
	vala_collection_add ((ValaCollection*) _tmp0_, size);
	if (size != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) size, (ValaCodeNode*) self);
	}
}

/**
 * Get the sizes for all dimensions ascending from left to right.
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sizes;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

ValaArrayCreationExpression*
vala_array_creation_expression_construct (GType object_type,
                                          ValaDataType* element_type,
                                          gint rank,
                                          ValaInitializerList* initializer_list,
                                          ValaSourceReference* source_reference)
{
	ValaArrayCreationExpression* self = NULL;
	g_return_val_if_fail (element_type != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaArrayCreationExpression*) vala_expression_construct (object_type);
	vala_array_creation_expression_set_element_type (self, element_type);
	vala_array_creation_expression_set_rank (self, rank);
	vala_array_creation_expression_set_initializer_list (self, initializer_list);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaArrayCreationExpression*
vala_array_creation_expression_new (ValaDataType* element_type,
                                    gint rank,
                                    ValaInitializerList* initializer_list,
                                    ValaSourceReference* source_reference)
{
	return vala_array_creation_expression_construct (VALA_TYPE_ARRAY_CREATION_EXPRESSION, element_type, rank, initializer_list, source_reference);
}

static void
vala_array_creation_expression_real_accept_children (ValaCodeNode* base,
                                                     ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaInitializerList* _tmp16_;
	ValaInitializerList* _tmp17_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_array_creation_expression_get_element_type (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_array_creation_expression_get_length_type (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_array_creation_expression_get_length_type (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _e_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _e_index = 0;
		_tmp8_ = self->priv->sizes;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_e_list = _tmp9_;
		_tmp10_ = _e_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_e_size = _tmp12_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaExpression* _tmp15_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp13_ = _e_list;
			_tmp14_ = vala_list_get (_tmp13_, _e_index);
			e = (ValaExpression*) _tmp14_;
			_tmp15_ = e;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp16_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaInitializerList* _tmp18_;
		ValaInitializerList* _tmp19_;
		_tmp18_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp19_ = _tmp18_;
		vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
	}
}

static void
vala_array_creation_expression_real_accept (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_array_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gboolean
vala_array_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_array_creation_expression_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym)
{
	ValaArrayCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	gboolean _tmp5_ = FALSE;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaInitializerList* _tmp18_;
	ValaInitializerList* _tmp19_;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_array_creation_expression_get_element_type (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp3_ = vala_array_creation_expression_get_element_type (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_data_type_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_array_creation_expression_get_length_type (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_array_creation_expression_get_length_type (self);
		_tmp9_ = _tmp8_;
		_tmp5_ = !vala_data_type_is_accessible (_tmp9_, sym);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _e_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _e_index = 0;
		_tmp10_ = self->priv->sizes;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_e_list = _tmp11_;
		_tmp12_ = _e_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_e_size = _tmp14_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaExpression* _tmp17_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp15_ = _e_list;
			_tmp16_ = vala_list_get (_tmp15_, _e_index);
			e = (ValaExpression*) _tmp16_;
			_tmp17_ = e;
			if (!vala_expression_is_accessible (_tmp17_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (e);
				_vala_iterable_unref0 (_e_list);
				return result;
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp18_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaInitializerList* _tmp20_;
		ValaInitializerList* _tmp21_;
		_tmp20_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp21_ = _tmp20_;
		result = vala_expression_is_accessible ((ValaExpression*) _tmp21_, sym);
		return result;
	}
	result = TRUE;
	return result;
}

static gchar*
vala_array_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaArrayCreationExpression * self;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean first = FALSE;
	GString* _tmp21_;
	ValaInitializerList* _tmp22_;
	ValaInitializerList* _tmp23_;
	GString* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* result = NULL;
	self = (ValaArrayCreationExpression*) base;
	_tmp0_ = g_string_new ("new ");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = vala_array_creation_expression_get_element_type (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_code_node_to_string ((ValaCodeNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp1_, "%s[", _tmp5_);
	_g_free0 (_tmp5_);
	first = TRUE;
	{
		ValaList* _size_list = NULL;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gint _size_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _size_index = 0;
		_tmp6_ = self->priv->sizes;
		_tmp7_ = _vala_iterable_ref0 (_tmp6_);
		_size_list = _tmp7_;
		_tmp8_ = _size_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_size_size = _tmp10_;
		_size_index = -1;
		while (TRUE) {
			ValaExpression* size = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			_size_index = _size_index + 1;
			if (!(_size_index < _size_size)) {
				break;
			}
			_tmp11_ = _size_list;
			_tmp12_ = vala_list_get (_tmp11_, _size_index);
			size = (ValaExpression*) _tmp12_;
			if (first) {
				GString* _tmp13_;
				ValaExpression* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp13_ = builder;
				_tmp14_ = size;
				_tmp15_ = vala_code_node_to_string ((ValaCodeNode*) _tmp14_);
				_tmp16_ = _tmp15_;
				g_string_append (_tmp13_, _tmp16_);
				_g_free0 (_tmp16_);
				first = FALSE;
			} else {
				GString* _tmp17_;
				ValaExpression* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp17_ = builder;
				_tmp18_ = size;
				_tmp19_ = vala_code_node_to_string ((ValaCodeNode*) _tmp18_);
				_tmp20_ = _tmp19_;
				g_string_append_printf (_tmp17_, ", %s", _tmp20_);
				_g_free0 (_tmp20_);
			}
			_vala_code_node_unref0 (size);
		}
		_vala_iterable_unref0 (_size_list);
	}
	_tmp21_ = builder;
	g_string_append_c (_tmp21_, ']');
	_tmp22_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != NULL) {
		GString* _tmp24_;
		ValaInitializerList* _tmp25_;
		ValaInitializerList* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp24_ = builder;
		_tmp25_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_node_to_string ((ValaCodeNode*) _tmp26_);
		_tmp28_ = _tmp27_;
		g_string_append (_tmp24_, _tmp28_);
		_g_free0 (_tmp28_);
	}
	_tmp29_ = builder;
	_tmp30_ = _tmp29_->str;
	_tmp31_ = g_strdup (_tmp30_);
	result = _tmp31_;
	_g_string_free0 (builder);
	return result;
}

static void
vala_array_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                        ValaExpression* old_node,
                                                        ValaExpression* new_node)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaExpression* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->sizes;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->sizes;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaExpression*) _tmp6_;
				_tmp8_ = _tmp7_ == old_node;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->sizes;
					vala_list_set (_tmp9_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_array_creation_expression_real_replace_type (ValaCodeNode* base,
                                                  ValaDataType* old_type,
                                                  ValaDataType* new_type)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_array_creation_expression_set_element_type (self, new_type);
	}
	_tmp2_ = vala_array_creation_expression_get_length_type (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_array_creation_expression_set_length_type (self, new_type);
	}
}

static gint
vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self,
                                                                   ValaCodeContext* context,
                                                                   ValaInitializerList* il,
                                                                   gint rank,
                                                                   ValaList* sl)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint subsize = 0;
	gint _tmp38_;
	gint _tmp39_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (context != NULL, 0);
	g_return_val_if_fail (il != NULL, 0);
	g_return_val_if_fail (sl != NULL, 0);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) sl);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_rank;
	if (_tmp1_ == (_tmp2_ - rank)) {
		ValaIntegerLiteral* init = NULL;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaIntegerLiteral* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		_tmp3_ = vala_initializer_list_get_size (il);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%i", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_integer_literal_new (_tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp6_);
		init = _tmp10_;
		_tmp11_ = init;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
		_tmp12_ = init;
		vala_collection_add ((ValaCollection*) sl, (ValaLiteral*) _tmp12_);
		_vala_code_node_unref0 (init);
	}
	subsize = -1;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp13_;
		gint _e_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _e_index = 0;
		_tmp13_ = vala_initializer_list_get_initializers (il);
		_e_list = _tmp13_;
		_tmp14_ = _e_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_e_size = _tmp16_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			gboolean _tmp19_ = FALSE;
			ValaExpression* _tmp20_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp17_ = _e_list;
			_tmp18_ = vala_list_get (_tmp17_, _e_index);
			e = (ValaExpression*) _tmp18_;
			_tmp20_ = e;
			if (VALA_IS_INITIALIZER_LIST (_tmp20_)) {
				ValaExpression* _tmp21_;
				ValaDataType* _tmp22_;
				ValaDataType* _tmp23_;
				_tmp21_ = e;
				_tmp22_ = vala_expression_get_target_type (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp19_ = VALA_IS_ARRAY_TYPE (_tmp23_);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				gint size = 0;
				ValaExpression* _tmp28_;
				gboolean _tmp29_ = FALSE;
				if (rank == 1) {
					ValaExpression* _tmp24_;
					ValaExpression* _tmp25_;
					ValaSourceReference* _tmp26_;
					ValaSourceReference* _tmp27_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp24_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp24_, TRUE);
					_tmp25_ = e;
					_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
					_tmp27_ = _tmp26_;
					vala_report_error (_tmp27_, "Expected array element, got array initializer list");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				_tmp28_ = e;
				size = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList), rank - 1, sl);
				if (size == -1) {
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				if (subsize >= 0) {
					_tmp29_ = subsize != size;
				} else {
					_tmp29_ = FALSE;
				}
				if (_tmp29_) {
					ValaSourceReference* _tmp30_;
					ValaSourceReference* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
					_tmp31_ = _tmp30_;
					_tmp32_ = g_strdup_printf ("Expected initializer list of size %d, got size %d", subsize, size);
					_tmp33_ = _tmp32_;
					vala_report_error (_tmp31_, _tmp33_);
					_g_free0 (_tmp33_);
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				} else {
					subsize = size;
				}
			} else {
				if (rank != 1) {
					ValaExpression* _tmp34_;
					ValaExpression* _tmp35_;
					ValaSourceReference* _tmp36_;
					ValaSourceReference* _tmp37_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp34_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp34_, TRUE);
					_tmp35_ = e;
					_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp35_);
					_tmp37_ = _tmp36_;
					vala_report_error (_tmp37_, "Expected array initializer list, got array element");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp38_ = vala_initializer_list_get_size (il);
	_tmp39_ = _tmp38_;
	result = _tmp39_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_array_creation_expression_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context)
{
	ValaArrayCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaList* sizes = NULL;
	ValaList* _tmp4_;
	ValaInitializerList* initlist = NULL;
	ValaInitializerList* _tmp5_;
	ValaInitializerList* _tmp6_;
	ValaInitializerList* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaArrayList* calc_sizes = NULL;
	GEqualFunc _tmp35_;
	ValaArrayList* _tmp36_;
	ValaInitializerList* _tmp37_;
	ValaList* _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	gboolean _tmp118_;
	gboolean _tmp119_;
	gboolean _tmp120_ = FALSE;
	ValaInitializerList* _tmp121_;
	ValaInitializerList* _tmp122_;
	ValaDataType* _tmp127_;
	ValaDataType* _tmp128_;
	ValaDataType* _tmp131_;
	ValaDataType* _tmp132_;
	gint _tmp133_;
	ValaSourceReference* _tmp134_;
	ValaSourceReference* _tmp135_;
	ValaArrayType* _tmp136_;
	ValaArrayType* _tmp137_;
	ValaDataType* _tmp138_;
	ValaDataType* _tmp139_;
	ValaDataType* _tmp140_;
	ValaDataType* _tmp141_;
	ValaDataType* _tmp142_;
	ValaDataType* _tmp143_;
	ValaDataType* _tmp144_;
	ValaDataType* _tmp145_;
	ValaDataType* _tmp158_;
	ValaDataType* _tmp159_;
	ValaDataType* _tmp160_;
	ValaDataType* _tmp161_;
	gboolean _tmp162_;
	gboolean _tmp163_;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_array_creation_expression_get_sizes (self);
	sizes = _tmp4_;
	_tmp5_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _vala_code_node_ref0 (_tmp6_);
	initlist = _tmp7_;
	_tmp8_ = vala_array_creation_expression_get_element_type (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_array_creation_expression_get_element_type (self);
		_tmp11_ = _tmp10_;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
	}
	_tmp12_ = vala_array_creation_expression_get_length_type (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == NULL) {
		ValaSemanticAnalyzer* _tmp14_;
		ValaSemanticAnalyzer* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		_tmp14_ = vala_code_context_get_analyzer (context);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_->int_type;
		_tmp17_ = vala_data_type_copy (_tmp16_);
		_tmp18_ = _tmp17_;
		vala_array_creation_expression_set_length_type (self, _tmp18_);
		_vala_code_node_unref0 (_tmp18_);
	} else {
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		_tmp19_ = vala_array_creation_expression_get_length_type (self);
		_tmp20_ = _tmp19_;
		vala_code_node_check ((ValaCodeNode*) _tmp20_, context);
		_tmp21_ = vala_array_creation_expression_get_length_type (self);
		_tmp22_ = _tmp21_;
		if (!VALA_IS_INTEGER_TYPE (_tmp22_)) {
			ValaDataType* _tmp23_;
			ValaDataType* _tmp24_;
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp23_ = vala_array_creation_expression_get_length_type (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			vala_report_error (_tmp26_, "Expected integer type as length type of array");
		}
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp27_;
		ValaList* _tmp28_;
		gint _e_size = 0;
		ValaList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _e_index = 0;
		_tmp27_ = sizes;
		_tmp28_ = _vala_iterable_ref0 (_tmp27_);
		_e_list = _tmp28_;
		_tmp29_ = _e_list;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_e_size = _tmp31_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp32_;
			gpointer _tmp33_;
			ValaExpression* _tmp34_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp32_ = _e_list;
			_tmp33_ = vala_list_get (_tmp32_, _e_index);
			e = (ValaExpression*) _tmp33_;
			_tmp34_ = e;
			vala_code_node_check ((ValaCodeNode*) _tmp34_, context);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp35_ = g_direct_equal;
	_tmp36_ = vala_array_list_new (VALA_TYPE_LITERAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp35_);
	calc_sizes = _tmp36_;
	_tmp37_ = initlist;
	if (_tmp37_ != NULL) {
		ValaInitializerList* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		gint _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaArrayType* _tmp44_;
		ValaArrayType* _tmp45_;
		ValaInitializerList* _tmp46_;
		ValaDataType* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		ValaDataType* _tmp52_;
		ValaInitializerList* _tmp53_;
		gint ret = 0;
		ValaInitializerList* _tmp54_;
		gint _tmp55_;
		ValaArrayList* _tmp56_;
		ValaArrayList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		_tmp38_ = initlist;
		_tmp39_ = vala_array_creation_expression_get_element_type (self);
		_tmp40_ = _tmp39_;
		_tmp41_ = self->priv->_rank;
		_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_array_type_new (_tmp40_, _tmp41_, _tmp43_);
		_tmp45_ = _tmp44_;
		vala_expression_set_target_type ((ValaExpression*) _tmp38_, (ValaDataType*) _tmp45_);
		_vala_code_node_unref0 (_tmp45_);
		_tmp46_ = initlist;
		_tmp47_ = vala_expression_get_target_type ((ValaExpression*) _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_array_creation_expression_get_length_type (self);
		_tmp50_ = _tmp49_;
		_tmp51_ = vala_data_type_copy (_tmp50_);
		_tmp52_ = _tmp51_;
		vala_array_type_set_length_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp52_);
		_vala_code_node_unref0 (_tmp52_);
		_tmp53_ = initlist;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp53_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp54_ = initlist;
		_tmp55_ = self->priv->_rank;
		_tmp56_ = calc_sizes;
		ret = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, _tmp54_, _tmp55_, (ValaList*) _tmp56_);
		if (ret == -1) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp57_ = calc_sizes;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = self->priv->_rank;
		if (_tmp59_ != _tmp60_) {
			ValaArrayType* actual_type = NULL;
			ValaDataType* _tmp61_;
			ValaDataType* _tmp62_;
			ValaArrayList* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			ValaSourceReference* _tmp66_;
			ValaSourceReference* _tmp67_;
			ValaArrayType* _tmp68_;
			ValaArrayType* _tmp69_;
			ValaDataType* _tmp70_;
			ValaDataType* _tmp71_;
			ValaInitializerList* _tmp72_;
			ValaSourceReference* _tmp73_;
			ValaSourceReference* _tmp74_;
			ValaDataType* _tmp75_;
			ValaDataType* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			ValaArrayType* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp61_ = vala_array_creation_expression_get_element_type (self);
			_tmp62_ = _tmp61_;
			_tmp63_ = calc_sizes;
			_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_array_type_new (_tmp62_, _tmp65_, _tmp67_);
			actual_type = _tmp68_;
			_tmp69_ = actual_type;
			_tmp70_ = vala_array_creation_expression_get_length_type (self);
			_tmp71_ = _tmp70_;
			vala_array_type_set_length_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp71_);
			_tmp72_ = initlist;
			_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp76_ = _tmp75_;
			_tmp77_ = vala_code_node_to_string ((ValaCodeNode*) _tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = actual_type;
			_tmp80_ = vala_code_node_to_string ((ValaCodeNode*) _tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = g_strdup_printf ("Expected initializer for `%s' but got `%s'", _tmp78_, _tmp81_);
			_tmp83_ = _tmp82_;
			vala_report_error (_tmp74_, _tmp83_);
			_g_free0 (_tmp83_);
			_g_free0 (_tmp81_);
			_g_free0 (_tmp78_);
			_vala_code_node_unref0 (actual_type);
		}
	}
	_tmp84_ = sizes;
	_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
	_tmp86_ = _tmp85_;
	if (_tmp86_ > 0) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp87_;
			ValaList* _tmp88_;
			gint _e_size = 0;
			ValaList* _tmp89_;
			gint _tmp90_;
			gint _tmp91_;
			gint _e_index = 0;
			_tmp87_ = sizes;
			_tmp88_ = _vala_iterable_ref0 (_tmp87_);
			_e_list = _tmp88_;
			_tmp89_ = _e_list;
			_tmp90_ = vala_collection_get_size ((ValaCollection*) _tmp89_);
			_tmp91_ = _tmp90_;
			_e_size = _tmp91_;
			_e_index = -1;
			while (TRUE) {
				ValaExpression* e = NULL;
				ValaList* _tmp92_;
				gpointer _tmp93_;
				ValaExpression* _tmp94_;
				ValaDataType* _tmp95_;
				ValaDataType* _tmp96_;
				_e_index = _e_index + 1;
				if (!(_e_index < _e_size)) {
					break;
				}
				_tmp92_ = _e_list;
				_tmp93_ = vala_list_get (_tmp92_, _e_index);
				e = (ValaExpression*) _tmp93_;
				_tmp94_ = e;
				_tmp95_ = vala_expression_get_value_type (_tmp94_);
				_tmp96_ = _tmp95_;
				if (_tmp96_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					_vala_iterable_unref0 (calc_sizes);
					_vala_code_node_unref0 (initlist);
					_vala_iterable_unref0 (sizes);
					return result;
				} else {
					gboolean _tmp97_ = FALSE;
					ValaExpression* _tmp98_;
					ValaDataType* _tmp99_;
					ValaDataType* _tmp100_;
					_tmp98_ = e;
					_tmp99_ = vala_expression_get_value_type (_tmp98_);
					_tmp100_ = _tmp99_;
					if (VALA_IS_INTEGER_TYPE (_tmp100_)) {
						_tmp97_ = TRUE;
					} else {
						ValaExpression* _tmp101_;
						ValaDataType* _tmp102_;
						ValaDataType* _tmp103_;
						_tmp101_ = e;
						_tmp102_ = vala_expression_get_value_type (_tmp101_);
						_tmp103_ = _tmp102_;
						_tmp97_ = VALA_IS_ENUM_VALUE_TYPE (_tmp103_);
					}
					if (!_tmp97_) {
						ValaExpression* _tmp104_;
						ValaSourceReference* _tmp105_;
						ValaSourceReference* _tmp106_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp104_ = e;
						_tmp105_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp104_);
						_tmp106_ = _tmp105_;
						vala_report_error (_tmp106_, "Expression of integer type expected");
					}
				}
				_vala_code_node_unref0 (e);
			}
			_vala_iterable_unref0 (_e_list);
		}
	} else {
		ValaInitializerList* _tmp107_;
		_tmp107_ = initlist;
		if (_tmp107_ == NULL) {
			ValaSourceReference* _tmp108_;
			ValaSourceReference* _tmp109_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp109_ = _tmp108_;
			vala_report_error (_tmp109_, "internal error: initializer list expected");
		} else {
			{
				ValaArrayList* _size_list = NULL;
				ValaArrayList* _tmp110_;
				ValaArrayList* _tmp111_;
				gint _size_size = 0;
				ValaArrayList* _tmp112_;
				gint _tmp113_;
				gint _tmp114_;
				gint _size_index = 0;
				_tmp110_ = calc_sizes;
				_tmp111_ = _vala_iterable_ref0 (_tmp110_);
				_size_list = _tmp111_;
				_tmp112_ = _size_list;
				_tmp113_ = vala_collection_get_size ((ValaCollection*) _tmp112_);
				_tmp114_ = _tmp113_;
				_size_size = _tmp114_;
				_size_index = -1;
				while (TRUE) {
					ValaExpression* size = NULL;
					ValaArrayList* _tmp115_;
					gpointer _tmp116_;
					ValaExpression* _tmp117_;
					_size_index = _size_index + 1;
					if (!(_size_index < _size_size)) {
						break;
					}
					_tmp115_ = _size_list;
					_tmp116_ = vala_list_get ((ValaList*) _tmp115_, _size_index);
					size = (ValaExpression*) ((ValaLiteral*) _tmp116_);
					_tmp117_ = size;
					vala_array_creation_expression_append_size (self, _tmp117_);
					_vala_code_node_unref0 (size);
				}
				_vala_iterable_unref0 (_size_list);
			}
		}
	}
	_tmp118_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp119_ = _tmp118_;
	if (_tmp119_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp121_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp122_ = _tmp121_;
	if (_tmp122_ != NULL) {
		ValaInitializerList* _tmp123_;
		ValaInitializerList* _tmp124_;
		ValaDataType* _tmp125_;
		ValaDataType* _tmp126_;
		_tmp123_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp124_ = _tmp123_;
		_tmp125_ = vala_expression_get_value_type ((ValaExpression*) _tmp124_);
		_tmp126_ = _tmp125_;
		_tmp120_ = _tmp126_ == NULL;
	} else {
		_tmp120_ = FALSE;
	}
	if (_tmp120_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp127_ = vala_array_creation_expression_get_element_type (self);
	_tmp128_ = _tmp127_;
	if (_tmp128_ == NULL) {
		ValaSourceReference* _tmp129_;
		ValaSourceReference* _tmp130_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp130_ = _tmp129_;
		vala_report_error (_tmp130_, "Cannot determine the element type of the created array");
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp131_ = vala_array_creation_expression_get_element_type (self);
	_tmp132_ = _tmp131_;
	_tmp133_ = self->priv->_rank;
	_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp135_ = _tmp134_;
	_tmp136_ = vala_array_type_new (_tmp132_, _tmp133_, _tmp135_);
	_tmp137_ = _tmp136_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp137_);
	_vala_code_node_unref0 (_tmp137_);
	_tmp138_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp139_ = _tmp138_;
	_tmp140_ = vala_array_creation_expression_get_length_type (self);
	_tmp141_ = _tmp140_;
	_tmp142_ = vala_data_type_copy (_tmp141_);
	_tmp143_ = _tmp142_;
	vala_array_type_set_length_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp139_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp143_);
	_vala_code_node_unref0 (_tmp143_);
	_tmp144_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
	_tmp145_ = _tmp144_;
	if (VALA_IS_ARRAY_TYPE (_tmp145_)) {
		ValaDataType* _tmp146_;
		ValaDataType* _tmp147_;
		ValaDataType* _tmp148_;
		ValaDataType* _tmp149_;
		gboolean _tmp150_;
		gboolean _tmp151_;
		ValaDataType* _tmp152_;
		ValaDataType* _tmp153_;
		ValaDataType* _tmp154_;
		ValaDataType* _tmp155_;
		gboolean _tmp156_;
		gboolean _tmp157_;
		_tmp146_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp149_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp151_ = _tmp150_;
		vala_array_type_set_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp151_);
		_tmp152_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp153_ = _tmp152_;
		_tmp154_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp155_ = _tmp154_;
		_tmp156_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp155_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp157_ = _tmp156_;
		vala_array_type_set_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp157_);
	}
	_tmp158_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp159_ = _tmp158_;
	vala_data_type_set_value_owned (_tmp159_, TRUE);
	_tmp160_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp161_ = _tmp160_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp161_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp162_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp163_ = _tmp162_;
	result = !_tmp163_;
	_vala_iterable_unref0 (calc_sizes);
	_vala_code_node_unref0 (initlist);
	_vala_iterable_unref0 (sizes);
	return result;
}

static void
vala_array_creation_expression_real_emit (ValaCodeNode* base,
                                          ValaCodeGenerator* codegen)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp8_;
	ValaInitializerList* _tmp9_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp5_ = _e_list;
			_tmp6_ = vala_list_get (_tmp5_, _e_index);
			e = (ValaExpression*) _tmp6_;
			_tmp7_ = e;
			vala_code_node_emit ((ValaCodeNode*) _tmp7_, codegen);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp8_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaInitializerList* _tmp10_;
		ValaInitializerList* _tmp11_;
		_tmp10_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp11_ = _tmp10_;
		vala_code_node_emit ((ValaCodeNode*) _tmp11_, codegen);
	}
	vala_code_visitor_visit_array_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                        ValaCollection* collection)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp8_;
	ValaInitializerList* _tmp9_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp5_ = _e_list;
			_tmp6_ = vala_list_get (_tmp5_, _e_index);
			e = (ValaExpression*) _tmp6_;
			_tmp7_ = e;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp7_, collection);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp8_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaInitializerList* _tmp10_;
		ValaInitializerList* _tmp11_;
		_tmp10_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp11_ = _tmp10_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
	}
}

ValaDataType*
vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_type;
	result = _tmp0_;
	return result;
}

void
vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self,
                                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_element_type);
	self->priv->_element_type = _tmp0_;
	_tmp1_ = self->priv->_element_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaDataType*
vala_array_creation_expression_get_length_type (ValaArrayCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_length_type;
	result = _tmp0_;
	return result;
}

void
vala_array_creation_expression_set_length_type (ValaArrayCreationExpression* self,
                                                ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_length_type);
	self->priv->_length_type = _tmp0_;
	_tmp1_ = self->priv->_length_type;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		_tmp2_ = self->priv->_length_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gint
vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rank;
	return result;
}

void
vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self,
                                         gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}

ValaInitializerList*
vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self)
{
	ValaInitializerList* result;
	ValaInitializerList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer_list;
	result = _tmp0_;
	return result;
}

void
vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self,
                                                     ValaInitializerList* value)
{
	ValaInitializerList* _tmp0_;
	ValaInitializerList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	self->priv->_initializer_list = _tmp0_;
	_tmp1_ = self->priv->_initializer_list;
	if (_tmp1_ != NULL) {
		ValaInitializerList* _tmp2_;
		_tmp2_ = self->priv->_initializer_list;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

static void
vala_array_creation_expression_class_init (ValaArrayCreationExpressionClass * klass,
                                           gpointer klass_data)
{
	vala_array_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_array_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaArrayCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_creation_expression_real_accept;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_array_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_array_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_array_creation_expression_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_array_creation_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_array_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_array_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_array_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_array_creation_expression_real_get_used_variables;
}

static void
vala_array_creation_expression_instance_init (ValaArrayCreationExpression * self,
                                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_array_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->sizes = (ValaList*) _tmp1_;
}

static void
vala_array_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaArrayCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression);
	_vala_iterable_unref0 (self->priv->sizes);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->_length_type);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	VALA_CODE_NODE_CLASS (vala_array_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an array creation expression.
 *
 * {{{ new int[] { 1, 2, 3 } }}}
 */
GType
vala_array_creation_expression_get_type (void)
{
	static volatile gsize vala_array_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_array_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayCreationExpression), 0, (GInstanceInitFunc) vala_array_creation_expression_instance_init, NULL };
		GType vala_array_creation_expression_type_id;
		vala_array_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaArrayCreationExpression", &g_define_type_info, 0);
		ValaArrayCreationExpression_private_offset = g_type_add_instance_private (vala_array_creation_expression_type_id, sizeof (ValaArrayCreationExpressionPrivate));
		g_once_init_leave (&vala_array_creation_expression_type_id__volatile, vala_array_creation_expression_type_id);
	}
	return vala_array_creation_expression_type_id__volatile;
}

