/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaGLibValue, vala_target_value_unref)
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp164_;
	GEqualFunc _tmp165_;
	GEqualFunc _tmp166_;
	ValaHashMap* _tmp167_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp168_;
	ValaHashMap* _tmp169_;
	gboolean _tmp170_ = FALSE;
	ValaMethod* _tmp171_;
	gboolean _tmp288_ = FALSE;
	ValaMethod* _tmp289_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp452_;
	ValaCCodeExpression* _tmp453_;
	ValaMethod* _tmp454_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp478_ = FALSE;
	ValaMethod* _tmp479_;
	gboolean _tmp639_ = FALSE;
	ValaMethod* _tmp640_;
	ValaMethod* _tmp688_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp873_;
	ValaIterator* _tmp874_;
	ValaIterator* _tmp1247_;
	gboolean _tmp1257_ = FALSE;
	gboolean _tmp1258_ = FALSE;
	ValaMethod* _tmp1259_;
	gboolean _tmp1381_ = FALSE;
	ValaDelegate* _tmp1382_;
	gboolean _tmp1479_ = FALSE;
	ValaMethod* _tmp1480_;
	gboolean _tmp1496_;
	gboolean _tmp1497_;
	ValaDataType* _tmp1540_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1564_;
	ValaDataType* _tmp1565_;
	ValaDataType* _tmp1566_;
	gboolean _tmp1567_;
	gboolean _tmp1568_ = FALSE;
	ValaDataType* _tmp1569_;
	ValaCCodeFunctionCall* _tmp1598_;
	ValaCCodeFunctionCall* _tmp1599_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1614_;
	ValaCCodeFunctionCall* _tmp1615_;
	ValaCCodeFunctionCall* _tmp1630_;
	gboolean _tmp1645_;
	gboolean _tmp1646_;
	gboolean _tmp1670_;
	gboolean _tmp1671_;
	gboolean _tmp1706_ = FALSE;
	gboolean _tmp1707_ = FALSE;
	ValaMethod* _tmp1708_;
	gboolean _tmp1746_ = FALSE;
	gboolean _tmp1747_ = FALSE;
	gboolean _tmp1748_ = FALSE;
	gboolean _tmp1749_ = FALSE;
	gboolean _tmp1750_ = FALSE;
	ValaMethod* _tmp1751_;
	gboolean _tmp1768_ = FALSE;
	gboolean _tmp1769_ = FALSE;
	ValaMethod* _tmp1770_;
	ValaMethod* _tmp1789_;
	gboolean _tmp1906_ = FALSE;
	ValaCodeNode* _tmp1907_;
	ValaCodeNode* _tmp1908_;
	ValaList* _tmp1981_;
	ValaIterator* _tmp1982_;
	gboolean _tmp2132_ = FALSE;
	gboolean _tmp2133_ = FALSE;
	ValaMethod* _tmp2134_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			ValaCodeContext* _tmp60_;
			ValaCodeContext* _tmp61_;
			ValaProfile _tmp62_;
			ValaProfile _tmp63_;
			_tmp60_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_code_context_get_profile (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp64_;
				ValaExpression* _tmp65_;
				ValaExpression* _tmp66_;
				_tmp64_ = ma;
				_tmp65_ = vala_member_access_get_inner (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp59_ = _tmp66_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				_tmp67_ = ma;
				_tmp68_ = vala_member_access_get_inner (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_expression_get_value_type (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp58_ = _tmp71_ != NULL;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp72_;
				ValaExpression* _tmp73_;
				ValaExpression* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				ValaTypeSymbol* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaDataType* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				_tmp72_ = ma;
				_tmp73_ = vala_member_access_get_inner (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_expression_get_value_type (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_data_type_get_data_type (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp80_ = vala_data_type_get_data_type (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp57_ = _tmp78_ == _tmp81_;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaMemberAccess* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				_tmp82_ = ma;
				_tmp83_ = vala_member_access_get_member_name (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp56_ = g_strcmp0 (_tmp84_, "printf") == 0;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ValaCCodeFunctionCall* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				ValaCCodeIdentifier* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				_tmp85_ = ccall;
				_tmp86_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_ccode_identifier_new (_tmp87_);
				_tmp89_ = _tmp88_;
				vala_ccode_function_call_set_call (_tmp85_, (ValaCCodeExpression*) _tmp89_);
				_vala_ccode_node_unref0 (_tmp89_);
				_g_free0 (_tmp87_);
			} else {
				gboolean _tmp90_;
				gboolean _tmp91_;
				_tmp90_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp91_ = _tmp90_;
				if (_tmp91_) {
					ValaCCodeFunctionCall* _tmp92_;
					ValaMethod* _tmp93_;
					gchar* _tmp94_;
					gchar* _tmp95_;
					ValaCCodeIdentifier* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					_tmp92_ = ccall;
					_tmp93_ = m;
					_tmp94_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_ccode_identifier_new (_tmp95_);
					_tmp97_ = _tmp96_;
					vala_ccode_function_call_set_call (_tmp92_, (ValaCCodeExpression*) _tmp97_);
					_vala_ccode_node_unref0 (_tmp97_);
					_g_free0 (_tmp95_);
				}
			}
		}
	} else {
		ValaDataType* _tmp98_;
		_tmp98_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp99_;
			ValaSignalType* _tmp100_;
			gboolean _tmp101_ = FALSE;
			gboolean _tmp102_ = FALSE;
			ValaMemberAccess* _tmp103_;
			_tmp99_ = itype;
			_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp100_;
			_tmp103_ = ma;
			if (_tmp103_ != NULL) {
				ValaMemberAccess* _tmp104_;
				ValaExpression* _tmp105_;
				ValaExpression* _tmp106_;
				_tmp104_ = ma;
				_tmp105_ = vala_member_access_get_inner (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp107_;
				ValaSignal* _tmp108_;
				ValaSignal* _tmp109_;
				gboolean _tmp110_;
				gboolean _tmp111_;
				_tmp107_ = sig_type;
				_tmp108_ = vala_signal_type_get_signal_symbol (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = vala_signal_get_is_virtual (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp101_ = _tmp111_;
			} else {
				_tmp101_ = FALSE;
			}
			if (_tmp101_) {
				ValaSignalType* _tmp112_;
				ValaSignal* _tmp113_;
				ValaSignal* _tmp114_;
				ValaMethod* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				_tmp112_ = sig_type;
				_tmp113_ = vala_signal_type_get_signal_symbol (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = vala_signal_get_default_handler (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = _vala_code_node_ref0 (_tmp116_);
				_vala_code_node_unref0 (m);
				m = _tmp117_;
			} else {
				ValaExpression* _tmp118_;
				ValaExpression* _tmp119_;
				ValaCCodeExpression* _tmp120_;
				_tmp118_ = vala_method_call_get_call (expr);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp119_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp121_;
			_tmp121_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp121_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp122_;
				ValaObjectTypeSymbol* _tmp123_;
				ValaObjectTypeSymbol* _tmp124_;
				ValaClass* _tmp125_;
				ValaClass* _tmp126_;
				ValaCreationMethod* _tmp127_;
				ValaCreationMethod* _tmp128_;
				ValaMethod* _tmp129_;
				ValaMethod* _tmp130_;
				ValaCCodeFile* _tmp131_;
				gchar* real_name = NULL;
				ValaMethod* _tmp132_;
				gchar* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				const gchar* _tmp138_;
				ValaCCodeIdentifier* _tmp139_;
				ValaCCodeIdentifier* _tmp140_;
				ValaCCodeFunctionCall* _tmp141_;
				_tmp122_ = itype;
				_tmp123_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp124_ = _tmp123_;
				_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp125_;
				_tmp126_ = cl;
				_tmp127_ = vala_class_get_default_construction_method (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = _vala_code_node_ref0 ((ValaMethod*) _tmp128_);
				_vala_code_node_unref0 (m);
				m = _tmp129_;
				_tmp130_ = m;
				_tmp131_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp130_, _tmp131_);
				_tmp132_ = m;
				_tmp133_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp132_);
				real_name = _tmp133_;
				_tmp134_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp135_ = _tmp134_;
				if (_tmp135_) {
					ValaMethod* _tmp136_;
					gchar* _tmp137_;
					_tmp136_ = m;
					_tmp137_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp137_;
				}
				_tmp138_ = real_name;
				_tmp139_ = vala_ccode_identifier_new (_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp140_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp141_;
				_vala_ccode_node_unref0 (_tmp140_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp142_;
				_tmp142_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp143_;
					ValaTypeSymbol* _tmp144_;
					ValaTypeSymbol* _tmp145_;
					ValaStruct* _tmp146_;
					ValaStruct* _tmp147_;
					ValaCreationMethod* _tmp148_;
					ValaCreationMethod* _tmp149_;
					ValaMethod* _tmp150_;
					ValaMethod* _tmp151_;
					ValaCCodeFile* _tmp152_;
					ValaMethod* _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					ValaCCodeIdentifier* _tmp156_;
					ValaCCodeIdentifier* _tmp157_;
					ValaCCodeFunctionCall* _tmp158_;
					_tmp143_ = itype;
					_tmp144_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp145_ = _tmp144_;
					_tmp146_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp146_;
					_tmp147_ = st;
					_tmp148_ = vala_struct_get_default_construction_method (_tmp147_);
					_tmp149_ = _tmp148_;
					_tmp150_ = _vala_code_node_ref0 ((ValaMethod*) _tmp149_);
					_vala_code_node_unref0 (m);
					m = _tmp150_;
					_tmp151_ = m;
					_tmp152_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp151_, _tmp152_);
					_tmp153_ = m;
					_tmp154_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp153_);
					_tmp155_ = _tmp154_;
					_tmp156_ = vala_ccode_identifier_new (_tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp157_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp158_;
					_vala_ccode_node_unref0 (_tmp157_);
					_g_free0 (_tmp155_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp159_;
					_tmp159_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp160_;
						ValaDelegate* _tmp161_;
						ValaDelegate* _tmp162_;
						ValaDelegate* _tmp163_;
						_tmp160_ = itype;
						_tmp161_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp162_ = _tmp161_;
						_tmp163_ = _vala_code_node_ref0 (_tmp162_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp163_;
					}
				}
			}
		}
	}
	_tmp164_ = g_direct_hash;
	_tmp165_ = g_direct_equal;
	_tmp166_ = g_direct_equal;
	_tmp167_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp164_, _tmp165_, _tmp166_);
	in_arg_map = _tmp167_;
	_tmp168_ = in_arg_map;
	_tmp169_ = _vala_map_ref0 (_tmp168_);
	out_arg_map = _tmp169_;
	_tmp171_ = m;
	if (_tmp171_ != NULL) {
		ValaMethod* _tmp172_;
		gboolean _tmp173_;
		gboolean _tmp174_;
		_tmp172_ = m;
		_tmp173_ = vala_method_get_coroutine (_tmp172_);
		_tmp174_ = _tmp173_;
		_tmp170_ = _tmp174_;
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaMethod* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		ValaCCodeIdentifier* _tmp178_;
		ValaCCodeIdentifier* _tmp179_;
		ValaCCodeFunctionCall* _tmp180_;
		ValaMethod* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		ValaCCodeIdentifier* _tmp184_;
		ValaCCodeIdentifier* _tmp185_;
		ValaCCodeFunctionCall* _tmp186_;
		ValaMemberAccess* _tmp187_;
		ValaExpression* _tmp188_;
		ValaExpression* _tmp189_;
		gboolean _tmp238_ = FALSE;
		ValaMemberAccess* _tmp239_;
		const gchar* _tmp240_;
		const gchar* _tmp241_;
		_tmp175_ = m;
		_tmp176_ = vala_get_ccode_name ((ValaCodeNode*) _tmp175_);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_ccode_identifier_new (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp179_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp180_;
		_vala_ccode_node_unref0 (_tmp179_);
		_g_free0 (_tmp177_);
		_tmp181_ = m;
		_tmp182_ = vala_get_ccode_finish_name (_tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_ccode_identifier_new (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp185_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp186_;
		_vala_ccode_node_unref0 (_tmp185_);
		_g_free0 (_tmp183_);
		_tmp187_ = ma;
		_tmp188_ = vala_member_access_get_inner (_tmp187_);
		_tmp189_ = _tmp188_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp189_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp190_;
			ValaMethod* _tmp191_;
			ValaMethod* _tmp192_;
			ValaCCodeExpression* _tmp223_;
			vcast = NULL;
			_tmp190_ = m;
			_tmp191_ = vala_method_get_base_method (_tmp190_);
			_tmp192_ = _tmp191_;
			if (_tmp192_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp193_;
				ValaMethod* _tmp194_;
				ValaMethod* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaClass* _tmp198_;
				gchar* _tmp199_;
				gchar* _tmp200_;
				ValaCCodeIdentifier* _tmp201_;
				ValaCCodeIdentifier* _tmp202_;
				ValaCCodeFunctionCall* _tmp203_;
				ValaCCodeExpression* _tmp204_;
				ValaClass* _tmp205_;
				ValaClass* _tmp206_;
				gchar* _tmp207_;
				gchar* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				ValaCCodeIdentifier* _tmp211_;
				ValaCCodeIdentifier* _tmp212_;
				_tmp193_ = m;
				_tmp194_ = vala_method_get_base_method (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp195_);
				_tmp197_ = _tmp196_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, VALA_TYPE_CLASS, ValaClass);
				_tmp198_ = base_class;
				_tmp199_ = vala_get_ccode_class_type_function (_tmp198_);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_ccode_identifier_new (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp202_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp203_;
				_vala_ccode_node_unref0 (_tmp202_);
				_g_free0 (_tmp200_);
				_tmp204_ = vcast;
				_tmp205_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp206_ = _tmp205_;
				_tmp207_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp206_, NULL);
				_tmp208_ = _tmp207_;
				_tmp209_ = g_strdup_printf ("%s_parent_class", _tmp208_);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_ccode_identifier_new (_tmp210_);
				_tmp212_ = _tmp211_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp212_);
				_vala_ccode_node_unref0 (_tmp212_);
				_g_free0 (_tmp210_);
				_g_free0 (_tmp208_);
			} else {
				ValaMethod* _tmp213_;
				ValaMethod* _tmp214_;
				ValaMethod* _tmp215_;
				_tmp213_ = m;
				_tmp214_ = vala_method_get_base_interface_method (_tmp213_);
				_tmp215_ = _tmp214_;
				if (_tmp215_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp216_;
					ValaMethod* _tmp217_;
					ValaMethod* _tmp218_;
					ValaSymbol* _tmp219_;
					ValaSymbol* _tmp220_;
					ValaInterface* _tmp221_;
					ValaCCodeExpression* _tmp222_;
					_tmp216_ = m;
					_tmp217_ = vala_method_get_base_interface_method (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp218_);
					_tmp220_ = _tmp219_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp220_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp221_ = base_iface;
					_tmp222_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp221_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp222_;
				}
			}
			_tmp223_ = vcast;
			if (_tmp223_ != NULL) {
				ValaCCodeFunctionCall* _tmp224_;
				ValaCCodeExpression* _tmp225_;
				ValaMethod* _tmp226_;
				gchar* _tmp227_;
				gchar* _tmp228_;
				ValaCCodeMemberAccess* _tmp229_;
				ValaCCodeMemberAccess* _tmp230_;
				ValaCCodeFunctionCall* _tmp231_;
				ValaCCodeExpression* _tmp232_;
				ValaMethod* _tmp233_;
				gchar* _tmp234_;
				gchar* _tmp235_;
				ValaCCodeMemberAccess* _tmp236_;
				ValaCCodeMemberAccess* _tmp237_;
				_tmp224_ = async_call;
				_tmp225_ = vcast;
				_tmp226_ = m;
				_tmp227_ = vala_get_ccode_vfunc_name (_tmp226_);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_ccode_member_access_new_pointer (_tmp225_, _tmp228_);
				_tmp230_ = _tmp229_;
				vala_ccode_function_call_set_call (_tmp224_, (ValaCCodeExpression*) _tmp230_);
				_vala_ccode_node_unref0 (_tmp230_);
				_g_free0 (_tmp228_);
				_tmp231_ = finish_call;
				_tmp232_ = vcast;
				_tmp233_ = m;
				_tmp234_ = vala_get_ccode_finish_vfunc_name (_tmp233_);
				_tmp235_ = _tmp234_;
				_tmp236_ = vala_ccode_member_access_new_pointer (_tmp232_, _tmp235_);
				_tmp237_ = _tmp236_;
				vala_ccode_function_call_set_call (_tmp231_, (ValaCCodeExpression*) _tmp237_);
				_vala_ccode_node_unref0 (_tmp237_);
				_g_free0 (_tmp235_);
			}
			_vala_ccode_node_unref0 (vcast);
		}
		_tmp239_ = ma;
		_tmp240_ = vala_member_access_get_member_name (_tmp239_);
		_tmp241_ = _tmp240_;
		if (g_strcmp0 (_tmp241_, "begin") == 0) {
			ValaMemberAccess* _tmp242_;
			ValaExpression* _tmp243_;
			ValaExpression* _tmp244_;
			ValaSymbol* _tmp245_;
			ValaSymbol* _tmp246_;
			ValaMemberAccess* _tmp247_;
			ValaSymbol* _tmp248_;
			ValaSymbol* _tmp249_;
			_tmp242_ = ma;
			_tmp243_ = vala_member_access_get_inner (_tmp242_);
			_tmp244_ = _tmp243_;
			_tmp245_ = vala_expression_get_symbol_reference (_tmp244_);
			_tmp246_ = _tmp245_;
			_tmp247_ = ma;
			_tmp248_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp247_);
			_tmp249_ = _tmp248_;
			_tmp238_ = _tmp246_ == _tmp249_;
		} else {
			_tmp238_ = FALSE;
		}
		if (_tmp238_) {
			ValaCCodeFunctionCall* _tmp250_;
			ValaCCodeFunctionCall* _tmp251_;
			ValaMethod* _tmp252_;
			ValaList* _tmp253_;
			_tmp250_ = async_call;
			_tmp251_ = _vala_ccode_node_ref0 (_tmp250_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp251_;
			_tmp252_ = m;
			_tmp253_ = vala_method_get_async_begin_parameters (_tmp252_);
			_vala_iterable_unref0 (params);
			params = _tmp253_;
		} else {
			gboolean _tmp254_ = FALSE;
			ValaMemberAccess* _tmp255_;
			const gchar* _tmp256_;
			const gchar* _tmp257_;
			_tmp255_ = ma;
			_tmp256_ = vala_member_access_get_member_name (_tmp255_);
			_tmp257_ = _tmp256_;
			if (g_strcmp0 (_tmp257_, "end") == 0) {
				ValaMemberAccess* _tmp258_;
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaSymbol* _tmp261_;
				ValaSymbol* _tmp262_;
				ValaMemberAccess* _tmp263_;
				ValaSymbol* _tmp264_;
				ValaSymbol* _tmp265_;
				_tmp258_ = ma;
				_tmp259_ = vala_member_access_get_inner (_tmp258_);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_symbol_reference (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = ma;
				_tmp264_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp263_);
				_tmp265_ = _tmp264_;
				_tmp254_ = _tmp262_ == _tmp265_;
			} else {
				_tmp254_ = FALSE;
			}
			if (_tmp254_) {
				ValaCCodeFunctionCall* _tmp266_;
				ValaCCodeFunctionCall* _tmp267_;
				ValaMethod* _tmp268_;
				ValaList* _tmp269_;
				_tmp266_ = finish_call;
				_tmp267_ = _vala_ccode_node_ref0 (_tmp266_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp267_;
				_tmp268_ = m;
				_tmp269_ = vala_method_get_async_end_parameters (_tmp268_);
				_vala_iterable_unref0 (params);
				params = _tmp269_;
			} else {
				gboolean _tmp270_;
				gboolean _tmp271_;
				_tmp270_ = vala_method_call_get_is_yield_expression (expr);
				_tmp271_ = _tmp270_;
				if (!_tmp271_) {
					ValaCCodeFunctionCall* _tmp272_;
					ValaCCodeFunctionCall* _tmp273_;
					ValaMethod* _tmp274_;
					ValaList* _tmp275_;
					_tmp272_ = async_call;
					_tmp273_ = _vala_ccode_node_ref0 (_tmp272_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp273_;
					_tmp274_ = m;
					_tmp275_ = vala_method_get_async_begin_parameters (_tmp274_);
					_vala_iterable_unref0 (params);
					params = _tmp275_;
				} else {
					ValaCCodeFunctionCall* _tmp276_;
					ValaCCodeFunctionCall* _tmp277_;
					GHashFunc _tmp278_;
					GEqualFunc _tmp279_;
					GEqualFunc _tmp280_;
					ValaHashMap* _tmp281_;
					ValaHashMap* _tmp282_;
					ValaMethod* _tmp283_;
					ValaCCodeIdentifier* _tmp284_;
					ValaCCodeIdentifier* _tmp285_;
					ValaCCodeMemberAccess* _tmp286_;
					ValaCCodeMemberAccess* _tmp287_;
					_tmp276_ = finish_call;
					_tmp277_ = _vala_ccode_node_ref0 (_tmp276_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp277_;
					_tmp278_ = g_direct_hash;
					_tmp279_ = g_direct_equal;
					_tmp280_ = g_direct_equal;
					_tmp281_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp278_, _tmp279_, _tmp280_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp281_;
					_tmp282_ = out_arg_map;
					_tmp283_ = m;
					_tmp284_ = vala_ccode_identifier_new ("_data_");
					_tmp285_ = _tmp284_;
					_tmp286_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp285_, "_res_");
					_tmp287_ = _tmp286_;
					vala_map_set ((ValaMap*) _tmp282_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp283_), FALSE)), (ValaCCodeExpression*) _tmp287_);
					_vala_ccode_node_unref0 (_tmp287_);
					_vala_ccode_node_unref0 (_tmp285_);
				}
			}
		}
	}
	_tmp289_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp289_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp290_;
		ValaSymbol* _tmp291_;
		ValaSymbol* _tmp292_;
		_tmp290_ = m;
		_tmp291_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp290_);
		_tmp292_ = _tmp291_;
		_tmp288_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp292_, VALA_TYPE_CLASS);
	} else {
		_tmp288_ = FALSE;
	}
	if (_tmp288_) {
		ValaCodeContext* _tmp293_;
		ValaCodeContext* _tmp294_;
		ValaProfile _tmp295_;
		ValaProfile _tmp296_;
		ValaClass* _tmp308_;
		ValaClass* _tmp309_;
		gboolean _tmp310_;
		gboolean _tmp311_;
		_tmp293_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp294_ = _tmp293_;
		_tmp295_ = vala_code_context_get_profile (_tmp294_);
		_tmp296_ = _tmp295_;
		if (_tmp296_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp297_;
			ValaSymbol* _tmp298_;
			ValaSymbol* _tmp299_;
			gboolean _tmp300_;
			gboolean _tmp301_;
			_tmp297_ = m;
			_tmp298_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp297_);
			_tmp299_ = _tmp298_;
			_tmp300_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp299_, VALA_TYPE_CLASS, ValaClass));
			_tmp301_ = _tmp300_;
			if (!_tmp301_) {
				ValaCCodeFunctionCall* _tmp302_;
				ValaCCodeExpression* _tmp303_;
				ValaCCodeExpression* _tmp304_;
				_tmp302_ = ccall;
				_tmp303_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp304_ = _tmp303_;
				vala_ccode_function_call_add_argument (_tmp302_, _tmp304_);
				_vala_ccode_node_unref0 (_tmp304_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp305_;
			ValaCCodeExpression* _tmp306_;
			ValaCCodeExpression* _tmp307_;
			_tmp305_ = ccall;
			_tmp306_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp307_ = _tmp306_;
			vala_ccode_function_call_add_argument (_tmp305_, _tmp307_);
			_vala_ccode_node_unref0 (_tmp307_);
		}
		_tmp308_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp309_ = _tmp308_;
		_tmp310_ = vala_class_get_is_compact (_tmp309_);
		_tmp311_ = _tmp310_;
		if (!_tmp311_) {
			ValaClass* _tmp312_;
			ValaClass* _tmp313_;
			ValaMethod* _tmp314_;
			ValaSymbol* _tmp315_;
			ValaSymbol* _tmp316_;
			_tmp312_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp313_ = _tmp312_;
			_tmp314_ = m;
			_tmp315_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp314_);
			_tmp316_ = _tmp315_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp313_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp316_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp317_;
					ValaClass* _tmp318_;
					ValaList* _tmp319_;
					gint _base_type_size = 0;
					ValaList* _tmp320_;
					gint _tmp321_;
					gint _tmp322_;
					gint _base_type_index = 0;
					_tmp317_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp318_ = _tmp317_;
					_tmp319_ = vala_class_get_base_types (_tmp318_);
					_base_type_list = _tmp319_;
					_tmp320_ = _base_type_list;
					_tmp321_ = vala_collection_get_size ((ValaCollection*) _tmp320_);
					_tmp322_ = _tmp321_;
					_base_type_size = _tmp322_;
					_base_type_index = -1;
					while (TRUE) {
						ValaDataType* base_type = NULL;
						ValaList* _tmp323_;
						gpointer _tmp324_;
						ValaDataType* _tmp325_;
						ValaTypeSymbol* _tmp326_;
						ValaTypeSymbol* _tmp327_;
						_base_type_index = _base_type_index + 1;
						if (!(_base_type_index < _base_type_size)) {
							break;
						}
						_tmp323_ = _base_type_list;
						_tmp324_ = vala_list_get (_tmp323_, _base_type_index);
						base_type = (ValaDataType*) _tmp324_;
						_tmp325_ = base_type;
						_tmp326_ = vala_data_type_get_data_type (_tmp325_);
						_tmp327_ = _tmp326_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp327_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp328_;
							gchar* _tmp329_;
							gchar* _tmp330_;
							gboolean _tmp331_;
							ValaHashMap* _tmp336_;
							ValaDataType* _tmp337_;
							ValaList* _tmp338_;
							ValaList* _tmp339_;
							ValaList* _tmp340_;
							type_parameters = NULL;
							_tmp328_ = m;
							_tmp329_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp328_);
							_tmp330_ = _tmp329_;
							_tmp331_ = g_strcmp0 (_tmp330_, "g_object_new") == 0;
							_g_free0 (_tmp330_);
							if (_tmp331_) {
								ValaDataType* _tmp332_;
								ValaTypeSymbol* _tmp333_;
								ValaTypeSymbol* _tmp334_;
								ValaList* _tmp335_;
								_tmp332_ = base_type;
								_tmp333_ = vala_data_type_get_data_type (_tmp332_);
								_tmp334_ = _tmp333_;
								_tmp335_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp334_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp335_;
							}
							_tmp336_ = in_arg_map;
							_tmp337_ = base_type;
							_tmp338_ = vala_data_type_get_type_arguments (_tmp337_);
							_tmp339_ = _tmp338_;
							_tmp340_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp336_, _tmp339_, (ValaCodeNode*) expr, TRUE, _tmp340_);
							_vala_iterable_unref0 (_tmp339_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp341_;
				ValaSymbol* _tmp342_;
				ValaSymbol* _tmp343_;
				ValaClass* _tmp344_;
				type_param_index = 0;
				_tmp341_ = m;
				_tmp342_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp341_);
				_tmp343_ = _tmp342_;
				_tmp344_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp343_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp344_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp345_;
					ValaList* _tmp346_;
					gint _type_param_size = 0;
					ValaList* _tmp347_;
					gint _tmp348_;
					gint _tmp349_;
					gint _type_param_index = 0;
					_tmp345_ = cl;
					_tmp346_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp345_);
					_type_param_list = _tmp346_;
					_tmp347_ = _type_param_list;
					_tmp348_ = vala_collection_get_size ((ValaCollection*) _tmp347_);
					_tmp349_ = _tmp348_;
					_type_param_size = _tmp349_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp350_;
						gpointer _tmp351_;
						ValaHashMap* _tmp352_;
						ValaTypeParameter* _tmp353_;
						const gchar* _tmp354_;
						const gchar* _tmp355_;
						gchar* _tmp356_;
						gchar* _tmp357_;
						gchar* _tmp358_;
						gchar* _tmp359_;
						ValaCCodeIdentifier* _tmp360_;
						ValaCCodeIdentifier* _tmp361_;
						ValaHashMap* _tmp362_;
						ValaTypeParameter* _tmp363_;
						const gchar* _tmp364_;
						const gchar* _tmp365_;
						gchar* _tmp366_;
						gchar* _tmp367_;
						gchar* _tmp368_;
						gchar* _tmp369_;
						ValaCCodeIdentifier* _tmp370_;
						ValaCCodeIdentifier* _tmp371_;
						ValaHashMap* _tmp372_;
						ValaTypeParameter* _tmp373_;
						const gchar* _tmp374_;
						const gchar* _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						gchar* _tmp378_;
						gchar* _tmp379_;
						ValaCCodeIdentifier* _tmp380_;
						ValaCCodeIdentifier* _tmp381_;
						gint _tmp382_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp350_ = _type_param_list;
						_tmp351_ = vala_list_get (_tmp350_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp351_;
						_tmp352_ = in_arg_map;
						_tmp353_ = type_param;
						_tmp354_ = vala_symbol_get_name ((ValaSymbol*) _tmp353_);
						_tmp355_ = _tmp354_;
						_tmp356_ = g_utf8_strdown (_tmp355_, (gssize) -1);
						_tmp357_ = _tmp356_;
						_tmp358_ = g_strdup_printf ("%s_type", _tmp357_);
						_tmp359_ = _tmp358_;
						_tmp360_ = vala_ccode_identifier_new (_tmp359_);
						_tmp361_ = _tmp360_;
						vala_map_set ((ValaMap*) _tmp352_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp361_);
						_vala_ccode_node_unref0 (_tmp361_);
						_g_free0 (_tmp359_);
						_g_free0 (_tmp357_);
						_tmp362_ = in_arg_map;
						_tmp363_ = type_param;
						_tmp364_ = vala_symbol_get_name ((ValaSymbol*) _tmp363_);
						_tmp365_ = _tmp364_;
						_tmp366_ = g_utf8_strdown (_tmp365_, (gssize) -1);
						_tmp367_ = _tmp366_;
						_tmp368_ = g_strdup_printf ("%s_dup_func", _tmp367_);
						_tmp369_ = _tmp368_;
						_tmp370_ = vala_ccode_identifier_new (_tmp369_);
						_tmp371_ = _tmp370_;
						vala_map_set ((ValaMap*) _tmp362_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp371_);
						_vala_ccode_node_unref0 (_tmp371_);
						_g_free0 (_tmp369_);
						_g_free0 (_tmp367_);
						_tmp372_ = in_arg_map;
						_tmp373_ = type_param;
						_tmp374_ = vala_symbol_get_name ((ValaSymbol*) _tmp373_);
						_tmp375_ = _tmp374_;
						_tmp376_ = g_utf8_strdown (_tmp375_, (gssize) -1);
						_tmp377_ = _tmp376_;
						_tmp378_ = g_strdup_printf ("%s_destroy_func", _tmp377_);
						_tmp379_ = _tmp378_;
						_tmp380_ = vala_ccode_identifier_new (_tmp379_);
						_tmp381_ = _tmp380_;
						vala_map_set ((ValaMap*) _tmp372_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp381_);
						_vala_ccode_node_unref0 (_tmp381_);
						_g_free0 (_tmp379_);
						_g_free0 (_tmp377_);
						_tmp382_ = type_param_index;
						type_param_index = _tmp382_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp383_;
			ValaClass* _tmp384_;
			ValaClass* _tmp385_;
			ValaClass* _tmp386_;
			ValaClass* _tmp387_;
			_tmp383_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp384_ = _tmp383_;
			_tmp385_ = vala_class_get_base_class (_tmp384_);
			_tmp386_ = _tmp385_;
			_tmp387_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp386_ == _tmp387_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp388_;
				ValaClass* _tmp389_;
				gchar* _tmp390_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp391_;
				ValaCCodeDeclaration* _tmp392_;
				ValaCCodeDeclaration* _tmp393_;
				const gchar* _tmp394_;
				const gchar* _tmp395_;
				const gchar* _tmp396_;
				const gchar* _tmp397_;
				gchar* _tmp398_;
				gchar* _tmp399_;
				ValaCCodeConstant* _tmp400_;
				ValaCCodeConstant* _tmp401_;
				ValaCCodeVariableDeclarator* _tmp402_;
				ValaCCodeVariableDeclarator* _tmp403_;
				ValaCCodeFunction* _tmp404_;
				ValaCCodeFunction* _tmp405_;
				ValaCCodeDeclaration* _tmp406_;
				ValaCCodeFunctionCall* _tmp407_;
				ValaCCodeIdentifier* _tmp408_;
				ValaCCodeIdentifier* _tmp409_;
				ValaCCodeUnaryExpression* _tmp410_;
				ValaCCodeUnaryExpression* _tmp411_;
				ValaCCodeCastExpression* _tmp412_;
				ValaCCodeCastExpression* _tmp413_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp414_;
				ValaCCodeIdentifier* _tmp415_;
				ValaCCodeFunctionCall* _tmp416_;
				ValaCCodeFunctionCall* _tmp417_;
				ValaCCodeFunctionCall* _tmp418_;
				ValaClass* _tmp419_;
				ValaClass* _tmp420_;
				gchar* _tmp421_;
				gchar* _tmp422_;
				ValaCCodeIdentifier* _tmp423_;
				ValaCCodeIdentifier* _tmp424_;
				ValaCCodeFunctionCall* _tmp425_;
				ValaCCodeFunctionCall* _tmp426_;
				_tmp388_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp389_ = _tmp388_;
				_tmp390_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp389_, NULL);
				class_prefix = _tmp390_;
				_tmp391_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp391_;
				_tmp392_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp392_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp393_ = funcs;
				_tmp394_ = class_prefix;
				_tmp395_ = class_prefix;
				_tmp396_ = class_prefix;
				_tmp397_ = class_prefix;
				_tmp398_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp394_, _tmp395_, _tmp396_, _tmp397_);
				_tmp399_ = _tmp398_;
				_tmp400_ = vala_ccode_constant_new (_tmp399_);
				_tmp401_ = _tmp400_;
				_tmp402_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp401_, NULL);
				_tmp403_ = _tmp402_;
				vala_ccode_declaration_add_declarator (_tmp393_, (ValaCCodeDeclarator*) _tmp403_);
				_vala_ccode_node_unref0 (_tmp403_);
				_vala_ccode_node_unref0 (_tmp401_);
				_g_free0 (_tmp399_);
				_tmp404_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp405_ = _tmp404_;
				_tmp406_ = funcs;
				vala_ccode_function_add_statement (_tmp405_, (ValaCCodeNode*) _tmp406_);
				_tmp407_ = ccall;
				_tmp408_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp409_ = _tmp408_;
				_tmp410_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp409_);
				_tmp411_ = _tmp410_;
				_tmp412_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp411_, "GSourceFuncs *");
				_tmp413_ = _tmp412_;
				vala_ccode_function_call_add_argument (_tmp407_, (ValaCCodeExpression*) _tmp413_);
				_vala_ccode_node_unref0 (_tmp413_);
				_vala_ccode_node_unref0 (_tmp411_);
				_vala_ccode_node_unref0 (_tmp409_);
				_tmp414_ = vala_ccode_identifier_new ("sizeof");
				_tmp415_ = _tmp414_;
				_tmp416_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp415_);
				_tmp417_ = _tmp416_;
				_vala_ccode_node_unref0 (_tmp415_);
				csizeof = _tmp417_;
				_tmp418_ = csizeof;
				_tmp419_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp420_ = _tmp419_;
				_tmp421_ = vala_get_ccode_name ((ValaCodeNode*) _tmp420_);
				_tmp422_ = _tmp421_;
				_tmp423_ = vala_ccode_identifier_new (_tmp422_);
				_tmp424_ = _tmp423_;
				vala_ccode_function_call_add_argument (_tmp418_, (ValaCCodeExpression*) _tmp424_);
				_vala_ccode_node_unref0 (_tmp424_);
				_g_free0 (_tmp422_);
				_tmp425_ = ccall;
				_tmp426_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp425_, (ValaCCodeExpression*) _tmp426_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp427_ = FALSE;
		ValaMethod* _tmp428_;
		_tmp428_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp428_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp429_;
			ValaSymbol* _tmp430_;
			ValaSymbol* _tmp431_;
			_tmp429_ = m;
			_tmp430_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp429_);
			_tmp431_ = _tmp430_;
			_tmp427_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp431_, VALA_TYPE_STRUCT);
		} else {
			_tmp427_ = FALSE;
		}
		if (_tmp427_) {
			ValaCCodeFunctionCall* _tmp432_;
			ValaCCodeExpression* _tmp433_;
			ValaCCodeExpression* _tmp434_;
			_tmp432_ = ccall;
			_tmp433_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp434_ = _tmp433_;
			vala_ccode_function_call_add_argument (_tmp432_, _tmp434_);
			_vala_ccode_node_unref0 (_tmp434_);
		} else {
			gboolean _tmp435_ = FALSE;
			gboolean _tmp436_ = FALSE;
			gboolean _tmp437_ = FALSE;
			gboolean _tmp438_ = FALSE;
			ValaMethod* _tmp439_;
			_tmp439_ = m;
			if (_tmp439_ != NULL) {
				ValaMethod* _tmp440_;
				_tmp440_ = m;
				_tmp438_ = vala_method_has_type_parameters (_tmp440_);
			} else {
				_tmp438_ = FALSE;
			}
			if (_tmp438_) {
				ValaMethod* _tmp441_;
				_tmp441_ = m;
				_tmp437_ = !vala_get_ccode_has_generic_type_parameter (_tmp441_);
			} else {
				_tmp437_ = FALSE;
			}
			if (_tmp437_) {
				ValaMethod* _tmp442_;
				_tmp442_ = m;
				_tmp436_ = !vala_get_ccode_simple_generics (_tmp442_);
			} else {
				_tmp436_ = FALSE;
			}
			if (_tmp436_) {
				gboolean _tmp443_ = FALSE;
				ValaCCodeFunctionCall* _tmp444_;
				ValaCCodeFunctionCall* _tmp445_;
				_tmp444_ = ccall;
				_tmp445_ = finish_call;
				if (_tmp444_ != _tmp445_) {
					_tmp443_ = TRUE;
				} else {
					gboolean _tmp446_;
					gboolean _tmp447_;
					_tmp446_ = vala_method_call_get_is_yield_expression (expr);
					_tmp447_ = _tmp446_;
					_tmp443_ = _tmp447_;
				}
				_tmp435_ = _tmp443_;
			} else {
				_tmp435_ = FALSE;
			}
			if (_tmp435_) {
				ValaHashMap* _tmp448_;
				ValaMemberAccess* _tmp449_;
				ValaList* _tmp450_;
				ValaList* _tmp451_;
				_tmp448_ = in_arg_map;
				_tmp449_ = ma;
				_tmp450_ = vala_member_access_get_type_arguments (_tmp449_);
				_tmp451_ = _tmp450_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp448_, _tmp451_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp451_);
			}
		}
	}
	_tmp452_ = ccall;
	_tmp453_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp452_);
	ccall_expr = _tmp453_;
	_tmp454_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp454_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp455_;
		ValaExpression* _tmp456_;
		ValaExpression* _tmp457_;
		ValaDataType* _tmp458_;
		ValaDataType* _tmp459_;
		ValaArrayType* _tmp460_;
		ValaHashMap* _tmp461_;
		ValaArrayType* _tmp462_;
		ValaDataType* _tmp463_;
		ValaDataType* _tmp464_;
		gchar* _tmp465_;
		gchar* _tmp466_;
		ValaCCodeIdentifier* _tmp467_;
		ValaCCodeIdentifier* _tmp468_;
		_tmp455_ = ma;
		_tmp456_ = vala_member_access_get_inner (_tmp455_);
		_tmp457_ = _tmp456_;
		_tmp458_ = vala_expression_get_value_type (_tmp457_);
		_tmp459_ = _tmp458_;
		_tmp460_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp459_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp460_;
		_tmp461_ = in_arg_map;
		_tmp462_ = array_type;
		_tmp463_ = vala_array_type_get_element_type (_tmp462_);
		_tmp464_ = _tmp463_;
		_tmp465_ = vala_get_ccode_name ((ValaCodeNode*) _tmp464_);
		_tmp466_ = _tmp465_;
		_tmp467_ = vala_ccode_identifier_new (_tmp466_);
		_tmp468_ = _tmp467_;
		vala_map_set ((ValaMap*) _tmp461_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp468_);
		_vala_ccode_node_unref0 (_tmp468_);
		_g_free0 (_tmp466_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp469_;
		_tmp469_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp469_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp470_;
			_tmp470_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp470_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp471_;
				ValaExpression* _tmp472_;
				ValaExpression* _tmp473_;
				ValaTargetValue* _tmp474_;
				ValaTargetValue* _tmp475_;
				ValaTargetValue* _tmp476_;
				ValaTargetValue* _tmp477_;
				_tmp471_ = ma;
				_tmp472_ = vala_member_access_get_inner (_tmp471_);
				_tmp473_ = _tmp472_;
				_tmp474_ = vala_expression_get_target_value (_tmp473_);
				_tmp475_ = _tmp474_;
				_tmp476_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp475_, (ValaCodeNode*) expr);
				_tmp477_ = _tmp476_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp477_);
				_vala_target_value_unref0 (_tmp477_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp479_ = m;
	if (_tmp479_ != NULL) {
		ValaMethod* _tmp480_;
		gboolean _tmp481_;
		gboolean _tmp482_;
		_tmp480_ = m;
		_tmp481_ = vala_method_get_is_async_callback (_tmp480_);
		_tmp482_ = _tmp481_;
		_tmp478_ = _tmp482_;
	} else {
		_tmp478_ = FALSE;
	}
	if (_tmp478_) {
		ValaMethod* _tmp483_;
		ValaMethod* _tmp484_;
		gboolean _tmp485_;
		gboolean _tmp486_;
		ValaHashMap* _tmp500_;
		ValaMethod* _tmp501_;
		ValaCCodeExpression* _tmp502_;
		ValaHashMap* _tmp503_;
		ValaMethod* _tmp504_;
		ValaCCodeExpression* _tmp505_;
		_tmp483_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp484_ = _tmp483_;
		_tmp485_ = vala_method_get_closure (_tmp484_);
		_tmp486_ = _tmp485_;
		if (_tmp486_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp487_;
			ValaSymbol* _tmp488_;
			ValaSymbol* _tmp489_;
			ValaBlock* _tmp490_;
			ValaBlock* _tmp491_;
			ValaBlock* _tmp492_;
			ValaBlock* _tmp493_;
			gchar* _tmp494_;
			gchar* _tmp495_;
			ValaCCodeExpression* _tmp496_;
			ValaCCodeExpression* _tmp497_;
			ValaCCodeMemberAccess* _tmp498_;
			_tmp487_ = m;
			_tmp488_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp487_);
			_tmp489_ = _tmp488_;
			_tmp490_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp489_, VALA_TYPE_METHOD, ValaMethod));
			_tmp491_ = _tmp490_;
			_tmp492_ = _vala_code_node_ref0 (_tmp491_);
			block = _tmp492_;
			_tmp493_ = block;
			_tmp494_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp493_));
			_tmp495_ = _tmp494_;
			_tmp496_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp495_);
			_tmp497_ = _tmp496_;
			_tmp498_ = vala_ccode_member_access_new_pointer (_tmp497_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp498_;
			_vala_ccode_node_unref0 (_tmp497_);
			_g_free0 (_tmp495_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp499_;
			_tmp499_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp499_;
		}
		_tmp500_ = in_arg_map;
		_tmp501_ = m;
		_tmp502_ = instance;
		vala_map_set ((ValaMap*) _tmp500_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp501_), FALSE)), _tmp502_);
		_tmp503_ = out_arg_map;
		_tmp504_ = m;
		_tmp505_ = instance;
		vala_map_set ((ValaMap*) _tmp503_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp504_), FALSE)), _tmp505_);
	} else {
		gboolean _tmp506_ = FALSE;
		gboolean _tmp507_ = FALSE;
		ValaMethod* _tmp508_;
		_tmp508_ = m;
		if (_tmp508_ != NULL) {
			ValaMethod* _tmp509_;
			ValaMemberBinding _tmp510_;
			ValaMemberBinding _tmp511_;
			_tmp509_ = m;
			_tmp510_ = vala_method_get_binding (_tmp509_);
			_tmp511_ = _tmp510_;
			_tmp507_ = _tmp511_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp507_ = FALSE;
		}
		if (_tmp507_) {
			ValaMethod* _tmp512_;
			_tmp512_ = m;
			_tmp506_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp512_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp506_ = FALSE;
		}
		if (_tmp506_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp513_;
			ValaExpression* _tmp514_;
			ValaExpression* _tmp515_;
			ValaTargetValue* _tmp516_;
			ValaTargetValue* _tmp517_;
			ValaTargetValue* _tmp518_;
			gboolean _tmp519_ = FALSE;
			gboolean _tmp520_ = FALSE;
			ValaMemberAccess* _tmp521_;
			const gchar* _tmp522_;
			const gchar* _tmp523_;
			ValaTargetValue* _tmp545_;
			ValaCCodeExpression* _tmp546_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp547_;
			ValaSymbol* _tmp548_;
			ValaSymbol* _tmp549_;
			ValaStruct* _tmp550_;
			gboolean _tmp551_ = FALSE;
			ValaStruct* _tmp552_;
			ValaMethod* _tmp561_;
			gboolean _tmp562_;
			gboolean _tmp563_;
			_tmp513_ = ma;
			_tmp514_ = vala_member_access_get_inner (_tmp513_);
			_tmp515_ = _tmp514_;
			_tmp516_ = vala_expression_get_target_value (_tmp515_);
			_tmp517_ = _tmp516_;
			_tmp518_ = _vala_target_value_ref0 (_tmp517_);
			instance_value = _tmp518_;
			_tmp521_ = ma;
			_tmp522_ = vala_member_access_get_member_name (_tmp521_);
			_tmp523_ = _tmp522_;
			if (g_strcmp0 (_tmp523_, "begin") == 0) {
				_tmp520_ = TRUE;
			} else {
				ValaMemberAccess* _tmp524_;
				const gchar* _tmp525_;
				const gchar* _tmp526_;
				_tmp524_ = ma;
				_tmp525_ = vala_member_access_get_member_name (_tmp524_);
				_tmp526_ = _tmp525_;
				_tmp520_ = g_strcmp0 (_tmp526_, "end") == 0;
			}
			if (_tmp520_) {
				ValaMemberAccess* _tmp527_;
				ValaExpression* _tmp528_;
				ValaExpression* _tmp529_;
				ValaSymbol* _tmp530_;
				ValaSymbol* _tmp531_;
				ValaMemberAccess* _tmp532_;
				ValaSymbol* _tmp533_;
				ValaSymbol* _tmp534_;
				_tmp527_ = ma;
				_tmp528_ = vala_member_access_get_inner (_tmp527_);
				_tmp529_ = _tmp528_;
				_tmp530_ = vala_expression_get_symbol_reference (_tmp529_);
				_tmp531_ = _tmp530_;
				_tmp532_ = ma;
				_tmp533_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp532_);
				_tmp534_ = _tmp533_;
				_tmp519_ = _tmp531_ == _tmp534_;
			} else {
				_tmp519_ = FALSE;
			}
			if (_tmp519_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp535_;
				ValaExpression* _tmp536_;
				ValaExpression* _tmp537_;
				ValaMemberAccess* _tmp538_;
				ValaMemberAccess* _tmp539_;
				ValaExpression* _tmp540_;
				ValaExpression* _tmp541_;
				ValaTargetValue* _tmp542_;
				ValaTargetValue* _tmp543_;
				ValaTargetValue* _tmp544_;
				_tmp535_ = ma;
				_tmp536_ = vala_member_access_get_inner (_tmp535_);
				_tmp537_ = _tmp536_;
				_tmp538_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp537_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp538_;
				_tmp539_ = inner_ma;
				_tmp540_ = vala_member_access_get_inner (_tmp539_);
				_tmp541_ = _tmp540_;
				_tmp542_ = vala_expression_get_target_value (_tmp541_);
				_tmp543_ = _tmp542_;
				_tmp544_ = _vala_target_value_ref0 (_tmp543_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp544_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp545_ = instance_value;
			_tmp546_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp545_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp546_;
			_tmp547_ = m;
			_tmp548_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp547_);
			_tmp549_ = _tmp548_;
			_tmp550_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp549_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp549_) : NULL);
			st = _tmp550_;
			_tmp552_ = st;
			if (_tmp552_ != NULL) {
				ValaStruct* _tmp553_;
				_tmp553_ = st;
				_tmp551_ = !vala_struct_is_simple_type (_tmp553_);
			} else {
				_tmp551_ = FALSE;
			}
			if (_tmp551_) {
				ValaTargetValue* _tmp554_;
				ValaTargetValue* _tmp557_;
				ValaCCodeExpression* _tmp558_;
				ValaCCodeExpression* _tmp559_;
				ValaCCodeUnaryExpression* _tmp560_;
				_tmp554_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp554_)) {
					ValaTargetValue* _tmp555_;
					ValaTargetValue* _tmp556_;
					_tmp555_ = instance_value;
					_tmp556_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp555_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp556_;
				}
				_tmp557_ = instance_value;
				_tmp558_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp557_);
				_tmp559_ = _tmp558_;
				_tmp560_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp559_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp560_;
				_vala_ccode_node_unref0 (_tmp559_);
			}
			_tmp561_ = m;
			_tmp562_ = vala_method_get_coroutine (_tmp561_);
			_tmp563_ = _tmp562_;
			if (!_tmp563_) {
				ValaHashMap* _tmp564_;
				ValaMethod* _tmp565_;
				ValaCCodeExpression* _tmp566_;
				_tmp564_ = in_arg_map;
				_tmp565_ = m;
				_tmp566_ = instance;
				vala_map_set ((ValaMap*) _tmp564_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp565_), FALSE)), _tmp566_);
			} else {
				gboolean _tmp567_;
				gboolean _tmp568_;
				_tmp567_ = vala_method_call_get_is_yield_expression (expr);
				_tmp568_ = _tmp567_;
				if (_tmp568_) {
					ValaHashMap* _tmp569_;
					ValaMethod* _tmp570_;
					ValaCCodeExpression* _tmp571_;
					ValaMethod* _tmp572_;
					_tmp569_ = in_arg_map;
					_tmp570_ = m;
					_tmp571_ = instance;
					vala_map_set ((ValaMap*) _tmp569_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp570_), FALSE)), _tmp571_);
					_tmp572_ = m;
					if (vala_get_ccode_finish_instance (_tmp572_)) {
						ValaHashMap* _tmp573_;
						ValaMethod* _tmp574_;
						ValaCCodeExpression* _tmp575_;
						_tmp573_ = out_arg_map;
						_tmp574_ = m;
						_tmp575_ = instance;
						vala_map_set ((ValaMap*) _tmp573_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp574_), FALSE)), _tmp575_);
					}
				} else {
					gboolean _tmp576_ = FALSE;
					ValaMemberAccess* _tmp577_;
					const gchar* _tmp578_;
					const gchar* _tmp579_;
					_tmp577_ = ma;
					_tmp578_ = vala_member_access_get_member_name (_tmp577_);
					_tmp579_ = _tmp578_;
					if (g_strcmp0 (_tmp579_, "end") != 0) {
						_tmp576_ = TRUE;
					} else {
						ValaMethod* _tmp580_;
						_tmp580_ = m;
						_tmp576_ = vala_get_ccode_finish_instance (_tmp580_);
					}
					if (_tmp576_) {
						ValaHashMap* _tmp581_;
						ValaMethod* _tmp582_;
						ValaCCodeExpression* _tmp583_;
						ValaHashMap* _tmp584_;
						ValaMethod* _tmp585_;
						ValaCCodeExpression* _tmp586_;
						_tmp581_ = out_arg_map;
						_tmp582_ = m;
						_tmp583_ = instance;
						vala_map_set ((ValaMap*) _tmp581_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp582_), FALSE)), _tmp583_);
						_tmp584_ = in_arg_map;
						_tmp585_ = m;
						_tmp586_ = instance;
						vala_map_set ((ValaMap*) _tmp584_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp585_), FALSE)), _tmp586_);
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp587_ = FALSE;
			ValaMethod* _tmp588_;
			_tmp588_ = m;
			if (_tmp588_ != NULL) {
				ValaMethod* _tmp589_;
				ValaMemberBinding _tmp590_;
				ValaMemberBinding _tmp591_;
				_tmp589_ = m;
				_tmp590_ = vala_method_get_binding (_tmp589_);
				_tmp591_ = _tmp590_;
				_tmp587_ = _tmp591_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp587_ = FALSE;
			}
			if (_tmp587_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp592_;
				ValaSymbol* _tmp593_;
				ValaSymbol* _tmp594_;
				ValaClass* _tmp595_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp596_;
				gchar* _tmp597_;
				gchar* _tmp598_;
				ValaCCodeIdentifier* _tmp599_;
				ValaCCodeIdentifier* _tmp600_;
				ValaCCodeFunctionCall* _tmp601_;
				ValaCCodeFunctionCall* _tmp602_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp603_;
				ValaExpression* _tmp604_;
				ValaExpression* _tmp605_;
				ValaCCodeFunctionCall* _tmp631_;
				ValaCCodeExpression* _tmp632_;
				ValaHashMap* _tmp633_;
				ValaMethod* _tmp634_;
				ValaCCodeFunctionCall* _tmp635_;
				ValaHashMap* _tmp636_;
				ValaMethod* _tmp637_;
				ValaCCodeFunctionCall* _tmp638_;
				_tmp592_ = m;
				_tmp593_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp592_);
				_tmp594_ = _tmp593_;
				_tmp595_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp594_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp595_;
				_tmp596_ = cl;
				_tmp597_ = vala_get_ccode_class_type_function (_tmp596_);
				_tmp598_ = _tmp597_;
				_tmp599_ = vala_ccode_identifier_new (_tmp598_);
				_tmp600_ = _tmp599_;
				_tmp601_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp600_);
				_tmp602_ = _tmp601_;
				_vala_ccode_node_unref0 (_tmp600_);
				_g_free0 (_tmp598_);
				cast = _tmp602_;
				_tmp603_ = ma;
				_tmp604_ = vala_member_access_get_inner (_tmp603_);
				_tmp605_ = _tmp604_;
				if (_tmp605_ == NULL) {
					ValaDataType* _tmp606_;
					ValaDataType* _tmp607_;
					gboolean _tmp608_;
					_tmp606_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp607_ = _tmp606_;
					_tmp608_ = _tmp607_ == NULL;
					_vala_code_node_unref0 (_tmp607_);
					if (_tmp608_) {
						ValaCCodeIdentifier* _tmp609_;
						_tmp609_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp609_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp610_;
						ValaCCodeIdentifier* _tmp611_;
						ValaCCodeFunctionCall* _tmp612_;
						ValaCCodeFunctionCall* _tmp613_;
						ValaCCodeFunctionCall* _tmp614_;
						ValaCCodeExpression* _tmp615_;
						ValaCCodeExpression* _tmp616_;
						ValaCCodeFunctionCall* _tmp617_;
						ValaCCodeExpression* _tmp618_;
						_tmp610_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp611_ = _tmp610_;
						_tmp612_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp611_);
						_tmp613_ = _tmp612_;
						_vala_ccode_node_unref0 (_tmp611_);
						k = _tmp613_;
						_tmp614_ = k;
						_tmp615_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp616_ = _tmp615_;
						vala_ccode_function_call_add_argument (_tmp614_, _tmp616_);
						_vala_ccode_node_unref0 (_tmp616_);
						_tmp617_ = k;
						_tmp618_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp617_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp618_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp619_;
					ValaCCodeIdentifier* _tmp620_;
					ValaCCodeFunctionCall* _tmp621_;
					ValaCCodeFunctionCall* _tmp622_;
					ValaCCodeFunctionCall* _tmp623_;
					ValaMemberAccess* _tmp624_;
					ValaExpression* _tmp625_;
					ValaExpression* _tmp626_;
					ValaCCodeExpression* _tmp627_;
					ValaCCodeExpression* _tmp628_;
					ValaCCodeFunctionCall* _tmp629_;
					ValaCCodeExpression* _tmp630_;
					_tmp619_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp620_ = _tmp619_;
					_tmp621_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp620_);
					_tmp622_ = _tmp621_;
					_vala_ccode_node_unref0 (_tmp620_);
					k = _tmp622_;
					_tmp623_ = k;
					_tmp624_ = ma;
					_tmp625_ = vala_member_access_get_inner (_tmp624_);
					_tmp626_ = _tmp625_;
					_tmp627_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp626_);
					_tmp628_ = _tmp627_;
					vala_ccode_function_call_add_argument (_tmp623_, _tmp628_);
					_vala_ccode_node_unref0 (_tmp628_);
					_tmp629_ = k;
					_tmp630_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp629_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp630_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp631_ = cast;
				_tmp632_ = klass;
				vala_ccode_function_call_add_argument (_tmp631_, _tmp632_);
				_tmp633_ = in_arg_map;
				_tmp634_ = m;
				_tmp635_ = cast;
				vala_map_set ((ValaMap*) _tmp633_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp634_), FALSE)), (ValaCCodeExpression*) _tmp635_);
				_tmp636_ = out_arg_map;
				_tmp637_ = m;
				_tmp638_ = cast;
				vala_map_set ((ValaMap*) _tmp636_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp637_), FALSE)), (ValaCCodeExpression*) _tmp638_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp640_ = m;
	if (_tmp640_ != NULL) {
		ValaMethod* _tmp641_;
		_tmp641_ = m;
		_tmp639_ = vala_get_ccode_has_generic_type_parameter (_tmp641_);
	} else {
		_tmp639_ = FALSE;
	}
	if (_tmp639_) {
		ValaMethod* _tmp642_;
		_tmp642_ = m;
		if (vala_method_has_type_parameters (_tmp642_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp643_;
				ValaList* _tmp644_;
				gint _type_arg_size = 0;
				ValaList* _tmp645_;
				gint _tmp646_;
				gint _tmp647_;
				gint _type_arg_index = 0;
				_tmp643_ = ma;
				_tmp644_ = vala_member_access_get_type_arguments (_tmp643_);
				_type_arg_list = _tmp644_;
				_tmp645_ = _type_arg_list;
				_tmp646_ = vala_collection_get_size ((ValaCollection*) _tmp645_);
				_tmp647_ = _tmp646_;
				_type_arg_size = _tmp647_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp648_;
					gpointer _tmp649_;
					gboolean _tmp650_ = FALSE;
					gboolean _tmp651_ = FALSE;
					gboolean _tmp652_ = FALSE;
					ValaMethod* _tmp653_;
					ValaHashMap* _tmp661_;
					ValaMethod* _tmp662_;
					ValaDataType* _tmp663_;
					gchar* _tmp664_;
					gchar* _tmp665_;
					ValaCCodeIdentifier* _tmp666_;
					ValaCCodeIdentifier* _tmp667_;
					gint _tmp668_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp648_ = _type_arg_list;
					_tmp649_ = vala_list_get (_tmp648_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp649_;
					_tmp653_ = m;
					if (vala_get_ccode_simple_generics (_tmp653_)) {
						ValaDataType* _tmp654_;
						_tmp654_ = type_arg;
						_tmp652_ = vala_data_type_is_real_struct_type (_tmp654_);
					} else {
						_tmp652_ = FALSE;
					}
					if (_tmp652_) {
						ValaDataType* _tmp655_;
						gboolean _tmp656_;
						gboolean _tmp657_;
						_tmp655_ = type_arg;
						_tmp656_ = vala_data_type_get_nullable (_tmp655_);
						_tmp657_ = _tmp656_;
						_tmp651_ = !_tmp657_;
					} else {
						_tmp651_ = FALSE;
					}
					if (_tmp651_) {
						ValaDataType* _tmp658_;
						_tmp658_ = type_arg;
						_tmp650_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp658_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp650_ = FALSE;
					}
					if (_tmp650_) {
						ValaDataType* _tmp659_;
						ValaPointerType* _tmp660_;
						_tmp659_ = type_arg;
						_tmp660_ = vala_pointer_type_new (_tmp659_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp660_;
					}
					_tmp661_ = in_arg_map;
					_tmp662_ = m;
					_tmp663_ = type_arg;
					_tmp664_ = vala_get_ccode_name ((ValaCodeNode*) _tmp663_);
					_tmp665_ = _tmp664_;
					_tmp666_ = vala_ccode_identifier_new (_tmp665_);
					_tmp667_ = _tmp666_;
					vala_map_set ((ValaMap*) _tmp661_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp662_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp667_);
					_vala_ccode_node_unref0 (_tmp667_);
					_g_free0 (_tmp665_);
					_tmp668_ = type_param_index;
					type_param_index = _tmp668_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp669_;
				ValaExpression* _tmp670_;
				ValaExpression* _tmp671_;
				ValaDataType* _tmp672_;
				ValaDataType* _tmp673_;
				ValaList* _tmp674_;
				gint _type_arg_size = 0;
				ValaList* _tmp675_;
				gint _tmp676_;
				gint _tmp677_;
				gint _type_arg_index = 0;
				_tmp669_ = ma;
				_tmp670_ = vala_member_access_get_inner (_tmp669_);
				_tmp671_ = _tmp670_;
				_tmp672_ = vala_expression_get_value_type (_tmp671_);
				_tmp673_ = _tmp672_;
				_tmp674_ = vala_data_type_get_type_arguments (_tmp673_);
				_type_arg_list = _tmp674_;
				_tmp675_ = _type_arg_list;
				_tmp676_ = vala_collection_get_size ((ValaCollection*) _tmp675_);
				_tmp677_ = _tmp676_;
				_type_arg_size = _tmp677_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp678_;
					gpointer _tmp679_;
					ValaHashMap* _tmp680_;
					ValaMethod* _tmp681_;
					ValaDataType* _tmp682_;
					gchar* _tmp683_;
					gchar* _tmp684_;
					ValaCCodeIdentifier* _tmp685_;
					ValaCCodeIdentifier* _tmp686_;
					gint _tmp687_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp678_ = _type_arg_list;
					_tmp679_ = vala_list_get (_tmp678_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp679_;
					_tmp680_ = in_arg_map;
					_tmp681_ = m;
					_tmp682_ = type_arg;
					_tmp683_ = vala_get_ccode_name ((ValaCodeNode*) _tmp682_);
					_tmp684_ = _tmp683_;
					_tmp685_ = vala_ccode_identifier_new (_tmp684_);
					_tmp686_ = _tmp685_;
					vala_map_set ((ValaMap*) _tmp680_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp681_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp686_);
					_vala_ccode_node_unref0 (_tmp686_);
					_g_free0 (_tmp684_);
					_tmp687_ = type_param_index;
					type_param_index = _tmp687_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp688_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp688_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp689_;
		ValaExpression* _tmp690_;
		ValaExpression* _tmp691_;
		ValaDataType* _tmp692_;
		ValaDataType* _tmp693_;
		ValaArrayType* _tmp694_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp695_;
		ValaCCodeIdentifier* _tmp696_;
		ValaCCodeFunctionCall* _tmp697_;
		ValaCCodeFunctionCall* _tmp698_;
		ValaCCodeFunctionCall* _tmp699_;
		ValaArrayType* _tmp700_;
		ValaDataType* _tmp701_;
		ValaDataType* _tmp702_;
		gchar* _tmp703_;
		gchar* _tmp704_;
		ValaCCodeIdentifier* _tmp705_;
		ValaCCodeIdentifier* _tmp706_;
		ValaHashMap* _tmp707_;
		ValaCCodeFunctionCall* _tmp708_;
		_tmp689_ = ma;
		_tmp690_ = vala_member_access_get_inner (_tmp689_);
		_tmp691_ = _tmp690_;
		_tmp692_ = vala_expression_get_value_type (_tmp691_);
		_tmp693_ = _tmp692_;
		_tmp694_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp693_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp694_;
		_tmp695_ = vala_ccode_identifier_new ("sizeof");
		_tmp696_ = _tmp695_;
		_tmp697_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp696_);
		_tmp698_ = _tmp697_;
		_vala_ccode_node_unref0 (_tmp696_);
		csizeof = _tmp698_;
		_tmp699_ = csizeof;
		_tmp700_ = array_type;
		_tmp701_ = vala_array_type_get_element_type (_tmp700_);
		_tmp702_ = _tmp701_;
		_tmp703_ = vala_get_ccode_name ((ValaCodeNode*) _tmp702_);
		_tmp704_ = _tmp703_;
		_tmp705_ = vala_ccode_identifier_new (_tmp704_);
		_tmp706_ = _tmp705_;
		vala_ccode_function_call_add_argument (_tmp699_, (ValaCCodeExpression*) _tmp706_);
		_vala_ccode_node_unref0 (_tmp706_);
		_g_free0 (_tmp704_);
		_tmp707_ = in_arg_map;
		_tmp708_ = csizeof;
		vala_map_set ((ValaMap*) _tmp707_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp708_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp709_;
		_tmp709_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp709_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp710_;
			ValaMethod* _tmp711_;
			ValaMethod* _tmp712_;
			gint param_nr = 0;
			ValaMethod* _tmp772_;
			ValaCCodeBaseModuleEmitContext* _tmp773_;
			_tmp710_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp711_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp710_, (ValaSymbol*) _tmp711_);
			_tmp712_ = m;
			vala_method_clear_parameters (_tmp712_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp713_;
				gint _arg_size = 0;
				ValaList* _tmp714_;
				gint _tmp715_;
				gint _tmp716_;
				gint _arg_index = 0;
				_tmp713_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp713_;
				_tmp714_ = _arg_list;
				_tmp715_ = vala_collection_get_size ((ValaCollection*) _tmp714_);
				_tmp716_ = _tmp715_;
				_arg_size = _tmp716_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp717_;
					gpointer _tmp718_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp719_;
					ValaUnaryExpression* _tmp720_;
					gboolean _tmp721_ = FALSE;
					ValaUnaryExpression* _tmp722_;
					gint _tmp763_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp717_ = _arg_list;
					_tmp718_ = vala_list_get (_tmp717_, _arg_index);
					arg = (ValaExpression*) _tmp718_;
					_tmp719_ = arg;
					_tmp720_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp719_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp719_) : NULL);
					unary = _tmp720_;
					_tmp722_ = unary;
					if (_tmp722_ != NULL) {
						ValaUnaryExpression* _tmp723_;
						ValaUnaryOperator _tmp724_;
						ValaUnaryOperator _tmp725_;
						_tmp723_ = unary;
						_tmp724_ = vala_unary_expression_get_operator (_tmp723_);
						_tmp725_ = _tmp724_;
						_tmp721_ = _tmp725_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp721_ = FALSE;
					}
					if (_tmp721_) {
						ValaParameter* param = NULL;
						gchar* _tmp726_;
						gchar* _tmp727_;
						ValaUnaryExpression* _tmp728_;
						ValaExpression* _tmp729_;
						ValaExpression* _tmp730_;
						ValaDataType* _tmp731_;
						ValaDataType* _tmp732_;
						ValaParameter* _tmp733_;
						ValaParameter* _tmp734_;
						ValaParameter* _tmp735_;
						ValaMethod* _tmp736_;
						ValaParameter* _tmp737_;
						_tmp726_ = g_strdup_printf ("param%d", param_nr);
						_tmp727_ = _tmp726_;
						_tmp728_ = unary;
						_tmp729_ = vala_unary_expression_get_inner (_tmp728_);
						_tmp730_ = _tmp729_;
						_tmp731_ = vala_expression_get_value_type (_tmp730_);
						_tmp732_ = _tmp731_;
						_tmp733_ = vala_parameter_new (_tmp727_, _tmp732_, NULL);
						_tmp734_ = _tmp733_;
						_g_free0 (_tmp727_);
						param = _tmp734_;
						_tmp735_ = param;
						vala_parameter_set_direction (_tmp735_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp736_ = m;
						_tmp737_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp736_, _tmp737_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp738_ = FALSE;
						ValaUnaryExpression* _tmp739_;
						_tmp739_ = unary;
						if (_tmp739_ != NULL) {
							ValaUnaryExpression* _tmp740_;
							ValaUnaryOperator _tmp741_;
							ValaUnaryOperator _tmp742_;
							_tmp740_ = unary;
							_tmp741_ = vala_unary_expression_get_operator (_tmp740_);
							_tmp742_ = _tmp741_;
							_tmp738_ = _tmp742_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp738_ = FALSE;
						}
						if (_tmp738_) {
							ValaParameter* param = NULL;
							gchar* _tmp743_;
							gchar* _tmp744_;
							ValaUnaryExpression* _tmp745_;
							ValaExpression* _tmp746_;
							ValaExpression* _tmp747_;
							ValaDataType* _tmp748_;
							ValaDataType* _tmp749_;
							ValaParameter* _tmp750_;
							ValaParameter* _tmp751_;
							ValaParameter* _tmp752_;
							ValaMethod* _tmp753_;
							ValaParameter* _tmp754_;
							_tmp743_ = g_strdup_printf ("param%d", param_nr);
							_tmp744_ = _tmp743_;
							_tmp745_ = unary;
							_tmp746_ = vala_unary_expression_get_inner (_tmp745_);
							_tmp747_ = _tmp746_;
							_tmp748_ = vala_expression_get_value_type (_tmp747_);
							_tmp749_ = _tmp748_;
							_tmp750_ = vala_parameter_new (_tmp744_, _tmp749_, NULL);
							_tmp751_ = _tmp750_;
							_g_free0 (_tmp744_);
							param = _tmp751_;
							_tmp752_ = param;
							vala_parameter_set_direction (_tmp752_, VALA_PARAMETER_DIRECTION_REF);
							_tmp753_ = m;
							_tmp754_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp753_, _tmp754_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp755_;
							gchar* _tmp756_;
							gchar* _tmp757_;
							ValaExpression* _tmp758_;
							ValaDataType* _tmp759_;
							ValaDataType* _tmp760_;
							ValaParameter* _tmp761_;
							ValaParameter* _tmp762_;
							_tmp755_ = m;
							_tmp756_ = g_strdup_printf ("param%d", param_nr);
							_tmp757_ = _tmp756_;
							_tmp758_ = arg;
							_tmp759_ = vala_expression_get_value_type (_tmp758_);
							_tmp760_ = _tmp759_;
							_tmp761_ = vala_parameter_new (_tmp757_, _tmp760_, NULL);
							_tmp762_ = _tmp761_;
							vala_callable_add_parameter ((ValaCallable*) _tmp755_, _tmp762_);
							_vala_code_node_unref0 (_tmp762_);
							_g_free0 (_tmp757_);
						}
					}
					_tmp763_ = param_nr;
					param_nr = _tmp763_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp764_;
				ValaList* _tmp765_;
				gint _param_size = 0;
				ValaList* _tmp766_;
				gint _tmp767_;
				gint _tmp768_;
				gint _param_index = 0;
				_tmp764_ = m;
				_tmp765_ = vala_callable_get_parameters ((ValaCallable*) _tmp764_);
				_param_list = _tmp765_;
				_tmp766_ = _param_list;
				_tmp767_ = vala_collection_get_size ((ValaCollection*) _tmp766_);
				_tmp768_ = _tmp767_;
				_param_size = _tmp768_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp769_;
					gpointer _tmp770_;
					ValaParameter* _tmp771_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp769_ = _param_list;
					_tmp770_ = vala_list_get (_tmp769_, _param_index);
					param = (ValaParameter*) _tmp770_;
					_tmp771_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp771_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp772_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp772_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp773_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp773_);
		} else {
			gboolean _tmp774_ = FALSE;
			gboolean _tmp775_ = FALSE;
			ValaMethod* _tmp776_;
			_tmp776_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp776_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp777_;
				ValaCodeContext* _tmp778_;
				ValaProfile _tmp779_;
				ValaProfile _tmp780_;
				_tmp777_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp778_ = _tmp777_;
				_tmp779_ = vala_code_context_get_profile (_tmp778_);
				_tmp780_ = _tmp779_;
				_tmp775_ = _tmp780_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp775_ = FALSE;
			}
			if (_tmp775_) {
				ValaMethod* _tmp781_;
				ValaSymbol* _tmp782_;
				ValaSymbol* _tmp783_;
				_tmp781_ = m;
				_tmp782_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp781_);
				_tmp783_ = _tmp782_;
				_tmp774_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp783_, VALA_TYPE_CLASS);
			} else {
				_tmp774_ = FALSE;
			}
			if (_tmp774_) {
				ValaCCodeFunction* _tmp784_;
				ValaCCodeFunction* _tmp785_;
				ValaCCodeExpression* _tmp786_;
				ValaCCodeExpression* _tmp787_;
				ValaCCodeFunctionCall* _tmp788_;
				ValaClass* _tmp789_;
				ValaClass* _tmp790_;
				gchar* _tmp791_;
				gchar* _tmp792_;
				gchar* _tmp793_;
				gchar* _tmp794_;
				ValaCCodeCastExpression* _tmp795_;
				ValaCCodeCastExpression* _tmp796_;
				ValaMethod* _tmp797_;
				ValaMethod* _tmp798_;
				ValaBlock* _tmp799_;
				ValaBlock* _tmp800_;
				gboolean _tmp801_;
				gboolean _tmp802_;
				gboolean _tmp829_ = FALSE;
				ValaClass* _tmp830_;
				ValaClass* _tmp831_;
				gboolean _tmp832_;
				gboolean _tmp833_;
				_tmp784_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp785_ = _tmp784_;
				_tmp786_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp787_ = _tmp786_;
				_tmp788_ = ccall;
				_tmp789_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp790_ = _tmp789_;
				_tmp791_ = vala_get_ccode_name ((ValaCodeNode*) _tmp790_);
				_tmp792_ = _tmp791_;
				_tmp793_ = g_strconcat (_tmp792_, "*", NULL);
				_tmp794_ = _tmp793_;
				_tmp795_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp788_, _tmp794_);
				_tmp796_ = _tmp795_;
				vala_ccode_function_add_assignment (_tmp785_, _tmp787_, (ValaCCodeExpression*) _tmp796_);
				_vala_ccode_node_unref0 (_tmp796_);
				_g_free0 (_tmp794_);
				_g_free0 (_tmp792_);
				_vala_ccode_node_unref0 (_tmp787_);
				_tmp797_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp798_ = _tmp797_;
				_tmp799_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp798_);
				_tmp800_ = _tmp799_;
				_tmp801_ = vala_block_get_captured (_tmp800_);
				_tmp802_ = _tmp801_;
				if (_tmp802_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp803_;
					ValaClass* _tmp804_;
					ValaObjectType* _tmp805_;
					ValaObjectType* _tmp806_;
					ValaSourceReference* _tmp807_;
					ValaSourceReference* _tmp808_;
					ValaCCodeExpression* _tmp809_;
					ValaCCodeExpression* _tmp810_;
					ValaCCodeFunctionCall* _tmp811_;
					ValaCCodeFunctionCall* _tmp812_;
					ValaCCodeFunctionCall* _tmp813_;
					ValaCCodeExpression* _tmp814_;
					ValaCCodeExpression* _tmp815_;
					ValaCCodeFunction* _tmp816_;
					ValaCCodeFunction* _tmp817_;
					ValaMethod* _tmp818_;
					ValaMethod* _tmp819_;
					ValaBlock* _tmp820_;
					ValaBlock* _tmp821_;
					gchar* _tmp822_;
					gchar* _tmp823_;
					ValaCCodeExpression* _tmp824_;
					ValaCCodeExpression* _tmp825_;
					ValaCCodeMemberAccess* _tmp826_;
					ValaCCodeMemberAccess* _tmp827_;
					ValaCCodeFunctionCall* _tmp828_;
					_tmp803_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp804_ = _tmp803_;
					_tmp805_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp804_);
					_tmp806_ = _tmp805_;
					_tmp807_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp808_ = _tmp807_;
					_tmp809_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp806_, _tmp808_, FALSE);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_ccode_function_call_new (_tmp810_);
					_tmp812_ = _tmp811_;
					_vala_ccode_node_unref0 (_tmp810_);
					_vala_code_node_unref0 (_tmp806_);
					ref_call = _tmp812_;
					_tmp813_ = ref_call;
					_tmp814_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp815_ = _tmp814_;
					vala_ccode_function_call_add_argument (_tmp813_, _tmp815_);
					_vala_ccode_node_unref0 (_tmp815_);
					_tmp816_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp817_ = _tmp816_;
					_tmp818_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp819_ = _tmp818_;
					_tmp820_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp819_);
					_tmp821_ = _tmp820_;
					_tmp822_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp821_));
					_tmp823_ = _tmp822_;
					_tmp824_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp823_);
					_tmp825_ = _tmp824_;
					_tmp826_ = vala_ccode_member_access_new_pointer (_tmp825_, "self");
					_tmp827_ = _tmp826_;
					_tmp828_ = ref_call;
					vala_ccode_function_add_assignment (_tmp817_, (ValaCCodeExpression*) _tmp827_, (ValaCCodeExpression*) _tmp828_);
					_vala_ccode_node_unref0 (_tmp827_);
					_vala_ccode_node_unref0 (_tmp825_);
					_g_free0 (_tmp823_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp830_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp831_ = _tmp830_;
				_tmp832_ = vala_class_get_is_compact (_tmp831_);
				_tmp833_ = _tmp832_;
				if (!_tmp833_) {
					ValaClass* _tmp834_;
					ValaClass* _tmp835_;
					_tmp834_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp835_ = _tmp834_;
					_tmp829_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp835_);
				} else {
					_tmp829_ = FALSE;
				}
				if (_tmp829_) {
					gchar** suffices = NULL;
					gchar* _tmp836_;
					gchar* _tmp837_;
					gchar* _tmp838_;
					gchar** _tmp839_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp836_ = g_strdup ("type");
					_tmp837_ = g_strdup ("dup_func");
					_tmp838_ = g_strdup ("destroy_func");
					_tmp839_ = g_new0 (gchar*, 3 + 1);
					_tmp839_[0] = _tmp836_;
					_tmp839_[1] = _tmp837_;
					_tmp839_[2] = _tmp838_;
					suffices = _tmp839_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp840_;
						ValaClass* _tmp841_;
						ValaList* _tmp842_;
						gint _type_param_size = 0;
						ValaList* _tmp843_;
						gint _tmp844_;
						gint _tmp845_;
						gint _type_param_index = 0;
						_tmp840_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp841_ = _tmp840_;
						_tmp842_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp841_);
						_type_param_list = _tmp842_;
						_tmp843_ = _type_param_list;
						_tmp844_ = vala_collection_get_size ((ValaCollection*) _tmp843_);
						_tmp845_ = _tmp844_;
						_type_param_size = _tmp845_;
						_type_param_index = -1;
						while (TRUE) {
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp846_;
							gpointer _tmp847_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp848_;
							ValaCCodeIdentifier* _tmp849_;
							ValaCCodeMemberAccess* _tmp850_;
							ValaCCodeMemberAccess* _tmp851_;
							gchar** _tmp852_;
							gint _tmp852__length1;
							_type_param_index = _type_param_index + 1;
							if (!(_type_param_index < _type_param_size)) {
								break;
							}
							_tmp846_ = _type_param_list;
							_tmp847_ = vala_list_get (_tmp846_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp847_;
							_tmp848_ = vala_ccode_identifier_new ("self");
							_tmp849_ = _tmp848_;
							_tmp850_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp849_, "priv");
							_tmp851_ = _tmp850_;
							_vala_ccode_node_unref0 (_tmp849_);
							priv_access = _tmp851_;
							_tmp852_ = suffices;
							_tmp852__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp852_;
								suffix_collection_length1 = _tmp852__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp853_;
									gchar* suffix = NULL;
									_tmp853_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp853_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp854_;
										const gchar* _tmp855_;
										const gchar* _tmp856_;
										gchar* _tmp857_;
										gchar* _tmp858_;
										const gchar* _tmp859_;
										gchar* _tmp860_;
										gchar* _tmp861_;
										ValaCCodeIdentifier* _tmp862_;
										ValaCCodeIdentifier* _tmp863_;
										ValaCCodeFunction* _tmp864_;
										ValaCCodeFunction* _tmp865_;
										ValaCCodeMemberAccess* _tmp866_;
										ValaCCodeIdentifier* _tmp867_;
										const gchar* _tmp868_;
										const gchar* _tmp869_;
										ValaCCodeMemberAccess* _tmp870_;
										ValaCCodeMemberAccess* _tmp871_;
										ValaCCodeIdentifier* _tmp872_;
										_tmp854_ = type_param;
										_tmp855_ = vala_symbol_get_name ((ValaSymbol*) _tmp854_);
										_tmp856_ = _tmp855_;
										_tmp857_ = g_utf8_strdown (_tmp856_, (gssize) -1);
										_tmp858_ = _tmp857_;
										_tmp859_ = suffix;
										_tmp860_ = g_strdup_printf ("%s_%s", _tmp858_, _tmp859_);
										_tmp861_ = _tmp860_;
										_tmp862_ = vala_ccode_identifier_new (_tmp861_);
										_tmp863_ = _tmp862_;
										_g_free0 (_tmp861_);
										_g_free0 (_tmp858_);
										param_name = _tmp863_;
										_tmp864_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp865_ = _tmp864_;
										_tmp866_ = priv_access;
										_tmp867_ = param_name;
										_tmp868_ = vala_ccode_identifier_get_name (_tmp867_);
										_tmp869_ = _tmp868_;
										_tmp870_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp866_, _tmp869_);
										_tmp871_ = _tmp870_;
										_tmp872_ = param_name;
										vala_ccode_function_add_assignment (_tmp865_, (ValaCCodeExpression*) _tmp871_, (ValaCCodeExpression*) _tmp872_);
										_vala_ccode_node_unref0 (_tmp871_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp873_ = params;
	_tmp874_ = vala_iterable_iterator ((ValaIterable*) _tmp873_);
	params_it = _tmp874_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp875_;
		gint _arg_size = 0;
		ValaList* _tmp876_;
		gint _tmp877_;
		gint _tmp878_;
		gint _arg_index = 0;
		_tmp875_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp875_;
		_tmp876_ = _arg_list;
		_tmp877_ = vala_collection_get_size ((ValaCollection*) _tmp876_);
		_tmp878_ = _tmp877_;
		_arg_size = _tmp878_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp879_;
			gpointer _tmp880_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp881_;
			ValaCCodeExpression* _tmp882_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp883_;
			ValaHashMap* _tmp884_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp885_;
			gboolean _tmp895_ = FALSE;
			ValaParameter* _tmp896_;
			gdouble _tmp1222_ = 0.0;
			gboolean _tmp1223_ = FALSE;
			ValaParameter* _tmp1224_;
			ValaHashMap* _tmp1226_;
			ValaCCodeExpression* _tmp1227_;
			gboolean _tmp1228_ = FALSE;
			ValaExpression* _tmp1229_;
			gint _tmp1246_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp879_ = _arg_list;
			_tmp880_ = vala_list_get (_tmp879_, _arg_index);
			arg = (ValaExpression*) _tmp880_;
			_tmp881_ = arg;
			_tmp882_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp881_);
			cexpr = _tmp882_;
			_tmp883_ = in_arg_map;
			_tmp884_ = _vala_map_ref0 (_tmp883_);
			carg_map = _tmp884_;
			param = NULL;
			_tmp885_ = params_it;
			if (vala_iterator_next (_tmp885_)) {
				ValaIterator* _tmp886_;
				gpointer _tmp887_;
				gboolean _tmp888_ = FALSE;
				ValaParameter* _tmp889_;
				gboolean _tmp890_;
				gboolean _tmp891_;
				_tmp886_ = params_it;
				_tmp887_ = vala_iterator_get (_tmp886_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp887_;
				_tmp889_ = param;
				_tmp890_ = vala_parameter_get_params_array (_tmp889_);
				_tmp891_ = _tmp890_;
				if (_tmp891_) {
					_tmp888_ = TRUE;
				} else {
					ValaParameter* _tmp892_;
					gboolean _tmp893_;
					gboolean _tmp894_;
					_tmp892_ = param;
					_tmp893_ = vala_parameter_get_ellipsis (_tmp892_);
					_tmp894_ = _tmp893_;
					_tmp888_ = _tmp894_;
				}
				ellipsis = _tmp888_;
			}
			_tmp896_ = param;
			if (_tmp896_ != NULL) {
				_tmp895_ = !ellipsis;
			} else {
				_tmp895_ = FALSE;
			}
			if (_tmp895_) {
				ValaParameter* _tmp897_;
				ValaParameterDirection _tmp898_;
				ValaParameterDirection _tmp899_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp902_;
				ValaUnaryExpression* _tmp903_;
				gboolean _tmp904_ = FALSE;
				ValaUnaryExpression* _tmp905_;
				ValaParameter* _tmp1173_;
				gchar* _tmp1174_;
				gchar* _tmp1175_;
				gboolean _tmp1176_;
				_tmp897_ = param;
				_tmp898_ = vala_parameter_get_direction (_tmp897_);
				_tmp899_ = _tmp898_;
				if (_tmp899_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp900_;
					ValaHashMap* _tmp901_;
					_tmp900_ = out_arg_map;
					_tmp901_ = _vala_map_ref0 (_tmp900_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp901_;
				}
				_tmp902_ = arg;
				_tmp903_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp902_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp902_) : NULL);
				unary = _tmp903_;
				_tmp905_ = unary;
				if (_tmp905_ == NULL) {
					_tmp904_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp906_;
					ValaUnaryOperator _tmp907_;
					ValaUnaryOperator _tmp908_;
					_tmp906_ = unary;
					_tmp907_ = vala_unary_expression_get_operator (_tmp906_);
					_tmp908_ = _tmp907_;
					_tmp904_ = _tmp908_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp904_) {
					gboolean _tmp909_ = FALSE;
					gboolean _tmp910_ = FALSE;
					ValaParameter* _tmp911_;
					ValaParameter* _tmp1047_;
					ValaExpression* _tmp1048_;
					ValaCCodeExpression* _tmp1049_;
					ValaCCodeExpression* _tmp1050_;
					_tmp911_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp911_)) {
						ValaParameter* _tmp912_;
						ValaDataType* _tmp913_;
						ValaDataType* _tmp914_;
						_tmp912_ = param;
						_tmp913_ = vala_variable_get_variable_type ((ValaVariable*) _tmp912_);
						_tmp914_ = _tmp913_;
						_tmp910_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp914_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp910_ = FALSE;
					}
					if (_tmp910_) {
						ValaParameter* _tmp915_;
						ValaDataType* _tmp916_;
						ValaDataType* _tmp917_;
						gboolean _tmp918_;
						gboolean _tmp919_;
						_tmp915_ = param;
						_tmp916_ = vala_variable_get_variable_type ((ValaVariable*) _tmp915_);
						_tmp917_ = _tmp916_;
						_tmp918_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp917_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp919_ = _tmp918_;
						_tmp909_ = !_tmp919_;
					} else {
						_tmp909_ = FALSE;
					}
					if (_tmp909_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp920_;
						ValaDataType* _tmp921_;
						ValaDataType* _tmp922_;
						ValaArrayType* _tmp923_;
						gchar* _tmp924_ = NULL;
						ValaParameter* _tmp925_;
						gchar* _tmp926_;
						gchar* length_ctype = NULL;
						gchar* _tmp929_;
						gboolean _tmp930_ = FALSE;
						ValaUnaryExpression* _tmp931_;
						_tmp920_ = param;
						_tmp921_ = vala_variable_get_variable_type ((ValaVariable*) _tmp920_);
						_tmp922_ = _tmp921_;
						_tmp923_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp922_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp923_;
						_tmp925_ = param;
						_tmp926_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp925_);
						_tmp924_ = _tmp926_;
						if (_tmp924_ == NULL) {
							ValaArrayType* _tmp927_;
							gchar* _tmp928_;
							_tmp927_ = array_type;
							_tmp928_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp927_);
							_g_free0 (_tmp924_);
							_tmp924_ = _tmp928_;
						}
						_tmp929_ = g_strdup (_tmp924_);
						length_ctype = _tmp929_;
						_tmp931_ = unary;
						if (_tmp931_ != NULL) {
							ValaUnaryExpression* _tmp932_;
							ValaUnaryOperator _tmp933_;
							ValaUnaryOperator _tmp934_;
							_tmp932_ = unary;
							_tmp933_ = vala_unary_expression_get_operator (_tmp932_);
							_tmp934_ = _tmp933_;
							_tmp930_ = _tmp934_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp930_ = FALSE;
						}
						if (_tmp930_) {
							const gchar* _tmp935_;
							gchar* _tmp936_;
							_tmp935_ = length_ctype;
							_tmp936_ = g_strdup_printf ("%s*", _tmp935_);
							_g_free0 (length_ctype);
							length_ctype = _tmp936_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp937_ = FALSE;
								_tmp937_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp939_;
									gint _tmp940_;
									gint _tmp941_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp942_;
									ValaCCodeExpression* _tmp943_;
									ValaCCodeExpression* _tmp944_;
									const gchar* _tmp945_;
									ValaCCodeCastExpression* _tmp946_;
									ValaCCodeCastExpression* _tmp947_;
									ValaHashMap* _tmp948_;
									ValaParameter* _tmp949_;
									ValaCCodeCastExpression* _tmp950_;
									if (!_tmp937_) {
										gint _tmp938_;
										_tmp938_ = dim;
										dim = _tmp938_ + 1;
									}
									_tmp937_ = FALSE;
									_tmp939_ = array_type;
									_tmp940_ = vala_array_type_get_rank (_tmp939_);
									_tmp941_ = _tmp940_;
									if (!(dim <= _tmp941_)) {
										break;
									}
									_tmp942_ = arg;
									_tmp943_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp942_, dim);
									_tmp944_ = _tmp943_;
									_tmp945_ = length_ctype;
									_tmp946_ = vala_ccode_cast_expression_new (_tmp944_, _tmp945_);
									_tmp947_ = _tmp946_;
									_vala_ccode_node_unref0 (_tmp944_);
									array_length_expr = _tmp947_;
									_tmp948_ = carg_map;
									_tmp949_ = param;
									_tmp950_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp948_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp949_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp950_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp924_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp951_;
						ValaDataType* _tmp952_;
						ValaDataType* _tmp953_;
						_tmp951_ = param;
						_tmp952_ = vala_variable_get_variable_type ((ValaVariable*) _tmp951_);
						_tmp953_ = _tmp952_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp953_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp954_;
							ValaDataType* _tmp955_;
							ValaDataType* _tmp956_;
							ValaDelegateType* _tmp957_;
							ValaDelegateType* _tmp958_;
							ValaDelegate* _tmp959_;
							ValaDelegate* _tmp960_;
							gboolean _tmp961_;
							gboolean _tmp962_;
							_tmp954_ = param;
							_tmp955_ = vala_variable_get_variable_type ((ValaVariable*) _tmp954_);
							_tmp956_ = _tmp955_;
							_tmp957_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp956_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp957_;
							_tmp958_ = deleg_type;
							_tmp959_ = vala_delegate_type_get_delegate_symbol (_tmp958_);
							_tmp960_ = _tmp959_;
							_tmp961_ = vala_delegate_get_has_target (_tmp960_);
							_tmp962_ = _tmp961_;
							if (_tmp962_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp963_;
								ValaCCodeExpression* _tmp964_ = NULL;
								ValaCCodeExpression* _tmp965_;
								ValaCCodeExpression* _tmp966_;
								ValaParameter* _tmp967_;
								gchar* _tmp968_;
								gchar* _tmp969_;
								gboolean _tmp970_;
								_tmp963_ = arg;
								_tmp965_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp963_, &_tmp964_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp964_;
								delegate_target = _tmp965_;
								_tmp966_ = delegate_target;
								_vala_assert (_tmp966_ != NULL, "delegate_target != null");
								_tmp967_ = param;
								_tmp968_ = vala_get_ccode_type ((ValaCodeNode*) _tmp967_);
								_tmp969_ = _tmp968_;
								_tmp970_ = g_strcmp0 (_tmp969_, "GClosure*") == 0;
								_g_free0 (_tmp969_);
								if (_tmp970_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp971_;
									ValaCCodeIdentifier* _tmp972_;
									ValaCCodeFunctionCall* _tmp973_;
									ValaCCodeFunctionCall* _tmp974_;
									ValaCCodeFunctionCall* _tmp975_;
									ValaCCodeExpression* _tmp976_;
									ValaCCodeCastExpression* _tmp977_;
									ValaCCodeCastExpression* _tmp978_;
									ValaCCodeFunctionCall* _tmp979_;
									ValaCCodeExpression* _tmp980_;
									ValaCCodeFunctionCall* _tmp981_;
									ValaCCodeExpression* _tmp982_;
									ValaCCodeCastExpression* _tmp983_;
									ValaCCodeCastExpression* _tmp984_;
									ValaCCodeExpression* _tmp985_;
									ValaCCodeIdentifier* _tmp986_;
									ValaCCodeIdentifier* _tmp987_;
									ValaCCodeBinaryExpression* _tmp988_;
									ValaCCodeBinaryExpression* _tmp989_;
									ValaCCodeIdentifier* _tmp990_;
									ValaCCodeIdentifier* _tmp991_;
									ValaCCodeFunctionCall* _tmp992_;
									ValaCCodeConditionalExpression* _tmp993_;
									_tmp971_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp972_ = _tmp971_;
									_tmp973_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp972_);
									_tmp974_ = _tmp973_;
									_vala_ccode_node_unref0 (_tmp972_);
									closure_new = _tmp974_;
									_tmp975_ = closure_new;
									_tmp976_ = cexpr;
									_tmp977_ = vala_ccode_cast_expression_new (_tmp976_, "GCallback");
									_tmp978_ = _tmp977_;
									vala_ccode_function_call_add_argument (_tmp975_, (ValaCCodeExpression*) _tmp978_);
									_vala_ccode_node_unref0 (_tmp978_);
									_tmp979_ = closure_new;
									_tmp980_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp979_, _tmp980_);
									_tmp981_ = closure_new;
									_tmp982_ = delegate_target_destroy_notify;
									_tmp983_ = vala_ccode_cast_expression_new (_tmp982_, "GClosureNotify");
									_tmp984_ = _tmp983_;
									vala_ccode_function_call_add_argument (_tmp981_, (ValaCCodeExpression*) _tmp984_);
									_vala_ccode_node_unref0 (_tmp984_);
									_tmp985_ = cexpr;
									_tmp986_ = vala_ccode_identifier_new ("NULL");
									_tmp987_ = _tmp986_;
									_tmp988_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp985_, (ValaCCodeExpression*) _tmp987_);
									_tmp989_ = _tmp988_;
									_tmp990_ = vala_ccode_identifier_new ("NULL");
									_tmp991_ = _tmp990_;
									_tmp992_ = closure_new;
									_tmp993_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp989_, (ValaCCodeExpression*) _tmp991_, (ValaCCodeExpression*) _tmp992_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp993_;
									_vala_ccode_node_unref0 (_tmp991_);
									_vala_ccode_node_unref0 (_tmp989_);
									_vala_ccode_node_unref0 (_tmp987_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp994_;
									ValaParameter* _tmp995_;
									ValaCCodeExpression* _tmp996_;
									ValaDelegateType* _tmp997_;
									_tmp994_ = carg_map;
									_tmp995_ = param;
									_tmp996_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp994_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp995_), FALSE)), _tmp996_);
									_tmp997_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp997_)) {
										ValaCCodeExpression* _tmp998_;
										ValaHashMap* _tmp999_;
										ValaParameter* _tmp1000_;
										ValaCCodeExpression* _tmp1001_;
										_tmp998_ = delegate_target_destroy_notify;
										_vala_assert (_tmp998_ != NULL, "delegate_target_destroy_notify != null");
										_tmp999_ = carg_map;
										_tmp1000_ = param;
										_tmp1001_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp999_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1000_) + 0.01, FALSE)), _tmp1001_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1002_;
							ValaDataType* _tmp1003_;
							ValaDataType* _tmp1004_;
							_tmp1002_ = param;
							_tmp1003_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1002_);
							_tmp1004_ = _tmp1003_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1004_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1005_;
								ValaParameter* _tmp1006_;
								ValaExpression* _tmp1007_;
								ValaCCodeExpression* _tmp1008_ = NULL;
								ValaCCodeExpression* _tmp1009_;
								ValaCCodeExpression* _tmp1010_;
								_tmp1005_ = carg_map;
								_tmp1006_ = param;
								_tmp1007_ = arg;
								_tmp1009_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1007_, &_tmp1008_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1008_;
								_tmp1010_ = _tmp1009_;
								vala_map_set ((ValaMap*) _tmp1005_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1006_), FALSE)), _tmp1010_);
								_vala_ccode_node_unref0 (_tmp1010_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1011_;
								ValaDataType* _tmp1012_;
								ValaDataType* _tmp1013_;
								_tmp1011_ = param;
								_tmp1012_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1011_);
								_tmp1013_ = _tmp1012_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1013_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1014_ = FALSE;
									ValaMethod* _tmp1015_;
									_tmp1015_ = m;
									if (_tmp1015_ != NULL) {
										ValaMethod* _tmp1016_;
										_tmp1016_ = m;
										_tmp1014_ = vala_get_ccode_simple_generics (_tmp1016_);
									} else {
										_tmp1014_ = FALSE;
									}
									if (_tmp1014_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1017_;
										ValaDataType* _tmp1018_;
										ValaDataType* _tmp1019_;
										ValaGenericType* _tmp1020_;
										gint type_param_index = 0;
										ValaMethod* _tmp1021_;
										ValaGenericType* _tmp1022_;
										ValaTypeParameter* _tmp1023_;
										ValaTypeParameter* _tmp1024_;
										const gchar* _tmp1025_;
										const gchar* _tmp1026_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1027_;
										ValaList* _tmp1028_;
										ValaList* _tmp1029_;
										gpointer _tmp1030_;
										ValaDataType* _tmp1031_;
										ValaParameter* _tmp1032_;
										ValaDataType* _tmp1033_;
										ValaDataType* _tmp1034_;
										gboolean _tmp1035_;
										gboolean _tmp1036_;
										_tmp1017_ = param;
										_tmp1018_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1017_);
										_tmp1019_ = _tmp1018_;
										_tmp1020_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1019_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1020_;
										_tmp1021_ = m;
										_tmp1022_ = generic_type;
										_tmp1023_ = vala_generic_type_get_type_parameter (_tmp1022_);
										_tmp1024_ = _tmp1023_;
										_tmp1025_ = vala_symbol_get_name ((ValaSymbol*) _tmp1024_);
										_tmp1026_ = _tmp1025_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1021_, _tmp1026_);
										_tmp1027_ = ma;
										_tmp1028_ = vala_member_access_get_type_arguments (_tmp1027_);
										_tmp1029_ = _tmp1028_;
										_tmp1030_ = vala_list_get (_tmp1029_, type_param_index);
										_tmp1031_ = (ValaDataType*) _tmp1030_;
										_vala_iterable_unref0 (_tmp1029_);
										type_arg = _tmp1031_;
										_tmp1032_ = param;
										_tmp1033_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1032_);
										_tmp1034_ = _tmp1033_;
										_tmp1035_ = vala_data_type_get_value_owned (_tmp1034_);
										_tmp1036_ = _tmp1035_;
										if (_tmp1036_) {
											ValaDataType* _tmp1037_;
											_tmp1037_ = type_arg;
											if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1037_)) {
												ValaHashMap* _tmp1038_;
												ValaParameter* _tmp1039_;
												ValaDataType* _tmp1040_;
												ValaCCodeExpression* _tmp1041_;
												ValaCCodeExpression* _tmp1042_;
												_tmp1038_ = carg_map;
												_tmp1039_ = param;
												_tmp1040_ = type_arg;
												_tmp1041_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1040_, FALSE);
												_tmp1042_ = _tmp1041_;
												vala_map_set ((ValaMap*) _tmp1038_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1039_), FALSE)), _tmp1042_);
												_vala_ccode_node_unref0 (_tmp1042_);
											} else {
												ValaHashMap* _tmp1043_;
												ValaParameter* _tmp1044_;
												ValaCCodeConstant* _tmp1045_;
												ValaCCodeConstant* _tmp1046_;
												_tmp1043_ = carg_map;
												_tmp1044_ = param;
												_tmp1045_ = vala_ccode_constant_new ("NULL");
												_tmp1046_ = _tmp1045_;
												vala_map_set ((ValaMap*) _tmp1043_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1044_), FALSE)), (ValaCCodeExpression*) _tmp1046_);
												_vala_ccode_node_unref0 (_tmp1046_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1047_ = param;
					_tmp1048_ = arg;
					_tmp1049_ = cexpr;
					_tmp1050_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1047_, _tmp1048_, _tmp1049_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1050_;
				} else {
					ValaExpression* _tmp1051_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1052_;
					ValaDataType* _tmp1053_;
					ValaDataType* _tmp1054_;
					ValaParameter* _tmp1055_;
					ValaDataType* _tmp1056_;
					ValaDataType* _tmp1057_;
					gboolean _tmp1058_;
					gboolean _tmp1059_;
					ValaLocalVariable* _tmp1060_;
					ValaLocalVariable* _tmp1061_;
					ValaExpression* _tmp1062_;
					ValaLocalVariable* _tmp1063_;
					const gchar* _tmp1064_;
					const gchar* _tmp1065_;
					ValaCCodeExpression* _tmp1066_;
					ValaCCodeExpression* _tmp1067_;
					ValaExpression* _tmp1068_;
					ValaTargetValue* _tmp1069_;
					ValaTargetValue* _tmp1070_;
					ValaExpression* _tmp1071_;
					ValaDataType* _tmp1072_;
					ValaDataType* _tmp1073_;
					ValaExpression* _tmp1074_;
					ValaCCodeExpression* _tmp1075_;
					ValaCCodeExpression* _tmp1076_;
					ValaCCodeUnaryExpression* _tmp1077_;
					gboolean _tmp1078_ = FALSE;
					gboolean _tmp1079_ = FALSE;
					ValaParameter* _tmp1080_;
					_tmp1051_ = arg;
					vala_expression_set_target_value (_tmp1051_, NULL);
					_tmp1052_ = param;
					_tmp1053_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1052_);
					_tmp1054_ = _tmp1053_;
					_tmp1055_ = param;
					_tmp1056_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1055_);
					_tmp1057_ = _tmp1056_;
					_tmp1058_ = vala_data_type_get_value_owned (_tmp1057_);
					_tmp1059_ = _tmp1058_;
					_tmp1060_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1054_, _tmp1059_, NULL, TRUE);
					temp_var = _tmp1060_;
					_tmp1061_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1061_, FALSE);
					_tmp1062_ = arg;
					_tmp1063_ = temp_var;
					_tmp1064_ = vala_symbol_get_name ((ValaSymbol*) _tmp1063_);
					_tmp1065_ = _tmp1064_;
					_tmp1066_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1065_);
					_tmp1067_ = _tmp1066_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1062_, _tmp1067_);
					_vala_ccode_node_unref0 (_tmp1067_);
					_tmp1068_ = arg;
					_tmp1069_ = vala_expression_get_target_value (_tmp1068_);
					_tmp1070_ = _tmp1069_;
					_tmp1071_ = arg;
					_tmp1072_ = vala_expression_get_target_type (_tmp1071_);
					_tmp1073_ = _tmp1072_;
					vala_target_value_set_value_type (_tmp1070_, _tmp1073_);
					_tmp1074_ = arg;
					_tmp1075_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1074_);
					_tmp1076_ = _tmp1075_;
					_tmp1077_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1076_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1077_;
					_vala_ccode_node_unref0 (_tmp1076_);
					_tmp1080_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1080_)) {
						ValaParameter* _tmp1081_;
						ValaDataType* _tmp1082_;
						ValaDataType* _tmp1083_;
						_tmp1081_ = param;
						_tmp1082_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1081_);
						_tmp1083_ = _tmp1082_;
						_tmp1079_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1083_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1079_ = FALSE;
					}
					if (_tmp1079_) {
						ValaParameter* _tmp1084_;
						ValaDataType* _tmp1085_;
						ValaDataType* _tmp1086_;
						gboolean _tmp1087_;
						gboolean _tmp1088_;
						_tmp1084_ = param;
						_tmp1085_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1084_);
						_tmp1086_ = _tmp1085_;
						_tmp1087_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1086_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1088_ = _tmp1087_;
						_tmp1078_ = !_tmp1088_;
					} else {
						_tmp1078_ = FALSE;
					}
					if (_tmp1078_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1089_;
						ValaDataType* _tmp1090_;
						ValaDataType* _tmp1091_;
						ValaArrayType* _tmp1092_;
						gchar* _tmp1093_ = NULL;
						ValaParameter* _tmp1094_;
						gchar* _tmp1095_;
						gchar* length_ctype = NULL;
						gchar* _tmp1098_;
						_tmp1089_ = param;
						_tmp1090_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1089_);
						_tmp1091_ = _tmp1090_;
						_tmp1092_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1091_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1092_;
						_tmp1094_ = param;
						_tmp1095_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1094_);
						_tmp1093_ = _tmp1095_;
						if (_tmp1093_ == NULL) {
							ValaArrayType* _tmp1096_;
							gchar* _tmp1097_;
							_tmp1096_ = array_type;
							_tmp1097_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1096_);
							_g_free0 (_tmp1093_);
							_tmp1093_ = _tmp1097_;
						}
						_tmp1098_ = g_strdup (_tmp1093_);
						length_ctype = _tmp1098_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1099_ = FALSE;
								_tmp1099_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1101_;
									gint _tmp1102_;
									gint _tmp1103_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1104_;
									ValaCType* _tmp1105_;
									ValaCType* _tmp1106_;
									ValaLocalVariable* _tmp1107_;
									ValaLocalVariable* _tmp1108_;
									ValaLocalVariable* _tmp1109_;
									ValaExpression* _tmp1110_;
									ValaLocalVariable* _tmp1111_;
									const gchar* _tmp1112_;
									const gchar* _tmp1113_;
									ValaCCodeExpression* _tmp1114_;
									ValaCCodeExpression* _tmp1115_;
									ValaHashMap* _tmp1116_;
									ValaParameter* _tmp1117_;
									ValaExpression* _tmp1118_;
									ValaList* _tmp1119_;
									ValaList* _tmp1120_;
									gpointer _tmp1121_;
									ValaCCodeExpression* _tmp1122_;
									ValaCCodeUnaryExpression* _tmp1123_;
									ValaCCodeUnaryExpression* _tmp1124_;
									if (!_tmp1099_) {
										gint _tmp1100_;
										_tmp1100_ = dim;
										dim = _tmp1100_ + 1;
									}
									_tmp1099_ = FALSE;
									_tmp1101_ = array_type;
									_tmp1102_ = vala_array_type_get_rank (_tmp1101_);
									_tmp1103_ = _tmp1102_;
									if (!(dim <= _tmp1103_)) {
										break;
									}
									_tmp1104_ = length_ctype;
									_tmp1105_ = vala_ctype_new (_tmp1104_, "0");
									_tmp1106_ = _tmp1105_;
									_tmp1107_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1106_, TRUE, NULL, TRUE);
									_tmp1108_ = _tmp1107_;
									_vala_code_node_unref0 (_tmp1106_);
									temp_array_length = _tmp1108_;
									_tmp1109_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1109_, FALSE);
									_tmp1110_ = arg;
									_tmp1111_ = temp_array_length;
									_tmp1112_ = vala_symbol_get_name ((ValaSymbol*) _tmp1111_);
									_tmp1113_ = _tmp1112_;
									_tmp1114_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1113_);
									_tmp1115_ = _tmp1114_;
									vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1110_, _tmp1115_);
									_vala_ccode_node_unref0 (_tmp1115_);
									_tmp1116_ = carg_map;
									_tmp1117_ = param;
									_tmp1118_ = arg;
									_tmp1119_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1118_);
									_tmp1120_ = _tmp1119_;
									_tmp1121_ = vala_list_get (_tmp1120_, dim - 1);
									_tmp1122_ = (ValaCCodeExpression*) _tmp1121_;
									_tmp1123_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1122_);
									_tmp1124_ = _tmp1123_;
									vala_map_set ((ValaMap*) _tmp1116_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1117_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1124_);
									_vala_ccode_node_unref0 (_tmp1124_);
									_vala_ccode_node_unref0 (_tmp1122_);
									_vala_iterable_unref0 (_tmp1120_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp1093_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp1125_;
						ValaDataType* _tmp1126_;
						ValaDataType* _tmp1127_;
						_tmp1125_ = param;
						_tmp1126_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1125_);
						_tmp1127_ = _tmp1126_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1127_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1128_;
							ValaDataType* _tmp1129_;
							ValaDataType* _tmp1130_;
							ValaDelegateType* _tmp1131_;
							ValaDelegateType* _tmp1132_;
							ValaDelegate* _tmp1133_;
							ValaDelegate* _tmp1134_;
							gboolean _tmp1135_;
							gboolean _tmp1136_;
							_tmp1128_ = param;
							_tmp1129_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1128_);
							_tmp1130_ = _tmp1129_;
							_tmp1131_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1130_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1131_;
							_tmp1132_ = deleg_type;
							_tmp1133_ = vala_delegate_type_get_delegate_symbol (_tmp1132_);
							_tmp1134_ = _tmp1133_;
							_tmp1135_ = vala_delegate_get_has_target (_tmp1134_);
							_tmp1136_ = _tmp1135_;
							if (_tmp1136_) {
								ValaVoidType* _tmp1137_;
								ValaVoidType* _tmp1138_;
								ValaPointerType* _tmp1139_;
								ValaPointerType* _tmp1140_;
								ValaLocalVariable* _tmp1141_;
								ValaLocalVariable* _tmp1142_;
								ValaExpression* _tmp1143_;
								ValaLocalVariable* _tmp1144_;
								const gchar* _tmp1145_;
								const gchar* _tmp1146_;
								ValaCCodeExpression* _tmp1147_;
								ValaCCodeExpression* _tmp1148_;
								ValaHashMap* _tmp1149_;
								ValaParameter* _tmp1150_;
								ValaExpression* _tmp1151_;
								ValaCCodeExpression* _tmp1152_;
								ValaCCodeExpression* _tmp1153_;
								ValaCCodeUnaryExpression* _tmp1154_;
								ValaCCodeUnaryExpression* _tmp1155_;
								ValaDelegateType* _tmp1156_;
								_tmp1137_ = vala_void_type_new (NULL);
								_tmp1138_ = _tmp1137_;
								_tmp1139_ = vala_pointer_type_new ((ValaDataType*) _tmp1138_, NULL);
								_tmp1140_ = _tmp1139_;
								_tmp1141_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1140_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1141_;
								_vala_code_node_unref0 (_tmp1140_);
								_vala_code_node_unref0 (_tmp1138_);
								_tmp1142_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1142_, FALSE);
								_tmp1143_ = arg;
								_tmp1144_ = temp_var;
								_tmp1145_ = vala_symbol_get_name ((ValaSymbol*) _tmp1144_);
								_tmp1146_ = _tmp1145_;
								_tmp1147_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1146_);
								_tmp1148_ = _tmp1147_;
								vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1143_, _tmp1148_);
								_vala_ccode_node_unref0 (_tmp1148_);
								_tmp1149_ = carg_map;
								_tmp1150_ = param;
								_tmp1151_ = arg;
								_tmp1152_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1151_);
								_tmp1153_ = _tmp1152_;
								_tmp1154_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1153_);
								_tmp1155_ = _tmp1154_;
								vala_map_set ((ValaMap*) _tmp1149_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1150_), FALSE)), (ValaCCodeExpression*) _tmp1155_);
								_vala_ccode_node_unref0 (_tmp1155_);
								_vala_ccode_node_unref0 (_tmp1153_);
								_tmp1156_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1156_)) {
									ValaDataType* _tmp1157_;
									ValaLocalVariable* _tmp1158_;
									ValaLocalVariable* _tmp1159_;
									ValaExpression* _tmp1160_;
									ValaLocalVariable* _tmp1161_;
									const gchar* _tmp1162_;
									const gchar* _tmp1163_;
									ValaCCodeExpression* _tmp1164_;
									ValaCCodeExpression* _tmp1165_;
									ValaHashMap* _tmp1166_;
									ValaParameter* _tmp1167_;
									ValaExpression* _tmp1168_;
									ValaCCodeExpression* _tmp1169_;
									ValaCCodeExpression* _tmp1170_;
									ValaCCodeUnaryExpression* _tmp1171_;
									ValaCCodeUnaryExpression* _tmp1172_;
									_tmp1157_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1158_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1157_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1158_;
									_tmp1159_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1159_, FALSE);
									_tmp1160_ = arg;
									_tmp1161_ = temp_var;
									_tmp1162_ = vala_symbol_get_name ((ValaSymbol*) _tmp1161_);
									_tmp1163_ = _tmp1162_;
									_tmp1164_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1163_);
									_tmp1165_ = _tmp1164_;
									vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1160_, _tmp1165_);
									_vala_ccode_node_unref0 (_tmp1165_);
									_tmp1166_ = carg_map;
									_tmp1167_ = param;
									_tmp1168_ = arg;
									_tmp1169_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1168_);
									_tmp1170_ = _tmp1169_;
									_tmp1171_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1170_);
									_tmp1172_ = _tmp1171_;
									vala_map_set ((ValaMap*) _tmp1166_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1167_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1172_);
									_vala_ccode_node_unref0 (_tmp1172_);
									_vala_ccode_node_unref0 (_tmp1170_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1173_ = param;
				_tmp1174_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1173_);
				_tmp1175_ = _tmp1174_;
				_tmp1176_ = _tmp1175_ != NULL;
				_g_free0 (_tmp1175_);
				if (_tmp1176_) {
					ValaCCodeExpression* _tmp1177_;
					ValaParameter* _tmp1178_;
					gchar* _tmp1179_;
					gchar* _tmp1180_;
					ValaCCodeCastExpression* _tmp1181_;
					_tmp1177_ = cexpr;
					_tmp1178_ = param;
					_tmp1179_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1178_);
					_tmp1180_ = _tmp1179_;
					_tmp1181_ = vala_ccode_cast_expression_new (_tmp1177_, _tmp1180_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1181_;
					_g_free0 (_tmp1180_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1182_;
				ValaUnaryExpression* _tmp1183_;
				gboolean _tmp1184_ = FALSE;
				gboolean _tmp1185_ = FALSE;
				_tmp1182_ = arg;
				_tmp1183_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1182_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1182_) : NULL);
				unary = _tmp1183_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1186_;
					_tmp1186_ = unary;
					_tmp1185_ = _tmp1186_ != NULL;
				} else {
					_tmp1185_ = FALSE;
				}
				if (_tmp1185_) {
					ValaUnaryExpression* _tmp1187_;
					ValaUnaryOperator _tmp1188_;
					ValaUnaryOperator _tmp1189_;
					_tmp1187_ = unary;
					_tmp1188_ = vala_unary_expression_get_operator (_tmp1187_);
					_tmp1189_ = _tmp1188_;
					_tmp1184_ = _tmp1189_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1184_ = FALSE;
				}
				if (_tmp1184_) {
					ValaHashMap* _tmp1190_;
					ValaHashMap* _tmp1191_;
					ValaExpression* _tmp1192_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1193_;
					ValaDataType* _tmp1194_;
					ValaDataType* _tmp1195_;
					ValaExpression* _tmp1196_;
					ValaDataType* _tmp1197_;
					ValaDataType* _tmp1198_;
					gboolean _tmp1199_;
					gboolean _tmp1200_;
					ValaLocalVariable* _tmp1201_;
					ValaLocalVariable* _tmp1202_;
					ValaExpression* _tmp1203_;
					ValaLocalVariable* _tmp1204_;
					const gchar* _tmp1205_;
					const gchar* _tmp1206_;
					ValaCCodeExpression* _tmp1207_;
					ValaCCodeExpression* _tmp1208_;
					ValaExpression* _tmp1209_;
					ValaTargetValue* _tmp1210_;
					ValaTargetValue* _tmp1211_;
					ValaExpression* _tmp1212_;
					ValaDataType* _tmp1213_;
					ValaDataType* _tmp1214_;
					ValaExpression* _tmp1215_;
					ValaCCodeExpression* _tmp1216_;
					ValaCCodeExpression* _tmp1217_;
					ValaCCodeUnaryExpression* _tmp1218_;
					_tmp1190_ = out_arg_map;
					_tmp1191_ = _vala_map_ref0 (_tmp1190_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1191_;
					_tmp1192_ = arg;
					vala_expression_set_target_value (_tmp1192_, NULL);
					_tmp1193_ = arg;
					_tmp1194_ = vala_expression_get_value_type (_tmp1193_);
					_tmp1195_ = _tmp1194_;
					_tmp1196_ = arg;
					_tmp1197_ = vala_expression_get_value_type (_tmp1196_);
					_tmp1198_ = _tmp1197_;
					_tmp1199_ = vala_data_type_get_value_owned (_tmp1198_);
					_tmp1200_ = _tmp1199_;
					_tmp1201_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1195_, _tmp1200_, NULL, TRUE);
					temp_var = _tmp1201_;
					_tmp1202_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1202_, FALSE);
					_tmp1203_ = arg;
					_tmp1204_ = temp_var;
					_tmp1205_ = vala_symbol_get_name ((ValaSymbol*) _tmp1204_);
					_tmp1206_ = _tmp1205_;
					_tmp1207_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1206_);
					_tmp1208_ = _tmp1207_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1203_, _tmp1208_);
					_vala_ccode_node_unref0 (_tmp1208_);
					_tmp1209_ = arg;
					_tmp1210_ = vala_expression_get_target_value (_tmp1209_);
					_tmp1211_ = _tmp1210_;
					_tmp1212_ = arg;
					_tmp1213_ = vala_expression_get_value_type (_tmp1212_);
					_tmp1214_ = _tmp1213_;
					vala_target_value_set_value_type (_tmp1211_, _tmp1214_);
					_tmp1215_ = arg;
					_tmp1216_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1215_);
					_tmp1217_ = _tmp1216_;
					_tmp1218_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1217_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1218_;
					_vala_ccode_node_unref0 (_tmp1217_);
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1219_;
					ValaCCodeExpression* _tmp1220_;
					ValaCCodeExpression* _tmp1221_;
					_tmp1219_ = arg;
					_tmp1220_ = cexpr;
					_tmp1221_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1219_, _tmp1220_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1221_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1224_ = param;
			if (_tmp1224_ != NULL) {
				_tmp1223_ = !ellipsis;
			} else {
				_tmp1223_ = FALSE;
			}
			if (_tmp1223_) {
				ValaParameter* _tmp1225_;
				_tmp1225_ = param;
				_tmp1222_ = vala_get_ccode_pos (_tmp1225_);
			} else {
				_tmp1222_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1222_, ellipsis);
			_tmp1226_ = carg_map;
			_tmp1227_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1226_, (gpointer) ((gintptr) arg_pos), _tmp1227_);
			_tmp1229_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1229_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1228_ = ellipsis;
			} else {
				_tmp1228_ = FALSE;
			}
			if (_tmp1228_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1230_;
				ValaNamedArgument* _tmp1231_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1232_;
				const gchar* _tmp1233_;
				const gchar* _tmp1234_;
				gchar** _tmp1235_;
				gchar** _tmp1236_;
				gchar** _tmp1237_;
				gint _tmp1237__length1;
				gchar* _tmp1238_;
				gchar* _tmp1239_;
				ValaHashMap* _tmp1240_;
				const gchar* _tmp1241_;
				gchar* _tmp1242_;
				gchar* _tmp1243_;
				ValaCCodeConstant* _tmp1244_;
				ValaCCodeConstant* _tmp1245_;
				_tmp1230_ = arg;
				_tmp1231_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1230_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1231_;
				_tmp1232_ = named_arg;
				_tmp1233_ = vala_named_argument_get_name (_tmp1232_);
				_tmp1234_ = _tmp1233_;
				_tmp1236_ = _tmp1235_ = g_strsplit (_tmp1234_, "_", 0);
				_tmp1237_ = _tmp1236_;
				_tmp1237__length1 = _vala_array_length (_tmp1235_);
				_tmp1238_ = _vala_g_strjoinv ("-", _tmp1237_, (gint) _vala_array_length (_tmp1235_));
				_tmp1239_ = _tmp1238_;
				_tmp1237_ = (_vala_array_free (_tmp1237_, _tmp1237__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1239_;
				_tmp1240_ = carg_map;
				_tmp1241_ = name;
				_tmp1242_ = g_strdup_printf ("\"%s\"", _tmp1241_);
				_tmp1243_ = _tmp1242_;
				_tmp1244_ = vala_ccode_constant_new (_tmp1243_);
				_tmp1245_ = _tmp1244_;
				vala_map_set ((ValaMap*) _tmp1240_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1245_);
				_vala_ccode_node_unref0 (_tmp1245_);
				_g_free0 (_tmp1243_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1246_ = i;
			i = _tmp1246_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1247_ = params_it;
	if (vala_iterator_next (_tmp1247_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1248_;
		gpointer _tmp1249_;
		gboolean _tmp1250_ = FALSE;
		ValaParameter* _tmp1251_;
		gboolean _tmp1252_;
		gboolean _tmp1253_;
		_tmp1248_ = params_it;
		_tmp1249_ = vala_iterator_get (_tmp1248_);
		param = (ValaParameter*) _tmp1249_;
		_tmp1251_ = param;
		_tmp1252_ = vala_parameter_get_params_array (_tmp1251_);
		_tmp1253_ = _tmp1252_;
		if (_tmp1253_) {
			_tmp1250_ = TRUE;
		} else {
			ValaParameter* _tmp1254_;
			gboolean _tmp1255_;
			gboolean _tmp1256_;
			_tmp1254_ = param;
			_tmp1255_ = vala_parameter_get_ellipsis (_tmp1254_);
			_tmp1256_ = _tmp1255_;
			_tmp1250_ = _tmp1256_;
		}
		_vala_assert (_tmp1250_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1259_ = m;
	if (_tmp1259_ != NULL) {
		ValaMethod* _tmp1260_;
		ValaDataType* _tmp1261_;
		ValaDataType* _tmp1262_;
		_tmp1260_ = m;
		_tmp1261_ = vala_callable_get_return_type ((ValaCallable*) _tmp1260_);
		_tmp1262_ = _tmp1261_;
		_tmp1258_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1262_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1258_ = FALSE;
	}
	if (_tmp1258_) {
		ValaCCodeFunctionCall* _tmp1263_;
		ValaCCodeFunctionCall* _tmp1264_;
		_tmp1263_ = async_call;
		_tmp1264_ = ccall;
		_tmp1257_ = _tmp1263_ != _tmp1264_;
	} else {
		_tmp1257_ = FALSE;
	}
	if (_tmp1257_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1265_;
		ValaDataType* _tmp1266_;
		ValaDataType* _tmp1267_;
		ValaArrayType* _tmp1268_;
		_tmp1265_ = m;
		_tmp1266_ = vala_callable_get_return_type ((ValaCallable*) _tmp1265_);
		_tmp1267_ = _tmp1266_;
		_tmp1268_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1267_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1268_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1269_ = FALSE;
				_tmp1269_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1271_;
					gint _tmp1272_;
					gint _tmp1273_;
					ValaMethod* _tmp1274_;
					if (!_tmp1269_) {
						gint _tmp1270_;
						_tmp1270_ = dim;
						dim = _tmp1270_ + 1;
					}
					_tmp1269_ = FALSE;
					_tmp1271_ = array_type;
					_tmp1272_ = vala_array_type_get_rank (_tmp1271_);
					_tmp1273_ = _tmp1272_;
					if (!(dim <= _tmp1273_)) {
						break;
					}
					_tmp1274_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1274_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1275_;
						ValaDataType* _tmp1276_;
						ValaDataType* _tmp1277_;
						ValaLocalVariable* _tmp1278_;
						ValaLocalVariable* _tmp1279_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1280_;
						const gchar* _tmp1281_;
						const gchar* _tmp1282_;
						ValaCCodeExpression* _tmp1283_;
						ValaLocalVariable* _tmp1284_;
						ValaCCodeExpression* _tmp1285_;
						ValaCCodeExpression* _tmp1286_;
						ValaCCodeAssignment* _tmp1287_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1288_;
						ValaCCodeIdentifier* _tmp1289_;
						ValaCCodeFunctionCall* _tmp1290_;
						ValaCCodeFunctionCall* _tmp1291_;
						ValaCCodeFunctionCall* _tmp1292_;
						ValaCCodeExpression* _tmp1293_;
						ValaCCodeFunctionCall* _tmp1294_;
						_tmp1275_ = itype;
						_tmp1276_ = vala_data_type_get_return_type (_tmp1275_);
						_tmp1277_ = _tmp1276_;
						_tmp1278_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1277_, TRUE, NULL, FALSE);
						_tmp1279_ = _tmp1278_;
						_vala_code_node_unref0 (_tmp1277_);
						temp_var = _tmp1279_;
						_tmp1280_ = temp_var;
						_tmp1281_ = vala_symbol_get_name ((ValaSymbol*) _tmp1280_);
						_tmp1282_ = _tmp1281_;
						_tmp1283_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1282_);
						temp_ref = _tmp1283_;
						_tmp1284_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1284_, FALSE);
						_tmp1285_ = temp_ref;
						_tmp1286_ = ccall_expr;
						_tmp1287_ = vala_ccode_assignment_new (_tmp1285_, _tmp1286_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1287_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1288_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1289_ = _tmp1288_;
						_tmp1290_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1289_);
						_tmp1291_ = _tmp1290_;
						_vala_ccode_node_unref0 (_tmp1289_);
						len_call = _tmp1291_;
						_tmp1292_ = len_call;
						_tmp1293_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1292_, _tmp1293_);
						_tmp1294_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1294_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1295_;
						_tmp1295_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1295_)) {
							gchar* _tmp1296_ = NULL;
							ValaMethod* _tmp1297_;
							gchar* _tmp1298_;
							gchar* length_ctype = NULL;
							gchar* _tmp1301_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1302_;
							ValaCType* _tmp1303_;
							ValaCType* _tmp1304_;
							ValaLocalVariable* _tmp1305_;
							ValaLocalVariable* _tmp1306_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1307_;
							const gchar* _tmp1308_;
							const gchar* _tmp1309_;
							ValaCCodeExpression* _tmp1310_;
							ValaLocalVariable* _tmp1311_;
							ValaHashMap* _tmp1312_;
							ValaMethod* _tmp1313_;
							ValaCCodeExpression* _tmp1314_;
							ValaCCodeUnaryExpression* _tmp1315_;
							ValaCCodeUnaryExpression* _tmp1316_;
							ValaCCodeExpression* _tmp1317_;
							_tmp1297_ = m;
							_tmp1298_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1297_);
							_tmp1296_ = _tmp1298_;
							if (_tmp1296_ == NULL) {
								ValaArrayType* _tmp1299_;
								gchar* _tmp1300_;
								_tmp1299_ = array_type;
								_tmp1300_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1299_);
								_g_free0 (_tmp1296_);
								_tmp1296_ = _tmp1300_;
							}
							_tmp1301_ = g_strdup (_tmp1296_);
							length_ctype = _tmp1301_;
							_tmp1302_ = length_ctype;
							_tmp1303_ = vala_ctype_new (_tmp1302_, "0");
							_tmp1304_ = _tmp1303_;
							_tmp1305_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1304_, TRUE, NULL, TRUE);
							_tmp1306_ = _tmp1305_;
							_vala_code_node_unref0 (_tmp1304_);
							temp_var = _tmp1306_;
							_tmp1307_ = temp_var;
							_tmp1308_ = vala_symbol_get_name ((ValaSymbol*) _tmp1307_);
							_tmp1309_ = _tmp1308_;
							_tmp1310_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1309_);
							temp_ref = _tmp1310_;
							_tmp1311_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1311_, FALSE);
							_tmp1312_ = out_arg_map;
							_tmp1313_ = m;
							_tmp1314_ = temp_ref;
							_tmp1315_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1314_);
							_tmp1316_ = _tmp1315_;
							vala_map_set ((ValaMap*) _tmp1312_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1313_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1316_);
							_vala_ccode_node_unref0 (_tmp1316_);
							_tmp1317_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1317_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
							_g_free0 (_tmp1296_);
						} else {
							ValaMethod* _tmp1318_;
							gchar* _tmp1319_;
							gchar* _tmp1320_;
							gboolean _tmp1321_;
							_tmp1318_ = m;
							_tmp1319_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1318_);
							_tmp1320_ = _tmp1319_;
							_tmp1321_ = _tmp1320_ != NULL;
							_g_free0 (_tmp1320_);
							if (_tmp1321_) {
								ValaMethod* _tmp1322_;
								gchar* _tmp1323_;
								gchar* _tmp1324_;
								ValaCCodeConstant* _tmp1325_;
								ValaCCodeConstant* _tmp1326_;
								_tmp1322_ = m;
								_tmp1323_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1322_);
								_tmp1324_ = _tmp1323_;
								_tmp1325_ = vala_ccode_constant_new (_tmp1324_);
								_tmp1326_ = _tmp1325_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1326_);
								_vala_ccode_node_unref0 (_tmp1326_);
								_g_free0 (_tmp1324_);
							} else {
								ValaCCodeConstant* _tmp1327_;
								ValaCCodeConstant* _tmp1328_;
								_tmp1327_ = vala_ccode_constant_new ("-1");
								_tmp1328_ = _tmp1327_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1328_);
								_vala_ccode_node_unref0 (_tmp1328_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1329_ = FALSE;
		gboolean _tmp1330_ = FALSE;
		ValaMethod* _tmp1331_;
		_tmp1331_ = m;
		if (_tmp1331_ != NULL) {
			ValaMethod* _tmp1332_;
			ValaDataType* _tmp1333_;
			ValaDataType* _tmp1334_;
			_tmp1332_ = m;
			_tmp1333_ = vala_callable_get_return_type ((ValaCallable*) _tmp1332_);
			_tmp1334_ = _tmp1333_;
			_tmp1330_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1334_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1330_ = FALSE;
		}
		if (_tmp1330_) {
			ValaCCodeFunctionCall* _tmp1335_;
			ValaCCodeFunctionCall* _tmp1336_;
			_tmp1335_ = async_call;
			_tmp1336_ = ccall;
			_tmp1329_ = _tmp1335_ != _tmp1336_;
		} else {
			_tmp1329_ = FALSE;
		}
		if (_tmp1329_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1337_;
			ValaDataType* _tmp1338_;
			ValaDataType* _tmp1339_;
			ValaDelegateType* _tmp1340_;
			ValaDelegateType* _tmp1341_;
			ValaDelegate* _tmp1342_;
			ValaDelegate* _tmp1343_;
			gboolean _tmp1344_;
			gboolean _tmp1345_;
			_tmp1337_ = m;
			_tmp1338_ = vala_callable_get_return_type ((ValaCallable*) _tmp1337_);
			_tmp1339_ = _tmp1338_;
			_tmp1340_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1339_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1340_;
			_tmp1341_ = deleg_type;
			_tmp1342_ = vala_delegate_type_get_delegate_symbol (_tmp1341_);
			_tmp1343_ = _tmp1342_;
			_tmp1344_ = vala_delegate_get_has_target (_tmp1343_);
			_tmp1345_ = _tmp1344_;
			if (_tmp1345_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1346_;
				ValaVoidType* _tmp1347_;
				ValaPointerType* _tmp1348_;
				ValaPointerType* _tmp1349_;
				ValaLocalVariable* _tmp1350_;
				ValaLocalVariable* _tmp1351_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1352_;
				const gchar* _tmp1353_;
				const gchar* _tmp1354_;
				ValaCCodeExpression* _tmp1355_;
				ValaLocalVariable* _tmp1356_;
				ValaHashMap* _tmp1357_;
				ValaMethod* _tmp1358_;
				ValaCCodeExpression* _tmp1359_;
				ValaCCodeUnaryExpression* _tmp1360_;
				ValaCCodeUnaryExpression* _tmp1361_;
				ValaCCodeExpression* _tmp1362_;
				ValaDelegateType* _tmp1363_;
				_tmp1346_ = vala_void_type_new (NULL);
				_tmp1347_ = _tmp1346_;
				_tmp1348_ = vala_pointer_type_new ((ValaDataType*) _tmp1347_, NULL);
				_tmp1349_ = _tmp1348_;
				_tmp1350_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1349_, TRUE, NULL, TRUE);
				_tmp1351_ = _tmp1350_;
				_vala_code_node_unref0 (_tmp1349_);
				_vala_code_node_unref0 (_tmp1347_);
				temp_var = _tmp1351_;
				_tmp1352_ = temp_var;
				_tmp1353_ = vala_symbol_get_name ((ValaSymbol*) _tmp1352_);
				_tmp1354_ = _tmp1353_;
				_tmp1355_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1354_);
				temp_ref = _tmp1355_;
				_tmp1356_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1356_, FALSE);
				_tmp1357_ = out_arg_map;
				_tmp1358_ = m;
				_tmp1359_ = temp_ref;
				_tmp1360_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1359_);
				_tmp1361_ = _tmp1360_;
				vala_map_set ((ValaMap*) _tmp1357_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1358_), FALSE)), (ValaCCodeExpression*) _tmp1361_);
				_vala_ccode_node_unref0 (_tmp1361_);
				_tmp1362_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1362_);
				_tmp1363_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1363_)) {
					ValaDataType* _tmp1364_;
					ValaLocalVariable* _tmp1365_;
					ValaLocalVariable* _tmp1366_;
					const gchar* _tmp1367_;
					const gchar* _tmp1368_;
					ValaCCodeExpression* _tmp1369_;
					ValaLocalVariable* _tmp1370_;
					ValaHashMap* _tmp1371_;
					ValaMethod* _tmp1372_;
					ValaCCodeExpression* _tmp1373_;
					ValaCCodeUnaryExpression* _tmp1374_;
					ValaCCodeUnaryExpression* _tmp1375_;
					ValaCCodeExpression* _tmp1376_;
					_tmp1364_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1365_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1364_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1365_;
					_tmp1366_ = temp_var;
					_tmp1367_ = vala_symbol_get_name ((ValaSymbol*) _tmp1366_);
					_tmp1368_ = _tmp1367_;
					_tmp1369_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1368_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1369_;
					_tmp1370_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1370_, FALSE);
					_tmp1371_ = out_arg_map;
					_tmp1372_ = m;
					_tmp1373_ = temp_ref;
					_tmp1374_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1373_);
					_tmp1375_ = _tmp1374_;
					vala_map_set ((ValaMap*) _tmp1371_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1372_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1375_);
					_vala_ccode_node_unref0 (_tmp1375_);
					_tmp1376_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1376_);
				} else {
					ValaCCodeConstant* _tmp1377_;
					ValaCCodeConstant* _tmp1378_;
					_tmp1377_ = vala_ccode_constant_new ("NULL");
					_tmp1378_ = _tmp1377_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1378_);
					_vala_ccode_node_unref0 (_tmp1378_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1379_;
				ValaCCodeConstant* _tmp1380_;
				_tmp1379_ = vala_ccode_constant_new ("NULL");
				_tmp1380_ = _tmp1379_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1380_);
				_vala_ccode_node_unref0 (_tmp1380_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1382_ = deleg;
	if (_tmp1382_ != NULL) {
		ValaDelegate* _tmp1383_;
		ValaDataType* _tmp1384_;
		ValaDataType* _tmp1385_;
		_tmp1383_ = deleg;
		_tmp1384_ = vala_callable_get_return_type ((ValaCallable*) _tmp1383_);
		_tmp1385_ = _tmp1384_;
		_tmp1381_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1385_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1381_ = FALSE;
	}
	if (_tmp1381_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1386_;
		ValaDataType* _tmp1387_;
		ValaDataType* _tmp1388_;
		ValaArrayType* _tmp1389_;
		_tmp1386_ = deleg;
		_tmp1387_ = vala_callable_get_return_type ((ValaCallable*) _tmp1386_);
		_tmp1388_ = _tmp1387_;
		_tmp1389_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1388_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1389_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1390_ = FALSE;
				_tmp1390_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1392_;
					gint _tmp1393_;
					gint _tmp1394_;
					ValaDelegate* _tmp1395_;
					if (!_tmp1390_) {
						gint _tmp1391_;
						_tmp1391_ = dim;
						dim = _tmp1391_ + 1;
					}
					_tmp1390_ = FALSE;
					_tmp1392_ = array_type;
					_tmp1393_ = vala_array_type_get_rank (_tmp1392_);
					_tmp1394_ = _tmp1393_;
					if (!(dim <= _tmp1394_)) {
						break;
					}
					_tmp1395_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1395_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1396_;
						ValaDataType* _tmp1397_;
						ValaDataType* _tmp1398_;
						ValaLocalVariable* _tmp1399_;
						ValaLocalVariable* _tmp1400_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1401_;
						const gchar* _tmp1402_;
						const gchar* _tmp1403_;
						ValaCCodeExpression* _tmp1404_;
						ValaLocalVariable* _tmp1405_;
						ValaCCodeExpression* _tmp1406_;
						ValaCCodeExpression* _tmp1407_;
						ValaCCodeAssignment* _tmp1408_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1409_;
						ValaCCodeIdentifier* _tmp1410_;
						ValaCCodeFunctionCall* _tmp1411_;
						ValaCCodeFunctionCall* _tmp1412_;
						ValaCCodeFunctionCall* _tmp1413_;
						ValaCCodeExpression* _tmp1414_;
						ValaCCodeFunctionCall* _tmp1415_;
						_tmp1396_ = itype;
						_tmp1397_ = vala_data_type_get_return_type (_tmp1396_);
						_tmp1398_ = _tmp1397_;
						_tmp1399_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1398_, TRUE, NULL, FALSE);
						_tmp1400_ = _tmp1399_;
						_vala_code_node_unref0 (_tmp1398_);
						temp_var = _tmp1400_;
						_tmp1401_ = temp_var;
						_tmp1402_ = vala_symbol_get_name ((ValaSymbol*) _tmp1401_);
						_tmp1403_ = _tmp1402_;
						_tmp1404_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1403_);
						temp_ref = _tmp1404_;
						_tmp1405_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1405_, FALSE);
						_tmp1406_ = temp_ref;
						_tmp1407_ = ccall_expr;
						_tmp1408_ = vala_ccode_assignment_new (_tmp1406_, _tmp1407_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1408_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1409_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1410_ = _tmp1409_;
						_tmp1411_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1410_);
						_tmp1412_ = _tmp1411_;
						_vala_ccode_node_unref0 (_tmp1410_);
						len_call = _tmp1412_;
						_tmp1413_ = len_call;
						_tmp1414_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1413_, _tmp1414_);
						_tmp1415_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1415_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1416_;
						_tmp1416_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1416_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaArrayType* _tmp1417_;
							ValaDataType* _tmp1418_;
							ValaDataType* _tmp1419_;
							ValaLocalVariable* _tmp1420_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1421_;
							const gchar* _tmp1422_;
							const gchar* _tmp1423_;
							ValaCCodeExpression* _tmp1424_;
							ValaLocalVariable* _tmp1425_;
							ValaHashMap* _tmp1426_;
							ValaDelegate* _tmp1427_;
							ValaCCodeExpression* _tmp1428_;
							ValaCCodeUnaryExpression* _tmp1429_;
							ValaCCodeUnaryExpression* _tmp1430_;
							ValaCCodeExpression* _tmp1431_;
							_tmp1417_ = array_type;
							_tmp1418_ = vala_array_type_get_length_type (_tmp1417_);
							_tmp1419_ = _tmp1418_;
							_tmp1420_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1419_, TRUE, NULL, TRUE);
							temp_var = _tmp1420_;
							_tmp1421_ = temp_var;
							_tmp1422_ = vala_symbol_get_name ((ValaSymbol*) _tmp1421_);
							_tmp1423_ = _tmp1422_;
							_tmp1424_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1423_);
							temp_ref = _tmp1424_;
							_tmp1425_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1425_, FALSE);
							_tmp1426_ = out_arg_map;
							_tmp1427_ = deleg;
							_tmp1428_ = temp_ref;
							_tmp1429_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1428_);
							_tmp1430_ = _tmp1429_;
							vala_map_set ((ValaMap*) _tmp1426_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1427_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1430_);
							_vala_ccode_node_unref0 (_tmp1430_);
							_tmp1431_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1431_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1432_;
							ValaCCodeConstant* _tmp1433_;
							_tmp1432_ = vala_ccode_constant_new ("-1");
							_tmp1433_ = _tmp1432_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1433_);
							_vala_ccode_node_unref0 (_tmp1433_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1434_ = FALSE;
		ValaDelegate* _tmp1435_;
		_tmp1435_ = deleg;
		if (_tmp1435_ != NULL) {
			ValaDelegate* _tmp1436_;
			ValaDataType* _tmp1437_;
			ValaDataType* _tmp1438_;
			_tmp1436_ = deleg;
			_tmp1437_ = vala_callable_get_return_type ((ValaCallable*) _tmp1436_);
			_tmp1438_ = _tmp1437_;
			_tmp1434_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1438_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1434_ = FALSE;
		}
		if (_tmp1434_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1439_;
			ValaDataType* _tmp1440_;
			ValaDataType* _tmp1441_;
			ValaDelegateType* _tmp1442_;
			ValaDelegateType* _tmp1443_;
			ValaDelegate* _tmp1444_;
			ValaDelegate* _tmp1445_;
			gboolean _tmp1446_;
			gboolean _tmp1447_;
			_tmp1439_ = deleg;
			_tmp1440_ = vala_callable_get_return_type ((ValaCallable*) _tmp1439_);
			_tmp1441_ = _tmp1440_;
			_tmp1442_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1441_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1442_;
			_tmp1443_ = deleg_type;
			_tmp1444_ = vala_delegate_type_get_delegate_symbol (_tmp1443_);
			_tmp1445_ = _tmp1444_;
			_tmp1446_ = vala_delegate_get_has_target (_tmp1445_);
			_tmp1447_ = _tmp1446_;
			if (_tmp1447_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1448_;
				ValaVoidType* _tmp1449_;
				ValaPointerType* _tmp1450_;
				ValaPointerType* _tmp1451_;
				ValaLocalVariable* _tmp1452_;
				ValaLocalVariable* _tmp1453_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1454_;
				const gchar* _tmp1455_;
				const gchar* _tmp1456_;
				ValaCCodeExpression* _tmp1457_;
				ValaLocalVariable* _tmp1458_;
				ValaHashMap* _tmp1459_;
				ValaDelegate* _tmp1460_;
				ValaCCodeExpression* _tmp1461_;
				ValaCCodeUnaryExpression* _tmp1462_;
				ValaCCodeUnaryExpression* _tmp1463_;
				ValaCCodeExpression* _tmp1464_;
				ValaDelegateType* _tmp1465_;
				_tmp1448_ = vala_void_type_new (NULL);
				_tmp1449_ = _tmp1448_;
				_tmp1450_ = vala_pointer_type_new ((ValaDataType*) _tmp1449_, NULL);
				_tmp1451_ = _tmp1450_;
				_tmp1452_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1451_, TRUE, NULL, TRUE);
				_tmp1453_ = _tmp1452_;
				_vala_code_node_unref0 (_tmp1451_);
				_vala_code_node_unref0 (_tmp1449_);
				temp_var = _tmp1453_;
				_tmp1454_ = temp_var;
				_tmp1455_ = vala_symbol_get_name ((ValaSymbol*) _tmp1454_);
				_tmp1456_ = _tmp1455_;
				_tmp1457_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1456_);
				temp_ref = _tmp1457_;
				_tmp1458_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1458_, FALSE);
				_tmp1459_ = out_arg_map;
				_tmp1460_ = deleg;
				_tmp1461_ = temp_ref;
				_tmp1462_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1461_);
				_tmp1463_ = _tmp1462_;
				vala_map_set ((ValaMap*) _tmp1459_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1460_), FALSE)), (ValaCCodeExpression*) _tmp1463_);
				_vala_ccode_node_unref0 (_tmp1463_);
				_tmp1464_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1464_);
				_tmp1465_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1465_)) {
					ValaDataType* _tmp1466_;
					ValaLocalVariable* _tmp1467_;
					ValaLocalVariable* _tmp1468_;
					const gchar* _tmp1469_;
					const gchar* _tmp1470_;
					ValaCCodeExpression* _tmp1471_;
					ValaLocalVariable* _tmp1472_;
					ValaHashMap* _tmp1473_;
					ValaDelegate* _tmp1474_;
					ValaCCodeExpression* _tmp1475_;
					ValaCCodeUnaryExpression* _tmp1476_;
					ValaCCodeUnaryExpression* _tmp1477_;
					ValaCCodeExpression* _tmp1478_;
					_tmp1466_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1467_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1466_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1467_;
					_tmp1468_ = temp_var;
					_tmp1469_ = vala_symbol_get_name ((ValaSymbol*) _tmp1468_);
					_tmp1470_ = _tmp1469_;
					_tmp1471_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1470_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1471_;
					_tmp1472_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1472_, FALSE);
					_tmp1473_ = out_arg_map;
					_tmp1474_ = deleg;
					_tmp1475_ = temp_ref;
					_tmp1476_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1475_);
					_tmp1477_ = _tmp1476_;
					vala_map_set ((ValaMap*) _tmp1473_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1474_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1477_);
					_vala_ccode_node_unref0 (_tmp1477_);
					_tmp1478_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1478_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1480_ = m;
	if (_tmp1480_ != NULL) {
		ValaMethod* _tmp1481_;
		gboolean _tmp1482_;
		gboolean _tmp1483_;
		_tmp1481_ = m;
		_tmp1482_ = vala_method_get_coroutine (_tmp1481_);
		_tmp1483_ = _tmp1482_;
		_tmp1479_ = _tmp1483_;
	} else {
		_tmp1479_ = FALSE;
	}
	if (_tmp1479_) {
		gboolean _tmp1484_;
		gboolean _tmp1485_;
		_tmp1484_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1485_ = _tmp1484_;
		if (_tmp1485_) {
			ValaHashMap* _tmp1486_;
			ValaMethod* _tmp1487_;
			ValaMethod* _tmp1488_;
			gchar* _tmp1489_;
			gchar* _tmp1490_;
			ValaCCodeIdentifier* _tmp1491_;
			ValaCCodeIdentifier* _tmp1492_;
			ValaHashMap* _tmp1493_;
			ValaCCodeIdentifier* _tmp1494_;
			ValaCCodeIdentifier* _tmp1495_;
			_tmp1486_ = in_arg_map;
			_tmp1487_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1488_ = _tmp1487_;
			_tmp1489_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1488_);
			_tmp1490_ = _tmp1489_;
			_tmp1491_ = vala_ccode_identifier_new (_tmp1490_);
			_tmp1492_ = _tmp1491_;
			vala_map_set ((ValaMap*) _tmp1486_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1492_);
			_vala_ccode_node_unref0 (_tmp1492_);
			_g_free0 (_tmp1490_);
			_tmp1493_ = in_arg_map;
			_tmp1494_ = vala_ccode_identifier_new ("_data_");
			_tmp1495_ = _tmp1494_;
			vala_map_set ((ValaMap*) _tmp1493_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1495_);
			_vala_ccode_node_unref0 (_tmp1495_);
		}
	}
	_tmp1496_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1497_ = _tmp1496_;
	if (_tmp1497_) {
		ValaCallable* _tmp1498_ = NULL;
		ValaMethod* _tmp1499_;
		ValaHashMap* _tmp1501_;
		ValaCCodeExpression* _tmp1502_;
		ValaCCodeExpression* _tmp1503_;
		ValaCCodeUnaryExpression* _tmp1504_;
		ValaCCodeUnaryExpression* _tmp1505_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1499_ = m;
		_tmp1498_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1499_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1498_ == NULL) {
			ValaDelegate* _tmp1500_;
			_tmp1500_ = deleg;
			_tmp1498_ = (ValaCallable*) _tmp1500_;
		}
		_tmp1501_ = out_arg_map;
		_tmp1502_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1503_ = _tmp1502_;
		_tmp1504_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1503_);
		_tmp1505_ = _tmp1504_;
		vala_map_set ((ValaMap*) _tmp1501_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1498_), FALSE)), (ValaCCodeExpression*) _tmp1505_);
		_vala_ccode_node_unref0 (_tmp1505_);
		_vala_ccode_node_unref0 (_tmp1503_);
	} else {
		gboolean _tmp1506_ = FALSE;
		gboolean _tmp1507_ = FALSE;
		ValaMethod* _tmp1508_;
		_tmp1508_ = m;
		if (_tmp1508_ != NULL) {
			ValaMethod* _tmp1509_;
			_tmp1509_ = m;
			_tmp1507_ = vala_method_has_error_type_parameter (_tmp1509_);
		} else {
			_tmp1507_ = FALSE;
		}
		if (_tmp1507_) {
			ValaCCodeFunctionCall* _tmp1510_;
			ValaCCodeFunctionCall* _tmp1511_;
			_tmp1510_ = async_call;
			_tmp1511_ = ccall;
			_tmp1506_ = _tmp1510_ != _tmp1511_;
		} else {
			_tmp1506_ = FALSE;
		}
		if (_tmp1506_) {
			ValaHashMap* _tmp1512_;
			ValaMethod* _tmp1513_;
			ValaCCodeConstant* _tmp1514_;
			ValaCCodeConstant* _tmp1515_;
			_tmp1512_ = out_arg_map;
			_tmp1513_ = m;
			_tmp1514_ = vala_ccode_constant_new ("NULL");
			_tmp1515_ = _tmp1514_;
			vala_map_set ((ValaMap*) _tmp1512_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1513_), FALSE)), (ValaCCodeExpression*) _tmp1515_);
			_vala_ccode_node_unref0 (_tmp1515_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1516_;
		_tmp1516_ = m;
		if (_tmp1516_ == NULL) {
			ValaHashMap* _tmp1517_;
			ValaCCodeConstant* _tmp1518_;
			ValaCCodeConstant* _tmp1519_;
			_tmp1517_ = in_arg_map;
			_tmp1518_ = vala_ccode_constant_new ("NULL");
			_tmp1519_ = _tmp1518_;
			vala_map_set ((ValaMap*) _tmp1517_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1519_);
			_vala_ccode_node_unref0 (_tmp1519_);
		} else {
			gboolean _tmp1520_ = FALSE;
			gboolean _tmp1521_ = FALSE;
			gboolean _tmp1522_ = FALSE;
			ValaMethod* _tmp1523_;
			gboolean _tmp1524_;
			gboolean _tmp1525_;
			_tmp1523_ = m;
			_tmp1524_ = vala_method_get_printf_format (_tmp1523_);
			_tmp1525_ = _tmp1524_;
			if (!_tmp1525_) {
				ValaMethod* _tmp1526_;
				gboolean _tmp1527_;
				gboolean _tmp1528_;
				_tmp1526_ = m;
				_tmp1527_ = vala_method_get_scanf_format (_tmp1526_);
				_tmp1528_ = _tmp1527_;
				_tmp1522_ = !_tmp1528_;
			} else {
				_tmp1522_ = FALSE;
			}
			if (_tmp1522_) {
				ValaMethod* _tmp1529_;
				gchar* _tmp1530_;
				gchar* _tmp1531_;
				_tmp1529_ = m;
				_tmp1530_ = vala_get_ccode_sentinel (_tmp1529_);
				_tmp1531_ = _tmp1530_;
				_tmp1521_ = g_strcmp0 (_tmp1531_, "") != 0;
				_g_free0 (_tmp1531_);
			} else {
				_tmp1521_ = FALSE;
			}
			if (_tmp1521_) {
				gboolean _tmp1532_;
				gboolean _tmp1533_;
				_tmp1532_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1533_ = _tmp1532_;
				_tmp1520_ = !_tmp1533_;
			} else {
				_tmp1520_ = FALSE;
			}
			if (_tmp1520_) {
				ValaHashMap* _tmp1534_;
				ValaMethod* _tmp1535_;
				gchar* _tmp1536_;
				gchar* _tmp1537_;
				ValaCCodeConstant* _tmp1538_;
				ValaCCodeConstant* _tmp1539_;
				_tmp1534_ = in_arg_map;
				_tmp1535_ = m;
				_tmp1536_ = vala_get_ccode_sentinel (_tmp1535_);
				_tmp1537_ = _tmp1536_;
				_tmp1538_ = vala_ccode_constant_new (_tmp1537_);
				_tmp1539_ = _tmp1538_;
				vala_map_set ((ValaMap*) _tmp1534_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1539_);
				_vala_ccode_node_unref0 (_tmp1539_);
				_g_free0 (_tmp1537_);
			}
		}
	}
	_tmp1540_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1540_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1541_;
		ValaDelegateType* _tmp1542_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1543_;
		ValaDelegate* _tmp1544_;
		ValaDelegate* _tmp1545_;
		ValaDelegate* _tmp1546_;
		ValaDelegate* _tmp1547_;
		gboolean _tmp1548_;
		gboolean _tmp1549_;
		_tmp1541_ = itype;
		_tmp1542_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1541_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1542_;
		_tmp1543_ = deleg_type;
		_tmp1544_ = vala_delegate_type_get_delegate_symbol (_tmp1543_);
		_tmp1545_ = _tmp1544_;
		_tmp1546_ = _vala_code_node_ref0 (_tmp1545_);
		d = _tmp1546_;
		_tmp1547_ = d;
		_tmp1548_ = vala_delegate_get_has_target (_tmp1547_);
		_tmp1549_ = _tmp1548_;
		if (_tmp1549_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1550_;
			ValaDelegate* _tmp1551_;
			ValaExpression* _tmp1552_;
			ValaExpression* _tmp1553_;
			ValaCCodeExpression* _tmp1554_ = NULL;
			ValaCCodeExpression* _tmp1555_;
			ValaCCodeExpression* _tmp1556_;
			ValaHashMap* _tmp1557_;
			ValaDelegate* _tmp1558_;
			ValaExpression* _tmp1559_;
			ValaExpression* _tmp1560_;
			ValaCCodeExpression* _tmp1561_ = NULL;
			ValaCCodeExpression* _tmp1562_;
			ValaCCodeExpression* _tmp1563_;
			_tmp1550_ = in_arg_map;
			_tmp1551_ = d;
			_tmp1552_ = vala_method_call_get_call (expr);
			_tmp1553_ = _tmp1552_;
			_tmp1555_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1553_, &_tmp1554_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1554_;
			_tmp1556_ = _tmp1555_;
			vala_map_set ((ValaMap*) _tmp1550_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1551_), FALSE)), _tmp1556_);
			_vala_ccode_node_unref0 (_tmp1556_);
			_tmp1557_ = out_arg_map;
			_tmp1558_ = d;
			_tmp1559_ = vala_method_call_get_call (expr);
			_tmp1560_ = _tmp1559_;
			_tmp1562_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1560_, &_tmp1561_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1561_;
			_tmp1563_ = _tmp1562_;
			vala_map_set ((ValaMap*) _tmp1557_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1558_), FALSE)), _tmp1563_);
			_vala_ccode_node_unref0 (_tmp1563_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1564_ = itype;
	_tmp1565_ = vala_data_type_get_return_type (_tmp1564_);
	_tmp1566_ = _tmp1565_;
	_tmp1567_ = vala_data_type_is_real_non_null_struct_type (_tmp1566_);
	_vala_code_node_unref0 (_tmp1566_);
	return_result_via_out_param = _tmp1567_;
	_tmp1569_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1569_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1570_;
		ValaDataType* _tmp1571_;
		ValaDataType* _tmp1572_;
		_tmp1570_ = itype;
		_tmp1571_ = vala_data_type_get_return_type (_tmp1570_);
		_tmp1572_ = _tmp1571_;
		_tmp1568_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1572_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1572_);
	} else {
		_tmp1568_ = FALSE;
	}
	if (_tmp1568_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1573_;
		ValaSignal* _tmp1574_;
		ValaSignal* _tmp1575_;
		ValaSignal* _tmp1576_;
		gboolean _tmp1577_ = FALSE;
		gboolean _tmp1578_ = FALSE;
		ValaMemberAccess* _tmp1579_;
		_tmp1573_ = itype;
		_tmp1574_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1573_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1575_ = _tmp1574_;
		_tmp1576_ = _vala_code_node_ref0 (_tmp1575_);
		sig = _tmp1576_;
		_tmp1579_ = ma;
		if (_tmp1579_ != NULL) {
			ValaMemberAccess* _tmp1580_;
			ValaExpression* _tmp1581_;
			ValaExpression* _tmp1582_;
			_tmp1580_ = ma;
			_tmp1581_ = vala_member_access_get_inner (_tmp1580_);
			_tmp1582_ = _tmp1581_;
			_tmp1578_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1582_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1578_ = FALSE;
		}
		if (_tmp1578_) {
			ValaSignal* _tmp1583_;
			gboolean _tmp1584_;
			gboolean _tmp1585_;
			_tmp1583_ = sig;
			_tmp1584_ = vala_signal_get_is_virtual (_tmp1583_);
			_tmp1585_ = _tmp1584_;
			_tmp1577_ = _tmp1585_;
		} else {
			_tmp1577_ = FALSE;
		}
		if (_tmp1577_) {
		} else {
			gboolean _tmp1586_ = FALSE;
			ValaSignal* _tmp1587_;
			_tmp1587_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1587_)) {
				_tmp1586_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1588_;
				ValaSourceReference* _tmp1589_;
				ValaSourceReference* _tmp1590_;
				ValaSourceFile* _tmp1591_;
				ValaSourceFile* _tmp1592_;
				ValaSignal* _tmp1593_;
				ValaSourceReference* _tmp1594_;
				ValaSourceReference* _tmp1595_;
				ValaSourceFile* _tmp1596_;
				ValaSourceFile* _tmp1597_;
				_tmp1588_ = ma;
				_tmp1589_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1588_);
				_tmp1590_ = _tmp1589_;
				_tmp1591_ = vala_source_reference_get_file (_tmp1590_);
				_tmp1592_ = _tmp1591_;
				_tmp1593_ = sig;
				_tmp1594_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1593_);
				_tmp1595_ = _tmp1594_;
				_tmp1596_ = vala_source_reference_get_file (_tmp1595_);
				_tmp1597_ = _tmp1596_;
				_tmp1586_ = _tmp1592_ == _tmp1597_;
			}
			if (_tmp1586_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1598_ = async_call;
	_tmp1599_ = ccall;
	if (_tmp1598_ == _tmp1599_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1600_;
		ValaDataType* _tmp1601_;
		ValaDataType* _tmp1602_;
		ValaLocalVariable* _tmp1603_;
		ValaLocalVariable* _tmp1604_;
		ValaLocalVariable* _tmp1605_;
		const gchar* _tmp1606_;
		const gchar* _tmp1607_;
		ValaCCodeExpression* _tmp1608_;
		ValaLocalVariable* _tmp1609_;
		ValaHashMap* _tmp1610_;
		ValaCCodeExpression* _tmp1611_;
		ValaCCodeUnaryExpression* _tmp1612_;
		ValaCCodeUnaryExpression* _tmp1613_;
		_tmp1600_ = itype;
		_tmp1601_ = vala_data_type_get_return_type (_tmp1600_);
		_tmp1602_ = _tmp1601_;
		_tmp1603_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1602_, TRUE, NULL, TRUE);
		_tmp1604_ = _tmp1603_;
		_vala_code_node_unref0 (_tmp1602_);
		out_param_var = _tmp1604_;
		_tmp1605_ = out_param_var;
		_tmp1606_ = vala_symbol_get_name ((ValaSymbol*) _tmp1605_);
		_tmp1607_ = _tmp1606_;
		_tmp1608_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1607_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1608_;
		_tmp1609_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1609_, FALSE);
		_tmp1610_ = out_arg_map;
		_tmp1611_ = out_param_ref;
		_tmp1612_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1611_);
		_tmp1613_ = _tmp1612_;
		vala_map_set ((ValaMap*) _tmp1610_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1613_);
		_vala_ccode_node_unref0 (_tmp1613_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1614_ = async_call;
	_tmp1615_ = ccall;
	if (_tmp1614_ != _tmp1615_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1626_;
			ValaHashMap* _tmp1627_;
			gpointer _tmp1628_;
			ValaCCodeExpression* _tmp1629_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1616_;
				ValaSet* _tmp1617_;
				ValaSet* _tmp1618_;
				ValaIterator* _tmp1619_;
				ValaIterator* _tmp1620_;
				_tmp1616_ = out_arg_map;
				_tmp1617_ = vala_map_get_keys ((ValaMap*) _tmp1616_);
				_tmp1618_ = _tmp1617_;
				_tmp1619_ = vala_iterable_iterator ((ValaIterable*) _tmp1618_);
				_tmp1620_ = _tmp1619_;
				_vala_iterable_unref0 (_tmp1618_);
				_pos_it = _tmp1620_;
				while (TRUE) {
					ValaIterator* _tmp1621_;
					gint pos = 0;
					ValaIterator* _tmp1622_;
					gpointer _tmp1623_;
					gboolean _tmp1624_ = FALSE;
					_tmp1621_ = _pos_it;
					if (!vala_iterator_next (_tmp1621_)) {
						break;
					}
					_tmp1622_ = _pos_it;
					_tmp1623_ = vala_iterator_get (_tmp1622_);
					pos = (gint) ((gintptr) _tmp1623_);
					if (pos > last_pos) {
						gboolean _tmp1625_ = FALSE;
						if (min_pos == -1) {
							_tmp1625_ = TRUE;
						} else {
							_tmp1625_ = pos < min_pos;
						}
						_tmp1624_ = _tmp1625_;
					} else {
						_tmp1624_ = FALSE;
					}
					if (_tmp1624_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1626_ = ccall;
			_tmp1627_ = out_arg_map;
			_tmp1628_ = vala_map_get ((ValaMap*) _tmp1627_, (gpointer) ((gintptr) min_pos));
			_tmp1629_ = (ValaCCodeExpression*) _tmp1628_;
			vala_ccode_function_call_add_argument (_tmp1626_, _tmp1629_);
			_vala_ccode_node_unref0 (_tmp1629_);
			last_pos = min_pos;
		}
	}
	_tmp1630_ = async_call;
	if (_tmp1630_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1641_;
			ValaHashMap* _tmp1642_;
			gpointer _tmp1643_;
			ValaCCodeExpression* _tmp1644_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1631_;
				ValaSet* _tmp1632_;
				ValaSet* _tmp1633_;
				ValaIterator* _tmp1634_;
				ValaIterator* _tmp1635_;
				_tmp1631_ = in_arg_map;
				_tmp1632_ = vala_map_get_keys ((ValaMap*) _tmp1631_);
				_tmp1633_ = _tmp1632_;
				_tmp1634_ = vala_iterable_iterator ((ValaIterable*) _tmp1633_);
				_tmp1635_ = _tmp1634_;
				_vala_iterable_unref0 (_tmp1633_);
				_pos_it = _tmp1635_;
				while (TRUE) {
					ValaIterator* _tmp1636_;
					gint pos = 0;
					ValaIterator* _tmp1637_;
					gpointer _tmp1638_;
					gboolean _tmp1639_ = FALSE;
					_tmp1636_ = _pos_it;
					if (!vala_iterator_next (_tmp1636_)) {
						break;
					}
					_tmp1637_ = _pos_it;
					_tmp1638_ = vala_iterator_get (_tmp1637_);
					pos = (gint) ((gintptr) _tmp1638_);
					if (pos > last_pos) {
						gboolean _tmp1640_ = FALSE;
						if (min_pos == -1) {
							_tmp1640_ = TRUE;
						} else {
							_tmp1640_ = pos < min_pos;
						}
						_tmp1639_ = _tmp1640_;
					} else {
						_tmp1639_ = FALSE;
					}
					if (_tmp1639_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1641_ = async_call;
			_tmp1642_ = in_arg_map;
			_tmp1643_ = vala_map_get ((ValaMap*) _tmp1642_, (gpointer) ((gintptr) min_pos));
			_tmp1644_ = (ValaCCodeExpression*) _tmp1643_;
			vala_ccode_function_call_add_argument (_tmp1641_, _tmp1644_);
			_vala_ccode_node_unref0 (_tmp1644_);
			last_pos = min_pos;
		}
	}
	_tmp1645_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1646_ = _tmp1645_;
	if (_tmp1646_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1647_;
		gint _tmp1648_;
		ValaCCodeFunction* _tmp1649_;
		ValaCCodeFunction* _tmp1650_;
		ValaCCodeIdentifier* _tmp1651_;
		ValaCCodeIdentifier* _tmp1652_;
		ValaCCodeMemberAccess* _tmp1653_;
		ValaCCodeMemberAccess* _tmp1654_;
		gchar* _tmp1655_;
		gchar* _tmp1656_;
		ValaCCodeConstant* _tmp1657_;
		ValaCCodeConstant* _tmp1658_;
		ValaCCodeFunction* _tmp1659_;
		ValaCCodeFunction* _tmp1660_;
		ValaCCodeFunctionCall* _tmp1661_;
		ValaCCodeFunction* _tmp1662_;
		ValaCCodeFunction* _tmp1663_;
		ValaCCodeConstant* _tmp1664_;
		ValaCCodeConstant* _tmp1665_;
		ValaCCodeFunction* _tmp1666_;
		ValaCCodeFunction* _tmp1667_;
		gchar* _tmp1668_;
		gchar* _tmp1669_;
		_tmp1647_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1648_ = _tmp1647_->next_coroutine_state;
		_tmp1647_->next_coroutine_state = _tmp1648_ + 1;
		state = _tmp1648_;
		_tmp1649_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1650_ = _tmp1649_;
		_tmp1651_ = vala_ccode_identifier_new ("_data_");
		_tmp1652_ = _tmp1651_;
		_tmp1653_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1652_, "_state_");
		_tmp1654_ = _tmp1653_;
		_tmp1655_ = g_strdup_printf ("%i", state);
		_tmp1656_ = _tmp1655_;
		_tmp1657_ = vala_ccode_constant_new (_tmp1656_);
		_tmp1658_ = _tmp1657_;
		vala_ccode_function_add_assignment (_tmp1650_, (ValaCCodeExpression*) _tmp1654_, (ValaCCodeExpression*) _tmp1658_);
		_vala_ccode_node_unref0 (_tmp1658_);
		_g_free0 (_tmp1656_);
		_vala_ccode_node_unref0 (_tmp1654_);
		_vala_ccode_node_unref0 (_tmp1652_);
		_tmp1659_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1660_ = _tmp1659_;
		_tmp1661_ = async_call;
		vala_ccode_function_add_expression (_tmp1660_, (ValaCCodeExpression*) _tmp1661_);
		_tmp1662_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1663_ = _tmp1662_;
		_tmp1664_ = vala_ccode_constant_new ("FALSE");
		_tmp1665_ = _tmp1664_;
		vala_ccode_function_add_return (_tmp1663_, (ValaCCodeExpression*) _tmp1665_);
		_vala_ccode_node_unref0 (_tmp1665_);
		_tmp1666_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1667_ = _tmp1666_;
		_tmp1668_ = g_strdup_printf ("_state_%d", state);
		_tmp1669_ = _tmp1668_;
		vala_ccode_function_add_label (_tmp1667_, _tmp1669_);
		_g_free0 (_tmp1669_);
	}
	_tmp1670_ = vala_method_call_get_is_assert (expr);
	_tmp1671_ = _tmp1670_;
	if (_tmp1671_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1672_;
		ValaSourceReference* _tmp1673_;
		ValaSourceLocation _tmp1674_ = {0};
		ValaSourceLocation _tmp1675_;
		gchar* _tmp1676_;
		ValaSourceReference* _tmp1677_;
		ValaSourceReference* _tmp1678_;
		ValaSourceLocation _tmp1679_ = {0};
		ValaSourceLocation _tmp1680_;
		gchar* _tmp1681_;
		ValaSourceReference* _tmp1682_;
		ValaSourceReference* _tmp1683_;
		ValaSourceLocation _tmp1684_ = {0};
		ValaSourceLocation _tmp1685_;
		gchar* _tmp1686_;
		gchar* _tmp1687_;
		ValaCCodeFunctionCall* _tmp1688_;
		ValaCCodeIdentifier* _tmp1689_;
		ValaCCodeIdentifier* _tmp1690_;
		ValaCCodeFunctionCall* _tmp1691_;
		const gchar* _tmp1692_;
		gchar* _tmp1693_;
		gchar* _tmp1694_;
		gchar* _tmp1695_;
		gchar* _tmp1696_;
		gchar* _tmp1697_;
		gchar* _tmp1698_;
		ValaCCodeConstant* _tmp1699_;
		ValaCCodeConstant* _tmp1700_;
		_tmp1672_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1673_ = _tmp1672_;
		vala_source_reference_get_begin (_tmp1673_, &_tmp1674_);
		_tmp1675_ = _tmp1674_;
		_tmp1676_ = _tmp1675_.pos;
		_tmp1677_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1678_ = _tmp1677_;
		vala_source_reference_get_end (_tmp1678_, &_tmp1679_);
		_tmp1680_ = _tmp1679_;
		_tmp1681_ = _tmp1680_.pos;
		_tmp1682_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1683_ = _tmp1682_;
		vala_source_reference_get_begin (_tmp1683_, &_tmp1684_);
		_tmp1685_ = _tmp1684_;
		_tmp1686_ = _tmp1685_.pos;
		_tmp1687_ = string_substring ((const gchar*) _tmp1676_, (glong) 0, (glong) ((gint) (_tmp1681_ - _tmp1686_)));
		message = _tmp1687_;
		_tmp1688_ = ccall;
		_tmp1689_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1690_ = _tmp1689_;
		vala_ccode_function_call_set_call (_tmp1688_, (ValaCCodeExpression*) _tmp1690_);
		_vala_ccode_node_unref0 (_tmp1690_);
		_tmp1691_ = ccall;
		_tmp1692_ = message;
		_tmp1693_ = string_replace (_tmp1692_, "\n", " ");
		_tmp1694_ = _tmp1693_;
		_tmp1695_ = g_strescape (_tmp1694_, "");
		_tmp1696_ = _tmp1695_;
		_tmp1697_ = g_strdup_printf ("\"%s\"", _tmp1696_);
		_tmp1698_ = _tmp1697_;
		_tmp1699_ = vala_ccode_constant_new (_tmp1698_);
		_tmp1700_ = _tmp1699_;
		vala_ccode_function_call_add_argument (_tmp1691_, (ValaCCodeExpression*) _tmp1700_);
		_vala_ccode_node_unref0 (_tmp1700_);
		_g_free0 (_tmp1698_);
		_g_free0 (_tmp1696_);
		_g_free0 (_tmp1694_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1701_;
		ValaCCodeFunction* _tmp1702_;
		ValaCCodeExpression* _tmp1703_;
		ValaCCodeExpression* _tmp1704_;
		ValaCCodeExpression* _tmp1705_;
		_tmp1701_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1702_ = _tmp1701_;
		_tmp1703_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1702_, _tmp1703_);
		_tmp1704_ = out_param_ref;
		_tmp1705_ = _vala_ccode_node_ref0 (_tmp1704_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1705_;
	}
	_tmp1708_ = m;
	if (_tmp1708_ != NULL) {
		ValaMethod* _tmp1709_;
		ValaMemberBinding _tmp1710_;
		ValaMemberBinding _tmp1711_;
		_tmp1709_ = m;
		_tmp1710_ = vala_method_get_binding (_tmp1709_);
		_tmp1711_ = _tmp1710_;
		_tmp1707_ = _tmp1711_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1707_ = FALSE;
	}
	if (_tmp1707_) {
		ValaMethod* _tmp1712_;
		gboolean _tmp1713_;
		gboolean _tmp1714_;
		_tmp1712_ = m;
		_tmp1713_ = vala_method_get_returns_modified_pointer (_tmp1712_);
		_tmp1714_ = _tmp1713_;
		_tmp1706_ = _tmp1714_;
	} else {
		_tmp1706_ = FALSE;
	}
	if (_tmp1706_) {
		gboolean _tmp1715_ = FALSE;
		gboolean _tmp1716_ = FALSE;
		ValaMemberAccess* _tmp1717_;
		_tmp1717_ = ma;
		if (_tmp1717_ != NULL) {
			ValaMemberAccess* _tmp1718_;
			ValaExpression* _tmp1719_;
			ValaExpression* _tmp1720_;
			ValaSymbol* _tmp1721_;
			ValaSymbol* _tmp1722_;
			_tmp1718_ = ma;
			_tmp1719_ = vala_member_access_get_inner (_tmp1718_);
			_tmp1720_ = _tmp1719_;
			_tmp1721_ = vala_expression_get_symbol_reference (_tmp1720_);
			_tmp1722_ = _tmp1721_;
			_tmp1716_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1722_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1716_ = FALSE;
		}
		if (_tmp1716_) {
			ValaMemberAccess* _tmp1723_;
			ValaExpression* _tmp1724_;
			ValaExpression* _tmp1725_;
			_tmp1723_ = ma;
			_tmp1724_ = vala_member_access_get_inner (_tmp1723_);
			_tmp1725_ = _tmp1724_;
			_tmp1715_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1725_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1715_ = FALSE;
		}
		if (_tmp1715_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1726_;
			ValaExpression* _tmp1727_;
			ValaExpression* _tmp1728_;
			ValaSymbol* _tmp1729_;
			ValaSymbol* _tmp1730_;
			ValaProperty* _tmp1731_;
			ValaProperty* _tmp1732_;
			ValaMemberAccess* _tmp1733_;
			ValaExpression* _tmp1734_;
			ValaExpression* _tmp1735_;
			ValaExpression* _tmp1736_;
			ValaExpression* _tmp1737_;
			ValaDataType* _tmp1738_;
			ValaDataType* _tmp1739_;
			ValaCCodeExpression* _tmp1740_;
			ValaGLibValue* _tmp1741_;
			ValaGLibValue* _tmp1742_;
			_tmp1726_ = ma;
			_tmp1727_ = vala_member_access_get_inner (_tmp1726_);
			_tmp1728_ = _tmp1727_;
			_tmp1729_ = vala_expression_get_symbol_reference (_tmp1728_);
			_tmp1730_ = _tmp1729_;
			_tmp1731_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1730_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1731_;
			_tmp1732_ = prop;
			_tmp1733_ = ma;
			_tmp1734_ = vala_member_access_get_inner (_tmp1733_);
			_tmp1735_ = _tmp1734_;
			_tmp1736_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1735_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1737_ = _tmp1736_;
			_tmp1738_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1739_ = _tmp1738_;
			_tmp1740_ = ccall_expr;
			_tmp1741_ = vala_glib_value_new (_tmp1739_, _tmp1740_, FALSE);
			_tmp1742_ = _tmp1741_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1732_, _tmp1737_, (ValaTargetValue*) _tmp1742_);
			_vala_target_value_unref0 (_tmp1742_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1743_;
			ValaCCodeExpression* _tmp1744_;
			ValaCCodeAssignment* _tmp1745_;
			_tmp1743_ = instance;
			_tmp1744_ = ccall_expr;
			_tmp1745_ = vala_ccode_assignment_new (_tmp1743_, _tmp1744_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1745_;
		}
	}
	_tmp1751_ = m;
	if (_tmp1751_ != NULL) {
		ValaMethod* _tmp1752_;
		_tmp1752_ = m;
		_tmp1750_ = vala_get_ccode_simple_generics (_tmp1752_);
	} else {
		_tmp1750_ = FALSE;
	}
	if (_tmp1750_) {
		ValaMethod* _tmp1753_;
		ValaDataType* _tmp1754_;
		ValaDataType* _tmp1755_;
		_tmp1753_ = m;
		_tmp1754_ = vala_callable_get_return_type ((ValaCallable*) _tmp1753_);
		_tmp1755_ = _tmp1754_;
		_tmp1749_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1755_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1749_ = FALSE;
	}
	if (_tmp1749_) {
		ValaDataType* _tmp1756_;
		ValaDataType* _tmp1757_;
		_tmp1756_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1757_ = _tmp1756_;
		_tmp1748_ = vala_data_type_is_real_struct_type (_tmp1757_);
	} else {
		_tmp1748_ = FALSE;
	}
	if (_tmp1748_) {
		ValaDataType* _tmp1758_;
		ValaDataType* _tmp1759_;
		gboolean _tmp1760_;
		gboolean _tmp1761_;
		_tmp1758_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1759_ = _tmp1758_;
		_tmp1760_ = vala_data_type_get_nullable (_tmp1759_);
		_tmp1761_ = _tmp1760_;
		_tmp1747_ = !_tmp1761_;
	} else {
		_tmp1747_ = FALSE;
	}
	if (_tmp1747_) {
		ValaDataType* _tmp1762_;
		ValaDataType* _tmp1763_;
		_tmp1762_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1763_ = _tmp1762_;
		_tmp1746_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1763_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1746_ = FALSE;
	}
	if (_tmp1746_) {
		ValaCCodeExpression* _tmp1764_;
		ValaCCodeParenthesizedExpression* _tmp1765_;
		ValaCCodeParenthesizedExpression* _tmp1766_;
		ValaCCodeUnaryExpression* _tmp1767_;
		_tmp1764_ = ccall_expr;
		_tmp1765_ = vala_ccode_parenthesized_expression_new (_tmp1764_);
		_tmp1766_ = _tmp1765_;
		_tmp1767_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1766_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1767_;
		_vala_ccode_node_unref0 (_tmp1766_);
	}
	_tmp1770_ = m;
	if (_tmp1770_ != NULL) {
		ValaMethod* _tmp1771_;
		gchar* _tmp1772_;
		gchar* _tmp1773_;
		_tmp1771_ = m;
		_tmp1772_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1771_);
		_tmp1773_ = _tmp1772_;
		_tmp1769_ = _tmp1773_ != NULL;
		_g_free0 (_tmp1773_);
	} else {
		_tmp1769_ = FALSE;
	}
	if (_tmp1769_) {
		ValaMethod* _tmp1774_;
		gchar* _tmp1775_;
		gchar* _tmp1776_;
		ValaMethod* _tmp1777_;
		ValaDataType* _tmp1778_;
		ValaDataType* _tmp1779_;
		gchar* _tmp1780_;
		gchar* _tmp1781_;
		_tmp1774_ = m;
		_tmp1775_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1774_);
		_tmp1776_ = _tmp1775_;
		_tmp1777_ = m;
		_tmp1778_ = vala_callable_get_return_type ((ValaCallable*) _tmp1777_);
		_tmp1779_ = _tmp1778_;
		_tmp1780_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1779_);
		_tmp1781_ = _tmp1780_;
		_tmp1768_ = g_strcmp0 (_tmp1776_, _tmp1781_) != 0;
		_g_free0 (_tmp1781_);
		_g_free0 (_tmp1776_);
	} else {
		_tmp1768_ = FALSE;
	}
	if (_tmp1768_) {
		ValaCCodeExpression* _tmp1782_;
		ValaMethod* _tmp1783_;
		ValaDataType* _tmp1784_;
		ValaDataType* _tmp1785_;
		gchar* _tmp1786_;
		gchar* _tmp1787_;
		ValaCCodeCastExpression* _tmp1788_;
		_tmp1782_ = ccall_expr;
		_tmp1783_ = m;
		_tmp1784_ = vala_callable_get_return_type ((ValaCallable*) _tmp1783_);
		_tmp1785_ = _tmp1784_;
		_tmp1786_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1785_);
		_tmp1787_ = _tmp1786_;
		_tmp1788_ = vala_ccode_cast_expression_new (_tmp1782_, _tmp1787_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1788_;
		_g_free0 (_tmp1787_);
	}
	_tmp1789_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1789_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1790_;
		ValaList* _tmp1791_;
		ValaIterator* _tmp1792_;
		ValaIterator* _tmp1793_;
		ValaIterator* _tmp1794_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1795_;
		gpointer _tmp1796_;
		ValaExpression* _tmp1797_;
		ValaCCodeExpression* _tmp1798_;
		ValaCCodeExpression* _tmp1799_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1800_;
		ValaLocalVariable* _tmp1801_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1802_;
		const gchar* _tmp1803_;
		const gchar* _tmp1804_;
		ValaCCodeExpression* _tmp1805_;
		ValaLocalVariable* _tmp1806_;
		ValaCCodeFile* _tmp1807_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1808_;
		ValaExpression* _tmp1809_;
		ValaExpression* _tmp1810_;
		ValaCCodeExpression* _tmp1811_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1812_;
		ValaExpression* _tmp1813_;
		ValaExpression* _tmp1814_;
		ValaCCodeExpression* _tmp1815_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1816_;
		ValaExpression* _tmp1817_;
		ValaExpression* _tmp1818_;
		ValaDataType* _tmp1819_;
		ValaDataType* _tmp1820_;
		ValaArrayType* _tmp1821_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1822_;
		ValaDataType* _tmp1823_;
		ValaDataType* _tmp1824_;
		gchar* _tmp1825_;
		gchar* _tmp1826_;
		gchar* _tmp1827_;
		gchar* _tmp1828_;
		ValaCCodeIdentifier* _tmp1829_;
		ValaCCodeIdentifier* _tmp1830_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1831_;
		ValaCCodeExpression* _tmp1832_;
		ValaCCodeBinaryExpression* _tmp1833_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1834_;
		ValaCCodeExpression* _tmp1835_;
		ValaCCodeBinaryExpression* _tmp1836_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1837_;
		ValaCCodeIdentifier* _tmp1838_;
		ValaCCodeFunctionCall* _tmp1839_;
		ValaCCodeFunctionCall* _tmp1840_;
		ValaCCodeFunctionCall* _tmp1841_;
		ValaCCodeExpression* _tmp1842_;
		ValaCCodeExpression* _tmp1843_;
		ValaCCodeBinaryExpression* _tmp1844_;
		ValaCCodeBinaryExpression* _tmp1845_;
		ValaCCodeFunctionCall* _tmp1846_;
		ValaCCodeConstant* _tmp1847_;
		ValaCCodeConstant* _tmp1848_;
		ValaCCodeFunctionCall* _tmp1849_;
		ValaCCodeIdentifier* _tmp1850_;
		ValaCCodeBinaryExpression* _tmp1851_;
		ValaCCodeBinaryExpression* _tmp1852_;
		ValaCCodeBinaryExpression* _tmp1853_;
		ValaCCodeFunction* _tmp1854_;
		ValaCCodeFunction* _tmp1855_;
		ValaCCodeExpression* _tmp1856_;
		ValaCCodeExpression* _tmp1857_;
		ValaCCodeFunction* _tmp1858_;
		ValaCCodeFunction* _tmp1859_;
		ValaCCodeExpression* _tmp1860_;
		ValaCCodeFunction* _tmp1861_;
		ValaCCodeFunction* _tmp1862_;
		ValaCCodeBinaryExpression* _tmp1863_;
		ValaCCodeFunctionCall* _tmp1864_;
		ValaCCodeConstant* _tmp1865_;
		ValaCCodeConstant* _tmp1866_;
		ValaCCodeConditionalExpression* _tmp1867_;
		ValaCCodeConditionalExpression* _tmp1868_;
		ValaCCodeFunction* _tmp1869_;
		ValaCCodeFunction* _tmp1870_;
		ValaMemberAccess* _tmp1871_;
		ValaExpression* _tmp1872_;
		ValaExpression* _tmp1873_;
		ValaCCodeExpression* _tmp1874_;
		ValaCCodeExpression* _tmp1875_;
		ValaCCodeExpression* _tmp1876_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1877_;
		ValaExpression* _tmp1878_;
		ValaExpression* _tmp1879_;
		ValaSymbol* _tmp1880_;
		ValaSymbol* _tmp1881_;
		ValaSymbol* _tmp1882_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1883_;
		ValaLocalVariable* _tmp1884_;
		gboolean _tmp1885_ = FALSE;
		gboolean _tmp1886_ = FALSE;
		ValaSymbol* _tmp1887_;
		_tmp1790_ = vala_method_call_get_argument_list (expr);
		_tmp1791_ = _tmp1790_;
		_tmp1792_ = vala_iterable_iterator ((ValaIterable*) _tmp1791_);
		_tmp1793_ = _tmp1792_;
		_vala_iterable_unref0 (_tmp1791_);
		arg_it = _tmp1793_;
		_tmp1794_ = arg_it;
		vala_iterator_next (_tmp1794_);
		_tmp1795_ = arg_it;
		_tmp1796_ = vala_iterator_get (_tmp1795_);
		_tmp1797_ = (ValaExpression*) _tmp1796_;
		_tmp1798_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1797_);
		_tmp1799_ = _tmp1798_;
		_vala_code_node_unref0 (_tmp1797_);
		new_size = _tmp1799_;
		_tmp1800_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1801_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1800_, TRUE, NULL, FALSE);
		temp_decl = _tmp1801_;
		_tmp1802_ = temp_decl;
		_tmp1803_ = vala_symbol_get_name ((ValaSymbol*) _tmp1802_);
		_tmp1804_ = _tmp1803_;
		_tmp1805_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1804_);
		temp_ref = _tmp1805_;
		_tmp1806_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1806_, FALSE);
		_tmp1807_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1807_, "string.h", FALSE);
		_tmp1808_ = ma;
		_tmp1809_ = vala_member_access_get_inner (_tmp1808_);
		_tmp1810_ = _tmp1809_;
		_tmp1811_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1810_, 1);
		clen = _tmp1811_;
		_tmp1812_ = ma;
		_tmp1813_ = vala_member_access_get_inner (_tmp1812_);
		_tmp1814_ = _tmp1813_;
		_tmp1815_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1814_);
		celems = _tmp1815_;
		_tmp1816_ = ma;
		_tmp1817_ = vala_member_access_get_inner (_tmp1816_);
		_tmp1818_ = _tmp1817_;
		_tmp1819_ = vala_expression_get_value_type (_tmp1818_);
		_tmp1820_ = _tmp1819_;
		_tmp1821_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1820_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1821_;
		_tmp1822_ = array_type;
		_tmp1823_ = vala_array_type_get_element_type (_tmp1822_);
		_tmp1824_ = _tmp1823_;
		_tmp1825_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1824_);
		_tmp1826_ = _tmp1825_;
		_tmp1827_ = g_strdup_printf ("sizeof (%s)", _tmp1826_);
		_tmp1828_ = _tmp1827_;
		_tmp1829_ = vala_ccode_identifier_new (_tmp1828_);
		_tmp1830_ = _tmp1829_;
		_g_free0 (_tmp1828_);
		_g_free0 (_tmp1826_);
		csizeof = _tmp1830_;
		_tmp1831_ = temp_ref;
		_tmp1832_ = clen;
		_tmp1833_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1831_, _tmp1832_);
		cdelta = _tmp1833_;
		_tmp1834_ = temp_ref;
		_tmp1835_ = clen;
		_tmp1836_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1834_, _tmp1835_);
		ccheck = _tmp1836_;
		_tmp1837_ = vala_ccode_identifier_new ("memset");
		_tmp1838_ = _tmp1837_;
		_tmp1839_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1838_);
		_tmp1840_ = _tmp1839_;
		_vala_ccode_node_unref0 (_tmp1838_);
		czero = _tmp1840_;
		_tmp1841_ = czero;
		_tmp1842_ = celems;
		_tmp1843_ = clen;
		_tmp1844_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1842_, _tmp1843_);
		_tmp1845_ = _tmp1844_;
		vala_ccode_function_call_add_argument (_tmp1841_, (ValaCCodeExpression*) _tmp1845_);
		_vala_ccode_node_unref0 (_tmp1845_);
		_tmp1846_ = czero;
		_tmp1847_ = vala_ccode_constant_new ("0");
		_tmp1848_ = _tmp1847_;
		vala_ccode_function_call_add_argument (_tmp1846_, (ValaCCodeExpression*) _tmp1848_);
		_vala_ccode_node_unref0 (_tmp1848_);
		_tmp1849_ = czero;
		_tmp1850_ = csizeof;
		_tmp1851_ = cdelta;
		_tmp1852_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1850_, (ValaCCodeExpression*) _tmp1851_);
		_tmp1853_ = _tmp1852_;
		vala_ccode_function_call_add_argument (_tmp1849_, (ValaCCodeExpression*) _tmp1853_);
		_vala_ccode_node_unref0 (_tmp1853_);
		_tmp1854_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1855_ = _tmp1854_;
		_tmp1856_ = temp_ref;
		_tmp1857_ = new_size;
		vala_ccode_function_add_assignment (_tmp1855_, _tmp1856_, _tmp1857_);
		_tmp1858_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1859_ = _tmp1858_;
		_tmp1860_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1859_, _tmp1860_);
		_tmp1861_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1862_ = _tmp1861_;
		_tmp1863_ = ccheck;
		_tmp1864_ = czero;
		_tmp1865_ = vala_ccode_constant_new ("NULL");
		_tmp1866_ = _tmp1865_;
		_tmp1867_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1863_, (ValaCCodeExpression*) _tmp1864_, (ValaCCodeExpression*) _tmp1866_);
		_tmp1868_ = _tmp1867_;
		vala_ccode_function_add_expression (_tmp1862_, (ValaCCodeExpression*) _tmp1868_);
		_vala_ccode_node_unref0 (_tmp1868_);
		_vala_ccode_node_unref0 (_tmp1866_);
		_tmp1869_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1870_ = _tmp1869_;
		_tmp1871_ = ma;
		_tmp1872_ = vala_member_access_get_inner (_tmp1871_);
		_tmp1873_ = _tmp1872_;
		_tmp1874_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1873_, 1);
		_tmp1875_ = _tmp1874_;
		_tmp1876_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1870_, _tmp1875_, _tmp1876_);
		_vala_ccode_node_unref0 (_tmp1875_);
		_tmp1877_ = ma;
		_tmp1878_ = vala_member_access_get_inner (_tmp1877_);
		_tmp1879_ = _tmp1878_;
		_tmp1880_ = vala_expression_get_symbol_reference (_tmp1879_);
		_tmp1881_ = _tmp1880_;
		_tmp1882_ = _vala_code_node_ref0 (_tmp1881_);
		array_var = _tmp1882_;
		_tmp1883_ = array_var;
		_tmp1884_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1883_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1883_) : NULL);
		array_local = _tmp1884_;
		_tmp1887_ = array_var;
		if (_tmp1887_ != NULL) {
			ValaSymbol* _tmp1888_;
			_tmp1888_ = array_var;
			_tmp1886_ = vala_symbol_is_internal_symbol (_tmp1888_);
		} else {
			_tmp1886_ = FALSE;
		}
		if (_tmp1886_) {
			gboolean _tmp1889_ = FALSE;
			gboolean _tmp1890_ = FALSE;
			ValaSymbol* _tmp1891_;
			_tmp1891_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1891_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1892_;
				gboolean _tmp1893_;
				gboolean _tmp1894_;
				_tmp1892_ = array_local;
				_tmp1893_ = vala_local_variable_get_captured (_tmp1892_);
				_tmp1894_ = _tmp1893_;
				_tmp1890_ = !_tmp1894_;
			} else {
				_tmp1890_ = FALSE;
			}
			if (_tmp1890_) {
				_tmp1889_ = TRUE;
			} else {
				ValaSymbol* _tmp1895_;
				_tmp1895_ = array_var;
				_tmp1889_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1895_, VALA_TYPE_FIELD);
			}
			_tmp1885_ = _tmp1889_;
		} else {
			_tmp1885_ = FALSE;
		}
		if (_tmp1885_) {
			ValaCCodeFunction* _tmp1896_;
			ValaCCodeFunction* _tmp1897_;
			ValaMemberAccess* _tmp1898_;
			ValaExpression* _tmp1899_;
			ValaExpression* _tmp1900_;
			ValaTargetValue* _tmp1901_;
			ValaTargetValue* _tmp1902_;
			ValaCCodeExpression* _tmp1903_;
			ValaCCodeExpression* _tmp1904_;
			ValaCCodeExpression* _tmp1905_;
			_tmp1896_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1897_ = _tmp1896_;
			_tmp1898_ = ma;
			_tmp1899_ = vala_member_access_get_inner (_tmp1898_);
			_tmp1900_ = _tmp1899_;
			_tmp1901_ = vala_expression_get_target_value (_tmp1900_);
			_tmp1902_ = _tmp1901_;
			_tmp1903_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1902_);
			_tmp1904_ = _tmp1903_;
			_tmp1905_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1897_, _tmp1904_, _tmp1905_);
			_vala_ccode_node_unref0 (_tmp1904_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1907_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1908_ = _tmp1907_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1908_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1909_;
		ValaDataType* _tmp1910_;
		_tmp1909_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1910_ = _tmp1909_;
		_tmp1906_ = !vala_data_type_is_disposable (_tmp1910_);
	} else {
		_tmp1906_ = FALSE;
	}
	if (_tmp1906_) {
		gboolean _tmp1911_ = FALSE;
		ValaCCodeExpression* _tmp1912_;
		_tmp1912_ = ccall_expr;
		if (_tmp1912_ != NULL) {
			_tmp1911_ = !return_result_via_out_param;
		} else {
			_tmp1911_ = FALSE;
		}
		if (_tmp1911_) {
			ValaCCodeFunction* _tmp1913_;
			ValaCCodeFunction* _tmp1914_;
			ValaCCodeExpression* _tmp1915_;
			_tmp1913_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1914_ = _tmp1913_;
			_tmp1915_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1914_, _tmp1915_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1916_;
		ValaDataType* _tmp1917_;
		gboolean _tmp1918_ = FALSE;
		ValaDataType* _tmp1919_;
		ValaDataType* _tmp1920_;
		gboolean _tmp1947_ = FALSE;
		ValaMethod* _tmp1948_;
		_tmp1916_ = itype;
		_tmp1917_ = vala_data_type_get_return_type (_tmp1916_);
		result_type = _tmp1917_;
		_tmp1919_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1920_ = _tmp1919_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1920_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1921_;
			ValaDataType* _tmp1922_;
			_tmp1921_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1922_ = _tmp1921_;
			_tmp1918_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1922_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1918_ = FALSE;
		}
		if (_tmp1918_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1923_;
			ValaDataType* _tmp1924_;
			ValaTypeParameter* _tmp1925_;
			ValaTypeParameter* _tmp1926_;
			ValaTypeParameter* _tmp1927_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1928_;
			ValaSymbol* _tmp1929_;
			ValaSymbol* _tmp1930_;
			ValaSymbol* _tmp1931_;
			ValaSymbol* _tmp1932_;
			ValaStruct* _tmp1933_;
			gboolean _tmp1934_ = FALSE;
			ValaTypeParameter* _tmp1935_;
			ValaSymbol* _tmp1936_;
			ValaSymbol* _tmp1937_;
			ValaTypeSymbol* _tmp1938_;
			_tmp1923_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1924_ = _tmp1923_;
			_tmp1925_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1924_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1926_ = _tmp1925_;
			_tmp1927_ = _vala_code_node_ref0 (_tmp1926_);
			type_parameter = _tmp1927_;
			_tmp1928_ = type_parameter;
			_tmp1929_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1928_);
			_tmp1930_ = _tmp1929_;
			_tmp1931_ = vala_symbol_get_parent_symbol (_tmp1930_);
			_tmp1932_ = _tmp1931_;
			_tmp1933_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1932_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1932_) : NULL);
			st = _tmp1933_;
			_tmp1935_ = type_parameter;
			_tmp1936_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1935_);
			_tmp1937_ = _tmp1936_;
			_tmp1938_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1937_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1938_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1934_ = TRUE;
			} else {
				gboolean _tmp1939_ = FALSE;
				ValaStruct* _tmp1940_;
				_tmp1940_ = st;
				if (_tmp1940_ != NULL) {
					ValaStruct* _tmp1941_;
					gchar* _tmp1942_;
					gchar* _tmp1943_;
					_tmp1941_ = st;
					_tmp1942_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1941_);
					_tmp1943_ = _tmp1942_;
					_tmp1939_ = g_strcmp0 (_tmp1943_, "va_list") == 0;
					_g_free0 (_tmp1943_);
				} else {
					_tmp1939_ = FALSE;
				}
				_tmp1934_ = _tmp1939_;
			}
			if (_tmp1934_) {
				ValaDataType* _tmp1944_;
				ValaDataType* _tmp1945_;
				ValaDataType* _tmp1946_;
				_tmp1944_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1945_ = _tmp1944_;
				_tmp1946_ = _vala_code_node_ref0 (_tmp1945_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1946_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1948_ = m;
		if (_tmp1948_ != NULL) {
			ValaMethod* _tmp1949_;
			_tmp1949_ = m;
			_tmp1947_ = vala_method_get_format_arg_index (_tmp1949_) >= 0;
		} else {
			_tmp1947_ = FALSE;
		}
		if (_tmp1947_) {
			ValaCCodeExpression* _tmp1950_;
			_tmp1950_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1950_);
		} else {
			gboolean _tmp1951_ = FALSE;
			ValaMethod* _tmp1952_;
			_tmp1952_ = m;
			if (_tmp1952_ != NULL) {
				ValaMethod* _tmp1953_;
				_tmp1953_ = m;
				_tmp1951_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1953_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1951_ = FALSE;
			}
			if (_tmp1951_) {
				ValaCCodeExpression* _tmp1954_;
				_tmp1954_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1954_);
			} else {
				gboolean _tmp1955_ = FALSE;
				gboolean _tmp1956_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp1956_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp1956_ = FALSE;
				}
				if (_tmp1956_) {
					gboolean _tmp1957_ = FALSE;
					ValaDataType* _tmp1958_;
					_tmp1958_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1958_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1959_;
						_tmp1959_ = result_type;
						_tmp1957_ = !vala_data_type_is_disposable (_tmp1959_);
					} else {
						_tmp1957_ = FALSE;
					}
					_tmp1955_ = _tmp1957_;
				} else {
					_tmp1955_ = FALSE;
				}
				if (_tmp1955_) {
					ValaCCodeExpression* _tmp1960_;
					_tmp1960_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1960_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1961_;
						ValaDataType* _tmp1962_;
						gboolean _tmp1963_;
						gboolean _tmp1964_;
						ValaLocalVariable* _tmp1965_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1966_;
						const gchar* _tmp1967_;
						const gchar* _tmp1968_;
						ValaCCodeExpression* _tmp1969_;
						ValaLocalVariable* _tmp1970_;
						ValaCCodeFunction* _tmp1971_;
						ValaCCodeFunction* _tmp1972_;
						ValaCCodeExpression* _tmp1973_;
						ValaCCodeExpression* _tmp1974_;
						ValaCCodeExpression* _tmp1975_;
						ValaTargetValue* _tmp1976_;
						ValaTargetValue* _tmp1977_;
						_tmp1961_ = result_type;
						_tmp1962_ = result_type;
						_tmp1963_ = vala_data_type_get_value_owned (_tmp1962_);
						_tmp1964_ = _tmp1963_;
						_tmp1965_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1961_, _tmp1964_, NULL, FALSE);
						temp_var = _tmp1965_;
						_tmp1966_ = temp_var;
						_tmp1967_ = vala_symbol_get_name ((ValaSymbol*) _tmp1966_);
						_tmp1968_ = _tmp1967_;
						_tmp1969_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1968_);
						temp_ref = _tmp1969_;
						_tmp1970_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1970_, FALSE);
						_tmp1971_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp1972_ = _tmp1971_;
						_tmp1973_ = temp_ref;
						_tmp1974_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp1972_, _tmp1973_, _tmp1974_);
						_tmp1975_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1975_);
						_tmp1976_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1977_ = _tmp1976_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1977_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp1978_;
						ValaTargetValue* _tmp1979_;
						ValaTargetValue* _tmp1980_;
						_tmp1978_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1978_);
						_tmp1979_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1980_ = _tmp1979_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1980_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp1981_ = params;
	_tmp1982_ = vala_iterable_iterator ((ValaIterable*) _tmp1981_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp1982_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1983_;
		gint _arg_size = 0;
		ValaList* _tmp1984_;
		gint _tmp1985_;
		gint _tmp1986_;
		gint _arg_index = 0;
		_tmp1983_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp1983_;
		_tmp1984_ = _arg_list;
		_tmp1985_ = vala_collection_get_size ((ValaCollection*) _tmp1984_);
		_tmp1986_ = _tmp1985_;
		_arg_size = _tmp1986_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp1987_;
			gpointer _tmp1988_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1989_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp1992_;
			ValaUnaryExpression* _tmp1993_;
			gboolean _tmp1994_ = FALSE;
			ValaUnaryExpression* _tmp1995_;
			gboolean _tmp2051_ = FALSE;
			ValaUnaryExpression* _tmp2052_;
			ValaUnaryExpression* _tmp2056_;
			ValaExpression* _tmp2057_;
			ValaExpression* _tmp2058_;
			ValaDataType* _tmp2059_;
			ValaDataType* _tmp2060_;
			gboolean _tmp2070_ = FALSE;
			ValaMemberAccess* _tmp2071_;
			ValaSymbol* _tmp2072_;
			ValaSymbol* _tmp2073_;
			ValaUnaryExpression* _tmp2089_;
			ValaExpression* _tmp2090_;
			ValaExpression* _tmp2091_;
			ValaTargetValue* _tmp2092_;
			ValaTargetValue* _tmp2093_;
			ValaUnaryExpression* _tmp2094_;
			ValaTargetValue* _tmp2095_;
			ValaTargetValue* _tmp2096_;
			ValaUnaryExpression* _tmp2097_;
			ValaExpression* _tmp2098_;
			ValaExpression* _tmp2099_;
			ValaDataType* _tmp2100_;
			ValaDataType* _tmp2101_;
			ValaExpression* _tmp2102_;
			ValaTargetValue* _tmp2103_;
			ValaTargetValue* _tmp2104_;
			ValaSourceReference* _tmp2105_;
			ValaSourceReference* _tmp2106_;
			gboolean _tmp2107_ = FALSE;
			ValaParameter* _tmp2108_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp1987_ = _arg_list;
			_tmp1988_ = vala_list_get (_tmp1987_, _arg_index);
			arg = (ValaExpression*) _tmp1988_;
			param = NULL;
			_tmp1989_ = params_it;
			if (vala_iterator_next (_tmp1989_)) {
				ValaIterator* _tmp1990_;
				gpointer _tmp1991_;
				_tmp1990_ = params_it;
				_tmp1991_ = vala_iterator_get (_tmp1990_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1991_;
			}
			_tmp1992_ = arg;
			_tmp1993_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1992_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1992_) : NULL);
			unary = _tmp1993_;
			_tmp1995_ = unary;
			if (_tmp1995_ != NULL) {
				ValaUnaryExpression* _tmp1996_;
				ValaUnaryOperator _tmp1997_;
				ValaUnaryOperator _tmp1998_;
				_tmp1996_ = unary;
				_tmp1997_ = vala_unary_expression_get_operator (_tmp1996_);
				_tmp1998_ = _tmp1997_;
				_tmp1994_ = _tmp1998_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp1994_ = FALSE;
			}
			if (_tmp1994_) {
				gboolean _tmp1999_ = FALSE;
				gboolean _tmp2000_ = FALSE;
				gboolean _tmp2001_ = FALSE;
				gboolean _tmp2002_ = FALSE;
				ValaParameter* _tmp2003_;
				_tmp2003_ = param;
				if (_tmp2003_ != NULL) {
					ValaParameter* _tmp2004_;
					_tmp2004_ = param;
					_tmp2002_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2004_);
				} else {
					_tmp2002_ = FALSE;
				}
				if (_tmp2002_) {
					ValaParameter* _tmp2005_;
					ValaDataType* _tmp2006_;
					ValaDataType* _tmp2007_;
					_tmp2005_ = param;
					_tmp2006_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2005_);
					_tmp2007_ = _tmp2006_;
					_tmp2001_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2007_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2001_ = FALSE;
				}
				if (_tmp2001_) {
					ValaParameter* _tmp2008_;
					ValaDataType* _tmp2009_;
					ValaDataType* _tmp2010_;
					gboolean _tmp2011_;
					gboolean _tmp2012_;
					_tmp2008_ = param;
					_tmp2009_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2008_);
					_tmp2010_ = _tmp2009_;
					_tmp2011_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2010_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2012_ = _tmp2011_;
					_tmp2000_ = !_tmp2012_;
				} else {
					_tmp2000_ = FALSE;
				}
				if (_tmp2000_) {
					ValaParameter* _tmp2013_;
					ValaDataType* _tmp2014_;
					ValaDataType* _tmp2015_;
					gint _tmp2016_;
					gint _tmp2017_;
					_tmp2013_ = param;
					_tmp2014_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2013_);
					_tmp2015_ = _tmp2014_;
					_tmp2016_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2015_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2017_ = _tmp2016_;
					_tmp1999_ = _tmp2017_ == 1;
				} else {
					_tmp1999_ = FALSE;
				}
				if (_tmp1999_) {
					ValaSymbol* array_var = NULL;
					ValaUnaryExpression* _tmp2018_;
					ValaExpression* _tmp2019_;
					ValaExpression* _tmp2020_;
					ValaSymbol* _tmp2021_;
					ValaSymbol* _tmp2022_;
					ValaLocalVariable* array_local = NULL;
					ValaSymbol* _tmp2023_;
					gboolean _tmp2024_ = FALSE;
					gboolean _tmp2025_ = FALSE;
					ValaSymbol* _tmp2026_;
					_tmp2018_ = unary;
					_tmp2019_ = vala_unary_expression_get_inner (_tmp2018_);
					_tmp2020_ = _tmp2019_;
					_tmp2021_ = vala_expression_get_symbol_reference (_tmp2020_);
					_tmp2022_ = _tmp2021_;
					array_var = _tmp2022_;
					_tmp2023_ = array_var;
					array_local = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2023_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp2023_) : NULL;
					_tmp2026_ = array_var;
					if (_tmp2026_ != NULL) {
						ValaSymbol* _tmp2027_;
						_tmp2027_ = array_var;
						_tmp2025_ = vala_symbol_is_internal_symbol (_tmp2027_);
					} else {
						_tmp2025_ = FALSE;
					}
					if (_tmp2025_) {
						gboolean _tmp2028_ = FALSE;
						gboolean _tmp2029_ = FALSE;
						ValaLocalVariable* _tmp2030_;
						_tmp2030_ = array_local;
						if (_tmp2030_ != NULL) {
							ValaLocalVariable* _tmp2031_;
							gboolean _tmp2032_;
							gboolean _tmp2033_;
							_tmp2031_ = array_local;
							_tmp2032_ = vala_local_variable_get_captured (_tmp2031_);
							_tmp2033_ = _tmp2032_;
							_tmp2029_ = !_tmp2033_;
						} else {
							_tmp2029_ = FALSE;
						}
						if (_tmp2029_) {
							_tmp2028_ = TRUE;
						} else {
							ValaSymbol* _tmp2034_;
							_tmp2034_ = array_var;
							_tmp2028_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2034_, VALA_TYPE_FIELD);
						}
						_tmp2024_ = _tmp2028_;
					} else {
						_tmp2024_ = FALSE;
					}
					if (_tmp2024_) {
						ValaCCodeFunction* _tmp2035_;
						ValaCCodeFunction* _tmp2036_;
						ValaUnaryExpression* _tmp2037_;
						ValaExpression* _tmp2038_;
						ValaExpression* _tmp2039_;
						ValaTargetValue* _tmp2040_;
						ValaTargetValue* _tmp2041_;
						ValaCCodeExpression* _tmp2042_;
						ValaCCodeExpression* _tmp2043_;
						ValaUnaryExpression* _tmp2044_;
						ValaExpression* _tmp2045_;
						ValaExpression* _tmp2046_;
						ValaTargetValue* _tmp2047_;
						ValaTargetValue* _tmp2048_;
						ValaCCodeExpression* _tmp2049_;
						ValaCCodeExpression* _tmp2050_;
						_tmp2035_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2036_ = _tmp2035_;
						_tmp2037_ = unary;
						_tmp2038_ = vala_unary_expression_get_inner (_tmp2037_);
						_tmp2039_ = _tmp2038_;
						_tmp2040_ = vala_expression_get_target_value (_tmp2039_);
						_tmp2041_ = _tmp2040_;
						_tmp2042_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp2041_);
						_tmp2043_ = _tmp2042_;
						_tmp2044_ = unary;
						_tmp2045_ = vala_unary_expression_get_inner (_tmp2044_);
						_tmp2046_ = _tmp2045_;
						_tmp2047_ = vala_expression_get_target_value (_tmp2046_);
						_tmp2048_ = _tmp2047_;
						_tmp2049_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2048_, 1);
						_tmp2050_ = _tmp2049_;
						vala_ccode_function_add_assignment (_tmp2036_, _tmp2043_, _tmp2050_);
						_vala_ccode_node_unref0 (_tmp2050_);
						_vala_ccode_node_unref0 (_tmp2043_);
					}
				}
			}
			_tmp2052_ = unary;
			if (_tmp2052_ == NULL) {
				_tmp2051_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2053_;
				ValaUnaryOperator _tmp2054_;
				ValaUnaryOperator _tmp2055_;
				_tmp2053_ = unary;
				_tmp2054_ = vala_unary_expression_get_operator (_tmp2053_);
				_tmp2055_ = _tmp2054_;
				_tmp2051_ = _tmp2055_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2051_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2056_ = unary;
			_tmp2057_ = vala_unary_expression_get_inner (_tmp2056_);
			_tmp2058_ = _tmp2057_;
			_tmp2059_ = vala_expression_get_value_type (_tmp2058_);
			_tmp2060_ = _tmp2059_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2060_)) {
				ValaCCodeFunction* _tmp2061_;
				ValaCCodeFunction* _tmp2062_;
				ValaUnaryExpression* _tmp2063_;
				ValaExpression* _tmp2064_;
				ValaExpression* _tmp2065_;
				ValaTargetValue* _tmp2066_;
				ValaTargetValue* _tmp2067_;
				ValaCCodeExpression* _tmp2068_;
				ValaCCodeExpression* _tmp2069_;
				_tmp2061_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2062_ = _tmp2061_;
				_tmp2063_ = unary;
				_tmp2064_ = vala_unary_expression_get_inner (_tmp2063_);
				_tmp2065_ = _tmp2064_;
				_tmp2066_ = vala_expression_get_target_value (_tmp2065_);
				_tmp2067_ = _tmp2066_;
				_tmp2068_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2067_, FALSE);
				_tmp2069_ = _tmp2068_;
				vala_ccode_function_add_expression (_tmp2062_, _tmp2069_);
				_vala_ccode_node_unref0 (_tmp2069_);
			}
			_tmp2071_ = ma;
			_tmp2072_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2071_);
			_tmp2073_ = _tmp2072_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2073_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2074_;
				ValaTargetValue* _tmp2075_;
				ValaTargetValue* _tmp2076_;
				ValaDataType* _tmp2077_;
				ValaDataType* _tmp2078_;
				_tmp2074_ = unary;
				_tmp2075_ = vala_expression_get_target_value ((ValaExpression*) _tmp2074_);
				_tmp2076_ = _tmp2075_;
				_tmp2077_ = vala_target_value_get_value_type (_tmp2076_);
				_tmp2078_ = _tmp2077_;
				_tmp2070_ = _tmp2078_ == NULL;
			} else {
				_tmp2070_ = FALSE;
			}
			if (_tmp2070_) {
				ValaUnaryExpression* _tmp2079_;
				ValaTargetValue* _tmp2080_;
				ValaTargetValue* _tmp2081_;
				ValaUnaryExpression* _tmp2082_;
				ValaExpression* _tmp2083_;
				ValaExpression* _tmp2084_;
				ValaDataType* _tmp2085_;
				ValaDataType* _tmp2086_;
				ValaDataType* _tmp2087_;
				ValaDataType* _tmp2088_;
				_tmp2079_ = unary;
				_tmp2080_ = vala_expression_get_target_value ((ValaExpression*) _tmp2079_);
				_tmp2081_ = _tmp2080_;
				_tmp2082_ = unary;
				_tmp2083_ = vala_unary_expression_get_inner (_tmp2082_);
				_tmp2084_ = _tmp2083_;
				_tmp2085_ = vala_expression_get_value_type (_tmp2084_);
				_tmp2086_ = _tmp2085_;
				_tmp2087_ = vala_data_type_copy (_tmp2086_);
				_tmp2088_ = _tmp2087_;
				vala_target_value_set_value_type (_tmp2081_, _tmp2088_);
				_vala_code_node_unref0 (_tmp2088_);
			}
			_tmp2089_ = unary;
			_tmp2090_ = vala_unary_expression_get_inner (_tmp2089_);
			_tmp2091_ = _tmp2090_;
			_tmp2092_ = vala_expression_get_target_value (_tmp2091_);
			_tmp2093_ = _tmp2092_;
			_tmp2094_ = unary;
			_tmp2095_ = vala_expression_get_target_value ((ValaExpression*) _tmp2094_);
			_tmp2096_ = _tmp2095_;
			_tmp2097_ = unary;
			_tmp2098_ = vala_unary_expression_get_inner (_tmp2097_);
			_tmp2099_ = _tmp2098_;
			_tmp2100_ = vala_expression_get_value_type (_tmp2099_);
			_tmp2101_ = _tmp2100_;
			_tmp2102_ = arg;
			_tmp2103_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2096_, _tmp2101_, (ValaCodeNode*) _tmp2102_);
			_tmp2104_ = _tmp2103_;
			_tmp2105_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2106_ = _tmp2105_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2093_, _tmp2104_, _tmp2106_);
			_vala_target_value_unref0 (_tmp2104_);
			_tmp2108_ = param;
			if (_tmp2108_ != NULL) {
				ValaParameter* _tmp2109_;
				_tmp2109_ = param;
				_tmp2107_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2109_);
			} else {
				_tmp2107_ = FALSE;
			}
			if (_tmp2107_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2110_;
				ValaCCodeIdentifier* _tmp2111_;
				ValaCCodeFunctionCall* _tmp2112_;
				ValaCCodeFunctionCall* _tmp2113_;
				ValaCCodeFunctionCall* _tmp2114_;
				ValaUnaryExpression* _tmp2115_;
				ValaExpression* _tmp2116_;
				ValaExpression* _tmp2117_;
				ValaTargetValue* _tmp2118_;
				ValaTargetValue* _tmp2119_;
				ValaCCodeExpression* _tmp2120_;
				ValaCCodeExpression* _tmp2121_;
				ValaCCodeFunction* _tmp2122_;
				ValaCCodeFunction* _tmp2123_;
				ValaUnaryExpression* _tmp2124_;
				ValaExpression* _tmp2125_;
				ValaExpression* _tmp2126_;
				ValaTargetValue* _tmp2127_;
				ValaTargetValue* _tmp2128_;
				ValaCCodeExpression* _tmp2129_;
				ValaCCodeExpression* _tmp2130_;
				ValaCCodeFunctionCall* _tmp2131_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2110_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2111_ = _tmp2110_;
				_tmp2112_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2111_);
				_tmp2113_ = _tmp2112_;
				_vala_ccode_node_unref0 (_tmp2111_);
				len_call = _tmp2113_;
				_tmp2114_ = len_call;
				_tmp2115_ = unary;
				_tmp2116_ = vala_unary_expression_get_inner (_tmp2115_);
				_tmp2117_ = _tmp2116_;
				_tmp2118_ = vala_expression_get_target_value (_tmp2117_);
				_tmp2119_ = _tmp2118_;
				_tmp2120_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2119_);
				_tmp2121_ = _tmp2120_;
				vala_ccode_function_call_add_argument (_tmp2114_, _tmp2121_);
				_vala_ccode_node_unref0 (_tmp2121_);
				_tmp2122_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2123_ = _tmp2122_;
				_tmp2124_ = unary;
				_tmp2125_ = vala_unary_expression_get_inner (_tmp2124_);
				_tmp2126_ = _tmp2125_;
				_tmp2127_ = vala_expression_get_target_value (_tmp2126_);
				_tmp2128_ = _tmp2127_;
				_tmp2129_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2128_, 1);
				_tmp2130_ = _tmp2129_;
				_tmp2131_ = len_call;
				vala_ccode_function_add_assignment (_tmp2123_, _tmp2130_, (ValaCCodeExpression*) _tmp2131_);
				_vala_ccode_node_unref0 (_tmp2130_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2134_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2134_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2135_;
		ValaSymbol* _tmp2136_;
		ValaSymbol* _tmp2137_;
		_tmp2135_ = m;
		_tmp2136_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2135_);
		_tmp2137_ = _tmp2136_;
		_tmp2133_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2137_, VALA_TYPE_CLASS);
	} else {
		_tmp2133_ = FALSE;
	}
	if (_tmp2133_) {
		gboolean _tmp2138_ = FALSE;
		gboolean _tmp2139_ = FALSE;
		ValaClass* _tmp2140_;
		ValaClass* _tmp2141_;
		gboolean _tmp2142_;
		gboolean _tmp2143_;
		_tmp2140_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2141_ = _tmp2140_;
		_tmp2142_ = vala_class_get_is_compact (_tmp2141_);
		_tmp2143_ = _tmp2142_;
		if (_tmp2143_) {
			ValaClass* _tmp2144_;
			ValaClass* _tmp2145_;
			ValaClass* _tmp2146_;
			ValaClass* _tmp2147_;
			_tmp2144_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2145_ = _tmp2144_;
			_tmp2146_ = vala_class_get_base_class (_tmp2145_);
			_tmp2147_ = _tmp2146_;
			_tmp2139_ = _tmp2147_ != NULL;
		} else {
			_tmp2139_ = FALSE;
		}
		if (_tmp2139_) {
			_tmp2138_ = TRUE;
		} else {
			ValaClass* _tmp2148_;
			ValaClass* _tmp2149_;
			ValaClass* _tmp2150_;
			ValaClass* _tmp2151_;
			ValaClass* _tmp2152_;
			_tmp2148_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2149_ = _tmp2148_;
			_tmp2150_ = vala_class_get_base_class (_tmp2149_);
			_tmp2151_ = _tmp2150_;
			_tmp2152_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2138_ = _tmp2151_ == _tmp2152_;
		}
		_tmp2132_ = _tmp2138_;
	} else {
		_tmp2132_ = FALSE;
	}
	if (_tmp2132_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2153_;
		ValaClass* _tmp2154_;
		gchar* _tmp2155_;
		gchar* _tmp2156_;
		gchar* _tmp2157_;
		gchar* _tmp2158_;
		ValaCCodeIdentifier* _tmp2159_;
		ValaCCodeIdentifier* _tmp2160_;
		ValaCCodeFunctionCall* _tmp2161_;
		ValaCCodeFunctionCall* _tmp2162_;
		ValaCCodeFunctionCall* _tmp2163_;
		ValaCCodeExpression* _tmp2164_;
		ValaCCodeExpression* _tmp2165_;
		ValaClass* _tmp2166_;
		ValaClass* _tmp2167_;
		gboolean _tmp2168_;
		gboolean _tmp2169_;
		ValaCCodeFunction* _tmp2173_;
		ValaCCodeFunction* _tmp2174_;
		ValaCCodeFunctionCall* _tmp2175_;
		_tmp2153_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2154_ = _tmp2153_;
		_tmp2155_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2154_, NULL);
		_tmp2156_ = _tmp2155_;
		_tmp2157_ = g_strdup_printf ("%s_instance_init", _tmp2156_);
		_tmp2158_ = _tmp2157_;
		_tmp2159_ = vala_ccode_identifier_new (_tmp2158_);
		_tmp2160_ = _tmp2159_;
		_tmp2161_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2160_);
		_tmp2162_ = _tmp2161_;
		_vala_ccode_node_unref0 (_tmp2160_);
		_g_free0 (_tmp2158_);
		_g_free0 (_tmp2156_);
		cinitcall = _tmp2162_;
		_tmp2163_ = cinitcall;
		_tmp2164_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2165_ = _tmp2164_;
		vala_ccode_function_call_add_argument (_tmp2163_, _tmp2165_);
		_vala_ccode_node_unref0 (_tmp2165_);
		_tmp2166_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2167_ = _tmp2166_;
		_tmp2168_ = vala_class_get_is_compact (_tmp2167_);
		_tmp2169_ = _tmp2168_;
		if (!_tmp2169_) {
			ValaCCodeFunctionCall* _tmp2170_;
			ValaCCodeConstant* _tmp2171_;
			ValaCCodeConstant* _tmp2172_;
			_tmp2170_ = cinitcall;
			_tmp2171_ = vala_ccode_constant_new ("NULL");
			_tmp2172_ = _tmp2171_;
			vala_ccode_function_call_add_argument (_tmp2170_, (ValaCCodeExpression*) _tmp2172_);
			_vala_ccode_node_unref0 (_tmp2172_);
		}
		_tmp2173_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2174_ = _tmp2173_;
		_tmp2175_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2174_, (ValaCCodeExpression*) _tmp2175_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp44_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeConstant* _tmp49_;
	ValaCCodeFile* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp24_;
			gpointer _tmp25_;
			ValaCCodeFunction* _tmp26_;
			ValaCCodeFunction* _tmp27_;
			ValaEnumValue* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeFunction* _tmp33_;
			ValaCCodeFunction* _tmp34_;
			ValaEnumValue* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			_enum_value_index = _enum_value_index + 1;
			if (!(_enum_value_index < _enum_value_size)) {
				break;
			}
			_tmp24_ = _enum_value_list;
			_tmp25_ = vala_list_get (_tmp24_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp25_;
			_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp27_ = _tmp26_;
			_tmp28_ = enum_value;
			_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_identifier_new (_tmp30_);
			_tmp32_ = _tmp31_;
			vala_ccode_function_add_case (_tmp27_, (ValaCCodeExpression*) _tmp32_);
			_vala_ccode_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp34_ = _tmp33_;
			_tmp35_ = enum_value;
			_tmp36_ = vala_get_ccode_name ((ValaCodeNode*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat ("\"", _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp39_, "\"", NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_constant_new (_tmp41_);
			_tmp43_ = _tmp42_;
			vala_ccode_function_add_return (_tmp34_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp44_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp45_ = _tmp44_;
	vala_ccode_function_close (_tmp45_);
	_tmp46_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_ccode_constant_new ("NULL");
	_tmp49_ = _tmp48_;
	vala_ccode_function_add_return (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp51_ = function;
	vala_ccode_file_add_function_declaration (_tmp50_, _tmp51_);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = function;
	vala_ccode_file_add_function (_tmp52_, _tmp53_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaUnaryExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp4_ = _arg_list;
			_tmp5_ = vala_list_get (_tmp4_, _arg_index);
			arg = (ValaExpression*) _tmp5_;
			_tmp6_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp6_) : NULL;
			_tmp8_ = unary;
			if (_tmp8_ != NULL) {
				gboolean _tmp9_ = FALSE;
				ValaUnaryExpression* _tmp10_;
				ValaUnaryOperator _tmp11_;
				ValaUnaryOperator _tmp12_;
				_tmp10_ = unary;
				_tmp11_ = vala_unary_expression_get_operator (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp9_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp13_;
					ValaUnaryOperator _tmp14_;
					ValaUnaryOperator _tmp15_;
					_tmp13_ = unary;
					_tmp14_ = vala_unary_expression_get_operator (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp9_ = _tmp15_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp7_ = _tmp9_;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeConstant* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeFunctionCall* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeIdentifier* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeBinaryExpression* _tmp60_;
	ValaCCodeBinaryExpression* _tmp61_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeIdentifier* _tmp63_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeFunctionCall* _tmp65_;
	ValaCCodeFunctionCall* _tmp66_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunction* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunctionCall* _tmp74_;
	ValaCCodeFunctionCall* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunction* _tmp79_;
	ValaCCodeFunction* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeFunctionCall* _tmp83_;
	ValaCCodeIdentifier* _tmp84_;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeFunctionCall* _tmp86_;
	ValaCCodeFunctionCall* _tmp87_;
	ValaCCodeIdentifier* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeFunction* _tmp93_;
	ValaCCodeFunction* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunctionCall* _tmp98_;
	ValaCCodeFunctionCall* _tmp99_;
	ValaCCodeIdentifier* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeFunctionCall* _tmp102_;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeFunctionCall* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeIdentifier* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeFunction* _tmp111_;
	ValaCCodeFunction* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunctionCall* _tmp116_;
	ValaCCodeFunctionCall* _tmp117_;
	ValaCCodeIdentifier* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeFunction* _tmp123_;
	ValaCCodeFunction* _tmp124_;
	ValaCCodeIdentifier* _tmp125_;
	ValaCCodeIdentifier* _tmp126_;
	ValaCCodeFile* _tmp127_;
	ValaCCodeFile* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFile* _tmp130_;
	ValaCCodeFunction* _tmp131_;
	gchar* _tmp132_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp38_);
	_tmp40_ = _tmp39_;
	_vala_ccode_node_unref0 (_tmp38_);
	vsnprintf = _tmp40_;
	_tmp41_ = vsnprintf;
	_tmp42_ = vala_ccode_constant_new ("NULL");
	_tmp43_ = _tmp42_;
	vala_ccode_function_call_add_argument (_tmp41_, (ValaCCodeExpression*) _tmp43_);
	_vala_ccode_node_unref0 (_tmp43_);
	_tmp44_ = vsnprintf;
	_tmp45_ = vala_ccode_constant_new ("0");
	_tmp46_ = _tmp45_;
	vala_ccode_function_call_add_argument (_tmp44_, (ValaCCodeExpression*) _tmp46_);
	_vala_ccode_node_unref0 (_tmp46_);
	_tmp47_ = vsnprintf;
	_tmp48_ = vala_ccode_identifier_new ("format");
	_tmp49_ = _tmp48_;
	vala_ccode_function_call_add_argument (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = vsnprintf;
	_tmp51_ = vala_ccode_identifier_new ("ap");
	_tmp52_ = _tmp51_;
	vala_ccode_function_call_add_argument (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_identifier_new ("length");
	_tmp56_ = _tmp55_;
	_tmp57_ = vsnprintf;
	_tmp58_ = vala_ccode_constant_new ("1");
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp57_, (ValaCCodeExpression*) _tmp59_);
	_tmp61_ = _tmp60_;
	vala_ccode_function_add_assignment (_tmp54_, (ValaCCodeExpression*) _tmp56_, (ValaCCodeExpression*) _tmp61_);
	_vala_ccode_node_unref0 (_tmp61_);
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp56_);
	_tmp62_ = vala_ccode_identifier_new ("va_end");
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp63_);
	_tmp65_ = _tmp64_;
	_vala_ccode_node_unref0 (_tmp63_);
	va_end = _tmp65_;
	_tmp66_ = va_end;
	_tmp67_ = vala_ccode_identifier_new ("ap");
	_tmp68_ = _tmp67_;
	vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp68_);
	_vala_ccode_node_unref0 (_tmp68_);
	_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp70_ = _tmp69_;
	_tmp71_ = va_end;
	vala_ccode_function_add_expression (_tmp70_, (ValaCCodeExpression*) _tmp71_);
	_tmp72_ = vala_ccode_identifier_new ("malloc");
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp73_);
	_tmp75_ = _tmp74_;
	_vala_ccode_node_unref0 (_tmp73_);
	malloc = _tmp75_;
	_tmp76_ = malloc;
	_tmp77_ = vala_ccode_identifier_new ("length");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_ccode_identifier_new ("result");
	_tmp82_ = _tmp81_;
	_tmp83_ = malloc;
	vala_ccode_function_add_assignment (_tmp80_, (ValaCCodeExpression*) _tmp82_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp82_);
	_tmp84_ = vala_ccode_identifier_new ("va_start");
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp85_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp86_;
	_vala_ccode_node_unref0 (_tmp85_);
	_tmp87_ = va_start;
	_tmp88_ = vala_ccode_identifier_new ("ap");
	_tmp89_ = _tmp88_;
	vala_ccode_function_call_add_argument (_tmp87_, (ValaCCodeExpression*) _tmp89_);
	_vala_ccode_node_unref0 (_tmp89_);
	_tmp90_ = va_start;
	_tmp91_ = vala_ccode_identifier_new ("format");
	_tmp92_ = _tmp91_;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp92_);
	_vala_ccode_node_unref0 (_tmp92_);
	_tmp93_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp94_ = _tmp93_;
	_tmp95_ = va_start;
	vala_ccode_function_add_expression (_tmp94_, (ValaCCodeExpression*) _tmp95_);
	_tmp96_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp98_;
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp99_ = vsnprintf;
	_tmp100_ = vala_ccode_identifier_new ("result");
	_tmp101_ = _tmp100_;
	vala_ccode_function_call_add_argument (_tmp99_, (ValaCCodeExpression*) _tmp101_);
	_vala_ccode_node_unref0 (_tmp101_);
	_tmp102_ = vsnprintf;
	_tmp103_ = vala_ccode_identifier_new ("length");
	_tmp104_ = _tmp103_;
	vala_ccode_function_call_add_argument (_tmp102_, (ValaCCodeExpression*) _tmp104_);
	_vala_ccode_node_unref0 (_tmp104_);
	_tmp105_ = vsnprintf;
	_tmp106_ = vala_ccode_identifier_new ("format");
	_tmp107_ = _tmp106_;
	vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp107_);
	_vala_ccode_node_unref0 (_tmp107_);
	_tmp108_ = vsnprintf;
	_tmp109_ = vala_ccode_identifier_new ("ap");
	_tmp110_ = _tmp109_;
	vala_ccode_function_call_add_argument (_tmp108_, (ValaCCodeExpression*) _tmp110_);
	_vala_ccode_node_unref0 (_tmp110_);
	_tmp111_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp112_, (ValaCCodeExpression*) _tmp113_);
	_tmp114_ = vala_ccode_identifier_new ("va_end");
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp116_;
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp117_ = va_end;
	_tmp118_ = vala_ccode_identifier_new ("ap");
	_tmp119_ = _tmp118_;
	vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
	_vala_ccode_node_unref0 (_tmp119_);
	_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = va_end;
	vala_ccode_function_add_expression (_tmp121_, (ValaCCodeExpression*) _tmp122_);
	_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_identifier_new ("result");
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_return (_tmp124_, (ValaCCodeExpression*) _tmp126_);
	_vala_ccode_node_unref0 (_tmp126_);
	_tmp127_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp127_, "stdarg.h", FALSE);
	_tmp128_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp129_ = function;
	vala_ccode_file_add_function_declaration (_tmp128_, _tmp129_);
	_tmp130_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp131_ = function;
	vala_ccode_file_add_function (_tmp130_, _tmp131_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp132_ = g_strdup ("string_printf");
	result = _tmp132_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

