/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* virtuals;
};

static gint ValaInterface_private_offset;
static gpointer vala_interface_parent_class = NULL;

static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);

static inline gpointer
vala_interface_get_instance_private (ValaInterface* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInterface_private_offset);
}

/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}

/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaObjectType* _tmp4_;
		ValaObjectType* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp4_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		vala_method_set_this_parameter (m, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_method_get_this_parameter (m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_method_get_this_parameter (m);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp17_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp18_ = _tmp17_;
	if (!VALA_IS_VOID_TYPE (_tmp18_)) {
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp19_ = vala_method_get_postconditions (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_ > 0;
		_vala_iterable_unref0 (_tmp20_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		_tmp23_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_data_type_copy (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_local_variable_new (_tmp26_, "result", NULL, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
		_vala_code_node_unref0 (_tmp26_);
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		vala_local_variable_set_is_result (_tmp32_, TRUE);
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaObjectType* _tmp4_;
	ValaObjectType* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	ValaScope* _tmp8_;
	ValaScope* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaParameter* _tmp14_;
	ValaParameter* _tmp15_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "interface properties should be `abstract' or have `get' accessor and/o" \
"r `set' mutator");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp4_ = vala_object_type_new ((ValaObjectTypeSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	vala_property_set_this_parameter (prop, _tmp7_);
	_vala_code_node_unref0 (_tmp7_);
	_vala_code_node_unref0 (_tmp5_);
	_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_property_get_this_parameter (prop);
	_tmp15_ = _tmp14_;
	vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
}

static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_INTERFACE_GET_CLASS (self)->get_virtuals (self);
}

static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}

static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp5_ = _type_list;
			_tmp6_ = vala_list_get (_tmp5_, _type_index);
			type = (ValaDataType*) _tmp6_;
			_tmp7_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp8_;
		gint _p_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _p_index = 0;
		_tmp8_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp8_;
		_tmp9_ = _p_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_p_size = _tmp11_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaTypeParameter* _tmp14_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp12_ = _p_list;
			_tmp13_ = vala_list_get (_tmp12_, _p_index);
			p = (ValaTypeParameter*) _tmp13_;
			_tmp14_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp15_;
		gint _en_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _en_index = 0;
		_tmp15_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp15_;
		_tmp16_ = _en_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_en_size = _tmp18_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			ValaEnum* _tmp21_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp19_ = _en_list;
			_tmp20_ = vala_list_get (_tmp19_, _en_index);
			en = (ValaEnum*) _tmp20_;
			_tmp21_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp21_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp22_;
		gint _m_size = 0;
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _m_index = 0;
		_tmp22_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp22_;
		_tmp23_ = _m_list;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_m_size = _tmp25_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp26_;
			gpointer _tmp27_;
			ValaMethod* _tmp28_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp26_ = _m_list;
			_tmp27_ = vala_list_get (_tmp26_, _m_index);
			m = (ValaMethod*) _tmp27_;
			_tmp28_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp28_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp29_;
		gint _f_size = 0;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _f_index = 0;
		_tmp29_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp29_;
		_tmp30_ = _f_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_f_size = _tmp32_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp33_;
			gpointer _tmp34_;
			ValaField* _tmp35_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp33_ = _f_list;
			_tmp34_ = vala_list_get (_tmp33_, _f_index);
			f = (ValaField*) _tmp34_;
			_tmp35_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp35_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp36_;
		gint _c_size = 0;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _c_index = 0;
		_tmp36_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp36_;
		_tmp37_ = _c_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_c_size = _tmp39_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp40_;
			gpointer _tmp41_;
			ValaConstant* _tmp42_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp40_ = _c_list;
			_tmp41_ = vala_list_get (_tmp40_, _c_index);
			c = (ValaConstant*) _tmp41_;
			_tmp42_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp42_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp43_;
		gint _prop_size = 0;
		ValaList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _prop_index = 0;
		_tmp43_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp43_;
		_tmp44_ = _prop_list;
		_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		_prop_size = _tmp46_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp47_;
			gpointer _tmp48_;
			ValaProperty* _tmp49_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp47_ = _prop_list;
			_tmp48_ = vala_list_get (_tmp47_, _prop_index);
			prop = (ValaProperty*) _tmp48_;
			_tmp49_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp49_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp50_;
		gint _sig_size = 0;
		ValaList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		gint _sig_index = 0;
		_tmp50_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp50_;
		_tmp51_ = _sig_list;
		_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
		_tmp53_ = _tmp52_;
		_sig_size = _tmp53_;
		_sig_index = -1;
		while (TRUE) {
			ValaSignal* sig = NULL;
			ValaList* _tmp54_;
			gpointer _tmp55_;
			ValaSignal* _tmp56_;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp54_ = _sig_list;
			_tmp55_ = vala_list_get (_tmp54_, _sig_index);
			sig = (ValaSignal*) _tmp55_;
			_tmp56_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp56_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp57_;
		gint _cl_size = 0;
		ValaList* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint _cl_index = 0;
		_tmp57_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp57_;
		_tmp58_ = _cl_list;
		_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
		_tmp60_ = _tmp59_;
		_cl_size = _tmp60_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp61_;
			gpointer _tmp62_;
			ValaClass* _tmp63_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp61_ = _cl_list;
			_tmp62_ = vala_list_get (_tmp61_, _cl_index);
			cl = (ValaClass*) _tmp62_;
			_tmp63_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp63_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp64_;
		gint _st_size = 0;
		ValaList* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _st_index = 0;
		_tmp64_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp64_;
		_tmp65_ = _st_list;
		_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
		_tmp67_ = _tmp66_;
		_st_size = _tmp67_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp68_;
			gpointer _tmp69_;
			ValaStruct* _tmp70_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp68_ = _st_list;
			_tmp69_ = vala_list_get (_tmp68_, _st_index);
			st = (ValaStruct*) _tmp69_;
			_tmp70_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp70_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp71_;
		gint _d_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _d_index = 0;
		_tmp71_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp71_;
		_tmp72_ = _d_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_d_size = _tmp74_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp75_;
			gpointer _tmp76_;
			ValaDelegate* _tmp77_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp75_ = _d_list;
			_tmp76_ = vala_list_get (_tmp75_, _d_index);
			d = (ValaDelegate*) _tmp76_;
			_tmp77_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp77_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}

static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prerequisite_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prerequisite_list = _tmp1_;
		_tmp2_ = _prerequisite_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prerequisite_size = _tmp4_;
		_prerequisite_index = -1;
		while (TRUE) {
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_prerequisite_index = _prerequisite_index + 1;
			if (!(_prerequisite_index < _prerequisite_size)) {
				break;
			}
			_tmp5_ = _prerequisite_list;
			_tmp6_ = vala_list_get (_tmp5_, _prerequisite_index);
			prerequisite = (ValaDataType*) _tmp6_;
			_tmp8_ = prerequisite;
			_tmp9_ = vala_data_type_get_data_type (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				ValaDataType* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				_tmp11_ = prerequisite;
				_tmp12_ = vala_data_type_get_data_type (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = vala_typesymbol_is_subtype_of (_tmp13_, t);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				_vala_iterable_unref0 (_prerequisite_list);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
		_vala_iterable_unref0 (_prerequisite_list);
	}
	result = FALSE;
	return result;
}

static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->prerequisites;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->prerequisites;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->prerequisites;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	gboolean _tmp115_;
	gboolean _tmp116_;
	ValaMap* positions = NULL;
	GHashFunc _tmp223_;
	GEqualFunc _tmp224_;
	GEqualFunc _tmp225_;
	ValaHashMap* _tmp226_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	ValaSemanticAnalyzer* _tmp300_;
	ValaSemanticAnalyzer* _tmp301_;
	ValaSourceFile* _tmp302_;
	ValaSemanticAnalyzer* _tmp303_;
	ValaSemanticAnalyzer* _tmp304_;
	ValaSymbol* _tmp305_;
	gboolean _tmp306_;
	gboolean _tmp307_;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_prerequisite_reference_list = _tmp24_;
		_tmp25_ = _prerequisite_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_prerequisite_reference_size = _tmp27_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaSemanticAnalyzer* _tmp30_;
			ValaSemanticAnalyzer* _tmp31_;
			ValaDataType* _tmp32_;
			_prerequisite_reference_index = _prerequisite_reference_index + 1;
			if (!(_prerequisite_reference_index < _prerequisite_reference_size)) {
				break;
			}
			_tmp28_ = _prerequisite_reference_list;
			_tmp29_ = vala_list_get (_tmp28_, _prerequisite_reference_index);
			prerequisite_reference = (ValaDataType*) _tmp29_;
			_tmp30_ = vala_code_context_get_analyzer (context);
			_tmp31_ = _tmp30_;
			_tmp32_ = prerequisite_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp31_, (ValaSymbol*) self, _tmp32_)) {
				ValaSourceReference* _tmp33_;
				ValaSourceReference* _tmp34_;
				ValaDataType* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = prerequisite_reference;
				_tmp36_ = vala_code_node_to_string ((ValaCodeNode*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_strdup_printf ("prerequisite `%s' is less accessible than interface `%s'", _tmp37_, _tmp39_);
				_tmp41_ = _tmp40_;
				vala_report_error (_tmp34_, _tmp41_);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp39_);
				_g_free0 (_tmp37_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_iterable_unref0 (_prerequisite_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
		_vala_iterable_unref0 (_prerequisite_reference_list);
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp42_;
		gint _prereq_size = 0;
		ValaList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _prereq_index = 0;
		_tmp42_ = vala_interface_get_prerequisites (self);
		_prereq_list = _tmp42_;
		_tmp43_ = _prereq_list;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_prereq_size = _tmp45_;
		_prereq_index = -1;
		while (TRUE) {
			ValaDataType* prereq = NULL;
			ValaList* _tmp46_;
			gpointer _tmp47_;
			ValaTypeSymbol* class_or_interface = NULL;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaTypeSymbol* _tmp51_;
			ValaTypeSymbol* _tmp52_;
			ValaTypeSymbol* _tmp53_;
			ValaTypeSymbol* _tmp63_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp46_ = _prereq_list;
			_tmp47_ = vala_list_get (_tmp46_, _prereq_index);
			prereq = (ValaDataType*) _tmp47_;
			_tmp48_ = prereq;
			_tmp49_ = vala_data_type_get_data_type (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = _vala_code_node_ref0 (_tmp50_);
			class_or_interface = _tmp51_;
			_tmp52_ = class_or_interface;
			if (_tmp52_ == NULL) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (class_or_interface);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp53_ = class_or_interface;
			if (!VALA_IS_OBJECT_TYPE_SYMBOL (_tmp53_)) {
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				ValaTypeSymbol* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp55_ = _tmp54_;
				_tmp56_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp57_ = _tmp56_;
				_tmp58_ = class_or_interface;
				_tmp59_ = vala_code_node_to_string ((ValaCodeNode*) _tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_strdup_printf ("Prerequisite `%s' of interface `%s' is not a class or interface", _tmp57_, _tmp60_);
				_tmp62_ = _tmp61_;
				vala_report_error (_tmp55_, _tmp62_);
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
				_g_free0 (_tmp57_);
				result = FALSE;
				_vala_code_node_unref0 (class_or_interface);
				_vala_code_node_unref0 (prereq);
				_vala_iterable_unref0 (_prereq_list);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp63_ = class_or_interface;
			if (VALA_IS_CLASS (_tmp63_)) {
				ValaClass* _tmp64_;
				ValaTypeSymbol* _tmp77_;
				ValaClass* _tmp78_;
				_tmp64_ = prereq_class;
				if (_tmp64_ != NULL) {
					ValaSourceReference* _tmp65_;
					ValaSourceReference* _tmp66_;
					gchar* _tmp67_;
					gchar* _tmp68_;
					ValaTypeSymbol* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					ValaClass* _tmp72_;
					gchar* _tmp73_;
					gchar* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp66_ = _tmp65_;
					_tmp67_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp68_ = _tmp67_;
					_tmp69_ = class_or_interface;
					_tmp70_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = prereq_class;
					_tmp73_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp68_, _tmp71_, _tmp74_);
					_tmp76_ = _tmp75_;
					vala_report_error (_tmp66_, _tmp76_);
					_g_free0 (_tmp76_);
					_g_free0 (_tmp74_);
					_g_free0 (_tmp71_);
					_g_free0 (_tmp68_);
					result = FALSE;
					_vala_code_node_unref0 (class_or_interface);
					_vala_code_node_unref0 (prereq);
					_vala_iterable_unref0 (_prereq_list);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp77_ = class_or_interface;
				_tmp78_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp78_;
			}
			_vala_code_node_unref0 (class_or_interface);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp79_;
		ValaList* _tmp80_;
		gint _type_size = 0;
		ValaList* _tmp81_;
		gint _tmp82_;
		gint _tmp83_;
		gint _type_index = 0;
		_tmp79_ = self->priv->prerequisites;
		_tmp80_ = _vala_iterable_ref0 (_tmp79_);
		_type_list = _tmp80_;
		_tmp81_ = _type_list;
		_tmp82_ = vala_collection_get_size ((ValaCollection*) _tmp81_);
		_tmp83_ = _tmp82_;
		_type_size = _tmp83_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp84_;
			gpointer _tmp85_;
			ValaDataType* _tmp86_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp84_ = _type_list;
			_tmp85_ = vala_list_get (_tmp84_, _type_index);
			type = (ValaDataType*) _tmp85_;
			_tmp86_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp86_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp87_;
		gint _p_size = 0;
		ValaList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gint _p_index = 0;
		_tmp87_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp87_;
		_tmp88_ = _p_list;
		_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
		_tmp90_ = _tmp89_;
		_p_size = _tmp90_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp91_;
			gpointer _tmp92_;
			ValaTypeParameter* _tmp93_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp91_ = _p_list;
			_tmp92_ = vala_list_get (_tmp91_, _p_index);
			p = (ValaTypeParameter*) _tmp92_;
			_tmp93_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp93_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp94_;
		gint _en_size = 0;
		ValaList* _tmp95_;
		gint _tmp96_;
		gint _tmp97_;
		gint _en_index = 0;
		_tmp94_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp94_;
		_tmp95_ = _en_list;
		_tmp96_ = vala_collection_get_size ((ValaCollection*) _tmp95_);
		_tmp97_ = _tmp96_;
		_en_size = _tmp97_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp98_;
			gpointer _tmp99_;
			ValaEnum* _tmp100_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp98_ = _en_list;
			_tmp99_ = vala_list_get (_tmp98_, _en_index);
			en = (ValaEnum*) _tmp99_;
			_tmp100_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp100_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp101_;
		gint _f_size = 0;
		ValaList* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		gint _f_index = 0;
		_tmp101_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp101_;
		_tmp102_ = _f_list;
		_tmp103_ = vala_collection_get_size ((ValaCollection*) _tmp102_);
		_tmp104_ = _tmp103_;
		_f_size = _tmp104_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp105_;
			gpointer _tmp106_;
			ValaField* _tmp107_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp105_ = _f_list;
			_tmp106_ = vala_list_get (_tmp105_, _f_index);
			f = (ValaField*) _tmp106_;
			_tmp107_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp107_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp108_;
		gint _c_size = 0;
		ValaList* _tmp109_;
		gint _tmp110_;
		gint _tmp111_;
		gint _c_index = 0;
		_tmp108_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp108_;
		_tmp109_ = _c_list;
		_tmp110_ = vala_collection_get_size ((ValaCollection*) _tmp109_);
		_tmp111_ = _tmp110_;
		_c_size = _tmp111_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp112_;
			gpointer _tmp113_;
			ValaConstant* _tmp114_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp112_ = _c_list;
			_tmp113_ = vala_list_get (_tmp112_, _c_index);
			c = (ValaConstant*) _tmp113_;
			_tmp114_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp114_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	_tmp115_ = vala_code_context_get_abi_stability (context);
	_tmp116_ = _tmp115_;
	if (_tmp116_) {
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp117_;
			gint _s_size = 0;
			ValaList* _tmp118_;
			gint _tmp119_;
			gint _tmp120_;
			gint _s_index = 0;
			_tmp117_ = vala_object_type_symbol_get_members ((ValaObjectTypeSymbol*) self);
			_s_list = _tmp117_;
			_tmp118_ = _s_list;
			_tmp119_ = vala_collection_get_size ((ValaCollection*) _tmp118_);
			_tmp120_ = _tmp119_;
			_s_size = _tmp120_;
			_s_index = -1;
			while (TRUE) {
				ValaSymbol* s = NULL;
				ValaList* _tmp121_;
				gpointer _tmp122_;
				ValaSymbol* _tmp123_;
				_s_index = _s_index + 1;
				if (!(_s_index < _s_size)) {
					break;
				}
				_tmp121_ = _s_list;
				_tmp122_ = vala_list_get (_tmp121_, _s_index);
				s = (ValaSymbol*) _tmp122_;
				_tmp123_ = s;
				if (VALA_IS_METHOD (_tmp123_)) {
					ValaMethod* m = NULL;
					ValaSymbol* _tmp124_;
					ValaMethod* _tmp125_;
					ValaMethod* _tmp126_;
					gboolean _tmp127_ = FALSE;
					ValaMethod* _tmp128_;
					gboolean _tmp129_;
					gboolean _tmp130_;
					_tmp124_ = s;
					_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp125_;
					_tmp126_ = m;
					vala_code_node_check ((ValaCodeNode*) _tmp126_, context);
					_tmp128_ = m;
					_tmp129_ = vala_method_get_is_virtual (_tmp128_);
					_tmp130_ = _tmp129_;
					if (_tmp130_) {
						_tmp127_ = TRUE;
					} else {
						ValaMethod* _tmp131_;
						gboolean _tmp132_;
						gboolean _tmp133_;
						_tmp131_ = m;
						_tmp132_ = vala_method_get_is_abstract (_tmp131_);
						_tmp133_ = _tmp132_;
						_tmp127_ = _tmp133_;
					}
					if (_tmp127_) {
						ValaList* _tmp134_;
						ValaMethod* _tmp135_;
						_tmp134_ = self->priv->virtuals;
						_tmp135_ = m;
						vala_collection_add ((ValaCollection*) _tmp134_, (ValaSymbol*) _tmp135_);
					}
					_vala_code_node_unref0 (m);
				} else {
					ValaSymbol* _tmp136_;
					_tmp136_ = s;
					if (VALA_IS_SIGNAL (_tmp136_)) {
						ValaSignal* sig = NULL;
						ValaSymbol* _tmp137_;
						ValaSignal* _tmp138_;
						ValaSignal* _tmp139_;
						ValaSignal* _tmp140_;
						gboolean _tmp141_;
						gboolean _tmp142_;
						_tmp137_ = s;
						_tmp138_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp137_, VALA_TYPE_SIGNAL, ValaSignal));
						sig = _tmp138_;
						_tmp139_ = sig;
						vala_code_node_check ((ValaCodeNode*) _tmp139_, context);
						_tmp140_ = sig;
						_tmp141_ = vala_signal_get_is_virtual (_tmp140_);
						_tmp142_ = _tmp141_;
						if (_tmp142_) {
							ValaList* _tmp143_;
							ValaSignal* _tmp144_;
							_tmp143_ = self->priv->virtuals;
							_tmp144_ = sig;
							vala_collection_add ((ValaCollection*) _tmp143_, (ValaSymbol*) _tmp144_);
						}
						_vala_code_node_unref0 (sig);
					} else {
						ValaSymbol* _tmp145_;
						_tmp145_ = s;
						if (VALA_IS_PROPERTY (_tmp145_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp146_;
							ValaProperty* _tmp147_;
							ValaProperty* _tmp148_;
							gboolean _tmp149_ = FALSE;
							ValaProperty* _tmp150_;
							gboolean _tmp151_;
							gboolean _tmp152_;
							_tmp146_ = s;
							_tmp147_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp146_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp147_;
							_tmp148_ = prop;
							vala_code_node_check ((ValaCodeNode*) _tmp148_, context);
							_tmp150_ = prop;
							_tmp151_ = vala_property_get_is_virtual (_tmp150_);
							_tmp152_ = _tmp151_;
							if (_tmp152_) {
								_tmp149_ = TRUE;
							} else {
								ValaProperty* _tmp153_;
								gboolean _tmp154_;
								gboolean _tmp155_;
								_tmp153_ = prop;
								_tmp154_ = vala_property_get_is_abstract (_tmp153_);
								_tmp155_ = _tmp154_;
								_tmp149_ = _tmp155_;
							}
							if (_tmp149_) {
								ValaList* _tmp156_;
								ValaProperty* _tmp157_;
								_tmp156_ = self->priv->virtuals;
								_tmp157_ = prop;
								vala_collection_add ((ValaCollection*) _tmp156_, (ValaSymbol*) _tmp157_);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
	} else {
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp158_;
			gint _m_size = 0;
			ValaList* _tmp159_;
			gint _tmp160_;
			gint _tmp161_;
			gint _m_index = 0;
			_tmp158_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
			_m_list = _tmp158_;
			_tmp159_ = _m_list;
			_tmp160_ = vala_collection_get_size ((ValaCollection*) _tmp159_);
			_tmp161_ = _tmp160_;
			_m_size = _tmp161_;
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m = NULL;
				ValaList* _tmp162_;
				gpointer _tmp163_;
				ValaMethod* _tmp164_;
				gboolean _tmp165_ = FALSE;
				ValaMethod* _tmp166_;
				gboolean _tmp167_;
				gboolean _tmp168_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp162_ = _m_list;
				_tmp163_ = vala_list_get (_tmp162_, _m_index);
				m = (ValaMethod*) _tmp163_;
				_tmp164_ = m;
				vala_code_node_check ((ValaCodeNode*) _tmp164_, context);
				_tmp166_ = m;
				_tmp167_ = vala_method_get_is_virtual (_tmp166_);
				_tmp168_ = _tmp167_;
				if (_tmp168_) {
					_tmp165_ = TRUE;
				} else {
					ValaMethod* _tmp169_;
					gboolean _tmp170_;
					gboolean _tmp171_;
					_tmp169_ = m;
					_tmp170_ = vala_method_get_is_abstract (_tmp169_);
					_tmp171_ = _tmp170_;
					_tmp165_ = _tmp171_;
				}
				if (_tmp165_) {
					ValaList* _tmp172_;
					ValaMethod* _tmp173_;
					_tmp172_ = self->priv->virtuals;
					_tmp173_ = m;
					vala_collection_add ((ValaCollection*) _tmp172_, (ValaSymbol*) _tmp173_);
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp174_;
			gint _sig_size = 0;
			ValaList* _tmp175_;
			gint _tmp176_;
			gint _tmp177_;
			gint _sig_index = 0;
			_tmp174_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
			_sig_list = _tmp174_;
			_tmp175_ = _sig_list;
			_tmp176_ = vala_collection_get_size ((ValaCollection*) _tmp175_);
			_tmp177_ = _tmp176_;
			_sig_size = _tmp177_;
			_sig_index = -1;
			while (TRUE) {
				ValaSignal* sig = NULL;
				ValaList* _tmp178_;
				gpointer _tmp179_;
				ValaSignal* _tmp180_;
				ValaSignal* _tmp181_;
				gboolean _tmp182_;
				gboolean _tmp183_;
				_sig_index = _sig_index + 1;
				if (!(_sig_index < _sig_size)) {
					break;
				}
				_tmp178_ = _sig_list;
				_tmp179_ = vala_list_get (_tmp178_, _sig_index);
				sig = (ValaSignal*) _tmp179_;
				_tmp180_ = sig;
				vala_code_node_check ((ValaCodeNode*) _tmp180_, context);
				_tmp181_ = sig;
				_tmp182_ = vala_signal_get_is_virtual (_tmp181_);
				_tmp183_ = _tmp182_;
				if (_tmp183_) {
					ValaList* _tmp184_;
					ValaSignal* _tmp185_;
					_tmp184_ = self->priv->virtuals;
					_tmp185_ = sig;
					vala_collection_add ((ValaCollection*) _tmp184_, (ValaSymbol*) _tmp185_);
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		{
			ValaList* _prop_list = NULL;
			ValaList* _tmp186_;
			gint _prop_size = 0;
			ValaList* _tmp187_;
			gint _tmp188_;
			gint _tmp189_;
			gint _prop_index = 0;
			_tmp186_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
			_prop_list = _tmp186_;
			_tmp187_ = _prop_list;
			_tmp188_ = vala_collection_get_size ((ValaCollection*) _tmp187_);
			_tmp189_ = _tmp188_;
			_prop_size = _tmp189_;
			_prop_index = -1;
			while (TRUE) {
				ValaProperty* prop = NULL;
				ValaList* _tmp190_;
				gpointer _tmp191_;
				ValaProperty* _tmp192_;
				gboolean _tmp193_ = FALSE;
				ValaProperty* _tmp194_;
				gboolean _tmp195_;
				gboolean _tmp196_;
				_prop_index = _prop_index + 1;
				if (!(_prop_index < _prop_size)) {
					break;
				}
				_tmp190_ = _prop_list;
				_tmp191_ = vala_list_get (_tmp190_, _prop_index);
				prop = (ValaProperty*) _tmp191_;
				_tmp192_ = prop;
				vala_code_node_check ((ValaCodeNode*) _tmp192_, context);
				_tmp194_ = prop;
				_tmp195_ = vala_property_get_is_virtual (_tmp194_);
				_tmp196_ = _tmp195_;
				if (_tmp196_) {
					_tmp193_ = TRUE;
				} else {
					ValaProperty* _tmp197_;
					gboolean _tmp198_;
					gboolean _tmp199_;
					_tmp197_ = prop;
					_tmp198_ = vala_property_get_is_abstract (_tmp197_);
					_tmp199_ = _tmp198_;
					_tmp193_ = _tmp199_;
				}
				if (_tmp193_) {
					ValaList* _tmp200_;
					ValaProperty* _tmp201_;
					_tmp200_ = self->priv->virtuals;
					_tmp201_ = prop;
					vala_collection_add ((ValaCollection*) _tmp200_, (ValaSymbol*) _tmp201_);
				}
				_vala_code_node_unref0 (prop);
			}
			_vala_iterable_unref0 (_prop_list);
		}
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp202_;
		gint _cl_size = 0;
		ValaList* _tmp203_;
		gint _tmp204_;
		gint _tmp205_;
		gint _cl_index = 0;
		_tmp202_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp202_;
		_tmp203_ = _cl_list;
		_tmp204_ = vala_collection_get_size ((ValaCollection*) _tmp203_);
		_tmp205_ = _tmp204_;
		_cl_size = _tmp205_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp206_;
			gpointer _tmp207_;
			ValaClass* _tmp208_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp206_ = _cl_list;
			_tmp207_ = vala_list_get (_tmp206_, _cl_index);
			cl = (ValaClass*) _tmp207_;
			_tmp208_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp208_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp209_;
		gint _st_size = 0;
		ValaList* _tmp210_;
		gint _tmp211_;
		gint _tmp212_;
		gint _st_index = 0;
		_tmp209_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp209_;
		_tmp210_ = _st_list;
		_tmp211_ = vala_collection_get_size ((ValaCollection*) _tmp210_);
		_tmp212_ = _tmp211_;
		_st_size = _tmp212_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp213_;
			gpointer _tmp214_;
			ValaStruct* _tmp215_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp213_ = _st_list;
			_tmp214_ = vala_list_get (_tmp213_, _st_index);
			st = (ValaStruct*) _tmp214_;
			_tmp215_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp215_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp216_;
		gint _d_size = 0;
		ValaList* _tmp217_;
		gint _tmp218_;
		gint _tmp219_;
		gint _d_index = 0;
		_tmp216_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp216_;
		_tmp217_ = _d_list;
		_tmp218_ = vala_collection_get_size ((ValaCollection*) _tmp217_);
		_tmp219_ = _tmp218_;
		_d_size = _tmp219_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp220_;
			gpointer _tmp221_;
			ValaDelegate* _tmp222_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp220_ = _d_list;
			_tmp221_ = vala_list_get (_tmp220_, _d_index);
			d = (ValaDelegate*) _tmp221_;
			_tmp222_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp222_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp223_ = g_direct_hash;
	_tmp224_ = g_direct_equal;
	_tmp225_ = g_direct_equal;
	_tmp226_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp223_, _tmp224_, _tmp225_);
	positions = (ValaMap*) _tmp226_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp227_;
		ValaList* _tmp228_;
		gint _sym_size = 0;
		ValaList* _tmp229_;
		gint _tmp230_;
		gint _tmp231_;
		gint _sym_index = 0;
		_tmp227_ = self->priv->virtuals;
		_tmp228_ = _vala_iterable_ref0 (_tmp227_);
		_sym_list = _tmp228_;
		_tmp229_ = _sym_list;
		_tmp230_ = vala_collection_get_size ((ValaCollection*) _tmp229_);
		_tmp231_ = _tmp230_;
		_sym_size = _tmp231_;
		_sym_index = -1;
		while (TRUE) {
			ValaSymbol* sym = NULL;
			ValaList* _tmp232_;
			gpointer _tmp233_;
			gint ordering = 0;
			ValaSymbol* _tmp234_;
			gboolean ordered = FALSE;
			gboolean _tmp243_ = FALSE;
			gboolean _tmp244_ = FALSE;
			gboolean _tmp253_ = FALSE;
			gboolean _tmp254_ = FALSE;
			gboolean _tmp255_ = FALSE;
			gboolean _tmp264_ = FALSE;
			gboolean _tmp265_ = FALSE;
			_sym_index = _sym_index + 1;
			if (!(_sym_index < _sym_size)) {
				break;
			}
			_tmp232_ = _sym_list;
			_tmp233_ = vala_list_get (_tmp232_, _sym_index);
			sym = (ValaSymbol*) _tmp233_;
			_tmp234_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp234_, "CCode", "ordering", -1);
			if (ordering < -1) {
				ValaSymbol* _tmp235_;
				ValaSourceReference* _tmp236_;
				ValaSourceReference* _tmp237_;
				ValaSymbol* _tmp238_;
				gchar* _tmp239_;
				gchar* _tmp240_;
				gchar* _tmp241_;
				gchar* _tmp242_;
				_tmp235_ = sym;
				_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = sym;
				_tmp239_ = vala_symbol_get_full_name (_tmp238_);
				_tmp240_ = _tmp239_;
				_tmp241_ = g_strdup_printf ("%s: Invalid ordering", _tmp240_);
				_tmp242_ = _tmp241_;
				vala_report_error (_tmp237_, _tmp242_);
				_g_free0 (_tmp242_);
				_g_free0 (_tmp240_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			ordered = ordering != -1;
			if (ordered) {
				_tmp244_ = unordered_seen;
			} else {
				_tmp244_ = FALSE;
			}
			if (_tmp244_) {
				_tmp243_ = !ordered_seen;
			} else {
				_tmp243_ = FALSE;
			}
			if (_tmp243_) {
				ValaSymbol* _tmp245_;
				ValaSourceReference* _tmp246_;
				ValaSourceReference* _tmp247_;
				ValaSymbol* _tmp248_;
				gchar* _tmp249_;
				gchar* _tmp250_;
				gchar* _tmp251_;
				gchar* _tmp252_;
				_tmp245_ = sym;
				_tmp246_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp245_);
				_tmp247_ = _tmp246_;
				_tmp248_ = sym;
				_tmp249_ = vala_symbol_get_full_name (_tmp248_);
				_tmp250_ = _tmp249_;
				_tmp251_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp250_);
				_tmp252_ = _tmp251_;
				vala_report_error (_tmp247_, _tmp252_);
				_g_free0 (_tmp252_);
				_g_free0 (_tmp250_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (ordered_seen) {
				_tmp253_ = TRUE;
			} else {
				_tmp253_ = ordered;
			}
			ordered_seen = _tmp253_;
			if (!ordered) {
				_tmp255_ = !unordered_seen;
			} else {
				_tmp255_ = FALSE;
			}
			if (_tmp255_) {
				_tmp254_ = ordered_seen;
			} else {
				_tmp254_ = FALSE;
			}
			if (_tmp254_) {
				ValaSymbol* _tmp256_;
				ValaSourceReference* _tmp257_;
				ValaSourceReference* _tmp258_;
				ValaSymbol* _tmp259_;
				gchar* _tmp260_;
				gchar* _tmp261_;
				gchar* _tmp262_;
				gchar* _tmp263_;
				_tmp256_ = sym;
				_tmp257_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp256_);
				_tmp258_ = _tmp257_;
				_tmp259_ = sym;
				_tmp260_ = vala_symbol_get_full_name (_tmp259_);
				_tmp261_ = _tmp260_;
				_tmp262_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp261_);
				_tmp263_ = _tmp262_;
				vala_report_error (_tmp258_, _tmp263_);
				_g_free0 (_tmp263_);
				_g_free0 (_tmp261_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (unordered_seen) {
				_tmp264_ = TRUE;
			} else {
				_tmp264_ = !ordered;
			}
			unordered_seen = _tmp264_;
			if (!ordered_seen) {
				_tmp265_ = TRUE;
			} else {
				_tmp265_ = !unordered_seen;
			}
			if (_tmp265_) {
				if (ordered) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp266_;
					gpointer _tmp267_;
					ValaSymbol* _tmp268_;
					ValaMap* _tmp280_;
					ValaSymbol* _tmp281_;
					_tmp266_ = positions;
					_tmp267_ = vala_map_get (_tmp266_, (gpointer) ((gintptr) ordering));
					prev = (ValaSymbol*) _tmp267_;
					_tmp268_ = prev;
					if (_tmp268_ != NULL) {
						ValaSymbol* _tmp269_;
						ValaSourceReference* _tmp270_;
						ValaSourceReference* _tmp271_;
						ValaSymbol* _tmp272_;
						gchar* _tmp273_;
						gchar* _tmp274_;
						ValaSymbol* _tmp275_;
						const gchar* _tmp276_;
						const gchar* _tmp277_;
						gchar* _tmp278_;
						gchar* _tmp279_;
						_tmp269_ = sym;
						_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp269_);
						_tmp271_ = _tmp270_;
						_tmp272_ = sym;
						_tmp273_ = vala_symbol_get_full_name (_tmp272_);
						_tmp274_ = _tmp273_;
						_tmp275_ = prev;
						_tmp276_ = vala_symbol_get_name (_tmp275_);
						_tmp277_ = _tmp276_;
						_tmp278_ = g_strdup_printf ("%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp274_, _tmp277_);
						_tmp279_ = _tmp278_;
						vala_report_error (_tmp271_, _tmp279_);
						_g_free0 (_tmp279_);
						_g_free0 (_tmp274_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp280_ = positions;
					_tmp281_ = sym;
					vala_map_set (_tmp280_, (gpointer) ((gintptr) ordering), _tmp281_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	if (ordered_seen) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp282_ = FALSE;
				_tmp282_ = TRUE;
				while (TRUE) {
					ValaList* _tmp284_;
					gint _tmp285_;
					gint _tmp286_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp287_;
					gpointer _tmp288_;
					ValaSymbol* _tmp289_;
					gboolean _tmp296_;
					gboolean _tmp297_;
					if (!_tmp282_) {
						gint _tmp283_;
						_tmp283_ = i;
						i = _tmp283_ + 1;
					}
					_tmp282_ = FALSE;
					_tmp284_ = self->priv->virtuals;
					_tmp285_ = vala_collection_get_size ((ValaCollection*) _tmp284_);
					_tmp286_ = _tmp285_;
					if (!(i < _tmp286_)) {
						break;
					}
					_tmp287_ = positions;
					_tmp288_ = vala_map_get (_tmp287_, (gpointer) ((gintptr) i));
					sym = (ValaSymbol*) _tmp288_;
					_tmp289_ = sym;
					if (_tmp289_ == NULL) {
						ValaSourceReference* _tmp290_;
						ValaSourceReference* _tmp291_;
						gchar* _tmp292_;
						gchar* _tmp293_;
						gchar* _tmp294_;
						gchar* _tmp295_;
						_tmp290_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp291_ = _tmp290_;
						_tmp292_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp293_ = _tmp292_;
						_tmp294_ = g_strdup_printf ("%s: Gap in ordering in position %d", _tmp293_, i);
						_tmp295_ = _tmp294_;
						vala_report_error (_tmp291_, _tmp295_);
						_g_free0 (_tmp295_);
						_g_free0 (_tmp293_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp296_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp297_ = _tmp296_;
					if (!_tmp297_) {
						ValaList* _tmp298_;
						ValaSymbol* _tmp299_;
						_tmp298_ = self->priv->virtuals;
						_tmp299_ = sym;
						vala_list_set (_tmp298_, i, _tmp299_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp300_ = vala_code_context_get_analyzer (context);
	_tmp301_ = _tmp300_;
	_tmp302_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp301_, _tmp302_);
	_tmp303_ = vala_code_context_get_analyzer (context);
	_tmp304_ = _tmp303_;
	_tmp305_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp304_, _tmp305_);
	_tmp306_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp307_ = _tmp306_;
	result = !_tmp307_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_interface_class_init (ValaInterfaceClass * klass,
                           gpointer klass_data)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInterface_private_offset);
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_interface_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_interface_real_add_property;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface*)) vala_interface_real_get_virtuals;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_interface_real_check;
}

static void
vala_interface_instance_init (ValaInterface * self,
                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_interface_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->virtuals = (ValaList*) _tmp3_;
}

static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->virtuals);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
		GType vala_interface_type_id;
		vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
		ValaInterface_private_offset = g_type_add_instance_private (vala_interface_type_id, sizeof (ValaInterfacePrivate));
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}

