/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaGLibValue, vala_target_value_unref)
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp164_;
	GEqualFunc _tmp165_;
	GEqualFunc _tmp166_;
	ValaHashMap* _tmp167_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp168_;
	ValaHashMap* _tmp169_;
	gboolean _tmp170_ = FALSE;
	ValaMethod* _tmp171_;
	gboolean _tmp315_ = FALSE;
	ValaMethod* _tmp316_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp479_;
	ValaCCodeExpression* _tmp480_;
	ValaMethod* _tmp481_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp505_ = FALSE;
	ValaMethod* _tmp506_;
	gboolean _tmp660_ = FALSE;
	ValaMethod* _tmp661_;
	ValaMethod* _tmp709_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp891_;
	ValaIterator* _tmp892_;
	ValaIterator* _tmp1264_;
	gboolean _tmp1274_ = FALSE;
	gboolean _tmp1275_ = FALSE;
	ValaMethod* _tmp1276_;
	gboolean _tmp1398_ = FALSE;
	ValaDelegate* _tmp1399_;
	gboolean _tmp1496_ = FALSE;
	ValaMethod* _tmp1497_;
	gboolean _tmp1513_;
	gboolean _tmp1514_;
	ValaDataType* _tmp1557_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1581_;
	ValaDataType* _tmp1582_;
	ValaDataType* _tmp1583_;
	gboolean _tmp1584_;
	gboolean _tmp1585_ = FALSE;
	ValaDataType* _tmp1586_;
	ValaCCodeFunctionCall* _tmp1615_;
	ValaCCodeFunctionCall* _tmp1616_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1631_;
	ValaCCodeFunctionCall* _tmp1632_;
	ValaCCodeFunctionCall* _tmp1647_;
	gboolean _tmp1662_;
	gboolean _tmp1663_;
	gboolean _tmp1687_;
	gboolean _tmp1688_;
	gboolean _tmp1723_ = FALSE;
	gboolean _tmp1724_ = FALSE;
	ValaMethod* _tmp1725_;
	gboolean _tmp1763_ = FALSE;
	gboolean _tmp1764_ = FALSE;
	gboolean _tmp1765_ = FALSE;
	gboolean _tmp1766_ = FALSE;
	gboolean _tmp1767_ = FALSE;
	ValaMethod* _tmp1768_;
	gboolean _tmp1785_ = FALSE;
	gboolean _tmp1786_ = FALSE;
	ValaMethod* _tmp1787_;
	ValaMethod* _tmp1806_;
	gboolean _tmp1923_ = FALSE;
	ValaCodeNode* _tmp1924_;
	ValaCodeNode* _tmp1925_;
	ValaList* _tmp1998_;
	ValaIterator* _tmp1999_;
	gboolean _tmp2073_ = FALSE;
	gboolean _tmp2074_ = FALSE;
	ValaMethod* _tmp2075_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			ValaCodeContext* _tmp60_;
			ValaCodeContext* _tmp61_;
			ValaProfile _tmp62_;
			ValaProfile _tmp63_;
			_tmp60_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_code_context_get_profile (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp64_;
				ValaExpression* _tmp65_;
				ValaExpression* _tmp66_;
				_tmp64_ = ma;
				_tmp65_ = vala_member_access_get_inner (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp59_ = _tmp66_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				_tmp67_ = ma;
				_tmp68_ = vala_member_access_get_inner (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_expression_get_value_type (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp58_ = _tmp71_ != NULL;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp72_;
				ValaExpression* _tmp73_;
				ValaExpression* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				ValaTypeSymbol* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaDataType* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				_tmp72_ = ma;
				_tmp73_ = vala_member_access_get_inner (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_expression_get_value_type (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_data_type_get_data_type (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp80_ = vala_data_type_get_data_type (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp57_ = _tmp78_ == _tmp81_;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaMemberAccess* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				_tmp82_ = ma;
				_tmp83_ = vala_member_access_get_member_name (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp56_ = g_strcmp0 (_tmp84_, "printf") == 0;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ValaCCodeFunctionCall* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				ValaCCodeIdentifier* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				_tmp85_ = ccall;
				_tmp86_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_ccode_identifier_new (_tmp87_);
				_tmp89_ = _tmp88_;
				vala_ccode_function_call_set_call (_tmp85_, (ValaCCodeExpression*) _tmp89_);
				_vala_ccode_node_unref0 (_tmp89_);
				_g_free0 (_tmp87_);
			} else {
				gboolean _tmp90_;
				gboolean _tmp91_;
				_tmp90_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp91_ = _tmp90_;
				if (_tmp91_) {
					ValaCCodeFunctionCall* _tmp92_;
					ValaMethod* _tmp93_;
					gchar* _tmp94_;
					gchar* _tmp95_;
					ValaCCodeIdentifier* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					_tmp92_ = ccall;
					_tmp93_ = m;
					_tmp94_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_ccode_identifier_new (_tmp95_);
					_tmp97_ = _tmp96_;
					vala_ccode_function_call_set_call (_tmp92_, (ValaCCodeExpression*) _tmp97_);
					_vala_ccode_node_unref0 (_tmp97_);
					_g_free0 (_tmp95_);
				}
			}
		}
	} else {
		ValaDataType* _tmp98_;
		_tmp98_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp99_;
			ValaSignalType* _tmp100_;
			gboolean _tmp101_ = FALSE;
			gboolean _tmp102_ = FALSE;
			ValaMemberAccess* _tmp103_;
			_tmp99_ = itype;
			_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp100_;
			_tmp103_ = ma;
			if (_tmp103_ != NULL) {
				ValaMemberAccess* _tmp104_;
				ValaExpression* _tmp105_;
				ValaExpression* _tmp106_;
				_tmp104_ = ma;
				_tmp105_ = vala_member_access_get_inner (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp107_;
				ValaSignal* _tmp108_;
				ValaSignal* _tmp109_;
				gboolean _tmp110_;
				gboolean _tmp111_;
				_tmp107_ = sig_type;
				_tmp108_ = vala_signal_type_get_signal_symbol (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = vala_signal_get_is_virtual (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp101_ = _tmp111_;
			} else {
				_tmp101_ = FALSE;
			}
			if (_tmp101_) {
				ValaSignalType* _tmp112_;
				ValaSignal* _tmp113_;
				ValaSignal* _tmp114_;
				ValaMethod* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				_tmp112_ = sig_type;
				_tmp113_ = vala_signal_type_get_signal_symbol (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = vala_signal_get_default_handler (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = _vala_code_node_ref0 (_tmp116_);
				_vala_code_node_unref0 (m);
				m = _tmp117_;
			} else {
				ValaExpression* _tmp118_;
				ValaExpression* _tmp119_;
				ValaCCodeExpression* _tmp120_;
				_tmp118_ = vala_method_call_get_call (expr);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp119_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp121_;
			_tmp121_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp121_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp122_;
				ValaObjectTypeSymbol* _tmp123_;
				ValaObjectTypeSymbol* _tmp124_;
				ValaClass* _tmp125_;
				ValaClass* _tmp126_;
				ValaCreationMethod* _tmp127_;
				ValaCreationMethod* _tmp128_;
				ValaMethod* _tmp129_;
				ValaMethod* _tmp130_;
				ValaCCodeFile* _tmp131_;
				gchar* real_name = NULL;
				ValaMethod* _tmp132_;
				gchar* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				const gchar* _tmp138_;
				ValaCCodeIdentifier* _tmp139_;
				ValaCCodeIdentifier* _tmp140_;
				ValaCCodeFunctionCall* _tmp141_;
				_tmp122_ = itype;
				_tmp123_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp124_ = _tmp123_;
				_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp125_;
				_tmp126_ = cl;
				_tmp127_ = vala_class_get_default_construction_method (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = _vala_code_node_ref0 ((ValaMethod*) _tmp128_);
				_vala_code_node_unref0 (m);
				m = _tmp129_;
				_tmp130_ = m;
				_tmp131_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp130_, _tmp131_);
				_tmp132_ = m;
				_tmp133_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp132_);
				real_name = _tmp133_;
				_tmp134_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp135_ = _tmp134_;
				if (_tmp135_) {
					ValaMethod* _tmp136_;
					gchar* _tmp137_;
					_tmp136_ = m;
					_tmp137_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp137_;
				}
				_tmp138_ = real_name;
				_tmp139_ = vala_ccode_identifier_new (_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp140_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp141_;
				_vala_ccode_node_unref0 (_tmp140_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp142_;
				_tmp142_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp143_;
					ValaTypeSymbol* _tmp144_;
					ValaTypeSymbol* _tmp145_;
					ValaStruct* _tmp146_;
					ValaStruct* _tmp147_;
					ValaCreationMethod* _tmp148_;
					ValaCreationMethod* _tmp149_;
					ValaMethod* _tmp150_;
					ValaMethod* _tmp151_;
					ValaCCodeFile* _tmp152_;
					ValaMethod* _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					ValaCCodeIdentifier* _tmp156_;
					ValaCCodeIdentifier* _tmp157_;
					ValaCCodeFunctionCall* _tmp158_;
					_tmp143_ = itype;
					_tmp144_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp145_ = _tmp144_;
					_tmp146_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp146_;
					_tmp147_ = st;
					_tmp148_ = vala_struct_get_default_construction_method (_tmp147_);
					_tmp149_ = _tmp148_;
					_tmp150_ = _vala_code_node_ref0 ((ValaMethod*) _tmp149_);
					_vala_code_node_unref0 (m);
					m = _tmp150_;
					_tmp151_ = m;
					_tmp152_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp151_, _tmp152_);
					_tmp153_ = m;
					_tmp154_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp153_);
					_tmp155_ = _tmp154_;
					_tmp156_ = vala_ccode_identifier_new (_tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp157_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp158_;
					_vala_ccode_node_unref0 (_tmp157_);
					_g_free0 (_tmp155_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp159_;
					_tmp159_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp160_;
						ValaDelegate* _tmp161_;
						ValaDelegate* _tmp162_;
						ValaDelegate* _tmp163_;
						_tmp160_ = itype;
						_tmp161_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp162_ = _tmp161_;
						_tmp163_ = _vala_code_node_ref0 (_tmp162_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp163_;
					}
				}
			}
		}
	}
	_tmp164_ = g_direct_hash;
	_tmp165_ = g_direct_equal;
	_tmp166_ = g_direct_equal;
	_tmp167_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp164_, _tmp165_, _tmp166_);
	in_arg_map = _tmp167_;
	_tmp168_ = in_arg_map;
	_tmp169_ = _vala_map_ref0 (_tmp168_);
	out_arg_map = _tmp169_;
	_tmp171_ = m;
	if (_tmp171_ != NULL) {
		ValaMethod* _tmp172_;
		gboolean _tmp173_;
		gboolean _tmp174_;
		_tmp172_ = m;
		_tmp173_ = vala_method_get_coroutine (_tmp172_);
		_tmp174_ = _tmp173_;
		_tmp170_ = _tmp174_;
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaMethod* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		ValaCCodeIdentifier* _tmp178_;
		ValaCCodeIdentifier* _tmp179_;
		ValaCCodeFunctionCall* _tmp180_;
		ValaMethod* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		ValaCCodeIdentifier* _tmp184_;
		ValaCCodeIdentifier* _tmp185_;
		ValaCCodeFunctionCall* _tmp186_;
		ValaMemberAccess* _tmp187_;
		ValaExpression* _tmp188_;
		ValaExpression* _tmp189_;
		gboolean _tmp265_ = FALSE;
		ValaMemberAccess* _tmp266_;
		const gchar* _tmp267_;
		const gchar* _tmp268_;
		_tmp175_ = m;
		_tmp176_ = vala_get_ccode_name ((ValaCodeNode*) _tmp175_);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_ccode_identifier_new (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp179_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp180_;
		_vala_ccode_node_unref0 (_tmp179_);
		_g_free0 (_tmp177_);
		_tmp181_ = m;
		_tmp182_ = vala_get_ccode_finish_name (_tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_ccode_identifier_new (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp185_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp186_;
		_vala_ccode_node_unref0 (_tmp185_);
		_g_free0 (_tmp183_);
		_tmp187_ = ma;
		_tmp188_ = vala_member_access_get_inner (_tmp187_);
		_tmp189_ = _tmp188_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp189_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp190_;
			ValaMethod* _tmp191_;
			ValaMethod* _tmp192_;
			_tmp190_ = m;
			_tmp191_ = vala_method_get_base_method (_tmp190_);
			_tmp192_ = _tmp191_;
			if (_tmp192_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp193_;
				ValaMethod* _tmp194_;
				ValaMethod* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaClass* _tmp198_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp199_;
				gchar* _tmp200_;
				gchar* _tmp201_;
				ValaCCodeIdentifier* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeFunctionCall* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeFunctionCall* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				ValaCCodeFunctionCall* _tmp215_;
				ValaCCodeFunctionCall* _tmp216_;
				ValaMethod* _tmp217_;
				gchar* _tmp218_;
				gchar* _tmp219_;
				ValaCCodeMemberAccess* _tmp220_;
				ValaCCodeMemberAccess* _tmp221_;
				ValaCCodeFunctionCall* _tmp222_;
				ValaCCodeFunctionCall* _tmp223_;
				ValaMethod* _tmp224_;
				gchar* _tmp225_;
				gchar* _tmp226_;
				ValaCCodeMemberAccess* _tmp227_;
				ValaCCodeMemberAccess* _tmp228_;
				_tmp193_ = m;
				_tmp194_ = vala_method_get_base_method (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp198_;
				_tmp199_ = base_class;
				_tmp200_ = vala_get_ccode_class_type_function (_tmp199_);
				_tmp201_ = _tmp200_;
				_tmp202_ = vala_ccode_identifier_new (_tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp203_);
				_tmp205_ = _tmp204_;
				_vala_ccode_node_unref0 (_tmp203_);
				_g_free0 (_tmp201_);
				vcast = _tmp205_;
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (_tmp206_, (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
				_tmp215_ = async_call;
				_tmp216_ = vcast;
				_tmp217_ = m;
				_tmp218_ = vala_get_ccode_vfunc_name (_tmp217_);
				_tmp219_ = _tmp218_;
				_tmp220_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp216_, _tmp219_);
				_tmp221_ = _tmp220_;
				vala_ccode_function_call_set_call (_tmp215_, (ValaCCodeExpression*) _tmp221_);
				_vala_ccode_node_unref0 (_tmp221_);
				_g_free0 (_tmp219_);
				_tmp222_ = finish_call;
				_tmp223_ = vcast;
				_tmp224_ = m;
				_tmp225_ = vala_get_ccode_finish_vfunc_name (_tmp224_);
				_tmp226_ = _tmp225_;
				_tmp227_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp223_, _tmp226_);
				_tmp228_ = _tmp227_;
				vala_ccode_function_call_set_call (_tmp222_, (ValaCCodeExpression*) _tmp228_);
				_vala_ccode_node_unref0 (_tmp228_);
				_g_free0 (_tmp226_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp229_;
				ValaMethod* _tmp230_;
				ValaMethod* _tmp231_;
				_tmp229_ = m;
				_tmp230_ = vala_method_get_base_interface_method (_tmp229_);
				_tmp231_ = _tmp230_;
				if (_tmp231_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp232_;
					ValaMethod* _tmp233_;
					ValaMethod* _tmp234_;
					ValaSymbol* _tmp235_;
					ValaSymbol* _tmp236_;
					ValaInterface* _tmp237_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp238_;
					ValaClass* _tmp239_;
					gchar* _tmp240_;
					gchar* _tmp241_;
					ValaInterface* _tmp242_;
					gchar* _tmp243_;
					gchar* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					ValaCCodeFunctionCall* _tmp247_;
					const gchar* _tmp248_;
					ValaCCodeIdentifier* _tmp249_;
					ValaCCodeIdentifier* _tmp250_;
					ValaMethod* _tmp251_;
					gchar* _tmp252_;
					gchar* _tmp253_;
					ValaCCodeMemberAccess* _tmp254_;
					ValaCCodeMemberAccess* _tmp255_;
					ValaCCodeFunctionCall* _tmp256_;
					const gchar* _tmp257_;
					ValaCCodeIdentifier* _tmp258_;
					ValaCCodeIdentifier* _tmp259_;
					ValaMethod* _tmp260_;
					gchar* _tmp261_;
					gchar* _tmp262_;
					ValaCCodeMemberAccess* _tmp263_;
					ValaCCodeMemberAccess* _tmp264_;
					_tmp232_ = m;
					_tmp233_ = vala_method_get_base_interface_method (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp237_;
					_tmp238_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp239_ = _tmp238_;
					_tmp240_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp239_, NULL);
					_tmp241_ = _tmp240_;
					_tmp242_ = base_iface;
					_tmp243_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp242_, NULL);
					_tmp244_ = _tmp243_;
					_tmp245_ = g_strdup_printf ("%s_%s_parent_iface", _tmp241_, _tmp244_);
					_tmp246_ = _tmp245_;
					_g_free0 (_tmp244_);
					_g_free0 (_tmp241_);
					parent_iface_var = _tmp246_;
					_tmp247_ = async_call;
					_tmp248_ = parent_iface_var;
					_tmp249_ = vala_ccode_identifier_new (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp251_ = m;
					_tmp252_ = vala_get_ccode_vfunc_name (_tmp251_);
					_tmp253_ = _tmp252_;
					_tmp254_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp250_, _tmp253_);
					_tmp255_ = _tmp254_;
					vala_ccode_function_call_set_call (_tmp247_, (ValaCCodeExpression*) _tmp255_);
					_vala_ccode_node_unref0 (_tmp255_);
					_g_free0 (_tmp253_);
					_vala_ccode_node_unref0 (_tmp250_);
					_tmp256_ = finish_call;
					_tmp257_ = parent_iface_var;
					_tmp258_ = vala_ccode_identifier_new (_tmp257_);
					_tmp259_ = _tmp258_;
					_tmp260_ = m;
					_tmp261_ = vala_get_ccode_finish_vfunc_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp263_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp259_, _tmp262_);
					_tmp264_ = _tmp263_;
					vala_ccode_function_call_set_call (_tmp256_, (ValaCCodeExpression*) _tmp264_);
					_vala_ccode_node_unref0 (_tmp264_);
					_g_free0 (_tmp262_);
					_vala_ccode_node_unref0 (_tmp259_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp266_ = ma;
		_tmp267_ = vala_member_access_get_member_name (_tmp266_);
		_tmp268_ = _tmp267_;
		if (g_strcmp0 (_tmp268_, "begin") == 0) {
			ValaMemberAccess* _tmp269_;
			ValaExpression* _tmp270_;
			ValaExpression* _tmp271_;
			ValaSymbol* _tmp272_;
			ValaSymbol* _tmp273_;
			ValaMemberAccess* _tmp274_;
			ValaSymbol* _tmp275_;
			ValaSymbol* _tmp276_;
			_tmp269_ = ma;
			_tmp270_ = vala_member_access_get_inner (_tmp269_);
			_tmp271_ = _tmp270_;
			_tmp272_ = vala_expression_get_symbol_reference (_tmp271_);
			_tmp273_ = _tmp272_;
			_tmp274_ = ma;
			_tmp275_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp274_);
			_tmp276_ = _tmp275_;
			_tmp265_ = _tmp273_ == _tmp276_;
		} else {
			_tmp265_ = FALSE;
		}
		if (_tmp265_) {
			ValaCCodeFunctionCall* _tmp277_;
			ValaCCodeFunctionCall* _tmp278_;
			ValaMethod* _tmp279_;
			ValaList* _tmp280_;
			_tmp277_ = async_call;
			_tmp278_ = _vala_ccode_node_ref0 (_tmp277_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp278_;
			_tmp279_ = m;
			_tmp280_ = vala_method_get_async_begin_parameters (_tmp279_);
			_vala_iterable_unref0 (params);
			params = _tmp280_;
		} else {
			gboolean _tmp281_ = FALSE;
			ValaMemberAccess* _tmp282_;
			const gchar* _tmp283_;
			const gchar* _tmp284_;
			_tmp282_ = ma;
			_tmp283_ = vala_member_access_get_member_name (_tmp282_);
			_tmp284_ = _tmp283_;
			if (g_strcmp0 (_tmp284_, "end") == 0) {
				ValaMemberAccess* _tmp285_;
				ValaExpression* _tmp286_;
				ValaExpression* _tmp287_;
				ValaSymbol* _tmp288_;
				ValaSymbol* _tmp289_;
				ValaMemberAccess* _tmp290_;
				ValaSymbol* _tmp291_;
				ValaSymbol* _tmp292_;
				_tmp285_ = ma;
				_tmp286_ = vala_member_access_get_inner (_tmp285_);
				_tmp287_ = _tmp286_;
				_tmp288_ = vala_expression_get_symbol_reference (_tmp287_);
				_tmp289_ = _tmp288_;
				_tmp290_ = ma;
				_tmp291_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp290_);
				_tmp292_ = _tmp291_;
				_tmp281_ = _tmp289_ == _tmp292_;
			} else {
				_tmp281_ = FALSE;
			}
			if (_tmp281_) {
				ValaCCodeFunctionCall* _tmp293_;
				ValaCCodeFunctionCall* _tmp294_;
				ValaMethod* _tmp295_;
				ValaList* _tmp296_;
				_tmp293_ = finish_call;
				_tmp294_ = _vala_ccode_node_ref0 (_tmp293_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp294_;
				_tmp295_ = m;
				_tmp296_ = vala_method_get_async_end_parameters (_tmp295_);
				_vala_iterable_unref0 (params);
				params = _tmp296_;
			} else {
				gboolean _tmp297_;
				gboolean _tmp298_;
				_tmp297_ = vala_method_call_get_is_yield_expression (expr);
				_tmp298_ = _tmp297_;
				if (!_tmp298_) {
					ValaCCodeFunctionCall* _tmp299_;
					ValaCCodeFunctionCall* _tmp300_;
					ValaMethod* _tmp301_;
					ValaList* _tmp302_;
					_tmp299_ = async_call;
					_tmp300_ = _vala_ccode_node_ref0 (_tmp299_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp300_;
					_tmp301_ = m;
					_tmp302_ = vala_method_get_async_begin_parameters (_tmp301_);
					_vala_iterable_unref0 (params);
					params = _tmp302_;
				} else {
					ValaCCodeFunctionCall* _tmp303_;
					ValaCCodeFunctionCall* _tmp304_;
					GHashFunc _tmp305_;
					GEqualFunc _tmp306_;
					GEqualFunc _tmp307_;
					ValaHashMap* _tmp308_;
					ValaHashMap* _tmp309_;
					ValaMethod* _tmp310_;
					ValaCCodeIdentifier* _tmp311_;
					ValaCCodeIdentifier* _tmp312_;
					ValaCCodeMemberAccess* _tmp313_;
					ValaCCodeMemberAccess* _tmp314_;
					_tmp303_ = finish_call;
					_tmp304_ = _vala_ccode_node_ref0 (_tmp303_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp304_;
					_tmp305_ = g_direct_hash;
					_tmp306_ = g_direct_equal;
					_tmp307_ = g_direct_equal;
					_tmp308_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp305_, _tmp306_, _tmp307_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp308_;
					_tmp309_ = out_arg_map;
					_tmp310_ = m;
					_tmp311_ = vala_ccode_identifier_new ("_data_");
					_tmp312_ = _tmp311_;
					_tmp313_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp312_, "_res_");
					_tmp314_ = _tmp313_;
					vala_map_set ((ValaMap*) _tmp309_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp310_), FALSE)), (ValaCCodeExpression*) _tmp314_);
					_vala_ccode_node_unref0 (_tmp314_);
					_vala_ccode_node_unref0 (_tmp312_);
				}
			}
		}
	}
	_tmp316_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp316_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp317_;
		ValaSymbol* _tmp318_;
		ValaSymbol* _tmp319_;
		_tmp317_ = m;
		_tmp318_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp317_);
		_tmp319_ = _tmp318_;
		_tmp315_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp319_, VALA_TYPE_CLASS);
	} else {
		_tmp315_ = FALSE;
	}
	if (_tmp315_) {
		ValaCodeContext* _tmp320_;
		ValaCodeContext* _tmp321_;
		ValaProfile _tmp322_;
		ValaProfile _tmp323_;
		ValaClass* _tmp335_;
		ValaClass* _tmp336_;
		gboolean _tmp337_;
		gboolean _tmp338_;
		_tmp320_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp321_ = _tmp320_;
		_tmp322_ = vala_code_context_get_profile (_tmp321_);
		_tmp323_ = _tmp322_;
		if (_tmp323_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp324_;
			ValaSymbol* _tmp325_;
			ValaSymbol* _tmp326_;
			gboolean _tmp327_;
			gboolean _tmp328_;
			_tmp324_ = m;
			_tmp325_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp324_);
			_tmp326_ = _tmp325_;
			_tmp327_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp326_, VALA_TYPE_CLASS, ValaClass));
			_tmp328_ = _tmp327_;
			if (!_tmp328_) {
				ValaCCodeFunctionCall* _tmp329_;
				ValaCCodeExpression* _tmp330_;
				ValaCCodeExpression* _tmp331_;
				_tmp329_ = ccall;
				_tmp330_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp331_ = _tmp330_;
				vala_ccode_function_call_add_argument (_tmp329_, _tmp331_);
				_vala_ccode_node_unref0 (_tmp331_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp332_;
			ValaCCodeExpression* _tmp333_;
			ValaCCodeExpression* _tmp334_;
			_tmp332_ = ccall;
			_tmp333_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp334_ = _tmp333_;
			vala_ccode_function_call_add_argument (_tmp332_, _tmp334_);
			_vala_ccode_node_unref0 (_tmp334_);
		}
		_tmp335_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp336_ = _tmp335_;
		_tmp337_ = vala_class_get_is_compact (_tmp336_);
		_tmp338_ = _tmp337_;
		if (!_tmp338_) {
			ValaClass* _tmp339_;
			ValaClass* _tmp340_;
			ValaMethod* _tmp341_;
			ValaSymbol* _tmp342_;
			ValaSymbol* _tmp343_;
			_tmp339_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp340_ = _tmp339_;
			_tmp341_ = m;
			_tmp342_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp341_);
			_tmp343_ = _tmp342_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp340_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp343_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp344_;
					ValaClass* _tmp345_;
					ValaList* _tmp346_;
					gint _base_type_size = 0;
					ValaList* _tmp347_;
					gint _tmp348_;
					gint _tmp349_;
					gint _base_type_index = 0;
					_tmp344_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp345_ = _tmp344_;
					_tmp346_ = vala_class_get_base_types (_tmp345_);
					_base_type_list = _tmp346_;
					_tmp347_ = _base_type_list;
					_tmp348_ = vala_collection_get_size ((ValaCollection*) _tmp347_);
					_tmp349_ = _tmp348_;
					_base_type_size = _tmp349_;
					_base_type_index = -1;
					while (TRUE) {
						ValaDataType* base_type = NULL;
						ValaList* _tmp350_;
						gpointer _tmp351_;
						ValaDataType* _tmp352_;
						ValaTypeSymbol* _tmp353_;
						ValaTypeSymbol* _tmp354_;
						_base_type_index = _base_type_index + 1;
						if (!(_base_type_index < _base_type_size)) {
							break;
						}
						_tmp350_ = _base_type_list;
						_tmp351_ = vala_list_get (_tmp350_, _base_type_index);
						base_type = (ValaDataType*) _tmp351_;
						_tmp352_ = base_type;
						_tmp353_ = vala_data_type_get_data_type (_tmp352_);
						_tmp354_ = _tmp353_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp354_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp355_;
							gchar* _tmp356_;
							gchar* _tmp357_;
							gboolean _tmp358_;
							ValaHashMap* _tmp363_;
							ValaDataType* _tmp364_;
							ValaList* _tmp365_;
							ValaList* _tmp366_;
							ValaList* _tmp367_;
							type_parameters = NULL;
							_tmp355_ = m;
							_tmp356_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp355_);
							_tmp357_ = _tmp356_;
							_tmp358_ = g_strcmp0 (_tmp357_, "g_object_new") == 0;
							_g_free0 (_tmp357_);
							if (_tmp358_) {
								ValaDataType* _tmp359_;
								ValaTypeSymbol* _tmp360_;
								ValaTypeSymbol* _tmp361_;
								ValaList* _tmp362_;
								_tmp359_ = base_type;
								_tmp360_ = vala_data_type_get_data_type (_tmp359_);
								_tmp361_ = _tmp360_;
								_tmp362_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp361_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp362_;
							}
							_tmp363_ = in_arg_map;
							_tmp364_ = base_type;
							_tmp365_ = vala_data_type_get_type_arguments (_tmp364_);
							_tmp366_ = _tmp365_;
							_tmp367_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp363_, _tmp366_, (ValaCodeNode*) expr, TRUE, _tmp367_);
							_vala_iterable_unref0 (_tmp366_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp368_;
				ValaSymbol* _tmp369_;
				ValaSymbol* _tmp370_;
				ValaClass* _tmp371_;
				type_param_index = 0;
				_tmp368_ = m;
				_tmp369_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp368_);
				_tmp370_ = _tmp369_;
				_tmp371_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp370_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp371_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp372_;
					ValaList* _tmp373_;
					gint _type_param_size = 0;
					ValaList* _tmp374_;
					gint _tmp375_;
					gint _tmp376_;
					gint _type_param_index = 0;
					_tmp372_ = cl;
					_tmp373_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp372_);
					_type_param_list = _tmp373_;
					_tmp374_ = _type_param_list;
					_tmp375_ = vala_collection_get_size ((ValaCollection*) _tmp374_);
					_tmp376_ = _tmp375_;
					_type_param_size = _tmp376_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp377_;
						gpointer _tmp378_;
						ValaHashMap* _tmp379_;
						ValaTypeParameter* _tmp380_;
						const gchar* _tmp381_;
						const gchar* _tmp382_;
						gchar* _tmp383_;
						gchar* _tmp384_;
						gchar* _tmp385_;
						gchar* _tmp386_;
						ValaCCodeIdentifier* _tmp387_;
						ValaCCodeIdentifier* _tmp388_;
						ValaHashMap* _tmp389_;
						ValaTypeParameter* _tmp390_;
						const gchar* _tmp391_;
						const gchar* _tmp392_;
						gchar* _tmp393_;
						gchar* _tmp394_;
						gchar* _tmp395_;
						gchar* _tmp396_;
						ValaCCodeIdentifier* _tmp397_;
						ValaCCodeIdentifier* _tmp398_;
						ValaHashMap* _tmp399_;
						ValaTypeParameter* _tmp400_;
						const gchar* _tmp401_;
						const gchar* _tmp402_;
						gchar* _tmp403_;
						gchar* _tmp404_;
						gchar* _tmp405_;
						gchar* _tmp406_;
						ValaCCodeIdentifier* _tmp407_;
						ValaCCodeIdentifier* _tmp408_;
						gint _tmp409_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp377_ = _type_param_list;
						_tmp378_ = vala_list_get (_tmp377_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp378_;
						_tmp379_ = in_arg_map;
						_tmp380_ = type_param;
						_tmp381_ = vala_symbol_get_name ((ValaSymbol*) _tmp380_);
						_tmp382_ = _tmp381_;
						_tmp383_ = g_utf8_strdown (_tmp382_, (gssize) -1);
						_tmp384_ = _tmp383_;
						_tmp385_ = g_strdup_printf ("%s_type", _tmp384_);
						_tmp386_ = _tmp385_;
						_tmp387_ = vala_ccode_identifier_new (_tmp386_);
						_tmp388_ = _tmp387_;
						vala_map_set ((ValaMap*) _tmp379_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp388_);
						_vala_ccode_node_unref0 (_tmp388_);
						_g_free0 (_tmp386_);
						_g_free0 (_tmp384_);
						_tmp389_ = in_arg_map;
						_tmp390_ = type_param;
						_tmp391_ = vala_symbol_get_name ((ValaSymbol*) _tmp390_);
						_tmp392_ = _tmp391_;
						_tmp393_ = g_utf8_strdown (_tmp392_, (gssize) -1);
						_tmp394_ = _tmp393_;
						_tmp395_ = g_strdup_printf ("%s_dup_func", _tmp394_);
						_tmp396_ = _tmp395_;
						_tmp397_ = vala_ccode_identifier_new (_tmp396_);
						_tmp398_ = _tmp397_;
						vala_map_set ((ValaMap*) _tmp389_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp398_);
						_vala_ccode_node_unref0 (_tmp398_);
						_g_free0 (_tmp396_);
						_g_free0 (_tmp394_);
						_tmp399_ = in_arg_map;
						_tmp400_ = type_param;
						_tmp401_ = vala_symbol_get_name ((ValaSymbol*) _tmp400_);
						_tmp402_ = _tmp401_;
						_tmp403_ = g_utf8_strdown (_tmp402_, (gssize) -1);
						_tmp404_ = _tmp403_;
						_tmp405_ = g_strdup_printf ("%s_destroy_func", _tmp404_);
						_tmp406_ = _tmp405_;
						_tmp407_ = vala_ccode_identifier_new (_tmp406_);
						_tmp408_ = _tmp407_;
						vala_map_set ((ValaMap*) _tmp399_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp408_);
						_vala_ccode_node_unref0 (_tmp408_);
						_g_free0 (_tmp406_);
						_g_free0 (_tmp404_);
						_tmp409_ = type_param_index;
						type_param_index = _tmp409_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp410_;
			ValaClass* _tmp411_;
			ValaClass* _tmp412_;
			ValaClass* _tmp413_;
			ValaClass* _tmp414_;
			_tmp410_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp411_ = _tmp410_;
			_tmp412_ = vala_class_get_base_class (_tmp411_);
			_tmp413_ = _tmp412_;
			_tmp414_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp413_ == _tmp414_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp415_;
				ValaClass* _tmp416_;
				gchar* _tmp417_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp418_;
				ValaCCodeDeclaration* _tmp419_;
				ValaCCodeDeclaration* _tmp420_;
				const gchar* _tmp421_;
				const gchar* _tmp422_;
				const gchar* _tmp423_;
				const gchar* _tmp424_;
				gchar* _tmp425_;
				gchar* _tmp426_;
				ValaCCodeConstant* _tmp427_;
				ValaCCodeConstant* _tmp428_;
				ValaCCodeVariableDeclarator* _tmp429_;
				ValaCCodeVariableDeclarator* _tmp430_;
				ValaCCodeFunction* _tmp431_;
				ValaCCodeFunction* _tmp432_;
				ValaCCodeDeclaration* _tmp433_;
				ValaCCodeFunctionCall* _tmp434_;
				ValaCCodeIdentifier* _tmp435_;
				ValaCCodeIdentifier* _tmp436_;
				ValaCCodeUnaryExpression* _tmp437_;
				ValaCCodeUnaryExpression* _tmp438_;
				ValaCCodeCastExpression* _tmp439_;
				ValaCCodeCastExpression* _tmp440_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp441_;
				ValaCCodeIdentifier* _tmp442_;
				ValaCCodeFunctionCall* _tmp443_;
				ValaCCodeFunctionCall* _tmp444_;
				ValaCCodeFunctionCall* _tmp445_;
				ValaClass* _tmp446_;
				ValaClass* _tmp447_;
				gchar* _tmp448_;
				gchar* _tmp449_;
				ValaCCodeIdentifier* _tmp450_;
				ValaCCodeIdentifier* _tmp451_;
				ValaCCodeFunctionCall* _tmp452_;
				ValaCCodeFunctionCall* _tmp453_;
				_tmp415_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp416_ = _tmp415_;
				_tmp417_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp416_, NULL);
				class_prefix = _tmp417_;
				_tmp418_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp418_;
				_tmp419_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp419_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp420_ = funcs;
				_tmp421_ = class_prefix;
				_tmp422_ = class_prefix;
				_tmp423_ = class_prefix;
				_tmp424_ = class_prefix;
				_tmp425_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp421_, _tmp422_, _tmp423_, _tmp424_);
				_tmp426_ = _tmp425_;
				_tmp427_ = vala_ccode_constant_new (_tmp426_);
				_tmp428_ = _tmp427_;
				_tmp429_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp428_, NULL);
				_tmp430_ = _tmp429_;
				vala_ccode_declaration_add_declarator (_tmp420_, (ValaCCodeDeclarator*) _tmp430_);
				_vala_ccode_node_unref0 (_tmp430_);
				_vala_ccode_node_unref0 (_tmp428_);
				_g_free0 (_tmp426_);
				_tmp431_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp432_ = _tmp431_;
				_tmp433_ = funcs;
				vala_ccode_function_add_statement (_tmp432_, (ValaCCodeNode*) _tmp433_);
				_tmp434_ = ccall;
				_tmp435_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp436_ = _tmp435_;
				_tmp437_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp436_);
				_tmp438_ = _tmp437_;
				_tmp439_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp438_, "GSourceFuncs *");
				_tmp440_ = _tmp439_;
				vala_ccode_function_call_add_argument (_tmp434_, (ValaCCodeExpression*) _tmp440_);
				_vala_ccode_node_unref0 (_tmp440_);
				_vala_ccode_node_unref0 (_tmp438_);
				_vala_ccode_node_unref0 (_tmp436_);
				_tmp441_ = vala_ccode_identifier_new ("sizeof");
				_tmp442_ = _tmp441_;
				_tmp443_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp442_);
				_tmp444_ = _tmp443_;
				_vala_ccode_node_unref0 (_tmp442_);
				csizeof = _tmp444_;
				_tmp445_ = csizeof;
				_tmp446_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp447_ = _tmp446_;
				_tmp448_ = vala_get_ccode_name ((ValaCodeNode*) _tmp447_);
				_tmp449_ = _tmp448_;
				_tmp450_ = vala_ccode_identifier_new (_tmp449_);
				_tmp451_ = _tmp450_;
				vala_ccode_function_call_add_argument (_tmp445_, (ValaCCodeExpression*) _tmp451_);
				_vala_ccode_node_unref0 (_tmp451_);
				_g_free0 (_tmp449_);
				_tmp452_ = ccall;
				_tmp453_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp452_, (ValaCCodeExpression*) _tmp453_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp454_ = FALSE;
		ValaMethod* _tmp455_;
		_tmp455_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp455_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp456_;
			ValaSymbol* _tmp457_;
			ValaSymbol* _tmp458_;
			_tmp456_ = m;
			_tmp457_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp456_);
			_tmp458_ = _tmp457_;
			_tmp454_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp458_, VALA_TYPE_STRUCT);
		} else {
			_tmp454_ = FALSE;
		}
		if (_tmp454_) {
			ValaCCodeFunctionCall* _tmp459_;
			ValaCCodeExpression* _tmp460_;
			ValaCCodeExpression* _tmp461_;
			_tmp459_ = ccall;
			_tmp460_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp461_ = _tmp460_;
			vala_ccode_function_call_add_argument (_tmp459_, _tmp461_);
			_vala_ccode_node_unref0 (_tmp461_);
		} else {
			gboolean _tmp462_ = FALSE;
			gboolean _tmp463_ = FALSE;
			gboolean _tmp464_ = FALSE;
			gboolean _tmp465_ = FALSE;
			ValaMethod* _tmp466_;
			_tmp466_ = m;
			if (_tmp466_ != NULL) {
				ValaMethod* _tmp467_;
				_tmp467_ = m;
				_tmp465_ = vala_method_has_type_parameters (_tmp467_);
			} else {
				_tmp465_ = FALSE;
			}
			if (_tmp465_) {
				ValaMethod* _tmp468_;
				_tmp468_ = m;
				_tmp464_ = !vala_get_ccode_has_generic_type_parameter (_tmp468_);
			} else {
				_tmp464_ = FALSE;
			}
			if (_tmp464_) {
				ValaMethod* _tmp469_;
				_tmp469_ = m;
				_tmp463_ = !vala_get_ccode_simple_generics (_tmp469_);
			} else {
				_tmp463_ = FALSE;
			}
			if (_tmp463_) {
				gboolean _tmp470_ = FALSE;
				ValaCCodeFunctionCall* _tmp471_;
				ValaCCodeFunctionCall* _tmp472_;
				_tmp471_ = ccall;
				_tmp472_ = finish_call;
				if (_tmp471_ != _tmp472_) {
					_tmp470_ = TRUE;
				} else {
					gboolean _tmp473_;
					gboolean _tmp474_;
					_tmp473_ = vala_method_call_get_is_yield_expression (expr);
					_tmp474_ = _tmp473_;
					_tmp470_ = _tmp474_;
				}
				_tmp462_ = _tmp470_;
			} else {
				_tmp462_ = FALSE;
			}
			if (_tmp462_) {
				ValaHashMap* _tmp475_;
				ValaMemberAccess* _tmp476_;
				ValaList* _tmp477_;
				ValaList* _tmp478_;
				_tmp475_ = in_arg_map;
				_tmp476_ = ma;
				_tmp477_ = vala_member_access_get_type_arguments (_tmp476_);
				_tmp478_ = _tmp477_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp475_, _tmp478_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp478_);
			}
		}
	}
	_tmp479_ = ccall;
	_tmp480_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp479_);
	ccall_expr = _tmp480_;
	_tmp481_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp481_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp482_;
		ValaExpression* _tmp483_;
		ValaExpression* _tmp484_;
		ValaDataType* _tmp485_;
		ValaDataType* _tmp486_;
		ValaArrayType* _tmp487_;
		ValaHashMap* _tmp488_;
		ValaArrayType* _tmp489_;
		ValaDataType* _tmp490_;
		ValaDataType* _tmp491_;
		gchar* _tmp492_;
		gchar* _tmp493_;
		ValaCCodeIdentifier* _tmp494_;
		ValaCCodeIdentifier* _tmp495_;
		_tmp482_ = ma;
		_tmp483_ = vala_member_access_get_inner (_tmp482_);
		_tmp484_ = _tmp483_;
		_tmp485_ = vala_expression_get_value_type (_tmp484_);
		_tmp486_ = _tmp485_;
		_tmp487_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp486_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp487_;
		_tmp488_ = in_arg_map;
		_tmp489_ = array_type;
		_tmp490_ = vala_array_type_get_element_type (_tmp489_);
		_tmp491_ = _tmp490_;
		_tmp492_ = vala_get_ccode_name ((ValaCodeNode*) _tmp491_);
		_tmp493_ = _tmp492_;
		_tmp494_ = vala_ccode_identifier_new (_tmp493_);
		_tmp495_ = _tmp494_;
		vala_map_set ((ValaMap*) _tmp488_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp495_);
		_vala_ccode_node_unref0 (_tmp495_);
		_g_free0 (_tmp493_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp496_;
		_tmp496_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp496_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp497_;
			_tmp497_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp497_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp498_;
				ValaExpression* _tmp499_;
				ValaExpression* _tmp500_;
				ValaTargetValue* _tmp501_;
				ValaTargetValue* _tmp502_;
				ValaTargetValue* _tmp503_;
				ValaTargetValue* _tmp504_;
				_tmp498_ = ma;
				_tmp499_ = vala_member_access_get_inner (_tmp498_);
				_tmp500_ = _tmp499_;
				_tmp501_ = vala_expression_get_target_value (_tmp500_);
				_tmp502_ = _tmp501_;
				_tmp503_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp502_, (ValaCodeNode*) expr);
				_tmp504_ = _tmp503_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp504_);
				_vala_target_value_unref0 (_tmp504_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp506_ = m;
	if (_tmp506_ != NULL) {
		ValaMethod* _tmp507_;
		gboolean _tmp508_;
		gboolean _tmp509_;
		_tmp507_ = m;
		_tmp508_ = vala_method_get_is_async_callback (_tmp507_);
		_tmp509_ = _tmp508_;
		_tmp505_ = _tmp509_;
	} else {
		_tmp505_ = FALSE;
	}
	if (_tmp505_) {
		ValaMethod* _tmp510_;
		ValaMethod* _tmp511_;
		gboolean _tmp512_;
		gboolean _tmp513_;
		ValaHashMap* _tmp527_;
		ValaMethod* _tmp528_;
		ValaCCodeExpression* _tmp529_;
		ValaHashMap* _tmp530_;
		ValaMethod* _tmp531_;
		ValaCCodeExpression* _tmp532_;
		_tmp510_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp511_ = _tmp510_;
		_tmp512_ = vala_method_get_closure (_tmp511_);
		_tmp513_ = _tmp512_;
		if (_tmp513_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp514_;
			ValaSymbol* _tmp515_;
			ValaSymbol* _tmp516_;
			ValaBlock* _tmp517_;
			ValaBlock* _tmp518_;
			ValaBlock* _tmp519_;
			ValaBlock* _tmp520_;
			gchar* _tmp521_;
			gchar* _tmp522_;
			ValaCCodeExpression* _tmp523_;
			ValaCCodeExpression* _tmp524_;
			ValaCCodeMemberAccess* _tmp525_;
			_tmp514_ = m;
			_tmp515_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp514_);
			_tmp516_ = _tmp515_;
			_tmp517_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp516_, VALA_TYPE_METHOD, ValaMethod));
			_tmp518_ = _tmp517_;
			_tmp519_ = _vala_code_node_ref0 (_tmp518_);
			block = _tmp519_;
			_tmp520_ = block;
			_tmp521_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp520_));
			_tmp522_ = _tmp521_;
			_tmp523_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp522_);
			_tmp524_ = _tmp523_;
			_tmp525_ = vala_ccode_member_access_new_pointer (_tmp524_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp525_;
			_vala_ccode_node_unref0 (_tmp524_);
			_g_free0 (_tmp522_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp526_;
			_tmp526_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp526_;
		}
		_tmp527_ = in_arg_map;
		_tmp528_ = m;
		_tmp529_ = instance;
		vala_map_set ((ValaMap*) _tmp527_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp528_), FALSE)), _tmp529_);
		_tmp530_ = out_arg_map;
		_tmp531_ = m;
		_tmp532_ = instance;
		vala_map_set ((ValaMap*) _tmp530_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp531_), FALSE)), _tmp532_);
	} else {
		gboolean _tmp533_ = FALSE;
		gboolean _tmp534_ = FALSE;
		ValaMethod* _tmp535_;
		_tmp535_ = m;
		if (_tmp535_ != NULL) {
			ValaMethod* _tmp536_;
			ValaMemberBinding _tmp537_;
			ValaMemberBinding _tmp538_;
			_tmp536_ = m;
			_tmp537_ = vala_method_get_binding (_tmp536_);
			_tmp538_ = _tmp537_;
			_tmp534_ = _tmp538_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp534_ = FALSE;
		}
		if (_tmp534_) {
			ValaMethod* _tmp539_;
			_tmp539_ = m;
			_tmp533_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp539_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp533_ = FALSE;
		}
		if (_tmp533_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp540_;
			ValaExpression* _tmp541_;
			ValaExpression* _tmp542_;
			ValaTargetValue* _tmp543_;
			ValaTargetValue* _tmp544_;
			ValaTargetValue* _tmp545_;
			gboolean _tmp546_ = FALSE;
			gboolean _tmp547_ = FALSE;
			ValaMemberAccess* _tmp548_;
			const gchar* _tmp549_;
			const gchar* _tmp550_;
			ValaTargetValue* _tmp572_;
			ValaCCodeExpression* _tmp573_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp574_;
			ValaSymbol* _tmp575_;
			ValaSymbol* _tmp576_;
			ValaStruct* _tmp577_;
			gboolean _tmp578_ = FALSE;
			ValaStruct* _tmp579_;
			gboolean _tmp588_;
			gboolean _tmp589_;
			_tmp540_ = ma;
			_tmp541_ = vala_member_access_get_inner (_tmp540_);
			_tmp542_ = _tmp541_;
			_tmp543_ = vala_expression_get_target_value (_tmp542_);
			_tmp544_ = _tmp543_;
			_tmp545_ = _vala_target_value_ref0 (_tmp544_);
			instance_value = _tmp545_;
			_tmp548_ = ma;
			_tmp549_ = vala_member_access_get_member_name (_tmp548_);
			_tmp550_ = _tmp549_;
			if (g_strcmp0 (_tmp550_, "begin") == 0) {
				_tmp547_ = TRUE;
			} else {
				ValaMemberAccess* _tmp551_;
				const gchar* _tmp552_;
				const gchar* _tmp553_;
				_tmp551_ = ma;
				_tmp552_ = vala_member_access_get_member_name (_tmp551_);
				_tmp553_ = _tmp552_;
				_tmp547_ = g_strcmp0 (_tmp553_, "end") == 0;
			}
			if (_tmp547_) {
				ValaMemberAccess* _tmp554_;
				ValaExpression* _tmp555_;
				ValaExpression* _tmp556_;
				ValaSymbol* _tmp557_;
				ValaSymbol* _tmp558_;
				ValaMemberAccess* _tmp559_;
				ValaSymbol* _tmp560_;
				ValaSymbol* _tmp561_;
				_tmp554_ = ma;
				_tmp555_ = vala_member_access_get_inner (_tmp554_);
				_tmp556_ = _tmp555_;
				_tmp557_ = vala_expression_get_symbol_reference (_tmp556_);
				_tmp558_ = _tmp557_;
				_tmp559_ = ma;
				_tmp560_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp559_);
				_tmp561_ = _tmp560_;
				_tmp546_ = _tmp558_ == _tmp561_;
			} else {
				_tmp546_ = FALSE;
			}
			if (_tmp546_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp562_;
				ValaExpression* _tmp563_;
				ValaExpression* _tmp564_;
				ValaMemberAccess* _tmp565_;
				ValaMemberAccess* _tmp566_;
				ValaExpression* _tmp567_;
				ValaExpression* _tmp568_;
				ValaTargetValue* _tmp569_;
				ValaTargetValue* _tmp570_;
				ValaTargetValue* _tmp571_;
				_tmp562_ = ma;
				_tmp563_ = vala_member_access_get_inner (_tmp562_);
				_tmp564_ = _tmp563_;
				_tmp565_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp564_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp565_;
				_tmp566_ = inner_ma;
				_tmp567_ = vala_member_access_get_inner (_tmp566_);
				_tmp568_ = _tmp567_;
				_tmp569_ = vala_expression_get_target_value (_tmp568_);
				_tmp570_ = _tmp569_;
				_tmp571_ = _vala_target_value_ref0 (_tmp570_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp571_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp572_ = instance_value;
			_tmp573_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp572_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp573_;
			_tmp574_ = m;
			_tmp575_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp574_);
			_tmp576_ = _tmp575_;
			_tmp577_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp576_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp576_) : NULL);
			st = _tmp577_;
			_tmp579_ = st;
			if (_tmp579_ != NULL) {
				ValaStruct* _tmp580_;
				_tmp580_ = st;
				_tmp578_ = !vala_struct_is_simple_type (_tmp580_);
			} else {
				_tmp578_ = FALSE;
			}
			if (_tmp578_) {
				ValaTargetValue* _tmp581_;
				ValaTargetValue* _tmp584_;
				ValaCCodeExpression* _tmp585_;
				ValaCCodeExpression* _tmp586_;
				ValaCCodeUnaryExpression* _tmp587_;
				_tmp581_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp581_)) {
					ValaTargetValue* _tmp582_;
					ValaTargetValue* _tmp583_;
					_tmp582_ = instance_value;
					_tmp583_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp582_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp583_;
				}
				_tmp584_ = instance_value;
				_tmp585_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp584_);
				_tmp586_ = _tmp585_;
				_tmp587_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp586_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp587_;
				_vala_ccode_node_unref0 (_tmp586_);
			}
			_tmp588_ = vala_method_call_get_is_yield_expression (expr);
			_tmp589_ = _tmp588_;
			if (_tmp589_) {
				ValaHashMap* _tmp590_;
				ValaMethod* _tmp591_;
				ValaCCodeExpression* _tmp592_;
				ValaMethod* _tmp593_;
				_tmp590_ = in_arg_map;
				_tmp591_ = m;
				_tmp592_ = instance;
				vala_map_set ((ValaMap*) _tmp590_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp591_), FALSE)), _tmp592_);
				_tmp593_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp593_)) {
					ValaHashMap* _tmp594_;
					ValaMethod* _tmp595_;
					ValaCCodeExpression* _tmp596_;
					_tmp594_ = out_arg_map;
					_tmp595_ = m;
					_tmp596_ = instance;
					vala_map_set ((ValaMap*) _tmp594_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp595_), FALSE)), _tmp596_);
				}
			} else {
				gboolean _tmp597_ = FALSE;
				ValaMemberAccess* _tmp598_;
				const gchar* _tmp599_;
				const gchar* _tmp600_;
				_tmp598_ = ma;
				_tmp599_ = vala_member_access_get_member_name (_tmp598_);
				_tmp600_ = _tmp599_;
				if (g_strcmp0 (_tmp600_, "end") != 0) {
					_tmp597_ = TRUE;
				} else {
					ValaMethod* _tmp601_;
					_tmp601_ = m;
					_tmp597_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp601_);
				}
				if (_tmp597_) {
					ValaHashMap* _tmp602_;
					ValaMethod* _tmp603_;
					ValaCCodeExpression* _tmp604_;
					ValaHashMap* _tmp605_;
					ValaMethod* _tmp606_;
					ValaCCodeExpression* _tmp607_;
					_tmp602_ = out_arg_map;
					_tmp603_ = m;
					_tmp604_ = instance;
					vala_map_set ((ValaMap*) _tmp602_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp603_), FALSE)), _tmp604_);
					_tmp605_ = in_arg_map;
					_tmp606_ = m;
					_tmp607_ = instance;
					vala_map_set ((ValaMap*) _tmp605_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp606_), FALSE)), _tmp607_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp608_ = FALSE;
			ValaMethod* _tmp609_;
			_tmp609_ = m;
			if (_tmp609_ != NULL) {
				ValaMethod* _tmp610_;
				ValaMemberBinding _tmp611_;
				ValaMemberBinding _tmp612_;
				_tmp610_ = m;
				_tmp611_ = vala_method_get_binding (_tmp610_);
				_tmp612_ = _tmp611_;
				_tmp608_ = _tmp612_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp608_ = FALSE;
			}
			if (_tmp608_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp613_;
				ValaSymbol* _tmp614_;
				ValaSymbol* _tmp615_;
				ValaClass* _tmp616_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp617_;
				gchar* _tmp618_;
				gchar* _tmp619_;
				ValaCCodeIdentifier* _tmp620_;
				ValaCCodeIdentifier* _tmp621_;
				ValaCCodeFunctionCall* _tmp622_;
				ValaCCodeFunctionCall* _tmp623_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp624_;
				ValaExpression* _tmp625_;
				ValaExpression* _tmp626_;
				ValaCCodeFunctionCall* _tmp652_;
				ValaCCodeExpression* _tmp653_;
				ValaHashMap* _tmp654_;
				ValaMethod* _tmp655_;
				ValaCCodeFunctionCall* _tmp656_;
				ValaHashMap* _tmp657_;
				ValaMethod* _tmp658_;
				ValaCCodeFunctionCall* _tmp659_;
				_tmp613_ = m;
				_tmp614_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp613_);
				_tmp615_ = _tmp614_;
				_tmp616_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp615_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp616_;
				_tmp617_ = cl;
				_tmp618_ = vala_get_ccode_class_type_function (_tmp617_);
				_tmp619_ = _tmp618_;
				_tmp620_ = vala_ccode_identifier_new (_tmp619_);
				_tmp621_ = _tmp620_;
				_tmp622_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp621_);
				_tmp623_ = _tmp622_;
				_vala_ccode_node_unref0 (_tmp621_);
				_g_free0 (_tmp619_);
				cast = _tmp623_;
				_tmp624_ = ma;
				_tmp625_ = vala_member_access_get_inner (_tmp624_);
				_tmp626_ = _tmp625_;
				if (_tmp626_ == NULL) {
					ValaDataType* _tmp627_;
					ValaDataType* _tmp628_;
					gboolean _tmp629_;
					_tmp627_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp628_ = _tmp627_;
					_tmp629_ = _tmp628_ == NULL;
					_vala_code_node_unref0 (_tmp628_);
					if (_tmp629_) {
						ValaCCodeIdentifier* _tmp630_;
						_tmp630_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp630_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp631_;
						ValaCCodeIdentifier* _tmp632_;
						ValaCCodeFunctionCall* _tmp633_;
						ValaCCodeFunctionCall* _tmp634_;
						ValaCCodeFunctionCall* _tmp635_;
						ValaCCodeExpression* _tmp636_;
						ValaCCodeExpression* _tmp637_;
						ValaCCodeFunctionCall* _tmp638_;
						ValaCCodeExpression* _tmp639_;
						_tmp631_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp632_ = _tmp631_;
						_tmp633_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp632_);
						_tmp634_ = _tmp633_;
						_vala_ccode_node_unref0 (_tmp632_);
						k = _tmp634_;
						_tmp635_ = k;
						_tmp636_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp637_ = _tmp636_;
						vala_ccode_function_call_add_argument (_tmp635_, _tmp637_);
						_vala_ccode_node_unref0 (_tmp637_);
						_tmp638_ = k;
						_tmp639_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp638_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp639_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp640_;
					ValaCCodeIdentifier* _tmp641_;
					ValaCCodeFunctionCall* _tmp642_;
					ValaCCodeFunctionCall* _tmp643_;
					ValaCCodeFunctionCall* _tmp644_;
					ValaMemberAccess* _tmp645_;
					ValaExpression* _tmp646_;
					ValaExpression* _tmp647_;
					ValaCCodeExpression* _tmp648_;
					ValaCCodeExpression* _tmp649_;
					ValaCCodeFunctionCall* _tmp650_;
					ValaCCodeExpression* _tmp651_;
					_tmp640_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp641_ = _tmp640_;
					_tmp642_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp641_);
					_tmp643_ = _tmp642_;
					_vala_ccode_node_unref0 (_tmp641_);
					k = _tmp643_;
					_tmp644_ = k;
					_tmp645_ = ma;
					_tmp646_ = vala_member_access_get_inner (_tmp645_);
					_tmp647_ = _tmp646_;
					_tmp648_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp647_);
					_tmp649_ = _tmp648_;
					vala_ccode_function_call_add_argument (_tmp644_, _tmp649_);
					_vala_ccode_node_unref0 (_tmp649_);
					_tmp650_ = k;
					_tmp651_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp650_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp651_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp652_ = cast;
				_tmp653_ = klass;
				vala_ccode_function_call_add_argument (_tmp652_, _tmp653_);
				_tmp654_ = in_arg_map;
				_tmp655_ = m;
				_tmp656_ = cast;
				vala_map_set ((ValaMap*) _tmp654_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp655_), FALSE)), (ValaCCodeExpression*) _tmp656_);
				_tmp657_ = out_arg_map;
				_tmp658_ = m;
				_tmp659_ = cast;
				vala_map_set ((ValaMap*) _tmp657_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp658_), FALSE)), (ValaCCodeExpression*) _tmp659_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp661_ = m;
	if (_tmp661_ != NULL) {
		ValaMethod* _tmp662_;
		_tmp662_ = m;
		_tmp660_ = vala_get_ccode_has_generic_type_parameter (_tmp662_);
	} else {
		_tmp660_ = FALSE;
	}
	if (_tmp660_) {
		ValaMethod* _tmp663_;
		_tmp663_ = m;
		if (vala_method_has_type_parameters (_tmp663_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp664_;
				ValaList* _tmp665_;
				gint _type_arg_size = 0;
				ValaList* _tmp666_;
				gint _tmp667_;
				gint _tmp668_;
				gint _type_arg_index = 0;
				_tmp664_ = ma;
				_tmp665_ = vala_member_access_get_type_arguments (_tmp664_);
				_type_arg_list = _tmp665_;
				_tmp666_ = _type_arg_list;
				_tmp667_ = vala_collection_get_size ((ValaCollection*) _tmp666_);
				_tmp668_ = _tmp667_;
				_type_arg_size = _tmp668_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp669_;
					gpointer _tmp670_;
					gboolean _tmp671_ = FALSE;
					gboolean _tmp672_ = FALSE;
					gboolean _tmp673_ = FALSE;
					ValaMethod* _tmp674_;
					ValaHashMap* _tmp682_;
					ValaMethod* _tmp683_;
					ValaDataType* _tmp684_;
					gchar* _tmp685_;
					gchar* _tmp686_;
					ValaCCodeIdentifier* _tmp687_;
					ValaCCodeIdentifier* _tmp688_;
					gint _tmp689_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp669_ = _type_arg_list;
					_tmp670_ = vala_list_get (_tmp669_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp670_;
					_tmp674_ = m;
					if (vala_get_ccode_simple_generics (_tmp674_)) {
						ValaDataType* _tmp675_;
						_tmp675_ = type_arg;
						_tmp673_ = vala_data_type_is_real_struct_type (_tmp675_);
					} else {
						_tmp673_ = FALSE;
					}
					if (_tmp673_) {
						ValaDataType* _tmp676_;
						gboolean _tmp677_;
						gboolean _tmp678_;
						_tmp676_ = type_arg;
						_tmp677_ = vala_data_type_get_nullable (_tmp676_);
						_tmp678_ = _tmp677_;
						_tmp672_ = !_tmp678_;
					} else {
						_tmp672_ = FALSE;
					}
					if (_tmp672_) {
						ValaDataType* _tmp679_;
						_tmp679_ = type_arg;
						_tmp671_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp679_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp671_ = FALSE;
					}
					if (_tmp671_) {
						ValaDataType* _tmp680_;
						ValaPointerType* _tmp681_;
						_tmp680_ = type_arg;
						_tmp681_ = vala_pointer_type_new (_tmp680_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp681_;
					}
					_tmp682_ = in_arg_map;
					_tmp683_ = m;
					_tmp684_ = type_arg;
					_tmp685_ = vala_get_ccode_name ((ValaCodeNode*) _tmp684_);
					_tmp686_ = _tmp685_;
					_tmp687_ = vala_ccode_identifier_new (_tmp686_);
					_tmp688_ = _tmp687_;
					vala_map_set ((ValaMap*) _tmp682_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp683_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp688_);
					_vala_ccode_node_unref0 (_tmp688_);
					_g_free0 (_tmp686_);
					_tmp689_ = type_param_index;
					type_param_index = _tmp689_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp690_;
				ValaExpression* _tmp691_;
				ValaExpression* _tmp692_;
				ValaDataType* _tmp693_;
				ValaDataType* _tmp694_;
				ValaList* _tmp695_;
				gint _type_arg_size = 0;
				ValaList* _tmp696_;
				gint _tmp697_;
				gint _tmp698_;
				gint _type_arg_index = 0;
				_tmp690_ = ma;
				_tmp691_ = vala_member_access_get_inner (_tmp690_);
				_tmp692_ = _tmp691_;
				_tmp693_ = vala_expression_get_value_type (_tmp692_);
				_tmp694_ = _tmp693_;
				_tmp695_ = vala_data_type_get_type_arguments (_tmp694_);
				_type_arg_list = _tmp695_;
				_tmp696_ = _type_arg_list;
				_tmp697_ = vala_collection_get_size ((ValaCollection*) _tmp696_);
				_tmp698_ = _tmp697_;
				_type_arg_size = _tmp698_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp699_;
					gpointer _tmp700_;
					ValaHashMap* _tmp701_;
					ValaMethod* _tmp702_;
					ValaDataType* _tmp703_;
					gchar* _tmp704_;
					gchar* _tmp705_;
					ValaCCodeIdentifier* _tmp706_;
					ValaCCodeIdentifier* _tmp707_;
					gint _tmp708_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp699_ = _type_arg_list;
					_tmp700_ = vala_list_get (_tmp699_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp700_;
					_tmp701_ = in_arg_map;
					_tmp702_ = m;
					_tmp703_ = type_arg;
					_tmp704_ = vala_get_ccode_name ((ValaCodeNode*) _tmp703_);
					_tmp705_ = _tmp704_;
					_tmp706_ = vala_ccode_identifier_new (_tmp705_);
					_tmp707_ = _tmp706_;
					vala_map_set ((ValaMap*) _tmp701_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp702_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp707_);
					_vala_ccode_node_unref0 (_tmp707_);
					_g_free0 (_tmp705_);
					_tmp708_ = type_param_index;
					type_param_index = _tmp708_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp709_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp709_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp710_;
		ValaExpression* _tmp711_;
		ValaExpression* _tmp712_;
		ValaDataType* _tmp713_;
		ValaDataType* _tmp714_;
		ValaArrayType* _tmp715_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp716_;
		ValaCCodeIdentifier* _tmp717_;
		ValaCCodeFunctionCall* _tmp718_;
		ValaCCodeFunctionCall* _tmp719_;
		ValaCCodeFunctionCall* _tmp720_;
		ValaArrayType* _tmp721_;
		ValaDataType* _tmp722_;
		ValaDataType* _tmp723_;
		gchar* _tmp724_;
		gchar* _tmp725_;
		ValaCCodeIdentifier* _tmp726_;
		ValaCCodeIdentifier* _tmp727_;
		ValaHashMap* _tmp728_;
		ValaCCodeFunctionCall* _tmp729_;
		_tmp710_ = ma;
		_tmp711_ = vala_member_access_get_inner (_tmp710_);
		_tmp712_ = _tmp711_;
		_tmp713_ = vala_expression_get_value_type (_tmp712_);
		_tmp714_ = _tmp713_;
		_tmp715_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp714_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp715_;
		_tmp716_ = vala_ccode_identifier_new ("sizeof");
		_tmp717_ = _tmp716_;
		_tmp718_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp717_);
		_tmp719_ = _tmp718_;
		_vala_ccode_node_unref0 (_tmp717_);
		csizeof = _tmp719_;
		_tmp720_ = csizeof;
		_tmp721_ = array_type;
		_tmp722_ = vala_array_type_get_element_type (_tmp721_);
		_tmp723_ = _tmp722_;
		_tmp724_ = vala_get_ccode_name ((ValaCodeNode*) _tmp723_);
		_tmp725_ = _tmp724_;
		_tmp726_ = vala_ccode_identifier_new (_tmp725_);
		_tmp727_ = _tmp726_;
		vala_ccode_function_call_add_argument (_tmp720_, (ValaCCodeExpression*) _tmp727_);
		_vala_ccode_node_unref0 (_tmp727_);
		_g_free0 (_tmp725_);
		_tmp728_ = in_arg_map;
		_tmp729_ = csizeof;
		vala_map_set ((ValaMap*) _tmp728_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp729_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp730_;
		_tmp730_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp730_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp731_;
			gint param_nr = 0;
			ValaMethod* _tmp791_;
			_tmp731_ = m;
			vala_method_clear_parameters (_tmp731_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp732_;
				gint _arg_size = 0;
				ValaList* _tmp733_;
				gint _tmp734_;
				gint _tmp735_;
				gint _arg_index = 0;
				_tmp732_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp732_;
				_tmp733_ = _arg_list;
				_tmp734_ = vala_collection_get_size ((ValaCollection*) _tmp733_);
				_tmp735_ = _tmp734_;
				_arg_size = _tmp735_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp736_;
					gpointer _tmp737_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp738_;
					ValaUnaryExpression* _tmp739_;
					gboolean _tmp740_ = FALSE;
					ValaUnaryExpression* _tmp741_;
					gint _tmp782_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp736_ = _arg_list;
					_tmp737_ = vala_list_get (_tmp736_, _arg_index);
					arg = (ValaExpression*) _tmp737_;
					_tmp738_ = arg;
					_tmp739_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp738_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp738_) : NULL);
					unary = _tmp739_;
					_tmp741_ = unary;
					if (_tmp741_ != NULL) {
						ValaUnaryExpression* _tmp742_;
						ValaUnaryOperator _tmp743_;
						ValaUnaryOperator _tmp744_;
						_tmp742_ = unary;
						_tmp743_ = vala_unary_expression_get_operator (_tmp742_);
						_tmp744_ = _tmp743_;
						_tmp740_ = _tmp744_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp740_ = FALSE;
					}
					if (_tmp740_) {
						ValaParameter* param = NULL;
						gchar* _tmp745_;
						gchar* _tmp746_;
						ValaUnaryExpression* _tmp747_;
						ValaExpression* _tmp748_;
						ValaExpression* _tmp749_;
						ValaDataType* _tmp750_;
						ValaDataType* _tmp751_;
						ValaParameter* _tmp752_;
						ValaParameter* _tmp753_;
						ValaParameter* _tmp754_;
						ValaMethod* _tmp755_;
						ValaParameter* _tmp756_;
						_tmp745_ = g_strdup_printf ("param%d", param_nr);
						_tmp746_ = _tmp745_;
						_tmp747_ = unary;
						_tmp748_ = vala_unary_expression_get_inner (_tmp747_);
						_tmp749_ = _tmp748_;
						_tmp750_ = vala_expression_get_value_type (_tmp749_);
						_tmp751_ = _tmp750_;
						_tmp752_ = vala_parameter_new (_tmp746_, _tmp751_, NULL);
						_tmp753_ = _tmp752_;
						_g_free0 (_tmp746_);
						param = _tmp753_;
						_tmp754_ = param;
						vala_parameter_set_direction (_tmp754_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp755_ = m;
						_tmp756_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp755_, _tmp756_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp757_ = FALSE;
						ValaUnaryExpression* _tmp758_;
						_tmp758_ = unary;
						if (_tmp758_ != NULL) {
							ValaUnaryExpression* _tmp759_;
							ValaUnaryOperator _tmp760_;
							ValaUnaryOperator _tmp761_;
							_tmp759_ = unary;
							_tmp760_ = vala_unary_expression_get_operator (_tmp759_);
							_tmp761_ = _tmp760_;
							_tmp757_ = _tmp761_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp757_ = FALSE;
						}
						if (_tmp757_) {
							ValaParameter* param = NULL;
							gchar* _tmp762_;
							gchar* _tmp763_;
							ValaUnaryExpression* _tmp764_;
							ValaExpression* _tmp765_;
							ValaExpression* _tmp766_;
							ValaDataType* _tmp767_;
							ValaDataType* _tmp768_;
							ValaParameter* _tmp769_;
							ValaParameter* _tmp770_;
							ValaParameter* _tmp771_;
							ValaMethod* _tmp772_;
							ValaParameter* _tmp773_;
							_tmp762_ = g_strdup_printf ("param%d", param_nr);
							_tmp763_ = _tmp762_;
							_tmp764_ = unary;
							_tmp765_ = vala_unary_expression_get_inner (_tmp764_);
							_tmp766_ = _tmp765_;
							_tmp767_ = vala_expression_get_value_type (_tmp766_);
							_tmp768_ = _tmp767_;
							_tmp769_ = vala_parameter_new (_tmp763_, _tmp768_, NULL);
							_tmp770_ = _tmp769_;
							_g_free0 (_tmp763_);
							param = _tmp770_;
							_tmp771_ = param;
							vala_parameter_set_direction (_tmp771_, VALA_PARAMETER_DIRECTION_REF);
							_tmp772_ = m;
							_tmp773_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp772_, _tmp773_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp774_;
							gchar* _tmp775_;
							gchar* _tmp776_;
							ValaExpression* _tmp777_;
							ValaDataType* _tmp778_;
							ValaDataType* _tmp779_;
							ValaParameter* _tmp780_;
							ValaParameter* _tmp781_;
							_tmp774_ = m;
							_tmp775_ = g_strdup_printf ("param%d", param_nr);
							_tmp776_ = _tmp775_;
							_tmp777_ = arg;
							_tmp778_ = vala_expression_get_value_type (_tmp777_);
							_tmp779_ = _tmp778_;
							_tmp780_ = vala_parameter_new (_tmp776_, _tmp779_, NULL);
							_tmp781_ = _tmp780_;
							vala_callable_add_parameter ((ValaCallable*) _tmp774_, _tmp781_);
							_vala_code_node_unref0 (_tmp781_);
							_g_free0 (_tmp776_);
						}
					}
					_tmp782_ = param_nr;
					param_nr = _tmp782_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp783_;
				ValaList* _tmp784_;
				gint _param_size = 0;
				ValaList* _tmp785_;
				gint _tmp786_;
				gint _tmp787_;
				gint _param_index = 0;
				_tmp783_ = m;
				_tmp784_ = vala_callable_get_parameters ((ValaCallable*) _tmp783_);
				_param_list = _tmp784_;
				_tmp785_ = _param_list;
				_tmp786_ = vala_collection_get_size ((ValaCollection*) _tmp785_);
				_tmp787_ = _tmp786_;
				_param_size = _tmp787_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp788_;
					gpointer _tmp789_;
					ValaParameter* _tmp790_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp788_ = _param_list;
					_tmp789_ = vala_list_get (_tmp788_, _param_index);
					param = (ValaParameter*) _tmp789_;
					_tmp790_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp790_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp791_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp791_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp792_ = FALSE;
			gboolean _tmp793_ = FALSE;
			ValaMethod* _tmp794_;
			_tmp794_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp794_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp795_;
				ValaCodeContext* _tmp796_;
				ValaProfile _tmp797_;
				ValaProfile _tmp798_;
				_tmp795_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp796_ = _tmp795_;
				_tmp797_ = vala_code_context_get_profile (_tmp796_);
				_tmp798_ = _tmp797_;
				_tmp793_ = _tmp798_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp793_ = FALSE;
			}
			if (_tmp793_) {
				ValaMethod* _tmp799_;
				ValaSymbol* _tmp800_;
				ValaSymbol* _tmp801_;
				_tmp799_ = m;
				_tmp800_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp799_);
				_tmp801_ = _tmp800_;
				_tmp792_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp801_, VALA_TYPE_CLASS);
			} else {
				_tmp792_ = FALSE;
			}
			if (_tmp792_) {
				ValaCCodeFunction* _tmp802_;
				ValaCCodeFunction* _tmp803_;
				ValaCCodeExpression* _tmp804_;
				ValaCCodeExpression* _tmp805_;
				ValaCCodeFunctionCall* _tmp806_;
				ValaClass* _tmp807_;
				ValaClass* _tmp808_;
				gchar* _tmp809_;
				gchar* _tmp810_;
				gchar* _tmp811_;
				gchar* _tmp812_;
				ValaCCodeCastExpression* _tmp813_;
				ValaCCodeCastExpression* _tmp814_;
				ValaMethod* _tmp815_;
				ValaMethod* _tmp816_;
				ValaBlock* _tmp817_;
				ValaBlock* _tmp818_;
				gboolean _tmp819_;
				gboolean _tmp820_;
				gboolean _tmp847_ = FALSE;
				ValaClass* _tmp848_;
				ValaClass* _tmp849_;
				gboolean _tmp850_;
				gboolean _tmp851_;
				_tmp802_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp803_ = _tmp802_;
				_tmp804_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp805_ = _tmp804_;
				_tmp806_ = ccall;
				_tmp807_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp808_ = _tmp807_;
				_tmp809_ = vala_get_ccode_name ((ValaCodeNode*) _tmp808_);
				_tmp810_ = _tmp809_;
				_tmp811_ = g_strconcat (_tmp810_, "*", NULL);
				_tmp812_ = _tmp811_;
				_tmp813_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp806_, _tmp812_);
				_tmp814_ = _tmp813_;
				vala_ccode_function_add_assignment (_tmp803_, _tmp805_, (ValaCCodeExpression*) _tmp814_);
				_vala_ccode_node_unref0 (_tmp814_);
				_g_free0 (_tmp812_);
				_g_free0 (_tmp810_);
				_vala_ccode_node_unref0 (_tmp805_);
				_tmp815_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp816_ = _tmp815_;
				_tmp817_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp816_);
				_tmp818_ = _tmp817_;
				_tmp819_ = vala_block_get_captured (_tmp818_);
				_tmp820_ = _tmp819_;
				if (_tmp820_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp821_;
					ValaClass* _tmp822_;
					ValaObjectType* _tmp823_;
					ValaObjectType* _tmp824_;
					ValaSourceReference* _tmp825_;
					ValaSourceReference* _tmp826_;
					ValaCCodeExpression* _tmp827_;
					ValaCCodeExpression* _tmp828_;
					ValaCCodeFunctionCall* _tmp829_;
					ValaCCodeFunctionCall* _tmp830_;
					ValaCCodeFunctionCall* _tmp831_;
					ValaCCodeExpression* _tmp832_;
					ValaCCodeExpression* _tmp833_;
					ValaCCodeFunction* _tmp834_;
					ValaCCodeFunction* _tmp835_;
					ValaMethod* _tmp836_;
					ValaMethod* _tmp837_;
					ValaBlock* _tmp838_;
					ValaBlock* _tmp839_;
					gchar* _tmp840_;
					gchar* _tmp841_;
					ValaCCodeExpression* _tmp842_;
					ValaCCodeExpression* _tmp843_;
					ValaCCodeMemberAccess* _tmp844_;
					ValaCCodeMemberAccess* _tmp845_;
					ValaCCodeFunctionCall* _tmp846_;
					_tmp821_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp822_ = _tmp821_;
					_tmp823_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp822_);
					_tmp824_ = _tmp823_;
					_tmp825_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp826_ = _tmp825_;
					_tmp827_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp824_, _tmp826_, FALSE);
					_tmp828_ = _tmp827_;
					_tmp829_ = vala_ccode_function_call_new (_tmp828_);
					_tmp830_ = _tmp829_;
					_vala_ccode_node_unref0 (_tmp828_);
					_vala_code_node_unref0 (_tmp824_);
					ref_call = _tmp830_;
					_tmp831_ = ref_call;
					_tmp832_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp833_ = _tmp832_;
					vala_ccode_function_call_add_argument (_tmp831_, _tmp833_);
					_vala_ccode_node_unref0 (_tmp833_);
					_tmp834_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp835_ = _tmp834_;
					_tmp836_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp837_ = _tmp836_;
					_tmp838_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp837_);
					_tmp839_ = _tmp838_;
					_tmp840_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp839_));
					_tmp841_ = _tmp840_;
					_tmp842_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp841_);
					_tmp843_ = _tmp842_;
					_tmp844_ = vala_ccode_member_access_new_pointer (_tmp843_, "self");
					_tmp845_ = _tmp844_;
					_tmp846_ = ref_call;
					vala_ccode_function_add_assignment (_tmp835_, (ValaCCodeExpression*) _tmp845_, (ValaCCodeExpression*) _tmp846_);
					_vala_ccode_node_unref0 (_tmp845_);
					_vala_ccode_node_unref0 (_tmp843_);
					_g_free0 (_tmp841_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp848_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp849_ = _tmp848_;
				_tmp850_ = vala_class_get_is_compact (_tmp849_);
				_tmp851_ = _tmp850_;
				if (!_tmp851_) {
					ValaClass* _tmp852_;
					ValaClass* _tmp853_;
					_tmp852_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp853_ = _tmp852_;
					_tmp847_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp853_);
				} else {
					_tmp847_ = FALSE;
				}
				if (_tmp847_) {
					gchar** suffices = NULL;
					gchar* _tmp854_;
					gchar* _tmp855_;
					gchar* _tmp856_;
					gchar** _tmp857_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp854_ = g_strdup ("type");
					_tmp855_ = g_strdup ("dup_func");
					_tmp856_ = g_strdup ("destroy_func");
					_tmp857_ = g_new0 (gchar*, 3 + 1);
					_tmp857_[0] = _tmp854_;
					_tmp857_[1] = _tmp855_;
					_tmp857_[2] = _tmp856_;
					suffices = _tmp857_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp858_;
						ValaClass* _tmp859_;
						ValaList* _tmp860_;
						gint _type_param_size = 0;
						ValaList* _tmp861_;
						gint _tmp862_;
						gint _tmp863_;
						gint _type_param_index = 0;
						_tmp858_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp859_ = _tmp858_;
						_tmp860_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp859_);
						_type_param_list = _tmp860_;
						_tmp861_ = _type_param_list;
						_tmp862_ = vala_collection_get_size ((ValaCollection*) _tmp861_);
						_tmp863_ = _tmp862_;
						_type_param_size = _tmp863_;
						_type_param_index = -1;
						while (TRUE) {
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp864_;
							gpointer _tmp865_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp866_;
							ValaCCodeIdentifier* _tmp867_;
							ValaCCodeMemberAccess* _tmp868_;
							ValaCCodeMemberAccess* _tmp869_;
							gchar** _tmp870_;
							gint _tmp870__length1;
							_type_param_index = _type_param_index + 1;
							if (!(_type_param_index < _type_param_size)) {
								break;
							}
							_tmp864_ = _type_param_list;
							_tmp865_ = vala_list_get (_tmp864_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp865_;
							_tmp866_ = vala_ccode_identifier_new ("self");
							_tmp867_ = _tmp866_;
							_tmp868_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp867_, "priv");
							_tmp869_ = _tmp868_;
							_vala_ccode_node_unref0 (_tmp867_);
							priv_access = _tmp869_;
							_tmp870_ = suffices;
							_tmp870__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp870_;
								suffix_collection_length1 = _tmp870__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp871_;
									gchar* suffix = NULL;
									_tmp871_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp871_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp872_;
										const gchar* _tmp873_;
										const gchar* _tmp874_;
										gchar* _tmp875_;
										gchar* _tmp876_;
										const gchar* _tmp877_;
										gchar* _tmp878_;
										gchar* _tmp879_;
										ValaCCodeIdentifier* _tmp880_;
										ValaCCodeIdentifier* _tmp881_;
										ValaCCodeFunction* _tmp882_;
										ValaCCodeFunction* _tmp883_;
										ValaCCodeMemberAccess* _tmp884_;
										ValaCCodeIdentifier* _tmp885_;
										const gchar* _tmp886_;
										const gchar* _tmp887_;
										ValaCCodeMemberAccess* _tmp888_;
										ValaCCodeMemberAccess* _tmp889_;
										ValaCCodeIdentifier* _tmp890_;
										_tmp872_ = type_param;
										_tmp873_ = vala_symbol_get_name ((ValaSymbol*) _tmp872_);
										_tmp874_ = _tmp873_;
										_tmp875_ = g_utf8_strdown (_tmp874_, (gssize) -1);
										_tmp876_ = _tmp875_;
										_tmp877_ = suffix;
										_tmp878_ = g_strdup_printf ("%s_%s", _tmp876_, _tmp877_);
										_tmp879_ = _tmp878_;
										_tmp880_ = vala_ccode_identifier_new (_tmp879_);
										_tmp881_ = _tmp880_;
										_g_free0 (_tmp879_);
										_g_free0 (_tmp876_);
										param_name = _tmp881_;
										_tmp882_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp883_ = _tmp882_;
										_tmp884_ = priv_access;
										_tmp885_ = param_name;
										_tmp886_ = vala_ccode_identifier_get_name (_tmp885_);
										_tmp887_ = _tmp886_;
										_tmp888_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp884_, _tmp887_);
										_tmp889_ = _tmp888_;
										_tmp890_ = param_name;
										vala_ccode_function_add_assignment (_tmp883_, (ValaCCodeExpression*) _tmp889_, (ValaCCodeExpression*) _tmp890_);
										_vala_ccode_node_unref0 (_tmp889_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp891_ = params;
	_tmp892_ = vala_iterable_iterator ((ValaIterable*) _tmp891_);
	params_it = _tmp892_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp893_;
		gint _arg_size = 0;
		ValaList* _tmp894_;
		gint _tmp895_;
		gint _tmp896_;
		gint _arg_index = 0;
		_tmp893_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp893_;
		_tmp894_ = _arg_list;
		_tmp895_ = vala_collection_get_size ((ValaCollection*) _tmp894_);
		_tmp896_ = _tmp895_;
		_arg_size = _tmp896_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp897_;
			gpointer _tmp898_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp899_;
			ValaCCodeExpression* _tmp900_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp901_;
			ValaHashMap* _tmp902_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp903_;
			gboolean _tmp913_ = FALSE;
			ValaParameter* _tmp914_;
			gdouble _tmp1240_ = 0.0;
			ValaParameter* _tmp1241_;
			ValaHashMap* _tmp1243_;
			ValaCCodeExpression* _tmp1244_;
			gboolean _tmp1245_ = FALSE;
			ValaExpression* _tmp1246_;
			gint _tmp1263_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp897_ = _arg_list;
			_tmp898_ = vala_list_get (_tmp897_, _arg_index);
			arg = (ValaExpression*) _tmp898_;
			_tmp899_ = arg;
			_tmp900_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp899_);
			cexpr = _tmp900_;
			_tmp901_ = in_arg_map;
			_tmp902_ = _vala_map_ref0 (_tmp901_);
			carg_map = _tmp902_;
			param = NULL;
			_tmp903_ = params_it;
			if (vala_iterator_next (_tmp903_)) {
				ValaIterator* _tmp904_;
				gpointer _tmp905_;
				gboolean _tmp906_ = FALSE;
				ValaParameter* _tmp907_;
				gboolean _tmp908_;
				gboolean _tmp909_;
				_tmp904_ = params_it;
				_tmp905_ = vala_iterator_get (_tmp904_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp905_;
				_tmp907_ = param;
				_tmp908_ = vala_parameter_get_params_array (_tmp907_);
				_tmp909_ = _tmp908_;
				if (_tmp909_) {
					_tmp906_ = TRUE;
				} else {
					ValaParameter* _tmp910_;
					gboolean _tmp911_;
					gboolean _tmp912_;
					_tmp910_ = param;
					_tmp911_ = vala_parameter_get_ellipsis (_tmp910_);
					_tmp912_ = _tmp911_;
					_tmp906_ = _tmp912_;
				}
				ellipsis = _tmp906_;
			}
			_tmp914_ = param;
			if (_tmp914_ != NULL) {
				_tmp913_ = !ellipsis;
			} else {
				_tmp913_ = FALSE;
			}
			if (_tmp913_) {
				ValaParameter* _tmp915_;
				ValaParameterDirection _tmp916_;
				ValaParameterDirection _tmp917_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp920_;
				ValaUnaryExpression* _tmp921_;
				gboolean _tmp922_ = FALSE;
				ValaUnaryExpression* _tmp923_;
				ValaParameter* _tmp1191_;
				gchar* _tmp1192_;
				gchar* _tmp1193_;
				gboolean _tmp1194_;
				_tmp915_ = param;
				_tmp916_ = vala_parameter_get_direction (_tmp915_);
				_tmp917_ = _tmp916_;
				if (_tmp917_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp918_;
					ValaHashMap* _tmp919_;
					_tmp918_ = out_arg_map;
					_tmp919_ = _vala_map_ref0 (_tmp918_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp919_;
				}
				_tmp920_ = arg;
				_tmp921_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp920_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp920_) : NULL);
				unary = _tmp921_;
				_tmp923_ = unary;
				if (_tmp923_ == NULL) {
					_tmp922_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp924_;
					ValaUnaryOperator _tmp925_;
					ValaUnaryOperator _tmp926_;
					_tmp924_ = unary;
					_tmp925_ = vala_unary_expression_get_operator (_tmp924_);
					_tmp926_ = _tmp925_;
					_tmp922_ = _tmp926_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp922_) {
					gboolean _tmp927_ = FALSE;
					gboolean _tmp928_ = FALSE;
					ValaParameter* _tmp929_;
					ValaParameter* _tmp1065_;
					ValaExpression* _tmp1066_;
					ValaCCodeExpression* _tmp1067_;
					ValaCCodeExpression* _tmp1068_;
					_tmp929_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp929_)) {
						ValaParameter* _tmp930_;
						ValaDataType* _tmp931_;
						ValaDataType* _tmp932_;
						_tmp930_ = param;
						_tmp931_ = vala_variable_get_variable_type ((ValaVariable*) _tmp930_);
						_tmp932_ = _tmp931_;
						_tmp928_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp932_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp928_ = FALSE;
					}
					if (_tmp928_) {
						ValaParameter* _tmp933_;
						ValaDataType* _tmp934_;
						ValaDataType* _tmp935_;
						gboolean _tmp936_;
						gboolean _tmp937_;
						_tmp933_ = param;
						_tmp934_ = vala_variable_get_variable_type ((ValaVariable*) _tmp933_);
						_tmp935_ = _tmp934_;
						_tmp936_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp935_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp937_ = _tmp936_;
						_tmp927_ = !_tmp937_;
					} else {
						_tmp927_ = FALSE;
					}
					if (_tmp927_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp938_;
						ValaDataType* _tmp939_;
						ValaDataType* _tmp940_;
						ValaArrayType* _tmp941_;
						gchar* _tmp942_ = NULL;
						ValaParameter* _tmp943_;
						gchar* _tmp944_;
						gchar* length_ctype = NULL;
						gchar* _tmp947_;
						gboolean _tmp948_ = FALSE;
						ValaUnaryExpression* _tmp949_;
						_tmp938_ = param;
						_tmp939_ = vala_variable_get_variable_type ((ValaVariable*) _tmp938_);
						_tmp940_ = _tmp939_;
						_tmp941_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp940_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp941_;
						_tmp943_ = param;
						_tmp944_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp943_);
						_tmp942_ = _tmp944_;
						if (_tmp942_ == NULL) {
							ValaArrayType* _tmp945_;
							gchar* _tmp946_;
							_tmp945_ = array_type;
							_tmp946_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp945_);
							_g_free0 (_tmp942_);
							_tmp942_ = _tmp946_;
						}
						_tmp947_ = g_strdup (_tmp942_);
						length_ctype = _tmp947_;
						_tmp949_ = unary;
						if (_tmp949_ != NULL) {
							ValaUnaryExpression* _tmp950_;
							ValaUnaryOperator _tmp951_;
							ValaUnaryOperator _tmp952_;
							_tmp950_ = unary;
							_tmp951_ = vala_unary_expression_get_operator (_tmp950_);
							_tmp952_ = _tmp951_;
							_tmp948_ = _tmp952_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp948_ = FALSE;
						}
						if (_tmp948_) {
							const gchar* _tmp953_;
							gchar* _tmp954_;
							_tmp953_ = length_ctype;
							_tmp954_ = g_strdup_printf ("%s*", _tmp953_);
							_g_free0 (length_ctype);
							length_ctype = _tmp954_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp955_ = FALSE;
								_tmp955_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp957_;
									gint _tmp958_;
									gint _tmp959_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp960_;
									ValaCCodeExpression* _tmp961_;
									ValaCCodeExpression* _tmp962_;
									const gchar* _tmp963_;
									ValaCCodeCastExpression* _tmp964_;
									ValaCCodeCastExpression* _tmp965_;
									ValaHashMap* _tmp966_;
									ValaParameter* _tmp967_;
									ValaCCodeCastExpression* _tmp968_;
									if (!_tmp955_) {
										gint _tmp956_;
										_tmp956_ = dim;
										dim = _tmp956_ + 1;
									}
									_tmp955_ = FALSE;
									_tmp957_ = array_type;
									_tmp958_ = vala_array_type_get_rank (_tmp957_);
									_tmp959_ = _tmp958_;
									if (!(dim <= _tmp959_)) {
										break;
									}
									_tmp960_ = arg;
									_tmp961_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp960_, dim);
									_tmp962_ = _tmp961_;
									_tmp963_ = length_ctype;
									_tmp964_ = vala_ccode_cast_expression_new (_tmp962_, _tmp963_);
									_tmp965_ = _tmp964_;
									_vala_ccode_node_unref0 (_tmp962_);
									array_length_expr = _tmp965_;
									_tmp966_ = carg_map;
									_tmp967_ = param;
									_tmp968_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp966_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp967_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp968_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp942_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp969_;
						ValaDataType* _tmp970_;
						ValaDataType* _tmp971_;
						_tmp969_ = param;
						_tmp970_ = vala_variable_get_variable_type ((ValaVariable*) _tmp969_);
						_tmp971_ = _tmp970_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp971_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp972_;
							ValaDataType* _tmp973_;
							ValaDataType* _tmp974_;
							ValaDelegateType* _tmp975_;
							ValaDelegateType* _tmp976_;
							ValaDelegate* _tmp977_;
							ValaDelegate* _tmp978_;
							gboolean _tmp979_;
							gboolean _tmp980_;
							_tmp972_ = param;
							_tmp973_ = vala_variable_get_variable_type ((ValaVariable*) _tmp972_);
							_tmp974_ = _tmp973_;
							_tmp975_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp974_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp975_;
							_tmp976_ = deleg_type;
							_tmp977_ = vala_delegate_type_get_delegate_symbol (_tmp976_);
							_tmp978_ = _tmp977_;
							_tmp979_ = vala_delegate_get_has_target (_tmp978_);
							_tmp980_ = _tmp979_;
							if (_tmp980_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp981_;
								ValaCCodeExpression* _tmp982_ = NULL;
								ValaCCodeExpression* _tmp983_;
								ValaCCodeExpression* _tmp984_;
								ValaParameter* _tmp985_;
								gchar* _tmp986_;
								gchar* _tmp987_;
								gboolean _tmp988_;
								_tmp981_ = arg;
								_tmp983_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp981_, &_tmp982_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp982_;
								delegate_target = _tmp983_;
								_tmp984_ = delegate_target;
								_vala_assert (_tmp984_ != NULL, "delegate_target != null");
								_tmp985_ = param;
								_tmp986_ = vala_get_ccode_type ((ValaCodeNode*) _tmp985_);
								_tmp987_ = _tmp986_;
								_tmp988_ = g_strcmp0 (_tmp987_, "GClosure*") == 0;
								_g_free0 (_tmp987_);
								if (_tmp988_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp989_;
									ValaCCodeIdentifier* _tmp990_;
									ValaCCodeFunctionCall* _tmp991_;
									ValaCCodeFunctionCall* _tmp992_;
									ValaCCodeFunctionCall* _tmp993_;
									ValaCCodeExpression* _tmp994_;
									ValaCCodeCastExpression* _tmp995_;
									ValaCCodeCastExpression* _tmp996_;
									ValaCCodeFunctionCall* _tmp997_;
									ValaCCodeExpression* _tmp998_;
									ValaCCodeFunctionCall* _tmp999_;
									ValaCCodeExpression* _tmp1000_;
									ValaCCodeCastExpression* _tmp1001_;
									ValaCCodeCastExpression* _tmp1002_;
									ValaCCodeExpression* _tmp1003_;
									ValaCCodeIdentifier* _tmp1004_;
									ValaCCodeIdentifier* _tmp1005_;
									ValaCCodeBinaryExpression* _tmp1006_;
									ValaCCodeBinaryExpression* _tmp1007_;
									ValaCCodeIdentifier* _tmp1008_;
									ValaCCodeIdentifier* _tmp1009_;
									ValaCCodeFunctionCall* _tmp1010_;
									ValaCCodeConditionalExpression* _tmp1011_;
									_tmp989_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp990_ = _tmp989_;
									_tmp991_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp990_);
									_tmp992_ = _tmp991_;
									_vala_ccode_node_unref0 (_tmp990_);
									closure_new = _tmp992_;
									_tmp993_ = closure_new;
									_tmp994_ = cexpr;
									_tmp995_ = vala_ccode_cast_expression_new (_tmp994_, "GCallback");
									_tmp996_ = _tmp995_;
									vala_ccode_function_call_add_argument (_tmp993_, (ValaCCodeExpression*) _tmp996_);
									_vala_ccode_node_unref0 (_tmp996_);
									_tmp997_ = closure_new;
									_tmp998_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp997_, _tmp998_);
									_tmp999_ = closure_new;
									_tmp1000_ = delegate_target_destroy_notify;
									_tmp1001_ = vala_ccode_cast_expression_new (_tmp1000_, "GClosureNotify");
									_tmp1002_ = _tmp1001_;
									vala_ccode_function_call_add_argument (_tmp999_, (ValaCCodeExpression*) _tmp1002_);
									_vala_ccode_node_unref0 (_tmp1002_);
									_tmp1003_ = cexpr;
									_tmp1004_ = vala_ccode_identifier_new ("NULL");
									_tmp1005_ = _tmp1004_;
									_tmp1006_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1003_, (ValaCCodeExpression*) _tmp1005_);
									_tmp1007_ = _tmp1006_;
									_tmp1008_ = vala_ccode_identifier_new ("NULL");
									_tmp1009_ = _tmp1008_;
									_tmp1010_ = closure_new;
									_tmp1011_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1007_, (ValaCCodeExpression*) _tmp1009_, (ValaCCodeExpression*) _tmp1010_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1011_;
									_vala_ccode_node_unref0 (_tmp1009_);
									_vala_ccode_node_unref0 (_tmp1007_);
									_vala_ccode_node_unref0 (_tmp1005_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1012_;
									ValaParameter* _tmp1013_;
									ValaCCodeExpression* _tmp1014_;
									ValaDelegateType* _tmp1015_;
									_tmp1012_ = carg_map;
									_tmp1013_ = param;
									_tmp1014_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1012_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1013_), FALSE)), _tmp1014_);
									_tmp1015_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1015_)) {
										ValaCCodeExpression* _tmp1016_;
										ValaHashMap* _tmp1017_;
										ValaParameter* _tmp1018_;
										ValaCCodeExpression* _tmp1019_;
										_tmp1016_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1016_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1017_ = carg_map;
										_tmp1018_ = param;
										_tmp1019_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1017_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1018_) + 0.01, FALSE)), _tmp1019_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1020_;
							ValaDataType* _tmp1021_;
							ValaDataType* _tmp1022_;
							_tmp1020_ = param;
							_tmp1021_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1020_);
							_tmp1022_ = _tmp1021_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1022_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1023_;
								ValaParameter* _tmp1024_;
								ValaExpression* _tmp1025_;
								ValaCCodeExpression* _tmp1026_ = NULL;
								ValaCCodeExpression* _tmp1027_;
								ValaCCodeExpression* _tmp1028_;
								_tmp1023_ = carg_map;
								_tmp1024_ = param;
								_tmp1025_ = arg;
								_tmp1027_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1025_, &_tmp1026_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1026_;
								_tmp1028_ = _tmp1027_;
								vala_map_set ((ValaMap*) _tmp1023_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1024_), FALSE)), _tmp1028_);
								_vala_ccode_node_unref0 (_tmp1028_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1029_;
								ValaDataType* _tmp1030_;
								ValaDataType* _tmp1031_;
								_tmp1029_ = param;
								_tmp1030_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1029_);
								_tmp1031_ = _tmp1030_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1031_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1032_ = FALSE;
									ValaMethod* _tmp1033_;
									_tmp1033_ = m;
									if (_tmp1033_ != NULL) {
										ValaMethod* _tmp1034_;
										_tmp1034_ = m;
										_tmp1032_ = vala_get_ccode_simple_generics (_tmp1034_);
									} else {
										_tmp1032_ = FALSE;
									}
									if (_tmp1032_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1035_;
										ValaDataType* _tmp1036_;
										ValaDataType* _tmp1037_;
										ValaGenericType* _tmp1038_;
										gint type_param_index = 0;
										ValaMethod* _tmp1039_;
										ValaGenericType* _tmp1040_;
										ValaTypeParameter* _tmp1041_;
										ValaTypeParameter* _tmp1042_;
										const gchar* _tmp1043_;
										const gchar* _tmp1044_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1045_;
										ValaList* _tmp1046_;
										ValaList* _tmp1047_;
										gpointer _tmp1048_;
										ValaDataType* _tmp1049_;
										ValaParameter* _tmp1050_;
										ValaDataType* _tmp1051_;
										ValaDataType* _tmp1052_;
										gboolean _tmp1053_;
										gboolean _tmp1054_;
										_tmp1035_ = param;
										_tmp1036_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1035_);
										_tmp1037_ = _tmp1036_;
										_tmp1038_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1037_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1038_;
										_tmp1039_ = m;
										_tmp1040_ = generic_type;
										_tmp1041_ = vala_generic_type_get_type_parameter (_tmp1040_);
										_tmp1042_ = _tmp1041_;
										_tmp1043_ = vala_symbol_get_name ((ValaSymbol*) _tmp1042_);
										_tmp1044_ = _tmp1043_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1039_, _tmp1044_);
										_tmp1045_ = ma;
										_tmp1046_ = vala_member_access_get_type_arguments (_tmp1045_);
										_tmp1047_ = _tmp1046_;
										_tmp1048_ = vala_list_get (_tmp1047_, type_param_index);
										_tmp1049_ = (ValaDataType*) _tmp1048_;
										_vala_iterable_unref0 (_tmp1047_);
										type_arg = _tmp1049_;
										_tmp1050_ = param;
										_tmp1051_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1050_);
										_tmp1052_ = _tmp1051_;
										_tmp1053_ = vala_data_type_get_value_owned (_tmp1052_);
										_tmp1054_ = _tmp1053_;
										if (_tmp1054_) {
											ValaDataType* _tmp1055_;
											_tmp1055_ = type_arg;
											if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1055_)) {
												ValaHashMap* _tmp1056_;
												ValaParameter* _tmp1057_;
												ValaDataType* _tmp1058_;
												ValaCCodeExpression* _tmp1059_;
												ValaCCodeExpression* _tmp1060_;
												_tmp1056_ = carg_map;
												_tmp1057_ = param;
												_tmp1058_ = type_arg;
												_tmp1059_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1058_, FALSE);
												_tmp1060_ = _tmp1059_;
												vala_map_set ((ValaMap*) _tmp1056_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1057_), FALSE)), _tmp1060_);
												_vala_ccode_node_unref0 (_tmp1060_);
											} else {
												ValaHashMap* _tmp1061_;
												ValaParameter* _tmp1062_;
												ValaCCodeConstant* _tmp1063_;
												ValaCCodeConstant* _tmp1064_;
												_tmp1061_ = carg_map;
												_tmp1062_ = param;
												_tmp1063_ = vala_ccode_constant_new ("NULL");
												_tmp1064_ = _tmp1063_;
												vala_map_set ((ValaMap*) _tmp1061_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1062_), FALSE)), (ValaCCodeExpression*) _tmp1064_);
												_vala_ccode_node_unref0 (_tmp1064_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1065_ = param;
					_tmp1066_ = arg;
					_tmp1067_ = cexpr;
					_tmp1068_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1065_, _tmp1066_, _tmp1067_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1068_;
				} else {
					ValaExpression* _tmp1069_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1070_;
					ValaDataType* _tmp1071_;
					ValaDataType* _tmp1072_;
					ValaParameter* _tmp1073_;
					ValaDataType* _tmp1074_;
					ValaDataType* _tmp1075_;
					gboolean _tmp1076_;
					gboolean _tmp1077_;
					ValaLocalVariable* _tmp1078_;
					ValaLocalVariable* _tmp1079_;
					ValaExpression* _tmp1080_;
					ValaLocalVariable* _tmp1081_;
					const gchar* _tmp1082_;
					const gchar* _tmp1083_;
					ValaCCodeExpression* _tmp1084_;
					ValaCCodeExpression* _tmp1085_;
					ValaExpression* _tmp1086_;
					ValaTargetValue* _tmp1087_;
					ValaTargetValue* _tmp1088_;
					ValaExpression* _tmp1089_;
					ValaDataType* _tmp1090_;
					ValaDataType* _tmp1091_;
					ValaExpression* _tmp1092_;
					ValaCCodeExpression* _tmp1093_;
					ValaCCodeExpression* _tmp1094_;
					ValaCCodeUnaryExpression* _tmp1095_;
					gboolean _tmp1096_ = FALSE;
					gboolean _tmp1097_ = FALSE;
					ValaParameter* _tmp1098_;
					_tmp1069_ = arg;
					vala_expression_set_target_value (_tmp1069_, NULL);
					_tmp1070_ = param;
					_tmp1071_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1070_);
					_tmp1072_ = _tmp1071_;
					_tmp1073_ = param;
					_tmp1074_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1073_);
					_tmp1075_ = _tmp1074_;
					_tmp1076_ = vala_data_type_get_value_owned (_tmp1075_);
					_tmp1077_ = _tmp1076_;
					_tmp1078_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1072_, _tmp1077_, NULL, TRUE);
					temp_var = _tmp1078_;
					_tmp1079_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1079_, FALSE);
					_tmp1080_ = arg;
					_tmp1081_ = temp_var;
					_tmp1082_ = vala_symbol_get_name ((ValaSymbol*) _tmp1081_);
					_tmp1083_ = _tmp1082_;
					_tmp1084_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1083_);
					_tmp1085_ = _tmp1084_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1080_, _tmp1085_);
					_vala_ccode_node_unref0 (_tmp1085_);
					_tmp1086_ = arg;
					_tmp1087_ = vala_expression_get_target_value (_tmp1086_);
					_tmp1088_ = _tmp1087_;
					_tmp1089_ = arg;
					_tmp1090_ = vala_expression_get_target_type (_tmp1089_);
					_tmp1091_ = _tmp1090_;
					vala_target_value_set_value_type (_tmp1088_, _tmp1091_);
					_tmp1092_ = arg;
					_tmp1093_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1092_);
					_tmp1094_ = _tmp1093_;
					_tmp1095_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1094_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1095_;
					_vala_ccode_node_unref0 (_tmp1094_);
					_tmp1098_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1098_)) {
						ValaParameter* _tmp1099_;
						ValaDataType* _tmp1100_;
						ValaDataType* _tmp1101_;
						_tmp1099_ = param;
						_tmp1100_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1099_);
						_tmp1101_ = _tmp1100_;
						_tmp1097_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1101_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1097_ = FALSE;
					}
					if (_tmp1097_) {
						ValaParameter* _tmp1102_;
						ValaDataType* _tmp1103_;
						ValaDataType* _tmp1104_;
						gboolean _tmp1105_;
						gboolean _tmp1106_;
						_tmp1102_ = param;
						_tmp1103_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1102_);
						_tmp1104_ = _tmp1103_;
						_tmp1105_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1104_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1106_ = _tmp1105_;
						_tmp1096_ = !_tmp1106_;
					} else {
						_tmp1096_ = FALSE;
					}
					if (_tmp1096_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1107_;
						ValaDataType* _tmp1108_;
						ValaDataType* _tmp1109_;
						ValaArrayType* _tmp1110_;
						gchar* _tmp1111_ = NULL;
						ValaParameter* _tmp1112_;
						gchar* _tmp1113_;
						gchar* length_ctype = NULL;
						gchar* _tmp1116_;
						_tmp1107_ = param;
						_tmp1108_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1107_);
						_tmp1109_ = _tmp1108_;
						_tmp1110_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1109_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1110_;
						_tmp1112_ = param;
						_tmp1113_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1112_);
						_tmp1111_ = _tmp1113_;
						if (_tmp1111_ == NULL) {
							ValaArrayType* _tmp1114_;
							gchar* _tmp1115_;
							_tmp1114_ = array_type;
							_tmp1115_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1114_);
							_g_free0 (_tmp1111_);
							_tmp1111_ = _tmp1115_;
						}
						_tmp1116_ = g_strdup (_tmp1111_);
						length_ctype = _tmp1116_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1117_ = FALSE;
								_tmp1117_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1119_;
									gint _tmp1120_;
									gint _tmp1121_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1122_;
									ValaCType* _tmp1123_;
									ValaCType* _tmp1124_;
									ValaLocalVariable* _tmp1125_;
									ValaLocalVariable* _tmp1126_;
									ValaLocalVariable* _tmp1127_;
									ValaExpression* _tmp1128_;
									ValaLocalVariable* _tmp1129_;
									const gchar* _tmp1130_;
									const gchar* _tmp1131_;
									ValaCCodeExpression* _tmp1132_;
									ValaCCodeExpression* _tmp1133_;
									ValaHashMap* _tmp1134_;
									ValaParameter* _tmp1135_;
									ValaExpression* _tmp1136_;
									ValaList* _tmp1137_;
									ValaList* _tmp1138_;
									gpointer _tmp1139_;
									ValaCCodeExpression* _tmp1140_;
									ValaCCodeUnaryExpression* _tmp1141_;
									ValaCCodeUnaryExpression* _tmp1142_;
									if (!_tmp1117_) {
										gint _tmp1118_;
										_tmp1118_ = dim;
										dim = _tmp1118_ + 1;
									}
									_tmp1117_ = FALSE;
									_tmp1119_ = array_type;
									_tmp1120_ = vala_array_type_get_rank (_tmp1119_);
									_tmp1121_ = _tmp1120_;
									if (!(dim <= _tmp1121_)) {
										break;
									}
									_tmp1122_ = length_ctype;
									_tmp1123_ = vala_ctype_new (_tmp1122_, "0");
									_tmp1124_ = _tmp1123_;
									_tmp1125_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1124_, TRUE, NULL, TRUE);
									_tmp1126_ = _tmp1125_;
									_vala_code_node_unref0 (_tmp1124_);
									temp_array_length = _tmp1126_;
									_tmp1127_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1127_, FALSE);
									_tmp1128_ = arg;
									_tmp1129_ = temp_array_length;
									_tmp1130_ = vala_symbol_get_name ((ValaSymbol*) _tmp1129_);
									_tmp1131_ = _tmp1130_;
									_tmp1132_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1131_);
									_tmp1133_ = _tmp1132_;
									vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1128_, _tmp1133_);
									_vala_ccode_node_unref0 (_tmp1133_);
									_tmp1134_ = carg_map;
									_tmp1135_ = param;
									_tmp1136_ = arg;
									_tmp1137_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1136_);
									_tmp1138_ = _tmp1137_;
									_tmp1139_ = vala_list_get (_tmp1138_, dim - 1);
									_tmp1140_ = (ValaCCodeExpression*) _tmp1139_;
									_tmp1141_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1140_);
									_tmp1142_ = _tmp1141_;
									vala_map_set ((ValaMap*) _tmp1134_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1135_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1142_);
									_vala_ccode_node_unref0 (_tmp1142_);
									_vala_ccode_node_unref0 (_tmp1140_);
									_vala_iterable_unref0 (_tmp1138_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp1111_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp1143_;
						ValaDataType* _tmp1144_;
						ValaDataType* _tmp1145_;
						_tmp1143_ = param;
						_tmp1144_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1143_);
						_tmp1145_ = _tmp1144_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1145_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1146_;
							ValaDataType* _tmp1147_;
							ValaDataType* _tmp1148_;
							ValaDelegateType* _tmp1149_;
							ValaDelegateType* _tmp1150_;
							ValaDelegate* _tmp1151_;
							ValaDelegate* _tmp1152_;
							gboolean _tmp1153_;
							gboolean _tmp1154_;
							_tmp1146_ = param;
							_tmp1147_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1146_);
							_tmp1148_ = _tmp1147_;
							_tmp1149_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1148_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1149_;
							_tmp1150_ = deleg_type;
							_tmp1151_ = vala_delegate_type_get_delegate_symbol (_tmp1150_);
							_tmp1152_ = _tmp1151_;
							_tmp1153_ = vala_delegate_get_has_target (_tmp1152_);
							_tmp1154_ = _tmp1153_;
							if (_tmp1154_) {
								ValaVoidType* _tmp1155_;
								ValaVoidType* _tmp1156_;
								ValaPointerType* _tmp1157_;
								ValaPointerType* _tmp1158_;
								ValaLocalVariable* _tmp1159_;
								ValaLocalVariable* _tmp1160_;
								ValaExpression* _tmp1161_;
								ValaLocalVariable* _tmp1162_;
								const gchar* _tmp1163_;
								const gchar* _tmp1164_;
								ValaCCodeExpression* _tmp1165_;
								ValaCCodeExpression* _tmp1166_;
								ValaHashMap* _tmp1167_;
								ValaParameter* _tmp1168_;
								ValaExpression* _tmp1169_;
								ValaCCodeExpression* _tmp1170_;
								ValaCCodeExpression* _tmp1171_;
								ValaCCodeUnaryExpression* _tmp1172_;
								ValaCCodeUnaryExpression* _tmp1173_;
								ValaDelegateType* _tmp1174_;
								_tmp1155_ = vala_void_type_new (NULL);
								_tmp1156_ = _tmp1155_;
								_tmp1157_ = vala_pointer_type_new ((ValaDataType*) _tmp1156_, NULL);
								_tmp1158_ = _tmp1157_;
								_tmp1159_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1158_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1159_;
								_vala_code_node_unref0 (_tmp1158_);
								_vala_code_node_unref0 (_tmp1156_);
								_tmp1160_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1160_, FALSE);
								_tmp1161_ = arg;
								_tmp1162_ = temp_var;
								_tmp1163_ = vala_symbol_get_name ((ValaSymbol*) _tmp1162_);
								_tmp1164_ = _tmp1163_;
								_tmp1165_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1164_);
								_tmp1166_ = _tmp1165_;
								vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1161_, _tmp1166_);
								_vala_ccode_node_unref0 (_tmp1166_);
								_tmp1167_ = carg_map;
								_tmp1168_ = param;
								_tmp1169_ = arg;
								_tmp1170_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1169_);
								_tmp1171_ = _tmp1170_;
								_tmp1172_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1171_);
								_tmp1173_ = _tmp1172_;
								vala_map_set ((ValaMap*) _tmp1167_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1168_), FALSE)), (ValaCCodeExpression*) _tmp1173_);
								_vala_ccode_node_unref0 (_tmp1173_);
								_vala_ccode_node_unref0 (_tmp1171_);
								_tmp1174_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1174_)) {
									ValaDataType* _tmp1175_;
									ValaLocalVariable* _tmp1176_;
									ValaLocalVariable* _tmp1177_;
									ValaExpression* _tmp1178_;
									ValaLocalVariable* _tmp1179_;
									const gchar* _tmp1180_;
									const gchar* _tmp1181_;
									ValaCCodeExpression* _tmp1182_;
									ValaCCodeExpression* _tmp1183_;
									ValaHashMap* _tmp1184_;
									ValaParameter* _tmp1185_;
									ValaExpression* _tmp1186_;
									ValaCCodeExpression* _tmp1187_;
									ValaCCodeExpression* _tmp1188_;
									ValaCCodeUnaryExpression* _tmp1189_;
									ValaCCodeUnaryExpression* _tmp1190_;
									_tmp1175_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1176_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1175_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1176_;
									_tmp1177_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1177_, FALSE);
									_tmp1178_ = arg;
									_tmp1179_ = temp_var;
									_tmp1180_ = vala_symbol_get_name ((ValaSymbol*) _tmp1179_);
									_tmp1181_ = _tmp1180_;
									_tmp1182_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1181_);
									_tmp1183_ = _tmp1182_;
									vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1178_, _tmp1183_);
									_vala_ccode_node_unref0 (_tmp1183_);
									_tmp1184_ = carg_map;
									_tmp1185_ = param;
									_tmp1186_ = arg;
									_tmp1187_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1186_);
									_tmp1188_ = _tmp1187_;
									_tmp1189_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1188_);
									_tmp1190_ = _tmp1189_;
									vala_map_set ((ValaMap*) _tmp1184_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1185_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1190_);
									_vala_ccode_node_unref0 (_tmp1190_);
									_vala_ccode_node_unref0 (_tmp1188_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1191_ = param;
				_tmp1192_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1191_);
				_tmp1193_ = _tmp1192_;
				_tmp1194_ = _tmp1193_ != NULL;
				_g_free0 (_tmp1193_);
				if (_tmp1194_) {
					ValaCCodeExpression* _tmp1195_;
					ValaParameter* _tmp1196_;
					gchar* _tmp1197_;
					gchar* _tmp1198_;
					ValaCCodeCastExpression* _tmp1199_;
					_tmp1195_ = cexpr;
					_tmp1196_ = param;
					_tmp1197_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1196_);
					_tmp1198_ = _tmp1197_;
					_tmp1199_ = vala_ccode_cast_expression_new (_tmp1195_, _tmp1198_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1199_;
					_g_free0 (_tmp1198_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1200_;
				ValaUnaryExpression* _tmp1201_;
				gboolean _tmp1202_ = FALSE;
				gboolean _tmp1203_ = FALSE;
				_tmp1200_ = arg;
				_tmp1201_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1200_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1200_) : NULL);
				unary = _tmp1201_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1204_;
					_tmp1204_ = unary;
					_tmp1203_ = _tmp1204_ != NULL;
				} else {
					_tmp1203_ = FALSE;
				}
				if (_tmp1203_) {
					ValaUnaryExpression* _tmp1205_;
					ValaUnaryOperator _tmp1206_;
					ValaUnaryOperator _tmp1207_;
					_tmp1205_ = unary;
					_tmp1206_ = vala_unary_expression_get_operator (_tmp1205_);
					_tmp1207_ = _tmp1206_;
					_tmp1202_ = _tmp1207_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1202_ = FALSE;
				}
				if (_tmp1202_) {
					ValaHashMap* _tmp1208_;
					ValaHashMap* _tmp1209_;
					ValaExpression* _tmp1210_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1211_;
					ValaDataType* _tmp1212_;
					ValaDataType* _tmp1213_;
					ValaExpression* _tmp1214_;
					ValaDataType* _tmp1215_;
					ValaDataType* _tmp1216_;
					gboolean _tmp1217_;
					gboolean _tmp1218_;
					ValaLocalVariable* _tmp1219_;
					ValaLocalVariable* _tmp1220_;
					ValaExpression* _tmp1221_;
					ValaLocalVariable* _tmp1222_;
					const gchar* _tmp1223_;
					const gchar* _tmp1224_;
					ValaCCodeExpression* _tmp1225_;
					ValaCCodeExpression* _tmp1226_;
					ValaExpression* _tmp1227_;
					ValaTargetValue* _tmp1228_;
					ValaTargetValue* _tmp1229_;
					ValaExpression* _tmp1230_;
					ValaDataType* _tmp1231_;
					ValaDataType* _tmp1232_;
					ValaExpression* _tmp1233_;
					ValaCCodeExpression* _tmp1234_;
					ValaCCodeExpression* _tmp1235_;
					ValaCCodeUnaryExpression* _tmp1236_;
					_tmp1208_ = out_arg_map;
					_tmp1209_ = _vala_map_ref0 (_tmp1208_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1209_;
					_tmp1210_ = arg;
					vala_expression_set_target_value (_tmp1210_, NULL);
					_tmp1211_ = arg;
					_tmp1212_ = vala_expression_get_value_type (_tmp1211_);
					_tmp1213_ = _tmp1212_;
					_tmp1214_ = arg;
					_tmp1215_ = vala_expression_get_value_type (_tmp1214_);
					_tmp1216_ = _tmp1215_;
					_tmp1217_ = vala_data_type_get_value_owned (_tmp1216_);
					_tmp1218_ = _tmp1217_;
					_tmp1219_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1213_, _tmp1218_, NULL, TRUE);
					temp_var = _tmp1219_;
					_tmp1220_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1220_, FALSE);
					_tmp1221_ = arg;
					_tmp1222_ = temp_var;
					_tmp1223_ = vala_symbol_get_name ((ValaSymbol*) _tmp1222_);
					_tmp1224_ = _tmp1223_;
					_tmp1225_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1224_);
					_tmp1226_ = _tmp1225_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1221_, _tmp1226_);
					_vala_ccode_node_unref0 (_tmp1226_);
					_tmp1227_ = arg;
					_tmp1228_ = vala_expression_get_target_value (_tmp1227_);
					_tmp1229_ = _tmp1228_;
					_tmp1230_ = arg;
					_tmp1231_ = vala_expression_get_value_type (_tmp1230_);
					_tmp1232_ = _tmp1231_;
					vala_target_value_set_value_type (_tmp1229_, _tmp1232_);
					_tmp1233_ = arg;
					_tmp1234_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1233_);
					_tmp1235_ = _tmp1234_;
					_tmp1236_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1235_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1236_;
					_vala_ccode_node_unref0 (_tmp1235_);
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1237_;
					ValaCCodeExpression* _tmp1238_;
					ValaCCodeExpression* _tmp1239_;
					_tmp1237_ = arg;
					_tmp1238_ = cexpr;
					_tmp1239_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1237_, _tmp1238_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1239_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1241_ = param;
			if (_tmp1241_ != NULL) {
				ValaParameter* _tmp1242_;
				_tmp1242_ = param;
				_tmp1240_ = vala_get_ccode_pos (_tmp1242_);
			} else {
				_tmp1240_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1240_, ellipsis);
			_tmp1243_ = carg_map;
			_tmp1244_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1243_, (gpointer) ((gintptr) arg_pos), _tmp1244_);
			_tmp1246_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1246_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1245_ = ellipsis;
			} else {
				_tmp1245_ = FALSE;
			}
			if (_tmp1245_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1247_;
				ValaNamedArgument* _tmp1248_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1249_;
				const gchar* _tmp1250_;
				const gchar* _tmp1251_;
				gchar** _tmp1252_;
				gchar** _tmp1253_;
				gchar** _tmp1254_;
				gint _tmp1254__length1;
				gchar* _tmp1255_;
				gchar* _tmp1256_;
				ValaHashMap* _tmp1257_;
				const gchar* _tmp1258_;
				gchar* _tmp1259_;
				gchar* _tmp1260_;
				ValaCCodeConstant* _tmp1261_;
				ValaCCodeConstant* _tmp1262_;
				_tmp1247_ = arg;
				_tmp1248_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1247_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1248_;
				_tmp1249_ = named_arg;
				_tmp1250_ = vala_named_argument_get_name (_tmp1249_);
				_tmp1251_ = _tmp1250_;
				_tmp1253_ = _tmp1252_ = g_strsplit (_tmp1251_, "_", 0);
				_tmp1254_ = _tmp1253_;
				_tmp1254__length1 = _vala_array_length (_tmp1252_);
				_tmp1255_ = _vala_g_strjoinv ("-", _tmp1254_, (gint) _vala_array_length (_tmp1252_));
				_tmp1256_ = _tmp1255_;
				_tmp1254_ = (_vala_array_free (_tmp1254_, _tmp1254__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1256_;
				_tmp1257_ = carg_map;
				_tmp1258_ = name;
				_tmp1259_ = g_strdup_printf ("\"%s\"", _tmp1258_);
				_tmp1260_ = _tmp1259_;
				_tmp1261_ = vala_ccode_constant_new (_tmp1260_);
				_tmp1262_ = _tmp1261_;
				vala_map_set ((ValaMap*) _tmp1257_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1262_);
				_vala_ccode_node_unref0 (_tmp1262_);
				_g_free0 (_tmp1260_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1263_ = i;
			i = _tmp1263_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1264_ = params_it;
	if (vala_iterator_next (_tmp1264_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1265_;
		gpointer _tmp1266_;
		gboolean _tmp1267_ = FALSE;
		ValaParameter* _tmp1268_;
		gboolean _tmp1269_;
		gboolean _tmp1270_;
		_tmp1265_ = params_it;
		_tmp1266_ = vala_iterator_get (_tmp1265_);
		param = (ValaParameter*) _tmp1266_;
		_tmp1268_ = param;
		_tmp1269_ = vala_parameter_get_params_array (_tmp1268_);
		_tmp1270_ = _tmp1269_;
		if (_tmp1270_) {
			_tmp1267_ = TRUE;
		} else {
			ValaParameter* _tmp1271_;
			gboolean _tmp1272_;
			gboolean _tmp1273_;
			_tmp1271_ = param;
			_tmp1272_ = vala_parameter_get_ellipsis (_tmp1271_);
			_tmp1273_ = _tmp1272_;
			_tmp1267_ = _tmp1273_;
		}
		_vala_assert (_tmp1267_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1276_ = m;
	if (_tmp1276_ != NULL) {
		ValaMethod* _tmp1277_;
		ValaDataType* _tmp1278_;
		ValaDataType* _tmp1279_;
		_tmp1277_ = m;
		_tmp1278_ = vala_callable_get_return_type ((ValaCallable*) _tmp1277_);
		_tmp1279_ = _tmp1278_;
		_tmp1275_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1279_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1275_ = FALSE;
	}
	if (_tmp1275_) {
		ValaCCodeFunctionCall* _tmp1280_;
		ValaCCodeFunctionCall* _tmp1281_;
		_tmp1280_ = async_call;
		_tmp1281_ = ccall;
		_tmp1274_ = _tmp1280_ != _tmp1281_;
	} else {
		_tmp1274_ = FALSE;
	}
	if (_tmp1274_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1282_;
		ValaDataType* _tmp1283_;
		ValaDataType* _tmp1284_;
		ValaArrayType* _tmp1285_;
		_tmp1282_ = m;
		_tmp1283_ = vala_callable_get_return_type ((ValaCallable*) _tmp1282_);
		_tmp1284_ = _tmp1283_;
		_tmp1285_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1284_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1285_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1286_ = FALSE;
				_tmp1286_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1288_;
					gint _tmp1289_;
					gint _tmp1290_;
					ValaMethod* _tmp1291_;
					if (!_tmp1286_) {
						gint _tmp1287_;
						_tmp1287_ = dim;
						dim = _tmp1287_ + 1;
					}
					_tmp1286_ = FALSE;
					_tmp1288_ = array_type;
					_tmp1289_ = vala_array_type_get_rank (_tmp1288_);
					_tmp1290_ = _tmp1289_;
					if (!(dim <= _tmp1290_)) {
						break;
					}
					_tmp1291_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1291_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1292_;
						ValaDataType* _tmp1293_;
						ValaDataType* _tmp1294_;
						ValaLocalVariable* _tmp1295_;
						ValaLocalVariable* _tmp1296_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1297_;
						const gchar* _tmp1298_;
						const gchar* _tmp1299_;
						ValaCCodeExpression* _tmp1300_;
						ValaLocalVariable* _tmp1301_;
						ValaCCodeExpression* _tmp1302_;
						ValaCCodeExpression* _tmp1303_;
						ValaCCodeAssignment* _tmp1304_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1305_;
						ValaCCodeIdentifier* _tmp1306_;
						ValaCCodeFunctionCall* _tmp1307_;
						ValaCCodeFunctionCall* _tmp1308_;
						ValaCCodeFunctionCall* _tmp1309_;
						ValaCCodeExpression* _tmp1310_;
						ValaCCodeFunctionCall* _tmp1311_;
						_tmp1292_ = itype;
						_tmp1293_ = vala_data_type_get_return_type (_tmp1292_);
						_tmp1294_ = _tmp1293_;
						_tmp1295_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1294_, TRUE, NULL, FALSE);
						_tmp1296_ = _tmp1295_;
						_vala_code_node_unref0 (_tmp1294_);
						temp_var = _tmp1296_;
						_tmp1297_ = temp_var;
						_tmp1298_ = vala_symbol_get_name ((ValaSymbol*) _tmp1297_);
						_tmp1299_ = _tmp1298_;
						_tmp1300_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1299_);
						temp_ref = _tmp1300_;
						_tmp1301_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1301_, FALSE);
						_tmp1302_ = temp_ref;
						_tmp1303_ = ccall_expr;
						_tmp1304_ = vala_ccode_assignment_new (_tmp1302_, _tmp1303_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1304_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1305_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1306_ = _tmp1305_;
						_tmp1307_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1306_);
						_tmp1308_ = _tmp1307_;
						_vala_ccode_node_unref0 (_tmp1306_);
						len_call = _tmp1308_;
						_tmp1309_ = len_call;
						_tmp1310_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1309_, _tmp1310_);
						_tmp1311_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1311_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1312_;
						_tmp1312_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1312_)) {
							gchar* _tmp1313_ = NULL;
							ValaMethod* _tmp1314_;
							gchar* _tmp1315_;
							gchar* length_ctype = NULL;
							gchar* _tmp1318_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1319_;
							ValaCType* _tmp1320_;
							ValaCType* _tmp1321_;
							ValaLocalVariable* _tmp1322_;
							ValaLocalVariable* _tmp1323_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1324_;
							const gchar* _tmp1325_;
							const gchar* _tmp1326_;
							ValaCCodeExpression* _tmp1327_;
							ValaLocalVariable* _tmp1328_;
							ValaHashMap* _tmp1329_;
							ValaMethod* _tmp1330_;
							ValaCCodeExpression* _tmp1331_;
							ValaCCodeUnaryExpression* _tmp1332_;
							ValaCCodeUnaryExpression* _tmp1333_;
							ValaCCodeExpression* _tmp1334_;
							_tmp1314_ = m;
							_tmp1315_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1314_);
							_tmp1313_ = _tmp1315_;
							if (_tmp1313_ == NULL) {
								ValaArrayType* _tmp1316_;
								gchar* _tmp1317_;
								_tmp1316_ = array_type;
								_tmp1317_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1316_);
								_g_free0 (_tmp1313_);
								_tmp1313_ = _tmp1317_;
							}
							_tmp1318_ = g_strdup (_tmp1313_);
							length_ctype = _tmp1318_;
							_tmp1319_ = length_ctype;
							_tmp1320_ = vala_ctype_new (_tmp1319_, "0");
							_tmp1321_ = _tmp1320_;
							_tmp1322_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1321_, TRUE, NULL, TRUE);
							_tmp1323_ = _tmp1322_;
							_vala_code_node_unref0 (_tmp1321_);
							temp_var = _tmp1323_;
							_tmp1324_ = temp_var;
							_tmp1325_ = vala_symbol_get_name ((ValaSymbol*) _tmp1324_);
							_tmp1326_ = _tmp1325_;
							_tmp1327_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1326_);
							temp_ref = _tmp1327_;
							_tmp1328_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1328_, FALSE);
							_tmp1329_ = out_arg_map;
							_tmp1330_ = m;
							_tmp1331_ = temp_ref;
							_tmp1332_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1331_);
							_tmp1333_ = _tmp1332_;
							vala_map_set ((ValaMap*) _tmp1329_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1330_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1333_);
							_vala_ccode_node_unref0 (_tmp1333_);
							_tmp1334_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1334_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
							_g_free0 (_tmp1313_);
						} else {
							ValaMethod* _tmp1335_;
							gchar* _tmp1336_;
							gchar* _tmp1337_;
							gboolean _tmp1338_;
							_tmp1335_ = m;
							_tmp1336_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1335_);
							_tmp1337_ = _tmp1336_;
							_tmp1338_ = _tmp1337_ != NULL;
							_g_free0 (_tmp1337_);
							if (_tmp1338_) {
								ValaMethod* _tmp1339_;
								gchar* _tmp1340_;
								gchar* _tmp1341_;
								ValaCCodeConstant* _tmp1342_;
								ValaCCodeConstant* _tmp1343_;
								_tmp1339_ = m;
								_tmp1340_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1339_);
								_tmp1341_ = _tmp1340_;
								_tmp1342_ = vala_ccode_constant_new (_tmp1341_);
								_tmp1343_ = _tmp1342_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1343_);
								_vala_ccode_node_unref0 (_tmp1343_);
								_g_free0 (_tmp1341_);
							} else {
								ValaCCodeConstant* _tmp1344_;
								ValaCCodeConstant* _tmp1345_;
								_tmp1344_ = vala_ccode_constant_new ("-1");
								_tmp1345_ = _tmp1344_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1345_);
								_vala_ccode_node_unref0 (_tmp1345_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1346_ = FALSE;
		gboolean _tmp1347_ = FALSE;
		ValaMethod* _tmp1348_;
		_tmp1348_ = m;
		if (_tmp1348_ != NULL) {
			ValaMethod* _tmp1349_;
			ValaDataType* _tmp1350_;
			ValaDataType* _tmp1351_;
			_tmp1349_ = m;
			_tmp1350_ = vala_callable_get_return_type ((ValaCallable*) _tmp1349_);
			_tmp1351_ = _tmp1350_;
			_tmp1347_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1351_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1347_ = FALSE;
		}
		if (_tmp1347_) {
			ValaCCodeFunctionCall* _tmp1352_;
			ValaCCodeFunctionCall* _tmp1353_;
			_tmp1352_ = async_call;
			_tmp1353_ = ccall;
			_tmp1346_ = _tmp1352_ != _tmp1353_;
		} else {
			_tmp1346_ = FALSE;
		}
		if (_tmp1346_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1354_;
			ValaDataType* _tmp1355_;
			ValaDataType* _tmp1356_;
			ValaDelegateType* _tmp1357_;
			ValaDelegateType* _tmp1358_;
			ValaDelegate* _tmp1359_;
			ValaDelegate* _tmp1360_;
			gboolean _tmp1361_;
			gboolean _tmp1362_;
			_tmp1354_ = m;
			_tmp1355_ = vala_callable_get_return_type ((ValaCallable*) _tmp1354_);
			_tmp1356_ = _tmp1355_;
			_tmp1357_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1356_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1357_;
			_tmp1358_ = deleg_type;
			_tmp1359_ = vala_delegate_type_get_delegate_symbol (_tmp1358_);
			_tmp1360_ = _tmp1359_;
			_tmp1361_ = vala_delegate_get_has_target (_tmp1360_);
			_tmp1362_ = _tmp1361_;
			if (_tmp1362_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1363_;
				ValaVoidType* _tmp1364_;
				ValaPointerType* _tmp1365_;
				ValaPointerType* _tmp1366_;
				ValaLocalVariable* _tmp1367_;
				ValaLocalVariable* _tmp1368_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1369_;
				const gchar* _tmp1370_;
				const gchar* _tmp1371_;
				ValaCCodeExpression* _tmp1372_;
				ValaLocalVariable* _tmp1373_;
				ValaHashMap* _tmp1374_;
				ValaMethod* _tmp1375_;
				ValaCCodeExpression* _tmp1376_;
				ValaCCodeUnaryExpression* _tmp1377_;
				ValaCCodeUnaryExpression* _tmp1378_;
				ValaCCodeExpression* _tmp1379_;
				ValaDelegateType* _tmp1380_;
				_tmp1363_ = vala_void_type_new (NULL);
				_tmp1364_ = _tmp1363_;
				_tmp1365_ = vala_pointer_type_new ((ValaDataType*) _tmp1364_, NULL);
				_tmp1366_ = _tmp1365_;
				_tmp1367_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1366_, TRUE, NULL, TRUE);
				_tmp1368_ = _tmp1367_;
				_vala_code_node_unref0 (_tmp1366_);
				_vala_code_node_unref0 (_tmp1364_);
				temp_var = _tmp1368_;
				_tmp1369_ = temp_var;
				_tmp1370_ = vala_symbol_get_name ((ValaSymbol*) _tmp1369_);
				_tmp1371_ = _tmp1370_;
				_tmp1372_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1371_);
				temp_ref = _tmp1372_;
				_tmp1373_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1373_, FALSE);
				_tmp1374_ = out_arg_map;
				_tmp1375_ = m;
				_tmp1376_ = temp_ref;
				_tmp1377_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1376_);
				_tmp1378_ = _tmp1377_;
				vala_map_set ((ValaMap*) _tmp1374_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1375_), FALSE)), (ValaCCodeExpression*) _tmp1378_);
				_vala_ccode_node_unref0 (_tmp1378_);
				_tmp1379_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1379_);
				_tmp1380_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1380_)) {
					ValaDataType* _tmp1381_;
					ValaLocalVariable* _tmp1382_;
					ValaLocalVariable* _tmp1383_;
					const gchar* _tmp1384_;
					const gchar* _tmp1385_;
					ValaCCodeExpression* _tmp1386_;
					ValaLocalVariable* _tmp1387_;
					ValaHashMap* _tmp1388_;
					ValaMethod* _tmp1389_;
					ValaCCodeExpression* _tmp1390_;
					ValaCCodeUnaryExpression* _tmp1391_;
					ValaCCodeUnaryExpression* _tmp1392_;
					ValaCCodeExpression* _tmp1393_;
					_tmp1381_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1382_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1381_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1382_;
					_tmp1383_ = temp_var;
					_tmp1384_ = vala_symbol_get_name ((ValaSymbol*) _tmp1383_);
					_tmp1385_ = _tmp1384_;
					_tmp1386_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1385_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1386_;
					_tmp1387_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1387_, FALSE);
					_tmp1388_ = out_arg_map;
					_tmp1389_ = m;
					_tmp1390_ = temp_ref;
					_tmp1391_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1390_);
					_tmp1392_ = _tmp1391_;
					vala_map_set ((ValaMap*) _tmp1388_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1389_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1392_);
					_vala_ccode_node_unref0 (_tmp1392_);
					_tmp1393_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1393_);
				} else {
					ValaCCodeConstant* _tmp1394_;
					ValaCCodeConstant* _tmp1395_;
					_tmp1394_ = vala_ccode_constant_new ("NULL");
					_tmp1395_ = _tmp1394_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1395_);
					_vala_ccode_node_unref0 (_tmp1395_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1396_;
				ValaCCodeConstant* _tmp1397_;
				_tmp1396_ = vala_ccode_constant_new ("NULL");
				_tmp1397_ = _tmp1396_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1397_);
				_vala_ccode_node_unref0 (_tmp1397_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1399_ = deleg;
	if (_tmp1399_ != NULL) {
		ValaDelegate* _tmp1400_;
		ValaDataType* _tmp1401_;
		ValaDataType* _tmp1402_;
		_tmp1400_ = deleg;
		_tmp1401_ = vala_callable_get_return_type ((ValaCallable*) _tmp1400_);
		_tmp1402_ = _tmp1401_;
		_tmp1398_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1402_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1398_ = FALSE;
	}
	if (_tmp1398_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1403_;
		ValaDataType* _tmp1404_;
		ValaDataType* _tmp1405_;
		ValaArrayType* _tmp1406_;
		_tmp1403_ = deleg;
		_tmp1404_ = vala_callable_get_return_type ((ValaCallable*) _tmp1403_);
		_tmp1405_ = _tmp1404_;
		_tmp1406_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1405_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1406_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1407_ = FALSE;
				_tmp1407_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1409_;
					gint _tmp1410_;
					gint _tmp1411_;
					ValaDelegate* _tmp1412_;
					if (!_tmp1407_) {
						gint _tmp1408_;
						_tmp1408_ = dim;
						dim = _tmp1408_ + 1;
					}
					_tmp1407_ = FALSE;
					_tmp1409_ = array_type;
					_tmp1410_ = vala_array_type_get_rank (_tmp1409_);
					_tmp1411_ = _tmp1410_;
					if (!(dim <= _tmp1411_)) {
						break;
					}
					_tmp1412_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1412_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1413_;
						ValaDataType* _tmp1414_;
						ValaDataType* _tmp1415_;
						ValaLocalVariable* _tmp1416_;
						ValaLocalVariable* _tmp1417_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1418_;
						const gchar* _tmp1419_;
						const gchar* _tmp1420_;
						ValaCCodeExpression* _tmp1421_;
						ValaLocalVariable* _tmp1422_;
						ValaCCodeExpression* _tmp1423_;
						ValaCCodeExpression* _tmp1424_;
						ValaCCodeAssignment* _tmp1425_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1426_;
						ValaCCodeIdentifier* _tmp1427_;
						ValaCCodeFunctionCall* _tmp1428_;
						ValaCCodeFunctionCall* _tmp1429_;
						ValaCCodeFunctionCall* _tmp1430_;
						ValaCCodeExpression* _tmp1431_;
						ValaCCodeFunctionCall* _tmp1432_;
						_tmp1413_ = itype;
						_tmp1414_ = vala_data_type_get_return_type (_tmp1413_);
						_tmp1415_ = _tmp1414_;
						_tmp1416_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1415_, TRUE, NULL, FALSE);
						_tmp1417_ = _tmp1416_;
						_vala_code_node_unref0 (_tmp1415_);
						temp_var = _tmp1417_;
						_tmp1418_ = temp_var;
						_tmp1419_ = vala_symbol_get_name ((ValaSymbol*) _tmp1418_);
						_tmp1420_ = _tmp1419_;
						_tmp1421_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1420_);
						temp_ref = _tmp1421_;
						_tmp1422_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1422_, FALSE);
						_tmp1423_ = temp_ref;
						_tmp1424_ = ccall_expr;
						_tmp1425_ = vala_ccode_assignment_new (_tmp1423_, _tmp1424_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1425_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1426_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1427_ = _tmp1426_;
						_tmp1428_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1427_);
						_tmp1429_ = _tmp1428_;
						_vala_ccode_node_unref0 (_tmp1427_);
						len_call = _tmp1429_;
						_tmp1430_ = len_call;
						_tmp1431_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1430_, _tmp1431_);
						_tmp1432_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1432_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1433_;
						_tmp1433_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1433_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaArrayType* _tmp1434_;
							ValaDataType* _tmp1435_;
							ValaDataType* _tmp1436_;
							ValaLocalVariable* _tmp1437_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1438_;
							const gchar* _tmp1439_;
							const gchar* _tmp1440_;
							ValaCCodeExpression* _tmp1441_;
							ValaLocalVariable* _tmp1442_;
							ValaHashMap* _tmp1443_;
							ValaDelegate* _tmp1444_;
							ValaCCodeExpression* _tmp1445_;
							ValaCCodeUnaryExpression* _tmp1446_;
							ValaCCodeUnaryExpression* _tmp1447_;
							ValaCCodeExpression* _tmp1448_;
							_tmp1434_ = array_type;
							_tmp1435_ = vala_array_type_get_length_type (_tmp1434_);
							_tmp1436_ = _tmp1435_;
							_tmp1437_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1436_, TRUE, NULL, TRUE);
							temp_var = _tmp1437_;
							_tmp1438_ = temp_var;
							_tmp1439_ = vala_symbol_get_name ((ValaSymbol*) _tmp1438_);
							_tmp1440_ = _tmp1439_;
							_tmp1441_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1440_);
							temp_ref = _tmp1441_;
							_tmp1442_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1442_, FALSE);
							_tmp1443_ = out_arg_map;
							_tmp1444_ = deleg;
							_tmp1445_ = temp_ref;
							_tmp1446_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1445_);
							_tmp1447_ = _tmp1446_;
							vala_map_set ((ValaMap*) _tmp1443_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1444_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1447_);
							_vala_ccode_node_unref0 (_tmp1447_);
							_tmp1448_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1448_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1449_;
							ValaCCodeConstant* _tmp1450_;
							_tmp1449_ = vala_ccode_constant_new ("-1");
							_tmp1450_ = _tmp1449_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1450_);
							_vala_ccode_node_unref0 (_tmp1450_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1451_ = FALSE;
		ValaDelegate* _tmp1452_;
		_tmp1452_ = deleg;
		if (_tmp1452_ != NULL) {
			ValaDelegate* _tmp1453_;
			ValaDataType* _tmp1454_;
			ValaDataType* _tmp1455_;
			_tmp1453_ = deleg;
			_tmp1454_ = vala_callable_get_return_type ((ValaCallable*) _tmp1453_);
			_tmp1455_ = _tmp1454_;
			_tmp1451_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1455_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1451_ = FALSE;
		}
		if (_tmp1451_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1456_;
			ValaDataType* _tmp1457_;
			ValaDataType* _tmp1458_;
			ValaDelegateType* _tmp1459_;
			ValaDelegateType* _tmp1460_;
			ValaDelegate* _tmp1461_;
			ValaDelegate* _tmp1462_;
			gboolean _tmp1463_;
			gboolean _tmp1464_;
			_tmp1456_ = deleg;
			_tmp1457_ = vala_callable_get_return_type ((ValaCallable*) _tmp1456_);
			_tmp1458_ = _tmp1457_;
			_tmp1459_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1458_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1459_;
			_tmp1460_ = deleg_type;
			_tmp1461_ = vala_delegate_type_get_delegate_symbol (_tmp1460_);
			_tmp1462_ = _tmp1461_;
			_tmp1463_ = vala_delegate_get_has_target (_tmp1462_);
			_tmp1464_ = _tmp1463_;
			if (_tmp1464_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1465_;
				ValaVoidType* _tmp1466_;
				ValaPointerType* _tmp1467_;
				ValaPointerType* _tmp1468_;
				ValaLocalVariable* _tmp1469_;
				ValaLocalVariable* _tmp1470_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1471_;
				const gchar* _tmp1472_;
				const gchar* _tmp1473_;
				ValaCCodeExpression* _tmp1474_;
				ValaLocalVariable* _tmp1475_;
				ValaHashMap* _tmp1476_;
				ValaDelegate* _tmp1477_;
				ValaCCodeExpression* _tmp1478_;
				ValaCCodeUnaryExpression* _tmp1479_;
				ValaCCodeUnaryExpression* _tmp1480_;
				ValaCCodeExpression* _tmp1481_;
				ValaDelegateType* _tmp1482_;
				_tmp1465_ = vala_void_type_new (NULL);
				_tmp1466_ = _tmp1465_;
				_tmp1467_ = vala_pointer_type_new ((ValaDataType*) _tmp1466_, NULL);
				_tmp1468_ = _tmp1467_;
				_tmp1469_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1468_, TRUE, NULL, TRUE);
				_tmp1470_ = _tmp1469_;
				_vala_code_node_unref0 (_tmp1468_);
				_vala_code_node_unref0 (_tmp1466_);
				temp_var = _tmp1470_;
				_tmp1471_ = temp_var;
				_tmp1472_ = vala_symbol_get_name ((ValaSymbol*) _tmp1471_);
				_tmp1473_ = _tmp1472_;
				_tmp1474_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1473_);
				temp_ref = _tmp1474_;
				_tmp1475_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1475_, FALSE);
				_tmp1476_ = out_arg_map;
				_tmp1477_ = deleg;
				_tmp1478_ = temp_ref;
				_tmp1479_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1478_);
				_tmp1480_ = _tmp1479_;
				vala_map_set ((ValaMap*) _tmp1476_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1477_), FALSE)), (ValaCCodeExpression*) _tmp1480_);
				_vala_ccode_node_unref0 (_tmp1480_);
				_tmp1481_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1481_);
				_tmp1482_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1482_)) {
					ValaDataType* _tmp1483_;
					ValaLocalVariable* _tmp1484_;
					ValaLocalVariable* _tmp1485_;
					const gchar* _tmp1486_;
					const gchar* _tmp1487_;
					ValaCCodeExpression* _tmp1488_;
					ValaLocalVariable* _tmp1489_;
					ValaHashMap* _tmp1490_;
					ValaDelegate* _tmp1491_;
					ValaCCodeExpression* _tmp1492_;
					ValaCCodeUnaryExpression* _tmp1493_;
					ValaCCodeUnaryExpression* _tmp1494_;
					ValaCCodeExpression* _tmp1495_;
					_tmp1483_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1484_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1483_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1484_;
					_tmp1485_ = temp_var;
					_tmp1486_ = vala_symbol_get_name ((ValaSymbol*) _tmp1485_);
					_tmp1487_ = _tmp1486_;
					_tmp1488_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1487_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1488_;
					_tmp1489_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1489_, FALSE);
					_tmp1490_ = out_arg_map;
					_tmp1491_ = deleg;
					_tmp1492_ = temp_ref;
					_tmp1493_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1492_);
					_tmp1494_ = _tmp1493_;
					vala_map_set ((ValaMap*) _tmp1490_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1491_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1494_);
					_vala_ccode_node_unref0 (_tmp1494_);
					_tmp1495_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1495_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1497_ = m;
	if (_tmp1497_ != NULL) {
		ValaMethod* _tmp1498_;
		gboolean _tmp1499_;
		gboolean _tmp1500_;
		_tmp1498_ = m;
		_tmp1499_ = vala_method_get_coroutine (_tmp1498_);
		_tmp1500_ = _tmp1499_;
		_tmp1496_ = _tmp1500_;
	} else {
		_tmp1496_ = FALSE;
	}
	if (_tmp1496_) {
		gboolean _tmp1501_;
		gboolean _tmp1502_;
		_tmp1501_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1502_ = _tmp1501_;
		if (_tmp1502_) {
			ValaHashMap* _tmp1503_;
			ValaMethod* _tmp1504_;
			ValaMethod* _tmp1505_;
			gchar* _tmp1506_;
			gchar* _tmp1507_;
			ValaCCodeIdentifier* _tmp1508_;
			ValaCCodeIdentifier* _tmp1509_;
			ValaHashMap* _tmp1510_;
			ValaCCodeIdentifier* _tmp1511_;
			ValaCCodeIdentifier* _tmp1512_;
			_tmp1503_ = in_arg_map;
			_tmp1504_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1505_ = _tmp1504_;
			_tmp1506_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1505_);
			_tmp1507_ = _tmp1506_;
			_tmp1508_ = vala_ccode_identifier_new (_tmp1507_);
			_tmp1509_ = _tmp1508_;
			vala_map_set ((ValaMap*) _tmp1503_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1509_);
			_vala_ccode_node_unref0 (_tmp1509_);
			_g_free0 (_tmp1507_);
			_tmp1510_ = in_arg_map;
			_tmp1511_ = vala_ccode_identifier_new ("_data_");
			_tmp1512_ = _tmp1511_;
			vala_map_set ((ValaMap*) _tmp1510_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1512_);
			_vala_ccode_node_unref0 (_tmp1512_);
		}
	}
	_tmp1513_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1514_ = _tmp1513_;
	if (_tmp1514_) {
		ValaCallable* _tmp1515_ = NULL;
		ValaMethod* _tmp1516_;
		ValaHashMap* _tmp1518_;
		ValaCCodeExpression* _tmp1519_;
		ValaCCodeExpression* _tmp1520_;
		ValaCCodeUnaryExpression* _tmp1521_;
		ValaCCodeUnaryExpression* _tmp1522_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1516_ = m;
		_tmp1515_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1516_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1515_ == NULL) {
			ValaDelegate* _tmp1517_;
			_tmp1517_ = deleg;
			_tmp1515_ = (ValaCallable*) _tmp1517_;
		}
		_tmp1518_ = out_arg_map;
		_tmp1519_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1520_ = _tmp1519_;
		_tmp1521_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1520_);
		_tmp1522_ = _tmp1521_;
		vala_map_set ((ValaMap*) _tmp1518_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1515_), FALSE)), (ValaCCodeExpression*) _tmp1522_);
		_vala_ccode_node_unref0 (_tmp1522_);
		_vala_ccode_node_unref0 (_tmp1520_);
	} else {
		gboolean _tmp1523_ = FALSE;
		gboolean _tmp1524_ = FALSE;
		ValaMethod* _tmp1525_;
		_tmp1525_ = m;
		if (_tmp1525_ != NULL) {
			ValaMethod* _tmp1526_;
			_tmp1526_ = m;
			_tmp1524_ = vala_method_has_error_type_parameter (_tmp1526_);
		} else {
			_tmp1524_ = FALSE;
		}
		if (_tmp1524_) {
			ValaCCodeFunctionCall* _tmp1527_;
			ValaCCodeFunctionCall* _tmp1528_;
			_tmp1527_ = async_call;
			_tmp1528_ = ccall;
			_tmp1523_ = _tmp1527_ != _tmp1528_;
		} else {
			_tmp1523_ = FALSE;
		}
		if (_tmp1523_) {
			ValaHashMap* _tmp1529_;
			ValaMethod* _tmp1530_;
			ValaCCodeConstant* _tmp1531_;
			ValaCCodeConstant* _tmp1532_;
			_tmp1529_ = out_arg_map;
			_tmp1530_ = m;
			_tmp1531_ = vala_ccode_constant_new ("NULL");
			_tmp1532_ = _tmp1531_;
			vala_map_set ((ValaMap*) _tmp1529_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1530_), FALSE)), (ValaCCodeExpression*) _tmp1532_);
			_vala_ccode_node_unref0 (_tmp1532_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1533_;
		_tmp1533_ = m;
		if (_tmp1533_ == NULL) {
			ValaHashMap* _tmp1534_;
			ValaCCodeConstant* _tmp1535_;
			ValaCCodeConstant* _tmp1536_;
			_tmp1534_ = in_arg_map;
			_tmp1535_ = vala_ccode_constant_new ("NULL");
			_tmp1536_ = _tmp1535_;
			vala_map_set ((ValaMap*) _tmp1534_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1536_);
			_vala_ccode_node_unref0 (_tmp1536_);
		} else {
			gboolean _tmp1537_ = FALSE;
			gboolean _tmp1538_ = FALSE;
			gboolean _tmp1539_ = FALSE;
			ValaMethod* _tmp1540_;
			gboolean _tmp1541_;
			gboolean _tmp1542_;
			_tmp1540_ = m;
			_tmp1541_ = vala_method_get_printf_format (_tmp1540_);
			_tmp1542_ = _tmp1541_;
			if (!_tmp1542_) {
				ValaMethod* _tmp1543_;
				gboolean _tmp1544_;
				gboolean _tmp1545_;
				_tmp1543_ = m;
				_tmp1544_ = vala_method_get_scanf_format (_tmp1543_);
				_tmp1545_ = _tmp1544_;
				_tmp1539_ = !_tmp1545_;
			} else {
				_tmp1539_ = FALSE;
			}
			if (_tmp1539_) {
				ValaMethod* _tmp1546_;
				gchar* _tmp1547_;
				gchar* _tmp1548_;
				_tmp1546_ = m;
				_tmp1547_ = vala_get_ccode_sentinel (_tmp1546_);
				_tmp1548_ = _tmp1547_;
				_tmp1538_ = g_strcmp0 (_tmp1548_, "") != 0;
				_g_free0 (_tmp1548_);
			} else {
				_tmp1538_ = FALSE;
			}
			if (_tmp1538_) {
				gboolean _tmp1549_;
				gboolean _tmp1550_;
				_tmp1549_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1550_ = _tmp1549_;
				_tmp1537_ = !_tmp1550_;
			} else {
				_tmp1537_ = FALSE;
			}
			if (_tmp1537_) {
				ValaHashMap* _tmp1551_;
				ValaMethod* _tmp1552_;
				gchar* _tmp1553_;
				gchar* _tmp1554_;
				ValaCCodeConstant* _tmp1555_;
				ValaCCodeConstant* _tmp1556_;
				_tmp1551_ = in_arg_map;
				_tmp1552_ = m;
				_tmp1553_ = vala_get_ccode_sentinel (_tmp1552_);
				_tmp1554_ = _tmp1553_;
				_tmp1555_ = vala_ccode_constant_new (_tmp1554_);
				_tmp1556_ = _tmp1555_;
				vala_map_set ((ValaMap*) _tmp1551_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1556_);
				_vala_ccode_node_unref0 (_tmp1556_);
				_g_free0 (_tmp1554_);
			}
		}
	}
	_tmp1557_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1557_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1558_;
		ValaDelegateType* _tmp1559_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1560_;
		ValaDelegate* _tmp1561_;
		ValaDelegate* _tmp1562_;
		ValaDelegate* _tmp1563_;
		ValaDelegate* _tmp1564_;
		gboolean _tmp1565_;
		gboolean _tmp1566_;
		_tmp1558_ = itype;
		_tmp1559_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1558_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1559_;
		_tmp1560_ = deleg_type;
		_tmp1561_ = vala_delegate_type_get_delegate_symbol (_tmp1560_);
		_tmp1562_ = _tmp1561_;
		_tmp1563_ = _vala_code_node_ref0 (_tmp1562_);
		d = _tmp1563_;
		_tmp1564_ = d;
		_tmp1565_ = vala_delegate_get_has_target (_tmp1564_);
		_tmp1566_ = _tmp1565_;
		if (_tmp1566_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1567_;
			ValaDelegate* _tmp1568_;
			ValaExpression* _tmp1569_;
			ValaExpression* _tmp1570_;
			ValaCCodeExpression* _tmp1571_ = NULL;
			ValaCCodeExpression* _tmp1572_;
			ValaCCodeExpression* _tmp1573_;
			ValaHashMap* _tmp1574_;
			ValaDelegate* _tmp1575_;
			ValaExpression* _tmp1576_;
			ValaExpression* _tmp1577_;
			ValaCCodeExpression* _tmp1578_ = NULL;
			ValaCCodeExpression* _tmp1579_;
			ValaCCodeExpression* _tmp1580_;
			_tmp1567_ = in_arg_map;
			_tmp1568_ = d;
			_tmp1569_ = vala_method_call_get_call (expr);
			_tmp1570_ = _tmp1569_;
			_tmp1572_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1570_, &_tmp1571_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1571_;
			_tmp1573_ = _tmp1572_;
			vala_map_set ((ValaMap*) _tmp1567_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1568_), FALSE)), _tmp1573_);
			_vala_ccode_node_unref0 (_tmp1573_);
			_tmp1574_ = out_arg_map;
			_tmp1575_ = d;
			_tmp1576_ = vala_method_call_get_call (expr);
			_tmp1577_ = _tmp1576_;
			_tmp1579_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1577_, &_tmp1578_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1578_;
			_tmp1580_ = _tmp1579_;
			vala_map_set ((ValaMap*) _tmp1574_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1575_), FALSE)), _tmp1580_);
			_vala_ccode_node_unref0 (_tmp1580_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1581_ = itype;
	_tmp1582_ = vala_data_type_get_return_type (_tmp1581_);
	_tmp1583_ = _tmp1582_;
	_tmp1584_ = vala_data_type_is_real_non_null_struct_type (_tmp1583_);
	_vala_code_node_unref0 (_tmp1583_);
	return_result_via_out_param = _tmp1584_;
	_tmp1586_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1586_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1587_;
		ValaDataType* _tmp1588_;
		ValaDataType* _tmp1589_;
		_tmp1587_ = itype;
		_tmp1588_ = vala_data_type_get_return_type (_tmp1587_);
		_tmp1589_ = _tmp1588_;
		_tmp1585_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1589_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1589_);
	} else {
		_tmp1585_ = FALSE;
	}
	if (_tmp1585_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1590_;
		ValaSignal* _tmp1591_;
		ValaSignal* _tmp1592_;
		ValaSignal* _tmp1593_;
		gboolean _tmp1594_ = FALSE;
		gboolean _tmp1595_ = FALSE;
		ValaMemberAccess* _tmp1596_;
		_tmp1590_ = itype;
		_tmp1591_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1590_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1592_ = _tmp1591_;
		_tmp1593_ = _vala_code_node_ref0 (_tmp1592_);
		sig = _tmp1593_;
		_tmp1596_ = ma;
		if (_tmp1596_ != NULL) {
			ValaMemberAccess* _tmp1597_;
			ValaExpression* _tmp1598_;
			ValaExpression* _tmp1599_;
			_tmp1597_ = ma;
			_tmp1598_ = vala_member_access_get_inner (_tmp1597_);
			_tmp1599_ = _tmp1598_;
			_tmp1595_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1599_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1595_ = FALSE;
		}
		if (_tmp1595_) {
			ValaSignal* _tmp1600_;
			gboolean _tmp1601_;
			gboolean _tmp1602_;
			_tmp1600_ = sig;
			_tmp1601_ = vala_signal_get_is_virtual (_tmp1600_);
			_tmp1602_ = _tmp1601_;
			_tmp1594_ = _tmp1602_;
		} else {
			_tmp1594_ = FALSE;
		}
		if (_tmp1594_) {
		} else {
			gboolean _tmp1603_ = FALSE;
			ValaSignal* _tmp1604_;
			_tmp1604_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1604_)) {
				_tmp1603_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1605_;
				ValaSourceReference* _tmp1606_;
				ValaSourceReference* _tmp1607_;
				ValaSourceFile* _tmp1608_;
				ValaSourceFile* _tmp1609_;
				ValaSignal* _tmp1610_;
				ValaSourceReference* _tmp1611_;
				ValaSourceReference* _tmp1612_;
				ValaSourceFile* _tmp1613_;
				ValaSourceFile* _tmp1614_;
				_tmp1605_ = ma;
				_tmp1606_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1605_);
				_tmp1607_ = _tmp1606_;
				_tmp1608_ = vala_source_reference_get_file (_tmp1607_);
				_tmp1609_ = _tmp1608_;
				_tmp1610_ = sig;
				_tmp1611_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1610_);
				_tmp1612_ = _tmp1611_;
				_tmp1613_ = vala_source_reference_get_file (_tmp1612_);
				_tmp1614_ = _tmp1613_;
				_tmp1603_ = _tmp1609_ == _tmp1614_;
			}
			if (_tmp1603_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1615_ = async_call;
	_tmp1616_ = ccall;
	if (_tmp1615_ == _tmp1616_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1617_;
		ValaDataType* _tmp1618_;
		ValaDataType* _tmp1619_;
		ValaLocalVariable* _tmp1620_;
		ValaLocalVariable* _tmp1621_;
		ValaLocalVariable* _tmp1622_;
		const gchar* _tmp1623_;
		const gchar* _tmp1624_;
		ValaCCodeExpression* _tmp1625_;
		ValaLocalVariable* _tmp1626_;
		ValaHashMap* _tmp1627_;
		ValaCCodeExpression* _tmp1628_;
		ValaCCodeUnaryExpression* _tmp1629_;
		ValaCCodeUnaryExpression* _tmp1630_;
		_tmp1617_ = itype;
		_tmp1618_ = vala_data_type_get_return_type (_tmp1617_);
		_tmp1619_ = _tmp1618_;
		_tmp1620_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1619_, TRUE, NULL, TRUE);
		_tmp1621_ = _tmp1620_;
		_vala_code_node_unref0 (_tmp1619_);
		out_param_var = _tmp1621_;
		_tmp1622_ = out_param_var;
		_tmp1623_ = vala_symbol_get_name ((ValaSymbol*) _tmp1622_);
		_tmp1624_ = _tmp1623_;
		_tmp1625_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1624_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1625_;
		_tmp1626_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1626_, FALSE);
		_tmp1627_ = out_arg_map;
		_tmp1628_ = out_param_ref;
		_tmp1629_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1628_);
		_tmp1630_ = _tmp1629_;
		vala_map_set ((ValaMap*) _tmp1627_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1630_);
		_vala_ccode_node_unref0 (_tmp1630_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1631_ = async_call;
	_tmp1632_ = ccall;
	if (_tmp1631_ != _tmp1632_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1643_;
			ValaHashMap* _tmp1644_;
			gpointer _tmp1645_;
			ValaCCodeExpression* _tmp1646_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1633_;
				ValaSet* _tmp1634_;
				ValaSet* _tmp1635_;
				ValaIterator* _tmp1636_;
				ValaIterator* _tmp1637_;
				_tmp1633_ = out_arg_map;
				_tmp1634_ = vala_map_get_keys ((ValaMap*) _tmp1633_);
				_tmp1635_ = _tmp1634_;
				_tmp1636_ = vala_iterable_iterator ((ValaIterable*) _tmp1635_);
				_tmp1637_ = _tmp1636_;
				_vala_iterable_unref0 (_tmp1635_);
				_pos_it = _tmp1637_;
				while (TRUE) {
					ValaIterator* _tmp1638_;
					gint pos = 0;
					ValaIterator* _tmp1639_;
					gpointer _tmp1640_;
					gboolean _tmp1641_ = FALSE;
					_tmp1638_ = _pos_it;
					if (!vala_iterator_next (_tmp1638_)) {
						break;
					}
					_tmp1639_ = _pos_it;
					_tmp1640_ = vala_iterator_get (_tmp1639_);
					pos = (gint) ((gintptr) _tmp1640_);
					if (pos > last_pos) {
						gboolean _tmp1642_ = FALSE;
						if (min_pos == -1) {
							_tmp1642_ = TRUE;
						} else {
							_tmp1642_ = pos < min_pos;
						}
						_tmp1641_ = _tmp1642_;
					} else {
						_tmp1641_ = FALSE;
					}
					if (_tmp1641_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1643_ = ccall;
			_tmp1644_ = out_arg_map;
			_tmp1645_ = vala_map_get ((ValaMap*) _tmp1644_, (gpointer) ((gintptr) min_pos));
			_tmp1646_ = (ValaCCodeExpression*) _tmp1645_;
			vala_ccode_function_call_add_argument (_tmp1643_, _tmp1646_);
			_vala_ccode_node_unref0 (_tmp1646_);
			last_pos = min_pos;
		}
	}
	_tmp1647_ = async_call;
	if (_tmp1647_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1658_;
			ValaHashMap* _tmp1659_;
			gpointer _tmp1660_;
			ValaCCodeExpression* _tmp1661_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1648_;
				ValaSet* _tmp1649_;
				ValaSet* _tmp1650_;
				ValaIterator* _tmp1651_;
				ValaIterator* _tmp1652_;
				_tmp1648_ = in_arg_map;
				_tmp1649_ = vala_map_get_keys ((ValaMap*) _tmp1648_);
				_tmp1650_ = _tmp1649_;
				_tmp1651_ = vala_iterable_iterator ((ValaIterable*) _tmp1650_);
				_tmp1652_ = _tmp1651_;
				_vala_iterable_unref0 (_tmp1650_);
				_pos_it = _tmp1652_;
				while (TRUE) {
					ValaIterator* _tmp1653_;
					gint pos = 0;
					ValaIterator* _tmp1654_;
					gpointer _tmp1655_;
					gboolean _tmp1656_ = FALSE;
					_tmp1653_ = _pos_it;
					if (!vala_iterator_next (_tmp1653_)) {
						break;
					}
					_tmp1654_ = _pos_it;
					_tmp1655_ = vala_iterator_get (_tmp1654_);
					pos = (gint) ((gintptr) _tmp1655_);
					if (pos > last_pos) {
						gboolean _tmp1657_ = FALSE;
						if (min_pos == -1) {
							_tmp1657_ = TRUE;
						} else {
							_tmp1657_ = pos < min_pos;
						}
						_tmp1656_ = _tmp1657_;
					} else {
						_tmp1656_ = FALSE;
					}
					if (_tmp1656_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1658_ = async_call;
			_tmp1659_ = in_arg_map;
			_tmp1660_ = vala_map_get ((ValaMap*) _tmp1659_, (gpointer) ((gintptr) min_pos));
			_tmp1661_ = (ValaCCodeExpression*) _tmp1660_;
			vala_ccode_function_call_add_argument (_tmp1658_, _tmp1661_);
			_vala_ccode_node_unref0 (_tmp1661_);
			last_pos = min_pos;
		}
	}
	_tmp1662_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1663_ = _tmp1662_;
	if (_tmp1663_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1664_;
		gint _tmp1665_;
		ValaCCodeFunction* _tmp1666_;
		ValaCCodeFunction* _tmp1667_;
		ValaCCodeIdentifier* _tmp1668_;
		ValaCCodeIdentifier* _tmp1669_;
		ValaCCodeMemberAccess* _tmp1670_;
		ValaCCodeMemberAccess* _tmp1671_;
		gchar* _tmp1672_;
		gchar* _tmp1673_;
		ValaCCodeConstant* _tmp1674_;
		ValaCCodeConstant* _tmp1675_;
		ValaCCodeFunction* _tmp1676_;
		ValaCCodeFunction* _tmp1677_;
		ValaCCodeFunctionCall* _tmp1678_;
		ValaCCodeFunction* _tmp1679_;
		ValaCCodeFunction* _tmp1680_;
		ValaCCodeConstant* _tmp1681_;
		ValaCCodeConstant* _tmp1682_;
		ValaCCodeFunction* _tmp1683_;
		ValaCCodeFunction* _tmp1684_;
		gchar* _tmp1685_;
		gchar* _tmp1686_;
		_tmp1664_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1665_ = _tmp1664_->next_coroutine_state;
		_tmp1664_->next_coroutine_state = _tmp1665_ + 1;
		state = _tmp1665_;
		_tmp1666_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1667_ = _tmp1666_;
		_tmp1668_ = vala_ccode_identifier_new ("_data_");
		_tmp1669_ = _tmp1668_;
		_tmp1670_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1669_, "_state_");
		_tmp1671_ = _tmp1670_;
		_tmp1672_ = g_strdup_printf ("%i", state);
		_tmp1673_ = _tmp1672_;
		_tmp1674_ = vala_ccode_constant_new (_tmp1673_);
		_tmp1675_ = _tmp1674_;
		vala_ccode_function_add_assignment (_tmp1667_, (ValaCCodeExpression*) _tmp1671_, (ValaCCodeExpression*) _tmp1675_);
		_vala_ccode_node_unref0 (_tmp1675_);
		_g_free0 (_tmp1673_);
		_vala_ccode_node_unref0 (_tmp1671_);
		_vala_ccode_node_unref0 (_tmp1669_);
		_tmp1676_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1677_ = _tmp1676_;
		_tmp1678_ = async_call;
		vala_ccode_function_add_expression (_tmp1677_, (ValaCCodeExpression*) _tmp1678_);
		_tmp1679_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1680_ = _tmp1679_;
		_tmp1681_ = vala_ccode_constant_new ("FALSE");
		_tmp1682_ = _tmp1681_;
		vala_ccode_function_add_return (_tmp1680_, (ValaCCodeExpression*) _tmp1682_);
		_vala_ccode_node_unref0 (_tmp1682_);
		_tmp1683_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1684_ = _tmp1683_;
		_tmp1685_ = g_strdup_printf ("_state_%d", state);
		_tmp1686_ = _tmp1685_;
		vala_ccode_function_add_label (_tmp1684_, _tmp1686_);
		_g_free0 (_tmp1686_);
	}
	_tmp1687_ = vala_method_call_get_is_assert (expr);
	_tmp1688_ = _tmp1687_;
	if (_tmp1688_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1689_;
		ValaSourceReference* _tmp1690_;
		ValaSourceLocation _tmp1691_ = {0};
		ValaSourceLocation _tmp1692_;
		gchar* _tmp1693_;
		ValaSourceReference* _tmp1694_;
		ValaSourceReference* _tmp1695_;
		ValaSourceLocation _tmp1696_ = {0};
		ValaSourceLocation _tmp1697_;
		gchar* _tmp1698_;
		ValaSourceReference* _tmp1699_;
		ValaSourceReference* _tmp1700_;
		ValaSourceLocation _tmp1701_ = {0};
		ValaSourceLocation _tmp1702_;
		gchar* _tmp1703_;
		gchar* _tmp1704_;
		ValaCCodeFunctionCall* _tmp1705_;
		ValaCCodeIdentifier* _tmp1706_;
		ValaCCodeIdentifier* _tmp1707_;
		ValaCCodeFunctionCall* _tmp1708_;
		const gchar* _tmp1709_;
		gchar* _tmp1710_;
		gchar* _tmp1711_;
		gchar* _tmp1712_;
		gchar* _tmp1713_;
		gchar* _tmp1714_;
		gchar* _tmp1715_;
		ValaCCodeConstant* _tmp1716_;
		ValaCCodeConstant* _tmp1717_;
		_tmp1689_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1690_ = _tmp1689_;
		vala_source_reference_get_begin (_tmp1690_, &_tmp1691_);
		_tmp1692_ = _tmp1691_;
		_tmp1693_ = _tmp1692_.pos;
		_tmp1694_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1695_ = _tmp1694_;
		vala_source_reference_get_end (_tmp1695_, &_tmp1696_);
		_tmp1697_ = _tmp1696_;
		_tmp1698_ = _tmp1697_.pos;
		_tmp1699_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1700_ = _tmp1699_;
		vala_source_reference_get_begin (_tmp1700_, &_tmp1701_);
		_tmp1702_ = _tmp1701_;
		_tmp1703_ = _tmp1702_.pos;
		_tmp1704_ = string_substring ((const gchar*) _tmp1693_, (glong) 0, (glong) ((gint) (_tmp1698_ - _tmp1703_)));
		message = _tmp1704_;
		_tmp1705_ = ccall;
		_tmp1706_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1707_ = _tmp1706_;
		vala_ccode_function_call_set_call (_tmp1705_, (ValaCCodeExpression*) _tmp1707_);
		_vala_ccode_node_unref0 (_tmp1707_);
		_tmp1708_ = ccall;
		_tmp1709_ = message;
		_tmp1710_ = string_replace (_tmp1709_, "\n", " ");
		_tmp1711_ = _tmp1710_;
		_tmp1712_ = g_strescape (_tmp1711_, "");
		_tmp1713_ = _tmp1712_;
		_tmp1714_ = g_strdup_printf ("\"%s\"", _tmp1713_);
		_tmp1715_ = _tmp1714_;
		_tmp1716_ = vala_ccode_constant_new (_tmp1715_);
		_tmp1717_ = _tmp1716_;
		vala_ccode_function_call_add_argument (_tmp1708_, (ValaCCodeExpression*) _tmp1717_);
		_vala_ccode_node_unref0 (_tmp1717_);
		_g_free0 (_tmp1715_);
		_g_free0 (_tmp1713_);
		_g_free0 (_tmp1711_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1718_;
		ValaCCodeFunction* _tmp1719_;
		ValaCCodeExpression* _tmp1720_;
		ValaCCodeExpression* _tmp1721_;
		ValaCCodeExpression* _tmp1722_;
		_tmp1718_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1719_ = _tmp1718_;
		_tmp1720_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1719_, _tmp1720_);
		_tmp1721_ = out_param_ref;
		_tmp1722_ = _vala_ccode_node_ref0 (_tmp1721_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1722_;
	}
	_tmp1725_ = m;
	if (_tmp1725_ != NULL) {
		ValaMethod* _tmp1726_;
		ValaMemberBinding _tmp1727_;
		ValaMemberBinding _tmp1728_;
		_tmp1726_ = m;
		_tmp1727_ = vala_method_get_binding (_tmp1726_);
		_tmp1728_ = _tmp1727_;
		_tmp1724_ = _tmp1728_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1724_ = FALSE;
	}
	if (_tmp1724_) {
		ValaMethod* _tmp1729_;
		gboolean _tmp1730_;
		gboolean _tmp1731_;
		_tmp1729_ = m;
		_tmp1730_ = vala_method_get_returns_modified_pointer (_tmp1729_);
		_tmp1731_ = _tmp1730_;
		_tmp1723_ = _tmp1731_;
	} else {
		_tmp1723_ = FALSE;
	}
	if (_tmp1723_) {
		gboolean _tmp1732_ = FALSE;
		gboolean _tmp1733_ = FALSE;
		ValaMemberAccess* _tmp1734_;
		_tmp1734_ = ma;
		if (_tmp1734_ != NULL) {
			ValaMemberAccess* _tmp1735_;
			ValaExpression* _tmp1736_;
			ValaExpression* _tmp1737_;
			ValaSymbol* _tmp1738_;
			ValaSymbol* _tmp1739_;
			_tmp1735_ = ma;
			_tmp1736_ = vala_member_access_get_inner (_tmp1735_);
			_tmp1737_ = _tmp1736_;
			_tmp1738_ = vala_expression_get_symbol_reference (_tmp1737_);
			_tmp1739_ = _tmp1738_;
			_tmp1733_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1739_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1733_ = FALSE;
		}
		if (_tmp1733_) {
			ValaMemberAccess* _tmp1740_;
			ValaExpression* _tmp1741_;
			ValaExpression* _tmp1742_;
			_tmp1740_ = ma;
			_tmp1741_ = vala_member_access_get_inner (_tmp1740_);
			_tmp1742_ = _tmp1741_;
			_tmp1732_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1742_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1732_ = FALSE;
		}
		if (_tmp1732_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1743_;
			ValaExpression* _tmp1744_;
			ValaExpression* _tmp1745_;
			ValaSymbol* _tmp1746_;
			ValaSymbol* _tmp1747_;
			ValaProperty* _tmp1748_;
			ValaProperty* _tmp1749_;
			ValaMemberAccess* _tmp1750_;
			ValaExpression* _tmp1751_;
			ValaExpression* _tmp1752_;
			ValaExpression* _tmp1753_;
			ValaExpression* _tmp1754_;
			ValaDataType* _tmp1755_;
			ValaDataType* _tmp1756_;
			ValaCCodeExpression* _tmp1757_;
			ValaGLibValue* _tmp1758_;
			ValaGLibValue* _tmp1759_;
			_tmp1743_ = ma;
			_tmp1744_ = vala_member_access_get_inner (_tmp1743_);
			_tmp1745_ = _tmp1744_;
			_tmp1746_ = vala_expression_get_symbol_reference (_tmp1745_);
			_tmp1747_ = _tmp1746_;
			_tmp1748_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1747_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1748_;
			_tmp1749_ = prop;
			_tmp1750_ = ma;
			_tmp1751_ = vala_member_access_get_inner (_tmp1750_);
			_tmp1752_ = _tmp1751_;
			_tmp1753_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1752_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1754_ = _tmp1753_;
			_tmp1755_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1756_ = _tmp1755_;
			_tmp1757_ = ccall_expr;
			_tmp1758_ = vala_glib_value_new (_tmp1756_, _tmp1757_, FALSE);
			_tmp1759_ = _tmp1758_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1749_, _tmp1754_, (ValaTargetValue*) _tmp1759_);
			_vala_target_value_unref0 (_tmp1759_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1760_;
			ValaCCodeExpression* _tmp1761_;
			ValaCCodeAssignment* _tmp1762_;
			_tmp1760_ = instance;
			_tmp1761_ = ccall_expr;
			_tmp1762_ = vala_ccode_assignment_new (_tmp1760_, _tmp1761_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1762_;
		}
	}
	_tmp1768_ = m;
	if (_tmp1768_ != NULL) {
		ValaMethod* _tmp1769_;
		_tmp1769_ = m;
		_tmp1767_ = vala_get_ccode_simple_generics (_tmp1769_);
	} else {
		_tmp1767_ = FALSE;
	}
	if (_tmp1767_) {
		ValaMethod* _tmp1770_;
		ValaDataType* _tmp1771_;
		ValaDataType* _tmp1772_;
		_tmp1770_ = m;
		_tmp1771_ = vala_callable_get_return_type ((ValaCallable*) _tmp1770_);
		_tmp1772_ = _tmp1771_;
		_tmp1766_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1772_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1766_ = FALSE;
	}
	if (_tmp1766_) {
		ValaDataType* _tmp1773_;
		ValaDataType* _tmp1774_;
		_tmp1773_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1774_ = _tmp1773_;
		_tmp1765_ = vala_data_type_is_real_struct_type (_tmp1774_);
	} else {
		_tmp1765_ = FALSE;
	}
	if (_tmp1765_) {
		ValaDataType* _tmp1775_;
		ValaDataType* _tmp1776_;
		gboolean _tmp1777_;
		gboolean _tmp1778_;
		_tmp1775_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1776_ = _tmp1775_;
		_tmp1777_ = vala_data_type_get_nullable (_tmp1776_);
		_tmp1778_ = _tmp1777_;
		_tmp1764_ = !_tmp1778_;
	} else {
		_tmp1764_ = FALSE;
	}
	if (_tmp1764_) {
		ValaDataType* _tmp1779_;
		ValaDataType* _tmp1780_;
		_tmp1779_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1780_ = _tmp1779_;
		_tmp1763_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1780_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1763_ = FALSE;
	}
	if (_tmp1763_) {
		ValaCCodeExpression* _tmp1781_;
		ValaCCodeParenthesizedExpression* _tmp1782_;
		ValaCCodeParenthesizedExpression* _tmp1783_;
		ValaCCodeUnaryExpression* _tmp1784_;
		_tmp1781_ = ccall_expr;
		_tmp1782_ = vala_ccode_parenthesized_expression_new (_tmp1781_);
		_tmp1783_ = _tmp1782_;
		_tmp1784_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1783_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1784_;
		_vala_ccode_node_unref0 (_tmp1783_);
	}
	_tmp1787_ = m;
	if (_tmp1787_ != NULL) {
		ValaMethod* _tmp1788_;
		gchar* _tmp1789_;
		gchar* _tmp1790_;
		_tmp1788_ = m;
		_tmp1789_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1788_);
		_tmp1790_ = _tmp1789_;
		_tmp1786_ = _tmp1790_ != NULL;
		_g_free0 (_tmp1790_);
	} else {
		_tmp1786_ = FALSE;
	}
	if (_tmp1786_) {
		ValaMethod* _tmp1791_;
		gchar* _tmp1792_;
		gchar* _tmp1793_;
		ValaMethod* _tmp1794_;
		ValaDataType* _tmp1795_;
		ValaDataType* _tmp1796_;
		gchar* _tmp1797_;
		gchar* _tmp1798_;
		_tmp1791_ = m;
		_tmp1792_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1791_);
		_tmp1793_ = _tmp1792_;
		_tmp1794_ = m;
		_tmp1795_ = vala_callable_get_return_type ((ValaCallable*) _tmp1794_);
		_tmp1796_ = _tmp1795_;
		_tmp1797_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1796_);
		_tmp1798_ = _tmp1797_;
		_tmp1785_ = g_strcmp0 (_tmp1793_, _tmp1798_) != 0;
		_g_free0 (_tmp1798_);
		_g_free0 (_tmp1793_);
	} else {
		_tmp1785_ = FALSE;
	}
	if (_tmp1785_) {
		ValaCCodeExpression* _tmp1799_;
		ValaMethod* _tmp1800_;
		ValaDataType* _tmp1801_;
		ValaDataType* _tmp1802_;
		gchar* _tmp1803_;
		gchar* _tmp1804_;
		ValaCCodeCastExpression* _tmp1805_;
		_tmp1799_ = ccall_expr;
		_tmp1800_ = m;
		_tmp1801_ = vala_callable_get_return_type ((ValaCallable*) _tmp1800_);
		_tmp1802_ = _tmp1801_;
		_tmp1803_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1802_);
		_tmp1804_ = _tmp1803_;
		_tmp1805_ = vala_ccode_cast_expression_new (_tmp1799_, _tmp1804_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1805_;
		_g_free0 (_tmp1804_);
	}
	_tmp1806_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1806_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1807_;
		ValaList* _tmp1808_;
		ValaIterator* _tmp1809_;
		ValaIterator* _tmp1810_;
		ValaIterator* _tmp1811_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1812_;
		gpointer _tmp1813_;
		ValaExpression* _tmp1814_;
		ValaCCodeExpression* _tmp1815_;
		ValaCCodeExpression* _tmp1816_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1817_;
		ValaLocalVariable* _tmp1818_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1819_;
		const gchar* _tmp1820_;
		const gchar* _tmp1821_;
		ValaCCodeExpression* _tmp1822_;
		ValaLocalVariable* _tmp1823_;
		ValaCCodeFile* _tmp1824_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1825_;
		ValaExpression* _tmp1826_;
		ValaExpression* _tmp1827_;
		ValaCCodeExpression* _tmp1828_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1829_;
		ValaExpression* _tmp1830_;
		ValaExpression* _tmp1831_;
		ValaCCodeExpression* _tmp1832_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1833_;
		ValaExpression* _tmp1834_;
		ValaExpression* _tmp1835_;
		ValaDataType* _tmp1836_;
		ValaDataType* _tmp1837_;
		ValaArrayType* _tmp1838_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1839_;
		ValaDataType* _tmp1840_;
		ValaDataType* _tmp1841_;
		gchar* _tmp1842_;
		gchar* _tmp1843_;
		gchar* _tmp1844_;
		gchar* _tmp1845_;
		ValaCCodeIdentifier* _tmp1846_;
		ValaCCodeIdentifier* _tmp1847_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1848_;
		ValaCCodeExpression* _tmp1849_;
		ValaCCodeBinaryExpression* _tmp1850_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1851_;
		ValaCCodeExpression* _tmp1852_;
		ValaCCodeBinaryExpression* _tmp1853_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1854_;
		ValaCCodeIdentifier* _tmp1855_;
		ValaCCodeFunctionCall* _tmp1856_;
		ValaCCodeFunctionCall* _tmp1857_;
		ValaCCodeFunctionCall* _tmp1858_;
		ValaCCodeExpression* _tmp1859_;
		ValaCCodeExpression* _tmp1860_;
		ValaCCodeBinaryExpression* _tmp1861_;
		ValaCCodeBinaryExpression* _tmp1862_;
		ValaCCodeFunctionCall* _tmp1863_;
		ValaCCodeConstant* _tmp1864_;
		ValaCCodeConstant* _tmp1865_;
		ValaCCodeFunctionCall* _tmp1866_;
		ValaCCodeIdentifier* _tmp1867_;
		ValaCCodeBinaryExpression* _tmp1868_;
		ValaCCodeBinaryExpression* _tmp1869_;
		ValaCCodeBinaryExpression* _tmp1870_;
		ValaCCodeFunction* _tmp1871_;
		ValaCCodeFunction* _tmp1872_;
		ValaCCodeExpression* _tmp1873_;
		ValaCCodeExpression* _tmp1874_;
		ValaCCodeFunction* _tmp1875_;
		ValaCCodeFunction* _tmp1876_;
		ValaCCodeExpression* _tmp1877_;
		ValaCCodeFunction* _tmp1878_;
		ValaCCodeFunction* _tmp1879_;
		ValaCCodeBinaryExpression* _tmp1880_;
		ValaCCodeFunctionCall* _tmp1881_;
		ValaCCodeConstant* _tmp1882_;
		ValaCCodeConstant* _tmp1883_;
		ValaCCodeConditionalExpression* _tmp1884_;
		ValaCCodeConditionalExpression* _tmp1885_;
		ValaCCodeFunction* _tmp1886_;
		ValaCCodeFunction* _tmp1887_;
		ValaMemberAccess* _tmp1888_;
		ValaExpression* _tmp1889_;
		ValaExpression* _tmp1890_;
		ValaCCodeExpression* _tmp1891_;
		ValaCCodeExpression* _tmp1892_;
		ValaCCodeExpression* _tmp1893_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1894_;
		ValaExpression* _tmp1895_;
		ValaExpression* _tmp1896_;
		ValaSymbol* _tmp1897_;
		ValaSymbol* _tmp1898_;
		ValaSymbol* _tmp1899_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1900_;
		ValaLocalVariable* _tmp1901_;
		gboolean _tmp1902_ = FALSE;
		gboolean _tmp1903_ = FALSE;
		ValaSymbol* _tmp1904_;
		_tmp1807_ = vala_method_call_get_argument_list (expr);
		_tmp1808_ = _tmp1807_;
		_tmp1809_ = vala_iterable_iterator ((ValaIterable*) _tmp1808_);
		_tmp1810_ = _tmp1809_;
		_vala_iterable_unref0 (_tmp1808_);
		arg_it = _tmp1810_;
		_tmp1811_ = arg_it;
		vala_iterator_next (_tmp1811_);
		_tmp1812_ = arg_it;
		_tmp1813_ = vala_iterator_get (_tmp1812_);
		_tmp1814_ = (ValaExpression*) _tmp1813_;
		_tmp1815_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1814_);
		_tmp1816_ = _tmp1815_;
		_vala_code_node_unref0 (_tmp1814_);
		new_size = _tmp1816_;
		_tmp1817_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1818_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1817_, TRUE, NULL, FALSE);
		temp_decl = _tmp1818_;
		_tmp1819_ = temp_decl;
		_tmp1820_ = vala_symbol_get_name ((ValaSymbol*) _tmp1819_);
		_tmp1821_ = _tmp1820_;
		_tmp1822_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1821_);
		temp_ref = _tmp1822_;
		_tmp1823_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1823_, FALSE);
		_tmp1824_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1824_, "string.h", FALSE);
		_tmp1825_ = ma;
		_tmp1826_ = vala_member_access_get_inner (_tmp1825_);
		_tmp1827_ = _tmp1826_;
		_tmp1828_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1827_, 1);
		clen = _tmp1828_;
		_tmp1829_ = ma;
		_tmp1830_ = vala_member_access_get_inner (_tmp1829_);
		_tmp1831_ = _tmp1830_;
		_tmp1832_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1831_);
		celems = _tmp1832_;
		_tmp1833_ = ma;
		_tmp1834_ = vala_member_access_get_inner (_tmp1833_);
		_tmp1835_ = _tmp1834_;
		_tmp1836_ = vala_expression_get_value_type (_tmp1835_);
		_tmp1837_ = _tmp1836_;
		_tmp1838_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1837_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1838_;
		_tmp1839_ = array_type;
		_tmp1840_ = vala_array_type_get_element_type (_tmp1839_);
		_tmp1841_ = _tmp1840_;
		_tmp1842_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1841_);
		_tmp1843_ = _tmp1842_;
		_tmp1844_ = g_strdup_printf ("sizeof (%s)", _tmp1843_);
		_tmp1845_ = _tmp1844_;
		_tmp1846_ = vala_ccode_identifier_new (_tmp1845_);
		_tmp1847_ = _tmp1846_;
		_g_free0 (_tmp1845_);
		_g_free0 (_tmp1843_);
		csizeof = _tmp1847_;
		_tmp1848_ = temp_ref;
		_tmp1849_ = clen;
		_tmp1850_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1848_, _tmp1849_);
		cdelta = _tmp1850_;
		_tmp1851_ = temp_ref;
		_tmp1852_ = clen;
		_tmp1853_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1851_, _tmp1852_);
		ccheck = _tmp1853_;
		_tmp1854_ = vala_ccode_identifier_new ("memset");
		_tmp1855_ = _tmp1854_;
		_tmp1856_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1855_);
		_tmp1857_ = _tmp1856_;
		_vala_ccode_node_unref0 (_tmp1855_);
		czero = _tmp1857_;
		_tmp1858_ = czero;
		_tmp1859_ = celems;
		_tmp1860_ = clen;
		_tmp1861_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1859_, _tmp1860_);
		_tmp1862_ = _tmp1861_;
		vala_ccode_function_call_add_argument (_tmp1858_, (ValaCCodeExpression*) _tmp1862_);
		_vala_ccode_node_unref0 (_tmp1862_);
		_tmp1863_ = czero;
		_tmp1864_ = vala_ccode_constant_new ("0");
		_tmp1865_ = _tmp1864_;
		vala_ccode_function_call_add_argument (_tmp1863_, (ValaCCodeExpression*) _tmp1865_);
		_vala_ccode_node_unref0 (_tmp1865_);
		_tmp1866_ = czero;
		_tmp1867_ = csizeof;
		_tmp1868_ = cdelta;
		_tmp1869_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1867_, (ValaCCodeExpression*) _tmp1868_);
		_tmp1870_ = _tmp1869_;
		vala_ccode_function_call_add_argument (_tmp1866_, (ValaCCodeExpression*) _tmp1870_);
		_vala_ccode_node_unref0 (_tmp1870_);
		_tmp1871_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1872_ = _tmp1871_;
		_tmp1873_ = temp_ref;
		_tmp1874_ = new_size;
		vala_ccode_function_add_assignment (_tmp1872_, _tmp1873_, _tmp1874_);
		_tmp1875_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1876_ = _tmp1875_;
		_tmp1877_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1876_, _tmp1877_);
		_tmp1878_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1879_ = _tmp1878_;
		_tmp1880_ = ccheck;
		_tmp1881_ = czero;
		_tmp1882_ = vala_ccode_constant_new ("NULL");
		_tmp1883_ = _tmp1882_;
		_tmp1884_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1880_, (ValaCCodeExpression*) _tmp1881_, (ValaCCodeExpression*) _tmp1883_);
		_tmp1885_ = _tmp1884_;
		vala_ccode_function_add_expression (_tmp1879_, (ValaCCodeExpression*) _tmp1885_);
		_vala_ccode_node_unref0 (_tmp1885_);
		_vala_ccode_node_unref0 (_tmp1883_);
		_tmp1886_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1887_ = _tmp1886_;
		_tmp1888_ = ma;
		_tmp1889_ = vala_member_access_get_inner (_tmp1888_);
		_tmp1890_ = _tmp1889_;
		_tmp1891_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1890_, 1);
		_tmp1892_ = _tmp1891_;
		_tmp1893_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1887_, _tmp1892_, _tmp1893_);
		_vala_ccode_node_unref0 (_tmp1892_);
		_tmp1894_ = ma;
		_tmp1895_ = vala_member_access_get_inner (_tmp1894_);
		_tmp1896_ = _tmp1895_;
		_tmp1897_ = vala_expression_get_symbol_reference (_tmp1896_);
		_tmp1898_ = _tmp1897_;
		_tmp1899_ = _vala_code_node_ref0 (_tmp1898_);
		array_var = _tmp1899_;
		_tmp1900_ = array_var;
		_tmp1901_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1900_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1900_) : NULL);
		array_local = _tmp1901_;
		_tmp1904_ = array_var;
		if (_tmp1904_ != NULL) {
			ValaSymbol* _tmp1905_;
			_tmp1905_ = array_var;
			_tmp1903_ = vala_symbol_is_internal_symbol (_tmp1905_);
		} else {
			_tmp1903_ = FALSE;
		}
		if (_tmp1903_) {
			gboolean _tmp1906_ = FALSE;
			gboolean _tmp1907_ = FALSE;
			ValaSymbol* _tmp1908_;
			_tmp1908_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1908_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1909_;
				gboolean _tmp1910_;
				gboolean _tmp1911_;
				_tmp1909_ = array_local;
				_tmp1910_ = vala_local_variable_get_captured (_tmp1909_);
				_tmp1911_ = _tmp1910_;
				_tmp1907_ = !_tmp1911_;
			} else {
				_tmp1907_ = FALSE;
			}
			if (_tmp1907_) {
				_tmp1906_ = TRUE;
			} else {
				ValaSymbol* _tmp1912_;
				_tmp1912_ = array_var;
				_tmp1906_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1912_, VALA_TYPE_FIELD);
			}
			_tmp1902_ = _tmp1906_;
		} else {
			_tmp1902_ = FALSE;
		}
		if (_tmp1902_) {
			ValaCCodeFunction* _tmp1913_;
			ValaCCodeFunction* _tmp1914_;
			ValaMemberAccess* _tmp1915_;
			ValaExpression* _tmp1916_;
			ValaExpression* _tmp1917_;
			ValaTargetValue* _tmp1918_;
			ValaTargetValue* _tmp1919_;
			ValaCCodeExpression* _tmp1920_;
			ValaCCodeExpression* _tmp1921_;
			ValaCCodeExpression* _tmp1922_;
			_tmp1913_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1914_ = _tmp1913_;
			_tmp1915_ = ma;
			_tmp1916_ = vala_member_access_get_inner (_tmp1915_);
			_tmp1917_ = _tmp1916_;
			_tmp1918_ = vala_expression_get_target_value (_tmp1917_);
			_tmp1919_ = _tmp1918_;
			_tmp1920_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1919_);
			_tmp1921_ = _tmp1920_;
			_tmp1922_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1914_, _tmp1921_, _tmp1922_);
			_vala_ccode_node_unref0 (_tmp1921_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1924_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1925_ = _tmp1924_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1925_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1926_;
		ValaDataType* _tmp1927_;
		_tmp1926_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1927_ = _tmp1926_;
		_tmp1923_ = !vala_data_type_is_disposable (_tmp1927_);
	} else {
		_tmp1923_ = FALSE;
	}
	if (_tmp1923_) {
		gboolean _tmp1928_ = FALSE;
		ValaCCodeExpression* _tmp1929_;
		_tmp1929_ = ccall_expr;
		if (_tmp1929_ != NULL) {
			_tmp1928_ = !return_result_via_out_param;
		} else {
			_tmp1928_ = FALSE;
		}
		if (_tmp1928_) {
			ValaCCodeFunction* _tmp1930_;
			ValaCCodeFunction* _tmp1931_;
			ValaCCodeExpression* _tmp1932_;
			_tmp1930_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1931_ = _tmp1930_;
			_tmp1932_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1931_, _tmp1932_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1933_;
		ValaDataType* _tmp1934_;
		gboolean _tmp1935_ = FALSE;
		ValaDataType* _tmp1936_;
		ValaDataType* _tmp1937_;
		gboolean _tmp1964_ = FALSE;
		ValaMethod* _tmp1965_;
		_tmp1933_ = itype;
		_tmp1934_ = vala_data_type_get_return_type (_tmp1933_);
		result_type = _tmp1934_;
		_tmp1936_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1937_ = _tmp1936_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1937_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1938_;
			ValaDataType* _tmp1939_;
			_tmp1938_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1939_ = _tmp1938_;
			_tmp1935_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1939_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1935_ = FALSE;
		}
		if (_tmp1935_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1940_;
			ValaDataType* _tmp1941_;
			ValaTypeParameter* _tmp1942_;
			ValaTypeParameter* _tmp1943_;
			ValaTypeParameter* _tmp1944_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1945_;
			ValaSymbol* _tmp1946_;
			ValaSymbol* _tmp1947_;
			ValaSymbol* _tmp1948_;
			ValaSymbol* _tmp1949_;
			ValaStruct* _tmp1950_;
			gboolean _tmp1951_ = FALSE;
			ValaTypeParameter* _tmp1952_;
			ValaSymbol* _tmp1953_;
			ValaSymbol* _tmp1954_;
			ValaTypeSymbol* _tmp1955_;
			_tmp1940_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1941_ = _tmp1940_;
			_tmp1942_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1941_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1943_ = _tmp1942_;
			_tmp1944_ = _vala_code_node_ref0 (_tmp1943_);
			type_parameter = _tmp1944_;
			_tmp1945_ = type_parameter;
			_tmp1946_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1945_);
			_tmp1947_ = _tmp1946_;
			_tmp1948_ = vala_symbol_get_parent_symbol (_tmp1947_);
			_tmp1949_ = _tmp1948_;
			_tmp1950_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1949_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1949_) : NULL);
			st = _tmp1950_;
			_tmp1952_ = type_parameter;
			_tmp1953_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1952_);
			_tmp1954_ = _tmp1953_;
			_tmp1955_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1954_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1955_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1951_ = TRUE;
			} else {
				gboolean _tmp1956_ = FALSE;
				ValaStruct* _tmp1957_;
				_tmp1957_ = st;
				if (_tmp1957_ != NULL) {
					ValaStruct* _tmp1958_;
					gchar* _tmp1959_;
					gchar* _tmp1960_;
					_tmp1958_ = st;
					_tmp1959_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1958_);
					_tmp1960_ = _tmp1959_;
					_tmp1956_ = g_strcmp0 (_tmp1960_, "va_list") == 0;
					_g_free0 (_tmp1960_);
				} else {
					_tmp1956_ = FALSE;
				}
				_tmp1951_ = _tmp1956_;
			}
			if (_tmp1951_) {
				ValaDataType* _tmp1961_;
				ValaDataType* _tmp1962_;
				ValaDataType* _tmp1963_;
				_tmp1961_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1962_ = _tmp1961_;
				_tmp1963_ = _vala_code_node_ref0 (_tmp1962_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1963_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1965_ = m;
		if (_tmp1965_ != NULL) {
			ValaMethod* _tmp1966_;
			_tmp1966_ = m;
			_tmp1964_ = vala_method_get_format_arg_index (_tmp1966_) >= 0;
		} else {
			_tmp1964_ = FALSE;
		}
		if (_tmp1964_) {
			ValaCCodeExpression* _tmp1967_;
			_tmp1967_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1967_);
		} else {
			gboolean _tmp1968_ = FALSE;
			ValaMethod* _tmp1969_;
			_tmp1969_ = m;
			if (_tmp1969_ != NULL) {
				ValaMethod* _tmp1970_;
				_tmp1970_ = m;
				_tmp1968_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1970_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1968_ = FALSE;
			}
			if (_tmp1968_) {
				ValaCCodeExpression* _tmp1971_;
				_tmp1971_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1971_);
			} else {
				gboolean _tmp1972_ = FALSE;
				gboolean _tmp1973_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp1973_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp1973_ = FALSE;
				}
				if (_tmp1973_) {
					gboolean _tmp1974_ = FALSE;
					ValaDataType* _tmp1975_;
					_tmp1975_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1975_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1976_;
						_tmp1976_ = result_type;
						_tmp1974_ = !vala_data_type_is_disposable (_tmp1976_);
					} else {
						_tmp1974_ = FALSE;
					}
					_tmp1972_ = _tmp1974_;
				} else {
					_tmp1972_ = FALSE;
				}
				if (_tmp1972_) {
					ValaCCodeExpression* _tmp1977_;
					_tmp1977_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1977_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1978_;
						ValaDataType* _tmp1979_;
						gboolean _tmp1980_;
						gboolean _tmp1981_;
						ValaLocalVariable* _tmp1982_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1983_;
						const gchar* _tmp1984_;
						const gchar* _tmp1985_;
						ValaCCodeExpression* _tmp1986_;
						ValaLocalVariable* _tmp1987_;
						ValaCCodeFunction* _tmp1988_;
						ValaCCodeFunction* _tmp1989_;
						ValaCCodeExpression* _tmp1990_;
						ValaCCodeExpression* _tmp1991_;
						ValaCCodeExpression* _tmp1992_;
						ValaTargetValue* _tmp1993_;
						ValaTargetValue* _tmp1994_;
						_tmp1978_ = result_type;
						_tmp1979_ = result_type;
						_tmp1980_ = vala_data_type_get_value_owned (_tmp1979_);
						_tmp1981_ = _tmp1980_;
						_tmp1982_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1978_, _tmp1981_, NULL, FALSE);
						temp_var = _tmp1982_;
						_tmp1983_ = temp_var;
						_tmp1984_ = vala_symbol_get_name ((ValaSymbol*) _tmp1983_);
						_tmp1985_ = _tmp1984_;
						_tmp1986_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1985_);
						temp_ref = _tmp1986_;
						_tmp1987_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1987_, FALSE);
						_tmp1988_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp1989_ = _tmp1988_;
						_tmp1990_ = temp_ref;
						_tmp1991_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp1989_, _tmp1990_, _tmp1991_);
						_tmp1992_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1992_);
						_tmp1993_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1994_ = _tmp1993_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1994_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp1995_;
						ValaTargetValue* _tmp1996_;
						ValaTargetValue* _tmp1997_;
						_tmp1995_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1995_);
						_tmp1996_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1997_ = _tmp1996_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1997_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp1998_ = params;
	_tmp1999_ = vala_iterable_iterator ((ValaIterable*) _tmp1998_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp1999_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2000_;
		gint _arg_size = 0;
		ValaList* _tmp2001_;
		gint _tmp2002_;
		gint _tmp2003_;
		gint _arg_index = 0;
		_tmp2000_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp2000_;
		_tmp2001_ = _arg_list;
		_tmp2002_ = vala_collection_get_size ((ValaCollection*) _tmp2001_);
		_tmp2003_ = _tmp2002_;
		_arg_size = _tmp2003_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp2004_;
			gpointer _tmp2005_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2006_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2009_;
			ValaUnaryExpression* _tmp2010_;
			gboolean _tmp2011_ = FALSE;
			ValaUnaryExpression* _tmp2012_;
			ValaUnaryExpression* _tmp2016_;
			ValaExpression* _tmp2017_;
			ValaExpression* _tmp2018_;
			ValaDataType* _tmp2019_;
			ValaDataType* _tmp2020_;
			ValaUnaryExpression* _tmp2030_;
			ValaExpression* _tmp2031_;
			ValaExpression* _tmp2032_;
			ValaTargetValue* _tmp2033_;
			ValaTargetValue* _tmp2034_;
			ValaUnaryExpression* _tmp2035_;
			ValaTargetValue* _tmp2036_;
			ValaTargetValue* _tmp2037_;
			ValaUnaryExpression* _tmp2038_;
			ValaExpression* _tmp2039_;
			ValaExpression* _tmp2040_;
			ValaDataType* _tmp2041_;
			ValaDataType* _tmp2042_;
			ValaExpression* _tmp2043_;
			ValaTargetValue* _tmp2044_;
			ValaTargetValue* _tmp2045_;
			ValaSourceReference* _tmp2046_;
			ValaSourceReference* _tmp2047_;
			gboolean _tmp2048_ = FALSE;
			ValaParameter* _tmp2049_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp2004_ = _arg_list;
			_tmp2005_ = vala_list_get (_tmp2004_, _arg_index);
			arg = (ValaExpression*) _tmp2005_;
			param = NULL;
			_tmp2006_ = params_it;
			if (vala_iterator_next (_tmp2006_)) {
				ValaIterator* _tmp2007_;
				gpointer _tmp2008_;
				_tmp2007_ = params_it;
				_tmp2008_ = vala_iterator_get (_tmp2007_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2008_;
			}
			_tmp2009_ = arg;
			_tmp2010_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2009_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2009_) : NULL);
			unary = _tmp2010_;
			_tmp2012_ = unary;
			if (_tmp2012_ == NULL) {
				_tmp2011_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2013_;
				ValaUnaryOperator _tmp2014_;
				ValaUnaryOperator _tmp2015_;
				_tmp2013_ = unary;
				_tmp2014_ = vala_unary_expression_get_operator (_tmp2013_);
				_tmp2015_ = _tmp2014_;
				_tmp2011_ = _tmp2015_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2011_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2016_ = unary;
			_tmp2017_ = vala_unary_expression_get_inner (_tmp2016_);
			_tmp2018_ = _tmp2017_;
			_tmp2019_ = vala_expression_get_value_type (_tmp2018_);
			_tmp2020_ = _tmp2019_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2020_)) {
				ValaCCodeFunction* _tmp2021_;
				ValaCCodeFunction* _tmp2022_;
				ValaUnaryExpression* _tmp2023_;
				ValaExpression* _tmp2024_;
				ValaExpression* _tmp2025_;
				ValaTargetValue* _tmp2026_;
				ValaTargetValue* _tmp2027_;
				ValaCCodeExpression* _tmp2028_;
				ValaCCodeExpression* _tmp2029_;
				_tmp2021_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2022_ = _tmp2021_;
				_tmp2023_ = unary;
				_tmp2024_ = vala_unary_expression_get_inner (_tmp2023_);
				_tmp2025_ = _tmp2024_;
				_tmp2026_ = vala_expression_get_target_value (_tmp2025_);
				_tmp2027_ = _tmp2026_;
				_tmp2028_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2027_, FALSE);
				_tmp2029_ = _tmp2028_;
				vala_ccode_function_add_expression (_tmp2022_, _tmp2029_);
				_vala_ccode_node_unref0 (_tmp2029_);
			}
			_tmp2030_ = unary;
			_tmp2031_ = vala_unary_expression_get_inner (_tmp2030_);
			_tmp2032_ = _tmp2031_;
			_tmp2033_ = vala_expression_get_target_value (_tmp2032_);
			_tmp2034_ = _tmp2033_;
			_tmp2035_ = unary;
			_tmp2036_ = vala_expression_get_target_value ((ValaExpression*) _tmp2035_);
			_tmp2037_ = _tmp2036_;
			_tmp2038_ = unary;
			_tmp2039_ = vala_unary_expression_get_inner (_tmp2038_);
			_tmp2040_ = _tmp2039_;
			_tmp2041_ = vala_expression_get_value_type (_tmp2040_);
			_tmp2042_ = _tmp2041_;
			_tmp2043_ = arg;
			_tmp2044_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2037_, _tmp2042_, (ValaCodeNode*) _tmp2043_);
			_tmp2045_ = _tmp2044_;
			_tmp2046_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2047_ = _tmp2046_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2034_, _tmp2045_, _tmp2047_);
			_vala_target_value_unref0 (_tmp2045_);
			_tmp2049_ = param;
			if (_tmp2049_ != NULL) {
				ValaParameter* _tmp2050_;
				_tmp2050_ = param;
				_tmp2048_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2050_);
			} else {
				_tmp2048_ = FALSE;
			}
			if (_tmp2048_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2051_;
				ValaCCodeIdentifier* _tmp2052_;
				ValaCCodeFunctionCall* _tmp2053_;
				ValaCCodeFunctionCall* _tmp2054_;
				ValaCCodeFunctionCall* _tmp2055_;
				ValaUnaryExpression* _tmp2056_;
				ValaExpression* _tmp2057_;
				ValaExpression* _tmp2058_;
				ValaTargetValue* _tmp2059_;
				ValaTargetValue* _tmp2060_;
				ValaCCodeExpression* _tmp2061_;
				ValaCCodeExpression* _tmp2062_;
				ValaCCodeFunction* _tmp2063_;
				ValaCCodeFunction* _tmp2064_;
				ValaUnaryExpression* _tmp2065_;
				ValaExpression* _tmp2066_;
				ValaExpression* _tmp2067_;
				ValaTargetValue* _tmp2068_;
				ValaTargetValue* _tmp2069_;
				ValaCCodeExpression* _tmp2070_;
				ValaCCodeExpression* _tmp2071_;
				ValaCCodeFunctionCall* _tmp2072_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2051_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2052_ = _tmp2051_;
				_tmp2053_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2052_);
				_tmp2054_ = _tmp2053_;
				_vala_ccode_node_unref0 (_tmp2052_);
				len_call = _tmp2054_;
				_tmp2055_ = len_call;
				_tmp2056_ = unary;
				_tmp2057_ = vala_unary_expression_get_inner (_tmp2056_);
				_tmp2058_ = _tmp2057_;
				_tmp2059_ = vala_expression_get_target_value (_tmp2058_);
				_tmp2060_ = _tmp2059_;
				_tmp2061_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2060_);
				_tmp2062_ = _tmp2061_;
				vala_ccode_function_call_add_argument (_tmp2055_, _tmp2062_);
				_vala_ccode_node_unref0 (_tmp2062_);
				_tmp2063_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2064_ = _tmp2063_;
				_tmp2065_ = unary;
				_tmp2066_ = vala_unary_expression_get_inner (_tmp2065_);
				_tmp2067_ = _tmp2066_;
				_tmp2068_ = vala_expression_get_target_value (_tmp2067_);
				_tmp2069_ = _tmp2068_;
				_tmp2070_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2069_, 1);
				_tmp2071_ = _tmp2070_;
				_tmp2072_ = len_call;
				vala_ccode_function_add_assignment (_tmp2064_, _tmp2071_, (ValaCCodeExpression*) _tmp2072_);
				_vala_ccode_node_unref0 (_tmp2071_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2075_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2075_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2076_;
		ValaSymbol* _tmp2077_;
		ValaSymbol* _tmp2078_;
		_tmp2076_ = m;
		_tmp2077_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2076_);
		_tmp2078_ = _tmp2077_;
		_tmp2074_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2078_, VALA_TYPE_CLASS);
	} else {
		_tmp2074_ = FALSE;
	}
	if (_tmp2074_) {
		gboolean _tmp2079_ = FALSE;
		gboolean _tmp2080_ = FALSE;
		ValaClass* _tmp2081_;
		ValaClass* _tmp2082_;
		gboolean _tmp2083_;
		gboolean _tmp2084_;
		_tmp2081_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2082_ = _tmp2081_;
		_tmp2083_ = vala_class_get_is_compact (_tmp2082_);
		_tmp2084_ = _tmp2083_;
		if (_tmp2084_) {
			ValaClass* _tmp2085_;
			ValaClass* _tmp2086_;
			ValaClass* _tmp2087_;
			ValaClass* _tmp2088_;
			_tmp2085_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2086_ = _tmp2085_;
			_tmp2087_ = vala_class_get_base_class (_tmp2086_);
			_tmp2088_ = _tmp2087_;
			_tmp2080_ = _tmp2088_ != NULL;
		} else {
			_tmp2080_ = FALSE;
		}
		if (_tmp2080_) {
			_tmp2079_ = TRUE;
		} else {
			ValaClass* _tmp2089_;
			ValaClass* _tmp2090_;
			ValaClass* _tmp2091_;
			ValaClass* _tmp2092_;
			ValaClass* _tmp2093_;
			_tmp2089_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2090_ = _tmp2089_;
			_tmp2091_ = vala_class_get_base_class (_tmp2090_);
			_tmp2092_ = _tmp2091_;
			_tmp2093_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2079_ = _tmp2092_ == _tmp2093_;
		}
		_tmp2073_ = _tmp2079_;
	} else {
		_tmp2073_ = FALSE;
	}
	if (_tmp2073_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2094_;
		ValaClass* _tmp2095_;
		gchar* _tmp2096_;
		gchar* _tmp2097_;
		gchar* _tmp2098_;
		gchar* _tmp2099_;
		ValaCCodeIdentifier* _tmp2100_;
		ValaCCodeIdentifier* _tmp2101_;
		ValaCCodeFunctionCall* _tmp2102_;
		ValaCCodeFunctionCall* _tmp2103_;
		ValaCCodeFunctionCall* _tmp2104_;
		ValaCCodeExpression* _tmp2105_;
		ValaCCodeExpression* _tmp2106_;
		ValaClass* _tmp2107_;
		ValaClass* _tmp2108_;
		gboolean _tmp2109_;
		gboolean _tmp2110_;
		ValaCCodeFunction* _tmp2114_;
		ValaCCodeFunction* _tmp2115_;
		ValaCCodeFunctionCall* _tmp2116_;
		_tmp2094_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2095_ = _tmp2094_;
		_tmp2096_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2095_, NULL);
		_tmp2097_ = _tmp2096_;
		_tmp2098_ = g_strdup_printf ("%s_instance_init", _tmp2097_);
		_tmp2099_ = _tmp2098_;
		_tmp2100_ = vala_ccode_identifier_new (_tmp2099_);
		_tmp2101_ = _tmp2100_;
		_tmp2102_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2101_);
		_tmp2103_ = _tmp2102_;
		_vala_ccode_node_unref0 (_tmp2101_);
		_g_free0 (_tmp2099_);
		_g_free0 (_tmp2097_);
		cinitcall = _tmp2103_;
		_tmp2104_ = cinitcall;
		_tmp2105_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2106_ = _tmp2105_;
		vala_ccode_function_call_add_argument (_tmp2104_, _tmp2106_);
		_vala_ccode_node_unref0 (_tmp2106_);
		_tmp2107_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2108_ = _tmp2107_;
		_tmp2109_ = vala_class_get_is_compact (_tmp2108_);
		_tmp2110_ = _tmp2109_;
		if (!_tmp2110_) {
			ValaCCodeFunctionCall* _tmp2111_;
			ValaCCodeConstant* _tmp2112_;
			ValaCCodeConstant* _tmp2113_;
			_tmp2111_ = cinitcall;
			_tmp2112_ = vala_ccode_constant_new ("NULL");
			_tmp2113_ = _tmp2112_;
			vala_ccode_function_call_add_argument (_tmp2111_, (ValaCCodeExpression*) _tmp2113_);
			_vala_ccode_node_unref0 (_tmp2113_);
		}
		_tmp2114_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2115_ = _tmp2114_;
		_tmp2116_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2115_, (ValaCCodeExpression*) _tmp2116_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp44_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeConstant* _tmp49_;
	ValaCCodeFile* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp24_;
			gpointer _tmp25_;
			ValaCCodeFunction* _tmp26_;
			ValaCCodeFunction* _tmp27_;
			ValaEnumValue* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeFunction* _tmp33_;
			ValaCCodeFunction* _tmp34_;
			ValaEnumValue* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			_enum_value_index = _enum_value_index + 1;
			if (!(_enum_value_index < _enum_value_size)) {
				break;
			}
			_tmp24_ = _enum_value_list;
			_tmp25_ = vala_list_get (_tmp24_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp25_;
			_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp27_ = _tmp26_;
			_tmp28_ = enum_value;
			_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_identifier_new (_tmp30_);
			_tmp32_ = _tmp31_;
			vala_ccode_function_add_case (_tmp27_, (ValaCCodeExpression*) _tmp32_);
			_vala_ccode_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp34_ = _tmp33_;
			_tmp35_ = enum_value;
			_tmp36_ = vala_get_ccode_name ((ValaCodeNode*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat ("\"", _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp39_, "\"", NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_constant_new (_tmp41_);
			_tmp43_ = _tmp42_;
			vala_ccode_function_add_return (_tmp34_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp44_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp45_ = _tmp44_;
	vala_ccode_function_close (_tmp45_);
	_tmp46_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_ccode_constant_new ("NULL");
	_tmp49_ = _tmp48_;
	vala_ccode_function_add_return (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp51_ = function;
	vala_ccode_file_add_function_declaration (_tmp50_, _tmp51_);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = function;
	vala_ccode_file_add_function (_tmp52_, _tmp53_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaUnaryExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp4_ = _arg_list;
			_tmp5_ = vala_list_get (_tmp4_, _arg_index);
			arg = (ValaExpression*) _tmp5_;
			_tmp6_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp6_) : NULL;
			_tmp8_ = unary;
			if (_tmp8_ != NULL) {
				gboolean _tmp9_ = FALSE;
				ValaUnaryExpression* _tmp10_;
				ValaUnaryOperator _tmp11_;
				ValaUnaryOperator _tmp12_;
				_tmp10_ = unary;
				_tmp11_ = vala_unary_expression_get_operator (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp9_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp13_;
					ValaUnaryOperator _tmp14_;
					ValaUnaryOperator _tmp15_;
					_tmp13_ = unary;
					_tmp14_ = vala_unary_expression_get_operator (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp9_ = _tmp15_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp7_ = _tmp9_;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeConstant* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeFunctionCall* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeIdentifier* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeBinaryExpression* _tmp60_;
	ValaCCodeBinaryExpression* _tmp61_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeIdentifier* _tmp63_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeFunctionCall* _tmp65_;
	ValaCCodeFunctionCall* _tmp66_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunction* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunctionCall* _tmp74_;
	ValaCCodeFunctionCall* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunction* _tmp79_;
	ValaCCodeFunction* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeFunctionCall* _tmp83_;
	ValaCCodeIdentifier* _tmp84_;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeFunctionCall* _tmp86_;
	ValaCCodeFunctionCall* _tmp87_;
	ValaCCodeIdentifier* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeFunction* _tmp93_;
	ValaCCodeFunction* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunctionCall* _tmp98_;
	ValaCCodeFunctionCall* _tmp99_;
	ValaCCodeIdentifier* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeFunctionCall* _tmp102_;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeFunctionCall* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeIdentifier* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeFunction* _tmp111_;
	ValaCCodeFunction* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunctionCall* _tmp116_;
	ValaCCodeFunctionCall* _tmp117_;
	ValaCCodeIdentifier* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeFunction* _tmp123_;
	ValaCCodeFunction* _tmp124_;
	ValaCCodeIdentifier* _tmp125_;
	ValaCCodeIdentifier* _tmp126_;
	ValaCCodeFile* _tmp127_;
	ValaCCodeFile* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFile* _tmp130_;
	ValaCCodeFunction* _tmp131_;
	gchar* _tmp132_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp38_);
	_tmp40_ = _tmp39_;
	_vala_ccode_node_unref0 (_tmp38_);
	vsnprintf = _tmp40_;
	_tmp41_ = vsnprintf;
	_tmp42_ = vala_ccode_constant_new ("NULL");
	_tmp43_ = _tmp42_;
	vala_ccode_function_call_add_argument (_tmp41_, (ValaCCodeExpression*) _tmp43_);
	_vala_ccode_node_unref0 (_tmp43_);
	_tmp44_ = vsnprintf;
	_tmp45_ = vala_ccode_constant_new ("0");
	_tmp46_ = _tmp45_;
	vala_ccode_function_call_add_argument (_tmp44_, (ValaCCodeExpression*) _tmp46_);
	_vala_ccode_node_unref0 (_tmp46_);
	_tmp47_ = vsnprintf;
	_tmp48_ = vala_ccode_identifier_new ("format");
	_tmp49_ = _tmp48_;
	vala_ccode_function_call_add_argument (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = vsnprintf;
	_tmp51_ = vala_ccode_identifier_new ("ap");
	_tmp52_ = _tmp51_;
	vala_ccode_function_call_add_argument (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_identifier_new ("length");
	_tmp56_ = _tmp55_;
	_tmp57_ = vsnprintf;
	_tmp58_ = vala_ccode_constant_new ("1");
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp57_, (ValaCCodeExpression*) _tmp59_);
	_tmp61_ = _tmp60_;
	vala_ccode_function_add_assignment (_tmp54_, (ValaCCodeExpression*) _tmp56_, (ValaCCodeExpression*) _tmp61_);
	_vala_ccode_node_unref0 (_tmp61_);
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp56_);
	_tmp62_ = vala_ccode_identifier_new ("va_end");
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp63_);
	_tmp65_ = _tmp64_;
	_vala_ccode_node_unref0 (_tmp63_);
	va_end = _tmp65_;
	_tmp66_ = va_end;
	_tmp67_ = vala_ccode_identifier_new ("ap");
	_tmp68_ = _tmp67_;
	vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp68_);
	_vala_ccode_node_unref0 (_tmp68_);
	_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp70_ = _tmp69_;
	_tmp71_ = va_end;
	vala_ccode_function_add_expression (_tmp70_, (ValaCCodeExpression*) _tmp71_);
	_tmp72_ = vala_ccode_identifier_new ("malloc");
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp73_);
	_tmp75_ = _tmp74_;
	_vala_ccode_node_unref0 (_tmp73_);
	malloc = _tmp75_;
	_tmp76_ = malloc;
	_tmp77_ = vala_ccode_identifier_new ("length");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_ccode_identifier_new ("result");
	_tmp82_ = _tmp81_;
	_tmp83_ = malloc;
	vala_ccode_function_add_assignment (_tmp80_, (ValaCCodeExpression*) _tmp82_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp82_);
	_tmp84_ = vala_ccode_identifier_new ("va_start");
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp85_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp86_;
	_vala_ccode_node_unref0 (_tmp85_);
	_tmp87_ = va_start;
	_tmp88_ = vala_ccode_identifier_new ("ap");
	_tmp89_ = _tmp88_;
	vala_ccode_function_call_add_argument (_tmp87_, (ValaCCodeExpression*) _tmp89_);
	_vala_ccode_node_unref0 (_tmp89_);
	_tmp90_ = va_start;
	_tmp91_ = vala_ccode_identifier_new ("format");
	_tmp92_ = _tmp91_;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp92_);
	_vala_ccode_node_unref0 (_tmp92_);
	_tmp93_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp94_ = _tmp93_;
	_tmp95_ = va_start;
	vala_ccode_function_add_expression (_tmp94_, (ValaCCodeExpression*) _tmp95_);
	_tmp96_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp98_;
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp99_ = vsnprintf;
	_tmp100_ = vala_ccode_identifier_new ("result");
	_tmp101_ = _tmp100_;
	vala_ccode_function_call_add_argument (_tmp99_, (ValaCCodeExpression*) _tmp101_);
	_vala_ccode_node_unref0 (_tmp101_);
	_tmp102_ = vsnprintf;
	_tmp103_ = vala_ccode_identifier_new ("length");
	_tmp104_ = _tmp103_;
	vala_ccode_function_call_add_argument (_tmp102_, (ValaCCodeExpression*) _tmp104_);
	_vala_ccode_node_unref0 (_tmp104_);
	_tmp105_ = vsnprintf;
	_tmp106_ = vala_ccode_identifier_new ("format");
	_tmp107_ = _tmp106_;
	vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp107_);
	_vala_ccode_node_unref0 (_tmp107_);
	_tmp108_ = vsnprintf;
	_tmp109_ = vala_ccode_identifier_new ("ap");
	_tmp110_ = _tmp109_;
	vala_ccode_function_call_add_argument (_tmp108_, (ValaCCodeExpression*) _tmp110_);
	_vala_ccode_node_unref0 (_tmp110_);
	_tmp111_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp112_, (ValaCCodeExpression*) _tmp113_);
	_tmp114_ = vala_ccode_identifier_new ("va_end");
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp116_;
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp117_ = va_end;
	_tmp118_ = vala_ccode_identifier_new ("ap");
	_tmp119_ = _tmp118_;
	vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
	_vala_ccode_node_unref0 (_tmp119_);
	_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = va_end;
	vala_ccode_function_add_expression (_tmp121_, (ValaCCodeExpression*) _tmp122_);
	_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_identifier_new ("result");
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_return (_tmp124_, (ValaCCodeExpression*) _tmp126_);
	_vala_ccode_node_unref0 (_tmp126_);
	_tmp127_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp127_, "stdarg.h", FALSE);
	_tmp128_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp129_ = function;
	vala_ccode_file_add_function_declaration (_tmp128_, _tmp129_);
	_tmp130_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp131_ = function;
	vala_ccode_file_add_function (_tmp130_, _tmp131_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp132_ = g_strdup ("string_printf");
	result = _tmp132_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

