/* valabinaryexpression.c generated by valac, the Vala compiler
 * generated from valabinaryexpression.vala, do not modify */

/* valabinaryexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaBinaryExpressionPrivate {
	ValaBinaryOperator _operator;
	gboolean _is_chained;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaBinaryExpression_private_offset;
static gpointer vala_binary_expression_parent_class = NULL;

static void vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                            gboolean value);
static void vala_binary_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                     ValaExpression* old_node,
                                                     ValaExpression* new_node);
static gchar* vala_binary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_binary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_binary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_binary_expression_real_is_non_null (ValaExpression* base);
static gboolean vala_binary_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym);
static void vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                                  ValaCollection* collection,
                                                  ValaSourceReference* source_reference);
static gboolean vala_binary_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_binary_expression_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                        ValaCollection* collection);
static void vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_binary_expression_finalize (ValaCodeNode * obj);

static inline gpointer
vala_binary_expression_get_instance_private (ValaBinaryExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaBinaryExpression_private_offset);
}

/**
 * Creates a new binary expression.
 *
 * @param op      binary operator
 * @param _left   left operand
 * @param _right  right operand
 * @param source  reference to source code
 * @return        newly created binary expression
 */
ValaBinaryExpression*
vala_binary_expression_construct (GType object_type,
                                  ValaBinaryOperator op,
                                  ValaExpression* _left,
                                  ValaExpression* _right,
                                  ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, FALSE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new (ValaBinaryOperator op,
                            ValaExpression* _left,
                            ValaExpression* _right,
                            ValaSourceReference* source)
{
	return vala_binary_expression_construct (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

ValaBinaryExpression*
vala_binary_expression_construct_chained (GType object_type,
                                          ValaBinaryOperator op,
                                          ValaExpression* _left,
                                          ValaExpression* _right,
                                          ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, TRUE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new_chained (ValaBinaryOperator op,
                                    ValaExpression* _left,
                                    ValaExpression* _right,
                                    ValaSourceReference* source)
{
	return vala_binary_expression_construct_chained (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

static void
vala_binary_expression_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_binary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static void
vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                ValaExpression* old_node,
                                                ValaExpression* new_node)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_binary_expression_set_left (self, new_node);
	}
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_binary_expression_set_right (self, new_node);
	}
}

static gchar*
vala_binary_expression_real_to_string (ValaCodeNode* base)
{
	ValaBinaryExpression * self;
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaBinaryOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	self = (ValaBinaryExpression*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_binary_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static gboolean
vala_binary_expression_real_is_constant (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_constant (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_constant (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_pure (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_pure (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_pure (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_non_null (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_non_null (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_non_null (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_accessible (ValaExpression* base,
                                           ValaSymbol* sym)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                             ValaCollection* collection,
                                             ValaSourceReference* source_reference)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_binary_expression_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaBinaryOperator _tmp126_;
	gboolean _tmp318_ = FALSE;
	gboolean _tmp319_ = FALSE;
	ValaDataType* _tmp320_;
	ValaDataType* _tmp321_;
	ValaExpression* _tmp341_;
	ValaExpression* _tmp342_;
	gboolean _tmp343_ = FALSE;
	gboolean _tmp344_ = FALSE;
	ValaExpression* _tmp345_;
	ValaExpression* _tmp346_;
	ValaDataType* _tmp347_;
	ValaDataType* _tmp348_;
	ValaExpression* _tmp366_;
	ValaExpression* _tmp367_;
	gboolean _tmp368_ = FALSE;
	gboolean _tmp369_ = FALSE;
	ValaExpression* _tmp370_;
	ValaExpression* _tmp371_;
	ValaDataType* _tmp372_;
	ValaDataType* _tmp373_;
	gboolean _tmp391_ = FALSE;
	ValaExpression* _tmp392_;
	ValaExpression* _tmp393_;
	ValaExpression* _tmp396_;
	ValaExpression* _tmp397_;
	ValaDataType* _tmp398_;
	ValaDataType* _tmp399_;
	gboolean _tmp404_ = FALSE;
	ValaBinaryOperator _tmp405_;
	gboolean _tmp414_ = FALSE;
	ValaExpression* _tmp415_;
	ValaExpression* _tmp416_;
	ValaDataType* _tmp417_;
	ValaDataType* _tmp418_;
	gboolean _tmp435_ = FALSE;
	ValaExpression* _tmp436_;
	ValaExpression* _tmp437_;
	ValaDataType* _tmp438_;
	ValaDataType* _tmp439_;
	ValaExpression* _tmp456_;
	ValaExpression* _tmp457_;
	ValaExpression* _tmp458_;
	ValaExpression* _tmp459_;
	ValaDataType* _tmp460_;
	ValaDataType* _tmp461_;
	ValaDataType* _tmp462_;
	ValaDataType* _tmp463_;
	ValaExpression* _tmp464_;
	ValaExpression* _tmp465_;
	ValaDataType* _tmp466_;
	ValaDataType* _tmp467_;
	ValaExpression* _tmp468_;
	ValaExpression* _tmp469_;
	ValaExpression* _tmp470_;
	ValaExpression* _tmp471_;
	ValaDataType* _tmp472_;
	ValaDataType* _tmp473_;
	ValaDataType* _tmp474_;
	ValaDataType* _tmp475_;
	ValaExpression* _tmp476_;
	ValaExpression* _tmp477_;
	ValaDataType* _tmp478_;
	ValaDataType* _tmp479_;
	gboolean _tmp480_ = FALSE;
	ValaExpression* _tmp481_;
	ValaExpression* _tmp482_;
	ValaDataType* _tmp483_;
	ValaDataType* _tmp484_;
	ValaTypeSymbol* _tmp485_;
	ValaTypeSymbol* _tmp486_;
	ValaSemanticAnalyzer* _tmp487_;
	ValaSemanticAnalyzer* _tmp488_;
	ValaDataType* _tmp489_;
	ValaTypeSymbol* _tmp490_;
	ValaTypeSymbol* _tmp491_;
	ValaDataType* _tmp1117_;
	ValaDataType* _tmp1118_;
	gboolean _tmp1119_;
	gboolean _tmp1120_;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_code_context_get_analyzer (context);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_symbol (_tmp6_);
	_tmp8_ = _tmp7_;
	if (VALA_IS_BLOCK (_tmp8_)) {
		gboolean _tmp9_ = FALSE;
		ValaBinaryOperator _tmp10_;
		_tmp10_ = self->priv->_operator;
		if (_tmp10_ == VALA_BINARY_OPERATOR_AND) {
			_tmp9_ = TRUE;
		} else {
			ValaBinaryOperator _tmp11_;
			_tmp11_ = self->priv->_operator;
			_tmp9_ = _tmp11_ == VALA_BINARY_OPERATOR_OR;
		}
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaLocalVariable* local = NULL;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaMemberAccess* _tmp34_;
		ValaMemberAccess* _tmp35_;
		ValaExpression* _tmp36_;
		ValaExpression* _tmp37_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaAssignment* _tmp42_;
		ValaAssignment* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaExpressionStatement* _tmp48_;
		ValaExpressionStatement* _tmp49_;
		ValaExpressionStatement* stmt = NULL;
		ValaLocalVariable* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaSourceReference* _tmp55_;
		ValaSourceReference* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaMemberAccess* _tmp58_;
		ValaBinaryOperator _tmp59_;
		ValaExpression* _tmp60_;
		ValaExpression* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaBooleanLiteral* _tmp64_;
		ValaBooleanLiteral* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaSourceReference* _tmp69_;
		ValaAssignment* _tmp70_;
		ValaAssignment* _tmp71_;
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		ValaExpressionStatement* _tmp76_;
		ValaExpressionStatement* _tmp77_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		ValaBlock* _tmp80_;
		ValaBlock* false_block = NULL;
		ValaSourceReference* _tmp81_;
		ValaSourceReference* _tmp82_;
		ValaBlock* _tmp83_;
		ValaBinaryOperator _tmp84_;
		ValaIfStatement* if_stmt = NULL;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		ValaBlock* _tmp95_;
		ValaBlock* _tmp96_;
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		ValaIfStatement* _tmp99_;
		ValaSemanticAnalyzer* _tmp100_;
		ValaSemanticAnalyzer* _tmp101_;
		ValaBlock* _tmp102_;
		ValaDeclarationStatement* _tmp103_;
		ValaSemanticAnalyzer* _tmp104_;
		ValaSemanticAnalyzer* _tmp105_;
		ValaBlock* _tmp106_;
		ValaIfStatement* _tmp107_;
		ValaDeclarationStatement* _tmp108_;
		ValaIfStatement* _tmp109_;
		ValaMemberAccess* ma = NULL;
		ValaLocalVariable* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaMemberAccess* _tmp115_;
		ValaMemberAccess* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		ValaMemberAccess* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		ValaCodeNode* _tmp122_;
		ValaCodeNode* _tmp123_;
		ValaMemberAccess* _tmp124_;
		ValaMemberAccess* _tmp125_;
		_tmp12_ = vala_code_context_get_analyzer (context);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->bool_type;
		_tmp15_ = vala_data_type_copy (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_code_node_get_temp_name ();
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (_tmp16_, _tmp18_, NULL, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp18_);
		_vala_code_node_unref0 (_tmp16_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = local;
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_binary_expression_get_right (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_member_access_new_simple (_tmp29_, _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_binary_expression_get_right (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_binary_expression_get_right (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_assignment_new ((ValaExpression*) _tmp35_, _tmp37_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_binary_expression_get_right (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_statement_new ((ValaExpression*) _tmp43_, _tmp47_);
		_tmp49_ = _tmp48_;
		_vala_code_node_unref0 (_tmp43_);
		_vala_code_node_unref0 (_tmp35_);
		right_stmt = _tmp49_;
		_tmp50_ = local;
		_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_binary_expression_get_left (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = self->priv->_operator;
		_tmp60_ = vala_binary_expression_get_left (self);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_boolean_literal_new (_tmp59_ == VALA_BINARY_OPERATOR_OR, _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_binary_expression_get_left (self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_assignment_new ((ValaExpression*) _tmp58_, (ValaExpression*) _tmp65_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_binary_expression_get_left (self);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_expression_statement_new ((ValaExpression*) _tmp71_, _tmp75_);
		_tmp77_ = _tmp76_;
		_vala_code_node_unref0 (_tmp71_);
		_vala_code_node_unref0 (_tmp65_);
		_vala_code_node_unref0 (_tmp58_);
		stmt = _tmp77_;
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_block_new (_tmp79_);
		true_block = _tmp80_;
		_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_block_new (_tmp82_);
		false_block = _tmp83_;
		_tmp84_ = self->priv->_operator;
		if (_tmp84_ == VALA_BINARY_OPERATOR_AND) {
			ValaBlock* _tmp85_;
			ValaExpressionStatement* _tmp86_;
			ValaBlock* _tmp87_;
			ValaExpressionStatement* _tmp88_;
			_tmp85_ = true_block;
			_tmp86_ = right_stmt;
			vala_block_add_statement (_tmp85_, (ValaStatement*) _tmp86_);
			_tmp87_ = false_block;
			_tmp88_ = stmt;
			vala_block_add_statement (_tmp87_, (ValaStatement*) _tmp88_);
		} else {
			ValaBlock* _tmp89_;
			ValaExpressionStatement* _tmp90_;
			ValaBlock* _tmp91_;
			ValaExpressionStatement* _tmp92_;
			_tmp89_ = true_block;
			_tmp90_ = stmt;
			vala_block_add_statement (_tmp89_, (ValaStatement*) _tmp90_);
			_tmp91_ = false_block;
			_tmp92_ = right_stmt;
			vala_block_add_statement (_tmp91_, (ValaStatement*) _tmp92_);
		}
		_tmp93_ = vala_binary_expression_get_left (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = true_block;
		_tmp96_ = false_block;
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_if_statement_new (_tmp94_, _tmp95_, _tmp96_, _tmp98_);
		if_stmt = _tmp99_;
		_tmp100_ = vala_code_context_get_analyzer (context);
		_tmp101_ = _tmp100_;
		_tmp102_ = _tmp101_->insert_block;
		_tmp103_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp102_, (ValaStatement*) _tmp103_);
		_tmp104_ = vala_code_context_get_analyzer (context);
		_tmp105_ = _tmp104_;
		_tmp106_ = _tmp105_->insert_block;
		_tmp107_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp106_, (ValaStatement*) _tmp107_);
		_tmp108_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp108_, context);
		_tmp109_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp109_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (false_block);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			return result;
		}
		_tmp110_ = local;
		_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_member_access_new_simple (_tmp112_, _tmp114_);
		ma = _tmp115_;
		_tmp116_ = ma;
		_tmp117_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp118_ = _tmp117_;
		vala_expression_set_target_type ((ValaExpression*) _tmp116_, _tmp118_);
		_tmp119_ = ma;
		_tmp120_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp121_ = _tmp120_;
		vala_expression_set_formal_target_type ((ValaExpression*) _tmp119_, _tmp121_);
		_tmp122_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = ma;
		vala_code_node_replace_expression (_tmp123_, (ValaExpression*) self, (ValaExpression*) _tmp124_);
		_tmp125_ = ma;
		vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
		result = TRUE;
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (false_block);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp126_ = self->priv->_operator;
	if (_tmp126_ == VALA_BINARY_OPERATOR_COALESCE) {
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		ValaExpression* _tmp129_;
		ValaExpression* _tmp130_;
		ValaDataType* local_type = NULL;
		gboolean cast_non_null = FALSE;
		gboolean _tmp131_ = FALSE;
		ValaExpression* _tmp132_;
		ValaExpression* _tmp133_;
		ValaDataType* _tmp134_;
		ValaDataType* _tmp135_;
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp218_;
		gchar* _tmp219_;
		gchar* _tmp220_;
		ValaExpression* _tmp221_;
		ValaExpression* _tmp222_;
		ValaSourceReference* _tmp223_;
		ValaSourceReference* _tmp224_;
		ValaLocalVariable* _tmp225_;
		ValaLocalVariable* _tmp226_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp227_;
		ValaSourceReference* _tmp228_;
		ValaSourceReference* _tmp229_;
		ValaDeclarationStatement* _tmp230_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp231_;
		const gchar* _tmp232_;
		const gchar* _tmp233_;
		ValaExpression* _tmp234_;
		ValaExpression* _tmp235_;
		ValaSourceReference* _tmp236_;
		ValaSourceReference* _tmp237_;
		ValaMemberAccess* _tmp238_;
		ValaMemberAccess* _tmp239_;
		ValaExpression* _tmp240_;
		ValaExpression* _tmp241_;
		ValaExpression* _tmp242_;
		ValaExpression* _tmp243_;
		ValaSourceReference* _tmp244_;
		ValaSourceReference* _tmp245_;
		ValaAssignment* _tmp246_;
		ValaAssignment* _tmp247_;
		ValaExpression* _tmp248_;
		ValaExpression* _tmp249_;
		ValaSourceReference* _tmp250_;
		ValaSourceReference* _tmp251_;
		ValaExpressionStatement* _tmp252_;
		ValaExpressionStatement* _tmp253_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp254_;
		ValaSourceReference* _tmp255_;
		ValaBlock* _tmp256_;
		ValaBlock* _tmp257_;
		ValaExpressionStatement* _tmp258_;
		ValaBinaryExpression* cond = NULL;
		ValaLocalVariable* _tmp259_;
		const gchar* _tmp260_;
		const gchar* _tmp261_;
		ValaExpression* _tmp262_;
		ValaExpression* _tmp263_;
		ValaSourceReference* _tmp264_;
		ValaSourceReference* _tmp265_;
		ValaMemberAccess* _tmp266_;
		ValaMemberAccess* _tmp267_;
		ValaSourceReference* _tmp268_;
		ValaSourceReference* _tmp269_;
		ValaNullLiteral* _tmp270_;
		ValaNullLiteral* _tmp271_;
		ValaSourceReference* _tmp272_;
		ValaSourceReference* _tmp273_;
		ValaBinaryExpression* _tmp274_;
		ValaBinaryExpression* _tmp275_;
		ValaIfStatement* if_stmt = NULL;
		ValaBinaryExpression* _tmp276_;
		ValaBlock* _tmp277_;
		ValaSourceReference* _tmp278_;
		ValaSourceReference* _tmp279_;
		ValaIfStatement* _tmp280_;
		ValaSemanticAnalyzer* _tmp281_;
		ValaSemanticAnalyzer* _tmp282_;
		ValaBlock* _tmp283_;
		ValaDeclarationStatement* _tmp284_;
		ValaSemanticAnalyzer* _tmp285_;
		ValaSemanticAnalyzer* _tmp286_;
		ValaBlock* _tmp287_;
		ValaIfStatement* _tmp288_;
		ValaDeclarationStatement* _tmp289_;
		ValaIfStatement* _tmp290_;
		ValaExpression* replace_expr = NULL;
		ValaLocalVariable* _tmp291_;
		ValaDataType* _tmp292_;
		ValaDataType* _tmp293_;
		ValaExpression* _tmp294_;
		gboolean _tmp295_ = FALSE;
		ValaCodeNode* _tmp314_;
		ValaCodeNode* _tmp315_;
		ValaExpression* _tmp316_;
		ValaExpression* _tmp317_;
		_tmp127_ = vala_binary_expression_get_left (self);
		_tmp128_ = _tmp127_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp128_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp129_ = vala_binary_expression_get_right (self);
		_tmp130_ = _tmp129_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp130_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		local_type = NULL;
		cast_non_null = FALSE;
		_tmp132_ = vala_binary_expression_get_left (self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_expression_get_value_type (_tmp133_);
		_tmp135_ = _tmp134_;
		if (VALA_IS_NULL_TYPE (_tmp135_)) {
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			_tmp136_ = vala_binary_expression_get_right (self);
			_tmp137_ = _tmp136_;
			_tmp138_ = vala_expression_get_value_type (_tmp137_);
			_tmp139_ = _tmp138_;
			_tmp131_ = _tmp139_ != NULL;
		} else {
			_tmp131_ = FALSE;
		}
		if (_tmp131_) {
			ValaExpression* _tmp140_;
			ValaExpression* _tmp141_;
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			ValaExpression* _tmp144_;
			ValaExpression* _tmp145_;
			ValaDataType* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			ValaDataType* _tmp149_;
			ValaExpression* _tmp150_;
			ValaExpression* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			gboolean _tmp154_;
			gboolean _tmp155_;
			_tmp140_ = vala_binary_expression_get_left (self);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp141_);
			_tmp143_ = _tmp142_;
			vala_report_warning (_tmp143_, "left operand is always null");
			_tmp144_ = vala_binary_expression_get_right (self);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_expression_get_value_type (_tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_data_type_copy (_tmp147_);
			_vala_code_node_unref0 (local_type);
			local_type = _tmp148_;
			_tmp149_ = local_type;
			vala_data_type_set_nullable (_tmp149_, TRUE);
			_tmp150_ = vala_binary_expression_get_right (self);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_expression_get_value_type (_tmp151_);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_data_type_get_nullable (_tmp153_);
			_tmp155_ = _tmp154_;
			if (!_tmp155_) {
				cast_non_null = TRUE;
			}
		} else {
			ValaExpression* _tmp156_;
			ValaExpression* _tmp157_;
			ValaDataType* _tmp158_;
			ValaDataType* _tmp159_;
			_tmp156_ = vala_binary_expression_get_left (self);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_expression_get_value_type (_tmp157_);
			_tmp159_ = _tmp158_;
			if (_tmp159_ != NULL) {
				ValaExpression* _tmp160_;
				ValaExpression* _tmp161_;
				ValaDataType* _tmp162_;
				ValaDataType* _tmp163_;
				ValaDataType* _tmp164_;
				gboolean _tmp165_ = FALSE;
				ValaExpression* _tmp166_;
				ValaExpression* _tmp167_;
				ValaDataType* _tmp168_;
				ValaDataType* _tmp169_;
				gboolean _tmp177_;
				gboolean _tmp178_;
				_tmp160_ = vala_binary_expression_get_left (self);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_expression_get_value_type (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_data_type_copy (_tmp163_);
				_vala_code_node_unref0 (local_type);
				local_type = _tmp164_;
				_tmp166_ = vala_binary_expression_get_right (self);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_expression_get_value_type (_tmp167_);
				_tmp169_ = _tmp168_;
				if (_tmp169_ != NULL) {
					ValaExpression* _tmp170_;
					ValaExpression* _tmp171_;
					ValaDataType* _tmp172_;
					ValaDataType* _tmp173_;
					gboolean _tmp174_;
					gboolean _tmp175_;
					_tmp170_ = vala_binary_expression_get_right (self);
					_tmp171_ = _tmp170_;
					_tmp172_ = vala_expression_get_value_type (_tmp171_);
					_tmp173_ = _tmp172_;
					_tmp174_ = vala_data_type_get_value_owned (_tmp173_);
					_tmp175_ = _tmp174_;
					_tmp165_ = _tmp175_;
				} else {
					_tmp165_ = FALSE;
				}
				if (_tmp165_) {
					ValaDataType* _tmp176_;
					_tmp176_ = local_type;
					vala_data_type_set_value_owned (_tmp176_, TRUE);
				}
				_tmp177_ = vala_code_context_get_experimental_non_null (context);
				_tmp178_ = _tmp177_;
				if (_tmp178_) {
					ValaDataType* _tmp179_;
					gboolean _tmp180_;
					gboolean _tmp181_;
					_tmp179_ = local_type;
					_tmp180_ = vala_data_type_get_nullable (_tmp179_);
					_tmp181_ = _tmp180_;
					if (!_tmp181_) {
						ValaExpression* _tmp182_;
						ValaExpression* _tmp183_;
						ValaSourceReference* _tmp184_;
						ValaSourceReference* _tmp185_;
						gboolean _tmp186_ = FALSE;
						ValaExpression* _tmp187_;
						ValaExpression* _tmp188_;
						ValaDataType* _tmp189_;
						ValaDataType* _tmp190_;
						_tmp182_ = vala_binary_expression_get_left (self);
						_tmp183_ = _tmp182_;
						_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp183_);
						_tmp185_ = _tmp184_;
						vala_report_warning (_tmp185_, "left operand is never null");
						_tmp187_ = vala_binary_expression_get_right (self);
						_tmp188_ = _tmp187_;
						_tmp189_ = vala_expression_get_value_type (_tmp188_);
						_tmp190_ = _tmp189_;
						if (_tmp190_ != NULL) {
							ValaExpression* _tmp191_;
							ValaExpression* _tmp192_;
							ValaDataType* _tmp193_;
							ValaDataType* _tmp194_;
							gboolean _tmp195_;
							gboolean _tmp196_;
							_tmp191_ = vala_binary_expression_get_right (self);
							_tmp192_ = _tmp191_;
							_tmp193_ = vala_expression_get_value_type (_tmp192_);
							_tmp194_ = _tmp193_;
							_tmp195_ = vala_data_type_get_nullable (_tmp194_);
							_tmp196_ = _tmp195_;
							_tmp186_ = _tmp196_;
						} else {
							_tmp186_ = FALSE;
						}
						if (_tmp186_) {
							ValaDataType* _tmp197_;
							_tmp197_ = local_type;
							vala_data_type_set_nullable (_tmp197_, TRUE);
							cast_non_null = TRUE;
						}
					} else {
						gboolean _tmp198_ = FALSE;
						ValaExpression* _tmp199_;
						ValaExpression* _tmp200_;
						ValaDataType* _tmp201_;
						ValaDataType* _tmp202_;
						_tmp199_ = vala_binary_expression_get_right (self);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_expression_get_value_type (_tmp200_);
						_tmp202_ = _tmp201_;
						if (_tmp202_ != NULL) {
							ValaExpression* _tmp203_;
							ValaExpression* _tmp204_;
							ValaDataType* _tmp205_;
							ValaDataType* _tmp206_;
							gboolean _tmp207_;
							gboolean _tmp208_;
							_tmp203_ = vala_binary_expression_get_right (self);
							_tmp204_ = _tmp203_;
							_tmp205_ = vala_expression_get_value_type (_tmp204_);
							_tmp206_ = _tmp205_;
							_tmp207_ = vala_data_type_get_nullable (_tmp206_);
							_tmp208_ = _tmp207_;
							_tmp198_ = !_tmp208_;
						} else {
							_tmp198_ = FALSE;
						}
						if (_tmp198_) {
							cast_non_null = TRUE;
						}
					}
				}
			} else {
				ValaExpression* _tmp209_;
				ValaExpression* _tmp210_;
				ValaDataType* _tmp211_;
				ValaDataType* _tmp212_;
				_tmp209_ = vala_binary_expression_get_right (self);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_expression_get_value_type (_tmp210_);
				_tmp212_ = _tmp211_;
				if (_tmp212_ != NULL) {
					ValaExpression* _tmp213_;
					ValaExpression* _tmp214_;
					ValaDataType* _tmp215_;
					ValaDataType* _tmp216_;
					ValaDataType* _tmp217_;
					_tmp213_ = vala_binary_expression_get_right (self);
					_tmp214_ = _tmp213_;
					_tmp215_ = vala_expression_get_value_type (_tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_data_type_copy (_tmp216_);
					_vala_code_node_unref0 (local_type);
					local_type = _tmp217_;
				}
			}
		}
		_tmp218_ = local_type;
		_tmp219_ = vala_code_node_get_temp_name ();
		_tmp220_ = _tmp219_;
		_tmp221_ = vala_binary_expression_get_left (self);
		_tmp222_ = _tmp221_;
		_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp224_ = _tmp223_;
		_tmp225_ = vala_local_variable_new (_tmp218_, _tmp220_, _tmp222_, _tmp224_);
		_tmp226_ = _tmp225_;
		_g_free0 (_tmp220_);
		local = _tmp226_;
		_tmp227_ = local;
		_tmp228_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp229_ = _tmp228_;
		_tmp230_ = vala_declaration_statement_new ((ValaSymbol*) _tmp227_, _tmp229_);
		decl = _tmp230_;
		_tmp231_ = local;
		_tmp232_ = vala_symbol_get_name ((ValaSymbol*) _tmp231_);
		_tmp233_ = _tmp232_;
		_tmp234_ = vala_binary_expression_get_right (self);
		_tmp235_ = _tmp234_;
		_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp235_);
		_tmp237_ = _tmp236_;
		_tmp238_ = vala_member_access_new_simple (_tmp233_, _tmp237_);
		_tmp239_ = _tmp238_;
		_tmp240_ = vala_binary_expression_get_right (self);
		_tmp241_ = _tmp240_;
		_tmp242_ = vala_binary_expression_get_right (self);
		_tmp243_ = _tmp242_;
		_tmp244_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp243_);
		_tmp245_ = _tmp244_;
		_tmp246_ = vala_assignment_new ((ValaExpression*) _tmp239_, _tmp241_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp245_);
		_tmp247_ = _tmp246_;
		_tmp248_ = vala_binary_expression_get_right (self);
		_tmp249_ = _tmp248_;
		_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp249_);
		_tmp251_ = _tmp250_;
		_tmp252_ = vala_expression_statement_new ((ValaExpression*) _tmp247_, _tmp251_);
		_tmp253_ = _tmp252_;
		_vala_code_node_unref0 (_tmp247_);
		_vala_code_node_unref0 (_tmp239_);
		right_stmt = _tmp253_;
		_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp255_ = _tmp254_;
		_tmp256_ = vala_block_new (_tmp255_);
		true_block = _tmp256_;
		_tmp257_ = true_block;
		_tmp258_ = right_stmt;
		vala_block_add_statement (_tmp257_, (ValaStatement*) _tmp258_);
		_tmp259_ = local;
		_tmp260_ = vala_symbol_get_name ((ValaSymbol*) _tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = vala_binary_expression_get_left (self);
		_tmp263_ = _tmp262_;
		_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp263_);
		_tmp265_ = _tmp264_;
		_tmp266_ = vala_member_access_new_simple (_tmp261_, _tmp265_);
		_tmp267_ = _tmp266_;
		_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp269_ = _tmp268_;
		_tmp270_ = vala_null_literal_new (_tmp269_);
		_tmp271_ = _tmp270_;
		_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_EQUALITY, (ValaExpression*) _tmp267_, (ValaExpression*) _tmp271_, _tmp273_);
		_tmp275_ = _tmp274_;
		_vala_code_node_unref0 (_tmp271_);
		_vala_code_node_unref0 (_tmp267_);
		cond = _tmp275_;
		_tmp276_ = cond;
		_tmp277_ = true_block;
		_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_if_statement_new ((ValaExpression*) _tmp276_, _tmp277_, NULL, _tmp279_);
		if_stmt = _tmp280_;
		_tmp281_ = vala_code_context_get_analyzer (context);
		_tmp282_ = _tmp281_;
		_tmp283_ = _tmp282_->insert_block;
		_tmp284_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp283_, (ValaStatement*) _tmp284_);
		_tmp285_ = vala_code_context_get_analyzer (context);
		_tmp286_ = _tmp285_;
		_tmp287_ = _tmp286_->insert_block;
		_tmp288_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp287_, (ValaStatement*) _tmp288_);
		_tmp289_ = decl;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp289_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			return result;
		}
		_tmp290_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp290_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			return result;
		}
		_tmp291_ = local;
		_tmp292_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp293_ = _tmp292_;
		_tmp294_ = vala_semantic_analyzer_create_temp_access (_tmp291_, _tmp293_);
		replace_expr = _tmp294_;
		if (cast_non_null) {
			ValaExpression* _tmp296_;
			ValaDataType* _tmp297_;
			ValaDataType* _tmp298_;
			_tmp296_ = replace_expr;
			_tmp297_ = vala_expression_get_target_type (_tmp296_);
			_tmp298_ = _tmp297_;
			_tmp295_ = _tmp298_ != NULL;
		} else {
			_tmp295_ = FALSE;
		}
		if (_tmp295_) {
			ValaCastExpression* cast = NULL;
			ValaExpression* _tmp299_;
			ValaSourceReference* _tmp300_;
			ValaSourceReference* _tmp301_;
			ValaCastExpression* _tmp302_;
			ValaCastExpression* _tmp303_;
			ValaExpression* _tmp304_;
			ValaDataType* _tmp305_;
			ValaDataType* _tmp306_;
			ValaDataType* _tmp307_;
			ValaDataType* _tmp308_;
			ValaCastExpression* _tmp309_;
			ValaDataType* _tmp310_;
			ValaDataType* _tmp311_;
			ValaCastExpression* _tmp312_;
			ValaExpression* _tmp313_;
			_tmp299_ = replace_expr;
			_tmp300_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_cast_expression_new_non_null (_tmp299_, _tmp301_);
			cast = _tmp302_;
			_tmp303_ = cast;
			_tmp304_ = replace_expr;
			_tmp305_ = vala_expression_get_target_type (_tmp304_);
			_tmp306_ = _tmp305_;
			_tmp307_ = vala_data_type_copy (_tmp306_);
			_tmp308_ = _tmp307_;
			vala_expression_set_target_type ((ValaExpression*) _tmp303_, _tmp308_);
			_vala_code_node_unref0 (_tmp308_);
			_tmp309_ = cast;
			_tmp310_ = vala_expression_get_target_type ((ValaExpression*) _tmp309_);
			_tmp311_ = _tmp310_;
			vala_data_type_set_nullable (_tmp311_, FALSE);
			_tmp312_ = cast;
			_tmp313_ = _vala_code_node_ref0 ((ValaExpression*) _tmp312_);
			_vala_code_node_unref0 (replace_expr);
			replace_expr = _tmp313_;
			_vala_code_node_unref0 (cast);
		}
		_tmp314_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp315_ = _tmp314_;
		_tmp316_ = replace_expr;
		vala_code_node_replace_expression (_tmp315_, (ValaExpression*) self, _tmp316_);
		_tmp317_ = replace_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp317_, context);
		result = TRUE;
		_vala_code_node_unref0 (replace_expr);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (cond);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (local_type);
		return result;
	}
	_tmp320_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp321_ = _tmp320_;
	if (_tmp321_ != NULL) {
		ValaDataType* _tmp322_;
		ValaDataType* _tmp323_;
		ValaTypeSymbol* _tmp324_;
		ValaTypeSymbol* _tmp325_;
		_tmp322_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp323_ = _tmp322_;
		_tmp324_ = vala_data_type_get_data_type (_tmp323_);
		_tmp325_ = _tmp324_;
		_tmp319_ = VALA_IS_ENUM (_tmp325_);
	} else {
		_tmp319_ = FALSE;
	}
	if (_tmp319_) {
		gboolean _tmp326_ = FALSE;
		ValaBinaryOperator _tmp327_;
		_tmp327_ = self->priv->_operator;
		if (_tmp327_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
			_tmp326_ = TRUE;
		} else {
			ValaBinaryOperator _tmp328_;
			_tmp328_ = self->priv->_operator;
			_tmp326_ = _tmp328_ == VALA_BINARY_OPERATOR_BITWISE_OR;
		}
		_tmp318_ = _tmp326_;
	} else {
		_tmp318_ = FALSE;
	}
	if (_tmp318_) {
		ValaExpression* _tmp329_;
		ValaExpression* _tmp330_;
		ValaDataType* _tmp331_;
		ValaDataType* _tmp332_;
		ValaDataType* _tmp333_;
		ValaDataType* _tmp334_;
		ValaExpression* _tmp335_;
		ValaExpression* _tmp336_;
		ValaDataType* _tmp337_;
		ValaDataType* _tmp338_;
		ValaDataType* _tmp339_;
		ValaDataType* _tmp340_;
		_tmp329_ = vala_binary_expression_get_left (self);
		_tmp330_ = _tmp329_;
		_tmp331_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp332_ = _tmp331_;
		_tmp333_ = vala_data_type_copy (_tmp332_);
		_tmp334_ = _tmp333_;
		vala_expression_set_target_type (_tmp330_, _tmp334_);
		_vala_code_node_unref0 (_tmp334_);
		_tmp335_ = vala_binary_expression_get_right (self);
		_tmp336_ = _tmp335_;
		_tmp337_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp338_ = _tmp337_;
		_tmp339_ = vala_data_type_copy (_tmp338_);
		_tmp340_ = _tmp339_;
		vala_expression_set_target_type (_tmp336_, _tmp340_);
		_vala_code_node_unref0 (_tmp340_);
	}
	_tmp341_ = vala_binary_expression_get_left (self);
	_tmp342_ = _tmp341_;
	vala_code_node_check ((ValaCodeNode*) _tmp342_, context);
	_tmp345_ = vala_binary_expression_get_left (self);
	_tmp346_ = _tmp345_;
	_tmp347_ = vala_expression_get_value_type (_tmp346_);
	_tmp348_ = _tmp347_;
	if (_tmp348_ != NULL) {
		ValaExpression* _tmp349_;
		ValaExpression* _tmp350_;
		ValaDataType* _tmp351_;
		ValaDataType* _tmp352_;
		ValaTypeSymbol* _tmp353_;
		ValaTypeSymbol* _tmp354_;
		_tmp349_ = vala_binary_expression_get_left (self);
		_tmp350_ = _tmp349_;
		_tmp351_ = vala_expression_get_value_type (_tmp350_);
		_tmp352_ = _tmp351_;
		_tmp353_ = vala_data_type_get_data_type (_tmp352_);
		_tmp354_ = _tmp353_;
		_tmp344_ = VALA_IS_ENUM (_tmp354_);
	} else {
		_tmp344_ = FALSE;
	}
	if (_tmp344_) {
		gboolean _tmp355_ = FALSE;
		ValaBinaryOperator _tmp356_;
		_tmp356_ = self->priv->_operator;
		if (_tmp356_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp355_ = TRUE;
		} else {
			ValaBinaryOperator _tmp357_;
			_tmp357_ = self->priv->_operator;
			_tmp355_ = _tmp357_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp343_ = _tmp355_;
	} else {
		_tmp343_ = FALSE;
	}
	if (_tmp343_) {
		ValaExpression* _tmp358_;
		ValaExpression* _tmp359_;
		ValaExpression* _tmp360_;
		ValaExpression* _tmp361_;
		ValaDataType* _tmp362_;
		ValaDataType* _tmp363_;
		ValaDataType* _tmp364_;
		ValaDataType* _tmp365_;
		_tmp358_ = vala_binary_expression_get_right (self);
		_tmp359_ = _tmp358_;
		_tmp360_ = vala_binary_expression_get_left (self);
		_tmp361_ = _tmp360_;
		_tmp362_ = vala_expression_get_value_type (_tmp361_);
		_tmp363_ = _tmp362_;
		_tmp364_ = vala_data_type_copy (_tmp363_);
		_tmp365_ = _tmp364_;
		vala_expression_set_target_type (_tmp359_, _tmp365_);
		_vala_code_node_unref0 (_tmp365_);
	}
	_tmp366_ = vala_binary_expression_get_right (self);
	_tmp367_ = _tmp366_;
	vala_code_node_check ((ValaCodeNode*) _tmp367_, context);
	_tmp370_ = vala_binary_expression_get_right (self);
	_tmp371_ = _tmp370_;
	_tmp372_ = vala_expression_get_value_type (_tmp371_);
	_tmp373_ = _tmp372_;
	if (_tmp373_ != NULL) {
		ValaExpression* _tmp374_;
		ValaExpression* _tmp375_;
		ValaDataType* _tmp376_;
		ValaDataType* _tmp377_;
		ValaTypeSymbol* _tmp378_;
		ValaTypeSymbol* _tmp379_;
		_tmp374_ = vala_binary_expression_get_right (self);
		_tmp375_ = _tmp374_;
		_tmp376_ = vala_expression_get_value_type (_tmp375_);
		_tmp377_ = _tmp376_;
		_tmp378_ = vala_data_type_get_data_type (_tmp377_);
		_tmp379_ = _tmp378_;
		_tmp369_ = VALA_IS_ENUM (_tmp379_);
	} else {
		_tmp369_ = FALSE;
	}
	if (_tmp369_) {
		gboolean _tmp380_ = FALSE;
		ValaBinaryOperator _tmp381_;
		_tmp381_ = self->priv->_operator;
		if (_tmp381_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp380_ = TRUE;
		} else {
			ValaBinaryOperator _tmp382_;
			_tmp382_ = self->priv->_operator;
			_tmp380_ = _tmp382_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp368_ = _tmp380_;
	} else {
		_tmp368_ = FALSE;
	}
	if (_tmp368_) {
		ValaExpression* _tmp383_;
		ValaExpression* _tmp384_;
		ValaExpression* _tmp385_;
		ValaExpression* _tmp386_;
		ValaDataType* _tmp387_;
		ValaDataType* _tmp388_;
		ValaDataType* _tmp389_;
		ValaDataType* _tmp390_;
		_tmp383_ = vala_binary_expression_get_left (self);
		_tmp384_ = _tmp383_;
		_tmp385_ = vala_binary_expression_get_right (self);
		_tmp386_ = _tmp385_;
		_tmp387_ = vala_expression_get_value_type (_tmp386_);
		_tmp388_ = _tmp387_;
		_tmp389_ = vala_data_type_copy (_tmp388_);
		_tmp390_ = _tmp389_;
		vala_expression_set_target_type (_tmp384_, _tmp390_);
		_vala_code_node_unref0 (_tmp390_);
	}
	_tmp392_ = vala_binary_expression_get_left (self);
	_tmp393_ = _tmp392_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp393_, context)) {
		_tmp391_ = TRUE;
	} else {
		ValaExpression* _tmp394_;
		ValaExpression* _tmp395_;
		_tmp394_ = vala_binary_expression_get_right (self);
		_tmp395_ = _tmp394_;
		_tmp391_ = !vala_code_node_check ((ValaCodeNode*) _tmp395_, context);
	}
	if (_tmp391_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp396_ = vala_binary_expression_get_left (self);
	_tmp397_ = _tmp396_;
	_tmp398_ = vala_expression_get_value_type (_tmp397_);
	_tmp399_ = _tmp398_;
	if (_tmp399_ == NULL) {
		ValaExpression* _tmp400_;
		ValaExpression* _tmp401_;
		ValaSourceReference* _tmp402_;
		ValaSourceReference* _tmp403_;
		_tmp400_ = vala_binary_expression_get_left (self);
		_tmp401_ = _tmp400_;
		_tmp402_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp401_);
		_tmp403_ = _tmp402_;
		vala_report_error (_tmp403_, "invalid left operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp405_ = self->priv->_operator;
	if (_tmp405_ != VALA_BINARY_OPERATOR_IN) {
		ValaExpression* _tmp406_;
		ValaExpression* _tmp407_;
		ValaDataType* _tmp408_;
		ValaDataType* _tmp409_;
		_tmp406_ = vala_binary_expression_get_right (self);
		_tmp407_ = _tmp406_;
		_tmp408_ = vala_expression_get_value_type (_tmp407_);
		_tmp409_ = _tmp408_;
		_tmp404_ = _tmp409_ == NULL;
	} else {
		_tmp404_ = FALSE;
	}
	if (_tmp404_) {
		ValaExpression* _tmp410_;
		ValaExpression* _tmp411_;
		ValaSourceReference* _tmp412_;
		ValaSourceReference* _tmp413_;
		_tmp410_ = vala_binary_expression_get_right (self);
		_tmp411_ = _tmp410_;
		_tmp412_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp411_);
		_tmp413_ = _tmp412_;
		vala_report_error (_tmp413_, "invalid right operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp415_ = vala_binary_expression_get_left (self);
	_tmp416_ = _tmp415_;
	_tmp417_ = vala_expression_get_value_type (_tmp416_);
	_tmp418_ = _tmp417_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp418_)) {
		_tmp414_ = TRUE;
	} else {
		ValaExpression* _tmp419_;
		ValaExpression* _tmp420_;
		ValaDataType* _tmp421_;
		ValaDataType* _tmp422_;
		_tmp419_ = vala_binary_expression_get_left (self);
		_tmp420_ = _tmp419_;
		_tmp421_ = vala_expression_get_value_type (_tmp420_);
		_tmp422_ = _tmp421_;
		_tmp414_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp422_);
	}
	if (_tmp414_) {
		ValaExpression* _tmp423_;
		ValaExpression* _tmp424_;
		ValaSourceReference* _tmp425_;
		ValaSourceReference* _tmp426_;
		ValaExpression* _tmp427_;
		ValaExpression* _tmp428_;
		ValaSymbol* _tmp429_;
		ValaSymbol* _tmp430_;
		gchar* _tmp431_;
		gchar* _tmp432_;
		gchar* _tmp433_;
		gchar* _tmp434_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp423_ = vala_binary_expression_get_left (self);
		_tmp424_ = _tmp423_;
		_tmp425_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp424_);
		_tmp426_ = _tmp425_;
		_tmp427_ = vala_binary_expression_get_left (self);
		_tmp428_ = _tmp427_;
		_tmp429_ = vala_expression_get_symbol_reference (_tmp428_);
		_tmp430_ = _tmp429_;
		_tmp431_ = vala_symbol_get_full_name (_tmp430_);
		_tmp432_ = _tmp431_;
		_tmp433_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp432_);
		_tmp434_ = _tmp433_;
		vala_report_error (_tmp426_, _tmp434_);
		_g_free0 (_tmp434_);
		_g_free0 (_tmp432_);
		result = FALSE;
		return result;
	}
	_tmp436_ = vala_binary_expression_get_right (self);
	_tmp437_ = _tmp436_;
	_tmp438_ = vala_expression_get_value_type (_tmp437_);
	_tmp439_ = _tmp438_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp439_)) {
		_tmp435_ = TRUE;
	} else {
		ValaExpression* _tmp440_;
		ValaExpression* _tmp441_;
		ValaDataType* _tmp442_;
		ValaDataType* _tmp443_;
		_tmp440_ = vala_binary_expression_get_right (self);
		_tmp441_ = _tmp440_;
		_tmp442_ = vala_expression_get_value_type (_tmp441_);
		_tmp443_ = _tmp442_;
		_tmp435_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp443_);
	}
	if (_tmp435_) {
		ValaExpression* _tmp444_;
		ValaExpression* _tmp445_;
		ValaSourceReference* _tmp446_;
		ValaSourceReference* _tmp447_;
		ValaExpression* _tmp448_;
		ValaExpression* _tmp449_;
		ValaSymbol* _tmp450_;
		ValaSymbol* _tmp451_;
		gchar* _tmp452_;
		gchar* _tmp453_;
		gchar* _tmp454_;
		gchar* _tmp455_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp444_ = vala_binary_expression_get_right (self);
		_tmp445_ = _tmp444_;
		_tmp446_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp445_);
		_tmp447_ = _tmp446_;
		_tmp448_ = vala_binary_expression_get_right (self);
		_tmp449_ = _tmp448_;
		_tmp450_ = vala_expression_get_symbol_reference (_tmp449_);
		_tmp451_ = _tmp450_;
		_tmp452_ = vala_symbol_get_full_name (_tmp451_);
		_tmp453_ = _tmp452_;
		_tmp454_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp453_);
		_tmp455_ = _tmp454_;
		vala_report_error (_tmp447_, _tmp455_);
		_g_free0 (_tmp455_);
		_g_free0 (_tmp453_);
		result = FALSE;
		return result;
	}
	_tmp456_ = vala_binary_expression_get_left (self);
	_tmp457_ = _tmp456_;
	_tmp458_ = vala_binary_expression_get_left (self);
	_tmp459_ = _tmp458_;
	_tmp460_ = vala_expression_get_value_type (_tmp459_);
	_tmp461_ = _tmp460_;
	_tmp462_ = vala_data_type_copy (_tmp461_);
	_tmp463_ = _tmp462_;
	vala_expression_set_target_type (_tmp457_, _tmp463_);
	_vala_code_node_unref0 (_tmp463_);
	_tmp464_ = vala_binary_expression_get_left (self);
	_tmp465_ = _tmp464_;
	_tmp466_ = vala_expression_get_target_type (_tmp465_);
	_tmp467_ = _tmp466_;
	vala_data_type_set_value_owned (_tmp467_, FALSE);
	_tmp468_ = vala_binary_expression_get_right (self);
	_tmp469_ = _tmp468_;
	_tmp470_ = vala_binary_expression_get_right (self);
	_tmp471_ = _tmp470_;
	_tmp472_ = vala_expression_get_value_type (_tmp471_);
	_tmp473_ = _tmp472_;
	_tmp474_ = vala_data_type_copy (_tmp473_);
	_tmp475_ = _tmp474_;
	vala_expression_set_target_type (_tmp469_, _tmp475_);
	_vala_code_node_unref0 (_tmp475_);
	_tmp476_ = vala_binary_expression_get_right (self);
	_tmp477_ = _tmp476_;
	_tmp478_ = vala_expression_get_target_type (_tmp477_);
	_tmp479_ = _tmp478_;
	vala_data_type_set_value_owned (_tmp479_, FALSE);
	_tmp481_ = vala_binary_expression_get_left (self);
	_tmp482_ = _tmp481_;
	_tmp483_ = vala_expression_get_value_type (_tmp482_);
	_tmp484_ = _tmp483_;
	_tmp485_ = vala_data_type_get_data_type (_tmp484_);
	_tmp486_ = _tmp485_;
	_tmp487_ = vala_code_context_get_analyzer (context);
	_tmp488_ = _tmp487_;
	_tmp489_ = _tmp488_->string_type;
	_tmp490_ = vala_data_type_get_data_type (_tmp489_);
	_tmp491_ = _tmp490_;
	if (_tmp486_ == _tmp491_) {
		ValaBinaryOperator _tmp492_;
		_tmp492_ = self->priv->_operator;
		_tmp480_ = _tmp492_ == VALA_BINARY_OPERATOR_PLUS;
	} else {
		_tmp480_ = FALSE;
	}
	if (_tmp480_) {
		gboolean _tmp493_ = FALSE;
		ValaExpression* _tmp494_;
		ValaExpression* _tmp495_;
		ValaDataType* _tmp496_;
		ValaDataType* _tmp497_;
		ValaSemanticAnalyzer* _tmp511_;
		ValaSemanticAnalyzer* _tmp512_;
		ValaDataType* _tmp513_;
		ValaDataType* _tmp514_;
		ValaDataType* _tmp515_;
		gboolean _tmp516_ = FALSE;
		ValaExpression* _tmp517_;
		ValaExpression* _tmp518_;
		_tmp494_ = vala_binary_expression_get_right (self);
		_tmp495_ = _tmp494_;
		_tmp496_ = vala_expression_get_value_type (_tmp495_);
		_tmp497_ = _tmp496_;
		if (_tmp497_ == NULL) {
			_tmp493_ = TRUE;
		} else {
			ValaExpression* _tmp498_;
			ValaExpression* _tmp499_;
			ValaDataType* _tmp500_;
			ValaDataType* _tmp501_;
			ValaTypeSymbol* _tmp502_;
			ValaTypeSymbol* _tmp503_;
			ValaSemanticAnalyzer* _tmp504_;
			ValaSemanticAnalyzer* _tmp505_;
			ValaDataType* _tmp506_;
			ValaTypeSymbol* _tmp507_;
			ValaTypeSymbol* _tmp508_;
			_tmp498_ = vala_binary_expression_get_right (self);
			_tmp499_ = _tmp498_;
			_tmp500_ = vala_expression_get_value_type (_tmp499_);
			_tmp501_ = _tmp500_;
			_tmp502_ = vala_data_type_get_data_type (_tmp501_);
			_tmp503_ = _tmp502_;
			_tmp504_ = vala_code_context_get_analyzer (context);
			_tmp505_ = _tmp504_;
			_tmp506_ = _tmp505_->string_type;
			_tmp507_ = vala_data_type_get_data_type (_tmp506_);
			_tmp508_ = _tmp507_;
			_tmp493_ = _tmp503_ != _tmp508_;
		}
		if (_tmp493_) {
			ValaSourceReference* _tmp509_;
			ValaSourceReference* _tmp510_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp509_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp510_ = _tmp509_;
			vala_report_error (_tmp510_, "Operands must be strings");
			result = FALSE;
			return result;
		}
		_tmp511_ = vala_code_context_get_analyzer (context);
		_tmp512_ = _tmp511_;
		_tmp513_ = _tmp512_->string_type;
		_tmp514_ = vala_data_type_copy (_tmp513_);
		_tmp515_ = _tmp514_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp515_);
		_vala_code_node_unref0 (_tmp515_);
		_tmp517_ = vala_binary_expression_get_left (self);
		_tmp518_ = _tmp517_;
		if (vala_expression_is_constant (_tmp518_)) {
			ValaExpression* _tmp519_;
			ValaExpression* _tmp520_;
			_tmp519_ = vala_binary_expression_get_right (self);
			_tmp520_ = _tmp519_;
			_tmp516_ = vala_expression_is_constant (_tmp520_);
		} else {
			_tmp516_ = FALSE;
		}
		if (_tmp516_) {
			ValaDataType* _tmp521_;
			ValaDataType* _tmp522_;
			_tmp521_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp522_ = _tmp521_;
			vala_data_type_set_value_owned (_tmp522_, FALSE);
		} else {
			ValaDataType* _tmp523_;
			ValaDataType* _tmp524_;
			_tmp523_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp524_ = _tmp523_;
			vala_data_type_set_value_owned (_tmp524_, TRUE);
		}
	} else {
		gboolean _tmp525_ = FALSE;
		ValaExpression* _tmp526_;
		ValaExpression* _tmp527_;
		ValaDataType* _tmp528_;
		ValaDataType* _tmp529_;
		_tmp526_ = vala_binary_expression_get_left (self);
		_tmp527_ = _tmp526_;
		_tmp528_ = vala_expression_get_value_type (_tmp527_);
		_tmp529_ = _tmp528_;
		if (VALA_IS_ARRAY_TYPE (_tmp529_)) {
			ValaBinaryOperator _tmp530_;
			_tmp530_ = self->priv->_operator;
			_tmp525_ = _tmp530_ == VALA_BINARY_OPERATOR_PLUS;
		} else {
			_tmp525_ = FALSE;
		}
		if (_tmp525_) {
			ValaArrayType* array_type = NULL;
			ValaExpression* _tmp531_;
			ValaExpression* _tmp532_;
			ValaDataType* _tmp533_;
			ValaDataType* _tmp534_;
			ValaArrayType* _tmp535_;
			gboolean _tmp536_ = FALSE;
			ValaExpression* _tmp537_;
			ValaExpression* _tmp538_;
			ValaDataType* _tmp539_;
			ValaDataType* _tmp540_;
			ValaExpression* _tmp550_;
			ValaExpression* _tmp551_;
			ValaArrayType* _tmp552_;
			ValaDataType* _tmp553_;
			ValaDataType* _tmp554_;
			ValaDataType* _tmp555_;
			ValaDataType* _tmp556_;
			ValaArrayType* _tmp557_;
			ValaDataType* _tmp558_;
			ValaDataType* _tmp559_;
			ValaDataType* _tmp560_;
			ValaDataType* _tmp561_;
			_tmp531_ = vala_binary_expression_get_left (self);
			_tmp532_ = _tmp531_;
			_tmp533_ = vala_expression_get_value_type (_tmp532_);
			_tmp534_ = _tmp533_;
			_tmp535_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp534_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			array_type = _tmp535_;
			_tmp537_ = vala_binary_expression_get_right (self);
			_tmp538_ = _tmp537_;
			_tmp539_ = vala_expression_get_value_type (_tmp538_);
			_tmp540_ = _tmp539_;
			if (_tmp540_ == NULL) {
				_tmp536_ = TRUE;
			} else {
				ValaExpression* _tmp541_;
				ValaExpression* _tmp542_;
				ValaDataType* _tmp543_;
				ValaDataType* _tmp544_;
				ValaArrayType* _tmp545_;
				ValaDataType* _tmp546_;
				ValaDataType* _tmp547_;
				_tmp541_ = vala_binary_expression_get_right (self);
				_tmp542_ = _tmp541_;
				_tmp543_ = vala_expression_get_value_type (_tmp542_);
				_tmp544_ = _tmp543_;
				_tmp545_ = array_type;
				_tmp546_ = vala_array_type_get_element_type (_tmp545_);
				_tmp547_ = _tmp546_;
				_tmp536_ = !vala_data_type_compatible (_tmp544_, _tmp547_);
			}
			if (_tmp536_) {
				ValaSourceReference* _tmp548_;
				ValaSourceReference* _tmp549_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp548_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp549_ = _tmp548_;
				vala_report_error (_tmp549_, "Incompatible operand");
				result = FALSE;
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_tmp550_ = vala_binary_expression_get_right (self);
			_tmp551_ = _tmp550_;
			_tmp552_ = array_type;
			_tmp553_ = vala_array_type_get_element_type (_tmp552_);
			_tmp554_ = _tmp553_;
			_tmp555_ = vala_data_type_copy (_tmp554_);
			_tmp556_ = _tmp555_;
			vala_expression_set_target_type (_tmp551_, _tmp556_);
			_vala_code_node_unref0 (_tmp556_);
			_tmp557_ = array_type;
			_tmp558_ = vala_data_type_copy ((ValaDataType*) _tmp557_);
			_tmp559_ = _tmp558_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp559_);
			_vala_code_node_unref0 (_tmp559_);
			_tmp560_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp561_ = _tmp560_;
			vala_data_type_set_value_owned (_tmp561_, TRUE);
			_vala_code_node_unref0 (array_type);
		} else {
			gboolean _tmp562_ = FALSE;
			gboolean _tmp563_ = FALSE;
			gboolean _tmp564_ = FALSE;
			ValaBinaryOperator _tmp565_;
			_tmp565_ = self->priv->_operator;
			if (_tmp565_ == VALA_BINARY_OPERATOR_PLUS) {
				_tmp564_ = TRUE;
			} else {
				ValaBinaryOperator _tmp566_;
				_tmp566_ = self->priv->_operator;
				_tmp564_ = _tmp566_ == VALA_BINARY_OPERATOR_MINUS;
			}
			if (_tmp564_) {
				_tmp563_ = TRUE;
			} else {
				ValaBinaryOperator _tmp567_;
				_tmp567_ = self->priv->_operator;
				_tmp563_ = _tmp567_ == VALA_BINARY_OPERATOR_MUL;
			}
			if (_tmp563_) {
				_tmp562_ = TRUE;
			} else {
				ValaBinaryOperator _tmp568_;
				_tmp568_ = self->priv->_operator;
				_tmp562_ = _tmp568_ == VALA_BINARY_OPERATOR_DIV;
			}
			if (_tmp562_) {
				ValaExpression* _tmp569_;
				ValaExpression* _tmp570_;
				ValaDataType* _tmp571_;
				ValaDataType* _tmp572_;
				ValaDataType* _tmp617_;
				ValaDataType* _tmp618_;
				ValaDataType* _tmp631_;
				ValaDataType* _tmp632_;
				_tmp569_ = vala_binary_expression_get_left (self);
				_tmp570_ = _tmp569_;
				_tmp571_ = vala_expression_get_value_type (_tmp570_);
				_tmp572_ = _tmp571_;
				if (VALA_IS_POINTER_TYPE (_tmp572_)) {
					ValaPointerType* pointer_type = NULL;
					ValaExpression* _tmp573_;
					ValaExpression* _tmp574_;
					ValaDataType* _tmp575_;
					ValaDataType* _tmp576_;
					ValaPointerType* _tmp577_;
					ValaPointerType* _tmp578_;
					ValaDataType* _tmp579_;
					ValaDataType* _tmp580_;
					ValaStruct* offset_type = NULL;
					ValaExpression* _tmp583_;
					ValaExpression* _tmp584_;
					ValaDataType* _tmp585_;
					ValaDataType* _tmp586_;
					ValaTypeSymbol* _tmp587_;
					ValaTypeSymbol* _tmp588_;
					ValaStruct* _tmp589_;
					gboolean _tmp590_ = FALSE;
					ValaStruct* _tmp591_;
					_tmp573_ = vala_binary_expression_get_left (self);
					_tmp574_ = _tmp573_;
					_tmp575_ = vala_expression_get_value_type (_tmp574_);
					_tmp576_ = _tmp575_;
					_tmp577_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp576_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
					pointer_type = _tmp577_;
					_tmp578_ = pointer_type;
					_tmp579_ = vala_pointer_type_get_base_type (_tmp578_);
					_tmp580_ = _tmp579_;
					if (VALA_IS_VOID_TYPE (_tmp580_)) {
						ValaSourceReference* _tmp581_;
						ValaSourceReference* _tmp582_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp581_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp582_ = _tmp581_;
						vala_report_error (_tmp582_, "Pointer arithmetic not supported for `void*'");
						result = FALSE;
						_vala_code_node_unref0 (pointer_type);
						return result;
					}
					_tmp583_ = vala_binary_expression_get_right (self);
					_tmp584_ = _tmp583_;
					_tmp585_ = vala_expression_get_value_type (_tmp584_);
					_tmp586_ = _tmp585_;
					_tmp587_ = vala_data_type_get_data_type (_tmp586_);
					_tmp588_ = _tmp587_;
					_tmp589_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp588_) ? ((ValaStruct*) _tmp588_) : NULL);
					offset_type = _tmp589_;
					_tmp591_ = offset_type;
					if (_tmp591_ != NULL) {
						ValaStruct* _tmp592_;
						_tmp592_ = offset_type;
						_tmp590_ = vala_struct_is_integer_type (_tmp592_);
					} else {
						_tmp590_ = FALSE;
					}
					if (_tmp590_) {
						gboolean _tmp593_ = FALSE;
						ValaBinaryOperator _tmp594_;
						_tmp594_ = self->priv->_operator;
						if (_tmp594_ == VALA_BINARY_OPERATOR_PLUS) {
							_tmp593_ = TRUE;
						} else {
							ValaBinaryOperator _tmp595_;
							_tmp595_ = self->priv->_operator;
							_tmp593_ = _tmp595_ == VALA_BINARY_OPERATOR_MINUS;
						}
						if (_tmp593_) {
							ValaExpression* _tmp596_;
							ValaExpression* _tmp597_;
							ValaDataType* _tmp598_;
							ValaDataType* _tmp599_;
							ValaDataType* _tmp600_;
							ValaDataType* _tmp601_;
							_tmp596_ = vala_binary_expression_get_left (self);
							_tmp597_ = _tmp596_;
							_tmp598_ = vala_expression_get_value_type (_tmp597_);
							_tmp599_ = _tmp598_;
							_tmp600_ = vala_data_type_copy (_tmp599_);
							_tmp601_ = _tmp600_;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp601_);
							_vala_code_node_unref0 (_tmp601_);
						}
					} else {
						ValaExpression* _tmp602_;
						ValaExpression* _tmp603_;
						ValaDataType* _tmp604_;
						ValaDataType* _tmp605_;
						_tmp602_ = vala_binary_expression_get_right (self);
						_tmp603_ = _tmp602_;
						_tmp604_ = vala_expression_get_value_type (_tmp603_);
						_tmp605_ = _tmp604_;
						if (VALA_IS_POINTER_TYPE (_tmp605_)) {
							ValaSemanticAnalyzer* _tmp606_;
							ValaSemanticAnalyzer* _tmp607_;
							ValaDataType* _tmp608_;
							_tmp606_ = vala_code_context_get_analyzer (context);
							_tmp607_ = _tmp606_;
							_tmp608_ = _tmp607_->size_t_type;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp608_);
						}
					}
					_vala_code_node_unref0 (offset_type);
					_vala_code_node_unref0 (pointer_type);
				} else {
					ValaExpression* _tmp609_;
					ValaExpression* _tmp610_;
					ValaDataType* _tmp611_;
					ValaDataType* _tmp612_;
					ValaExpression* _tmp613_;
					ValaExpression* _tmp614_;
					ValaDataType* _tmp615_;
					ValaDataType* _tmp616_;
					_tmp609_ = vala_binary_expression_get_left (self);
					_tmp610_ = _tmp609_;
					_tmp611_ = vala_expression_get_target_type (_tmp610_);
					_tmp612_ = _tmp611_;
					vala_data_type_set_nullable (_tmp612_, FALSE);
					_tmp613_ = vala_binary_expression_get_right (self);
					_tmp614_ = _tmp613_;
					_tmp615_ = vala_expression_get_target_type (_tmp614_);
					_tmp616_ = _tmp615_;
					vala_data_type_set_nullable (_tmp616_, FALSE);
				}
				_tmp617_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp618_ = _tmp617_;
				if (_tmp618_ == NULL) {
					ValaSemanticAnalyzer* _tmp619_;
					ValaSemanticAnalyzer* _tmp620_;
					ValaExpression* _tmp621_;
					ValaExpression* _tmp622_;
					ValaDataType* _tmp623_;
					ValaDataType* _tmp624_;
					ValaExpression* _tmp625_;
					ValaExpression* _tmp626_;
					ValaDataType* _tmp627_;
					ValaDataType* _tmp628_;
					ValaDataType* _tmp629_;
					ValaDataType* _tmp630_;
					_tmp619_ = vala_code_context_get_analyzer (context);
					_tmp620_ = _tmp619_;
					_tmp621_ = vala_binary_expression_get_left (self);
					_tmp622_ = _tmp621_;
					_tmp623_ = vala_expression_get_target_type (_tmp622_);
					_tmp624_ = _tmp623_;
					_tmp625_ = vala_binary_expression_get_right (self);
					_tmp626_ = _tmp625_;
					_tmp627_ = vala_expression_get_target_type (_tmp626_);
					_tmp628_ = _tmp627_;
					_tmp629_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp620_, _tmp624_, _tmp628_);
					_tmp630_ = _tmp629_;
					vala_expression_set_value_type ((ValaExpression*) self, _tmp630_);
					_vala_code_node_unref0 (_tmp630_);
				}
				_tmp631_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp632_ = _tmp631_;
				if (_tmp632_ == NULL) {
					ValaSourceReference* _tmp633_;
					ValaSourceReference* _tmp634_;
					ValaExpression* _tmp635_;
					ValaExpression* _tmp636_;
					ValaDataType* _tmp637_;
					ValaDataType* _tmp638_;
					gchar* _tmp639_;
					gchar* _tmp640_;
					ValaExpression* _tmp641_;
					ValaExpression* _tmp642_;
					ValaDataType* _tmp643_;
					ValaDataType* _tmp644_;
					gchar* _tmp645_;
					gchar* _tmp646_;
					gchar* _tmp647_;
					gchar* _tmp648_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp633_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp634_ = _tmp633_;
					_tmp635_ = vala_binary_expression_get_left (self);
					_tmp636_ = _tmp635_;
					_tmp637_ = vala_expression_get_value_type (_tmp636_);
					_tmp638_ = _tmp637_;
					_tmp639_ = vala_code_node_to_string ((ValaCodeNode*) _tmp638_);
					_tmp640_ = _tmp639_;
					_tmp641_ = vala_binary_expression_get_right (self);
					_tmp642_ = _tmp641_;
					_tmp643_ = vala_expression_get_value_type (_tmp642_);
					_tmp644_ = _tmp643_;
					_tmp645_ = vala_code_node_to_string ((ValaCodeNode*) _tmp644_);
					_tmp646_ = _tmp645_;
					_tmp647_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp640_, _tmp646_);
					_tmp648_ = _tmp647_;
					vala_report_error (_tmp634_, _tmp648_);
					_g_free0 (_tmp648_);
					_g_free0 (_tmp646_);
					_g_free0 (_tmp640_);
					result = FALSE;
					return result;
				}
			} else {
				gboolean _tmp649_ = FALSE;
				gboolean _tmp650_ = FALSE;
				ValaBinaryOperator _tmp651_;
				_tmp651_ = self->priv->_operator;
				if (_tmp651_ == VALA_BINARY_OPERATOR_MOD) {
					_tmp650_ = TRUE;
				} else {
					ValaBinaryOperator _tmp652_;
					_tmp652_ = self->priv->_operator;
					_tmp650_ = _tmp652_ == VALA_BINARY_OPERATOR_SHIFT_LEFT;
				}
				if (_tmp650_) {
					_tmp649_ = TRUE;
				} else {
					ValaBinaryOperator _tmp653_;
					_tmp653_ = self->priv->_operator;
					_tmp649_ = _tmp653_ == VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				}
				if (_tmp649_) {
					ValaExpression* _tmp654_;
					ValaExpression* _tmp655_;
					ValaDataType* _tmp656_;
					ValaDataType* _tmp657_;
					ValaExpression* _tmp658_;
					ValaExpression* _tmp659_;
					ValaDataType* _tmp660_;
					ValaDataType* _tmp661_;
					ValaSemanticAnalyzer* _tmp662_;
					ValaSemanticAnalyzer* _tmp663_;
					ValaExpression* _tmp664_;
					ValaExpression* _tmp665_;
					ValaDataType* _tmp666_;
					ValaDataType* _tmp667_;
					ValaExpression* _tmp668_;
					ValaExpression* _tmp669_;
					ValaDataType* _tmp670_;
					ValaDataType* _tmp671_;
					ValaDataType* _tmp672_;
					ValaDataType* _tmp673_;
					ValaDataType* _tmp674_;
					ValaDataType* _tmp675_;
					_tmp654_ = vala_binary_expression_get_left (self);
					_tmp655_ = _tmp654_;
					_tmp656_ = vala_expression_get_target_type (_tmp655_);
					_tmp657_ = _tmp656_;
					vala_data_type_set_nullable (_tmp657_, FALSE);
					_tmp658_ = vala_binary_expression_get_right (self);
					_tmp659_ = _tmp658_;
					_tmp660_ = vala_expression_get_target_type (_tmp659_);
					_tmp661_ = _tmp660_;
					vala_data_type_set_nullable (_tmp661_, FALSE);
					_tmp662_ = vala_code_context_get_analyzer (context);
					_tmp663_ = _tmp662_;
					_tmp664_ = vala_binary_expression_get_left (self);
					_tmp665_ = _tmp664_;
					_tmp666_ = vala_expression_get_target_type (_tmp665_);
					_tmp667_ = _tmp666_;
					_tmp668_ = vala_binary_expression_get_right (self);
					_tmp669_ = _tmp668_;
					_tmp670_ = vala_expression_get_target_type (_tmp669_);
					_tmp671_ = _tmp670_;
					_tmp672_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp663_, _tmp667_, _tmp671_);
					_tmp673_ = _tmp672_;
					vala_expression_set_value_type ((ValaExpression*) self, _tmp673_);
					_vala_code_node_unref0 (_tmp673_);
					_tmp674_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp675_ = _tmp674_;
					if (_tmp675_ == NULL) {
						ValaSourceReference* _tmp676_;
						ValaSourceReference* _tmp677_;
						ValaExpression* _tmp678_;
						ValaExpression* _tmp679_;
						ValaDataType* _tmp680_;
						ValaDataType* _tmp681_;
						gchar* _tmp682_;
						gchar* _tmp683_;
						ValaExpression* _tmp684_;
						ValaExpression* _tmp685_;
						ValaDataType* _tmp686_;
						ValaDataType* _tmp687_;
						gchar* _tmp688_;
						gchar* _tmp689_;
						gchar* _tmp690_;
						gchar* _tmp691_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp676_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp677_ = _tmp676_;
						_tmp678_ = vala_binary_expression_get_left (self);
						_tmp679_ = _tmp678_;
						_tmp680_ = vala_expression_get_value_type (_tmp679_);
						_tmp681_ = _tmp680_;
						_tmp682_ = vala_code_node_to_string ((ValaCodeNode*) _tmp681_);
						_tmp683_ = _tmp682_;
						_tmp684_ = vala_binary_expression_get_right (self);
						_tmp685_ = _tmp684_;
						_tmp686_ = vala_expression_get_value_type (_tmp685_);
						_tmp687_ = _tmp686_;
						_tmp688_ = vala_code_node_to_string ((ValaCodeNode*) _tmp687_);
						_tmp689_ = _tmp688_;
						_tmp690_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp683_, _tmp689_);
						_tmp691_ = _tmp690_;
						vala_report_error (_tmp677_, _tmp691_);
						_g_free0 (_tmp691_);
						_g_free0 (_tmp689_);
						_g_free0 (_tmp683_);
						result = FALSE;
						return result;
					}
				} else {
					gboolean _tmp692_ = FALSE;
					gboolean _tmp693_ = FALSE;
					gboolean _tmp694_ = FALSE;
					ValaBinaryOperator _tmp695_;
					_tmp695_ = self->priv->_operator;
					if (_tmp695_ == VALA_BINARY_OPERATOR_LESS_THAN) {
						_tmp694_ = TRUE;
					} else {
						ValaBinaryOperator _tmp696_;
						_tmp696_ = self->priv->_operator;
						_tmp694_ = _tmp696_ == VALA_BINARY_OPERATOR_GREATER_THAN;
					}
					if (_tmp694_) {
						_tmp693_ = TRUE;
					} else {
						ValaBinaryOperator _tmp697_;
						_tmp697_ = self->priv->_operator;
						_tmp693_ = _tmp697_ == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
					}
					if (_tmp693_) {
						_tmp692_ = TRUE;
					} else {
						ValaBinaryOperator _tmp698_;
						_tmp698_ = self->priv->_operator;
						_tmp692_ = _tmp698_ == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
					}
					if (_tmp692_) {
						gboolean _tmp699_ = FALSE;
						ValaExpression* _tmp700_;
						ValaExpression* _tmp701_;
						ValaDataType* _tmp702_;
						ValaDataType* _tmp703_;
						ValaSemanticAnalyzer* _tmp704_;
						ValaSemanticAnalyzer* _tmp705_;
						ValaDataType* _tmp706_;
						ValaSemanticAnalyzer* _tmp786_;
						ValaSemanticAnalyzer* _tmp787_;
						ValaDataType* _tmp788_;
						_tmp700_ = vala_binary_expression_get_left (self);
						_tmp701_ = _tmp700_;
						_tmp702_ = vala_expression_get_value_type (_tmp701_);
						_tmp703_ = _tmp702_;
						_tmp704_ = vala_code_context_get_analyzer (context);
						_tmp705_ = _tmp704_;
						_tmp706_ = _tmp705_->string_type;
						if (vala_data_type_compatible (_tmp703_, _tmp706_)) {
							ValaExpression* _tmp707_;
							ValaExpression* _tmp708_;
							ValaDataType* _tmp709_;
							ValaDataType* _tmp710_;
							ValaSemanticAnalyzer* _tmp711_;
							ValaSemanticAnalyzer* _tmp712_;
							ValaDataType* _tmp713_;
							_tmp707_ = vala_binary_expression_get_right (self);
							_tmp708_ = _tmp707_;
							_tmp709_ = vala_expression_get_value_type (_tmp708_);
							_tmp710_ = _tmp709_;
							_tmp711_ = vala_code_context_get_analyzer (context);
							_tmp712_ = _tmp711_;
							_tmp713_ = _tmp712_->string_type;
							_tmp699_ = vala_data_type_compatible (_tmp710_, _tmp713_);
						} else {
							_tmp699_ = FALSE;
						}
						if (_tmp699_) {
						} else {
							gboolean _tmp714_ = FALSE;
							ValaExpression* _tmp715_;
							ValaExpression* _tmp716_;
							ValaDataType* _tmp717_;
							ValaDataType* _tmp718_;
							_tmp715_ = vala_binary_expression_get_left (self);
							_tmp716_ = _tmp715_;
							_tmp717_ = vala_expression_get_value_type (_tmp716_);
							_tmp718_ = _tmp717_;
							if (VALA_IS_POINTER_TYPE (_tmp718_)) {
								ValaExpression* _tmp719_;
								ValaExpression* _tmp720_;
								ValaDataType* _tmp721_;
								ValaDataType* _tmp722_;
								_tmp719_ = vala_binary_expression_get_right (self);
								_tmp720_ = _tmp719_;
								_tmp721_ = vala_expression_get_value_type (_tmp720_);
								_tmp722_ = _tmp721_;
								_tmp714_ = VALA_IS_POINTER_TYPE (_tmp722_);
							} else {
								_tmp714_ = FALSE;
							}
							if (_tmp714_) {
							} else {
								ValaDataType* resulting_type = NULL;
								gboolean _tmp723_;
								ValaDataType* _tmp750_;
								gboolean _tmp767_;
								ValaExpression* _tmp773_;
								ValaExpression* _tmp774_;
								ValaDataType* _tmp775_;
								ValaDataType* _tmp776_;
								ValaDataType* _tmp777_;
								ValaExpression* _tmp778_;
								ValaExpression* _tmp779_;
								ValaDataType* _tmp780_;
								ValaDataType* _tmp781_;
								ValaExpression* _tmp782_;
								ValaExpression* _tmp783_;
								ValaDataType* _tmp784_;
								ValaDataType* _tmp785_;
								_tmp723_ = self->priv->_is_chained;
								if (_tmp723_) {
									ValaBinaryExpression* lbe = NULL;
									ValaExpression* _tmp724_;
									ValaExpression* _tmp725_;
									ValaBinaryExpression* _tmp726_;
									ValaSemanticAnalyzer* _tmp727_;
									ValaSemanticAnalyzer* _tmp728_;
									ValaBinaryExpression* _tmp729_;
									ValaExpression* _tmp730_;
									ValaExpression* _tmp731_;
									ValaDataType* _tmp732_;
									ValaDataType* _tmp733_;
									ValaExpression* _tmp734_;
									ValaExpression* _tmp735_;
									ValaDataType* _tmp736_;
									ValaDataType* _tmp737_;
									ValaDataType* _tmp738_;
									_tmp724_ = vala_binary_expression_get_left (self);
									_tmp725_ = _tmp724_;
									_tmp726_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp725_, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression));
									lbe = _tmp726_;
									_tmp727_ = vala_code_context_get_analyzer (context);
									_tmp728_ = _tmp727_;
									_tmp729_ = lbe;
									_tmp730_ = vala_binary_expression_get_right (_tmp729_);
									_tmp731_ = _tmp730_;
									_tmp732_ = vala_expression_get_target_type (_tmp731_);
									_tmp733_ = _tmp732_;
									_tmp734_ = vala_binary_expression_get_right (self);
									_tmp735_ = _tmp734_;
									_tmp736_ = vala_expression_get_target_type (_tmp735_);
									_tmp737_ = _tmp736_;
									_tmp738_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp728_, _tmp733_, _tmp737_);
									_vala_code_node_unref0 (resulting_type);
									resulting_type = _tmp738_;
									_vala_code_node_unref0 (lbe);
								} else {
									ValaSemanticAnalyzer* _tmp739_;
									ValaSemanticAnalyzer* _tmp740_;
									ValaExpression* _tmp741_;
									ValaExpression* _tmp742_;
									ValaDataType* _tmp743_;
									ValaDataType* _tmp744_;
									ValaExpression* _tmp745_;
									ValaExpression* _tmp746_;
									ValaDataType* _tmp747_;
									ValaDataType* _tmp748_;
									ValaDataType* _tmp749_;
									_tmp739_ = vala_code_context_get_analyzer (context);
									_tmp740_ = _tmp739_;
									_tmp741_ = vala_binary_expression_get_left (self);
									_tmp742_ = _tmp741_;
									_tmp743_ = vala_expression_get_target_type (_tmp742_);
									_tmp744_ = _tmp743_;
									_tmp745_ = vala_binary_expression_get_right (self);
									_tmp746_ = _tmp745_;
									_tmp747_ = vala_expression_get_target_type (_tmp746_);
									_tmp748_ = _tmp747_;
									_tmp749_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp740_, _tmp744_, _tmp748_);
									_vala_code_node_unref0 (resulting_type);
									resulting_type = _tmp749_;
								}
								_tmp750_ = resulting_type;
								if (_tmp750_ == NULL) {
									ValaSourceReference* _tmp751_;
									ValaSourceReference* _tmp752_;
									ValaExpression* _tmp753_;
									ValaExpression* _tmp754_;
									ValaDataType* _tmp755_;
									ValaDataType* _tmp756_;
									gchar* _tmp757_;
									gchar* _tmp758_;
									ValaExpression* _tmp759_;
									ValaExpression* _tmp760_;
									ValaDataType* _tmp761_;
									ValaDataType* _tmp762_;
									gchar* _tmp763_;
									gchar* _tmp764_;
									gchar* _tmp765_;
									gchar* _tmp766_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp751_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp752_ = _tmp751_;
									_tmp753_ = vala_binary_expression_get_left (self);
									_tmp754_ = _tmp753_;
									_tmp755_ = vala_expression_get_value_type (_tmp754_);
									_tmp756_ = _tmp755_;
									_tmp757_ = vala_code_node_to_string ((ValaCodeNode*) _tmp756_);
									_tmp758_ = _tmp757_;
									_tmp759_ = vala_binary_expression_get_right (self);
									_tmp760_ = _tmp759_;
									_tmp761_ = vala_expression_get_value_type (_tmp760_);
									_tmp762_ = _tmp761_;
									_tmp763_ = vala_code_node_to_string ((ValaCodeNode*) _tmp762_);
									_tmp764_ = _tmp763_;
									_tmp765_ = g_strdup_printf ("Relational operation not supported for types `%s' and `%s'", _tmp758_, _tmp764_);
									_tmp766_ = _tmp765_;
									vala_report_error (_tmp752_, _tmp766_);
									_g_free0 (_tmp766_);
									_g_free0 (_tmp764_);
									_g_free0 (_tmp758_);
									result = FALSE;
									_vala_code_node_unref0 (resulting_type);
									return result;
								}
								_tmp767_ = self->priv->_is_chained;
								if (!_tmp767_) {
									ValaExpression* _tmp768_;
									ValaExpression* _tmp769_;
									ValaDataType* _tmp770_;
									ValaDataType* _tmp771_;
									ValaDataType* _tmp772_;
									_tmp768_ = vala_binary_expression_get_left (self);
									_tmp769_ = _tmp768_;
									_tmp770_ = resulting_type;
									_tmp771_ = vala_data_type_copy (_tmp770_);
									_tmp772_ = _tmp771_;
									vala_expression_set_target_type (_tmp769_, _tmp772_);
									_vala_code_node_unref0 (_tmp772_);
								}
								_tmp773_ = vala_binary_expression_get_right (self);
								_tmp774_ = _tmp773_;
								_tmp775_ = resulting_type;
								_tmp776_ = vala_data_type_copy (_tmp775_);
								_tmp777_ = _tmp776_;
								vala_expression_set_target_type (_tmp774_, _tmp777_);
								_vala_code_node_unref0 (_tmp777_);
								_tmp778_ = vala_binary_expression_get_left (self);
								_tmp779_ = _tmp778_;
								_tmp780_ = vala_expression_get_target_type (_tmp779_);
								_tmp781_ = _tmp780_;
								vala_data_type_set_nullable (_tmp781_, FALSE);
								_tmp782_ = vala_binary_expression_get_right (self);
								_tmp783_ = _tmp782_;
								_tmp784_ = vala_expression_get_target_type (_tmp783_);
								_tmp785_ = _tmp784_;
								vala_data_type_set_nullable (_tmp785_, FALSE);
								_vala_code_node_unref0 (resulting_type);
							}
						}
						_tmp786_ = vala_code_context_get_analyzer (context);
						_tmp787_ = _tmp786_;
						_tmp788_ = _tmp787_->bool_type;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp788_);
					} else {
						gboolean _tmp789_ = FALSE;
						ValaBinaryOperator _tmp790_;
						_tmp790_ = self->priv->_operator;
						if (_tmp790_ == VALA_BINARY_OPERATOR_EQUALITY) {
							_tmp789_ = TRUE;
						} else {
							ValaBinaryOperator _tmp791_;
							_tmp791_ = self->priv->_operator;
							_tmp789_ = _tmp791_ == VALA_BINARY_OPERATOR_INEQUALITY;
						}
						if (_tmp789_) {
							ValaProfile _tmp792_;
							ValaProfile _tmp793_;
							gboolean _tmp862_ = FALSE;
							ValaExpression* _tmp863_;
							ValaExpression* _tmp864_;
							ValaDataType* _tmp865_;
							ValaDataType* _tmp866_;
							ValaExpression* _tmp867_;
							ValaExpression* _tmp868_;
							ValaDataType* _tmp869_;
							ValaDataType* _tmp870_;
							ValaDataType* resulting_type = NULL;
							ValaSemanticAnalyzer* _tmp895_;
							ValaSemanticAnalyzer* _tmp896_;
							ValaExpression* _tmp897_;
							ValaExpression* _tmp898_;
							ValaDataType* _tmp899_;
							ValaDataType* _tmp900_;
							ValaExpression* _tmp901_;
							ValaExpression* _tmp902_;
							ValaDataType* _tmp903_;
							ValaDataType* _tmp904_;
							ValaDataType* _tmp905_;
							ValaDataType* _tmp906_;
							ValaExpression* _tmp917_;
							ValaExpression* _tmp918_;
							ValaDataType* _tmp919_;
							ValaDataType* _tmp920_;
							ValaExpression* _tmp921_;
							ValaExpression* _tmp922_;
							ValaDataType* _tmp923_;
							ValaDataType* _tmp924_;
							ValaExpression* _tmp925_;
							ValaExpression* _tmp926_;
							ValaDataType* _tmp927_;
							ValaDataType* _tmp928_;
							gboolean _tmp929_;
							gboolean _tmp930_;
							ValaExpression* _tmp931_;
							ValaExpression* _tmp932_;
							ValaDataType* _tmp933_;
							ValaDataType* _tmp934_;
							gboolean _tmp935_;
							gboolean _tmp936_;
							ValaSemanticAnalyzer* _tmp945_;
							ValaSemanticAnalyzer* _tmp946_;
							ValaDataType* _tmp947_;
							_tmp792_ = vala_code_context_get_profile (context);
							_tmp793_ = _tmp792_;
							if (_tmp793_ == VALA_PROFILE_GOBJECT) {
								ValaTypeSymbol* gvalue_type = NULL;
								ValaSemanticAnalyzer* _tmp794_;
								ValaSemanticAnalyzer* _tmp795_;
								ValaStructValueType* _tmp796_;
								ValaTypeSymbol* _tmp797_;
								ValaTypeSymbol* _tmp798_;
								ValaTypeSymbol* _tmp799_;
								gboolean _tmp800_ = FALSE;
								gboolean _tmp801_ = FALSE;
								ValaExpression* _tmp802_;
								ValaExpression* _tmp803_;
								ValaDataType* _tmp804_;
								ValaDataType* _tmp805_;
								ValaTypeSymbol* _tmp806_;
								ValaTypeSymbol* _tmp807_;
								ValaTypeSymbol* _tmp808_;
								_tmp794_ = vala_code_context_get_analyzer (context);
								_tmp795_ = _tmp794_;
								_tmp796_ = _tmp795_->gvalue_type;
								_tmp797_ = vala_data_type_get_data_type ((ValaDataType*) _tmp796_);
								_tmp798_ = _tmp797_;
								_tmp799_ = _vala_code_node_ref0 (_tmp798_);
								gvalue_type = _tmp799_;
								_tmp802_ = vala_binary_expression_get_left (self);
								_tmp803_ = _tmp802_;
								_tmp804_ = vala_expression_get_target_type (_tmp803_);
								_tmp805_ = _tmp804_;
								_tmp806_ = vala_data_type_get_data_type (_tmp805_);
								_tmp807_ = _tmp806_;
								_tmp808_ = gvalue_type;
								if (_tmp807_ == _tmp808_) {
									ValaExpression* _tmp809_;
									ValaExpression* _tmp810_;
									ValaDataType* _tmp811_;
									ValaDataType* _tmp812_;
									ValaTypeSymbol* _tmp813_;
									ValaTypeSymbol* _tmp814_;
									ValaTypeSymbol* _tmp815_;
									_tmp809_ = vala_binary_expression_get_right (self);
									_tmp810_ = _tmp809_;
									_tmp811_ = vala_expression_get_target_type (_tmp810_);
									_tmp812_ = _tmp811_;
									_tmp813_ = vala_data_type_get_data_type (_tmp812_);
									_tmp814_ = _tmp813_;
									_tmp815_ = gvalue_type;
									_tmp801_ = _tmp814_ != _tmp815_;
								} else {
									_tmp801_ = FALSE;
								}
								if (_tmp801_) {
									_tmp800_ = TRUE;
								} else {
									gboolean _tmp816_ = FALSE;
									ValaExpression* _tmp817_;
									ValaExpression* _tmp818_;
									ValaDataType* _tmp819_;
									ValaDataType* _tmp820_;
									ValaTypeSymbol* _tmp821_;
									ValaTypeSymbol* _tmp822_;
									ValaTypeSymbol* _tmp823_;
									_tmp817_ = vala_binary_expression_get_left (self);
									_tmp818_ = _tmp817_;
									_tmp819_ = vala_expression_get_target_type (_tmp818_);
									_tmp820_ = _tmp819_;
									_tmp821_ = vala_data_type_get_data_type (_tmp820_);
									_tmp822_ = _tmp821_;
									_tmp823_ = gvalue_type;
									if (_tmp822_ != _tmp823_) {
										ValaExpression* _tmp824_;
										ValaExpression* _tmp825_;
										ValaDataType* _tmp826_;
										ValaDataType* _tmp827_;
										ValaTypeSymbol* _tmp828_;
										ValaTypeSymbol* _tmp829_;
										ValaTypeSymbol* _tmp830_;
										_tmp824_ = vala_binary_expression_get_right (self);
										_tmp825_ = _tmp824_;
										_tmp826_ = vala_expression_get_target_type (_tmp825_);
										_tmp827_ = _tmp826_;
										_tmp828_ = vala_data_type_get_data_type (_tmp827_);
										_tmp829_ = _tmp828_;
										_tmp830_ = gvalue_type;
										_tmp816_ = _tmp829_ == _tmp830_;
									} else {
										_tmp816_ = FALSE;
									}
									_tmp800_ = _tmp816_;
								}
								if (_tmp800_) {
									ValaExpression* gvalue_expr = NULL;
									ValaDataType* target_type = NULL;
									ValaExpression* _tmp831_;
									ValaExpression* _tmp832_;
									ValaDataType* _tmp833_;
									ValaDataType* _tmp834_;
									ValaTypeSymbol* _tmp835_;
									ValaTypeSymbol* _tmp836_;
									ValaTypeSymbol* _tmp837_;
									ValaCastExpression* cast_expr = NULL;
									ValaExpression* _tmp854_;
									ValaDataType* _tmp855_;
									ValaExpression* _tmp856_;
									ValaSourceReference* _tmp857_;
									ValaSourceReference* _tmp858_;
									ValaCastExpression* _tmp859_;
									ValaExpression* _tmp860_;
									ValaCastExpression* _tmp861_;
									_tmp831_ = vala_binary_expression_get_left (self);
									_tmp832_ = _tmp831_;
									_tmp833_ = vala_expression_get_target_type (_tmp832_);
									_tmp834_ = _tmp833_;
									_tmp835_ = vala_data_type_get_data_type (_tmp834_);
									_tmp836_ = _tmp835_;
									_tmp837_ = gvalue_type;
									if (_tmp836_ == _tmp837_) {
										ValaExpression* _tmp838_;
										ValaExpression* _tmp839_;
										ValaExpression* _tmp840_;
										ValaExpression* _tmp841_;
										ValaExpression* _tmp842_;
										ValaDataType* _tmp843_;
										ValaDataType* _tmp844_;
										ValaDataType* _tmp845_;
										_tmp838_ = vala_binary_expression_get_left (self);
										_tmp839_ = _tmp838_;
										_tmp840_ = _vala_code_node_ref0 (_tmp839_);
										_vala_code_node_unref0 (gvalue_expr);
										gvalue_expr = _tmp840_;
										_tmp841_ = vala_binary_expression_get_right (self);
										_tmp842_ = _tmp841_;
										_tmp843_ = vala_expression_get_target_type (_tmp842_);
										_tmp844_ = _tmp843_;
										_tmp845_ = _vala_code_node_ref0 (_tmp844_);
										_vala_code_node_unref0 (target_type);
										target_type = _tmp845_;
									} else {
										ValaExpression* _tmp846_;
										ValaExpression* _tmp847_;
										ValaExpression* _tmp848_;
										ValaExpression* _tmp849_;
										ValaExpression* _tmp850_;
										ValaDataType* _tmp851_;
										ValaDataType* _tmp852_;
										ValaDataType* _tmp853_;
										_tmp846_ = vala_binary_expression_get_right (self);
										_tmp847_ = _tmp846_;
										_tmp848_ = _vala_code_node_ref0 (_tmp847_);
										_vala_code_node_unref0 (gvalue_expr);
										gvalue_expr = _tmp848_;
										_tmp849_ = vala_binary_expression_get_left (self);
										_tmp850_ = _tmp849_;
										_tmp851_ = vala_expression_get_target_type (_tmp850_);
										_tmp852_ = _tmp851_;
										_tmp853_ = _vala_code_node_ref0 (_tmp852_);
										_vala_code_node_unref0 (target_type);
										target_type = _tmp853_;
									}
									_tmp854_ = gvalue_expr;
									_tmp855_ = target_type;
									_tmp856_ = gvalue_expr;
									_tmp857_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp856_);
									_tmp858_ = _tmp857_;
									_tmp859_ = vala_cast_expression_new (_tmp854_, _tmp855_, _tmp858_);
									cast_expr = _tmp859_;
									_tmp860_ = gvalue_expr;
									_tmp861_ = cast_expr;
									vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp860_, (ValaExpression*) _tmp861_);
									vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
									result = vala_code_node_check ((ValaCodeNode*) self, context);
									_vala_code_node_unref0 (cast_expr);
									_vala_code_node_unref0 (target_type);
									_vala_code_node_unref0 (gvalue_expr);
									_vala_code_node_unref0 (gvalue_type);
									return result;
								}
								_vala_code_node_unref0 (gvalue_type);
							}
							_tmp863_ = vala_binary_expression_get_right (self);
							_tmp864_ = _tmp863_;
							_tmp865_ = vala_expression_get_value_type (_tmp864_);
							_tmp866_ = _tmp865_;
							_tmp867_ = vala_binary_expression_get_left (self);
							_tmp868_ = _tmp867_;
							_tmp869_ = vala_expression_get_value_type (_tmp868_);
							_tmp870_ = _tmp869_;
							if (!vala_data_type_compatible (_tmp866_, _tmp870_)) {
								ValaExpression* _tmp871_;
								ValaExpression* _tmp872_;
								ValaDataType* _tmp873_;
								ValaDataType* _tmp874_;
								ValaExpression* _tmp875_;
								ValaExpression* _tmp876_;
								ValaDataType* _tmp877_;
								ValaDataType* _tmp878_;
								_tmp871_ = vala_binary_expression_get_left (self);
								_tmp872_ = _tmp871_;
								_tmp873_ = vala_expression_get_value_type (_tmp872_);
								_tmp874_ = _tmp873_;
								_tmp875_ = vala_binary_expression_get_right (self);
								_tmp876_ = _tmp875_;
								_tmp877_ = vala_expression_get_value_type (_tmp876_);
								_tmp878_ = _tmp877_;
								_tmp862_ = !vala_data_type_compatible (_tmp874_, _tmp878_);
							} else {
								_tmp862_ = FALSE;
							}
							if (_tmp862_) {
								ValaSourceReference* _tmp879_;
								ValaSourceReference* _tmp880_;
								ValaExpression* _tmp881_;
								ValaExpression* _tmp882_;
								ValaDataType* _tmp883_;
								ValaDataType* _tmp884_;
								gchar* _tmp885_;
								gchar* _tmp886_;
								ValaExpression* _tmp887_;
								ValaExpression* _tmp888_;
								ValaDataType* _tmp889_;
								ValaDataType* _tmp890_;
								gchar* _tmp891_;
								gchar* _tmp892_;
								gchar* _tmp893_;
								gchar* _tmp894_;
								_tmp879_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp880_ = _tmp879_;
								_tmp881_ = vala_binary_expression_get_right (self);
								_tmp882_ = _tmp881_;
								_tmp883_ = vala_expression_get_value_type (_tmp882_);
								_tmp884_ = _tmp883_;
								_tmp885_ = vala_code_node_to_string ((ValaCodeNode*) _tmp884_);
								_tmp886_ = _tmp885_;
								_tmp887_ = vala_binary_expression_get_left (self);
								_tmp888_ = _tmp887_;
								_tmp889_ = vala_expression_get_value_type (_tmp888_);
								_tmp890_ = _tmp889_;
								_tmp891_ = vala_code_node_to_string ((ValaCodeNode*) _tmp890_);
								_tmp892_ = _tmp891_;
								_tmp893_ = g_strdup_printf ("Equality operation: `%s' and `%s' are incompatible", _tmp886_, _tmp892_);
								_tmp894_ = _tmp893_;
								vala_report_error (_tmp880_, _tmp894_);
								_g_free0 (_tmp894_);
								_g_free0 (_tmp892_);
								_g_free0 (_tmp886_);
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp895_ = vala_code_context_get_analyzer (context);
							_tmp896_ = _tmp895_;
							_tmp897_ = vala_binary_expression_get_left (self);
							_tmp898_ = _tmp897_;
							_tmp899_ = vala_expression_get_target_type (_tmp898_);
							_tmp900_ = _tmp899_;
							_tmp901_ = vala_binary_expression_get_right (self);
							_tmp902_ = _tmp901_;
							_tmp903_ = vala_expression_get_target_type (_tmp902_);
							_tmp904_ = _tmp903_;
							_tmp905_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp896_, _tmp900_, _tmp904_);
							resulting_type = _tmp905_;
							_tmp906_ = resulting_type;
							if (_tmp906_ != NULL) {
								ValaExpression* _tmp907_;
								ValaExpression* _tmp908_;
								ValaDataType* _tmp909_;
								ValaDataType* _tmp910_;
								ValaDataType* _tmp911_;
								ValaExpression* _tmp912_;
								ValaExpression* _tmp913_;
								ValaDataType* _tmp914_;
								ValaDataType* _tmp915_;
								ValaDataType* _tmp916_;
								_tmp907_ = vala_binary_expression_get_left (self);
								_tmp908_ = _tmp907_;
								_tmp909_ = resulting_type;
								_tmp910_ = vala_data_type_copy (_tmp909_);
								_tmp911_ = _tmp910_;
								vala_expression_set_target_type (_tmp908_, _tmp911_);
								_vala_code_node_unref0 (_tmp911_);
								_tmp912_ = vala_binary_expression_get_right (self);
								_tmp913_ = _tmp912_;
								_tmp914_ = resulting_type;
								_tmp915_ = vala_data_type_copy (_tmp914_);
								_tmp916_ = _tmp915_;
								vala_expression_set_target_type (_tmp913_, _tmp916_);
								_vala_code_node_unref0 (_tmp916_);
							}
							_tmp917_ = vala_binary_expression_get_left (self);
							_tmp918_ = _tmp917_;
							_tmp919_ = vala_expression_get_target_type (_tmp918_);
							_tmp920_ = _tmp919_;
							vala_data_type_set_value_owned (_tmp920_, FALSE);
							_tmp921_ = vala_binary_expression_get_right (self);
							_tmp922_ = _tmp921_;
							_tmp923_ = vala_expression_get_target_type (_tmp922_);
							_tmp924_ = _tmp923_;
							vala_data_type_set_value_owned (_tmp924_, FALSE);
							_tmp925_ = vala_binary_expression_get_left (self);
							_tmp926_ = _tmp925_;
							_tmp927_ = vala_expression_get_value_type (_tmp926_);
							_tmp928_ = _tmp927_;
							_tmp929_ = vala_data_type_get_nullable (_tmp928_);
							_tmp930_ = _tmp929_;
							_tmp931_ = vala_binary_expression_get_right (self);
							_tmp932_ = _tmp931_;
							_tmp933_ = vala_expression_get_value_type (_tmp932_);
							_tmp934_ = _tmp933_;
							_tmp935_ = vala_data_type_get_nullable (_tmp934_);
							_tmp936_ = _tmp935_;
							if (_tmp930_ != _tmp936_) {
								ValaExpression* _tmp937_;
								ValaExpression* _tmp938_;
								ValaDataType* _tmp939_;
								ValaDataType* _tmp940_;
								ValaExpression* _tmp941_;
								ValaExpression* _tmp942_;
								ValaDataType* _tmp943_;
								ValaDataType* _tmp944_;
								_tmp937_ = vala_binary_expression_get_left (self);
								_tmp938_ = _tmp937_;
								_tmp939_ = vala_expression_get_target_type (_tmp938_);
								_tmp940_ = _tmp939_;
								vala_data_type_set_nullable (_tmp940_, TRUE);
								_tmp941_ = vala_binary_expression_get_right (self);
								_tmp942_ = _tmp941_;
								_tmp943_ = vala_expression_get_target_type (_tmp942_);
								_tmp944_ = _tmp943_;
								vala_data_type_set_nullable (_tmp944_, TRUE);
							}
							_tmp945_ = vala_code_context_get_analyzer (context);
							_tmp946_ = _tmp945_;
							_tmp947_ = _tmp946_->bool_type;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp947_);
							_vala_code_node_unref0 (resulting_type);
						} else {
							gboolean _tmp948_ = FALSE;
							gboolean _tmp949_ = FALSE;
							ValaBinaryOperator _tmp950_;
							_tmp950_ = self->priv->_operator;
							if (_tmp950_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
								_tmp949_ = TRUE;
							} else {
								ValaBinaryOperator _tmp951_;
								_tmp951_ = self->priv->_operator;
								_tmp949_ = _tmp951_ == VALA_BINARY_OPERATOR_BITWISE_OR;
							}
							if (_tmp949_) {
								_tmp948_ = TRUE;
							} else {
								ValaBinaryOperator _tmp952_;
								_tmp952_ = self->priv->_operator;
								_tmp948_ = _tmp952_ == VALA_BINARY_OPERATOR_BITWISE_XOR;
							}
							if (_tmp948_) {
								ValaExpression* _tmp953_;
								ValaExpression* _tmp954_;
								ValaDataType* _tmp955_;
								ValaDataType* _tmp956_;
								ValaExpression* _tmp957_;
								ValaExpression* _tmp958_;
								ValaDataType* _tmp959_;
								ValaDataType* _tmp960_;
								ValaExpression* _tmp961_;
								ValaExpression* _tmp962_;
								ValaDataType* _tmp963_;
								ValaDataType* _tmp964_;
								ValaDataType* _tmp965_;
								ValaDataType* _tmp966_;
								_tmp953_ = vala_binary_expression_get_left (self);
								_tmp954_ = _tmp953_;
								_tmp955_ = vala_expression_get_target_type (_tmp954_);
								_tmp956_ = _tmp955_;
								vala_data_type_set_nullable (_tmp956_, FALSE);
								_tmp957_ = vala_binary_expression_get_right (self);
								_tmp958_ = _tmp957_;
								_tmp959_ = vala_expression_get_target_type (_tmp958_);
								_tmp960_ = _tmp959_;
								vala_data_type_set_nullable (_tmp960_, FALSE);
								_tmp961_ = vala_binary_expression_get_left (self);
								_tmp962_ = _tmp961_;
								_tmp963_ = vala_expression_get_target_type (_tmp962_);
								_tmp964_ = _tmp963_;
								_tmp965_ = vala_data_type_copy (_tmp964_);
								_tmp966_ = _tmp965_;
								vala_expression_set_value_type ((ValaExpression*) self, _tmp966_);
								_vala_code_node_unref0 (_tmp966_);
							} else {
								gboolean _tmp967_ = FALSE;
								ValaBinaryOperator _tmp968_;
								_tmp968_ = self->priv->_operator;
								if (_tmp968_ == VALA_BINARY_OPERATOR_AND) {
									_tmp967_ = TRUE;
								} else {
									ValaBinaryOperator _tmp969_;
									_tmp969_ = self->priv->_operator;
									_tmp967_ = _tmp969_ == VALA_BINARY_OPERATOR_OR;
								}
								if (_tmp967_) {
									gboolean _tmp970_ = FALSE;
									ValaExpression* _tmp971_;
									ValaExpression* _tmp972_;
									ValaDataType* _tmp973_;
									ValaDataType* _tmp974_;
									ValaSemanticAnalyzer* _tmp975_;
									ValaSemanticAnalyzer* _tmp976_;
									ValaDataType* _tmp977_;
									ValaExpression* _tmp987_;
									ValaExpression* _tmp988_;
									ValaDataType* _tmp989_;
									ValaDataType* _tmp990_;
									ValaExpression* _tmp991_;
									ValaExpression* _tmp992_;
									ValaDataType* _tmp993_;
									ValaDataType* _tmp994_;
									ValaSemanticAnalyzer* _tmp995_;
									ValaSemanticAnalyzer* _tmp996_;
									ValaDataType* _tmp997_;
									_tmp971_ = vala_binary_expression_get_left (self);
									_tmp972_ = _tmp971_;
									_tmp973_ = vala_expression_get_value_type (_tmp972_);
									_tmp974_ = _tmp973_;
									_tmp975_ = vala_code_context_get_analyzer (context);
									_tmp976_ = _tmp975_;
									_tmp977_ = _tmp976_->bool_type;
									if (!vala_data_type_compatible (_tmp974_, _tmp977_)) {
										_tmp970_ = TRUE;
									} else {
										ValaExpression* _tmp978_;
										ValaExpression* _tmp979_;
										ValaDataType* _tmp980_;
										ValaDataType* _tmp981_;
										ValaSemanticAnalyzer* _tmp982_;
										ValaSemanticAnalyzer* _tmp983_;
										ValaDataType* _tmp984_;
										_tmp978_ = vala_binary_expression_get_right (self);
										_tmp979_ = _tmp978_;
										_tmp980_ = vala_expression_get_value_type (_tmp979_);
										_tmp981_ = _tmp980_;
										_tmp982_ = vala_code_context_get_analyzer (context);
										_tmp983_ = _tmp982_;
										_tmp984_ = _tmp983_->bool_type;
										_tmp970_ = !vala_data_type_compatible (_tmp981_, _tmp984_);
									}
									if (_tmp970_) {
										ValaSourceReference* _tmp985_;
										ValaSourceReference* _tmp986_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp985_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp986_ = _tmp985_;
										vala_report_error (_tmp986_, "Operands must be boolean");
									}
									_tmp987_ = vala_binary_expression_get_left (self);
									_tmp988_ = _tmp987_;
									_tmp989_ = vala_expression_get_target_type (_tmp988_);
									_tmp990_ = _tmp989_;
									vala_data_type_set_nullable (_tmp990_, FALSE);
									_tmp991_ = vala_binary_expression_get_right (self);
									_tmp992_ = _tmp991_;
									_tmp993_ = vala_expression_get_target_type (_tmp992_);
									_tmp994_ = _tmp993_;
									vala_data_type_set_nullable (_tmp994_, FALSE);
									_tmp995_ = vala_code_context_get_analyzer (context);
									_tmp996_ = _tmp995_;
									_tmp997_ = _tmp996_->bool_type;
									vala_expression_set_value_type ((ValaExpression*) self, _tmp997_);
								} else {
									ValaBinaryOperator _tmp998_;
									_tmp998_ = self->priv->_operator;
									if (_tmp998_ == VALA_BINARY_OPERATOR_IN) {
										gboolean _tmp999_ = FALSE;
										ValaExpression* _tmp1000_;
										ValaExpression* _tmp1001_;
										ValaDataType* _tmp1002_;
										ValaDataType* _tmp1003_;
										ValaSemanticAnalyzer* _tmp1004_;
										ValaSemanticAnalyzer* _tmp1005_;
										ValaDataType* _tmp1006_;
										ValaSemanticAnalyzer* _tmp1112_;
										ValaSemanticAnalyzer* _tmp1113_;
										ValaDataType* _tmp1114_;
										_tmp1000_ = vala_binary_expression_get_left (self);
										_tmp1001_ = _tmp1000_;
										_tmp1002_ = vala_expression_get_value_type (_tmp1001_);
										_tmp1003_ = _tmp1002_;
										_tmp1004_ = vala_code_context_get_analyzer (context);
										_tmp1005_ = _tmp1004_;
										_tmp1006_ = _tmp1005_->int_type;
										if (vala_data_type_compatible (_tmp1003_, _tmp1006_)) {
											ValaExpression* _tmp1007_;
											ValaExpression* _tmp1008_;
											ValaDataType* _tmp1009_;
											ValaDataType* _tmp1010_;
											ValaSemanticAnalyzer* _tmp1011_;
											ValaSemanticAnalyzer* _tmp1012_;
											ValaDataType* _tmp1013_;
											_tmp1007_ = vala_binary_expression_get_right (self);
											_tmp1008_ = _tmp1007_;
											_tmp1009_ = vala_expression_get_value_type (_tmp1008_);
											_tmp1010_ = _tmp1009_;
											_tmp1011_ = vala_code_context_get_analyzer (context);
											_tmp1012_ = _tmp1011_;
											_tmp1013_ = _tmp1012_->int_type;
											_tmp999_ = vala_data_type_compatible (_tmp1010_, _tmp1013_);
										} else {
											_tmp999_ = FALSE;
										}
										if (_tmp999_) {
											ValaExpression* _tmp1014_;
											ValaExpression* _tmp1015_;
											ValaDataType* _tmp1016_;
											ValaDataType* _tmp1017_;
											ValaExpression* _tmp1018_;
											ValaExpression* _tmp1019_;
											ValaDataType* _tmp1020_;
											ValaDataType* _tmp1021_;
											_tmp1014_ = vala_binary_expression_get_left (self);
											_tmp1015_ = _tmp1014_;
											_tmp1016_ = vala_expression_get_target_type (_tmp1015_);
											_tmp1017_ = _tmp1016_;
											vala_data_type_set_nullable (_tmp1017_, FALSE);
											_tmp1018_ = vala_binary_expression_get_right (self);
											_tmp1019_ = _tmp1018_;
											_tmp1020_ = vala_expression_get_target_type (_tmp1019_);
											_tmp1021_ = _tmp1020_;
											vala_data_type_set_nullable (_tmp1021_, FALSE);
										} else {
											ValaExpression* _tmp1022_;
											ValaExpression* _tmp1023_;
											ValaDataType* _tmp1024_;
											ValaDataType* _tmp1025_;
											_tmp1022_ = vala_binary_expression_get_right (self);
											_tmp1023_ = _tmp1022_;
											_tmp1024_ = vala_expression_get_value_type (_tmp1023_);
											_tmp1025_ = _tmp1024_;
											if (VALA_IS_ARRAY_TYPE (_tmp1025_)) {
												ValaExpression* _tmp1026_;
												ValaExpression* _tmp1027_;
												ValaDataType* _tmp1028_;
												ValaDataType* _tmp1029_;
												ValaExpression* _tmp1030_;
												ValaExpression* _tmp1031_;
												ValaDataType* _tmp1032_;
												ValaDataType* _tmp1033_;
												ValaDataType* _tmp1034_;
												ValaDataType* _tmp1035_;
												_tmp1026_ = vala_binary_expression_get_left (self);
												_tmp1027_ = _tmp1026_;
												_tmp1028_ = vala_expression_get_value_type (_tmp1027_);
												_tmp1029_ = _tmp1028_;
												_tmp1030_ = vala_binary_expression_get_right (self);
												_tmp1031_ = _tmp1030_;
												_tmp1032_ = vala_expression_get_value_type (_tmp1031_);
												_tmp1033_ = _tmp1032_;
												_tmp1034_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1033_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
												_tmp1035_ = _tmp1034_;
												if (!vala_data_type_compatible (_tmp1029_, _tmp1035_)) {
													ValaSourceReference* _tmp1036_;
													ValaSourceReference* _tmp1037_;
													ValaExpression* _tmp1038_;
													ValaExpression* _tmp1039_;
													ValaDataType* _tmp1040_;
													ValaDataType* _tmp1041_;
													gchar* _tmp1042_;
													gchar* _tmp1043_;
													ValaExpression* _tmp1044_;
													ValaExpression* _tmp1045_;
													ValaDataType* _tmp1046_;
													ValaDataType* _tmp1047_;
													gchar* _tmp1048_;
													gchar* _tmp1049_;
													gchar* _tmp1050_;
													gchar* _tmp1051_;
													_tmp1036_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1037_ = _tmp1036_;
													_tmp1038_ = vala_binary_expression_get_left (self);
													_tmp1039_ = _tmp1038_;
													_tmp1040_ = vala_expression_get_value_type (_tmp1039_);
													_tmp1041_ = _tmp1040_;
													_tmp1042_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1041_);
													_tmp1043_ = _tmp1042_;
													_tmp1044_ = vala_binary_expression_get_right (self);
													_tmp1045_ = _tmp1044_;
													_tmp1046_ = vala_expression_get_value_type (_tmp1045_);
													_tmp1047_ = _tmp1046_;
													_tmp1048_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1047_);
													_tmp1049_ = _tmp1048_;
													_tmp1050_ = g_strdup_printf ("Cannot look for `%s' in `%s'", _tmp1043_, _tmp1049_);
													_tmp1051_ = _tmp1050_;
													vala_report_error (_tmp1037_, _tmp1051_);
													_g_free0 (_tmp1051_);
													_g_free0 (_tmp1049_);
													_g_free0 (_tmp1043_);
												}
											} else {
												ValaMethod* contains_method = NULL;
												ValaExpression* _tmp1052_;
												ValaExpression* _tmp1053_;
												ValaDataType* _tmp1054_;
												ValaDataType* _tmp1055_;
												ValaSymbol* _tmp1056_;
												ValaMethod* _tmp1057_;
												ValaMethod* _tmp1058_;
												ValaMethod* _tmp1069_;
												ValaList* _tmp1070_;
												ValaList* _tmp1071_;
												gint _tmp1072_;
												gint _tmp1073_;
												gboolean _tmp1074_;
												ValaMethod* _tmp1082_;
												ValaDataType* _tmp1083_;
												ValaDataType* _tmp1084_;
												ValaSemanticAnalyzer* _tmp1085_;
												ValaSemanticAnalyzer* _tmp1086_;
												ValaDataType* _tmp1087_;
												ValaMethodCall* contains_call = NULL;
												ValaExpression* _tmp1095_;
												ValaExpression* _tmp1096_;
												ValaSourceReference* _tmp1097_;
												ValaSourceReference* _tmp1098_;
												ValaMemberAccess* _tmp1099_;
												ValaMemberAccess* _tmp1100_;
												ValaSourceReference* _tmp1101_;
												ValaSourceReference* _tmp1102_;
												ValaMethodCall* _tmp1103_;
												ValaMethodCall* _tmp1104_;
												ValaMethodCall* _tmp1105_;
												ValaExpression* _tmp1106_;
												ValaExpression* _tmp1107_;
												ValaCodeNode* _tmp1108_;
												ValaCodeNode* _tmp1109_;
												ValaMethodCall* _tmp1110_;
												ValaMethodCall* _tmp1111_;
												_tmp1052_ = vala_binary_expression_get_right (self);
												_tmp1053_ = _tmp1052_;
												_tmp1054_ = vala_expression_get_value_type (_tmp1053_);
												_tmp1055_ = _tmp1054_;
												_tmp1056_ = vala_data_type_get_member (_tmp1055_, "contains");
												_tmp1057_ = VALA_IS_METHOD (_tmp1056_) ? ((ValaMethod*) _tmp1056_) : NULL;
												if (_tmp1057_ == NULL) {
													_vala_code_node_unref0 (_tmp1056_);
												}
												contains_method = _tmp1057_;
												_tmp1058_ = contains_method;
												if (_tmp1058_ == NULL) {
													ValaSourceReference* _tmp1059_;
													ValaSourceReference* _tmp1060_;
													ValaExpression* _tmp1061_;
													ValaExpression* _tmp1062_;
													ValaDataType* _tmp1063_;
													ValaDataType* _tmp1064_;
													gchar* _tmp1065_;
													gchar* _tmp1066_;
													gchar* _tmp1067_;
													gchar* _tmp1068_;
													_tmp1059_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1060_ = _tmp1059_;
													_tmp1061_ = vala_binary_expression_get_right (self);
													_tmp1062_ = _tmp1061_;
													_tmp1063_ = vala_expression_get_value_type (_tmp1062_);
													_tmp1064_ = _tmp1063_;
													_tmp1065_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1064_);
													_tmp1066_ = _tmp1065_;
													_tmp1067_ = g_strdup_printf ("`%s' does not have a `contains' method", _tmp1066_);
													_tmp1068_ = _tmp1067_;
													vala_report_error (_tmp1060_, _tmp1068_);
													_g_free0 (_tmp1068_);
													_g_free0 (_tmp1066_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1069_ = contains_method;
												_tmp1070_ = vala_callable_get_parameters ((ValaCallable*) _tmp1069_);
												_tmp1071_ = _tmp1070_;
												_tmp1072_ = vala_collection_get_size ((ValaCollection*) _tmp1071_);
												_tmp1073_ = _tmp1072_;
												_tmp1074_ = _tmp1073_ != 1;
												_vala_iterable_unref0 (_tmp1071_);
												if (_tmp1074_) {
													ValaSourceReference* _tmp1075_;
													ValaSourceReference* _tmp1076_;
													ValaMethod* _tmp1077_;
													gchar* _tmp1078_;
													gchar* _tmp1079_;
													gchar* _tmp1080_;
													gchar* _tmp1081_;
													_tmp1075_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1076_ = _tmp1075_;
													_tmp1077_ = contains_method;
													_tmp1078_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1077_);
													_tmp1079_ = _tmp1078_;
													_tmp1080_ = g_strdup_printf ("`%s' must have one parameter", _tmp1079_);
													_tmp1081_ = _tmp1080_;
													vala_report_error (_tmp1076_, _tmp1081_);
													_g_free0 (_tmp1081_);
													_g_free0 (_tmp1079_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1082_ = contains_method;
												_tmp1083_ = vala_callable_get_return_type ((ValaCallable*) _tmp1082_);
												_tmp1084_ = _tmp1083_;
												_tmp1085_ = vala_code_context_get_analyzer (context);
												_tmp1086_ = _tmp1085_;
												_tmp1087_ = _tmp1086_->bool_type;
												if (!vala_data_type_compatible (_tmp1084_, _tmp1087_)) {
													ValaSourceReference* _tmp1088_;
													ValaSourceReference* _tmp1089_;
													ValaMethod* _tmp1090_;
													gchar* _tmp1091_;
													gchar* _tmp1092_;
													gchar* _tmp1093_;
													gchar* _tmp1094_;
													_tmp1088_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1089_ = _tmp1088_;
													_tmp1090_ = contains_method;
													_tmp1091_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1090_);
													_tmp1092_ = _tmp1091_;
													_tmp1093_ = g_strdup_printf ("`%s' must return a boolean value", _tmp1092_);
													_tmp1094_ = _tmp1093_;
													vala_report_error (_tmp1089_, _tmp1094_);
													_g_free0 (_tmp1094_);
													_g_free0 (_tmp1092_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1095_ = vala_binary_expression_get_right (self);
												_tmp1096_ = _tmp1095_;
												_tmp1097_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1098_ = _tmp1097_;
												_tmp1099_ = vala_member_access_new (_tmp1096_, "contains", _tmp1098_);
												_tmp1100_ = _tmp1099_;
												_tmp1101_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1102_ = _tmp1101_;
												_tmp1103_ = vala_method_call_new ((ValaExpression*) _tmp1100_, _tmp1102_);
												_tmp1104_ = _tmp1103_;
												_vala_code_node_unref0 (_tmp1100_);
												contains_call = _tmp1104_;
												_tmp1105_ = contains_call;
												_tmp1106_ = vala_binary_expression_get_left (self);
												_tmp1107_ = _tmp1106_;
												vala_method_call_add_argument (_tmp1105_, _tmp1107_);
												_tmp1108_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
												_tmp1109_ = _tmp1108_;
												_tmp1110_ = contains_call;
												vala_code_node_replace_expression (_tmp1109_, (ValaExpression*) self, (ValaExpression*) _tmp1110_);
												_tmp1111_ = contains_call;
												result = vala_code_node_check ((ValaCodeNode*) _tmp1111_, context);
												_vala_code_node_unref0 (contains_call);
												_vala_code_node_unref0 (contains_method);
												return result;
											}
										}
										_tmp1112_ = vala_code_context_get_analyzer (context);
										_tmp1113_ = _tmp1112_;
										_tmp1114_ = _tmp1113_->bool_type;
										vala_expression_set_value_type ((ValaExpression*) self, _tmp1114_);
									} else {
										ValaSourceReference* _tmp1115_;
										ValaSourceReference* _tmp1116_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp1115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp1116_ = _tmp1115_;
										vala_report_error (_tmp1116_, "internal error: unsupported binary operator");
										result = FALSE;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1117_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1118_ = _tmp1117_;
	vala_code_node_check ((ValaCodeNode*) _tmp1118_, context);
	_tmp1119_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1120_ = _tmp1119_;
	result = !_tmp1120_;
	return result;
}

static void
vala_binary_expression_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	vala_code_visitor_visit_binary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                   ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
}

static void
vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
}

ValaBinaryOperator
vala_binary_expression_get_operator (ValaBinaryExpression* self)
{
	ValaBinaryOperator result;
	ValaBinaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

void
vala_binary_expression_set_operator (ValaBinaryExpression* self,
                                     ValaBinaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_binary_expression_get_left (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

void
vala_binary_expression_set_left (ValaBinaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaExpression*
vala_binary_expression_get_right (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_binary_expression_set_right (ValaBinaryExpression* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_binary_expression_get_is_chained (ValaBinaryExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chained;
	return result;
}

static void
vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chained = value;
}

static void
vala_binary_expression_class_init (ValaBinaryExpressionClass * klass,
                                   gpointer klass_data)
{
	vala_binary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_binary_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaBinaryExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_binary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_binary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_non_null;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_binary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_binary_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_binary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_binary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_used_variables;
}

static void
vala_binary_expression_instance_init (ValaBinaryExpression * self,
                                      gpointer klass)
{
	self->priv = vala_binary_expression_get_instance_private (self);
}

static void
vala_binary_expression_finalize (ValaCodeNode * obj)
{
	ValaBinaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_binary_expression_parent_class)->finalize (obj);
}

/**
 * Represents an expression with two operands in the source code.
 *
 * Supports +, -, *, /, %, <<, >>, <, >, <=, >=, ==, !=, &, |, ^, &&, ||, ??.
 */
GType
vala_binary_expression_get_type (void)
{
	static volatile gsize vala_binary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBinaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_binary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBinaryExpression), 0, (GInstanceInitFunc) vala_binary_expression_instance_init, NULL };
		GType vala_binary_expression_type_id;
		vala_binary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaBinaryExpression", &g_define_type_info, 0);
		ValaBinaryExpression_private_offset = g_type_add_instance_private (vala_binary_expression_type_id, sizeof (ValaBinaryExpressionPrivate));
		g_once_init_leave (&vala_binary_expression_type_id__volatile, vala_binary_expression_type_id);
	}
	return vala_binary_expression_type_id__volatile;
}

const gchar*
vala_binary_operator_to_string (ValaBinaryOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_BINARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_BINARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_BINARY_OPERATOR_MUL:
		{
			result = "*";
			return result;
		}
		case VALA_BINARY_OPERATOR_DIV:
		{
			result = "/";
			return result;
		}
		case VALA_BINARY_OPERATOR_MOD:
		{
			result = "%";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		{
			result = "<<";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		{
			result = "<";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		{
			result = ">";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			result = "<=";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			result = ">=";
			return result;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		{
			result = "==";
			return result;
		}
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			result = "!=";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		{
			result = "&";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		{
			result = "|";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			result = "^";
			return result;
		}
		case VALA_BINARY_OPERATOR_AND:
		{
			result = "&&";
			return result;
		}
		case VALA_BINARY_OPERATOR_OR:
		{
			result = "||";
			return result;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			result = "in";
			return result;
		}
		case VALA_BINARY_OPERATOR_COALESCE:
		{
			result = "??";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GType
vala_binary_operator_get_type (void)
{
	static volatile gsize vala_binary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_BINARY_OPERATOR_NONE, "VALA_BINARY_OPERATOR_NONE", "none"}, {VALA_BINARY_OPERATOR_PLUS, "VALA_BINARY_OPERATOR_PLUS", "plus"}, {VALA_BINARY_OPERATOR_MINUS, "VALA_BINARY_OPERATOR_MINUS", "minus"}, {VALA_BINARY_OPERATOR_MUL, "VALA_BINARY_OPERATOR_MUL", "mul"}, {VALA_BINARY_OPERATOR_DIV, "VALA_BINARY_OPERATOR_DIV", "div"}, {VALA_BINARY_OPERATOR_MOD, "VALA_BINARY_OPERATOR_MOD", "mod"}, {VALA_BINARY_OPERATOR_SHIFT_LEFT, "VALA_BINARY_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_BINARY_OPERATOR_SHIFT_RIGHT, "VALA_BINARY_OPERATOR_SHIFT_RIGHT", "shift-right"}, {VALA_BINARY_OPERATOR_LESS_THAN, "VALA_BINARY_OPERATOR_LESS_THAN", "less-than"}, {VALA_BINARY_OPERATOR_GREATER_THAN, "VALA_BINARY_OPERATOR_GREATER_THAN", "greater-than"}, {VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL", "less-than-or-equal"}, {VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL", "greater-than-or-equal"}, {VALA_BINARY_OPERATOR_EQUALITY, "VALA_BINARY_OPERATOR_EQUALITY", "equality"}, {VALA_BINARY_OPERATOR_INEQUALITY, "VALA_BINARY_OPERATOR_INEQUALITY", "inequality"}, {VALA_BINARY_OPERATOR_BITWISE_AND, "VALA_BINARY_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_BINARY_OPERATOR_BITWISE_OR, "VALA_BINARY_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_BINARY_OPERATOR_BITWISE_XOR, "VALA_BINARY_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_BINARY_OPERATOR_AND, "VALA_BINARY_OPERATOR_AND", "and"}, {VALA_BINARY_OPERATOR_OR, "VALA_BINARY_OPERATOR_OR", "or"}, {VALA_BINARY_OPERATOR_IN, "VALA_BINARY_OPERATOR_IN", "in"}, {VALA_BINARY_OPERATOR_COALESCE, "VALA_BINARY_OPERATOR_COALESCE", "coalesce"}, {0, NULL, NULL}};
		GType vala_binary_operator_type_id;
		vala_binary_operator_type_id = g_enum_register_static ("ValaBinaryOperator", values);
		g_once_init_leave (&vala_binary_operator_type_id__volatile, vala_binary_operator_type_id);
	}
	return vala_binary_operator_type_id__volatile;
}

