/* priorityqueue.c generated by valac 0.44.7, the Vala compiler
 * generated from priorityqueue.vala, do not modify */

/* priorityqueue.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 * Copyright (C) 2012-2014  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;
typedef gboolean (*GeeForallFunc) (gpointer g, gpointer user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END,
	GEE_TRAVERSABLE_STREAM_WAIT
} GeeTraversableStream;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;
typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy* * lazy, gpointer user_data);

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;
typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, gpointer user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, gpointer user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, gpointer user_data);
typedef GeeIterator* (*GeeFlatMapFunc) (gpointer g, gpointer user_data);

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_ABSTRACT_QUEUE (gee_abstract_queue_get_type ())
#define GEE_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueue))
#define GEE_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))
#define GEE_IS_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_IS_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_ABSTRACT_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))

typedef struct _GeeAbstractQueue GeeAbstractQueue;
typedef struct _GeeAbstractQueueClass GeeAbstractQueueClass;
typedef struct _GeeAbstractQueuePrivate GeeAbstractQueuePrivate;

#define GEE_TYPE_PRIORITY_QUEUE (gee_priority_queue_get_type ())
#define GEE_PRIORITY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueue))
#define GEE_PRIORITY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueueClass))
#define GEE_IS_PRIORITY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_PRIORITY_QUEUE))
#define GEE_IS_PRIORITY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_PRIORITY_QUEUE))
#define GEE_PRIORITY_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueueClass))

typedef struct _GeePriorityQueue GeePriorityQueue;
typedef struct _GeePriorityQueueClass GeePriorityQueueClass;
typedef struct _GeePriorityQueuePrivate GeePriorityQueuePrivate;

#define GEE_PRIORITY_QUEUE_TYPE_NODE (gee_priority_queue_node_get_type ())
#define GEE_PRIORITY_QUEUE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode))
#define GEE_PRIORITY_QUEUE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNodeClass))
#define GEE_PRIORITY_QUEUE_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE))
#define GEE_PRIORITY_QUEUE_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_NODE))
#define GEE_PRIORITY_QUEUE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNodeClass))

typedef struct _GeePriorityQueueNode GeePriorityQueueNode;
typedef struct _GeePriorityQueueNodeClass GeePriorityQueueNodeClass;

#define GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE (gee_priority_queue_type1_node_get_type ())
#define GEE_PRIORITY_QUEUE_TYPE1_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1Node))
#define GEE_PRIORITY_QUEUE_TYPE1_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1NodeClass))
#define GEE_PRIORITY_QUEUE_IS_TYPE1_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE))
#define GEE_PRIORITY_QUEUE_IS_TYPE1_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE))
#define GEE_PRIORITY_QUEUE_TYPE1_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1NodeClass))

typedef struct _GeePriorityQueueType1Node GeePriorityQueueType1Node;
typedef struct _GeePriorityQueueType1NodeClass GeePriorityQueueType1NodeClass;

#define GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE (gee_priority_queue_type2_node_get_type ())
#define GEE_PRIORITY_QUEUE_TYPE2_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, GeePriorityQueueType2Node))
#define GEE_PRIORITY_QUEUE_TYPE2_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, GeePriorityQueueType2NodeClass))
#define GEE_PRIORITY_QUEUE_IS_TYPE2_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE))
#define GEE_PRIORITY_QUEUE_IS_TYPE2_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE))
#define GEE_PRIORITY_QUEUE_TYPE2_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, GeePriorityQueueType2NodeClass))

typedef struct _GeePriorityQueueType2Node GeePriorityQueueType2Node;
typedef struct _GeePriorityQueueType2NodeClass GeePriorityQueueType2NodeClass;
typedef struct _GeePriorityQueueNodePair GeePriorityQueueNodePair;
enum  {
	GEE_PRIORITY_QUEUE_0_PROPERTY,
	GEE_PRIORITY_QUEUE_G_TYPE,
	GEE_PRIORITY_QUEUE_G_DUP_FUNC,
	GEE_PRIORITY_QUEUE_G_DESTROY_FUNC,
	GEE_PRIORITY_QUEUE_CAPACITY_PROPERTY,
	GEE_PRIORITY_QUEUE_REMAINING_CAPACITY_PROPERTY,
	GEE_PRIORITY_QUEUE_IS_FULL_PROPERTY,
	GEE_PRIORITY_QUEUE_READ_ONLY_PROPERTY,
	GEE_PRIORITY_QUEUE_SIZE_PROPERTY,
	GEE_PRIORITY_QUEUE_NUM_PROPERTIES
};
static GParamSpec* gee_priority_queue_properties[GEE_PRIORITY_QUEUE_NUM_PROPERTIES];
#define _gee_priority_queue_node_unref0(var) ((var == NULL) ? NULL : (var = (gee_priority_queue_node_unref (var), NULL)))
#define _gee_priority_queue_node_pair_free0(var) ((var == NULL) ? NULL : (var = (gee_priority_queue_node_pair_free (var), NULL)))
typedef struct _GeePriorityQueueNodePrivate GeePriorityQueueNodePrivate;
typedef struct _GeePriorityQueueType1NodePrivate GeePriorityQueueType1NodePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_PRIORITY_QUEUE_TYPE_ITERATOR (gee_priority_queue_iterator_get_type ())
#define GEE_PRIORITY_QUEUE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIterator))
#define GEE_PRIORITY_QUEUE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIteratorClass))
#define GEE_PRIORITY_QUEUE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_ITERATOR))
#define GEE_PRIORITY_QUEUE_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_ITERATOR))
#define GEE_PRIORITY_QUEUE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIteratorClass))

typedef struct _GeePriorityQueueIterator GeePriorityQueueIterator;
typedef struct _GeePriorityQueueIteratorClass GeePriorityQueueIteratorClass;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _GeePriorityQueueParamSpecNode GeePriorityQueueParamSpecNode;
typedef struct _GeePriorityQueueType2NodePrivate GeePriorityQueueType2NodePrivate;

#define GEE_PRIORITY_QUEUE_TYPE_DUMMY_NODE (gee_priority_queue_dummy_node_get_type ())
#define GEE_PRIORITY_QUEUE_DUMMY_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_DUMMY_NODE, GeePriorityQueueDummyNode))
#define GEE_PRIORITY_QUEUE_DUMMY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_DUMMY_NODE, GeePriorityQueueDummyNodeClass))
#define GEE_PRIORITY_QUEUE_IS_DUMMY_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_DUMMY_NODE))
#define GEE_PRIORITY_QUEUE_IS_DUMMY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_DUMMY_NODE))
#define GEE_PRIORITY_QUEUE_DUMMY_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_DUMMY_NODE, GeePriorityQueueDummyNodeClass))

typedef struct _GeePriorityQueueDummyNode GeePriorityQueueDummyNode;
typedef struct _GeePriorityQueueDummyNodeClass GeePriorityQueueDummyNodeClass;
typedef struct _GeePriorityQueueDummyNodePrivate GeePriorityQueueDummyNodePrivate;
typedef struct _GeePriorityQueueIteratorPrivate GeePriorityQueueIteratorPrivate;
enum  {
	GEE_PRIORITY_QUEUE_ITERATOR_0_PROPERTY,
	GEE_PRIORITY_QUEUE_ITERATOR_G_TYPE,
	GEE_PRIORITY_QUEUE_ITERATOR_G_DUP_FUNC,
	GEE_PRIORITY_QUEUE_ITERATOR_G_DESTROY_FUNC,
	GEE_PRIORITY_QUEUE_ITERATOR_READ_ONLY_PROPERTY,
	GEE_PRIORITY_QUEUE_ITERATOR_VALID_PROPERTY,
	GEE_PRIORITY_QUEUE_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* gee_priority_queue_iterator_properties[GEE_PRIORITY_QUEUE_ITERATOR_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, gpointer f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, gpointer f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, gpointer f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, gpointer f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, gpointer f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
	GeeIterator* (*flat_map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, gpointer f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator** (*tee) (GeeTraversable* self, guint forks, gint* result_length1);
	gpointer (*first_match) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	gboolean (*any_match) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	gboolean (*all_match) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	gpointer (*max) (GeeTraversable* self, GCompareDataFunc compare, gpointer compare_target, GDestroyNotify compare_target_destroy_notify);
	gpointer (*min) (GeeTraversable* self, GCompareDataFunc compare, gpointer compare_target, GDestroyNotify compare_target_destroy_notify);
	GeeIterator* (*order_by) (GeeTraversable* self, GCompareDataFunc compare, gpointer compare_target, GDestroyNotify compare_target_destroy_notify);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, gint* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
	gboolean (*add_all_array) (GeeCollection* self, gpointer* array, gint array_length1);
	gboolean (*contains_all_array) (GeeCollection* self, gpointer* array, gint array_length1);
	gboolean (*remove_all_array) (GeeCollection* self, gpointer* array, gint array_length1);
	gboolean (*add_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*contains_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*remove_all_iterator) (GeeCollection* self, GeeIterator* iter);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gboolean (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, gpointer f_target);
	void (*reserved0) (GeeAbstractCollection* self);
	void (*reserved1) (GeeAbstractCollection* self);
	void (*reserved2) (GeeAbstractCollection* self);
	void (*reserved3) (GeeAbstractCollection* self);
	void (*reserved4) (GeeAbstractCollection* self);
	void (*reserved5) (GeeAbstractCollection* self);
	void (*reserved6) (GeeAbstractCollection* self);
	void (*reserved7) (GeeAbstractCollection* self);
	void (*reserved8) (GeeAbstractCollection* self);
	void (*reserved9) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeQueue* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeQueue* self);
	GDestroyNotify (*get_g_destroy_func) (GeeQueue* self);
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeAbstractQueue {
	GeeAbstractCollection parent_instance;
	GeeAbstractQueuePrivate * priv;
};

struct _GeeAbstractQueueClass {
	GeeAbstractCollectionClass parent_class;
	gpointer (*peek) (GeeAbstractQueue* self);
	gpointer (*poll) (GeeAbstractQueue* self);
	void (*reserved0) (GeeAbstractQueue* self);
	void (*reserved1) (GeeAbstractQueue* self);
	void (*reserved2) (GeeAbstractQueue* self);
	void (*reserved3) (GeeAbstractQueue* self);
	void (*reserved4) (GeeAbstractQueue* self);
	void (*reserved5) (GeeAbstractQueue* self);
	void (*reserved6) (GeeAbstractQueue* self);
	void (*reserved7) (GeeAbstractQueue* self);
	void (*reserved8) (GeeAbstractQueue* self);
	void (*reserved9) (GeeAbstractQueue* self);
	gint (*get_capacity) (GeeAbstractQueue* self);
	gint (*get_remaining_capacity) (GeeAbstractQueue* self);
	gboolean (*get_is_full) (GeeAbstractQueue* self);
};

struct _GeePriorityQueue {
	GeeAbstractQueue parent_instance;
	GeePriorityQueuePrivate * priv;
};

struct _GeePriorityQueueClass {
	GeeAbstractQueueClass parent_class;
};

struct _GeePriorityQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _size;
	gint _stamp;
	GeePriorityQueueType1Node* _r;
	GeePriorityQueueType2Node* _r_prime;
	GeePriorityQueueType2Node* _lm_head;
	GeePriorityQueueType2Node* _lm_tail;
	GeePriorityQueueType1Node* _p;
	GeePriorityQueueType1Node** _a;
	gint _a_length1;
	gint __a_size_;
	GeePriorityQueueNodePair* _lp_head;
	GeePriorityQueueNodePair* _lp_tail;
	gboolean* _b;
	gint _b_length1;
	gint __b_size_;
	GeePriorityQueueType1Node* _ll_head;
	GeePriorityQueueType1Node* _ll_tail;
	GeePriorityQueueNode* _iter_head;
	GeePriorityQueueNode* _iter_tail;
	GCompareDataFunc _compare_func;
	gpointer _compare_func_target;
	GDestroyNotify _compare_func_target_destroy_notify;
};

struct _GeePriorityQueueNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeePriorityQueueNodePrivate * priv;
	gpointer data;
	GeePriorityQueueNode* parent;
	gint type1_children_count;
	GeePriorityQueueType1Node* type1_children_head;
	GeePriorityQueueType1Node* type1_children_tail;
	GeePriorityQueueNode* iter_prev;
	GeePriorityQueueNode* iter_next;
	gboolean pending_drop;
};

struct _GeePriorityQueueNodeClass {
	GTypeClass parent_class;
	void (*finalize) (GeePriorityQueueNode *self);
};

struct _GeePriorityQueueType1Node {
	GeePriorityQueueNode parent_instance;
	GeePriorityQueueType1NodePrivate * priv;
	guint lost;
	GeePriorityQueueType1Node* brothers_prev;
	GeePriorityQueueType1Node* brothers_next;
	GeePriorityQueueType2Node* type2_child;
	GeePriorityQueueType1Node* ll_prev;
	GeePriorityQueueType1Node* ll_next;
	GeePriorityQueueNodePair* pair;
};

struct _GeePriorityQueueType1NodeClass {
	GeePriorityQueueNodeClass parent_class;
};

struct _GeePriorityQueueNodePair {
	GeePriorityQueueNodePair* lp_prev;
	GeePriorityQueueNodePair* lp_next;
	GeePriorityQueueType1Node* node1;
	GeePriorityQueueType1Node* node2;
};

struct _GeePriorityQueueNodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeePriorityQueueParamSpecNode {
	GParamSpec parent_instance;
};

struct _GeePriorityQueueType1NodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeePriorityQueueType2Node {
	GeePriorityQueueNode parent_instance;
	GeePriorityQueueType2NodePrivate * priv;
};

struct _GeePriorityQueueType2NodeClass {
	GeePriorityQueueNodeClass parent_class;
};

struct _GeePriorityQueueType2NodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeePriorityQueueDummyNode {
	GeePriorityQueueNode parent_instance;
	GeePriorityQueueDummyNodePrivate * priv;
};

struct _GeePriorityQueueDummyNodeClass {
	GeePriorityQueueNodeClass parent_class;
};

struct _GeePriorityQueueDummyNodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeePriorityQueueIterator {
	GObject parent_instance;
	GeePriorityQueueIteratorPrivate * priv;
	GeePriorityQueue* queue;
	GeePriorityQueueNode* position;
	GeePriorityQueueNode* previous;
	gint stamp;
};

struct _GeePriorityQueueIteratorClass {
	GObjectClass parent_class;
};

struct _GeePriorityQueueIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

static gint GeePriorityQueue_private_offset;
static gpointer gee_priority_queue_parent_class = NULL;
static gint GeePriorityQueueNode_private_offset;
static gpointer gee_priority_queue_node_parent_class = NULL;
static gint GeePriorityQueueType1Node_private_offset;
static gpointer gee_priority_queue_type1_node_parent_class = NULL;
static gint GeePriorityQueueType2Node_private_offset;
static gpointer gee_priority_queue_type2_node_parent_class = NULL;
static gint GeePriorityQueueDummyNode_private_offset;
static gpointer gee_priority_queue_dummy_node_parent_class = NULL;
static gint GeePriorityQueueIterator_private_offset;
static gpointer gee_priority_queue_iterator_parent_class = NULL;
static GeeTraversableIface * gee_priority_queue_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface * gee_priority_queue_iterator_gee_iterator_parent_iface = NULL;

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void gee_value_set_lazy (GValue* value,
                         gpointer v_object);
void gee_value_take_lazy (GValue* value,
                          gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
GType gee_abstract_queue_get_type (void) G_GNUC_CONST;
GType gee_priority_queue_get_type (void) G_GNUC_CONST;
static gpointer gee_priority_queue_node_ref (gpointer instance);
static void gee_priority_queue_node_unref (gpointer instance);
static GParamSpec* gee_priority_queue_param_spec_node (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags) G_GNUC_UNUSED;
static void gee_priority_queue_value_set_node (GValue* value,
                                        gpointer v_object) G_GNUC_UNUSED;
static void gee_priority_queue_value_take_node (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED;
static gpointer gee_priority_queue_value_get_node (const GValue* value) G_GNUC_UNUSED;
static GType gee_priority_queue_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType gee_priority_queue_type1_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType gee_priority_queue_type2_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void gee_priority_queue_node_pair_free (GeePriorityQueueNodePair * self);
GeePriorityQueue* gee_priority_queue_new (GType g_type,
                                          GBoxedCopyFunc g_dup_func,
                                          GDestroyNotify g_destroy_func,
                                          GCompareDataFunc compare_func,
                                          gpointer compare_func_target,
                                          GDestroyNotify compare_func_target_destroy_notify);
GeePriorityQueue* gee_priority_queue_construct (GType object_type,
                                                GType g_type,
                                                GBoxedCopyFunc g_dup_func,
                                                GDestroyNotify g_destroy_func,
                                                GCompareDataFunc compare_func,
                                                gpointer compare_func_target,
                                                GDestroyNotify compare_func_target_destroy_notify);
GeeAbstractQueue* gee_abstract_queue_construct (GType object_type,
                                                GType g_type,
                                                GBoxedCopyFunc g_dup_func,
                                                GDestroyNotify g_destroy_func);
GCompareDataFunc gee_functions_get_compare_func_for (GType t,
                                                     gpointer* result_target,
                                                     GDestroyNotify* result_target_destroy_notify);
gboolean gee_priority_queue_offer (GeePriorityQueue* self,
                                   gconstpointer element);
static GeePriorityQueueType1Node* gee_priority_queue_type1_node_new (GType g_type,
                                                              GBoxedCopyFunc g_dup_func,
                                                              GDestroyNotify g_destroy_func,
                                                              gconstpointer data,
                                                              GeePriorityQueueNode* * head,
                                                              GeePriorityQueueNode* * tail);
static GeePriorityQueueType1Node* gee_priority_queue_type1_node_construct (GType object_type,
                                                                    GType g_type,
                                                                    GBoxedCopyFunc g_dup_func,
                                                                    GDestroyNotify g_destroy_func,
                                                                    gconstpointer data,
                                                                    GeePriorityQueueNode* * head,
                                                                    GeePriorityQueueNode* * tail);
static GeePriorityQueueType2Node* gee_priority_queue_type2_node_new (GType g_type,
                                                              GBoxedCopyFunc g_dup_func,
                                                              GDestroyNotify g_destroy_func,
                                                              gconstpointer data,
                                                              GeePriorityQueueNode* * head,
                                                              GeePriorityQueueNode* * tail);
static GeePriorityQueueType2Node* gee_priority_queue_type2_node_construct (GType object_type,
                                                                    GType g_type,
                                                                    GBoxedCopyFunc g_dup_func,
                                                                    GDestroyNotify g_destroy_func,
                                                                    gconstpointer data,
                                                                    GeePriorityQueueNode* * head,
                                                                    GeePriorityQueueNode* * tail);
static inline gint _gee_priority_queue_compare (GeePriorityQueue* self,
                                  GeePriorityQueueNode* node1,
                                  GeePriorityQueueNode* node2);
static inline void _gee_priority_queue_swap_data (GeePriorityQueue* self,
                                    GeePriorityQueueNode* node1,
                                    GeePriorityQueueNode* node2);
static void _gee_priority_queue_add (GeePriorityQueue* self,
                              GeePriorityQueueType1Node* n);
static gpointer gee_priority_queue_real_peek (GeeAbstractQueue* base);
static gpointer gee_priority_queue_real_poll (GeeAbstractQueue* base);
static inline void _gee_priority_queue_move_data (GeePriorityQueue* self,
                                    GeePriorityQueueNode* target,
                                    GeePriorityQueueNode* source);
static void _gee_priority_queue_remove_type2_node (GeePriorityQueue* self,
                                            GeePriorityQueueType2Node* node,
                                            gboolean with_iteration);
static void _gee_priority_queue_remove_type1_node (GeePriorityQueue* self,
                                            GeePriorityQueueType1Node* node,
                                            gboolean with_iteration);
static void _gee_priority_queue_add_in_r_prime (GeePriorityQueue* self,
                                         GeePriorityQueueType1Node* node);
static void _gee_priority_queue_adjust (GeePriorityQueue* self,
                                 GeePriorityQueueType1Node* p1,
                                 GeePriorityQueueType1Node* p2);
static gboolean _gee_priority_queue_check_linkable (GeePriorityQueue* self);
gint gee_priority_queue_drain (GeePriorityQueue* self,
                               GeeCollection* recipient,
                               gint amount);
gboolean gee_collection_add (GeeCollection* self,
                             gconstpointer item);
gpointer gee_abstract_queue_poll (GeeAbstractQueue* self);
static gboolean gee_priority_queue_real_contains (GeeAbstractCollection* base,
                                           gconstpointer item);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
GCompareDataFunc gee_priority_queue_get_compare_func (GeePriorityQueue* self,
                                                      gpointer* result_target);
static gboolean gee_priority_queue_real_add (GeeAbstractCollection* base,
                                      gconstpointer item);
static gboolean gee_priority_queue_real_remove (GeeAbstractCollection* base,
                                         gconstpointer item);
static GType gee_priority_queue_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeePriorityQueueIterator* gee_priority_queue_iterator_new (GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func,
                                                           GeePriorityQueue* queue);
static GeePriorityQueueIterator* gee_priority_queue_iterator_construct (GType object_type,
                                                                 GType g_type,
                                                                 GBoxedCopyFunc g_dup_func,
                                                                 GDestroyNotify g_destroy_func,
                                                                 GeePriorityQueue* queue);
void gee_iterator_remove (GeeIterator* self);
static void gee_priority_queue_real_clear (GeeAbstractCollection* base);
static GeeIterator* gee_priority_queue_real_iterator (GeeAbstractCollection* base);
static gboolean gee_priority_queue_real_foreach (GeeAbstractCollection* base,
                                          GeeForallFunc f,
                                          gpointer f_target);
static void _gee_priority_queue_link (GeePriorityQueue* self,
                               GeePriorityQueueType1Node* ri,
                               GeePriorityQueueType1Node* rj);
static inline gint gee_priority_queue_node_degree (GeePriorityQueueNode* self);
static void _gee_priority_queue_add_to (GeePriorityQueue* self,
                                 GeePriorityQueueType1Node* node,
                                 GeePriorityQueueType1Node* parent);
static GeePriorityQueueNode* _gee_priority_queue_re_insert (GeePriorityQueue* self,
                                                     GeePriorityQueueType1Node* n);
static void _gee_priority_queue_delete (GeePriorityQueue* self,
                                 GeePriorityQueueNode* n);
static void _gee_priority_queue_decrease_key (GeePriorityQueue* self,
                                       GeePriorityQueueNode* n);
static inline void gee_priority_queue_type1_node_add (GeePriorityQueueType1Node* self,
                                        GeePriorityQueueType1Node* node);
static GeePriorityQueueNodePair* gee_priority_queue_node_pair_new (GeePriorityQueueType1Node* node1,
                                                            GeePriorityQueueType1Node* node2);
static void _gee_priority_queue_updated_degree (GeePriorityQueue* self,
                                         GeePriorityQueueType1Node* node,
                                         gboolean child_removed);
static inline void gee_priority_queue_type1_node_remove (GeePriorityQueueType1Node* self);
static void gee_priority_queue_set_compare_func (GeePriorityQueue* self,
                                          GCompareDataFunc value,
                                          gpointer value_target);
#define GEE_QUEUE_UNBOUNDED_CAPACITY -1
static GeePriorityQueueNode* gee_priority_queue_node_construct (GType object_type,
                                                         GType g_type,
                                                         GBoxedCopyFunc g_dup_func,
                                                         GDestroyNotify g_destroy_func,
                                                         gconstpointer data,
                                                         GeePriorityQueueNode* * head,
                                                         GeePriorityQueueNode* * tail);
static void gee_priority_queue_node_finalize (GeePriorityQueueNode * obj);
static void gee_priority_queue_type1_node_finalize (GeePriorityQueueNode * obj);
static GType gee_priority_queue_dummy_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeePriorityQueueDummyNode* gee_priority_queue_dummy_node_new (GType g_type,
                                                              GBoxedCopyFunc g_dup_func,
                                                              GDestroyNotify g_destroy_func,
                                                              GeePriorityQueueNode* * prev_next,
                                                              GeePriorityQueueNode* * next_prev,
                                                              GeePriorityQueueNode* iter_prev,
                                                              GeePriorityQueueNode* iter_next);
static GeePriorityQueueDummyNode* gee_priority_queue_dummy_node_construct (GType object_type,
                                                                    GType g_type,
                                                                    GBoxedCopyFunc g_dup_func,
                                                                    GDestroyNotify g_destroy_func,
                                                                    GeePriorityQueueNode* * prev_next,
                                                                    GeePriorityQueueNode* * next_prev,
                                                                    GeePriorityQueueNode* iter_prev,
                                                                    GeePriorityQueueNode* iter_next);
static void gee_priority_queue_node_pair_instance_init (GeePriorityQueueNodePair * self);
static GeePriorityQueueIterator* gee_priority_queue_iterator_new_from_iterator (GType g_type,
                                                                         GBoxedCopyFunc g_dup_func,
                                                                         GDestroyNotify g_destroy_func,
                                                                         GeePriorityQueueIterator* iter);
static GeePriorityQueueIterator* gee_priority_queue_iterator_construct_from_iterator (GType object_type,
                                                                               GType g_type,
                                                                               GBoxedCopyFunc g_dup_func,
                                                                               GDestroyNotify g_destroy_func,
                                                                               GeePriorityQueueIterator* iter);
static gboolean gee_priority_queue_iterator_real_next (GeeIterator* base);
static inline GeePriorityQueueNode* _gee_priority_queue_iterator_get_next_node (GeePriorityQueueIterator* self);
static gboolean gee_priority_queue_iterator_real_has_next (GeeIterator* base);
static gpointer gee_priority_queue_iterator_real_get (GeeIterator* base);
static void gee_priority_queue_iterator_real_remove (GeeIterator* base);
static gboolean gee_priority_queue_iterator_real_foreach (GeeTraversable* base,
                                                   GeeForallFunc f,
                                                   gpointer f_target);
static GeeIterator** gee_priority_queue_iterator_real_tee (GeeTraversable* base,
                                                    guint forks,
                                                    gint* result_length1);
static void gee_priority_queue_iterator_finalize (GObject * obj);
gboolean gee_iterator_get_read_only (GeeIterator* self);
gboolean gee_iterator_get_valid (GeeIterator* self);
static void _vala_gee_priority_queue_iterator_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_gee_priority_queue_iterator_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void gee_priority_queue_finalize (GObject * obj);
gint gee_abstract_queue_get_capacity (GeeAbstractQueue* self);
gint gee_abstract_queue_get_remaining_capacity (GeeAbstractQueue* self);
gboolean gee_abstract_queue_get_is_full (GeeAbstractQueue* self);
gboolean gee_abstract_collection_get_read_only (GeeAbstractCollection* self);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static void _vala_gee_priority_queue_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_gee_priority_queue_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gee_priority_queue_get_instance_private (GeePriorityQueue* self)
{
	return G_STRUCT_MEMBER_P (self, GeePriorityQueue_private_offset);
}

/**
 * Constructs a new, empty priority queue.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param compare_func an optional element comparator function
 */
GeePriorityQueue*
gee_priority_queue_construct (GType object_type,
                              GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func,
                              GCompareDataFunc compare_func,
                              gpointer compare_func_target,
                              GDestroyNotify compare_func_target_destroy_notify)
{
	GeePriorityQueue * self = NULL;
	GCompareDataFunc _tmp3_;
	gpointer _tmp3__target;
	GDestroyNotify _tmp3__target_destroy_notify;
	GeePriorityQueueType1Node** _tmp4_;
	self = (GeePriorityQueue*) gee_abstract_queue_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (compare_func == NULL) {
		void* _tmp0_ = NULL;
		GDestroyNotify _tmp1_ = NULL;
		GCompareDataFunc _tmp2_;
		_tmp2_ = gee_functions_get_compare_func_for (g_type, &_tmp0_, &_tmp1_);
		(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
		compare_func = NULL;
		compare_func_target = NULL;
		compare_func_target_destroy_notify = NULL;
		compare_func = _tmp2_;
		compare_func_target = _tmp0_;
		compare_func_target_destroy_notify = _tmp1_;
	}
	_tmp3_ = compare_func;
	_tmp3__target = compare_func_target;
	_tmp3__target_destroy_notify = compare_func_target_destroy_notify;
	compare_func = NULL;
	compare_func_target = NULL;
	compare_func_target_destroy_notify = NULL;
	(self->priv->_compare_func_target_destroy_notify == NULL) ? NULL : (self->priv->_compare_func_target_destroy_notify (self->priv->_compare_func_target), NULL);
	self->priv->_compare_func = NULL;
	self->priv->_compare_func_target = NULL;
	self->priv->_compare_func_target_destroy_notify = NULL;
	self->priv->_compare_func = _tmp3_;
	self->priv->_compare_func_target = _tmp3__target;
	self->priv->_compare_func_target_destroy_notify = _tmp3__target_destroy_notify;
	_tmp4_ = g_new0 (GeePriorityQueueType1Node*, 0 + 1);
	self->priv->_a = (_vala_array_free (self->priv->_a, self->priv->_a_length1, (GDestroyNotify) gee_priority_queue_node_unref), NULL);
	self->priv->_a = _tmp4_;
	self->priv->_a_length1 = 0;
	self->priv->__a_size_ = self->priv->_a_length1;
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
	compare_func = NULL;
	compare_func_target = NULL;
	compare_func_target_destroy_notify = NULL;
	return self;
}

GeePriorityQueue*
gee_priority_queue_new (GType g_type,
                        GBoxedCopyFunc g_dup_func,
                        GDestroyNotify g_destroy_func,
                        GCompareDataFunc compare_func,
                        gpointer compare_func_target,
                        GDestroyNotify compare_func_target_destroy_notify)
{
	return gee_priority_queue_construct (GEE_TYPE_PRIORITY_QUEUE, g_type, g_dup_func, g_destroy_func, compare_func, compare_func_target, compare_func_target_destroy_notify);
}

/**
 * {@inheritDoc}
 */
static gpointer
_gee_priority_queue_node_ref0 (gpointer self)
{
	return self ? gee_priority_queue_node_ref (self) : NULL;
}

gboolean
gee_priority_queue_offer (GeePriorityQueue* self,
                          gconstpointer element)
{
	gboolean result = FALSE;
	GeePriorityQueueType1Node* _tmp0_;
	gint _tmp17_;
	gint _tmp18_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_r;
	if (_tmp0_ == NULL) {
		GeePriorityQueueType1Node* _tmp1_;
		GeePriorityQueueType1Node* _tmp2_;
		GeePriorityQueueType1Node* _tmp3_;
		_tmp1_ = gee_priority_queue_type1_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, element, &self->priv->_iter_head, &self->priv->_iter_tail);
		_gee_priority_queue_node_unref0 (self->priv->_r);
		self->priv->_r = _tmp1_;
		_tmp2_ = self->priv->_r;
		_tmp3_ = _gee_priority_queue_node_ref0 (_tmp2_);
		_gee_priority_queue_node_unref0 (self->priv->_p);
		self->priv->_p = _tmp3_;
	} else {
		GeePriorityQueueType2Node* _tmp4_;
		_tmp4_ = self->priv->_r_prime;
		if (_tmp4_ == NULL) {
			GeePriorityQueueType2Node* _tmp5_;
			GeePriorityQueueType2Node* _tmp6_;
			GeePriorityQueueType1Node* _tmp7_;
			GeePriorityQueueType1Node* _tmp8_;
			GeePriorityQueueType2Node* _tmp9_;
			GeePriorityQueueType2Node* _tmp10_;
			GeePriorityQueueType2Node* _tmp11_;
			GeePriorityQueueType1Node* _tmp12_;
			_tmp5_ = gee_priority_queue_type2_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, element, &self->priv->_iter_head, &self->priv->_iter_tail);
			_gee_priority_queue_node_unref0 (self->priv->_r_prime);
			self->priv->_r_prime = _tmp5_;
			_tmp6_ = self->priv->_r_prime;
			_tmp7_ = self->priv->_r;
			((GeePriorityQueueNode*) _tmp6_)->parent = (GeePriorityQueueNode*) _tmp7_;
			_tmp8_ = self->priv->_r;
			_tmp9_ = self->priv->_r_prime;
			_tmp10_ = _gee_priority_queue_node_ref0 (_tmp9_);
			_gee_priority_queue_node_unref0 (_tmp8_->type2_child);
			_tmp8_->type2_child = _tmp10_;
			_tmp11_ = self->priv->_r_prime;
			_tmp12_ = self->priv->_r;
			if (_gee_priority_queue_compare (self, (GeePriorityQueueNode*) _tmp11_, (GeePriorityQueueNode*) _tmp12_) < 0) {
				GeePriorityQueueType2Node* _tmp13_;
				GeePriorityQueueType1Node* _tmp14_;
				_tmp13_ = self->priv->_r_prime;
				_tmp14_ = self->priv->_r;
				_gee_priority_queue_swap_data (self, (GeePriorityQueueNode*) _tmp13_, (GeePriorityQueueNode*) _tmp14_);
			}
		} else {
			GeePriorityQueueType1Node* node = NULL;
			GeePriorityQueueType1Node* _tmp15_;
			GeePriorityQueueType1Node* _tmp16_;
			_tmp15_ = gee_priority_queue_type1_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, element, &self->priv->_iter_head, &self->priv->_iter_tail);
			node = _tmp15_;
			_tmp16_ = node;
			_gee_priority_queue_add (self, _tmp16_);
			_gee_priority_queue_node_unref0 (node);
		}
	}
	_tmp17_ = self->priv->_stamp;
	self->priv->_stamp = _tmp17_ + 1;
	_tmp18_ = self->priv->_size;
	self->priv->_size = _tmp18_ + 1;
	result = TRUE;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_priority_queue_real_peek (GeeAbstractQueue* base)
{
	GeePriorityQueue * self;
	gpointer result = NULL;
	GeePriorityQueueType1Node* _tmp0_;
	GeePriorityQueueType1Node* _tmp1_;
	gconstpointer _tmp2_;
	gpointer _tmp3_;
	self = (GeePriorityQueue*) base;
	_tmp0_ = self->priv->_r;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_r;
	_tmp2_ = ((GeePriorityQueueNode*) _tmp1_)->data;
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
	result = _tmp3_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_priority_queue_real_poll (GeeAbstractQueue* base)
{
	GeePriorityQueue * self;
	gpointer result = NULL;
	GeePriorityQueueType1Node* _tmp0_;
	gpointer min = NULL;
	GeePriorityQueueType1Node* _tmp1_;
	gconstpointer _tmp2_;
	gpointer _tmp3_;
	GeePriorityQueueType1Node* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GeePriorityQueueType2Node* _tmp7_;
	GeePriorityQueueType1Node* _tmp28_;
	GeePriorityQueueType2Node* _tmp29_;
	GeePriorityQueueType2Node* _tmp30_;
	GeePriorityQueueType1Node* _tmp31_;
	GeePriorityQueueType1Node* r_second = NULL;
	GeePriorityQueueType1Node* node = NULL;
	GeePriorityQueueType2Node* _tmp33_;
	GeePriorityQueueType1Node* _tmp34_;
	GeePriorityQueueType1Node* _tmp35_;
	GeePriorityQueueType2Node* _tmp46_;
	GeePriorityQueueType1Node* _tmp47_;
	GeePriorityQueueType1Node* _tmp48_;
	GeePriorityQueueType1Node* _tmp49_;
	GeePriorityQueueType1Node* _tmp50_;
	GeePriorityQueueType1Node* _tmp51_;
	GeePriorityQueueType1Node* _tmp60_;
	GeePriorityQueueType1Node* _tmp61_;
	self = (GeePriorityQueue*) base;
	_tmp0_ = self->priv->_r;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_r;
	_tmp2_ = ((GeePriorityQueueNode*) _tmp1_)->data;
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
	min = _tmp3_;
	_tmp4_ = self->priv->_r;
	((GeePriorityQueueNode*) _tmp4_)->pending_drop = FALSE;
	_tmp5_ = self->priv->_stamp;
	self->priv->_stamp = _tmp5_ + 1;
	_tmp6_ = self->priv->_size;
	self->priv->_size = _tmp6_ - 1;
	_tmp7_ = self->priv->_r_prime;
	if (_tmp7_ == NULL) {
		GeePriorityQueueType1Node* _tmp8_;
		GeePriorityQueueNode* _tmp9_;
		GeePriorityQueueType1Node* _tmp14_;
		GeePriorityQueueNode* _tmp15_;
		GeePriorityQueueNode* _tmp20_;
		GeePriorityQueueType1Node* _tmp21_;
		GeePriorityQueueNode* _tmp24_;
		GeePriorityQueueType1Node* _tmp25_;
		_tmp8_ = self->priv->_r;
		_tmp9_ = ((GeePriorityQueueNode*) _tmp8_)->iter_next;
		if (_tmp9_ != NULL) {
			GeePriorityQueueType1Node* _tmp10_;
			GeePriorityQueueNode* _tmp11_;
			GeePriorityQueueType1Node* _tmp12_;
			GeePriorityQueueNode* _tmp13_;
			_tmp10_ = self->priv->_r;
			_tmp11_ = ((GeePriorityQueueNode*) _tmp10_)->iter_next;
			_tmp12_ = self->priv->_r;
			_tmp13_ = ((GeePriorityQueueNode*) _tmp12_)->iter_prev;
			_tmp11_->iter_prev = _tmp13_;
		}
		_tmp14_ = self->priv->_r;
		_tmp15_ = ((GeePriorityQueueNode*) _tmp14_)->iter_prev;
		if (_tmp15_ != NULL) {
			GeePriorityQueueType1Node* _tmp16_;
			GeePriorityQueueNode* _tmp17_;
			GeePriorityQueueType1Node* _tmp18_;
			GeePriorityQueueNode* _tmp19_;
			_tmp16_ = self->priv->_r;
			_tmp17_ = ((GeePriorityQueueNode*) _tmp16_)->iter_prev;
			_tmp18_ = self->priv->_r;
			_tmp19_ = ((GeePriorityQueueNode*) _tmp18_)->iter_next;
			_tmp17_->iter_next = _tmp19_;
		}
		_tmp20_ = self->priv->_iter_head;
		_tmp21_ = self->priv->_r;
		if (_tmp20_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode)) {
			GeePriorityQueueType1Node* _tmp22_;
			GeePriorityQueueNode* _tmp23_;
			_tmp22_ = self->priv->_r;
			_tmp23_ = ((GeePriorityQueueNode*) _tmp22_)->iter_next;
			self->priv->_iter_head = _tmp23_;
		}
		_tmp24_ = self->priv->_iter_tail;
		_tmp25_ = self->priv->_r;
		if (_tmp24_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode)) {
			GeePriorityQueueType1Node* _tmp26_;
			GeePriorityQueueNode* _tmp27_;
			_tmp26_ = self->priv->_r;
			_tmp27_ = ((GeePriorityQueueNode*) _tmp26_)->iter_prev;
			self->priv->_iter_tail = _tmp27_;
		}
		_gee_priority_queue_node_unref0 (self->priv->_r);
		self->priv->_r = NULL;
		_gee_priority_queue_node_unref0 (self->priv->_p);
		self->priv->_p = NULL;
		result = min;
		return result;
	}
	_tmp28_ = self->priv->_r;
	_tmp29_ = self->priv->_r_prime;
	_gee_priority_queue_move_data (self, (GeePriorityQueueNode*) _tmp28_, (GeePriorityQueueNode*) _tmp29_);
	_tmp30_ = self->priv->_r_prime;
	_tmp31_ = ((GeePriorityQueueNode*) _tmp30_)->type1_children_head;
	if (_tmp31_ == NULL) {
		GeePriorityQueueType2Node* _tmp32_;
		_tmp32_ = self->priv->_r_prime;
		_gee_priority_queue_remove_type2_node (self, _tmp32_, TRUE);
		_gee_priority_queue_node_unref0 (self->priv->_r_prime);
		self->priv->_r_prime = NULL;
		result = min;
		return result;
	}
	r_second = NULL;
	_tmp33_ = self->priv->_r_prime;
	_tmp34_ = ((GeePriorityQueueNode*) _tmp33_)->type1_children_head;
	_tmp35_ = _gee_priority_queue_node_ref0 (_tmp34_);
	node = _tmp35_;
	while (TRUE) {
		GeePriorityQueueType1Node* _tmp36_;
		gboolean _tmp37_ = FALSE;
		GeePriorityQueueType1Node* _tmp38_;
		GeePriorityQueueType1Node* _tmp43_;
		GeePriorityQueueType1Node* _tmp44_;
		GeePriorityQueueType1Node* _tmp45_;
		_tmp36_ = node;
		if (!(_tmp36_ != NULL)) {
			break;
		}
		_tmp38_ = r_second;
		if (_tmp38_ == NULL) {
			_tmp37_ = TRUE;
		} else {
			GeePriorityQueueType1Node* _tmp39_;
			GeePriorityQueueType1Node* _tmp40_;
			_tmp39_ = node;
			_tmp40_ = r_second;
			_tmp37_ = _gee_priority_queue_compare (self, (GeePriorityQueueNode*) _tmp39_, (GeePriorityQueueNode*) _tmp40_) < 0;
		}
		if (_tmp37_) {
			GeePriorityQueueType1Node* _tmp41_;
			GeePriorityQueueType1Node* _tmp42_;
			_tmp41_ = node;
			_tmp42_ = _gee_priority_queue_node_ref0 (_tmp41_);
			_gee_priority_queue_node_unref0 (r_second);
			r_second = _tmp42_;
		}
		_tmp43_ = node;
		_tmp44_ = _tmp43_->brothers_next;
		_tmp45_ = _gee_priority_queue_node_ref0 (_tmp44_);
		_gee_priority_queue_node_unref0 (node);
		node = _tmp45_;
	}
	_tmp46_ = self->priv->_r_prime;
	_tmp47_ = r_second;
	_gee_priority_queue_move_data (self, (GeePriorityQueueNode*) _tmp46_, (GeePriorityQueueNode*) _tmp47_);
	_tmp48_ = r_second;
	_gee_priority_queue_remove_type1_node (self, _tmp48_, TRUE);
	_tmp49_ = r_second;
	_tmp50_ = ((GeePriorityQueueNode*) _tmp49_)->type1_children_head;
	_tmp51_ = _gee_priority_queue_node_ref0 (_tmp50_);
	_gee_priority_queue_node_unref0 (node);
	node = _tmp51_;
	while (TRUE) {
		GeePriorityQueueType1Node* _tmp52_;
		GeePriorityQueueType1Node* next = NULL;
		GeePriorityQueueType1Node* _tmp53_;
		GeePriorityQueueType1Node* _tmp54_;
		GeePriorityQueueType1Node* _tmp55_;
		GeePriorityQueueType1Node* _tmp56_;
		GeePriorityQueueType1Node* _tmp57_;
		GeePriorityQueueType1Node* _tmp58_;
		GeePriorityQueueType1Node* _tmp59_;
		_tmp52_ = node;
		if (!(_tmp52_ != NULL)) {
			break;
		}
		_tmp53_ = node;
		_tmp54_ = _tmp53_->brothers_next;
		_tmp55_ = _gee_priority_queue_node_ref0 (_tmp54_);
		next = _tmp55_;
		_tmp56_ = node;
		_gee_priority_queue_remove_type1_node (self, _tmp56_, FALSE);
		_tmp57_ = node;
		_gee_priority_queue_add_in_r_prime (self, _tmp57_);
		_tmp58_ = next;
		_tmp59_ = _gee_priority_queue_node_ref0 (_tmp58_);
		_gee_priority_queue_node_unref0 (node);
		node = _tmp59_;
		_gee_priority_queue_node_unref0 (next);
	}
	_tmp60_ = self->priv->_p;
	_tmp61_ = self->priv->_p;
	_gee_priority_queue_adjust (self, _tmp60_, _tmp61_);
	while (TRUE) {
		if (!_gee_priority_queue_check_linkable (self)) {
			break;
		}
	}
	result = min;
	_gee_priority_queue_node_unref0 (node);
	_gee_priority_queue_node_unref0 (r_second);
	return result;
}

/**
 * {@inheritDoc}
 */
gint
gee_priority_queue_drain (GeePriorityQueue* self,
                          GeeCollection* recipient,
                          gint amount)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (recipient != NULL, 0);
	if (amount == -1) {
		amount = self->priv->_size;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gpointer _tmp2_;
				gpointer _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < amount)) {
					break;
				}
				if (self->priv->_size == 0) {
					result = i;
					return result;
				}
				_tmp2_ = gee_abstract_queue_poll ((GeeAbstractQueue*) self);
				_tmp3_ = _tmp2_;
				gee_collection_add (recipient, _tmp3_);
				((_tmp3_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp3_ = (self->priv->g_destroy_func (_tmp3_), NULL));
			}
		}
	}
	result = amount;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_priority_queue_real_contains (GeeAbstractCollection* base,
                                  gconstpointer item)
{
	GeePriorityQueue * self;
	gboolean result = FALSE;
	self = (GeePriorityQueue*) base;
	{
		GeeIterator* _an_item_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
		_an_item_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			gpointer an_item = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GCompareDataFunc _tmp4_;
			gpointer _tmp4__target;
			GCompareDataFunc _tmp5_;
			gpointer _tmp5__target;
			gconstpointer _tmp6_;
			_tmp1_ = _an_item_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _an_item_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			an_item = _tmp3_;
			_tmp4_ = gee_priority_queue_get_compare_func (self, &_tmp4__target);
			_tmp5_ = _tmp4_;
			_tmp5__target = _tmp4__target;
			_tmp6_ = an_item;
			if (_tmp5_ (item, _tmp6_, _tmp5__target) == 0) {
				result = TRUE;
				((an_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (an_item = (self->priv->g_destroy_func (an_item), NULL));
				_g_object_unref0 (_an_item_it);
				return result;
			}
			((an_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (an_item = (self->priv->g_destroy_func (an_item), NULL));
		}
		_g_object_unref0 (_an_item_it);
	}
	result = FALSE;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_priority_queue_real_add (GeeAbstractCollection* base,
                             gconstpointer item)
{
	GeePriorityQueue * self;
	gboolean result = FALSE;
	self = (GeePriorityQueue*) base;
	result = gee_priority_queue_offer (self, item);
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_priority_queue_real_remove (GeeAbstractCollection* base,
                                gconstpointer item)
{
	GeePriorityQueue * self;
	gboolean result = FALSE;
	GeePriorityQueueIterator* iterator = NULL;
	GeePriorityQueueIterator* _tmp0_;
	self = (GeePriorityQueue*) base;
	_tmp0_ = gee_priority_queue_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	iterator = _tmp0_;
	while (TRUE) {
		GeePriorityQueueIterator* _tmp1_;
		gpointer an_item = NULL;
		GeePriorityQueueIterator* _tmp2_;
		gpointer _tmp3_;
		GCompareDataFunc _tmp4_;
		gpointer _tmp4__target;
		GCompareDataFunc _tmp5_;
		gpointer _tmp5__target;
		gconstpointer _tmp6_;
		_tmp1_ = iterator;
		if (!gee_iterator_next ((GeeIterator*) _tmp1_)) {
			break;
		}
		_tmp2_ = iterator;
		_tmp3_ = gee_iterator_get ((GeeIterator*) _tmp2_);
		an_item = _tmp3_;
		_tmp4_ = gee_priority_queue_get_compare_func (self, &_tmp4__target);
		_tmp5_ = _tmp4_;
		_tmp5__target = _tmp4__target;
		_tmp6_ = an_item;
		if (_tmp5_ (item, _tmp6_, _tmp5__target) == 0) {
			GeePriorityQueueIterator* _tmp7_;
			_tmp7_ = iterator;
			gee_iterator_remove ((GeeIterator*) _tmp7_);
			result = TRUE;
			((an_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (an_item = (self->priv->g_destroy_func (an_item), NULL));
			_g_object_unref0 (iterator);
			return result;
		}
		((an_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (an_item = (self->priv->g_destroy_func (an_item), NULL));
	}
	result = FALSE;
	_g_object_unref0 (iterator);
	return result;
}

/**
 * {@inheritDoc}
 */
static void
gee_priority_queue_real_clear (GeeAbstractCollection* base)
{
	GeePriorityQueue * self;
	GeePriorityQueueType1Node** _tmp0_;
	gboolean* _tmp1_;
	self = (GeePriorityQueue*) base;
	self->priv->_size = 0;
	_gee_priority_queue_node_unref0 (self->priv->_r);
	self->priv->_r = NULL;
	_gee_priority_queue_node_unref0 (self->priv->_r_prime);
	self->priv->_r_prime = NULL;
	_gee_priority_queue_node_unref0 (self->priv->_lm_head);
	self->priv->_lm_head = NULL;
	_gee_priority_queue_node_unref0 (self->priv->_lm_tail);
	self->priv->_lm_tail = NULL;
	_gee_priority_queue_node_unref0 (self->priv->_p);
	self->priv->_p = NULL;
	_tmp0_ = g_new0 (GeePriorityQueueType1Node*, 0 + 1);
	self->priv->_a = (_vala_array_free (self->priv->_a, self->priv->_a_length1, (GDestroyNotify) gee_priority_queue_node_unref), NULL);
	self->priv->_a = _tmp0_;
	self->priv->_a_length1 = 0;
	self->priv->__a_size_ = self->priv->_a_length1;
	_gee_priority_queue_node_pair_free0 (self->priv->_lp_head);
	self->priv->_lp_head = NULL;
	self->priv->_lp_tail = NULL;
	_tmp1_ = g_new0 (gboolean, 0);
	self->priv->_b = (g_free (self->priv->_b), NULL);
	self->priv->_b = _tmp1_;
	self->priv->_b_length1 = 0;
	self->priv->__b_size_ = self->priv->_b_length1;
	_gee_priority_queue_node_unref0 (self->priv->_ll_head);
	self->priv->_ll_head = NULL;
	_gee_priority_queue_node_unref0 (self->priv->_ll_tail);
	self->priv->_ll_tail = NULL;
	self->priv->_iter_head = NULL;
	self->priv->_iter_tail = NULL;
}

/**
 * {@inheritDoc}
 */
static GeeIterator*
gee_priority_queue_real_iterator (GeeAbstractCollection* base)
{
	GeePriorityQueue * self;
	GeeIterator* result = NULL;
	GeePriorityQueueIterator* _tmp0_;
	self = (GeePriorityQueue*) base;
	_tmp0_ = gee_priority_queue_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeIterator*) _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_priority_queue_real_foreach (GeeAbstractCollection* base,
                                 GeeForallFunc f,
                                 gpointer f_target)
{
	GeePriorityQueue * self;
	gboolean result = FALSE;
	self = (GeePriorityQueue*) base;
	{
		GeePriorityQueueNode* current = NULL;
		GeePriorityQueueNode* _tmp0_;
		_tmp0_ = self->priv->_iter_head;
		current = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeePriorityQueueNode* _tmp4_;
				GeePriorityQueueNode* _tmp5_;
				gconstpointer _tmp6_;
				gpointer _tmp7_;
				if (!_tmp1_) {
					GeePriorityQueueNode* _tmp2_;
					GeePriorityQueueNode* _tmp3_;
					_tmp2_ = current;
					_tmp3_ = _tmp2_->iter_next;
					current = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = current;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = current;
				_tmp6_ = _tmp5_->data;
				_tmp7_ = ((_tmp6_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
				if (!f (_tmp7_, f_target)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static inline gint
_gee_priority_queue_compare (GeePriorityQueue* self,
                             GeePriorityQueueNode* node1,
                             GeePriorityQueueNode* node2)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (node1 != NULL, 0);
	g_return_val_if_fail (node2 != NULL, 0);
	if (node1->pending_drop) {
		result = -1;
		return result;
	} else {
		if (node2->pending_drop) {
			result = 1;
			return result;
		} else {
			GCompareDataFunc _tmp0_;
			gpointer _tmp0__target;
			GCompareDataFunc _tmp1_;
			gpointer _tmp1__target;
			gconstpointer _tmp2_;
			gconstpointer _tmp3_;
			_tmp0_ = gee_priority_queue_get_compare_func (self, &_tmp0__target);
			_tmp1_ = _tmp0_;
			_tmp1__target = _tmp0__target;
			_tmp2_ = node1->data;
			_tmp3_ = node2->data;
			result = _tmp1_ (_tmp2_, _tmp3_, _tmp1__target);
			return result;
		}
	}
}

static inline void
_gee_priority_queue_swap_data (GeePriorityQueue* self,
                               GeePriorityQueueNode* node1,
                               GeePriorityQueueNode* node2)
{
	gpointer temp_data = NULL;
	gpointer _tmp0_;
	gboolean temp_pending_drop = FALSE;
	gpointer _tmp1_;
	gpointer _tmp2_;
	GeePriorityQueueNode* _tmp3_;
	GeePriorityQueueNode* _tmp19_;
	GeePriorityQueueNode* _tmp21_;
	GeePriorityQueueNode* _tmp23_;
	GeePriorityQueueNode* _tmp25_;
	GeePriorityQueueNode* _tmp27_;
	GeePriorityQueueNode* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node1 != NULL);
	g_return_if_fail (node2 != NULL);
	_tmp0_ = node1->data;
	node1->data = NULL;
	temp_data = _tmp0_;
	temp_pending_drop = node1->pending_drop;
	_tmp1_ = node2->data;
	node2->data = NULL;
	((node1->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node1->data = (self->priv->g_destroy_func (node1->data), NULL));
	node1->data = _tmp1_;
	node1->pending_drop = node2->pending_drop;
	_tmp2_ = temp_data;
	temp_data = NULL;
	((node2->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node2->data = (self->priv->g_destroy_func (node2->data), NULL));
	node2->data = _tmp2_;
	node2->pending_drop = temp_pending_drop;
	_tmp3_ = node1->iter_next;
	if (_tmp3_ == node2) {
		GeePriorityQueueNode* temp_iter_prev = NULL;
		GeePriorityQueueNode* _tmp4_;
		GeePriorityQueueNode* temp_iter_next = NULL;
		GeePriorityQueueNode* _tmp5_;
		GeePriorityQueueNode* _tmp6_;
		GeePriorityQueueNode* _tmp7_;
		_tmp4_ = node1->iter_prev;
		temp_iter_prev = _tmp4_;
		_tmp5_ = node2->iter_next;
		temp_iter_next = _tmp5_;
		node1->iter_prev = node2;
		_tmp6_ = temp_iter_next;
		node1->iter_next = _tmp6_;
		_tmp7_ = temp_iter_prev;
		node2->iter_prev = _tmp7_;
		node2->iter_next = node1;
	} else {
		GeePriorityQueueNode* _tmp8_;
		_tmp8_ = node1->iter_prev;
		if (_tmp8_ == node2) {
			GeePriorityQueueNode* temp_iter_prev = NULL;
			GeePriorityQueueNode* _tmp9_;
			GeePriorityQueueNode* temp_iter_next = NULL;
			GeePriorityQueueNode* _tmp10_;
			GeePriorityQueueNode* _tmp11_;
			GeePriorityQueueNode* _tmp12_;
			_tmp9_ = node2->iter_prev;
			temp_iter_prev = _tmp9_;
			_tmp10_ = node1->iter_next;
			temp_iter_next = _tmp10_;
			_tmp11_ = temp_iter_prev;
			node1->iter_prev = _tmp11_;
			node1->iter_next = node2;
			node2->iter_prev = node1;
			_tmp12_ = temp_iter_next;
			node2->iter_next = _tmp12_;
		} else {
			GeePriorityQueueNode* temp_iter_prev = NULL;
			GeePriorityQueueNode* _tmp13_;
			GeePriorityQueueNode* temp_iter_next = NULL;
			GeePriorityQueueNode* _tmp14_;
			GeePriorityQueueNode* _tmp15_;
			GeePriorityQueueNode* _tmp16_;
			GeePriorityQueueNode* _tmp17_;
			GeePriorityQueueNode* _tmp18_;
			_tmp13_ = node1->iter_prev;
			temp_iter_prev = _tmp13_;
			_tmp14_ = node1->iter_next;
			temp_iter_next = _tmp14_;
			_tmp15_ = node2->iter_prev;
			node1->iter_prev = _tmp15_;
			_tmp16_ = node2->iter_next;
			node1->iter_next = _tmp16_;
			_tmp17_ = temp_iter_prev;
			node2->iter_prev = _tmp17_;
			_tmp18_ = temp_iter_next;
			node2->iter_next = _tmp18_;
		}
	}
	_tmp19_ = self->priv->_iter_head;
	if (node2 == _tmp19_) {
		self->priv->_iter_head = node1;
	} else {
		GeePriorityQueueNode* _tmp20_;
		_tmp20_ = self->priv->_iter_head;
		if (node1 == _tmp20_) {
			self->priv->_iter_head = node2;
		}
	}
	_tmp21_ = self->priv->_iter_tail;
	if (node2 == _tmp21_) {
		self->priv->_iter_tail = node1;
	} else {
		GeePriorityQueueNode* _tmp22_;
		_tmp22_ = self->priv->_iter_tail;
		if (node1 == _tmp22_) {
			self->priv->_iter_tail = node2;
		}
	}
	_tmp23_ = node1->iter_prev;
	if (_tmp23_ != NULL) {
		GeePriorityQueueNode* _tmp24_;
		_tmp24_ = node1->iter_prev;
		_tmp24_->iter_next = node1;
	}
	_tmp25_ = node1->iter_next;
	if (_tmp25_ != NULL) {
		GeePriorityQueueNode* _tmp26_;
		_tmp26_ = node1->iter_next;
		_tmp26_->iter_prev = node1;
	}
	_tmp27_ = node2->iter_prev;
	if (_tmp27_ != NULL) {
		GeePriorityQueueNode* _tmp28_;
		_tmp28_ = node2->iter_prev;
		_tmp28_->iter_next = node2;
	}
	_tmp29_ = node2->iter_next;
	if (_tmp29_ != NULL) {
		GeePriorityQueueNode* _tmp30_;
		_tmp30_ = node2->iter_next;
		_tmp30_->iter_prev = node2;
	}
	((temp_data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (temp_data = (self->priv->g_destroy_func (temp_data), NULL));
}

static inline void
_gee_priority_queue_move_data (GeePriorityQueue* self,
                               GeePriorityQueueNode* target,
                               GeePriorityQueueNode* source)
{
	GeePriorityQueueNode* _tmp0_;
	GeePriorityQueueNode* _tmp5_;
	gconstpointer _tmp10_;
	gpointer _tmp11_;
	GeePriorityQueueNode* _tmp12_;
	GeePriorityQueueNode* _tmp13_;
	GeePriorityQueueNode* _tmp14_;
	GeePriorityQueueNode* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = target->iter_next;
	if (_tmp0_ != NULL) {
		GeePriorityQueueNode* _tmp1_;
		GeePriorityQueueNode* _tmp2_;
		_tmp1_ = target->iter_next;
		_tmp2_ = target->iter_prev;
		_tmp1_->iter_prev = _tmp2_;
	} else {
		GeePriorityQueueNode* _tmp3_;
		_tmp3_ = self->priv->_iter_tail;
		if (_tmp3_ == target) {
			GeePriorityQueueNode* _tmp4_;
			_tmp4_ = target->iter_prev;
			self->priv->_iter_tail = _tmp4_;
		}
	}
	_tmp5_ = target->iter_prev;
	if (_tmp5_ != NULL) {
		GeePriorityQueueNode* _tmp6_;
		GeePriorityQueueNode* _tmp7_;
		_tmp6_ = target->iter_prev;
		_tmp7_ = target->iter_next;
		_tmp6_->iter_next = _tmp7_;
	} else {
		GeePriorityQueueNode* _tmp8_;
		_tmp8_ = self->priv->_iter_head;
		if (_tmp8_ == target) {
			GeePriorityQueueNode* _tmp9_;
			_tmp9_ = target->iter_next;
			self->priv->_iter_head = _tmp9_;
		}
	}
	_tmp10_ = source->data;
	_tmp11_ = ((_tmp10_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp10_) : ((gpointer) _tmp10_);
	((target->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (target->data = (self->priv->g_destroy_func (target->data), NULL));
	target->data = _tmp11_;
	target->pending_drop = source->pending_drop;
	_tmp12_ = source->iter_next;
	target->iter_next = _tmp12_;
	_tmp13_ = source->iter_prev;
	target->iter_prev = _tmp13_;
	source->iter_next = NULL;
	source->iter_prev = NULL;
	_tmp14_ = target->iter_next;
	if (_tmp14_ != NULL) {
		GeePriorityQueueNode* _tmp15_;
		_tmp15_ = target->iter_next;
		_tmp15_->iter_prev = target;
	} else {
		GeePriorityQueueNode* _tmp16_;
		_tmp16_ = self->priv->_iter_tail;
		if (_tmp16_ == source) {
			self->priv->_iter_tail = target;
		}
	}
	_tmp17_ = target->iter_prev;
	if (_tmp17_ != NULL) {
		GeePriorityQueueNode* _tmp18_;
		_tmp18_ = target->iter_prev;
		_tmp18_->iter_next = target;
	} else {
		GeePriorityQueueNode* _tmp19_;
		_tmp19_ = self->priv->_iter_head;
		if (_tmp19_ == source) {
			self->priv->_iter_head = target;
		}
	}
}

static void
_gee_priority_queue_link (GeePriorityQueue* self,
                          GeePriorityQueueType1Node* ri,
                          GeePriorityQueueType1Node* rj)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (ri != NULL);
	g_return_if_fail (rj != NULL);
	_vala_assert (gee_priority_queue_node_degree ((GeePriorityQueueNode*) ri) == gee_priority_queue_node_degree ((GeePriorityQueueNode*) rj), "ri.degree () == rj.degree ()");
	_gee_priority_queue_remove_type1_node (self, ri, FALSE);
	_gee_priority_queue_remove_type1_node (self, rj, FALSE);
	if (_gee_priority_queue_compare (self, (GeePriorityQueueNode*) ri, (GeePriorityQueueNode*) rj) > 0) {
		GeePriorityQueueType1Node* temp = NULL;
		GeePriorityQueueType1Node* _tmp0_;
		GeePriorityQueueType1Node* _tmp1_;
		GeePriorityQueueType1Node* _tmp2_;
		GeePriorityQueueType1Node* _tmp3_;
		_tmp0_ = _gee_priority_queue_node_ref0 (ri);
		temp = _tmp0_;
		_tmp1_ = _gee_priority_queue_node_ref0 (rj);
		_gee_priority_queue_node_unref0 (ri);
		ri = _tmp1_;
		_tmp2_ = temp;
		_tmp3_ = _gee_priority_queue_node_ref0 (_tmp2_);
		_gee_priority_queue_node_unref0 (rj);
		rj = _tmp3_;
		_gee_priority_queue_node_unref0 (temp);
	}
	_gee_priority_queue_add_to (self, rj, ri);
	_gee_priority_queue_add_in_r_prime (self, ri);
	_gee_priority_queue_node_unref0 (ri);
	_gee_priority_queue_node_unref0 (rj);
}

static void
_gee_priority_queue_add (GeePriorityQueue* self,
                         GeePriorityQueueType1Node* n)
{
	GeePriorityQueueType2Node* _tmp0_;
	GeePriorityQueueType2Node* _tmp2_;
	GeePriorityQueueType1Node* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	_gee_priority_queue_add_in_r_prime (self, n);
	_tmp0_ = self->priv->_r_prime;
	if (_gee_priority_queue_compare (self, (GeePriorityQueueNode*) n, (GeePriorityQueueNode*) _tmp0_) < 0) {
		GeePriorityQueueType2Node* _tmp1_;
		_tmp1_ = self->priv->_r_prime;
		_gee_priority_queue_swap_data (self, (GeePriorityQueueNode*) n, (GeePriorityQueueNode*) _tmp1_);
	}
	_tmp2_ = self->priv->_r_prime;
	_tmp3_ = self->priv->_r;
	if (_gee_priority_queue_compare (self, (GeePriorityQueueNode*) _tmp2_, (GeePriorityQueueNode*) _tmp3_) < 0) {
		GeePriorityQueueType2Node* _tmp4_;
		GeePriorityQueueType1Node* _tmp5_;
		_tmp4_ = self->priv->_r_prime;
		_tmp5_ = self->priv->_r;
		_gee_priority_queue_swap_data (self, (GeePriorityQueueNode*) _tmp4_, (GeePriorityQueueNode*) _tmp5_);
	}
	_gee_priority_queue_check_linkable (self);
}

static gboolean
_gee_priority_queue_check_linkable (GeePriorityQueue* self)
{
	gboolean result = FALSE;
	GeePriorityQueueNodePair* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_lp_head;
	if (_tmp0_ != NULL) {
		GeePriorityQueueNodePair* pair = NULL;
		GeePriorityQueueNodePair* _tmp1_;
		GeePriorityQueueNodePair* _tmp2_;
		GeePriorityQueueType1Node* _tmp3_;
		GeePriorityQueueType1Node* _tmp4_;
		GeePriorityQueueNodePair* _tmp5_;
		GeePriorityQueueType1Node* _tmp6_;
		GeePriorityQueueType1Node* _tmp7_;
		_tmp1_ = self->priv->_lp_head;
		pair = _tmp1_;
		_tmp2_ = pair;
		_tmp3_ = _tmp2_->node1;
		_tmp4_ = _gee_priority_queue_node_ref0 (_tmp3_);
		_tmp5_ = pair;
		_tmp6_ = _tmp5_->node2;
		_tmp7_ = _gee_priority_queue_node_ref0 (_tmp6_);
		_gee_priority_queue_link (self, _tmp4_, _tmp7_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static GeePriorityQueueNode*
_gee_priority_queue_re_insert (GeePriorityQueue* self,
                               GeePriorityQueueType1Node* n)
{
	GeePriorityQueueNode* result = NULL;
	GeePriorityQueueType1Node* _tmp0_;
	GeePriorityQueueNode* parent = NULL;
	GeePriorityQueueNode* _tmp1_;
	GeePriorityQueueNode* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = self->priv->_r;
	_vala_assert (n != _tmp0_, "n != _r");
	_tmp1_ = ((GeePriorityQueueNode*) n)->parent;
	_tmp2_ = _gee_priority_queue_node_ref0 (_tmp1_);
	parent = _tmp2_;
	_gee_priority_queue_remove_type1_node (self, n, FALSE);
	_gee_priority_queue_add (self, n);
	result = parent;
	_gee_priority_queue_node_unref0 (n);
	return result;
}

static void
_gee_priority_queue_adjust (GeePriorityQueue* self,
                            GeePriorityQueueType1Node* p1,
                            GeePriorityQueueType1Node* p2)
{
	GeePriorityQueueType1Node* _tmp0_;
	GeePriorityQueueType1Node* m = NULL;
	GeePriorityQueueType1Node* _tmp3_;
	GeePriorityQueueType1Node* _tmp13_;
	GeePriorityQueueType1Node* _tmp14_;
	GeePriorityQueueNode* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p1 != NULL);
	g_return_if_fail (p2 != NULL);
	_tmp0_ = self->priv->_ll_head;
	if (_tmp0_ == NULL) {
		return;
	}
	if (p1->lost > p2->lost) {
		GeePriorityQueueType1Node* _tmp1_;
		_tmp1_ = _gee_priority_queue_node_ref0 (p1);
		_gee_priority_queue_node_unref0 (m);
		m = _tmp1_;
	} else {
		GeePriorityQueueType1Node* _tmp2_;
		_tmp2_ = _gee_priority_queue_node_ref0 (p2);
		_gee_priority_queue_node_unref0 (m);
		m = _tmp2_;
	}
	_tmp3_ = m;
	if (_tmp3_->lost <= ((guint) 1)) {
		GeePriorityQueueType1Node* _tmp4_;
		GeePriorityQueueType1Node* _tmp5_;
		GeePriorityQueueType1Node* _tmp6_;
		GeePriorityQueueType1Node* _tmp7_;
		GeePriorityQueueType1Node* _tmp10_;
		GeePriorityQueueType1Node* _tmp11_;
		GeePriorityQueueType1Node* _tmp12_;
		_tmp4_ = self->priv->_ll_head;
		_tmp5_ = _gee_priority_queue_node_ref0 (_tmp4_);
		_gee_priority_queue_node_unref0 (m);
		m = _tmp5_;
		_tmp6_ = self->priv->_ll_head;
		_tmp7_ = _tmp6_->ll_next;
		if (_tmp7_ != NULL) {
			GeePriorityQueueType1Node* _tmp8_;
			GeePriorityQueueType1Node* _tmp9_;
			_tmp8_ = self->priv->_ll_head;
			_tmp9_ = _tmp8_->ll_next;
			_tmp9_->ll_prev = NULL;
		}
		_tmp10_ = self->priv->_ll_head;
		_tmp11_ = _tmp10_->ll_next;
		_tmp12_ = _gee_priority_queue_node_ref0 (_tmp11_);
		_gee_priority_queue_node_unref0 (self->priv->_ll_head);
		self->priv->_ll_head = _tmp12_;
	}
	_tmp13_ = m;
	_tmp14_ = _gee_priority_queue_node_ref0 (_tmp13_);
	_tmp15_ = _gee_priority_queue_re_insert (self, _tmp14_);
	_gee_priority_queue_node_unref0 (self->priv->_p);
	self->priv->_p = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1Node);
	_gee_priority_queue_node_unref0 (m);
}

static void
_gee_priority_queue_delete (GeePriorityQueue* self,
                            GeePriorityQueueNode* n)
{
	gpointer _tmp0_;
	gpointer _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	_gee_priority_queue_decrease_key (self, n);
	_tmp0_ = gee_abstract_queue_poll ((GeeAbstractQueue*) self);
	_tmp1_ = _tmp0_;
	((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
}

static void
_gee_priority_queue_decrease_key (GeePriorityQueue* self,
                                  GeePriorityQueueNode* n)
{
	gboolean _tmp0_ = FALSE;
	GeePriorityQueueType1Node* _tmp1_;
	gboolean _tmp3_ = FALSE;
	GeePriorityQueueType2Node* _tmp4_;
	GeePriorityQueueNode* p_prime = NULL;
	GeePriorityQueueType1Node* _tmp9_;
	GeePriorityQueueNode* _tmp10_;
	GeePriorityQueueNode* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	_tmp1_ = self->priv->_r;
	if (n == G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode)) {
		_tmp0_ = TRUE;
	} else {
		GeePriorityQueueType2Node* _tmp2_;
		_tmp2_ = self->priv->_r_prime;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	n->pending_drop = TRUE;
	_tmp4_ = self->priv->_r_prime;
	if (n == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode)) {
		GeePriorityQueueType2Node* _tmp5_;
		GeePriorityQueueType1Node* _tmp6_;
		_tmp5_ = self->priv->_r_prime;
		_tmp6_ = self->priv->_r;
		_tmp3_ = _gee_priority_queue_compare (self, (GeePriorityQueueNode*) _tmp5_, (GeePriorityQueueNode*) _tmp6_) < 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GeePriorityQueueType2Node* _tmp7_;
		GeePriorityQueueType1Node* _tmp8_;
		_tmp7_ = self->priv->_r_prime;
		_tmp8_ = self->priv->_r;
		_gee_priority_queue_swap_data (self, (GeePriorityQueueNode*) _tmp7_, (GeePriorityQueueNode*) _tmp8_);
		return;
	}
	_tmp9_ = _gee_priority_queue_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (n, GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1Node));
	_tmp10_ = _gee_priority_queue_re_insert (self, _tmp9_);
	p_prime = _tmp10_;
	_tmp11_ = p_prime;
	if (GEE_PRIORITY_QUEUE_IS_TYPE2_NODE (_tmp11_)) {
		GeePriorityQueueType1Node* _tmp12_;
		GeePriorityQueueType1Node* _tmp13_;
		_tmp12_ = self->priv->_p;
		_tmp13_ = self->priv->_p;
		_gee_priority_queue_adjust (self, _tmp12_, _tmp13_);
	} else {
		GeePriorityQueueType1Node* _tmp14_;
		GeePriorityQueueNode* _tmp15_;
		_tmp14_ = self->priv->_p;
		_tmp15_ = p_prime;
		_gee_priority_queue_adjust (self, _tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1Node));
	}
	_gee_priority_queue_node_unref0 (p_prime);
}

static void
_gee_priority_queue_add_to (GeePriorityQueue* self,
                            GeePriorityQueueType1Node* node,
                            GeePriorityQueueType1Node* parent)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (parent != NULL);
	gee_priority_queue_type1_node_add (parent, node);
	parent->lost = (guint) 0;
}

static void
_gee_priority_queue_add_in_r_prime (GeePriorityQueue* self,
                                    GeePriorityQueueType1Node* node)
{
	gint degree = 0;
	GeePriorityQueueType1Node* insertion_point = NULL;
	GeePriorityQueueType1Node** _tmp0_;
	gint _tmp0__length1;
	GeePriorityQueueType1Node* _tmp4_;
	GeePriorityQueueType2Node* _tmp28_;
	GeePriorityQueueType1Node** _tmp29_;
	gint _tmp29__length1;
	GeePriorityQueueType1Node** _tmp32_;
	gint _tmp32__length1;
	GeePriorityQueueType1Node* _tmp33_;
	GeePriorityQueueType1Node** _tmp53_;
	gint _tmp53__length1;
	GeePriorityQueueType1Node* _tmp54_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	degree = gee_priority_queue_node_degree ((GeePriorityQueueNode*) node);
	insertion_point = NULL;
	_tmp0_ = self->priv->_a;
	_tmp0__length1 = self->priv->_a_length1;
	if (degree < _tmp0__length1) {
		GeePriorityQueueType1Node** _tmp1_;
		gint _tmp1__length1;
		GeePriorityQueueType1Node* _tmp2_;
		GeePriorityQueueType1Node* _tmp3_;
		_tmp1_ = self->priv->_a;
		_tmp1__length1 = self->priv->_a_length1;
		_tmp2_ = _tmp1_[degree];
		_tmp3_ = _gee_priority_queue_node_ref0 (_tmp2_);
		_gee_priority_queue_node_unref0 (insertion_point);
		insertion_point = _tmp3_;
	}
	_tmp4_ = insertion_point;
	if (_tmp4_ == NULL) {
		GeePriorityQueueType2Node* _tmp5_;
		GeePriorityQueueType1Node* _tmp6_;
		GeePriorityQueueType2Node* _tmp14_;
		GeePriorityQueueType1Node* _tmp15_;
		_tmp5_ = self->priv->_r_prime;
		_tmp6_ = ((GeePriorityQueueNode*) _tmp5_)->type1_children_tail;
		if (_tmp6_ != NULL) {
			GeePriorityQueueType2Node* _tmp7_;
			GeePriorityQueueType1Node* _tmp8_;
			GeePriorityQueueType2Node* _tmp9_;
			GeePriorityQueueType1Node* _tmp10_;
			GeePriorityQueueType1Node* _tmp11_;
			_tmp7_ = self->priv->_r_prime;
			_tmp8_ = ((GeePriorityQueueNode*) _tmp7_)->type1_children_tail;
			node->brothers_prev = _tmp8_;
			_tmp9_ = self->priv->_r_prime;
			_tmp10_ = ((GeePriorityQueueNode*) _tmp9_)->type1_children_tail;
			_tmp11_ = _gee_priority_queue_node_ref0 (node);
			_gee_priority_queue_node_unref0 (_tmp10_->brothers_next);
			_tmp10_->brothers_next = _tmp11_;
		} else {
			GeePriorityQueueType2Node* _tmp12_;
			GeePriorityQueueType1Node* _tmp13_;
			_tmp12_ = self->priv->_r_prime;
			_tmp13_ = _gee_priority_queue_node_ref0 (node);
			_gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) _tmp12_)->type1_children_head);
			((GeePriorityQueueNode*) _tmp12_)->type1_children_head = _tmp13_;
		}
		_tmp14_ = self->priv->_r_prime;
		_tmp15_ = _gee_priority_queue_node_ref0 (node);
		_gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) _tmp14_)->type1_children_tail);
		((GeePriorityQueueNode*) _tmp14_)->type1_children_tail = _tmp15_;
	} else {
		GeePriorityQueueType1Node* _tmp16_;
		GeePriorityQueueType1Node* _tmp17_;
		GeePriorityQueueType1Node* _tmp25_;
		GeePriorityQueueType1Node* _tmp26_;
		GeePriorityQueueType1Node* _tmp27_;
		_tmp16_ = insertion_point;
		_tmp17_ = _tmp16_->brothers_prev;
		if (_tmp17_ != NULL) {
			GeePriorityQueueType1Node* _tmp18_;
			GeePriorityQueueType1Node* _tmp19_;
			GeePriorityQueueType1Node* _tmp20_;
			GeePriorityQueueType1Node* _tmp21_;
			GeePriorityQueueType1Node* _tmp22_;
			_tmp18_ = insertion_point;
			_tmp19_ = _tmp18_->brothers_prev;
			_tmp20_ = _gee_priority_queue_node_ref0 (node);
			_gee_priority_queue_node_unref0 (_tmp19_->brothers_next);
			_tmp19_->brothers_next = _tmp20_;
			_tmp21_ = insertion_point;
			_tmp22_ = _tmp21_->brothers_prev;
			node->brothers_prev = _tmp22_;
		} else {
			GeePriorityQueueType2Node* _tmp23_;
			GeePriorityQueueType1Node* _tmp24_;
			_tmp23_ = self->priv->_r_prime;
			_tmp24_ = _gee_priority_queue_node_ref0 (node);
			_gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) _tmp23_)->type1_children_head);
			((GeePriorityQueueNode*) _tmp23_)->type1_children_head = _tmp24_;
		}
		_tmp25_ = insertion_point;
		_tmp26_ = _gee_priority_queue_node_ref0 (_tmp25_);
		_gee_priority_queue_node_unref0 (node->brothers_next);
		node->brothers_next = _tmp26_;
		_tmp27_ = insertion_point;
		_tmp27_->brothers_prev = node;
	}
	_tmp28_ = self->priv->_r_prime;
	((GeePriorityQueueNode*) node)->parent = (GeePriorityQueueNode*) _tmp28_;
	_tmp29_ = self->priv->_a;
	_tmp29__length1 = self->priv->_a_length1;
	if (degree >= _tmp29__length1) {
		gint _tmp30_;
		gint _tmp31_;
		_tmp30_ = degree + 1;
		self->priv->_a = g_renew (GeePriorityQueueType1Node*, self->priv->_a, degree + 1);
		(_tmp30_ > self->priv->_a_length1) ? memset (self->priv->_a + self->priv->_a_length1, 0, sizeof (GeePriorityQueueType1Node*) * (_tmp30_ - self->priv->_a_length1)) : NULL;
		self->priv->_a_length1 = _tmp30_;
		self->priv->__a_size_ = _tmp30_;
		_tmp31_ = degree + 1;
		self->priv->_b = g_renew (gboolean, self->priv->_b, degree + 1);
		(_tmp31_ > self->priv->_b_length1) ? memset (self->priv->_b + self->priv->_b_length1, 0, sizeof (gboolean) * (_tmp31_ - self->priv->_b_length1)) : NULL;
		self->priv->_b_length1 = _tmp31_;
		self->priv->__b_size_ = _tmp31_;
	}
	_tmp32_ = self->priv->_a;
	_tmp32__length1 = self->priv->_a_length1;
	_tmp33_ = _tmp32_[degree];
	if (_tmp33_ == NULL) {
		gboolean* _tmp34_;
		gint _tmp34__length1;
		_tmp34_ = self->priv->_b;
		_tmp34__length1 = self->priv->_b_length1;
		_tmp34_[degree] = TRUE;
	} else {
		gboolean* _tmp35_;
		gint _tmp35__length1;
		gboolean _tmp36_;
		_tmp35_ = self->priv->_b;
		_tmp35__length1 = self->priv->_b_length1;
		_tmp36_ = _tmp35_[degree];
		if (_tmp36_) {
			GeePriorityQueueNodePair* pair = NULL;
			GeePriorityQueueType1Node* _tmp37_;
			GeePriorityQueueNodePair* _tmp38_;
			GeePriorityQueueType1Node* _tmp39_;
			GeePriorityQueueNodePair* _tmp40_;
			GeePriorityQueueNodePair* _tmp41_;
			GeePriorityQueueNodePair* _tmp42_;
			gboolean* _tmp51_;
			gint _tmp51__length1;
			_tmp37_ = node->brothers_next;
			_tmp38_ = gee_priority_queue_node_pair_new (node, _tmp37_);
			pair = _tmp38_;
			_tmp39_ = node->brothers_next;
			_tmp40_ = pair;
			_tmp39_->pair = _tmp40_;
			_tmp41_ = pair;
			node->pair = _tmp41_;
			_tmp42_ = self->priv->_lp_head;
			if (_tmp42_ == NULL) {
				GeePriorityQueueNodePair* _tmp43_;
				GeePriorityQueueNodePair* _tmp44_;
				_tmp43_ = pair;
				self->priv->_lp_tail = _tmp43_;
				_tmp44_ = pair;
				pair = NULL;
				_gee_priority_queue_node_pair_free0 (self->priv->_lp_head);
				self->priv->_lp_head = _tmp44_;
			} else {
				GeePriorityQueueNodePair* _tmp45_;
				GeePriorityQueueNodePair* _tmp46_;
				GeePriorityQueueNodePair* _tmp47_;
				GeePriorityQueueNodePair* _tmp48_;
				GeePriorityQueueNodePair* _tmp49_;
				GeePriorityQueueNodePair* _tmp50_;
				_tmp45_ = pair;
				_tmp46_ = self->priv->_lp_tail;
				_tmp45_->lp_prev = _tmp46_;
				_tmp47_ = self->priv->_lp_tail;
				_tmp48_ = pair;
				pair = NULL;
				_gee_priority_queue_node_pair_free0 (_tmp47_->lp_next);
				_tmp47_->lp_next = _tmp48_;
				_tmp49_ = self->priv->_lp_tail;
				_tmp50_ = _tmp49_->lp_next;
				self->priv->_lp_tail = _tmp50_;
			}
			_tmp51_ = self->priv->_b;
			_tmp51__length1 = self->priv->_b_length1;
			_tmp51_[degree] = FALSE;
			_gee_priority_queue_node_pair_free0 (pair);
		} else {
			gboolean* _tmp52_;
			gint _tmp52__length1;
			_tmp52_ = self->priv->_b;
			_tmp52__length1 = self->priv->_b_length1;
			_tmp52_[degree] = TRUE;
		}
	}
	_tmp53_ = self->priv->_a;
	_tmp53__length1 = self->priv->_a_length1;
	_tmp54_ = _gee_priority_queue_node_ref0 (node);
	_gee_priority_queue_node_unref0 (_tmp53_[degree]);
	_tmp53_[degree] = _tmp54_;
	_gee_priority_queue_node_unref0 (insertion_point);
}

static void
_gee_priority_queue_remove_type1_node (GeePriorityQueue* self,
                                       GeePriorityQueueType1Node* node,
                                       gboolean with_iteration)
{
	GeePriorityQueueNode* _tmp0_;
	GeePriorityQueueType2Node* _tmp1_;
	GeePriorityQueueType1Node* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = ((GeePriorityQueueNode*) node)->parent;
	_tmp1_ = self->priv->_r_prime;
	if (_tmp0_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode)) {
		_gee_priority_queue_updated_degree (self, node, FALSE);
	} else {
		GeePriorityQueueType1Node* _tmp2_;
		GeePriorityQueueType1Node* _tmp9_;
		GeePriorityQueueNode* _tmp15_;
		_tmp2_ = node->ll_prev;
		if (_tmp2_ != NULL) {
			GeePriorityQueueType1Node* _tmp3_;
			GeePriorityQueueType1Node* _tmp4_;
			GeePriorityQueueType1Node* _tmp5_;
			_tmp3_ = node->ll_prev;
			_tmp4_ = node->ll_next;
			_tmp5_ = _gee_priority_queue_node_ref0 (_tmp4_);
			_gee_priority_queue_node_unref0 (_tmp3_->ll_next);
			_tmp3_->ll_next = _tmp5_;
		} else {
			GeePriorityQueueType1Node* _tmp6_;
			_tmp6_ = self->priv->_ll_head;
			if (_tmp6_ == node) {
				GeePriorityQueueType1Node* _tmp7_;
				GeePriorityQueueType1Node* _tmp8_;
				_tmp7_ = node->ll_next;
				_tmp8_ = _gee_priority_queue_node_ref0 (_tmp7_);
				_gee_priority_queue_node_unref0 (self->priv->_ll_head);
				self->priv->_ll_head = _tmp8_;
			}
		}
		_tmp9_ = node->ll_next;
		if (_tmp9_ != NULL) {
			GeePriorityQueueType1Node* _tmp10_;
			GeePriorityQueueType1Node* _tmp11_;
			_tmp10_ = node->ll_next;
			_tmp11_ = node->ll_prev;
			_tmp10_->ll_prev = _tmp11_;
		} else {
			GeePriorityQueueType1Node* _tmp12_;
			_tmp12_ = self->priv->_ll_tail;
			if (_tmp12_ == node) {
				GeePriorityQueueType1Node* _tmp13_;
				GeePriorityQueueType1Node* _tmp14_;
				_tmp13_ = node->ll_prev;
				_tmp14_ = _gee_priority_queue_node_ref0 (_tmp13_);
				_gee_priority_queue_node_unref0 (self->priv->_ll_tail);
				self->priv->_ll_tail = _tmp14_;
			}
		}
		_tmp15_ = ((GeePriorityQueueNode*) node)->parent;
		if (_tmp15_ != NULL) {
			GeePriorityQueueNode* _tmp16_;
			GeePriorityQueueNode* _tmp17_;
			GeePriorityQueueType2Node* _tmp18_;
			_tmp16_ = ((GeePriorityQueueNode*) node)->parent;
			_tmp17_ = _tmp16_->parent;
			_tmp18_ = self->priv->_r_prime;
			if (_tmp17_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode)) {
				GeePriorityQueueNode* _tmp19_;
				_tmp19_ = ((GeePriorityQueueNode*) node)->parent;
				_gee_priority_queue_updated_degree (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1Node), TRUE);
			} else {
				GeePriorityQueueNode* _tmp20_;
				GeePriorityQueueNode* _tmp21_;
				_tmp20_ = ((GeePriorityQueueNode*) node)->parent;
				_tmp21_ = _tmp20_->parent;
				if (_tmp21_ != NULL) {
					GeePriorityQueueType1Node* parent = NULL;
					GeePriorityQueueNode* _tmp22_;
					GeePriorityQueueType1Node* _tmp23_;
					GeePriorityQueueType1Node* _tmp24_;
					guint _tmp25_;
					GeePriorityQueueType1Node* _tmp26_;
					_tmp22_ = ((GeePriorityQueueNode*) node)->parent;
					_tmp23_ = _gee_priority_queue_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1Node));
					parent = _tmp23_;
					_tmp24_ = parent;
					_tmp25_ = _tmp24_->lost;
					_tmp24_->lost = _tmp25_ + 1;
					_tmp26_ = parent;
					if (_tmp26_->lost > ((guint) 1)) {
						GeePriorityQueueType1Node* _tmp27_;
						GeePriorityQueueType1Node* _tmp35_;
						GeePriorityQueueType1Node* _tmp36_;
						_tmp27_ = self->priv->_ll_tail;
						if (_tmp27_ != NULL) {
							GeePriorityQueueType1Node* _tmp28_;
							GeePriorityQueueType1Node* _tmp29_;
							GeePriorityQueueType1Node* _tmp30_;
							GeePriorityQueueType1Node* _tmp31_;
							GeePriorityQueueType1Node* _tmp32_;
							_tmp28_ = parent;
							_tmp29_ = self->priv->_ll_tail;
							_tmp28_->ll_prev = _tmp29_;
							_tmp30_ = self->priv->_ll_tail;
							_tmp31_ = parent;
							_tmp32_ = _gee_priority_queue_node_ref0 (_tmp31_);
							_gee_priority_queue_node_unref0 (_tmp30_->ll_next);
							_tmp30_->ll_next = _tmp32_;
						} else {
							GeePriorityQueueType1Node* _tmp33_;
							GeePriorityQueueType1Node* _tmp34_;
							_tmp33_ = parent;
							_tmp34_ = _gee_priority_queue_node_ref0 (_tmp33_);
							_gee_priority_queue_node_unref0 (self->priv->_ll_head);
							self->priv->_ll_head = _tmp34_;
						}
						_tmp35_ = parent;
						_tmp36_ = _gee_priority_queue_node_ref0 (_tmp35_);
						_gee_priority_queue_node_unref0 (self->priv->_ll_tail);
						self->priv->_ll_tail = _tmp36_;
					}
					_gee_priority_queue_node_unref0 (parent);
				}
			}
		}
	}
	_tmp37_ = self->priv->_p;
	if (node == _tmp37_) {
		GeePriorityQueueType1Node* _tmp38_;
		GeePriorityQueueType1Node* _tmp39_;
		_tmp38_ = self->priv->_r;
		_tmp39_ = _gee_priority_queue_node_ref0 (_tmp38_);
		_gee_priority_queue_node_unref0 (self->priv->_p);
		self->priv->_p = _tmp39_;
	}
	gee_priority_queue_type1_node_remove (node);
	if (with_iteration) {
		GeePriorityQueueNode* _tmp40_;
		GeePriorityQueueNode* _tmp45_;
		_tmp40_ = ((GeePriorityQueueNode*) node)->iter_prev;
		if (_tmp40_ != NULL) {
			GeePriorityQueueNode* _tmp41_;
			GeePriorityQueueNode* _tmp42_;
			_tmp41_ = ((GeePriorityQueueNode*) node)->iter_prev;
			_tmp42_ = ((GeePriorityQueueNode*) node)->iter_next;
			_tmp41_->iter_next = _tmp42_;
		} else {
			GeePriorityQueueNode* _tmp43_;
			_tmp43_ = self->priv->_iter_head;
			if (_tmp43_ == G_TYPE_CHECK_INSTANCE_CAST (node, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode)) {
				GeePriorityQueueNode* _tmp44_;
				_tmp44_ = ((GeePriorityQueueNode*) node)->iter_next;
				self->priv->_iter_head = _tmp44_;
			}
		}
		_tmp45_ = ((GeePriorityQueueNode*) node)->iter_next;
		if (_tmp45_ != NULL) {
			GeePriorityQueueNode* _tmp46_;
			GeePriorityQueueNode* _tmp47_;
			_tmp46_ = ((GeePriorityQueueNode*) node)->iter_next;
			_tmp47_ = ((GeePriorityQueueNode*) node)->iter_prev;
			_tmp46_->iter_prev = _tmp47_;
		} else {
			GeePriorityQueueNode* _tmp48_;
			_tmp48_ = self->priv->_iter_tail;
			if (_tmp48_ == G_TYPE_CHECK_INSTANCE_CAST (node, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode)) {
				GeePriorityQueueNode* _tmp49_;
				_tmp49_ = ((GeePriorityQueueNode*) node)->iter_prev;
				self->priv->_iter_tail = _tmp49_;
			}
		}
	}
}

static void
_gee_priority_queue_updated_degree (GeePriorityQueue* self,
                                    GeePriorityQueueType1Node* node,
                                    gboolean child_removed)
{
	gint degree = 0;
	GeePriorityQueueType1Node** _tmp0_;
	gint _tmp0__length1;
	gboolean _tmp3_ = FALSE;
	gboolean* _tmp11_;
	gint _tmp11__length1;
	gboolean* _tmp12_;
	gint _tmp12__length1;
	gboolean _tmp13_;
	GeePriorityQueueType1Node** _tmp14_;
	gint _tmp14__length1;
	GeePriorityQueueType1Node* _tmp15_;
	GeePriorityQueueNodePair* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	degree = gee_priority_queue_node_degree ((GeePriorityQueueNode*) node);
	_tmp0_ = self->priv->_a;
	_tmp0__length1 = self->priv->_a_length1;
	if (degree >= _tmp0__length1) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = degree + 1;
		self->priv->_a = g_renew (GeePriorityQueueType1Node*, self->priv->_a, degree + 1);
		(_tmp1_ > self->priv->_a_length1) ? memset (self->priv->_a + self->priv->_a_length1, 0, sizeof (GeePriorityQueueType1Node*) * (_tmp1_ - self->priv->_a_length1)) : NULL;
		self->priv->_a_length1 = _tmp1_;
		self->priv->__a_size_ = _tmp1_;
		_tmp2_ = degree + 1;
		self->priv->_b = g_renew (gboolean, self->priv->_b, degree + 1);
		(_tmp2_ > self->priv->_b_length1) ? memset (self->priv->_b + self->priv->_b_length1, 0, sizeof (gboolean) * (_tmp2_ - self->priv->_b_length1)) : NULL;
		self->priv->_b_length1 = _tmp2_;
		self->priv->__b_size_ = _tmp2_;
	}
	if (child_removed) {
		GeePriorityQueueType1Node** _tmp4_;
		gint _tmp4__length1;
		GeePriorityQueueType1Node* _tmp5_;
		_tmp4_ = self->priv->_a;
		_tmp4__length1 = self->priv->_a_length1;
		_tmp5_ = _tmp4_[degree - 1];
		_tmp3_ = _tmp5_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GeePriorityQueueType1Node** _tmp6_;
		gint _tmp6__length1;
		GeePriorityQueueType1Node* _tmp7_;
		gboolean* _tmp8_;
		gint _tmp8__length1;
		gboolean* _tmp9_;
		gint _tmp9__length1;
		gboolean _tmp10_;
		_tmp6_ = self->priv->_a;
		_tmp6__length1 = self->priv->_a_length1;
		_tmp7_ = _gee_priority_queue_node_ref0 (node);
		_gee_priority_queue_node_unref0 (_tmp6_[degree - 1]);
		_tmp6_[degree - 1] = _tmp7_;
		_tmp8_ = self->priv->_b;
		_tmp8__length1 = self->priv->_b_length1;
		_tmp9_ = self->priv->_b;
		_tmp9__length1 = self->priv->_b_length1;
		_tmp10_ = _tmp9_[degree - 1];
		_tmp8_[degree - 1] = !_tmp10_;
	}
	_tmp11_ = self->priv->_b;
	_tmp11__length1 = self->priv->_b_length1;
	_tmp12_ = self->priv->_b;
	_tmp12__length1 = self->priv->_b_length1;
	_tmp13_ = _tmp12_[degree];
	_tmp11_[degree] = !_tmp13_;
	_tmp14_ = self->priv->_a;
	_tmp14__length1 = self->priv->_a_length1;
	_tmp15_ = _tmp14_[degree];
	if (_tmp15_ == node) {
		GeePriorityQueueType1Node* next = NULL;
		GeePriorityQueueType1Node* _tmp16_;
		GeePriorityQueueType1Node* _tmp17_;
		gboolean _tmp18_ = FALSE;
		GeePriorityQueueType1Node* _tmp19_;
		_tmp16_ = node->brothers_next;
		_tmp17_ = _gee_priority_queue_node_ref0 (_tmp16_);
		next = _tmp17_;
		_tmp19_ = next;
		if (_tmp19_ != NULL) {
			GeePriorityQueueType1Node* _tmp20_;
			_tmp20_ = next;
			_tmp18_ = gee_priority_queue_node_degree ((GeePriorityQueueNode*) _tmp20_) == degree;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			GeePriorityQueueType1Node** _tmp21_;
			gint _tmp21__length1;
			GeePriorityQueueType1Node* _tmp22_;
			GeePriorityQueueType1Node* _tmp23_;
			_tmp21_ = self->priv->_a;
			_tmp21__length1 = self->priv->_a_length1;
			_tmp22_ = next;
			_tmp23_ = _gee_priority_queue_node_ref0 (_tmp22_);
			_gee_priority_queue_node_unref0 (_tmp21_[degree]);
			_tmp21_[degree] = _tmp23_;
		} else {
			GeePriorityQueueType1Node** _tmp24_;
			gint _tmp24__length1;
			gint i = 0;
			GeePriorityQueueType1Node** _tmp25_;
			gint _tmp25__length1;
			gint _tmp30_;
			gint _tmp31_;
			_tmp24_ = self->priv->_a;
			_tmp24__length1 = self->priv->_a_length1;
			_gee_priority_queue_node_unref0 (_tmp24_[degree]);
			_tmp24_[degree] = NULL;
			_tmp25_ = self->priv->_a;
			_tmp25__length1 = self->priv->_a_length1;
			i = _tmp25__length1 - 1;
			while (TRUE) {
				gboolean _tmp26_ = FALSE;
				gint _tmp29_;
				if (i >= 0) {
					GeePriorityQueueType1Node** _tmp27_;
					gint _tmp27__length1;
					GeePriorityQueueType1Node* _tmp28_;
					_tmp27_ = self->priv->_a;
					_tmp27__length1 = self->priv->_a_length1;
					_tmp28_ = _tmp27_[i];
					_tmp26_ = _tmp28_ == NULL;
				} else {
					_tmp26_ = FALSE;
				}
				if (!_tmp26_) {
					break;
				}
				_tmp29_ = i;
				i = _tmp29_ - 1;
			}
			_tmp30_ = i + 1;
			self->priv->_a = g_renew (GeePriorityQueueType1Node*, self->priv->_a, i + 1);
			(_tmp30_ > self->priv->_a_length1) ? memset (self->priv->_a + self->priv->_a_length1, 0, sizeof (GeePriorityQueueType1Node*) * (_tmp30_ - self->priv->_a_length1)) : NULL;
			self->priv->_a_length1 = _tmp30_;
			self->priv->__a_size_ = _tmp30_;
			_tmp31_ = i + 1;
			self->priv->_b = g_renew (gboolean, self->priv->_b, i + 1);
			(_tmp31_ > self->priv->_b_length1) ? memset (self->priv->_b + self->priv->_b_length1, 0, sizeof (gboolean) * (_tmp31_ - self->priv->_b_length1)) : NULL;
			self->priv->_b_length1 = _tmp31_;
			self->priv->__b_size_ = _tmp31_;
		}
		_gee_priority_queue_node_unref0 (next);
	}
	_tmp32_ = node->pair;
	if (_tmp32_ != NULL) {
		GeePriorityQueueNodePair* pair = NULL;
		GeePriorityQueueNodePair* _tmp33_;
		GeePriorityQueueType1Node* _tmp34_ = NULL;
		GeePriorityQueueNodePair* _tmp35_;
		GeePriorityQueueType1Node* _tmp36_;
		GeePriorityQueueType1Node* other = NULL;
		GeePriorityQueueType1Node* _tmp41_;
		GeePriorityQueueType1Node* _tmp42_;
		GeePriorityQueueNodePair* _tmp43_;
		GeePriorityQueueNodePair* _tmp44_;
		GeePriorityQueueNodePair* _tmp51_;
		GeePriorityQueueNodePair* _tmp52_;
		_tmp33_ = node->pair;
		pair = _tmp33_;
		_tmp35_ = pair;
		_tmp36_ = _tmp35_->node1;
		if (_tmp36_ == node) {
			GeePriorityQueueNodePair* _tmp37_;
			GeePriorityQueueType1Node* _tmp38_;
			_tmp37_ = pair;
			_tmp38_ = _tmp37_->node2;
			_tmp34_ = _tmp38_;
		} else {
			GeePriorityQueueNodePair* _tmp39_;
			GeePriorityQueueType1Node* _tmp40_;
			_tmp39_ = pair;
			_tmp40_ = _tmp39_->node1;
			_tmp34_ = _tmp40_;
		}
		_tmp41_ = _gee_priority_queue_node_ref0 (_tmp34_);
		other = _tmp41_;
		node->pair = NULL;
		_tmp42_ = other;
		_tmp42_->pair = NULL;
		_tmp43_ = pair;
		_tmp44_ = _tmp43_->lp_next;
		if (_tmp44_ != NULL) {
			GeePriorityQueueNodePair* _tmp45_;
			GeePriorityQueueNodePair* _tmp46_;
			GeePriorityQueueNodePair* _tmp47_;
			GeePriorityQueueNodePair* _tmp48_;
			_tmp45_ = pair;
			_tmp46_ = _tmp45_->lp_next;
			_tmp47_ = pair;
			_tmp48_ = _tmp47_->lp_prev;
			_tmp46_->lp_prev = _tmp48_;
		} else {
			GeePriorityQueueNodePair* _tmp49_;
			GeePriorityQueueNodePair* _tmp50_;
			_tmp49_ = pair;
			_tmp50_ = _tmp49_->lp_prev;
			self->priv->_lp_tail = _tmp50_;
		}
		_tmp51_ = pair;
		_tmp52_ = _tmp51_->lp_prev;
		if (_tmp52_ != NULL) {
			GeePriorityQueueNodePair* _tmp53_;
			GeePriorityQueueNodePair* _tmp54_;
			GeePriorityQueueNodePair* _tmp55_;
			GeePriorityQueueNodePair* _tmp56_;
			_tmp53_ = pair;
			_tmp54_ = _tmp53_->lp_prev;
			_tmp55_ = pair;
			_tmp56_ = _tmp55_->lp_next;
			_tmp55_->lp_next = NULL;
			_gee_priority_queue_node_pair_free0 (_tmp54_->lp_next);
			_tmp54_->lp_next = _tmp56_;
		} else {
			GeePriorityQueueNodePair* _tmp57_;
			GeePriorityQueueNodePair* _tmp58_;
			_tmp57_ = pair;
			_tmp58_ = _tmp57_->lp_next;
			_tmp57_->lp_next = NULL;
			_gee_priority_queue_node_pair_free0 (self->priv->_lp_head);
			self->priv->_lp_head = _tmp58_;
		}
		_gee_priority_queue_node_unref0 (other);
	}
}

static void
_gee_priority_queue_remove_type2_node (GeePriorityQueue* self,
                                       GeePriorityQueueType2Node* node,
                                       gboolean with_iteration)
{
	GeePriorityQueueNode* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = ((GeePriorityQueueNode*) node)->parent;
	_gee_priority_queue_node_unref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1Node)->type2_child);
	G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1Node)->type2_child = NULL;
	((GeePriorityQueueNode*) node)->parent = NULL;
	if (with_iteration) {
		GeePriorityQueueNode* _tmp1_;
		GeePriorityQueueNode* _tmp6_;
		_tmp1_ = ((GeePriorityQueueNode*) node)->iter_prev;
		if (_tmp1_ != NULL) {
			GeePriorityQueueNode* _tmp2_;
			GeePriorityQueueNode* _tmp3_;
			_tmp2_ = ((GeePriorityQueueNode*) node)->iter_prev;
			_tmp3_ = ((GeePriorityQueueNode*) node)->iter_next;
			_tmp2_->iter_next = _tmp3_;
		} else {
			GeePriorityQueueNode* _tmp4_;
			_tmp4_ = self->priv->_iter_head;
			if (_tmp4_ == G_TYPE_CHECK_INSTANCE_CAST (node, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode)) {
				GeePriorityQueueNode* _tmp5_;
				_tmp5_ = ((GeePriorityQueueNode*) node)->iter_next;
				self->priv->_iter_head = _tmp5_;
			}
		}
		_tmp6_ = ((GeePriorityQueueNode*) node)->iter_next;
		if (_tmp6_ != NULL) {
			GeePriorityQueueNode* _tmp7_;
			GeePriorityQueueNode* _tmp8_;
			_tmp7_ = ((GeePriorityQueueNode*) node)->iter_next;
			_tmp8_ = ((GeePriorityQueueNode*) node)->iter_prev;
			_tmp7_->iter_prev = _tmp8_;
		} else {
			GeePriorityQueueNode* _tmp9_;
			_tmp9_ = self->priv->_iter_tail;
			if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (node, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode)) {
				GeePriorityQueueNode* _tmp10_;
				_tmp10_ = ((GeePriorityQueueNode*) node)->iter_prev;
				self->priv->_iter_tail = _tmp10_;
			}
		}
	}
}

GCompareDataFunc
gee_priority_queue_get_compare_func (GeePriorityQueue* self,
                                     gpointer* result_target)
{
	GCompareDataFunc result;
	GCompareDataFunc _tmp0_;
	gpointer _tmp0__target;
	GCompareDataFunc _tmp1_;
	gpointer _tmp1__target;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_compare_func;
	_tmp0__target = self->priv->_compare_func_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}

static void
gee_priority_queue_set_compare_func (GeePriorityQueue* self,
                                     GCompareDataFunc value,
                                     gpointer value_target)
{
	g_return_if_fail (self != NULL);
}

static gint
gee_priority_queue_real_get_capacity (GeeAbstractQueue* base)
{
	gint result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}

static gint
gee_priority_queue_real_get_remaining_capacity (GeeAbstractQueue* base)
{
	gint result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}

static gboolean
gee_priority_queue_real_get_is_full (GeeAbstractQueue* base)
{
	gboolean result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = FALSE;
	return result;
}

static gboolean
gee_priority_queue_real_get_read_only (GeeAbstractCollection* base)
{
	gboolean result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = FALSE;
	return result;
}

static gint
gee_priority_queue_real_get_size (GeeAbstractCollection* base)
{
	gint result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = self->priv->_size;
	return result;
}

static inline gpointer
gee_priority_queue_node_get_instance_private (GeePriorityQueueNode* self)
{
	return G_STRUCT_MEMBER_P (self, GeePriorityQueueNode_private_offset);
}

static GeePriorityQueueNode*
gee_priority_queue_node_construct (GType object_type,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   gconstpointer data,
                                   GeePriorityQueueNode* * head,
                                   GeePriorityQueueNode* * tail)
{
	GeePriorityQueueNode* self = NULL;
	gpointer _tmp0_;
	GeePriorityQueueNode* _tmp1_;
	self = (GeePriorityQueueNode*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = ((data != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) data) : ((gpointer) data);
	_g_destroy_func0 (self->data);
	self->data = _tmp0_;
	self->iter_prev = *tail;
	*tail = self;
	_tmp1_ = self->iter_prev;
	if (_tmp1_ != NULL) {
		GeePriorityQueueNode* _tmp2_;
		_tmp2_ = self->iter_prev;
		_tmp2_->iter_next = self;
	}
	if ((*head) == NULL) {
		*head = self;
	}
	return self;
}

static inline gint
gee_priority_queue_node_degree (GeePriorityQueueNode* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = self->type1_children_count;
	return result;
}

static void
gee_priority_queue_value_node_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gee_priority_queue_value_node_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gee_priority_queue_node_unref (value->data[0].v_pointer);
	}
}

static void
gee_priority_queue_value_node_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_priority_queue_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gee_priority_queue_value_node_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gee_priority_queue_value_node_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GeePriorityQueueNode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_priority_queue_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gee_priority_queue_value_node_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	GeePriorityQueueNode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_priority_queue_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
gee_priority_queue_param_spec_node (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	GeePriorityQueueParamSpecNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_PRIORITY_QUEUE_TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
gee_priority_queue_value_get_node (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}

static void
gee_priority_queue_value_set_node (GValue* value,
                                   gpointer v_object)
{
	GeePriorityQueueNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_PRIORITY_QUEUE_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_priority_queue_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_priority_queue_node_unref (old);
	}
}

static void
gee_priority_queue_value_take_node (GValue* value,
                                    gpointer v_object)
{
	GeePriorityQueueNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_PRIORITY_QUEUE_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_priority_queue_node_unref (old);
	}
}

static void
gee_priority_queue_node_class_init (GeePriorityQueueNodeClass * klass,
                                    gpointer klass_data)
{
	gee_priority_queue_node_parent_class = g_type_class_peek_parent (klass);
	((GeePriorityQueueNodeClass *) klass)->finalize = gee_priority_queue_node_finalize;
	g_type_class_adjust_private_offset (klass, &GeePriorityQueueNode_private_offset);
}

static void
gee_priority_queue_node_instance_init (GeePriorityQueueNode * self,
                                       gpointer klass)
{
	self->priv = gee_priority_queue_node_get_instance_private (self);
	self->parent = NULL;
	self->type1_children_head = NULL;
	self->type1_children_tail = NULL;
	self->iter_next = NULL;
	self->ref_count = 1;
}

static void
gee_priority_queue_node_finalize (GeePriorityQueueNode * obj)
{
	GeePriorityQueueNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode);
	g_signal_handlers_destroy (self);
	((self->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->data = (self->priv->g_destroy_func (self->data), NULL));
	_gee_priority_queue_node_unref0 (self->type1_children_head);
	_gee_priority_queue_node_unref0 (self->type1_children_tail);
}

static GType
gee_priority_queue_node_get_type (void)
{
	static volatile gsize gee_priority_queue_node_type_id__volatile = 0;
	if (g_once_init_enter (&gee_priority_queue_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gee_priority_queue_value_node_init, gee_priority_queue_value_node_free_value, gee_priority_queue_value_node_copy_value, gee_priority_queue_value_node_peek_pointer, "p", gee_priority_queue_value_node_collect_value, "p", gee_priority_queue_value_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueNode), 0, (GInstanceInitFunc) gee_priority_queue_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gee_priority_queue_node_type_id;
		gee_priority_queue_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeePriorityQueueNode", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		GeePriorityQueueNode_private_offset = g_type_add_instance_private (gee_priority_queue_node_type_id, sizeof (GeePriorityQueueNodePrivate));
		g_once_init_leave (&gee_priority_queue_node_type_id__volatile, gee_priority_queue_node_type_id);
	}
	return gee_priority_queue_node_type_id__volatile;
}

static gpointer
gee_priority_queue_node_ref (gpointer instance)
{
	GeePriorityQueueNode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
gee_priority_queue_node_unref (gpointer instance)
{
	GeePriorityQueueNode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_PRIORITY_QUEUE_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
gee_priority_queue_type1_node_get_instance_private (GeePriorityQueueType1Node* self)
{
	return G_STRUCT_MEMBER_P (self, GeePriorityQueueType1Node_private_offset);
}

static GeePriorityQueueType1Node*
gee_priority_queue_type1_node_construct (GType object_type,
                                         GType g_type,
                                         GBoxedCopyFunc g_dup_func,
                                         GDestroyNotify g_destroy_func,
                                         gconstpointer data,
                                         GeePriorityQueueNode* * head,
                                         GeePriorityQueueNode* * tail)
{
	GeePriorityQueueType1Node* self = NULL;
	self = (GeePriorityQueueType1Node*) gee_priority_queue_node_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, data, head, tail);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}

static GeePriorityQueueType1Node*
gee_priority_queue_type1_node_new (GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   gconstpointer data,
                                   GeePriorityQueueNode* * head,
                                   GeePriorityQueueNode* * tail)
{
	return gee_priority_queue_type1_node_construct (GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, g_type, g_dup_func, g_destroy_func, data, head, tail);
}

static inline void
gee_priority_queue_type1_node_add (GeePriorityQueueType1Node* self,
                                   GeePriorityQueueType1Node* node)
{
	GeePriorityQueueType1Node* _tmp0_;
	GeePriorityQueueType1Node* _tmp3_;
	GeePriorityQueueType1Node* _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	((GeePriorityQueueNode*) node)->parent = (GeePriorityQueueNode*) self;
	_tmp0_ = ((GeePriorityQueueNode*) self)->type1_children_head;
	if (_tmp0_ == NULL) {
		GeePriorityQueueType1Node* _tmp1_;
		_tmp1_ = _gee_priority_queue_node_ref0 (node);
		_gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self)->type1_children_head);
		((GeePriorityQueueNode*) self)->type1_children_head = _tmp1_;
	} else {
		GeePriorityQueueType1Node* _tmp2_;
		_tmp2_ = ((GeePriorityQueueNode*) self)->type1_children_tail;
		node->brothers_prev = _tmp2_;
	}
	_tmp3_ = ((GeePriorityQueueNode*) self)->type1_children_tail;
	if (_tmp3_ != NULL) {
		GeePriorityQueueType1Node* _tmp4_;
		GeePriorityQueueType1Node* _tmp5_;
		_tmp4_ = ((GeePriorityQueueNode*) self)->type1_children_tail;
		_tmp5_ = _gee_priority_queue_node_ref0 (node);
		_gee_priority_queue_node_unref0 (_tmp4_->brothers_next);
		_tmp4_->brothers_next = _tmp5_;
	}
	_tmp6_ = _gee_priority_queue_node_ref0 (node);
	_gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self)->type1_children_tail);
	((GeePriorityQueueNode*) self)->type1_children_tail = _tmp6_;
	_tmp7_ = ((GeePriorityQueueNode*) self)->type1_children_count;
	((GeePriorityQueueNode*) self)->type1_children_count = _tmp7_ + 1;
}

static inline void
gee_priority_queue_type1_node_remove (GeePriorityQueueType1Node* self)
{
	GeePriorityQueueType1Node* _tmp0_;
	GeePriorityQueueType1Node* _tmp7_;
	GeePriorityQueueNode* _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->brothers_prev;
	if (_tmp0_ == NULL) {
		GeePriorityQueueNode* _tmp1_;
		GeePriorityQueueType1Node* _tmp2_;
		GeePriorityQueueType1Node* _tmp3_;
		_tmp1_ = ((GeePriorityQueueNode*) self)->parent;
		_tmp2_ = self->brothers_next;
		_tmp3_ = _gee_priority_queue_node_ref0 (_tmp2_);
		_gee_priority_queue_node_unref0 (_tmp1_->type1_children_head);
		_tmp1_->type1_children_head = _tmp3_;
	} else {
		GeePriorityQueueType1Node* _tmp4_;
		GeePriorityQueueType1Node* _tmp5_;
		GeePriorityQueueType1Node* _tmp6_;
		_tmp4_ = self->brothers_prev;
		_tmp5_ = self->brothers_next;
		_tmp6_ = _gee_priority_queue_node_ref0 (_tmp5_);
		_gee_priority_queue_node_unref0 (_tmp4_->brothers_next);
		_tmp4_->brothers_next = _tmp6_;
	}
	_tmp7_ = self->brothers_next;
	if (_tmp7_ == NULL) {
		GeePriorityQueueNode* _tmp8_;
		GeePriorityQueueType1Node* _tmp9_;
		GeePriorityQueueType1Node* _tmp10_;
		_tmp8_ = ((GeePriorityQueueNode*) self)->parent;
		_tmp9_ = self->brothers_prev;
		_tmp10_ = _gee_priority_queue_node_ref0 (_tmp9_);
		_gee_priority_queue_node_unref0 (_tmp8_->type1_children_tail);
		_tmp8_->type1_children_tail = _tmp10_;
	} else {
		GeePriorityQueueType1Node* _tmp11_;
		GeePriorityQueueType1Node* _tmp12_;
		_tmp11_ = self->brothers_next;
		_tmp12_ = self->brothers_prev;
		_tmp11_->brothers_prev = _tmp12_;
	}
	_tmp13_ = ((GeePriorityQueueNode*) self)->parent;
	_tmp14_ = _tmp13_->type1_children_count;
	_tmp13_->type1_children_count = _tmp14_ - 1;
	((GeePriorityQueueNode*) self)->parent = NULL;
	self->brothers_prev = NULL;
	_gee_priority_queue_node_unref0 (self->brothers_next);
	self->brothers_next = NULL;
}

static void
gee_priority_queue_type1_node_class_init (GeePriorityQueueType1NodeClass * klass,
                                          gpointer klass_data)
{
	gee_priority_queue_type1_node_parent_class = g_type_class_peek_parent (klass);
	((GeePriorityQueueNodeClass *) klass)->finalize = gee_priority_queue_type1_node_finalize;
	g_type_class_adjust_private_offset (klass, &GeePriorityQueueType1Node_private_offset);
}

static void
gee_priority_queue_type1_node_instance_init (GeePriorityQueueType1Node * self,
                                             gpointer klass)
{
	self->priv = gee_priority_queue_type1_node_get_instance_private (self);
	self->brothers_prev = NULL;
	self->brothers_next = NULL;
	self->type2_child = NULL;
	self->ll_prev = NULL;
	self->ll_next = NULL;
	self->pair = NULL;
}

static void
gee_priority_queue_type1_node_finalize (GeePriorityQueueNode * obj)
{
	GeePriorityQueueType1Node * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1Node);
	_gee_priority_queue_node_unref0 (self->brothers_next);
	_gee_priority_queue_node_unref0 (self->type2_child);
	_gee_priority_queue_node_unref0 (self->ll_next);
	GEE_PRIORITY_QUEUE_NODE_CLASS (gee_priority_queue_type1_node_parent_class)->finalize (obj);
}

static GType
gee_priority_queue_type1_node_get_type (void)
{
	static volatile gsize gee_priority_queue_type1_node_type_id__volatile = 0;
	if (g_once_init_enter (&gee_priority_queue_type1_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueType1NodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_type1_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueType1Node), 0, (GInstanceInitFunc) gee_priority_queue_type1_node_instance_init, NULL };
		GType gee_priority_queue_type1_node_type_id;
		gee_priority_queue_type1_node_type_id = g_type_register_static (GEE_PRIORITY_QUEUE_TYPE_NODE, "GeePriorityQueueType1Node", &g_define_type_info, 0);
		GeePriorityQueueType1Node_private_offset = g_type_add_instance_private (gee_priority_queue_type1_node_type_id, sizeof (GeePriorityQueueType1NodePrivate));
		g_once_init_leave (&gee_priority_queue_type1_node_type_id__volatile, gee_priority_queue_type1_node_type_id);
	}
	return gee_priority_queue_type1_node_type_id__volatile;
}

static inline gpointer
gee_priority_queue_type2_node_get_instance_private (GeePriorityQueueType2Node* self)
{
	return G_STRUCT_MEMBER_P (self, GeePriorityQueueType2Node_private_offset);
}

static GeePriorityQueueType2Node*
gee_priority_queue_type2_node_construct (GType object_type,
                                         GType g_type,
                                         GBoxedCopyFunc g_dup_func,
                                         GDestroyNotify g_destroy_func,
                                         gconstpointer data,
                                         GeePriorityQueueNode* * head,
                                         GeePriorityQueueNode* * tail)
{
	GeePriorityQueueType2Node* self = NULL;
	self = (GeePriorityQueueType2Node*) gee_priority_queue_node_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, data, head, tail);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}

static GeePriorityQueueType2Node*
gee_priority_queue_type2_node_new (GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   gconstpointer data,
                                   GeePriorityQueueNode* * head,
                                   GeePriorityQueueNode* * tail)
{
	return gee_priority_queue_type2_node_construct (GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, g_type, g_dup_func, g_destroy_func, data, head, tail);
}

static void
gee_priority_queue_type2_node_class_init (GeePriorityQueueType2NodeClass * klass,
                                          gpointer klass_data)
{
	gee_priority_queue_type2_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeePriorityQueueType2Node_private_offset);
}

static void
gee_priority_queue_type2_node_instance_init (GeePriorityQueueType2Node * self,
                                             gpointer klass)
{
	self->priv = gee_priority_queue_type2_node_get_instance_private (self);
}

static GType
gee_priority_queue_type2_node_get_type (void)
{
	static volatile gsize gee_priority_queue_type2_node_type_id__volatile = 0;
	if (g_once_init_enter (&gee_priority_queue_type2_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueType2NodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_type2_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueType2Node), 0, (GInstanceInitFunc) gee_priority_queue_type2_node_instance_init, NULL };
		GType gee_priority_queue_type2_node_type_id;
		gee_priority_queue_type2_node_type_id = g_type_register_static (GEE_PRIORITY_QUEUE_TYPE_NODE, "GeePriorityQueueType2Node", &g_define_type_info, 0);
		GeePriorityQueueType2Node_private_offset = g_type_add_instance_private (gee_priority_queue_type2_node_type_id, sizeof (GeePriorityQueueType2NodePrivate));
		g_once_init_leave (&gee_priority_queue_type2_node_type_id__volatile, gee_priority_queue_type2_node_type_id);
	}
	return gee_priority_queue_type2_node_type_id__volatile;
}

static inline gpointer
gee_priority_queue_dummy_node_get_instance_private (GeePriorityQueueDummyNode* self)
{
	return G_STRUCT_MEMBER_P (self, GeePriorityQueueDummyNode_private_offset);
}

static GeePriorityQueueDummyNode*
gee_priority_queue_dummy_node_construct (GType object_type,
                                         GType g_type,
                                         GBoxedCopyFunc g_dup_func,
                                         GDestroyNotify g_destroy_func,
                                         GeePriorityQueueNode* * prev_next,
                                         GeePriorityQueueNode* * next_prev,
                                         GeePriorityQueueNode* iter_prev,
                                         GeePriorityQueueNode* iter_next)
{
	GeePriorityQueueDummyNode* self = NULL;
	self = (GeePriorityQueueDummyNode*) gee_priority_queue_node_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, NULL, prev_next, next_prev);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	((GeePriorityQueueNode*) self)->iter_prev = iter_prev;
	((GeePriorityQueueNode*) self)->iter_next = iter_next;
	*next_prev = (GeePriorityQueueNode*) self;
	*prev_next = *next_prev;
	return self;
}

static GeePriorityQueueDummyNode*
gee_priority_queue_dummy_node_new (GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   GeePriorityQueueNode* * prev_next,
                                   GeePriorityQueueNode* * next_prev,
                                   GeePriorityQueueNode* iter_prev,
                                   GeePriorityQueueNode* iter_next)
{
	return gee_priority_queue_dummy_node_construct (GEE_PRIORITY_QUEUE_TYPE_DUMMY_NODE, g_type, g_dup_func, g_destroy_func, prev_next, next_prev, iter_prev, iter_next);
}

static void
gee_priority_queue_dummy_node_class_init (GeePriorityQueueDummyNodeClass * klass,
                                          gpointer klass_data)
{
	gee_priority_queue_dummy_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeePriorityQueueDummyNode_private_offset);
}

static void
gee_priority_queue_dummy_node_instance_init (GeePriorityQueueDummyNode * self,
                                             gpointer klass)
{
	self->priv = gee_priority_queue_dummy_node_get_instance_private (self);
}

static GType
gee_priority_queue_dummy_node_get_type (void)
{
	static volatile gsize gee_priority_queue_dummy_node_type_id__volatile = 0;
	if (g_once_init_enter (&gee_priority_queue_dummy_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueDummyNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_dummy_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueDummyNode), 0, (GInstanceInitFunc) gee_priority_queue_dummy_node_instance_init, NULL };
		GType gee_priority_queue_dummy_node_type_id;
		gee_priority_queue_dummy_node_type_id = g_type_register_static (GEE_PRIORITY_QUEUE_TYPE_NODE, "GeePriorityQueueDummyNode", &g_define_type_info, 0);
		GeePriorityQueueDummyNode_private_offset = g_type_add_instance_private (gee_priority_queue_dummy_node_type_id, sizeof (GeePriorityQueueDummyNodePrivate));
		g_once_init_leave (&gee_priority_queue_dummy_node_type_id__volatile, gee_priority_queue_dummy_node_type_id);
	}
	return gee_priority_queue_dummy_node_type_id__volatile;
}

static GeePriorityQueueNodePair*
gee_priority_queue_node_pair_new (GeePriorityQueueType1Node* node1,
                                  GeePriorityQueueType1Node* node2)
{
	GeePriorityQueueNodePair* self;
	g_return_val_if_fail (node1 != NULL, NULL);
	g_return_val_if_fail (node2 != NULL, NULL);
	self = g_slice_new0 (GeePriorityQueueNodePair);
	gee_priority_queue_node_pair_instance_init (self);
	self->node1 = node1;
	self->node2 = node2;
	return self;
}

static void
gee_priority_queue_node_pair_instance_init (GeePriorityQueueNodePair * self)
{
	self->lp_prev = NULL;
	self->lp_next = NULL;
	self->node1 = NULL;
	self->node2 = NULL;
}

static void
gee_priority_queue_node_pair_free (GeePriorityQueueNodePair * self)
{
	_gee_priority_queue_node_pair_free0 (self->lp_next);
	g_slice_free (GeePriorityQueueNodePair, self);
}

static inline gpointer
gee_priority_queue_iterator_get_instance_private (GeePriorityQueueIterator* self)
{
	return G_STRUCT_MEMBER_P (self, GeePriorityQueueIterator_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GeePriorityQueueIterator*
gee_priority_queue_iterator_construct (GType object_type,
                                       GType g_type,
                                       GBoxedCopyFunc g_dup_func,
                                       GDestroyNotify g_destroy_func,
                                       GeePriorityQueue* queue)
{
	GeePriorityQueueIterator * self = NULL;
	GeePriorityQueue* _tmp0_;
	g_return_val_if_fail (queue != NULL, NULL);
	self = (GeePriorityQueueIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (queue);
	_g_object_unref0 (self->queue);
	self->queue = _tmp0_;
	self->position = NULL;
	self->previous = NULL;
	self->stamp = queue->priv->_stamp;
	return self;
}

static GeePriorityQueueIterator*
gee_priority_queue_iterator_new (GType g_type,
                                 GBoxedCopyFunc g_dup_func,
                                 GDestroyNotify g_destroy_func,
                                 GeePriorityQueue* queue)
{
	return gee_priority_queue_iterator_construct (GEE_PRIORITY_QUEUE_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, queue);
}

static GeePriorityQueueIterator*
gee_priority_queue_iterator_construct_from_iterator (GType object_type,
                                                     GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     GeePriorityQueueIterator* iter)
{
	GeePriorityQueueIterator * self = NULL;
	GeePriorityQueue* _tmp0_;
	GeePriorityQueue* _tmp1_;
	GeePriorityQueueNode* _tmp2_;
	GeePriorityQueueNode* _tmp3_;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (GeePriorityQueueIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = iter->queue;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->queue);
	self->queue = _tmp1_;
	_tmp2_ = iter->position;
	self->position = _tmp2_;
	_tmp3_ = iter->previous;
	self->previous = _tmp3_;
	self->stamp = iter->stamp;
	return self;
}

static GeePriorityQueueIterator*
gee_priority_queue_iterator_new_from_iterator (GType g_type,
                                               GBoxedCopyFunc g_dup_func,
                                               GDestroyNotify g_destroy_func,
                                               GeePriorityQueueIterator* iter)
{
	return gee_priority_queue_iterator_construct_from_iterator (GEE_PRIORITY_QUEUE_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, iter);
}

static gboolean
gee_priority_queue_iterator_real_next (GeeIterator* base)
{
	GeePriorityQueueIterator * self;
	gboolean result = FALSE;
	GeePriorityQueueNode* next = NULL;
	GeePriorityQueueNode* _tmp0_;
	GeePriorityQueueNode* _tmp1_;
	GeePriorityQueueNode* _tmp4_;
	self = (GeePriorityQueueIterator*) base;
	_tmp0_ = _gee_priority_queue_iterator_get_next_node (self);
	next = _tmp0_;
	_tmp1_ = next;
	if (_tmp1_ != NULL) {
		GeePriorityQueueNode* _tmp2_;
		GeePriorityQueueNode* _tmp3_;
		_tmp2_ = self->position;
		self->previous = _tmp2_;
		_tmp3_ = next;
		self->position = _tmp3_;
	}
	_tmp4_ = next;
	result = _tmp4_ != NULL;
	return result;
}

static gboolean
gee_priority_queue_iterator_real_has_next (GeeIterator* base)
{
	GeePriorityQueueIterator * self;
	gboolean result = FALSE;
	GeePriorityQueueNode* _tmp0_;
	self = (GeePriorityQueueIterator*) base;
	_tmp0_ = _gee_priority_queue_iterator_get_next_node (self);
	result = _tmp0_ != NULL;
	return result;
}

static inline GeePriorityQueueNode*
_gee_priority_queue_iterator_get_next_node (GeePriorityQueueIterator* self)
{
	GeePriorityQueueNode* result = NULL;
	GeePriorityQueueNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->position;
	if (_tmp0_ != NULL) {
		GeePriorityQueueNode* _tmp1_;
		GeePriorityQueueNode* _tmp2_;
		_tmp1_ = self->position;
		_tmp2_ = _tmp1_->iter_next;
		result = _tmp2_;
		return result;
	} else {
		GeePriorityQueueNode* _tmp3_ = NULL;
		GeePriorityQueueNode* _tmp4_;
		_tmp4_ = self->previous;
		if (_tmp4_ != NULL) {
			GeePriorityQueueNode* _tmp5_;
			GeePriorityQueueNode* _tmp6_;
			_tmp5_ = self->previous;
			_tmp6_ = _tmp5_->iter_next;
			_tmp3_ = _tmp6_;
		} else {
			GeePriorityQueue* _tmp7_;
			GeePriorityQueueNode* _tmp8_;
			_tmp7_ = self->queue;
			_tmp8_ = _tmp7_->priv->_iter_head;
			_tmp3_ = _tmp8_;
		}
		result = _tmp3_;
		return result;
	}
}

static gpointer
gee_priority_queue_iterator_real_get (GeeIterator* base)
{
	GeePriorityQueueIterator * self;
	gpointer result = NULL;
	GeePriorityQueue* _tmp0_;
	GeePriorityQueueNode* _tmp1_;
	GeePriorityQueueNode* _tmp2_;
	gconstpointer _tmp3_;
	gpointer _tmp4_;
	self = (GeePriorityQueueIterator*) base;
	_tmp0_ = self->queue;
	_vala_assert (self->stamp == _tmp0_->priv->_stamp, "stamp == queue._stamp");
	_tmp1_ = self->position;
	_vala_assert (_tmp1_ != NULL, "position != null");
	_tmp2_ = self->position;
	_tmp3_ = _tmp2_->data;
	_tmp4_ = ((_tmp3_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
	result = _tmp4_;
	return result;
}

static void
gee_priority_queue_iterator_real_remove (GeeIterator* base)
{
	GeePriorityQueueIterator * self;
	GeePriorityQueue* _tmp0_;
	GeePriorityQueueNode* _tmp1_;
	GeePriorityQueueDummyNode* dn = NULL;
	GeePriorityQueueNode* _tmp2_;
	GeePriorityQueue* _tmp12_;
	GeePriorityQueueNode* _tmp13_;
	GeePriorityQueueNode* _tmp14_;
	GeePriorityQueueDummyNode* _tmp18_;
	GeePriorityQueue* _tmp19_;
	GeePriorityQueueNode* _tmp20_;
	GeePriorityQueueDummyNode* _tmp24_;
	GeePriorityQueueNode* _tmp25_;
	GeePriorityQueueDummyNode* _tmp29_;
	GeePriorityQueue* _tmp30_;
	GeePriorityQueueNode* _tmp31_;
	gint _tmp34_;
	GeePriorityQueue* _tmp35_;
	self = (GeePriorityQueueIterator*) base;
	_tmp0_ = self->queue;
	_vala_assert (self->stamp == _tmp0_->priv->_stamp, "stamp == queue._stamp");
	_tmp1_ = self->position;
	_vala_assert (_tmp1_ != NULL, "position != null");
	_tmp2_ = self->previous;
	if (_tmp2_ != NULL) {
		GeePriorityQueueNode* _tmp3_;
		GeePriorityQueueNode* _tmp4_;
		GeePriorityQueueNode* _tmp5_;
		GeePriorityQueueNode* _tmp6_;
		GeePriorityQueueDummyNode* _tmp7_;
		_tmp3_ = self->previous;
		_tmp4_ = self->position;
		_tmp5_ = self->previous;
		_tmp6_ = self->position;
		_tmp7_ = gee_priority_queue_dummy_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, &_tmp3_->iter_next, &_tmp4_->iter_prev, _tmp5_, _tmp6_);
		_gee_priority_queue_node_unref0 (dn);
		dn = _tmp7_;
	} else {
		GeePriorityQueue* _tmp8_;
		GeePriorityQueueNode* _tmp9_;
		GeePriorityQueueNode* _tmp10_;
		GeePriorityQueueDummyNode* _tmp11_;
		_tmp8_ = self->queue;
		_tmp9_ = self->position;
		_tmp10_ = self->position;
		_tmp11_ = gee_priority_queue_dummy_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, &_tmp8_->priv->_iter_head, &_tmp9_->iter_prev, NULL, _tmp10_);
		_gee_priority_queue_node_unref0 (dn);
		dn = _tmp11_;
	}
	_tmp12_ = self->queue;
	_tmp13_ = self->position;
	_gee_priority_queue_delete (_tmp12_, _tmp13_);
	self->position = NULL;
	_tmp14_ = self->previous;
	if (_tmp14_ != NULL) {
		GeePriorityQueueNode* _tmp15_;
		GeePriorityQueueDummyNode* _tmp16_;
		GeePriorityQueueNode* _tmp17_;
		_tmp15_ = self->previous;
		_tmp16_ = dn;
		_tmp17_ = ((GeePriorityQueueNode*) _tmp16_)->iter_next;
		_tmp15_->iter_next = _tmp17_;
	}
	_tmp18_ = dn;
	_tmp19_ = self->queue;
	_tmp20_ = _tmp19_->priv->_iter_head;
	if (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode) == _tmp20_) {
		GeePriorityQueue* _tmp21_;
		GeePriorityQueueDummyNode* _tmp22_;
		GeePriorityQueueNode* _tmp23_;
		_tmp21_ = self->queue;
		_tmp22_ = dn;
		_tmp23_ = ((GeePriorityQueueNode*) _tmp22_)->iter_next;
		_tmp21_->priv->_iter_head = _tmp23_;
	}
	_tmp24_ = dn;
	_tmp25_ = ((GeePriorityQueueNode*) _tmp24_)->iter_next;
	if (_tmp25_ != NULL) {
		GeePriorityQueueDummyNode* _tmp26_;
		GeePriorityQueueNode* _tmp27_;
		GeePriorityQueueNode* _tmp28_;
		_tmp26_ = dn;
		_tmp27_ = ((GeePriorityQueueNode*) _tmp26_)->iter_next;
		_tmp28_ = self->previous;
		_tmp27_->iter_prev = _tmp28_;
	}
	_tmp29_ = dn;
	_tmp30_ = self->queue;
	_tmp31_ = _tmp30_->priv->_iter_tail;
	if (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode) == _tmp31_) {
		GeePriorityQueue* _tmp32_;
		GeePriorityQueueNode* _tmp33_;
		_tmp32_ = self->queue;
		_tmp33_ = self->previous;
		_tmp32_->priv->_iter_tail = _tmp33_;
	}
	_tmp34_ = self->stamp;
	self->stamp = _tmp34_ + 1;
	_tmp35_ = self->queue;
	_vala_assert (self->stamp == _tmp35_->priv->_stamp, "stamp == queue._stamp");
	_gee_priority_queue_node_unref0 (dn);
}

static gboolean
gee_priority_queue_iterator_real_foreach (GeeTraversable* base,
                                          GeeForallFunc f,
                                          gpointer f_target)
{
	GeePriorityQueueIterator * self;
	gboolean result = FALSE;
	GeePriorityQueueNode* _tmp0_;
	GeePriorityQueueNode* _tmp7_;
	GeePriorityQueueNode* _tmp8_;
	gconstpointer _tmp9_;
	gpointer _tmp10_;
	self = (GeePriorityQueueIterator*) base;
	_tmp0_ = self->position;
	if (_tmp0_ == NULL) {
		GeePriorityQueueNode* _tmp1_ = NULL;
		GeePriorityQueueNode* _tmp2_;
		_tmp2_ = self->previous;
		if (_tmp2_ != NULL) {
			GeePriorityQueueNode* _tmp3_;
			GeePriorityQueueNode* _tmp4_;
			_tmp3_ = self->previous;
			_tmp4_ = _tmp3_->iter_next;
			_tmp1_ = _tmp4_;
		} else {
			GeePriorityQueue* _tmp5_;
			GeePriorityQueueNode* _tmp6_;
			_tmp5_ = self->queue;
			_tmp6_ = _tmp5_->priv->_iter_head;
			_tmp1_ = _tmp6_;
		}
		self->position = _tmp1_;
	}
	_tmp7_ = self->position;
	if (_tmp7_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp8_ = self->position;
	_tmp9_ = _tmp8_->data;
	_tmp10_ = ((_tmp9_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp9_) : ((gpointer) _tmp9_);
	if (!f (_tmp10_, f_target)) {
		result = FALSE;
		return result;
	}
	while (TRUE) {
		GeePriorityQueueNode* _tmp11_;
		GeePriorityQueueNode* _tmp12_;
		GeePriorityQueueNode* _tmp13_;
		GeePriorityQueueNode* _tmp14_;
		GeePriorityQueueNode* _tmp15_;
		GeePriorityQueueNode* _tmp16_;
		gconstpointer _tmp17_;
		gpointer _tmp18_;
		_tmp11_ = self->position;
		_tmp12_ = _tmp11_->iter_next;
		if (!(_tmp12_ != NULL)) {
			break;
		}
		_tmp13_ = self->position;
		self->previous = _tmp13_;
		_tmp14_ = self->position;
		_tmp15_ = _tmp14_->iter_next;
		self->position = _tmp15_;
		_tmp16_ = self->position;
		_tmp17_ = _tmp16_->data;
		_tmp18_ = ((_tmp17_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp17_) : ((gpointer) _tmp17_);
		if (!f (_tmp18_, f_target)) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

static GeeIterator**
gee_priority_queue_iterator_real_tee (GeeTraversable* base,
                                      guint forks,
                                      gint* result_length1)
{
	GeePriorityQueueIterator * self;
	GeeIterator** result = NULL;
	self = (GeePriorityQueueIterator*) base;
	if (forks == ((guint) 0)) {
		GeeIterator** _tmp0_;
		GeeIterator** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = g_new0 (GeeIterator*, 0 + 1);
		_tmp1_ = _tmp0_;
		_tmp1__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	} else {
		GeeIterator** _result_ = NULL;
		GeeIterator** _tmp2_;
		gint _result__length1;
		gint __result__size_;
		GeeIterator** _tmp3_;
		gint _tmp3__length1;
		GeeIterator* _tmp4_;
		GeeIterator** _tmp9_;
		gint _tmp9__length1;
		_tmp2_ = g_new0 (GeeIterator*, forks + 1);
		_result_ = _tmp2_;
		_result__length1 = forks;
		__result__size_ = _result__length1;
		_tmp3_ = _result_;
		_tmp3__length1 = _result__length1;
		_tmp4_ = _g_object_ref0 ((GeeIterator*) self);
		_g_object_unref0 (_tmp3_[0]);
		_tmp3_[0] = _tmp4_;
		{
			guint i = 0U;
			i = (guint) 1;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					GeeIterator** _tmp7_;
					gint _tmp7__length1;
					GeePriorityQueueIterator* _tmp8_;
					if (!_tmp5_) {
						guint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					if (!(i < forks)) {
						break;
					}
					_tmp7_ = _result_;
					_tmp7__length1 = _result__length1;
					_tmp8_ = gee_priority_queue_iterator_new_from_iterator (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
					_g_object_unref0 (_tmp7_[i]);
					_tmp7_[i] = (GeeIterator*) _tmp8_;
				}
			}
		}
		_tmp9_ = _result_;
		_tmp9__length1 = _result__length1;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		return result;
	}
}

static gboolean
gee_priority_queue_iterator_real_get_read_only (GeeIterator* base)
{
	gboolean result;
	GeePriorityQueueIterator* self;
	self = (GeePriorityQueueIterator*) base;
	result = FALSE;
	return result;
}

static gboolean
gee_priority_queue_iterator_real_get_valid (GeeIterator* base)
{
	gboolean result;
	GeePriorityQueueIterator* self;
	GeePriorityQueueNode* _tmp0_;
	self = (GeePriorityQueueIterator*) base;
	_tmp0_ = self->position;
	result = _tmp0_ != NULL;
	return result;
}

static void
gee_priority_queue_iterator_class_init (GeePriorityQueueIteratorClass * klass,
                                        gpointer klass_data)
{
	gee_priority_queue_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeePriorityQueueIterator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_priority_queue_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_priority_queue_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_priority_queue_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_ITERATOR_READ_ONLY_PROPERTY, gee_priority_queue_iterator_properties[GEE_PRIORITY_QUEUE_ITERATOR_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_ITERATOR_VALID_PROPERTY, gee_priority_queue_iterator_properties[GEE_PRIORITY_QUEUE_ITERATOR_VALID_PROPERTY] = g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_priority_queue_iterator_gee_traversable_get_g_type (GeePriorityQueueIterator* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_priority_queue_iterator_gee_traversable_get_g_dup_func (GeePriorityQueueIterator* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_priority_queue_iterator_gee_traversable_get_g_destroy_func (GeePriorityQueueIterator* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_priority_queue_iterator_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                            gpointer iface_data)
{
	gee_priority_queue_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) gee_priority_queue_iterator_real_foreach;
	iface->tee = (GeeIterator** (*) (GeeTraversable*, guint, gint*)) gee_priority_queue_iterator_real_tee;
	iface->get_g_type = (GType (*) (GeeTraversable *)) gee_priority_queue_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) gee_priority_queue_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) gee_priority_queue_iterator_gee_traversable_get_g_destroy_func;
}

static void
gee_priority_queue_iterator_gee_iterator_interface_init (GeeIteratorIface * iface,
                                                         gpointer iface_data)
{
	gee_priority_queue_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*) (GeeIterator*)) gee_priority_queue_iterator_real_next;
	iface->has_next = (gboolean (*) (GeeIterator*)) gee_priority_queue_iterator_real_has_next;
	iface->get = (gpointer (*) (GeeIterator*)) gee_priority_queue_iterator_real_get;
	iface->remove = (void (*) (GeeIterator*)) gee_priority_queue_iterator_real_remove;
	iface->get_read_only = gee_priority_queue_iterator_real_get_read_only;
	iface->get_valid = gee_priority_queue_iterator_real_get_valid;
}

static void
gee_priority_queue_iterator_instance_init (GeePriorityQueueIterator * self,
                                           gpointer klass)
{
	self->priv = gee_priority_queue_iterator_get_instance_private (self);
}

static void
gee_priority_queue_iterator_finalize (GObject * obj)
{
	GeePriorityQueueIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIterator);
	_g_object_unref0 (self->queue);
	G_OBJECT_CLASS (gee_priority_queue_iterator_parent_class)->finalize (obj);
}

static GType
gee_priority_queue_iterator_get_type (void)
{
	static volatile gsize gee_priority_queue_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_priority_queue_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueIterator), 0, (GInstanceInitFunc) gee_priority_queue_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_priority_queue_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_priority_queue_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_priority_queue_iterator_type_id;
		gee_priority_queue_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeePriorityQueueIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_priority_queue_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (gee_priority_queue_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		GeePriorityQueueIterator_private_offset = g_type_add_instance_private (gee_priority_queue_iterator_type_id, sizeof (GeePriorityQueueIteratorPrivate));
		g_once_init_leave (&gee_priority_queue_iterator_type_id__volatile, gee_priority_queue_iterator_type_id);
	}
	return gee_priority_queue_iterator_type_id__volatile;
}

static void
_vala_gee_priority_queue_iterator_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GeePriorityQueueIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIterator);
	switch (property_id) {
		case GEE_PRIORITY_QUEUE_ITERATOR_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		case GEE_PRIORITY_QUEUE_ITERATOR_VALID_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_priority_queue_iterator_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GeePriorityQueueIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIterator);
	switch (property_id) {
		case GEE_PRIORITY_QUEUE_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_PRIORITY_QUEUE_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_PRIORITY_QUEUE_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
gee_priority_queue_class_init (GeePriorityQueueClass * klass,
                               gpointer klass_data)
{
	gee_priority_queue_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeePriorityQueue_private_offset);
	((GeeAbstractQueueClass *) klass)->peek = (gpointer (*) (GeeAbstractQueue*)) gee_priority_queue_real_peek;
	((GeeAbstractQueueClass *) klass)->poll = (gpointer (*) (GeeAbstractQueue*)) gee_priority_queue_real_poll;
	((GeeAbstractCollectionClass *) klass)->contains = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_priority_queue_real_contains;
	((GeeAbstractCollectionClass *) klass)->add = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_priority_queue_real_add;
	((GeeAbstractCollectionClass *) klass)->remove = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_priority_queue_real_remove;
	((GeeAbstractCollectionClass *) klass)->clear = (void (*) (GeeAbstractCollection*)) gee_priority_queue_real_clear;
	((GeeAbstractCollectionClass *) klass)->iterator = (GeeIterator* (*) (GeeAbstractCollection*)) gee_priority_queue_real_iterator;
	((GeeAbstractCollectionClass *) klass)->foreach = (gboolean (*) (GeeAbstractCollection*, GeeForallFunc, gpointer)) gee_priority_queue_real_foreach;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_capacity = gee_priority_queue_real_get_capacity;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_remaining_capacity = gee_priority_queue_real_get_remaining_capacity;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_is_full = gee_priority_queue_real_get_is_full;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_priority_queue_real_get_read_only;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_priority_queue_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_priority_queue_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_priority_queue_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_priority_queue_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_CAPACITY_PROPERTY, gee_priority_queue_properties[GEE_PRIORITY_QUEUE_CAPACITY_PROPERTY] = g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_REMAINING_CAPACITY_PROPERTY, gee_priority_queue_properties[GEE_PRIORITY_QUEUE_REMAINING_CAPACITY_PROPERTY] = g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_IS_FULL_PROPERTY, gee_priority_queue_properties[GEE_PRIORITY_QUEUE_IS_FULL_PROPERTY] = g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_READ_ONLY_PROPERTY, gee_priority_queue_properties[GEE_PRIORITY_QUEUE_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_SIZE_PROPERTY, gee_priority_queue_properties[GEE_PRIORITY_QUEUE_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gee_priority_queue_instance_init (GeePriorityQueue * self,
                                  gpointer klass)
{
	gboolean* _tmp0_;
	self->priv = gee_priority_queue_get_instance_private (self);
	self->priv->_size = 0;
	self->priv->_stamp = 0;
	self->priv->_r = NULL;
	self->priv->_r_prime = NULL;
	self->priv->_lm_head = NULL;
	self->priv->_lm_tail = NULL;
	self->priv->_p = NULL;
	self->priv->_lp_head = NULL;
	self->priv->_lp_tail = NULL;
	_tmp0_ = g_new0 (gboolean, 0);
	self->priv->_b = _tmp0_;
	self->priv->_b_length1 = 0;
	self->priv->__b_size_ = self->priv->_b_length1;
	self->priv->_ll_head = NULL;
	self->priv->_ll_tail = NULL;
	self->priv->_iter_head = NULL;
	self->priv->_iter_tail = NULL;
}

static void
gee_priority_queue_finalize (GObject * obj)
{
	GeePriorityQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueue);
	_gee_priority_queue_node_unref0 (self->priv->_r);
	_gee_priority_queue_node_unref0 (self->priv->_r_prime);
	_gee_priority_queue_node_unref0 (self->priv->_lm_head);
	_gee_priority_queue_node_unref0 (self->priv->_lm_tail);
	_gee_priority_queue_node_unref0 (self->priv->_p);
	self->priv->_a = (_vala_array_free (self->priv->_a, self->priv->_a_length1, (GDestroyNotify) gee_priority_queue_node_unref), NULL);
	_gee_priority_queue_node_pair_free0 (self->priv->_lp_head);
	self->priv->_b = (g_free (self->priv->_b), NULL);
	_gee_priority_queue_node_unref0 (self->priv->_ll_head);
	_gee_priority_queue_node_unref0 (self->priv->_ll_tail);
	(self->priv->_compare_func_target_destroy_notify == NULL) ? NULL : (self->priv->_compare_func_target_destroy_notify (self->priv->_compare_func_target), NULL);
	self->priv->_compare_func = NULL;
	self->priv->_compare_func_target = NULL;
	self->priv->_compare_func_target_destroy_notify = NULL;
	G_OBJECT_CLASS (gee_priority_queue_parent_class)->finalize (obj);
}

/**
 * Relaxed fibonacci heap priority queue implementation of the {@link Queue}.
 *
 * The elements of the priority queue are ordered according to their natural
 * ordering, or by a compare_func provided at queue construction time. A
 * priority queue does not permit null elements and does not have bounded
 * capacity.
 *
 * This implementation provides O(1) time for offer and peek methods, and
 * O(log n) for poll method. It is based on the algorithms described by
 * Boyapati Chandra Sekhar in:
 *
 *   "Worst Case Efficient Data Structures
 *      for Priority Queues and Deques with Heap Order"
 *   Boyapati Chandra Sekhar (under the guidance of Prof. C. Pandu Rangan)
 *   Department of Computer Science and Engineering
 *   Indian Institute of Technology, Madras
 *   May 1996
 */
GType
gee_priority_queue_get_type (void)
{
	static volatile gsize gee_priority_queue_type_id__volatile = 0;
	if (g_once_init_enter (&gee_priority_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueue), 0, (GInstanceInitFunc) gee_priority_queue_instance_init, NULL };
		GType gee_priority_queue_type_id;
		gee_priority_queue_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_QUEUE, "GeePriorityQueue", &g_define_type_info, 0);
		GeePriorityQueue_private_offset = g_type_add_instance_private (gee_priority_queue_type_id, sizeof (GeePriorityQueuePrivate));
		g_once_init_leave (&gee_priority_queue_type_id__volatile, gee_priority_queue_type_id);
	}
	return gee_priority_queue_type_id__volatile;
}

static void
_vala_gee_priority_queue_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GeePriorityQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueue);
	switch (property_id) {
		case GEE_PRIORITY_QUEUE_CAPACITY_PROPERTY:
		g_value_set_int (value, gee_abstract_queue_get_capacity ((GeeAbstractQueue*) self));
		break;
		case GEE_PRIORITY_QUEUE_REMAINING_CAPACITY_PROPERTY:
		g_value_set_int (value, gee_abstract_queue_get_remaining_capacity ((GeeAbstractQueue*) self));
		break;
		case GEE_PRIORITY_QUEUE_IS_FULL_PROPERTY:
		g_value_set_boolean (value, gee_abstract_queue_get_is_full ((GeeAbstractQueue*) self));
		break;
		case GEE_PRIORITY_QUEUE_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
		break;
		case GEE_PRIORITY_QUEUE_SIZE_PROPERTY:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_priority_queue_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GeePriorityQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueue);
	switch (property_id) {
		case GEE_PRIORITY_QUEUE_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_PRIORITY_QUEUE_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_PRIORITY_QUEUE_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

