// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use AppInfo;
use AppLaunchContext;
use ffi;
use glib;
use glib::GString;
use glib::object::IsA;
use glib::translate::*;
use std;
use std::fmt;

glib_wrapper! {
    pub struct DesktopAppInfo(Object<ffi::GDesktopAppInfo, ffi::GDesktopAppInfoClass, DesktopAppInfoClass>) @implements AppInfo;

    match fn {
        get_type => || ffi::g_desktop_app_info_get_type(),
    }
}

impl DesktopAppInfo {
    pub fn new(desktop_id: &str) -> Option<DesktopAppInfo> {
        unsafe {
            from_glib_full(ffi::g_desktop_app_info_new(desktop_id.to_glib_none().0))
        }
    }

    pub fn new_from_filename<P: AsRef<std::path::Path>>(filename: P) -> Option<DesktopAppInfo> {
        unsafe {
            from_glib_full(ffi::g_desktop_app_info_new_from_filename(filename.as_ref().to_glib_none().0))
        }
    }

    pub fn new_from_keyfile(key_file: &glib::KeyFile) -> Option<DesktopAppInfo> {
        unsafe {
            from_glib_full(ffi::g_desktop_app_info_new_from_keyfile(key_file.to_glib_none().0))
        }
    }

    pub fn get_implementations(interface: &str) -> Vec<DesktopAppInfo> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::g_desktop_app_info_get_implementations(interface.to_glib_none().0))
        }
    }
}

pub const NONE_DESKTOP_APP_INFO: Option<&DesktopAppInfo> = None;

pub trait DesktopAppInfoExt: 'static {
    fn get_action_name(&self, action_name: &str) -> Option<GString>;

    fn get_boolean(&self, key: &str) -> bool;

    fn get_categories(&self) -> Option<GString>;

    fn get_filename(&self) -> Option<std::path::PathBuf>;

    fn get_generic_name(&self) -> Option<GString>;

    fn get_is_hidden(&self) -> bool;

    fn get_keywords(&self) -> Vec<GString>;

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    fn get_locale_string(&self, key: &str) -> Option<GString>;

    fn get_nodisplay(&self) -> bool;

    fn get_show_in<'a, P: Into<Option<&'a str>>>(&self, desktop_env: P) -> bool;

    fn get_startup_wm_class(&self) -> Option<GString>;

    fn get_string(&self, key: &str) -> Option<GString>;

    fn has_key(&self, key: &str) -> bool;

    fn launch_action<'a, P: IsA<AppLaunchContext> + 'a, Q: Into<Option<&'a P>>>(&self, action_name: &str, launch_context: Q);

    //fn launch_uris_as_manager<'a, P: IsA<AppLaunchContext> + 'a, Q: Into<Option<&'a P>>>(&self, uris: &[&str], launch_context: Q, spawn_flags: /*Ignored*/glib::SpawnFlags, user_setup: /*Ignored*/glib::Option<Box<dyn FnOnce() + 'static>>, user_setup_data: /*Unimplemented*/Option<Fundamental: Pointer>, pid_callback: /*Unimplemented*/FnMut(&DesktopAppInfo, /*Ignored*/glib::Pid), pid_callback_data: /*Unimplemented*/Option<Fundamental: Pointer>) -> Result<(), Error>;

    //#[cfg(any(feature = "v2_58", feature = "dox"))]
    //fn launch_uris_as_manager_with_fds<'a, P: IsA<AppLaunchContext> + 'a, Q: Into<Option<&'a P>>>(&self, uris: &[&str], launch_context: Q, spawn_flags: /*Ignored*/glib::SpawnFlags, user_setup: /*Ignored*/glib::Option<Box<dyn FnOnce() + 'static>>, user_setup_data: /*Unimplemented*/Option<Fundamental: Pointer>, pid_callback: /*Unimplemented*/FnMut(&DesktopAppInfo, /*Ignored*/glib::Pid), pid_callback_data: /*Unimplemented*/Option<Fundamental: Pointer>, stdin_fd: i32, stdout_fd: i32, stderr_fd: i32) -> Result<(), Error>;

    fn list_actions(&self) -> Vec<GString>;
}

impl<O: IsA<DesktopAppInfo>> DesktopAppInfoExt for O {
    fn get_action_name(&self, action_name: &str) -> Option<GString> {
        unsafe {
            from_glib_full(ffi::g_desktop_app_info_get_action_name(self.as_ref().to_glib_none().0, action_name.to_glib_none().0))
        }
    }

    fn get_boolean(&self, key: &str) -> bool {
        unsafe {
            from_glib(ffi::g_desktop_app_info_get_boolean(self.as_ref().to_glib_none().0, key.to_glib_none().0))
        }
    }

    fn get_categories(&self) -> Option<GString> {
        unsafe {
            from_glib_none(ffi::g_desktop_app_info_get_categories(self.as_ref().to_glib_none().0))
        }
    }

    fn get_filename(&self) -> Option<std::path::PathBuf> {
        unsafe {
            from_glib_none(ffi::g_desktop_app_info_get_filename(self.as_ref().to_glib_none().0))
        }
    }

    fn get_generic_name(&self) -> Option<GString> {
        unsafe {
            from_glib_none(ffi::g_desktop_app_info_get_generic_name(self.as_ref().to_glib_none().0))
        }
    }

    fn get_is_hidden(&self) -> bool {
        unsafe {
            from_glib(ffi::g_desktop_app_info_get_is_hidden(self.as_ref().to_glib_none().0))
        }
    }

    fn get_keywords(&self) -> Vec<GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::g_desktop_app_info_get_keywords(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    fn get_locale_string(&self, key: &str) -> Option<GString> {
        unsafe {
            from_glib_full(ffi::g_desktop_app_info_get_locale_string(self.as_ref().to_glib_none().0, key.to_glib_none().0))
        }
    }

    fn get_nodisplay(&self) -> bool {
        unsafe {
            from_glib(ffi::g_desktop_app_info_get_nodisplay(self.as_ref().to_glib_none().0))
        }
    }

    fn get_show_in<'a, P: Into<Option<&'a str>>>(&self, desktop_env: P) -> bool {
        let desktop_env = desktop_env.into();
        unsafe {
            from_glib(ffi::g_desktop_app_info_get_show_in(self.as_ref().to_glib_none().0, desktop_env.to_glib_none().0))
        }
    }

    fn get_startup_wm_class(&self) -> Option<GString> {
        unsafe {
            from_glib_none(ffi::g_desktop_app_info_get_startup_wm_class(self.as_ref().to_glib_none().0))
        }
    }

    fn get_string(&self, key: &str) -> Option<GString> {
        unsafe {
            from_glib_full(ffi::g_desktop_app_info_get_string(self.as_ref().to_glib_none().0, key.to_glib_none().0))
        }
    }

    fn has_key(&self, key: &str) -> bool {
        unsafe {
            from_glib(ffi::g_desktop_app_info_has_key(self.as_ref().to_glib_none().0, key.to_glib_none().0))
        }
    }

    fn launch_action<'a, P: IsA<AppLaunchContext> + 'a, Q: Into<Option<&'a P>>>(&self, action_name: &str, launch_context: Q) {
        let launch_context = launch_context.into();
        unsafe {
            ffi::g_desktop_app_info_launch_action(self.as_ref().to_glib_none().0, action_name.to_glib_none().0, launch_context.map(|p| p.as_ref()).to_glib_none().0);
        }
    }

    //fn launch_uris_as_manager<'a, P: IsA<AppLaunchContext> + 'a, Q: Into<Option<&'a P>>>(&self, uris: &[&str], launch_context: Q, spawn_flags: /*Ignored*/glib::SpawnFlags, user_setup: /*Ignored*/glib::Option<Box<dyn FnOnce() + 'static>>, user_setup_data: /*Unimplemented*/Option<Fundamental: Pointer>, pid_callback: /*Unimplemented*/FnMut(&DesktopAppInfo, /*Ignored*/glib::Pid), pid_callback_data: /*Unimplemented*/Option<Fundamental: Pointer>) -> Result<(), Error> {
    //    unsafe { TODO: call ffi::g_desktop_app_info_launch_uris_as_manager() }
    //}

    //#[cfg(any(feature = "v2_58", feature = "dox"))]
    //fn launch_uris_as_manager_with_fds<'a, P: IsA<AppLaunchContext> + 'a, Q: Into<Option<&'a P>>>(&self, uris: &[&str], launch_context: Q, spawn_flags: /*Ignored*/glib::SpawnFlags, user_setup: /*Ignored*/glib::Option<Box<dyn FnOnce() + 'static>>, user_setup_data: /*Unimplemented*/Option<Fundamental: Pointer>, pid_callback: /*Unimplemented*/FnMut(&DesktopAppInfo, /*Ignored*/glib::Pid), pid_callback_data: /*Unimplemented*/Option<Fundamental: Pointer>, stdin_fd: i32, stdout_fd: i32, stderr_fd: i32) -> Result<(), Error> {
    //    unsafe { TODO: call ffi::g_desktop_app_info_launch_uris_as_manager_with_fds() }
    //}

    fn list_actions(&self) -> Vec<GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::g_desktop_app_info_list_actions(self.as_ref().to_glib_none().0))
        }
    }
}

impl fmt::Display for DesktopAppInfo {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "DesktopAppInfo")
    }
}
