// Generated by gmmproc 2.61.1 -- DO NOT MODIFY!
#ifndef _GTKMM_MEDIAFILE_H
#define _GTKMM_MEDIAFILE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2018 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/mediastream.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkMediaFile = struct _GtkMediaFile;
using GtkMediaFileClass = struct _GtkMediaFileClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class MediaFile_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gio
{
class File;
class InputStream;
}

namespace Gtk
{

/** Open media files for use in GTK.
 *
 * %MediaFile is the implementation for media file usage with MediaStream.
 *
 * This provides a simple way to play back video files with GTK.
 *
 * GTK+ provides a GIO extension point for %Gtk::MediaFile implementations
 * to allow for external implementations using various media frameworks.
 * GTK+ itself includes implementations using GStreamer and ffmpeg.
 *
 * @see Gtk:MediaStream, Gtk::Video
 *
 * @newin{3,94}
 */

class MediaFile : public Gtk::MediaStream
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = MediaFile;
  using CppClassType = MediaFile_Class;
  using BaseObjectType = GtkMediaFile;
  using BaseClassType = GtkMediaFileClass;

  // noncopyable
  MediaFile(const MediaFile&) = delete;
  MediaFile& operator=(const MediaFile&) = delete;

private:  friend class MediaFile_Class;
  static CppClassType mediafile_class_;

protected:
  explicit MediaFile(const Glib::ConstructParams& construct_params);
  explicit MediaFile(GtkMediaFile* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  MediaFile(MediaFile&& src) noexcept;
  MediaFile& operator=(MediaFile&& src) noexcept;

  ~MediaFile() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkMediaFile*       gobj()       { return reinterpret_cast<GtkMediaFile*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkMediaFile* gobj() const { return reinterpret_cast<GtkMediaFile*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkMediaFile* gobj_copy();

private:


protected:
  MediaFile();

public:
 

  // All gdk_media_file_new_*() functions do more than call g_object_new().
  
  /** Creates a new empty media file.
   * 
   * @return A new Gtk::MediaFile.
   */
  static Glib::RefPtr<MediaFile> create();
  
  /** This is a utility function that converts the given @a filename
   * to a Gio::File and calls new_for_file().
   * 
   * @param filename Filename to open.
   * @return A new Gtk::MediaFile playing @a filename.
   */
  static Glib::RefPtr<MediaFile> create_for_filename(const std::string& filename);
  
  /** This is a utility function that converts the given @a resource
   * to a Gio::File and calls new_for_file().
   * 
   * @param resource_path Resource path to open.
   * @return A new Gtk::MediaFile playing @a resource_path.
   */
  static Glib::RefPtr<MediaFile> create_for_resource(const std::string& resource_path);
  
  /** Creates a new media file to play @a file.
   * 
   * @param file The file to play.
   * @return A new Gtk::MediaFile playing @a file.
   */
  static Glib::RefPtr<MediaFile> create(const Glib::RefPtr<Gio::File>& file);
  
  /** Creates a new media file to play @a stream. If you want the
   * resulting media to be seekable, the stream should implement
   * the Seekable interface.
   * 
   * @param stream The stream to play.
   * @return A new Gtk::MediaFile.
   */
  static Glib::RefPtr<MediaFile> create(const Glib::RefPtr<Gio::InputStream>& stream);

  
  /** Resets the media file to be empty.
   */
  void clear();
  
  /** This is a utility function that converts the given @a filename
   * to a Gio::File and calls set_file().
   * 
   * @param filename Name of file to play.
   */
  void set_filename(const std::string& filename);
  
  /** This is a utility function that converts the given @a resource_path
   * to a Gio::File and calls set_file().
   * 
   * @param resource_path Path to resource to play.
   */
  void set_resource(const std::string& resource_path);

  
  /** If any file is still playing, stop playing it.
   * 
   * Then start playing the given @a file.
   * 
   * @param file The file to play.
   */
  void set_file(const Glib::RefPtr<Gio::File>& file);
  
  /** Returns the file that @a self is currently playing from.
   * 
   * When @a self is not playing or not playing from a file,
   * <tt>nullptr</tt> is returned.
   * 
   * @return The currently playing file or <tt>nullptr</tt> if not
   * playing from a file.
   */
  Glib::RefPtr<Gio::File> get_file();
  
  /** Returns the file that @a self is currently playing from.
   * 
   * When @a self is not playing or not playing from a file,
   * <tt>nullptr</tt> is returned.
   * 
   * @return The currently playing file or <tt>nullptr</tt> if not
   * playing from a file.
   */
  Glib::RefPtr<const Gio::File> get_file() const;

  
  /** If anything is still playing, stop playing it. Then start
   * playing the given @a stream.
   * 
   * Full control about the @a stream is assumed for the duration of
   * playback. The stream will not bt be closed.
   * 
   * @param stream The stream to play from.
   */
  void set_input_stream(const Glib::RefPtr<Gio::InputStream>& stream);
  
  /** Returns the stream that @a self is currently playing from.
   * 
   * When @a self is not playing or not playing from a stream,
   * <tt>nullptr</tt> is returned.
   * 
   * @return The currently playing stream or <tt>nullptr</tt> if not
   * playing from a stream.
   */
  Glib::RefPtr<Gio::InputStream> get_input_stream();
  
  /** Returns the stream that @a self is currently playing from.
   * 
   * When @a self is not playing or not playing from a stream,
   * <tt>nullptr</tt> is returned.
   * 
   * @return The currently playing stream or <tt>nullptr</tt> if not
   * playing from a stream.
   */
  Glib::RefPtr<const Gio::InputStream> get_input_stream() const;
  
  /** The file being played back or <tt>nullptr</tt> if not playing a file.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::File> > property_file() ;

/** The file being played back or <tt>nullptr</tt> if not playing a file.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::File> > property_file() const;

  /** The stream being played back or <tt>nullptr</tt> if not playing a stream, like when playing a file.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::InputStream> > property_input_stream() ;

/** The stream being played back or <tt>nullptr</tt> if not playing a stream, like when playing a file.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::InputStream> > property_input_stream() const;


protected:
    virtual void open_vfunc();

    virtual void close_vfunc();


  // There are no signals.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::MediaFile
   */
  Glib::RefPtr<Gtk::MediaFile> wrap(GtkMediaFile* object, bool take_copy = false);
}


#endif /* _GTKMM_MEDIAFILE_H */

