// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Converter;
use FileInfo;
use ZlibCompressorFormat;
use ffi;
use glib::StaticType;
use glib::Value;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect_raw;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib_wrapper! {
    pub struct ZlibCompressor(Object<ffi::GZlibCompressor, ffi::GZlibCompressorClass, ZlibCompressorClass>) @implements Converter;

    match fn {
        get_type => || ffi::g_zlib_compressor_get_type(),
    }
}

impl ZlibCompressor {
    pub fn new(format: ZlibCompressorFormat, level: i32) -> ZlibCompressor {
        unsafe {
            from_glib_full(ffi::g_zlib_compressor_new(format.to_glib(), level))
        }
    }
}

pub const NONE_ZLIB_COMPRESSOR: Option<&ZlibCompressor> = None;

pub trait ZlibCompressorExt: 'static {
    fn get_file_info(&self) -> Option<FileInfo>;

    fn set_file_info<'a, P: IsA<FileInfo> + 'a, Q: Into<Option<&'a P>>>(&self, file_info: Q);

    fn get_property_format(&self) -> ZlibCompressorFormat;

    fn get_property_level(&self) -> i32;

    fn connect_property_file_info_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<ZlibCompressor>> ZlibCompressorExt for O {
    fn get_file_info(&self) -> Option<FileInfo> {
        unsafe {
            from_glib_none(ffi::g_zlib_compressor_get_file_info(self.as_ref().to_glib_none().0))
        }
    }

    fn set_file_info<'a, P: IsA<FileInfo> + 'a, Q: Into<Option<&'a P>>>(&self, file_info: Q) {
        let file_info = file_info.into();
        unsafe {
            ffi::g_zlib_compressor_set_file_info(self.as_ref().to_glib_none().0, file_info.map(|p| p.as_ref()).to_glib_none().0);
        }
    }

    fn get_property_format(&self) -> ZlibCompressorFormat {
        unsafe {
            let mut value = Value::from_type(<ZlibCompressorFormat as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut gobject_ffi::GObject, b"format\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_level(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut gobject_ffi::GObject, b"level\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn connect_property_file_info_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::file-info\0".as_ptr() as *const _,
                Some(transmute(notify_file_info_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }
}

unsafe extern "C" fn notify_file_info_trampoline<P, F: Fn(&P) + 'static>(this: *mut ffi::GZlibCompressor, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<ZlibCompressor> {
    let f: &F = transmute(f);
    f(&ZlibCompressor::from_glib_borrow(this).unsafe_cast())
}

impl fmt::Display for ZlibCompressor {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "ZlibCompressor")
    }
}
