// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Cancellable;
use Error;
use IOStream;
use ProxyAddress;
use ffi;
#[cfg(feature = "futures")]
use futures_core;
use glib;
use glib::object::IsA;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
#[cfg(feature = "futures")]
use std::boxed::Box as Box_;
use std::mem;
use std::ptr;

glib_wrapper! {
    pub struct Proxy(Object<ffi::GProxy, ffi::GProxyInterface>);

    match fn {
        get_type => || ffi::g_proxy_get_type(),
    }
}

impl Proxy {
    pub fn get_default_for_protocol(protocol: &str) -> Option<Proxy> {
        unsafe {
            from_glib_full(ffi::g_proxy_get_default_for_protocol(protocol.to_glib_none().0))
        }
    }
}

pub trait ProxyExt: Sized {
    fn connect<'a, P: IsA<IOStream>, Q: Into<Option<&'a Cancellable>>>(&self, connection: &P, proxy_address: &ProxyAddress, cancellable: Q) -> Result<IOStream, Error>;

    fn connect_async<'a, P: IsA<IOStream>, Q: Into<Option<&'a Cancellable>>, R: FnOnce(Result<IOStream, Error>) + Send + 'static>(&self, connection: &P, proxy_address: &ProxyAddress, cancellable: Q, callback: R);

    #[cfg(feature = "futures")]
    fn connect_async_future<P: IsA<IOStream> + Clone + 'static>(&self, connection: &P, proxy_address: &ProxyAddress) -> Box_<futures_core::Future<Item = (Self, IOStream), Error = (Self, Error)>>;

    fn supports_hostname(&self) -> bool;
}

impl<O: IsA<Proxy> + IsA<glib::object::Object> + Clone + 'static> ProxyExt for O {
    fn connect<'a, P: IsA<IOStream>, Q: Into<Option<&'a Cancellable>>>(&self, connection: &P, proxy_address: &ProxyAddress, cancellable: Q) -> Result<IOStream, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_proxy_connect(self.to_glib_none().0, connection.to_glib_none().0, proxy_address.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn connect_async<'a, P: IsA<IOStream>, Q: Into<Option<&'a Cancellable>>, R: FnOnce(Result<IOStream, Error>) + Send + 'static>(&self, connection: &P, proxy_address: &ProxyAddress, cancellable: Q, callback: R) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<R>> = Box::new(Box::new(callback));
        unsafe extern "C" fn connect_async_trampoline<R: FnOnce(Result<IOStream, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            let mut error = ptr::null_mut();
            let ret = ffi::g_proxy_connect_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<R>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = connect_async_trampoline::<R>;
        unsafe {
            ffi::g_proxy_connect_async(self.to_glib_none().0, connection.to_glib_none().0, proxy_address.to_glib_none().0, cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    #[cfg(feature = "futures")]
    fn connect_async_future<P: IsA<IOStream> + Clone + 'static>(&self, connection: &P, proxy_address: &ProxyAddress) -> Box_<futures_core::Future<Item = (Self, IOStream), Error = (Self, Error)>> {
        use GioFuture;
        use fragile::Fragile;

        let connection = connection.clone();
        let proxy_address = proxy_address.clone();
        GioFuture::new(self, move |obj, send| {
            let cancellable = Cancellable::new();
            let send = Fragile::new(send);
            let obj_clone = Fragile::new(obj.clone());
            obj.connect_async(
                 &connection,
                 &proxy_address,
                 Some(&cancellable),
                 move |res| {
                     let obj = obj_clone.into_inner();
                     let res = res.map(|v| (obj.clone(), v)).map_err(|v| (obj.clone(), v));
                     let _ = send.into_inner().send(res);
                 },
            );

            cancellable
        })
    }

    fn supports_hostname(&self) -> bool {
        unsafe {
            from_glib(ffi::g_proxy_supports_hostname(self.to_glib_none().0))
        }
    }
}
