/* rygel-http-byte-seek-request.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-http-byte-seek-request.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <glib.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST (rygel_http_byte_seek_request_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))

typedef struct _RygelHTTPByteSeekRequest RygelHTTPByteSeekRequest;
typedef struct _RygelHTTPByteSeekRequestClass RygelHTTPByteSeekRequestClass;
typedef struct _RygelHTTPByteSeekRequestPrivate RygelHTTPByteSeekRequestPrivate;
enum  {
	RYGEL_HTTP_BYTE_SEEK_REQUEST_0_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_NUM_PROPERTIES
};
static GParamSpec* rygel_http_byte_seek_request_properties[RYGEL_HTTP_BYTE_SEEK_REQUEST_NUM_PROPERTIES];

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelHTTPByteSeekRequestPrivate * priv;
};

struct _RygelHTTPByteSeekRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

struct _RygelHTTPByteSeekRequestPrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gint RygelHTTPByteSeekRequest_private_offset;
static gpointer rygel_http_byte_seek_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPSeekRequest, g_object_unref)
GType rygel_http_byte_seek_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPByteSeekRequest, g_object_unref)
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPGetHandler, g_object_unref)
GQuark rygel_http_seek_request_error_quark (void);
GQuark rygel_http_request_error_quark (void);
RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_new (SoupMessage* msg,
                                                            RygelHTTPGetHandler* handler,
                                                            GError** error);
RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_construct (GType object_type,
                                                                  SoupMessage* msg,
                                                                  RygelHTTPGetHandler* handler,
                                                                  GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
gint64 rygel_http_get_handler_get_resource_size (RygelHTTPGetHandler* self);
#define RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED ((gint64) -1)
static gchar* rygel_http_byte_seek_request_strip_leading_zeros (const gchar* number_string);
static void rygel_http_byte_seek_request_set_range_length (RygelHTTPByteSeekRequest* self,
                                                    gint64 value);
void rygel_http_byte_seek_request_set_start_byte (RygelHTTPByteSeekRequest* self,
                                                  gint64 value);
void rygel_http_byte_seek_request_set_end_byte (RygelHTTPByteSeekRequest* self,
                                                gint64 value);
void rygel_http_byte_seek_request_set_total_size (RygelHTTPByteSeekRequest* self,
                                                  gint64 value);
gboolean rygel_http_byte_seek_request_supported (SoupMessage* message,
                                                 RygelHTTPGetHandler* handler);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelClientHacks, g_object_unref)
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message,
                                             GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
gboolean rygel_http_get_handler_supports_byte_seek (RygelHTTPGetHandler* self);
gboolean rygel_http_byte_seek_request_requested (SoupMessage* msg);
gint64 rygel_http_byte_seek_request_get_start_byte (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_end_byte (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_range_length (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_total_size (RygelHTTPByteSeekRequest* self);
static void rygel_http_byte_seek_request_finalize (GObject * obj);
static void _vala_rygel_http_byte_seek_request_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_rygel_http_byte_seek_request_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
rygel_http_byte_seek_request_get_instance_private (RygelHTTPByteSeekRequest* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPByteSeekRequest_private_offset);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar* * unparsed)
{
	gint64 _vala__result_ = 0LL;
	const gchar* _vala_unparsed = NULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, (guint) 0);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = TRUE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala__result_;
	}
	if (unparsed) {
		*unparsed = _vala_unparsed;
	}
}

RygelHTTPByteSeekRequest*
rygel_http_byte_seek_request_construct (GType object_type,
                                        SoupMessage* msg,
                                        RygelHTTPGetHandler* handler,
                                        GError** error)
{
	RygelHTTPByteSeekRequest * self = NULL;
	const gchar* range = NULL;
	SoupMessageHeaders* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint64 start_byte = 0LL;
	gint64 end_byte = 0LL;
	gint64 total_size = 0LL;
	const gchar* _tmp4_;
	gchar* parsed_range = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** range_tokens = NULL;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint range_tokens_length1;
	gint _range_tokens_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gint64 _tmp19_ = 0LL;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gchar** _tmp30_;
	gint _tmp30__length1;
	const gchar* _tmp31_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (msg != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	self = (RygelHTTPByteSeekRequest*) rygel_http_seek_request_construct (object_type);
	_tmp0_ = msg->request_headers;
	_tmp1_ = soup_message_headers_get_one (_tmp0_, "Range");
	range = _tmp1_;
	_tmp2_ = range;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Range header not present");
		_inner_error0_ = _tmp3_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	total_size = rygel_http_get_handler_get_resource_size (handler);
	if (total_size < ((gint64) 0)) {
		total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	}
	_tmp4_ = range;
	if (!g_str_has_prefix (_tmp4_, "bytes=")) {
		gchar* message = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
		_tmp5_ = g_strdup ("Invalid Range value (missing 'bytes=' field): '%s'");
		message = _tmp5_;
		_tmp6_ = message;
		_tmp7_ = range;
		_tmp8_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp6_, _tmp7_);
		_inner_error0_ = _tmp8_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (message);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (message);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (message);
	}
	_tmp9_ = range;
	_tmp10_ = string_substring (_tmp9_, (glong) 6, (glong) -1);
	parsed_range = _tmp10_;
	if (!string_contains (parsed_range, "-")) {
		const gchar* _tmp11_;
		GError* _tmp12_;
		_tmp11_ = range;
		_tmp12_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range request with no '-': '%s'", _tmp11_);
		_inner_error0_ = _tmp12_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (parsed_range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (parsed_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp14_ = _tmp13_ = g_strsplit (parsed_range, "-", 2);
	range_tokens = _tmp14_;
	range_tokens_length1 = _vala_array_length (_tmp13_);
	_range_tokens_size_ = range_tokens_length1;
	_tmp15_ = range_tokens;
	_tmp15__length1 = range_tokens_length1;
	_tmp16_ = _tmp15_[0];
	_tmp17_ = rygel_http_byte_seek_request_strip_leading_zeros (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp20_ = int64_try_parse (_tmp18_, &_tmp19_, NULL);
	start_byte = _tmp19_;
	_tmp21_ = !_tmp20_;
	_g_free0 (_tmp18_);
	if (_tmp21_) {
		const gchar* _tmp22_;
		GError* _tmp23_;
		_tmp22_ = range;
		_tmp23_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range start value: '%s'", _tmp22_);
		_inner_error0_ = _tmp23_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (total_size != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		_tmp24_ = start_byte >= total_size;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gchar* message = NULL;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		GError* _tmp28_;
		_tmp25_ = g_strdup ("Range start value %lld is larger than content size %lld: '%s'");
		message = _tmp25_;
		_tmp26_ = message;
		_tmp27_ = range;
		_tmp28_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp26_, start_byte, total_size, _tmp27_);
		_inner_error0_ = _tmp28_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (message);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (message);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (message);
	}
	_tmp30_ = range_tokens;
	_tmp30__length1 = range_tokens_length1;
	_tmp31_ = _tmp30_[1];
	if (_tmp31_ == NULL) {
		_tmp29_ = TRUE;
	} else {
		gchar** _tmp32_;
		gint _tmp32__length1;
		const gchar* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp32_ = range_tokens;
		_tmp32__length1 = range_tokens_length1;
		_tmp33_ = _tmp32_[1];
		_tmp34_ = strlen (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp29_ = _tmp35_ == 0;
	}
	if (_tmp29_) {
		if (total_size != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
			end_byte = total_size - 1;
			rygel_http_byte_seek_request_set_range_length (self, (end_byte - start_byte) + 1);
		} else {
			end_byte = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
			rygel_http_byte_seek_request_set_range_length (self, RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED);
		}
	} else {
		gchar** _tmp36_;
		gint _tmp36__length1;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gint64 _tmp40_ = 0LL;
		gboolean _tmp41_;
		gboolean _tmp42_;
		gboolean _tmp49_ = FALSE;
		_tmp36_ = range_tokens;
		_tmp36__length1 = range_tokens_length1;
		_tmp37_ = _tmp36_[1];
		_tmp38_ = rygel_http_byte_seek_request_strip_leading_zeros (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp41_ = int64_try_parse (_tmp39_, &_tmp40_, NULL);
		end_byte = _tmp40_;
		_tmp42_ = !_tmp41_;
		_g_free0 (_tmp39_);
		if (_tmp42_) {
			const gchar* _tmp43_;
			GError* _tmp44_;
			_tmp43_ = range;
			_tmp44_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range end value: '%s'", _tmp43_);
			_inner_error0_ = _tmp44_;
			if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		if (end_byte < start_byte) {
			gchar* message = NULL;
			gchar* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			GError* _tmp48_;
			_tmp45_ = g_strdup ("Range end value %lld is smaller than range start value %lld: '%s'");
			message = _tmp45_;
			_tmp46_ = message;
			_tmp47_ = range;
			_tmp48_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp46_, end_byte, start_byte, _tmp47_);
			_inner_error0_ = _tmp48_;
			if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (message);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (message);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_free0 (message);
		}
		if (total_size != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
			_tmp49_ = end_byte >= total_size;
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			end_byte = total_size - 1;
		}
		rygel_http_byte_seek_request_set_range_length (self, (end_byte - start_byte) + 1);
	}
	rygel_http_byte_seek_request_set_start_byte (self, start_byte);
	rygel_http_byte_seek_request_set_end_byte (self, end_byte);
	rygel_http_byte_seek_request_set_total_size (self, total_size);
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (parsed_range);
	return self;
}

RygelHTTPByteSeekRequest*
rygel_http_byte_seek_request_new (SoupMessage* msg,
                                  RygelHTTPGetHandler* handler,
                                  GError** error)
{
	return rygel_http_byte_seek_request_construct (RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, msg, handler, error);
}

gboolean
rygel_http_byte_seek_request_supported (SoupMessage* message,
                                        RygelHTTPGetHandler* handler)
{
	gboolean result = FALSE;
	gboolean force_seek = FALSE;
	gboolean _tmp2_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (message != NULL, FALSE);
	g_return_val_if_fail (handler != NULL, FALSE);
	force_seek = FALSE;
	{
		RygelClientHacks* hack = NULL;
		RygelClientHacks* _tmp0_;
		_tmp0_ = rygel_client_hacks_create (message, &_inner_error0_);
		hack = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch39_g_error;
		}
		force_seek = rygel_client_hacks_force_seek (hack);
		_g_object_unref0 (hack);
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally39:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp1_;
	}
	if (force_seek) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = rygel_http_get_handler_supports_byte_seek (handler);
	}
	result = _tmp2_;
	return result;
}

gboolean
rygel_http_byte_seek_request_requested (SoupMessage* msg)
{
	gboolean result = FALSE;
	SoupMessageHeaders* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (msg != NULL, FALSE);
	_tmp0_ = msg->request_headers;
	_tmp1_ = soup_message_headers_get_one (_tmp0_, "Range");
	result = _tmp1_ != NULL;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
rygel_http_byte_seek_request_strip_leading_zeros (const gchar* number_string)
{
	gchar* result = NULL;
	gint i = 0;
	g_return_val_if_fail (number_string != NULL, NULL);
	i = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint _tmp3_;
		if (string_get (number_string, (glong) i) == '0') {
			gint _tmp1_;
			gint _tmp2_;
			_tmp1_ = strlen (number_string);
			_tmp2_ = _tmp1_;
			_tmp0_ = i < _tmp2_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp3_ = i;
		i = _tmp3_ + 1;
	}
	if (i == 0) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (number_string);
		result = _tmp4_;
		return result;
	} else {
		gint _tmp5_;
		gint _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = strlen (number_string);
		_tmp6_ = _tmp5_;
		_tmp7_ = string_slice (number_string, (glong) i, (glong) _tmp6_);
		result = _tmp7_;
		return result;
	}
}

gint64
rygel_http_byte_seek_request_get_start_byte (RygelHTTPByteSeekRequest* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_start_byte;
	return result;
}

void
rygel_http_byte_seek_request_set_start_byte (RygelHTTPByteSeekRequest* self,
                                             gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_http_byte_seek_request_get_start_byte (self) != value) {
		self->priv->_start_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_byte_seek_request_properties[RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE_PROPERTY]);
	}
}

gint64
rygel_http_byte_seek_request_get_end_byte (RygelHTTPByteSeekRequest* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_end_byte;
	return result;
}

void
rygel_http_byte_seek_request_set_end_byte (RygelHTTPByteSeekRequest* self,
                                           gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_http_byte_seek_request_get_end_byte (self) != value) {
		self->priv->_end_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_byte_seek_request_properties[RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE_PROPERTY]);
	}
}

gint64
rygel_http_byte_seek_request_get_range_length (RygelHTTPByteSeekRequest* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_range_length;
	return result;
}

static void
rygel_http_byte_seek_request_set_range_length (RygelHTTPByteSeekRequest* self,
                                               gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_http_byte_seek_request_get_range_length (self) != value) {
		self->priv->_range_length = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_byte_seek_request_properties[RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH_PROPERTY]);
	}
}

gint64
rygel_http_byte_seek_request_get_total_size (RygelHTTPByteSeekRequest* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_total_size;
	return result;
}

void
rygel_http_byte_seek_request_set_total_size (RygelHTTPByteSeekRequest* self,
                                             gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_http_byte_seek_request_get_total_size (self) != value) {
		self->priv->_total_size = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_byte_seek_request_properties[RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE_PROPERTY]);
	}
}

static void
rygel_http_byte_seek_request_class_init (RygelHTTPByteSeekRequestClass * klass,
                                         gpointer klass_data)
{
	rygel_http_byte_seek_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPByteSeekRequest_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_byte_seek_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_byte_seek_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_byte_seek_request_finalize;
	/**
	     * The start of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE_PROPERTY, rygel_http_byte_seek_request_properties[RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE_PROPERTY] = g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The end of the range in bytes (inclusive)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE_PROPERTY, rygel_http_byte_seek_request_properties[RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE_PROPERTY] = g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The length of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH_PROPERTY, rygel_http_byte_seek_request_properties[RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH_PROPERTY] = g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The length of the resource in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE_PROPERTY, rygel_http_byte_seek_request_properties[RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE_PROPERTY] = g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_http_byte_seek_request_instance_init (RygelHTTPByteSeekRequest * self,
                                            gpointer klass)
{
	self->priv = rygel_http_byte_seek_request_get_instance_private (self);
}

static void
rygel_http_byte_seek_request_finalize (GObject * obj)
{
	RygelHTTPByteSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest);
	G_OBJECT_CLASS (rygel_http_byte_seek_request_parent_class)->finalize (obj);
}

GType
rygel_http_byte_seek_request_get_type (void)
{
	static volatile gsize rygel_http_byte_seek_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeekRequest), 0, (GInstanceInitFunc) rygel_http_byte_seek_request_instance_init, NULL };
		GType rygel_http_byte_seek_request_type_id;
		rygel_http_byte_seek_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelHTTPByteSeekRequest", &g_define_type_info, 0);
		RygelHTTPByteSeekRequest_private_offset = g_type_add_instance_private (rygel_http_byte_seek_request_type_id, sizeof (RygelHTTPByteSeekRequestPrivate));
		g_once_init_leave (&rygel_http_byte_seek_request_type_id__volatile, rygel_http_byte_seek_request_type_id);
	}
	return rygel_http_byte_seek_request_type_id__volatile;
}

static void
_vala_rygel_http_byte_seek_request_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	RygelHTTPByteSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest);
	switch (property_id) {
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_start_byte (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_end_byte (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH_PROPERTY:
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_range_length (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_total_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_http_byte_seek_request_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	RygelHTTPByteSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest);
	switch (property_id) {
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE_PROPERTY:
		rygel_http_byte_seek_request_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE_PROPERTY:
		rygel_http_byte_seek_request_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH_PROPERTY:
		rygel_http_byte_seek_request_set_range_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE_PROPERTY:
		rygel_http_byte_seek_request_set_total_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

