/* tracker-turtle-reader.c generated by valac 0.43.90, the Vala compiler
 * generated from tracker-turtle-reader.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-common/tracker-date-time.h"
#include "libtracker-data/tracker-db-interface.h"

#define TRACKER_TYPE_TURTLE_READER (tracker_turtle_reader_get_type ())
#define TRACKER_TURTLE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader))
#define TRACKER_TURTLE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderClass))
#define TRACKER_IS_TURTLE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_TURTLE_READER))
#define TRACKER_IS_TURTLE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_TURTLE_READER))
#define TRACKER_TURTLE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderClass))

typedef struct _TrackerTurtleReader TrackerTurtleReader;
typedef struct _TrackerTurtleReaderClass TrackerTurtleReaderClass;
typedef struct _TrackerTurtleReaderPrivate TrackerTurtleReaderPrivate;

#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;

#define TRACKER_TURTLE_READER_TYPE_TOKEN_INFO (tracker_turtle_reader_token_info_get_type ())
typedef struct _TrackerTurtleReaderTokenInfo TrackerTurtleReaderTokenInfo;
typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_ABS,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BIND,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CEIL,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_CONTAINS,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DAY,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FLOOR,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_HOURS,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LCASE,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MD5,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_MINUTES,
	TRACKER_SPARQL_TOKEN_TYPE_MONTH,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NOW,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_RAND,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_ROUND,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SECONDS,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SHA1,
	TRACKER_SPARQL_TOKEN_TYPE_SHA256,
	TRACKER_SPARQL_TOKEN_TYPE_SHA512,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRAFTER,
	TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE,
	TRACKER_SPARQL_TOKEN_TYPE_STRENDS,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_STRLEN,
	TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS,
	TRACKER_SPARQL_TOKEN_TYPE_SUBSTR,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UCASE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH,
	TRACKER_SPARQL_TOKEN_TYPE_YEAR
} TrackerSparqlTokenType;

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;
typedef enum  {
	TRACKER_TURTLE_READER_STATE_INITIAL,
	TRACKER_TURTLE_READER_STATE_BOS,
	TRACKER_TURTLE_READER_STATE_SUBJECT,
	TRACKER_TURTLE_READER_STATE_PREDICATE,
	TRACKER_TURTLE_READER_STATE_OBJECT
} TrackerTurtleReaderState;

#define TRACKER_TURTLE_READER_TYPE_STATE (tracker_turtle_reader_state_get_type ())
enum  {
	TRACKER_TURTLE_READER_0_PROPERTY,
	TRACKER_TURTLE_READER_GRAPH_PROPERTY,
	TRACKER_TURTLE_READER_SUBJECT_PROPERTY,
	TRACKER_TURTLE_READER_PREDICATE_PROPERTY,
	TRACKER_TURTLE_READER_OBJECT_PROPERTY,
	TRACKER_TURTLE_READER_OBJECT_IS_URI_PROPERTY,
	TRACKER_TURTLE_READER_NUM_PROPERTIES
};
static GParamSpec* tracker_turtle_reader_properties[TRACKER_TURTLE_READER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TrackerTurtleReader {
	GObject parent_instance;
	TrackerTurtleReaderPrivate * priv;
};

struct _TrackerTurtleReaderClass {
	GObjectClass parent_class;
};

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerTurtleReaderTokenInfo {
	TrackerSparqlTokenType type;
	TrackerSourceLocation begin;
	TrackerSourceLocation end;
};

struct _TrackerTurtleReaderPrivate {
	TrackerSparqlScanner* scanner;
	TrackerTurtleReaderTokenInfo* tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gint index;
	gint size;
	TrackerTurtleReaderState state;
	gchar* _graph;
	gchar* _subject;
	gchar* _predicate;
	gchar* _object;
	gboolean _object_is_uri;
	GHashTable* prefix_map;
	gchar** subject_stack;
	gint subject_stack_length1;
	gint _subject_stack_size_;
	gchar** predicate_stack;
	gint predicate_stack_length1;
	gint _predicate_stack_size_;
	gint bnodeid;
	guchar* base_uuid;
	gint base_uuid_length1;
	gint _base_uuid_size_;
	GMappedFile* mapped_file;
	guchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
};

static gint TrackerTurtleReader_private_offset;
static gpointer tracker_turtle_reader_parent_class = NULL;

GType tracker_turtle_reader_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerTurtleReader, g_object_unref)
GType tracker_sparql_scanner_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSparqlScanner, g_object_unref)
static GType tracker_turtle_reader_token_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static TrackerTurtleReaderTokenInfo* tracker_turtle_reader_token_info_dup (const TrackerTurtleReaderTokenInfo* self);
static void tracker_turtle_reader_token_info_free (TrackerTurtleReaderTokenInfo* self);
static GType tracker_turtle_reader_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_TURTLE_READER_BUFFER_SIZE 32
#define TRACKER_TURTLE_READER_MAX_ONTOLOGY_SIZE ((2 * 1024) * 1024)
TrackerTurtleReader* tracker_turtle_reader_new (GFile* file,
                                                GError** error);
TrackerTurtleReader* tracker_turtle_reader_construct (GType object_type,
                                                      GFile* file,
                                                      GError** error);
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input,
                                                  gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type,
                                                        gchar* input,
                                                        gsize len);
void uuid_generate (guchar* uuid);
static gchar* tracker_turtle_reader_generate_bnodeid (TrackerTurtleReader* self,
                                               const gchar* user_bnodeid);
static inline gboolean tracker_turtle_reader_next_token (TrackerTurtleReader* self,
                                           GError** error);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self,
                                                          TrackerSourceLocation* token_begin,
                                                          TrackerSourceLocation* token_end,
                                                          GError** error);
static inline TrackerSparqlTokenType tracker_turtle_reader_current (TrackerTurtleReader* self);
static inline gboolean tracker_turtle_reader_accept (TrackerTurtleReader* self,
                                       TrackerSparqlTokenType type,
                                       GError** error);
static GError* tracker_turtle_reader_get_error (TrackerTurtleReader* self,
                                         const gchar* msg);
static gboolean tracker_turtle_reader_expect (TrackerTurtleReader* self,
                                       TrackerSparqlTokenType type,
                                       GError** error);
const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);
static gchar* tracker_turtle_reader_get_last_string (TrackerTurtleReader* self,
                                              gint strip);
static gchar* tracker_turtle_reader_resolve_prefixed_name (TrackerTurtleReader* self,
                                                    const gchar* prefix,
                                                    const gchar* local_name,
                                                    GError** error);
gboolean tracker_turtle_reader_next (TrackerTurtleReader* self,
                                     GError** error);
static void tracker_turtle_reader_set_subject (TrackerTurtleReader* self,
                                        const gchar* value);
static void tracker_turtle_reader_set_predicate (TrackerTurtleReader* self,
                                          const gchar* value);
static void tracker_turtle_reader_set_object (TrackerTurtleReader* self,
                                       const gchar* value);
static void tracker_turtle_reader_set_object_is_uri (TrackerTurtleReader* self,
                                              gboolean value);
const gchar* tracker_turtle_reader_get_subject (TrackerTurtleReader* self);
static void _vala_array_add12 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
const gchar* tracker_turtle_reader_get_predicate (TrackerTurtleReader* self);
static void _vala_array_add13 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
void tracker_turtle_reader_load (GFile* file,
                                 TrackerData* data,
                                 GError** error);
gboolean tracker_turtle_reader_get_object_is_uri (TrackerTurtleReader* self);
const gchar* tracker_turtle_reader_get_graph (TrackerTurtleReader* self);
const gchar* tracker_turtle_reader_get_object (TrackerTurtleReader* self);
static void tracker_turtle_reader_set_graph (TrackerTurtleReader* self,
                                      const gchar* value);
static void tracker_turtle_reader_finalize (GObject * obj);
static void _vala_tracker_turtle_reader_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_tracker_turtle_reader_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
tracker_turtle_reader_get_instance_private (TrackerTurtleReader* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerTurtleReader_private_offset);
}

static GType
tracker_turtle_reader_state_get_type (void)
{
	static volatile gsize tracker_turtle_reader_state_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_turtle_reader_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_TURTLE_READER_STATE_INITIAL, "TRACKER_TURTLE_READER_STATE_INITIAL", "initial"}, {TRACKER_TURTLE_READER_STATE_BOS, "TRACKER_TURTLE_READER_STATE_BOS", "bos"}, {TRACKER_TURTLE_READER_STATE_SUBJECT, "TRACKER_TURTLE_READER_STATE_SUBJECT", "subject"}, {TRACKER_TURTLE_READER_STATE_PREDICATE, "TRACKER_TURTLE_READER_STATE_PREDICATE", "predicate"}, {TRACKER_TURTLE_READER_STATE_OBJECT, "TRACKER_TURTLE_READER_STATE_OBJECT", "object"}, {0, NULL, NULL}};
		GType tracker_turtle_reader_state_type_id;
		tracker_turtle_reader_state_type_id = g_enum_register_static ("TrackerTurtleReaderState", values);
		g_once_init_leave (&tracker_turtle_reader_state_type_id__volatile, tracker_turtle_reader_state_type_id);
	}
	return tracker_turtle_reader_state_type_id__volatile;
}

TrackerTurtleReader*
tracker_turtle_reader_construct (GType object_type,
                                 GFile* file,
                                 GError** error)
{
	TrackerTurtleReader * self = NULL;
	guchar* _tmp18_;
	guchar* _tmp19_;
	gint _tmp19__length1;
	TrackerTurtleReaderTokenInfo* _tmp20_;
	GHashFunc _tmp21_;
	GEqualFunc _tmp22_;
	GDestroyNotify _tmp23_;
	GDestroyNotify _tmp24_;
	GHashTable* _tmp25_;
	GError* _inner_error0_ = NULL;
#line 69 "tracker-turtle-reader.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 69 "tracker-turtle-reader.vala"
	self = (TrackerTurtleReader*) g_object_new (object_type, NULL);
#line 70 "tracker-turtle-reader.vala"
	if (g_file_is_native (file)) {
#line 406 "tracker-turtle-reader.c"
		GMappedFile* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GMappedFile* _tmp3_;
		GMappedFile* _tmp4_;
		GMappedFile* _tmp5_;
		GMappedFile* _tmp6_;
		gchar* _tmp7_;
		GMappedFile* _tmp8_;
		TrackerSparqlScanner* _tmp9_;
#line 71 "tracker-turtle-reader.vala"
		_tmp1_ = g_file_get_path (file);
#line 71 "tracker-turtle-reader.vala"
		_tmp2_ = _tmp1_;
#line 71 "tracker-turtle-reader.vala"
		_tmp3_ = g_mapped_file_new (_tmp2_, FALSE, &_inner_error0_);
#line 71 "tracker-turtle-reader.vala"
		_tmp4_ = _tmp3_;
#line 71 "tracker-turtle-reader.vala"
		_g_free0 (_tmp2_);
#line 71 "tracker-turtle-reader.vala"
		_tmp0_ = _tmp4_;
#line 71 "tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 71 "tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error0_);
#line 71 "tracker-turtle-reader.vala"
			_g_object_unref0 (self);
#line 71 "tracker-turtle-reader.vala"
			return NULL;
#line 437 "tracker-turtle-reader.c"
		}
#line 71 "tracker-turtle-reader.vala"
		_tmp5_ = _tmp0_;
#line 71 "tracker-turtle-reader.vala"
		_tmp0_ = NULL;
#line 71 "tracker-turtle-reader.vala"
		_g_mapped_file_unref0 (self->priv->mapped_file);
#line 71 "tracker-turtle-reader.vala"
		self->priv->mapped_file = _tmp5_;
#line 72 "tracker-turtle-reader.vala"
		_tmp6_ = self->priv->mapped_file;
#line 72 "tracker-turtle-reader.vala"
		_tmp7_ = g_mapped_file_get_contents (_tmp6_);
#line 72 "tracker-turtle-reader.vala"
		_tmp8_ = self->priv->mapped_file;
#line 72 "tracker-turtle-reader.vala"
		_tmp9_ = tracker_sparql_scanner_new (_tmp7_, g_mapped_file_get_length (_tmp8_));
#line 72 "tracker-turtle-reader.vala"
		_g_object_unref0 (self->priv->scanner);
#line 72 "tracker-turtle-reader.vala"
		self->priv->scanner = _tmp9_;
#line 70 "tracker-turtle-reader.vala"
		_g_mapped_file_unref0 (_tmp0_);
#line 461 "tracker-turtle-reader.c"
	} else {
		gsize len = 0UL;
		GFileInputStream* istream = NULL;
		GFileInputStream* _tmp10_;
		guchar* _tmp11_;
		GFileInputStream* _tmp12_;
		guchar* _tmp13_;
		gint _tmp13__length1;
		gsize _tmp14_ = 0UL;
		guchar* _tmp16_;
		gint _tmp16__length1;
		TrackerSparqlScanner* _tmp17_;
#line 75 "tracker-turtle-reader.vala"
		_tmp10_ = g_file_read (file, NULL, &_inner_error0_);
#line 75 "tracker-turtle-reader.vala"
		istream = _tmp10_;
#line 75 "tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 75 "tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error0_);
#line 75 "tracker-turtle-reader.vala"
			_g_object_unref0 (self);
#line 75 "tracker-turtle-reader.vala"
			return NULL;
#line 486 "tracker-turtle-reader.c"
		}
#line 76 "tracker-turtle-reader.vala"
		_tmp11_ = g_new0 (guchar, TRACKER_TURTLE_READER_MAX_ONTOLOGY_SIZE);
#line 76 "tracker-turtle-reader.vala"
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 76 "tracker-turtle-reader.vala"
		self->priv->buffer = _tmp11_;
#line 76 "tracker-turtle-reader.vala"
		self->priv->buffer_length1 = TRACKER_TURTLE_READER_MAX_ONTOLOGY_SIZE;
#line 76 "tracker-turtle-reader.vala"
		self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 77 "tracker-turtle-reader.vala"
		_tmp12_ = istream;
#line 77 "tracker-turtle-reader.vala"
		_tmp13_ = self->priv->buffer;
#line 77 "tracker-turtle-reader.vala"
		_tmp13__length1 = self->priv->buffer_length1;
#line 77 "tracker-turtle-reader.vala"
		g_input_stream_read_all ((GInputStream*) _tmp12_, _tmp13_, (gsize) _tmp13__length1, &_tmp14_, NULL, &_inner_error0_);
#line 77 "tracker-turtle-reader.vala"
		len = _tmp14_;
#line 77 "tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 77 "tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error0_);
#line 77 "tracker-turtle-reader.vala"
			_g_object_unref0 (istream);
#line 77 "tracker-turtle-reader.vala"
			_g_object_unref0 (self);
#line 77 "tracker-turtle-reader.vala"
			return NULL;
#line 518 "tracker-turtle-reader.c"
		}
#line 80 "tracker-turtle-reader.vala"
		if (len == ((gsize) TRACKER_TURTLE_READER_MAX_ONTOLOGY_SIZE)) {
#line 522 "tracker-turtle-reader.c"
			GError* _tmp15_;
#line 81 "tracker-turtle-reader.vala"
			_tmp15_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Ontology file too large");
#line 81 "tracker-turtle-reader.vala"
			_inner_error0_ = _tmp15_;
#line 81 "tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error0_);
#line 81 "tracker-turtle-reader.vala"
			_g_object_unref0 (istream);
#line 81 "tracker-turtle-reader.vala"
			_g_object_unref0 (self);
#line 81 "tracker-turtle-reader.vala"
			return NULL;
#line 536 "tracker-turtle-reader.c"
		}
#line 83 "tracker-turtle-reader.vala"
		_tmp16_ = self->priv->buffer;
#line 83 "tracker-turtle-reader.vala"
		_tmp16__length1 = self->priv->buffer_length1;
#line 83 "tracker-turtle-reader.vala"
		_tmp17_ = tracker_sparql_scanner_new (_tmp16_, len);
#line 83 "tracker-turtle-reader.vala"
		_g_object_unref0 (self->priv->scanner);
#line 83 "tracker-turtle-reader.vala"
		self->priv->scanner = _tmp17_;
#line 70 "tracker-turtle-reader.vala"
		_g_object_unref0 (istream);
#line 550 "tracker-turtle-reader.c"
	}
#line 86 "tracker-turtle-reader.vala"
	_tmp18_ = g_new0 (guchar, 16);
#line 86 "tracker-turtle-reader.vala"
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
#line 86 "tracker-turtle-reader.vala"
	self->priv->base_uuid = _tmp18_;
#line 86 "tracker-turtle-reader.vala"
	self->priv->base_uuid_length1 = 16;
#line 86 "tracker-turtle-reader.vala"
	self->priv->_base_uuid_size_ = self->priv->base_uuid_length1;
#line 87 "tracker-turtle-reader.vala"
	_tmp19_ = self->priv->base_uuid;
#line 87 "tracker-turtle-reader.vala"
	_tmp19__length1 = self->priv->base_uuid_length1;
#line 87 "tracker-turtle-reader.vala"
	uuid_generate (_tmp19_);
#line 89 "tracker-turtle-reader.vala"
	_tmp20_ = g_new0 (TrackerTurtleReaderTokenInfo, TRACKER_TURTLE_READER_BUFFER_SIZE);
#line 89 "tracker-turtle-reader.vala"
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
#line 89 "tracker-turtle-reader.vala"
	self->priv->tokens = _tmp20_;
#line 89 "tracker-turtle-reader.vala"
	self->priv->tokens_length1 = TRACKER_TURTLE_READER_BUFFER_SIZE;
#line 89 "tracker-turtle-reader.vala"
	self->priv->_tokens_size_ = self->priv->tokens_length1;
#line 90 "tracker-turtle-reader.vala"
	_tmp21_ = g_str_hash;
#line 90 "tracker-turtle-reader.vala"
	_tmp22_ = g_str_equal;
#line 90 "tracker-turtle-reader.vala"
	_tmp23_ = g_free;
#line 90 "tracker-turtle-reader.vala"
	_tmp24_ = g_free;
#line 90 "tracker-turtle-reader.vala"
	_tmp25_ = g_hash_table_new_full (_tmp21_, _tmp22_, _tmp23_, _tmp24_);
#line 90 "tracker-turtle-reader.vala"
	_g_hash_table_unref0 (self->priv->prefix_map);
#line 90 "tracker-turtle-reader.vala"
	self->priv->prefix_map = _tmp25_;
#line 69 "tracker-turtle-reader.vala"
	return self;
#line 594 "tracker-turtle-reader.c"
}

TrackerTurtleReader*
tracker_turtle_reader_new (GFile* file,
                           GError** error)
{
#line 69 "tracker-turtle-reader.vala"
	return tracker_turtle_reader_construct (TRACKER_TYPE_TURTLE_READER, file, error);
#line 603 "tracker-turtle-reader.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1392 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1392 "glib-2.0.vapi"
	end = _tmp0_;
#line 1393 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1393 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1394 "glib-2.0.vapi"
		result = maxlen;
#line 1394 "glib-2.0.vapi"
		return result;
#line 626 "tracker-turtle-reader.c"
	} else {
		gchar* _tmp2_;
#line 1396 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1396 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1396 "glib-2.0.vapi"
		return result;
#line 635 "tracker-turtle-reader.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
#line 1403 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1405 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1405 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 654 "tracker-turtle-reader.c"
	} else {
#line 1405 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 658 "tracker-turtle-reader.c"
	}
#line 1405 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1407 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 664 "tracker-turtle-reader.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1409 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1409 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1409 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 674 "tracker-turtle-reader.c"
	}
#line 1412 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1413 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1414 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 682 "tracker-turtle-reader.c"
	} else {
#line 1416 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 686 "tracker-turtle-reader.c"
	}
#line 1418 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1419 "glib-2.0.vapi"
		len = string_length - offset;
#line 692 "tracker-turtle-reader.c"
	}
#line 1421 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1422 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1422 "glib-2.0.vapi"
	result = _tmp3_;
#line 1422 "glib-2.0.vapi"
	return result;
#line 702 "tracker-turtle-reader.c"
}

static gchar*
tracker_turtle_reader_generate_bnodeid (TrackerTurtleReader* self,
                                        const gchar* user_bnodeid)
{
	gchar* result = NULL;
#line 93 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "tracker-turtle-reader.vala"
	if (user_bnodeid == NULL) {
#line 714 "tracker-turtle-reader.c"
		gchar* _tmp0_;
#line 96 "tracker-turtle-reader.vala"
		self->priv->bnodeid = self->priv->bnodeid + 1;
#line 96 "tracker-turtle-reader.vala"
		_tmp0_ = g_strdup_printf (":%d", self->priv->bnodeid);
#line 96 "tracker-turtle-reader.vala"
		result = _tmp0_;
#line 96 "tracker-turtle-reader.vala"
		return result;
#line 724 "tracker-turtle-reader.c"
	} else {
		GChecksum* checksum = NULL;
		GChecksum* _tmp1_;
		GChecksum* _tmp2_;
		guchar* _tmp3_;
		gint _tmp3__length1;
		GChecksum* _tmp4_;
		gchar* sha1 = NULL;
		GChecksum* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
#line 98 "tracker-turtle-reader.vala"
		_tmp1_ = g_checksum_new (G_CHECKSUM_SHA1);
#line 98 "tracker-turtle-reader.vala"
		checksum = _tmp1_;
#line 100 "tracker-turtle-reader.vala"
		_tmp2_ = checksum;
#line 100 "tracker-turtle-reader.vala"
		_tmp3_ = self->priv->base_uuid;
#line 100 "tracker-turtle-reader.vala"
		_tmp3__length1 = self->priv->base_uuid_length1;
#line 100 "tracker-turtle-reader.vala"
		g_checksum_update (_tmp2_, _tmp3_, (gsize) 16);
#line 102 "tracker-turtle-reader.vala"
		_tmp4_ = checksum;
#line 102 "tracker-turtle-reader.vala"
		g_checksum_update (_tmp4_, (guchar*) user_bnodeid, (gsize) -1);
#line 104 "tracker-turtle-reader.vala"
		_tmp5_ = checksum;
#line 104 "tracker-turtle-reader.vala"
		_tmp6_ = g_checksum_get_string (_tmp5_);
#line 104 "tracker-turtle-reader.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 104 "tracker-turtle-reader.vala"
		sha1 = _tmp7_;
#line 107 "tracker-turtle-reader.vala"
		_tmp8_ = sha1;
#line 107 "tracker-turtle-reader.vala"
		_tmp9_ = sha1;
#line 107 "tracker-turtle-reader.vala"
		_tmp10_ = string_substring (_tmp9_, (glong) 8, (glong) -1);
#line 107 "tracker-turtle-reader.vala"
		_tmp11_ = _tmp10_;
#line 107 "tracker-turtle-reader.vala"
		_tmp12_ = sha1;
#line 107 "tracker-turtle-reader.vala"
		_tmp13_ = string_substring (_tmp12_, (glong) 12, (glong) -1);
#line 107 "tracker-turtle-reader.vala"
		_tmp14_ = _tmp13_;
#line 107 "tracker-turtle-reader.vala"
		_tmp15_ = sha1;
#line 107 "tracker-turtle-reader.vala"
		_tmp16_ = string_substring (_tmp15_, (glong) 16, (glong) -1);
#line 107 "tracker-turtle-reader.vala"
		_tmp17_ = _tmp16_;
#line 107 "tracker-turtle-reader.vala"
		_tmp18_ = sha1;
#line 107 "tracker-turtle-reader.vala"
		_tmp19_ = string_substring (_tmp18_, (glong) 20, (glong) -1);
#line 107 "tracker-turtle-reader.vala"
		_tmp20_ = _tmp19_;
#line 107 "tracker-turtle-reader.vala"
		_tmp21_ = g_strdup_printf ("urn:uuid:%.8s-%.4s-%.4s-%.4s-%.12s", _tmp8_, _tmp11_, _tmp14_, _tmp17_, _tmp20_);
#line 107 "tracker-turtle-reader.vala"
		_tmp22_ = _tmp21_;
#line 107 "tracker-turtle-reader.vala"
		_g_free0 (_tmp20_);
#line 107 "tracker-turtle-reader.vala"
		_g_free0 (_tmp17_);
#line 107 "tracker-turtle-reader.vala"
		_g_free0 (_tmp14_);
#line 107 "tracker-turtle-reader.vala"
		_g_free0 (_tmp11_);
#line 107 "tracker-turtle-reader.vala"
		result = _tmp22_;
#line 107 "tracker-turtle-reader.vala"
		_g_free0 (sha1);
#line 107 "tracker-turtle-reader.vala"
		_g_checksum_free0 (checksum);
#line 107 "tracker-turtle-reader.vala"
		return result;
#line 821 "tracker-turtle-reader.c"
	}
}

static inline gboolean
tracker_turtle_reader_next_token (TrackerTurtleReader* self,
                                  GError** error)
{
	gboolean result = FALSE;
	gint _tmp0_;
	TrackerTurtleReaderTokenInfo* _tmp13_;
	gint _tmp13__length1;
	TrackerTurtleReaderTokenInfo _tmp14_;
	TrackerSparqlTokenType _tmp15_;
	GError* _inner_error0_ = NULL;
#line 112 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 113 "tracker-turtle-reader.vala"
	self->priv->index = (self->priv->index + 1) % TRACKER_TURTLE_READER_BUFFER_SIZE;
#line 114 "tracker-turtle-reader.vala"
	_tmp0_ = self->priv->size;
#line 114 "tracker-turtle-reader.vala"
	self->priv->size = _tmp0_ - 1;
#line 115 "tracker-turtle-reader.vala"
	if (self->priv->size <= 0) {
#line 846 "tracker-turtle-reader.c"
		TrackerSourceLocation begin = {0};
		TrackerSourceLocation end = {0};
		TrackerSparqlTokenType type = 0;
		TrackerSparqlScanner* _tmp1_;
		TrackerSourceLocation _tmp2_ = {0};
		TrackerSourceLocation _tmp3_ = {0};
		TrackerSparqlTokenType _tmp4_;
		TrackerTurtleReaderTokenInfo* _tmp7_;
		gint _tmp7__length1;
		TrackerSparqlTokenType _tmp8_;
		TrackerTurtleReaderTokenInfo* _tmp9_;
		gint _tmp9__length1;
		TrackerSourceLocation _tmp10_;
		TrackerTurtleReaderTokenInfo* _tmp11_;
		gint _tmp11__length1;
		TrackerSourceLocation _tmp12_;
#line 117 "tracker-turtle-reader.vala"
		_tmp1_ = self->priv->scanner;
#line 117 "tracker-turtle-reader.vala"
		_tmp4_ = tracker_sparql_scanner_read_token (_tmp1_, &_tmp2_, &_tmp3_, &_inner_error0_);
#line 117 "tracker-turtle-reader.vala"
		begin = _tmp2_;
#line 117 "tracker-turtle-reader.vala"
		end = _tmp3_;
#line 117 "tracker-turtle-reader.vala"
		type = _tmp4_;
#line 117 "tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 117 "tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 877 "tracker-turtle-reader.c"
				gboolean _tmp5_ = FALSE;
#line 117 "tracker-turtle-reader.vala"
				g_propagate_error (error, _inner_error0_);
#line 117 "tracker-turtle-reader.vala"
				return _tmp5_;
#line 883 "tracker-turtle-reader.c"
			} else {
				gboolean _tmp6_ = FALSE;
#line 117 "tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 117 "tracker-turtle-reader.vala"
				g_clear_error (&_inner_error0_);
#line 117 "tracker-turtle-reader.vala"
				return _tmp6_;
#line 892 "tracker-turtle-reader.c"
			}
		}
#line 118 "tracker-turtle-reader.vala"
		_tmp7_ = self->priv->tokens;
#line 118 "tracker-turtle-reader.vala"
		_tmp7__length1 = self->priv->tokens_length1;
#line 118 "tracker-turtle-reader.vala"
		_tmp8_ = type;
#line 118 "tracker-turtle-reader.vala"
		_tmp7_[self->priv->index].type = _tmp8_;
#line 119 "tracker-turtle-reader.vala"
		_tmp9_ = self->priv->tokens;
#line 119 "tracker-turtle-reader.vala"
		_tmp9__length1 = self->priv->tokens_length1;
#line 119 "tracker-turtle-reader.vala"
		_tmp10_ = begin;
#line 119 "tracker-turtle-reader.vala"
		_tmp9_[self->priv->index].begin = _tmp10_;
#line 120 "tracker-turtle-reader.vala"
		_tmp11_ = self->priv->tokens;
#line 120 "tracker-turtle-reader.vala"
		_tmp11__length1 = self->priv->tokens_length1;
#line 120 "tracker-turtle-reader.vala"
		_tmp12_ = end;
#line 120 "tracker-turtle-reader.vala"
		_tmp11_[self->priv->index].end = _tmp12_;
#line 121 "tracker-turtle-reader.vala"
		self->priv->size = 1;
#line 921 "tracker-turtle-reader.c"
	}
#line 123 "tracker-turtle-reader.vala"
	_tmp13_ = self->priv->tokens;
#line 123 "tracker-turtle-reader.vala"
	_tmp13__length1 = self->priv->tokens_length1;
#line 123 "tracker-turtle-reader.vala"
	_tmp14_ = _tmp13_[self->priv->index];
#line 123 "tracker-turtle-reader.vala"
	_tmp15_ = _tmp14_.type;
#line 123 "tracker-turtle-reader.vala"
	result = _tmp15_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 123 "tracker-turtle-reader.vala"
	return result;
#line 935 "tracker-turtle-reader.c"
}

static inline TrackerSparqlTokenType
tracker_turtle_reader_current (TrackerTurtleReader* self)
{
	TrackerSparqlTokenType result = 0;
	TrackerTurtleReaderTokenInfo* _tmp0_;
	gint _tmp0__length1;
	TrackerTurtleReaderTokenInfo _tmp1_;
	TrackerSparqlTokenType _tmp2_;
#line 126 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 127 "tracker-turtle-reader.vala"
	_tmp0_ = self->priv->tokens;
#line 127 "tracker-turtle-reader.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 127 "tracker-turtle-reader.vala"
	_tmp1_ = _tmp0_[self->priv->index];
#line 127 "tracker-turtle-reader.vala"
	_tmp2_ = _tmp1_.type;
#line 127 "tracker-turtle-reader.vala"
	result = _tmp2_;
#line 127 "tracker-turtle-reader.vala"
	return result;
#line 960 "tracker-turtle-reader.c"
}

static inline gboolean
tracker_turtle_reader_accept (TrackerTurtleReader* self,
                              TrackerSparqlTokenType type,
                              GError** error)
{
	gboolean result = FALSE;
	GError* _inner_error0_ = NULL;
#line 130 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 131 "tracker-turtle-reader.vala"
	if (tracker_turtle_reader_current (self) == type) {
#line 132 "tracker-turtle-reader.vala"
		tracker_turtle_reader_next_token (self, &_inner_error0_);
#line 132 "tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 132 "tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 980 "tracker-turtle-reader.c"
				gboolean _tmp0_ = FALSE;
#line 132 "tracker-turtle-reader.vala"
				g_propagate_error (error, _inner_error0_);
#line 132 "tracker-turtle-reader.vala"
				return _tmp0_;
#line 986 "tracker-turtle-reader.c"
			} else {
				gboolean _tmp1_ = FALSE;
#line 132 "tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 132 "tracker-turtle-reader.vala"
				g_clear_error (&_inner_error0_);
#line 132 "tracker-turtle-reader.vala"
				return _tmp1_;
#line 995 "tracker-turtle-reader.c"
			}
		}
#line 133 "tracker-turtle-reader.vala"
		result = TRUE;
#line 133 "tracker-turtle-reader.vala"
		return result;
#line 1002 "tracker-turtle-reader.c"
	}
#line 135 "tracker-turtle-reader.vala"
	result = FALSE;
#line 135 "tracker-turtle-reader.vala"
	return result;
#line 1008 "tracker-turtle-reader.c"
}

static GError*
tracker_turtle_reader_get_error (TrackerTurtleReader* self,
                                 const gchar* msg)
{
	GError* result = NULL;
	TrackerTurtleReaderTokenInfo* _tmp0_;
	gint _tmp0__length1;
	TrackerTurtleReaderTokenInfo _tmp1_;
	TrackerSourceLocation _tmp2_;
	TrackerTurtleReaderTokenInfo* _tmp3_;
	gint _tmp3__length1;
	TrackerTurtleReaderTokenInfo _tmp4_;
	TrackerSourceLocation _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
#line 138 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 138 "tracker-turtle-reader.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 139 "tracker-turtle-reader.vala"
	_tmp0_ = self->priv->tokens;
#line 139 "tracker-turtle-reader.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 139 "tracker-turtle-reader.vala"
	_tmp1_ = _tmp0_[self->priv->index];
#line 139 "tracker-turtle-reader.vala"
	_tmp2_ = _tmp1_.begin;
#line 139 "tracker-turtle-reader.vala"
	_tmp3_ = self->priv->tokens;
#line 139 "tracker-turtle-reader.vala"
	_tmp3__length1 = self->priv->tokens_length1;
#line 139 "tracker-turtle-reader.vala"
	_tmp4_ = _tmp3_[self->priv->index];
#line 139 "tracker-turtle-reader.vala"
	_tmp5_ = _tmp4_.begin;
#line 139 "tracker-turtle-reader.vala"
	_tmp6_ = g_strdup_printf ("%d.%d: syntax error, %s", _tmp2_.line, _tmp5_.column, msg);
#line 139 "tracker-turtle-reader.vala"
	_tmp7_ = _tmp6_;
#line 139 "tracker-turtle-reader.vala"
	_tmp8_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp7_);
#line 139 "tracker-turtle-reader.vala"
	_tmp9_ = _tmp8_;
#line 139 "tracker-turtle-reader.vala"
	_g_free0 (_tmp7_);
#line 139 "tracker-turtle-reader.vala"
	result = _tmp9_;
#line 139 "tracker-turtle-reader.vala"
	return result;
#line 1062 "tracker-turtle-reader.c"
}

static gboolean
tracker_turtle_reader_expect (TrackerTurtleReader* self,
                              TrackerSparqlTokenType type,
                              GError** error)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _inner_error0_ = NULL;
#line 142 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 143 "tracker-turtle-reader.vala"
	_tmp0_ = tracker_turtle_reader_accept (self, type, &_inner_error0_);
#line 143 "tracker-turtle-reader.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 143 "tracker-turtle-reader.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1086 "tracker-turtle-reader.c"
			gboolean _tmp1_ = FALSE;
#line 143 "tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error0_);
#line 143 "tracker-turtle-reader.vala"
			return _tmp1_;
#line 1092 "tracker-turtle-reader.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 143 "tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 143 "tracker-turtle-reader.vala"
			g_clear_error (&_inner_error0_);
#line 143 "tracker-turtle-reader.vala"
			return _tmp2_;
#line 1101 "tracker-turtle-reader.c"
		}
	}
#line 143 "tracker-turtle-reader.vala"
	if (_tmp0_) {
#line 144 "tracker-turtle-reader.vala"
		result = TRUE;
#line 144 "tracker-turtle-reader.vala"
		return result;
#line 1110 "tracker-turtle-reader.c"
	}
#line 147 "tracker-turtle-reader.vala"
	_tmp3_ = tracker_sparql_token_type_to_string (type);
#line 147 "tracker-turtle-reader.vala"
	_tmp4_ = g_strdup_printf ("expected %s", _tmp3_);
#line 147 "tracker-turtle-reader.vala"
	_tmp5_ = _tmp4_;
#line 147 "tracker-turtle-reader.vala"
	_tmp6_ = tracker_turtle_reader_get_error (self, _tmp5_);
#line 147 "tracker-turtle-reader.vala"
	_tmp7_ = _tmp6_;
#line 147 "tracker-turtle-reader.vala"
	_g_free0 (_tmp5_);
#line 147 "tracker-turtle-reader.vala"
	_inner_error0_ = _tmp7_;
#line 147 "tracker-turtle-reader.vala"
	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1128 "tracker-turtle-reader.c"
		gboolean _tmp8_ = FALSE;
#line 147 "tracker-turtle-reader.vala"
		g_propagate_error (error, _inner_error0_);
#line 147 "tracker-turtle-reader.vala"
		return _tmp8_;
#line 1134 "tracker-turtle-reader.c"
	} else {
		gboolean _tmp9_ = FALSE;
#line 147 "tracker-turtle-reader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 147 "tracker-turtle-reader.vala"
		g_clear_error (&_inner_error0_);
#line 147 "tracker-turtle-reader.vala"
		return _tmp9_;
#line 1143 "tracker-turtle-reader.c"
	}
}

static gchar*
tracker_turtle_reader_get_last_string (TrackerTurtleReader* self,
                                       gint strip)
{
	gchar* result = NULL;
	gint last_index = 0;
	TrackerTurtleReaderTokenInfo* _tmp0_;
	gint _tmp0__length1;
	TrackerTurtleReaderTokenInfo _tmp1_;
	TrackerSourceLocation _tmp2_;
	gchar* _tmp3_;
	TrackerTurtleReaderTokenInfo* _tmp4_;
	gint _tmp4__length1;
	TrackerTurtleReaderTokenInfo _tmp5_;
	TrackerSourceLocation _tmp6_;
	gchar* _tmp7_;
	TrackerTurtleReaderTokenInfo* _tmp8_;
	gint _tmp8__length1;
	TrackerTurtleReaderTokenInfo _tmp9_;
	TrackerSourceLocation _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
#line 150 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 151 "tracker-turtle-reader.vala"
	last_index = ((self->priv->index + TRACKER_TURTLE_READER_BUFFER_SIZE) - 1) % TRACKER_TURTLE_READER_BUFFER_SIZE;
#line 152 "tracker-turtle-reader.vala"
	_tmp0_ = self->priv->tokens;
#line 152 "tracker-turtle-reader.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 152 "tracker-turtle-reader.vala"
	_tmp1_ = _tmp0_[last_index];
#line 152 "tracker-turtle-reader.vala"
	_tmp2_ = _tmp1_.begin;
#line 152 "tracker-turtle-reader.vala"
	_tmp3_ = _tmp2_.pos;
#line 152 "tracker-turtle-reader.vala"
	_tmp4_ = self->priv->tokens;
#line 152 "tracker-turtle-reader.vala"
	_tmp4__length1 = self->priv->tokens_length1;
#line 152 "tracker-turtle-reader.vala"
	_tmp5_ = _tmp4_[last_index];
#line 152 "tracker-turtle-reader.vala"
	_tmp6_ = _tmp5_.end;
#line 152 "tracker-turtle-reader.vala"
	_tmp7_ = _tmp6_.pos;
#line 152 "tracker-turtle-reader.vala"
	_tmp8_ = self->priv->tokens;
#line 152 "tracker-turtle-reader.vala"
	_tmp8__length1 = self->priv->tokens_length1;
#line 152 "tracker-turtle-reader.vala"
	_tmp9_ = _tmp8_[last_index];
#line 152 "tracker-turtle-reader.vala"
	_tmp10_ = _tmp9_.begin;
#line 152 "tracker-turtle-reader.vala"
	_tmp11_ = _tmp10_.pos;
#line 152 "tracker-turtle-reader.vala"
	_tmp12_ = string_substring ((const gchar*) (_tmp3_ + strip), (glong) 0, (glong) ((gint) ((_tmp7_ - _tmp11_) - (2 * strip))));
#line 152 "tracker-turtle-reader.vala"
	result = _tmp12_;
#line 152 "tracker-turtle-reader.vala"
	return result;
#line 1209 "tracker-turtle-reader.c"
}

static gchar*
tracker_turtle_reader_resolve_prefixed_name (TrackerTurtleReader* self,
                                             const gchar* prefix,
                                             const gchar* local_name,
                                             GError** error)
{
	gchar* result = NULL;
	gchar* ns = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
#line 155 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 155 "tracker-turtle-reader.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 155 "tracker-turtle-reader.vala"
	g_return_val_if_fail (local_name != NULL, NULL);
#line 156 "tracker-turtle-reader.vala"
	_tmp0_ = self->priv->prefix_map;
#line 156 "tracker-turtle-reader.vala"
	_tmp1_ = g_hash_table_lookup (_tmp0_, prefix);
#line 156 "tracker-turtle-reader.vala"
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
#line 156 "tracker-turtle-reader.vala"
	ns = _tmp2_;
#line 157 "tracker-turtle-reader.vala"
	_tmp3_ = ns;
#line 157 "tracker-turtle-reader.vala"
	if (_tmp3_ == NULL) {
#line 1245 "tracker-turtle-reader.c"
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
#line 158 "tracker-turtle-reader.vala"
		_tmp4_ = g_strdup_printf ("use of undefined prefix `%s'", prefix);
#line 158 "tracker-turtle-reader.vala"
		_tmp5_ = _tmp4_;
#line 158 "tracker-turtle-reader.vala"
		_tmp6_ = tracker_turtle_reader_get_error (self, _tmp5_);
#line 158 "tracker-turtle-reader.vala"
		_tmp7_ = _tmp6_;
#line 158 "tracker-turtle-reader.vala"
		_g_free0 (_tmp5_);
#line 158 "tracker-turtle-reader.vala"
		_inner_error0_ = _tmp7_;
#line 158 "tracker-turtle-reader.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 158 "tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error0_);
#line 158 "tracker-turtle-reader.vala"
			_g_free0 (ns);
#line 158 "tracker-turtle-reader.vala"
			return NULL;
#line 1270 "tracker-turtle-reader.c"
		} else {
#line 158 "tracker-turtle-reader.vala"
			_g_free0 (ns);
#line 158 "tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 158 "tracker-turtle-reader.vala"
			g_clear_error (&_inner_error0_);
#line 158 "tracker-turtle-reader.vala"
			return NULL;
#line 1280 "tracker-turtle-reader.c"
		}
	}
#line 160 "tracker-turtle-reader.vala"
	_tmp8_ = ns;
#line 160 "tracker-turtle-reader.vala"
	_tmp9_ = g_strconcat (_tmp8_, local_name, NULL);
#line 160 "tracker-turtle-reader.vala"
	result = _tmp9_;
#line 160 "tracker-turtle-reader.vala"
	_g_free0 (ns);
#line 160 "tracker-turtle-reader.vala"
	return result;
#line 1293 "tracker-turtle-reader.c"
}

static void
_vala_array_add12 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 269 "tracker-turtle-reader.vala"
	if ((*length) == (*size)) {
#line 269 "tracker-turtle-reader.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 269 "tracker-turtle-reader.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1308 "tracker-turtle-reader.c"
	}
#line 269 "tracker-turtle-reader.vala"
	(*array)[(*length)++] = value;
#line 269 "tracker-turtle-reader.vala"
	(*array)[*length] = NULL;
#line 1314 "tracker-turtle-reader.c"
}

static void
_vala_array_add13 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 270 "tracker-turtle-reader.vala"
	if ((*length) == (*size)) {
#line 270 "tracker-turtle-reader.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 270 "tracker-turtle-reader.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1329 "tracker-turtle-reader.c"
	}
#line 270 "tracker-turtle-reader.vala"
	(*array)[(*length)++] = value;
#line 270 "tracker-turtle-reader.vala"
	(*array)[*length] = NULL;
#line 1335 "tracker-turtle-reader.c"
}

gboolean
tracker_turtle_reader_next (TrackerTurtleReader* self,
                            GError** error)
{
	gboolean result = FALSE;
	GError* _inner_error0_ = NULL;
#line 163 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 164 "tracker-turtle-reader.vala"
	while (TRUE) {
#line 1348 "tracker-turtle-reader.c"
		TrackerTurtleReaderState _tmp0_;
#line 165 "tracker-turtle-reader.vala"
		_tmp0_ = self->priv->state;
#line 165 "tracker-turtle-reader.vala"
		switch (_tmp0_) {
#line 165 "tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_INITIAL:
#line 1356 "tracker-turtle-reader.c"
			{
#line 167 "tracker-turtle-reader.vala"
				tracker_turtle_reader_next_token (self, &_inner_error0_);
#line 167 "tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 167 "tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1364 "tracker-turtle-reader.c"
						gboolean _tmp1_ = FALSE;
#line 167 "tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error0_);
#line 167 "tracker-turtle-reader.vala"
						return _tmp1_;
#line 1370 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp2_ = FALSE;
#line 167 "tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 167 "tracker-turtle-reader.vala"
						g_clear_error (&_inner_error0_);
#line 167 "tracker-turtle-reader.vala"
						return _tmp2_;
#line 1379 "tracker-turtle-reader.c"
					}
				}
#line 168 "tracker-turtle-reader.vala"
				self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
#line 169 "tracker-turtle-reader.vala"
				continue;
#line 1386 "tracker-turtle-reader.c"
			}
#line 165 "tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_BOS:
#line 1390 "tracker-turtle-reader.c"
			{
				gboolean _tmp3_ = FALSE;
				gboolean _tmp30_ = FALSE;
#line 172 "tracker-turtle-reader.vala"
				_tmp3_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX, &_inner_error0_);
#line 172 "tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 172 "tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1400 "tracker-turtle-reader.c"
						gboolean _tmp4_ = FALSE;
#line 172 "tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error0_);
#line 172 "tracker-turtle-reader.vala"
						return _tmp4_;
#line 1406 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp5_ = FALSE;
#line 172 "tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 172 "tracker-turtle-reader.vala"
						g_clear_error (&_inner_error0_);
#line 172 "tracker-turtle-reader.vala"
						return _tmp5_;
#line 1415 "tracker-turtle-reader.c"
					}
				}
#line 172 "tracker-turtle-reader.vala"
				if (_tmp3_) {
#line 1420 "tracker-turtle-reader.c"
					gchar* ns = NULL;
					gchar* _tmp6_;
					gboolean _tmp7_ = FALSE;
					gchar* uri = NULL;
					gchar* _tmp15_;
					GHashTable* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
#line 173 "tracker-turtle-reader.vala"
					_tmp6_ = g_strdup ("");
#line 173 "tracker-turtle-reader.vala"
					ns = _tmp6_;
#line 174 "tracker-turtle-reader.vala"
					_tmp7_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 174 "tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 174 "tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1441 "tracker-turtle-reader.c"
							gboolean _tmp8_ = FALSE;
#line 174 "tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 174 "tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 174 "tracker-turtle-reader.vala"
							return _tmp8_;
#line 1449 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp9_ = FALSE;
#line 174 "tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 174 "tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 174 "tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 174 "tracker-turtle-reader.vala"
							return _tmp9_;
#line 1460 "tracker-turtle-reader.c"
						}
					}
#line 174 "tracker-turtle-reader.vala"
					if (_tmp7_) {
#line 1465 "tracker-turtle-reader.c"
						gchar* _tmp10_;
#line 175 "tracker-turtle-reader.vala"
						_tmp10_ = tracker_turtle_reader_get_last_string (self, 0);
#line 175 "tracker-turtle-reader.vala"
						_g_free0 (ns);
#line 175 "tracker-turtle-reader.vala"
						ns = _tmp10_;
#line 1473 "tracker-turtle-reader.c"
					}
#line 177 "tracker-turtle-reader.vala"
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 177 "tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 177 "tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1481 "tracker-turtle-reader.c"
							gboolean _tmp11_ = FALSE;
#line 177 "tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 177 "tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 177 "tracker-turtle-reader.vala"
							return _tmp11_;
#line 1489 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp12_ = FALSE;
#line 177 "tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 177 "tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 177 "tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 177 "tracker-turtle-reader.vala"
							return _tmp12_;
#line 1500 "tracker-turtle-reader.c"
						}
					}
#line 178 "tracker-turtle-reader.vala"
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 178 "tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 178 "tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1509 "tracker-turtle-reader.c"
							gboolean _tmp13_ = FALSE;
#line 178 "tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 178 "tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 178 "tracker-turtle-reader.vala"
							return _tmp13_;
#line 1517 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp14_ = FALSE;
#line 178 "tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 178 "tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 178 "tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 178 "tracker-turtle-reader.vala"
							return _tmp14_;
#line 1528 "tracker-turtle-reader.c"
						}
					}
#line 179 "tracker-turtle-reader.vala"
					_tmp15_ = tracker_turtle_reader_get_last_string (self, 1);
#line 179 "tracker-turtle-reader.vala"
					uri = _tmp15_;
#line 180 "tracker-turtle-reader.vala"
					_tmp16_ = self->priv->prefix_map;
#line 180 "tracker-turtle-reader.vala"
					_tmp17_ = ns;
#line 180 "tracker-turtle-reader.vala"
					_tmp18_ = g_strdup (_tmp17_);
#line 180 "tracker-turtle-reader.vala"
					_tmp19_ = uri;
#line 180 "tracker-turtle-reader.vala"
					_tmp20_ = g_strdup (_tmp19_);
#line 180 "tracker-turtle-reader.vala"
					g_hash_table_insert (_tmp16_, _tmp18_, _tmp20_);
#line 181 "tracker-turtle-reader.vala"
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error0_);
#line 181 "tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 181 "tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1553 "tracker-turtle-reader.c"
							gboolean _tmp21_ = FALSE;
#line 181 "tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 181 "tracker-turtle-reader.vala"
							_g_free0 (uri);
#line 181 "tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 181 "tracker-turtle-reader.vala"
							return _tmp21_;
#line 1563 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp22_ = FALSE;
#line 181 "tracker-turtle-reader.vala"
							_g_free0 (uri);
#line 181 "tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 181 "tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 181 "tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 181 "tracker-turtle-reader.vala"
							return _tmp22_;
#line 1576 "tracker-turtle-reader.c"
						}
					}
#line 182 "tracker-turtle-reader.vala"
					_g_free0 (uri);
#line 182 "tracker-turtle-reader.vala"
					_g_free0 (ns);
#line 182 "tracker-turtle-reader.vala"
					continue;
#line 1585 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp23_ = FALSE;
#line 183 "tracker-turtle-reader.vala"
					_tmp23_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ATBASE, &_inner_error0_);
#line 183 "tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 183 "tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1594 "tracker-turtle-reader.c"
							gboolean _tmp24_ = FALSE;
#line 183 "tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 183 "tracker-turtle-reader.vala"
							return _tmp24_;
#line 1600 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp25_ = FALSE;
#line 183 "tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 183 "tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 183 "tracker-turtle-reader.vala"
							return _tmp25_;
#line 1609 "tracker-turtle-reader.c"
						}
					}
#line 183 "tracker-turtle-reader.vala"
					if (_tmp23_) {
#line 184 "tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 184 "tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 184 "tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1620 "tracker-turtle-reader.c"
								gboolean _tmp26_ = FALSE;
#line 184 "tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 184 "tracker-turtle-reader.vala"
								return _tmp26_;
#line 1626 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp27_ = FALSE;
#line 184 "tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 184 "tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 184 "tracker-turtle-reader.vala"
								return _tmp27_;
#line 1635 "tracker-turtle-reader.c"
							}
						}
#line 185 "tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error0_);
#line 185 "tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 185 "tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1644 "tracker-turtle-reader.c"
								gboolean _tmp28_ = FALSE;
#line 185 "tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 185 "tracker-turtle-reader.vala"
								return _tmp28_;
#line 1650 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp29_ = FALSE;
#line 185 "tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 185 "tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 185 "tracker-turtle-reader.vala"
								return _tmp29_;
#line 1659 "tracker-turtle-reader.c"
							}
						}
#line 186 "tracker-turtle-reader.vala"
						continue;
#line 1664 "tracker-turtle-reader.c"
					} else {
#line 187 "tracker-turtle-reader.vala"
						if (tracker_turtle_reader_current (self) == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
#line 188 "tracker-turtle-reader.vala"
							result = FALSE;
#line 188 "tracker-turtle-reader.vala"
							return result;
#line 1672 "tracker-turtle-reader.c"
						}
					}
				}
#line 191 "tracker-turtle-reader.vala"
				_tmp30_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 191 "tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 191 "tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1682 "tracker-turtle-reader.c"
						gboolean _tmp31_ = FALSE;
#line 191 "tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error0_);
#line 191 "tracker-turtle-reader.vala"
						return _tmp31_;
#line 1688 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp32_ = FALSE;
#line 191 "tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 191 "tracker-turtle-reader.vala"
						g_clear_error (&_inner_error0_);
#line 191 "tracker-turtle-reader.vala"
						return _tmp32_;
#line 1697 "tracker-turtle-reader.c"
					}
				}
#line 191 "tracker-turtle-reader.vala"
				if (_tmp30_) {
#line 1702 "tracker-turtle-reader.c"
					gchar* _tmp33_;
					gchar* _tmp34_;
#line 192 "tracker-turtle-reader.vala"
					_tmp33_ = tracker_turtle_reader_get_last_string (self, 1);
#line 192 "tracker-turtle-reader.vala"
					_tmp34_ = _tmp33_;
#line 192 "tracker-turtle-reader.vala"
					tracker_turtle_reader_set_subject (self, _tmp34_);
#line 192 "tracker-turtle-reader.vala"
					_g_free0 (_tmp34_);
#line 193 "tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 194 "tracker-turtle-reader.vala"
					continue;
#line 1717 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp35_ = FALSE;
#line 195 "tracker-turtle-reader.vala"
					_tmp35_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 195 "tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 195 "tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1726 "tracker-turtle-reader.c"
							gboolean _tmp36_ = FALSE;
#line 195 "tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 195 "tracker-turtle-reader.vala"
							return _tmp36_;
#line 1732 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp37_ = FALSE;
#line 195 "tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 195 "tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 195 "tracker-turtle-reader.vala"
							return _tmp37_;
#line 1741 "tracker-turtle-reader.c"
						}
					}
#line 195 "tracker-turtle-reader.vala"
					if (_tmp35_) {
#line 1746 "tracker-turtle-reader.c"
						gchar* ns = NULL;
						gchar* _tmp38_;
						gchar* _tmp41_ = NULL;
						const gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						gchar* _tmp48_;
#line 197 "tracker-turtle-reader.vala"
						_tmp38_ = tracker_turtle_reader_get_last_string (self, 0);
#line 197 "tracker-turtle-reader.vala"
						ns = _tmp38_;
#line 198 "tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 198 "tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 198 "tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1767 "tracker-turtle-reader.c"
								gboolean _tmp39_ = FALSE;
#line 198 "tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 198 "tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 198 "tracker-turtle-reader.vala"
								return _tmp39_;
#line 1775 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp40_ = FALSE;
#line 198 "tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 198 "tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 198 "tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 198 "tracker-turtle-reader.vala"
								return _tmp40_;
#line 1786 "tracker-turtle-reader.c"
							}
						}
#line 199 "tracker-turtle-reader.vala"
						_tmp42_ = ns;
#line 199 "tracker-turtle-reader.vala"
						_tmp43_ = tracker_turtle_reader_get_last_string (self, 0);
#line 199 "tracker-turtle-reader.vala"
						_tmp44_ = _tmp43_;
#line 199 "tracker-turtle-reader.vala"
						_tmp45_ = string_substring (_tmp44_, (glong) 1, (glong) -1);
#line 199 "tracker-turtle-reader.vala"
						_tmp46_ = _tmp45_;
#line 199 "tracker-turtle-reader.vala"
						_tmp47_ = tracker_turtle_reader_resolve_prefixed_name (self, _tmp42_, _tmp46_, &_inner_error0_);
#line 199 "tracker-turtle-reader.vala"
						_tmp48_ = _tmp47_;
#line 199 "tracker-turtle-reader.vala"
						_g_free0 (_tmp46_);
#line 199 "tracker-turtle-reader.vala"
						_g_free0 (_tmp44_);
#line 199 "tracker-turtle-reader.vala"
						_tmp41_ = _tmp48_;
#line 199 "tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 199 "tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1813 "tracker-turtle-reader.c"
								gboolean _tmp49_ = FALSE;
#line 199 "tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 199 "tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 199 "tracker-turtle-reader.vala"
								return _tmp49_;
#line 1821 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp50_ = FALSE;
#line 199 "tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 199 "tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 199 "tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 199 "tracker-turtle-reader.vala"
								return _tmp50_;
#line 1832 "tracker-turtle-reader.c"
							}
						}
#line 199 "tracker-turtle-reader.vala"
						tracker_turtle_reader_set_subject (self, _tmp41_);
#line 200 "tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 201 "tracker-turtle-reader.vala"
						_g_free0 (_tmp41_);
#line 201 "tracker-turtle-reader.vala"
						_g_free0 (ns);
#line 201 "tracker-turtle-reader.vala"
						continue;
#line 1845 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp51_ = FALSE;
#line 202 "tracker-turtle-reader.vala"
						_tmp51_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 202 "tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 202 "tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1854 "tracker-turtle-reader.c"
								gboolean _tmp52_ = FALSE;
#line 202 "tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 202 "tracker-turtle-reader.vala"
								return _tmp52_;
#line 1860 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp53_ = FALSE;
#line 202 "tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 202 "tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 202 "tracker-turtle-reader.vala"
								return _tmp53_;
#line 1869 "tracker-turtle-reader.c"
							}
						}
#line 202 "tracker-turtle-reader.vala"
						if (_tmp51_) {
#line 1874 "tracker-turtle-reader.c"
							gchar* _tmp54_ = NULL;
							gchar* _tmp55_;
							gchar* _tmp56_;
							gchar* _tmp57_;
							gchar* _tmp58_;
							gchar* _tmp59_;
							gchar* _tmp60_;
#line 204 "tracker-turtle-reader.vala"
							_tmp55_ = tracker_turtle_reader_get_last_string (self, 0);
#line 204 "tracker-turtle-reader.vala"
							_tmp56_ = _tmp55_;
#line 204 "tracker-turtle-reader.vala"
							_tmp57_ = string_substring (_tmp56_, (glong) 1, (glong) -1);
#line 204 "tracker-turtle-reader.vala"
							_tmp58_ = _tmp57_;
#line 204 "tracker-turtle-reader.vala"
							_tmp59_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp58_, &_inner_error0_);
#line 204 "tracker-turtle-reader.vala"
							_tmp60_ = _tmp59_;
#line 204 "tracker-turtle-reader.vala"
							_g_free0 (_tmp58_);
#line 204 "tracker-turtle-reader.vala"
							_g_free0 (_tmp56_);
#line 204 "tracker-turtle-reader.vala"
							_tmp54_ = _tmp60_;
#line 204 "tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 204 "tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1904 "tracker-turtle-reader.c"
									gboolean _tmp61_ = FALSE;
#line 204 "tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 204 "tracker-turtle-reader.vala"
									return _tmp61_;
#line 1910 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp62_ = FALSE;
#line 204 "tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 204 "tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 204 "tracker-turtle-reader.vala"
									return _tmp62_;
#line 1919 "tracker-turtle-reader.c"
								}
							}
#line 204 "tracker-turtle-reader.vala"
							tracker_turtle_reader_set_subject (self, _tmp54_);
#line 205 "tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 206 "tracker-turtle-reader.vala"
							_g_free0 (_tmp54_);
#line 206 "tracker-turtle-reader.vala"
							continue;
#line 1930 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp63_ = FALSE;
#line 207 "tracker-turtle-reader.vala"
							_tmp63_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error0_);
#line 207 "tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 207 "tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1939 "tracker-turtle-reader.c"
									gboolean _tmp64_ = FALSE;
#line 207 "tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 207 "tracker-turtle-reader.vala"
									return _tmp64_;
#line 1945 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp65_ = FALSE;
#line 207 "tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 207 "tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 207 "tracker-turtle-reader.vala"
									return _tmp65_;
#line 1954 "tracker-turtle-reader.c"
								}
							}
#line 207 "tracker-turtle-reader.vala"
							if (_tmp63_) {
#line 1959 "tracker-turtle-reader.c"
								gchar* _tmp68_;
								gchar* _tmp69_;
								gchar* _tmp70_;
								gchar* _tmp71_;
								gchar* _tmp72_;
								gchar* _tmp73_;
#line 209 "tracker-turtle-reader.vala"
								tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 209 "tracker-turtle-reader.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 209 "tracker-turtle-reader.vala"
									if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1972 "tracker-turtle-reader.c"
										gboolean _tmp66_ = FALSE;
#line 209 "tracker-turtle-reader.vala"
										g_propagate_error (error, _inner_error0_);
#line 209 "tracker-turtle-reader.vala"
										return _tmp66_;
#line 1978 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp67_ = FALSE;
#line 209 "tracker-turtle-reader.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 209 "tracker-turtle-reader.vala"
										g_clear_error (&_inner_error0_);
#line 209 "tracker-turtle-reader.vala"
										return _tmp67_;
#line 1987 "tracker-turtle-reader.c"
									}
								}
#line 210 "tracker-turtle-reader.vala"
								_tmp68_ = tracker_turtle_reader_get_last_string (self, 0);
#line 210 "tracker-turtle-reader.vala"
								_tmp69_ = _tmp68_;
#line 210 "tracker-turtle-reader.vala"
								_tmp70_ = string_substring (_tmp69_, (glong) 1, (glong) -1);
#line 210 "tracker-turtle-reader.vala"
								_tmp71_ = _tmp70_;
#line 210 "tracker-turtle-reader.vala"
								_tmp72_ = tracker_turtle_reader_generate_bnodeid (self, _tmp71_);
#line 210 "tracker-turtle-reader.vala"
								_tmp73_ = _tmp72_;
#line 210 "tracker-turtle-reader.vala"
								tracker_turtle_reader_set_subject (self, _tmp73_);
#line 210 "tracker-turtle-reader.vala"
								_g_free0 (_tmp73_);
#line 210 "tracker-turtle-reader.vala"
								_g_free0 (_tmp71_);
#line 210 "tracker-turtle-reader.vala"
								_g_free0 (_tmp69_);
#line 211 "tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 212 "tracker-turtle-reader.vala"
								continue;
#line 2014 "tracker-turtle-reader.c"
							} else {
								GError* _tmp74_;
#line 214 "tracker-turtle-reader.vala"
								_tmp74_ = tracker_turtle_reader_get_error (self, "expected subject");
#line 214 "tracker-turtle-reader.vala"
								_inner_error0_ = _tmp74_;
#line 214 "tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2023 "tracker-turtle-reader.c"
									gboolean _tmp75_ = FALSE;
#line 214 "tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 214 "tracker-turtle-reader.vala"
									return _tmp75_;
#line 2029 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp76_ = FALSE;
#line 214 "tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 214 "tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 214 "tracker-turtle-reader.vala"
									return _tmp76_;
#line 2038 "tracker-turtle-reader.c"
								}
							}
						}
					}
				}
			}
#line 165 "tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_SUBJECT:
#line 2047 "tracker-turtle-reader.c"
			{
				gboolean _tmp77_ = FALSE;
#line 218 "tracker-turtle-reader.vala"
				_tmp77_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 218 "tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 218 "tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2056 "tracker-turtle-reader.c"
						gboolean _tmp78_ = FALSE;
#line 218 "tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error0_);
#line 218 "tracker-turtle-reader.vala"
						return _tmp78_;
#line 2062 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp79_ = FALSE;
#line 218 "tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 218 "tracker-turtle-reader.vala"
						g_clear_error (&_inner_error0_);
#line 218 "tracker-turtle-reader.vala"
						return _tmp79_;
#line 2071 "tracker-turtle-reader.c"
					}
				}
#line 218 "tracker-turtle-reader.vala"
				if (_tmp77_) {
#line 2076 "tracker-turtle-reader.c"
					gchar* _tmp80_;
					gchar* _tmp81_;
#line 219 "tracker-turtle-reader.vala"
					_tmp80_ = tracker_turtle_reader_get_last_string (self, 1);
#line 219 "tracker-turtle-reader.vala"
					_tmp81_ = _tmp80_;
#line 219 "tracker-turtle-reader.vala"
					tracker_turtle_reader_set_predicate (self, _tmp81_);
#line 219 "tracker-turtle-reader.vala"
					_g_free0 (_tmp81_);
#line 220 "tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 221 "tracker-turtle-reader.vala"
					continue;
#line 2091 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp82_ = FALSE;
#line 222 "tracker-turtle-reader.vala"
					_tmp82_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 222 "tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 222 "tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2100 "tracker-turtle-reader.c"
							gboolean _tmp83_ = FALSE;
#line 222 "tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 222 "tracker-turtle-reader.vala"
							return _tmp83_;
#line 2106 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp84_ = FALSE;
#line 222 "tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 222 "tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 222 "tracker-turtle-reader.vala"
							return _tmp84_;
#line 2115 "tracker-turtle-reader.c"
						}
					}
#line 222 "tracker-turtle-reader.vala"
					if (_tmp82_) {
#line 2120 "tracker-turtle-reader.c"
						gchar* ns = NULL;
						gchar* _tmp85_;
						gchar* _tmp88_ = NULL;
						const gchar* _tmp89_;
						gchar* _tmp90_;
						gchar* _tmp91_;
						gchar* _tmp92_;
						gchar* _tmp93_;
						gchar* _tmp94_;
						gchar* _tmp95_;
#line 223 "tracker-turtle-reader.vala"
						_tmp85_ = tracker_turtle_reader_get_last_string (self, 0);
#line 223 "tracker-turtle-reader.vala"
						ns = _tmp85_;
#line 224 "tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 224 "tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 224 "tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2141 "tracker-turtle-reader.c"
								gboolean _tmp86_ = FALSE;
#line 224 "tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 224 "tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 224 "tracker-turtle-reader.vala"
								return _tmp86_;
#line 2149 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp87_ = FALSE;
#line 224 "tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 224 "tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 224 "tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 224 "tracker-turtle-reader.vala"
								return _tmp87_;
#line 2160 "tracker-turtle-reader.c"
							}
						}
#line 225 "tracker-turtle-reader.vala"
						_tmp89_ = ns;
#line 225 "tracker-turtle-reader.vala"
						_tmp90_ = tracker_turtle_reader_get_last_string (self, 0);
#line 225 "tracker-turtle-reader.vala"
						_tmp91_ = _tmp90_;
#line 225 "tracker-turtle-reader.vala"
						_tmp92_ = string_substring (_tmp91_, (glong) 1, (glong) -1);
#line 225 "tracker-turtle-reader.vala"
						_tmp93_ = _tmp92_;
#line 225 "tracker-turtle-reader.vala"
						_tmp94_ = tracker_turtle_reader_resolve_prefixed_name (self, _tmp89_, _tmp93_, &_inner_error0_);
#line 225 "tracker-turtle-reader.vala"
						_tmp95_ = _tmp94_;
#line 225 "tracker-turtle-reader.vala"
						_g_free0 (_tmp93_);
#line 225 "tracker-turtle-reader.vala"
						_g_free0 (_tmp91_);
#line 225 "tracker-turtle-reader.vala"
						_tmp88_ = _tmp95_;
#line 225 "tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 225 "tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2187 "tracker-turtle-reader.c"
								gboolean _tmp96_ = FALSE;
#line 225 "tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 225 "tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 225 "tracker-turtle-reader.vala"
								return _tmp96_;
#line 2195 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp97_ = FALSE;
#line 225 "tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 225 "tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 225 "tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 225 "tracker-turtle-reader.vala"
								return _tmp97_;
#line 2206 "tracker-turtle-reader.c"
							}
						}
#line 225 "tracker-turtle-reader.vala"
						tracker_turtle_reader_set_predicate (self, _tmp88_);
#line 226 "tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 227 "tracker-turtle-reader.vala"
						_g_free0 (_tmp88_);
#line 227 "tracker-turtle-reader.vala"
						_g_free0 (ns);
#line 227 "tracker-turtle-reader.vala"
						continue;
#line 2219 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp98_ = FALSE;
#line 228 "tracker-turtle-reader.vala"
						_tmp98_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 228 "tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 228 "tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2228 "tracker-turtle-reader.c"
								gboolean _tmp99_ = FALSE;
#line 228 "tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 228 "tracker-turtle-reader.vala"
								return _tmp99_;
#line 2234 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp100_ = FALSE;
#line 228 "tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 228 "tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 228 "tracker-turtle-reader.vala"
								return _tmp100_;
#line 2243 "tracker-turtle-reader.c"
							}
						}
#line 228 "tracker-turtle-reader.vala"
						if (_tmp98_) {
#line 2248 "tracker-turtle-reader.c"
							gchar* _tmp101_ = NULL;
							gchar* _tmp102_;
							gchar* _tmp103_;
							gchar* _tmp104_;
							gchar* _tmp105_;
							gchar* _tmp106_;
							gchar* _tmp107_;
#line 229 "tracker-turtle-reader.vala"
							_tmp102_ = tracker_turtle_reader_get_last_string (self, 0);
#line 229 "tracker-turtle-reader.vala"
							_tmp103_ = _tmp102_;
#line 229 "tracker-turtle-reader.vala"
							_tmp104_ = string_substring (_tmp103_, (glong) 1, (glong) -1);
#line 229 "tracker-turtle-reader.vala"
							_tmp105_ = _tmp104_;
#line 229 "tracker-turtle-reader.vala"
							_tmp106_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp105_, &_inner_error0_);
#line 229 "tracker-turtle-reader.vala"
							_tmp107_ = _tmp106_;
#line 229 "tracker-turtle-reader.vala"
							_g_free0 (_tmp105_);
#line 229 "tracker-turtle-reader.vala"
							_g_free0 (_tmp103_);
#line 229 "tracker-turtle-reader.vala"
							_tmp101_ = _tmp107_;
#line 229 "tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 229 "tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2278 "tracker-turtle-reader.c"
									gboolean _tmp108_ = FALSE;
#line 229 "tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 229 "tracker-turtle-reader.vala"
									return _tmp108_;
#line 2284 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp109_ = FALSE;
#line 229 "tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 229 "tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 229 "tracker-turtle-reader.vala"
									return _tmp109_;
#line 2293 "tracker-turtle-reader.c"
								}
							}
#line 229 "tracker-turtle-reader.vala"
							tracker_turtle_reader_set_predicate (self, _tmp101_);
#line 230 "tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 231 "tracker-turtle-reader.vala"
							_g_free0 (_tmp101_);
#line 231 "tracker-turtle-reader.vala"
							continue;
#line 2304 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp110_ = FALSE;
#line 232 "tracker-turtle-reader.vala"
							_tmp110_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_A, &_inner_error0_);
#line 232 "tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 232 "tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2313 "tracker-turtle-reader.c"
									gboolean _tmp111_ = FALSE;
#line 232 "tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 232 "tracker-turtle-reader.vala"
									return _tmp111_;
#line 2319 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp112_ = FALSE;
#line 232 "tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 232 "tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 232 "tracker-turtle-reader.vala"
									return _tmp112_;
#line 2328 "tracker-turtle-reader.c"
								}
							}
#line 232 "tracker-turtle-reader.vala"
							if (_tmp110_) {
#line 233 "tracker-turtle-reader.vala"
								tracker_turtle_reader_set_predicate (self, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
#line 234 "tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 235 "tracker-turtle-reader.vala"
								continue;
#line 2339 "tracker-turtle-reader.c"
							} else {
								GError* _tmp113_;
#line 237 "tracker-turtle-reader.vala"
								_tmp113_ = tracker_turtle_reader_get_error (self, "expected predicate");
#line 237 "tracker-turtle-reader.vala"
								_inner_error0_ = _tmp113_;
#line 237 "tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2348 "tracker-turtle-reader.c"
									gboolean _tmp114_ = FALSE;
#line 237 "tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 237 "tracker-turtle-reader.vala"
									return _tmp114_;
#line 2354 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp115_ = FALSE;
#line 237 "tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 237 "tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 237 "tracker-turtle-reader.vala"
									return _tmp115_;
#line 2363 "tracker-turtle-reader.c"
								}
							}
						}
					}
				}
			}
#line 165 "tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_PREDICATE:
#line 2372 "tracker-turtle-reader.c"
			{
				gboolean _tmp116_ = FALSE;
#line 241 "tracker-turtle-reader.vala"
				_tmp116_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 241 "tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 241 "tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2381 "tracker-turtle-reader.c"
						gboolean _tmp117_ = FALSE;
#line 241 "tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error0_);
#line 241 "tracker-turtle-reader.vala"
						return _tmp117_;
#line 2387 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp118_ = FALSE;
#line 241 "tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 241 "tracker-turtle-reader.vala"
						g_clear_error (&_inner_error0_);
#line 241 "tracker-turtle-reader.vala"
						return _tmp118_;
#line 2396 "tracker-turtle-reader.c"
					}
				}
#line 241 "tracker-turtle-reader.vala"
				if (_tmp116_) {
#line 2401 "tracker-turtle-reader.c"
					gchar* _tmp119_;
					gchar* _tmp120_;
#line 242 "tracker-turtle-reader.vala"
					_tmp119_ = tracker_turtle_reader_get_last_string (self, 1);
#line 242 "tracker-turtle-reader.vala"
					_tmp120_ = _tmp119_;
#line 242 "tracker-turtle-reader.vala"
					tracker_turtle_reader_set_object (self, _tmp120_);
#line 242 "tracker-turtle-reader.vala"
					_g_free0 (_tmp120_);
#line 243 "tracker-turtle-reader.vala"
					tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 244 "tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 245 "tracker-turtle-reader.vala"
					result = TRUE;
#line 245 "tracker-turtle-reader.vala"
					return result;
#line 2420 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp121_ = FALSE;
#line 246 "tracker-turtle-reader.vala"
					_tmp121_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 246 "tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 246 "tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2429 "tracker-turtle-reader.c"
							gboolean _tmp122_ = FALSE;
#line 246 "tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 246 "tracker-turtle-reader.vala"
							return _tmp122_;
#line 2435 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp123_ = FALSE;
#line 246 "tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 246 "tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 246 "tracker-turtle-reader.vala"
							return _tmp123_;
#line 2444 "tracker-turtle-reader.c"
						}
					}
#line 246 "tracker-turtle-reader.vala"
					if (_tmp121_) {
#line 2449 "tracker-turtle-reader.c"
						gchar* ns = NULL;
						gchar* _tmp124_;
						gchar* _tmp127_ = NULL;
						const gchar* _tmp128_;
						gchar* _tmp129_;
						gchar* _tmp130_;
						gchar* _tmp131_;
						gchar* _tmp132_;
						gchar* _tmp133_;
						gchar* _tmp134_;
#line 248 "tracker-turtle-reader.vala"
						_tmp124_ = tracker_turtle_reader_get_last_string (self, 0);
#line 248 "tracker-turtle-reader.vala"
						ns = _tmp124_;
#line 249 "tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 249 "tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 249 "tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2470 "tracker-turtle-reader.c"
								gboolean _tmp125_ = FALSE;
#line 249 "tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 249 "tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 249 "tracker-turtle-reader.vala"
								return _tmp125_;
#line 2478 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp126_ = FALSE;
#line 249 "tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 249 "tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 249 "tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 249 "tracker-turtle-reader.vala"
								return _tmp126_;
#line 2489 "tracker-turtle-reader.c"
							}
						}
#line 250 "tracker-turtle-reader.vala"
						_tmp128_ = ns;
#line 250 "tracker-turtle-reader.vala"
						_tmp129_ = tracker_turtle_reader_get_last_string (self, 0);
#line 250 "tracker-turtle-reader.vala"
						_tmp130_ = _tmp129_;
#line 250 "tracker-turtle-reader.vala"
						_tmp131_ = string_substring (_tmp130_, (glong) 1, (glong) -1);
#line 250 "tracker-turtle-reader.vala"
						_tmp132_ = _tmp131_;
#line 250 "tracker-turtle-reader.vala"
						_tmp133_ = tracker_turtle_reader_resolve_prefixed_name (self, _tmp128_, _tmp132_, &_inner_error0_);
#line 250 "tracker-turtle-reader.vala"
						_tmp134_ = _tmp133_;
#line 250 "tracker-turtle-reader.vala"
						_g_free0 (_tmp132_);
#line 250 "tracker-turtle-reader.vala"
						_g_free0 (_tmp130_);
#line 250 "tracker-turtle-reader.vala"
						_tmp127_ = _tmp134_;
#line 250 "tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 250 "tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2516 "tracker-turtle-reader.c"
								gboolean _tmp135_ = FALSE;
#line 250 "tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 250 "tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 250 "tracker-turtle-reader.vala"
								return _tmp135_;
#line 2524 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp136_ = FALSE;
#line 250 "tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 250 "tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 250 "tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 250 "tracker-turtle-reader.vala"
								return _tmp136_;
#line 2535 "tracker-turtle-reader.c"
							}
						}
#line 250 "tracker-turtle-reader.vala"
						tracker_turtle_reader_set_object (self, _tmp127_);
#line 251 "tracker-turtle-reader.vala"
						tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 252 "tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 253 "tracker-turtle-reader.vala"
						result = TRUE;
#line 253 "tracker-turtle-reader.vala"
						_g_free0 (_tmp127_);
#line 253 "tracker-turtle-reader.vala"
						_g_free0 (ns);
#line 253 "tracker-turtle-reader.vala"
						return result;
#line 2552 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp137_ = FALSE;
#line 254 "tracker-turtle-reader.vala"
						_tmp137_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 254 "tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 254 "tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2561 "tracker-turtle-reader.c"
								gboolean _tmp138_ = FALSE;
#line 254 "tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 254 "tracker-turtle-reader.vala"
								return _tmp138_;
#line 2567 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp139_ = FALSE;
#line 254 "tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 254 "tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 254 "tracker-turtle-reader.vala"
								return _tmp139_;
#line 2576 "tracker-turtle-reader.c"
							}
						}
#line 254 "tracker-turtle-reader.vala"
						if (_tmp137_) {
#line 2581 "tracker-turtle-reader.c"
							gchar* _tmp140_ = NULL;
							gchar* _tmp141_;
							gchar* _tmp142_;
							gchar* _tmp143_;
							gchar* _tmp144_;
							gchar* _tmp145_;
							gchar* _tmp146_;
#line 256 "tracker-turtle-reader.vala"
							_tmp141_ = tracker_turtle_reader_get_last_string (self, 0);
#line 256 "tracker-turtle-reader.vala"
							_tmp142_ = _tmp141_;
#line 256 "tracker-turtle-reader.vala"
							_tmp143_ = string_substring (_tmp142_, (glong) 1, (glong) -1);
#line 256 "tracker-turtle-reader.vala"
							_tmp144_ = _tmp143_;
#line 256 "tracker-turtle-reader.vala"
							_tmp145_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp144_, &_inner_error0_);
#line 256 "tracker-turtle-reader.vala"
							_tmp146_ = _tmp145_;
#line 256 "tracker-turtle-reader.vala"
							_g_free0 (_tmp144_);
#line 256 "tracker-turtle-reader.vala"
							_g_free0 (_tmp142_);
#line 256 "tracker-turtle-reader.vala"
							_tmp140_ = _tmp146_;
#line 256 "tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 256 "tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2611 "tracker-turtle-reader.c"
									gboolean _tmp147_ = FALSE;
#line 256 "tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 256 "tracker-turtle-reader.vala"
									return _tmp147_;
#line 2617 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp148_ = FALSE;
#line 256 "tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 256 "tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 256 "tracker-turtle-reader.vala"
									return _tmp148_;
#line 2626 "tracker-turtle-reader.c"
								}
							}
#line 256 "tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object (self, _tmp140_);
#line 257 "tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 258 "tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 259 "tracker-turtle-reader.vala"
							result = TRUE;
#line 259 "tracker-turtle-reader.vala"
							_g_free0 (_tmp140_);
#line 259 "tracker-turtle-reader.vala"
							return result;
#line 2641 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp149_ = FALSE;
#line 260 "tracker-turtle-reader.vala"
							_tmp149_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error0_);
#line 260 "tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 260 "tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2650 "tracker-turtle-reader.c"
									gboolean _tmp150_ = FALSE;
#line 260 "tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 260 "tracker-turtle-reader.vala"
									return _tmp150_;
#line 2656 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp151_ = FALSE;
#line 260 "tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 260 "tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 260 "tracker-turtle-reader.vala"
									return _tmp151_;
#line 2665 "tracker-turtle-reader.c"
								}
							}
#line 260 "tracker-turtle-reader.vala"
							if (_tmp149_) {
#line 2670 "tracker-turtle-reader.c"
								gchar* _tmp154_;
								gchar* _tmp155_;
								gchar* _tmp156_;
								gchar* _tmp157_;
								gchar* _tmp158_;
								gchar* _tmp159_;
#line 262 "tracker-turtle-reader.vala"
								tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 262 "tracker-turtle-reader.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 262 "tracker-turtle-reader.vala"
									if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2683 "tracker-turtle-reader.c"
										gboolean _tmp152_ = FALSE;
#line 262 "tracker-turtle-reader.vala"
										g_propagate_error (error, _inner_error0_);
#line 262 "tracker-turtle-reader.vala"
										return _tmp152_;
#line 2689 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp153_ = FALSE;
#line 262 "tracker-turtle-reader.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 262 "tracker-turtle-reader.vala"
										g_clear_error (&_inner_error0_);
#line 262 "tracker-turtle-reader.vala"
										return _tmp153_;
#line 2698 "tracker-turtle-reader.c"
									}
								}
#line 263 "tracker-turtle-reader.vala"
								_tmp154_ = tracker_turtle_reader_get_last_string (self, 0);
#line 263 "tracker-turtle-reader.vala"
								_tmp155_ = _tmp154_;
#line 263 "tracker-turtle-reader.vala"
								_tmp156_ = string_substring (_tmp155_, (glong) 1, (glong) -1);
#line 263 "tracker-turtle-reader.vala"
								_tmp157_ = _tmp156_;
#line 263 "tracker-turtle-reader.vala"
								_tmp158_ = tracker_turtle_reader_generate_bnodeid (self, _tmp157_);
#line 263 "tracker-turtle-reader.vala"
								_tmp159_ = _tmp158_;
#line 263 "tracker-turtle-reader.vala"
								tracker_turtle_reader_set_object (self, _tmp159_);
#line 263 "tracker-turtle-reader.vala"
								_g_free0 (_tmp159_);
#line 263 "tracker-turtle-reader.vala"
								_g_free0 (_tmp157_);
#line 263 "tracker-turtle-reader.vala"
								_g_free0 (_tmp155_);
#line 264 "tracker-turtle-reader.vala"
								tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 265 "tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 266 "tracker-turtle-reader.vala"
								result = TRUE;
#line 266 "tracker-turtle-reader.vala"
								return result;
#line 2729 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp160_ = FALSE;
#line 267 "tracker-turtle-reader.vala"
								_tmp160_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET, &_inner_error0_);
#line 267 "tracker-turtle-reader.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 267 "tracker-turtle-reader.vala"
									if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2738 "tracker-turtle-reader.c"
										gboolean _tmp161_ = FALSE;
#line 267 "tracker-turtle-reader.vala"
										g_propagate_error (error, _inner_error0_);
#line 267 "tracker-turtle-reader.vala"
										return _tmp161_;
#line 2744 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp162_ = FALSE;
#line 267 "tracker-turtle-reader.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 267 "tracker-turtle-reader.vala"
										g_clear_error (&_inner_error0_);
#line 267 "tracker-turtle-reader.vala"
										return _tmp162_;
#line 2753 "tracker-turtle-reader.c"
									}
								}
#line 267 "tracker-turtle-reader.vala"
								if (_tmp160_) {
#line 2758 "tracker-turtle-reader.c"
									gchar** _tmp163_;
									gint _tmp163__length1;
									const gchar* _tmp164_;
									gchar* _tmp165_;
									gchar** _tmp166_;
									gint _tmp166__length1;
									const gchar* _tmp167_;
									gchar* _tmp168_;
									gchar* _tmp169_;
									gchar* _tmp170_;
#line 269 "tracker-turtle-reader.vala"
									_tmp163_ = self->priv->subject_stack;
#line 269 "tracker-turtle-reader.vala"
									_tmp163__length1 = self->priv->subject_stack_length1;
#line 269 "tracker-turtle-reader.vala"
									_tmp164_ = self->priv->_subject;
#line 269 "tracker-turtle-reader.vala"
									_tmp165_ = g_strdup (_tmp164_);
#line 269 "tracker-turtle-reader.vala"
									_vala_array_add12 (&self->priv->subject_stack, &self->priv->subject_stack_length1, &self->priv->_subject_stack_size_, _tmp165_);
#line 270 "tracker-turtle-reader.vala"
									_tmp166_ = self->priv->predicate_stack;
#line 270 "tracker-turtle-reader.vala"
									_tmp166__length1 = self->priv->predicate_stack_length1;
#line 270 "tracker-turtle-reader.vala"
									_tmp167_ = self->priv->_predicate;
#line 270 "tracker-turtle-reader.vala"
									_tmp168_ = g_strdup (_tmp167_);
#line 270 "tracker-turtle-reader.vala"
									_vala_array_add13 (&self->priv->predicate_stack, &self->priv->predicate_stack_length1, &self->priv->_predicate_stack_size_, _tmp168_);
#line 271 "tracker-turtle-reader.vala"
									_tmp169_ = tracker_turtle_reader_generate_bnodeid (self, NULL);
#line 271 "tracker-turtle-reader.vala"
									_tmp170_ = _tmp169_;
#line 271 "tracker-turtle-reader.vala"
									tracker_turtle_reader_set_subject (self, _tmp170_);
#line 271 "tracker-turtle-reader.vala"
									_g_free0 (_tmp170_);
#line 272 "tracker-turtle-reader.vala"
									self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 273 "tracker-turtle-reader.vala"
									continue;
#line 2801 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp171_ = FALSE;
									gboolean _tmp172_ = FALSE;
#line 274 "tracker-turtle-reader.vala"
									_tmp172_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1, &_inner_error0_);
#line 274 "tracker-turtle-reader.vala"
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 274 "tracker-turtle-reader.vala"
										if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2811 "tracker-turtle-reader.c"
											gboolean _tmp173_ = FALSE;
#line 274 "tracker-turtle-reader.vala"
											g_propagate_error (error, _inner_error0_);
#line 274 "tracker-turtle-reader.vala"
											return _tmp173_;
#line 2817 "tracker-turtle-reader.c"
										} else {
											gboolean _tmp174_ = FALSE;
#line 274 "tracker-turtle-reader.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 274 "tracker-turtle-reader.vala"
											g_clear_error (&_inner_error0_);
#line 274 "tracker-turtle-reader.vala"
											return _tmp174_;
#line 2826 "tracker-turtle-reader.c"
										}
									}
#line 274 "tracker-turtle-reader.vala"
									if (_tmp172_) {
#line 274 "tracker-turtle-reader.vala"
										_tmp171_ = TRUE;
#line 2833 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp175_ = FALSE;
#line 274 "tracker-turtle-reader.vala"
										_tmp175_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2, &_inner_error0_);
#line 274 "tracker-turtle-reader.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 274 "tracker-turtle-reader.vala"
											if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2842 "tracker-turtle-reader.c"
												gboolean _tmp176_ = FALSE;
#line 274 "tracker-turtle-reader.vala"
												g_propagate_error (error, _inner_error0_);
#line 274 "tracker-turtle-reader.vala"
												return _tmp176_;
#line 2848 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp177_ = FALSE;
#line 274 "tracker-turtle-reader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 274 "tracker-turtle-reader.vala"
												g_clear_error (&_inner_error0_);
#line 274 "tracker-turtle-reader.vala"
												return _tmp177_;
#line 2857 "tracker-turtle-reader.c"
											}
										}
#line 274 "tracker-turtle-reader.vala"
										_tmp171_ = _tmp175_;
#line 2862 "tracker-turtle-reader.c"
									}
#line 274 "tracker-turtle-reader.vala"
									if (_tmp171_) {
#line 2866 "tracker-turtle-reader.c"
										GString* sb = NULL;
										GString* _tmp178_;
										gchar* s = NULL;
										gchar* _tmp179_;
										const gchar* p = NULL;
										const gchar* _tmp180_;
										const gchar* end = NULL;
										const gchar* _tmp181_;
										const gchar* _tmp182_;
										gint _tmp183_;
										gint _tmp184_;
										GString* _tmp211_;
										const gchar* _tmp212_;
										gboolean _tmp213_ = FALSE;
#line 275 "tracker-turtle-reader.vala"
										_tmp178_ = g_string_new ("");
#line 275 "tracker-turtle-reader.vala"
										sb = _tmp178_;
#line 277 "tracker-turtle-reader.vala"
										_tmp179_ = tracker_turtle_reader_get_last_string (self, 1);
#line 277 "tracker-turtle-reader.vala"
										s = _tmp179_;
#line 278 "tracker-turtle-reader.vala"
										_tmp180_ = s;
#line 278 "tracker-turtle-reader.vala"
										p = _tmp180_;
#line 279 "tracker-turtle-reader.vala"
										_tmp181_ = p;
#line 279 "tracker-turtle-reader.vala"
										_tmp182_ = s;
#line 279 "tracker-turtle-reader.vala"
										_tmp183_ = strlen (_tmp182_);
#line 279 "tracker-turtle-reader.vala"
										_tmp184_ = _tmp183_;
#line 279 "tracker-turtle-reader.vala"
										end = _tmp181_ + _tmp184_;
#line 280 "tracker-turtle-reader.vala"
										while (TRUE) {
#line 2905 "tracker-turtle-reader.c"
											const gchar* _tmp185_;
											const gchar* _tmp186_;
											const gchar* q = NULL;
											const gchar* _tmp187_;
											const gchar* _tmp188_;
											const gchar* _tmp189_;
#line 280 "tracker-turtle-reader.vala"
											_tmp185_ = p;
#line 280 "tracker-turtle-reader.vala"
											_tmp186_ = end;
#line 280 "tracker-turtle-reader.vala"
											if (!(((glong) _tmp185_) < ((glong) _tmp186_))) {
#line 280 "tracker-turtle-reader.vala"
												break;
#line 2920 "tracker-turtle-reader.c"
											}
#line 281 "tracker-turtle-reader.vala"
											_tmp187_ = p;
#line 281 "tracker-turtle-reader.vala"
											_tmp188_ = strchr (_tmp187_, (gint) '\\');
#line 281 "tracker-turtle-reader.vala"
											q = _tmp188_;
#line 282 "tracker-turtle-reader.vala"
											_tmp189_ = q;
#line 282 "tracker-turtle-reader.vala"
											if (_tmp189_ == NULL) {
#line 2932 "tracker-turtle-reader.c"
												GString* _tmp190_;
												const gchar* _tmp191_;
												const gchar* _tmp192_;
												const gchar* _tmp193_;
												const gchar* _tmp194_;
#line 283 "tracker-turtle-reader.vala"
												_tmp190_ = sb;
#line 283 "tracker-turtle-reader.vala"
												_tmp191_ = p;
#line 283 "tracker-turtle-reader.vala"
												_tmp192_ = end;
#line 283 "tracker-turtle-reader.vala"
												_tmp193_ = p;
#line 283 "tracker-turtle-reader.vala"
												g_string_append_len (_tmp190_, _tmp191_, (gssize) ((glong) (_tmp192_ - _tmp193_)));
#line 284 "tracker-turtle-reader.vala"
												_tmp194_ = end;
#line 284 "tracker-turtle-reader.vala"
												p = _tmp194_;
#line 2952 "tracker-turtle-reader.c"
											} else {
												GString* _tmp195_;
												const gchar* _tmp196_;
												const gchar* _tmp197_;
												const gchar* _tmp198_;
												const gchar* _tmp199_;
												const gchar* _tmp200_;
												gchar _tmp201_;
												const gchar* _tmp210_;
#line 286 "tracker-turtle-reader.vala"
												_tmp195_ = sb;
#line 286 "tracker-turtle-reader.vala"
												_tmp196_ = p;
#line 286 "tracker-turtle-reader.vala"
												_tmp197_ = q;
#line 286 "tracker-turtle-reader.vala"
												_tmp198_ = p;
#line 286 "tracker-turtle-reader.vala"
												g_string_append_len (_tmp195_, _tmp196_, (gssize) ((glong) (_tmp197_ - _tmp198_)));
#line 287 "tracker-turtle-reader.vala"
												_tmp199_ = q;
#line 287 "tracker-turtle-reader.vala"
												p = _tmp199_ + 1;
#line 288 "tracker-turtle-reader.vala"
												_tmp200_ = p;
#line 288 "tracker-turtle-reader.vala"
												_tmp201_ = ((gchar*) _tmp200_)[0];
#line 288 "tracker-turtle-reader.vala"
												switch (_tmp201_) {
#line 288 "tracker-turtle-reader.vala"
													case '\'':
#line 288 "tracker-turtle-reader.vala"
													case '"':
#line 288 "tracker-turtle-reader.vala"
													case '\\':
#line 2988 "tracker-turtle-reader.c"
													{
														GString* _tmp202_;
														const gchar* _tmp203_;
														gchar _tmp204_;
#line 292 "tracker-turtle-reader.vala"
														_tmp202_ = sb;
#line 292 "tracker-turtle-reader.vala"
														_tmp203_ = p;
#line 292 "tracker-turtle-reader.vala"
														_tmp204_ = ((gchar*) _tmp203_)[0];
#line 292 "tracker-turtle-reader.vala"
														g_string_append_c (_tmp202_, _tmp204_);
#line 293 "tracker-turtle-reader.vala"
														break;
#line 3003 "tracker-turtle-reader.c"
													}
#line 288 "tracker-turtle-reader.vala"
													case 'b':
#line 3007 "tracker-turtle-reader.c"
													{
														GString* _tmp205_;
#line 295 "tracker-turtle-reader.vala"
														_tmp205_ = sb;
#line 295 "tracker-turtle-reader.vala"
														g_string_append_c (_tmp205_, '\b');
#line 296 "tracker-turtle-reader.vala"
														break;
#line 3016 "tracker-turtle-reader.c"
													}
#line 288 "tracker-turtle-reader.vala"
													case 'f':
#line 3020 "tracker-turtle-reader.c"
													{
														GString* _tmp206_;
#line 298 "tracker-turtle-reader.vala"
														_tmp206_ = sb;
#line 298 "tracker-turtle-reader.vala"
														g_string_append_c (_tmp206_, '\f');
#line 299 "tracker-turtle-reader.vala"
														break;
#line 3029 "tracker-turtle-reader.c"
													}
#line 288 "tracker-turtle-reader.vala"
													case 'n':
#line 3033 "tracker-turtle-reader.c"
													{
														GString* _tmp207_;
#line 301 "tracker-turtle-reader.vala"
														_tmp207_ = sb;
#line 301 "tracker-turtle-reader.vala"
														g_string_append_c (_tmp207_, '\n');
#line 302 "tracker-turtle-reader.vala"
														break;
#line 3042 "tracker-turtle-reader.c"
													}
#line 288 "tracker-turtle-reader.vala"
													case 'r':
#line 3046 "tracker-turtle-reader.c"
													{
														GString* _tmp208_;
#line 304 "tracker-turtle-reader.vala"
														_tmp208_ = sb;
#line 304 "tracker-turtle-reader.vala"
														g_string_append_c (_tmp208_, '\r');
#line 305 "tracker-turtle-reader.vala"
														break;
#line 3055 "tracker-turtle-reader.c"
													}
#line 288 "tracker-turtle-reader.vala"
													case 't':
#line 3059 "tracker-turtle-reader.c"
													{
														GString* _tmp209_;
#line 307 "tracker-turtle-reader.vala"
														_tmp209_ = sb;
#line 307 "tracker-turtle-reader.vala"
														g_string_append_c (_tmp209_, '\t');
#line 308 "tracker-turtle-reader.vala"
														break;
#line 3068 "tracker-turtle-reader.c"
													}
													default:
#line 288 "tracker-turtle-reader.vala"
													break;
#line 3073 "tracker-turtle-reader.c"
												}
#line 310 "tracker-turtle-reader.vala"
												_tmp210_ = p;
#line 310 "tracker-turtle-reader.vala"
												p = _tmp210_ + 1;
#line 3079 "tracker-turtle-reader.c"
											}
										}
#line 313 "tracker-turtle-reader.vala"
										_tmp211_ = sb;
#line 313 "tracker-turtle-reader.vala"
										_tmp212_ = _tmp211_->str;
#line 313 "tracker-turtle-reader.vala"
										tracker_turtle_reader_set_object (self, _tmp212_);
#line 314 "tracker-turtle-reader.vala"
										tracker_turtle_reader_set_object_is_uri (self, FALSE);
#line 315 "tracker-turtle-reader.vala"
										self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 317 "tracker-turtle-reader.vala"
										_tmp213_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error0_);
#line 317 "tracker-turtle-reader.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 317 "tracker-turtle-reader.vala"
											if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3098 "tracker-turtle-reader.c"
												gboolean _tmp214_ = FALSE;
#line 317 "tracker-turtle-reader.vala"
												g_propagate_error (error, _inner_error0_);
#line 317 "tracker-turtle-reader.vala"
												_g_free0 (s);
#line 317 "tracker-turtle-reader.vala"
												_g_string_free0 (sb);
#line 317 "tracker-turtle-reader.vala"
												return _tmp214_;
#line 3108 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp215_ = FALSE;
#line 317 "tracker-turtle-reader.vala"
												_g_free0 (s);
#line 317 "tracker-turtle-reader.vala"
												_g_string_free0 (sb);
#line 317 "tracker-turtle-reader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 317 "tracker-turtle-reader.vala"
												g_clear_error (&_inner_error0_);
#line 317 "tracker-turtle-reader.vala"
												return _tmp215_;
#line 3121 "tracker-turtle-reader.c"
											}
										}
#line 317 "tracker-turtle-reader.vala"
										if (_tmp213_) {
#line 3126 "tracker-turtle-reader.c"
											gboolean _tmp216_ = FALSE;
#line 318 "tracker-turtle-reader.vala"
											_tmp216_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 318 "tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 318 "tracker-turtle-reader.vala"
												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3134 "tracker-turtle-reader.c"
													gboolean _tmp217_ = FALSE;
#line 318 "tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error0_);
#line 318 "tracker-turtle-reader.vala"
													_g_free0 (s);
#line 318 "tracker-turtle-reader.vala"
													_g_string_free0 (sb);
#line 318 "tracker-turtle-reader.vala"
													return _tmp217_;
#line 3144 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp218_ = FALSE;
#line 318 "tracker-turtle-reader.vala"
													_g_free0 (s);
#line 318 "tracker-turtle-reader.vala"
													_g_string_free0 (sb);
#line 318 "tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 318 "tracker-turtle-reader.vala"
													g_clear_error (&_inner_error0_);
#line 318 "tracker-turtle-reader.vala"
													return _tmp218_;
#line 3157 "tracker-turtle-reader.c"
												}
											}
#line 318 "tracker-turtle-reader.vala"
											if (!_tmp216_) {
#line 319 "tracker-turtle-reader.vala"
												tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 319 "tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 319 "tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3168 "tracker-turtle-reader.c"
														gboolean _tmp219_ = FALSE;
#line 319 "tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 319 "tracker-turtle-reader.vala"
														_g_free0 (s);
#line 319 "tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 319 "tracker-turtle-reader.vala"
														return _tmp219_;
#line 3178 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp220_ = FALSE;
#line 319 "tracker-turtle-reader.vala"
														_g_free0 (s);
#line 319 "tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 319 "tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 319 "tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 319 "tracker-turtle-reader.vala"
														return _tmp220_;
#line 3191 "tracker-turtle-reader.c"
													}
												}
#line 320 "tracker-turtle-reader.vala"
												tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 320 "tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 320 "tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3200 "tracker-turtle-reader.c"
														gboolean _tmp221_ = FALSE;
#line 320 "tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 320 "tracker-turtle-reader.vala"
														_g_free0 (s);
#line 320 "tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 320 "tracker-turtle-reader.vala"
														return _tmp221_;
#line 3210 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp222_ = FALSE;
#line 320 "tracker-turtle-reader.vala"
														_g_free0 (s);
#line 320 "tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 320 "tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 320 "tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 320 "tracker-turtle-reader.vala"
														return _tmp222_;
#line 3223 "tracker-turtle-reader.c"
													}
												}
											}
										}
#line 324 "tracker-turtle-reader.vala"
										result = TRUE;
#line 324 "tracker-turtle-reader.vala"
										_g_free0 (s);
#line 324 "tracker-turtle-reader.vala"
										_g_string_free0 (sb);
#line 324 "tracker-turtle-reader.vala"
										return result;
#line 3236 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp223_ = FALSE;
										gboolean _tmp224_ = FALSE;
#line 325 "tracker-turtle-reader.vala"
										_tmp224_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1, &_inner_error0_);
#line 325 "tracker-turtle-reader.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 325 "tracker-turtle-reader.vala"
											if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3246 "tracker-turtle-reader.c"
												gboolean _tmp225_ = FALSE;
#line 325 "tracker-turtle-reader.vala"
												g_propagate_error (error, _inner_error0_);
#line 325 "tracker-turtle-reader.vala"
												return _tmp225_;
#line 3252 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp226_ = FALSE;
#line 325 "tracker-turtle-reader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 325 "tracker-turtle-reader.vala"
												g_clear_error (&_inner_error0_);
#line 325 "tracker-turtle-reader.vala"
												return _tmp226_;
#line 3261 "tracker-turtle-reader.c"
											}
										}
#line 325 "tracker-turtle-reader.vala"
										if (_tmp224_) {
#line 325 "tracker-turtle-reader.vala"
											_tmp223_ = TRUE;
#line 3268 "tracker-turtle-reader.c"
										} else {
											gboolean _tmp227_ = FALSE;
#line 325 "tracker-turtle-reader.vala"
											_tmp227_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2, &_inner_error0_);
#line 325 "tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 325 "tracker-turtle-reader.vala"
												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3277 "tracker-turtle-reader.c"
													gboolean _tmp228_ = FALSE;
#line 325 "tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error0_);
#line 325 "tracker-turtle-reader.vala"
													return _tmp228_;
#line 3283 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp229_ = FALSE;
#line 325 "tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 325 "tracker-turtle-reader.vala"
													g_clear_error (&_inner_error0_);
#line 325 "tracker-turtle-reader.vala"
													return _tmp229_;
#line 3292 "tracker-turtle-reader.c"
												}
											}
#line 325 "tracker-turtle-reader.vala"
											_tmp223_ = _tmp227_;
#line 3297 "tracker-turtle-reader.c"
										}
#line 325 "tracker-turtle-reader.vala"
										if (_tmp223_) {
#line 3301 "tracker-turtle-reader.c"
											gchar* _tmp230_;
											gchar* _tmp231_;
											gboolean _tmp232_ = FALSE;
#line 326 "tracker-turtle-reader.vala"
											_tmp230_ = tracker_turtle_reader_get_last_string (self, 3);
#line 326 "tracker-turtle-reader.vala"
											_tmp231_ = _tmp230_;
#line 326 "tracker-turtle-reader.vala"
											tracker_turtle_reader_set_object (self, _tmp231_);
#line 326 "tracker-turtle-reader.vala"
											_g_free0 (_tmp231_);
#line 327 "tracker-turtle-reader.vala"
											tracker_turtle_reader_set_object_is_uri (self, FALSE);
#line 328 "tracker-turtle-reader.vala"
											self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 330 "tracker-turtle-reader.vala"
											_tmp232_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error0_);
#line 330 "tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 330 "tracker-turtle-reader.vala"
												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3323 "tracker-turtle-reader.c"
													gboolean _tmp233_ = FALSE;
#line 330 "tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error0_);
#line 330 "tracker-turtle-reader.vala"
													return _tmp233_;
#line 3329 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp234_ = FALSE;
#line 330 "tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 330 "tracker-turtle-reader.vala"
													g_clear_error (&_inner_error0_);
#line 330 "tracker-turtle-reader.vala"
													return _tmp234_;
#line 3338 "tracker-turtle-reader.c"
												}
											}
#line 330 "tracker-turtle-reader.vala"
											if (_tmp232_) {
#line 3343 "tracker-turtle-reader.c"
												gboolean _tmp235_ = FALSE;
#line 331 "tracker-turtle-reader.vala"
												_tmp235_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 331 "tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 331 "tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3351 "tracker-turtle-reader.c"
														gboolean _tmp236_ = FALSE;
#line 331 "tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 331 "tracker-turtle-reader.vala"
														return _tmp236_;
#line 3357 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp237_ = FALSE;
#line 331 "tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 331 "tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 331 "tracker-turtle-reader.vala"
														return _tmp237_;
#line 3366 "tracker-turtle-reader.c"
													}
												}
#line 331 "tracker-turtle-reader.vala"
												if (!_tmp235_) {
#line 332 "tracker-turtle-reader.vala"
													tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 332 "tracker-turtle-reader.vala"
													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 332 "tracker-turtle-reader.vala"
														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3377 "tracker-turtle-reader.c"
															gboolean _tmp238_ = FALSE;
#line 332 "tracker-turtle-reader.vala"
															g_propagate_error (error, _inner_error0_);
#line 332 "tracker-turtle-reader.vala"
															return _tmp238_;
#line 3383 "tracker-turtle-reader.c"
														} else {
															gboolean _tmp239_ = FALSE;
#line 332 "tracker-turtle-reader.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 332 "tracker-turtle-reader.vala"
															g_clear_error (&_inner_error0_);
#line 332 "tracker-turtle-reader.vala"
															return _tmp239_;
#line 3392 "tracker-turtle-reader.c"
														}
													}
#line 333 "tracker-turtle-reader.vala"
													tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 333 "tracker-turtle-reader.vala"
													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 333 "tracker-turtle-reader.vala"
														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3401 "tracker-turtle-reader.c"
															gboolean _tmp240_ = FALSE;
#line 333 "tracker-turtle-reader.vala"
															g_propagate_error (error, _inner_error0_);
#line 333 "tracker-turtle-reader.vala"
															return _tmp240_;
#line 3407 "tracker-turtle-reader.c"
														} else {
															gboolean _tmp241_ = FALSE;
#line 333 "tracker-turtle-reader.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 333 "tracker-turtle-reader.vala"
															g_clear_error (&_inner_error0_);
#line 333 "tracker-turtle-reader.vala"
															return _tmp241_;
#line 3416 "tracker-turtle-reader.c"
														}
													}
												}
											}
#line 337 "tracker-turtle-reader.vala"
											result = TRUE;
#line 337 "tracker-turtle-reader.vala"
											return result;
#line 3425 "tracker-turtle-reader.c"
										} else {
											gboolean _tmp242_ = FALSE;
											gboolean _tmp243_ = FALSE;
											gboolean _tmp244_ = FALSE;
											gboolean _tmp245_ = FALSE;
											gboolean _tmp246_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
											_tmp246_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error0_);
#line 338 "tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 338 "tracker-turtle-reader.vala"
												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3438 "tracker-turtle-reader.c"
													gboolean _tmp247_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error0_);
#line 338 "tracker-turtle-reader.vala"
													return _tmp247_;
#line 3444 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp248_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 338 "tracker-turtle-reader.vala"
													g_clear_error (&_inner_error0_);
#line 338 "tracker-turtle-reader.vala"
													return _tmp248_;
#line 3453 "tracker-turtle-reader.c"
												}
											}
#line 338 "tracker-turtle-reader.vala"
											if (_tmp246_) {
#line 338 "tracker-turtle-reader.vala"
												_tmp245_ = TRUE;
#line 3460 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp249_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
												_tmp249_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DECIMAL, &_inner_error0_);
#line 338 "tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 338 "tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3469 "tracker-turtle-reader.c"
														gboolean _tmp250_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 338 "tracker-turtle-reader.vala"
														return _tmp250_;
#line 3475 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp251_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 338 "tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 338 "tracker-turtle-reader.vala"
														return _tmp251_;
#line 3484 "tracker-turtle-reader.c"
													}
												}
#line 338 "tracker-turtle-reader.vala"
												_tmp245_ = _tmp249_;
#line 3489 "tracker-turtle-reader.c"
											}
#line 338 "tracker-turtle-reader.vala"
											if (_tmp245_) {
#line 338 "tracker-turtle-reader.vala"
												_tmp244_ = TRUE;
#line 3495 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp252_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
												_tmp252_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE, &_inner_error0_);
#line 338 "tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 338 "tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3504 "tracker-turtle-reader.c"
														gboolean _tmp253_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 338 "tracker-turtle-reader.vala"
														return _tmp253_;
#line 3510 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp254_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 338 "tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 338 "tracker-turtle-reader.vala"
														return _tmp254_;
#line 3519 "tracker-turtle-reader.c"
													}
												}
#line 338 "tracker-turtle-reader.vala"
												_tmp244_ = _tmp252_;
#line 3524 "tracker-turtle-reader.c"
											}
#line 338 "tracker-turtle-reader.vala"
											if (_tmp244_) {
#line 338 "tracker-turtle-reader.vala"
												_tmp243_ = TRUE;
#line 3530 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp255_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
												_tmp255_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_TRUE, &_inner_error0_);
#line 338 "tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 338 "tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3539 "tracker-turtle-reader.c"
														gboolean _tmp256_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 338 "tracker-turtle-reader.vala"
														return _tmp256_;
#line 3545 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp257_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 338 "tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 338 "tracker-turtle-reader.vala"
														return _tmp257_;
#line 3554 "tracker-turtle-reader.c"
													}
												}
#line 338 "tracker-turtle-reader.vala"
												_tmp243_ = _tmp255_;
#line 3559 "tracker-turtle-reader.c"
											}
#line 338 "tracker-turtle-reader.vala"
											if (_tmp243_) {
#line 338 "tracker-turtle-reader.vala"
												_tmp242_ = TRUE;
#line 3565 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp258_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
												_tmp258_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FALSE, &_inner_error0_);
#line 338 "tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 338 "tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3574 "tracker-turtle-reader.c"
														gboolean _tmp259_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 338 "tracker-turtle-reader.vala"
														return _tmp259_;
#line 3580 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp260_ = FALSE;
#line 338 "tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 338 "tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 338 "tracker-turtle-reader.vala"
														return _tmp260_;
#line 3589 "tracker-turtle-reader.c"
													}
												}
#line 338 "tracker-turtle-reader.vala"
												_tmp242_ = _tmp258_;
#line 3594 "tracker-turtle-reader.c"
											}
#line 338 "tracker-turtle-reader.vala"
											if (_tmp242_) {
#line 3598 "tracker-turtle-reader.c"
												gchar* _tmp261_;
												gchar* _tmp262_;
#line 339 "tracker-turtle-reader.vala"
												_tmp261_ = tracker_turtle_reader_get_last_string (self, 0);
#line 339 "tracker-turtle-reader.vala"
												_tmp262_ = _tmp261_;
#line 339 "tracker-turtle-reader.vala"
												tracker_turtle_reader_set_object (self, _tmp262_);
#line 339 "tracker-turtle-reader.vala"
												_g_free0 (_tmp262_);
#line 340 "tracker-turtle-reader.vala"
												tracker_turtle_reader_set_object_is_uri (self, FALSE);
#line 341 "tracker-turtle-reader.vala"
												self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 342 "tracker-turtle-reader.vala"
												result = TRUE;
#line 342 "tracker-turtle-reader.vala"
												return result;
#line 3617 "tracker-turtle-reader.c"
											} else {
												GError* _tmp263_;
#line 344 "tracker-turtle-reader.vala"
												_tmp263_ = tracker_turtle_reader_get_error (self, "expected object");
#line 344 "tracker-turtle-reader.vala"
												_inner_error0_ = _tmp263_;
#line 344 "tracker-turtle-reader.vala"
												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3626 "tracker-turtle-reader.c"
													gboolean _tmp264_ = FALSE;
#line 344 "tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error0_);
#line 344 "tracker-turtle-reader.vala"
													return _tmp264_;
#line 3632 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp265_ = FALSE;
#line 344 "tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 344 "tracker-turtle-reader.vala"
													g_clear_error (&_inner_error0_);
#line 344 "tracker-turtle-reader.vala"
													return _tmp265_;
#line 3641 "tracker-turtle-reader.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
#line 165 "tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_OBJECT:
#line 3654 "tracker-turtle-reader.c"
			{
				gboolean _tmp266_ = FALSE;
#line 347 "tracker-turtle-reader.vala"
				_tmp266_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 347 "tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 347 "tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3663 "tracker-turtle-reader.c"
						gboolean _tmp267_ = FALSE;
#line 347 "tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error0_);
#line 347 "tracker-turtle-reader.vala"
						return _tmp267_;
#line 3669 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp268_ = FALSE;
#line 347 "tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 347 "tracker-turtle-reader.vala"
						g_clear_error (&_inner_error0_);
#line 347 "tracker-turtle-reader.vala"
						return _tmp268_;
#line 3678 "tracker-turtle-reader.c"
					}
				}
#line 347 "tracker-turtle-reader.vala"
				if (_tmp266_) {
#line 348 "tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 349 "tracker-turtle-reader.vala"
					continue;
#line 3687 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp269_ = FALSE;
#line 350 "tracker-turtle-reader.vala"
					_tmp269_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error0_);
#line 350 "tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 350 "tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3696 "tracker-turtle-reader.c"
							gboolean _tmp270_ = FALSE;
#line 350 "tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 350 "tracker-turtle-reader.vala"
							return _tmp270_;
#line 3702 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp271_ = FALSE;
#line 350 "tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 350 "tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 350 "tracker-turtle-reader.vala"
							return _tmp271_;
#line 3711 "tracker-turtle-reader.c"
						}
					}
#line 350 "tracker-turtle-reader.vala"
					if (_tmp269_) {
#line 3716 "tracker-turtle-reader.c"
						gboolean _tmp272_ = FALSE;
#line 351 "tracker-turtle-reader.vala"
						_tmp272_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error0_);
#line 351 "tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 351 "tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3724 "tracker-turtle-reader.c"
								gboolean _tmp273_ = FALSE;
#line 351 "tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 351 "tracker-turtle-reader.vala"
								return _tmp273_;
#line 3730 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp274_ = FALSE;
#line 351 "tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 351 "tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 351 "tracker-turtle-reader.vala"
								return _tmp274_;
#line 3739 "tracker-turtle-reader.c"
							}
						}
#line 351 "tracker-turtle-reader.vala"
						if (_tmp272_) {
#line 353 "tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
#line 354 "tracker-turtle-reader.vala"
							continue;
#line 3748 "tracker-turtle-reader.c"
						}
#line 356 "tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 357 "tracker-turtle-reader.vala"
						continue;
#line 3754 "tracker-turtle-reader.c"
					} else {
						gchar** _tmp275_;
						gint _tmp275__length1;
#line 358 "tracker-turtle-reader.vala"
						_tmp275_ = self->priv->subject_stack;
#line 358 "tracker-turtle-reader.vala"
						_tmp275__length1 = self->priv->subject_stack_length1;
#line 358 "tracker-turtle-reader.vala"
						if (_tmp275__length1 > 0) {
#line 3764 "tracker-turtle-reader.c"
							const gchar* _tmp278_;
							gchar** _tmp279_;
							gint _tmp279__length1;
							gchar** _tmp280_;
							gint _tmp280__length1;
							const gchar* _tmp281_;
							gint _tmp282_;
							gchar** _tmp283_;
							gint _tmp283__length1;
							gchar** _tmp284_;
							gint _tmp284__length1;
							const gchar* _tmp285_;
							gint _tmp286_;
#line 360 "tracker-turtle-reader.vala"
							tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error0_);
#line 360 "tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 360 "tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3784 "tracker-turtle-reader.c"
									gboolean _tmp276_ = FALSE;
#line 360 "tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 360 "tracker-turtle-reader.vala"
									return _tmp276_;
#line 3790 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp277_ = FALSE;
#line 360 "tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 360 "tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 360 "tracker-turtle-reader.vala"
									return _tmp277_;
#line 3799 "tracker-turtle-reader.c"
								}
							}
#line 362 "tracker-turtle-reader.vala"
							_tmp278_ = self->priv->_subject;
#line 362 "tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object (self, _tmp278_);
#line 363 "tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 365 "tracker-turtle-reader.vala"
							_tmp279_ = self->priv->subject_stack;
#line 365 "tracker-turtle-reader.vala"
							_tmp279__length1 = self->priv->subject_stack_length1;
#line 365 "tracker-turtle-reader.vala"
							_tmp280_ = self->priv->subject_stack;
#line 365 "tracker-turtle-reader.vala"
							_tmp280__length1 = self->priv->subject_stack_length1;
#line 365 "tracker-turtle-reader.vala"
							_tmp281_ = _tmp279_[_tmp280__length1 - 1];
#line 365 "tracker-turtle-reader.vala"
							tracker_turtle_reader_set_subject (self, _tmp281_);
#line 366 "tracker-turtle-reader.vala"
							_tmp282_ = self->priv->subject_stack_length1;
#line 366 "tracker-turtle-reader.vala"
							self->priv->subject_stack_length1 = _tmp282_ - 1;
#line 368 "tracker-turtle-reader.vala"
							_tmp283_ = self->priv->predicate_stack;
#line 368 "tracker-turtle-reader.vala"
							_tmp283__length1 = self->priv->predicate_stack_length1;
#line 368 "tracker-turtle-reader.vala"
							_tmp284_ = self->priv->predicate_stack;
#line 368 "tracker-turtle-reader.vala"
							_tmp284__length1 = self->priv->predicate_stack_length1;
#line 368 "tracker-turtle-reader.vala"
							_tmp285_ = _tmp283_[_tmp284__length1 - 1];
#line 368 "tracker-turtle-reader.vala"
							tracker_turtle_reader_set_predicate (self, _tmp285_);
#line 369 "tracker-turtle-reader.vala"
							_tmp286_ = self->priv->predicate_stack_length1;
#line 369 "tracker-turtle-reader.vala"
							self->priv->predicate_stack_length1 = _tmp286_ - 1;
#line 371 "tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 372 "tracker-turtle-reader.vala"
							result = TRUE;
#line 372 "tracker-turtle-reader.vala"
							return result;
#line 3846 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp287_ = FALSE;
#line 373 "tracker-turtle-reader.vala"
							_tmp287_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error0_);
#line 373 "tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 373 "tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3855 "tracker-turtle-reader.c"
									gboolean _tmp288_ = FALSE;
#line 373 "tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 373 "tracker-turtle-reader.vala"
									return _tmp288_;
#line 3861 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp289_ = FALSE;
#line 373 "tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 373 "tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 373 "tracker-turtle-reader.vala"
									return _tmp289_;
#line 3870 "tracker-turtle-reader.c"
								}
							}
#line 373 "tracker-turtle-reader.vala"
							if (_tmp287_) {
#line 374 "tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
#line 375 "tracker-turtle-reader.vala"
								continue;
#line 3879 "tracker-turtle-reader.c"
							} else {
								GError* _tmp290_;
#line 377 "tracker-turtle-reader.vala"
								_tmp290_ = tracker_turtle_reader_get_error (self, "expected comma, semicolon, or dot");
#line 377 "tracker-turtle-reader.vala"
								_inner_error0_ = _tmp290_;
#line 377 "tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3888 "tracker-turtle-reader.c"
									gboolean _tmp291_ = FALSE;
#line 377 "tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 377 "tracker-turtle-reader.vala"
									return _tmp291_;
#line 3894 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp292_ = FALSE;
#line 377 "tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 377 "tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 377 "tracker-turtle-reader.vala"
									return _tmp292_;
#line 3903 "tracker-turtle-reader.c"
								}
							}
						}
					}
				}
			}
			default:
#line 165 "tracker-turtle-reader.vala"
			break;
#line 3913 "tracker-turtle-reader.c"
		}
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
#line 400 "tracker-turtle-reader.vala"
	return self ? g_error_copy (self) : NULL;
#line 3923 "tracker-turtle-reader.c"
}

void
tracker_turtle_reader_load (GFile* file,
                            TrackerData* data,
                            GError** error)
{
	GError* _inner_error0_ = NULL;
#line 383 "tracker-turtle-reader.vala"
	g_return_if_fail (file != NULL);
#line 383 "tracker-turtle-reader.vala"
	g_return_if_fail (data != NULL);
#line 3936 "tracker-turtle-reader.c"
	{
		TrackerTurtleReader* reader = NULL;
		TrackerTurtleReader* _tmp0_;
#line 385 "tracker-turtle-reader.vala"
		tracker_data_begin_transaction (data, &_inner_error0_);
#line 385 "tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 385 "tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3946 "tracker-turtle-reader.c"
				goto __catch4_tracker_sparql_error;
			}
#line 385 "tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3951 "tracker-turtle-reader.c"
				goto __catch4_tracker_db_interface_error;
			}
#line 385 "tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 385 "tracker-turtle-reader.vala"
			g_clear_error (&_inner_error0_);
#line 385 "tracker-turtle-reader.vala"
			return;
#line 3960 "tracker-turtle-reader.c"
		}
#line 387 "tracker-turtle-reader.vala"
		_tmp0_ = tracker_turtle_reader_new (file, &_inner_error0_);
#line 387 "tracker-turtle-reader.vala"
		reader = _tmp0_;
#line 387 "tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 387 "tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3970 "tracker-turtle-reader.c"
				goto __catch4_tracker_sparql_error;
			}
#line 387 "tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3975 "tracker-turtle-reader.c"
				goto __catch4_tracker_db_interface_error;
			}
			goto __finally4;
		}
#line 388 "tracker-turtle-reader.vala"
		while (TRUE) {
#line 3982 "tracker-turtle-reader.c"
			gboolean _tmp1_ = FALSE;
			TrackerTurtleReader* _tmp2_;
			TrackerTurtleReader* _tmp3_;
			gboolean _tmp4_;
#line 388 "tracker-turtle-reader.vala"
			_tmp2_ = reader;
#line 388 "tracker-turtle-reader.vala"
			_tmp1_ = tracker_turtle_reader_next (_tmp2_, &_inner_error0_);
#line 388 "tracker-turtle-reader.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 388 "tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 388 "tracker-turtle-reader.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3997 "tracker-turtle-reader.c"
					goto __catch4_tracker_sparql_error;
				}
#line 388 "tracker-turtle-reader.vala"
				if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4002 "tracker-turtle-reader.c"
					goto __catch4_tracker_db_interface_error;
				}
#line 388 "tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 388 "tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 388 "tracker-turtle-reader.vala"
				g_clear_error (&_inner_error0_);
#line 388 "tracker-turtle-reader.vala"
				return;
#line 4013 "tracker-turtle-reader.c"
			}
#line 388 "tracker-turtle-reader.vala"
			if (!_tmp1_) {
#line 388 "tracker-turtle-reader.vala"
				break;
#line 4019 "tracker-turtle-reader.c"
			}
#line 389 "tracker-turtle-reader.vala"
			_tmp3_ = reader;
#line 389 "tracker-turtle-reader.vala"
			_tmp4_ = _tmp3_->priv->_object_is_uri;
#line 389 "tracker-turtle-reader.vala"
			if (_tmp4_) {
#line 4027 "tracker-turtle-reader.c"
				TrackerTurtleReader* _tmp5_;
				const gchar* _tmp6_;
				TrackerTurtleReader* _tmp7_;
				const gchar* _tmp8_;
				TrackerTurtleReader* _tmp9_;
				const gchar* _tmp10_;
				TrackerTurtleReader* _tmp11_;
				const gchar* _tmp12_;
#line 390 "tracker-turtle-reader.vala"
				_tmp5_ = reader;
#line 390 "tracker-turtle-reader.vala"
				_tmp6_ = _tmp5_->priv->_graph;
#line 390 "tracker-turtle-reader.vala"
				_tmp7_ = reader;
#line 390 "tracker-turtle-reader.vala"
				_tmp8_ = _tmp7_->priv->_subject;
#line 390 "tracker-turtle-reader.vala"
				_tmp9_ = reader;
#line 390 "tracker-turtle-reader.vala"
				_tmp10_ = _tmp9_->priv->_predicate;
#line 390 "tracker-turtle-reader.vala"
				_tmp11_ = reader;
#line 390 "tracker-turtle-reader.vala"
				_tmp12_ = _tmp11_->priv->_object;
#line 390 "tracker-turtle-reader.vala"
				tracker_data_insert_statement_with_uri (data, _tmp6_, _tmp8_, _tmp10_, _tmp12_, &_inner_error0_);
#line 390 "tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 390 "tracker-turtle-reader.vala"
					_g_object_unref0 (reader);
#line 390 "tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 4060 "tracker-turtle-reader.c"
						goto __catch4_tracker_sparql_error;
					}
#line 390 "tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4065 "tracker-turtle-reader.c"
						goto __catch4_tracker_db_interface_error;
					}
#line 390 "tracker-turtle-reader.vala"
					_g_object_unref0 (reader);
#line 390 "tracker-turtle-reader.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 390 "tracker-turtle-reader.vala"
					g_clear_error (&_inner_error0_);
#line 390 "tracker-turtle-reader.vala"
					return;
#line 4076 "tracker-turtle-reader.c"
				}
			} else {
				TrackerTurtleReader* _tmp13_;
				const gchar* _tmp14_;
				TrackerTurtleReader* _tmp15_;
				const gchar* _tmp16_;
				TrackerTurtleReader* _tmp17_;
				const gchar* _tmp18_;
				TrackerTurtleReader* _tmp19_;
				const gchar* _tmp20_;
#line 392 "tracker-turtle-reader.vala"
				_tmp13_ = reader;
#line 392 "tracker-turtle-reader.vala"
				_tmp14_ = _tmp13_->priv->_graph;
#line 392 "tracker-turtle-reader.vala"
				_tmp15_ = reader;
#line 392 "tracker-turtle-reader.vala"
				_tmp16_ = _tmp15_->priv->_subject;
#line 392 "tracker-turtle-reader.vala"
				_tmp17_ = reader;
#line 392 "tracker-turtle-reader.vala"
				_tmp18_ = _tmp17_->priv->_predicate;
#line 392 "tracker-turtle-reader.vala"
				_tmp19_ = reader;
#line 392 "tracker-turtle-reader.vala"
				_tmp20_ = _tmp19_->priv->_object;
#line 392 "tracker-turtle-reader.vala"
				tracker_data_insert_statement_with_string (data, _tmp14_, _tmp16_, _tmp18_, _tmp20_, &_inner_error0_);
#line 392 "tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 392 "tracker-turtle-reader.vala"
					_g_object_unref0 (reader);
#line 392 "tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 4111 "tracker-turtle-reader.c"
						goto __catch4_tracker_sparql_error;
					}
#line 392 "tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4116 "tracker-turtle-reader.c"
						goto __catch4_tracker_db_interface_error;
					}
					goto __finally4;
				}
			}
#line 394 "tracker-turtle-reader.vala"
			tracker_data_update_buffer_might_flush (data, &_inner_error0_);
#line 394 "tracker-turtle-reader.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 394 "tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 394 "tracker-turtle-reader.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 4130 "tracker-turtle-reader.c"
					goto __catch4_tracker_sparql_error;
				}
#line 394 "tracker-turtle-reader.vala"
				if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4135 "tracker-turtle-reader.c"
					goto __catch4_tracker_db_interface_error;
				}
#line 394 "tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 394 "tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 394 "tracker-turtle-reader.vala"
				g_clear_error (&_inner_error0_);
#line 394 "tracker-turtle-reader.vala"
				return;
#line 4146 "tracker-turtle-reader.c"
			}
		}
#line 397 "tracker-turtle-reader.vala"
		tracker_data_commit_transaction (data, &_inner_error0_);
#line 397 "tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 397 "tracker-turtle-reader.vala"
			_g_object_unref0 (reader);
#line 397 "tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 4157 "tracker-turtle-reader.c"
				goto __catch4_tracker_sparql_error;
			}
#line 397 "tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4162 "tracker-turtle-reader.c"
				goto __catch4_tracker_db_interface_error;
			}
#line 397 "tracker-turtle-reader.vala"
			_g_object_unref0 (reader);
#line 397 "tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 397 "tracker-turtle-reader.vala"
			g_clear_error (&_inner_error0_);
#line 397 "tracker-turtle-reader.vala"
			return;
#line 4173 "tracker-turtle-reader.c"
		}
#line 384 "tracker-turtle-reader.vala"
		_g_object_unref0 (reader);
#line 4177 "tracker-turtle-reader.c"
	}
	goto __finally4;
	__catch4_tracker_sparql_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		GError* _tmp22_;
#line 384 "tracker-turtle-reader.vala"
		e = _inner_error0_;
#line 384 "tracker-turtle-reader.vala"
		_inner_error0_ = NULL;
#line 399 "tracker-turtle-reader.vala"
		tracker_data_rollback_transaction (data);
#line 400 "tracker-turtle-reader.vala"
		_tmp21_ = e;
#line 400 "tracker-turtle-reader.vala"
		_tmp22_ = _g_error_copy0 (_tmp21_);
#line 400 "tracker-turtle-reader.vala"
		_inner_error0_ = _tmp22_;
#line 400 "tracker-turtle-reader.vala"
		_g_error_free0 (e);
#line 4199 "tracker-turtle-reader.c"
		goto __finally4;
	}
	goto __finally4;
	__catch4_tracker_db_interface_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		GError* _tmp24_;
#line 384 "tracker-turtle-reader.vala"
		e = _inner_error0_;
#line 384 "tracker-turtle-reader.vala"
		_inner_error0_ = NULL;
#line 402 "tracker-turtle-reader.vala"
		tracker_data_rollback_transaction (data);
#line 403 "tracker-turtle-reader.vala"
		_tmp23_ = e;
#line 403 "tracker-turtle-reader.vala"
		_tmp24_ = _g_error_copy0 (_tmp23_);
#line 403 "tracker-turtle-reader.vala"
		_inner_error0_ = _tmp24_;
#line 403 "tracker-turtle-reader.vala"
		_g_error_free0 (e);
#line 4222 "tracker-turtle-reader.c"
		goto __finally4;
	}
	__finally4:
#line 384 "tracker-turtle-reader.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 384 "tracker-turtle-reader.vala"
		g_propagate_error (error, _inner_error0_);
#line 384 "tracker-turtle-reader.vala"
		return;
#line 4232 "tracker-turtle-reader.c"
	}
}

const gchar*
tracker_turtle_reader_get_graph (TrackerTurtleReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 50 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_graph;
#line 50 "tracker-turtle-reader.vala"
	result = _tmp0_;
#line 50 "tracker-turtle-reader.vala"
	return result;
#line 4249 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_set_graph (TrackerTurtleReader* self,
                                 const gchar* value)
{
#line 50 "tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 50 "tracker-turtle-reader.vala"
	if (g_strcmp0 (value, tracker_turtle_reader_get_graph (self)) != 0) {
#line 4260 "tracker-turtle-reader.c"
		gchar* _tmp0_;
#line 50 "tracker-turtle-reader.vala"
		_tmp0_ = g_strdup (value);
#line 50 "tracker-turtle-reader.vala"
		_g_free0 (self->priv->_graph);
#line 50 "tracker-turtle-reader.vala"
		self->priv->_graph = _tmp0_;
#line 50 "tracker-turtle-reader.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_GRAPH_PROPERTY]);
#line 4270 "tracker-turtle-reader.c"
	}
}

const gchar*
tracker_turtle_reader_get_subject (TrackerTurtleReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 52 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_subject;
#line 52 "tracker-turtle-reader.vala"
	result = _tmp0_;
#line 52 "tracker-turtle-reader.vala"
	return result;
#line 4287 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_set_subject (TrackerTurtleReader* self,
                                   const gchar* value)
{
#line 52 "tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 52 "tracker-turtle-reader.vala"
	if (g_strcmp0 (value, tracker_turtle_reader_get_subject (self)) != 0) {
#line 4298 "tracker-turtle-reader.c"
		gchar* _tmp0_;
#line 52 "tracker-turtle-reader.vala"
		_tmp0_ = g_strdup (value);
#line 52 "tracker-turtle-reader.vala"
		_g_free0 (self->priv->_subject);
#line 52 "tracker-turtle-reader.vala"
		self->priv->_subject = _tmp0_;
#line 52 "tracker-turtle-reader.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_SUBJECT_PROPERTY]);
#line 4308 "tracker-turtle-reader.c"
	}
}

const gchar*
tracker_turtle_reader_get_predicate (TrackerTurtleReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 53 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_predicate;
#line 53 "tracker-turtle-reader.vala"
	result = _tmp0_;
#line 53 "tracker-turtle-reader.vala"
	return result;
#line 4325 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_set_predicate (TrackerTurtleReader* self,
                                     const gchar* value)
{
#line 53 "tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 53 "tracker-turtle-reader.vala"
	if (g_strcmp0 (value, tracker_turtle_reader_get_predicate (self)) != 0) {
#line 4336 "tracker-turtle-reader.c"
		gchar* _tmp0_;
#line 53 "tracker-turtle-reader.vala"
		_tmp0_ = g_strdup (value);
#line 53 "tracker-turtle-reader.vala"
		_g_free0 (self->priv->_predicate);
#line 53 "tracker-turtle-reader.vala"
		self->priv->_predicate = _tmp0_;
#line 53 "tracker-turtle-reader.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_PREDICATE_PROPERTY]);
#line 4346 "tracker-turtle-reader.c"
	}
}

const gchar*
tracker_turtle_reader_get_object (TrackerTurtleReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 54 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 54 "tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_object;
#line 54 "tracker-turtle-reader.vala"
	result = _tmp0_;
#line 54 "tracker-turtle-reader.vala"
	return result;
#line 4363 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_set_object (TrackerTurtleReader* self,
                                  const gchar* value)
{
#line 54 "tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 54 "tracker-turtle-reader.vala"
	if (g_strcmp0 (value, tracker_turtle_reader_get_object (self)) != 0) {
#line 4374 "tracker-turtle-reader.c"
		gchar* _tmp0_;
#line 54 "tracker-turtle-reader.vala"
		_tmp0_ = g_strdup (value);
#line 54 "tracker-turtle-reader.vala"
		_g_free0 (self->priv->_object);
#line 54 "tracker-turtle-reader.vala"
		self->priv->_object = _tmp0_;
#line 54 "tracker-turtle-reader.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_OBJECT_PROPERTY]);
#line 4384 "tracker-turtle-reader.c"
	}
}

gboolean
tracker_turtle_reader_get_object_is_uri (TrackerTurtleReader* self)
{
	gboolean result;
#line 55 "tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 55 "tracker-turtle-reader.vala"
	result = self->priv->_object_is_uri;
#line 55 "tracker-turtle-reader.vala"
	return result;
#line 4398 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_set_object_is_uri (TrackerTurtleReader* self,
                                         gboolean value)
{
#line 55 "tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 55 "tracker-turtle-reader.vala"
	if (tracker_turtle_reader_get_object_is_uri (self) != value) {
#line 55 "tracker-turtle-reader.vala"
		self->priv->_object_is_uri = value;
#line 55 "tracker-turtle-reader.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_OBJECT_IS_URI_PROPERTY]);
#line 4413 "tracker-turtle-reader.c"
	}
}

static TrackerTurtleReaderTokenInfo*
tracker_turtle_reader_token_info_dup (const TrackerTurtleReaderTokenInfo* self)
{
	TrackerTurtleReaderTokenInfo* dup;
#line 33 "tracker-turtle-reader.vala"
	dup = g_new0 (TrackerTurtleReaderTokenInfo, 1);
#line 33 "tracker-turtle-reader.vala"
	memcpy (dup, self, sizeof (TrackerTurtleReaderTokenInfo));
#line 33 "tracker-turtle-reader.vala"
	return dup;
#line 4427 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_token_info_free (TrackerTurtleReaderTokenInfo* self)
{
#line 33 "tracker-turtle-reader.vala"
	g_free (self);
#line 4435 "tracker-turtle-reader.c"
}

static GType
tracker_turtle_reader_token_info_get_type (void)
{
	static volatile gsize tracker_turtle_reader_token_info_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_turtle_reader_token_info_type_id__volatile)) {
		GType tracker_turtle_reader_token_info_type_id;
		tracker_turtle_reader_token_info_type_id = g_boxed_type_register_static ("TrackerTurtleReaderTokenInfo", (GBoxedCopyFunc) tracker_turtle_reader_token_info_dup, (GBoxedFreeFunc) tracker_turtle_reader_token_info_free);
		g_once_init_leave (&tracker_turtle_reader_token_info_type_id__volatile, tracker_turtle_reader_token_info_type_id);
	}
	return tracker_turtle_reader_token_info_type_id__volatile;
}

static void
tracker_turtle_reader_class_init (TrackerTurtleReaderClass * klass,
                                  gpointer klass_data)
{
#line 20 "tracker-turtle-reader.vala"
	tracker_turtle_reader_parent_class = g_type_class_peek_parent (klass);
#line 20 "tracker-turtle-reader.vala"
	g_type_class_adjust_private_offset (klass, &TrackerTurtleReader_private_offset);
#line 20 "tracker-turtle-reader.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_turtle_reader_get_property;
#line 20 "tracker-turtle-reader.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_turtle_reader_set_property;
#line 20 "tracker-turtle-reader.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_turtle_reader_finalize;
#line 20 "tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_GRAPH_PROPERTY, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_GRAPH_PROPERTY] = g_param_spec_string ("graph", "graph", "graph", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 20 "tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_SUBJECT_PROPERTY, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_SUBJECT_PROPERTY] = g_param_spec_string ("subject", "subject", "subject", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 20 "tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_PREDICATE_PROPERTY, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_PREDICATE_PROPERTY] = g_param_spec_string ("predicate", "predicate", "predicate", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 20 "tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_OBJECT_PROPERTY, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_OBJECT_PROPERTY] = g_param_spec_string ("object", "object", "object", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 20 "tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_OBJECT_IS_URI_PROPERTY, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_OBJECT_IS_URI_PROPERTY] = g_param_spec_boolean ("object-is-uri", "object-is-uri", "object-is-uri", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 4474 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_instance_init (TrackerTurtleReader * self,
                                     gpointer klass)
{
#line 20 "tracker-turtle-reader.vala"
	self->priv = tracker_turtle_reader_get_instance_private (self);
#line 62 "tracker-turtle-reader.vala"
	self->priv->bnodeid = 0;
#line 4485 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_finalize (GObject * obj)
{
	TrackerTurtleReader * self;
#line 20 "tracker-turtle-reader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader);
#line 21 "tracker-turtle-reader.vala"
	_g_object_unref0 (self->priv->scanner);
#line 24 "tracker-turtle-reader.vala"
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
#line 50 "tracker-turtle-reader.vala"
	_g_free0 (self->priv->_graph);
#line 52 "tracker-turtle-reader.vala"
	_g_free0 (self->priv->_subject);
#line 53 "tracker-turtle-reader.vala"
	_g_free0 (self->priv->_predicate);
#line 54 "tracker-turtle-reader.vala"
	_g_free0 (self->priv->_object);
#line 57 "tracker-turtle-reader.vala"
	_g_hash_table_unref0 (self->priv->prefix_map);
#line 59 "tracker-turtle-reader.vala"
	self->priv->subject_stack = (_vala_array_free (self->priv->subject_stack, self->priv->subject_stack_length1, (GDestroyNotify) g_free), NULL);
#line 60 "tracker-turtle-reader.vala"
	self->priv->predicate_stack = (_vala_array_free (self->priv->predicate_stack, self->priv->predicate_stack_length1, (GDestroyNotify) g_free), NULL);
#line 64 "tracker-turtle-reader.vala"
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
#line 66 "tracker-turtle-reader.vala"
	_g_mapped_file_unref0 (self->priv->mapped_file);
#line 67 "tracker-turtle-reader.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 20 "tracker-turtle-reader.vala"
	G_OBJECT_CLASS (tracker_turtle_reader_parent_class)->finalize (obj);
#line 4520 "tracker-turtle-reader.c"
}

GType
tracker_turtle_reader_get_type (void)
{
	static volatile gsize tracker_turtle_reader_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_turtle_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTurtleReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_turtle_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTurtleReader), 0, (GInstanceInitFunc) tracker_turtle_reader_instance_init, NULL };
		GType tracker_turtle_reader_type_id;
		tracker_turtle_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerTurtleReader", &g_define_type_info, 0);
		TrackerTurtleReader_private_offset = g_type_add_instance_private (tracker_turtle_reader_type_id, sizeof (TrackerTurtleReaderPrivate));
		g_once_init_leave (&tracker_turtle_reader_type_id__volatile, tracker_turtle_reader_type_id);
	}
	return tracker_turtle_reader_type_id__volatile;
}

static void
_vala_tracker_turtle_reader_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	TrackerTurtleReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader);
#line 20 "tracker-turtle-reader.vala"
	switch (property_id) {
#line 20 "tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_GRAPH_PROPERTY:
#line 20 "tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_graph (self));
#line 20 "tracker-turtle-reader.vala"
		break;
#line 20 "tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_SUBJECT_PROPERTY:
#line 20 "tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_subject (self));
#line 20 "tracker-turtle-reader.vala"
		break;
#line 20 "tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_PREDICATE_PROPERTY:
#line 20 "tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_predicate (self));
#line 20 "tracker-turtle-reader.vala"
		break;
#line 20 "tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT_PROPERTY:
#line 20 "tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_object (self));
#line 20 "tracker-turtle-reader.vala"
		break;
#line 20 "tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT_IS_URI_PROPERTY:
#line 20 "tracker-turtle-reader.vala"
		g_value_set_boolean (value, tracker_turtle_reader_get_object_is_uri (self));
#line 20 "tracker-turtle-reader.vala"
		break;
#line 4577 "tracker-turtle-reader.c"
		default:
#line 20 "tracker-turtle-reader.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "tracker-turtle-reader.vala"
		break;
#line 4583 "tracker-turtle-reader.c"
	}
}

static void
_vala_tracker_turtle_reader_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	TrackerTurtleReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader);
#line 20 "tracker-turtle-reader.vala"
	switch (property_id) {
#line 20 "tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_GRAPH_PROPERTY:
#line 20 "tracker-turtle-reader.vala"
		tracker_turtle_reader_set_graph (self, g_value_get_string (value));
#line 20 "tracker-turtle-reader.vala"
		break;
#line 20 "tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_SUBJECT_PROPERTY:
#line 20 "tracker-turtle-reader.vala"
		tracker_turtle_reader_set_subject (self, g_value_get_string (value));
#line 20 "tracker-turtle-reader.vala"
		break;
#line 20 "tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_PREDICATE_PROPERTY:
#line 20 "tracker-turtle-reader.vala"
		tracker_turtle_reader_set_predicate (self, g_value_get_string (value));
#line 20 "tracker-turtle-reader.vala"
		break;
#line 20 "tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT_PROPERTY:
#line 20 "tracker-turtle-reader.vala"
		tracker_turtle_reader_set_object (self, g_value_get_string (value));
#line 20 "tracker-turtle-reader.vala"
		break;
#line 20 "tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT_IS_URI_PROPERTY:
#line 20 "tracker-turtle-reader.vala"
		tracker_turtle_reader_set_object_is_uri (self, g_value_get_boolean (value));
#line 20 "tracker-turtle-reader.vala"
		break;
#line 4627 "tracker-turtle-reader.c"
		default:
#line 20 "tracker-turtle-reader.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "tracker-turtle-reader.vala"
		break;
#line 4633 "tracker-turtle-reader.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

