/* valagerrormodule.c generated by valac, the Vala compiler
 * generated from valagerrormodule.vala, do not modify */

/* valagerrormodule.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Jürg Billeter <j@bitron.ch>
 *	Thijs Vermeir <thijsvermeir@gmail.com>
 */

#include "valacodegen.h"
#include <glib.h>
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))

struct _ValaGErrorModulePrivate {
	gint current_try_id;
	gint next_try_id;
	gboolean is_in_catch;
};

static gint ValaGErrorModule_private_offset;
static gpointer vala_gerror_module_parent_class = NULL;

static void vala_gerror_module_real_generate_error_domain_declaration (ValaCCodeBaseModule* base,
                                                                ValaErrorDomain* edomain,
                                                                ValaCCodeFile* decl_space);
static void vala_gerror_module_real_visit_error_domain (ValaCodeVisitor* base,
                                                 ValaErrorDomain* edomain);
static void vala_gerror_module_real_visit_throw_statement (ValaCodeVisitor* base,
                                                    ValaThrowStatement* stmt);
static void vala_gerror_module_real_return_with_exception (ValaGErrorModule* self,
                                                    ValaCCodeExpression* error_expr);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gerror_module_uncaught_error_statement (ValaGErrorModule* self,
                                                  ValaCCodeExpression* inner_error,
                                                  gboolean unexpected);
static gboolean vala_gerror_module_in_finally_block (ValaGErrorModule* self,
                                              ValaCodeNode* node);
static void vala_gerror_module_real_add_simple_check (ValaCCodeBaseModule* base,
                                               ValaCodeNode* node,
                                               gboolean always_fails);
static void vala_gerror_module_real_visit_try_statement (ValaCodeVisitor* base,
                                                  ValaTryStatement* stmt);
static void vala_gerror_module_real_visit_catch_clause (ValaCodeVisitor* base,
                                                 ValaCatchClause* clause);
static void vala_gerror_module_real_append_scope_free (ValaCCodeBaseModule* base,
                                                ValaSymbol* sym,
                                                ValaCodeNode* stop_at);
static void vala_gerror_module_finalize (ValaCodeVisitor * obj);

static inline gpointer
vala_gerror_module_get_instance_private (ValaGErrorModule* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGErrorModule_private_offset);
}

static void
vala_gerror_module_real_generate_error_domain_declaration (ValaCCodeBaseModule* base,
                                                           ValaErrorDomain* edomain,
                                                           ValaCCodeFile* decl_space)
{
	ValaGErrorModule * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	ValaDataType* _tmp3_;
	ValaCCodeEnum* cenum = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaCCodeEnum* _tmp6_;
	ValaCCodeEnum* _tmp7_;
	ValaCCodeEnum* _tmp37_;
	gchar* quark_fun_name = NULL;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	ValaCCodeMacroReplacement* error_domain_define = NULL;
	gchar* _tmp42_;
	gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	ValaCCodeMacroReplacement* _tmp47_;
	ValaCCodeMacroReplacement* _tmp48_;
	ValaCCodeMacroReplacement* _tmp49_;
	ValaCCodeFunction* cquark_fun = NULL;
	const gchar* _tmp50_;
	ValaDataType* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaTypeSymbol* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (edomain != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = vala_get_ccode_name ((ValaCodeNode*) edomain);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_add_symbol_declaration ((ValaCCodeBaseModule*) self, decl_space, (ValaSymbol*) edomain, _tmp1_);
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, _tmp3_, decl_space);
	_tmp4_ = vala_get_ccode_name ((ValaCodeNode*) edomain);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_enum_new (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	cenum = _tmp7_;
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp8_;
		gint _ecode_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _ecode_index = 0;
		_tmp8_ = vala_error_domain_get_codes (edomain);
		_ecode_list = _tmp8_;
		_tmp9_ = _ecode_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_ecode_size = _tmp11_;
		_ecode_index = -1;
		while (TRUE) {
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaErrorCode* _tmp14_;
			ValaExpression* _tmp15_;
			ValaExpression* _tmp16_;
			_ecode_index = _ecode_index + 1;
			if (!(_ecode_index < _ecode_size)) {
				break;
			}
			_tmp12_ = _ecode_list;
			_tmp13_ = vala_list_get (_tmp12_, _ecode_index);
			ecode = (ValaErrorCode*) _tmp13_;
			_tmp14_ = ecode;
			_tmp15_ = vala_error_code_get_value (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_ == NULL) {
				ValaCCodeEnum* _tmp17_;
				ValaErrorCode* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				ValaCCodeEnumValue* _tmp21_;
				ValaCCodeEnumValue* _tmp22_;
				_tmp17_ = cenum;
				_tmp18_ = ecode;
				_tmp19_ = vala_get_ccode_name ((ValaCodeNode*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = vala_ccode_enum_value_new (_tmp20_, NULL);
				_tmp22_ = _tmp21_;
				vala_ccode_enum_add_value (_tmp17_, _tmp22_);
				_vala_ccode_node_unref0 (_tmp22_);
				_g_free0 (_tmp20_);
			} else {
				ValaErrorCode* _tmp23_;
				ValaExpression* _tmp24_;
				ValaExpression* _tmp25_;
				ValaCCodeEnum* _tmp26_;
				ValaErrorCode* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				ValaErrorCode* _tmp30_;
				ValaExpression* _tmp31_;
				ValaExpression* _tmp32_;
				ValaCCodeExpression* _tmp33_;
				ValaCCodeExpression* _tmp34_;
				ValaCCodeEnumValue* _tmp35_;
				ValaCCodeEnumValue* _tmp36_;
				_tmp23_ = ecode;
				_tmp24_ = vala_error_code_get_value (_tmp23_);
				_tmp25_ = _tmp24_;
				vala_code_node_emit ((ValaCodeNode*) _tmp25_, (ValaCodeGenerator*) self);
				_tmp26_ = cenum;
				_tmp27_ = ecode;
				_tmp28_ = vala_get_ccode_name ((ValaCodeNode*) _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = ecode;
				_tmp31_ = vala_error_code_get_value (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_ccode_enum_value_new (_tmp29_, _tmp34_);
				_tmp36_ = _tmp35_;
				vala_ccode_enum_add_value (_tmp26_, _tmp36_);
				_vala_ccode_node_unref0 (_tmp36_);
				_vala_ccode_node_unref0 (_tmp34_);
				_g_free0 (_tmp29_);
			}
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	_tmp37_ = cenum;
	vala_ccode_file_add_type_definition (decl_space, (ValaCCodeNode*) _tmp37_);
	_tmp38_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strconcat (_tmp39_, "quark", NULL);
	_tmp41_ = _tmp40_;
	_g_free0 (_tmp39_);
	quark_fun_name = _tmp41_;
	_tmp42_ = vala_get_ccode_upper_case_name ((ValaSymbol*) edomain, NULL);
	_tmp43_ = _tmp42_;
	_tmp44_ = quark_fun_name;
	_tmp45_ = g_strconcat (_tmp44_, " ()", NULL);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_ccode_macro_replacement_new (_tmp43_, _tmp46_);
	_tmp48_ = _tmp47_;
	_g_free0 (_tmp46_);
	_g_free0 (_tmp43_);
	error_domain_define = _tmp48_;
	_tmp49_ = error_domain_define;
	vala_ccode_file_add_type_definition (decl_space, (ValaCCodeNode*) _tmp49_);
	_tmp50_ = quark_fun_name;
	_tmp51_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	_tmp52_ = vala_data_type_get_data_type (_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = vala_get_ccode_name ((ValaCodeNode*) _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_ccode_function_new (_tmp50_, _tmp55_);
	_tmp57_ = _tmp56_;
	_g_free0 (_tmp55_);
	cquark_fun = _tmp57_;
	_tmp58_ = cquark_fun;
	vala_ccode_file_add_function_declaration (decl_space, _tmp58_);
	_vala_ccode_node_unref0 (cquark_fun);
	_vala_ccode_node_unref0 (error_domain_define);
	_g_free0 (quark_fun_name);
	_vala_ccode_node_unref0 (cenum);
}

static void
vala_gerror_module_real_visit_error_domain (ValaCodeVisitor* base,
                                            ValaErrorDomain* edomain)
{
	ValaGErrorModule * self;
	ValaComment* _tmp0_;
	ValaComment* _tmp1_;
	ValaCCodeFile* _tmp9_;
	gchar* quark_fun_name = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	ValaCCodeFunction* cquark_fun = NULL;
	ValaDataType* _tmp16_;
	ValaTypeSymbol* _tmp17_;
	ValaTypeSymbol* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunctionCall* cquark_call = NULL;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	ValaCCodeConstant* _tmp33_;
	ValaCCodeConstant* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunction* _tmp36_;
	ValaCCodeFile* _tmp37_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_symbol_get_comment ((ValaSymbol*) edomain);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaCCodeFile* _tmp2_;
		ValaComment* _tmp3_;
		ValaComment* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		ValaCCodeComment* _tmp7_;
		ValaCCodeComment* _tmp8_;
		_tmp2_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp3_ = vala_symbol_get_comment ((ValaSymbol*) edomain);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_comment_get_content (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_ccode_comment_new (_tmp6_);
		_tmp8_ = _tmp7_;
		vala_ccode_file_add_type_definition (_tmp2_, (ValaCCodeNode*) _tmp8_);
		_vala_ccode_node_unref0 (_tmp8_);
	}
	_tmp9_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp9_);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp10_;
		_tmp10_ = ((ValaCCodeBaseModule*) self)->header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp10_);
	}
	if (!vala_symbol_is_private_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp11_;
		_tmp11_ = ((ValaCCodeBaseModule*) self)->internal_header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp11_);
	}
	_tmp12_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "quark", NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	quark_fun_name = _tmp15_;
	_tmp16_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	_tmp17_ = vala_data_type_get_data_type (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_get_ccode_name ((ValaCodeNode*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_ccode_function_new (quark_fun_name, _tmp20_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	cquark_fun = _tmp22_;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, cquark_fun);
	_tmp23_ = vala_ccode_identifier_new ("g_quark_from_static_string");
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp24_);
	_tmp26_ = _tmp25_;
	_vala_ccode_node_unref0 (_tmp24_);
	cquark_call = _tmp26_;
	_tmp27_ = vala_get_ccode_quark_name (edomain);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat ("\"", _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp30_, "\"", NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_ccode_constant_new (_tmp32_);
	_tmp34_ = _tmp33_;
	vala_ccode_function_call_add_argument (cquark_call, (ValaCCodeExpression*) _tmp34_);
	_vala_ccode_node_unref0 (_tmp34_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp36_ = _tmp35_;
	vala_ccode_function_add_return (_tmp36_, (ValaCCodeExpression*) cquark_call);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp37_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_function (_tmp37_, cquark_fun);
	_vala_ccode_node_unref0 (cquark_call);
	_vala_ccode_node_unref0 (cquark_fun);
	_g_free0 (quark_fun_name);
}

static void
vala_gerror_module_real_visit_throw_statement (ValaCodeVisitor* base,
                                               ValaThrowStatement* stmt)
{
	ValaGErrorModule * self;
	ValaCCodeFunction* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCCodeExpression* _tmp6_;
	ValaCCodeExpression* _tmp7_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
	_tmp0_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_throw_statement_get_error_expression (stmt);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp5_);
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_assignment (_tmp1_, _tmp3_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_vala_ccode_node_unref0 (_tmp3_);
	vala_ccode_base_module_add_simple_check ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, TRUE);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_gerror_module_real_return_with_exception (ValaGErrorModule* self,
                                               ValaCCodeExpression* error_expr)
{
	ValaCCodeFunctionCall* cpropagate = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeFunctionCall* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	gboolean _tmp13_ = FALSE;
	ValaMethod* _tmp14_;
	ValaMethod* _tmp15_;
	g_return_if_fail (error_expr != NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_propagate_error");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	cpropagate = _tmp3_;
	_tmp4_ = cpropagate;
	_tmp5_ = vala_ccode_identifier_new ("error");
	_tmp6_ = _tmp5_;
	vala_ccode_function_call_add_argument (_tmp4_, (ValaCCodeExpression*) _tmp6_);
	_vala_ccode_node_unref0 (_tmp6_);
	_tmp7_ = cpropagate;
	vala_ccode_function_call_add_argument (_tmp7_, error_expr);
	_tmp8_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = cpropagate;
	vala_ccode_function_add_expression (_tmp9_, (ValaCCodeExpression*) _tmp10_);
	_tmp11_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
	_tmp12_ = _tmp11_;
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp12_, FALSE, NULL);
	_tmp14_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
	_tmp15_ = _tmp14_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		_tmp16_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_CLASS);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ValaClass* cl = NULL;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaClass* _tmp24_;
		ValaCCodeFunction* _tmp25_;
		ValaCCodeFunction* _tmp26_;
		ValaClass* _tmp27_;
		ValaObjectType* _tmp28_;
		ValaObjectType* _tmp29_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		ValaGLibValue* _tmp32_;
		ValaGLibValue* _tmp33_;
		ValaCCodeExpression* _tmp34_;
		ValaCCodeExpression* _tmp35_;
		ValaCCodeFunction* _tmp36_;
		ValaCCodeFunction* _tmp37_;
		ValaCCodeConstant* _tmp38_;
		ValaCCodeConstant* _tmp39_;
		_tmp20_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp24_;
		_tmp25_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = cl;
		_tmp28_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_ccode_identifier_new ("self");
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_glib_value_new ((ValaDataType*) _tmp29_, (ValaCCodeExpression*) _tmp31_, TRUE);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp33_, FALSE);
		_tmp35_ = _tmp34_;
		vala_ccode_function_add_expression (_tmp26_, _tmp35_);
		_vala_ccode_node_unref0 (_tmp35_);
		_vala_target_value_unref0 (_tmp33_);
		_vala_ccode_node_unref0 (_tmp31_);
		_vala_code_node_unref0 (_tmp29_);
		_tmp36_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_ccode_constant_new ("NULL");
		_tmp39_ = _tmp38_;
		vala_ccode_function_add_return (_tmp37_, (ValaCCodeExpression*) _tmp39_);
		_vala_ccode_node_unref0 (_tmp39_);
		_vala_code_node_unref0 (cl);
	} else {
		if (vala_ccode_base_module_is_in_coroutine ((ValaCCodeBaseModule*) self)) {
			ValaCCodeFunction* _tmp40_;
			ValaCCodeFunction* _tmp41_;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			_tmp40_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_constant_new ("FALSE");
			_tmp43_ = _tmp42_;
			vala_ccode_function_add_return (_tmp41_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
		} else {
			ValaDataType* _tmp44_;
			ValaDataType* _tmp45_;
			_tmp44_ = vala_ccode_base_module_get_current_return_type ((ValaCCodeBaseModule*) self);
			_tmp45_ = _tmp44_;
			vala_ccode_base_module_return_default_value ((ValaCCodeBaseModule*) self, _tmp45_, TRUE);
		}
	}
	_vala_ccode_node_unref0 (cpropagate);
}

void
vala_gerror_module_return_with_exception (ValaGErrorModule* self,
                                          ValaCCodeExpression* error_expr)
{
	g_return_if_fail (self != NULL);
	VALA_GERROR_MODULE_GET_CLASS (self)->return_with_exception (self, error_expr);
}

static void
vala_gerror_module_uncaught_error_statement (ValaGErrorModule* self,
                                             ValaCCodeExpression* inner_error,
                                             gboolean unexpected)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaCCodeFunctionCall* ccritical = NULL;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	const gchar* _tmp6_ = NULL;
	ValaCCodeFunctionCall* _tmp7_;
	ValaCCodeConstant* _tmp8_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	ValaCCodeConstant* _tmp11_;
	ValaCCodeConstant* _tmp12_;
	ValaCCodeFunctionCall* _tmp13_;
	ValaCCodeConstant* _tmp14_;
	ValaCCodeConstant* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeMemberAccess* _tmp17_;
	ValaCCodeMemberAccess* _tmp18_;
	ValaCCodeFunctionCall* domain_name = NULL;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeFunctionCall* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeMemberAccess* _tmp24_;
	ValaCCodeMemberAccess* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeMemberAccess* _tmp29_;
	ValaCCodeMemberAccess* _tmp30_;
	ValaCCodeFunctionCall* cclear = NULL;
	ValaCCodeIdentifier* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeFunctionCall* _tmp33_;
	ValaCCodeFunctionCall* _tmp34_;
	ValaCCodeFunctionCall* _tmp35_;
	ValaCCodeUnaryExpression* _tmp36_;
	ValaCCodeUnaryExpression* _tmp37_;
	ValaCCodeFunction* _tmp38_;
	ValaCCodeFunction* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunction* _tmp41_;
	ValaCCodeFunction* _tmp42_;
	ValaCCodeFunctionCall* _tmp43_;
	gboolean _tmp44_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (inner_error != NULL);
	_tmp0_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp1_, FALSE, NULL);
	_tmp2_ = vala_ccode_identifier_new ("g_critical");
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccritical = _tmp5_;
	if (unexpected) {
		_tmp6_ = "\"file %s: line %d: unexpected error: %s (%s, %d)\"";
	} else {
		_tmp6_ = "\"file %s: line %d: uncaught error: %s (%s, %d)\"";
	}
	_tmp7_ = ccritical;
	_tmp8_ = vala_ccode_constant_new (_tmp6_);
	_tmp9_ = _tmp8_;
	vala_ccode_function_call_add_argument (_tmp7_, (ValaCCodeExpression*) _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = ccritical;
	_tmp11_ = vala_ccode_constant_new ("__FILE__");
	_tmp12_ = _tmp11_;
	vala_ccode_function_call_add_argument (_tmp10_, (ValaCCodeExpression*) _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = ccritical;
	_tmp14_ = vala_ccode_constant_new ("__LINE__");
	_tmp15_ = _tmp14_;
	vala_ccode_function_call_add_argument (_tmp13_, (ValaCCodeExpression*) _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = ccritical;
	_tmp17_ = vala_ccode_member_access_new_pointer (inner_error, "message");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = vala_ccode_identifier_new ("g_quark_to_string");
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp20_);
	_tmp22_ = _tmp21_;
	_vala_ccode_node_unref0 (_tmp20_);
	domain_name = _tmp22_;
	_tmp23_ = domain_name;
	_tmp24_ = vala_ccode_member_access_new_pointer (inner_error, "domain");
	_tmp25_ = _tmp24_;
	vala_ccode_function_call_add_argument (_tmp23_, (ValaCCodeExpression*) _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = ccritical;
	_tmp27_ = domain_name;
	vala_ccode_function_call_add_argument (_tmp26_, (ValaCCodeExpression*) _tmp27_);
	_tmp28_ = ccritical;
	_tmp29_ = vala_ccode_member_access_new_pointer (inner_error, "code");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = vala_ccode_identifier_new ("g_clear_error");
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp32_);
	_tmp34_ = _tmp33_;
	_vala_ccode_node_unref0 (_tmp32_);
	cclear = _tmp34_;
	_tmp35_ = cclear;
	_tmp36_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, inner_error);
	_tmp37_ = _tmp36_;
	vala_ccode_function_call_add_argument (_tmp35_, (ValaCCodeExpression*) _tmp37_);
	_vala_ccode_node_unref0 (_tmp37_);
	_tmp38_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp39_ = _tmp38_;
	_tmp40_ = ccritical;
	vala_ccode_function_add_expression (_tmp39_, (ValaCCodeExpression*) _tmp40_);
	_tmp41_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = cclear;
	vala_ccode_function_add_expression (_tmp42_, (ValaCCodeExpression*) _tmp43_);
	if (vala_ccode_base_module_is_in_constructor ((ValaCCodeBaseModule*) self)) {
		_tmp44_ = TRUE;
	} else {
		_tmp44_ = vala_ccode_base_module_is_in_destructor ((ValaCCodeBaseModule*) self);
	}
	if (_tmp44_) {
	} else {
		ValaMethod* _tmp45_;
		ValaMethod* _tmp46_;
		_tmp45_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp46_ = _tmp45_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp47_;
			ValaMethod* _tmp48_;
			ValaSymbol* _tmp49_;
			ValaSymbol* _tmp50_;
			_tmp47_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp48_);
			_tmp50_ = _tmp49_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, VALA_TYPE_STRUCT)) {
				ValaCCodeFunction* _tmp51_;
				ValaCCodeFunction* _tmp52_;
				_tmp51_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp52_ = _tmp51_;
				vala_ccode_function_add_return (_tmp52_, NULL);
			} else {
				ValaCCodeFunction* _tmp53_;
				ValaCCodeFunction* _tmp54_;
				ValaCCodeConstant* _tmp55_;
				ValaCCodeConstant* _tmp56_;
				_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_ccode_constant_new ("NULL");
				_tmp56_ = _tmp55_;
				vala_ccode_function_add_return (_tmp54_, (ValaCCodeExpression*) _tmp56_);
				_vala_ccode_node_unref0 (_tmp56_);
			}
		} else {
			if (vala_ccode_base_module_is_in_coroutine ((ValaCCodeBaseModule*) self)) {
				ValaCCodeMemberAccess* async_result_expr = NULL;
				ValaCCodeIdentifier* _tmp57_;
				ValaCCodeIdentifier* _tmp58_;
				ValaCCodeMemberAccess* _tmp59_;
				ValaCCodeMemberAccess* _tmp60_;
				ValaCCodeFunctionCall* unref = NULL;
				ValaCCodeIdentifier* _tmp61_;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeFunctionCall* _tmp63_;
				ValaCCodeFunctionCall* _tmp64_;
				ValaCCodeFunctionCall* _tmp65_;
				ValaCCodeMemberAccess* _tmp66_;
				ValaCCodeFunction* _tmp67_;
				ValaCCodeFunction* _tmp68_;
				ValaCCodeFunctionCall* _tmp69_;
				ValaCCodeFunction* _tmp70_;
				ValaCCodeFunction* _tmp71_;
				ValaCCodeConstant* _tmp72_;
				ValaCCodeConstant* _tmp73_;
				_tmp57_ = vala_ccode_identifier_new ("_data_");
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp58_, "_async_result");
				_tmp60_ = _tmp59_;
				_vala_ccode_node_unref0 (_tmp58_);
				async_result_expr = _tmp60_;
				_tmp61_ = vala_ccode_identifier_new ("g_object_unref");
				_tmp62_ = _tmp61_;
				_tmp63_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp62_);
				_tmp64_ = _tmp63_;
				_vala_ccode_node_unref0 (_tmp62_);
				unref = _tmp64_;
				_tmp65_ = unref;
				_tmp66_ = async_result_expr;
				vala_ccode_function_call_add_argument (_tmp65_, (ValaCCodeExpression*) _tmp66_);
				_tmp67_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp68_ = _tmp67_;
				_tmp69_ = unref;
				vala_ccode_function_add_expression (_tmp68_, (ValaCCodeExpression*) _tmp69_);
				_tmp70_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_ccode_constant_new ("FALSE");
				_tmp73_ = _tmp72_;
				vala_ccode_function_add_return (_tmp71_, (ValaCCodeExpression*) _tmp73_);
				_vala_ccode_node_unref0 (_tmp73_);
				_vala_ccode_node_unref0 (unref);
				_vala_ccode_node_unref0 (async_result_expr);
			} else {
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				_tmp74_ = vala_ccode_base_module_get_current_return_type ((ValaCCodeBaseModule*) self);
				_tmp75_ = _tmp74_;
				if (_tmp75_ != NULL) {
					ValaDataType* _tmp76_;
					ValaDataType* _tmp77_;
					_tmp76_ = vala_ccode_base_module_get_current_return_type ((ValaCCodeBaseModule*) self);
					_tmp77_ = _tmp76_;
					vala_ccode_base_module_return_default_value ((ValaCCodeBaseModule*) self, _tmp77_, TRUE);
				}
			}
		}
	}
	_vala_ccode_node_unref0 (cclear);
	_vala_ccode_node_unref0 (domain_name);
	_vala_ccode_node_unref0 (ccritical);
}

static gboolean
vala_gerror_module_in_finally_block (ValaGErrorModule* self,
                                     ValaCodeNode* node)
{
	gboolean result = FALSE;
	ValaCodeNode* current_node = NULL;
	ValaCodeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (node);
	current_node = _tmp0_;
	while (TRUE) {
		ValaCodeNode* _tmp1_;
		ValaTryStatement* try_stmt = NULL;
		ValaCodeNode* _tmp2_;
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaTryStatement* _tmp5_;
		gboolean _tmp6_ = FALSE;
		ValaTryStatement* _tmp7_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		_tmp1_ = current_node;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = current_node;
		_tmp3_ = vala_code_node_get_parent_node (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_TRY_STATEMENT) ? ((ValaTryStatement*) _tmp4_) : NULL);
		try_stmt = _tmp5_;
		_tmp7_ = try_stmt;
		if (_tmp7_ != NULL) {
			ValaTryStatement* _tmp8_;
			ValaBlock* _tmp9_;
			ValaBlock* _tmp10_;
			ValaCodeNode* _tmp11_;
			_tmp8_ = try_stmt;
			_tmp9_ = vala_try_statement_get_finally_body (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = current_node;
			_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp11_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			result = TRUE;
			_vala_code_node_unref0 (try_stmt);
			_vala_code_node_unref0 (current_node);
			return result;
		}
		_tmp12_ = current_node;
		_tmp13_ = vala_code_node_get_parent_node (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _vala_code_node_ref0 (_tmp14_);
		_vala_code_node_unref0 (current_node);
		current_node = _tmp15_;
		_vala_code_node_unref0 (try_stmt);
	}
	result = FALSE;
	_vala_code_node_unref0 (current_node);
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static void
vala_gerror_module_real_add_simple_check (ValaCCodeBaseModule* base,
                                          ValaCodeNode* node,
                                          gboolean always_fails)
{
	ValaGErrorModule * self;
	ValaCCodeExpression* inner_error = NULL;
	ValaCCodeExpression* _tmp0_;
	ValaTryStatement* _tmp15_;
	ValaTryStatement* _tmp16_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (node != NULL);
	vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
	_tmp0_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
	inner_error = _tmp0_;
	if (always_fails) {
	} else {
		ValaCCodeBinaryExpression* ccond = NULL;
		ValaCCodeExpression* _tmp1_;
		ValaCCodeConstant* _tmp2_;
		ValaCCodeConstant* _tmp3_;
		ValaCCodeBinaryExpression* _tmp4_;
		ValaCCodeBinaryExpression* _tmp5_;
		ValaCCodeFunctionCall* unlikely = NULL;
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeFunctionCall* _tmp8_;
		ValaCCodeFunctionCall* _tmp9_;
		ValaCCodeFunctionCall* _tmp10_;
		ValaCCodeBinaryExpression* _tmp11_;
		ValaCCodeFunction* _tmp12_;
		ValaCCodeFunction* _tmp13_;
		ValaCCodeFunctionCall* _tmp14_;
		_tmp1_ = inner_error;
		_tmp2_ = vala_ccode_constant_new ("NULL");
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, _tmp1_, (ValaCCodeExpression*) _tmp3_);
		_tmp5_ = _tmp4_;
		_vala_ccode_node_unref0 (_tmp3_);
		ccond = _tmp5_;
		_tmp6_ = vala_ccode_identifier_new ("G_UNLIKELY");
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		_vala_ccode_node_unref0 (_tmp7_);
		unlikely = _tmp9_;
		_tmp10_ = unlikely;
		_tmp11_ = ccond;
		vala_ccode_function_call_add_argument (_tmp10_, (ValaCCodeExpression*) _tmp11_);
		_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = unlikely;
		vala_ccode_function_open_if (_tmp13_, (ValaCCodeExpression*) _tmp14_);
		_vala_ccode_node_unref0 (unlikely);
		_vala_ccode_node_unref0 (ccond);
	}
	_tmp15_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp25_;
		ValaArrayList* _tmp26_;
		ValaArrayList* _tmp27_;
		gboolean has_general_catch_clause = FALSE;
		if (self->priv->is_in_catch) {
			ValaSymbol* _tmp17_;
			ValaSymbol* _tmp18_;
			ValaCatchClause* _tmp19_;
			ValaCatchClause* _tmp20_;
			_tmp17_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_ccode_base_module_get_current_catch ((ValaCCodeBaseModule*) self);
			_tmp20_ = _tmp19_;
			vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp18_, FALSE, (ValaCodeNode*) _tmp20_);
		} else {
			ValaSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaTryStatement* _tmp23_;
			ValaTryStatement* _tmp24_;
			_tmp21_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
			_tmp24_ = _tmp23_;
			vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp22_, FALSE, (ValaCodeNode*) _tmp24_);
		}
		_tmp25_ = g_direct_equal;
		_tmp26_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp25_);
		error_types = _tmp26_;
		_tmp27_ = error_types;
		vala_code_node_get_error_types (node, (ValaCollection*) _tmp27_, NULL);
		has_general_catch_clause = FALSE;
		if (!self->priv->is_in_catch) {
			ValaArrayList* handled_error_types = NULL;
			GEqualFunc _tmp28_;
			ValaArrayList* _tmp29_;
			_tmp28_ = g_direct_equal;
			_tmp29_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp28_);
			handled_error_types = _tmp29_;
			{
				ValaList* _clause_list = NULL;
				ValaTryStatement* _tmp30_;
				ValaTryStatement* _tmp31_;
				ValaList* _tmp32_;
				gint _clause_size = 0;
				ValaList* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _clause_index = 0;
				_tmp30_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_try_statement_get_catch_clauses (_tmp31_);
				_clause_list = _tmp32_;
				_tmp33_ = _clause_list;
				_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				_clause_size = _tmp35_;
				_clause_index = -1;
				while (TRUE) {
					ValaCatchClause* clause = NULL;
					ValaList* _tmp36_;
					gpointer _tmp37_;
					ValaArrayList* _tmp64_;
					ValaCatchClause* _tmp65_;
					ValaDataType* _tmp66_;
					ValaDataType* _tmp67_;
					ValaErrorType* _tmp68_;
					_clause_index = _clause_index + 1;
					if (!(_clause_index < _clause_size)) {
						break;
					}
					_tmp36_ = _clause_list;
					_tmp37_ = vala_list_get (_tmp36_, _clause_index);
					clause = (ValaCatchClause*) _tmp37_;
					{
						ValaArrayList* _node_error_type_list = NULL;
						ValaArrayList* _tmp38_;
						ValaArrayList* _tmp39_;
						gint _node_error_type_size = 0;
						ValaArrayList* _tmp40_;
						gint _tmp41_;
						gint _tmp42_;
						gint _node_error_type_index = 0;
						_tmp38_ = error_types;
						_tmp39_ = _vala_iterable_ref0 (_tmp38_);
						_node_error_type_list = _tmp39_;
						_tmp40_ = _node_error_type_list;
						_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
						_tmp42_ = _tmp41_;
						_node_error_type_size = _tmp42_;
						_node_error_type_index = -1;
						while (TRUE) {
							ValaDataType* node_error_type = NULL;
							ValaArrayList* _tmp43_;
							gpointer _tmp44_;
							gboolean _tmp45_ = FALSE;
							ValaCatchClause* _tmp46_;
							ValaDataType* _tmp47_;
							ValaDataType* _tmp48_;
							_node_error_type_index = _node_error_type_index + 1;
							if (!(_node_error_type_index < _node_error_type_size)) {
								break;
							}
							_tmp43_ = _node_error_type_list;
							_tmp44_ = vala_list_get ((ValaList*) _tmp43_, _node_error_type_index);
							node_error_type = (ValaDataType*) _tmp44_;
							_tmp46_ = clause;
							_tmp47_ = vala_catch_clause_get_error_type (_tmp46_);
							_tmp48_ = _tmp47_;
							if (_tmp48_ == NULL) {
								_tmp45_ = TRUE;
							} else {
								ValaDataType* _tmp49_;
								ValaCatchClause* _tmp50_;
								ValaDataType* _tmp51_;
								ValaDataType* _tmp52_;
								_tmp49_ = node_error_type;
								_tmp50_ = clause;
								_tmp51_ = vala_catch_clause_get_error_type (_tmp50_);
								_tmp52_ = _tmp51_;
								_tmp45_ = vala_data_type_compatible (_tmp49_, _tmp52_);
							}
							if (_tmp45_) {
								ValaArrayList* _tmp53_;
								ValaDataType* _tmp54_;
								_tmp53_ = handled_error_types;
								_tmp54_ = node_error_type;
								vala_collection_add ((ValaCollection*) _tmp53_, _tmp54_);
							}
							_vala_code_node_unref0 (node_error_type);
						}
						_vala_iterable_unref0 (_node_error_type_list);
					}
					{
						ValaArrayList* _handled_error_type_list = NULL;
						ValaArrayList* _tmp55_;
						ValaArrayList* _tmp56_;
						gint _handled_error_type_size = 0;
						ValaArrayList* _tmp57_;
						gint _tmp58_;
						gint _tmp59_;
						gint _handled_error_type_index = 0;
						_tmp55_ = handled_error_types;
						_tmp56_ = _vala_iterable_ref0 (_tmp55_);
						_handled_error_type_list = _tmp56_;
						_tmp57_ = _handled_error_type_list;
						_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
						_tmp59_ = _tmp58_;
						_handled_error_type_size = _tmp59_;
						_handled_error_type_index = -1;
						while (TRUE) {
							ValaDataType* handled_error_type = NULL;
							ValaArrayList* _tmp60_;
							gpointer _tmp61_;
							ValaArrayList* _tmp62_;
							ValaDataType* _tmp63_;
							_handled_error_type_index = _handled_error_type_index + 1;
							if (!(_handled_error_type_index < _handled_error_type_size)) {
								break;
							}
							_tmp60_ = _handled_error_type_list;
							_tmp61_ = vala_list_get ((ValaList*) _tmp60_, _handled_error_type_index);
							handled_error_type = (ValaDataType*) _tmp61_;
							_tmp62_ = error_types;
							_tmp63_ = handled_error_type;
							vala_collection_remove ((ValaCollection*) _tmp62_, _tmp63_);
							_vala_code_node_unref0 (handled_error_type);
						}
						_vala_iterable_unref0 (_handled_error_type_list);
					}
					_tmp64_ = handled_error_types;
					vala_collection_clear ((ValaCollection*) _tmp64_);
					_tmp65_ = clause;
					_tmp66_ = vala_catch_clause_get_error_type (_tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = ((ValaCCodeBaseModule*) self)->gerror_type;
					if (vala_data_type_equals (_tmp67_, (ValaDataType*) _tmp68_)) {
						ValaCCodeFunction* _tmp69_;
						ValaCCodeFunction* _tmp70_;
						ValaCatchClause* _tmp71_;
						const gchar* _tmp72_;
						const gchar* _tmp73_;
						has_general_catch_clause = TRUE;
						_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp70_ = _tmp69_;
						_tmp71_ = clause;
						_tmp72_ = vala_catch_clause_get_clabel_name (_tmp71_);
						_tmp73_ = _tmp72_;
						vala_ccode_function_add_goto (_tmp70_, _tmp73_);
						_vala_code_node_unref0 (clause);
						break;
					} else {
						ValaErrorType* catch_type = NULL;
						ValaCatchClause* _tmp74_;
						ValaDataType* _tmp75_;
						ValaDataType* _tmp76_;
						ValaErrorType* _tmp77_;
						ValaErrorType* _tmp78_;
						ValaErrorCode* _tmp79_;
						ValaErrorCode* _tmp80_;
						ValaCCodeFunction* _tmp123_;
						ValaCCodeFunction* _tmp124_;
						ValaCatchClause* _tmp125_;
						const gchar* _tmp126_;
						const gchar* _tmp127_;
						ValaCCodeFunction* _tmp128_;
						ValaCCodeFunction* _tmp129_;
						_tmp74_ = clause;
						_tmp75_ = vala_catch_clause_get_error_type (_tmp74_);
						_tmp76_ = _tmp75_;
						_tmp77_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, VALA_TYPE_ERROR_TYPE) ? ((ValaErrorType*) _tmp76_) : NULL);
						catch_type = _tmp77_;
						_tmp78_ = catch_type;
						_tmp79_ = vala_error_type_get_error_code (_tmp78_);
						_tmp80_ = _tmp79_;
						if (_tmp80_ != NULL) {
							ValaCCodeFunctionCall* error_match = NULL;
							ValaCCodeIdentifier* _tmp81_;
							ValaCCodeIdentifier* _tmp82_;
							ValaCCodeFunctionCall* _tmp83_;
							ValaCCodeFunctionCall* _tmp84_;
							ValaCCodeFunctionCall* _tmp85_;
							ValaCCodeExpression* _tmp86_;
							ValaCCodeFunctionCall* _tmp87_;
							ValaErrorType* _tmp88_;
							ValaTypeSymbol* _tmp89_;
							ValaTypeSymbol* _tmp90_;
							gchar* _tmp91_;
							gchar* _tmp92_;
							ValaCCodeIdentifier* _tmp93_;
							ValaCCodeIdentifier* _tmp94_;
							ValaCCodeFunctionCall* _tmp95_;
							ValaErrorType* _tmp96_;
							ValaErrorCode* _tmp97_;
							ValaErrorCode* _tmp98_;
							gchar* _tmp99_;
							gchar* _tmp100_;
							ValaCCodeIdentifier* _tmp101_;
							ValaCCodeIdentifier* _tmp102_;
							ValaCCodeFunction* _tmp103_;
							ValaCCodeFunction* _tmp104_;
							ValaCCodeFunctionCall* _tmp105_;
							_tmp81_ = vala_ccode_identifier_new ("g_error_matches");
							_tmp82_ = _tmp81_;
							_tmp83_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp82_);
							_tmp84_ = _tmp83_;
							_vala_ccode_node_unref0 (_tmp82_);
							error_match = _tmp84_;
							_tmp85_ = error_match;
							_tmp86_ = inner_error;
							vala_ccode_function_call_add_argument (_tmp85_, _tmp86_);
							_tmp87_ = error_match;
							_tmp88_ = catch_type;
							_tmp89_ = vala_data_type_get_data_type ((ValaDataType*) _tmp88_);
							_tmp90_ = _tmp89_;
							_tmp91_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp90_, NULL);
							_tmp92_ = _tmp91_;
							_tmp93_ = vala_ccode_identifier_new (_tmp92_);
							_tmp94_ = _tmp93_;
							vala_ccode_function_call_add_argument (_tmp87_, (ValaCCodeExpression*) _tmp94_);
							_vala_ccode_node_unref0 (_tmp94_);
							_g_free0 (_tmp92_);
							_tmp95_ = error_match;
							_tmp96_ = catch_type;
							_tmp97_ = vala_error_type_get_error_code (_tmp96_);
							_tmp98_ = _tmp97_;
							_tmp99_ = vala_get_ccode_name ((ValaCodeNode*) _tmp98_);
							_tmp100_ = _tmp99_;
							_tmp101_ = vala_ccode_identifier_new (_tmp100_);
							_tmp102_ = _tmp101_;
							vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp102_);
							_vala_ccode_node_unref0 (_tmp102_);
							_g_free0 (_tmp100_);
							_tmp103_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp104_ = _tmp103_;
							_tmp105_ = error_match;
							vala_ccode_function_open_if (_tmp104_, (ValaCCodeExpression*) _tmp105_);
							_vala_ccode_node_unref0 (error_match);
						} else {
							ValaCCodeBinaryExpression* ccond = NULL;
							ValaCCodeExpression* _tmp106_;
							ValaCCodeMemberAccess* _tmp107_;
							ValaCCodeMemberAccess* _tmp108_;
							ValaCatchClause* _tmp109_;
							ValaDataType* _tmp110_;
							ValaDataType* _tmp111_;
							ValaTypeSymbol* _tmp112_;
							ValaTypeSymbol* _tmp113_;
							gchar* _tmp114_;
							gchar* _tmp115_;
							ValaCCodeIdentifier* _tmp116_;
							ValaCCodeIdentifier* _tmp117_;
							ValaCCodeBinaryExpression* _tmp118_;
							ValaCCodeBinaryExpression* _tmp119_;
							ValaCCodeFunction* _tmp120_;
							ValaCCodeFunction* _tmp121_;
							ValaCCodeBinaryExpression* _tmp122_;
							_tmp106_ = inner_error;
							_tmp107_ = vala_ccode_member_access_new_pointer (_tmp106_, "domain");
							_tmp108_ = _tmp107_;
							_tmp109_ = clause;
							_tmp110_ = vala_catch_clause_get_error_type (_tmp109_);
							_tmp111_ = _tmp110_;
							_tmp112_ = vala_data_type_get_data_type (_tmp111_);
							_tmp113_ = _tmp112_;
							_tmp114_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp113_, NULL);
							_tmp115_ = _tmp114_;
							_tmp116_ = vala_ccode_identifier_new (_tmp115_);
							_tmp117_ = _tmp116_;
							_tmp118_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp108_, (ValaCCodeExpression*) _tmp117_);
							_tmp119_ = _tmp118_;
							_vala_ccode_node_unref0 (_tmp117_);
							_g_free0 (_tmp115_);
							_vala_ccode_node_unref0 (_tmp108_);
							ccond = _tmp119_;
							_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp121_ = _tmp120_;
							_tmp122_ = ccond;
							vala_ccode_function_open_if (_tmp121_, (ValaCCodeExpression*) _tmp122_);
							_vala_ccode_node_unref0 (ccond);
						}
						_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp124_ = _tmp123_;
						_tmp125_ = clause;
						_tmp126_ = vala_catch_clause_get_clabel_name (_tmp125_);
						_tmp127_ = _tmp126_;
						vala_ccode_function_add_goto (_tmp124_, _tmp127_);
						_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp129_ = _tmp128_;
						vala_ccode_function_close (_tmp129_);
						_vala_code_node_unref0 (catch_type);
					}
					_vala_code_node_unref0 (clause);
				}
				_vala_iterable_unref0 (_clause_list);
			}
			_vala_iterable_unref0 (handled_error_types);
		}
		if (has_general_catch_clause) {
		} else {
			ValaArrayList* _tmp130_;
			gint _tmp131_;
			gint _tmp132_;
			_tmp130_ = error_types;
			_tmp131_ = vala_collection_get_size ((ValaCollection*) _tmp130_);
			_tmp132_ = _tmp131_;
			if (_tmp132_ > 0) {
				ValaCCodeFunction* _tmp133_;
				ValaCCodeFunction* _tmp134_;
				gchar* _tmp135_;
				gchar* _tmp136_;
				_tmp133_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp134_ = _tmp133_;
				_tmp135_ = g_strdup_printf ("__finally%d", self->priv->current_try_id);
				_tmp136_ = _tmp135_;
				vala_ccode_function_add_goto (_tmp134_, _tmp136_);
				_g_free0 (_tmp136_);
			} else {
				if (vala_gerror_module_in_finally_block (self, node)) {
				} else {
					ValaCCodeExpression* _tmp137_;
					_tmp137_ = inner_error;
					vala_gerror_module_uncaught_error_statement (self, _tmp137_, TRUE);
				}
			}
		}
		_vala_iterable_unref0 (error_types);
	} else {
		gboolean _tmp138_ = FALSE;
		ValaMethod* _tmp139_;
		ValaMethod* _tmp140_;
		_tmp139_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp140_ = _tmp139_;
		if (_tmp140_ != NULL) {
			ValaMethod* _tmp141_;
			ValaMethod* _tmp142_;
			gboolean _tmp143_;
			gboolean _tmp144_;
			_tmp141_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp142_);
			_tmp144_ = _tmp143_;
			_tmp138_ = _tmp144_;
		} else {
			_tmp138_ = FALSE;
		}
		if (_tmp138_) {
			ValaCCodeBinaryExpression* ccond = NULL;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp145_;
			ValaArrayList* _tmp146_;
			ValaMethod* _tmp147_;
			ValaMethod* _tmp148_;
			ValaArrayList* _tmp149_;
			ValaCCodeBinaryExpression* _tmp177_;
			ccond = NULL;
			_tmp145_ = g_direct_equal;
			_tmp146_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp145_);
			error_types = _tmp146_;
			_tmp147_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp148_ = _tmp147_;
			_tmp149_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp148_, (ValaCollection*) _tmp149_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp150_;
				ValaArrayList* _tmp151_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp152_;
				gint _tmp153_;
				gint _tmp154_;
				gint _error_type_index = 0;
				_tmp150_ = error_types;
				_tmp151_ = _vala_iterable_ref0 (_tmp150_);
				_error_type_list = _tmp151_;
				_tmp152_ = _error_type_list;
				_tmp153_ = vala_collection_get_size ((ValaCollection*) _tmp152_);
				_tmp154_ = _tmp153_;
				_error_type_size = _tmp154_;
				_error_type_index = -1;
				while (TRUE) {
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp155_;
					gpointer _tmp156_;
					ValaDataType* _tmp157_;
					ValaErrorType* _tmp158_;
					ValaCCodeBinaryExpression* domain_check = NULL;
					ValaCCodeExpression* _tmp159_;
					ValaCCodeMemberAccess* _tmp160_;
					ValaCCodeMemberAccess* _tmp161_;
					ValaDataType* _tmp162_;
					ValaTypeSymbol* _tmp163_;
					ValaTypeSymbol* _tmp164_;
					gchar* _tmp165_;
					gchar* _tmp166_;
					ValaCCodeIdentifier* _tmp167_;
					ValaCCodeIdentifier* _tmp168_;
					ValaCCodeBinaryExpression* _tmp169_;
					ValaCCodeBinaryExpression* _tmp170_;
					ValaCCodeBinaryExpression* _tmp171_;
					_error_type_index = _error_type_index + 1;
					if (!(_error_type_index < _error_type_size)) {
						break;
					}
					_tmp155_ = _error_type_list;
					_tmp156_ = vala_list_get ((ValaList*) _tmp155_, _error_type_index);
					error_type = (ValaDataType*) _tmp156_;
					_tmp157_ = error_type;
					_tmp158_ = ((ValaCCodeBaseModule*) self)->gerror_type;
					if (vala_data_type_equals (_tmp157_, (ValaDataType*) _tmp158_)) {
						_vala_ccode_node_unref0 (ccond);
						ccond = NULL;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp159_ = inner_error;
					_tmp160_ = vala_ccode_member_access_new_pointer (_tmp159_, "domain");
					_tmp161_ = _tmp160_;
					_tmp162_ = error_type;
					_tmp163_ = vala_data_type_get_data_type (_tmp162_);
					_tmp164_ = _tmp163_;
					_tmp165_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp164_, NULL);
					_tmp166_ = _tmp165_;
					_tmp167_ = vala_ccode_identifier_new (_tmp166_);
					_tmp168_ = _tmp167_;
					_tmp169_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp161_, (ValaCCodeExpression*) _tmp168_);
					_tmp170_ = _tmp169_;
					_vala_ccode_node_unref0 (_tmp168_);
					_g_free0 (_tmp166_);
					_vala_ccode_node_unref0 (_tmp161_);
					domain_check = _tmp170_;
					_tmp171_ = ccond;
					if (_tmp171_ == NULL) {
						ValaCCodeBinaryExpression* _tmp172_;
						ValaCCodeBinaryExpression* _tmp173_;
						_tmp172_ = domain_check;
						_tmp173_ = _vala_ccode_node_ref0 (_tmp172_);
						_vala_ccode_node_unref0 (ccond);
						ccond = _tmp173_;
					} else {
						ValaCCodeBinaryExpression* _tmp174_;
						ValaCCodeBinaryExpression* _tmp175_;
						ValaCCodeBinaryExpression* _tmp176_;
						_tmp174_ = ccond;
						_tmp175_ = domain_check;
						_tmp176_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) _tmp174_, (ValaCCodeExpression*) _tmp175_);
						_vala_ccode_node_unref0 (ccond);
						ccond = _tmp176_;
					}
					_vala_ccode_node_unref0 (domain_check);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			_tmp177_ = ccond;
			if (_tmp177_ != NULL) {
				ValaCCodeFunction* _tmp178_;
				ValaCCodeFunction* _tmp179_;
				ValaCCodeBinaryExpression* _tmp180_;
				ValaCCodeExpression* _tmp181_;
				ValaCCodeFunction* _tmp182_;
				ValaCCodeFunction* _tmp183_;
				ValaCCodeExpression* _tmp184_;
				ValaCCodeFunction* _tmp185_;
				ValaCCodeFunction* _tmp186_;
				_tmp178_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp179_ = _tmp178_;
				_tmp180_ = ccond;
				vala_ccode_function_open_if (_tmp179_, (ValaCCodeExpression*) _tmp180_);
				_tmp181_ = inner_error;
				vala_gerror_module_return_with_exception (self, _tmp181_);
				_tmp182_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp183_ = _tmp182_;
				vala_ccode_function_add_else (_tmp183_);
				_tmp184_ = inner_error;
				vala_gerror_module_uncaught_error_statement (self, _tmp184_, FALSE);
				_tmp185_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp186_ = _tmp185_;
				vala_ccode_function_close (_tmp186_);
			} else {
				ValaCCodeExpression* _tmp187_;
				_tmp187_ = inner_error;
				vala_gerror_module_return_with_exception (self, _tmp187_);
			}
			_vala_iterable_unref0 (error_types);
			_vala_ccode_node_unref0 (ccond);
		} else {
			ValaCCodeExpression* _tmp188_;
			_tmp188_ = inner_error;
			vala_gerror_module_uncaught_error_statement (self, _tmp188_, FALSE);
		}
	}
	if (!always_fails) {
		ValaCCodeFunction* _tmp189_;
		ValaCCodeFunction* _tmp190_;
		_tmp189_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp190_ = _tmp189_;
		vala_ccode_function_close (_tmp190_);
	}
	_vala_ccode_node_unref0 (inner_error);
}

static void
vala_gerror_module_real_visit_try_statement (ValaCodeVisitor* base,
                                             ValaTryStatement* stmt)
{
	ValaGErrorModule * self;
	gint this_try_id = 0;
	gint _tmp0_;
	ValaTryStatement* old_try = NULL;
	ValaTryStatement* _tmp1_;
	ValaTryStatement* _tmp2_;
	ValaTryStatement* _tmp3_;
	gint old_try_id = 0;
	gboolean old_is_in_catch = FALSE;
	ValaCatchClause* old_catch = NULL;
	ValaCatchClause* _tmp4_;
	ValaCatchClause* _tmp5_;
	ValaCatchClause* _tmp6_;
	ValaBlock* _tmp21_;
	ValaBlock* _tmp22_;
	ValaTryStatement* _tmp35_;
	ValaCatchClause* _tmp36_;
	ValaCCodeFunction* _tmp37_;
	ValaCCodeFunction* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	ValaBlock* _tmp41_;
	ValaBlock* _tmp42_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = self->priv->next_try_id;
	self->priv->next_try_id = _tmp0_ + 1;
	this_try_id = _tmp0_;
	_tmp1_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	old_try = _tmp3_;
	old_try_id = self->priv->current_try_id;
	old_is_in_catch = self->priv->is_in_catch;
	_tmp4_ = vala_ccode_base_module_get_current_catch ((ValaCCodeBaseModule*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (_tmp5_);
	old_catch = _tmp6_;
	vala_ccode_base_module_set_current_try ((ValaCCodeBaseModule*) self, stmt);
	self->priv->current_try_id = this_try_id;
	self->priv->is_in_catch = TRUE;
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp7_;
		gint _clause_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _clause_index = 0;
		_tmp7_ = vala_try_statement_get_catch_clauses (stmt);
		_clause_list = _tmp7_;
		_tmp8_ = _clause_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_clause_size = _tmp10_;
		_clause_index = -1;
		while (TRUE) {
			ValaCatchClause* clause = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaCatchClause* _tmp13_;
			ValaCatchClause* _tmp14_;
			ValaDataType* _tmp15_;
			ValaDataType* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_clause_index = _clause_index + 1;
			if (!(_clause_index < _clause_size)) {
				break;
			}
			_tmp11_ = _clause_list;
			_tmp12_ = vala_list_get (_tmp11_, _clause_index);
			clause = (ValaCatchClause*) _tmp12_;
			_tmp13_ = clause;
			_tmp14_ = clause;
			_tmp15_ = vala_catch_clause_get_error_type (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf ("__catch%d_%s", this_try_id, _tmp18_);
			_tmp20_ = _tmp19_;
			vala_catch_clause_set_clabel_name (_tmp13_, _tmp20_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	self->priv->is_in_catch = FALSE;
	_tmp21_ = vala_try_statement_get_body (stmt);
	_tmp22_ = _tmp21_;
	vala_code_node_emit ((ValaCodeNode*) _tmp22_, (ValaCodeGenerator*) self);
	self->priv->is_in_catch = TRUE;
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp23_;
		gint _clause_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _clause_index = 0;
		_tmp23_ = vala_try_statement_get_catch_clauses (stmt);
		_clause_list = _tmp23_;
		_tmp24_ = _clause_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_clause_size = _tmp26_;
		_clause_index = -1;
		while (TRUE) {
			ValaCatchClause* clause = NULL;
			ValaList* _tmp27_;
			gpointer _tmp28_;
			ValaCatchClause* _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunction* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			ValaCatchClause* _tmp34_;
			_clause_index = _clause_index + 1;
			if (!(_clause_index < _clause_size)) {
				break;
			}
			_tmp27_ = _clause_list;
			_tmp28_ = vala_list_get (_tmp27_, _clause_index);
			clause = (ValaCatchClause*) _tmp28_;
			_tmp29_ = clause;
			vala_ccode_base_module_set_current_catch ((ValaCCodeBaseModule*) self, _tmp29_);
			_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strdup_printf ("__finally%d", this_try_id);
			_tmp33_ = _tmp32_;
			vala_ccode_function_add_goto (_tmp31_, _tmp33_);
			_g_free0 (_tmp33_);
			_tmp34_ = clause;
			vala_code_node_emit ((ValaCodeNode*) _tmp34_, (ValaCodeGenerator*) self);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	_tmp35_ = old_try;
	vala_ccode_base_module_set_current_try ((ValaCCodeBaseModule*) self, _tmp35_);
	self->priv->current_try_id = old_try_id;
	self->priv->is_in_catch = old_is_in_catch;
	_tmp36_ = old_catch;
	vala_ccode_base_module_set_current_catch ((ValaCCodeBaseModule*) self, _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_strdup_printf ("__finally%d", this_try_id);
	_tmp40_ = _tmp39_;
	vala_ccode_function_add_label (_tmp38_, _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = vala_try_statement_get_finally_body (stmt);
	_tmp42_ = _tmp41_;
	if (_tmp42_ != NULL) {
		ValaBlock* _tmp43_;
		ValaBlock* _tmp44_;
		_tmp43_ = vala_try_statement_get_finally_body (stmt);
		_tmp44_ = _tmp43_;
		vala_code_node_emit ((ValaCodeNode*) _tmp44_, (ValaCodeGenerator*) self);
	}
	_tmp45_ = vala_try_statement_get_after_try_block_reachable (stmt);
	_tmp46_ = _tmp45_;
	vala_ccode_base_module_add_simple_check ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, !_tmp46_);
	_vala_code_node_unref0 (old_catch);
	_vala_code_node_unref0 (old_try);
}

static void
vala_gerror_module_real_visit_catch_clause (ValaCodeVisitor* base,
                                            ValaCatchClause* clause)
{
	ValaGErrorModule * self;
	ValaErrorType* error_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaErrorType* _tmp2_;
	ValaErrorType* _tmp3_;
	ValaErrorDomain* _tmp4_;
	ValaErrorDomain* _tmp5_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaLocalVariable* _tmp16_;
	ValaLocalVariable* _tmp17_;
	ValaCCodeFunction* _tmp42_;
	ValaCCodeFunction* _tmp43_;
	ValaCCodeExpression* _tmp44_;
	ValaCCodeExpression* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaBlock* _tmp48_;
	ValaBlock* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (clause != NULL);
	vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
	_tmp0_ = vala_catch_clause_get_error_type (clause);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
	error_type = _tmp2_;
	_tmp3_ = error_type;
	_tmp4_ = vala_error_type_get_error_domain (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaErrorType* _tmp6_;
		ValaErrorDomain* _tmp7_;
		ValaErrorDomain* _tmp8_;
		ValaCCodeFile* _tmp9_;
		_tmp6_ = error_type;
		_tmp7_ = vala_error_type_get_error_domain (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, _tmp8_, _tmp9_);
	}
	_tmp10_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_catch_clause_get_clabel_name (clause);
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_label (_tmp11_, _tmp13_);
	_tmp14_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp15_ = _tmp14_;
	vala_ccode_function_open_block (_tmp15_);
	_tmp16_ = vala_catch_clause_get_error_variable (clause);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaLocalVariable* _tmp18_;
		ValaLocalVariable* _tmp19_;
		ValaCCodeFunction* _tmp20_;
		ValaCCodeFunction* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		ValaCCodeExpression* _tmp26_;
		ValaCCodeExpression* _tmp27_;
		ValaCCodeExpression* _tmp28_;
		ValaCCodeExpression* _tmp29_;
		_tmp18_ = vala_catch_clause_get_error_variable (clause);
		_tmp19_ = _tmp18_;
		vala_code_visitor_visit_local_variable ((ValaCodeVisitor*) self, _tmp19_);
		_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_catch_clause_get_error_variable (clause);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_ccode_base_module_get_local_cname ((ValaCCodeBaseModule*) self, _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
		_tmp29_ = _tmp28_;
		vala_ccode_function_add_assignment (_tmp21_, _tmp27_, _tmp29_);
		_vala_ccode_node_unref0 (_tmp29_);
		_vala_ccode_node_unref0 (_tmp27_);
		_g_free0 (_tmp25_);
	} else {
		ValaCCodeFunctionCall* cclear = NULL;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		ValaCCodeFunctionCall* _tmp32_;
		ValaCCodeFunctionCall* _tmp33_;
		ValaCCodeFunctionCall* _tmp34_;
		ValaCCodeExpression* _tmp35_;
		ValaCCodeExpression* _tmp36_;
		ValaCCodeUnaryExpression* _tmp37_;
		ValaCCodeUnaryExpression* _tmp38_;
		ValaCCodeFunction* _tmp39_;
		ValaCCodeFunction* _tmp40_;
		ValaCCodeFunctionCall* _tmp41_;
		_tmp30_ = vala_ccode_identifier_new ("g_clear_error");
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp31_);
		_tmp33_ = _tmp32_;
		_vala_ccode_node_unref0 (_tmp31_);
		cclear = _tmp33_;
		_tmp34_ = cclear;
		_tmp35_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp36_);
		_tmp38_ = _tmp37_;
		vala_ccode_function_call_add_argument (_tmp34_, (ValaCCodeExpression*) _tmp38_);
		_vala_ccode_node_unref0 (_tmp38_);
		_vala_ccode_node_unref0 (_tmp36_);
		_tmp39_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = cclear;
		vala_ccode_function_add_expression (_tmp40_, (ValaCCodeExpression*) _tmp41_);
		_vala_ccode_node_unref0 (cclear);
	}
	_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_ccode_constant_new ("NULL");
	_tmp47_ = _tmp46_;
	vala_ccode_function_add_assignment (_tmp43_, _tmp45_, (ValaCCodeExpression*) _tmp47_);
	_vala_ccode_node_unref0 (_tmp47_);
	_vala_ccode_node_unref0 (_tmp45_);
	_tmp48_ = vala_catch_clause_get_body (clause);
	_tmp49_ = _tmp48_;
	vala_code_node_emit ((ValaCodeNode*) _tmp49_, (ValaCodeGenerator*) self);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	vala_ccode_function_close (_tmp51_);
	_vala_code_node_unref0 (error_type);
}

static void
vala_gerror_module_real_append_scope_free (ValaCCodeBaseModule* base,
                                           ValaSymbol* sym,
                                           ValaCodeNode* stop_at)
{
	ValaGErrorModule * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (sym != NULL);
	VALA_CCODE_BASE_MODULE_CLASS (vala_gerror_module_parent_class)->append_scope_free ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule), sym, stop_at);
	if (G_TYPE_CHECK_INSTANCE_TYPE (stop_at, VALA_TYPE_TRY_STATEMENT)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (stop_at, VALA_TYPE_CATCH_CLAUSE);
	}
	if (!_tmp0_) {
		ValaBlock* finally_block = NULL;
		ValaBlock* _tmp1_;
		ValaCodeNode* _tmp2_;
		ValaCodeNode* _tmp3_;
		gboolean _tmp18_ = FALSE;
		ValaBlock* _tmp19_;
		_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (NULL, VALA_TYPE_BLOCK, ValaBlock));
		finally_block = _tmp1_;
		_tmp2_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
		_tmp3_ = _tmp2_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_TRY_STATEMENT)) {
			ValaCodeNode* _tmp4_;
			ValaCodeNode* _tmp5_;
			ValaBlock* _tmp6_;
			ValaBlock* _tmp7_;
			ValaBlock* _tmp8_;
			_tmp4_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_try_statement_get_finally_body (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_TRY_STATEMENT, ValaTryStatement));
			_tmp7_ = _tmp6_;
			_tmp8_ = _vala_code_node_ref0 (_tmp7_);
			_vala_code_node_unref0 (finally_block);
			finally_block = _tmp8_;
		} else {
			ValaCodeNode* _tmp9_;
			ValaCodeNode* _tmp10_;
			_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
			_tmp10_ = _tmp9_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_CATCH_CLAUSE)) {
				ValaCodeNode* _tmp11_;
				ValaCodeNode* _tmp12_;
				ValaCodeNode* _tmp13_;
				ValaCodeNode* _tmp14_;
				ValaBlock* _tmp15_;
				ValaBlock* _tmp16_;
				ValaBlock* _tmp17_;
				_tmp11_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
				_tmp12_ = _tmp11_;
				_tmp13_ = vala_code_node_get_parent_node (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = vala_try_statement_get_finally_body (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_TRY_STATEMENT, ValaTryStatement));
				_tmp16_ = _tmp15_;
				_tmp17_ = _vala_code_node_ref0 (_tmp16_);
				_vala_code_node_unref0 (finally_block);
				finally_block = _tmp17_;
			}
		}
		_tmp19_ = finally_block;
		if (_tmp19_ != NULL) {
			ValaBlock* _tmp20_;
			_tmp20_ = finally_block;
			_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_SYMBOL, ValaSymbol) != sym;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaBlock* _tmp21_;
			_tmp21_ = finally_block;
			vala_code_node_emit ((ValaCodeNode*) _tmp21_, (ValaCodeGenerator*) self);
		}
		_vala_code_node_unref0 (finally_block);
	}
}

ValaGErrorModule*
vala_gerror_module_construct (GType object_type)
{
	ValaGErrorModule* self = NULL;
	self = (ValaGErrorModule*) vala_ccode_delegate_module_construct (object_type);
	return self;
}

ValaGErrorModule*
vala_gerror_module_new (void)
{
	return vala_gerror_module_construct (VALA_TYPE_GERROR_MODULE);
}

static void
vala_gerror_module_class_init (ValaGErrorModuleClass * klass,
                               gpointer klass_data)
{
	vala_gerror_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gerror_module_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGErrorModule_private_offset);
	((ValaCCodeBaseModuleClass *) klass)->generate_error_domain_declaration = (void (*) (ValaCCodeBaseModule*, ValaErrorDomain*, ValaCCodeFile*)) vala_gerror_module_real_generate_error_domain_declaration;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_gerror_module_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor*, ValaThrowStatement*)) vala_gerror_module_real_visit_throw_statement;
	((ValaGErrorModuleClass *) klass)->return_with_exception = (void (*) (ValaGErrorModule*, ValaCCodeExpression*)) vala_gerror_module_real_return_with_exception;
	((ValaCCodeBaseModuleClass *) klass)->add_simple_check = (void (*) (ValaCCodeBaseModule*, ValaCodeNode*, gboolean)) vala_gerror_module_real_add_simple_check;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor*, ValaTryStatement*)) vala_gerror_module_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_catch_clause = (void (*) (ValaCodeVisitor*, ValaCatchClause*)) vala_gerror_module_real_visit_catch_clause;
	((ValaCCodeBaseModuleClass *) klass)->append_scope_free = (void (*) (ValaCCodeBaseModule*, ValaSymbol*, ValaCodeNode*)) vala_gerror_module_real_append_scope_free;
}

static void
vala_gerror_module_instance_init (ValaGErrorModule * self,
                                  gpointer klass)
{
	self->priv = vala_gerror_module_get_instance_private (self);
	self->priv->current_try_id = 0;
	self->priv->next_try_id = 0;
	self->priv->is_in_catch = FALSE;
}

static void
vala_gerror_module_finalize (ValaCodeVisitor * obj)
{
	ValaGErrorModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GERROR_MODULE, ValaGErrorModule);
	VALA_CODE_VISITOR_CLASS (vala_gerror_module_parent_class)->finalize (obj);
}

GType
vala_gerror_module_get_type (void)
{
	static volatile gsize vala_gerror_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gerror_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGErrorModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gerror_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGErrorModule), 0, (GInstanceInitFunc) vala_gerror_module_instance_init, NULL };
		GType vala_gerror_module_type_id;
		vala_gerror_module_type_id = g_type_register_static (VALA_TYPE_CCODE_DELEGATE_MODULE, "ValaGErrorModule", &g_define_type_info, 0);
		ValaGErrorModule_private_offset = g_type_add_instance_private (vala_gerror_module_type_id, sizeof (ValaGErrorModulePrivate));
		g_once_init_leave (&vala_gerror_module_type_id__volatile, vala_gerror_module_type_id);
	}
	return vala_gerror_module_type_id__volatile;
}

