// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

extern crate gdk_pixbuf_sys;
extern crate shell_words;
extern crate tempdir;
use std::env;
use std::error::Error;
use std::path::Path;
use std::mem::{align_of, size_of};
use std::process::Command;
use std::str;
use gdk_pixbuf_sys::*;

static PACKAGES: &[&str] = &["gdk-pixbuf-2.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Compiler, Box<Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Compiler { args })
    }

    pub fn define<'a, V: Into<Option<&'a str>>>(&mut self, var: &str, val: V) {
        let arg = match val.into() {
            None => format!("-D{}", var),
            Some(val) => format!("-D{}={}", var, val),
        };
        self.args.push(arg);
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}",
                               &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let mut cmd = Command::new("pkg-config");
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}",
                           &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}


#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
    /// Number of tests that failed to compile.
    failed_to_compile: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn record_failed_to_compile(&mut self) {
        self.failed += 1;
        self.failed_to_compile += 1;
    }
    fn summary(&self) -> String {
        format!(
            "{} passed; {} failed (compilation errors: {})",
            self.passed,
            self.failed,
            self.failed_to_compile)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let tmpdir = tempdir::TempDir::new("abi").expect("temporary directory");
    let cc = Compiler::new().expect("configured compiler");

    assert_eq!("1",
               get_c_value(tmpdir.path(), &cc, "1").expect("C constant"),
               "failed to obtain correct constant value for 1");

    let mut results : Results = Default::default();
    for (i, &(name, rust_value)) in RUST_CONSTANTS.iter().enumerate() {
        match get_c_value(tmpdir.path(), &cc, name) {
            Err(e) => {
                results.record_failed_to_compile();
                eprintln!("{}", e);
            },
            Ok(ref c_value) => {
                if rust_value == c_value {
                    results.record_passed();
                } else {
                    results.record_failed();
                    eprintln!("Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                              name, rust_value, c_value);
                }
            }
        };
        if (i + 1) % 25 == 0 {
            println!("constants ... {}", results.summary());
        }
    }
    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let tmpdir = tempdir::TempDir::new("abi").expect("temporary directory");
    let cc = Compiler::new().expect("configured compiler");

    assert_eq!(Layout {size: 1, alignment: 1},
               get_c_layout(tmpdir.path(), &cc, "char").expect("C layout"),
               "failed to obtain correct layout for char type");

    let mut results : Results = Default::default();
    for (i, &(name, rust_layout)) in RUST_LAYOUTS.iter().enumerate() {
        match get_c_layout(tmpdir.path(), &cc, name) {
            Err(e) => {
                results.record_failed_to_compile();
                eprintln!("{}", e);
            },
            Ok(c_layout) => {
                if rust_layout == c_layout {
                    results.record_passed();
                } else {
                    results.record_failed();
                    eprintln!("Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                              name, rust_layout, &c_layout);
                }
            }
        };
        if (i + 1) % 25 == 0 {
            println!("layout    ... {}", results.summary());
        }
    }
    results.expect_total_success();
}

fn get_c_layout(dir: &Path, cc: &Compiler, name: &str) -> Result<Layout, Box<Error>> {
    let exe = dir.join("layout");
    let mut cc = cc.clone();
    cc.define("ABI_TYPE_NAME", name);
    cc.compile(Path::new("tests/layout.c"), &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}",
                           &abi_cmd, &output).into());
    }

    let stdout = str::from_utf8(&output.stdout)?;
    let mut words = stdout.trim().split_whitespace();
    let size = words.next().unwrap().parse().unwrap();
    let alignment = words.next().unwrap().parse().unwrap();
    Ok(Layout {size, alignment})
}

fn get_c_value(dir: &Path, cc: &Compiler, name: &str) -> Result<String, Box<Error>> {
    let exe = dir.join("constant");
    let mut cc = cc.clone();
    cc.define("ABI_CONSTANT_NAME", name);
    cc.compile(Path::new("tests/constant.c"), &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}",
                           &abi_cmd, &output).into());
    }

    Ok(str::from_utf8(&output.stdout)?.trim().to_owned())
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    ("GdkColorspace", Layout {size: size_of::<GdkColorspace>(), alignment: align_of::<GdkColorspace>()}),
    ("GdkInterpType", Layout {size: size_of::<GdkInterpType>(), alignment: align_of::<GdkInterpType>()}),
    ("GdkPixbufAlphaMode", Layout {size: size_of::<GdkPixbufAlphaMode>(), alignment: align_of::<GdkPixbufAlphaMode>()}),
    ("GdkPixbufError", Layout {size: size_of::<GdkPixbufError>(), alignment: align_of::<GdkPixbufError>()}),
    ("GdkPixbufLoader", Layout {size: size_of::<GdkPixbufLoader>(), alignment: align_of::<GdkPixbufLoader>()}),
    ("GdkPixbufLoaderClass", Layout {size: size_of::<GdkPixbufLoaderClass>(), alignment: align_of::<GdkPixbufLoaderClass>()}),
    ("GdkPixbufRotation", Layout {size: size_of::<GdkPixbufRotation>(), alignment: align_of::<GdkPixbufRotation>()}),
    ("GdkPixdata", Layout {size: size_of::<GdkPixdata>(), alignment: align_of::<GdkPixdata>()}),
    ("GdkPixdataDumpType", Layout {size: size_of::<GdkPixdataDumpType>(), alignment: align_of::<GdkPixdataDumpType>()}),
    ("GdkPixdataType", Layout {size: size_of::<GdkPixdataType>(), alignment: align_of::<GdkPixdataType>()}),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("GDK_COLORSPACE_RGB", "0"),
    ("GDK_INTERP_BILINEAR", "2"),
    ("GDK_INTERP_HYPER", "3"),
    ("GDK_INTERP_NEAREST", "0"),
    ("GDK_INTERP_TILES", "1"),
    ("GDK_PIXBUF_ALPHA_BILEVEL", "0"),
    ("GDK_PIXBUF_ALPHA_FULL", "1"),
    ("GDK_PIXBUF_ERROR_BAD_OPTION", "2"),
    ("GDK_PIXBUF_ERROR_CORRUPT_IMAGE", "0"),
    ("GDK_PIXBUF_ERROR_FAILED", "5"),
    ("GDK_PIXBUF_ERROR_INCOMPLETE_ANIMATION", "6"),
    ("GDK_PIXBUF_ERROR_INSUFFICIENT_MEMORY", "1"),
    ("GDK_PIXBUF_ERROR_UNKNOWN_TYPE", "3"),
    ("GDK_PIXBUF_ERROR_UNSUPPORTED_OPERATION", "4"),
    ("GDK_PIXBUF_MAGIC_NUMBER", "1197763408"),
    ("GDK_PIXBUF_ROTATE_CLOCKWISE", "270"),
    ("GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE", "90"),
    ("GDK_PIXBUF_ROTATE_NONE", "0"),
    ("GDK_PIXBUF_ROTATE_UPSIDEDOWN", "180"),
    ("GDK_PIXDATA_COLOR_TYPE_MASK", "255"),
    ("GDK_PIXDATA_COLOR_TYPE_RGB", "1"),
    ("GDK_PIXDATA_COLOR_TYPE_RGBA", "2"),
    ("GDK_PIXDATA_DUMP_CONST", "1024"),
    ("GDK_PIXDATA_DUMP_CTYPES", "256"),
    ("GDK_PIXDATA_DUMP_GTYPES", "0"),
    ("GDK_PIXDATA_DUMP_MACROS", "2"),
    ("GDK_PIXDATA_DUMP_PIXDATA_STREAM", "0"),
    ("GDK_PIXDATA_DUMP_PIXDATA_STRUCT", "1"),
    ("GDK_PIXDATA_DUMP_RLE_DECODER", "65536"),
    ("GDK_PIXDATA_DUMP_STATIC", "512"),
    ("GDK_PIXDATA_ENCODING_MASK", "251658240"),
    ("GDK_PIXDATA_ENCODING_RAW", "16777216"),
    ("GDK_PIXDATA_ENCODING_RLE", "33554432"),
    ("GDK_PIXDATA_HEADER_LENGTH", "24"),
    ("GDK_PIXDATA_SAMPLE_WIDTH_8", "65536"),
    ("GDK_PIXDATA_SAMPLE_WIDTH_MASK", "983040"),
];


