/* rygel-xbox-hacks.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-xbox-hacks.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
typedef struct _RygelXBoxHacksPrivate RygelXBoxHacksPrivate;
enum  {
	RYGEL_XBOX_HACKS_0_PROPERTY,
	RYGEL_XBOX_HACKS_NUM_PROPERTIES
};
static GParamSpec* rygel_xbox_hacks_properties[RYGEL_XBOX_HACKS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelXboxHacksSearchData RygelXboxHacksSearchData;

#define RYGEL_TYPE_LOGICAL_EXPRESSION (rygel_logical_expression_get_type ())
#define RYGEL_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpression))
#define RYGEL_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))
#define RYGEL_IS_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_IS_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_LOGICAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))

typedef struct _RygelLogicalExpression RygelLogicalExpression;
typedef struct _RygelLogicalExpressionClass RygelLogicalExpressionClass;
typedef enum  {
	RYGEL_LOGICAL_OPERATOR_AND,
	RYGEL_LOGICAL_OPERATOR_OR
} RygelLogicalOperator;

#define RYGEL_TYPE_LOGICAL_OPERATOR (rygel_logical_operator_get_type ())

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
	GRegex* agent_regex;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
	void (*translate_container_id) (RygelClientHacks* self, RygelMediaQueryAction* action, gchar* * container_id);
	void (*apply) (RygelClientHacks* self, RygelMediaObject* object);
	void (*filter_sort_criteria) (RygelClientHacks* self, gchar* * sort_criteria);
	gboolean (*force_seek) (RygelClientHacks* self);
	void (*modify_headers) (RygelClientHacks* self, RygelHTTPRequest* request);
	void (*search) (RygelClientHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelClientHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelXBoxHacks {
	RygelClientHacks parent_instance;
	RygelXBoxHacksPrivate * priv;
};

struct _RygelXBoxHacksClass {
	RygelClientHacksClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelXboxHacksSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelXBoxHacks* self;
	RygelSearchableContainer* container;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	guint total_matches;
	RygelMediaObjects* result;
	gboolean set_total_matches;
	RygelSearchExpression* modified_expression;
	RygelSearchExpression* _tmp0_;
	RygelRelationalExpression* rel_expression;
	RygelRelationalExpression* _tmp1_;
	gboolean _tmp2_;
	RygelRelationalExpression* _tmp3_;
	gconstpointer _tmp4_;
	RygelRelationalExpression* _tmp5_;
	gconstpointer _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	RygelRelationalExpression* _tmp10_;
	gconstpointer _tmp11_;
	RygelRelationalExpression* _tmp12_;
	gconstpointer _tmp13_;
	RygelRelationalExpression* _tmp14_;
	gconstpointer _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	RygelSearchExpression* _tmp18_;
	RygelMediaObjects* results;
	RygelSearchExpression* _tmp19_;
	guint _tmp20_;
	RygelMediaObjects* _tmp21_;
	gboolean _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GError * _inner_error_;
};

static gpointer rygel_xbox_hacks_parent_class = NULL;

GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
void rygel_value_set_search_expression (GValue* value,
                                        gpointer v_object);
void rygel_value_take_search_expression (GValue* value,
                                         gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
#define RYGEL_XBOX_HACKS_AGENT ".*Xbox.*"
#define RYGEL_XBOX_HACKS_DMS "urn:schemas-upnp-org:device:MediaServer"
#define RYGEL_XBOX_HACKS_DMS_V1 RYGEL_XBOX_HACKS_DMS ":1"
#define RYGEL_XBOX_HACKS_FRIENDLY_NAME_POSTFIX ":"
#define RYGEL_XBOX_HACKS_MODEL_NAME "Windows Media Player Sharing"
#define RYGEL_XBOX_HACKS_MODEL_VERSION "11"
#define RYGEL_XBOX_HACKS_CONTAINER_ID "ContainerID"
GQuark rygel_client_hacks_error_quark (void);
RygelXBoxHacks* rygel_xbox_hacks_new (SoupMessage* message,
                                      GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type,
                                            SoupMessage* message,
                                            GError** error);
RygelClientHacks* rygel_client_hacks_construct (GType object_type,
                                                const gchar* agent,
                                                SoupMessage* message,
                                                GError** error);
void rygel_client_hacks_set_object_id (RygelClientHacks* self,
                                       const gchar* value);
static gchar** _vala_array_dup5 (gchar** self,
                          int length);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self,
                                       RygelRootDevice* device,
                                       const gchar* template_path,
                                       GError** error);
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE "urn:microsoft-com:service:X_MS_MediaReceiverRegistrar:1"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_COMPAT_TYPE "urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1"
static void rygel_xbox_hacks_real_translate_container_id (RygelClientHacks* base,
                                                   RygelMediaQueryAction* action,
                                                   gchar* * container_id);
GType rygel_search_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
static void rygel_xbox_hacks_real_apply (RygelClientHacks* base,
                                  RygelMediaObject* object);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
#define RYGEL_MEDIA_CONTAINER_UPNP_CLASS "object.container"
#define RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".storageFolder"
void rygel_media_object_set_upnp_class (RygelMediaObject* self,
                                        const gchar* value);
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GeeList* rygel_media_object_get_resource_list (RygelMediaObject* self);
const gchar* rygel_media_resource_get_mime_type (RygelMediaResource* self);
void rygel_media_resource_set_mime_type (RygelMediaResource* self,
                                         const gchar* value);
static void rygel_xbox_hacks_real_filter_sort_criteria (RygelClientHacks* base,
                                                 gchar* * sort_criteria);
static void rygel_xbox_hacks_real_search_data_free (gpointer _data);
static void rygel_xbox_hacks_real_search_async_ready_wrapper (GObject *source_object,
                                                       GAsyncResult *res,
                                                       void *user_data);
static void rygel_xbox_hacks_real_search (RygelClientHacks* base,
                                   RygelSearchableContainer* container,
                                   RygelSearchExpression* expression,
                                   guint offset,
                                   guint max_count,
                                   const gchar* sort_criteria,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
static gboolean rygel_xbox_hacks_real_search_co (RygelXboxHacksSearchData* _data_);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
static RygelSearchExpression* rygel_xbox_hacks_rewrite_search_expression (RygelXBoxHacks* self,
                                                                   RygelSearchExpression* expression);
void rygel_searchable_container_search (RygelSearchableContainer* self,
                                        RygelSearchExpression* expression,
                                        guint offset,
                                        guint max_count,
                                        const gchar* sort_criteria,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self,
                                                             GAsyncResult* _res_,
                                                             guint* total_matches,
                                                             GError** error);
static void rygel_xbox_hacks_search_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_logical_expression_get_type (void) G_GNUC_CONST;
RygelLogicalExpression* rygel_logical_expression_new (void);
RygelLogicalExpression* rygel_logical_expression_construct (GType object_type);
GType rygel_logical_operator_get_type (void) G_GNUC_CONST;
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gboolean
bool_parse (const gchar* str)
{
	gboolean result = FALSE;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gchar**
_vala_array_dup5 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

RygelXBoxHacks*
rygel_xbox_hacks_construct (GType object_type,
                            SoupMessage* message,
                            GError** error)
{
	RygelXBoxHacks * self = NULL;
	SoupURI* uri = NULL;
	SoupURI* _tmp0_;
	const gchar* query = NULL;
	SoupURI* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GHashTable* params = NULL;
	const gchar* _tmp4_;
	GHashTable* _tmp5_;
	gchar* album_art = NULL;
	GHashTable* _tmp6_;
	gconstpointer _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gchar* path = NULL;
	SoupURI* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** particles = NULL;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gint particles_length1;
	gint _particles_size_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	SoupURI* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GError * _inner_error_ = NULL;
	self = (RygelXBoxHacks*) rygel_client_hacks_construct (object_type, RYGEL_XBOX_HACKS_AGENT, message, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_CLIENT_HACKS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	rygel_client_hacks_set_object_id ((RygelClientHacks*) self, RYGEL_XBOX_HACKS_CONTAINER_ID);
	if (message == NULL) {
		return self;
	}
	_tmp0_ = soup_message_get_uri (message);
	uri = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = _tmp1_->query;
	query = _tmp2_;
	_tmp3_ = query;
	if (_tmp3_ == NULL) {
		return self;
	}
	_tmp4_ = query;
	_tmp5_ = soup_form_decode (_tmp4_);
	params = _tmp5_;
	_tmp6_ = params;
	_tmp7_ = g_hash_table_lookup (_tmp6_, "albumArt");
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	album_art = _tmp8_;
	_tmp10_ = album_art;
	if (_tmp10_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp11_;
		_tmp11_ = album_art;
		_tmp9_ = !bool_parse (_tmp11_);
	}
	if (_tmp9_) {
		_g_free0 (album_art);
		_g_hash_table_unref0 (params);
		return self;
	}
	_tmp12_ = uri;
	_tmp13_ = soup_uri_get_path (_tmp12_);
	_tmp14_ = g_strdup (_tmp13_);
	path = _tmp14_;
	_tmp15_ = path;
	_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, "/", 0);
	_tmp18_ = _tmp17_;
	_tmp18__length1 = _vala_array_length (_tmp16_);
	_tmp19_ = ((_tmp18_ + 0) != NULL) ? _vala_array_dup5 (_tmp18_ + 0, 4 - 0) : ((gpointer) (_tmp18_ + 0));
	_tmp19__length1 = 4 - 0;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = _tmp19__length1;
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	particles = _tmp20_;
	particles_length1 = _tmp20__length1;
	_particles_size_ = particles_length1;
	_tmp21_ = particles;
	_tmp21__length1 = particles_length1;
	_tmp22_ = g_strdup ("th");
	_vala_array_add1 (&particles, &particles_length1, &_particles_size_, _tmp22_);
	_tmp23_ = particles;
	_tmp23__length1 = particles_length1;
	_tmp24_ = g_strdup ("0");
	_vala_array_add2 (&particles, &particles_length1, &_particles_size_, _tmp24_);
	_tmp25_ = uri;
	_tmp26_ = particles;
	_tmp26__length1 = particles_length1;
	_tmp27_ = _vala_g_strjoinv ("/", _tmp26_, (gint) _tmp26__length1);
	_tmp28_ = _tmp27_;
	soup_uri_set_path (_tmp25_, _tmp28_);
	_g_free0 (_tmp28_);
	particles = (_vala_array_free (particles, particles_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (path);
	_g_free0 (album_art);
	_g_hash_table_unref0 (params);
	return self;
}

RygelXBoxHacks*
rygel_xbox_hacks_new (SoupMessage* message,
                      GError** error)
{
	return rygel_xbox_hacks_construct (RYGEL_TYPE_XBOX_HACKS, message, error);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch84_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch84_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally84;
	__catch84_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally84:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}

void
rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self,
                                  RygelRootDevice* device,
                                  const gchar* template_path,
                                  GError** error)
{
	const gchar* _tmp0_;
	RygelDescriptionFile* description_file = NULL;
	RygelDescriptionFile* _tmp1_;
	RygelDescriptionFile* _tmp2_;
	RygelDescriptionFile* _tmp3_;
	gchar* friendly_name = NULL;
	RygelDescriptionFile* _tmp4_;
	gchar* _tmp5_;
	RygelDescriptionFile* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	RygelDescriptionFile* _tmp10_;
	gchar* desc_path = NULL;
	gchar* _tmp11_;
	RygelDescriptionFile* _tmp12_;
	const gchar* _tmp13_;
	gchar* server_path = NULL;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GUPnPContext* _tmp16_;
	GUPnPContext* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GRegex* _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) device);
	if (!g_str_has_prefix (_tmp0_, RYGEL_XBOX_HACKS_DMS)) {
		return;
	}
	if (template_path == NULL) {
		return;
	}
	_tmp1_ = rygel_description_file_new (template_path, &_inner_error_);
	description_file = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = description_file;
	rygel_description_file_set_model_name (_tmp2_, RYGEL_XBOX_HACKS_MODEL_NAME);
	_tmp3_ = description_file;
	rygel_description_file_set_model_number (_tmp3_, RYGEL_XBOX_HACKS_MODEL_VERSION);
	_tmp4_ = description_file;
	_tmp5_ = rygel_description_file_get_friendly_name (_tmp4_);
	friendly_name = _tmp5_;
	_tmp6_ = description_file;
	_tmp7_ = friendly_name;
	_tmp8_ = g_strconcat (_tmp7_, RYGEL_XBOX_HACKS_FRIENDLY_NAME_POSTFIX, NULL);
	_tmp9_ = _tmp8_;
	rygel_description_file_set_friendly_name (_tmp6_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = description_file;
	rygel_description_file_modify_service_type (_tmp10_, RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE, RYGEL_MEDIA_RECEIVER_REGISTRAR_COMPAT_TYPE);
	_tmp11_ = string_replace (template_path, "v1.xml", "xbox.xml");
	desc_path = _tmp11_;
	_tmp12_ = description_file;
	_tmp13_ = desc_path;
	rygel_description_file_save (_tmp12_, _tmp13_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (desc_path);
		_g_free0 (friendly_name);
		_g_object_unref0 (description_file);
		return;
	}
	_tmp14_ = gupnp_root_device_get_relative_location ((GUPnPRootDevice*) device);
	_tmp15_ = g_strconcat ("/", _tmp14_, NULL);
	server_path = _tmp15_;
	_tmp16_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) device);
	_tmp17_ = _tmp16_;
	_tmp18_ = desc_path;
	_tmp19_ = server_path;
	_tmp20_ = ((RygelClientHacks*) self)->agent_regex;
	gupnp_context_host_path_for_agent (_tmp17_, _tmp18_, _tmp19_, _tmp20_);
	_g_free0 (server_path);
	_g_free0 (desc_path);
	_g_free0 (friendly_name);
	_g_object_unref0 (description_file);
}

static void
rygel_xbox_hacks_real_translate_container_id (RygelClientHacks* base,
                                              RygelMediaQueryAction* action,
                                              gchar* * container_id)
{
	RygelXBoxHacks * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (RygelXBoxHacks*) base;
	g_return_if_fail (action != NULL);
	g_return_if_fail (*container_id != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (action, RYGEL_TYPE_SEARCH)) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		if (g_strcmp0 (*container_id, "1") == 0) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = g_strcmp0 (*container_id, "4") == 0;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = g_strcmp0 (*container_id, "5") == 0;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = g_strcmp0 (*container_id, "6") == 0;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = g_strcmp0 (*container_id, "7") == 0;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = g_strcmp0 (*container_id, "F") == 0;
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (action, RYGEL_TYPE_BROWSE)) {
			_tmp9_ = g_strcmp0 (*container_id, "15") == 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = g_strcmp0 (*container_id, "14") == 0;
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = g_strcmp0 (*container_id, "16") == 0;
		}
		_tmp0_ = _tmp7_;
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("0");
		_g_free0 (*container_id);
		*container_id = _tmp10_;
	}
}

static void
rygel_xbox_hacks_real_apply (RygelClientHacks* base,
                             RygelMediaObject* object)
{
	RygelXBoxHacks * self;
	self = (RygelXBoxHacks*) base;
	g_return_if_fail (object != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_CONTAINER)) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = rygel_media_object_get_upnp_class (object);
		_tmp1_ = _tmp0_;
		if (g_strcmp0 (_tmp1_, RYGEL_MEDIA_CONTAINER_UPNP_CLASS) == 0) {
			rygel_media_object_set_upnp_class (object, RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER);
		}
		return;
	}
	{
		GeeList* _resource_list = NULL;
		GeeList* _tmp2_;
		gint _resource_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _resource_index = 0;
		_tmp2_ = rygel_media_object_get_resource_list (object);
		_resource_list = _tmp2_;
		_tmp3_ = _resource_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_resource_size = _tmp5_;
		_resource_index = -1;
		while (TRUE) {
			RygelMediaResource* resource = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			RygelMediaResource* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_resource_index = _resource_index + 1;
			if (!(_resource_index < _resource_size)) {
				break;
			}
			_tmp6_ = _resource_list;
			_tmp7_ = gee_list_get (_tmp6_, _resource_index);
			resource = (RygelMediaResource*) _tmp7_;
			_tmp8_ = resource;
			_tmp9_ = rygel_media_resource_get_mime_type (_tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, "video/x-msvideo") == 0) {
				RygelMediaResource* _tmp11_;
				_tmp11_ = resource;
				rygel_media_resource_set_mime_type (_tmp11_, "video/avi");
			} else {
				RygelMediaResource* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp12_ = resource;
				_tmp13_ = rygel_media_resource_get_mime_type (_tmp12_);
				_tmp14_ = _tmp13_;
				if (g_strcmp0 (_tmp14_, "video/mpeg") == 0) {
					RygelMediaResource* _tmp15_;
					_tmp15_ = resource;
					rygel_media_resource_set_mime_type (_tmp15_, "invalid/content");
				}
			}
			_g_object_unref0 (resource);
		}
		_g_object_unref0 (_resource_list);
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
rygel_xbox_hacks_real_filter_sort_criteria (RygelClientHacks* base,
                                            gchar* * sort_criteria)
{
	RygelXBoxHacks * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelXBoxHacks*) base;
	g_return_if_fail (*sort_criteria != NULL);
	_tmp0_ = string_replace (*sort_criteria, "+microsoft:sourceURL", "");
	_g_free0 (*sort_criteria);
	*sort_criteria = _tmp0_;
	_tmp1_ = string_replace (*sort_criteria, ",,", ",");
	_g_free0 (*sort_criteria);
	*sort_criteria = _tmp1_;
	if (g_str_has_prefix (*sort_criteria, ",")) {
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = strlen (*sort_criteria);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_slice (*sort_criteria, (glong) 1, (glong) _tmp3_);
		_g_free0 (*sort_criteria);
		*sort_criteria = _tmp4_;
	}
}

static void
rygel_xbox_hacks_real_search_data_free (gpointer _data)
{
	RygelXboxHacksSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelXboxHacksSearchData, _data_);
}

static void
rygel_xbox_hacks_real_search_async_ready_wrapper (GObject *source_object,
                                                  GAsyncResult *res,
                                                  void *user_data)
{
	RygelXboxHacksSearchData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}

static void
rygel_xbox_hacks_real_search (RygelClientHacks* base,
                              RygelSearchableContainer* container,
                              RygelSearchExpression* expression,
                              guint offset,
                              guint max_count,
                              const gchar* sort_criteria,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	RygelXBoxHacks * self;
	RygelXboxHacksSearchData* _data_;
	RygelXBoxHacks* _tmp0_;
	RygelSearchableContainer* _tmp1_;
	RygelSearchExpression* _tmp2_;
	gchar* _tmp3_;
	GCancellable* _tmp4_;
	self = (RygelXBoxHacks*) base;
	_data_ = g_slice_new0 (RygelXboxHacksSearchData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_xbox_hacks_real_search_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_xbox_hacks_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (container);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp1_;
	_tmp2_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp2_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp3_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_xbox_hacks_real_search_co (_data_);
}

static RygelMediaObjects*
rygel_xbox_hacks_real_search_finish (RygelClientHacks* base,
                                     GAsyncResult* _res_,
                                     guint* total_matches,
                                     GError** error)
{
	RygelMediaObjects* result;
	RygelXboxHacksSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_xbox_hacks_search_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	RygelXboxHacksSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_xbox_hacks_real_search_co (_data_);
}

static gboolean
rygel_xbox_hacks_real_search_co (RygelXboxHacksSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->set_total_matches = FALSE;
	_data_->_tmp0_ = _rygel_search_expression_ref0 (_data_->expression);
	_data_->modified_expression = _data_->_tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->expression, RYGEL_TYPE_RELATIONAL_EXPRESSION)) {
		_data_->_tmp1_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->expression, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _data_->expression) : NULL);
		_data_->rel_expression = _data_->_tmp1_;
		_data_->_tmp3_ = _data_->rel_expression;
		_data_->_tmp4_ = ((RygelSearchExpression*) _data_->_tmp3_)->operand1;
		if (G_LIKELY (((const gchar*) _data_->_tmp4_) != NULL)) {
			_data_->_tmp5_ = _data_->rel_expression;
			_data_->_tmp6_ = ((RygelSearchExpression*) _data_->_tmp5_)->operand1;
			_data_->_tmp2_ = g_strcmp0 ((const gchar*) _data_->_tmp6_, "upnp:class") == 0;
		} else {
			_data_->_tmp2_ = FALSE;
		}
		if (_data_->_tmp2_) {
			_data_->set_total_matches = TRUE;
			_data_->_tmp10_ = _data_->rel_expression;
			_data_->_tmp11_ = ((RygelSearchExpression*) _data_->_tmp10_)->op;
			if (((GUPnPSearchCriteriaOp) ((gintptr) _data_->_tmp11_)) == GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM) {
				_data_->_tmp12_ = _data_->rel_expression;
				_data_->_tmp13_ = ((RygelSearchExpression*) _data_->_tmp12_)->operand2;
				_data_->_tmp9_ = ((const gchar*) _data_->_tmp13_) != NULL;
			} else {
				_data_->_tmp9_ = FALSE;
			}
			if (_data_->_tmp9_) {
				_data_->_tmp14_ = _data_->rel_expression;
				_data_->_tmp15_ = ((RygelSearchExpression*) _data_->_tmp14_)->operand2;
				_data_->_tmp8_ = g_strcmp0 ((const gchar*) _data_->_tmp15_, RYGEL_AUDIO_ITEM_UPNP_CLASS) == 0;
			} else {
				_data_->_tmp8_ = FALSE;
			}
			if (_data_->_tmp8_) {
				_data_->_tmp16_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->container);
				_data_->_tmp17_ = _data_->_tmp16_;
				_data_->_tmp7_ = g_strcmp0 (_data_->_tmp17_, "0") == 0;
			} else {
				_data_->_tmp7_ = FALSE;
			}
			if (_data_->_tmp7_) {
				_data_->_tmp18_ = rygel_xbox_hacks_rewrite_search_expression (_data_->self, _data_->expression);
				_rygel_search_expression_unref0 (_data_->modified_expression);
				_data_->modified_expression = _data_->_tmp18_;
			}
		}
		_rygel_search_expression_unref0 (_data_->rel_expression);
	}
	_data_->_tmp19_ = _data_->modified_expression;
	_data_->_tmp20_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_search (_data_->container, _data_->_tmp19_, _data_->offset, _data_->max_count, _data_->sort_criteria, _data_->cancellable, rygel_xbox_hacks_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp21_ = rygel_searchable_container_search_finish (_data_->container, _data_->_res_, &_data_->_tmp20_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp20_;
	_data_->results = _data_->_tmp21_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->modified_expression);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->total_matches == ((guint) 0)) {
		_data_->_tmp22_ = _data_->set_total_matches;
	} else {
		_data_->_tmp22_ = FALSE;
	}
	if (_data_->_tmp22_) {
		_data_->_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->results);
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->total_matches = (guint) _data_->_tmp24_;
	}
	_data_->result = _data_->results;
	_rygel_search_expression_unref0 (_data_->modified_expression);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static RygelSearchExpression*
rygel_xbox_hacks_rewrite_search_expression (RygelXBoxHacks* self,
                                            RygelSearchExpression* expression)
{
	RygelSearchExpression* result = NULL;
	RygelRelationalExpression* ref_id_expression = NULL;
	RygelRelationalExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	RygelLogicalExpression* new_expression = NULL;
	RygelLogicalExpression* _tmp3_;
	RygelSearchExpression* _tmp4_;
	RygelSearchExpression* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	_tmp0_ = rygel_relational_expression_new ();
	ref_id_expression = _tmp0_;
	_tmp1_ = g_strdup ("@refID");
	_g_free0 (((RygelSearchExpression*) ref_id_expression)->operand1);
	((RygelSearchExpression*) ref_id_expression)->operand1 = _tmp1_;
	((RygelSearchExpression*) ref_id_expression)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EXISTS);
	_tmp2_ = g_strdup ("false");
	_g_free0 (((RygelSearchExpression*) ref_id_expression)->operand2);
	((RygelSearchExpression*) ref_id_expression)->operand2 = _tmp2_;
	_tmp3_ = rygel_logical_expression_new ();
	new_expression = _tmp3_;
	_tmp4_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (((RygelSearchExpression*) new_expression)->operand1);
	((RygelSearchExpression*) new_expression)->operand1 = _tmp4_;
	((RygelSearchExpression*) new_expression)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_AND);
	_tmp5_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) ref_id_expression);
	_rygel_search_expression_unref0 (((RygelSearchExpression*) new_expression)->operand2);
	((RygelSearchExpression*) new_expression)->operand2 = _tmp5_;
	result = (RygelSearchExpression*) new_expression;
	_rygel_search_expression_unref0 (ref_id_expression);
	return result;
}

static void
rygel_xbox_hacks_class_init (RygelXBoxHacksClass * klass)
{
	rygel_xbox_hacks_parent_class = g_type_class_peek_parent (klass);
	((RygelClientHacksClass *) klass)->translate_container_id = (void (*) (RygelClientHacks*, RygelMediaQueryAction*, gchar* *)) rygel_xbox_hacks_real_translate_container_id;
	((RygelClientHacksClass *) klass)->apply = (void (*) (RygelClientHacks*, RygelMediaObject*)) rygel_xbox_hacks_real_apply;
	((RygelClientHacksClass *) klass)->filter_sort_criteria = (void (*) (RygelClientHacks*, gchar* *)) rygel_xbox_hacks_real_filter_sort_criteria;
	((RygelClientHacksClass *) klass)->search = (void (*) (RygelClientHacks*, RygelSearchableContainer*, RygelSearchExpression*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_xbox_hacks_real_search;
	((RygelClientHacksClass *) klass)->search_finish = (RygelMediaObjects* (*) (RygelClientHacks*, GAsyncResult*, guint*, GError**)) rygel_xbox_hacks_real_search_finish;
}

static void
rygel_xbox_hacks_instance_init (RygelXBoxHacks * self)
{
}

GType
rygel_xbox_hacks_get_type (void)
{
	static volatile gsize rygel_xbox_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_xbox_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelXBoxHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_xbox_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelXBoxHacks), 0, (GInstanceInitFunc) rygel_xbox_hacks_instance_init, NULL };
		GType rygel_xbox_hacks_type_id;
		rygel_xbox_hacks_type_id = g_type_register_static (RYGEL_TYPE_CLIENT_HACKS, "RygelXBoxHacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_xbox_hacks_type_id__volatile, rygel_xbox_hacks_type_id);
	}
	return rygel_xbox_hacks_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

