// Generated by gmmproc 2.55.2 -- DO NOT MODIFY!
#ifndef _GDKMM_DEVICE_H
#define _GDKMM_DEVICE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2002-2004 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <vector>

#include <gdkmm/cursor.h>
#include <gdkmm/enums.h>
#include <gdkmm/timecoord.h>
#include <gdkmm/types.h>
#include <gdk/gdk.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkDevice = struct _GdkDevice;
using GdkDeviceClass = struct _GdkDeviceClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class Device_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{

/** @addtogroup gdkmmEnums gdkmm Enums and Flags */

/** 
 *  @var EventMask EXPOSURE_MASK
 * Receive expose events.
 * 
 *  @var EventMask POINTER_MOTION_MASK
 * Receive all pointer motion events.
 * 
 *  @var EventMask BUTTON_MOTION_MASK
 * Receive pointer motion events while any button is pressed.
 * 
 *  @var EventMask BUTTON1_MOTION_MASK
 * Receive pointer motion events while 1 button is pressed.
 * 
 *  @var EventMask BUTTON2_MOTION_MASK
 * Receive pointer motion events while 2 button is pressed.
 * 
 *  @var EventMask BUTTON3_MOTION_MASK
 * Receive pointer motion events while 3 button is pressed.
 * 
 *  @var EventMask BUTTON_PRESS_MASK
 * Receive button press events.
 * 
 *  @var EventMask BUTTON_RELEASE_MASK
 * Receive button release events.
 * 
 *  @var EventMask KEY_PRESS_MASK
 * Receive key press events.
 * 
 *  @var EventMask KEY_RELEASE_MASK
 * Receive key release events.
 * 
 *  @var EventMask ENTER_NOTIFY_MASK
 * Receive window enter events.
 * 
 *  @var EventMask LEAVE_NOTIFY_MASK
 * Receive window leave events.
 * 
 *  @var EventMask FOCUS_CHANGE_MASK
 * Receive focus change events.
 * 
 *  @var EventMask STRUCTURE_MASK
 * Receive events about window configuration change.
 * 
 *  @var EventMask PROPERTY_CHANGE_MASK
 * Receive property change events.
 * 
 *  @var EventMask PROXIMITY_IN_MASK
 * Receive proximity in events.
 * 
 *  @var EventMask PROXIMITY_OUT_MASK
 * Receive proximity out events.
 * 
 *  @var EventMask SUBSTRUCTURE_MASK
 * Receive events about window configuration changes of
 * child windows.
 * 
 *  @var EventMask SCROLL_MASK
 * Receive scroll events.
 * 
 *  @var EventMask TOUCH_MASK
 * Receive touch events. @newin{3,4}
 * 
 *  @var EventMask SMOOTH_SCROLL_MASK
 * Receive smooth scrolling events. Since 3.4
 *    @a GDK_TOUCHPAD_GESTURE_MASK: receive touchpad gesture events. @newin{3,18}
 * 
 *  @var EventMask TABLET_PAD_MASK
 * Receive tablet pad events. @newin{3,22}
 * 
 *  @var EventMask ALL_EVENTS_MASK
 * The combination of all the above event masks.
 * 
 *  @enum EventMask
 * 
 * A set of bit-flags to indicate which events a window is to receive.
 * Most of these masks map onto one or more of the Gdk::Event::Type event types
 * above.
 * 
 * See the [input handling overview][chap-input-handling] for details of
 * [event masks][event-masks] and [event propagation][event-propagation].
 * 
 * Since GTK 3.8, motion events are already compressed by default, independent
 * of this mechanism. This compression can be disabled with
 * gdk_window_set_event_compression(). See the documentation of that function
 * for details.
 * 
 * If Gdk::EventMask::TOUCH_MASK is enabled, the window will receive touch events
 * from touch-enabled devices. Those will come as sequences of Gdk::EventTouch
 * with type Gdk::Event::Type::TOUCH_UPDATE, enclosed by two events with
 * type Gdk::Event::Type::TOUCH_BEGIN and Gdk::Event::Type::TOUCH_END (or Gdk::Event::Type::TOUCH_CANCEL).
 * Gdk::Event::get_event_sequence() returns the event sequence for these
 * events, so different sequences may be distinguished.
 *
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>EventMask operator|(EventMask, EventMask)</tt><br>
 * <tt>EventMask operator&(EventMask, EventMask)</tt><br>
 * <tt>EventMask operator^(EventMask, EventMask)</tt><br>
 * <tt>EventMask operator~(EventMask)</tt><br>
 * <tt>EventMask& operator|=(EventMask&, EventMask)</tt><br>
 * <tt>EventMask& operator&=(EventMask&, EventMask)</tt><br>
 * <tt>EventMask& operator^=(EventMask&, EventMask)</tt><br>
 */
enum class EventMask
{
  EXPOSURE_MASK = 1 << 1,
  POINTER_MOTION_MASK = 1 << 2,
  BUTTON_MOTION_MASK = 1 << 4,
  BUTTON1_MOTION_MASK = 1 << 5,
  BUTTON2_MOTION_MASK = 1 << 6,
  BUTTON3_MOTION_MASK = 1 << 7,
  BUTTON_PRESS_MASK = 1 << 8,
  BUTTON_RELEASE_MASK = 1 << 9,
  KEY_PRESS_MASK = 1 << 10,
  KEY_RELEASE_MASK = 1 << 11,
  ENTER_NOTIFY_MASK = 1 << 12,
  LEAVE_NOTIFY_MASK = 1 << 13,
  FOCUS_CHANGE_MASK = 1 << 14,
  STRUCTURE_MASK = 1 << 15,
  PROPERTY_CHANGE_MASK = 1 << 16,
  PROXIMITY_IN_MASK = 1 << 18,
  PROXIMITY_OUT_MASK = 1 << 19,
  SUBSTRUCTURE_MASK = 1 << 20,
  SCROLL_MASK = 1 << 21,
  TOUCH_MASK = 1 << 22,
  SMOOTH_SCROLL_MASK = 1 << 23,
  TOUCHPAD_GESTURE_MASK = 1 << 24,
  TABLET_PAD_MASK = 1 << 25,
  ALL_EVENTS_MASK = 0x3FFFFFE
};

/** @ingroup gdkmmEnums */
inline EventMask operator|(EventMask lhs, EventMask rhs)
  { return static_cast<EventMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline EventMask operator&(EventMask lhs, EventMask rhs)
  { return static_cast<EventMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline EventMask operator^(EventMask lhs, EventMask rhs)
  { return static_cast<EventMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline EventMask operator~(EventMask flags)
  { return static_cast<EventMask>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline EventMask& operator|=(EventMask& lhs, EventMask rhs)
  { return (lhs = static_cast<EventMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline EventMask& operator&=(EventMask& lhs, EventMask rhs)
  { return (lhs = static_cast<EventMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline EventMask& operator^=(EventMask& lhs, EventMask rhs)
  { return (lhs = static_cast<EventMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::EventMask> : public Glib::Value_Flags<Gdk::EventMask>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var InputMode DISABLED
 * The device is disabled and will not report any events.
 * 
 *  @var InputMode SCREEN
 * The device is enabled. The device’s coordinate space
 * maps to the entire screen.
 * 
 *  @var InputMode WINDOW
 * The device is enabled. The device’s coordinate space
 * is mapped to a single window. The manner in which this window
 * is chosen is undefined, but it will typically be the same
 * way in which the focus window for key events is determined.
 * 
 *  @enum InputMode
 * 
 * An enumeration that describes the mode of an input device.
 *
 * @ingroup gdkmmEnums
 */
enum class InputMode
{
  DISABLED,
  SCREEN,
  WINDOW
};


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::InputMode> : public Glib::Value_Enum<Gdk::InputMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var InputSource MOUSE
 * The device is a mouse. (This will be reported for the core
 * pointer, even if it is something else, such as a trackball.).
 * 
 *  @var InputSource PEN
 * The device is a stylus of a graphics tablet or similar device.
 * 
 *  @var InputSource ERASER
 * The device is an eraser. Typically, this would be the other end
 * of a stylus on a graphics tablet.
 * 
 *  @var InputSource CURSOR
 * The device is a graphics tablet “puck” or similar device.
 * 
 *  @var InputSource KEYBOARD
 * The device is a keyboard.
 * 
 *  @var InputSource TOUCHSCREEN
 * The device is a direct-input touch device, such
 * as a touchscreen or tablet. This device type has been added in 3.4.
 * 
 *  @var InputSource TOUCHPAD
 * The device is an indirect touch device, such
 * as a touchpad. This device type has been added in 3.4.
 * 
 *  @var InputSource TRACKPOINT
 * The device is a trackpoint. This device type has been
 * added in 3.22.
 * 
 *  @var InputSource TABLET_PAD
 * The device is a "pad", a collection of buttons,
 * rings and strips found in drawing tablets. This device type has been
 * added in 3.22.
 * 
 *  @enum InputSource
 * 
 * An enumeration describing the type of an input device in general terms.
 *
 * @ingroup gdkmmEnums
 */
enum class InputSource
{
  MOUSE,
  PEN,
  ERASER,
  CURSOR,
  KEYBOARD,
  TOUCHSCREEN,
  TOUCHPAD,
  TRACKPOINT,
  TABLET_PAD
};


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::InputSource> : public Glib::Value_Enum<Gdk::InputSource>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

//_WRAP_ENUM(GrabOwnership, GdkGrabOwnership)
/** 
 *  @var GrabStatus SUCCESS
 * The resource was successfully grabbed.
 * 
 *  @var GrabStatus ALREADY_GRABBED
 * The resource is actively grabbed by another client.
 * 
 *  @var GrabStatus INVALID_TIME
 * The resource was grabbed more recently than the
 * specified time.
 * 
 *  @var GrabStatus NOT_VIEWABLE
 * The grab window or the @a confine_to window are not
 * viewable.
 * 
 *  @var GrabStatus FROZEN
 * The resource is frozen by an active grab of another client.
 * 
 *  @var GrabStatus FAILED
 * The grab failed for some other reason. @newin{3,16}
 * 
 *  @enum GrabStatus
 * 
 * Returned by Gdk::Device::grab() to indicate success or the reason for the
 * failure of the grab attempt.
 *
 * @ingroup gdkmmEnums
 */
enum class GrabStatus
{
  SUCCESS,
  ALREADY_GRABBED,
  INVALID_TIME,
  NOT_VIEWABLE,
  FROZEN,
  FAILED
};


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::GrabStatus> : public Glib::Value_Enum<Gdk::GrabStatus>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{


class DeviceTool;
class Display;
class Seat;
class Window;

/** A Gdk::Device instance contains a detailed description of an extended input device.
 */

class Device : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Device;
  using CppClassType = Device_Class;
  using BaseObjectType = GdkDevice;
  using BaseClassType = GdkDeviceClass;

  // noncopyable
  Device(const Device&) = delete;
  Device& operator=(const Device&) = delete;

private:  friend class Device_Class;
  static CppClassType device_class_;

protected:
  explicit Device(const Glib::ConstructParams& construct_params);
  explicit Device(GdkDevice* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Device(Device&& src) noexcept;
  Device& operator=(Device&& src) noexcept;

  ~Device() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkDevice*       gobj()       { return reinterpret_cast<GdkDevice*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkDevice* gobj() const { return reinterpret_cast<GdkDevice*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkDevice* gobj_copy();

private:


protected:
  Device();

public:
  /** 
   *  @var Type MASTER
   * Device is a master (or virtual) device. There will
   * be an associated focus indicator on the screen.
   * 
   *  @var Type SLAVE
   * Device is a slave (or physical) device.
   * 
   *  @var Type FLOATING
   * Device is a physical device, currently not attached to
   * any seat.
   * 
   *  @enum Type
   * 
   * Indicates the device type.
   *
   * @ingroup gdkmmEnums
   */
  enum class Type
  {
    MASTER,
    SLAVE,
    FLOATING
  };


  /** Determines the name of the device.
   * 
   * @return A name.
   */
  Glib::ustring get_name() const;
  
  /** Determines whether the pointer follows device motion.
   * This is not meaningful for keyboard devices, which don't have a pointer.
   * 
   * @return <tt>true</tt> if the pointer follows device motion.
   */
  bool get_has_cursor() const;

  
  /** Determines the type of the device.
   * 
   * @return A Gdk::InputSource.
   */
  InputSource get_source() const;
  
  /** Determines the mode of the device.
   * 
   * @return A Gdk::InputSource.
   */
  InputMode get_mode() const;
  
  /** Sets a the mode of an input device. The mode controls if the
   * device is active and whether the device’s range is mapped to the
   * entire screen or to a single window.
   * 
   * @note This is only meaningful for floating devices, master devices (and
   * slaves connected to these) drive the pointer cursor, which is not limited
   * by the input mode.
   * 
   * @param mode The input mode.
   * @return <tt>true</tt> if the mode was successfully changed.
   */
  bool set_mode(InputMode mode);
  
  /** Returns the number of keys the device currently has.
   * 
   * @return The number of keys.
   */
  int get_n_keys() const;
  
  /** If @a index has a valid keyval, this function will return <tt>true</tt>
   * and fill in @a keyval and @a modifiers with the keyval settings.
   * 
   * @param index The index of the macro button to get.
   * @param keyval Return value for the keyval.
   * @param modifiers Return value for modifiers.
   * @return <tt>true</tt> if keyval is set for @a index.
   */
  bool get_key(guint index_, guint& keyval, ModifierType& modifiers) const;
  
  /** Specifies the X key event to generate when a macro button of a device
   * is pressed.
   * 
   * @param index The index of the macro button to set.
   * @param keyval The keyval to generate.
   * @param modifiers The modifiers to set.
   */
  void set_key(guint index_, guint keyval, ModifierType modifiers);
  
  /** Returns the axis use for @a index.
   * 
   * @param index The index of the axis.
   * @return A Gdk::AxisUse specifying how the axis is used.
   */
  AxisUse get_axis_use(guint index_) const;
  
  /** Specifies how an axis of a device is used.
   * 
   * @param index The index of the axis.
   * @param use Specifies how the axis is used.
   */
  void set_axis_use(guint index_, AxisUse use);
  
  /** Gets the current state of a pointer device relative to @a window. As a slave
   * device’s coordinates are those of its master pointer, this
   * function may not be called on devices of type Gdk::Device::Type::SLAVE,
   * unless there is an ongoing grab on them. See grab().
   * 
   * @param window A Gdk::Window.
   * @param axes An array of doubles to store the values of
   * the axes of @a device in, or <tt>nullptr</tt>.
   * @param mask Location to store the modifiers, or <tt>nullptr</tt>.
   */
  void get_state(const Glib::RefPtr<Window>& window, double& axes, ModifierType& mask);

  /** Obtains the motion history for a device.
   * Given a starting and ending timestamp, this will return all events
   * in the motion history for the device in the given range of time.
   * Some windowing systems do not support motion history, in which case, false will be returned.
   * (This is not distinguishable from the case where motion history is supported and no events were found.)
   *
   * @param window The window with respect to which which the event coordinates will be reported.
   * @param start Starting timestamp for range of events to return.
   * @param stop Ending timestamp for the range of events to return.
   * @result A vector of TimeCoord.
   */
  std::vector<TimeCoord> get_history(const Glib::RefPtr<Window>& window, guint32 start, guint32 stop) const;
  

  /** If the device if of type Gdk::Device::Type::MASTER, it will return
   * the list of slave devices attached to it, otherwise it will return
   * <tt>nullptr</tt>
   * 
   * @return The list of slave devices, or <tt>nullptr</tt>.
   */
  std::vector<Glib::RefPtr<Gdk::Device> > list_slave_devices();
  //TODO:_WRAP_METHOD(std::vector<Glib::RefPtr<const Gdk::Device> > list_slave_devices() const, gdk_device_list_slave_devices, constversion)

  
  /** Returns the number of axes the device currently has.
   * 
   * @return The number of axes.
   */
  int get_n_axes() const;

  /** Returns the labels for the axes that the device currently has.
   * @newin{3,4}
   */
  std::vector<std::string> list_axes() const;
  

  //TODO: Use a string instead of a GdkAtom:
  
  /** Interprets an array of double as axis values for a given device,
   * and locates the value in the array for a given axis label, as returned
   * by list_axes()
   * 
   * @param axes Pointer to an array of axes.
   * @param axis_label Name of the label.
   * @param value Location to store the found value.
   * @return <tt>true</tt> if the given axis use was found, otherwise <tt>false</tt>.
   */
  bool get_axis_value(double& axes, GdkAtom axis_label, double& value) const;

  
  /** Interprets an array of double as axis values for a given device,
   * and locates the value in the array for a given axis use.
   * 
   * @param axes Pointer to an array of axes.
   * @param use The use to look for.
   * @param value Location to store the found value.
   * @return <tt>true</tt> if the given axis use was found, otherwise <tt>false</tt>.
   */
  bool get_axis(double& axes, AxisUse use, double& value) const;

  
  /** Returns the Gdk::Display to which @a device pertains.
   * 
   * @return A Gdk::Display. This memory is owned
   * by GTK+, and must not be freed or unreffed.
   */
  Glib::RefPtr<Display> get_display();
  
  /** Returns the Gdk::Display to which @a device pertains.
   * 
   * @return A Gdk::Display. This memory is owned
   * by GTK+, and must not be freed or unreffed.
   */
  Glib::RefPtr<const Display> get_display() const;

  
  /** Returns the associated device to @a device, if @a device is of type
   * Gdk::Device::Type::MASTER, it will return the paired pointer or
   * keyboard.
   * 
   * If @a device is of type Gdk::Device::Type::SLAVE, it will return
   * the master device to which @a device is attached to.
   * 
   * If @a device is of type Gdk::Device::Type::FLOATING, <tt>nullptr</tt> will be
   * returned, as there is no associated device.
   * 
   * @return The associated device, or
   * <tt>nullptr</tt>.
   */
  Glib::RefPtr<Device> get_associated_device();
  
  /** Returns the associated device to @a device, if @a device is of type
   * Gdk::Device::Type::MASTER, it will return the paired pointer or
   * keyboard.
   * 
   * If @a device is of type Gdk::Device::Type::SLAVE, it will return
   * the master device to which @a device is attached to.
   * 
   * If @a device is of type Gdk::Device::Type::FLOATING, <tt>nullptr</tt> will be
   * returned, as there is no associated device.
   * 
   * @return The associated device, or
   * <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Device> get_associated_device() const;

  
  /** Returns the device type for @a device.
   * 
   * @return The Gdk::Device::Type for @a device.
   */
  Type get_device_type() const;

   
  /** Warps @a device in @a display to the point @a x, @a y,
   * unless the device is confined to a window by a grab,
   * in which case it will be moved
   * as far as allowed by the grab. Warping the pointer
   * creates events as if the user had moved the mouse
   * instantaneously to the destination.
   * 
   * Note that the pointer should normally be under the
   * control of the user. This function was added to cover
   * some rare use cases like keyboard navigation support
   * for the color picker in the Gtk::ColorSelectionDialog.
   * 
   * @param x The X coordinate of the destination.
   * @param y The Y coordinate of the destination.
   */
  void warp(int x, int y);

  /** Gets the current location of the device.
   * As a slave device coordinates are those of its master pointer,
   * this function may not be called on devices of type Gdk::Device::Type::SLAVE,
   * unless there is an ongoing grab on them. See grab().
   *
   * @param[out] x This will contain the root window X coordinate of the device.
   * @param[out] y This will contain the root window X coordinate of the device.
   */
  void get_position(int& x, int& y) const;
  

  /** Gets the current location of the device in double precision.
   * As a slave device coordinates are those of its master pointer,
   * this function may not be called on devices of type Gdk::Device::Type::SLAVE,
   * unless there is an ongoing grab on them. See grab().
   *
   * @param[out] x This will contain the root window X coordinate of the device.
   * @param[out] y This will contain the root window X coordinate of the device.
   *
   * @newin{3,10}
   */
  void get_position(double& x, double& y) const;
  

  /** Obtains the window underneath @a device, returning the location of the device in @a win_x and @a win_y. Returns
   * <tt>nullptr</tt> if the window tree under @a device is not known to GDK (for example, belongs to another application).
   * 
   * As a slave device coordinates are those of its master pointer, This
   * function may not be called on devices of type Gdk::Device::Type::SLAVE,
   * unless there is an ongoing grab on them, see grab().
   * 
   * @param win_x Return location for the X coordinate of the device location,
   * relative to the window origin, or <tt>nullptr</tt>.
   * @param win_y Return location for the Y coordinate of the device location,
   * relative to the window origin, or <tt>nullptr</tt>.
   * @return The Gdk::Window under the
   * device position, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<Window> get_window_at_position(int& win_x, int& win_y);
  
  /** Obtains the window underneath @a device, returning the location of the device in @a win_x and @a win_y. Returns
   * <tt>nullptr</tt> if the window tree under @a device is not known to GDK (for example, belongs to another application).
   * 
   * As a slave device coordinates are those of its master pointer, This
   * function may not be called on devices of type Gdk::Device::Type::SLAVE,
   * unless there is an ongoing grab on them, see grab().
   * 
   * @param win_x Return location for the X coordinate of the device location,
   * relative to the window origin, or <tt>nullptr</tt>.
   * @param win_y Return location for the Y coordinate of the device location,
   * relative to the window origin, or <tt>nullptr</tt>.
   * @return The Gdk::Window under the
   * device position, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Window> get_window_at_position(int& win_x, int& win_y) const;

  //TODO: Would this be ambiguous? Test it.
  //_WRAP_METHOD(Glib::RefPtr<Window> get_window_at_position(double& win_x, double& win_y), gdk_device_get_window_at_position_double, refreturn)
  //_WRAP_METHOD(Glib::RefPtr<const Window> get_window_at_position(double& win_x, double& win_y) const, gdk_device_get_window_at_position_double, refreturn, constversion)

  /** Obtains the window underneath the device.
   * Returns an empty RefPtr if the window tree under the device is not known to GDK (for example, belongs to another application).
   *
   * As a slave device coordinates are those of its master pointer, This
   * function may not be called on devices of type Gdk::Device::Type::SLAVE,
   * unless there is an ongoing grab on them. See grab().
   *
   * @newin{3,0}
   *
   * @return The Gdk::Window under the device position.
   */
  Glib::RefPtr<Window> get_window_at_position();

  /** Obtains the window underneath the device.
   * Returns an empty RefPtr if the window tree under the device is not known to GDK (for example, belongs to another application).
   *
   * As a slave device coordinates are those of its master pointer, This
   * function may not be called on devices of type Gdk::Device::Type::SLAVE,
   * unless there is an ongoing grab on them. See grab().
   *
   * @newin{3,0}
   *
   * @return The Gdk::Window under the device position.
   */
  Glib::RefPtr<const Window> get_window_at_position() const;

  
  /** Gets information about which window the given pointer device is in, based on events
   * that have been received so far from the display server. If another application
   * has a pointer grab, or this application has a grab with owner_events = <tt>false</tt>,
   * <tt>nullptr</tt> may be returned even if the pointer is physically over one of this
   * application's windows.
   * 
   * @return The last window the device.
   */
  Glib::RefPtr<Window> get_last_event_window();
  
  /** Gets information about which window the given pointer device is in, based on events
   * that have been received so far from the display server. If another application
   * has a pointer grab, or this application has a grab with owner_events = <tt>false</tt>,
   * <tt>nullptr</tt> may be returned even if the pointer is physically over one of this
   * application's windows.
   * 
   * @return The last window the device.
   */
  Glib::RefPtr<const Window> get_last_event_window() const;

  
  /** Returns the vendor ID of this device, or <tt>nullptr</tt> if this information couldn't
   * be obtained. This ID is retrieved from the device, and is thus constant for
   * it.
   * 
   * This function, together with get_product_id(), can be used to eg.
   * compose Gio::Settings paths to store settings for this device.
   * 
   * 
   * [C example ellipted]
   * 
   * @return The vendor ID, or <tt>nullptr</tt>.
   */
  Glib::ustring get_vendor_id() const;
  
  /** Returns the product ID of this device, or <tt>nullptr</tt> if this information couldn't
   * be obtained. This ID is retrieved from the device, and is thus constant for
   * it. See get_vendor_id() for more information.
   * 
   * @return The product ID, or <tt>nullptr</tt>.
   */
  Glib::ustring get_product_id();

  
  /** Returns the Gdk::Seat the device belongs to.
   * 
   * @return A Gdk::Seat. This memory is owned by GTK+ and
   * must not be freed.
   */
  Glib::RefPtr<Seat> get_seat();
  
  /** Returns the Gdk::Seat the device belongs to.
   * 
   * @return A Gdk::Seat. This memory is owned by GTK+ and
   * must not be freed.
   */
  Glib::RefPtr<const Seat> get_seat() const;

  
  /** Returns the axes currently available on the device.
   */
  AxisFlags get_axes() const;

  // We use no_default_handler because _GdkDeviceClass is private.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%changed()</tt>
   *
   * Flags: Run Last
   *
   * The signal_changed() signal is emitted either when the Gdk::Device
   * has changed the number of either axes or keys. For example
   * In X this will normally happen when the slave device routing
   * events through the master device changes (for example, user
   * switches from the USB mouse to a tablet), in that case the
   * master device will change to reflect the new slave device
   * axes and keys.
   * 
   * @newin{3,22}
   */

  Glib::SignalProxy<void()> signal_changed();

 
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%tool_changed(const Glib::RefPtr<DeviceTool>& tool)</tt>
   *
   * Flags: Run Last
   *
   * The signal_tool_changed() signal is emitted on pen/eraser
   * Gdk::Devices whenever tools enter or leave proximity.
   * 
   * @newin{3,94}
   * 
   * @param tool The new current tool.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<DeviceTool>&)> signal_tool_changed();


  /** The Gdk::Display the Gdk::Device pertains to.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> > property_display() const;


  /** The device name.
   * 
   * @newin{3,22}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_name() const;


  /** Device role in the device manager.
   * 
   * @newin{3,22}
   *
   * Default value: Gdk::Device::Type::MASTER
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Type > property_type() const;


  /** Associated pointer or keyboard with this device, if any. Devices of type Gdk::Device::Type::MASTER
   * always come in keyboard/pointer pairs. Other device types will have a <tt>nullptr</tt> associated device.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Device> > property_associated_device() const;


  /** Source type for the device.
   * 
   * @newin{3,22}
   *
   * Default value: Gdk::InputSource::MOUSE
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< InputSource > property_input_source() const;


  /** Input mode for the device.
   *
   * @newin{3,22}
   *
   * Default value: Gdk::InputMode::DISABLED
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< InputMode > property_input_mode() ;

/** Input mode for the device.
   *
   * @newin{3,22}
   *
   * Default value: Gdk::InputMode::DISABLED
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< InputMode > property_input_mode() const;

  /** Whether the device is represented by a cursor on the screen. Devices of type
   * Gdk::Device::Type::MASTER will have <tt>true</tt> here.
   * 
   * @newin{3,22}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_cursor() const;


  /** Number of axes in the device.
   * 
   * @newin{3,22}
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_n_axes() const;


  /** Vendor ID of this device, see Gdk::Device::get_vendor_id().
   * 
   * @newin{3,22}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_vendor_id() const;


  /** Product ID of this device, see Gdk::Device::get_product_id().
   * 
   * @newin{3,22}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_product_id() const;


  /** Gdk::Seat of this device.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Seat> > property_seat() ;

/** Gdk::Seat of this device.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Seat> > property_seat() const;

  /** The maximal number of concurrent touches on a touch device.
   * Will be 0 if the device is not a touch device or if the number
   * of touches is unknown.
   * 
   * @newin{3,22}
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_num_touches() const;


  /** The axes currently available for this device.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< AxisFlags > property_axes() const;


  /** The tool that is currently used with this device.
   *
   * @newin{3,94}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DeviceTool> > property_tool() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Device::Type> : public Glib::Value_Enum<Gdk::Device::Type>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Device
   */
  Glib::RefPtr<Gdk::Device> wrap(GdkDevice* object, bool take_copy = false);
}


#endif /* _GDKMM_DEVICE_H */

