/* timsort.c generated by valac, the Vala compiler
 * generated from timsort.vala, do not modify */

/* timsort.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */


#include <glib.h>
#include <glib-object.h>
#include "valagee.h"
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_TIM_SORT (vala_tim_sort_get_type ())
#define VALA_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TIM_SORT, ValaTimSort))
#define VALA_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TIM_SORT, ValaTimSortClass))
#define VALA_IS_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TIM_SORT))
#define VALA_IS_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TIM_SORT))
#define VALA_TIM_SORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TIM_SORT, ValaTimSortClass))

typedef struct _ValaTimSort ValaTimSort;
typedef struct _ValaTimSortClass ValaTimSortClass;
typedef struct _ValaTimSortPrivate ValaTimSortPrivate;
typedef struct _ValaTimSortSlice ValaTimSortSlice;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
#define _vala_tim_sort_unref0(var) ((var == NULL) ? NULL : (var = (vala_tim_sort_unref (var), NULL)))
#define _vala_tim_sort_slice_free0(var) ((var == NULL) ? NULL : (var = (vala_tim_sort_slice_free (var), NULL)))
typedef struct _ValaParamSpecTimSort ValaParamSpecTimSort;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaTimSort {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaTimSortPrivate * priv;
};

struct _ValaTimSortClass {
	GTypeClass parent_class;
	void (*finalize) (ValaTimSort *self);
};

struct _ValaTimSortPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	ValaList* list_collection;
	gpointer* array;
	gint array_length1;
	gint _array_size_;
	void** list;
	gint index;
	gint size;
	ValaTimSortSlice** pending;
	gint pending_length1;
	gint _pending_size_;
	gint minimum_gallop;
	GCompareDataFunc compare;
	gpointer compare_target;
};

struct _ValaTimSortSlice {
	void** list;
	void** new_list;
	gint index;
	gint length;
};

typedef gboolean (*ValaTimSortLowerFunc) (gconstpointer left, gconstpointer right, gpointer user_data);
struct _ValaParamSpecTimSort {
	GParamSpec parent_instance;
};


static gint ValaTimSort_private_offset;
static gpointer vala_tim_sort_parent_class = NULL;

G_GNUC_INTERNAL gpointer vala_tim_sort_ref (gpointer instance);
G_GNUC_INTERNAL void vala_tim_sort_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_tim_sort (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_tim_sort (GValue* value,
                              gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_tim_sort (GValue* value,
                               gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_tim_sort (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_tim_sort_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_tim_sort_slice_free (ValaTimSortSlice * self);
#define VALA_TIM_SORT_MINIMUM_GALLOP 7
G_GNUC_INTERNAL void vala_tim_sort_sort (GType g_type,
                         GBoxedCopyFunc g_dup_func,
                         GDestroyNotify g_destroy_func,
                         ValaList* list,
                         GCompareDataFunc compare,
                         gpointer compare_target);
static void vala_tim_sort_sort_arraylist (GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   ValaArrayList* list,
                                   GCompareDataFunc compare,
                                   gpointer compare_target);
static void vala_tim_sort_sort_list (GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func,
                              ValaList* list,
                              GCompareDataFunc compare,
                              gpointer compare_target);
G_GNUC_INTERNAL ValaTimSort* vala_tim_sort_new (GType g_type,
                                GBoxedCopyFunc g_dup_func,
                                GDestroyNotify g_destroy_func);
G_GNUC_INTERNAL ValaTimSort* vala_tim_sort_construct (GType object_type,
                                      GType g_type,
                                      GBoxedCopyFunc g_dup_func,
                                      GDestroyNotify g_destroy_func);
static void vala_tim_sort_do_sort (ValaTimSort* self);
static ValaTimSortSlice* vala_tim_sort_slice_new (void** list,
                                           gint index,
                                           gint length);
static gint vala_tim_sort_compute_minimum_run_length (ValaTimSort* self,
                                               gint length);
static ValaTimSortSlice* vala_tim_sort_compute_longest_run (ValaTimSort* self,
                                                     ValaTimSortSlice* a,
                                                     gboolean* descending);
static void vala_tim_sort_slice_reverse (ValaTimSortSlice* self);
static void vala_tim_sort_insertion_sort (ValaTimSort* self,
                                   ValaTimSortSlice* a,
                                   gint offset);
static inline void vala_tim_sort_slice_shorten_start (ValaTimSortSlice* self,
                                        gint n);
static void _vala_array_add1 (ValaTimSortSlice** * array,
                       int* length,
                       int* size,
                       ValaTimSortSlice* value);
static void vala_tim_sort_merge_collapse (ValaTimSort* self);
static void vala_tim_sort_merge_force_collapse (ValaTimSort* self);
static inline gboolean vala_tim_sort_lower_than (ValaTimSort* self,
                                   gconstpointer left,
                                   gconstpointer right);
static inline gboolean vala_tim_sort_lower_than_or_equal_to (ValaTimSort* self,
                                               gconstpointer left,
                                               gconstpointer right);
static void vala_tim_sort_merge_at (ValaTimSort* self,
                             gint index);
static gint vala_tim_sort_gallop_rightmost (ValaTimSort* self,
                                     gconstpointer key,
                                     ValaTimSortSlice* a,
                                     gint hint);
static inline void* vala_tim_sort_slice_peek_first (ValaTimSortSlice* self);
static gint vala_tim_sort_gallop_leftmost (ValaTimSort* self,
                                    gconstpointer key,
                                    ValaTimSortSlice* a,
                                    gint hint);
static inline void* vala_tim_sort_slice_peek_last (ValaTimSortSlice* self);
static void vala_tim_sort_merge_low (ValaTimSort* self,
                              ValaTimSortSlice* a,
                              ValaTimSortSlice* b);
static void vala_tim_sort_merge_high (ValaTimSort* self,
                               ValaTimSortSlice* a,
                               ValaTimSortSlice* b);
static void vala_tim_sort_slice_copy (ValaTimSortSlice* self);
static inline void* vala_tim_sort_slice_pop_first (ValaTimSortSlice* self);
static inline void vala_tim_sort_slice_merge_in (ValaTimSortSlice* self,
                                   void** dest_array,
                                   gint index,
                                   gint dest_index,
                                   gint count);
static inline void* vala_tim_sort_slice_pop_last (ValaTimSortSlice* self);
static inline void vala_tim_sort_slice_merge_in_reversed (ValaTimSortSlice* self,
                                            void** dest_array,
                                            gint index,
                                            gint dest_index,
                                            gint count);
static inline void vala_tim_sort_slice_shorten_end (ValaTimSortSlice* self,
                                      gint n);
static void vala_tim_sort_slice_instance_init (ValaTimSortSlice * self);
static inline void vala_tim_sort_slice_swap (ValaTimSortSlice* self,
                               gint i,
                               gint j);
static void vala_tim_sort_finalize (ValaTimSort * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array,
                       gsize element_size,
                       gint src,
                       gint dest,
                       gint length);


static inline gpointer
vala_tim_sort_get_instance_private (ValaTimSort* self)
{
	return G_STRUCT_MEMBER_P (self, ValaTimSort_private_offset);
}


G_GNUC_INTERNAL void
vala_tim_sort_sort (GType g_type,
                    GBoxedCopyFunc g_dup_func,
                    GDestroyNotify g_destroy_func,
                    ValaList* list,
                    GCompareDataFunc compare,
                    gpointer compare_target)
{
	g_return_if_fail (list != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (list, VALA_TYPE_ARRAY_LIST)) {
		vala_tim_sort_sort_arraylist (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, G_TYPE_CHECK_INSTANCE_CAST (list, VALA_TYPE_ARRAY_LIST, ValaArrayList), compare, compare_target);
	} else {
		vala_tim_sort_sort_list (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, list, compare, compare_target);
	}
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static void
vala_tim_sort_sort_list (GType g_type,
                         GBoxedCopyFunc g_dup_func,
                         GDestroyNotify g_destroy_func,
                         ValaList* list,
                         GCompareDataFunc compare,
                         gpointer compare_target)
{
	ValaTimSort* helper = NULL;
	ValaTimSort* _tmp0_;
	ValaTimSort* _tmp1_;
	ValaList* _tmp2_;
	ValaTimSort* _tmp3_;
	gint _tmp4_;
	gpointer* _tmp5_;
	ValaTimSort* _tmp6_;
	ValaTimSort* _tmp7_;
	gpointer* _tmp8_;
	gint _tmp8__length1;
	ValaTimSort* _tmp9_;
	ValaTimSort* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	ValaTimSort* _tmp13_;
	ValaTimSort* _tmp14_;
	ValaTimSort* _tmp15_;
	gpointer* _tmp16_;
	gint _tmp16__length1;
	g_return_if_fail (list != NULL);
	_tmp0_ = vala_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	helper = _tmp0_;
	_tmp1_ = helper;
	_tmp2_ = _vala_iterable_ref0 (list);
	_vala_iterable_unref0 (_tmp1_->priv->list_collection);
	_tmp1_->priv->list_collection = _tmp2_;
	_tmp3_ = helper;
	_tmp5_ = vala_collection_to_array ((ValaCollection*) list, &_tmp4_);
	_tmp3_->priv->array = (_vala_array_free (_tmp3_->priv->array, _tmp3_->priv->array_length1, (GDestroyNotify) g_destroy_func), NULL);
	_tmp3_->priv->array = _tmp5_;
	_tmp3_->priv->array_length1 = _tmp4_;
	_tmp3_->priv->_array_size_ = _tmp3_->priv->array_length1;
	_tmp6_ = helper;
	_tmp7_ = helper;
	_tmp8_ = _tmp7_->priv->array;
	_tmp8__length1 = _tmp7_->priv->array_length1;
	_tmp6_->priv->list = _tmp8_;
	_tmp9_ = helper;
	_tmp9_->priv->index = 0;
	_tmp10_ = helper;
	_tmp11_ = vala_collection_get_size ((ValaCollection*) list);
	_tmp12_ = _tmp11_;
	_tmp10_->priv->size = _tmp12_;
	_tmp13_ = helper;
	_tmp13_->priv->compare = compare;
	_tmp13_->priv->compare_target = compare_target;
	_tmp14_ = helper;
	vala_tim_sort_do_sort (_tmp14_);
	vala_collection_clear ((ValaCollection*) list);
	_tmp15_ = helper;
	_tmp16_ = _tmp15_->priv->array;
	_tmp16__length1 = _tmp15_->priv->array_length1;
	{
		gpointer* item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp16_;
		item_collection_length1 = _tmp16__length1;
		for (item_it = 0; item_it < _tmp16__length1; item_it = item_it + 1) {
			gpointer _tmp17_;
			gpointer item = NULL;
			_tmp17_ = ((item_collection[item_it] != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) item_collection[item_it]) : ((gpointer) item_collection[item_it]);
			item = _tmp17_;
			{
				gconstpointer _tmp18_;
				_tmp18_ = item;
				vala_collection_add ((ValaCollection*) list, _tmp18_);
				_g_destroy_func0 (item);
			}
		}
	}
	_vala_tim_sort_unref0 (helper);
}


static void
vala_tim_sort_sort_arraylist (GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func,
                              ValaArrayList* list,
                              GCompareDataFunc compare,
                              gpointer compare_target)
{
	ValaTimSort* helper = NULL;
	ValaTimSort* _tmp0_;
	ValaList* _tmp1_;
	gpointer* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	g_return_if_fail (list != NULL);
	_tmp0_ = vala_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	helper = _tmp0_;
	_tmp1_ = _vala_iterable_ref0 ((ValaList*) list);
	_vala_iterable_unref0 (helper->priv->list_collection);
	helper->priv->list_collection = _tmp1_;
	_tmp2_ = list->_items;
	_tmp2__length1 = list->_items_length1;
	helper->priv->list = _tmp2_;
	helper->priv->index = 0;
	_tmp3_ = list->_size;
	helper->priv->size = _tmp3_;
	helper->priv->compare = compare;
	helper->priv->compare_target = compare_target;
	vala_tim_sort_do_sort (helper);
	_vala_tim_sort_unref0 (helper);
}


static void
_vala_array_add1 (ValaTimSortSlice** * array,
                  int* length,
                  int* size,
                  ValaTimSortSlice* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaTimSortSlice*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
vala_tim_sort_do_sort (ValaTimSort* self)
{
	gint _tmp0_;
	ValaTimSortSlice** _tmp1_;
	ValaTimSortSlice* remaining = NULL;
	void** _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValaTimSortSlice* _tmp5_;
	gint minimum_length = 0;
	ValaTimSortSlice* _tmp6_;
	gint _tmp7_;
	ValaTimSortSlice* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	ValaTimSortSlice** _tmp34_;
	gint _tmp34__length1;
	ValaTimSortSlice** _tmp35_;
	gint _tmp35__length1;
	ValaTimSortSlice* _tmp36_;
	gint _tmp37_;
	ValaTimSortSlice** _tmp38_;
	gint _tmp38__length1;
	ValaTimSortSlice* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->size;
	if (_tmp0_ < 2) {
		return;
	}
	_tmp1_ = g_new0 (ValaTimSortSlice*, 0 + 1);
	self->priv->pending = (_vala_array_free (self->priv->pending, self->priv->pending_length1, (GDestroyNotify) vala_tim_sort_slice_free), NULL);
	self->priv->pending = _tmp1_;
	self->priv->pending_length1 = 0;
	self->priv->_pending_size_ = self->priv->pending_length1;
	self->priv->minimum_gallop = VALA_TIM_SORT_MINIMUM_GALLOP;
	_tmp2_ = self->priv->list;
	_tmp3_ = self->priv->index;
	_tmp4_ = self->priv->size;
	_tmp5_ = vala_tim_sort_slice_new (_tmp2_, _tmp3_, _tmp4_);
	remaining = _tmp5_;
	_tmp6_ = remaining;
	_tmp7_ = _tmp6_->length;
	minimum_length = vala_tim_sort_compute_minimum_run_length (self, _tmp7_);
	while (TRUE) {
		ValaTimSortSlice* _tmp8_;
		gint _tmp9_;
		gboolean descending = FALSE;
		ValaTimSortSlice* run = NULL;
		ValaTimSortSlice* _tmp10_;
		gboolean _tmp11_ = FALSE;
		ValaTimSortSlice* _tmp12_;
		gboolean _tmp13_;
		ValaTimSortSlice* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		ValaTimSortSlice* _tmp26_;
		ValaTimSortSlice* _tmp27_;
		gint _tmp28_;
		ValaTimSortSlice** _tmp29_;
		gint _tmp29__length1;
		ValaTimSortSlice* _tmp30_;
		_tmp8_ = remaining;
		_tmp9_ = _tmp8_->length;
		if (!(_tmp9_ > 0)) {
			break;
		}
		_tmp10_ = remaining;
		_tmp12_ = vala_tim_sort_compute_longest_run (self, _tmp10_, &_tmp11_);
		descending = _tmp11_;
		run = _tmp12_;
		_tmp13_ = descending;
		if (_tmp13_) {
			ValaTimSortSlice* _tmp14_;
			_tmp14_ = run;
			vala_tim_sort_slice_reverse (_tmp14_);
		}
		_tmp15_ = run;
		_tmp16_ = _tmp15_->length;
		_tmp17_ = minimum_length;
		if (_tmp16_ < _tmp17_) {
			gint sorted_count = 0;
			ValaTimSortSlice* _tmp18_;
			gint _tmp19_;
			ValaTimSortSlice* _tmp20_;
			gint _tmp21_;
			ValaTimSortSlice* _tmp22_;
			gint _tmp23_;
			ValaTimSortSlice* _tmp24_;
			gint _tmp25_;
			_tmp18_ = run;
			_tmp19_ = _tmp18_->length;
			sorted_count = _tmp19_;
			_tmp20_ = run;
			_tmp21_ = minimum_length;
			_tmp22_ = remaining;
			_tmp23_ = _tmp22_->length;
			_tmp20_->length = MIN (_tmp21_, _tmp23_);
			_tmp24_ = run;
			_tmp25_ = sorted_count;
			vala_tim_sort_insertion_sort (self, _tmp24_, _tmp25_);
		}
		_tmp26_ = remaining;
		_tmp27_ = run;
		_tmp28_ = _tmp27_->length;
		vala_tim_sort_slice_shorten_start (_tmp26_, _tmp28_);
		_tmp29_ = self->priv->pending;
		_tmp29__length1 = self->priv->pending_length1;
		_tmp30_ = run;
		run = NULL;
		_vala_array_add1 (&self->priv->pending, &self->priv->pending_length1, &self->priv->_pending_size_, _tmp30_);
		vala_tim_sort_merge_collapse (self);
		_vala_tim_sort_slice_free0 (run);
	}
	_tmp31_ = remaining;
	_tmp32_ = _tmp31_->index;
	_tmp33_ = self->priv->size;
	_vala_assert (_tmp32_ == _tmp33_, "remaining.index == size");
	vala_tim_sort_merge_force_collapse (self);
	_tmp34_ = self->priv->pending;
	_tmp34__length1 = self->priv->pending_length1;
	_vala_assert (_tmp34__length1 == 1, "pending.length == 1");
	_tmp35_ = self->priv->pending;
	_tmp35__length1 = self->priv->pending_length1;
	_tmp36_ = _tmp35_[0];
	_tmp37_ = _tmp36_->index;
	_vala_assert (_tmp37_ == 0, "pending[0].index == 0");
	_tmp38_ = self->priv->pending;
	_tmp38__length1 = self->priv->pending_length1;
	_tmp39_ = _tmp38_[0];
	_tmp40_ = _tmp39_->length;
	_tmp41_ = self->priv->size;
	_vala_assert (_tmp40_ == _tmp41_, "pending[0].length == size");
	_vala_tim_sort_slice_free0 (remaining);
}


static inline gboolean
vala_tim_sort_lower_than (ValaTimSort* self,
                          gconstpointer left,
                          gconstpointer right)
{
	gboolean result = FALSE;
	GCompareDataFunc _tmp0_;
	void* _tmp0__target;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->compare;
	_tmp0__target = self->priv->compare_target;
	result = _tmp0_ (left, right, _tmp0__target) < 0;
	return result;
}


static inline gboolean
vala_tim_sort_lower_than_or_equal_to (ValaTimSort* self,
                                      gconstpointer left,
                                      gconstpointer right)
{
	gboolean result = FALSE;
	GCompareDataFunc _tmp0_;
	void* _tmp0__target;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->compare;
	_tmp0__target = self->priv->compare_target;
	result = _tmp0_ (left, right, _tmp0__target) <= 0;
	return result;
}


static gint
vala_tim_sort_compute_minimum_run_length (ValaTimSort* self,
                                          gint length)
{
	gint result = 0;
	gint run_length = 0;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	run_length = 0;
	while (TRUE) {
		gint _tmp0_;
		if (!(length >= 64)) {
			break;
		}
		_tmp0_ = run_length;
		run_length = _tmp0_ | (length & 1);
		length = length >> 1;
	}
	_tmp1_ = run_length;
	result = length + _tmp1_;
	return result;
}


static ValaTimSortSlice*
vala_tim_sort_compute_longest_run (ValaTimSort* self,
                                   ValaTimSortSlice* a,
                                   gboolean* descending)
{
	gboolean _vala_descending = FALSE;
	ValaTimSortSlice* result = NULL;
	gint run_length = 0;
	gint _tmp0_;
	void** _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	ValaTimSortSlice* _tmp37_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (a != NULL, NULL);
	_tmp0_ = a->length;
	if (_tmp0_ <= 1) {
		gint _tmp1_;
		_tmp1_ = a->length;
		run_length = _tmp1_;
		_vala_descending = FALSE;
	} else {
		void** _tmp2_;
		gint _tmp3_;
		void* _tmp4_;
		void** _tmp5_;
		gint _tmp6_;
		void* _tmp7_;
		run_length = 2;
		_tmp2_ = a->list;
		_tmp3_ = a->index;
		_tmp4_ = _tmp2_[_tmp3_ + 1];
		_tmp5_ = a->list;
		_tmp6_ = a->index;
		_tmp7_ = _tmp5_[_tmp6_];
		if (vala_tim_sort_lower_than (self, _tmp4_, _tmp7_)) {
			_vala_descending = TRUE;
			{
				gint i = 0;
				gint _tmp8_;
				_tmp8_ = a->index;
				i = _tmp8_ + 2;
				{
					gboolean _tmp9_ = FALSE;
					_tmp9_ = TRUE;
					while (TRUE) {
						gint _tmp11_;
						gint _tmp12_;
						gint _tmp13_;
						void** _tmp14_;
						gint _tmp15_;
						void* _tmp16_;
						void** _tmp17_;
						gint _tmp18_;
						void* _tmp19_;
						if (!_tmp9_) {
							gint _tmp10_;
							_tmp10_ = i;
							i = _tmp10_ + 1;
						}
						_tmp9_ = FALSE;
						_tmp11_ = i;
						_tmp12_ = a->index;
						_tmp13_ = a->length;
						if (!(_tmp11_ < (_tmp12_ + _tmp13_))) {
							break;
						}
						_tmp14_ = a->list;
						_tmp15_ = i;
						_tmp16_ = _tmp14_[_tmp15_];
						_tmp17_ = a->list;
						_tmp18_ = i;
						_tmp19_ = _tmp17_[_tmp18_ - 1];
						if (vala_tim_sort_lower_than (self, _tmp16_, _tmp19_)) {
							gint _tmp20_;
							_tmp20_ = run_length;
							run_length = _tmp20_ + 1;
						} else {
							break;
						}
					}
				}
			}
		} else {
			_vala_descending = FALSE;
			{
				gint i = 0;
				gint _tmp21_;
				_tmp21_ = a->index;
				i = _tmp21_ + 2;
				{
					gboolean _tmp22_ = FALSE;
					_tmp22_ = TRUE;
					while (TRUE) {
						gint _tmp24_;
						gint _tmp25_;
						gint _tmp26_;
						void** _tmp27_;
						gint _tmp28_;
						void* _tmp29_;
						void** _tmp30_;
						gint _tmp31_;
						void* _tmp32_;
						if (!_tmp22_) {
							gint _tmp23_;
							_tmp23_ = i;
							i = _tmp23_ + 1;
						}
						_tmp22_ = FALSE;
						_tmp24_ = i;
						_tmp25_ = a->index;
						_tmp26_ = a->length;
						if (!(_tmp24_ < (_tmp25_ + _tmp26_))) {
							break;
						}
						_tmp27_ = a->list;
						_tmp28_ = i;
						_tmp29_ = _tmp27_[_tmp28_];
						_tmp30_ = a->list;
						_tmp31_ = i;
						_tmp32_ = _tmp30_[_tmp31_ - 1];
						if (vala_tim_sort_lower_than (self, _tmp29_, _tmp32_)) {
							break;
						} else {
							gint _tmp33_;
							_tmp33_ = run_length;
							run_length = _tmp33_ + 1;
						}
					}
				}
			}
		}
	}
	_tmp34_ = a->list;
	_tmp35_ = a->index;
	_tmp36_ = run_length;
	_tmp37_ = vala_tim_sort_slice_new (_tmp34_, _tmp35_, _tmp36_);
	result = _tmp37_;
	if (descending) {
		*descending = _vala_descending;
	}
	return result;
}


static void
vala_tim_sort_insertion_sort (ValaTimSort* self,
                              ValaTimSortSlice* a,
                              gint offset)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	{
		gint start = 0;
		gint _tmp0_;
		_tmp0_ = a->index;
		start = _tmp0_ + offset;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gint left = 0;
				gint _tmp6_;
				gint right = 0;
				gint _tmp7_;
				void* pivot = NULL;
				void** _tmp8_;
				gint _tmp9_;
				void* _tmp10_;
				gint _tmp22_;
				gint _tmp23_;
				void** _tmp24_;
				gint _tmp25_;
				void** _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				void** _tmp30_;
				gint _tmp31_;
				void* _tmp32_;
				void* _tmp33_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = start;
					start = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = start;
				_tmp4_ = a->index;
				_tmp5_ = a->length;
				if (!(_tmp3_ < (_tmp4_ + _tmp5_))) {
					break;
				}
				_tmp6_ = a->index;
				left = _tmp6_;
				_tmp7_ = start;
				right = _tmp7_;
				_tmp8_ = a->list;
				_tmp9_ = right;
				_tmp10_ = _tmp8_[_tmp9_];
				pivot = _tmp10_;
				while (TRUE) {
					gint _tmp11_;
					gint _tmp12_;
					gint p = 0;
					gint _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					void* _tmp16_;
					void** _tmp17_;
					gint _tmp18_;
					void* _tmp19_;
					_tmp11_ = left;
					_tmp12_ = right;
					if (!(_tmp11_ < _tmp12_)) {
						break;
					}
					_tmp13_ = left;
					_tmp14_ = right;
					_tmp15_ = left;
					p = _tmp13_ + ((_tmp14_ - _tmp15_) >> 1);
					_tmp16_ = pivot;
					_tmp17_ = a->list;
					_tmp18_ = p;
					_tmp19_ = _tmp17_[_tmp18_];
					if (vala_tim_sort_lower_than (self, _tmp16_, _tmp19_)) {
						gint _tmp20_;
						_tmp20_ = p;
						right = _tmp20_;
					} else {
						gint _tmp21_;
						_tmp21_ = p;
						left = _tmp21_ + 1;
					}
				}
				_tmp22_ = left;
				_tmp23_ = right;
				_vala_assert (_tmp22_ == _tmp23_, "left == right");
				_tmp24_ = a->list;
				_tmp25_ = left;
				_tmp26_ = a->list;
				_tmp27_ = left;
				_tmp28_ = start;
				_tmp29_ = left;
				g_memmove (&_tmp24_[_tmp25_ + 1], &_tmp26_[_tmp27_], (gsize) (sizeof (gpointer) * (_tmp28_ - _tmp29_)));
				_tmp30_ = a->list;
				_tmp31_ = left;
				_tmp32_ = pivot;
				_tmp30_[_tmp31_] = _tmp32_;
				_tmp33_ = _tmp30_[_tmp31_];
			}
		}
	}
}


static void
vala_tim_sort_merge_collapse (ValaTimSort* self)
{
	gint count = 0;
	ValaTimSortSlice** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	count = _tmp0__length1;
	while (TRUE) {
		gint _tmp1_;
		gboolean _tmp2_ = FALSE;
		gint _tmp3_;
		ValaTimSortSlice** _tmp35_;
		gint _tmp35__length1;
		_tmp1_ = count;
		if (!(_tmp1_ > 1)) {
			break;
		}
		_tmp3_ = count;
		if (_tmp3_ >= 3) {
			ValaTimSortSlice** _tmp4_;
			gint _tmp4__length1;
			gint _tmp5_;
			ValaTimSortSlice* _tmp6_;
			gint _tmp7_;
			ValaTimSortSlice** _tmp8_;
			gint _tmp8__length1;
			gint _tmp9_;
			ValaTimSortSlice* _tmp10_;
			gint _tmp11_;
			ValaTimSortSlice** _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			ValaTimSortSlice* _tmp14_;
			gint _tmp15_;
			_tmp4_ = self->priv->pending;
			_tmp4__length1 = self->priv->pending_length1;
			_tmp5_ = count;
			_tmp6_ = _tmp4_[_tmp5_ - 3];
			_tmp7_ = _tmp6_->length;
			_tmp8_ = self->priv->pending;
			_tmp8__length1 = self->priv->pending_length1;
			_tmp9_ = count;
			_tmp10_ = _tmp8_[_tmp9_ - 2];
			_tmp11_ = _tmp10_->length;
			_tmp12_ = self->priv->pending;
			_tmp12__length1 = self->priv->pending_length1;
			_tmp13_ = count;
			_tmp14_ = _tmp12_[_tmp13_ - 1];
			_tmp15_ = _tmp14_->length;
			_tmp2_ = _tmp7_ <= (_tmp11_ + _tmp15_);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			ValaTimSortSlice** _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_;
			ValaTimSortSlice* _tmp18_;
			gint _tmp19_;
			ValaTimSortSlice** _tmp20_;
			gint _tmp20__length1;
			gint _tmp21_;
			ValaTimSortSlice* _tmp22_;
			gint _tmp23_;
			_tmp16_ = self->priv->pending;
			_tmp16__length1 = self->priv->pending_length1;
			_tmp17_ = count;
			_tmp18_ = _tmp16_[_tmp17_ - 3];
			_tmp19_ = _tmp18_->length;
			_tmp20_ = self->priv->pending;
			_tmp20__length1 = self->priv->pending_length1;
			_tmp21_ = count;
			_tmp22_ = _tmp20_[_tmp21_ - 1];
			_tmp23_ = _tmp22_->length;
			if (_tmp19_ < _tmp23_) {
				gint _tmp24_;
				_tmp24_ = count;
				vala_tim_sort_merge_at (self, _tmp24_ - 3);
			} else {
				gint _tmp25_;
				_tmp25_ = count;
				vala_tim_sort_merge_at (self, _tmp25_ - 2);
			}
		} else {
			ValaTimSortSlice** _tmp26_;
			gint _tmp26__length1;
			gint _tmp27_;
			ValaTimSortSlice* _tmp28_;
			gint _tmp29_;
			ValaTimSortSlice** _tmp30_;
			gint _tmp30__length1;
			gint _tmp31_;
			ValaTimSortSlice* _tmp32_;
			gint _tmp33_;
			_tmp26_ = self->priv->pending;
			_tmp26__length1 = self->priv->pending_length1;
			_tmp27_ = count;
			_tmp28_ = _tmp26_[_tmp27_ - 2];
			_tmp29_ = _tmp28_->length;
			_tmp30_ = self->priv->pending;
			_tmp30__length1 = self->priv->pending_length1;
			_tmp31_ = count;
			_tmp32_ = _tmp30_[_tmp31_ - 1];
			_tmp33_ = _tmp32_->length;
			if (_tmp29_ <= _tmp33_) {
				gint _tmp34_;
				_tmp34_ = count;
				vala_tim_sort_merge_at (self, _tmp34_ - 2);
			} else {
				break;
			}
		}
		_tmp35_ = self->priv->pending;
		_tmp35__length1 = self->priv->pending_length1;
		count = _tmp35__length1;
	}
}


static void
vala_tim_sort_merge_force_collapse (ValaTimSort* self)
{
	gint count = 0;
	ValaTimSortSlice** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	count = _tmp0__length1;
	while (TRUE) {
		gint _tmp1_;
		gboolean _tmp2_ = FALSE;
		gint _tmp3_;
		ValaTimSortSlice** _tmp14_;
		gint _tmp14__length1;
		_tmp1_ = count;
		if (!(_tmp1_ > 1)) {
			break;
		}
		_tmp3_ = count;
		if (_tmp3_ >= 3) {
			ValaTimSortSlice** _tmp4_;
			gint _tmp4__length1;
			gint _tmp5_;
			ValaTimSortSlice* _tmp6_;
			gint _tmp7_;
			ValaTimSortSlice** _tmp8_;
			gint _tmp8__length1;
			gint _tmp9_;
			ValaTimSortSlice* _tmp10_;
			gint _tmp11_;
			_tmp4_ = self->priv->pending;
			_tmp4__length1 = self->priv->pending_length1;
			_tmp5_ = count;
			_tmp6_ = _tmp4_[_tmp5_ - 3];
			_tmp7_ = _tmp6_->length;
			_tmp8_ = self->priv->pending;
			_tmp8__length1 = self->priv->pending_length1;
			_tmp9_ = count;
			_tmp10_ = _tmp8_[_tmp9_ - 1];
			_tmp11_ = _tmp10_->length;
			_tmp2_ = _tmp7_ < _tmp11_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gint _tmp12_;
			_tmp12_ = count;
			vala_tim_sort_merge_at (self, _tmp12_ - 3);
		} else {
			gint _tmp13_;
			_tmp13_ = count;
			vala_tim_sort_merge_at (self, _tmp13_ - 2);
		}
		_tmp14_ = self->priv->pending;
		_tmp14__length1 = self->priv->pending_length1;
		count = _tmp14__length1;
	}
}


static void
vala_tim_sort_merge_at (ValaTimSort* self,
                        gint index)
{
	ValaTimSortSlice* a = NULL;
	ValaTimSortSlice** _tmp0_;
	gint _tmp0__length1;
	ValaTimSortSlice* _tmp1_;
	ValaTimSortSlice* b = NULL;
	ValaTimSortSlice** _tmp2_;
	gint _tmp2__length1;
	ValaTimSortSlice* _tmp3_;
	ValaTimSortSlice* _tmp4_;
	gint _tmp5_;
	ValaTimSortSlice* _tmp6_;
	gint _tmp7_;
	ValaTimSortSlice* _tmp8_;
	gint _tmp9_;
	ValaTimSortSlice* _tmp10_;
	gint _tmp11_;
	ValaTimSortSlice* _tmp12_;
	gint _tmp13_;
	ValaTimSortSlice** _tmp14_;
	gint _tmp14__length1;
	void** _tmp15_;
	ValaTimSortSlice* _tmp16_;
	gint _tmp17_;
	ValaTimSortSlice* _tmp18_;
	gint _tmp19_;
	ValaTimSortSlice* _tmp20_;
	gint _tmp21_;
	ValaTimSortSlice* _tmp22_;
	ValaTimSortSlice* _tmp23_;
	ValaTimSortSlice** _tmp24_;
	gint _tmp24__length1;
	gint _tmp25_;
	gint sorted_count = 0;
	ValaTimSortSlice* _tmp26_;
	void* _tmp27_;
	ValaTimSortSlice* _tmp28_;
	ValaTimSortSlice* _tmp29_;
	gint _tmp30_;
	ValaTimSortSlice* _tmp31_;
	gint _tmp32_;
	ValaTimSortSlice* _tmp33_;
	ValaTimSortSlice* _tmp34_;
	void* _tmp35_;
	ValaTimSortSlice* _tmp36_;
	ValaTimSortSlice* _tmp37_;
	gint _tmp38_;
	ValaTimSortSlice* _tmp39_;
	gint _tmp40_;
	ValaTimSortSlice* _tmp41_;
	gint _tmp42_;
	ValaTimSortSlice* _tmp43_;
	gint _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	a = _tmp1_;
	_tmp2_ = self->priv->pending;
	_tmp2__length1 = self->priv->pending_length1;
	_tmp3_ = _tmp2_[index + 1];
	_tmp2_[index + 1] = NULL;
	b = _tmp3_;
	_tmp4_ = a;
	_tmp5_ = _tmp4_->length;
	_vala_assert (_tmp5_ > 0, "a.length > 0");
	_tmp6_ = b;
	_tmp7_ = _tmp6_->length;
	_vala_assert (_tmp7_ > 0, "b.length > 0");
	_tmp8_ = a;
	_tmp9_ = _tmp8_->index;
	_tmp10_ = a;
	_tmp11_ = _tmp10_->length;
	_tmp12_ = b;
	_tmp13_ = _tmp12_->index;
	_vala_assert ((_tmp9_ + _tmp11_) == _tmp13_, "a.index + a.length == b.index");
	_tmp14_ = self->priv->pending;
	_tmp14__length1 = self->priv->pending_length1;
	_tmp15_ = self->priv->list;
	_tmp16_ = a;
	_tmp17_ = _tmp16_->index;
	_tmp18_ = a;
	_tmp19_ = _tmp18_->length;
	_tmp20_ = b;
	_tmp21_ = _tmp20_->length;
	_tmp22_ = vala_tim_sort_slice_new (_tmp15_, _tmp17_, _tmp19_ + _tmp21_);
	_vala_tim_sort_slice_free0 (_tmp14_[index]);
	_tmp14_[index] = _tmp22_;
	_tmp23_ = _tmp14_[index];
	_tmp24_ = self->priv->pending;
	_tmp24__length1 = self->priv->pending_length1;
	_vala_array_move (self->priv->pending, sizeof (ValaTimSortSlice*), index + 2, index + 1, (_tmp24__length1 - index) - 2);
	self->priv->pending_length1 = self->priv->pending_length1 - 1;
	_tmp25_ = self->priv->pending_length1;
	_tmp26_ = b;
	_tmp27_ = vala_tim_sort_slice_peek_first (_tmp26_);
	_tmp28_ = a;
	sorted_count = vala_tim_sort_gallop_rightmost (self, _tmp27_, _tmp28_, 0);
	_tmp29_ = a;
	_tmp30_ = sorted_count;
	vala_tim_sort_slice_shorten_start (_tmp29_, _tmp30_);
	_tmp31_ = a;
	_tmp32_ = _tmp31_->length;
	if (_tmp32_ == 0) {
		_vala_tim_sort_slice_free0 (b);
		_vala_tim_sort_slice_free0 (a);
		return;
	}
	_tmp33_ = b;
	_tmp34_ = a;
	_tmp35_ = vala_tim_sort_slice_peek_last (_tmp34_);
	_tmp36_ = b;
	_tmp37_ = b;
	_tmp38_ = _tmp37_->length;
	_tmp33_->length = vala_tim_sort_gallop_leftmost (self, _tmp35_, _tmp36_, _tmp38_ - 1);
	_tmp39_ = b;
	_tmp40_ = _tmp39_->length;
	if (_tmp40_ == 0) {
		_vala_tim_sort_slice_free0 (b);
		_vala_tim_sort_slice_free0 (a);
		return;
	}
	_tmp41_ = a;
	_tmp42_ = _tmp41_->length;
	_tmp43_ = b;
	_tmp44_ = _tmp43_->length;
	if (_tmp42_ <= _tmp44_) {
		ValaTimSortSlice* _tmp45_;
		ValaTimSortSlice* _tmp46_;
		_tmp45_ = a;
		a = NULL;
		_tmp46_ = b;
		b = NULL;
		vala_tim_sort_merge_low (self, _tmp45_, _tmp46_);
	} else {
		ValaTimSortSlice* _tmp47_;
		ValaTimSortSlice* _tmp48_;
		_tmp47_ = a;
		a = NULL;
		_tmp48_ = b;
		b = NULL;
		vala_tim_sort_merge_high (self, _tmp47_, _tmp48_);
	}
	_vala_tim_sort_slice_free0 (b);
	_vala_tim_sort_slice_free0 (a);
}


static gint
vala_tim_sort_gallop_leftmost (ValaTimSort* self,
                               gconstpointer key,
                               ValaTimSortSlice* a,
                               gint hint)
{
	gint result = 0;
	gint _tmp0_;
	gint p = 0;
	gint _tmp1_;
	gint last_offset = 0;
	gint offset = 0;
	void** _tmp2_;
	gint _tmp3_;
	void* _tmp4_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp53_;
	gint _tmp54_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	_vala_assert (0 <= hint, "0 <= hint");
	_tmp0_ = a->length;
	_vala_assert (hint < _tmp0_, "hint < a.length");
	_tmp1_ = a->index;
	p = _tmp1_ + hint;
	last_offset = 0;
	offset = 1;
	_tmp2_ = a->list;
	_tmp3_ = p;
	_tmp4_ = _tmp2_[_tmp3_];
	if (vala_tim_sort_lower_than (self, _tmp4_, key)) {
		gint max_offset = 0;
		gint _tmp5_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp5_ = a->length;
		max_offset = _tmp5_ - hint;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			void** _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			void* _tmp11_;
			_tmp6_ = offset;
			_tmp7_ = max_offset;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = a->list;
			_tmp9_ = p;
			_tmp10_ = offset;
			_tmp11_ = _tmp8_[_tmp9_ + _tmp10_];
			if (vala_tim_sort_lower_than (self, _tmp11_, key)) {
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp12_ = offset;
				last_offset = _tmp12_;
				_tmp13_ = offset;
				offset = _tmp13_ << 1;
				_tmp14_ = offset;
				offset = _tmp14_ + 1;
			} else {
				break;
			}
		}
		_tmp15_ = offset;
		_tmp16_ = max_offset;
		if (_tmp15_ > _tmp16_) {
			gint _tmp17_;
			_tmp17_ = max_offset;
			offset = _tmp17_;
		}
		_tmp18_ = last_offset;
		last_offset = hint + _tmp18_;
		_tmp19_ = offset;
		offset = hint + _tmp19_;
	} else {
		gint max_offset = 0;
		gint _tmp29_;
		gint _tmp30_;
		gint temp_last_offset = 0;
		gint _tmp32_;
		gint temp_offset = 0;
		gint _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		max_offset = hint + 1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			void** _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			void* _tmp25_;
			_tmp20_ = offset;
			_tmp21_ = max_offset;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = a->list;
			_tmp23_ = p;
			_tmp24_ = offset;
			_tmp25_ = _tmp22_[_tmp23_ - _tmp24_];
			if (vala_tim_sort_lower_than (self, _tmp25_, key)) {
				break;
			} else {
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				_tmp26_ = offset;
				last_offset = _tmp26_;
				_tmp27_ = offset;
				offset = _tmp27_ << 1;
				_tmp28_ = offset;
				offset = _tmp28_ + 1;
			}
		}
		_tmp29_ = offset;
		_tmp30_ = max_offset;
		if (_tmp29_ > _tmp30_) {
			gint _tmp31_;
			_tmp31_ = max_offset;
			offset = _tmp31_;
		}
		_tmp32_ = last_offset;
		temp_last_offset = _tmp32_;
		_tmp33_ = offset;
		temp_offset = _tmp33_;
		_tmp34_ = temp_offset;
		last_offset = hint - _tmp34_;
		_tmp35_ = temp_last_offset;
		offset = hint - _tmp35_;
	}
	_tmp36_ = last_offset;
	_vala_assert (-1 <= _tmp36_, "-1 <= last_offset");
	_tmp37_ = last_offset;
	_tmp38_ = offset;
	_vala_assert (_tmp37_ < _tmp38_, "last_offset < offset");
	_tmp39_ = offset;
	_tmp40_ = a->length;
	_vala_assert (_tmp39_ <= _tmp40_, "offset <= a.length");
	_tmp41_ = last_offset;
	last_offset = _tmp41_ + 1;
	while (TRUE) {
		gint _tmp42_;
		gint _tmp43_;
		gint m = 0;
		gint _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		void** _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		void* _tmp50_;
		_tmp42_ = last_offset;
		_tmp43_ = offset;
		if (!(_tmp42_ < _tmp43_)) {
			break;
		}
		_tmp44_ = last_offset;
		_tmp45_ = offset;
		_tmp46_ = last_offset;
		m = _tmp44_ + ((_tmp45_ - _tmp46_) >> 1);
		_tmp47_ = a->list;
		_tmp48_ = a->index;
		_tmp49_ = m;
		_tmp50_ = _tmp47_[_tmp48_ + _tmp49_];
		if (vala_tim_sort_lower_than (self, _tmp50_, key)) {
			gint _tmp51_;
			_tmp51_ = m;
			last_offset = _tmp51_ + 1;
		} else {
			gint _tmp52_;
			_tmp52_ = m;
			offset = _tmp52_;
		}
	}
	_tmp53_ = last_offset;
	_tmp54_ = offset;
	_vala_assert (_tmp53_ == _tmp54_, "last_offset == offset");
	result = offset;
	return result;
}


static gint
vala_tim_sort_gallop_rightmost (ValaTimSort* self,
                                gconstpointer key,
                                ValaTimSortSlice* a,
                                gint hint)
{
	gint result = 0;
	gint _tmp0_;
	gint p = 0;
	gint _tmp1_;
	gint last_offset = 0;
	gint offset = 0;
	void** _tmp2_;
	gint _tmp3_;
	void* _tmp4_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp53_;
	gint _tmp54_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	_vala_assert (0 <= hint, "0 <= hint");
	_tmp0_ = a->length;
	_vala_assert (hint < _tmp0_, "hint < a.length");
	_tmp1_ = a->index;
	p = _tmp1_ + hint;
	last_offset = 0;
	offset = 1;
	_tmp2_ = a->list;
	_tmp3_ = p;
	_tmp4_ = _tmp2_[_tmp3_];
	if (vala_tim_sort_lower_than_or_equal_to (self, _tmp4_, key)) {
		gint max_offset = 0;
		gint _tmp5_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp5_ = a->length;
		max_offset = _tmp5_ - hint;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			void** _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			void* _tmp11_;
			_tmp6_ = offset;
			_tmp7_ = max_offset;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = a->list;
			_tmp9_ = p;
			_tmp10_ = offset;
			_tmp11_ = _tmp8_[_tmp9_ + _tmp10_];
			if (vala_tim_sort_lower_than_or_equal_to (self, _tmp11_, key)) {
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp12_ = offset;
				last_offset = _tmp12_;
				_tmp13_ = offset;
				offset = _tmp13_ << 1;
				_tmp14_ = offset;
				offset = _tmp14_ + 1;
			} else {
				break;
			}
		}
		_tmp15_ = offset;
		_tmp16_ = max_offset;
		if (_tmp15_ > _tmp16_) {
			gint _tmp17_;
			_tmp17_ = max_offset;
			offset = _tmp17_;
		}
		_tmp18_ = last_offset;
		last_offset = hint + _tmp18_;
		_tmp19_ = offset;
		offset = hint + _tmp19_;
	} else {
		gint max_offset = 0;
		gint _tmp29_;
		gint _tmp30_;
		gint temp_last_offset = 0;
		gint _tmp32_;
		gint temp_offset = 0;
		gint _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		max_offset = hint + 1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			void** _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			void* _tmp25_;
			_tmp20_ = offset;
			_tmp21_ = max_offset;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = a->list;
			_tmp23_ = p;
			_tmp24_ = offset;
			_tmp25_ = _tmp22_[_tmp23_ - _tmp24_];
			if (vala_tim_sort_lower_than_or_equal_to (self, _tmp25_, key)) {
				break;
			} else {
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				_tmp26_ = offset;
				last_offset = _tmp26_;
				_tmp27_ = offset;
				offset = _tmp27_ << 1;
				_tmp28_ = offset;
				offset = _tmp28_ + 1;
			}
		}
		_tmp29_ = offset;
		_tmp30_ = max_offset;
		if (_tmp29_ > _tmp30_) {
			gint _tmp31_;
			_tmp31_ = max_offset;
			offset = _tmp31_;
		}
		_tmp32_ = last_offset;
		temp_last_offset = _tmp32_;
		_tmp33_ = offset;
		temp_offset = _tmp33_;
		_tmp34_ = temp_offset;
		last_offset = hint - _tmp34_;
		_tmp35_ = temp_last_offset;
		offset = hint - _tmp35_;
	}
	_tmp36_ = last_offset;
	_vala_assert (-1 <= _tmp36_, "-1 <= last_offset");
	_tmp37_ = last_offset;
	_tmp38_ = offset;
	_vala_assert (_tmp37_ < _tmp38_, "last_offset < offset");
	_tmp39_ = offset;
	_tmp40_ = a->length;
	_vala_assert (_tmp39_ <= _tmp40_, "offset <= a.length");
	_tmp41_ = last_offset;
	last_offset = _tmp41_ + 1;
	while (TRUE) {
		gint _tmp42_;
		gint _tmp43_;
		gint m = 0;
		gint _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		void** _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		void* _tmp50_;
		_tmp42_ = last_offset;
		_tmp43_ = offset;
		if (!(_tmp42_ < _tmp43_)) {
			break;
		}
		_tmp44_ = last_offset;
		_tmp45_ = offset;
		_tmp46_ = last_offset;
		m = _tmp44_ + ((_tmp45_ - _tmp46_) >> 1);
		_tmp47_ = a->list;
		_tmp48_ = a->index;
		_tmp49_ = m;
		_tmp50_ = _tmp47_[_tmp48_ + _tmp49_];
		if (vala_tim_sort_lower_than_or_equal_to (self, _tmp50_, key)) {
			gint _tmp51_;
			_tmp51_ = m;
			last_offset = _tmp51_ + 1;
		} else {
			gint _tmp52_;
			_tmp52_ = m;
			offset = _tmp52_;
		}
	}
	_tmp53_ = last_offset;
	_tmp54_ = offset;
	_vala_assert (_tmp53_ == _tmp54_, "last_offset == offset");
	result = offset;
	return result;
}


static void
vala_tim_sort_merge_low (ValaTimSort* self,
                         ValaTimSortSlice* a,
                         ValaTimSortSlice* b)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint minimum_gallop = 0;
	gint _tmp5_;
	gint dest = 0;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = a->length;
	_vala_assert (_tmp0_ > 0, "a.length > 0");
	_tmp1_ = b->length;
	_vala_assert (_tmp1_ > 0, "b.length > 0");
	_tmp2_ = a->index;
	_tmp3_ = a->length;
	_tmp4_ = b->index;
	_vala_assert ((_tmp2_ + _tmp3_) == _tmp4_, "a.index + a.length == b.index");
	_tmp5_ = self->priv->minimum_gallop;
	minimum_gallop = _tmp5_;
	_tmp6_ = a->index;
	dest = _tmp6_;
	vala_tim_sort_slice_copy (a);
	{
		void** _tmp7_;
		gint _tmp8_;
		void* _tmp9_;
		void* _tmp10_;
		gboolean _tmp11_ = FALSE;
		gint _tmp12_;
		_tmp7_ = self->priv->list;
		_tmp8_ = dest;
		dest = _tmp8_ + 1;
		_tmp9_ = vala_tim_sort_slice_pop_first (b);
		_tmp7_[_tmp8_] = _tmp9_;
		_tmp10_ = _tmp7_[_tmp8_];
		_tmp12_ = a->length;
		if (_tmp12_ == 1) {
			_tmp11_ = TRUE;
		} else {
			gint _tmp13_;
			_tmp13_ = b->length;
			_tmp11_ = _tmp13_ == 0;
		}
		if (_tmp11_) {
			{
				gint _tmp14_;
				gint _tmp15_;
				void** _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				void** _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				_tmp14_ = a->length;
				_vala_assert (_tmp14_ >= 0, "a.length >= 0");
				_tmp15_ = b->length;
				_vala_assert (_tmp15_ >= 0, "b.length >= 0");
				_tmp16_ = self->priv->list;
				_tmp17_ = b->index;
				_tmp18_ = dest;
				_tmp19_ = b->length;
				vala_tim_sort_slice_merge_in (b, _tmp16_, _tmp17_, _tmp18_, _tmp19_);
				_tmp20_ = self->priv->list;
				_tmp21_ = a->index;
				_tmp22_ = dest;
				_tmp23_ = b->length;
				_tmp24_ = a->length;
				vala_tim_sort_slice_merge_in (a, _tmp20_, _tmp21_, _tmp22_ + _tmp23_, _tmp24_);
			}
			_vala_tim_sort_slice_free0 (a);
			_vala_tim_sort_slice_free0 (b);
			return;
		}
		while (TRUE) {
			gint a_count = 0;
			gint b_count = 0;
			gint _tmp65_;
			gint _tmp145_;
			gint _tmp146_;
			a_count = 0;
			b_count = 0;
			while (TRUE) {
				void* _tmp25_;
				void* _tmp26_;
				_tmp25_ = vala_tim_sort_slice_peek_first (b);
				_tmp26_ = vala_tim_sort_slice_peek_first (a);
				if (vala_tim_sort_lower_than (self, _tmp25_, _tmp26_)) {
					void** _tmp27_;
					gint _tmp28_;
					void* _tmp29_;
					void* _tmp30_;
					gint _tmp31_;
					gint _tmp43_;
					gint _tmp44_;
					gint _tmp45_;
					_tmp27_ = self->priv->list;
					_tmp28_ = dest;
					dest = _tmp28_ + 1;
					_tmp29_ = vala_tim_sort_slice_pop_first (b);
					_tmp27_[_tmp28_] = _tmp29_;
					_tmp30_ = _tmp27_[_tmp28_];
					_tmp31_ = b->length;
					if (_tmp31_ == 0) {
						{
							gint _tmp32_;
							gint _tmp33_;
							void** _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							gint _tmp37_;
							void** _tmp38_;
							gint _tmp39_;
							gint _tmp40_;
							gint _tmp41_;
							gint _tmp42_;
							_tmp32_ = a->length;
							_vala_assert (_tmp32_ >= 0, "a.length >= 0");
							_tmp33_ = b->length;
							_vala_assert (_tmp33_ >= 0, "b.length >= 0");
							_tmp34_ = self->priv->list;
							_tmp35_ = b->index;
							_tmp36_ = dest;
							_tmp37_ = b->length;
							vala_tim_sort_slice_merge_in (b, _tmp34_, _tmp35_, _tmp36_, _tmp37_);
							_tmp38_ = self->priv->list;
							_tmp39_ = a->index;
							_tmp40_ = dest;
							_tmp41_ = b->length;
							_tmp42_ = a->length;
							vala_tim_sort_slice_merge_in (a, _tmp38_, _tmp39_, _tmp40_ + _tmp41_, _tmp42_);
						}
						_vala_tim_sort_slice_free0 (a);
						_vala_tim_sort_slice_free0 (b);
						return;
					}
					_tmp43_ = b_count;
					b_count = _tmp43_ + 1;
					a_count = 0;
					_tmp44_ = b_count;
					_tmp45_ = minimum_gallop;
					if (_tmp44_ >= _tmp45_) {
						break;
					}
				} else {
					void** _tmp46_;
					gint _tmp47_;
					void* _tmp48_;
					void* _tmp49_;
					gint _tmp50_;
					gint _tmp62_;
					gint _tmp63_;
					gint _tmp64_;
					_tmp46_ = self->priv->list;
					_tmp47_ = dest;
					dest = _tmp47_ + 1;
					_tmp48_ = vala_tim_sort_slice_pop_first (a);
					_tmp46_[_tmp47_] = _tmp48_;
					_tmp49_ = _tmp46_[_tmp47_];
					_tmp50_ = a->length;
					if (_tmp50_ == 1) {
						{
							gint _tmp51_;
							gint _tmp52_;
							void** _tmp53_;
							gint _tmp54_;
							gint _tmp55_;
							gint _tmp56_;
							void** _tmp57_;
							gint _tmp58_;
							gint _tmp59_;
							gint _tmp60_;
							gint _tmp61_;
							_tmp51_ = a->length;
							_vala_assert (_tmp51_ >= 0, "a.length >= 0");
							_tmp52_ = b->length;
							_vala_assert (_tmp52_ >= 0, "b.length >= 0");
							_tmp53_ = self->priv->list;
							_tmp54_ = b->index;
							_tmp55_ = dest;
							_tmp56_ = b->length;
							vala_tim_sort_slice_merge_in (b, _tmp53_, _tmp54_, _tmp55_, _tmp56_);
							_tmp57_ = self->priv->list;
							_tmp58_ = a->index;
							_tmp59_ = dest;
							_tmp60_ = b->length;
							_tmp61_ = a->length;
							vala_tim_sort_slice_merge_in (a, _tmp57_, _tmp58_, _tmp59_ + _tmp60_, _tmp61_);
						}
						_vala_tim_sort_slice_free0 (a);
						_vala_tim_sort_slice_free0 (b);
						return;
					}
					_tmp62_ = a_count;
					a_count = _tmp62_ + 1;
					b_count = 0;
					_tmp63_ = a_count;
					_tmp64_ = minimum_gallop;
					if (_tmp63_ >= _tmp64_) {
						break;
					}
				}
			}
			_tmp65_ = minimum_gallop;
			minimum_gallop = _tmp65_ + 1;
			while (TRUE) {
				gint _tmp66_ = 0;
				gint _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				void* _tmp70_;
				void** _tmp71_;
				gint _tmp72_;
				gint _tmp73_;
				gint _tmp74_;
				gint _tmp75_;
				gint _tmp76_;
				gint _tmp77_;
				gint _tmp78_;
				void** _tmp90_;
				gint _tmp91_;
				void* _tmp92_;
				void* _tmp93_;
				gint _tmp94_;
				void* _tmp106_;
				void** _tmp107_;
				gint _tmp108_;
				gint _tmp109_;
				gint _tmp110_;
				gint _tmp111_;
				gint _tmp112_;
				gint _tmp113_;
				gint _tmp114_;
				void** _tmp126_;
				gint _tmp127_;
				void* _tmp128_;
				void* _tmp129_;
				gint _tmp130_;
				gboolean _tmp142_ = FALSE;
				gint _tmp143_;
				_tmp67_ = minimum_gallop;
				if (_tmp67_ > 1) {
					_tmp66_ = 1;
				} else {
					_tmp66_ = 0;
				}
				_tmp68_ = minimum_gallop;
				minimum_gallop = _tmp68_ - _tmp66_;
				_tmp69_ = minimum_gallop;
				self->priv->minimum_gallop = _tmp69_;
				_tmp70_ = vala_tim_sort_slice_peek_first (b);
				a_count = vala_tim_sort_gallop_rightmost (self, _tmp70_, a, 0);
				_tmp71_ = self->priv->list;
				_tmp72_ = a->index;
				_tmp73_ = dest;
				_tmp74_ = a_count;
				vala_tim_sort_slice_merge_in (a, _tmp71_, _tmp72_, _tmp73_, _tmp74_);
				_tmp75_ = dest;
				_tmp76_ = a_count;
				dest = _tmp75_ + _tmp76_;
				_tmp77_ = a_count;
				vala_tim_sort_slice_shorten_start (a, _tmp77_);
				_tmp78_ = a->length;
				if (_tmp78_ <= 1) {
					{
						gint _tmp79_;
						gint _tmp80_;
						void** _tmp81_;
						gint _tmp82_;
						gint _tmp83_;
						gint _tmp84_;
						void** _tmp85_;
						gint _tmp86_;
						gint _tmp87_;
						gint _tmp88_;
						gint _tmp89_;
						_tmp79_ = a->length;
						_vala_assert (_tmp79_ >= 0, "a.length >= 0");
						_tmp80_ = b->length;
						_vala_assert (_tmp80_ >= 0, "b.length >= 0");
						_tmp81_ = self->priv->list;
						_tmp82_ = b->index;
						_tmp83_ = dest;
						_tmp84_ = b->length;
						vala_tim_sort_slice_merge_in (b, _tmp81_, _tmp82_, _tmp83_, _tmp84_);
						_tmp85_ = self->priv->list;
						_tmp86_ = a->index;
						_tmp87_ = dest;
						_tmp88_ = b->length;
						_tmp89_ = a->length;
						vala_tim_sort_slice_merge_in (a, _tmp85_, _tmp86_, _tmp87_ + _tmp88_, _tmp89_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp90_ = self->priv->list;
				_tmp91_ = dest;
				dest = _tmp91_ + 1;
				_tmp92_ = vala_tim_sort_slice_pop_first (b);
				_tmp90_[_tmp91_] = _tmp92_;
				_tmp93_ = _tmp90_[_tmp91_];
				_tmp94_ = b->length;
				if (_tmp94_ == 0) {
					{
						gint _tmp95_;
						gint _tmp96_;
						void** _tmp97_;
						gint _tmp98_;
						gint _tmp99_;
						gint _tmp100_;
						void** _tmp101_;
						gint _tmp102_;
						gint _tmp103_;
						gint _tmp104_;
						gint _tmp105_;
						_tmp95_ = a->length;
						_vala_assert (_tmp95_ >= 0, "a.length >= 0");
						_tmp96_ = b->length;
						_vala_assert (_tmp96_ >= 0, "b.length >= 0");
						_tmp97_ = self->priv->list;
						_tmp98_ = b->index;
						_tmp99_ = dest;
						_tmp100_ = b->length;
						vala_tim_sort_slice_merge_in (b, _tmp97_, _tmp98_, _tmp99_, _tmp100_);
						_tmp101_ = self->priv->list;
						_tmp102_ = a->index;
						_tmp103_ = dest;
						_tmp104_ = b->length;
						_tmp105_ = a->length;
						vala_tim_sort_slice_merge_in (a, _tmp101_, _tmp102_, _tmp103_ + _tmp104_, _tmp105_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp106_ = vala_tim_sort_slice_peek_first (a);
				b_count = vala_tim_sort_gallop_leftmost (self, _tmp106_, b, 0);
				_tmp107_ = self->priv->list;
				_tmp108_ = b->index;
				_tmp109_ = dest;
				_tmp110_ = b_count;
				vala_tim_sort_slice_merge_in (b, _tmp107_, _tmp108_, _tmp109_, _tmp110_);
				_tmp111_ = dest;
				_tmp112_ = b_count;
				dest = _tmp111_ + _tmp112_;
				_tmp113_ = b_count;
				vala_tim_sort_slice_shorten_start (b, _tmp113_);
				_tmp114_ = b->length;
				if (_tmp114_ == 0) {
					{
						gint _tmp115_;
						gint _tmp116_;
						void** _tmp117_;
						gint _tmp118_;
						gint _tmp119_;
						gint _tmp120_;
						void** _tmp121_;
						gint _tmp122_;
						gint _tmp123_;
						gint _tmp124_;
						gint _tmp125_;
						_tmp115_ = a->length;
						_vala_assert (_tmp115_ >= 0, "a.length >= 0");
						_tmp116_ = b->length;
						_vala_assert (_tmp116_ >= 0, "b.length >= 0");
						_tmp117_ = self->priv->list;
						_tmp118_ = b->index;
						_tmp119_ = dest;
						_tmp120_ = b->length;
						vala_tim_sort_slice_merge_in (b, _tmp117_, _tmp118_, _tmp119_, _tmp120_);
						_tmp121_ = self->priv->list;
						_tmp122_ = a->index;
						_tmp123_ = dest;
						_tmp124_ = b->length;
						_tmp125_ = a->length;
						vala_tim_sort_slice_merge_in (a, _tmp121_, _tmp122_, _tmp123_ + _tmp124_, _tmp125_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp126_ = self->priv->list;
				_tmp127_ = dest;
				dest = _tmp127_ + 1;
				_tmp128_ = vala_tim_sort_slice_pop_first (a);
				_tmp126_[_tmp127_] = _tmp128_;
				_tmp129_ = _tmp126_[_tmp127_];
				_tmp130_ = a->length;
				if (_tmp130_ == 1) {
					{
						gint _tmp131_;
						gint _tmp132_;
						void** _tmp133_;
						gint _tmp134_;
						gint _tmp135_;
						gint _tmp136_;
						void** _tmp137_;
						gint _tmp138_;
						gint _tmp139_;
						gint _tmp140_;
						gint _tmp141_;
						_tmp131_ = a->length;
						_vala_assert (_tmp131_ >= 0, "a.length >= 0");
						_tmp132_ = b->length;
						_vala_assert (_tmp132_ >= 0, "b.length >= 0");
						_tmp133_ = self->priv->list;
						_tmp134_ = b->index;
						_tmp135_ = dest;
						_tmp136_ = b->length;
						vala_tim_sort_slice_merge_in (b, _tmp133_, _tmp134_, _tmp135_, _tmp136_);
						_tmp137_ = self->priv->list;
						_tmp138_ = a->index;
						_tmp139_ = dest;
						_tmp140_ = b->length;
						_tmp141_ = a->length;
						vala_tim_sort_slice_merge_in (a, _tmp137_, _tmp138_, _tmp139_ + _tmp140_, _tmp141_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp143_ = a_count;
				if (_tmp143_ < VALA_TIM_SORT_MINIMUM_GALLOP) {
					gint _tmp144_;
					_tmp144_ = b_count;
					_tmp142_ = _tmp144_ < VALA_TIM_SORT_MINIMUM_GALLOP;
				} else {
					_tmp142_ = FALSE;
				}
				if (_tmp142_) {
					break;
				}
			}
			_tmp145_ = minimum_gallop;
			minimum_gallop = _tmp145_ + 1;
			_tmp146_ = minimum_gallop;
			self->priv->minimum_gallop = _tmp146_;
		}
	}
	__finally0:
	{
		gint _tmp147_;
		gint _tmp148_;
		void** _tmp149_;
		gint _tmp150_;
		gint _tmp151_;
		gint _tmp152_;
		void** _tmp153_;
		gint _tmp154_;
		gint _tmp155_;
		gint _tmp156_;
		gint _tmp157_;
		_tmp147_ = a->length;
		_vala_assert (_tmp147_ >= 0, "a.length >= 0");
		_tmp148_ = b->length;
		_vala_assert (_tmp148_ >= 0, "b.length >= 0");
		_tmp149_ = self->priv->list;
		_tmp150_ = b->index;
		_tmp151_ = dest;
		_tmp152_ = b->length;
		vala_tim_sort_slice_merge_in (b, _tmp149_, _tmp150_, _tmp151_, _tmp152_);
		_tmp153_ = self->priv->list;
		_tmp154_ = a->index;
		_tmp155_ = dest;
		_tmp156_ = b->length;
		_tmp157_ = a->length;
		vala_tim_sort_slice_merge_in (a, _tmp153_, _tmp154_, _tmp155_ + _tmp156_, _tmp157_);
	}
	_vala_tim_sort_slice_free0 (a);
	_vala_tim_sort_slice_free0 (b);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return;
}


static void
vala_tim_sort_merge_high (ValaTimSort* self,
                          ValaTimSortSlice* a,
                          ValaTimSortSlice* b)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint minimum_gallop = 0;
	gint _tmp5_;
	gint dest = 0;
	gint _tmp6_;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = a->length;
	_vala_assert (_tmp0_ > 0, "a.length > 0");
	_tmp1_ = b->length;
	_vala_assert (_tmp1_ > 0, "b.length > 0");
	_tmp2_ = a->index;
	_tmp3_ = a->length;
	_tmp4_ = b->index;
	_vala_assert ((_tmp2_ + _tmp3_) == _tmp4_, "a.index + a.length == b.index");
	_tmp5_ = self->priv->minimum_gallop;
	minimum_gallop = _tmp5_;
	_tmp6_ = b->index;
	_tmp7_ = b->length;
	dest = _tmp6_ + _tmp7_;
	vala_tim_sort_slice_copy (b);
	{
		void** _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		void* _tmp11_;
		void* _tmp12_;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_;
		_tmp8_ = self->priv->list;
		_tmp9_ = dest;
		dest = _tmp9_ - 1;
		_tmp10_ = dest;
		_tmp11_ = vala_tim_sort_slice_pop_last (a);
		_tmp8_[_tmp10_] = _tmp11_;
		_tmp12_ = _tmp8_[_tmp10_];
		_tmp14_ = a->length;
		if (_tmp14_ == 0) {
			_tmp13_ = TRUE;
		} else {
			gint _tmp15_;
			_tmp15_ = b->length;
			_tmp13_ = _tmp15_ == 1;
		}
		if (_tmp13_) {
			{
				gint _tmp16_;
				gint _tmp17_;
				void** _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				void** _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				_tmp16_ = a->length;
				_vala_assert (_tmp16_ >= 0, "a.length >= 0");
				_tmp17_ = b->length;
				_vala_assert (_tmp17_ >= 0, "b.length >= 0");
				_tmp18_ = self->priv->list;
				_tmp19_ = a->index;
				_tmp20_ = dest;
				_tmp21_ = a->length;
				_tmp22_ = a->length;
				vala_tim_sort_slice_merge_in_reversed (a, _tmp18_, _tmp19_, _tmp20_ - _tmp21_, _tmp22_);
				_tmp23_ = self->priv->list;
				_tmp24_ = b->index;
				_tmp25_ = dest;
				_tmp26_ = a->length;
				_tmp27_ = b->length;
				_tmp28_ = b->length;
				vala_tim_sort_slice_merge_in_reversed (b, _tmp23_, _tmp24_, (_tmp25_ - _tmp26_) - _tmp27_, _tmp28_);
			}
			_vala_tim_sort_slice_free0 (a);
			_vala_tim_sort_slice_free0 (b);
			return;
		}
		while (TRUE) {
			gint a_count = 0;
			gint b_count = 0;
			gint _tmp75_;
			gint _tmp175_;
			gint _tmp176_;
			a_count = 0;
			b_count = 0;
			while (TRUE) {
				void* _tmp29_;
				void* _tmp30_;
				_tmp29_ = vala_tim_sort_slice_peek_last (b);
				_tmp30_ = vala_tim_sort_slice_peek_last (a);
				if (vala_tim_sort_lower_than (self, _tmp29_, _tmp30_)) {
					void** _tmp31_;
					gint _tmp32_;
					gint _tmp33_;
					void* _tmp34_;
					void* _tmp35_;
					gint _tmp36_;
					gint _tmp50_;
					gint _tmp51_;
					gint _tmp52_;
					_tmp31_ = self->priv->list;
					_tmp32_ = dest;
					dest = _tmp32_ - 1;
					_tmp33_ = dest;
					_tmp34_ = vala_tim_sort_slice_pop_last (a);
					_tmp31_[_tmp33_] = _tmp34_;
					_tmp35_ = _tmp31_[_tmp33_];
					_tmp36_ = a->length;
					if (_tmp36_ == 0) {
						{
							gint _tmp37_;
							gint _tmp38_;
							void** _tmp39_;
							gint _tmp40_;
							gint _tmp41_;
							gint _tmp42_;
							gint _tmp43_;
							void** _tmp44_;
							gint _tmp45_;
							gint _tmp46_;
							gint _tmp47_;
							gint _tmp48_;
							gint _tmp49_;
							_tmp37_ = a->length;
							_vala_assert (_tmp37_ >= 0, "a.length >= 0");
							_tmp38_ = b->length;
							_vala_assert (_tmp38_ >= 0, "b.length >= 0");
							_tmp39_ = self->priv->list;
							_tmp40_ = a->index;
							_tmp41_ = dest;
							_tmp42_ = a->length;
							_tmp43_ = a->length;
							vala_tim_sort_slice_merge_in_reversed (a, _tmp39_, _tmp40_, _tmp41_ - _tmp42_, _tmp43_);
							_tmp44_ = self->priv->list;
							_tmp45_ = b->index;
							_tmp46_ = dest;
							_tmp47_ = a->length;
							_tmp48_ = b->length;
							_tmp49_ = b->length;
							vala_tim_sort_slice_merge_in_reversed (b, _tmp44_, _tmp45_, (_tmp46_ - _tmp47_) - _tmp48_, _tmp49_);
						}
						_vala_tim_sort_slice_free0 (a);
						_vala_tim_sort_slice_free0 (b);
						return;
					}
					_tmp50_ = a_count;
					a_count = _tmp50_ + 1;
					b_count = 0;
					_tmp51_ = a_count;
					_tmp52_ = minimum_gallop;
					if (_tmp51_ >= _tmp52_) {
						break;
					}
				} else {
					void** _tmp53_;
					gint _tmp54_;
					gint _tmp55_;
					void* _tmp56_;
					void* _tmp57_;
					gint _tmp58_;
					gint _tmp72_;
					gint _tmp73_;
					gint _tmp74_;
					_tmp53_ = self->priv->list;
					_tmp54_ = dest;
					dest = _tmp54_ - 1;
					_tmp55_ = dest;
					_tmp56_ = vala_tim_sort_slice_pop_last (b);
					_tmp53_[_tmp55_] = _tmp56_;
					_tmp57_ = _tmp53_[_tmp55_];
					_tmp58_ = b->length;
					if (_tmp58_ == 1) {
						{
							gint _tmp59_;
							gint _tmp60_;
							void** _tmp61_;
							gint _tmp62_;
							gint _tmp63_;
							gint _tmp64_;
							gint _tmp65_;
							void** _tmp66_;
							gint _tmp67_;
							gint _tmp68_;
							gint _tmp69_;
							gint _tmp70_;
							gint _tmp71_;
							_tmp59_ = a->length;
							_vala_assert (_tmp59_ >= 0, "a.length >= 0");
							_tmp60_ = b->length;
							_vala_assert (_tmp60_ >= 0, "b.length >= 0");
							_tmp61_ = self->priv->list;
							_tmp62_ = a->index;
							_tmp63_ = dest;
							_tmp64_ = a->length;
							_tmp65_ = a->length;
							vala_tim_sort_slice_merge_in_reversed (a, _tmp61_, _tmp62_, _tmp63_ - _tmp64_, _tmp65_);
							_tmp66_ = self->priv->list;
							_tmp67_ = b->index;
							_tmp68_ = dest;
							_tmp69_ = a->length;
							_tmp70_ = b->length;
							_tmp71_ = b->length;
							vala_tim_sort_slice_merge_in_reversed (b, _tmp66_, _tmp67_, (_tmp68_ - _tmp69_) - _tmp70_, _tmp71_);
						}
						_vala_tim_sort_slice_free0 (a);
						_vala_tim_sort_slice_free0 (b);
						return;
					}
					_tmp72_ = b_count;
					b_count = _tmp72_ + 1;
					a_count = 0;
					_tmp73_ = b_count;
					_tmp74_ = minimum_gallop;
					if (_tmp73_ >= _tmp74_) {
						break;
					}
				}
			}
			_tmp75_ = minimum_gallop;
			minimum_gallop = _tmp75_ + 1;
			while (TRUE) {
				gint _tmp76_ = 0;
				gint _tmp77_;
				gint _tmp78_;
				gint _tmp79_;
				gint k = 0;
				void* _tmp80_;
				gint _tmp81_;
				gint _tmp82_;
				gint _tmp83_;
				void** _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				gint _tmp87_;
				gint _tmp88_;
				gint _tmp89_;
				gint _tmp90_;
				gint _tmp91_;
				gint _tmp92_;
				gint _tmp93_;
				void** _tmp107_;
				gint _tmp108_;
				gint _tmp109_;
				void* _tmp110_;
				void* _tmp111_;
				gint _tmp112_;
				void* _tmp126_;
				gint _tmp127_;
				gint _tmp128_;
				gint _tmp129_;
				void** _tmp130_;
				gint _tmp131_;
				gint _tmp132_;
				gint _tmp133_;
				gint _tmp134_;
				gint _tmp135_;
				gint _tmp136_;
				gint _tmp137_;
				gint _tmp138_;
				gint _tmp139_;
				void** _tmp153_;
				gint _tmp154_;
				gint _tmp155_;
				void* _tmp156_;
				void* _tmp157_;
				gint _tmp158_;
				gboolean _tmp172_ = FALSE;
				gint _tmp173_;
				_tmp77_ = minimum_gallop;
				if (_tmp77_ > 1) {
					_tmp76_ = 1;
				} else {
					_tmp76_ = 0;
				}
				_tmp78_ = minimum_gallop;
				minimum_gallop = _tmp78_ - _tmp76_;
				_tmp79_ = minimum_gallop;
				self->priv->minimum_gallop = _tmp79_;
				_tmp80_ = vala_tim_sort_slice_peek_last (b);
				_tmp81_ = a->length;
				k = vala_tim_sort_gallop_rightmost (self, _tmp80_, a, _tmp81_ - 1);
				_tmp82_ = a->length;
				_tmp83_ = k;
				a_count = _tmp82_ - _tmp83_;
				_tmp84_ = self->priv->list;
				_tmp85_ = a->index;
				_tmp86_ = k;
				_tmp87_ = dest;
				_tmp88_ = a_count;
				_tmp89_ = a_count;
				vala_tim_sort_slice_merge_in_reversed (a, _tmp84_, _tmp85_ + _tmp86_, _tmp87_ - _tmp88_, _tmp89_);
				_tmp90_ = dest;
				_tmp91_ = a_count;
				dest = _tmp90_ - _tmp91_;
				_tmp92_ = a_count;
				vala_tim_sort_slice_shorten_end (a, _tmp92_);
				_tmp93_ = a->length;
				if (_tmp93_ == 0) {
					{
						gint _tmp94_;
						gint _tmp95_;
						void** _tmp96_;
						gint _tmp97_;
						gint _tmp98_;
						gint _tmp99_;
						gint _tmp100_;
						void** _tmp101_;
						gint _tmp102_;
						gint _tmp103_;
						gint _tmp104_;
						gint _tmp105_;
						gint _tmp106_;
						_tmp94_ = a->length;
						_vala_assert (_tmp94_ >= 0, "a.length >= 0");
						_tmp95_ = b->length;
						_vala_assert (_tmp95_ >= 0, "b.length >= 0");
						_tmp96_ = self->priv->list;
						_tmp97_ = a->index;
						_tmp98_ = dest;
						_tmp99_ = a->length;
						_tmp100_ = a->length;
						vala_tim_sort_slice_merge_in_reversed (a, _tmp96_, _tmp97_, _tmp98_ - _tmp99_, _tmp100_);
						_tmp101_ = self->priv->list;
						_tmp102_ = b->index;
						_tmp103_ = dest;
						_tmp104_ = a->length;
						_tmp105_ = b->length;
						_tmp106_ = b->length;
						vala_tim_sort_slice_merge_in_reversed (b, _tmp101_, _tmp102_, (_tmp103_ - _tmp104_) - _tmp105_, _tmp106_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp107_ = self->priv->list;
				_tmp108_ = dest;
				dest = _tmp108_ - 1;
				_tmp109_ = dest;
				_tmp110_ = vala_tim_sort_slice_pop_last (b);
				_tmp107_[_tmp109_] = _tmp110_;
				_tmp111_ = _tmp107_[_tmp109_];
				_tmp112_ = b->length;
				if (_tmp112_ == 1) {
					{
						gint _tmp113_;
						gint _tmp114_;
						void** _tmp115_;
						gint _tmp116_;
						gint _tmp117_;
						gint _tmp118_;
						gint _tmp119_;
						void** _tmp120_;
						gint _tmp121_;
						gint _tmp122_;
						gint _tmp123_;
						gint _tmp124_;
						gint _tmp125_;
						_tmp113_ = a->length;
						_vala_assert (_tmp113_ >= 0, "a.length >= 0");
						_tmp114_ = b->length;
						_vala_assert (_tmp114_ >= 0, "b.length >= 0");
						_tmp115_ = self->priv->list;
						_tmp116_ = a->index;
						_tmp117_ = dest;
						_tmp118_ = a->length;
						_tmp119_ = a->length;
						vala_tim_sort_slice_merge_in_reversed (a, _tmp115_, _tmp116_, _tmp117_ - _tmp118_, _tmp119_);
						_tmp120_ = self->priv->list;
						_tmp121_ = b->index;
						_tmp122_ = dest;
						_tmp123_ = a->length;
						_tmp124_ = b->length;
						_tmp125_ = b->length;
						vala_tim_sort_slice_merge_in_reversed (b, _tmp120_, _tmp121_, (_tmp122_ - _tmp123_) - _tmp124_, _tmp125_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp126_ = vala_tim_sort_slice_peek_last (a);
				_tmp127_ = b->length;
				k = vala_tim_sort_gallop_leftmost (self, _tmp126_, b, _tmp127_ - 1);
				_tmp128_ = b->length;
				_tmp129_ = k;
				b_count = _tmp128_ - _tmp129_;
				_tmp130_ = self->priv->list;
				_tmp131_ = b->index;
				_tmp132_ = k;
				_tmp133_ = dest;
				_tmp134_ = b_count;
				_tmp135_ = b_count;
				vala_tim_sort_slice_merge_in_reversed (b, _tmp130_, _tmp131_ + _tmp132_, _tmp133_ - _tmp134_, _tmp135_);
				_tmp136_ = dest;
				_tmp137_ = b_count;
				dest = _tmp136_ - _tmp137_;
				_tmp138_ = b_count;
				vala_tim_sort_slice_shorten_end (b, _tmp138_);
				_tmp139_ = b->length;
				if (_tmp139_ <= 1) {
					{
						gint _tmp140_;
						gint _tmp141_;
						void** _tmp142_;
						gint _tmp143_;
						gint _tmp144_;
						gint _tmp145_;
						gint _tmp146_;
						void** _tmp147_;
						gint _tmp148_;
						gint _tmp149_;
						gint _tmp150_;
						gint _tmp151_;
						gint _tmp152_;
						_tmp140_ = a->length;
						_vala_assert (_tmp140_ >= 0, "a.length >= 0");
						_tmp141_ = b->length;
						_vala_assert (_tmp141_ >= 0, "b.length >= 0");
						_tmp142_ = self->priv->list;
						_tmp143_ = a->index;
						_tmp144_ = dest;
						_tmp145_ = a->length;
						_tmp146_ = a->length;
						vala_tim_sort_slice_merge_in_reversed (a, _tmp142_, _tmp143_, _tmp144_ - _tmp145_, _tmp146_);
						_tmp147_ = self->priv->list;
						_tmp148_ = b->index;
						_tmp149_ = dest;
						_tmp150_ = a->length;
						_tmp151_ = b->length;
						_tmp152_ = b->length;
						vala_tim_sort_slice_merge_in_reversed (b, _tmp147_, _tmp148_, (_tmp149_ - _tmp150_) - _tmp151_, _tmp152_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp153_ = self->priv->list;
				_tmp154_ = dest;
				dest = _tmp154_ - 1;
				_tmp155_ = dest;
				_tmp156_ = vala_tim_sort_slice_pop_last (a);
				_tmp153_[_tmp155_] = _tmp156_;
				_tmp157_ = _tmp153_[_tmp155_];
				_tmp158_ = a->length;
				if (_tmp158_ == 0) {
					{
						gint _tmp159_;
						gint _tmp160_;
						void** _tmp161_;
						gint _tmp162_;
						gint _tmp163_;
						gint _tmp164_;
						gint _tmp165_;
						void** _tmp166_;
						gint _tmp167_;
						gint _tmp168_;
						gint _tmp169_;
						gint _tmp170_;
						gint _tmp171_;
						_tmp159_ = a->length;
						_vala_assert (_tmp159_ >= 0, "a.length >= 0");
						_tmp160_ = b->length;
						_vala_assert (_tmp160_ >= 0, "b.length >= 0");
						_tmp161_ = self->priv->list;
						_tmp162_ = a->index;
						_tmp163_ = dest;
						_tmp164_ = a->length;
						_tmp165_ = a->length;
						vala_tim_sort_slice_merge_in_reversed (a, _tmp161_, _tmp162_, _tmp163_ - _tmp164_, _tmp165_);
						_tmp166_ = self->priv->list;
						_tmp167_ = b->index;
						_tmp168_ = dest;
						_tmp169_ = a->length;
						_tmp170_ = b->length;
						_tmp171_ = b->length;
						vala_tim_sort_slice_merge_in_reversed (b, _tmp166_, _tmp167_, (_tmp168_ - _tmp169_) - _tmp170_, _tmp171_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp173_ = a_count;
				if (_tmp173_ < VALA_TIM_SORT_MINIMUM_GALLOP) {
					gint _tmp174_;
					_tmp174_ = b_count;
					_tmp172_ = _tmp174_ < VALA_TIM_SORT_MINIMUM_GALLOP;
				} else {
					_tmp172_ = FALSE;
				}
				if (_tmp172_) {
					break;
				}
			}
			_tmp175_ = minimum_gallop;
			minimum_gallop = _tmp175_ + 1;
			_tmp176_ = minimum_gallop;
			self->priv->minimum_gallop = _tmp176_;
		}
	}
	__finally1:
	{
		gint _tmp177_;
		gint _tmp178_;
		void** _tmp179_;
		gint _tmp180_;
		gint _tmp181_;
		gint _tmp182_;
		gint _tmp183_;
		void** _tmp184_;
		gint _tmp185_;
		gint _tmp186_;
		gint _tmp187_;
		gint _tmp188_;
		gint _tmp189_;
		_tmp177_ = a->length;
		_vala_assert (_tmp177_ >= 0, "a.length >= 0");
		_tmp178_ = b->length;
		_vala_assert (_tmp178_ >= 0, "b.length >= 0");
		_tmp179_ = self->priv->list;
		_tmp180_ = a->index;
		_tmp181_ = dest;
		_tmp182_ = a->length;
		_tmp183_ = a->length;
		vala_tim_sort_slice_merge_in_reversed (a, _tmp179_, _tmp180_, _tmp181_ - _tmp182_, _tmp183_);
		_tmp184_ = self->priv->list;
		_tmp185_ = b->index;
		_tmp186_ = dest;
		_tmp187_ = a->length;
		_tmp188_ = b->length;
		_tmp189_ = b->length;
		vala_tim_sort_slice_merge_in_reversed (b, _tmp184_, _tmp185_, (_tmp186_ - _tmp187_) - _tmp188_, _tmp189_);
	}
	_vala_tim_sort_slice_free0 (a);
	_vala_tim_sort_slice_free0 (b);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return;
}


G_GNUC_INTERNAL ValaTimSort*
vala_tim_sort_construct (GType object_type,
                         GType g_type,
                         GBoxedCopyFunc g_dup_func,
                         GDestroyNotify g_destroy_func)
{
	ValaTimSort* self = NULL;
	self = (ValaTimSort*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


G_GNUC_INTERNAL ValaTimSort*
vala_tim_sort_new (GType g_type,
                   GBoxedCopyFunc g_dup_func,
                   GDestroyNotify g_destroy_func)
{
	return vala_tim_sort_construct (VALA_TYPE_TIM_SORT, g_type, g_dup_func, g_destroy_func);
}


static ValaTimSortSlice*
vala_tim_sort_slice_new (void** list,
                         gint index,
                         gint length)
{
	ValaTimSortSlice* self;
	self = g_slice_new0 (ValaTimSortSlice);
	vala_tim_sort_slice_instance_init (self);
	self->list = list;
	self->index = index;
	self->length = length;
	return self;
}


static void
vala_tim_sort_slice_copy (ValaTimSortSlice* self)
{
	void** _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	void** _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	_tmp1_ = self->index;
	_tmp2_ = self->length;
	_tmp3_ = g_memdup (&_tmp0_[_tmp1_], ((guint) sizeof (gpointer)) * _tmp2_);
	self->new_list = _tmp3_;
	_tmp4_ = self->new_list;
	self->list = _tmp4_;
	self->index = 0;
}


static inline void
vala_tim_sort_slice_merge_in (ValaTimSortSlice* self,
                              void** dest_array,
                              gint index,
                              gint dest_index,
                              gint count)
{
	void** _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	g_memmove (&dest_array[dest_index], &_tmp0_[index], (gsize) (sizeof (gpointer) * count));
}


static inline void
vala_tim_sort_slice_merge_in_reversed (ValaTimSortSlice* self,
                                       void** dest_array,
                                       gint index,
                                       gint dest_index,
                                       gint count)
{
	void** _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	g_memmove (&dest_array[dest_index], &_tmp0_[index], (gsize) (sizeof (gpointer) * count));
}


static inline void
vala_tim_sort_slice_shorten_start (ValaTimSortSlice* self,
                                   gint n)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->index;
	self->index = _tmp0_ + n;
	_tmp1_ = self->length;
	self->length = _tmp1_ - n;
}


static inline void
vala_tim_sort_slice_shorten_end (ValaTimSortSlice* self,
                                 gint n)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->length;
	self->length = _tmp0_ - n;
}


static inline void*
vala_tim_sort_slice_pop_first (ValaTimSortSlice* self)
{
	void* result = NULL;
	gint _tmp0_;
	void** _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->length;
	self->length = _tmp0_ - 1;
	_tmp1_ = self->list;
	_tmp2_ = self->index;
	self->index = _tmp2_ + 1;
	_tmp3_ = _tmp1_[_tmp2_];
	result = _tmp3_;
	return result;
}


static inline void*
vala_tim_sort_slice_pop_last (ValaTimSortSlice* self)
{
	void* result = NULL;
	gint _tmp0_;
	void** _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	void* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->length;
	self->length = _tmp0_ - 1;
	_tmp1_ = self->list;
	_tmp2_ = self->index;
	_tmp3_ = self->length;
	_tmp4_ = _tmp1_[_tmp2_ + _tmp3_];
	result = _tmp4_;
	return result;
}


static inline void*
vala_tim_sort_slice_peek_first (ValaTimSortSlice* self)
{
	void* result = NULL;
	void** _tmp0_;
	gint _tmp1_;
	void* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->list;
	_tmp1_ = self->index;
	_tmp2_ = _tmp0_[_tmp1_];
	result = _tmp2_;
	return result;
}


static inline void*
vala_tim_sort_slice_peek_last (ValaTimSortSlice* self)
{
	void* result = NULL;
	void** _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->list;
	_tmp1_ = self->index;
	_tmp2_ = self->length;
	_tmp3_ = _tmp0_[(_tmp1_ + _tmp2_) - 1];
	result = _tmp3_;
	return result;
}


static void
vala_tim_sort_slice_reverse (ValaTimSortSlice* self)
{
	gint low = 0;
	gint _tmp0_;
	gint high = 0;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->index;
	low = _tmp0_;
	_tmp1_ = self->index;
	_tmp2_ = self->length;
	high = (_tmp1_ + _tmp2_) - 1;
	while (TRUE) {
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = low;
		_tmp4_ = high;
		if (!(_tmp3_ < _tmp4_)) {
			break;
		}
		_tmp5_ = low;
		low = _tmp5_ + 1;
		_tmp6_ = high;
		high = _tmp6_ - 1;
		vala_tim_sort_slice_swap (self, _tmp5_, _tmp6_);
	}
}


static inline void
vala_tim_sort_slice_swap (ValaTimSortSlice* self,
                          gint i,
                          gint j)
{
	void* temp = NULL;
	void** _tmp0_;
	void* _tmp1_;
	void** _tmp2_;
	void** _tmp3_;
	void* _tmp4_;
	void* _tmp5_;
	void** _tmp6_;
	void* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	_tmp1_ = _tmp0_[i];
	temp = _tmp1_;
	_tmp2_ = self->list;
	_tmp3_ = self->list;
	_tmp4_ = _tmp3_[j];
	_tmp2_[i] = _tmp4_;
	_tmp5_ = _tmp2_[i];
	_tmp6_ = self->list;
	_tmp6_[j] = temp;
	_tmp7_ = _tmp6_[j];
}


static void
vala_tim_sort_slice_instance_init (ValaTimSortSlice * self)
{
}


static void
vala_tim_sort_slice_free (ValaTimSortSlice * self)
{
	void** _tmp0_;
	_tmp0_ = self->new_list;
	if (_tmp0_ != NULL) {
		void** _tmp1_;
		_tmp1_ = self->new_list;
		g_free (_tmp1_);
	}
	g_slice_free (ValaTimSortSlice, self);
}


static void
vala_value_tim_sort_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_tim_sort_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_tim_sort_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_tim_sort_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_tim_sort_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_tim_sort_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_tim_sort_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaTimSort * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_tim_sort_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_tim_sort_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	ValaTimSort ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_tim_sort_ref (value->data[0].v_pointer);
	}
	return NULL;
}


G_GNUC_INTERNAL GParamSpec*
vala_param_spec_tim_sort (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ValaParamSpecTimSort* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_TIM_SORT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


G_GNUC_INTERNAL gpointer
vala_value_get_tim_sort (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TIM_SORT), NULL);
	return value->data[0].v_pointer;
}


G_GNUC_INTERNAL void
vala_value_set_tim_sort (GValue* value,
                         gpointer v_object)
{
	ValaTimSort * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TIM_SORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_TIM_SORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_tim_sort_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_tim_sort_unref (old);
	}
}


G_GNUC_INTERNAL void
vala_value_take_tim_sort (GValue* value,
                          gpointer v_object)
{
	ValaTimSort * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TIM_SORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_TIM_SORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_tim_sort_unref (old);
	}
}


static void
vala_tim_sort_class_init (ValaTimSortClass * klass)
{
	vala_tim_sort_parent_class = g_type_class_peek_parent (klass);
	((ValaTimSortClass *) klass)->finalize = vala_tim_sort_finalize;
	g_type_class_adjust_private_offset (klass, &ValaTimSort_private_offset);
}


static void
vala_tim_sort_instance_init (ValaTimSort * self)
{
	self->priv = vala_tim_sort_get_instance_private (self);
	self->ref_count = 1;
}


static void
vala_tim_sort_finalize (ValaTimSort * obj)
{
	ValaTimSort * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_TIM_SORT, ValaTimSort);
	g_signal_handlers_destroy (self);
	_vala_iterable_unref0 (self->priv->list_collection);
	self->priv->array = (_vala_array_free (self->priv->array, self->priv->array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	self->priv->pending = (_vala_array_free (self->priv->pending, self->priv->pending_length1, (GDestroyNotify) vala_tim_sort_slice_free), NULL);
}


/**
 * A stable, adaptive, iterative mergesort that requires far fewer than n*lg(n)
 * comparisons when running on partially sorted arrays, while offering
 * performance comparable to a traditional mergesort when run on random arrays.
 * Like all proper mergesorts, this sort is stable and runs O(n*log(n)) time
 * (worst case). In the worst case, this sort requires temporary storage space
 * for n/2 object references; in the best case, it requires only a small
 * constant amount of space.
 *
 * This implementation was adapted from Tim Peters's list sort for Python,
 * which is described in detail here:
 * [[http://svn.python.org/projects/python/trunk/Objects/listsort.txt]]
 *
 * Tim's C code may be found here:
 * [[http://svn.python.org/projects/python/trunk/Objects/listobject.c]]
 *
 * The underlying techniques are described in this paper (and may have even
 * earlier origins):
 *
 *   "Optimistic Sorting and Information Theoretic Complexity"
 *   Peter McIlroy
 *   SODA (Fourth Annual ACM-SIAM Symposium on Discrete Algorithms), pp
 *   467-474, Austin, Texas, 25-27 January 1993.
 */
G_GNUC_INTERNAL GType
vala_tim_sort_get_type (void)
{
	static volatile gsize vala_tim_sort_type_id__volatile = 0;
	if (g_once_init_enter (&vala_tim_sort_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_tim_sort_init, vala_value_tim_sort_free_value, vala_value_tim_sort_copy_value, vala_value_tim_sort_peek_pointer, "p", vala_value_tim_sort_collect_value, "p", vala_value_tim_sort_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaTimSortClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_tim_sort_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTimSort), 0, (GInstanceInitFunc) vala_tim_sort_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_tim_sort_type_id;
		vala_tim_sort_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaTimSort", &g_define_type_info, &g_define_type_fundamental_info, 0);
		ValaTimSort_private_offset = g_type_add_instance_private (vala_tim_sort_type_id, sizeof (ValaTimSortPrivate));
		g_once_init_leave (&vala_tim_sort_type_id__volatile, vala_tim_sort_type_id);
	}
	return vala_tim_sort_type_id__volatile;
}


G_GNUC_INTERNAL gpointer
vala_tim_sort_ref (gpointer instance)
{
	ValaTimSort * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


G_GNUC_INTERNAL void
vala_tim_sort_unref (gpointer instance)
{
	ValaTimSort * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_TIM_SORT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void
_vala_array_move (gpointer array,
                  gsize element_size,
                  gint src,
                  gint dest,
                  gint length)
{
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}



