/* serializer.c generated by valac 0.38.7, the Vala compiler
 * generated from serializer.vala, do not modify */

/*
 * Copyright (C) 2010 Robin Sonefors
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <langinfo.h>
#include <glib/gi18n-lib.h>


#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
typedef struct _SerializerPrivate SerializerPrivate;
enum  {
	SERIALIZER_0_PROPERTY,
	SERIALIZER_ERROR_PROPERTY,
	SERIALIZER_NUM_PROPERTIES
};
static GParamSpec* serializer_properties[SERIALIZER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

struct _Serializer {
	GObject parent_instance;
	SerializerPrivate * priv;
};

struct _SerializerClass {
	GObjectClass parent_class;
};

struct _SerializerPrivate {
	gint leading_digits;
	gint trailing_digits;
	DisplayFormat format;
	gboolean show_tsep;
	gboolean show_zeroes;
	gint number_base;
	guint representation_base;
	gunichar radix;
	gunichar tsep;
	gint tsep_count;
	gchar* _error;
};


static gpointer serializer_parent_class = NULL;

GType display_format_get_type (void) G_GNUC_CONST;
GType serializer_get_type (void) G_GNUC_CONST;
#define SERIALIZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SERIALIZER, SerializerPrivate))
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
GType number_get_type (void) G_GNUC_CONST;
gchar* serializer_to_string (Serializer* self, Number* x);
static gchar* serializer_cast_to_string (Serializer* self, Number* x, gint* n_digits);
gint serializer_get_base (Serializer* self);
static gchar* serializer_cast_to_exponential_string (Serializer* self, Number* x, gboolean eng_format, gint* n_digits);
Number* serializer_from_string (Serializer* self, const gchar* str);
Number* mp_set_from_string (const gchar* str, gint default_base);
void serializer_set_base (Serializer* self, gint number_base);
void serializer_set_representation_base (Serializer* self, guint representation_base);
guint serializer_get_representation_base (Serializer* self);
void serializer_set_radix (Serializer* self, gunichar radix);
gunichar serializer_get_radix (Serializer* self);
void serializer_set_thousands_separator (Serializer* self, gunichar separator);
gunichar serializer_get_thousands_separator (Serializer* self);
gint serializer_get_thousands_separator_count (Serializer* self);
void serializer_set_thousands_separator_count (Serializer* self, gint count);
void serializer_set_show_thousands_separators (Serializer* self, gboolean visible);
gboolean serializer_get_show_thousands_separators (Serializer* self);
void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible);
gboolean serializer_get_show_trailing_zeroes (Serializer* self);
gint serializer_get_leading_digits (Serializer* self);
void serializer_set_leading_digits (Serializer* self, gint leading_digits);
gint serializer_get_trailing_digits (Serializer* self);
void serializer_set_trailing_digits (Serializer* self, gint trailing_digits);
DisplayFormat serializer_get_number_format (Serializer* self);
void serializer_set_number_format (Serializer* self, DisplayFormat format);
Number* number_real_component (Number* self);
static void serializer_cast_to_string_real (Serializer* self, Number* x, gint number_base, gboolean force_sign, gint* n_digits, GString* string);
gboolean number_is_complex (Number* self);
Number* number_imaginary_component (Number* self);
gboolean number_is_negative (Number* self);
Number* number_abs (Number* self);
Number* number_new_integer (gint64 real, gint64 imag);
Number* number_construct_integer (GType object_type, gint64 real, gint64 imag);
Number* number_xpowy_integer (Number* self, gint64 n);
Number* number_multiply_integer (Number* self, gint64 y);
Number* number_divide_integer (Number* self, gint64 y);
Number* number_add (Number* self, Number* y);
Number* number_floor (Number* self);
gboolean number_is_zero (Number* self);
Number* number_subtract (Number* self, Number* y);
gint64 number_to_integer (Number* self);
void serializer_set_error (Serializer* self, const gchar* value);
Number* number_fractional_component (Number* self);
static gint serializer_cast_to_exponential_string_real (Serializer* self, Number* x, GString* string, gboolean eng_format, gint* n_digits);
Number* number_divide (Number* self, Number* y);
gint number_compare (Number* self, Number* y);
Number* number_multiply (Number* self, Number* y);
static void serializer_append_exponent (Serializer* self, GString* string, gint exponent);
const gchar* serializer_get_error (Serializer* self);
static void serializer_finalize (GObject * obj);
static void _vala_serializer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_serializer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType display_format_get_type (void) {
	static volatile gsize display_format_type_id__volatile = 0;
	if (g_once_init_enter (&display_format_type_id__volatile)) {
		static const GEnumValue values[] = {{DISPLAY_FORMAT_AUTOMATIC, "DISPLAY_FORMAT_AUTOMATIC", "automatic"}, {DISPLAY_FORMAT_FIXED, "DISPLAY_FORMAT_FIXED", "fixed"}, {DISPLAY_FORMAT_SCIENTIFIC, "DISPLAY_FORMAT_SCIENTIFIC", "scientific"}, {DISPLAY_FORMAT_ENGINEERING, "DISPLAY_FORMAT_ENGINEERING", "engineering"}, {0, NULL, NULL}};
		GType display_format_type_id;
		display_format_type_id = g_enum_register_static ("DisplayFormat", values);
		g_once_init_leave (&display_format_type_id__volatile, display_format_type_id);
	}
	return display_format_type_id__volatile;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits) {
	Serializer * self = NULL;
	gchar* radix_string = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* tsep_string = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	DisplayFormat _tmp23_;
	self = (Serializer*) g_object_new (object_type, NULL);
	_tmp0_ = nl_langinfo (RADIXCHAR);
	_tmp1_ = g_strdup (_tmp0_);
	radix_string = _tmp1_;
	_tmp3_ = radix_string;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = radix_string;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* radix_utf8 = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = radix_string;
		_tmp6_ = g_locale_to_utf8 (_tmp5_, (gssize) -1, NULL, NULL, NULL);
		radix_utf8 = _tmp6_;
		_tmp7_ = radix_utf8;
		if (_tmp7_ != NULL) {
			const gchar* _tmp8_;
			gunichar _tmp9_;
			_tmp8_ = radix_utf8;
			_tmp9_ = string_get_char (_tmp8_, (glong) 0);
			self->priv->radix = _tmp9_;
		} else {
			self->priv->radix = (gunichar) '.';
		}
		_g_free0 (radix_utf8);
	} else {
		self->priv->radix = (gunichar) '.';
	}
	_tmp10_ = nl_langinfo (THOUSEP);
	_tmp11_ = g_strdup (_tmp10_);
	tsep_string = _tmp11_;
	_tmp13_ = tsep_string;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = tsep_string;
		_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gchar* tsep_utf8 = NULL;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp15_ = tsep_string;
		_tmp16_ = g_locale_to_utf8 (_tmp15_, (gssize) -1, NULL, NULL, NULL);
		tsep_utf8 = _tmp16_;
		_tmp17_ = tsep_utf8;
		if (_tmp17_ != NULL) {
			const gchar* _tmp18_;
			gunichar _tmp19_;
			_tmp18_ = tsep_utf8;
			_tmp19_ = string_get_char (_tmp18_, (glong) 0);
			self->priv->tsep = _tmp19_;
		} else {
			self->priv->tsep = (gunichar) ' ';
		}
		_g_free0 (tsep_utf8);
	} else {
		self->priv->tsep = (gunichar) ' ';
	}
	self->priv->tsep_count = 3;
	_tmp20_ = number_base;
	self->priv->number_base = _tmp20_;
	_tmp21_ = number_base;
	self->priv->representation_base = (guint) _tmp21_;
	self->priv->leading_digits = 12;
	_tmp22_ = trailing_digits;
	self->priv->trailing_digits = _tmp22_;
	self->priv->show_zeroes = FALSE;
	self->priv->show_tsep = FALSE;
	_tmp23_ = format;
	self->priv->format = _tmp23_;
	_g_free0 (tsep_string);
	_g_free0 (radix_string);
	return self;
}


Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits) {
	return serializer_construct (TYPE_SERIALIZER, format, number_base, trailing_digits);
}


gchar* serializer_to_string (Serializer* self, Number* x) {
	gchar* result = NULL;
	guint _tmp0_;
	gint _tmp1_;
	DisplayFormat _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->representation_base;
	_tmp1_ = self->priv->number_base;
	if (_tmp0_ != ((guint) _tmp1_)) {
		gint n_digits = 0;
		Number* _tmp2_;
		gchar* _tmp3_;
		n_digits = 0;
		_tmp2_ = x;
		_tmp3_ = serializer_cast_to_string (self, _tmp2_, &n_digits);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->format;
	switch (_tmp4_) {
		default:
		case DISPLAY_FORMAT_AUTOMATIC:
		{
			gint n_digits = 0;
			gchar* s0 = NULL;
			Number* _tmp5_;
			gchar* _tmp6_;
			gint _tmp7_;
			n_digits = 0;
			_tmp5_ = x;
			_tmp6_ = serializer_cast_to_string (self, _tmp5_, &n_digits);
			s0 = _tmp6_;
			_tmp7_ = serializer_get_base (self);
			switch (_tmp7_) {
				case 2:
				{
					gint _tmp8_;
					_tmp8_ = n_digits;
					if (_tmp8_ <= 64) {
						result = s0;
						return result;
					} else {
						Number* _tmp9_;
						gchar* _tmp10_;
						_tmp9_ = x;
						_tmp10_ = serializer_cast_to_exponential_string (self, _tmp9_, FALSE, &n_digits);
						result = _tmp10_;
						_g_free0 (s0);
						return result;
					}
				}
				case 8:
				{
					gint _tmp11_;
					_tmp11_ = n_digits;
					if (_tmp11_ <= 22) {
						result = s0;
						return result;
					} else {
						Number* _tmp12_;
						gchar* _tmp13_;
						_tmp12_ = x;
						_tmp13_ = serializer_cast_to_exponential_string (self, _tmp12_, FALSE, &n_digits);
						result = _tmp13_;
						_g_free0 (s0);
						return result;
					}
				}
				case 16:
				{
					gint _tmp14_;
					_tmp14_ = n_digits;
					if (_tmp14_ <= 16) {
						result = s0;
						return result;
					} else {
						Number* _tmp15_;
						gchar* _tmp16_;
						_tmp15_ = x;
						_tmp16_ = serializer_cast_to_exponential_string (self, _tmp15_, FALSE, &n_digits);
						result = _tmp16_;
						_g_free0 (s0);
						return result;
					}
				}
				default:
				case 10:
				{
					gint _tmp17_;
					gint _tmp18_;
					_tmp17_ = n_digits;
					_tmp18_ = self->priv->leading_digits;
					if (_tmp17_ <= _tmp18_) {
						result = s0;
						return result;
					} else {
						Number* _tmp19_;
						gchar* _tmp20_;
						_tmp19_ = x;
						_tmp20_ = serializer_cast_to_exponential_string (self, _tmp19_, FALSE, &n_digits);
						result = _tmp20_;
						_g_free0 (s0);
						return result;
					}
				}
			}
			_g_free0 (s0);
		}
		case DISPLAY_FORMAT_FIXED:
		{
			gint n_digits = 0;
			Number* _tmp21_;
			gchar* _tmp22_;
			n_digits = 0;
			_tmp21_ = x;
			_tmp22_ = serializer_cast_to_string (self, _tmp21_, &n_digits);
			result = _tmp22_;
			return result;
		}
		case DISPLAY_FORMAT_SCIENTIFIC:
		{
			guint _tmp23_;
			_tmp23_ = self->priv->representation_base;
			if (_tmp23_ == ((guint) 10)) {
				gint n_digits = 0;
				Number* _tmp24_;
				gchar* _tmp25_;
				n_digits = 0;
				_tmp24_ = x;
				_tmp25_ = serializer_cast_to_exponential_string (self, _tmp24_, FALSE, &n_digits);
				result = _tmp25_;
				return result;
			} else {
				gint n_digits = 0;
				Number* _tmp26_;
				gchar* _tmp27_;
				n_digits = 0;
				_tmp26_ = x;
				_tmp27_ = serializer_cast_to_string (self, _tmp26_, &n_digits);
				result = _tmp27_;
				return result;
			}
		}
		case DISPLAY_FORMAT_ENGINEERING:
		{
			guint _tmp28_;
			_tmp28_ = self->priv->representation_base;
			if (_tmp28_ == ((guint) 10)) {
				gint n_digits = 0;
				Number* _tmp29_;
				gchar* _tmp30_;
				n_digits = 0;
				_tmp29_ = x;
				_tmp30_ = serializer_cast_to_exponential_string (self, _tmp29_, TRUE, &n_digits);
				result = _tmp30_;
				return result;
			} else {
				gint n_digits = 0;
				Number* _tmp31_;
				gchar* _tmp32_;
				n_digits = 0;
				_tmp31_ = x;
				_tmp32_ = serializer_cast_to_string (self, _tmp31_, &n_digits);
				result = _tmp32_;
				return result;
			}
		}
	}
}


Number* serializer_from_string (Serializer* self, const gchar* str) {
	Number* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	Number* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = self->priv->number_base;
	_tmp2_ = mp_set_from_string (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


void serializer_set_base (Serializer* self, gint number_base) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = number_base;
	self->priv->number_base = _tmp0_;
}


gint serializer_get_base (Serializer* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->number_base;
	result = _tmp0_;
	return result;
}


void serializer_set_representation_base (Serializer* self, guint representation_base) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = representation_base;
	self->priv->representation_base = _tmp0_;
}


guint serializer_get_representation_base (Serializer* self) {
	guint result = 0U;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->representation_base;
	result = _tmp0_;
	return result;
}


void serializer_set_radix (Serializer* self, gunichar radix) {
	gunichar _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = radix;
	self->priv->radix = _tmp0_;
}


gunichar serializer_get_radix (Serializer* self) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->radix;
	result = _tmp0_;
	return result;
}


void serializer_set_thousands_separator (Serializer* self, gunichar separator) {
	gunichar _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = separator;
	self->priv->tsep = _tmp0_;
}


gunichar serializer_get_thousands_separator (Serializer* self) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->tsep;
	result = _tmp0_;
	return result;
}


gint serializer_get_thousands_separator_count (Serializer* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tsep_count;
	result = _tmp0_;
	return result;
}


void serializer_set_thousands_separator_count (Serializer* self, gint count) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = count;
	self->priv->tsep_count = _tmp0_;
}


void serializer_set_show_thousands_separators (Serializer* self, gboolean visible) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = visible;
	self->priv->show_tsep = _tmp0_;
}


gboolean serializer_get_show_thousands_separators (Serializer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->show_tsep;
	result = _tmp0_;
	return result;
}


void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = visible;
	self->priv->show_zeroes = _tmp0_;
}


gboolean serializer_get_show_trailing_zeroes (Serializer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->show_zeroes;
	result = _tmp0_;
	return result;
}


gint serializer_get_leading_digits (Serializer* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->leading_digits;
	result = _tmp0_;
	return result;
}


void serializer_set_leading_digits (Serializer* self, gint leading_digits) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = leading_digits;
	self->priv->leading_digits = _tmp0_;
}


gint serializer_get_trailing_digits (Serializer* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->trailing_digits;
	result = _tmp0_;
	return result;
}


void serializer_set_trailing_digits (Serializer* self, gint trailing_digits) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = trailing_digits;
	self->priv->trailing_digits = _tmp0_;
}


DisplayFormat serializer_get_number_format (Serializer* self) {
	DisplayFormat result = 0;
	DisplayFormat _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->format;
	result = _tmp0_;
	return result;
}


void serializer_set_number_format (Serializer* self, DisplayFormat format) {
	DisplayFormat _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = format;
	self->priv->format = _tmp0_;
}


static gchar* serializer_cast_to_string (Serializer* self, Number* x, gint* n_digits) {
	gchar* result = NULL;
	GString* string = NULL;
	GString* _tmp0_;
	Number* x_real = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	guint _tmp4_;
	GString* _tmp5_;
	Number* _tmp6_;
	gboolean _tmp7_;
	GString* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = g_string_sized_new ((gsize) 1024);
	string = _tmp0_;
	_tmp1_ = x;
	_tmp2_ = number_real_component (_tmp1_);
	x_real = _tmp2_;
	_tmp3_ = x_real;
	_tmp4_ = self->priv->representation_base;
	_tmp5_ = string;
	serializer_cast_to_string_real (self, _tmp3_, (gint) _tmp4_, FALSE, n_digits, _tmp5_);
	_tmp6_ = x;
	_tmp7_ = number_is_complex (_tmp6_);
	if (_tmp7_) {
		Number* x_im = NULL;
		Number* _tmp8_;
		Number* _tmp9_;
		gboolean force_sign = FALSE;
		GString* _tmp10_;
		const gchar* _tmp11_;
		GString* s = NULL;
		GString* _tmp13_;
		gint n_complex_digits = 0;
		Number* _tmp14_;
		guint _tmp15_;
		gboolean _tmp16_;
		GString* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		GString* _tmp23_;
		const gchar* _tmp24_;
		_tmp8_ = x;
		_tmp9_ = number_imaginary_component (_tmp8_);
		x_im = _tmp9_;
		force_sign = TRUE;
		_tmp10_ = string;
		_tmp11_ = _tmp10_->str;
		if (g_strcmp0 (_tmp11_, "0") == 0) {
			GString* _tmp12_;
			_tmp12_ = string;
			g_string_assign (_tmp12_, "");
			force_sign = FALSE;
		}
		_tmp13_ = g_string_sized_new ((gsize) 1024);
		s = _tmp13_;
		n_complex_digits = 0;
		_tmp14_ = x_im;
		_tmp15_ = self->priv->representation_base;
		_tmp16_ = force_sign;
		_tmp17_ = s;
		serializer_cast_to_string_real (self, _tmp14_, (gint) _tmp15_, _tmp16_, &n_complex_digits, _tmp17_);
		_tmp18_ = n_complex_digits;
		_tmp19_ = *n_digits;
		if (_tmp18_ > _tmp19_) {
			gint _tmp20_;
			_tmp20_ = n_complex_digits;
			*n_digits = _tmp20_;
		}
		_tmp23_ = s;
		_tmp24_ = _tmp23_->str;
		if (g_strcmp0 (_tmp24_, "0") == 0) {
			_tmp22_ = TRUE;
		} else {
			GString* _tmp25_;
			const gchar* _tmp26_;
			_tmp25_ = s;
			_tmp26_ = _tmp25_->str;
			_tmp22_ = g_strcmp0 (_tmp26_, "+0") == 0;
		}
		if (_tmp22_) {
			_tmp21_ = TRUE;
		} else {
			GString* _tmp27_;
			const gchar* _tmp28_;
			_tmp27_ = s;
			_tmp28_ = _tmp27_->str;
			_tmp21_ = g_strcmp0 (_tmp28_, "−0") == 0;
		}
		if (_tmp21_) {
		} else {
			GString* _tmp29_;
			const gchar* _tmp30_;
			_tmp29_ = s;
			_tmp30_ = _tmp29_->str;
			if (g_strcmp0 (_tmp30_, "1") == 0) {
				GString* _tmp31_;
				_tmp31_ = string;
				g_string_append (_tmp31_, "i");
			} else {
				GString* _tmp32_;
				const gchar* _tmp33_;
				_tmp32_ = s;
				_tmp33_ = _tmp32_->str;
				if (g_strcmp0 (_tmp33_, "+1") == 0) {
					GString* _tmp34_;
					_tmp34_ = string;
					g_string_append (_tmp34_, "+i");
				} else {
					GString* _tmp35_;
					const gchar* _tmp36_;
					_tmp35_ = s;
					_tmp36_ = _tmp35_->str;
					if (g_strcmp0 (_tmp36_, "−1") == 0) {
						GString* _tmp37_;
						_tmp37_ = string;
						g_string_append (_tmp37_, "−i");
					} else {
						GString* _tmp38_;
						const gchar* _tmp39_;
						GString* _tmp46_;
						_tmp38_ = s;
						_tmp39_ = _tmp38_->str;
						if (g_strcmp0 (_tmp39_, "+0") == 0) {
							GString* _tmp40_;
							_tmp40_ = string;
							g_string_append (_tmp40_, "+");
						} else {
							GString* _tmp41_;
							const gchar* _tmp42_;
							_tmp41_ = s;
							_tmp42_ = _tmp41_->str;
							if (g_strcmp0 (_tmp42_, "0") != 0) {
								GString* _tmp43_;
								GString* _tmp44_;
								const gchar* _tmp45_;
								_tmp43_ = string;
								_tmp44_ = s;
								_tmp45_ = _tmp44_->str;
								g_string_append (_tmp43_, _tmp45_);
							}
						}
						_tmp46_ = string;
						g_string_append (_tmp46_, "i");
					}
				}
			}
		}
		_g_string_free0 (s);
		_g_object_unref0 (x_im);
	}
	_tmp47_ = string;
	_tmp48_ = _tmp47_->str;
	_tmp49_ = g_strdup (_tmp48_);
	result = _tmp49_;
	_g_object_unref0 (x_real);
	_g_string_free0 (string);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void serializer_cast_to_string_real (Serializer* self, Number* x, gint number_base, gboolean force_sign, gint* n_digits, GString* string) {
	static const gchar digits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
	Number* number = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	gboolean _tmp3_;
	Number* temp = NULL;
	gint _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	gint _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	gint _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* rounded_number = NULL;
	Number* _tmp16_;
	Number* _tmp17_;
	Number* _tmp18_;
	Number* _tmp19_;
	Number* _tmp20_;
	gint i = 0;
	gssize last_non_zero = 0L;
	GString* _tmp57_;
	gssize _tmp58_;
	GString* _tmp59_;
	gunichar _tmp60_;
	Number* _tmp61_;
	Number* _tmp62_;
	gboolean _tmp85_ = FALSE;
	gboolean _tmp86_;
	gboolean _tmp90_ = FALSE;
	GString* _tmp91_;
	const gchar* _tmp92_;
	gint _tmp99_;
	gint _tmp100_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (x != NULL);
	g_return_if_fail (string != NULL);
	_tmp0_ = x;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	number = _tmp1_;
	_tmp2_ = number;
	_tmp3_ = number_is_negative (_tmp2_);
	if (_tmp3_) {
		Number* _tmp4_;
		Number* _tmp5_;
		_tmp4_ = number;
		_tmp5_ = number_abs (_tmp4_);
		_g_object_unref0 (number);
		number = _tmp5_;
	}
	_tmp6_ = number_base;
	_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
	temp = _tmp7_;
	_tmp8_ = temp;
	_tmp9_ = self->priv->trailing_digits;
	_tmp10_ = number_xpowy_integer (_tmp8_, (gint64) (-(_tmp9_ + 1)));
	_g_object_unref0 (temp);
	temp = _tmp10_;
	_tmp11_ = temp;
	_tmp12_ = number_base;
	_tmp13_ = number_multiply_integer (_tmp11_, (gint64) _tmp12_);
	_g_object_unref0 (temp);
	temp = _tmp13_;
	_tmp14_ = temp;
	_tmp15_ = number_divide_integer (_tmp14_, (gint64) 2);
	_g_object_unref0 (temp);
	temp = _tmp15_;
	_tmp16_ = number;
	_tmp17_ = temp;
	_tmp18_ = number_add (_tmp16_, _tmp17_);
	rounded_number = _tmp18_;
	_tmp19_ = rounded_number;
	_tmp20_ = number_floor (_tmp19_);
	_g_object_unref0 (temp);
	temp = _tmp20_;
	i = 0;
	{
		gboolean _tmp21_ = FALSE;
		_tmp21_ = TRUE;
		while (TRUE) {
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gint _tmp26_;
			gint _tmp32_;
			Number* t = NULL;
			Number* _tmp33_;
			gint _tmp34_;
			Number* _tmp35_;
			Number* _tmp36_;
			Number* _tmp37_;
			Number* t2 = NULL;
			Number* _tmp38_;
			gint _tmp39_;
			Number* _tmp40_;
			Number* t3 = NULL;
			Number* _tmp41_;
			Number* _tmp42_;
			Number* _tmp43_;
			gint64 d = 0LL;
			Number* _tmp44_;
			gint64 _tmp45_;
			gboolean _tmp46_ = FALSE;
			gint64 _tmp47_;
			gint _tmp54_;
			Number* _tmp55_;
			Number* _tmp56_;
			if (!_tmp21_) {
				Number* _tmp22_;
				gboolean _tmp23_;
				_tmp22_ = temp;
				_tmp23_ = number_is_zero (_tmp22_);
				if (!(!_tmp23_)) {
					break;
				}
			}
			_tmp21_ = FALSE;
			_tmp26_ = number_base;
			if (_tmp26_ == 10) {
				gboolean _tmp27_;
				_tmp27_ = self->priv->show_tsep;
				_tmp25_ = _tmp27_;
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				gint _tmp28_;
				gint _tmp29_;
				_tmp28_ = i;
				_tmp29_ = self->priv->tsep_count;
				_tmp24_ = _tmp28_ == _tmp29_;
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				GString* _tmp30_;
				gunichar _tmp31_;
				_tmp30_ = string;
				_tmp31_ = self->priv->tsep;
				g_string_prepend_unichar (_tmp30_, _tmp31_);
				i = 0;
			}
			_tmp32_ = i;
			i = _tmp32_ + 1;
			_tmp33_ = temp;
			_tmp34_ = number_base;
			_tmp35_ = number_divide_integer (_tmp33_, (gint64) _tmp34_);
			t = _tmp35_;
			_tmp36_ = t;
			_tmp37_ = number_floor (_tmp36_);
			_g_object_unref0 (t);
			t = _tmp37_;
			_tmp38_ = t;
			_tmp39_ = number_base;
			_tmp40_ = number_multiply_integer (_tmp38_, (gint64) _tmp39_);
			t2 = _tmp40_;
			_tmp41_ = temp;
			_tmp42_ = t2;
			_tmp43_ = number_subtract (_tmp41_, _tmp42_);
			t3 = _tmp43_;
			_tmp44_ = t3;
			_tmp45_ = number_to_integer (_tmp44_);
			d = _tmp45_;
			_tmp47_ = d;
			if (_tmp47_ < ((gint64) 16)) {
				gint64 _tmp48_;
				_tmp48_ = d;
				_tmp46_ = _tmp48_ >= ((gint64) 0);
			} else {
				_tmp46_ = FALSE;
			}
			if (_tmp46_) {
				GString* _tmp49_;
				gint64 _tmp50_;
				gchar _tmp51_;
				_tmp49_ = string;
				_tmp50_ = d;
				_tmp51_ = digits[_tmp50_];
				g_string_prepend_c (_tmp49_, _tmp51_);
			} else {
				GString* _tmp52_;
				GString* _tmp53_;
				_tmp52_ = string;
				g_string_prepend_c (_tmp52_, '?');
				serializer_set_error (self, _ ("Overflow: the result couldn’t be calculated"));
				_tmp53_ = string;
				g_string_assign (_tmp53_, "0");
				_g_object_unref0 (t3);
				_g_object_unref0 (t2);
				_g_object_unref0 (t);
				break;
			}
			_tmp54_ = *n_digits;
			*n_digits = _tmp54_ + 1;
			_tmp55_ = t;
			_tmp56_ = _g_object_ref0 (_tmp55_);
			_g_object_unref0 (temp);
			temp = _tmp56_;
			_g_object_unref0 (t3);
			_g_object_unref0 (t2);
			_g_object_unref0 (t);
		}
	}
	_tmp57_ = string;
	_tmp58_ = _tmp57_->len;
	last_non_zero = _tmp58_;
	_tmp59_ = string;
	_tmp60_ = self->priv->radix;
	g_string_append_unichar (_tmp59_, _tmp60_);
	_tmp61_ = rounded_number;
	_tmp62_ = number_fractional_component (_tmp61_);
	_g_object_unref0 (temp);
	temp = _tmp62_;
	{
		gboolean _tmp63_ = FALSE;
		i = 0;
		_tmp63_ = TRUE;
		while (TRUE) {
			gint _tmp65_;
			gint _tmp66_;
			Number* _tmp67_;
			gboolean _tmp68_;
			Number* _tmp69_;
			gint _tmp70_;
			Number* _tmp71_;
			Number* digit = NULL;
			Number* _tmp72_;
			Number* _tmp73_;
			gint64 d = 0LL;
			Number* _tmp74_;
			gint64 _tmp75_;
			GString* _tmp76_;
			gint64 _tmp77_;
			gchar _tmp78_;
			gint64 _tmp79_;
			Number* _tmp82_;
			Number* _tmp83_;
			Number* _tmp84_;
			if (!_tmp63_) {
				gint _tmp64_;
				_tmp64_ = i;
				i = _tmp64_ + 1;
			}
			_tmp63_ = FALSE;
			_tmp65_ = i;
			_tmp66_ = self->priv->trailing_digits;
			if (!(_tmp65_ < _tmp66_)) {
				break;
			}
			_tmp67_ = temp;
			_tmp68_ = number_is_zero (_tmp67_);
			if (_tmp68_) {
				break;
			}
			_tmp69_ = temp;
			_tmp70_ = number_base;
			_tmp71_ = number_multiply_integer (_tmp69_, (gint64) _tmp70_);
			_g_object_unref0 (temp);
			temp = _tmp71_;
			_tmp72_ = temp;
			_tmp73_ = number_floor (_tmp72_);
			digit = _tmp73_;
			_tmp74_ = digit;
			_tmp75_ = number_to_integer (_tmp74_);
			d = _tmp75_;
			_tmp76_ = string;
			_tmp77_ = d;
			_tmp78_ = digits[_tmp77_];
			g_string_append_c (_tmp76_, _tmp78_);
			_tmp79_ = d;
			if (_tmp79_ != ((gint64) 0)) {
				GString* _tmp80_;
				gssize _tmp81_;
				_tmp80_ = string;
				_tmp81_ = _tmp80_->len;
				last_non_zero = _tmp81_;
			}
			_tmp82_ = temp;
			_tmp83_ = digit;
			_tmp84_ = number_subtract (_tmp82_, _tmp83_);
			_g_object_unref0 (temp);
			temp = _tmp84_;
			_g_object_unref0 (digit);
		}
	}
	_tmp86_ = self->priv->show_zeroes;
	if (!_tmp86_) {
		_tmp85_ = TRUE;
	} else {
		gint _tmp87_;
		_tmp87_ = self->priv->trailing_digits;
		_tmp85_ = _tmp87_ == 0;
	}
	if (_tmp85_) {
		GString* _tmp88_;
		gssize _tmp89_;
		_tmp88_ = string;
		_tmp89_ = last_non_zero;
		g_string_truncate (_tmp88_, (gsize) _tmp89_);
	}
	_tmp91_ = string;
	_tmp92_ = _tmp91_->str;
	if (g_strcmp0 (_tmp92_, "0") != 0) {
		_tmp90_ = TRUE;
	} else {
		gboolean _tmp93_;
		_tmp93_ = force_sign;
		_tmp90_ = _tmp93_;
	}
	if (_tmp90_) {
		Number* _tmp94_;
		gboolean _tmp95_;
		_tmp94_ = x;
		_tmp95_ = number_is_negative (_tmp94_);
		if (_tmp95_) {
			GString* _tmp96_;
			_tmp96_ = string;
			g_string_prepend (_tmp96_, "−");
		} else {
			gboolean _tmp97_;
			_tmp97_ = force_sign;
			if (_tmp97_) {
				GString* _tmp98_;
				_tmp98_ = string;
				g_string_prepend (_tmp98_, "+");
			}
		}
	}
	_tmp99_ = number_base;
	_tmp100_ = self->priv->number_base;
	if (_tmp99_ != _tmp100_) {
		static const gchar* sub_digits[] = {"₀", "₁", "₂", "₃", "₄", "₅", "₆", "₇", "₈", "₉"};
		gint multiplier = 0;
		gint b = 0;
		gint _tmp101_;
		multiplier = 1;
		_tmp101_ = number_base;
		b = _tmp101_;
		while (TRUE) {
			gint _tmp102_;
			gint _tmp103_;
			gint _tmp104_;
			_tmp102_ = number_base;
			_tmp103_ = multiplier;
			if (!((_tmp102_ / _tmp103_) != 0)) {
				break;
			}
			_tmp104_ = multiplier;
			multiplier = _tmp104_ * 10;
		}
		while (TRUE) {
			gint _tmp105_;
			gint d = 0;
			gint _tmp106_;
			gint _tmp107_;
			gint _tmp108_;
			GString* _tmp109_;
			gint _tmp110_;
			const gchar* _tmp111_;
			gint _tmp112_;
			gint _tmp113_;
			gint _tmp114_;
			_tmp105_ = multiplier;
			if (!(_tmp105_ != 1)) {
				break;
			}
			_tmp106_ = multiplier;
			multiplier = _tmp106_ / 10;
			_tmp107_ = b;
			_tmp108_ = multiplier;
			d = _tmp107_ / _tmp108_;
			_tmp109_ = string;
			_tmp110_ = d;
			_tmp111_ = sub_digits[_tmp110_];
			g_string_append (_tmp109_, _tmp111_);
			_tmp112_ = b;
			_tmp113_ = d;
			_tmp114_ = multiplier;
			b = _tmp112_ - (_tmp113_ * _tmp114_);
		}
	}
	_g_object_unref0 (rounded_number);
	_g_object_unref0 (temp);
	_g_object_unref0 (number);
}


static gint serializer_cast_to_exponential_string_real (Serializer* self, Number* x, GString* string, gboolean eng_format, gint* n_digits) {
	gint result = 0;
	Number* _tmp0_;
	gboolean _tmp1_;
	Number* mantissa = NULL;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* base_ = NULL;
	gint _tmp5_;
	Number* _tmp6_;
	Number* base3 = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* base10 = NULL;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* t = NULL;
	Number* _tmp11_;
	Number* base10inv = NULL;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	gint exponent = 0;
	Number* _tmp15_;
	gboolean _tmp16_;
	GString* _tmp64_;
	Number* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (x != NULL, 0);
	g_return_val_if_fail (string != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = number_is_negative (_tmp0_);
	if (_tmp1_) {
		GString* _tmp2_;
		_tmp2_ = string;
		g_string_append (_tmp2_, "−");
	}
	_tmp3_ = x;
	_tmp4_ = number_abs (_tmp3_);
	mantissa = _tmp4_;
	_tmp5_ = self->priv->number_base;
	_tmp6_ = number_new_integer ((gint64) _tmp5_, (gint64) 0);
	base_ = _tmp6_;
	_tmp7_ = base_;
	_tmp8_ = number_xpowy_integer (_tmp7_, (gint64) 3);
	base3 = _tmp8_;
	_tmp9_ = base_;
	_tmp10_ = number_xpowy_integer (_tmp9_, (gint64) 10);
	base10 = _tmp10_;
	_tmp11_ = number_new_integer ((gint64) 1, (gint64) 0);
	t = _tmp11_;
	_tmp12_ = t;
	_tmp13_ = base10;
	_tmp14_ = number_divide (_tmp12_, _tmp13_);
	base10inv = _tmp14_;
	exponent = 0;
	_tmp15_ = mantissa;
	_tmp16_ = number_is_zero (_tmp15_);
	if (!_tmp16_) {
		Number* _tmp52_;
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_;
			gint _tmp22_;
			Number* _tmp23_;
			Number* _tmp24_;
			Number* _tmp25_;
			_tmp18_ = eng_format;
			if (!_tmp18_) {
				Number* _tmp19_;
				Number* _tmp20_;
				gint _tmp21_;
				_tmp19_ = mantissa;
				_tmp20_ = base10;
				_tmp21_ = number_compare (_tmp19_, _tmp20_);
				_tmp17_ = _tmp21_ >= 0;
			} else {
				_tmp17_ = FALSE;
			}
			if (!_tmp17_) {
				break;
			}
			_tmp22_ = exponent;
			exponent = _tmp22_ + 10;
			_tmp23_ = mantissa;
			_tmp24_ = base10inv;
			_tmp25_ = number_multiply (_tmp23_, _tmp24_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp25_;
		}
		while (TRUE) {
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_;
			gint _tmp39_;
			Number* _tmp40_;
			Number* _tmp41_;
			Number* _tmp42_;
			_tmp28_ = eng_format;
			if (!_tmp28_) {
				Number* _tmp29_;
				Number* _tmp30_;
				gint _tmp31_;
				_tmp29_ = mantissa;
				_tmp30_ = base_;
				_tmp31_ = number_compare (_tmp29_, _tmp30_);
				_tmp27_ = _tmp31_ >= 0;
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				_tmp26_ = TRUE;
			} else {
				gboolean _tmp32_ = FALSE;
				gboolean _tmp33_;
				_tmp33_ = eng_format;
				if (_tmp33_) {
					gboolean _tmp34_ = FALSE;
					Number* _tmp35_;
					Number* _tmp36_;
					gint _tmp37_;
					_tmp35_ = mantissa;
					_tmp36_ = base3;
					_tmp37_ = number_compare (_tmp35_, _tmp36_);
					if (_tmp37_ >= 0) {
						_tmp34_ = TRUE;
					} else {
						gint _tmp38_;
						_tmp38_ = exponent;
						_tmp34_ = (_tmp38_ % 3) != 0;
					}
					_tmp32_ = _tmp34_;
				} else {
					_tmp32_ = FALSE;
				}
				_tmp26_ = _tmp32_;
			}
			if (!_tmp26_) {
				break;
			}
			_tmp39_ = exponent;
			exponent = _tmp39_ + 1;
			_tmp40_ = mantissa;
			_tmp41_ = base_;
			_tmp42_ = number_divide (_tmp40_, _tmp41_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp42_;
		}
		while (TRUE) {
			gboolean _tmp43_ = FALSE;
			gboolean _tmp44_;
			gint _tmp48_;
			Number* _tmp49_;
			Number* _tmp50_;
			Number* _tmp51_;
			_tmp44_ = eng_format;
			if (!_tmp44_) {
				Number* _tmp45_;
				Number* _tmp46_;
				gint _tmp47_;
				_tmp45_ = mantissa;
				_tmp46_ = base10inv;
				_tmp47_ = number_compare (_tmp45_, _tmp46_);
				_tmp43_ = _tmp47_ < 0;
			} else {
				_tmp43_ = FALSE;
			}
			if (!_tmp43_) {
				break;
			}
			_tmp48_ = exponent;
			exponent = _tmp48_ - 10;
			_tmp49_ = mantissa;
			_tmp50_ = base10;
			_tmp51_ = number_multiply (_tmp49_, _tmp50_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp51_;
		}
		_tmp52_ = number_new_integer ((gint64) 1, (gint64) 0);
		_g_object_unref0 (t);
		t = _tmp52_;
		while (TRUE) {
			gboolean _tmp53_ = FALSE;
			Number* _tmp54_;
			Number* _tmp55_;
			gint _tmp56_;
			gint _tmp60_;
			Number* _tmp61_;
			Number* _tmp62_;
			Number* _tmp63_;
			_tmp54_ = mantissa;
			_tmp55_ = t;
			_tmp56_ = number_compare (_tmp54_, _tmp55_);
			if (_tmp56_ < 0) {
				_tmp53_ = TRUE;
			} else {
				gboolean _tmp57_ = FALSE;
				gboolean _tmp58_;
				_tmp58_ = eng_format;
				if (_tmp58_) {
					gint _tmp59_;
					_tmp59_ = exponent;
					_tmp57_ = (_tmp59_ % 3) != 0;
				} else {
					_tmp57_ = FALSE;
				}
				_tmp53_ = _tmp57_;
			}
			if (!_tmp53_) {
				break;
			}
			_tmp60_ = exponent;
			exponent = _tmp60_ - 1;
			_tmp61_ = mantissa;
			_tmp62_ = base_;
			_tmp63_ = number_multiply (_tmp61_, _tmp62_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp63_;
		}
	}
	_tmp64_ = string;
	_tmp65_ = mantissa;
	_tmp66_ = serializer_cast_to_string (self, _tmp65_, n_digits);
	_tmp67_ = _tmp66_;
	g_string_append (_tmp64_, _tmp67_);
	_g_free0 (_tmp67_);
	result = exponent;
	_g_object_unref0 (base10inv);
	_g_object_unref0 (t);
	_g_object_unref0 (base10);
	_g_object_unref0 (base3);
	_g_object_unref0 (base_);
	_g_object_unref0 (mantissa);
	return result;
}


static gchar* serializer_cast_to_exponential_string (Serializer* self, Number* x, gboolean eng_format, gint* n_digits) {
	gchar* result = NULL;
	GString* string = NULL;
	GString* _tmp0_;
	Number* x_real = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	gint exponent = 0;
	Number* _tmp3_;
	GString* _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	GString* _tmp7_;
	gint _tmp8_;
	Number* _tmp9_;
	gboolean _tmp10_;
	GString* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = g_string_sized_new ((gsize) 1024);
	string = _tmp0_;
	_tmp1_ = x;
	_tmp2_ = number_real_component (_tmp1_);
	x_real = _tmp2_;
	_tmp3_ = x_real;
	_tmp4_ = string;
	_tmp5_ = eng_format;
	_tmp6_ = serializer_cast_to_exponential_string_real (self, _tmp3_, _tmp4_, _tmp5_, n_digits);
	exponent = _tmp6_;
	_tmp7_ = string;
	_tmp8_ = exponent;
	serializer_append_exponent (self, _tmp7_, _tmp8_);
	_tmp9_ = x;
	_tmp10_ = number_is_complex (_tmp9_);
	if (_tmp10_) {
		Number* x_im = NULL;
		Number* _tmp11_;
		Number* _tmp12_;
		GString* _tmp13_;
		const gchar* _tmp14_;
		GString* s = NULL;
		GString* _tmp16_;
		gint n_complex_digits = 0;
		Number* _tmp17_;
		GString* _tmp18_;
		gboolean _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		GString* _tmp26_;
		const gchar* _tmp27_;
		GString* _tmp50_;
		gint _tmp51_;
		_tmp11_ = x;
		_tmp12_ = number_imaginary_component (_tmp11_);
		x_im = _tmp12_;
		_tmp13_ = string;
		_tmp14_ = _tmp13_->str;
		if (g_strcmp0 (_tmp14_, "0") == 0) {
			GString* _tmp15_;
			_tmp15_ = string;
			g_string_assign (_tmp15_, "");
		}
		_tmp16_ = g_string_sized_new ((gsize) 1024);
		s = _tmp16_;
		n_complex_digits = 0;
		_tmp17_ = x_im;
		_tmp18_ = s;
		_tmp19_ = eng_format;
		_tmp20_ = serializer_cast_to_exponential_string_real (self, _tmp17_, _tmp18_, _tmp19_, &n_complex_digits);
		exponent = _tmp20_;
		_tmp21_ = n_complex_digits;
		_tmp22_ = *n_digits;
		if (_tmp21_ > _tmp22_) {
			gint _tmp23_;
			_tmp23_ = n_complex_digits;
			*n_digits = _tmp23_;
		}
		_tmp26_ = s;
		_tmp27_ = _tmp26_->str;
		if (g_strcmp0 (_tmp27_, "0") == 0) {
			_tmp25_ = TRUE;
		} else {
			GString* _tmp28_;
			const gchar* _tmp29_;
			_tmp28_ = s;
			_tmp29_ = _tmp28_->str;
			_tmp25_ = g_strcmp0 (_tmp29_, "+0") == 0;
		}
		if (_tmp25_) {
			_tmp24_ = TRUE;
		} else {
			GString* _tmp30_;
			const gchar* _tmp31_;
			_tmp30_ = s;
			_tmp31_ = _tmp30_->str;
			_tmp24_ = g_strcmp0 (_tmp31_, "−0") == 0;
		}
		if (_tmp24_) {
		} else {
			GString* _tmp32_;
			const gchar* _tmp33_;
			_tmp32_ = s;
			_tmp33_ = _tmp32_->str;
			if (g_strcmp0 (_tmp33_, "1") == 0) {
				GString* _tmp34_;
				_tmp34_ = string;
				g_string_append (_tmp34_, "i");
			} else {
				GString* _tmp35_;
				const gchar* _tmp36_;
				_tmp35_ = s;
				_tmp36_ = _tmp35_->str;
				if (g_strcmp0 (_tmp36_, "+1") == 0) {
					GString* _tmp37_;
					_tmp37_ = string;
					g_string_append (_tmp37_, "+i");
				} else {
					GString* _tmp38_;
					const gchar* _tmp39_;
					_tmp38_ = s;
					_tmp39_ = _tmp38_->str;
					if (g_strcmp0 (_tmp39_, "−1") == 0) {
						GString* _tmp40_;
						_tmp40_ = string;
						g_string_append (_tmp40_, "−i");
					} else {
						GString* _tmp41_;
						const gchar* _tmp42_;
						GString* _tmp49_;
						_tmp41_ = s;
						_tmp42_ = _tmp41_->str;
						if (g_strcmp0 (_tmp42_, "+0") == 0) {
							GString* _tmp43_;
							_tmp43_ = string;
							g_string_append (_tmp43_, "+");
						} else {
							GString* _tmp44_;
							const gchar* _tmp45_;
							_tmp44_ = s;
							_tmp45_ = _tmp44_->str;
							if (g_strcmp0 (_tmp45_, "0") != 0) {
								GString* _tmp46_;
								GString* _tmp47_;
								const gchar* _tmp48_;
								_tmp46_ = string;
								_tmp47_ = s;
								_tmp48_ = _tmp47_->str;
								g_string_append (_tmp46_, _tmp48_);
							}
						}
						_tmp49_ = string;
						g_string_append (_tmp49_, "i");
					}
				}
			}
		}
		_tmp50_ = string;
		_tmp51_ = exponent;
		serializer_append_exponent (self, _tmp50_, _tmp51_);
		_g_string_free0 (s);
		_g_object_unref0 (x_im);
	}
	_tmp52_ = string;
	_tmp53_ = _tmp52_->str;
	_tmp54_ = g_strdup (_tmp53_);
	result = _tmp54_;
	_g_object_unref0 (x_real);
	_g_string_free0 (string);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void serializer_append_exponent (Serializer* self, GString* string, gint exponent) {
	static const gunichar super_digits[] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
	gint _tmp0_;
	GString* _tmp1_;
	gint _tmp2_;
	gchar* super_value = NULL;
	gint _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (string != NULL);
	_tmp0_ = exponent;
	if (_tmp0_ == 0) {
		return;
	}
	_tmp1_ = string;
	g_string_append (_tmp1_, "×10");
	_tmp2_ = exponent;
	if (_tmp2_ < 0) {
		gint _tmp3_;
		GString* _tmp4_;
		_tmp3_ = exponent;
		exponent = -_tmp3_;
		_tmp4_ = string;
		g_string_append_unichar (_tmp4_, 8315U);
	}
	_tmp5_ = exponent;
	_tmp6_ = g_strdup_printf ("%d", _tmp5_);
	super_value = _tmp6_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				GString* _tmp13_;
				const gchar* _tmp14_;
				gint _tmp15_;
				gchar _tmp16_;
				gunichar _tmp17_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = super_value;
				_tmp11_ = strlen (_tmp10_);
				_tmp12_ = _tmp11_;
				if (!(_tmp9_ < _tmp12_)) {
					break;
				}
				_tmp13_ = string;
				_tmp14_ = super_value;
				_tmp15_ = i;
				_tmp16_ = string_get (_tmp14_, (glong) _tmp15_);
				_tmp17_ = super_digits[_tmp16_ - '0'];
				g_string_append_unichar (_tmp13_, _tmp17_);
			}
		}
	}
	_g_free0 (super_value);
}


const gchar* serializer_get_error (Serializer* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error;
	result = _tmp0_;
	return result;
}


void serializer_set_error (Serializer* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, serializer_get_error (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_error);
		self->priv->_error = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, serializer_properties[SERIALIZER_ERROR_PROPERTY]);
	}
}


static void serializer_class_init (SerializerClass * klass) {
	serializer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SerializerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_serializer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_serializer_set_property;
	G_OBJECT_CLASS (klass)->finalize = serializer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SERIALIZER_ERROR_PROPERTY, serializer_properties[SERIALIZER_ERROR_PROPERTY] = g_param_spec_string ("error", "error", "error", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void serializer_instance_init (Serializer * self) {
	self->priv = SERIALIZER_GET_PRIVATE (self);
	self->priv->_error = NULL;
}


static void serializer_finalize (GObject * obj) {
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SERIALIZER, Serializer);
	_g_free0 (self->priv->_error);
	G_OBJECT_CLASS (serializer_parent_class)->finalize (obj);
}


GType serializer_get_type (void) {
	static volatile gsize serializer_type_id__volatile = 0;
	if (g_once_init_enter (&serializer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SerializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) serializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Serializer), 0, (GInstanceInitFunc) serializer_instance_init, NULL };
		GType serializer_type_id;
		serializer_type_id = g_type_register_static (G_TYPE_OBJECT, "Serializer", &g_define_type_info, 0);
		g_once_init_leave (&serializer_type_id__volatile, serializer_type_id);
	}
	return serializer_type_id__volatile;
}


static void _vala_serializer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SERIALIZER, Serializer);
	switch (property_id) {
		case SERIALIZER_ERROR_PROPERTY:
		g_value_set_string (value, serializer_get_error (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_serializer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SERIALIZER, Serializer);
	switch (property_id) {
		case SERIALIZER_ERROR_PROPERTY:
		serializer_set_error (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



