/* test-equation.c generated by valac 0.38.4, the Vala compiler
 * generated from test-equation.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include "libcalculator.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>


#define TYPE_TEST_EQUATION (test_equation_get_type ())
#define TEST_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_EQUATION, TestEquation))
#define TEST_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_EQUATION, TestEquationClass))
#define IS_TEST_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_EQUATION))
#define IS_TEST_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_EQUATION))
#define TEST_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_EQUATION, TestEquationClass))

typedef struct _TestEquation TestEquation;
typedef struct _TestEquationClass TestEquationClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TestEquationPrivate TestEquationPrivate;
enum  {
	TEST_EQUATION_0_PROPERTY,
	TEST_EQUATION_NUM_PROPERTIES
};
static GParamSpec* test_equation_properties[TEST_EQUATION_NUM_PROPERTIES];

struct _TestEquation {
	Equation parent_instance;
	TestEquationPrivate * priv;
};

struct _TestEquationClass {
	EquationClass parent_class;
};

struct _TestEquationPrivate {
	gboolean enable_variables;
	gboolean enable_conversions;
};


extern gint number_base;
gint number_base = 10;
extern gint wordlen;
gint wordlen = 32;
extern AngleUnit angle_units;
AngleUnit angle_units = ANGLE_UNIT_DEGREES;
extern gboolean enable_conversions;
gboolean enable_conversions = FALSE;
extern gboolean enable_variables;
gboolean enable_variables = FALSE;
extern gint fail_count;
gint fail_count = 0;
extern gint pass_count;
gint pass_count = 0;
static gpointer test_equation_parent_class = NULL;

gchar* error_code_to_string (ErrorCode _error_);
void test (const gchar* expression, const gchar* expected, ErrorCode expected_error);
GType test_equation_get_type (void) G_GNUC_CONST;
TestEquation* test_equation_new (const gchar* equation, gboolean enable_variables, gboolean enable_conversions);
TestEquation* test_equation_construct (GType object_type, const gchar* equation, gboolean enable_variables, gboolean enable_conversions);
#define TEST_EQUATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST_EQUATION, TestEquationPrivate))
static gboolean test_equation_real_variable_is_defined (Equation* base, const gchar* name);
static Number* test_equation_real_get_variable (Equation* base, const gchar* name);
static Number* test_equation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units);
static void test_equation_finalize (GObject * obj);
void test_conversions (void);
void test_equations (void);
void test_base_conversion (void);
void test_precedence (void);
void test_custom_functions (void);
gint _vala_main (gchar** args, int args_length1);


gchar* error_code_to_string (ErrorCode _error_) {
	gchar* result = NULL;
	ErrorCode _tmp0_;
	ErrorCode _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = _error_;
	if (_tmp0_ == ERROR_CODE_MP) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf ("ErrorCode.MP(\"%s\")", _tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = _error_;
	_tmp5_ = mp_error_code_to_string (_tmp4_);
	result = _tmp5_;
	return result;
}


void test (const gchar* expression, const gchar* expected, ErrorCode expected_error) {
	TestEquation* equation = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	TestEquation* _tmp3_;
	TestEquation* _tmp4_;
	gint _tmp5_;
	TestEquation* _tmp6_;
	gint _tmp7_;
	TestEquation* _tmp8_;
	AngleUnit _tmp9_;
	ErrorCode _error_ = 0;
	guint representation_base = 0U;
	Number* _result_ = NULL;
	TestEquation* _tmp10_;
	guint _tmp11_ = 0U;
	ErrorCode _tmp12_ = 0;
	Number* _tmp13_;
	Number* _tmp14_;
	g_return_if_fail (expression != NULL);
	g_return_if_fail (expected != NULL);
	_tmp0_ = expression;
	_tmp1_ = enable_variables;
	_tmp2_ = enable_conversions;
	_tmp3_ = test_equation_new (_tmp0_, _tmp1_, _tmp2_);
	equation = _tmp3_;
	_tmp4_ = equation;
	_tmp5_ = number_base;
	((Equation*) _tmp4_)->base = _tmp5_;
	_tmp6_ = equation;
	_tmp7_ = wordlen;
	((Equation*) _tmp6_)->wordlen = _tmp7_;
	_tmp8_ = equation;
	_tmp9_ = angle_units;
	((Equation*) _tmp8_)->angle_units = _tmp9_;
	_tmp10_ = equation;
	_tmp13_ = equation_parse ((Equation*) _tmp10_, &_tmp11_, &_tmp12_, NULL, NULL, NULL);
	representation_base = _tmp11_;
	_error_ = _tmp12_;
	_result_ = _tmp13_;
	_tmp14_ = _result_;
	if (_tmp14_ == NULL) {
		ErrorCode _tmp15_;
		ErrorCode _tmp16_;
		_tmp15_ = _error_;
		_tmp16_ = expected_error;
		if (_tmp15_ == _tmp16_) {
			gint _tmp17_;
			_tmp17_ = pass_count;
			pass_count = _tmp17_ + 1;
		} else {
			ErrorCode _tmp18_;
			_tmp18_ = expected_error;
			if (_tmp18_ == ERROR_CODE_NONE) {
				FILE* _tmp19_;
				const gchar* _tmp20_;
				ErrorCode _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				gint _tmp25_;
				_tmp19_ = stdout;
				_tmp20_ = expression;
				_tmp21_ = _error_;
				_tmp22_ = error_code_to_string (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = expected;
				fprintf (_tmp19_, "*FAIL: '%s' -> error %s, expected result %s\n", _tmp20_, _tmp23_, _tmp24_);
				_g_free0 (_tmp23_);
				_tmp25_ = fail_count;
				fail_count = _tmp25_ + 1;
			} else {
				FILE* _tmp26_;
				const gchar* _tmp27_;
				ErrorCode _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				ErrorCode _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gint _tmp34_;
				_tmp26_ = stdout;
				_tmp27_ = expression;
				_tmp28_ = _error_;
				_tmp29_ = error_code_to_string (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = expected_error;
				_tmp32_ = error_code_to_string (_tmp31_);
				_tmp33_ = _tmp32_;
				fprintf (_tmp26_, "*FAIL: '%s' -> error %s, expected error %s\n", _tmp27_, _tmp30_, _tmp33_);
				_g_free0 (_tmp33_);
				_g_free0 (_tmp30_);
				_tmp34_ = fail_count;
				fail_count = _tmp34_ + 1;
			}
		}
	} else {
		Serializer* serializer = NULL;
		gint _tmp35_;
		Serializer* _tmp36_;
		Serializer* _tmp37_;
		guint _tmp38_;
		gchar* result_str = NULL;
		Serializer* _tmp39_;
		Number* _tmp40_;
		gchar* _tmp41_;
		ErrorCode _tmp42_;
		_tmp35_ = number_base;
		_tmp36_ = serializer_new (DISPLAY_FORMAT_FIXED, _tmp35_, 9);
		serializer = _tmp36_;
		_tmp37_ = serializer;
		_tmp38_ = representation_base;
		serializer_set_representation_base (_tmp37_, _tmp38_);
		_tmp39_ = serializer;
		_tmp40_ = _result_;
		_tmp41_ = serializer_to_string (_tmp39_, _tmp40_);
		result_str = _tmp41_;
		_tmp42_ = expected_error;
		if (_tmp42_ != ERROR_CODE_NONE) {
			FILE* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			ErrorCode _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gint _tmp49_;
			_tmp43_ = stdout;
			_tmp44_ = expression;
			_tmp45_ = result_str;
			_tmp46_ = expected_error;
			_tmp47_ = error_code_to_string (_tmp46_);
			_tmp48_ = _tmp47_;
			fprintf (_tmp43_, "*FAIL: '%s' -> %s, expected error %s\n", _tmp44_, _tmp45_, _tmp48_);
			_g_free0 (_tmp48_);
			_tmp49_ = fail_count;
			fail_count = _tmp49_ + 1;
		} else {
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			_tmp50_ = result_str;
			_tmp51_ = expected;
			if (g_strcmp0 (_tmp50_, _tmp51_) != 0) {
				FILE* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				gint _tmp56_;
				_tmp52_ = stdout;
				_tmp53_ = expression;
				_tmp54_ = result_str;
				_tmp55_ = expected;
				fprintf (_tmp52_, "*FAIL: '%s' -> '%s', expected '%s'\n", _tmp53_, _tmp54_, _tmp55_);
				_tmp56_ = fail_count;
				fail_count = _tmp56_ + 1;
			} else {
				gint _tmp57_;
				_tmp57_ = pass_count;
				pass_count = _tmp57_ + 1;
			}
		}
		_g_free0 (result_str);
		_g_object_unref0 (serializer);
	}
	_g_object_unref0 (_result_);
	_g_object_unref0 (equation);
}


TestEquation* test_equation_construct (GType object_type, const gchar* equation, gboolean enable_variables, gboolean enable_conversions) {
	TestEquation * self = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (equation != NULL, NULL);
	_tmp0_ = equation;
	self = (TestEquation*) equation_construct (object_type, _tmp0_);
	_tmp1_ = enable_variables;
	self->priv->enable_variables = _tmp1_;
	_tmp2_ = enable_conversions;
	self->priv->enable_conversions = _tmp2_;
	return self;
}


TestEquation* test_equation_new (const gchar* equation, gboolean enable_variables, gboolean enable_conversions) {
	return test_equation_construct (TYPE_TEST_EQUATION, equation, enable_variables, enable_conversions);
}


static gboolean test_equation_real_variable_is_defined (Equation* base, const gchar* name) {
	TestEquation * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	self = (TestEquation*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->enable_variables;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = name;
	if (g_strcmp0 (_tmp2_, "x") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = name;
		_tmp1_ = g_strcmp0 (_tmp3_, "y") == 0;
	}
	result = _tmp1_;
	return result;
}


static Number* test_equation_real_get_variable (Equation* base, const gchar* name) {
	TestEquation * self;
	Number* result = NULL;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	self = (TestEquation*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->enable_variables;
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = name;
	if (g_strcmp0 (_tmp1_, "x") == 0) {
		Number* _tmp2_;
		_tmp2_ = number_new_integer ((gint64) 2, (gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = name;
	if (g_strcmp0 (_tmp3_, "y") == 0) {
		Number* _tmp4_;
		_tmp4_ = number_new_integer ((gint64) 3, (gint64) 0);
		result = _tmp4_;
		return result;
	}
	result = NULL;
	return result;
}


static Number* test_equation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units) {
	TestEquation * self;
	Number* result = NULL;
	gboolean _tmp0_;
	UnitManager* _tmp1_;
	UnitManager* _tmp2_;
	Number* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	self = (TestEquation*) base;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	_tmp0_ = self->priv->enable_conversions;
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = unit_manager_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = x;
	_tmp4_ = x_units;
	_tmp5_ = z_units;
	_tmp6_ = unit_manager_convert_by_symbol (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp2_);
	result = _tmp7_;
	return result;
}


static void test_equation_class_init (TestEquationClass * klass) {
	test_equation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TestEquationPrivate));
	((EquationClass *) klass)->variable_is_defined = (gboolean (*) (Equation *, const gchar*)) test_equation_real_variable_is_defined;
	((EquationClass *) klass)->get_variable = (Number* (*) (Equation *, const gchar*)) test_equation_real_get_variable;
	((EquationClass *) klass)->convert = (Number* (*) (Equation *, Number*, const gchar*, const gchar*)) test_equation_real_convert;
	G_OBJECT_CLASS (klass)->finalize = test_equation_finalize;
}


static void test_equation_instance_init (TestEquation * self) {
	self->priv = TEST_EQUATION_GET_PRIVATE (self);
}


static void test_equation_finalize (GObject * obj) {
	TestEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEST_EQUATION, TestEquation);
	G_OBJECT_CLASS (test_equation_parent_class)->finalize (obj);
}


GType test_equation_get_type (void) {
	static volatile gsize test_equation_type_id__volatile = 0;
	if (g_once_init_enter (&test_equation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestEquation), 0, (GInstanceInitFunc) test_equation_instance_init, NULL };
		GType test_equation_type_id;
		test_equation_type_id = g_type_register_static (TYPE_EQUATION, "TestEquation", &g_define_type_info, 0);
		g_once_init_leave (&test_equation_type_id__volatile, test_equation_type_id);
	}
	return test_equation_type_id__volatile;
}


void test_conversions (void) {
	number_base = 10;
	wordlen = 32;
	angle_units = ANGLE_UNIT_DEGREES;
	enable_conversions = TRUE;
	enable_variables = FALSE;
	test ("100 gradians in degrees", "90", 0);
	test ("1 meter in mm", "1000", 0);
	test ("1m in mm", "1000", 0);
	test ("1 inch in cm", "2.54", 0);
	test ("1m² in mm²", "1000000", 0);
	test ("1m³ in mm³", "1000000000", 0);
	test ("1 kg in pounds", "2.204622622", 0);
	test ("1 minute in seconds", "60", 0);
	test ("1s in ms", "1000", 0);
	test ("100degC in degF", "212", 0);
	test ("0degC in degF", "32", 0);
	test ("0 K in degC", "−273.15", 0);
	test ("0 k in c", "−273.15", 0);
	test ("-1 c in k", "272.15", 0);
	test ("1000 bits in bytes", "125", 0);
	test ("1000 bits in nibbles", "250", 0);
	test ("1000 bytes in kilobytes", "1", 0);
	test ("1 kB in bits", "8000", 0);
	test ("10 kB in B", "10000", 0);
	test ("1 GB in MB", "1000", 0);
	test ("100 MB in kilobytes", "100000", 0);
	test ("10000 MB in GB", "10", 0);
	test ("1000 GB in petabytes", "0.001", 0);
	test ("1 GB in MiB", "953.674316406", 0);
	test ("1 mebibit in B", "131072", 0);
	test ("10 kibibytes in b", "81920", 0);
	test ("1000 GiB in tebibytes", "0.9765625", 0);
	test ("100 MiB in Gib", "0.78125", 0);
	test ("10 TiB in MiB", "10485760", 0);
	test ("10 pebibytes in TiB", "10240", 0);
	test ("10 exbibytes in PiB", "10240", 0);
	test ("10 zebibytes in EiB", "10240", 0);
	test ("10 yobibytes in ZiB", "10240", 0);
}


void test_equations (void) {
	number_base = 10;
	wordlen = 32;
	angle_units = ANGLE_UNIT_DEGREES;
	enable_conversions = FALSE;
	enable_variables = TRUE;
	number_base = 2;
	test ("2₁₀", "10", 0);
	number_base = 8;
	test ("16434824₁₀", "76543210", 0);
	number_base = 16;
	test ("FF", "FF", 0);
	test ("18364758544493064720₁₀", "FEDCBA9876543210", 0);
	number_base = 10;
	test ("0₂", "0", 0);
	test ("0₈", "0", 0);
	test ("0", "0", 0);
	test ("0₁₆", "0", 0);
	test ("1₂", "1", 0);
	test ("1₈", "1", 0);
	test ("1", "1", 0);
	test ("1₁₆", "1", 0);
	test ("2₂", "", ERROR_CODE_INVALID);
	test ("2₈", "2", 0);
	test ("2", "2", 0);
	test ("2₁₆", "2", 0);
	test ("3₂", "", ERROR_CODE_INVALID);
	test ("3₈", "3", 0);
	test ("3", "3", 0);
	test ("3₁₆", "3", 0);
	test ("4₂", "", ERROR_CODE_INVALID);
	test ("4₈", "4", 0);
	test ("4", "4", 0);
	test ("4₁₆", "4", 0);
	test ("5₂", "", ERROR_CODE_INVALID);
	test ("5₈", "5", 0);
	test ("5", "5", 0);
	test ("5₁₆", "5", 0);
	test ("6₂", "", ERROR_CODE_INVALID);
	test ("6₈", "6", 0);
	test ("6", "6", 0);
	test ("6₁₆", "6", 0);
	test ("7₂", "", ERROR_CODE_INVALID);
	test ("7₈", "7", 0);
	test ("7", "7", 0);
	test ("7₁₆", "7", 0);
	test ("8₂", "", ERROR_CODE_INVALID);
	test ("8₈", "", ERROR_CODE_INVALID);
	test ("8", "8", 0);
	test ("8₁₆", "8", 0);
	test ("9₂", "", ERROR_CODE_INVALID);
	test ("9₈", "", ERROR_CODE_INVALID);
	test ("9", "9", 0);
	test ("9₁₆", "9", 0);
	test ("A₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("A₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("A", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("A₁₆", "10", 0);
	test ("B₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("B₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("B", "", ERROR_CODE_INVALID);
	test ("B₁₆", "11", 0);
	test ("C₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("C₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("C", "", ERROR_CODE_INVALID);
	test ("C₁₆", "12", 0);
	test ("D₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("D₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("D", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("D₁₆", "13", 0);
	test ("E₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("E₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("E", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("E₁₆", "14", 0);
	test ("F₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("F₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("F", "", ERROR_CODE_INVALID);
	test ("F₁₆", "15", 0);
	test ("a₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("a₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("a", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("a₁₆", "10", 0);
	test ("b₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("b₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("b", "", ERROR_CODE_INVALID);
	test ("b₁₆", "11", 0);
	test ("c₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("c₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("c", "", ERROR_CODE_INVALID);
	test ("c₁₆", "12", 0);
	test ("d₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("d₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("d", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("d₁₆", "13", 0);
	test ("e₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("e₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("e₁₆", "14", 0);
	test ("f₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("f₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("f", "", ERROR_CODE_INVALID);
	test ("f₁₆", "15", 0);
	test ("+1", "1", 0);
	test ("−1", "−1", 0);
	test ("+ 1", "1", 0);
	test ("− 1", "−1", 0);
	test ("++1", "1", ERROR_CODE_INVALID);
	test ("−−1", "1", 0);
	test ("255", "255", 0);
	test ("256", "256", 0);
	test ("½", "0.5", 0);
	test ("1½", "1.5", 0);
	test ("0°", "0", 0);
	test ("1°", "1", 0);
	test ("0°30'", "0.5", 0);
	test ("0°0'1\"", "0.000277778", 0);
	test ("0°0'0.1\"", "0.000027778", 0);
	test ("1.00", "1", 0);
	test ("1.01", "1.01", 0);
	test ("١٢٣٤٥٦٧٨٩٠", "1234567890", 0);
	test ("۱۲۳۴۵۶۷۸۹۰", "1234567890", 0);
	test ("2×10^3", "2000", 0);
	test ("2×10^−3", "0.002", 0);
	test ("x", "2", 0);
	test ("y", "3", 0);
	test ("z", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("2y", "6", 0);
	test ("y2", "", ERROR_CODE_INVALID);
	test ("y 2", "", ERROR_CODE_INVALID);
	test ("2z", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("z2", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("z 2", "", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("z(2)", "", ERROR_CODE_UNKNOWN_FUNCTION);
	test ("y²", "9", 0);
	test ("2y²", "18", 0);
	test ("x×y", "6", 0);
	test ("xy", "6", 0);
	test ("yx", "6", 0);
	test ("2xy", "12", 0);
	test ("x²y", "12", 0);
	test ("xy²", "18", 0);
	test ("(xy)²", "36", 0);
	test ("2x²y", "24", 0);
	test ("2xy²", "36", 0);
	test ("2x²y²", "72", 0);
	test ("x²yx²y", "144", 0);
	test ("x³+2x²−5", "11", 0);
	test ("2(x+3y)", "22", 0);
	test ("x(x+3y)", "22", 0);
	test ("(x+3y)(2x-4y)", "−88", 0);
	test ("2x²+2xy−12y²", "−88", 0);
	test ("π", "3.141592654", 0);
	test ("e", "2.718281828", 0);
	test ("z=99", "99", 0);
	test ("longname=99", "99", 0);
	test ("0+0", "0", 0);
	test ("1+1", "2", 0);
	test ("1+4", "5", 0);
	test ("4+1", "5", 0);
	test ("40000+0.001", "40000.001", 0);
	test ("0.001+40000", "40000.001", 0);
	test ("2-3", "−1", 0);
	test ("2−3", "−1", 0);
	test ("3−2", "1", 0);
	test ("40000−0.001", "39999.999", 0);
	test ("0.001−40000", "−39999.999", 0);
	test ("2*3", "6", 0);
	test ("2×3", "6", 0);
	test ("−2×3", "−6", 0);
	test ("2×−3", "−6", 0);
	test ("−2×−3", "6", 0);
	test ("6/3", "2", 0);
	test ("6÷3", "2", 0);
	test ("1÷2", "0.5", 0);
	test ("−6÷3", "−2", 0);
	test ("6÷−3", "−2", 0);
	test ("−6÷−3", "2", 0);
	test ("(−3)÷(−6)", "0.5", 0);
	test ("2÷2", "1", 0);
	test ("1203÷1", "1203", 0);
	test ("−0÷32352.689", "0", 0);
	test ("1÷4", "0.25", 0);
	test ("1÷3", "0.333333333", 0);
	test ("2÷3", "0.666666667", 0);
	test ("1÷0", "", ERROR_CODE_MP);
	test ("0÷0", "", ERROR_CODE_MP);
	test ("1÷sin(0)", "", ERROR_CODE_MP);
	test ("1000000000000000−1000000000000000", "0", 0);
	test ("1000000000000000÷1000000000000000", "1", 0);
	test ("1000000000000000×0.000000000000001", "1", 0);
	test ("1−0.9−0.1", "0", 0);
	test ("1+2×3", "7", 0);
	test ("1+(2×3)", "7", 0);
	test ("(1+2)×3", "9", 0);
	test ("(1+2×3)", "7", 0);
	test ("2(1+1)", "4", 0);
	test ("(2)1+1", "3", 0);
	test ("(2)(1)", "2", 0);
	test ("4÷2(1+1)", "4", 0);
	test ("100%", "1", 0);
	test ("1%", "0.01", 0);
	test ("100+1%", "101", 0);
	test ("100−1%", "99", 0);
	test ("100×1%", "1", 0);
	test ("100÷1%", "10000", 0);
	test ("0!", "1", 0);
	test ("1!", "1", 0);
	test ("5!", "120", 0);
	test ("69!", "1711224524281413113724683388812728390922705448935203693936480409232572" \
"79754140647424000000000000000", 0);
	test ("−1!", "−1", 0);
	test ("(−1)!", "", ERROR_CODE_MP);
	test ("−(1!)", "−1", 0);
	test ("3.5!", "11.631728397", 0);
	test ("(-2)!", "", ERROR_CODE_MP);
	test ("(-10.9)!", "", ERROR_CODE_MP);
	test ("(-10.0)!", "", ERROR_CODE_MP);
	test ("2²", "4", 0);
	test ("2³", "8", 0);
	test ("2¹⁰", "1024", 0);
	test ("(1+2)²", "9", 0);
	test ("(x)²", "4", 0);
	test ("|1−3|²", "4", 0);
	test ("|x|²", "4", 0);
	test ("0^0", "0", ERROR_CODE_MP);
	test ("0^0.5", "0", 0);
	test ("2^0", "1", 0);
	test ("2^1", "2", 0);
	test ("2^2", "4", 0);
	test ("2⁻¹", "0.5", 0);
	test ("2⁻", "", ERROR_CODE_MP);
	test ("2^−1", "0.5", 0);
	test ("2^(−1)", "0.5", 0);
	test ("x⁻¹", "0.5", 0);
	test ("−10^2", "−100", 0);
	test ("(−10)^2", "100", 0);
	test ("−(10^2)", "−100", 0);
	test ("2^100", "1267650600228229401496703205376", 0);
	test ("4^3^2", "262144", 0);
	test ("4^(3^2)", "262144", 0);
	test ("(4^3)^2", "4096", 0);
	test ("√4", "2", 0);
	test ("√4−2", "0", 0);
	test ("∛8", "2", 0);
	test ("∜16", "2", 0);
	test ("₃√8", "2", 0);
	test ("₁₀√1024", "2", 0);
	test ("√(2+2)", "2", 0);
	test ("2√4", "4", 0);
	test ("2×√4", "4", 0);
	test ("Sqrt (4)", "2", 0);
	test ("Sqrt (2)", "1.414213562", 0);
	test ("Sqrt (-1)", "i", 0);
	test ("4^0.5", "2", 0);
	test ("2^0.5", "1.414213562", 0);
	test ("₃√−8", "−2", 0);
	test ("(−8)^(1÷3)", "−2", 0);
	test ("e^(−0.5)", "0.60653066", 0);
	test ("0 mod 7", "0", 0);
	test ("6 mod 7", "6", 0);
	test ("7 mod 7", "0", 0);
	test ("8 mod 7", "1", 0);
	test ("−1 mod 7", "6", 0);
	test ("21 mod 9", "3", 0);
	test ("21 mod -9", "−6", 0);
	test ("-21 mod 9", "6", 0);
	test ("-21 mod -9", "−3", 0);
	test ("sgn 0", "0", 0);
	test ("sgn 3", "1", 0);
	test ("sgn −3", "−1", 0);
	test ("⌊3⌋", "3", 0);
	test ("⌈3⌉", "3", 0);
	test ("[3]", "3", 0);
	test ("⌊−3⌋", "−3", 0);
	test ("⌈−3⌉", "−3", 0);
	test ("[−3]", "−3", 0);
	test ("⌊3.2⌋", "3", 0);
	test ("⌈3.2⌉", "4", 0);
	test ("[3.2]", "3", 0);
	test ("⌊−3.2⌋", "−4", 0);
	test ("⌈−3.2⌉", "−3", 0);
	test ("[−3.2]", "−3", 0);
	test ("⌊3.5⌋", "3", 0);
	test ("⌈3.5⌉", "4", 0);
	test ("[3.5]", "4", 0);
	test ("⌊−3.5⌋", "−4", 0);
	test ("⌈−3.5⌉", "−3", 0);
	test ("[−3.5]", "−4", 0);
	test ("⌊3.7⌋", "3", 0);
	test ("⌈3.7⌉", "4", 0);
	test ("[3.7]", "4", 0);
	test ("⌊−3.7⌋", "−4", 0);
	test ("⌈−3.7⌉", "−3", 0);
	test ("[−3.7]", "−4", 0);
	test ("{3.2}", "0.2", 0);
	test ("{−3.2}", "0.8", 0);
	test ("|1|", "1", 0);
	test ("|−1|", "1", 0);
	test ("|3−5|", "2", 0);
	test ("|x|", "2", 0);
	test ("abs 1", "1", 0);
	test ("abs (−1)", "1", 0);
	test ("log 0", "", ERROR_CODE_MP);
	test ("log 1", "0", 0);
	test ("log 2", "0.301029996", 0);
	test ("log 10", "1", 0);
	test ("log₁₀ 10", "1", 0);
	test ("log₂ 2", "1", 0);
	test ("2 log 2", "0.602059991", 0);
	test ("ln 0", "", ERROR_CODE_MP);
	test ("ln 1", "0", 0);
	test ("ln 2", "0.693147181", 0);
	test ("ln e", "1", 0);
	test ("2 ln 2", "1.386294361", 0);
	angle_units = ANGLE_UNIT_DEGREES;
	test ("sin 0", "0", 0);
	test ("sin 45 − 1÷√2", "0", 0);
	test ("sin 20 + sin(−20)", "0", 0);
	test ("sin 90", "1", 0);
	test ("sin 180", "0", 0);
	test ("2 sin 90", "2", 0);
	test ("sin²45", "0.5", 0);
	test ("cos 0", "1", 0);
	test ("cos 45 − 1÷√2", "0", 0);
	test ("cos 20 − cos (−20)", "0", 0);
	test ("cos 90", "0", 0);
	test ("cos 180", "−1", 0);
	test ("2 cos 0", "2", 0);
	test ("cos²45", "0.5", 0);
	test ("tan 0", "0", 0);
	test ("tan 10 − sin 10÷cos 10", "0", 0);
	test ("tan 90", "", ERROR_CODE_MP);
	test ("tan 10", "0.176326981", 0);
	test ("tan²10", "0.031091204", 0);
	test ("cos⁻¹ 0", "90", 0);
	test ("cos⁻¹ 1", "0", 0);
	test ("cos⁻¹ (−1)", "180", 0);
	test ("cos⁻¹ (1÷√2)", "45", 0);
	test ("acos 0", "90", 0);
	test ("acos 1", "0", 0);
	test ("sin⁻¹ 0", "0", 0);
	test ("sin⁻¹ 1", "90", 0);
	test ("sin⁻¹ (−1)", "−90", 0);
	test ("sin⁻¹ (1÷√2)", "45", 0);
	test ("asin 0", "0", 0);
	test ("asin 1", "90", 0);
	test ("cosh 0", "1", 0);
	test ("cosh 10 − (e^10 + e^−10)÷2", "0", 0);
	test ("sinh 0", "0", 0);
	test ("sinh 10 − (e^10 − e^−10)÷2", "0", 0);
	test ("sinh (−10) + sinh 10", "0", 0);
	test ("cosh² (−5) − sinh² (−5)", "1", 0);
	test ("tanh 0", "0", 0);
	test ("tanh 10 − sinh 10 ÷ cosh 10", "0", 0);
	test ("atanh 0", "0", 0);
	test ("atanh (1÷10) − 0.5 ln(11÷9)", "0", 0);
	angle_units = ANGLE_UNIT_DEGREES;
	test ("sin 90", "1", 0);
	angle_units = ANGLE_UNIT_RADIANS;
	test ("sin (π÷2)", "1", 0);
	angle_units = ANGLE_UNIT_GRADIANS;
	test ("sin 100", "1", 0);
	angle_units = ANGLE_UNIT_DEGREES;
	test ("i", "i", 0);
	test ("−i", "−i", 0);
	test ("2i", "2i", 0);
	test ("1+i", "1+i", 0);
	test ("i+1", "1+i", 0);
	test ("1−i", "1−i", 0);
	test ("i−1", "−1+i", 0);
	test ("i×i", "−1", 0);
	test ("i÷i", "1", 0);
	test ("1÷i", "−i", 0);
	test ("i^2", "−1", 0);
	test ("(−1)^(1/2)", "i", 0);
	test ("|i|", "1", 0);
	test ("|3+4i|", "5", 0);
	test ("arg 0", "", ERROR_CODE_MP);
	test ("arg 1", "0", 0);
	test ("arg (1+i)", "45", 0);
	test ("arg i", "90", 0);
	test ("arg (−1+i)", "135", 0);
	test ("arg −1", "180", 0);
	test ("arg (1+−i)", "−45", 0);
	test ("arg −i", "−90", 0);
	test ("arg (−1−i)", "−135", 0);
	test ("i⁻¹", "−i", 0);
	test ("√−1", "i", 0);
	test ("(−1)^0.5", "i", 0);
	test ("√−4", "2i", 0);
	test ("e^iπ", "−1", 0);
	test ("log (−10) − (1 + πi÷ln(10))", "0", 0);
	test ("ln (−e) − (1 + πi)", "0", 0);
	test ("sin(iπ÷4) − i×sinh(π÷4)", "0", 0);
	test ("cos(iπ÷4) − cosh(π÷4)", "0", 0);
	test ("0 and 0", "0", 0);
	test ("1 and 0", "0", 0);
	test ("0 and 1", "0", 0);
	test ("1 and 1", "1", 0);
	test ("3 and 5", "1", 0);
	test ("0 or 0", "0", 0);
	test ("1 or 0", "1", 0);
	test ("0 or 1", "1", 0);
	test ("1 or 1", "1", 0);
	test ("3 or 5", "7", 0);
	test ("0 xor 0", "0", 0);
	test ("1 xor 0", "1", 0);
	test ("0 xor 1", "1", 0);
	test ("1 xor 1", "0", 0);
	test ("3 xor 5", "6", 0);
	number_base = 16;
	test ("ones 1", "FFFFFFFE", 0);
	test ("ones 7FFFFFFF", "80000000", 0);
	test ("twos 1", "FFFFFFFF", 0);
	test ("twos 7FFFFFFF", "80000001", 0);
	test ("~7A₁₆", "FFFFFF85", 0);
	number_base = 2;
	wordlen = 4;
	test ("1100∧1010", "1000", 0);
	test ("1100∨1010", "1110", 0);
	test ("1100⊻1010", "110", 0);
	test ("1100⊕1010", "110", 0);
}


void test_base_conversion (void) {
	number_base = 10;
	wordlen = 32;
	angle_units = ANGLE_UNIT_DEGREES;
	enable_conversions = TRUE;
	enable_variables = TRUE;
	test ("10 in bin", "1010₂", 0);
	test ("10 in oct", "12₈", 0);
	test ("10 in dec", "10", 0);
	test ("10 in hex", "A₁₆", 0);
	test ("10 in binary", "1010₂", 0);
	test ("10 in octal", "12₈", 0);
	test ("10 in decimal", "10", 0);
	test ("10 in hexadecimal", "A₁₆", 0);
	test ("1010₂ in dec", "10", 0);
	test ("12₈ in dec", "10", 0);
	test ("10 in dec", "10", 0);
	test ("A₁₆ in dec", "10", 0);
	test ("x in bin", "10₂", 0);
	test ("x in oct", "2₈", 0);
	test ("x in dec", "2", 0);
	test ("x in hex", "2₁₆", 0);
}


void test_precedence (void) {
	number_base = 10;
	wordlen = 32;
	angle_units = ANGLE_UNIT_DEGREES;
	enable_conversions = TRUE;
	enable_variables = TRUE;
	test ("1 + 2 - 3 * 4 / 5", "0.6", 0);
	test ("10 mod 4 / 2", "1", 0);
	test ("20 / 10 mod 3", "2", 0);
	test ("12 / 3 √4", "8", 0);
	test ("√5!", "10.95445115", 0);
	test ("4 ^ sin 30", "2", 0);
	test ("4 ^ (sin 30)", "2", 0);
	test ("4 ^ sin (30)", "2", 0);
	test ("sin (30) ^ 4", "0.0625", 0);
	test ("sin 30 ^ 4", "0.0625", 0);
	test ("sin (30 ^ 4)", "0", 0);
	test ("10 / - 2", "−5", 0);
	test ("10 * - 2", "−20", 0);
	test ("10 ^ -2", "0.01", 0);
	test ("-10 ^ 2", "−100", 0);
	test ("sin (-30)", "−0.5", 0);
	test ("sin - 30", "−0.5", 0);
	test ("6 + 3!", "12", 0);
	test ("4 * 3!", "24", 0);
	test ("100 mod 3!", "4", 0);
	test ("5! mod 7", "1", 0);
	test ("24 / 3!", "4", 0);
	test ("4! / 6", "4", 0);
	test ("cos 5!", "−0.5", 0);
	test ("sin 6!", "0", 0);
	test ("- 4!", "−24", 0);
	test ("3! ^ 3", "216", 0);
	test ("3 ^ 3!", "729", 0);
	test ("(−√3)^2", "3", 0);
}


void test_custom_functions (void) {
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp0_;
	number_base = 10;
	wordlen = 32;
	angle_units = ANGLE_UNIT_DEGREES;
	enable_conversions = FALSE;
	enable_variables = TRUE;
	_tmp0_ = function_manager_get_default_function_manager ();
	function_manager = _tmp0_;
	test ("func(x;y;z)=x+y+z", "0", 0);
	test ("func(2;3;5)", "10", 0);
	test ("func(x;y;z)=x+y-z", "0", 0);
	test ("func(2;3;5)", "0", 0);
	test ("func(x;y;z)=abs(x-y)+abs(y-z)+abs(x-z)", "0", 0);
	test ("func(1;2;3)", "4", 0);
	test ("func(x;y;z)", "0", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("test(x;y)=func(x;y;x)+func(y;x;y)", "0", 0);
	test ("6*test(3;5)+log10", "49", 0);
	test ("test(test(5;6);9)", "20", 0);
	test ("log(test(8;9))", "0.602059991", 0);
	test ("sum(8)", "0", ERROR_CODE_UNKNOWN_FUNCTION);
	test ("sum", "0", ERROR_CODE_UNKNOWN_VARIABLE);
	test ("sum(x;y)=x+y", "0", 0);
	test ("(3+2)*10 + 5^2 - sum(7;8)", "60", 0);
	test ("dummy(abc;xyz;pqr)=abc*xyz*pqr", "0", 0);
	test ("dummy(1;0;1)", "0", 0);
	test ("dummy(4;5;6)", "120", 0);
	test ("dummy(dummy(1;2;3);dummy(1;2;3);dummy(1;2;3))", "216", 0);
	test ("dummy(10;5.687;100)", "5687", 0);
	test ("dummy(10;5.687;1)", "56.87", 0);
	test ("diff(x,y)=x-y", "0", ERROR_CODE_INVALID);
	test ("abcd(x;y;z) = (floor((x+y+z)/z)+frac((x+y+z)/z))*z", "0", 0);
	test ("abcd(4;5;6)", "15", 0);
	test ("abcd(2.9;91;9.1)", "103", 0);
	test ("log(dummy(1;5;2))", "1", 0);
	test ("sum(sum(sum(1;1);sum(1;1));sum(sum(1;1);sum(1;1)))", "8", 0);
	function_manager_delete (function_manager, "sum");
	test ("sum(sum(sum(1;1);sum(1;1));sum(sum(1;1);sum(1;1)))", "8", ERROR_CODE_UNKNOWN_FUNCTION);
	test ("sum(x;y)=x+y+1", "0", 0);
	test ("sum(sum(sum(1;1);sum(1;1));sum(sum(1;1);sum(1;1)))", "15", 0);
	function_manager_delete (function_manager, "func");
	function_manager_delete (function_manager, "test");
	function_manager_delete (function_manager, "sum");
	function_manager_delete (function_manager, "dummy");
	function_manager_delete (function_manager, "abcd");
	_g_object_unref0 (function_manager);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp7_;
	setlocale (LC_ALL, "C");
	test_conversions ();
	test_equations ();
	test_base_conversion ();
	test_precedence ();
	test_custom_functions ();
	_tmp0_ = fail_count;
	if (_tmp0_ == 0) {
		FILE* _tmp1_;
		gint _tmp2_;
		_tmp1_ = stdout;
		_tmp2_ = pass_count;
		fprintf (_tmp1_, "Passed all %i tests\n", _tmp2_);
	} else {
		FILE* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = stdout;
		_tmp4_ = fail_count;
		_tmp5_ = pass_count;
		_tmp6_ = fail_count;
		fprintf (_tmp3_, "Failed %i/%d tests\n", _tmp4_, _tmp5_ + _tmp6_);
	}
	_tmp7_ = fail_count;
	result = _tmp7_;
	return result;
}


int main (int argc, char ** argv) {
	return _vala_main (argv, argc);
}



