/* valaerrordomain.c generated by valac, the Vala compiler
 * generated from valaerrordomain.vala, do not modify */

/* valaerrordomain.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_ERROR_DOMAIN_DUMMY_PROPERTY,
	VALA_ERROR_DOMAIN_LAST_PROPERTY
};
static GParamSpec* vala_error_domain_properties[VALA_ERROR_DOMAIN_LAST_PROPERTY];
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaErrorDomainPrivate {
	ValaList* codes;
	ValaList* methods;
};


static gpointer vala_error_domain_parent_class = NULL;

#define VALA_ERROR_DOMAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainPrivate))
static void vala_error_domain_real_add_method (ValaSymbol* base, ValaMethod* m);
static void vala_error_domain_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_error_domain_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_error_domain_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_error_domain_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_error_domain_finalize (ValaCodeNode * obj);


/**
 * Creates a new error domain.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @return                 newly created error domain
 */
ValaErrorDomain* vala_error_domain_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaErrorDomain* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaErrorDomain*) vala_typesymbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


ValaErrorDomain* vala_error_domain_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_error_domain_construct (VALA_TYPE_ERROR_DOMAIN, name, source_reference, comment);
}


/**
 * Appends the specified code to the list of error codes.
 *
 * @param ecode an error code
 */
void vala_error_domain_add_code (ValaErrorDomain* self, ValaErrorCode* ecode) {
	ValaList* _tmp0_;
	ValaErrorCode* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaErrorCode* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaErrorCode* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ecode != NULL);
	_tmp0_ = self->priv->codes;
	_tmp1_ = ecode;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = ecode;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = ecode;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified method as a member to this error domain.
 *
 * @param m a method
 */
static void vala_error_domain_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaErrorDomain * self;
	ValaMethod* _tmp0_;
	ValaMethod* _tmp5_;
	ValaMemberBinding _tmp6_;
	ValaMemberBinding _tmp7_;
	ValaList* _tmp24_;
	ValaMethod* _tmp25_;
	ValaScope* _tmp26_;
	ValaScope* _tmp27_;
	ValaMethod* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	ValaMethod* _tmp31_;
	self = (ValaErrorDomain*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaMethod* _tmp4_;
		_tmp1_ = m;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1_);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "construction methods may only be declared within classes and structs");
		_tmp4_ = m;
		vala_code_node_set_error ((ValaCodeNode*) _tmp4_, TRUE);
		return;
	}
	_tmp5_ = m;
	_tmp6_ = vala_method_get_binding (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaMethod* _tmp8_;
		ValaErrorType* _tmp9_;
		ValaErrorType* _tmp10_;
		ValaParameter* _tmp11_;
		ValaParameter* _tmp12_;
		ValaMethod* _tmp13_;
		ValaScope* _tmp14_;
		ValaScope* _tmp15_;
		ValaMethod* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaMethod* _tmp21_;
		ValaParameter* _tmp22_;
		ValaParameter* _tmp23_;
		_tmp8_ = m;
		_tmp9_ = vala_error_type_new (self, NULL, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_parameter_new ("this", (ValaDataType*) _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		vala_method_set_this_parameter (_tmp8_, _tmp12_);
		_vala_code_node_unref0 (_tmp12_);
		_vala_code_node_unref0 (_tmp10_);
		_tmp13_ = m;
		_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = m;
		_tmp17_ = vala_method_get_this_parameter (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = m;
		_tmp22_ = vala_method_get_this_parameter (_tmp21_);
		_tmp23_ = _tmp22_;
		vala_scope_add (_tmp15_, _tmp20_, (ValaSymbol*) _tmp23_);
	}
	_tmp24_ = self->priv->methods;
	_tmp25_ = m;
	vala_collection_add ((ValaCollection*) _tmp24_, _tmp25_);
	_tmp26_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp27_ = _tmp26_;
	_tmp28_ = m;
	_tmp29_ = vala_symbol_get_name ((ValaSymbol*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = m;
	vala_scope_add (_tmp27_, _tmp30_, (ValaSymbol*) _tmp31_);
}


/**
 * Returns a copy of the list of error codes.
 *
 * @return list of error codes
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_error_domain_get_codes (ValaErrorDomain* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->codes;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
ValaList* vala_error_domain_get_methods (ValaErrorDomain* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void vala_error_domain_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaErrorDomain * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaErrorDomain*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_error_domain (_tmp0_, self);
}


static void vala_error_domain_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaErrorDomain * self;
	self = (ValaErrorDomain*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _ecode_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ecode_index = 0;
		_tmp0_ = self->priv->codes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_ecode_list = _tmp1_;
		_tmp2_ = _ecode_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ecode_size = _tmp4_;
		_ecode_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaErrorCode* _tmp11_;
			ValaCodeVisitor* _tmp12_;
			_tmp5_ = _ecode_index;
			_ecode_index = _tmp5_ + 1;
			_tmp6_ = _ecode_index;
			_tmp7_ = _ecode_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _ecode_list;
			_tmp9_ = _ecode_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			ecode = (ValaErrorCode*) _tmp10_;
			_tmp11_ = ecode;
			_tmp12_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _m_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _m_index = 0;
		_tmp13_ = self->priv->methods;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_m_list = _tmp14_;
		_tmp15_ = _m_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_m_size = _tmp17_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			ValaMethod* m = NULL;
			ValaList* _tmp21_;
			gint _tmp22_;
			gpointer _tmp23_;
			ValaMethod* _tmp24_;
			ValaCodeVisitor* _tmp25_;
			_tmp18_ = _m_index;
			_m_index = _tmp18_ + 1;
			_tmp19_ = _m_index;
			_tmp20_ = _m_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _m_list;
			_tmp22_ = _m_index;
			_tmp23_ = vala_list_get (_tmp21_, _tmp22_);
			m = (ValaMethod*) _tmp23_;
			_tmp24_ = m;
			_tmp25_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp24_, _tmp25_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
}


static gboolean vala_error_domain_real_is_reference_type (ValaTypeSymbol* base) {
	ValaErrorDomain * self;
	gboolean result = FALSE;
	self = (ValaErrorDomain*) base;
	result = FALSE;
	return result;
}


static gboolean vala_error_domain_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaErrorDomain * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	self = (ValaErrorDomain*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _ecode_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _ecode_index = 0;
		_tmp4_ = self->priv->codes;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_ecode_list = _tmp5_;
		_tmp6_ = _ecode_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_ecode_size = _tmp8_;
		_ecode_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaErrorCode* _tmp15_;
			ValaCodeContext* _tmp16_;
			_tmp9_ = _ecode_index;
			_ecode_index = _tmp9_ + 1;
			_tmp10_ = _ecode_index;
			_tmp11_ = _ecode_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _ecode_list;
			_tmp13_ = _ecode_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			ecode = (ValaErrorCode*) _tmp14_;
			_tmp15_ = ecode;
			_tmp16_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, _tmp16_);
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _m_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _m_index = 0;
		_tmp17_ = self->priv->methods;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_m_list = _tmp18_;
		_tmp19_ = _m_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_m_size = _tmp21_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			ValaMethod* m = NULL;
			ValaList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			ValaMethod* _tmp28_;
			ValaCodeContext* _tmp29_;
			_tmp22_ = _m_index;
			_m_index = _tmp22_ + 1;
			_tmp23_ = _m_index;
			_tmp24_ = _m_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _m_list;
			_tmp26_ = _m_index;
			_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
			m = (ValaMethod*) _tmp27_;
			_tmp28_ = m;
			_tmp29_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp28_, _tmp29_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	_tmp30_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp31_ = _tmp30_;
	result = !_tmp31_;
	return result;
}


static void vala_error_domain_class_init (ValaErrorDomainClass * klass) {
	vala_error_domain_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_error_domain_finalize;
	g_type_class_add_private (klass, sizeof (ValaErrorDomainPrivate));
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol *, ValaMethod*)) vala_error_domain_real_add_method;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_error_domain_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_error_domain_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol *)) vala_error_domain_real_is_reference_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_error_domain_real_check;
}


static void vala_error_domain_instance_init (ValaErrorDomain * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_ERROR_DOMAIN_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_ERROR_CODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->codes = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->methods = (ValaList*) _tmp3_;
}


static void vala_error_domain_finalize (ValaCodeNode * obj) {
	ValaErrorDomain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain);
	_vala_iterable_unref0 (self->priv->codes);
	_vala_iterable_unref0 (self->priv->methods);
	VALA_CODE_NODE_CLASS (vala_error_domain_parent_class)->finalize (obj);
}


/**
 * Represents an error domain declaration in the source code.
 */
GType vala_error_domain_get_type (void) {
	static volatile gsize vala_error_domain_type_id__volatile = 0;
	if (g_once_init_enter (&vala_error_domain_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaErrorDomainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_error_domain_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaErrorDomain), 0, (GInstanceInitFunc) vala_error_domain_instance_init, NULL };
		GType vala_error_domain_type_id;
		vala_error_domain_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaErrorDomain", &g_define_type_info, 0);
		g_once_init_leave (&vala_error_domain_type_id__volatile, vala_error_domain_type_id);
	}
	return vala_error_domain_type_id__volatile;
}



