// Generated by gmmproc 2.53.2 -- DO NOT MODIFY!
#ifndef _GDKMM_SCREEN_H
#define _GDKMM_SCREEN_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gdkmm/rectangle.h>
#include <glibmm/object.h>
#include <cairomm/fontoptions.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkScreen = struct _GdkScreen;
using GdkScreenClass = struct _GdkScreenClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class Screen_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{

class Display;
class Visual;
class Window;

/** Object representing a physical screen
 * Gdk::Screen objects are the GDK representation of a physical screen. It is used throughout GDK and GTK+ to specify
 * which screen the top level windows are to be displayed on. It is also used to query the screen specification and
 * default settings such as the screen width (get_width()), etc.
 * Note that a screen may consist of multiple monitors which are merged to form a large screen area.
 */

class Screen : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Screen;
  using CppClassType = Screen_Class;
  using BaseObjectType = GdkScreen;
  using BaseClassType = GdkScreenClass;

  // noncopyable
  Screen(const Screen&) = delete;
  Screen& operator=(const Screen&) = delete;

private:  friend class Screen_Class;
  static CppClassType screen_class_;

protected:
  explicit Screen(const Glib::ConstructParams& construct_params);
  explicit Screen(GdkScreen* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Screen(Screen&& src) noexcept;
  Screen& operator=(Screen&& src) noexcept;

  ~Screen() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkScreen*       gobj()       { return reinterpret_cast<GdkScreen*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkScreen* gobj() const { return reinterpret_cast<GdkScreen*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkScreen* gobj_copy();

private:

protected:

public:
  
  /** Gets the root window of @a screen.
   * 
   * @newin{2,2}
   * 
   * @return The root window.
   */
  Glib::RefPtr<Window> get_root_window();
  
  /** Gets the root window of @a screen.
   * 
   * @newin{2,2}
   * 
   * @return The root window.
   */
  Glib::RefPtr<const Window> get_root_window() const;

  
  /** Gets the display to which the @a screen belongs.
   * 
   * @newin{2,2}
   * 
   * @return The display to which @a screen belongs.
   */
  Glib::RefPtr<Display> get_display();
  
  /** Gets the display to which the @a screen belongs.
   * 
   * @newin{2,2}
   * 
   * @return The display to which @a screen belongs.
   */
  Glib::RefPtr<const Display> get_display() const;

 
  /** Obtains a list of all toplevel windows known to GDK on the screen @a screen.
   * A toplevel window is a child of the root window (see
   * gdk_get_default_root_window()).
   * @newin{2,2}
   * 
   * @return List of toplevel windows.
   */
  std::vector< Glib::RefPtr<Window> > get_toplevel_windows();

  
  /** Gets the default screen for the default display. (See
   * Gdk::Display::get_default()).
   * 
   * @newin{2,2}
   * 
   * @return A Gdk::Screen, or <tt>nullptr</tt> if
   * there is no default display.
   */
  static Glib::RefPtr<Screen> get_default();

  template <class ValueType>
  bool get_setting(const Glib::ustring& name, ValueType& value) const;
  

  /** Sets the resolution for font handling on the screen. This is a
   * scale factor between points specified in a Pango::FontDescription
   * and cairo units. The default value is 96, meaning that a 10 point
   * font will be 13 units high. (10 * 96. / 72. = 13.3).
   * 
   * @newin{2,10}
   * 
   * @param dpi The resolution in “dots per inch”. (Physical inches aren’t actually
   * involved; the terminology is conventional.).
   */
  void set_resolution(double dpi);
  
  /** Gets the resolution for font handling on the screen; see
   * set_resolution() for full details.
   * 
   * @newin{2,10}
   * 
   * @return The current resolution, or -1 if no resolution
   * has been set.
   */
  double get_resolution() const;

  //We use no_default_handler because GdkDisplayManagerClass is private.

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%monitors_changed()</tt>
   *
   * The signal_monitors_changed() signal is emitted when the number, size
   * or position of the monitors attached to the screen change. 
   * 
   * Only for X11 and OS X for now. A future implementation for Win32
   * may be a possibility.
   * 
   * @newin{2,14}
   */

  Glib::SignalProxy<void()> signal_monitors_changed();


  /** The resolution for fonts on the screen.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_resolution() ;

/** The resolution for fonts on the screen.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_resolution() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

template <class ValueType>
bool Screen::get_setting(const Glib::ustring& name, ValueType& value) const
{
  Glib::Value<ValueType> glibmmvalue;
  glibmmvalue.init(Glib::Value<ValueType>::value_type());

  gboolean result = gdk_screen_get_setting(const_cast<GdkScreen*>(gobj()), name.c_str(), glibmmvalue.gobj());

  value = glibmmvalue.get();
  return result;
}

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Screen
   */
  Glib::RefPtr<Gdk::Screen> wrap(GdkScreen* object, bool take_copy = false);
}


#endif /* _GDKMM_SCREEN_H */

